<?php
/**
 * This file contains the default template for the eWeather module.
 *
 * This file is part of the eWeather Module.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * converted to Joomla! 1.5.x by Bob Lavey
 * 02/26/2010: Bob Lavey - converted to MVC and updated to work with 1.4.0 MVC component
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeather Module
 * @subpackage eWeather Module
 * @copyright Copyright (C) 2000 - 2005 Miro International Pty Ltd,
 *            2006 Harald Baer<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE .DS.'modules'.DS.'mod_eweather'.DS.'helpers'.DS.'defines.php' );


echo '<!-- begin eWeather Module Version '.MOD_EWEATHER_VERSION.' '.MOD_EWEATHER_VERSION_DATE.' -->';

?>

<div class="eweather" >
<table>
	<tr>
		<td colspan="2" align="center" >
			<div align="center">
				<strong><?php echo $this->data->twcContent->loc_city; ?></strong>
			</div>
		</td>
	</tr>
	<tr>
		<td>
			<div align="center">
				<img src="<?php echo $this->data->imageUrls['currentConditionsSmall']; ?>" alt="<?php echo $this->data->twcContent->cc_text; ?>" border="0" />
			</div>
		</td>
		<td valign="top">
			<table>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: left;">
						<strong><?php echo JText::_('COM_EWEATHER_TEMP').':'; ?></strong>
					</td>
					<td style="margin: 0px; padding: 0px; text-align: right;">
<?php
					if (is_numeric($this->data->twcContent->cc_temp))
					{

						echo $this->data->twcContent->cc_temp.'&deg;'.$this->data->twcContent->h_temp;
					}
					else
					{
						echo $this->data->twcContent->cc_temp;
					}
?>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: left;">
						<strong><?php echo JText::_('COM_EWEATHER_FEELSLIKE').':'; ?></strong>
					</td>
					<td style="margin: 0px; padding: 0px; text-align: right;">
<?php
					if (is_numeric($this->data->twcContent->cc_windchill))
					{
						echo $this->data->twcContent->cc_windchill.'&deg;'.$this->data->twcContent->h_temp;
					}
					else
					{
						echo $this->data->twcContent->cc_windchill;
					}
?>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: left;">
						<strong><?php echo JText::_('COM_EWEATHER_HUMIDITY').':'; ?></strong>
					</td>
					<td style="margin: 0px; padding: 0px; text-align: right;">
<?php
					if (is_numeric($this->data->twcContent->cc_humidity))
					{
						echo $this->data->twcContent->cc_humidity.'%';
					}
					else
					{
						echo $this->data->twcContent->cc_humidity;
					}
?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table>
	<tr>
		<td valign="top">
			<table>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: left;">
						<strong><?php echo JText::_('COM_EWEATHER_WINDSPEED').':'; ?></strong>
					</td>
					<td style="margin: 0px; padding: 0px; text-align: right;">
<?php
					if (is_numeric($this->data->twcContent->cc_windspeed))
					{
						echo $this->data->twcContent->cc_windspeed.'&nbsp;'.$this->data->twcContent->h_speed;
					}
					else
					{
						echo $this->data->twcContent->cc_windspeed;
					}
?>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: left;">
						<strong><?php echo JText::_('COM_EWEATHER_WINDDIR').':'; ?></strong>
					</td>
					<td style="margin: 0px; padding: 0px; text-align: right;">
<?php
					if (is_numeric($this->data->twcContent->cc_winddirection))
					{
						echo $this->data->twcContent->cc_winddirection.'&deg;';
					}
					else
					{
						echo $this->data->twcContent->cc_winddirection;
					}
?>
					</td>
				</tr>
				<tr>
					<td style="margin: 0px; padding: 0px; text-align: left;">
						<strong><?php echo JText::_('COM_EWEATHER_PRESSURE').':'; ?></strong>
					</td>
					<td style="margin: 0px; padding: 0px; text-align: right;">
<?php
					if (is_numeric($this->data->twcContent->cc_barpressure))
					{
						echo $this->data->twcContent->cc_barpressure."&nbsp;".$this->data->twcContent->h_pressure;
					}
					else
					{
						echo $this->data->twcContent->cc_barpressure;
					}
?>
					</td>
				</tr>
			</table>
		</td>
		<td>
			<div align="center">
				<img src="<?php echo $this->data->imageUrls['windDirSmall']; ?>" alt="" border="0" />
			</div>
			<div align="center">
				<strong><?php echo $this->data->twcContent->cc_windtext; ?></strong>
			</div>
		</td>
	</tr>
	<tr>
		<td colspan="2" text-align: center; padding-top: 8px; float: none;" align="center">
			<a class="button<?php echo $this->moduleClassSuffix; ?>" style="float: none;" href="<?php echo $this->data->weatherUrl ?>">
				<?php echo JText::_('MOD_EWEATHER_SHOW_DETAILS'); ?>
			</a>
		</td>
	</tr>
<?php
	if ('1' == $this->allowUserProfiles)
	{
?>
	<tr>
		<td colspan="2" style="border-bottom: 1px solid #CCCCCC; text-align: center; padding-top: 8px; float: none;" align="center">
			<a class="button<?php echo $this->moduleClassSuffix; ?>" style="float: none;" href="<?php echo $this->data->profileUrl; ?>">
				<?php echo JText::_('MOD_EWEATHER_SELECT_LOCATION'); ?>
			</a>
		</td>
	</tr>
<?php
	}
?>
	<tr>
		<td colspan="2">
			<table>
				<tr>
					<td align="right" style="font-size: 70%; padding-top: 15px;">
						<div align="left">
							<?php echo JText::_('COM_EWEATHER_PROVIDER').':'; ?>
							<br/>
							<a href="http://www.weather.com" target="blank">
								<img src="<?php echo $this->data->imageUrls['weatherChannelLogoSmall']; ?>" border="0" alt="www.weather.com" />
							</a>
						</div>
					</td>
					<td align="right" style="font-size: 80%; padding-left: 5px; padding-top: 15px; text-align: right;" >
<?php
		    		$numLinks = count($this->data->twcContent->partnerLinks);
    				for ($x = 0; $x < $numLinks; $x++)
    				{
	    			$url = JROUTE::_(str_replace('&','&amp;',$this->data->twcContent->partnerLinks[$x]->url));
	    			$text = str_replace('&','&amp;',$this->data->twcContent->partnerLinks[$x]->text)
?>
						<a target="_blank" href="<?php echo $url ?>" title="<?php echo $text ?>" >
							<?php echo $text ?>
						</a>
						<br/>
<?php
					}
?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
<?php
echo '<!-- end eWeather Module Version '.MOD_EWEATHER_VERSION.' '.MOD_EWEATHER_VERSION_DATE.' -->';
?>
