<?php
/**
 * This file contains helper routines for the administrator
 *  screens for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * aangepast door Mart Dirks<br/>
 * converted to Joomla! 1.5.x by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright Copyright (c) 2000 - 2006 MamboBaer.de (Harald Baer),
 * 			  2007 Mart Dirks,<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

$cmd = JRequest::getCmd('task', 'cpanel_show');

if (strpos($cmd, '_') != false)
{
	// We have a defined controller/task pair -- lets split them out
	list($controllerName, $task) = explode('_', $cmd);
	
	// Define the controller name and path
	$controllerName	= strtolower($controllerName);
	$controllerPath	= COM_EWEATHER_ADMIN_CONTROLLERS_PATH.DS.$controllerName.'.php';
	
	// If the controller file path exists, include it ... else lets die with a 500 error
	if (file_exists($controllerPath))
	{
		require_once($controllerPath);
	}
	else
	{
		JError::raiseError(500, 'Invalid Controller - '.$controllerPath);
	}
}
else
{
	// Base controller, just set the task 
	require_once(COM_EWEATHER_ADMIN_CONTROLLERS_PATH.DS."default.php");
	$controllerName = null;
	$task = $cmd;
}

// Set the name for the controller and instantiate it
$controllerClass = 'eWeatherController'.ucfirst($controllerName);
if (class_exists($controllerClass))
{
	$controller = new $controllerClass();
}
else
{
	JError::raiseError(500, 'Invalid Controller Class - '.$controllerClass );
}

 
// Perform the Request task and redirect
$controller->execute( $task );
$controller->redirect();
