<?php
/**
 * This file contains the controller for the Config page
 *  of the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// import Joomla controllerform library
jimport('joomla.application.component.controllerform');
 
// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );


class eWeatherControllerConfig extends JControllerForm
{
	protected $_model = null;
	
	function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask( 'show',  'display' );
		$this->registerTask( 'apply',  'apply' );
		
		$this->_model = $this->getModel('Config');
	}

	function display()
	{
        // set default view if not set
        JRequest::setVar('view', JRequest::getCmd('view', 'config'));
		
		parent::display();
	}
	
	function save()
	{
		$data = JRequest::getVar('jform', array(), 'post', 'array');
		$this->_model->save($data);
		
		$msg = JText::_('COM_EWEATHER_ADMIN_CONFIG_CHANGES_SAVED');

		$this->setRedirect('index.php?option=com_eweather&task=cpanel_show', $msg);
	}
	
	function apply()
	{
		$data = JRequest::getVar('jform', array(), 'post', 'array');
		$this->_model->save($data);
		
		$msg = JText::_('COM_EWEATHER_ADMIN_CONFIG_CHANGES_SAVED');
		
		$this->setRedirect('index.php?option=com_eweather&task=config_show', $msg);
	}
	
	function reset()
	{
		$this->_model->reset();
		
		$msg = JText::_('COM_EWEATHER_ADMIN_CONFIG_RESET');
		
		$this->setRedirect('index.php?option=com_eweather&task=config_show', $msg);
	}
	
	function cancel()
	{
		$this->setRedirect('index.php?option=com_eweather&task=cpanel_show');
	}
}
