<?php
/**
 * This file contains various global definitions
 *  for the back-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

if ( !defined('COM_EWEATHER_ADMIN_VERSION') )
{
	define( 'COM_EWEATHER_ADMIN_VERSION', '1.5.0.8' );  // must be w.x.y.z or update script will fail
	define( 'COM_EWEATHER_ADMIN_VERSION_DATE', 'October 2011' );
	
	define( 'COM_EWEATHER_ADMIN_PATH', JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_eweather' );
	define( 'COM_EWEATHER_ADMIN_CONTROLLERS_PATH', COM_EWEATHER_ADMIN_PATH.DS.'controllers' );
	define( 'COM_EWEATHER_ADMIN_CLASSES_PATH', COM_EWEATHER_ADMIN_PATH.DS.'classes' );
	define( 'COM_EWEATHER_ADMIN_HELPERS_PATH', COM_EWEATHER_ADMIN_PATH.DS.'helpers' );
	define( 'COM_EWEATHER_ADMIN_LOCATIONS_PATH', COM_EWEATHER_ADMIN_PATH.DS.'locations' );
	define( 'COM_EWEATHER_ADMIN_MODELS_PATH', COM_EWEATHER_ADMIN_PATH.DS.'models' );
	define( 'COM_EWEATHER_ADMIN_FORMS_PATH', COM_EWEATHER_ADMIN_PATH.DS.'forms' );
	define( 'COM_EWEATHER_ADMIN_FIELDS_PATH', COM_EWEATHER_ADMIN_MODELS_PATH.DS.'fields' );
	define( 'COM_EWEATHER_ADMIN_TABLES_PATH', COM_EWEATHER_ADMIN_PATH.DS.'tables' );
	define( 'COM_EWEATHER_ADMIN_VIEWS_PATH', COM_EWEATHER_ADMIN_PATH.DS.'views' );
	
	define( 'COM_EWEATHER_ADMIN_URL', 'administrator/components/com_eweather' );
	define( 'COM_EWEATHER_ADMIN_CSS_URL', COM_EWEATHER_ADMIN_URL.'/assets/css/' );
	define( 'COM_EWEATHER_ADMIN_FORMS_URL', COM_EWEATHER_ADMIN_URL.'/models/forms/' );
	define( 'COM_EWEATHER_ADMIN_VIEWS_URL', COM_EWEATHER_ADMIN_URL.'/views/' );
	
	define( 'COM_EWEATHER_ADMIN_IMAGES_PATH', JPATH_SITE .DS.'components'.DS.'com_eweather'.DS.'assets'.DS.'images');
}
