<?php
/**
 * This file contains the model for the allLocations view
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// import the Joomla modellist and form libraries
jimport('joomla.application.component.modellist');
jimport('joomla.form.form');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );
JLoader::register('eWeatherConfiguration', COM_EWEATHER_ADMIN_CLASSES_PATH.DS.'eweatherconfiguration.php' );


class eWeatherModelAllLocations extends JModelList
{
	protected $_totalLocations = null;
	protected $_where = null;
	protected $_eWeatherConfig = null;
	protected $_forms = array();
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		$this->_eWeatherConfig = new eWeatherConfiguration();
	}

    /**
     * Method to build an SQL query to load the list data.
     *
     * @return      string  An SQL query
     */
    protected function getListQuery()
    {
       	// create a new query object.         
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		
       	// select the fields
       	$query->select('id,region,country,city,loc_id,published');
        
       	// from the eweather_locations table
       	$query->from('#__eweather_locations');

       	// set the where conditions
		$where = $this->_buildQueryWhere();
		if (strlen($where))
		{
			$query->where($where);
		}
			
       	// set the order conditions
		$query->order('region,country,city');
		
		return $query;
	}

	function setPublishedState($publish)
	{
        // create a new query object.         
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		
        // update the eweather_locations table
        $query->update('#__eweather_locations');

        // set the where conditions
        $where = $this->_buildQueryWhere();
        if (strlen($where))
        {
        	$query->where($where);
        }
        
        // set the fields to be updated
		$query->set('published = '.$publish);

		// run the query
		$db->setQuery($query);
		$db->query();
	}

	function getTotalLocations()
	{
		if (!$this->_totalLocations)
		{
			$this->_totalLocations = $this->_getListCount("SELECT id FROM #__eweather_locations");
		}
		return $this->_totalLocations;
	}

	function getPublishedLocations()
	{
		return $this->_getListCount("SELECT id FROM #__eweather_locations WHERE `published` = '1'");;
	}

	function getLocationsInCurrentView()
	{
		return $this->getTotal();
	}

	function getDefaultLocation()
	{
		
    	$defaultLocationId = $this->_eWeatherConfig->getDefaultLocationId();
		$row = null;

		if (isset($defaultLocationId) && !empty($defaultLocationId))
		{
       		// create a new query object.         
			$db = JFactory::getDBO();
			$query = $db->getQuery(true);
		
       		// select the fields
       		$query->select('region,country,city,loc_id,published');
        
       		// from the eweather_locations table
       		$query->from('#__eweather_locations');

       		// set the where conditions
			$query->where('loc_id = "'.$defaultLocationId.'"');
			
			// run the query; there should be 0 or 1 result
			$list = $this->_getList((string) $query);
			if (count($list) <> 0)
			{
				$row = $list[0];
			}
		}

		return $row;
	}

	function setDefaultLocation($region, $country, $city, $locId)
	{
		$this->_eWeatherConfig->setDefaultLocation($region, $country, $city, $locId);
	}

	function verifyDefaultLocation()
	{
		$row = $this->getDefaultLocation();
		if (!isset($row) || ('0' == $row->published))
		{
			$this->setDefaultLocation('', '', '', '');
		}
	}

	/**
	 * Method to get the total number of items for the data set.
	 * Overriding base class function.
	 *
	 * @return	integer	The total number of items available in the data set.
	 * @since	1.6
	 */
	public function getTotal()
	{
		// Get a storage key.
		$store = $this->getStoreId('getTotal');

		// Try to load the data from internal storage.
		if (!empty($this->cache[$store])) {
			return $this->cache[$store];
		}

		// create a simple query
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		
		// select only the id field from the eweather_locations table
		$query->select('id');
		$query->from('#__eweather_locations');
		
		// set the where conditions
		$where = $this->_buildQueryWhere();
		if (strlen($where))
		{
			$query->where($where);
		}
		
		// Load the total.
		$total = (int) $this->_getListCount((string) $query);

		// Check for a database error.
		if ($this->_db->getErrorNum()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Add the total to the internal cache.
		$this->cache[$store] = $total;

		return $this->cache[$store];
	}

	function _buildQueryWhere()
	{
		if(!$this->_where)
		{
			// get the published, region, country, and search filter values
			$app = JFactory::getApplication();
			$filterPublished = $app->getUserState('com_eweather.admin.alllocations.filterPublished');
			$filterRegion = $app->getUserState('com_eweather.admin.alllocations.filterRegion');
			$filterCountry = $app->getUserState('com_eweather.admin.alllocations.filterCountry');
			$search = $app->getUserState('com_eweather.admin.alllocations.filterSearch');
			
			// prepare to build WHERE clause as an array
			$this->_where = array();
			$db = JFactory::getDBO();

			// check if we are performing a free text search
			if (strlen($search))
			{
				// make string safe for searching
				$search = '%' . $db->getEscaped($search, true). '%';
				$search = $db->Quote($search, false);
				$regionField = $db->nameQuote('region');
				$countryField = $db->nameQuote('country');
				$cityField = $db->nameQuote('city');

				// add search to $_where array
				$this->_where[] = "(LOWER($regionField) LIKE $search OR LOWER($countryField) LIKE $search OR LOWER($cityField) LIKE $search)";
			}

			// check if we are filtering based on published state
			if ($filterPublished == JText::_('JPUBLISHED'))
			{
				$this->_where[] = $db->nameQuote('published') . ' = 1';
			}
			else if ($filterPublished == JText::_('JUNPUBLISHED'))
			{
				$this->_where[] = $db->nameQuote('published') . ' = 0';
			}

			// check if we are filtering based on region
			if (($filterRegion != JText::_('COM_EWEATHER_ADMIN_SELECT_REGION')) && ($filterRegion != ''))
			{
				$this->_where[] = $db->nameQuote('region') . ' = ' . $db->Quote($filterRegion, true);
			}

			// check if we are filtering based on country
			if (($filterCountry != JText::_('COM_EWEATHER_ADMIN_SELECT_COUNTRY')) && ($filterCountry != ''))
			{
				$this->_where[] = $db->nameQuote('country') . ' = ' . $db->Quote($filterCountry, true);
			}

			if (count($this->_where))
			{
				// building from array
				$this->_where = implode(' AND ', $this->_where);
			}
			else
			{
				$this->_where = '';
			}
		}

		return $this->_where;
	}
	
    /**
     * Method to get the record form.
     *
     * @param       array   $data           Data for the form.
     * @param       boolean $loadData       True if the form is to load its own data (default case), false if not.
     * @return      mixed   A JForm object on success, false on failure
     * @since       1.6
     */
    public function getForm($data = array(), $loadData = true) 
    {
        // Get the form.
        $form = $this->loadForm('com_eweather.admin', 'alllocations', array('control' => 'jform', 'load_data' => $loadData));
		
        if (empty($form)) 
        {
            return false;
        }

        return $form;
    }

	/**
	 * Method to get a form object.
	 * Copied from libraries\joomla\application\component\modelform.php
	 * @param	string		$name		The name of the form.
	 * @param	string		$source		The form source. Can be XML string if file flag is set to false.
	 * @param	array		$options	Optional array of options for the form creation.
	 * @param	boolean		$clear		Optional argument to force load a new form.
	 * @param	string		$xpath		An optional xpath to search for the fields.
	 * @return	mixed		JForm object on success, False on error.
	 */
	protected function loadForm($name, $source = null, $options = array(), $clear = false, $xpath = false)
	{
		// Handle the optional arguments.
		$options['control']	= JArrayHelper::getValue($options, 'control', false);

		// Create a signature hash.
		$hash = md5($source.serialize($options));

		// Check if we can use a previously loaded form.
		if (isset($this->_forms[$hash]) && !$clear) {
			return $this->_forms[$hash];
		}

		// Get the form.
		JForm::addFormPath(JPATH_COMPONENT.'/models/forms');
		JForm::addFieldPath(JPATH_COMPONENT.'/models/fields');

		try {
			$form = JForm::getInstance($name, $source, $options, false, $xpath);

			if (isset($options['load_data']) && $options['load_data']) {
				// Get the data for the form.
				$data = $this->loadFormData();
			} else {
				$data = array();
			}

			// Allow for additional modification of the form, and events to be triggered.
			// We pass the data because plugins may require it.
			//$this->preprocessForm($form, $data);

			// Load the data into the form after the plugins have operated.
			$form->bind($data);

		} catch (Exception $e) {
			$this->setError($e->getMessage());
			return false;
		}

		// Store the form for later.
		$this->_forms[$hash] = $form;

		return $form;
	}

    /**
     * Method to get the data that should be injected in the form.
     *
     * @return      mixed   The data for the form.
     * @since       1.6
     */
    protected function loadFormData() 
    {
		$app = JFactory::getApplication();
    	
		// Check for previously entered form data.
        $data = JRequest::getVar( 'jform', array(), 'post' );

        if (empty($data)) 
        {
        	// try to find previous data
			$published = $app->getUserState('com_eweather.admin.alllocations.filterPublished');
			$region = $app->getUserState('com_eweather.admin.alllocations.filterRegion');
			$country = $app->getUserState('com_eweather.admin.alllocations.filterCountry');
			$search = $app->getUserState('com_eweather.admin.alllocations.filterSearch');

			// use default values, if no previous data was found
			$data['published'] = isset($published) ? $published : JText::_('JALL');
			$data['region'] = isset($region) ? $region : JText::_('COM_EWEATHER_ADMIN_SELECT_REGION');
			$data['country'] = isset($country) ? $country : JText::_('COM_EWEATHER_ADMIN_SELECT_COUNTRY');
			$data['search'] = isset($search) ?  JString::strtolower($search) : "";
        }
        
		// save the published, region, country, and search filter values
		$app->setUserState('com_eweather.admin.alllocations.filterPublished', $data['published']);
		$app->setUserState('com_eweather.admin.alllocations.filterRegion', $data['region']);
		$app->setUserState('com_eweather.admin.alllocations.filterCountry', $data['country']);
		$app->setUserState('com_eweather.admin.alllocations.filterSearch', $data['search']);

        return $data;
    }
    
	public function clearFilters()
	{
		$app = JFactory::getApplication();
    	
		$app->setUserState('com_eweather.admin.alllocations.filterPublished', null);
		$app->setUserState('com_eweather.admin.alllocations.filterRegion', null);
		$app->setUserState('com_eweather.admin.alllocations.filterCountry', null);
		$app->setUserState('com_eweather.admin.alllocations.filterSearch', null);
	}
}
