<?php
/**
 * This file contains the model for the config view
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// import the Joomla modeladmin library
jimport( 'joomla.application.component.modeladmin' );
jimport( 'joomla.registry.registry' );

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('eWeatherConfiguration', COM_EWEATHER_ADMIN_CLASSES_PATH.DS.'eweatherconfiguration.php' );

class eWeatherModelConfig extends JModelAdmin
{
	protected $_eWeatherConfig = null;
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		$this->_eWeatherConfig = new eWeatherConfiguration();
	}

    /**
     * Method to get the record form.
     *
     * @param       array   $data           Data for the form.
     * @param       boolean $loadData       True if the form is to load its own data (default case), false if not.
     * @return      mixed   A JForm object on success, false on failure
     * @since       1.6
     */
    public function getForm($data = array(), $loadData = true) 
    {
        // Get the form.
        $form = $this->loadForm('com_eweather.admin', 'config', array('control' => 'jform', 'load_data' => $loadData));
		
        if (empty($form)) 
        {
            return false;
        }

        return $form;
    }

	/**
	 * Method to get the script that have to be included on the form
     *
     * @return string       Script files
     */
	public function getScript() 
	{
		return COM_EWEATHER_ADMIN_FORMS_URL.'config.js';
	}
	
    /**
     * Method to get the data that should be injected in the form.
     *
     * @return      mixed   The data for the form.
     * @since       1.6
     */
    protected function loadFormData() 
    {
		// Check for previously entered form data.
        $data = JRequest::getVar( 'jform', array(), 'post' );
		
        if (empty($data)) 
        {
            $data = $this->getItem();
        }
        
		return $data;
    }
    
    /**
     * Method to reset the data to defaults
     */
    function reset()
    {
		$defaults = array();
		
		// create a form but provide no data, and we'll
		//  get back the default values in the form
    	$form = $this->getForm(null, false);
		
		foreach($form->getFieldset('eWeatherLocation') as $field)
		{
			$defaults[$field->fieldname] = $field->value;
		}
		foreach($form->getFieldset('eWeather') as $field)
		{
			$defaults[$field->fieldname] = $field->value;
		}
		
		$this->save($defaults);
    }
    
    /**
     * Method to save the given data to the extensions table
	 * @param data an array of name=>value pairs
     */
    function save($data)
    {
    	$this->_eWeatherConfig->set($data);
    }
    
    function getItem()
    {
		return $this->_eWeatherConfig->get();
    }
}
