<?php
/**
 * This file contains the eWeatherLocationId field definition
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('hidden');

/**
 * eWeatherIconList Form Field class for the eWeather component
 */
class JFormFieldEWeatherLocationId extends JFormFieldHidden
{
	public function __construct($form = null)
	{
		parent::__construct($form);
		$this->type = 'EWeatherLocationId';
	}
	
	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// get the locationId and call the base class's getInput()
		$this->value = $this->getLocationId();
		
		return parent::getInput();
	}

	protected function getLocationId()
	{
    	$app = JFactory::getApplication();
    	
    	// set our current value to a user state, so
    	//  it can be used by the eWeatherLocation
	   	$city = $app->getUserState('com_eweather.admin.filterCity');
    	
    	// get the current value of the region filter
    	$region = $app->getUserState('com_eweather.admin.filterRegion');
    	
    	// get the current value of the country filter
    	$country = $app->getUserState('com_eweather.admin.filterCountry');
    	
		// get the location id using the selected region, country, and city
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
    	$query->select('loc_id');
    	$query->from('#__eweather_locations');
    	$query->where("region='".$region."'");
    	$query->where("country='".$country."'");
		$query->where("city='".$city."'");
		$db->setQuery($query);
		$locationId = $db->loadObject();
		
		if (isset($locationId))
		{
			return $locationId->loc_id;
		}
		else
		{
			return null;
		}
	}
}
