<?php
/**
 * This file contains the eWeatherMenuTypeList field definition
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

// import the eWeatherList field type
JLoader::register('JFormFieldEWeatherList', COM_EWEATHER_ADMIN_FIELDS_PATH.DS.'eweatherlist.php' );


/**
 * eWeatherMenuTypeList Form Field class for the eWeather component
 */
class JFormFieldEWeatherMenuTypeList extends JFormFieldEWeatherList
{
	public function __construct($form = null)
	{
		parent::__construct($form);
		$this->type = 'EWeatherMenuTypeList';
	}
	
	/**
	 * Method to get the field options.
	 *
	 * @return	array	The field option objects.
	 * @since	1.6
	 */
	protected function getOptions() 
    {
    	// create a list of all menu types
    	return $this->getMenuTypes();
	}
    
	protected function getMenuTypes()
	{
		// no selection (default)
		$menuTypeOptions[] = JHTML::_('select.option', '', JText::_('COM_EWEATHER_ADMIN_SELECT_MENUTYPE'));

    	// create a list of all menu types
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
    	$query->select('menutype');
    	$query->from('#__menu_types');
		$query->order('menutype');
		$db->setQuery($query);
		$menuTypes = $db->loadObjectList();

		if (count($menuTypes) <> 0)
		{
			foreach ($menuTypes as $menuType)
			{
				$menuTypeOptions[] = JHTML::_('select.option', $menuType->menutype, JText::_($menuType->menutype), 'value', 'text' );
			}
		}
		
		return $menuTypeOptions;
	}
}
