<?php
/**
 * This file contains the eWeatherPublishedList field definition
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

// import the eWeatherList field type
JLoader::register('JFormFieldEWeatherList', COM_EWEATHER_ADMIN_FIELDS_PATH.DS.'eweatherlist.php' );


/**
 * eWeatherPublishedList Form Field class for the eWeather component
 */
class JFormFieldEWeatherPublishedList extends JFormFieldEWeatherList
{
	public function __construct($form = null)
	{
		parent::__construct($form);
		$this->type = 'EWeatherPublishedList';
	}
	
	/**
	 * Method to get the field options.
	 *
	 * @return	array	The field option objects.
	 * @since	1.6
	 */
	protected function getOptions() 
    {
		return $this->getPublishedLocations(false);
    }
    
	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// add an onclick option and call the base class's getInput()
		$this->element['onchange'] = 'submitform();';
		return parent::getInput();
	}

	function getPublishedLocations($addDefaultOption)
	{
		// no selection (default)
		if ($addDefaultOption)
		{
			$publishedOptions[] = JHTML::_('select.option', JText::_('JALL'), JText::_('JALL'));
		}

		// create a list of possible options
		$publishedOptions[] = JHTML::_('select.option', JText::_('JPUBLISHED'), JText::_('JPUBLISHED'));
		$publishedOptions[] = JHTML::_('select.option', JText::_('JUNPUBLISHED'), JText::_('JUNPUBLISHED'));

		return $publishedOptions;
	}
}
