<?php
/**
 * This file contains the default template for
 *  the allLocations view of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>

<form action="index.php" method="post" name="adminForm" id="adminForm">
<table>
	<tr>
		<td width="50%">
			<?php echo JText::_('JSEARCH_FILTER').': '; ?>
			<?php echo $this->fieldset['jform_search']->input; ?>
			<button id="goButton" onclick="document.adminForm.submit();">
				<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>
			</button>
			<button id="resetButton" onclick="document.getElementById('jform_search').value='';
					document.getElementById('jform_published').value='<?php echo JText::_('JALL'); ?>';
					document.getElementById('jform_region').value='';
					document.getElementById('jform_country').value='';
					document.adminForm.submit();">
				<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>
			</button>
		</td>
		<td width="50%">
		  <table>
		    <tr>
			  <td>
				<?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_TOTAL_LOCATIONS').': '; ?>
			  </td>
			  <td align="right" id="totalLocations" >
				<?php echo $this->totalLocations; ?>
			  </td>
			</tr>
		    <tr>
			  <td>
				<?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_LOCATION_PUBLISHED_LOCATIONS').': '; ?>
			  </td>
			  <td align="right" id="publishedLocations" >
				<?php echo $this->publishedLocations; ?>
			  </td>
			</tr>
		    <tr>
			  <td>
				<?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_CURRENT_VIEW_LOCATIONS').': '; ?>
			  </td>
			  <td align="right" id="locationsInCurrentView" >
				<?php echo $this->locationsInCurrentView; ?>
			  </td>
			</tr>
		    <tr>
			  <td>
				<?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_DEFAULT_LOCATION').': '; ?>
			  </td>
			  <td align="right" id="defaultLocation" >
				<?php
				if (isset($this->defaultLocation))
				{
					echo JText::_($this->defaultLocation->region) . '<br/>';
					echo JText::_($this->defaultLocation->country) . '<br/>';
					echo JText::_($this->defaultLocation->city) . '<br/>';
				}
				else
				{
					echo 'none selected';
				}
				?>
			  </td>
			</tr>
		  </table>
		</td>
		<td nowrap="nowrap">
			<?php echo $this->fieldset['jform_published']->input; ?>
		</td>
		<td nowrap="nowrap">
			<?php echo $this->fieldset['jform_region']->input; ?>
		</td>
		<td nowrap="nowrap">
			<?php echo $this->fieldset['jform_country']->input; ?>
			<?php echo $this->fieldset['jform_city']->input; ?>
		</td>
	</tr>
</table>

<table class="adminlist">
	<thead>
		<tr>
			<th width="20">
				<input type="checkbox"
				       name="toggle"
				       value=""
				       onclick="checkAll(<?php echo count( $this->rows ); ?>);" />
			</th>
			<th width="5%"><?php echo JText::_( 'COM_EWEATHER_ADMIN_LOCATION_DEFAULT_HEADING' ); ?></th>
			<th width="25%"><?php echo JText::_( 'COM_EWEATHER_ADMIN_LOCATION_REGION_HEADING' ); ?></th>
			<th width="25%"><?php echo JText::_( 'COM_EWEATHER_ADMIN_LOCATION_COUNTRY_HEADING' ); ?></th>
			<th width="30%"><?php echo JText::_( 'COM_EWEATHER_ADMIN_LOCATION_CITY_HEADING' ); ?></th>
			<th width="10%"><?php echo JText::_( 'COM_EWEATHER_ADMIN_LOCATION_LOCATION_ID_HEADING' ); ?></th>
			<th width="5%" nowrap="nowrap"><?php echo JText::_( 'COM_EWEATHER_ADMIN_LOCATION_PUBLISHED_HEADING' ); ?></th>
		</tr>
	</thead>
<?php
	$k = 0;
	for ($i=0, $n=count( $this->rows ); $i < $n; $i++)
	{
		$row = $this->rows[$i];
		$checked = JHTML::_('grid.id', $i, $row->id );
		$published = JHTML::_('grid.published', $row, $i,'tick.png','publish_x.png','location_' );
?>
	<tr class="<?php echo "row$k"; ?>">
		<td><?php echo $checked; ?></td>
		<td align="center" id="defaultLocation<?php echo $i; ?>" >
<?php
			if (isset($this->defaultLocation) && ($this->defaultLocation->loc_id == $row->loc_id))
			{
?>
			<img src="../media/com_eweather/images/menu/icon-16-default.png" alt="*" />
<?php
			}
?>
		</td>
		<td id="region<?php echo $i; ?>" ><?php echo JText::_($row->region); ?></td>
		<td id="country<?php echo $i; ?>" ><?php echo JText::_($row->country); ?></td>
		<td id="city<?php echo $i; ?>" ><?php echo JText::_($row->city); ?></td>
		<td id="loc_id<?php echo $i; ?>" ><?php echo $row->loc_id; ?></td>
		<td align="center" ><?php echo $published; ?></td>
	</tr>
	<?php
	$k = 1 - $k;
	}
	?>

	<tfoot>
		<tr>
			<td colspan="6">
				<?php echo $this->pagination->getListFooter(); ?>
			</td>
		</tr>
	</tfoot>

</table>
<input type="hidden" name="option" value="com_eweather" />
<input type="hidden" name="task" value="location_show" />
<input type="hidden" name="boxchecked" value="0" />
</form>
