<?php
/**
 * This file contains the Configuration Manager view definition
 *  for the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
?>

<form action="index.php" method="post" name="adminForm" id="adminForm" class="form-validate" >
    <div>
        <fieldset class="adminform">
			<table border="0" cellspacing="0" cellpadding="0" class="adminlist">
				<tr>
					<th align="left"><?php echo JText::_('COM_EWEATHER_ADMIN_CONFIG_PARAM_HEADING'); ?></th>
					<th align="left"><?php echo JText::_('COM_EWEATHER_ADMIN_CONFIG_VALUE_HEADING'); ?></th>
					<th align="left"><?php echo JText::_('COM_EWEATHER_ADMIN_CONFIG_DESCRIPTION_HEADING'); ?></th>
				</tr>
				<tr>
					<td id="locationHdg" ><?php echo JText::_('COM_EWEATHER_ADMIN_CONFIG_DEFAULT_LOCATION'); ?></td>
					<td>
<?php foreach($this->form->getFieldset('eWeatherLocation') as $field): ?>
						<?php if (!$field->hidden) echo '<p>'; ?>
						<?php echo $field->input; ?>
						<?php if (!$field->hidden) echo '</p><br/>'; ?>
<?php endforeach; ?>
					</td>
					<td><?php JText::_('COM_EWEATHER_ADMIN_CONFIG_DEFAULT_LOCATION_D'); ?></td>
				</tr>
<?php foreach($this->form->getFieldset('eWeather') as $field): ?>
				<tr>
					<td><?php echo $field->label; ?></td>
					<td><?php echo $field->input; ?></td>
					<td><?php echo JText::_($field->description); ?></td>
				</tr>
<?php endforeach; ?>
            </table>
        </fieldset>
    </div>
 
    <div>
    	<input type="hidden" name="option" value="com_eweather" />
	    <input type="hidden" name="task" value="config_show" />
        <?php echo JHtml::_('form.token'); ?>
    </div>
</form>
