<?php
/**
 * This file contains the Control Panel view definition
 *  for the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport( 'joomla.application.component.view');
jimport( 'joomla.html.toolbar.button.popup' );


class eWeatherViewCpanel extends JView
{
	function display($tpl = null)
	{
    	JHTML::stylesheet( 'eweather.admin.css', COM_EWEATHER_ADMIN_CSS_URL );

    	// set the page title
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_EWEATHER_ADMIN_TITLE') . ' :: ' .JText::_('COM_EWEATHER_ADMIN_CPANEL_TITLE'));
		
		// Set toolbar items for the page
		JToolBarHelper::title( JText::_('COM_EWEATHER_ADMIN_TITLE') .' :: '. JText::_( 'COM_EWEATHER_ADMIN_HEADER' ), 'eweather_logo' );
		//JToolBarHelper::help( 'cpanel', true);			

		parent::display($tpl);
	}
	
	/**
	 * This method creates a standard cpanel button
	 *
	 * @param string $link
	 * @param string $image
	 * @param string $text
	 * @param string $path
	 * @param string $target
	 * @param string $onclick
	 * @access protected
	 */
	 function _quickiconButton( $id, $link, $image, $text, $path=null, $target='', $onclick='' ) {
	 	if( $target != '' ) {
	 		$target = 'target="' .$target. '"';
	 	}
	 	if( $onclick != '' ) {
	 		$onclick = 'onclick="' .$onclick. '"';
	 	}
	 	if( $path === null || $path === '' ) {
	 		$path = 'components/com_eweather/assets/images/toolbar/';
	 	}
		?>
		<div style="float:left;">
			<div class="icon">
				<a id="<?php echo $id; ?>" href="<?php echo $link; ?>" <?php echo $target;?>  <?php echo $onclick;?>>
					<?php echo JHTML::_('image.administrator', $image, $path, NULL, NULL, $text ); ?>
					<span><?php echo $text; ?></span>
				</a>
			</div>
		</div>
		<?php
	 }
}
