<?php
/**
 * This file contains the Info view definition
 *  for the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport( 'joomla.application.component.view');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('JButtonEWeather', COM_EWEATHER_ADMIN_CLASSES_PATH.DS.'jbuttonweather.php' );


class eWeatherViewInfo extends JView
{
	function display($tpl = null)
	{
    	JHTML::stylesheet( 'eweather.admin.css', COM_EWEATHER_ADMIN_CSS_URL );

    	// set the page title
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_EWEATHER_ADMIN_TITLE') . ' :: ' .JText::_('COM_EWEATHER_ADMIN_INFO_TITLE'));
		
		// Set toolbar items for the page
		JToolBarHelper::title( JText::_('COM_EWEATHER_ADMIN_TITLE') . ' ' . JText::_('COM_EWEATHER_ADMIN_INFO_TITLE'), 'eweather_info' );

		// Add a close button.
		$bar = JToolBar::getInstance('toolbar');
		$bar->appendButton('eWeather', 'cancel', JText::_('JTOOLBAR_CLOSE'), 'info_close', false);
		
		// attach the data
		$this->version = COM_EWEATHER_ADMIN_VERSION_DATE.' :: Version '.COM_EWEATHER_ADMIN_VERSION;
		
		
		parent::display($tpl);
	}
}
