<?php
/**
 * This file contains the install/uninstall routines for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * aangepast door Mart Dirks<br/>
 * converted to Joomla! 1.5.x by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright Copyright (c) 2000 - 2006 MamboBaer.de (Harald Baer),
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 *
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die ('Direct Access to this location is not allowed.');


class com_eWeatherInstallerScript
{
	/**
     * method to run after an install/update/uninstall method
     *
     * @param type    the type of change (install, update or discover_install)
     * @param parent  the class calling this method
     * @return void
     */
	function preflight($type, $parent) 
    {
    	if ('update' == $type)
    	{
			$defines_file = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php';
			if (file_exists( $defines_file ))
			{
				include_once( $defines_file );
	    		$com_eweather_version = COM_EWEATHER_ADMIN_VERSION;
				
				$db = JFactory::GetDBO();
	    		$query = $db->getQuery(true);
	    		$query->select('manifest_cache');
	    		$query->from('#__extensions');
	    		$query->where('name='.$db->quote('com_eweather'));
	    		$db->setQuery($query);
	    		$component = $db->loadObject();
	
	    		if (!isset($component))
	    		{
					JError::raiseWarning(100, JText::_('COM_EWEATHER_ADMIN_UPDATE_ERROR_NO_COMPONENT'));
					return false;
	    		}
	    		
	    		// convert the JSON string to an array
		        $manifestCache = new JRegistry();
	        	$manifestCache->loadJSON($component->manifest_cache);
				$manifestCacheArray = $manifestCache->toArray();
				
				if (!array_key_exists('version', $manifestCacheArray))
				{
					JError::raiseWarning(100, JText::_('COM_EWEATHER_ADMIN_UPDATE_ERROR_NO_VERSION'));
					return false;
				}
				
				// make sure we can parse the previous version
				$prevVersion = $manifestCacheArray['version'];
				$prevVersionArray = explode('.', $prevVersion);
				if (count($prevVersionArray) <> 4)
				{
					JError::raiseWarning(100, JText::_('COM_EWEATHER_ADMIN_UPDATE_ERROR_UNKNOWN_VERSION'));
					return false;
				}
				
				// make sure the previous version is at least 1.5.0.0
				$prevVersionInt = ($prevVersionArray[0] * 1000) + ($prevVersionArray[1] * 100) + ($prevVersionArray[2] * 10) + $prevVersionArray[3];
				if ($prevVersionInt < 1500)
	    		{
					JError::raiseWarning(100, JText::_('COM_EWEATHER_ADMIN_UPDATE_ERROR_TOO_OLD_VERSION'));
					return false;
	    		}
	    		
				// make sure we can parse the current version
				$currVersionArray = explode('.', $com_eweather_version);
				if (count($currVersionArray) <> 4)
				{
					JError::raiseWarning(100, JText::_('COM_EWEATHER_ADMIN_UPDATE_ERROR_UNKNOWN_CURRENT_VERSION'));
					return false;
				}
				
	    		// make sure the previous version not newer than the current version
				$currVersionInt = ($currVersionArray[0] * 1000) + ($currVersionArray[1] * 100) + ($currVersionArray[2] * 10) + $currVersionArray[3];
				if ($prevVersionInt > $currVersionInt)
	    		{
					JError::raiseWarning(100, JText::_('COM_EWEATHER_ADMIN_UPDATE_ERROR_TOO_NEW_VERSION'));
					return false;
	    		}
			}
    		return true;
    	}
	}
    
	/**
     * method to run after an install/update/uninstall method
     *
     * @param type    the type of change (install, update or discover_install)
     * @param parent  the class calling this method
     * @return void
     */
	function postflight($type, $parent) 
    {
		if ('install' == $type)
    	{
//    		$db = JFactory::getDBO();
//
//    		// install all the location files from admin\locations
//    		$path = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'locations';
// 			if (@is_dir( $path ))
//			{
//	    		$handle = opendir( $path );
//				while ($file = readdir($handle))
//				{
//					$file_path = JPath::clean( $path.DS.$file );
//					$info = pathinfo($file);
//					if (is_file($file_path) && ($info['extension'] == "sql"))
//					{
//						echo '<p>including location file '.$file.'</p>';
//						$sql = file_get_contents( $file_path );
//						//$db->setQuery($sql);
//						//$db->query();
//						echo '<p>file length: '.strlen($sql).'</p>';
//					}
//				}
//				closedir($handle);
//			}
    	
    	}
		
		if ('update' == $type)
    	{
    		// the manifest is now in the database, so get the version/date 
    		//  from there and update the component params
    		$db = JFactory::GetDBO();
	    	$query = $db->getQuery(true);
	    	$query->select('manifest_cache');
	    	$query->from('#__extensions');
	    	$query->where('name='.$db->quote('com_eweather'));
	    	$db->setQuery($query);
	    	$component = $db->loadObject();
	
	    	if (isset($component))
	    	{
	    		// convert the JSON string to an array
		        $manifestCache = new JRegistry();
	        	$manifestCache->loadJSON($component->manifest_cache);
				$manifestCacheArray = $manifestCache->toArray();
				
				if (array_key_exists('version', $manifestCacheArray) &&
				    array_key_exists('creationDate', $manifestCacheArray))
				{
					JLoader::register('eWeatherConfiguration', COM_EWEATHER_ADMIN_CLASSES_PATH.DS.'eweatherconfiguration.php' );
				
					$eWeatherConfig = new eWeatherConfiguration();
					$data = array(
						'eWeatherVersion' => $manifestCacheArray['version'],
						'eWeatherVersionDate' => $manifestCacheArray['creationDate']);

					$eWeatherConfig->set($data);
				}
			}
    	}
					
		printConfigurationInstructions();
    }

    /**
     * method to uninstall the component
     *
     * @param parent  the class calling this method
     * @return void
     */
    function uninstall($parent) 
    {
		$db = JFactory::getDBO();
    	
    	// remove any eWeather menus
		$query = $db->getQuery(true);
		$query->delete();
		$query->from('#__menu');
		$query->where("link LIKE '%option=com_eweather%'");
		$db->setQuery($query);
		$db->query();
    }
}

function printConfigurationInstructions()
{
echo '<table width="100%" border="0">';
echo '   <tr>';
echo '     <td width="10%" valign="top">';
echo '        <img src="../media/com_eweather/images/eWeather_logo.png" alt="" />';
echo '     </td>';
echo '     <td width="90%">';
echo '        <p>';
echo '           <strong>eWeather</strong> Component <em>for Joomla! 1.6.x/1.7.x CMS </em> <br />';
echo '           &copy; 2009 - 2011 by Bob Lavey en &copy; 2007 door Mart Dirks en &copy; 2006 door Mambobaer <br/>';
echo '           All rights reserved.';
echo '           <br />';
echo '           <br />';
echo '           eWeather Component has been released under';
echo '           <a href="http://www.gnu.org/licenses/gpl.txt" target="_blank">GNU/GPL</a>.<br/>';
echo '           <strong>Note:</strong>&nbsp;This package has only been tested under Joomla! 1.6.x/1.7.x';
echo '        </p>';
echo '     </td>';
echo '   </tr>';
echo '   <tr>';
echo '     <td valign="top">';
echo '        <strong>Installation:</strong><br /><br />';
echo '     </td>';
echo '     <td>';
echo '     	<p>';
echo '			After downloading the latest version of com_eweather from';
echo '			<a href="http://www.robertjlavey.com/en/eweather-homepage/eweatherdownloads" target="_blank">';
echo '				www.robertjlavey.com/en/eweather-homepage/eweatherdownloads';
echo '			</a>';
echo '			and installing it, you will need to:';
echo '			<ol>';
echo '				<li>obtain a Partner ID and Partner Key from The Weather Channel,</li>';
echo '				<li>add locations,</li>';
echo '				<li>configure the component, and</li>';
echo '				<li>set up eWeather to be shown on your front-end</li>';
echo '			</ol>';
echo '		</p>';
echo '		<p>';
echo '			To obtain a Partner ID and Partner Key from The Weather Channel, go to';
echo '			<a href="http://www.weather.com/services/xmloap.html" target="_blank">www.weather.com/services/xmloap.html</a>,';
echo '			and you will find instructions for how to register with The Weather Channel and receive';
echo '			your Partner ID and Partner Key.';
echo '		</p>';
echo '		<p>';
echo '			To add locations, go to the eWeather Location Manager and use the';
echo '			Publish Selected, Unpublish Selected, Publish All in View, and Unpublish';
echo '			All in View buttons to add and remove locations.  You can use the Search';
echo '			box to search for specific text, and you can use the drop-downs to select';
echo '			any combination of published/unpublished regions and countries.  You can also';
echo '			select a default location from your site from the Location Manager, since';
echo '			the search/filter capabilities can make it easier to find a specific location.';
echo '		</p>';
echo '		<p>';
echo '			To configure the eWeather component, go to the eWeather Configuration Manager';
echo '			 and add your Parnter ID/Key, select the default region/country/city, and';
echo '			 select other parameters. If you have questions about any of the parameters,';
echo '			 feel free to post a question in the forum (<a href="http://www.robertjlavey.com/forum" target="_blank">';
echo '			 www.robertjlavey.com/forum</a>.';
echo '		</p>';
echo '		<p>';
echo '			To see eWeather on your front-end, you need to add eWeather to your main menu.';
echo '			You can also install and configure the eWeather module, but you still have to';
echo '			add eWeather to the main menu.';
echo '		</p>';
echo '     </td>';
echo '   </tr>';
echo '   <tr>';
echo '      <td valign="top">';
echo '         <strong>Information:</strong><br /><br />';
echo '      </td>';
echo '      <td>';
echo '         <p>';
echo '<strong>NO WARRANTY</strong><br />';
echo '  <p>';
echo '    This program is free software: you can redistribute it and/or modify';
echo '    it under the terms of the GNU General Public License as published by';
echo '    the Free Software Foundation, either version 3 of the License, or';
echo '    (at your option) any later version.';
echo '  </p>';
echo '  <p>';
echo '    This program is distributed in the hope that it will be useful,';
echo '    but WITHOUT ANY WARRANTY; without even the implied warranty of';
echo '    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the';
echo '    GNU General Public License for more details.';
echo '  </p>';
echo '  <p>';
echo '    You should have received a copy of the GNU General Public License';
echo '    along with this program.  If not, see <a href="http://www.gnu.org/licenses/" target="_blank">http://www.gnu.org/licenses/</a>.';
echo '        </p>';
echo '      </td>';
echo '   </tr>';
echo '   <tr>';
echo '      <td>&nbsp;';
echo '      </td>';
echo '      <td>';
echo '         <p>';
echo '            Thank you for using eWeather Component!';
echo '         </p>';
echo '         <p>';
echo '            <em>Bob Lavey, www.martdirks.nl, and MamboBaer.de</em>';
echo '         </p>';
echo '      </td>';
echo '   </tr>';
echo '</table>';
}
?>