<?php
/**
 * This file provides a concrete implementation for the
 *  IXmlDataProvider interface that uses cUrl to retrieve XML data.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('IXmlDataProvider', COM_EWEATHER_INTERFACES_PATH.DS.'ixmldataprovider.php' );


class CurlXmlDataProvider implements IXmlDataProvider
{
	protected $_errorCode = null;
	protected $_errorString = null;
	
	public function getXmlData($weatherUrl)
    {
    	$xmlData = null;
    	
    	try
    	{
    		$ch = curl_init();
			curl_setopt ($ch, CURLOPT_URL, $weatherUrl);
			curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5); // set to zero for no timeout
			$xmlData = curl_exec($ch);
			curl_close($ch);
    	}
		catch(Exception $exception)
		{
			$this->_errorCode = $exception->getCode();
			$this->_errorString = $exception->getMessage();
			$xmlData = null;
		}
		
		return $xmlData;

	}
    
    public function getErrorCode()
    {
    	return $this->_errorCode;
    }

    public function getErrorString()
    {
    	return $this->_errorString;
    }
}
