<?php
/**
 * This file provides a concrete implementation for the
 *  IXmlDataProvider interface that uses the PHP DomDocument
 *  class to retrieve XML data.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('IXmlDataProvider', COM_EWEATHER_INTERFACES_PATH.DS.'ixmldataprovider.php' );


class DomXmlDataProvider implements IXmlDataProvider
{
	protected $_errorCode = null;
	protected $_errorString = null;
	
    public function getXmlData($weatherUrl)
    {
    	$xmlData = null;
    	
    	try
    	{
			$xmlDoc = new DOMDocument();

			$result = $xmlDoc->load($weatherUrl);

			if (TRUE === $result)
			{
				if ($xmlDoc->documentElement->tagName == 'weather')
				{
					$xmlData = $xmlDoc->saveXML();
				}
				else
				{
					$this->_errorCode = null;
					$this->_errorString = "unexpected tag '".$xmlDoc->documentElement->tagName."' found - expected 'weather'";
				}
			}
			else
			{
					$this->_errorCode = null;
					$this->_errorString = "could not retrieve weather data from ".$weatherUrl;
			}
    	}
		catch(Exception $exception)
		{
			$this->_errorCode = $exception->getCode();
			$this->_errorString = $exception->getMessage();
			$xmlData = null;
		}
		
		return $xmlData;
    }
    
    public function getErrorCode()
    {
    	return $this->_errorCode;
    }

    public function getErrorString()
    {
    	return $this->_errorString;
    }
}
