<?php
/**
 * This file contains the profile controller for the front-end
 *  of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport('joomla.application.component.controllerform');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );
JTable::addIncludePath(COM_EWEATHER_TABLES_PATH);


class eWeatherProfileController extends JControllerForm
{
	protected $_model = null;
	
	function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask( 'show',  'display' );
		$this->registerTask( 'apply',  'apply' );
		
		$this->_model = $this->getModel('_Profile');
		
		// load the com_eweather admin language file
		$lang = JFactory::getLanguage();
		$lang->load('', JPATH_ADMINISTRATOR);
		$lang->load('com_eweather', JPATH_ADMINISTRATOR);

	}
	
	function display()
	{
		JRequest::setVar('view', '_profile');
		
		parent::display();
	}

	function save()
	{
		$data = JRequest::getVar('jform', array(), 'post', 'array');
		$data['cid'] = JRequest::getVar('cid', array());
		$msgData = $this->_model->save($data);
		
		$this->setRedirect('index.php?option=com_eweather&Itemid='.JRequest::getVar('Itemid').'&task=weather_show', $msgData['msg'], $msgData['msgType']);
	}
	
	function apply()
	{
		$data = JRequest::getVar('jform', array(), 'post', 'array');
		$data['cid'] = JRequest::getVar('cid', array());
		$msgData = $this->_model->save($data);
		
		$this->setRedirect(JRoute::_('index.php?option=com_eweather&Itemid='.JRequest::getVar('Itemid').'&task=profile_show'), $msgData['msg'], $msgData['msgType']);
	}

	function reset()
	{
		$this->_model->reset();
		
	    $this->setRedirect(JRoute::_('index.php?option=com_eweather&Itemid='.JRequest::getVar('Itemid').'&task=profile_show'), JText::_('COM_EWEATHER_PROFILE_RESET'));
	}

	function close()
	{
		$this->setRedirect(JRoute::_('index.php?option=com_eweather&Itemid='.JRequest::getVar('Itemid').'&task=weather_show'));
	}
}
