<?php
/**
 * This file contains the controller for the front-end
 *  of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport('joomla.application.component.controller');
jimport('joomla.application.component.model');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );
JTable::addIncludePath(COM_EWEATHER_TABLES_PATH);
JTable::addIncludePath(COM_EWEATHER_ADMIN_TABLES_PATH);
JModel::addIncludePath('COM_EWEATHER_MODELS_PATH');

JLoader::register('eWeatherConfiguration', COM_EWEATHER_CLASSES_PATH.DS.'eweatherconfiguration.php' );


class eWeatherController extends JController
{
	function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask( 'show',  'display' );

		// load the com_eweather admin language file
		$lang = JFactory::getLanguage();
		$lang->load("com_eweather", JPATH_ADMINISTRATOR);
		
	}
	
	function display()
	{
        // set default view if not set
        JRequest::setVar('view', JRequest::getCmd('view', 'main'));

        parent::display();
	}

	function units()
	{
		$this->_changeUserUnits('s');
	}
	
	function unitm()
	{
		$this->_changeUserUnits('m');
	}
	
	function _changeUserUnits($units)
	{
		$msg = null;
		$msgType = null;
		$locationId = null;
		
		$profileModel = JModel::getInstance('_Profile', 'eWeatherProfileModel');
		
		if ($profileModel)
		{
			$profileModel->save(array('units' => $units));
		}
		
		$this->setRedirect('index.php?option=com_eweather&task=weather_show#eWeatherUnitSelection');
	}
	
}
