<?php
/**
 * This file contains the profiles table definition
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');


class JTableEWeatherProfiles extends JTable
{
	var $userId = 0;
  	var $params = '';
		
	public function __construct(&$db)
	{
		parent::__construct( '#__eweather_profiles', 'userId', $db );
	}
	
	public function insert()
	{
		return $this->_db->insertObject($this->_tbl, $this, $this->_tbl_key);
	}
	
	public function bind($src, $ignore = array())
	{
		$srcParamsJSON = null;
		
		// If the ignore value is a string, explode it over spaces.
		if (!is_array($ignore)) {
			$ignore = explode(' ', $ignore);
		}

		// let the base class bind everything except the params
		if (array_key_exists('params', $src))
		{
			$srcParamsJSON = $src['params'];
			unset($src['params']);
		}
		
		parent::bind($src, $ignore);
		
		// bind params ourself (if not ignored)
		if (isset($srcParamsJSON) && !in_array('params', $ignore))
		{
			// convert the src JSON to an array
			$srcParamsReg = new JRegistry();
			$srcParamsReg->loadJSON($srcParamsJSON);
			$srcParamsArray = $srcParamsReg->toArray();
			
			// convert the table row's JSON to an array
			$paramsReg = new JRegistry();
			$paramsReg->loadJSON($this->params);
			$paramsArray = $paramsReg->toArray();
			
			// bind the arrays
			foreach ($srcParamsArray as $k => $v)
			{
				$paramsArray[$k] = $srcParamsArray[$k];
			}
			
			// convert it back to JSON
			$paramsReg->loadArray($paramsArray);
			$this->params = $paramsReg->toString('JSON');
		}
		
		return true;
	}
}