<?php
/**
 * This file contains the profile view definition
 *  for the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport( 'joomla.application.component.view');
jimport('joomla.html.toolbar');
jimport('joomla.html.pane');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('JButtonFrontEndToolbar', COM_EWEATHER_CLASSES_PATH.DS.'jbuttonfrontendtoolbar.php' );
JLoader::register('eWeatherConfiguration', COM_EWEATHER_CLASSES_PATH.DS.'eweatherconfiguration.php' );
JLoader::register('eWeatherMenuParams', COM_EWEATHER_CLASSES_PATH.DS.'eweathermenuparams.php' );

require_once( COM_EWEATHER_ADMIN_HELPERS_PATH.DS.'view.helpers.php' );


class eWeatherProfileView_Profile extends JView
{
	protected $_cfg = null;
	protected $_menuParams = null;
	protected $_units = null;
	
	function __construct($config = array())
	{
		parent::__construct($config);
	}
	
	function display($tpl = null)
	{
		$this->_cfg = new eWeatherConfiguration();
		$this->_menuParams = new eWeatherMenuParams($this->_cfg);

		$this->_setupToolbar();
		$this->_setupMenuParams();
		
        // get the Data
        $form = $this->get('form');
		$locData = $this->get('locationData');
		$locRows = $this->get('locationRows');
		$pagination = $this->get('pagination');
        
        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            JError::raiseError(500, implode('<br />', $errors));
            return false;
        }

        // Assign the Data
        $this->form = $form;
        $this->locData = $locData;
        $this->locRows = $locRows;
        $this->pagination = $pagination;
        
		parent::display($tpl);

        // Setup the document
        $this->_setupDocument();
	}
	
	protected function _setupToolbar()
	{
		$bar = new JToolBar( 'WeatherProfileToolbar' );
		$bar->loadButtonType('FrontEndToolbar');
		$bar->appendButton( 'FrontEndToolbar', 'save', JText::_('JTOOLBAR_SAVE'), 'profile_save', false );
		$bar->appendButton( 'FrontEndToolbar', 'apply', JText::_('JTOOLBAR_APPLY'), 'profile_apply', false );
		$bar->appendButton( 'FrontEndToolbar', 'restore', JText::_('COM_EWEATHER_ADMIN_CONFIG_RESET_BUTTON'), 'profile_reset', false );
		$bar->appendButton( 'FrontEndToolbar', 'cancel', JText::_('JTOOLBAR_CLOSE'), 'profile_close', false );

		$this->toolbar = $bar;
	}

	protected function _setupMenuParams()
	{
		$this->itemId = null;
		$this->pageClassSuffix = null;
		$this->showPageHeading = false;
		$this->pageHeading = null;

		if (isset($this->_menuParams->pageclass_sfx))
		{
			$this->itemId = $this->_menuParams->menuId;
			$this->pageClassSuffix = $this->_menuParams->pageclass_sfx;
			$this->showPageHeading = $this->_menuParams->show_page_heading;
			$this->pageHeading = $this->_menuParams->page_heading;
		}
	}

    /**
     * Method to set up the document properties
     *
     * @return void
     */
    protected function _setupDocument() 
    {
		// add our stylesheets
    	JHTML::stylesheet( 'eweather.css', COM_EWEATHER_CSS_URL );
    	JHTML::stylesheet( 'eweather.images.'.$this->_cfg->iconStyle.'.css', COM_EWEATHER_CSS_URL );
    }
	
}
