<?php
/**
 * This file contains the current conditions template for the main view
 *  in the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

?>

<table>
	<tr>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td class="sectiontableheader<?php echo $this->data->pageClassSuffix; ?>" valign="middle" >
			<?php echo JText::_('COM_EWEATHER_ACTUAL').'&nbsp;-&nbsp;'.$this->data->twcContent->loc_city; ?>
			<br/>
			<?php echo JText::_('COM_EWEATHER_LASTUPDATED').'&nbsp;-&nbsp;'.$this->data->formattedCurrentConditionsLastUpdate; ?>
		</td>
	</tr>
	<tr>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td>
			<table>
				<tr>
					<td class="CurrentConditionsBlockHeader<?php echo $this->data->pageClassSuffix; ?>" width="33%" >
						<?php echo $this->data->twcContent->loc_city; ?>
					</td>
					<td>&nbsp;</td>
					<td class="CurrentConditionsBlockHeader<?php echo $this->data->pageClassSuffix; ?>" width="33%" >
						<?php echo JText::_('COM_EWEATHER_WIND'); ?>
					</td>
					<td>&nbsp;</td>
					<td class="CurrentConditionsBlockHeader<?php echo $this->data->pageClassSuffix; ?>" width="33%" >
						<?php echo JText::_('COM_EWEATHER_LOC_DATA'); ?>
					</td>
				</tr>
				<tr>
					<td valign="top" style="border: 1px solid #CCCCCC;" >
						<table>
							<tr>
								<td>
									<div align="center">
										<img src="<?php echo $this->data->imageUrls['currentConditions']; ?>" alt="<?php echo $this->data->twcContent->cc_text; ?>" border="0" />
									</div>
									<div class="CurrentConditionsText<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_text; ?>
									</div>
								</td>
								<td>
									<div class="CurrentConditionsTemperature<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_temp.'&deg;'.$this->data->twcContent->h_temp; ?>
									</div>
									<br />
								</td>
							</tr>
						</table>
						<table>
							<tr>
								<td>
									<table>
										<tr class="CurrentConditionsDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="CurrentConditionsDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_FEELSLIKE').': '; ?>
												</div>
											</td>
											<td>
												<div class="CurrentConditionsDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_windchill.'&deg;'.$this->data->twcContent->h_temp; ?>
												</div>
											</td>
										</tr>
										<tr class="CurrentConditionsDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="CurrentConditionsDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_SUNRISE').': '; ?>
												</div>
											</td>
											<td>
												<div class="CurrentConditionsDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->loc_sunrise; ?>
												</div>
											</td>
										</tr>
										<tr class="CurrentConditionsDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="CurrentConditionsDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_SUNSET').': '; ?>
												</div>
											</td>
											<td>
												<div class="CurrentConditionsDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->loc_sunset; ?>
												</div>
											</td>
										</tr>
									</table>
								</td>
								<td align="center">
<?php
									if ($this->data->imageUrls['moon'] != null)
									{
?>
									<img src="<?php echo $this->data->imageUrls['moon']; ?>" border="0" alt="<?php echo $this->data->twcContent->cc_moontext; ?>" />									
<?php
									}
?>
									<br />
									<?php echo $this->data->twcContent->cc_moontext; ?>
								</td>
							</tr>
						</table>
					</td>
					<td>&nbsp;</td>
					<td valign="top" style="border: 1px solid #CCCCCC" >
						<table>
							<tr>
								<td>
									<div align="center">
										<img src="<?php echo $this->data->imageUrls['windDir']; ?>" alt="" border="0" />
									</div>
								</td>
								<td>
									<div class="CurrentConditionsWindBlockText<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_windtext; ?>
									</div>
									<br />
								</td>
							</tr>
						</table>
						<br />
						<table>
							<tr>
								<td valign="middle" >
									<table>
										<tr class="CurrentConditionsWindDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="CurrentConditionsWindDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_WINDSPEED').': ' ?>
												</div>
											</td>
											<td>
												<div class="CurrentConditionsWindDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_windspeed.'&nbsp;'.$this->data->twcContent->h_speed; ?>
												</div>
											</td>
										</tr>
										<tr class="CurrentConditionsWindDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="CurrentConditionsWindDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_WINDDIR').': ' ?>
												</div>
											</td>
											<td>
												<div class="CurrentConditionsWindDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_winddirection.'&deg;'; ?>
												</div>
											</td>
										</tr>
										<tr class="CurrentConditionsWindDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="CurrentConditionsWindDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_WINDGUST').': ' ?>
												</div>
											</td>
											<td>
												<div class="CurrentConditionsWindDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_windgust.'&nbsp;'.$this->data->twcContent->h_speed; ?>
												</div>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
					<td>&nbsp;</td>
					<td valign="top" style="border: 1px solid #CCCCCC;" >
						<br />
						<table>
							<tr class="CurrentConditionsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_OBST').': ' ?>
									</div>
								</td>
								<td>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_observatory; ?>
									</div>
								</td>
							</tr>
							<tr class="CurrentConditionsLocationDataDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_LAT').': ' ?>
									</div>
								</td>
								<td>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->loc_latitude; ?>
									</div>
								</td>
							</tr>
							<tr class="CurrentConditionsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_LON').': ' ?>
									</div>
								</td>
								<td>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->loc_longitude; ?>
									</div>
								</td>
							</tr>
							<tr class="CurrentConditionsLocationDataDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_DEWP').': ' ?>
									</div>
								</td>
								<td>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_dewp.'&deg;'.$this->data->twcContent->h_temp; ?>
									</div>
								</td>
							</tr>
							<tr class="CurrentConditionsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_VISIBILITY').': ' ?>
									</div>
								</td>
								<td>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_visibility.'&nbsp;'.$this->data->twcContent->h_distance; ?>
									</div>
								</td>
							</tr>
							<tr class="CurrentConditionsLocationDataDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_HUMIDITY').': ' ?>
									</div>
								</td>
								<td>
<?php
									if (is_numeric($this->data->twcContent->cc_humidity))
									{
?>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_humidity.'%'; ?>
									</div>
<?php
									}
									else
									{
?>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_humidity; ?>
									</div>
<?php
									}
?>
								</td>
							</tr>
							<tr class="CurrentConditionsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="CurrentConditionsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_PRESSURE').': ' ?>
									</div>
								</td>
								<td>
<?php
									if (is_numeric($this->data->twcContent->cc_barpressure))
									{
?>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_barpressure.'&nbsp;'.$this->data->twcContent->h_pressure.'&nbsp;('.$this->data->twcContent->cc_bartext.')'; ?>
									</div>
<?php
									}
									else
									{
?>
									<div class="CurrentConditionsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_barpressure; ?>
									</div>
<?php
									}
?>
								</td>
							</tr>
						</table>
						<br />
						<table>
							<tbody>
								<tr>
									<td colspan="4" style="height: 2px;"></td>
								</tr>
								<tr>
									<td class="CurrentConditionsUvIndexHeader<?php echo $this->data->pageClassSuffix; ?>" colspan="4" valign="top" >
										<?php echo '&nbsp;'.JText::_('COM_EWEATHER_UV_INDEX').'&nbsp;('.$this->data->twcContent->cc_uvindex.')' ?>
									</td>
								</tr>
								<tr>
									<td rowspan="3" style="height: 3px; width: 4px;"></td>
								</tr>
								<tr>
									<td colspan="4" height="4">
										<table>
											<tbody>
												<tr>
<?php
		              								for ($y = 0; $y < 11; $y++)
              										{
														if ($this->data->twcContent->cc_uvindex != $y)
														{
?>
													<td width="9%"></td>
<?php
														}
														else
														{
?>
													<td width="9%">
														<img src="<?php echo $this->data->imageUrls['uvIndexArrow']; ?>" height="6" width="6" alt="" />
													</td>
<?php
														}
													}
?>
												</tr>
											</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td colspan="4" height="4">
										<img src="<?php echo $this->data->imageUrls['uvIndexKey']; ?>" height="10" width="100%" />
									</td>
								</tr>
								<tr>
									<td colspan="4" style="height: 1px;"></td>
								</tr>
								<tr>
									<td rowspan="3"></td>
								</tr>
								<tr>
									<td width="25%" align="left" style="text-align: left;" >
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_LOW'); ?>
										</font>
									</td>
									<td width="25%">
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_MED'); ?>
										</font>
									</td>
									<td width="25%">
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_HIGH'); ?>
										</font>
									</td>
									<td width="25%" align="right" style="text-align: right;" >
										<font face="Verdana,sans-serif" size="-2" >
											<?php echo JText::_('COM_EWEATHER_UV_SHIGH'); ?>
										</font>
									</td>
								</tr>
								<tr>
									<td width="25%" align="left" style="text-align: left;" >
										<font face="Verdana,sans-serif" size="-2">
											0
										</font>
									</td>
									<td width="25%" >&nbsp;</td>
									<td width="25%" >&nbsp;</td>
									<td width="25%" align="right" style="text-align: right;" >
										<font face="Verdana,sans-serif" size="-2">
											+10
										</font>
									</td>
								</tr>
								<tr>
									<td colspan="4" style="height: 6px;"></td>
								</tr>
							</tbody>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table><br /><br />
