<?php
/**
 * This file contains the forecast template for the main view
 *  in the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>

<!-- Forecast Header -->
<a name="eWeatherForecast"></a>
<table>
	<tr>
		<td class="sectiontableheader<?php echo $this->data->pageClassSuffix; ?>" valign="middle" >
			<?php echo JText::_('COM_EWEATHER_FORECAST').'&nbsp;-&nbsp;'.$this->data->twcContent->loc_city; ?>
			<br/>
			<?php echo JText::_('COM_EWEATHER_LASTUPDATED').'&nbsp;-&nbsp;'.$this->data->twcContent->dayf_lastupdate; ?>
		</td>
	</tr>
	<tr>
		<td>
			<br />
		</td>
	</tr>
</table>
<!-- Forecast Body -->
<div class="eweatherforecast" >
<table>
	 <tr>
<?php
		for ($i = 0; $i < $this->forecastDays; ++$i)
		{
?>        
		<td>
			<table>
				<tr>
					<td class="ForecastBlockHeader<?php echo $this->data->pageClassSuffix; ?>" height="19" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; border: 0px; vertical-align: bottom;">
							<a href="<?php echo $this->data->detailedForecastUrls[$i]; ?>" title="<?php echo JText::_('COM_EWEATHER_FORECAST_FTITLE'); ?>" >
								<img src="<?php echo $this->data->imageUrls['weatherDetailOpen']; ?>" align="left" border="0" alt="" />
							</a>
							<?php echo $this->data->formattedForecastDates[$i]; ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" >
						<div style="font-weight: bold; text-align: center;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_DAY'); ?>
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC;">
						<div style="font-weight: bold; text-align: center;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_NIGHT'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
							<img src="<?php echo $this->data->forecastDayIcons[$i]; ?>" border="0" alt="<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_d_text; ?>" />
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
						<img src="<?php echo $this->data->forecastNightIcons[$i]; ?>" border="0" alt="<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_n_text; ?>" />
							<br />
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; background: #EFEFEF;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_TEMP'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
<?php
						if ('N/A' == $this->data->twcContent->dayf_forecasts[$i]->day_d_text)
						{
							echo 'N/A';
						}
						else
						{
							echo JText::_('COM_EWEATHER_FORECAST_TEMP_MAX').': '.$this->data->twcContent->dayf_forecasts[$i]->day_temp_max.'&deg;'.$this->data->twcContent->h_temp;
						}
?>
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_TEMP_MIN').': '.$this->data->twcContent->dayf_forecasts[$i]->day_temp_min.'&deg;'.$this->data->twcContent->h_temp; ?>
							<br />
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; background: #EFEFEF;" >
							<?php echo JText::_('COM_EWEATHER_FORECAST_RAIN'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
<?php
						if ('N/A' == $this->data->twcContent->dayf_forecasts[$i]->day_d_text)
						{
							echo 'N/A';
						}
						else
						{
							echo $this->data->twcContent->dayf_forecasts[$i]->day_d_precipitation.'%';
						}
?>
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
							<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_n_precipitation.'%'; ?>
							<br />
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC;" colspan="2" >
						<div style="font-weight: bold; text-align: center; color: #000000; background: #EFEFEF;">
							<?php echo JText::_('COM_EWEATHER_WIND'); ?>
						</div>
					</td>
				</tr>
				<tr>
					<td style="border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
<?php
						if ('N/A' == $this->data->twcContent->dayf_forecasts[$i]->day_d_text)
						{
							echo 'N/A';
						}
						else
						{

							echo $this->data->twcContent->dayf_forecasts[$i]->day_d_windtext.'&nbsp;'.$this->data->twcContent->dayf_forecasts[$i]->day_d_windspeed;
						}
?>
							<br />
						</div>
					</td>
					<td style="border-right: 1px solid #CCCCCC; border-bottom: 1px solid #CCCCCC;" >
						<div align="center" style="text-align:center" >
							<?php echo $this->data->twcContent->dayf_forecasts[$i]->day_n_windtext.'&nbsp;'.$this->data->twcContent->dayf_forecasts[$i]->day_n_windspeed; ?>
							<br />
						</div>
					</td>
				</tr>
			</table>
		</td>
<?php
		// If this is the last forecast for this row, close the row
		if (($i % $this->forecastDaysPerRow) == ($this->forecastDaysPerRow - 1))
	    {
?>
	</tr>
	<tr>
		<td colspan="15" height="10"></td>
	</tr>
<?php
			// If there are more forecasts, open a new row
			if ($i != ($this->forecastDays - 1))
			{
?>
	<tr>
<?php
			}
		}
		// Not at the end of a row
		elseif ($i != ($this->forecastDays - 1))
		{
?>
		<td class="eweatherforecastspacer"></td>
<?php
		}
    } // end for loop

	//
	// if there is still a forecast row open, close it
	// there will be a forecast row open in the case that
	//  the number of forecasts per row is not an even
	//  multiple of the number of forecasts
	//
    if (($this->forecastDays % $this->forecastDaysPerRow) != 0)
	{
?>
	</tr>
<?php
	}
?>
</table>
</div>
