<?php
/**
 * This file contains the main view definition
 *  for the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport( 'joomla.application.component.view');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('eWeatherConfiguration', COM_EWEATHER_CLASSES_PATH.DS.'eweatherconfiguration.php' );


class eWeatherViewMain extends JView
{
	function __construct($config = array())
	{
		parent::__construct($config);
		
		$cfg = new eWeatherConfiguration();
		
		// add path to sub-layout templates
		$this->addTemplatePath(COM_EWEATHER_VIEWS_PATH.DS.'main'.DS.'tmpl'.DS);

		// include the appropriate style sheets
    	JHTML::stylesheet( 'eweather.css', COM_EWEATHER_CSS_URL );
		if (isset($cfg->iconStyle))
		{	
    		JHTML::stylesheet( 'eweather.images.'.$cfg->iconStyle.'.css', COM_EWEATHER_CSS_URL );
		}
	}
	
	function display($tpl = null)
	{
		$cfg = new eWeatherConfiguration();
		
		// get the view-oriented configuration data
		if (isset($cfg->eWeatherVersion))
		{
			$this->providerPosition = $cfg->providerPosition;
			$this->allowUserProfiles = $cfg->allowUserProfiles;
			$this->showCurrentConditions = $cfg->showCurrentConditions;
			$this->showForecast = $cfg->showForecast;
			$this->showFooter = $cfg->showFooter;
			$this->forecastDays = $cfg->forecastDays;
			$this->forecastDaysPerRow = $cfg->forecastDaysPerRow;
		}
		$this->detailedForecast = JRequest::getVar('detail', null);
		
		// get the weather data from the model,
		//  using the user-supplied locid
		$locid = JRequest::getVar('locid');
		$model = $this->getModel();
		$this->data = $model->getData($locid);
		
		parent::display($tpl);
	}

}
