<?php
/**
 * This file contains the eWeatherModule class
 *  for the eWeather module.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * converted to Joomla! 1.5.x by Bob Lavey
 * 02/26/2010: Bob Lavey - converted to MVC and updated to work with 1.4.0 MVC component
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 * 
 * @package eWeather
 * @subpackage eWeather Module
 * @copyright Copyright (C) 2000 - 2005 Miro International Pty Ltd,
 *            2006 Harald Baer<br/>
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.model');

// setup paths
require_once( JPATH_SITE .DS.'modules'.DS.'mod_eweather'.DS.'helpers'.DS.'defines.php' );

JModel::addIncludePath( COM_EWEATHER_MODELS_PATH );			


class eWeatherModule extends JObject
{
	var $_moduleclass_sfx = null;
	var $_allowUserProfiles = null;
	var $_model = false;

	function __construct($params)
	{
		if (defined( 'COM_EWEATHER_ADMIN_VERSION' ))
		{
			// load the com_eweather language file
			$lang = JFactory::getLanguage();
			$lang->load('com_eweather', COM_EWEATHER_PATH );
			
			// get the module's params
			$this->moduleClassSuffix = $params->get( 'moduleClassSuffix' );
			$this->allowUserProfiles = $params->get( 'allowUserProfiles' );
	
			// include the appropriate style sheets
	    	JHTML::stylesheet( 'eweather.css', COM_EWEATHER_CSS_URL );
			
			// get eWeather Component's "main" model
	    	$this->_model = JModel::getInstance('main', 'eWeatherModel');
			if (false == $this->_model)
			{
				$this->_errors['moduleError'] = JText::_('MOD_EWEATHER_COMPONENT_NOT_FOUND').': com_eweather';
			}
		}
		else
		{
			$this->_errors['moduleError'] = JText::_('MOD_EWEATHER_COMPONENT_NOT_FOUND').': com_eweather';
		}
    
	}
	
	function display()
	{
		if (false != $this->_model)
		{
			$this->data = $this->_model->getData(null);
		}
		
		if (isset($this->_errors['moduleError']))
		{
			require(JModuleHelper::getLayoutPath('mod_eweather', 'componenterror'));
		}
		else if ('error' == $this->data->dataType)
		{
			require(JModuleHelper::getLayoutPath('mod_eweather', 'weathererror'));
		}
		else
		{
			require(JModuleHelper::getLayoutPath('mod_eweather', 'default'));
		}
	}
	
}
