<?php
/**
 * This file contains the eWeatherCCDetailsModule class
 *  for the eWeatherCCDetails module.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 04/11/2010: Bob Lavey - Initial revision
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeather
 * @subpackage eWeatherCCDetails Module
 * @copyright Copyright (C) 2011 Bob Lavey
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.model');

// setup paths
require_once( JPATH_SITE .DS.'modules'.DS.'mod_eweather_ccdetails'.DS.'helpers'.DS.'defines.php' );

JModel::addIncludePath( COM_EWEATHER_MODELS_PATH );			


class eWeatherCCDetailsModule extends JObject
{
	protected $model = false;
	
	function __construct($params)
	{
		if (defined( 'COM_EWEATHER_ADMIN_VERSION' ))
		{
			// load the com_eweather language file
			$lang = JFactory::getLanguage();
			$lang->load('com_eweather', COM_EWEATHER_PATH );
					
			// get the module's params
			$this->moduleClassSuffix = $params->get( 'moduleClassSuffix' );
			$this->stackHorizontally = $params->get( 'stackHorizontally' );
			
			// include the appropriate style sheets
			JHTML::stylesheet( 'mod_eweather_ccdetails.css', MOD_EWEATHER_CCDETAILS_CSS_URL );
					
			// get eWeather Component's "main" model
			$this->model = JModel::getInstance('main', 'eWeatherModel');
			if (false == $this->model)
			{
				$this->_errors['moduleError'] = JText::_('MOD_EWEATHER_CCDETAILS_COMPONENT_NOT_FOUND').': com_eweather';
			}
		}
		else
		{
			$this->_errors['moduleError'] = JText::_('MOD_EWEATHER_CCDETAILS_COMPONENT_NOT_FOUND').': com_eweather';
		}
	}
	
	function display()
	{
		if (false != $this->model)
		{
			$this->data = $this->model->getData(null);
		}
		
		if (isset($this->_errors['moduleError']))
		{
			require(JModuleHelper::getLayoutPath('mod_eweather_ccdetails', 'componenterror'));
		}
		else if ('error' == $this->data->dataType)
		{
			require(JModuleHelper::getLayoutPath('mod_eweather_ccdetails', 'weathererror'));
		}
		else
		{
			require(JModuleHelper::getLayoutPath('mod_eweather_ccdetails', 'default'));
		}
	}

}
