<?php
/**
 * This file contains the default template for the eWeatherCCDetails module.
 *
 * This file is part of the eWeatherCCDetails Module.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * 04/11/2010: Bob Lavey - Initial revision
 * 03/14/2011: Bob Lavey - Converted to work with Joomla! 1.6.x 
 *
 * @package eWeatherCCDetails Module
 * @subpackage eWeatherCCDetails Module
 * @copyright Copyright (C) 2011 Bob Lavey
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

require_once( JPATH_SITE .DS.'modules'.DS.'mod_eweather_ccdetails'.DS.'helpers'.DS.'defines.php' );


echo '<!-- eWeatherCCDetails Module Version '.MOD_EWEATHER_CCDETAILS_VERSION.' '.MOD_EWEATHER_CCDETAILS_VERSION_DATE.' -->';
?>
<div class="eweather" >
<table width="98%" border="0" cellspacing="0" cellpadding="3" align="center" >
	<tr>
		<td>&nbsp;</td>
	</tr>
	<tr>
		<td class="sectiontableheader<?php echo $this->data->pageClassSuffix; ?>" valign="middle" >
			<?php echo JText::_('COM_EWEATHER_LASTUPDATED').'&nbsp;-&nbsp;'.$this->data->formattedCurrentConditionsLastUpdate; ?>
		</td>
	</tr>
	<tr>
		<td>
			<table border="0" width="99%" align="center" cellpadding="2" cellspacing="0" >
				<tr>
					<td valign="top" style="border: 1px solid #CCCCCC;" >
						<table border="0" width="100%" align="center" cellpadding="0" cellspacing="0" >
							<tr>
								<td colspan=2 class="ModCCDetailsBlockHeader<?php echo $this->data->pageClassSuffix; ?>" >
									<?php echo $this->data->twcContent->loc_city; ?>
								</td>
							</tr>
							<tr>
								<td>
									<div align="center">
										<img src="<?php echo $this->data->imageUrls['currentConditions']; ?>" alt="<?php echo $this->data->twcContent->cc_text; ?>" border="0" />
									</div>
									<div class="ModCCDetailsText<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_text; ?>
									</div>
								</td>
								<td>
									<div class="ModCCDetailsTemperature<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_temp.'&deg;'.$this->data->twcContent->h_temp; ?>
									</div>
									<br />
								</td>
							</tr>
						</table>
						<table border="0" width="96%" align="center" cellpadding="0" cellspacing="0" >
							<tr>
								<td>
									<table border="0" width="100%" cellspacing="0" summary="" >
										<tr class="ModCCDetailsDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="ModCCDetailsDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_FEELSLIKE').': '; ?>
												</div>
											</td>
											<td>
												<div class="ModCCDetailsDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_windchill.'&deg;'.$this->data->twcContent->h_temp; ?>
												</div>
											</td>
										</tr>
										<tr class="ModCCDetailsDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="ModCCDetailsDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_SUNRISE').': '; ?>
												</div>
											</td>
											<td>
												<div class="ModCCDetailsDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->loc_sunrise; ?>
												</div>
											</td>
										</tr>
										<tr class="ModCCDetailsDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="ModCCDetailsDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_SUNSET').': '; ?>
												</div>
											</td>
											<td>
												<div class="ModCCDetailsDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->loc_sunset; ?>
												</div>
											</td>
										</tr>
									</table>
								</td>
								<td align="center">
<?php
									if ($this->data->imageUrls['moon'] != null)
									{
?>
									<img src="<?php echo $this->data->imageUrls['moon']; ?>" border="0" alt="<?php echo $this->data->twcContent->cc_moontext; ?>" />									
<?php
									}
?>
									<br />
									<?php echo $this->data->twcContent->cc_moontext; ?>
								</td>
							</tr>
						</table>
					</td>
<?php 			if (0 == $this->stackHorizontally)
				{
					echo "				</tr>\n";
					echo "				<tr>\n";
				}
				else
				{
					echo "					<td>&nbsp;</td>\n";
				}
?>
					<td valign="top" style="border: 1px solid #CCCCCC" >
						<table border="0" width="100%" align="center" cellpadding="0" cellspacing="0" >
							<tr>
								<td colspan=2 class="ModCCDetailsBlockHeader<?php echo $this->data->pageClassSuffix; ?>" width="33%" >
									<?php echo JText::_('COM_EWEATHER_WIND'); ?>
								</td>
							</tr>
							<tr>
								<td>
									<div align="center">
										<img src="<?php echo $this->data->imageUrls['windDir']; ?>" alt="" border="0" />
									</div>
								</td>
								<td>
									<div class="ModCCDetailsWindBlockText<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_windtext; ?>
									</div>
									<br />
								</td>
							</tr>
						</table>
						<br />
						<table border="0" width="100%" align="center" cellpadding="0" cellspacing="0" >
							<tr>
								<td valign="middle" >
									<table border="0" width="80%" cellspacing="0" align="center" >
										<tr class="ModCCDetailsWindDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="ModCCDetailsWindDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_WINDSPEED').': ' ?>
												</div>
											</td>
											<td>
												<div class="ModCCDetailsWindDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_windspeed.'&nbsp;'.$this->data->twcContent->h_speed; ?>
												</div>
											</td>
										</tr>
										<tr class="ModCCDetailsWindDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="ModCCDetailsWindDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_WINDDIR').': ' ?>
												</div>
											</td>
											<td>
												<div class="ModCCDetailsWindDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_winddirection.'&deg;'; ?>
												</div>
											</td>
										</tr>
										<tr class="ModCCDetailsWindDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
											<td>
												<div class="ModCCDetailsWindDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo JText::_('COM_EWEATHER_WINDGUST').': ' ?>
												</div>
											</td>
											<td>
												<div class="ModCCDetailsWindDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
													<?php echo $this->data->twcContent->cc_windgust.'&nbsp;'.$this->data->twcContent->h_speed; ?>
												</div>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
<?php 			if (0 == $this->stackHorizontally)
				{
					echo "				</tr>\n";
					echo "				<tr>\n";
				}
				else
				{
					echo "					<td>&nbsp;</td>\n";
				}
?>
					<td valign="top" style="border: 1px solid #CCCCCC;" >
						<table border="0" width="100%" align="center" cellpadding="0" cellspacing="0" >
							<tr>
								<td colspan=2 class="ModCCDetailsBlockHeader<?php echo $this->data->pageClassSuffix; ?>">
									<?php echo JText::_('COM_EWEATHER_LOC_DATA'); ?>
								</td>
							</tr>
							<tr><td>&nbsp;</td></tr>
							<tr class="ModCCDetailsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_OBST').': ' ?>
									</div>
								</td>
								<td>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_observatory; ?>
									</div>
								</td>
							</tr>
							<tr class="ModCCDetailsLocationDataDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_LAT').': ' ?>
									</div>
								</td>
								<td>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->loc_latitude; ?>
									</div>
								</td>
							</tr>
							<tr class="ModCCDetailsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_LON').': ' ?>
									</div>
								</td>
								<td>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->loc_longitude; ?>
									</div>
								</td>
							</tr>
							<tr class="ModCCDetailsLocationDataDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_DEWP').': ' ?>
									</div>
								</td>
								<td>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_dewp.'&deg;'.$this->data->twcContent->h_temp; ?>
									</div>
								</td>
							</tr>
							<tr class="ModCCDetailsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_VISIBILITY').': ' ?>
									</div>
								</td>
								<td>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_visibility.'&nbsp;'.$this->data->twcContent->h_distance; ?>
									</div>
								</td>
							</tr>
							<tr class="ModCCDetailsLocationDataDetail_2<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_HUMIDITY').': ' ?>
									</div>
								</td>
								<td>
<?php
									if (is_numeric($this->data->twcContent->cc_humidity))
									{
?>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_humidity.'%'; ?>
									</div>
<?php
									}
									else
									{
?>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_humidity; ?>
									</div>
<?php
									}
?>
								</td>
							</tr>
							<tr class="ModCCDetailsLocationDataDetail_1<?php echo $this->data->pageClassSuffix; ?>" >
								<td>
									<div class="ModCCDetailsLocationDataDetailHeader<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo JText::_('COM_EWEATHER_PRESSURE').': ' ?>
									</div>
								</td>
								<td>
<?php
									if (is_numeric($this->data->twcContent->cc_barpressure))
									{
?>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_barpressure.'&nbsp;'.$this->data->twcContent->h_pressure.'&nbsp;('.$this->data->twcContent->cc_bartext.')'; ?>
									</div>
<?php
									}
									else
									{
?>
									<div class="ModCCDetailsLocationDataDetailValue<?php echo $this->data->pageClassSuffix; ?>" >
										<?php echo $this->data->twcContent->cc_barpressure; ?>
									</div>
<?php
									}
?>
								</td>
							</tr>
						</table>
						<br />
						<table border="0" cellpadding="0" cellspacing="0" width="174" align="center" summary="">
							<tbody>
								<tr>
									<td colspan="4" style="height: 2px;"></td>
								</tr>
								<tr>
									<td class="ModCCDetailsUvIndexHeader<?php echo $this->data->pageClassSuffix; ?>" colspan="4" valign="top" >
										<?php echo '&nbsp;'.JText::_('COM_EWEATHER_UV_INDEX').'&nbsp;('.$this->data->twcContent->cc_uvindex.')' ?>
									</td>
								</tr>
								<tr>
									<td rowspan="3" style="height: 3px; width: 4px;"></td>
								</tr>
								<tr>
									<td colspan="4" height="4">
										<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height: 2;" summary="" >
											<tbody>
												<tr>
<?php
		              								for ($y = 0; $y < 11; $y++)
              										{
														if ($this->data->twcContent->cc_uvindex != $y)
														{
?>
													<td width="15"></td>
<?php
														}
														else
														{
?>
													<td width="15">
														<img src="<?php echo $this->data->imageUrls['uvIndexArrow']; ?>" height="6" width="6" alt="" />
													</td>
<?php
														}
													}
?>
												</tr>
											</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td colspan="4" height="4">
										<img src="<?php echo $this->data->imageUrls['uvIndexKey']; ?>" height="10" width="166" alt="" />
									</td>
								</tr>
								<tr>
									<td colspan="4" style="height: 1px;"></td>
								</tr>
								<tr>
									<td rowspan="3" style="width: 4px;"></td>
								</tr>
								<tr>
									<td width="42">
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_LOW'); ?>
										</font>
									</td>
									<td width="42">
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_MED'); ?>
										</font>
									</td>
									<td width="42">
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_HIGH'); ?>
										</font>
									</td>
									<td width="42">
										<font face="Verdana,sans-serif" size="-2">
											<?php echo JText::_('COM_EWEATHER_UV_SHIGH'); ?>
										</font>
									</td>
								</tr>
								<tr>
									<td width="42"  align="left" style="text-align: left;" >
										<font face="Verdana,sans-serif" size="-2">
											0
										</font>
									</td>
									<td width="42"  align="right" style="text-align: right;" >
										<font face="Verdana,sans-serif" size="-2">
											&nbsp;
										</font>
									</td>
									<td width="42"  align="right" style="text-align: right;" >
										<font face="Verdana,sans-serif" size="-2">
											&nbsp;
										</font>
									</td>
									<td width="42" align="right" style="text-align: right;" >
										<font face="Verdana,sans-serif" size="-2">
											+10
										</font>
									</td>
								</tr>
								<tr>
									<td colspan="4" style="height: 6px;"></td>
								</tr>
							</tbody>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<table border="0" cellspacing="0" style="border-collapse: collapse;" align="center" width="99%">
				<tr>
					<td align="right" style="font-size: 70%; line-height:90%; padding-top: 15px;">
						<div align="left">
							<?php echo JText::_('COM_EWEATHER_PROVIDER').':'; ?>
							<br/>
							<a href="http://www.weather.com" target="blank">
								<img src="<?php echo $this->data->imageUrls['weatherChannelLogoSmall']; ?>" border="0" alt="www.weather.com" />
							</a>
						</div>
					</td>
					<td align="right" style="font-size: 80%; line-height:100%; padding-left: 5px; padding-top: 15px; text-align: right;" >
<?php
		    		$numLinks = count($this->data->twcContent->partnerLinks);
    				for ($x = 0; $x < $numLinks; $x++)
    				{
	    			$url = JROUTE::_(str_replace('&','&amp;',$this->data->twcContent->partnerLinks[$x]->url));
	    			$text = str_replace('&','&amp;',$this->data->twcContent->partnerLinks[$x]->text)
?>
						<a target="_blank" href="<?php echo $url ?>" title="<?php echo $text ?>" >
							<?php echo $text ?>
						</a>
						<br/>
<?php
					}
?>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</div>
<?php
echo '<!-- end eWeatherCCDetails Module Version '.MOD_EWEATHER_CCDETAILS_VERSION.' '.MOD_EWEATHER_CCDETAILS_VERSION_DATE.' -->';
?>
