<?php
/**
* @version $Id: admin.serverstat.html.php,v 0.6.2 2006/08/28 23:55:00 wilcojansen Exp $
* @package serverstat 0.6.2
* @copyright (c) 2005 Wilco Jansen
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* Servstatus main HTML writer.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");

/**
  * Draw the menu items for given options. Check out the 
  * toolbar.serverstat.php file for option handling.
  */
Class HTML_serverstat {
	/**
	  * Display the list of defined servers
	  */
	function showServerEntries( $option, &$rows, $pageNav, &$lists, &$st, &$rm ) {
	global $my;
	?>

	<!--
	*    START OF SERVERLIST FORM
	-->
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminheading">
	<tr>
		<th><?php echo _SERVERSTAT_BACKHEADER_SERVERLIST_ALL; ?></small></th>
		<td align="right">
			<table cellpadding="0" cellspacing="5">
			<tr>
				<td nowrap><small><?php echo _SERVERSTAT_SERVERTYPE;?></small></td>
				<td><?php echo $lists['st']; ?></td>

			</tr>
			<tr>
				<td align="left" nowrap><small><?php echo _SERVERSTAT_INCLUDEREMOTE;?></small></td>
				<td><input type="checkbox" name="rm" value="1" <?php echo $rm ? 'checked="checked"' : ''; ?> onchange="document.adminForm.submit();" /></td>
			</tr>
			</table>
		<td>
	</tr>
	</table>

	<!--
	*    START OF SERVERLIST, HEADER PART (COLUMNS)
	-->
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th width="2%" class="title"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" /></th>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_LIST_SERVERNAME; ?></div></th>
		<th class="title"><div align="center"><?php echo _SERVERSTAT_LIST_PUBLISHED; ?></div></th>
		<th width="5% class="title" colspan="2"><div align="center"><?php echo _SERVERSTAT_LIST_ORDER; ?></div></th>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_LIST_IP; ?></div></th>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_LIST_PORT; ?></div></th>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_LIST_TYPE; ?></div></th>
	</tr>

	<?php
	$k = 0;
	for ($i=0, $n=count( $rows ); $i < $n; $i++) {
		# Get current row, and set some vars for presentation for published status
		# for current server.
		$row = &$rows[$i];

		# Now we render the server detail record.
		echo "<tr class='row$k'>";
		?>

		<td width='2%'>
		<?php echo mosCommonHTML::CheckedOutProcessing( $row, $i ); ?>
		</td>

		<?php
		echo "<td align='left'><a href=\"index2.php?option=".$option."&task=edit&id=".$row->id."&st=$st&rm=$rm\">$row->servername</a></td>";
		?>
			<td align="center">
			<?php echo mosCommonHTML::PublishedProcessing( $row, $i );?>
			</td>
			<td>
			<?php echo $pageNav->orderUpIcon( $i ); ?>
			</td>
			<td>
			<?php echo $pageNav->orderDownIcon( $i, $n ); ?>
			</td>
	<?php
		echo "<td align='left'>$row->ip</td>\n";
		echo "<td align='left'>$row->port</td>\n";
		echo "<td align='left'>" . getServerConfigVar ($row, "description") . "</td>\n";
	?>
	</tr>
	<?php $k = 1 - $k; } ?>
	</table>

	<?php echo $pageNav->getListFooter(); ?>
	<input type="hidden" name="option" value="<?php echo $option;?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	</form>

	<?php
	} # End function showServerEntries

	/**
	  * Display the list of defined servers
	  * @param row object for selected server
	  * @param variables for the 
	  */
	function editServers( $row, $option, &$lists, $status, $st, $rm ) {
	global $mosConfig_live_site, $mosConfig_absolute_path, $serverstat_tweaking;
	global $serverstat_servers;

	mosMakeHtmlSafe( $row );

	$tabs = new mosTabs(1);

	mosCommonHTML::loadOverlib();
	mosCommonHTML::loadCalendar();
	?>
	<!--
	* Start javascript field control.
	-->
	<script language="javascript" type="text/javascript">

	onload = function() {
		setfields()
	} // End function onload (predefined method)

	function setfields () {
		// Field handling
		switch (document.adminForm.servertype.value) {
			case "ICE":
			case "SC":
				showlayer ("authentication")
				hidelayer ("port1")
				break;

			case "FTP":
			case "WEB":
				hidelayer ("port1")
				break;

			default:
				showlayer ("port1")
				hidelayer ("authentication")
		} // End switch

		// Determine default field values when servertype changes, only
		// change the port values when fields are empty, else we leave
		// port values untouched.
		if (document.adminForm.port.value == "" && document.adminForm.port1.value == "") {
			switch (document.adminForm.servertype.value) {
			<?php
			global $serverstat_servers;

			# Here we render all possible servertype values from the
			# main config.serverstat.xml file.
			$array = $serverstat_servers;
			for ($i=0; $i<count($array); $i++) {
				echo "\t\tcase \"" . $array[$i]['id'] . "\":\n";
				echo "\t\t\tdocument.adminForm.port.value = "  . intval($array[$i]['port']) . "\n";
				echo "\t\t\tdocument.adminForm.port1.value = "  . intval($array[$i]['port1']) . "\n";
				echo "\t\t\tbreak\n";
			} # End for
			?>
			} // End switch
		} // End if
		
		// When editing a server, we can render instant information
		// For this we check if the field "serverinfo" is present,
		// if so we enable the DIV tag for the selected server.
		hidelayer ('serverinfo_default')
		<?php
		for ($i=0; $i<count($array); $i++) {
			echo "\t\thidelayer('serverinfo_" . $array[$i]['id'] . "')\n";
		} # End for
		?>

		var Layer = 'serverinfo_default'
		if (document.adminForm.servertype.value != "") {
			Layer = "serverinfo_" + document.adminForm.servertype.value
		} // # End if
		showlayer (Layer)
	} // End function setfields

	function showlayer(el) {
		document.getElementById(el).style.display = ''
	} // End function showlayer

	function hidelayer(el) {
		document.getElementById(el).style.display = 'none'
	} // End function hidelayer

	function submitbutton(pressbutton) {
		var form = document.adminForm;

		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		}

		if ( form.servername.value == "" ) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_SERVERNAME; ?>" );
			return;
		}

		if ( form.servertype.value == 0 ) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_SERVERTYPE; ?>" );
			return;
		}

		if ( form.ip.value == "" ) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_IP; ?>" );
			return;
		}

		if ( form.port.value == "" || form.port.value < 0 || form.port.value > 65536) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_PORT; ?>" );
			return;
		}

		if ( form.port1.value < 0 || form.port1.value > 65536) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_PORT1; ?>" );
			return;
		}

		if ( form.retrycount.value < 0 ) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_RETRYCOUNT; ?>" );
			return;
		}

		if ( form.emailnotification.checked && form.email.value == "") {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_EMAIL; ?>" );
			return;
		}

		if ( form.timeout.value < 0 ) {
			alert( "<?php echo _SERVERSTAT_JSCRIPTERR_TIMEOUT; ?>" );
			return;
		}
		submitform( pressbutton );
	} // End function submitbutton
	</script>

	<!--
	*    START OF SERVEREDITFORM
	-->
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminheading" border="1">
	<tr>
		<th class="edit"><?php echo $row->id ? _SERVERSTAT_BACKHEADER_EDIT : _SERVERSTAT_BACKHEADER_NEW;?>
		<?php
		if ( $row->id ) {
			?>
			<small>
			[ <?php echo $row->servername?> ]
			</small>
			<?php
		} # End if
		?>
		</th>
	</tr>
	</table>

	<!--
	*    START OF SERVER DETAILS
	-->
	<table cellspacing="0" cellpadding="0" width="100%" border="0">
	<tr>
		<td width="40%" valign="top" cellspacing="0" cellpadding="0" border="0">
			<table width="100%" class="adminform" cellspacing="0" cellpadding="0" border="0">
			<tr valign="top">
				<td>
					<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr>
						<th colspan="4"><?php echo _SERVERSTAT_BACKHEADER_SERVERDETAILS; ?></th>
					</tr>
					<tr valign="top">
						<td nowrap width="150"><?php echo _SERVERSTAT_DETAILS_SERVERNAME; ?></td>
						<td>
						<input class="text" type="text" name="servername" size="30" maxlength="50" value="<?php echo $row->servername; ?>" />
						</td>
						<td nowrap><?php echo _SERVERSTAT_DETAILS_TYPE; ?></td>
						<td><?php echo $lists['servertype']; ?></td>
					</tr>
					<tr valign="top">
						<td nowrap width="150"><?php echo _SERVERSTAT_DETAILS_IP; ?></td></td>
						<td colspan="3">
						<input class="text" type="text" name="ip" size="15" maxlength="50" value="<?php echo $row->ip; ?>" />
						</td>
					</tr>
					<tr valign="top">
						<td nowrap width="150"><?php echo _SERVERSTAT_DETAILS_PORT; ?></td>
						<td colspan="3">
						<input class="text" type="text" name="port" size="6" maxlength="6" value="<?php echo $row->port; ?>" />
						</td>
					</tr>
					</table>
					<div id="port1" style="DISPLAY: none">
					<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr valign="top">
						<td nowrap width="150"><?php echo _SERVERSTAT_DETAILS_PORT1; ?></td>
						<td colspan="3">
						<input class="text" type="text" name="port1" size="6" maxlength="6" value="<?php echo $row->port1; ?>" />
						&nbsp;
						<?php echo mosToolTip( _SERVERSTAT_DETAILS_PORT1_INFO, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
						</td>
					</tr>
					</table>
					</div>
					<div id="authentication" style="DISPLAY: none">
					<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr valign="top">
						<td nowrap width="150"><?php echo _SERVERSTAT_DETAILS_USERNAME; ?></td>
						<td colspan="3">
						<input class="text" type="text" name="username" size="20" maxlength="50" value="<?php echo $row->username; ?>" />
						&nbsp;
						<?php echo mosToolTip( _SERVERSTAT_DETAILS_USERNAME_INFO, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
						</td>
					</tr>
					<tr valign="top">
						<td nowrap width="150"><?php echo _SERVERSTAT_DETAILS_PASSWORD; ?></td>
						<td colspan="3">
						<input class="text" type="text" name="password" size="20" maxlength="50" value="<?php echo $row->password; ?>" />
						&nbsp;
						<?php echo mosToolTip( _SERVERSTAT_DETAILS_PASSWORD_INFO, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
						</td>
					</tr>
					</table>
					</div>
					<?php
					# This logic is available from com_serverstathelp version 0.6.1 and up
					if (intval(str_replace(".", "", ComponentVersion ("serverstathelp"))) > 59) {
					?>
					<br>
					<table class="adminform" cellspacing="0" cellpadding="0">
					<tr>
						<th><?php echo _SERVERSTAT_HELP_INSTANT; ?></th>
					</tr>
					<tr><td>
					<?php
					# Default info when no servertype is selected (e.g. new server).
					echo "\n<div id=\"serverinfo_default\" style=\"DISPLAY: none\">\n";
					echo "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n";
					echo "<tr class=\"row0\">\n";
					echo "<td>";
					echo _SERVERSTAT_HELP_NOTAVAILABLE;
					echo "</td>";
					echo "</tr>\n";
					echo "</table>\n";
					echo "</div>\n";

					for ($i=0; $i<count($array); $i++) {
						echo "\n<div id=\"serverinfo_"  . $array[$i]['id'] ."\" style=\"DISPLAY: none\">\n";
						echo "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n";
						echo "<tr class=\"row0\">\n";
						echo "<td valign=\"top\">";
						$file = $mosConfig_absolute_path."/administrator/components/com_serverstathelp/serverinfo/serverinfo." . $array[$i]['id'] . ".php";
						if (file_exists($file)) {
							include $file;
						} else {
							echo _SERVERSTAT_HELP_NOTAVAILABLE;
						} # End if
						echo "</td>";
						echo "</tr>\n";
						echo "</table>\n";
						echo "</div>\n";
					} # End for

					?>
					</td></tr>
					</table>
					<?php
					} # End if
					?>
				</td>
				<td width="40%">
					<table width="100%">
					<tr>
						<td>
						<?php
						$tabs->startPane("content-pane");
						$tabs->startTab(_SERVERSTAT_TABPUBLISHING,"publish-page");
						?>
							<table class="adminform">
							<tr>
								<th colspan="2"><?php echo _SERVERSTAT_TABPUBLISHING_INFO; ?></th>
							</tr>
							<tr valign="top">
								<td colspan="2"><small><?php echo _SERVERSTAT_PUBLISHED_INFO; ?></small>
								</td>
							</tr>
							<tr>
								<td valign="top" align="right"><?php echo _SERVERSTAT_PUBLISHED_PUBLISHED; ?></td>
								<td><input type="checkbox" name="published" value="1" <?php echo $row->published ? 'checked="checked"' : ''; ?> /></td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><?php echo _SERVERSTAT_PUBLISHED_ORDER; ?></td>
								<td><?php echo $lists['ordering']; ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right" nowrap><?php echo _SERVERSTAT_SLOWSERVER; ?></td>
								<td><input type="checkbox" name="slowserver" value="1" <?php echo $row->slowserver ? 'checked="checked"' : ''; ?> /></td>
							</tr>
							</table>
							<br>
							<table class="adminform">
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_SERVERID; ?></strong></td>
								<td><?php echo $row->id; ?> </td>
							</tr>
							<tr valign="top">
								<td width="90px" valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_STATE; ?></strong></td>
								<td>
								<?php echo $row->published > 0 ? 'Published' : 'Unpublished';?>
								</td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_VIEWS; ?></strong></td>
								<td><?php echo $row->views; ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_HITS; ?></strong></td>
								<td><?php echo $row->hits; ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_THRESHOLDCOUNTER; ?></strong></td>
								<td><?php echo $row->tcounter; ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_CREATED; ?></strong></td>
								<td><?php echo mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S' ); ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_CREATEDBY; ?></strong></td>
								<td><?php echo empty($row->creator) ? '-' : $row->creator ; ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_LASTMODIFIED; ?></strong>
								<td><?php echo mosFormatDate( $row->modified, '%Y-%m-%d %H:%M:%S' ); ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_MODIFIEDBY; ?></strong></td>
								<td><?php echo empty($row->modifier) ? '-' : $row->modifier ; ?> </td>
							</tr>
							<tr valign="top">
								<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_CURRENTSTATUS; ?></strong></td>
								<td><?php echo $status; ?> </td>
							</tr>
							</table>
						<?php
						$tabs->endTab();
						$tabs->startTab(_SERVERSTAT_APPEARANCE,"appearance-page");
						?>
							<table class="adminform">
							<tr valign="top">
								<th colspan="2">
								Appearance
								</th>
							<tr>
							<tr valign="top">
								<td colspan="2"><small><?php echo _SERVERSTAT_APPEARRENCE_INFO; ?></small>
								</td>
							</tr>
							<tr valign="top">
								<td><?php echo _SERVERSTAT_APPEARRENCE_SERVERIMAGE; ?></td>
								<td><?php echo $lists['images']; ?></td>
							</tr>
							<tr valign="top">
								<td><?php echo _SERVERSTAT_APPEARRENCE_DETAILSTEMPLATE; ?></td>
								<td><?php echo $lists['templates']; ?></td>
							</tr>
							</table>
						<?php
						$tabs->endTab();
						$tabs->startTab(_SERVERSTAT_LOGGING,"logging-page");
						?>
							<table class="adminform">
							<tr>
								<th colspan="2"><?php echo _SERVERSTAT_TABSERVERLOGGING; ?></th>
							<tr>
							<tr>
								<td colspan="2"><small><?php echo _SERVERSTAT_LOGGING_INFO; ?></small>
								</td>
							</tr>
							<tr>
								<td><?php echo _SERVERSTAT_LOGGING_ENABLE; ?></td>
								<td>
								<input type="checkbox" name="collectstats" value="1" <?php echo $row->collectstats ? 'checked="checked"' : ''; ?> />
								</td>
							</tr>
							<tr>
								<td><?php echo _SERVERSTAT_LOGGING_EMAILNOTIFICATION; ?></td>
								<td>
								<input type="checkbox" name="emailnotification" value="1" <?php echo $row->emailnotification ? 'checked="checked"' : ''; ?> />
								</td>
							</tr>
							<tr>
								<td><?php echo _SERVERSTAT_LOGGING_EMAIL; ?></td>
								<td>
								<input class="text" type="text" name="email" size="20" maxlength="100" value="<?php echo $row->email; ?>" />
								</td>
							</tr>
							</table>
						<?php
						$tabs->endTab();
						if ($serverstat_tweaking) {
							$tabs->startTab(_SERVERSTAT_TWEAKING,"tweaking-page");
						?>
							<table class="adminform">
							<tr>
								<th colspan="2"><?php echo _SERVERSTAT_TABSERVERRETRY; ?></th>
							<tr>
							<tr>
								<td colspan="2"><small><?php echo _SERVERSTAT_RETRY_INFO; ?></small>
								</td>
							</tr>
							<tr>
								<td><?php echo _SERVERSTAT_RETRYCOUNT; ?></td>
								<td>
								<input class="text" type="text" name="retrycount" size="2" maxlength="2" value="<?php echo number_format($row->retrycount, 0, '', ''); ?>">
								</td>
							</tr>
							<tr>
								<th colspan="2"><?php echo _SERVERSTAT_TABTIMEOUT; ?></th>
							<tr>
							<tr>
								<td colspan="2"><small><?php echo _SERVERSTAT_TIMEOUT_INFO; ?></small>
								</td>
							</tr>
							<tr>
								<td><?php echo _SERVERSTAT_TIMEOUT; ?></td>
								<td>
								<input class="text" type="text" name="timeout" size="7" maxlength="7" value="<?php echo number_format($row->timeout, 0, '', ''); ?>">
								</td>
							</tr>
							</table>
						<?php
							$tabs->endTab();
						} else {
							?>
							<input type="hidden" name="retrycount" value="<?php echo number_format($row->retrycount, 0, '', ''); ?>" />
							<input type="hidden" name="timeout" value="<?php echo number_format($row->timeout, 0, '', ''); ?>" />
							<?php
						} # End if
						$tabs->endPane();
						?>
						</td>
					</tr>
					</table>
				</td>
			</tr>
			</table>
		</td>
	</tr>
	</table>
	<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
	<input type="hidden" name="option" value="<?php echo $option;?>" />
	<input type="hidden" name="st" value="<?php echo $st;?>" />
	<input type="hidden" name="rm" value="<?php echo $rm;?>" />
	<input type="hidden" name="task" value="" />
	</form>
	<?php

	} # End function editServers

	/**
	  * Show the configuration for the serverstat module.
	  */
	function showConfig( $option) {
	global $mosConfig_absolute_path;
	require($mosConfig_absolute_path."/administrator/components/com_serverstat/config/config.serverstat.php");
?>

<script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
		var form = document.adminForm;

		if ( form.threshold.value.search(/\d{1,3}/) == -1 ) {
				alert( "Threshold must contain an numeric value!" );
				return;
		}

		if ( form.threshold.value < 0 ) {
				alert( "Logging interval must contain an value greater then 0!" );
				return;
		}

		if ( form.loginterval.value.search(/\d{1,3}/) == -1 ) {
				alert( "Logging interval must contain an numeric value!" );
				return;
		}

		if ( form.collectstats.checked && form.loginterval.value <= 0 ) {
				alert( "Logging interval must contain an value greater then 0!" );
				return;
		}

		if ( form.collectstats.checked && form.loginterval.value > 60 ) {
				alert( "max value of logging is 60 minutes!" );
				return;
		}

		if ( form.retrycount.value < 1 ) {
				alert( "Retry count must contain an value greater then 0!" );
				return;
		}

		if (pressbutton == 'cancel') {
			submitform( pressbutton );
			return;
		}

		submitform( pressbutton );
	}

	function slowservervars() {
		document.forms[0].actasserviceprovider.disabled = false
		document.forms[0].remotestatus.disabled = false

		if (document.forms[0].actasserviceprovider.checked) {
			document.forms[0].remotestatus.checked = false
			document.forms[0].remotestatus.disabled = true
		}

		if (document.forms[0].remotestatus.checked) {
			document.forms[0].actasserviceprovider.checked = false
			document.forms[0].actasserviceprovider.disabled = true
		}
	}
</script>

<!--
*    START OF SERVERSTAT CONFIG FORM
-->
<form action="index2.php" method="post" name="adminForm" id="adminForm">
<table class="adminheading">
<tr>
	<th>Serverstat - Configuration</th>
</tr>
</table>

<?php
$tabs = new mosTabs(1);

mosCommonHTML::loadOverlib();

$tabs->startPane("content-pane");
$tabs->startTab(_SERVERSTAT_APPEARANCE,"appearance-page");
?>
<table class="adminform">
<tr>
	<th colspan="4"><?php echo _SERVERSTAT_APPEARANCE; ?></th>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_THRESHOLD; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="threshold" size="3" maxlength="3" value="<?php echo number_format($serverstat_threshold); ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_TRESHHOLD, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#threshold") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_CONNECTBUTTON; ?></b></td>
	<td align="left">
	<input type="checkbox" name="connectbutton" value="1" <?php echo $serverstat_connectbutton ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_CONNECTBUTTON, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#connectbutton") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
</table>
<?php
$tabs->endTab();
$tabs->startTab(_SERVERSTAT_LOGGING,"logging-page");
?>
<table class="adminform">
<tr>
	<th colspan="4"><?php echo _SERVERSTAT_LOGGING; ?></th>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_LOGGING; ?></b></td>
	<td align="left">
	<input type="checkbox" name="collectstats" value="1" <?php echo $serverstat_collectstats ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_LOGGING, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_INTERVAL; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="loginterval" size="3" maxlength="3" value="<?php echo $serverstat_loginterval; ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_INTERVAL, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_JPGRAPH; ?></b></td>
	<td align="left">
	<?php 
	if (!ComponentVersion ("jpgraph")) {
		?>
		<input type="checkbox" name="jpgraph" value="0" disabled />
		<?php
	} else {
		?>
		<input type="checkbox" name="jpgraph" value="1" <?php echo $serverstat_jpgraph ? 'checked="checked"' : ''; ?> />
		<?php
	} # End if
	?>
	</td>
	<td>
	<?php 
	if (!ComponentVersion ("jpgraph")) {
		echo mosToolTip( _SERVERSTAT_TOOLTIP_JPGRAPH_NO, $title='', $width='', $image='tooltip.png', $text='', $href='#' );
	} else {
		echo mosToolTip( _SERVERSTAT_TOOLTIP_JPGRAPH_YES, $title='', $width='', $image='tooltip.png', $text='', $href='#' );
	} # End if
	 ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_LOGPUBLISHED; ?></b></td>
	<td align="left">
	<input type="checkbox" name="logpublished" value="1" <?php echo $serverstat_logpublished ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_LOGPUBLISHED, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_LOGREMOTE; ?></b></td>
	<td align="left">
	<input type="checkbox" name="logremote" value="1" <?php echo $serverstat_logremote ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_LOGREMOTE, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_DISABLEWHENLOGTHRESHOLDREACHED; ?></b></td>
	<td align="left">
	<input type="checkbox" name="disablewhenlogthresholdreached" value="1" <?php echo $serverstat_disablewhenlogthresholdreached ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_DISABLEWHENLOGTHRESHOLDREACHED, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_LOGTHRESHOLD; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="logthreshold" size="3" maxlength="3" value="<?php echo $serverstat_logthreshold; ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_LOGTHRESHOLD, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_LOGRETENTION; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="logretention" size="3" maxlength="3" value="<?php echo $serverstat_logretention; ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_LOGRETENTION, $title='', $width='', $image='tooltip.png', $text='', $href=HelpUrl ("_03_01_mainconfig.html#logging") ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
</table>
<?php
$tabs->endTab();
$tabs->startTab(_SERVERSTAT_MISCELLANEOUS,"misc-page");
?>
<table class="adminform">
<tr>
	<th colspan="4"><?php echo _SERVERSTAT_MISCELLANEOUS; ?></th>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_RETRYCOUNT; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="retrycount" size="1" maxlength="1" value="<?php echo $serverstat_retrycount; ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_RETRYCOUNT, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_TWEAKING; ?></b></td>
	<td align="left">
	<input type="checkbox" name="tweaking" value="1" <?php echo $serverstat_tweaking ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_TWEAKING, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_BACKENDCHECK; ?></b></td>
	<td align="left">
	<input type="checkbox" name="backendcheck" value="1" <?php echo $serverstat_backendcheck ? 'checked="checked"' : ''; ?> />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_BACKENDCHECK, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_URLMASTERMAPPACK; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="mastermappack" size="35" maxlength="50" value="<?php echo $serverstat_mastermappack; ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_URLMASTERMAPPACK, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
</table>
<?php
$tabs->endTab();
$tabs->startTab(_SERVERSTAT_REMOTESTATUS,"remotestatus-page");
?>
<table class="adminform">
<tr>
	<th colspan="4"><?php echo _SERVERSTAT_REMOTESTATUS; ?></th>
</tr>
<tr>
	<td colspan="2" valign="top" align="right"><font color="red"><small><strong><?php echo _SERVERSTAT_INFO_REMOTESTATUS; ?></strong></small></font><br></td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_ACTASSERVICEPROVIDER; ?></b></td>
	<td align="left">
	<input type="checkbox" name="actasserviceprovider" value="1" <?php echo $serverstat_actasserviceprovider ? 'checked="checked"' : ''; ?> onchange="slowservervars();" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_ACTASSERVICEPROVIDER, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_REMOTESTATUS; ?></b></td>
	<td align="left">
	<input type="checkbox" name="remotestatus" value="1" <?php echo $serverstat_remotestatus ? 'checked="checked"' : ''; ?> onchange="slowservervars();" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_REMOTESTATUS, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
<tr>
	<td valign="top" align="right" nowrap><b><?php echo _SERVERSTAT_CONFIG_SERVICEPROVIDER; ?></b></td>
	<td align="left">
	<input class="text" type="text" name="serviceprovider" size="35" maxlength="50" value="<?php echo $serverstat_serviceprovider; ?>" />
	</td>
	<td>
	<?php echo mosToolTip( _SERVERSTAT_TOOLTIP_SERVICEPROVIDER, $title='', $width='', $image='tooltip.png', $text='', $href='#' ); ?>
	</td>
	<td width="100%">
	&nbsp;
	</td>
</tr>
</table>
<?php
$tabs->endTab();
$tabs->endPane();
?>
<input type="hidden" name="id" value="">
<input type="hidden" name="task" value="">
<input type="hidden" name="option" value="<?php echo $option; ?>">
</form>
<?php
} # End function showConfig

/**
* Display the list of defined servers
*/
function showServerStatEntries( $option, &$rows, $pageNav ) {
global $my;
	?>

	<!--
	*    START OF SERVERLIST FORM (STATS)
	-->
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminheading">
	<tr>
		<th><?php echo _SERVERSTAT_BACKHEADER_STATS; ?> <small>[ <?php echo _SERVERSTAT_BACKHEADER_STATS_ALL;?> ]</small></th>
	</tr>
	</table>

	<!--
	*    START OF SERVERLIST, HEADER PART (COLUMNS)
	-->
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th class="title"><div align="left"><? echo _SERVERSTAT_STAT_SERVERNAME; ?></div></th>
		<th class="title"><div align="left"><? echo _SERVERSTAT_STAT_IP; ?></div></th>
		<th class="title"><div align="left"><? echo _SERVERSTAT_STAT_PORT; ?></div></th>
		<th class="title"><div align="left"><? echo _SERVERSTAT_STAT_TYPE; ?></div></th>
	</tr>

	<?php
	$k = 0;
	for ($i=0, $n=count( $rows ); $i < $n; $i++) {
		# Get current row, and set some vars for presentation for published status
		# for current server.
		$row = &$rows[$i];

		# Now we render the server detail record.
		echo "<tr class='row$k'>";
		echo "<td align='left'><a href=\"index2.php?option=".$option."&task=statshow&id=".$row->id."\">$row->servername</a></td>";
		?>
		<td align="left"><?php echo $row->ip; ?></td>
		<td align="left"><?php echo $row->port; ?></td>
		<td align="left"><?php echo getServerConfigVar ($row, "description")?></td>
	</tr>
	<?php $k = 1 - $k; } ?>
	</table>

	<?php echo $pageNav->getListFooter(); ?>

	<input type="hidden" name="option" value="<?php echo $option;?>" />
	<input type="hidden" name="task" value="stats" />
	<input type="hidden" name="boxchecked" value="0" />
	</form>

	<?php
} # End function showServerStatEntries

/**
* Display the list of defined servers
*/
function showStatsServer( $option, $id, $row, $type, &$stats, $lists, $server, $status, $graph ) {
	global $serverstat_jpgraph, $serverstat_classtreshhold, $mosConfig_live_site;

	mosCommonHTML::loadOverlib();
	mosCommonHTML::loadCalendar();
	$tabs = new mosTabs(1);
	?>
	<!--
	*    START OF SERVERLIST FORM (STATS)
	-->
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminheading">
	<tr>
		<th><?php echo _SERVERSTAT_BACKHEADER_STATS; ?> <small>[ <?php echo $row->servername;?> ]</small></th>
		<td align="right">
			<form action="index2.php" method="post" name="adminForm">
			<table cellpadding="0" cellspacing="5">
			<tr>
				<td><small><?php echo _SERVERSTAT_BACKHEADER_STATS_SERVER;?></small></td>
				<td colspan="2"><?php echo $lists['servers']; ?></td>
			</tr>
			<tr>
				<td align="left"><small><?php echo _SERVERSTAT_BACKHEADER_STATS_REPORDATE;?></small></td>
				<td align="left" nowrap>
				<input class="text_area" type="text" name="seldata" id="seldate" size="10" maxlength="19" value="<?php echo $lists['seldate']; ?>" />
				<input name="reset" type="reset" class="button" onClick="return showCalendar('seldate', 'y-mm-dd');" value="...">
				<input type="submit" name="Submit" value="Go">
				</td>
			</tr>
			</table>

			<input type="hidden" name="option" value="<?php echo $option;?>" />
			<input type="hidden" name="task" value="statshow" />
			</form>
		<td>
	</tr>
	</table>

	<!--
	*    START OF SERVERLIST STATISTICS, HEADER PART (COLUMNS)
	-->
	<?php
	$tabs->startPane("content-pane");
	$tabs->startTab(_SERVERSTAT_TABDETAILS,"appearance-page");
	?>
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_STAT_HOURS; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_USERS; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_MAXUSERS; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_USERLOAD; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_MINPING; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_MAXPING; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_AVGPING; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_STAT_CLASSTIMING; ?></div></th>
	</tr>
	<?php
	for ($i=0; $i < count($stats); $i++) {
		echo "<tr>";
		echo "<td align=\"left\">" . $stats[$i]['type'] . "</td>\n";
		echo "<td align=\"right\">" . $stats[$i]['users'] . "</td>\n";
		echo "<td align=\"right\">" . $stats[$i]['maxusers'] . "</td>\n";
		echo "<td align=\"right\">" . $stats[$i]['load'] . "</td>\n";
		echo "<td align=\"right\">" . $stats[$i]['pinglowest'] . "</td>\n";
		echo "<td align=\"right\">" . $stats[$i]['pinghighest'] . "</td>\n";
		echo "<td align=\"right\">" . $stats[$i]['pingavarage'] . "</td>\n";
		echo "<td align=\"right\">";

		if (is_numeric($stats[$i]['classtiming'])) {
			for ($j=0; $j<count($serverstat_classtreshhold); $j++) {
				$color =  $serverstat_classtreshhold[$j][1];
				if ($stats[$i]['classtiming'] < $serverstat_classtreshhold[$j][0]) {
					break;
				} # End if
			} # End for
			echo "<font color=\"$color\">" . $stats[$i]['classtiming'] . "</font>";
		} else {
			echo $stats[$i]['classtiming'];
		} # End if
		echo "</td>\n";
		echo "</tr>\n";
	} # End for
	?>
	</table>
	<?php
	$tabs->endTab();
	$tabs->startTab(_SERVERSTAT_TABSTATUS,"status-page");
	?>
	<table width="100%">
	<tr valign="top">
	<td width="50%">
		<table class="adminform">
		<tr valign="top">
			<th colspan="2"><div align="left"><?php echo _SERVERSTAT_BACKHEADER_STATS_PUBLISHINGINFO; ?></div></th>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_SERVERID; ?></strong></td>
			<td><?php echo $row->id; ?> </td>
		</tr>
		<tr valign="top">
			<td width="90px" valign="top" align="right"><strong><strong><?php echo _SERVERSTAT_PUBLISHED_STATE; ?></strong></td>
			<td>
			<?php echo $row->published > 0 ? 'Published' : 'Unpublished';?>
			</td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_VIEWS; ?></strong></td>
			<td><?php echo $row->views; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_HITS; ?></strong></td>
			<td><?php echo $row->hits; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_THRESHOLDCOUNTER; ?></strong></td>
			<td><?php echo $row->tcounter; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_CREATED; ?></strong></td>
			<td><?php echo mosFormatDate( $row->created, '%Y-%m-%d %H:%M:%S' ); ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_CREATEDBY; ?></strong></td>
			<td><?php echo empty($row->creator) ? '-' : $row->creator ; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_LASTMODIFIED; ?></strong></td>
			<td><?php echo mosFormatDate( $row->modified, '%Y-%m-%d %H:%M:%S' ); ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_MODIFIEDBY; ?></strong></td>
			<td><?php echo empty($row->modifier) ? '-' : $row->modifier ; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_CURRENTSTATUS; ?></strong></td>
			<td><?php echo $status; ?> </td>
		</tr>
		</table>
	</td>
	<td width="50%">
		<table class="adminform">
		<tr valign="top">
			<th colspan="2"><div align="left"><?php echo _SERVERSTAT_BACKHEADER_STATS_PUBLISHINGLOGINFO; ?></div></th>
		</tr>
		</table>
		<table class="adminform">
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_LOGENTRIES; ?></strong></td>
			<td><?php echo $lists['logcount']; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_LOGSTARTED; ?></strong></td>
			<td><?php echo $lists['logstart']; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_LASTLOG; ?></strong></td>
			<td><?php echo $lists['logend']; ?> </td>
		</tr>
		<tr valign="top">
			<td valign="top" align="right"><strong><?php echo _SERVERSTAT_PUBLISHED_LOGINTERVAL; ?></strong></td>
			<td><?php echo $lists['loginterval']; ?> </td>
		</tr>
		</table>
	</td>
	</tr>
	</table>
	<?php
	$tabs->endTab();
	if (ComponentVersion ("jpgraph") && $serverstat_jpgraph) {
		$tabs->startTab(_SERVERSTAT_TABGRAPHICAL,"jpgraph-page");
	?>
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_BACKHEADER_STATS_GRAPHICS; ?></div></th>
	</tr>
	<tr>
		<?php
		for ($i=0; $i<23; $i++) {
			$users .= $graph[$i]['users'] . ";";
			$maxusers .= $graph[$i]['maxusers'] . ";";
		} # End for

		$titleperformance = $lists['jpgraphusers'];
		$titlexaxis = $lists['titlexaxis'];
		$titleyaxis = $lists['titleyaxis'];
		?>
		<td><?php echo "<img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/jpgraph/bar.php?d0=$users&title=$titleperformance&titlexaxis=$titlexaxis\">\n"; ?></td>
	</tr>
	<tr>
		<?php
		for ($i=0; $i<23; $i++) {
			$minping .= $graph[$i]['pinglowest'] . ";";
			$maxping .= $graph[$i]['pinghighest'] . ";";
			$avgping .= $graph[$i]['pingavarage'] . ";";
		} # End for

		$lminping = $lists['lminping'];
		$lmaxping = $lists['lmaxping'];
		$lavgping = $lists['lavgping'];
		$titleperformance = $lists['jpgraphperformance'];
		$titlexaxis = $lists['titlexaxis'];
		$titleyaxis = $lists['titleyaxis'];
		?>
		<td><?php echo "<img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/jpgraph/line.php?minping=$minping&maxping=$maxping&avgping=$avgping&lminping=$lminping&lmaxping=$lmaxping&lavgping=$lavgping&title=$titleperformance&titlexaxis=$titlexaxis&titleyaxis=$titleyaxis\">\n"; ?></td>
	</tr>
	<tr>
		<?php
		for ($i=0; $i<23; $i++) {
			$classtiming .= $graph[$i]['classtiming'] . ";";
		} # End for

		$lminping = $lists['lclasstiming'];
		$titleperformance = $lists['jpgraphperformance'];
		$titleclassformance = $lists['jpgraphclassformance'];
		$titlexaxis = $lists['titlexaxis'];
		$titleyaxis = $lists['titleyaxis'];
		$titleyaxisclass = $lists['titleyaxisclass'];
		?>
		<td><?php echo "<img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/jpgraph/line2.php?classtiming=$classtiming&title=$titleclassformance&titlexaxis=$titlexaxis&titleyaxisclass=$titleyaxisclass\">\n"; ?></td>
	</tr>
	<tr>
	</tr>
	</table>
	<?php
		$tabs->endTab();
	} # End if
	$tabs->endPane();

} # End function showStatsServer

/**
* The help function...
*/
function showHelpScreen ( $toc, $helpsearch, $page, $helpurl ) {
	global $serverstat_version, $mosConfig_live_site;

?>
	<style type="text/css">
	.helpIndex {
		border: 0px;
		width: 95%;
		height: 100%;
		padding: 0px 5px 0px 10px;
		overflow: auto;
	}

	.helpFrame {
		border-left: 0px solid #222;
		border-right: none;
		border-top: none;
		border-bottom: none;
		width: 100%;
		height: 600px;
		padding: 0px 5px 0px 10px;
	}
	</style>

	<form name="adminForm">
	<table class="adminform" border="1" width="100%">
	<tr>
		<th colspan="2" class="title" width="100%"><?php echo _SERVERSTAT_HELP_HEADER; ?></th>
	</tr>
	<tr>
		<td colspan="2" width="100%">
			<table width="100%">
			<tr>
				<td>
				<strong>Search:</strong>
				<input class="text_area" type="hidden" name="option" value="com_serverstat" />
				<input type="text" name="helpsearch" value="<?php echo $helpsearch;?>" class="inputbox" />
				<input type="submit" value="<?php echo _SERVERSTAT_HELP_BUTTON_GO; ?>" class="button" />
				<input type="button" value="<?php echo _SERVERSTAT_HELP_BUTTON_CLEAR; ?>" class="button" onclick="f=document.adminForm;f.helpsearch.value='';f.submit()" />
				</td>
				<td style="text-align:right">
					<a href="<?php echo $helpurl; ?>credits.html" target="helpFrame"><?php echo _SERVERSTAT_HELP_CREDITS; ?></a>
					|
					<a href="<?php echo $helpurl; ?>_01_04_support.html" target="helpFrame"><?php echo _SERVERSTAT_HELP_SUPPORT; ?></a>
					|
					<a href="http://www.gnu.org/copyleft/gpl.html" target="helpFrame"><?php echo _SERVERSTAT_HELP_LICENCE; ?></a>
					|
					<a href="<?php echo $mosConfig_live_site;?>/administrator/index2.php?option=com_admin&task=sysinfo&no_html=1" target="helpFrame"><?php echo _SERVERSTAT_HELP_SYSTEMINFO; ?></a>
				</td>
			</tr>
			</table>
		</td>
	</tr>
	<tr valign="top">
		<td width="25%" valign="top">
			<strong>Index</strong>
			<div class="helpIndex">
			<?php
			foreach ($toc as $k=>$v) {
				if ($helpurl) {
					echo '<br /><a href="' . $helpurl . urlencode( $k ) . '" target="helpFrame">' . $v . '</a>';
				} else {
					echo '<br /><a href="' . $mosConfig_live_site . '/administrator/components/com_serverstat/' . $k . '" target="helpFrame">' . $v . '</a>';
				}
			}
			?>
			</div>
		</td>
		<td valign="top" width="75%">
			<iframe name="helpFrame" src="<?php echo $helpurl . $page;?>" class="helpFrame" frameborder="0" /></iframe>
		</td>
	</tr>
	</table>
		
	<input type="hidden" name="task" value="help" />
	</form>
<?php
} # End function showHelpScreen

/**
* Render all mappacks that are read from the mappack.xml file
* that resides on the master server specified in the main
* configuration.
*/
function showMapPack ( $option, $mappack ) {
	?>

	<!--
	*    START OF SERVERLIST FORM
	-->
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminheading">
	<tr>
		<th><?php echo _SERVERSTAT_MAPPACK_ALL; ?></small></th>
	</tr>
	</table>

	<!--
	*    START OF SERVERLIST, HEADER PART (COLUMNS)
	-->
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<tr>
		<th width="2%" class="title"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $mappack->mappackdetail ) + 1; ?>);" /></th>
		<th class="title"><div align="left"><?php echo _SERVERSTAT_MAPPACK_DESCRIPTION; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_MAPPACK_VERSION; ?></div></th>
		<th class="title"><div align="right"><?php echo _SERVERSTAT_MAPPACK_STATUS; ?></div></th>
	</tr>

	<?php
	if ($mappack->err) {
		echo "<tr><td colspan=\"4\"><font color=\"red\">" .  $mappack->errmsg . "</font></td></tr>\n";
	} else {
		$i=0;
		foreach ($mappack->mappackdetail as $servertype => $array) {
			echo "<tr>\n";
			echo "<td>" . mosHTML::idBox( $array['id'], $servertype ) . "</td>\n";
			echo "<td nowrap>" . $array['description'] . "</td>\n";
			echo "<td align=\"right\">" . $mappack->mappackdetail[$servertype]['version'] . "</td>\n";
			echo "<td align=\"right\">";
			if (!$array['status']) {
				echo _SERVERSTAT_MAPPACK_MAPNOTINSTALLED; 
			} else {
				if ($mappack->mappackdetail[$servertype]['version'] <= $array['status']) {
					echo str_replace ("[version]" , $array['status'], _SERVERSTAT_MAPPACK_INSTALLED );
				} else {
					echo str_replace ("[version]" , $array['status'], _SERVERSTAT_MAPPACK_INSTALLEDUPGRADE );
				} # End if
			} # End if
  			echo"</td>\n";
			echo "</tr>\n";
			$i++;
		} # End foreach
	} # End if
	?>
	</table>

	<input type="hidden" name="option" value="<?php echo $option;?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<?php
} # End function showMapPack

/**
* Show the result of the install/remove actions for a mappack.
*/
function showMapPackResult ( $result ) {
	?>

	<!--
	*    START OF MAPPACK RESULT PAGE
	-->
	<table class="adminheading">
	<tr>
		<th><?php echo _SERVERSTAT_MAPPACK_RESULTS; ?></small></th>
	</tr>
	</table>

	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	<?php
	$k = 0;
	for ($i=0; $i < count ( $result ); $i++) {
		echo "<tr class='row$k'>";
		echo "<td align='left'>" . $result[$i] . "</td>";
		echo "</tr>\n";
		$k = 1 - $k;
	} # End for
	?>
	</table>
	<?php		
} # End function showMapPackResult

/**
* Information about this module.
*/
function showAbout( $helpurl ) {
	global $serverstat_version, $mosConfig_live_site;
?>
	<style type="text/css">
	.helpIndex {
		border: 0px;
		width: 95%;
		height: 100%;
		padding: 0px 5px 0px 10px;
		overflow: auto;
	}

	.helpFrame {
		border-left: 0px solid #222;
		border-right: none;
		border-top: none;
		border-bottom: none;
		width: 100%;
		height: 600px;
		padding: 0px 5px 0px 10px;
	}
	</style>

	<table cellpadding="4" cellspacing="0" border="0" width="100%">
	<tr valign="top">
		<td width="100%">
		<img src="<?php echo $mosConfig_live_site;?>/components/com_serverstat/images/logo.png" align="absmiddle" style="margin-right:10px;" width="150" height="150">
		<font style="color: #FF9E31;font-size : 18px;font-weight: bold;text-align: left;">Serverstat version <?php echo $serverstat_version; ?></font>
		</td>
	</tr>
	<tr>
		<td width="100%">
			<iframe width="100%" name="helpFrame" src="<?php echo $helpurl . "/credits.html"; ?>" class="helpFrame" frameborder="0" /></iframe>
		</td>
	</tr>
   	</table>
<?php
  }

/*
* Render the result for the map-pack generation.
*/
function generateMapPackXML ( $result ) {
	echo "<table class=\"adminheading\">\n";
	echo "<tr>\n";
	echo "<th>Results for map-pack generation</small></th>\n";
	echo "</tr>\n";

	for ($i=0; $i < count ($result); $i++) {
		echo "<tr><td>" . $result[$i] . "</td></tr>\n";
	} # End if
	echo "</table>\n";
} # End function generateMapPackXML

}?>