<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.FTP.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for a ftp server.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class Ftp extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = 21;								# Port to query
	var $timeout = 500000;							# Timeout in microsecond (huge for ftp!!!)
										# Use slow server option for this kinda servers!
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = "";							# Contains server information: not used!
	var $numofusers = 0;							# Number of users: not used!

	var $serveronline = false;						# Local flag

	/**
	* Constructor.
	*/
	function Ftp ($serverip, $port, $debug, $retrycount, $timeout) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("Ftp::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$i=0;
		do {
			$this->socket = $this->getSocket($this->serverip, $this->port);
			if ($this->socket) {					# Interact with webserver
				$this->serveronline = true;
				$this->closeSocket($this->socket);		# Also close the connection
			} else {
				$this->serveronline = false;
			} # End if;		
			$i++;
		} while (!$this->socket && $i < $this->retry);			# Retry, sometimes server does not respond that fast :D
	} # End function Webserver

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		return $this->serveronline;
	} # End function IsServerRunning

	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format(0);
	} # End function getUsersOnline

	/**
	* Return the maximum number of clients that may connect to this server.
	* For a webserver we cannot retrieve the maximum number of users (makes
	* no sense), so we return 0 here.
	*/
	function getMaxClients () {
		return number_format(0);
	} # End function getMaxClients

	/**
	* Return the operating system the server is running on. We do not have
	* any clue of the OS we are going to, just return "Unknown".
	*/
	function getOSRunning () {
		return "unknown";
	} # End function getOSRunning

	/**
	* Return lowest found ping for an user.
	*/
	function getPingLowest() {
		return number_format(0);
	} # End function getPingLowest

	/**
	* Return highest found ping for an user.
	*/
	function getPingHighest () {
		return number_format(0);
	} # End function getPingHighest

	/**
	* Return avarage found ping for an user.
	*/
	function getPingAvarage () {
		return number_format(0);
	} # End function getPingAvarage

	/**
	* Opens a connection to the server.
	*/
	function getSocket($ip, $port) {
		$this->trace ("Ftp::_getSocket ()", "timeout: " . $this->timeout . " (=" . $this->timeout / 100000 . " sec.)", 1, 0);
		return @ftp_connect ($ip, $port, $this->timeout / 100000);
	} # End function getSocket

	/**
	* Closes the connection to the server.
	*/
	function closeSocket($socket) {
		$this->trace ("Ftp::_closeSocket ()", "", 9, 0);
		@ftp_close ($socket);
	} # end function closeSocket(...)

} # End class Ftp
?>