<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.GS.class.php,v 0.6 2005/12/17 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific code for retrieving the status for gameservers
* using the gamespy protocol. Parts of the code have been taken from the KjStat
* v0.87 (beta, public) package that was developed by Sam 'KingJackaL' Evans.
* (This class has been altered quite a lot for usage within Serverstat)
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class Gamespy extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $gametype = "";

	/**
	* Constructor.
	*/
	function Gamespy ($serverip, $port, $debug, $retrycount, $timeout, $gametype) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if
		$this->gametype = $gametype;

		# Here we go!
		$this->trace("Gamespy::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);		# Interact with gameserver
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("Gamespy::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
	} # End constructor Gamespy

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("Gamespy::_getServerStatus ()", "", 0, 0);

		$this->serverdata['num_team1'] = 0;
		$this->serverdata['num_team2'] = 0;
		$this->serverdata['num_total'] = 0;

		# configure stream
		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)

		# Array of commands we want to try here.
		$commands = array("\\info\\",
		                  "\\rules\\"
		                 );
	
		# parses in the /info/ and /rules/ replies
		# while(list(, $curquery) = each($queries) {
		foreach($commands as $curquery) {
			$gotfinal = false;
			fwrite($socket, $curquery);				# Interact with command
			$this->trace ("Gamespy::getServerStatus ()", $curquery, 1, 1);
			while(!$gotfinal) {
				if (!($this->result = @fread($socket, 4096))) {
					$this->err = 110;
					$this->errmsg = "No data from stream";
					$this->trace ("Gamespy::getServerStatus ()", "ERR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
					return false;
				} # End if

				$this->trace ("Gamespy::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
				$this->trace ("Gamespy::getServerStatus ()", $this->result, 2, 1);

				# Split up the result
				$splitup = explode("\\", $this->result);
				array_shift($splitup); 				# get rid of first '/'
				while (list(, $key) = each($splitup)) {
					list(, $data) = each($splitup);

					if ($key == "final") {
						$gotfinal = true;
					} else {
						$this->serverdata["$key"] = $data;
					} # End if
				} # End while (settings)
			} # End if (packets)
		} # End foreach (queries)

		# parse players command to socket, and read all player data.
		$gotfinal = false;
		$gotall = false;

		$packetsRecieved = array(); 					# array to check if the fragmented packets are all re-assembled.
		$finalPacketNumber = 0;

		$curquery = "\\players\\";
		fwrite($socket, $curquery);					# Interact with command
		$this->trace ("Gamespy::getServerStatus ()", $curquery, 1, 1);

		while(!$gotall) {
			$currentpacket = 0;

			# fux - MISSING A BLOODY PACKET YOU USELESS PROTOCOL! XD
			# patch up by sending everything we've got so far :/
			if (!($this->result = @fread($socket, 4096))) {
				$this->trace ("Gamespy::getServerStatus ()", "Packets lost - scan may not be complete!", 0, 0);
				break;
			} # End while

			$this->trace ("Gamespy::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
			$this->trace ("Gamespy::getServerStatus ()", $this->result, 2, 1);

			$splitup = explode("\\", $this->result);
			array_shift($splitup); 					# get rid of first '/'
			while (list(, $setting) = each($splitup)) {		# walk thru keys
				list(, $value) = each($splitup);		# and values

				#print "$setting = $value     ($field with key $key)<br>";
				$settingindex = explode("_", $setting);	# get player slot
				$field = $settingindex[0];


				if ($setting == 'queryid') { 			# put in packetsRecieved array
					$queryid = explode(".", $value);	# the right part contains query id, store in
					$currentpacket = $queryid[1];		# packet number
					$packetsRecieved[$currentpacket] = true;
					continue;
				} elseif ($setting == 'final') {
					$gotfinal = true;
					continue;
				} elseif ($field == "teamname") {
					$k = $key + 1;
					$this->serverdata[$field.$k] = $value;
					continue;
				} else {
					$key = $settingindex[1];		# Only applies if no q queryid or final response returned

					# new entry?
					if (!(array_key_exists($key, $this->userinfo))) {
						$this->userinfo[$key] = array();
						$this->userinfo[$key]['score'] = "0";
						$this->numofusers++;
					} # End if

					# count players per team
					if ($field == "team") {
						if (!(array_key_exists('num_team' . $value, $this->serverdata))) {
							$this->serverdata['num_team' . $value] = 0;
						} # End if
						$this->serverdata['num_team' . $value]++;
					} # End if

					$this->userinfo[$key][$field] = $value;
					
					#print "$key  -->  $field  == $value <br>";
				} # End if (player setting)
			} # End while (player packet parsed)

			if ($gotfinal && $finalPacketNumber == 0)
				$finalPacketNumber = $currentpacket;

			$this->trace ("Gamespy::getServerStatus ()", "Gotfinal is: $gotfinal", 1, 0);
			$this->trace ("Gamespy::getServerStatus ()", "finalPacketNumber is: $finalPacketNumber", 1, 0);
			$this->trace ("Gamespy::getServerStatus ()", "gotall is: $gotall", 1, 0);
			$this->trace ("Gamespy::getServerStatus ()", "currentpacket is: $currentpacket", 1, 0);

			# checks to ensure we have got all the fragmented player packets
			if ($gotfinal) {
				$anotherPacketNeeded = false;
				for ($i = 1; $i < $finalPacketNumber; $i++) {
					if (!array_key_exists($i, $packetsRecieved)) {
						$anotherPacketNeeded = true;
					} # End if
				} # End for

				if (!($anotherPacketNeeded)) {
					$gotall = true;
				} # End if
			} # End if

			$this->trace ("Gamespy::getServerStatus ()", "gotall is: $gotall", 1, 0);
		} # End while (player packets parsed)

		# cos I have nfi what BF's 'numplayers' var actually does :/
		if (!(array_key_exists('num_total', $this->serverdata))) {
			$this->serverdata['num_total'] = 0;
		} # End if

		if($this->serverdata['num_team1'] + $this->serverdata['num_team2'] > $this->serverdata['num_total'])
			$this->serverdata['num_total'] = $this->serverdata['num_team1'] + $this->serverdata['num_team2'];

		if(array_key_exists('mod', $this->serverdata)) {
			if ($this->serverdata['mod'] == "") {
				$this->serverdata['mod'] = "default";
			} # End if
		} else {
			$this->serverdata['mod'] = "";
		} # End if

		return true;
	} # End function getServerStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("Gamespy::_IsServerRunning ()", "", 0, 0);

		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		$this->trace ("Gamespy::_getMaxClients ()", "", 0, 0);
		return number_format($this->serverdata['maxplayers']);
	} # End function getMaxClients
} # End class Gamespy
?>