<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.GS2.class.php,v 0.6 2005/12/30 21:15:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific code for retrieving the status for gameservers
* using the gamespy 2 protocol. Parts of the code have been taken from the KjStat
* v0.87 (beta, public) package that was developed by Sam 'KingJackaL' Evans.
* (This class has been altered quite a lot for usage within Serverstat and support
* for Battlefield 2 Servers).
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

class Gamespy2 extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $numofusers = 0;							# Number of players on server

	# Miscelanious properties
	var $playervars = Array();						# Holds player variables used
	var $queryresponse = 0;							# Holds numeric value of response string detected
	var $queryresponsestring = "";						# Holds string value of response string detected

	/**
	* Constructor.
	*/
	function Gamespy2 ($serverip, $port, $debug, $retrycount, $timeout, $servertype) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if

		# Here we go!
		$this->trace("Gamespy2::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data
		$this->servertype = $servertype;

		$this->socket = $this->getSocket($this->serverip, $this->port);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("Gamespy2::_constructor", "ERROR: could not open scoket (error: " . $this->err . "&nbsp;" . $this->errmsg . ")", 0, 0);
		} # End if
	} # End constructor Gamespy2

	/*
	* Additional variables to handle gamespy2 header logic. We have values per game
	* here to determine the proper values.
	*/
	function _getPlayerVars ( $servertype ) {
		$gamespy2vars = Array ('AA'    => Array ('leader' => 'leader', 'goal' => 'goal', 'honor' => 'honor', 'player' => 'name', 'ping' => 'ping', 'roe' => 'roe', 'kia' => 'kia', 'enemy' => 'score'),
		                       'BFV'   => Array ('player' => 'name', 'score' => 'score', 'deaths' => 'deaths', 'ping' => 'ping', 'team' => 'team', 'kills' => 'kills'),
                                       'BF2'   => Array ('player_' => 'name', 'score_' => 'score', 'ping_' => 'ping', 'team_' => 'team', 'deaths_' => 'kills', 'pid_' => 'pid', 'skill_' => 'skill', 'team_t' => 'team_t', 'score_t' => 'score_t'),
                                       'HALO'  => Array ('player' => 'name', 'score' => 'score', 'ping' => 'ping', 'team' => 'team'),
                                       'PK'    => Array ('player' => 'name', 'score' => 'score', 'deaths' => 'deaths', 'ping' => 'ping', 'team' => 'team'),
                                      );

		reset ($gamespy2vars);
		$gs2=false;
		while (list($server, $element) = each($gamespy2vars)) {
			if ($server == $servertype) {
				$gs2 = $element;
			} # End if
		} # End while
		
		return $gs2;
	} # End function _getPlayerVars

	/*
	* Determine which response we have. Returns false if response string
	* not found, else the numeric value of the response string.
	*/
	function _setQueryResponse ($result) {
		# The response codes that are valid. Remember that response
		# codes can overlap each other.
		$response = Array (0 => Array ("\x00STATsplitnum\x00\x00\x00"),		# 0 = query response new type: general info + players (part 1)
		                   1 => Array ("\x00STATsplitnum\x00\x82\x01"),		# 1 = query response new type: skill+team info *ignored here*
		                   2 => Array ("\x00STATsplitnum\x00\x01\x01"),		# 2 = query response new type: player+score+ping+team+deaths+pid+skill
		                   3 => Array ("\x00STAT\x00player_\x00"),		# 3 = query response old type: players
		                   4 => Array ("\x00STAT")				# 4 = query response old type: general info
		                   );

		reset ($response);
		while (list($key, $element) = each($response)) {
			if(substr($result, 0, strlen($element[0])) == $element[0]) {
				$this->queryresponse = $key;
				$this->queryresponsestring = $element[0];
				return true;
			} # End if
		} # While
		return false;
	} # End function

	/*
	* Handle query response type for basic Gamespy 2 protocol
	*/
	function _handleResponseTypeGS2 ( $result ) {
		$this->playervars = $this->_getPlayerVars($this->servertype);

		for ($i=0; $i<count($result);$i++) {
			$this->_setQueryResponse ($result[$i]);

			switch ($i) {
			case 0: # walk thru information and save server variables.
				$j=5;
				$infodone = false;
				while(!$infodone) {
					$varlength = strpos($result[$i], "\x00", $j) - $j;
					$varvalue = substr($result[$i], $j, $varlength);
					$j += $varlength + 1;

					$valuelength = strpos($result[$i], "\x00", $j) - $j;
					$data = substr($result[$i], $j, $valuelength);
					$j += $valuelength + 1;

					if (empty($varvalue)) {
						$infodone = true;
					} else {
						$this->serverdata[$varvalue] = $data;
					} # End if
				} # End while (server info)
				break;

			case 1: # Determine player information
				$j=7;

				# In gamespy server the user fields are in the "header" of the
				# response, we walk thru this header to get the field info, just
				# to determine where the player info really starts.
				while(list($playervar) = each($this->playervars)) {
					$varlength = strpos($result[$i], "\x00", $j) - $j;
					$varvalue = substr($result[$i], $j, $varlength - 1);

					$this->trace ("Gamespy2::getServerStatus ()", "found header item: " . $varvalue . " on position $j with length " . $varlength, 1, 0);
					$j += $varlength + 1;
				} # End while
				reset($this->playervars);
				$j++;

				do {
					$playerfound = false;
					while(list($playervar, $playerval) = each($this->playervars)) {
						$varlength = strpos($result[$i], "\x00", $j) - $j;
						$varvalue = substr($result[$i], $j, $varlength);
						$j += $varlength + 1;
						if ($varlength !=0) {
							$this->userinfo[$this->numofusers][$playerval] = $varvalue;
							$playerfound = true;
						} # End if
					} # End while
					reset($this->playervars);

					if ($playerfound) {
						$this->numofusers++;
					} # End if
				} while($j < strlen($result[$i]));
				break;
			} # End switch
		} # End for
	} # End function _handleResponseTypeGS2

	/*
	* Handle query response type for extented Gamespy 2 protocol, currently
	* only tested for Battlefield 2 servers (only servertype that handles
	# this protocol as far as i know).
	*/
	function _handleResponseTypeGS2Extened ( $result ) {
		$this->trace ("Gamespy2::_handleResponseTypeGS2Extened ()", "_start", 0, 0);

		# Some variables we need further on...
		$vars = $this->_getPlayerVars ( $this->servertype );
		$sections = Array();
		$target = Array();
		reset ($vars);
		while (list($selement, $telement) = each($vars)) {
			$sections[] = $selement;				# Source
			$target[] = $telement;					# Target
		} # End while

		# With the extended Gamespy 2 protocol response packets are
		# returned in fragments, and the order of in which the come
		# can also differ per query...the bloke who build this needs
		# to be shot! Ok, back on track, we first need to do some
		# ordering here before we proceed. For this we just use a
		# bubble sort routine (binary sort).
		$response = "\x00STATsplitnum\x00";
		$count = count ($result);
		do {
			$sort = false;
			for ($i=0; $i < $count-1; $i++) {
				if (substr($result[$i], strlen($response), 2) > substr($result[$i+1], strlen($response), 2)) {
					$swap = $result[$i];
					$result[$i] = $result[$i+1];
					$result[$i+1] = $swap;
					$sort = true;
				} # End if
			} # End for
		} while ($sort);

		# We have sorted the packages out, now we handle another weird
		# aspect of the packet handling. Maximum packet size is 1400
		# bytes (which moron has made this?), so we can have incomplete
		# packages. We just need to put those together to one complete
		# string, after this we can handle the server and player
		# values.
		$i=0;
		$completeresult = "";						# The result after pasting response packets to one complete packet
		$cpacket = true;						# Complete package indicator: true/false
		$start = 0;							# Counter from where we need to copy/paste
		do {
			# First we cut off the response tag of the packet.
			$packet = substr($result[$i], strlen("\x00STATsplitnum\x00")+2);

			# If we have a packet we need to check the section that
			# comes thru. If the packet for instance begins with the
			# "pid_" section, we need to strip of that part in the 
			# code that comes next.
			if ($i>0 && !$cpacket) {
				for ($j=0; $j<count($sections); $j++) {
					if (substr($packet, 0, strlen($sections[$j])+1) == $sections[$j] . "\x00") {
						$packet = substr($packet, strlen($sections[$j]) + 2);
						break;
					} # End if
				} # End for
			} # End if

			# Depending on the completeness of the packet, we can determine
			# the action to cut of some of the current result packet, if the
			# packet was incomplete, just chop of the last field...
			if (!$cpacket) {
				$array = explode (chr(0), $completeresult);
				array_pop ($array);
				array_pop ($array);
				$completeresult = implode (chr(0), $array). chr(0);
			}  # End if

			# Determine the complete package result
			$completeresult .= $packet;

			# Determine if current package is a complete package,
			# this info will be used
			if (substr($packet, strlen($packet) - 3, 2) == "\x00\x00") { $cpacket = true; } else { $cpacket = false; }

			$i++;
		} While ($i<count($result));

		# before we can handle the complete resultstring here, we first
		# need to clean up some rubbish that has been left.
		$completeresult = str_replace ("\x00\x00\x01", "\x00", $completeresult);
		$completeresult = str_replace ("\x00\x00\x02", "\x00", $completeresult);

		$this->trace ("Gamespy2::getServerStatus ()", "Total bytes in complete package (result after processing packet stream): " . strlen($completeresult), 1, 0);
		$this->trace ("Gamespy2::getServerStatus ()", $completeresult, 2, 1);

		# Pffffff. Now we have come so far, we just handle all values here,
		# split the string up into chunks.
		$chunks = Array();
		$start=0;
		for ($i=0; $i<count($sections);$i++) {
			$end = strpos($completeresult, $sections[$i]);
			$chunks[$i] = substr ($completeresult, $start, $end - $start);
			$start = $end;
		} # End for
		$chunks[] = substr ($completeresult, $start, strlen($completeresult) - $start);

		# Just leave this for debugging purposes...
		for ($i=0; $i<count($chunks);$i++) {
			$this->trace ("Gamespy2::chunk $i", $chunks[$i], 2, 1);
		} # End for

		# Almost there...just process those chunks into the proper properties
		for ($i=0; $i<count($chunks);$i++) {
			if ($i>0) { $chunks[$i] = str_replace ("\x00\x00", "\x00", $chunks[$i]); }
			$array = explode (chr(0), $chunks[$i]);

			switch ($i) {
			case 0:							# Server variables
				for ($j=0; $j<count($array)+2;$j=$j+2) {
					$this->serverdata[$array[$j]] = $array[$j+1];
				} # End for
				break;
			default:						# Player variables
				array_shift($array);			
				$this->trace ("Gamespy2::$i == count", count($array), 2, 0);
				for ($j=0; $j<count($array);$j++) {

					$this->userinfo[$j][$target[$i-1]] = $array[$j];
					if ($i==1 && !empty($array[$j])) { $this->numofusers++; }
				} # End for
				break;
			} # End switch
		} # End 

		$this->trace ("Gamespy2::_handleResponseTypeGS2Extened ()", "_end", 0, 0);
	} # End function _handleResponseTypeGS2Extened

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		$this->trace ("Gamespy2::_getServerStatus ()", "", 0, 0);

		# Configure stream
		socket_set_blocking ($socket, true);				# Set blocking mode...wait until we have an reaction
		socket_set_timeout ($socket, $this->timeout / 100000);		# Set the timeout (in microseconds here!)

		# Determine the query strings.
		switch ($this->servertype) {
		case "BF2":
			$query[] = "\xfe\xfd\x00STAT\xff\xff\xff\x01";		# Full status for BF2 games
			break;			
		default:
			$query[] = "\xfe\xfd\x00STAT\xff\x00\x00";		# Status/rules
			$query[] = "\xfe\xfd\x00STAT\x00\xff\x00";		# Player info
			break;
		} # End switch

		# Handle all query strings needed
		$this->trace ("Gamespy2::getServerStatus ()", "Start interaction with server...", 1, 0);
		$packetcount = 0;
		$this->result = Array();
		for ($i=0; $i<count($query); $i++) {
			# Start interacting with current query string
			$command = $query[$i];					# Command to interact with gameserver
			$this->trace ("Gamespy2::getServerStatus ()", "Query command used :", 1, 1);
			$this->trace ("Gamespy2::getServerStatus ()", $command, 1, 1);
			fwrite($socket, $command);				# Interact with command

			# Just read-out the stream, return when stream cannot be read.
			do {
				$result = @fread($socket, 4096);
				if (!empty($result)) {
					$this->result[] .= $result;
					$this->trace ("Gamespy2::getServerStatus ()", "bytes read : " . strlen($result), 1, 0);
					$this->trace ("Gamespy2::getServerStatus ()", $result, 2, 1);
					$packetcount++;
				} # End if
			} while (strlen($result) > 0); 

			# Did we get any result? If not, throw error...
			if ($packetcount == 0) {
				$this->err = 110;
				$this->errmsg = "No data from stream";
				$this->trace ("Gamespy2::getServerStatus ()", "ERROR: stream cannot be read after query interaction (error: " . $this->err . "&nbsp;" . $this->errmsg . ")", 0, 0);
				return false;
			} # End if
		} # End for

		# Data has been read, now check if we have valid query
		# responses (just checking).
		$this->trace ("Gamespy2::getServerStatus ()", "Packets retrieved : " . $packetcount, 1, 0);

		for ($j=0; $j<$packetcount; $j++) {
			if (!$this->_setQueryResponse ($this->result[$j])) {
				$this->err = 120;
				$this->errmsg = "Bad query response";
				$this->trace ("Gamespy2::getServerStatus ()", "ERROR: " . $this->err . "&nbsp;" . $this->errmsg , 0, 0);
				return false;
			} # End if
		} # End for
			
		$this->online = true;

		# Now go to work, just handle the results here.
		switch ($this->servertype) {
		case "BF2":
			$this->_handleResponseTypeGS2Extened ( $this->result );
			break;			
		default:
			$this->_handleResponseTypeGS2 ( $this->result );
			break;
		} # End switch

		return true;
	} # End function getServerStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("Gamespy2::_IsServerRunning ()", "", 0, 0);
		return $this->online;
	} # End function IsServerRunning 

	/**
	* Return the maximum number of clients that may connect to this server.
	*/
	function getMaxClients () {
		$this->trace ("Gamespy2::_getMaxClients ()", "", 0, 0);
		return number_format($this->serverdata['maxplayers']);
	} # End function getMaxClients
} # End class Gamespy2
?>