<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: serverstat.ICE.class.php,v 0.4 2005/12/17 22:30:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Class that holds the specific game code for an Icecast server.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

defined('_VALID_MOS') or die('Direct access to this location is not allowed.');

require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );

class Icecast extends ServerMain {
	/**
	* Properties.
	*/
	var $serverip = "localhost";						# Ip addr for server to query
	var $port = "29253";							# Port to query
	var $timeout = 160000;							# Timeout in microsecond
	var $retry = 3;

	var $socket = "";							# Socket var...
	var $err = 0;								# Error code, set when an error has occured
	var $errmsg = "";							# Error message...

	var $result = "";							# The result of a status request to the gameserver
	var $serverdata = Array();						# Contains server information
	var $userinfo = Array();						# Contains player information
	var $numofusers = 0;							# Number of players on server

	var $username;								# Username to connect to icecast server
	var $password;								# Password to connect to icecast server

	/**
	* Constructor.
	*/
	function Icecast ($serverip, $port, $debug, $retrycount, $timeout, $username, $password) {
		# Variable settings
		$this->debug = $debug;
		$this->retry = $retrycount;
		if ($timeout > 0) {
			$this->timeout = $timeout;				# Override default value when >0
		} #End if
		$this->username = $username;
		$this->password = $password;

		# Here we go! (do not show username and password)
		$this->trace("Icecast::_constructor", "serverip:$serverip  port:$port  retrycount:" . $this->retry . "  timeout:" . $this->timeout, 0, 0);
		$this->serverip = $serverip;                                    # Initialize properties
		$this->port = $port;
		$this->result = "";						# Contains server respons data

		$this->socket = $this->getSocket($this->serverip, $this->port, $this->username, $this->password);
		if ($this->socket) {
			$i=0;
			do {
				$this->getServerStatus($this->socket);
				$i++;
			} while (empty($this->result) && $i < $this->retry);	# Retry, sometimes server does not respond that fast :D
			$this->closeSocket($this->socket);			# Also close the connection
		} else {
			$this->trace("Icecast::_constructor", "ERR: " . $this->err . "&nbsp;" . $this->errmsg, 0, 0);
		} # End if
	} # End constructor Icecast

	/**
	* Opens a connection to the server, overrides the default class because
	* icecast servers expect a userid and password. And yes, we use the
	* fopen command here, we don't read the socket.
	*/
	function getSocket($ip, $port, $username, $password) {
		$this->trace ("Icecast::_getSocket ()", "", 1, 0);
		return @fopen("http://" . $username. ":" . $password . "@" . $ip . ":" . $port . "/admin/stats.xml" ,"r");
	} # End function getSocket

	/**
	* Closes the connection to the server.
	*/
	function closeSocket($socket) {
		$this->trace ("Icecast::_closeSocket ()", "", 9, 0);
		fclose($socket);
	} # end function closeSocket(...)

	/**
	* Initiates a status call to the server.
	* Returns true if successfull, false if an error occured
	*/
	function getServerStatus($socket) {
		global $mosConfig_absolute_path;				# Ouch, this is very ugly (oo rape :p)

		$this->trace ("Icecast::_getServerStatus ()", "", 0, 0);

		# Socket is open, just read the result
		while(!feof($socket)) {
			$this->result .= fread($socket,1024);
		} # End while
		$this->trace ("Icecast::getServerStatus ()", "bytes read : " . strlen($this->result), 1, 0);
		$this->trace ("Icecast::getServerStatus ()", $this->result, 2, 1);

		# Write result into cache directory
		$file = $mosConfig_absolute_path . "/cache/icecast-stats.xml";
		if (is_writable($mosConfig_absolute_path . "/cache")) {
			$handle = @fopen($file, "w+");
			if ($handle) {
				@fwrite($handle, $this->result);
				@fclose($handle);
			} # End if
		} # End if

		# Now we use the Joomla build in xml parser to get the results...
		# First we instantiate the xml class, and read it.
		$xmldoc =& new DOMIT_Lite_Document();
		$xmldoc->resolveErrors( true );
		if (!$xmldoc->loadXML( $file, false, true )) {
			$this->trace ("Icecast::getServerStatus ()", "Cached xml file could not be read", 0, 0);
			$this->result ="";
			return false;							# File cannot be read
		} # End if

		# First we check the root element, this needs to contain
		# "icestats", if not we have an invalid respone.
		if ($xmldoc->documentElement->nodeName != "icestats") {
			$this->trace ("Icecast::getServerStatus ()", "Invalid doctype in cached xml file (needs to be icestats)", 0, 0);
			$this->result ="";
			return false;							# File cannot be read
		} # End if

		# Check if the document has *any* child nodes, if not exit with
		# error...
		if (!$xmldoc->documentElement->hasChildNodes()) {
			$this->trace ("Icecast::getServerStatus ()", "Doctype has no child nodes.", 0, 0);
			$this->result ="";
			return false;
		} # End if
		$childnodes =&$xmldoc->documentElement->childNodes;

		# Pre-check look ok, now walk thru the nodelist. The xml file
		# generated by icestats are quite simple, so no recusion of
		# node walk-thru is used, pretty straight forward...
		$sourcecounter=1;
		for ($i = 0; $i < $xmldoc->documentElement->childCount; $i++) {
			$nodename = $childnodes[$i]->nodeName;
			switch ($nodename) {
			case "source":
				# Source node holds a subset with parameters.
				# Handle multiple sources if present...
				$this->serverdata['mount' . $sourcecounter] = $childnodes[$i]->getAttribute ("mount");
				$j=$i+1;
				$subnode = $xmldoc->getElementsByPath( $nodename, $sourcecounter );
				if ($subnode->hasChildNodes()) {
					$values = $subnode->childNodes;
					foreach ($values as $value) {
						#print "sc=$sourcecounter  : " . $value->nodeName . " == " . $value->getText() . "<br>";
						$subnode = $value->nodeName . $sourcecounter;
						$this->serverdata[$subnode] = $value->getText();
					} # End foreach
				} # End if
				$sourcecounter++;
				break;

			default:
				$this->serverdata[$nodename] = $xmldoc->documentElement->childNodes[$i]->getText();
				#print $nodename . " == " . $this->serverdata[$nodename] . "<br>";
				break;
			} # End switch

		} # End for

		return true;
	} # End function getServerStatus

	/**
	* Function that is used to check if the server is running. Call with
	* serverip and port to check. Returns true is running, else returns 
	* false.
	*/
	function IsServerRunning () {
		$this->trace ("Icecast::_IsServerRunning ()", "", 0, 0);

		if (!empty($this->result)) {
			return true;
		} else {
			return false;
		} # End if
	} # End function IsServerRunning 

	/**
	* Returns the current number of users on the server.
	*/
	function getUsersOnline () {
		return number_format($this->serverdata['clients']);
	} # End function getUsersOnline

	/**
	* Return the maximum number of clients that may connect to this server.
	* Icecast servers seem not offer the possibilty to read-out the
	* configuration, so we return the same value as the current
	* usercount.
	*/
	function getMaxClients () {
		return number_format($this->serverdata['clients']);
	} # End function getMaxClients

	/**
	* Return lowest found ping for an user: not supported in shoutcast!
	*/
	function getPingLowest() {
		return number_format(0);
	} # End function getPingLowest

	/**
	* Return highest found ping for an user: not supported in shoutcast!
	*/
	function getPingHighest () {
		return number_format(0);
	} # End function getPingHighest

	/**
	* Return avarage found ping for an user: not supported in shoutcast!
	*/
	function getPingAvarage () {
		return number_format(0);
	} # End function getPingAvarage

	/**
	* Return the operating system the server is running on.
	* Returns false when os cannot be detected.
	*/
	function getOSRunning () {
		return $this->serverdata['server'];
	} # End function getOSRunning
} # End class Icecast
?>