<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: voice.TS.php,v 0.6 2005/12/17 19:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains some extra routines for teamspeak information rendering.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

/*
* Function to render a channel, if the channel has sub-channels,
* we just render them here by recursing this function. If it has
* no sub-channels, we try to find users in this channel. For use
* in Teamspeak channel rendering.
*/
function renderChannelTeamspeak( $server, $cid, $level ) {
	global $mosConfig_live_site;

	# And next we render the channel name, including the image
	echo "<table class=\"teamspeak\">\n";
	echo "<tr>\n";
	for ($j=0; $j < $level; $j++) {
		if ($j+1 == $level) {
			if ($server->channelinfo[$cid]['channel'] == getLastChannelInLevel($server->channelinfo[$cid]['parent'], $server)) {
				$image = "treeimage3.gif";
			} else {
				$image = "treeimage2.gif";
			} # End if
		} else {
			$image = "treeimage1.gif";
		}# End if
		$title = str_replace ("[maxusers]", $server->channelinfo[$cid]['maxusers'], _SERVERSTAT_TEAMSPEAK_CHANNEL);
		$title = str_replace ("[codec]", getCodec ($server->channelinfo[$cid]['codec']), $title);
		$title = str_replace ("[topic]", $server->channelinfo[$cid]['topic'], $title);
		echo "<td><img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/servers/TS/$image\" title=\"$title\"></td>";
	} # End for
	echo "<td><img src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/servers/TS/channel.gif\" title=\"$title\"></td>";
	echo "<td>" . $server->channelinfo[$cid]['namefull'] . "</td>";
	echo "</tr>\n";
	echo "</table>\n";

	# Ok, always render users that have the same channel id as the channel
	# we are handling here.

	for ($j=0; $j < $server->numofusers; $j++) {
		if ($server->channelinfo[$cid]['channel'] == $server->userinfo[$j]['channel']) {	# is user in current channel?
			echo "<table class=\"teamspeak\">\n";
			echo "<tr>\n";
			for ($k=0; $k < $level+1; $k++) {
				if ($k == $level) {
					if (($server->channelinfo[$cid]['parent'] == -1 && getLastUserInChannel ($server->channelinfo[$cid]['channel'], $server) != $j) || hasSubChannels ($server->channelinfo[$cid]['channel'], $server)) { 
						$image = "treeimage2.gif";
					} elseif (hasSubChannels ($server->channelinfo[$cid]['channel'], $server) || $j == getLastUserInChannel($server->channelinfo[$cid]['channel'], $server)) {
						$image = "treeimage3.gif";
					} else {
						$image = "treeimage2.gif";
					}# End if
				} else {
					if ($server->channelinfo[$cid]['parent'] == -1 && getLastChannelInLevel( $server->channelinfo[$cid]['parent'], $server ) != $server->channelinfo[$cid]['channel']) { 
						$image = "treeimage1.gif";
					} elseif ($server->channelinfo[$cid]['channel'] == getLastChannelInLevel($server->channelinfo[$cid]['parent'], $server) || getLastChannelInLevel($server->channelinfo[$cid]['channel'], $server)) {
						$image = "treeimage4.gif";
					} else {
						$image = "treeimage1.gif";
					} # End if
				}# End if
				echo "<td><img class=\"teamspeakimg\" src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/servers/TS/$image\"></td>";
			} # End for

			# Determine the actual status of user
			switch ($server->userinfo[$j]['userstatus']) {
				case 1:
					$image = "player_channelcommander.gif";
					break;
				case 2:
					$image = "player_away.gif";
					break;
				case 3:
					$image = "player_mutemicrophone.gif";
					break;
				case 4:
					$image = "player_mutespeakers.gif";
					break;
				default:
					$image = "player_normal.gif";
					break;
			} # End switch
			$title = str_replace ("[time]", sec2time($server->userinfo[$j]['time']), _SERVERSTAT_TEAMSPEAK_USER);
			$title = str_replace ("[ping]", $server->userinfo[$j]['ping'], $title);
			echo "<td><img class=\"teamspeakimg\" src=\"" . $mosConfig_live_site . "/administrator/components/com_serverstat/images/servers/TS/$image\" title=\"$title\"></td>";
			echo "<td>&nbsp;" . $server->userinfo[$j]['namefull'] . "</td>";
			echo "</tr>\n";
			echo "</table>\n";
		} # End if
	} # End for

	# Next we determing if there are sub-channels, if so, we just recurse
	# this routine, that's all :-)
	for ($j=0; $j < $server->numofchannels; $j++) {
		if ($server->channelinfo[$j]['parent'] == $server->channelinfo[$cid]['channel']) {
			renderChannelTeamspeak($server, $j, $level+1 );
		} # End if
	} # End for
} # End function renderChannelTeamspeak

/*
* Returns formatted string of codec used by Ventrilo Server.
*/
function getCodec ( $codec ) {
	switch ($codec) {
	case 0:
		return "CELP 5.1 Kbit";
		break;
	case 1:
		return "CELP 6.3 Kbit";
		break;
	case 2:
		return "GSM 14.8 Kbit";
		break;
	case 3:
		return "GSM 16.4 Kbit";
		break;
	case 4:
		return "CELP Windows 5.2 Kbit";
		break;
	case 5:
		return "Speex 3.4 Kbit";
		break;
	case 6:
		return "Speex 5.2 Kbit";
		break;
	case 7:
		return "Speex 7.2 Kbit";
		break;
	case 8:
		return "Speex 9.3 Kbit";
		break;
	case 9:
		return "Speex 12.3 Kbit";
		break;
	case 10:
		return "Speex 16.3 Kbit";
		break;
	case 11:
		return "Speex 19.5 Kbit";
		break;
	case 12:
		return "Speex 25.9 Kbit";
		break;
	default:
		return "Unknown codec(" . $codec . ")";
		break;
	} # End switch
} # End function getCodec

/*
* Function that returns the current status for a player.
* 0 = normal
* 1 = channel commander
* 2 = away
* 3 = microphone muted
* 4 = speakers muted
*/
function getPlayerStatus ( $userstatus ) {
	if (($userstatus & 32) == 32) { $status = 4; }
	else if (($userstatus & 16) == 16) { $status = 3; }
	else if (($userstatus & 8) == 8) { $status = 2; }
	else if (($userstatus & 1) == 1) { $status = 1; }
	else { $status = 0; }
	return $status;
} # End function getPlayerStatus

/*
* Determine the player status:
* U = Unregistered
* R = Registered
* SA = Server Admin
* CA = Channel Admin
* AO = Auto-Operator
* AV = Auto-Voice
* O = Operator
* V = Voice
*/
function getPlayerFlags ( $userstatus, $privilege, $attribute ) {
	$playerstatus = "";

	if (($userstatus & 4) == 4) { $playerstatus = "R"; } else { $playerstatus = 'U'; }
	if (($userstatus & 1) == 1) { $playerstatus .= " SA"; }
	if (($privilege & 1) == 1) { $playerstatus .= " CA"; }
	if (($privilege & 8) == 8) { $playerstatus .= " AO"; }
	if (($privilege & 16) == 16) { $playerstatus .= " AV"; }
	if (($privilege & 2) == 2) { $playerstatus .= " O"; }
	if (($privilege & 4) == 4) { $playerstatus .= " V"; }
	if (($attribute & 64) == 64) { $playerstatus .= " Rec"; }

	return $playerstatus;
} # End function getPlayerFlags

/*
* Determine the channel status:
* U = Unregisterd
* R = Registered
* M = Moderated
* P = Passworded
* S = Sub-channels
* D = Default
*/
function getChannelFlags ( $flags ) {
	$channelstatus = "";
	if (($flags & 1) == 1) {$channelstatus ='U';} else {$channelstatus ='R';}
	if (($flags & 2) == 2) {$channelstatus .='M';}
	if (($flags & 4) == 4) {$channelstatus .='P';}
	if (($flags & 8) == 8) {$channelstatus .='S';}
	if (($flags & 16) == 16) {$channelstatus .='D';}

	return $channelstatus;
} # End function getChannelFlags
	
/*
* Determine the last channel in a channellist. Returns false if not
* found.
*/
function getLastChannelInLevel( $pid, $server ) {
	$cid = false;

	# Walk thru all channels, and deterermine the last
	# channel in this level, and return it.
	for ($i=0; $i < $server->numofchannels; $i++) {
		if ($server->channelinfo[$i]['parent'] == $pid ) {
			$cid = $server->channelinfo[$i]['channel'];
		} # End if
	} # End for
	return $cid;
} # End function getLastChannelInLevel
	
/*
* Determinge the last user that is in given channel. Returns false if 
* not found.
*/
function getLastUserInChannel ( $cid, $server ) {
	$uid = false;

	# Walk thru all users, and select the user id in given channel.
	for ($i=0; $i < $server->numofusers; $i++) {
		if ($server->userinfo[$i]['channel'] == $cid) {
			$uid = $i;
		} # End if
	} # End if

	return $uid;
} # End function getLastUserInChannel 

/*
* Check if channels has sub-channels
*/
function hasSubChannels ( $cid, $server ) {
	# Walk thru all channels, and deterermine if channels have
	# givens channel as parent, if so, return true.
	for ($i=0; $i < $server->numofchannels; $i++) {
		if ($server->channelinfo[$i]['parent'] == $cid ) {
			return true;
		} # End if
	} # End for

	return false;
} # End function hasSubChannels
?>
