<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: voice.VENT.php,v 0.6 2005/12/17 19:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains some extra routines for Ventrilo information rendering.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/*
* Function to render a channel, if the channel has sub-channels,
* we just render them here by recursing this function. If it has
* no sub-channels, we try to find users in this channel. For use
* in Ventrilo channel rendering.
*/
function renderChannelVentrilo( $server, $i, $level, $short = false ) {
	global $mosConfig_live_site;

	$spacer = "&nbsp;";
	if (!$short) { $spacer .= "&nbsp;&nbsp;&nbsp;&nbsp;"; }
	
	# Let us first determine the image type
	if ($server->channelinfo[$i]['prot'] == 0) {
		$image = "v_channel.gif";
	} else {
		$image = "v_channel_pw.gif";
	} # End if

	# And next we render the channel name, including the image
	?>
	<tr>
		<td align="left">
			<?php for ($s=0; $s < $level; $s++) { echo $spacer; } ?>
			<img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_serverstat/images/servers/VENT/<?php echo $image; ?>" border="0">
			<?php echo $server->channelinfo[$i]['name']; ?>
		</td>
	</tr>
	<?php	

	# Ok, always render users that have the same channel id as the channel
	# we are handling here.
	for ($j=0; $j < $server->numofusers; $j++) {
		if ($server->channelinfo[$i]['cid'] == $server->userinfo[$j]['cid']) {
		?>
		<tr>
			<td align="left">
				<?php for ($s=0; $s < $level; $s++) { echo $spacer; } ?>
				<img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_serverstat/images/servers/VENT/v_user.gif" border="0">
				<?php echo $server->userinfo[$j]['name'] . " (" . sec2time($server->userinfo[$j]['sec']) . ")"; ?>
			</td>
		</tr>
		<?php
		} # End if
	} # End for

	# Next we determing if there are sub-channels, if so, we just recurse
	# this routine, that's all :-)
	for ($j=0; $j < $server->numofchannels; $j++) {
		if ($server->channelinfo[$j]['pid'] == $server->channelinfo[$i]['cid']) {
			renderChannelVentrilo($server, $j, $level+1 );
		} # End if
	} # End for
} # End function renderChannelVentrilo
?>