<?php
/**
* @version $Id: admin.serverstat.html.php,v 0.6 2005/12/22 20:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Php code for rendering an bargraph. Used within the serverstat module, 
* depends on the presence of the JpGraph component!
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.*/
require_once ( "../../../../configuration.php" );
require_once ( $mosConfig_absolute_path . "/administrator/components/com_jpgraph/src/jpgraph.php");
require_once ( $mosConfig_absolute_path . "/administrator/components/com_jpgraph/src/jpgraph_bar.php");

/*
* Just an array that holds the color codes for the graph. I presume we only
* use the backend here, for future use we need to find an solution for
* incorperation into the template logic...
*
* Color codes used to render the individual graphics. The following references
* can be used:
* Color         --> The main color of the graph (background)
* MargingColor  --> Color of the margins of the graph.
* Title         --> All text items get this color
*/
$colorcode['Color'] = "#E5E5E5";
$colorcode['MarginColor'] = "#E5E5E5";
$colorcode['Title'] = "#FF9E31";
$colorcode['Axis'] = "#000000";

/*
* Colorcodes per data item. This is used when drawing a bar chart. The bar
* elements get the color codes "mentioned" here. Add as many color codes
* as needed.
*/
$colorcode['data'][0] = "blue";
$colorcode['data'][1] = "red";
$colorcode['data'][2] = "#006600";

/*
* Now render the graph.
*/
$graph = new Graph(600,350,'auto');
$graph->SetScale("textlin");
$graph->SetColor($colorcode['Color']);
$graph->img->SetMargin(55,5,100,40);
$graph->SetMarginColor($colorcode['MarginColor']);

$graph->xaxis->title->Set($_GET['titlexaxis']);
$graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
$graph->xaxis->title->SetColor($colorcode['Axis']);

$graph->xaxis->SetColor($colorcode['Axis']);
$graph->yaxis->SetColor($colorcode['Axis']);

$graph->title->Set($_GET['title']);
$graph->title->SetFont(FF_FONT2,FS_BOLD);
$graph->title->SetColor($colorcode['Title']);

$graph->legend->Pos(0.05,0.1);

/*
* Unpack the data passed to this module. The fields have the following format:
* d[n] - n=0,1,2,3,.... contains the data fields, delimited with an ";"
* l[n] - dito           contains the legent that need to be showed
*/
$i=0;
$abplot = array();
foreach ($_GET as $key => $value) {
	if (substr ($key, 0, 1) == 'd') {
		$keyval = "l" . substr($key, 1);				# Determine keyvalue
		$bplot = new BarPlot(split (";", $_GET[$key]));			# Use data field
		$bplot->SetFillColor($colorcode['data'][$i]);
		$bplot->SetLegend($_GET[$keyval]);				# Use the corresponding legend field
		if (!isset($_GET['showvalue'])) {
			$bplot->value->Show();
		} # End if
		#$bplot->SetShadow();
		$bplot->value->SetFormat('%d');
		$bplot->value->SetFont(FF_FONT1,FS_BOLD);
		$bplot->value->SetColor($colorcode['Title']);
		$i++;
		$abplot[] = $bplot;						# Build array
	} # End if
} # End foreach

/*
* Build the graph, and render it...
*/
$gbarplot = new GroupBarPlot($abplot);
$gbarplot->SetWidth(0.6);
$graph->Add($gbarplot);
$graph->Stroke();
?>