<?php
/**
* @version $Id: admin.serverstat.html.php,v 0.6 2005/11/20 20:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* Php code for rendering an line graph. Used within the serverstat module, 
* depends on the presence  of the JpGraph component!
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.*/
require_once ( "../../../../configuration.php" );
require_once ( $mosConfig_absolute_path . "/administrator/components/com_jpgraph/src/jpgraph.php" );
require_once ( $mosConfig_absolute_path . "/administrator/components/com_jpgraph/src/jpgraph_line.php" );

# Just an array that holds the color codes for the graph. I presume we only
# use the backend here, for future use we need to find an solution for
# incorperation into the template logic...
#
# Color codes used to render the individual graphics. The following references
# can be used:
# Color         --> The main color of the graph (background)
# MargingColor  --> Color of the margins of the graph.
# Title         --> All text items get this color
$colorcode['Color'] = "#E5E5E5";
$colorcode['MarginColor'] = "#E5E5E5";
$colorcode['Title'] = "#FF9E31";
$colorcode['Axis'] = "#000000";

# Colorcodes per data item. This is used when drawing a bar chart. The bar
# elements get the color codes "mentioned" here. Add as many color codes
# as needed.
$colorcode['data'][0] = "blue";
$colorcode['data'][1] = "red";
$colorcode['data'][2] = "#006600";

# Retrieve the data, passed on to this piece of code.
# - "current" holds the values for the line graph
# - "lxaxis" holds the legenda for the xaxis (hours in this case).
$ydata = split (";", $_GET['current']);
$lxaxis = split (";",  $_GET['lxaxis']);

# Create the graph. These two calls are always required
$graph = new Graph(225,150,'auto');
$graph->SetScale("textlin");

$graph->img->SetMargin(40,20,20,40);
$graph->ygrid->Show(true,true);
$graph->xgrid->Show(true,false);

# Specify the tick labels for the x axis
$graph->xaxis->SetTickLabels($lxaxis);
$graph->xaxis->SetTextLabelInterval(intval(count($lxaxis) / 3));

# Create the linear plot
$lineplot1 = new LinePlot($ydata);

# Legenda is stored in the vars "lminping", "lmaxping" and "avgping"
$lineplot1->SetColor($colorcode['data'][0]);
$lineplot1->SetWeight(2);

# Add the plot to the graph
$graph->xaxis->title->Set($_GET['titlexaxis']);
$graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
$graph->xaxis->SetColor($colorcode['Axis']);
$graph->xaxis->SetWeight(1);
$graph->Add($lineplot1);

# Display the graph
$graph->Stroke();
?>