<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: template.TS.php,v 0.6 2005/12/22 23:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains the serverstat template for teamspeak servers.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/

/*
* Function to render a channel, if the channel has sub-channels,
* we just render them here by recursing this function. If it has
* no sub-channels, we try to find users in this channel. For use
* in Teamspeak channel rendering.*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/voice.TS.php");

/**
* Let me explain what we are going to do here. The default mambo code uses 
* an static reference to the style sheet used for tabs in forms. Here we 
* inherit the mosTabs class, and change the constructor for using an template 
* dependend style sheet. If the style has no tabbed stylesheet present, we use
* the default stylesheet.
*/
class mosTabsModified extends mosTabs {
	/**
	* Constructor
	* Includes files needed for displaying tabs and sets cookie options
	* @param int useCookies, if set to 1 cookie will hold last used tab between page refreshes
	*/
	function mosTabsModified($useCookies) {
		global $mosConfig_live_site, $mosConfig_absolute_path, $cur_template;

		if (file_exists( $mosConfig_absolute_path. "/templates/". $cur_template ."/css/tabpane.css" )) {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . "templates/". $cur_template ."/css/tabpane.css\"/>";
		} else {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . $mosConfig_live_site. "/includes/js/tabs/tabpane.css\" />";
		} # End if
		echo "<script type=\"text/javascript\" src=\"". $mosConfig_live_site . "/includes/js/tabs/tabpane.js\"></script>";
		$this->useCookies = $useCookies;
	}

} # End class mosTabsModified 

$tabs = new mosTabsModified(1);
?>

<table width="100%" border="0" class="contentpaneopen" cellspacing="0" cellpadding="5">
<tr valign="top">
<td width="25%">
	<table width="100%">
	<tr>
	<td align="center" colspan="2"><img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_serverstat/images/servers/TS/unknown.gif" border="0"></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_NAME; ?></strong></small></td>
		<td align="left"><small><?php echo $server->serverdata['server_name']; ?><small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_IP; ?></strong></small></td>
		<td align="left"><small><?php echo wordwrap($server->serverdata['host'], 25, "<br>", 1); ?>:<?php echo $server->serverdata['clientport']; ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_USERS; ?></strong></small></td>
		<td align="left"><small><?php echo $server->serverdata['server_currentusers']; ?>/<?php echo $server->serverdata['server_maxusers']; ?> (<?php echo number_format ($server->serverdata['server_currentusers'] / $server->serverdata['server_maxusers'] * 100, 2); ?>%)</small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_VERSION; ?></strong></small></td>
		<td align="left"><small><?php echo $server->serverdata["server_version"]; ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_UPTIME; ?></strong></small></td>
		<td align="left"><small><?php echo sec2time($server->serverdata['server_uptime']); ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_BYTESSEND; ?></strong></small></td>
		<td align="left"><small><?php echo DataSize ($server->serverdata['server_bytessend']); ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_BYTESRECEIVED; ?></strong></small></td>
		<td align="left"><small><?php echo DataSize ($server->serverdata['server_bytesreceived']); ?></small></td>
	</tr>
	<?php
	if ($serverstat_connectbutton == 1) {
	?>
	<tr>
		<td align="center" colspan="2">
		<br>
		<form action='teamspeak://<?php echo $row->ip; ?>:<?php echo getGamePort ($row); ?>'>
		<input type="submit" value="Connect">
		</form>
		</td>
	</tr>
	<?php
	} # End if
	?>
	</table>
</td>
<td width="75%">
	<table width="100%" cellspacing="0" cellpadding="5">
	<tr class="sectiontableheader">
		<th align="left" ><?php echo _SERVERSTAT_BUTTON_STATUS; ?></th>
	</tr>
	</table>

	<?php
	$title = str_replace ("[host]", $server->serverdata['host'], _SERVERSTAT_TEAMSPEAK_SERVER);
	$title = str_replace ("[maxusers]", $server->serverdata['server_maxusers'], $title);
	$title = str_replace ("[time]", sec2time($server->serverdata['server_uptime']), $title);
	?>

	<table cellspacing="0" cellpadding="0" class="teamspeak">
	<tr valign="top">
		<td align="left"><img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_serverstat/images/servers/TS/teamspeak_online.gif" border="0" title="<?php echo $title; ?>"></td>
		<td><?php echo $server->getHostName(); ?></td>
	</tr>
	</table>
	<?php
	for ($i=0; $i < $server->numofchannels; $i++) {
		if ($server->channelinfo[$i]['parent'] == -1) {			# Only render top-level down channels
			renderChannelTeamspeak($server, $i, 1 );
		} # End if
	} # End for
	?>
</td>
</tr>
</table>