<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: template.VENTRILO.php,v 0.6 2005/12/17 23:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains the serverstat template for Ventrilo servers.
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path."/administrator/components/com_serverstat/includes/voice.VENT.php");

/**
* Let me explain what we are going to do here. The default mambo code uses 
* an static reference to the style sheet used for tabs in forms. Here we 
* inherit the mosTabs class, and change the constructor for using an template 
* dependend style sheet. If the style has no tabbed stylesheet present, we use
* the default stylesheet.
*/
class mosTabsModified extends mosTabs {
	/**
	* Constructor
	* Includes files needed for displaying tabs and sets cookie options
	* @param int useCookies, if set to 1 cookie will hold last used tab between page refreshes
	*/
	function mosTabsModified($useCookies) {
		global $mosConfig_live_site, $mosConfig_absolute_path, $cur_template;

		if (file_exists( $mosConfig_absolute_path. "/templates/". $cur_template ."/css/tabpane.css" )) {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . "templates/". $cur_template ."/css/tabpane.css\"/>";
		} else {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . $mosConfig_live_site. "/includes/js/tabs/tabpane.css\" />";
		} # End if
		echo "<script type=\"text/javascript\" src=\"". $mosConfig_live_site . "/includes/js/tabs/tabpane.js\"></script>";
		$this->useCookies = $useCookies;
	}

} # End class mosTabsModified 

$tabs = new mosTabsModified(1);
?>

<table width="100%" border="0" class="contentpaneopen">
<tr valign="top">
<td width="25%">
	<table width="100%">
	<tr>
	<td align="center" colspan="2"><img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_serverstat/images/servers/VENT/unknown.jpg" border="0"></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_NAME; ?></strong></small></td>
		<td align="left"><small><?php echo $server->getHostName(); ?><small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_IP; ?></strong></small></td>
		<td align="left"><small><?php echo wordwrap($server->serverip, 25, "<br>", 1); ?>:<?php echo $server->port; ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_USERS; ?></strong></small></td>
		<td align="left"><small><?php echo $server->getUsersOnline () . "/" . $server->getMaxClients() . " (" . number_format (($server->numofusers/$server->getMaxClients()) * 100, 2) . "%)";; ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_VERSION; ?></strong></small></td>
		<td align="left"><small><?php echo $server->serverdata["version"] . " (" . $server->getOSRunning() . ")"; ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_UPTIME; ?></strong></small></td>
		<td align="left"><small><?php echo sec2time($server->serverdata['uptime']); ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_CODEC; ?></strong></small></td>
		<?php
		$codec = split (",", $server->serverdata['voicecodec']);
		?>
		<td align="left"><small><?php echo $codec[1]; ?></small></td>
	</tr>
	<tr>
		<td align="left" nowrap><small><strong><?php echo _SERVERSTAT_VOICEFORMAT; ?></strong></small></td>
		<td align="left"><small><?php echo str_replace("%", ", ", $server->serverdata['voiceformat']); ?></small></td>
	</tr>
	</table>
</td>
<td width="75%">
	<table width="100%" cellspacing="0" cellpadding="5">
	<tr class="sectiontableheader">
		<th colspan="4" align="left" ><?php echo _SERVERSTAT_BUTTON_STATUS; ?></th>
	</tr>
	<tr><td>&nbsp;</td></tr>
	<tr>
		<td align="left" colspan="2">
			<img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_serverstat/images/servers/VENT/v_main.gif" border="0">
			<?php echo $server->getHostName(); ?>
		</td>
	</tr>
	<?php
	for ($i=0; $i < $server->numofchannels; $i++) {
		if ($server->channelinfo[$i]['pid'] == 0) {			# Only render top-level down channels
			renderChannelVentrilo($server, $i, 1, false );
		} # End if
	} # End for
	?>
	</table>
</td>
</tr>
</table>