<?php
/**
* Serverstatus 0.6 for Joomla CMS 
* @version $Id: template.classic.php,v 0.6 2005/12/22 15:00:00 wilcojansen Exp $
* @package serverstat 0.6
*
* This file contains the serverstat template for gameservers. This template
* handles the output rendering for alsmost all gameservers Serverstat supports and
* is marked as the classic template for gameservers. Classic refers to the
* original design of Serverstat that was around from the first version
* of Serverstat on.
*
* Remember that the complete context of the server is available here, so the
* $server and $row objects can be used fully here!
*
* LICENSE
* =======
* Copyright (C) 2006 Wilco Jansen
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
* http://www.gnu.org/licenses/gpl.txt
*
* =======
* If you modify or create derivative works based on this code, please respect
* our work and carry along our Copyright notices along with the GNU GPL.
* The GPL DOES NOT allow you to release modified or derivative works under
* any other license. Before you modify this code, read up on your rights
* and obligations under the GPL.*/

global $serverstat_loginterval, $serverstat_graph_recentusers, $serverstat_collectstats, $serverstat_jpgraph;
global $mosConfig_absolute_path, $mosConfig_live_site;

/*
* Let us start to include the variables we need to render the proper information.
* For this we try to include the variable file for the given gametype, if not
* present we render an error message that the server is not supported.
*/
$file = $mosConfig_absolute_path . "/administrator/components/com_serverstat/includes/game." . $row->servertype . ".php";
if (!file_exists($file)) { ?>
	<table width="100%" border="0" class="infoform" cellspacing="0" cellpadding="5">
	<tr>
		<td><?php echo _SERVERSTAT_GAMETYPENOTSUPPORTED; ?> </td>
	</tr>
	</table>
	<?php
	return;
} # End if
include ($file);

/*
* Function to render a table with all player information in it.
*/
function renderPlayerInfo ($server, $playerinfo) { ?>
	<table width="100%" border="0" cellspacing="0" cellpadding="5">
	<tr class="sectiontableheader">
		<?php
		# Render the header for the player information
		for ($i=0; $i < count($playerinfo['headers']); $i++) {
			echo "<th>" . $playerinfo['headers'][$i] . "</th>\n";
		} # End for
		?>
	</tr>
	
	<?php
	# Now render the player information for this server
	if ($server->numofusers != 0) {
		for ($i=0; $i < $server->numofusers; $i++) {
			echo "<tr>\n";
			# Render the header for the player information
			for ($j=0; $j < count($playerinfo['headers']); $j++) {
				$field = $playerinfo['fields'][$j];
				$value = $server->userinfo[$i][$field];
				Switch ($playerinfo['transform'][$j]) {
					# Q3 name tagging
					case 1;
						$value = q3Name2HTML($value);
						break;
					# UT name type
					case 2; 
						$value = UTName2HTML($value);
					# Time conversion
					case 3;
						$value = date("H:i:s", $value);
						break;
				} # End switch
				echo "<td><small>" . $value . "<small></td>\n";
			} # End for
			echo "</tr>\n";
		} # End for
		?>
		<tr><td colspan="<?php echo count($playerinfo['headers']); ?>"><br><small><strong><?php echo str_replace ("[count]", $server->numofusers, _SERVERSTAT_NUMPLAYERS); ?></strong></small></td></tr>	
		<?php
	} else { ?>
		<tr><td><small><strong><?php echo _SERVERSTAT_NOPLAYERS; ?></strong></small></td></tr>	
	<?php
	} # End if
	?>
	</table>
	<?php
} # End function renderPlayerInfo

/*
* Function to render a table with all server variables information.
*/
function renderServerInfo ($server) { ?>
	<table width="100%" border="0" cellspacing="0" cellpadding="5">
	<tr class="sectiontableheader">
		<th width="50%"><?php echo _SERVERSTAT_SETTING; ?></th>
		<th width="50%"><?php echo _SERVERSTAT_VALUE; ?></th>
	</tr>
	<?php
	foreach ($server->serverdata as $key => $value) { ?>
		<tr>
	  	<td align="left"><small><?php echo wordwrap($key, 25, "<br>", 1); ?></small></td>
	  	<td align="left"><small><?php echo wordwrap($value, 25, "<br>", 1); ?></small></td>
	  	</tr>
		<?php
	} # End foreach
	?>
	</table>
	<?php
} # End function renderServerInfo

/*
* Panel extention (automatically detects additional stylesheet).
*/
class mosTabsModified extends mosTabs {
	/**
	* Constructor
	* Includes files needed for displaying tabs and sets cookie options
	* @param int useCookies, if set to 1 cookie will hold last used tab between page refreshes
	*/
	function mosTabsModified($useCookies) {
		global $mosConfig_live_site, $mosConfig_absolute_path, $cur_template;

		if (file_exists( $mosConfig_absolute_path. "/templates/". $cur_template ."/css/tabpane.css" )) {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . "templates/". $cur_template ."/css/tabpane.css\"/>";
		} else {
			echo "<link id=\"luna-tab-style-sheet\" type=\"text/css\" rel=\"stylesheet\" href=\"" . $mosConfig_live_site. "/includes/js/tabs/tabpane.css\" />";
		} # End if
		echo "<script type=\"text/javascript\" src=\"". $mosConfig_live_site . "/includes/js/tabs/tabpane.js\"></script>";
		$this->useCookies = $useCookies;
	}

} # End class mosTabsModified 

$tabs = new mosTabsModified(1);
?>

<!--
* ONLINE SERVER DETAILS
-->

<table width="100%" border="0" class="contentpaneopen">
<tr valign="top">
<td width="25%">
	<table width="100%">
	<tr>
		<td align="center" colspan="2"><img src="<?php echo getImagePath ($row, $server); ?>" border="0"></td>
	</tr>
	<?php
	# Render the fields that we want to display. These fields are defined
	# in the include files that are located in the /include directory for
	# the given servertype.
	for ($i=0; $i < count($headerfields); $i++) {
		echo "<tr valign=\"top\">\n";
		echo "<td align=\"left\" nowrap><small><strong>" . $headerfields[$i] . "</strong></small></td>\n";
		echo "<td align=\"left\"><small>" . $headervalues[$i] . "</small></td>\n";
		echo "</tr>\n";
	} # End for

	# Render a connect button if needed.
	if ($serverstat_connectbutton == 1) {
		$html = renderConnectButton ( $row );
		if ($html != false) {
			echo "<tr><td align=\"center\" colspan=\"2\">$html</td></tr>";
		} # End if
	} # End if
	?>
	</table>
</td>
<td width="75%">
	<?php
	$tabs->startPane("server-pane");
	$tabs->startTab(_SERVERSTAT_BUTTON_PLAYER,"player-page");
	?>
	<table width="100%" cellspacing="0" cellpadding="5">
	<tr>
		<td width="100%"><?php renderPlayerInfo ($server, $playerinfo); ?></td>
	</tr>
	</table>
	<?php
	$tabs->endTab();
	$tabs->startTab(_SERVERSTAT_BUTTON_SERVER,"server-page");
	?>
	<table width="100%" cellspacing="0" cellpadding="5">
	<tr>
		<td width="100%"><?php renderServerInfo ($server); ?></td>
	</tr>
	</table>
	<?php
	$tabs->endTab();
	$tabs->endPane();
	?>
</td>
</tr>
</table>
