<?php
/**
 * This file contains the definition for the eWeatherConfiguration class
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );


class eWeatherConfiguration extends JObject
{
	public function getDefaultLocationId()
	{
		$paramsArray = $this->get();
		if (array_key_exists('locationId', $paramsArray))
		{
			return $paramsArray['locationId'];
		}
		else
		{
			return null;
		}
	}
	
	public function setDefaultLocation($region, $country, $city, $locId)
	{
		$paramsArray = $this->get();
		$paramsArray['region'] = $region;
		$paramsArray['country'] = $country;
		$paramsArray['city'] = $city;
		$paramsArray['locationId'] = $locId;
		$this->set($paramsArray);
	}
	
    /**
     * Method to retrieve the given configuration from the extensions table
	 * @return an array of name=>value pairs
     */
	public function get()
	{
    	$params = JComponentHelper::getParams('com_eweather');
    	
		return $params->toArray();
	}
	
    /**
     * Method to save the given data to the extensions table
	 * @param data an array of name=>value pairs
     */
    function set($data)
	{
       	// get the com_eweather params field from the extensions table 
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('`extension_id`,`params`');
       	$query->from('`#__extensions`');
		$query->where('name="com_eweather"');
		
		$db->setQuery($query);
		$component = $db->loadObject();

		// Load the previous Data
		if (!isset($component))
		{
			// TODO add intelligent error message
			$this->setError("ERROR: could not find com_eweather extension");
			return false;
		}

		// convert the JSON string to an array
        $params = new JRegistry();
        $params->loadJSON($component->params);
		$paramsArray = $params->toArray();

		// Bind the data values from the form
		//  all the form values must be in the dest array
		//  there may be additional values in the dest array
		foreach ($data as $k => $v)
		{
			$paramsArray[$k] = $data[$k];
		}

		// convert the array to a JSON string
		$params = new JRegistry();
        $params->loadArray($paramsArray);
        $paramsJsonString = $params->toString('JSON');
		
        // save the params back to the com_eweather extension record
		$query = $db->getQuery(true);
       	$query->update('#__extensions');
		$query->set('params='.$db->quote($paramsJsonString));
		$query->where('extension_id='.$component->extension_id);

		// run the query
		$db->setQuery($query);
		if (!$db->query()) {
			// TODO add intelligent error message
			$this->setError("ERROR: could not save the configuration");
			return false;
		}
		
	}
}
