<?php
/**
 * This file contains the controller for the backend
 *  of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport('joomla.application.component.controller');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JTable::addIncludePath(COM_EWEATHER_ADMIN_TABLES_PATH);


class eWeatherControllerLocation extends JController
{
	protected $_model = null;
	
	function __construct($config = array())
	{
		parent::__construct($config);
		$this->registerTask('show', 'display');
		$this->registerTask('unpublish', 'publish');
		$this->registerTask('unpublishAll', 'publishAll');
		
		$this->_model = $this->getModel('allLocations');
	}

	function display()
	{
        // set default view if not set
        JRequest::setVar('view', JRequest::getCmd('view', 'allLocations'));
		
		$this->_model->verifyDefaultLocation();

		parent::display();
	}

	function makeDefault()
	{
		$cid = JRequest::getVar('cid', array());
		$row = JTable::getInstance('eweatherlocations');
		$msg = JText::_('COM_EWEATHER_ADMIN_LOCATION_NO_LOCATIONS_SELECTED_FOR_DEFAULT');
		$msgType = 'error';

		foreach ($cid as $id)
		{
			$row->load($id);
			if ('1' == $row->published)
			{
				$this->_model->setDefaultLocation($row->region, $row->country, $row->city, $row->loc_id);
				$msg = sprintf(JText::_('COM_EWEATHER_ADMIN_LOCATION_DEFAULT_LOCATION_SELECTED'), $row->loc_id);
				$msgType = 'message';
				break;
			}
		}

		$this->setRedirect('index.php?option=com_eweather&task=location_show', $msg, $msgType);
	}
	
	function publish()
	{
		$cid = JRequest::getVar('cid', array());
		$row = JTable::getInstance('eWeatherLocations');
		$publish = 1;
		$msg = "";
		$msgType = "message";

		if(count($cid) == 0)
		{
			$msg = JText::_( 'COM_EWEATHER_ADMIN_LOCATION_NO_LOCATIONS_SELECTED' );
			$msgType = "notice";
		}
		else
		{
			if($this->getTask() == 'unpublish')
			{
				$publish = 0;
			}
				
			if(!$row->publish($cid, $publish))
			{
				JError::raiseError(500, $row->getError() );
			}
				
			if ($this->getTask() == 'unpublish')
			{
				if (count($cid) > 1)
				{
					$msg = JText::_( 'COM_EWEATHER_ADMIN_LOCATION_LOCATIONS_UNPUBLISHED' );
				}
				else
				{
					$msg = JText::_( 'COM_EWEATHER_ADMIN_LOCATION_LOCATION_UNPUBLISHED' );
				}
			
				// we may have unpublished the default location
				$this->_model->verifyDefaultLocation();
			}
			else
			{
				if (count($cid) > 1)
				{
					$msg = JText::_( 'COM_EWEATHER_ADMIN_LOCATION_LOCATIONS_PUBLISHED' );
				}
				else
				{
					$msg = JText::_( 'COM_EWEATHER_ADMIN_LOCATION_LOCATION_PUBLISHED' );
				}
			}
			
		}

		$this->setRedirect('index.php?option=com_eweather&task=location_show', $msg, $msgType);
	}

	function publishAll()
	{
		$publish = 1;
		$msg = JText::_('COM_EWEATHER_ADMIN_LOCATION_PUBLISHED_ALL_LOCATIONS_IN_VIEW');
		$msgType = "message";

		if($this->getTask() == 'unpublishAll')
		{
			$publish = 0;
			$msg = JText::_( 'COM_EWEATHER_ADMIN_LOCATION_UNPUBLISHED_ALL_LOCATIONS_IN_VIEW' );
		}

		$this->_model->setPublishedState($publish);

		if ($this->getTask() == 'unpublishAll')
		{
			// we may have unpublished the default location
			$this->_model->verifyDefaultLocation();
		}
		
		$this->setRedirect('index.php?option=com_eweather&task=location_show', $msg, $msgType);
	}

	function close()
	{
		$this->_model->clearFilters();
		$this->setRedirect('index.php?option=com_eweather&task=cpanel_show');
	}
}
