<?php
/**
 * This file contains the eWeatherRegionList field definition
 *  for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

// import the eWeatherList field type
JLoader::register('JFormFieldEWeatherList', COM_EWEATHER_ADMIN_FIELDS_PATH.DS.'eweatherlist.php' );


/**
 * eWeatherRegionList Form Field class for the eWeather component
 */
class JFormFieldEWeatherRegionList extends JFormFieldEWeatherList
{
	public function __construct($form = null)
	{
		parent::__construct($form);
		$this->type = 'EWeatherRegionList';
	}
	
	/**
	 * Method to get the field options.
	 *
	 * @return	array	The field option objects.
	 * @since	1.6
	 */
	protected function getOptions() 
    {
    	// create a list of all regions
    	return $this->getRegions(false, true);
	}
    
	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// add an onclick option and call the base class's getInput()
		$this->element['onchange'] = 'document.getElementById(\'jform_country\').value=\'\';submitform();';
		return parent::getInput();
	}

	protected function getRegions($onlyPublished=false, $addDefaultOption=false)
	{
    	// set our current value to a user state, so
    	//  it can be used by the eWeatherCountryList
    	JFactory::getApplication()->setUserState('com_eweather.admin.filterRegion', isset($this->value) ? $this->value : "");
    	
		// no selection (default)
		if ($addDefaultOption)
		{
			$regionOptions[] = JHTML::_('select.option', '', JText::_('COM_EWEATHER_ADMIN_SELECT_REGION'));
		}

    	// create a list of all regions
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
    	$query->select('region');
    	$query->from('#__eweather_locations');
		if ($onlyPublished)
		{
			$query->where('published=1');
		}
    	$query->group('region');
		$query->order('region');
		$db->setQuery($query);
		$regions = $db->loadObjectList();

		if (count($regions) <> 0)
		{
			foreach ($regions as $region)
			{
				$regionOptions[] = JHTML::_('select.option', $region->region, JText::_($region->region), 'value', 'text' );
			}
		}
		// make sure there's at least one option
		else if (!$addDefaultOption)
		{
			$regionOptions[] = JHTML::_('select.option', "", "", 'value', 'text' );
		}
		
		return $regionOptions;
	}
}
