DROP TABLE IF EXISTS `#__eweather_cache`;
CREATE TABLE IF NOT EXISTS `#__eweather_cache` (
  `id` mediumint(9) NOT NULL auto_increment,
  `lastupdate` int(11) default NULL default '0',
  `locid` char(8) NOT NULL default '',
  `dataType` varchar(9) NOT NULL default '',
  `units` char(1) NOT NULL default 's',
  `data` text NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM PACK_KEYS=0 DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;

DROP TABLE IF EXISTS `#__eweather_locations`;
CREATE TABLE IF NOT EXISTS `#__eweather_locations` (
  `id` int(4) NOT NULL auto_increment,
  `city` varchar(50) default NULL default '',
  `country` varchar(50) NOT NULL default '',
  `region` varchar(50) NOT NULL default '',
  `loc_id` char(8) NOT NULL default '',
  `published` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM PACK_KEYS=0 DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;

DROP TABLE IF EXISTS `#__eweather_profiles`;
CREATE TABLE IF NOT EXISTS `#__eweather_profiles` (
  `userId` int(11) NOT NULL,
  `params` text NOT NULL default '',
  PRIMARY KEY  (`userId`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;

INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Adrar', 'Algeria', 'Africa', 'AGXX0034', 0),
(0, 'Algiers', 'Algeria', 'Africa', 'AGXX0001', 0),
(0, 'Amsel', 'Algeria', 'Africa', 'AGXX0002', 0),
(0, 'Annaba', 'Algeria', 'Africa', 'AGXX0012', 0),
(0, 'Batna', 'Algeria', 'Africa', 'AGXX0017', 0),
(0, 'Bechar', 'Algeria', 'Africa', 'AGXX0028', 0),
(0, 'Bejaia', 'Algeria', 'Africa', 'AGXX0003', 0),
(0, 'Beni Abbes', 'Algeria', 'Africa', 'AGXX0038', 0),
(0, 'Biskra', 'Algeria', 'Africa', 'AGXX0022', 0),
(0, 'Bordj Bou Arreridj', 'Algeria', 'Africa', 'AGXX0015', 0),
(0, 'Bou-Saada', 'Algeria', 'Africa', 'AGXX0021', 0),
(0, 'Chlef', 'Algeria', 'Africa', 'AGXX0014', 0),
(0, 'Constantine', 'Algeria', 'Africa', 'AGXX0013', 0),
(0, 'Djanet', 'Algeria', 'Africa', 'AGXX0037', 0),
(0, 'El Golea', 'Algeria', 'Africa', 'AGXX0031', 0),
(0, 'El Oued', 'Algeria', 'Africa', 'AGXX0026', 0),
(0, 'Ghardaia', 'Algeria', 'Africa', 'AGXX0027', 0),
(0, 'Hassi-Messaoud', 'Algeria', 'Africa', 'AGXX0030', 0),
(0, 'Illizi', 'Algeria', 'Africa', 'AGXX0036', 0),
(0, 'In Amenas', 'Algeria', 'Africa', 'AGXX0033', 0),
(0, 'In Salah', 'Algeria', 'Africa', 'AGXX0035', 0),
(0, 'Jijel', 'Algeria', 'Africa', 'AGXX0040', 0),
(0, 'Mascara Metmore', 'Algeria', 'Africa', 'AGXX0019', 0),
(0, 'Mecheria', 'Algeria', 'Africa', 'AGXX0024', 0),
(0, 'Mostaganem', 'Algeria', 'Africa', 'AGXX0005', 0),
(0, 'Oran', 'Algeria', 'Africa', 'AGXX0006', 0),
(0, 'Ouargla', 'Algeria', 'Africa', 'AGXX0029', 0),
(0, 'Setif', 'Algeria', 'Africa', 'AGXX0016', 0),
(0, 'Skikda', 'Algeria', 'Africa', 'AGXX0011', 0),
(0, 'Tahifet', 'Algeria', 'Africa', 'AGXX0007', 0),
(0, 'Tamanrasset', 'Algeria', 'Africa', 'AGXX0008', 0),
(0, 'Tebessa', 'Algeria', 'Africa', 'AGXX0018', 0),
(0, 'Tenes', 'Algeria', 'Africa', 'AGXX0009', 0),
(0, 'Tiaret', 'Algeria', 'Africa', 'AGXX0020', 0),
(0, 'Timimoun', 'Algeria', 'Africa', 'AGXX0032', 0),
(0, 'Tindouf', 'Algeria', 'Africa', 'AGXX0010', 0),
(0, 'Tlemcen Zenata', 'Algeria', 'Africa', 'AGXX0023', 0),
(0, 'Touggourt', 'Algeria', 'Africa', 'AGXX0025', 0),
(0, 'Cabinda', 'Angola', 'Africa', 'AOXX0002', 0),
(0, 'Cacuaco', 'Angola', 'Africa', 'AOXX0003', 0),
(0, 'Caxito', 'Angola', 'Africa', 'AOXX0005', 0),
(0, 'Luanda', 'Angola', 'Africa', 'AOXX0008', 0),
(0, 'Cotonou', 'Benin', 'Africa', 'BNXX0001', 0),
(0, 'Porto-Novo', 'Benin', 'Africa', 'BNXX0002', 0),
(0, 'Save', 'Benin', 'Africa', 'BNXX0003', 0),
(0, 'Francistown', 'Botswana', 'Africa', 'BCXX0004', 0),
(0, 'Gaberone/Khama', 'Botswana', 'Africa', 'BCXX0005', 0),
(0, 'Gaborone', 'Botswana', 'Africa', 'BCXX0001', 0),
(0, 'Ghanzi', 'Botswana', 'Africa', 'BCXX0006', 0),
(0, 'Jwaneng', 'Botswana', 'Africa', 'BCXX0007', 0),
(0, 'Kasane', 'Botswana', 'Africa', 'BCXX0008', 0),
(0, 'Letlhakane', 'Botswana', 'Africa', 'BCXX0009', 0),
(0, 'Mahalapye', 'Botswana', 'Africa', 'BCXX0010', 0),
(0, 'Maun', 'Botswana', 'Africa', 'BCXX0011', 0),
(0, 'Pandamatenga', 'Botswana', 'Africa', 'BCXX0012', 0),
(0, 'Selebi Phikwe', 'Botswana', 'Africa', 'BCXX0013', 0),
(0, 'Shakawe', 'Botswana', 'Africa', 'BCXX0016', 0),
(0, 'Suapan', 'Botswana', 'Africa', 'BCXX0017', 0),
(0, 'Tsabong', 'Botswana', 'Africa', 'BCXX0014', 0),
(0, 'Tshane', 'Botswana', 'Africa', 'BCXX0015', 0),
(0, 'Ouagadougou', 'Burkina Faso', 'Africa', 'UVXX0001', 0),
(0, 'Bujumbura', 'Burundi', 'Africa', 'BYXX0001', 0),
(0, 'Bafoussam', 'Cameroon', 'Africa', 'CMXX0001', 0),
(0, 'Buea', 'Cameroon', 'Africa', 'CMXX0002', 0),
(0, 'Douala', 'Cameroon', 'Africa', 'CMXX0003', 0),
(0, 'Edea', 'Cameroon', 'Africa', 'CMXX0004', 0),
(0, 'Mamfe', 'Cameroon', 'Africa', 'CMXX0010', 0),
(0, 'Mbalmayo', 'Cameroon', 'Africa', 'CMXX0007', 0),
(0, 'Yaounde', 'Cameroon', 'Africa', 'CMXX0008', 0),
(0, 'Praia', 'Cape Verde', 'Africa', 'CVXX0002', 0),
(0, 'Sal', 'Cape Verde', 'Africa', 'CVXX0001', 0),
(0, 'Bangui', 'Central African Republic', 'Africa', 'CTXX0001', 0),
(0, 'Bimbo', 'Central African Republic', 'Africa', 'CTXX0002', 0),
(0, 'Bangassou', 'Central African Republic', 'Africa', 'CTXX0003', 0),
(0, 'Bossangoa', 'Central African Republic', 'Africa', 'CTXX0004', 0),
(0, 'Faya', 'Chad', 'Africa', 'CDXX0002', 0),
(0, 'Ndjamena', 'Chad', 'Africa', 'CDXX0003', 0),
(0, 'Dzaoudzi', 'Comoros', 'Africa', 'CNXX0001', 0),
(0, 'Moroni/Hahaya', 'Comoros', 'Africa', 'CNXX0003', 0),
(0, 'Baya', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0001', 0),
(0, 'Boma', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0002', 0),
(0, 'Kahemba', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0003', 0),
(0, 'Kananga', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0017', 0),
(0, 'Kinshasa', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0005', 0),
(0, 'Kipushi', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0006', 0),
(0, 'Kisangani', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0007', 0),
(0, 'Likasi', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0008', 0),
(0, 'Lubumbashi', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0009', 0),
(0, 'Matadi', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0010', 0),
(0, 'Mbandaka', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0011', 0),
(0, 'Uvira', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0014', 0),
(0, 'Zongo', 'Democratic Republic Of The Congo', 'Africa', 'CGXX0015', 0),
(0, 'Djibouti', 'Djibouti', 'Africa', 'DJXX0001', 0),
(0, 'Alexandria', 'Egypt', 'Africa', 'EGXX0001', 0),
(0, 'Armant', 'Egypt', 'Africa', 'EGXX0002', 0),
(0, 'Aswan', 'Egypt', 'Africa', 'EGXX0003', 0),
(0, 'Asyut', 'Egypt', 'Africa', 'EGXX0030', 0),
(0, 'Baltim', 'Egypt', 'Africa', 'EGXX0027', 0),
(0, 'Cairo', 'Egypt', 'Africa', 'EGXX0004', 0),
(0, 'El Arish', 'Egypt', 'Africa', 'EGXX0029', 0),
(0, 'El Fayoum', 'Egypt', 'Africa', 'EGXX0005', 0),
(0, 'El Tor', 'Egypt', 'Africa', 'EGXX0034', 0),
(0, 'El-Giza', 'Egypt', 'Africa', 'EGXX0006', 0),
(0, 'Farafra', 'Egypt', 'Africa', 'EGXX0035', 0),
(0, 'Gemsa', 'Egypt', 'Africa', 'EGXX0007', 0),
(0, 'Hurghada', 'Egypt', 'Africa', 'EGXX0008', 0),
(0, 'Ismailia', 'Egypt', 'Africa', 'EGXX0009', 0),
(0, 'Kafr el-Dauwar', 'Egypt', 'Africa', 'EGXX0010', 0),
(0, 'Kharga', 'Egypt', 'Africa', 'EGXX0032', 0),
(0, 'Luxor', 'Egypt', 'Africa', 'EGXX0011', 0),
(0, 'Marsa Alam', 'Egypt', 'Africa', 'EGXX0036', 0),
(0, 'Mersa Matruh', 'Egypt', 'Africa', 'EGXX0012', 0),
(0, 'Nabq', 'Egypt', 'Africa', 'EGXX0013', 0),
(0, 'Port Said/El Gamil', 'Egypt', 'Africa', 'EGXX0028', 0),
(0, 'Port Taufiq', 'Egypt', 'Africa', 'EGXX0014', 0),
(0, 'Qasr Farafra', 'Egypt', 'Africa', 'EGXX0038', 0),
(0, 'Qena', 'Egypt', 'Africa', 'EGXX0015', 0),
(0, 'Quseir', 'Egypt', 'Africa', 'EGXX0016', 0),
(0, 'Safaga', 'Egypt', 'Africa', 'EGXX0017', 0),
(0, 'Saint Catherine', 'Egypt', 'Africa', 'EGXX0039', 0),
(0, 'Sallum Plateau', 'Egypt', 'Africa', 'EGXX0026', 0),
(0, 'Sharm el Sheikh', 'Egypt', 'Africa', 'EGXX0018', 0),
(0, 'Shibin el-Kom', 'Egypt', 'Africa', 'EGXX0019', 0),
(0, 'Shubra el-Kheima', 'Egypt', 'Africa', 'EGXX0020', 0),
(0, 'Sidi Heneish', 'Egypt', 'Africa', 'EGXX0021', 0),
(0, 'Siwa', 'Egypt', 'Africa', 'EGXX0031', 0),
(0, 'Suez', 'Egypt', 'Africa', 'EGXX0022', 0),
(0, 'Thebes', 'Egypt', 'Africa', 'EGXX0023', 0),
(0, 'Zagazig', 'Egypt', 'Africa', 'EGXX0024', 0),
(0, 'Zawiyat Shammas', 'Egypt', 'Africa', 'EGXX0025', 0),
(0, 'Bata', 'Equatorial Guinea', 'Africa', 'EKXX0001', 0),
(0, 'Luba', 'Equatorial Guinea', 'Africa', 'EKXX0002', 0),
(0, 'Malabo', 'Equatorial Guinea', 'Africa', 'EKXX0003', 0),
(0, 'Asmara', 'Eritrea', 'Africa', 'ERXX0001', 0),
(0, 'Keren', 'Eritrea', 'Africa', 'ERXX0002', 0),
(0, 'Addis Ababa', 'Ethiopia', 'Africa', 'ETXX0001', 0),
(0, 'Gode', 'Ethiopia', 'Africa', 'ETXX0003', 0),
(0, 'Gondar', 'Ethiopia', 'Africa', 'ETXX0004', 0),
(0, 'Gore', 'Ethiopia', 'Africa', 'ETXX0005', 0),
(0, 'Jiggiga', 'Ethiopia', 'Africa', 'ETXX0006', 0),
(0, 'Jimma', 'Ethiopia', 'Africa', 'ETXX0002', 0),
(0, 'Neghelli', 'Ethiopia', 'Africa', 'ETXX0007', 0),
(0, 'Bitam', 'Gabon', 'Africa', 'GBXX0006', 0),
(0, 'Franceville', 'Gabon', 'Africa', 'GBXX0001', 0),
(0, 'Koulamoutou', 'Gabon', 'Africa', 'GBXX0002', 0),
(0, 'Lambarene', 'Gabon', 'Africa', 'GBXX0008', 0),
(0, 'Lastoursville', 'Gabon', 'Africa', 'GBXX0003', 0),
(0, 'Libreville', 'Gabon', 'Africa', 'GBXX0004', 0),
(0, 'Moanda', 'Gabon', 'Africa', 'GBXX0007', 0),
(0, 'Port-Gentil', 'Gabon', 'Africa', 'GBXX0005', 0),
(0, 'Accra', 'Ghana', 'Africa', 'GHXX0001', 0),
(0, 'Kumasi', 'Ghana', 'Africa', 'GHXX0003', 0),
(0, 'Tema', 'Ghana', 'Africa', 'GHXX0002', 0),
(0, 'Boffa', 'Guinea', 'Africa', 'GVXX0001', 0),
(0, 'Conakry', 'Guinea', 'Africa', 'GVXX0002', 0),
(0, 'Athi River', 'Kenya', 'Africa', 'KEXX0001', 0),
(0, 'Eldoret', 'Kenya', 'Africa', 'KEXX0020', 0),
(0, 'Garissa', 'Kenya', 'Africa', 'KEXX0016', 0),
(0, 'Kakamega', 'Kenya', 'Africa', 'KEXX0002', 0),
(0, 'Kericho', 'Kenya', 'Africa', 'KEXX0003', 0),
(0, 'Kisii', 'Kenya', 'Africa', 'KEXX0004', 0),
(0, 'Kisumu', 'Kenya', 'Africa', 'KEXX0005', 0),
(0, 'Kitale', 'Kenya', 'Africa', 'KEXX0014', 0),
(0, 'Konza', 'Kenya', 'Africa', 'KEXX0006', 0),
(0, 'Lodwar', 'Kenya', 'Africa', 'KEXX0012', 0),
(0, 'Makindu', 'Kenya', 'Africa', 'KEXX0017', 0),
(0, 'Malindi', 'Kenya', 'Africa', 'KEXX0007', 0),
(0, 'Marsabit', 'Kenya', 'Africa', 'KEXX0013', 0),
(0, 'Meru', 'Kenya', 'Africa', 'KEXX0015', 0),
(0, 'Mombasa', 'Kenya', 'Africa', 'KEXX0008', 0),
(0, 'Nairobi', 'Kenya', 'Africa', 'KEXX0009', 0),
(0, 'Nakuru', 'Kenya', 'Africa', 'KEXX0010', 0),
(0, 'Thika', 'Kenya', 'Africa', 'KEXX0011', 0),
(0, 'Voi', 'Kenya', 'Africa', 'KEXX0018', 0),
(0, 'Wajir', 'Kenya', 'Africa', 'KEXX0019', 0),
(0, 'Maseru', 'Lesotho', 'Africa', 'LTXX0001', 0),
(0, 'Morija', 'Lesotho', 'Africa', 'LTXX0002', 0),
(0, 'Teyateyaneng', 'Lesotho', 'Africa', 'LTXX0003', 0),
(0, 'Monrovia', 'Liberia', 'Africa', 'LIXX0002', 0),
(0, 'Benghazi/Benina', 'Libya', 'Africa', 'LYXX0011', 0),
(0, 'Dirj', 'Libya', 'Africa', 'LYXX0002', 0),
(0, 'Ghadamis', 'Libya', 'Africa', 'LYXX0003', 0),
(0, 'Ghat', 'Libya', 'Africa', 'LYXX0004', 0),
(0, 'Hon', 'Libya', 'Africa', 'LYXX0012', 0),
(0, 'Kufra', 'Libya', 'Africa', 'LYXX0013', 0),
(0, 'Misratah', 'Libya', 'Africa', 'LYXX0005', 0),
(0, 'Murzuq', 'Libya', 'Africa', 'LYXX0006', 0),
(0, 'Taraghin', 'Libya', 'Africa', 'LYXX0008', 0),
(0, 'Tripoli', 'Libya', 'Africa', 'LYXX0009', 0),
(0, 'Ambanja', 'Madagascar', 'Africa', 'MAXX0009', 0),
(0, 'Andevoranto', 'Madagascar', 'Africa', 'MAXX0001', 0),
(0, 'Antananarivo', 'Madagascar', 'Africa', 'MAXX0002', 0),
(0, 'Fort Dauphin', 'Madagascar', 'Africa', 'MAXX0007', 0),
(0, 'Mahajanga', 'Madagascar', 'Africa', 'MAXX0008', 0),
(0, 'Mahavelona', 'Madagascar', 'Africa', 'MAXX0004', 0),
(0, 'Toamasina', 'Madagascar', 'Africa', 'MAXX0006', 0),
(0, 'Dowa', 'Malawi', 'Africa', 'MIXX0001', 0),
(0, 'Lilongwe', 'Malawi', 'Africa', 'MIXX0002', 0),
(0, 'Bamako', 'Mali', 'Africa', 'MLXX0001', 0),
(0, 'Gao', 'Mali', 'Africa', 'MLXX0003', 0),
(0, 'Kayes', 'Mali', 'Africa', 'MLXX0004', 0),
(0, 'Mopti', 'Mali', 'Africa', 'MLXX0005', 0),
(0, 'Segou', 'Mali', 'Africa', 'MLXX0006', 0),
(0, 'Tessalit', 'Mali', 'Africa', 'MLXX0007', 0),
(0, 'Timbuktu', 'Mali', 'Africa', 'MLXX0002', 0),
(0, 'Atar', 'Mauritania', 'Africa', 'MRXX0005', 0),
(0, 'Beila', 'Mauritania', 'Africa', 'MRXX0001', 0),
(0, 'Cansado', 'Mauritania', 'Africa', 'MRXX0002', 0),
(0, 'Nouadhibou', 'Mauritania', 'Africa', 'MRXX0003', 0),
(0, 'Nouakchott', 'Mauritania', 'Africa', 'MRXX0004', 0),
(0, 'Agalega', 'Mauritius', 'Africa', 'MPXX0001', 0),
(0, 'Plaisance Mauritius', 'Mauritius', 'Africa', 'MPXX0004', 0),
(0, 'Rodrigues', 'Mauritius', 'Africa', 'MPXX0003', 0),
(0, 'Saint Brandon Saint Raphael', 'Mauritius', 'Africa', 'MPXX0002', 0),
(0, 'Vacoas Mauritius', 'Mauritius', 'Africa', 'MPXX0005', 0),
(0, 'Dzaoudzi/Pamanzi', 'Mayotte', 'Africa', 'MFXX0001', 0),
(0, 'Agadir Al Massira', 'Morocco', 'Africa', 'MOXX0022', 0),
(0, 'Al Hoceima', 'Morocco', 'Africa', 'MOXX0013', 0),
(0, 'Beni-Mellal', 'Morocco', 'Africa', 'MOXX0018', 0),
(0, 'Casablanca', 'Morocco', 'Africa', 'MOXX0001', 0),
(0, 'El Jadida', 'Morocco', 'Africa', 'MOXX0002', 0),
(0, 'Errachidia', 'Morocco', 'Africa', 'MOXX0020', 0),
(0, 'Es Semara', 'Morocco', 'Africa', 'MOXX0025', 0),
(0, 'Essaouira', 'Morocco', 'Africa', 'MOXX0021', 0),
(0, 'Fes', 'Morocco', 'Africa', 'MOXX0003', 0),
(0, 'Kasba-Tadla', 'Morocco', 'Africa', 'MOXX0017', 0),
(0, 'Larache', 'Morocco', 'Africa', 'MOXX0012', 0),
(0, 'Marrakech', 'Morocco', 'Africa', 'MOXX0004', 0),
(0, 'Meknes', 'Morocco', 'Africa', 'MOXX0005', 0),
(0, 'Midelt', 'Morocco', 'Africa', 'MOXX0019', 0),
(0, 'Mohammedia', 'Morocco', 'Africa', 'MOXX0006', 0),
(0, 'Nouasseur', 'Morocco', 'Africa', 'MOXX0015', 0),
(0, 'Ouarzazate', 'Morocco', 'Africa', 'MOXX0023', 0),
(0, 'Oujda', 'Morocco', 'Africa', 'MOXX0014', 0),
(0, 'Rabat', 'Morocco', 'Africa', 'MOXX0007', 0),
(0, 'Safi', 'Morocco', 'Africa', 'MOXX0016', 0),
(0, 'Sidi Ifni', 'Morocco', 'Africa', 'MOXX0011', 0),
(0, 'Tan-tan', 'Morocco', 'Africa', 'MOXX0024', 0),
(0, 'Tangier', 'Morocco', 'Africa', 'MOXX0008', 0),
(0, 'Taza', 'Morocco', 'Africa', 'MOXX0009', 0),
(0, 'Tetouan', 'Morocco', 'Africa', 'MOXX0010', 0),
(0, 'Beira', 'Mozambique', 'Africa', 'MZXX0001', 0),
(0, 'Lumbo', 'Mozambique', 'Africa', 'MZXX0002', 0),
(0, 'Maputo', 'Mozambique', 'Africa', 'MZXX0003', 0),
(0, 'Mocambique', 'Mozambique', 'Africa', 'MZXX0004', 0),
(0, 'Mogincual', 'Mozambique', 'Africa', 'MZXX0005', 0),
(0, 'Quelimane', 'Mozambique', 'Africa', 'MZXX0007', 0),
(0, 'Xai-Xai', 'Mozambique', 'Africa', 'MZXX0006', 0),
(0, 'Hentiesbaai', 'Namibia', 'Africa', 'WAXX0001', 0),
(0, 'Keetmanshoop', 'Namibia', 'Africa', 'WAXX0006', 0),
(0, 'Luderitz Diaz Point', 'Namibia', 'Africa', 'WAXX0005', 0),
(0, 'Swakopmund', 'Namibia', 'Africa', 'WAXX0002', 0),
(0, 'Walvis Bay', 'Namibia', 'Africa', 'WAXX0003', 0),
(0, 'Windhoek', 'Namibia', 'Africa', 'WAXX0004', 0),
(0, 'Agadez', 'Niger', 'Africa', 'NGXX0001', 0),
(0, 'Assaouas', 'Niger', 'Africa', 'NGXX0002', 0),
(0, 'Bilma', 'Niger', 'Africa', 'NGXX0010', 0),
(0, 'Diffa', 'Niger', 'Africa', 'NGXX0011', 0),
(0, 'Magaria', 'Niger', 'Africa', 'NGXX0008', 0),
(0, 'Maine-Soroa', 'Niger', 'Africa', 'NGXX0009', 0),
(0, 'Maradi', 'Niger', 'Africa', 'NGXX0006', 0),
(0, 'Niamey', 'Niger', 'Africa', 'NGXX0003', 0),
(0, 'Tahoua', 'Niger', 'Africa', 'NGXX0005', 0),
(0, 'Tillabery', 'Niger', 'Africa', 'NGXX0004', 0),
(0, 'Zinder', 'Niger', 'Africa', 'NGXX0007', 0),
(0, 'Aba', 'Nigeria', 'Africa', 'NIXX0001', 0),
(0, 'Abeokuta', 'Nigeria', 'Africa', 'NIXX0002', 0),
(0, 'Abuja', 'Nigeria', 'Africa', 'NIXX0022', 0),
(0, 'Birnin Kebbi', 'Nigeria', 'Africa', 'NIXX0003', 0),
(0, 'Calabar', 'Nigeria', 'Africa', 'NIXX0004', 0),
(0, 'Dange', 'Nigeria', 'Africa', 'NIXX0005', 0),
(0, 'Enugu', 'Nigeria', 'Africa', 'NIXX0006', 0),
(0, 'Gwarzo', 'Nigeria', 'Africa', 'NIXX0007', 0),
(0, 'Ibadan', 'Nigeria', 'Africa', 'NIXX0008', 0),
(0, 'Iwo', 'Nigeria', 'Africa', 'NIXX0009', 0),
(0, 'Kano', 'Nigeria', 'Africa', 'NIXX0010', 0),
(0, 'Kware', 'Nigeria', 'Africa', 'NIXX0011', 0),
(0, 'Lagos', 'Nigeria', 'Africa', 'NIXX0012', 0),
(0, 'Maiduguri', 'Nigeria', 'Africa', 'NIXX0013', 0),
(0, 'Mushin', 'Nigeria', 'Africa', 'NIXX0014', 0),
(0, 'Onitsha', 'Nigeria', 'Africa', 'NIXX0015', 0),
(0, 'Oyo', 'Nigeria', 'Africa', 'NIXX0016', 0),
(0, 'Port Harcourt', 'Nigeria', 'Africa', 'NIXX0017', 0),
(0, 'Sokoto', 'Nigeria', 'Africa', 'NIXX0018', 0),
(0, 'Zaria', 'Nigeria', 'Africa', 'NIXX0019', 0),
(0, 'Brazzaville', 'Republic Of The Congo', 'Africa', 'CFXX0001', 0),
(0, 'Impfondo', 'Republic Of The Congo', 'Africa', 'CFXX0004', 0),
(0, 'Madingo-Kayes', 'Republic Of The Congo', 'Africa', 'CFXX0002', 0),
(0, 'Pointe-Noire', 'Republic Of The Congo', 'Africa', 'CFXX0003', 0),
(0, 'Serge-Frolow Ile Tromelin', 'Reunion', 'Africa', 'REXX0001', 0),
(0, 'Saint-Denis/Gillot', 'Reunion', 'Africa', 'REXX0002', 0),
(0, 'Saint-Pierre', 'Reunion', 'Africa', 'REXX0003', 0),
(0, 'Kigali', 'Rwanda', 'Africa', 'RWXX0001', 0),
(0, 'Sao Tome', 'Sao Tome And Principe', 'Africa', 'TPXX0001', 0),
(0, 'Dakar', 'Senegal', 'Africa', 'SGXX0001', 0),
(0, 'Kabrousse', 'Senegal', 'Africa', 'SGXX0007', 0),
(0, 'Kaolack', 'Senegal', 'Africa', 'SGXX0002', 0),
(0, 'Mbour', 'Senegal', 'Africa', 'SGXX0003', 0),
(0, 'Saint-Louis', 'Senegal', 'Africa', 'SGXX0004', 0),
(0, 'Thies', 'Senegal', 'Africa', 'SGXX0005', 0),
(0, 'Ziguinchor', 'Senegal', 'Africa', 'SGXX0006', 0),
(0, 'Seychelles International Airport', 'Seychelles', 'Africa', 'SEXX0001', 0),
(0, 'Freetown', 'Sierra Leone', 'Africa', 'SLXX0001', 0),
(0, 'Hargeisa', 'Somalia', 'Africa', 'SOXX0003', 0),
(0, 'Kismanyo', 'Somalia', 'Africa', 'SOXX0001', 0),
(0, 'Mogadishu', 'Somalia', 'Africa', 'SOXX0002', 0),
(0, 'Alexander Bay', 'South Africa', 'Africa', 'SFXX0001', 0),
(0, 'Annadale', 'South Africa', 'Africa', 'SFXX0002', 0),
(0, 'Barkly West', 'South Africa', 'Africa', 'SFXX0003', 0),
(0, 'Beauvallon', 'South Africa', 'Africa', 'SFXX0004', 0),
(0, 'Bellville', 'South Africa', 'Africa', 'SFXX0005', 0),
(0, 'Benoni', 'South Africa', 'Africa', 'SFXX0006', 0),
(0, 'Berlin', 'South Africa', 'Africa', 'SFXX0007', 0),
(0, 'Bethlehem Airport', 'South Africa', 'Africa', 'SFXX0062', 0),
(0, 'Bloemfontein', 'South Africa', 'Africa', 'SFXX0008', 0),
(0, 'Boshof', 'South Africa', 'Africa', 'SFXX0009', 0),
(0, 'Calvinia', 'South Africa', 'Africa', 'SFXX0064', 0),
(0, 'Cape Point', 'South Africa', 'Africa', 'SFXX0068', 0),
(0, 'Cape Town', 'South Africa', 'Africa', 'SFXX0010', 0),
(0, 'Durban', 'South Africa', 'Africa', 'SFXX0011', 0),
(0, 'East London', 'South Africa', 'Africa', 'SFXX0012', 0),
(0, 'Edenburg', 'South Africa', 'Africa', 'SFXX0013', 0),
(0, 'Ferreira', 'South Africa', 'Africa', 'SFXX0014', 0),
(0, 'George Airport', 'South Africa', 'Africa', 'SFXX0066', 0),
(0, 'Germiston', 'South Africa', 'Africa', 'SFXX0015', 0),
(0, 'Gough Island', 'South Africa', 'Africa', 'SFXX0067', 0),
(0, 'Grootmis', 'South Africa', 'Africa', 'SFXX0016', 0),
(0, 'Haga-Haga', 'South Africa', 'Africa', 'SFXX0017', 0),
(0, 'Hamburg', 'South Africa', 'Africa', 'SFXX0018', 0),
(0, 'Hermanus', 'South Africa', 'Africa', 'SFXX0019', 0),
(0, 'Illovo', 'South Africa', 'Africa', 'SFXX0020', 0),
(0, 'Jacobsdal', 'South Africa', 'Africa', 'SFXX0021', 0),
(0, 'Jeffrey`s Bay', 'South Africa', 'Africa', 'SFXX0022', 0),
(0, 'Johannesburg', 'South Africa', 'Africa', 'SFXX0023', 0),
(0, 'Kakamas', 'South Africa', 'Africa', 'SFXX0024', 0),
(0, 'Karos', 'South Africa', 'Africa', 'SFXX0025', 0),
(0, 'Keimoes', 'South Africa', 'Africa', 'SFXX0026', 0),
(0, 'Kempton Park', 'South Africa', 'Africa', 'SFXX0027', 0),
(0, 'Kimberley', 'South Africa', 'Africa', 'SFXX0028', 0),
(0, 'King William`s Town', 'South Africa', 'Africa', 'SFXX0029', 0),
(0, 'Kleinsee', 'South Africa', 'Africa', 'SFXX0030', 0),
(0, 'Krugersdorp', 'South Africa', 'Africa', 'SFXX0031', 0),
(0, 'Langebaanweg', 'South Africa', 'Africa', 'SFXX0065', 0),
(0, 'Louisvale', 'South Africa', 'Africa', 'SFXX0032', 0),
(0, 'Lyttelton', 'South Africa', 'Africa', 'SFXX0033', 0),
(0, 'Mafeking', 'South Africa', 'Africa', 'SFXX0071', 0),
(0, 'Malmesbury', 'South Africa', 'Africa', 'SFXX0034', 0),
(0, 'Margate', 'South Africa', 'Africa', 'SFXX0072', 0),
(0, 'Marion Island', 'South Africa', 'Africa', 'SFXX0069', 0),
(0, 'Mphakane', 'South Africa', 'Africa', 'SFXX0035', 0),
(0, 'Nelspruit', 'South Africa', 'Africa', 'SFXX0074', 0),
(0, 'Paarl', 'South Africa', 'Africa', 'SFXX0036', 0),
(0, 'Parow', 'South Africa', 'Africa', 'SFXX0037', 0),
(0, 'Pietermaritzburg', 'South Africa', 'Africa', 'SFXX0070', 0),
(0, 'Pietersburg', 'South Africa', 'Africa', 'SFXX0038', 0),
(0, 'Pinetown', 'South Africa', 'Africa', 'SFXX0039', 0),
(0, 'Port Alfred', 'South Africa', 'Africa', 'SFXX0040', 0),
(0, 'Port Elizabeth', 'South Africa', 'Africa', 'SFXX0041', 0),
(0, 'Port Nolloth', 'South Africa', 'Africa', 'SFXX0042', 0),
(0, 'Potgietersrus', 'South Africa', 'Africa', 'SFXX0043', 0),
(0, 'Pretoria', 'South Africa', 'Africa', 'SFXX0044', 0),
(0, 'Pretoria Irene', 'South Africa', 'Africa', 'SFXX0061', 0),
(0, 'Queenstown', 'South Africa', 'Africa', 'SFXX0073', 0),
(0, 'Ritchie', 'South Africa', 'Africa', 'SFXX0045', 0),
(0, 'Rustenburg', 'South Africa', 'Africa', 'SFXX0046', 0),
(0, 'Saldanha', 'South Africa', 'Africa', 'SFXX0047', 0),
(0, 'Sekuruwe', 'South Africa', 'Africa', 'SFXX0048', 0),
(0, 'Soweto', 'South Africa', 'Africa', 'SFXX0049', 0),
(0, 'Springbok', 'South Africa', 'Africa', 'SFXX0063', 0),
(0, 'Stanger', 'South Africa', 'Africa', 'SFXX0050', 0),
(0, 'Strand', 'South Africa', 'Africa', 'SFXX0051', 0),
(0, 'Tembisa', 'South Africa', 'Africa', 'SFXX0052', 0),
(0, 'Tongaat', 'South Africa', 'Africa', 'SFXX0053', 0),
(0, 'Uitenhage', 'South Africa', 'Africa', 'SFXX0054', 0),
(0, 'Ulco', 'South Africa', 'Africa', 'SFXX0055', 0),
(0, 'Upington', 'South Africa', 'Africa', 'SFXX0056', 0),
(0, 'Vereeniging', 'South Africa', 'Africa', 'SFXX0057', 0),
(0, 'Walmer', 'South Africa', 'Africa', 'SFXX0058', 0),
(0, 'Welkom', 'South Africa', 'Africa', 'SFXX0059', 0),
(0, 'Witbank', 'South Africa', 'Africa', 'SFXX0060', 0),
(0, 'Ascension Island', 'St. Helena', 'Africa', 'SHXX0001', 0),
(0, 'El Obeid', 'Sudan', 'Africa', 'SUXX0001', 0),
(0, 'Khartoum', 'Sudan', 'Africa', 'SUXX0002', 0),
(0, 'Malakal', 'Sudan', 'Africa', 'SUXX0008', 0),
(0, 'Nyala', 'Sudan', 'Africa', 'SUXX0007', 0),
(0, 'Port Sudan', 'Sudan', 'Africa', 'SUXX0003', 0),
(0, 'Umm Durman', 'Sudan', 'Africa', 'SUXX0004', 0),
(0, 'Wad Madani', 'Sudan', 'Africa', 'SUXX0005', 0),
(0, 'Wadi Halfa`', 'Sudan', 'Africa', 'SUXX0006', 0),
(0, 'Mbabane', 'Swaziland', 'Africa', 'WZXX0001', 0),
(0, 'Banjul', 'The Gambia', 'Africa', 'GAXX0001', 0),
(0, 'Lome', 'Togo', 'Africa', 'TOXX0001', 0),
(0, 'Bizerte', 'Tunisia', 'Africa', 'TSXX0001', 0),
(0, 'Chebba', 'Tunisia', 'Africa', 'TSXX0002', 0),
(0, 'Djerba Mellita', 'Tunisia', 'Africa', 'TSXX0018', 0),
(0, 'Gabes', 'Tunisia', 'Africa', 'TSXX0003', 0),
(0, 'Gafsa', 'Tunisia', 'Africa', 'TSXX0016', 0),
(0, 'Houmet Essouk', 'Tunisia', 'Africa', 'TSXX0004', 0),
(0, 'Kairouan', 'Tunisia', 'Africa', 'TSXX0013', 0),
(0, 'Kasserine', 'Tunisia', 'Africa', 'TSXX0021', 0),
(0, 'Kelibia', 'Tunisia', 'Africa', 'TSXX0012', 0),
(0, 'La Marsa', 'Tunisia', 'Africa', 'TSXX0005', 0),
(0, 'Mahres', 'Tunisia', 'Africa', 'TSXX0006', 0),
(0, 'Menzel Bourguiba', 'Tunisia', 'Africa', 'TSXX0007', 0),
(0, 'Monastir-Skanes', 'Tunisia', 'Africa', 'TSXX0015', 0),
(0, 'Remada', 'Tunisia', 'Africa', 'TSXX0019', 0),
(0, 'Sfax', 'Tunisia', 'Africa', 'TSXX0008', 0),
(0, 'Souk-El Arba', 'Tunisia', 'Africa', 'TSXX0020', 0),
(0, 'Sousse', 'Tunisia', 'Africa', 'TSXX0009', 0),
(0, 'Tabarka', 'Tunisia', 'Africa', 'TSXX0011', 0),
(0, 'Thala', 'Tunisia', 'Africa', 'TSXX0014', 0),
(0, 'Tozeur', 'Tunisia', 'Africa', 'TSXX0017', 0),
(0, 'Tunis', 'Tunisia', 'Africa', 'TSXX0010', 0),
(0, 'Entebbe', 'Uganda', 'Africa', 'UGXX0001', 0),
(0, 'Kampala', 'Uganda', 'Africa', 'UGXX0002', 0),
(0, 'Dar es Salaam', 'United Republic Of Tanzania', 'Africa', 'TZXX0001', 0),
(0, 'Dodoma', 'United Republic Of Tanzania', 'Africa', 'TZXX0002', 0),
(0, 'Itetemia', 'United Republic Of Tanzania', 'Africa', 'TZXX0012', 0),
(0, 'Kigoma', 'United Republic Of Tanzania', 'Africa', 'TZXX0003', 0),
(0, 'Maruku', 'United Republic Of Tanzania', 'Africa', 'TZXX0011', 0),
(0, 'Mtwara', 'United Republic Of Tanzania', 'Africa', 'TZXX0004', 0),
(0, 'Mwanza', 'United Republic Of Tanzania', 'Africa', 'TZXX0007', 0),
(0, 'Nduli', 'United Republic Of Tanzania', 'Africa', 'TZXX0010', 0),
(0, 'Tanga', 'United Republic Of Tanzania', 'Africa', 'TZXX0005', 0),
(0, 'Zanzibar', 'United Republic Of Tanzania', 'Africa', 'TZXX0006', 0),
(0, 'Edchera', 'Western Sahara', 'Africa', 'WIXX0001', 0),
(0, 'La Guera', 'Western Sahara', 'Africa', 'WIXX0002', 0),
(0, 'Laayoune', 'Western Sahara', 'Africa', 'WIXX0003', 0),
(0, 'Lemsid', 'Western Sahara', 'Africa', 'WIXX0004', 0),
(0, 'Villa Cisneros', 'Western Sahara', 'Africa', 'WIXX0005', 0),
(0, 'Chingolo', 'Zambia', 'Africa', 'ZAXX0001', 0),
(0, 'Kabwe', 'Zambia', 'Africa', 'ZAXX0002', 0),
(0, 'Livingstone', 'Zambia', 'Africa', 'ZAXX0003', 0),
(0, 'Lusaka', 'Zambia', 'Africa', 'ZAXX0004', 0),
(0, 'Ndola', 'Zambia', 'Africa', 'ZAXX0005', 0),
(0, 'Buffalo Range', 'Zimbabwe', 'Africa', 'ZIXX0011', 0),
(0, 'Bulawayo', 'Zimbabwe', 'Africa', 'ZIXX0001', 0),
(0, 'Chegutu', 'Zimbabwe', 'Africa', 'ZIXX0002', 0),
(0, 'Chitungwiza', 'Zimbabwe', 'Africa', 'ZIXX0003', 0),
(0, 'Harare', 'Zimbabwe', 'Africa', 'ZIXX0004', 0),
(0, 'Hwange National Park', 'Zimbabwe', 'Africa', 'ZIXX0008', 0),
(0, 'Karoi', 'Zimbabwe', 'Africa', 'ZIXX0005', 0),
(0, 'Masvingo', 'Zimbabwe', 'Africa', 'ZIXX0010', 0),
(0, 'Mount Darwin', 'Zimbabwe', 'Africa', 'ZIXX0006', 0),
(0, 'Rusape', 'Zimbabwe', 'Africa', 'ZIXX0009', 0),
(0, 'Victoria Falls', 'Zimbabwe', 'Africa', 'ZIXX0007', 0),
(0, 'Base Arturo Prat', 'Antarctica', 'Antarctica', 'AYXX0007', 0),
(0, 'Base Bernardo O`Higgins', 'Antarctica', 'Antarctica', 'AYXX0009', 0),
(0, 'Base Esperanza', 'Antarctica', 'Antarctica', 'AYXX0001', 0),
(0, 'Base Jubany', 'Antarctica', 'Antarctica', 'AYXX0003', 0),
(0, 'Base Marambio Centro Met. Antartico', 'Antarctica', 'Antarctica', 'AYXX0005', 0),
(0, 'Base Orcadas', 'Antarctica', 'Antarctica', 'AYXX0002', 0),
(0, 'Centro Met. Antartico', 'Antarctica', 'Antarctica', 'AYXX0006', 0),
(0, 'Dinamet-Uruguay', 'Antarctica', 'Antarctica', 'AYXX0004', 0),
(0, 'Great Wall', 'Antarctica', 'Antarctica', 'AYXX0008', 0),
(0, 'McMurdo', 'Antarctica', 'Antarctica', 'AYXX0010', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Hong Kong', 'China', 'Asia', 'CHXX0049', 0),
(0, 'Bost/Laskar', 'Afghanistan', 'Asia', 'AFXX0005', 0),
(0, 'Ghurian', 'Afghanistan', 'Asia', 'AFXX0001', 0),
(0, 'Herat', 'Afghanistan', 'Asia', 'AFXX0002', 0),
(0, 'Kabul', 'Afghanistan', 'Asia', 'AFXX0003', 0),
(0, 'Qandahar', 'Afghanistan', 'Asia', 'AFXX0004', 0),
(0, 'Abovyan', 'Armenia', 'Asia', 'AMXX0001', 0),
(0, 'Gyumri', 'Armenia', 'Asia', 'AMXX0002', 0),
(0, 'Yerevan', 'Armenia', 'Asia', 'AMXX0003', 0),
(0, 'Baku', 'Azerbaijan', 'Asia', 'AJXX0001', 0),
(0, 'Fizuli', 'Azerbaijan', 'Asia', 'AJXX0005', 0),
(0, 'Gyanja', 'Azerbaijan', 'Asia', 'AJXX0006', 0),
(0, 'Lankaran', 'Azerbaijan', 'Asia', 'AJXX0007', 0),
(0, 'Lokbatan', 'Azerbaijan', 'Asia', 'AJXX0002', 0),
(0, 'Mastaga', 'Azerbaijan', 'Asia', 'AJXX0003', 0),
(0, 'Nasosnyy', 'Azerbaijan', 'Asia', 'AJXX0009', 0),
(0, 'Naxcivan', 'Azerbaijan', 'Asia', 'AJXX0004', 0),
(0, 'Zakatala', 'Azerbaijan', 'Asia', 'AJXX0008', 0),
(0, 'Al Manama', 'Bahrain', 'Asia', 'BAXX0001', 0),
(0, 'Al Muharraq', 'Bahrain', 'Asia', 'BAXX0002', 0),
(0, 'Barisal', 'Bangladesh', 'Asia', 'BGXX0001', 0),
(0, 'Bogra', 'Bangladesh', 'Asia', 'BGXX0009', 0),
(0, 'Chittagong', 'Bangladesh', 'Asia', 'BGXX0002', 0),
(0, 'Dhaka', 'Bangladesh', 'Asia', 'BGXX0003', 0),
(0, 'Dhaka/Tezgaon', 'Bangladesh', 'Asia', 'BGXX0014', 0),
(0, 'Ishurdi', 'Bangladesh', 'Asia', 'BGXX0011', 0),
(0, 'Jessore', 'Bangladesh', 'Asia', 'BGXX0004', 0),
(0, 'Khulna', 'Bangladesh', 'Asia', 'BGXX0005', 0),
(0, 'Narayanganj', 'Bangladesh', 'Asia', 'BGXX0006', 0),
(0, 'Rangpur', 'Bangladesh', 'Asia', 'BGXX0008', 0),
(0, 'Sylhet', 'Bangladesh', 'Asia', 'BGXX0010', 0),
(0, 'Tangail', 'Bangladesh', 'Asia', 'BGXX0007', 0),
(0, 'Paro', 'Bhutan', 'Asia', 'BTXX0001', 0),
(0, 'Thimphu', 'Bhutan', 'Asia', 'BTXX0002', 0),
(0, 'Brunei Airport', 'Brunei', 'Asia', 'BXXX0001', 0),
(0, 'Kuala Belait', 'Brunei', 'Asia', 'BXXX0002', 0),
(0, 'Mandalay', 'Burma', 'Asia', 'BMXX0001', 0),
(0, 'Pathein', 'Burma', 'Asia', 'BMXX0002', 0),
(0, 'Pegu', 'Burma', 'Asia', 'BMXX0003', 0),
(0, 'Rangoon', 'Burma', 'Asia', 'BMXX0004', 0),
(0, 'Yangon', 'Burma', 'Asia', 'BMXX0005', 0),
(0, 'Phnom Penh', 'Cambodia', 'Asia', 'CBXX0001', 0),
(0, 'Abag Qi', 'China', 'Asia', 'CHXX0243', 0),
(0, 'Acheng', 'China', 'Asia', 'CHXX0001', 0),
(0, 'Aihui', 'China', 'Asia', 'CHXX0174', 0),
(0, 'Akqi', 'China', 'Asia', 'CHXX0210', 0),
(0, 'Alar', 'China', 'Asia', 'CHXX0212', 0),
(0, 'Altay', 'China', 'Asia', 'CHXX0196', 0),
(0, 'Anda', 'China', 'Asia', 'CHXX0187', 0),
(0, 'Ang`angxi', 'China', 'Asia', 'CHXX0002', 0),
(0, 'Ankang', 'China', 'Asia', 'CHXX0394', 0),
(0, 'Anning', 'China', 'Asia', 'CHXX0003', 0),
(0, 'Anqing', 'China', 'Asia', 'CHXX0452', 0),
(0, 'Anshan', 'China', 'Asia', 'CHXX0004', 0),
(0, 'Anshun', 'China', 'Asia', 'CHXX0005', 0),
(0, 'Anyang', 'China', 'Asia', 'CHXX0269', 0),
(0, 'Arxan', 'China', 'Asia', 'CHXX0182', 0),
(0, 'Bachu', 'China', 'Asia', 'CHXX0211', 0),
(0, 'Bailing-Miao', 'China', 'Asia', 'CHXX0247', 0),
(0, 'Baingoin', 'China', 'Asia', 'CHXX0324', 0),
(0, 'Baise', 'China', 'Asia', 'CHXX0488', 0),
(0, 'Baiyin', 'China', 'Asia', 'CHXX0006', 0),
(0, 'Balguntay', 'China', 'Asia', 'CHXX0204', 0),
(0, 'Baoding', 'China', 'Asia', 'CHXX0308', 0),
(0, 'Baoji', 'China', 'Asia', 'CHXX0387', 0),
(0, 'Baoqing', 'China', 'Asia', 'CHXX0188', 0),
(0, 'Baoshan', 'China', 'Asia', 'CHXX0370', 0),
(0, 'Baotou', 'China', 'Asia', 'CHXX0007', 0),
(0, 'Barkam', 'China', 'Asia', 'CHXX0348', 0),
(0, 'Batang', 'China', 'Asia', 'CHXX0352', 0),
(0, 'Bayan Mod', 'China', 'Asia', 'CHXX0225', 0),
(0, 'Bayanbulak', 'China', 'Asia', 'CHXX0206', 0),
(0, 'Baytik Shan', 'China', 'Asia', 'CHXX0201', 0),
(0, 'Beihai', 'China', 'Asia', 'CHXX0499', 0),
(0, 'Beijing', 'China', 'Asia', 'CHXX0008', 0),
(0, 'Bengbu', 'China', 'Asia', 'CHXX0444', 0),
(0, 'Benxi', 'China', 'Asia', 'CHXX0296', 0),
(0, 'Bijie', 'China', 'Asia', 'CHXX0418', 0),
(0, 'Boxian', 'China', 'Asia', 'CHXX0439', 0),
(0, 'Boyang', 'China', 'Asia', 'CHXX0009', 0),
(0, 'Bugt', 'China', 'Asia', 'CHXX0287', 0),
(0, 'Chang Dao', 'China', 'Asia', 'CHXX0312', 0),
(0, 'Changbai', 'China', 'Asia', 'CHXX0299', 0),
(0, 'Changchun', 'China', 'Asia', 'CHXX0010', 0),
(0, 'Changde', 'China', 'Asia', 'CHXX0416', 0),
(0, 'Changji', 'China', 'Asia', 'CHXX0011', 0),
(0, 'Changling', 'China', 'Asia', 'CHXX0277', 0),
(0, 'Changping', 'China', 'Asia', 'CHXX0012', 0),
(0, 'Changsha', 'China', 'Asia', 'CHXX0013', 0),
(0, 'Changshu', 'China', 'Asia', 'CHXX0014', 0),
(0, 'Changting', 'China', 'Asia', 'CHXX0472', 0),
(0, 'Changzhou', 'China', 'Asia', 'CHXX0015', 0),
(0, 'Chaoyang', 'China', 'Asia', 'CHXX0294', 0),
(0, 'Chengde', 'China', 'Asia', 'CHXX0302', 0),
(0, 'Chengdu', 'China', 'Asia', 'CHXX0016', 0),
(0, 'Chengshantou', 'China', 'Asia', 'CHXX0314', 0),
(0, 'Chenzhou', 'China', 'Asia', 'CHXX0435', 0),
(0, 'Chifeng', 'China', 'Asia', 'CHXX0286', 0),
(0, 'Chongqing', 'China', 'Asia', 'CHXX0017', 0),
(0, 'Chuxiong', 'China', 'Asia', 'CHXX0373', 0),
(0, 'Da Xian', 'China', 'Asia', 'CHXX0400', 0),
(0, 'Da-Qaidam', 'China', 'Asia', 'CHXX0230', 0),
(0, 'Dachen Dao', 'China', 'Asia', 'CHXX0464', 0),
(0, 'Dalad Qi', 'China', 'Asia', 'CHXX0018', 0),
(0, 'Dali', 'China', 'Asia', 'CHXX0371', 0),
(0, 'Dalian', 'China', 'Asia', 'CHXX0019', 0),
(0, 'Dandong', 'China', 'Asia', 'CHXX0306', 0),
(0, 'Danxian', 'China', 'Asia', 'CHXX0505', 0),
(0, 'Daocheng', 'China', 'Asia', 'CHXX0357', 0),
(0, 'Daodi', 'China', 'Asia', 'CHXX0020', 0),
(0, 'Daolin', 'China', 'Asia', 'CHXX0021', 0),
(0, 'Darlag', 'China', 'Asia', 'CHXX0336', 0),
(0, 'Datong', 'China', 'Asia', 'CHXX0251', 0),
(0, 'Datun', 'China', 'Asia', 'CHXX0022', 0),
(0, 'Dawu', 'China', 'Asia', 'CHXX0347', 0),
(0, 'Daxing', 'China', 'Asia', 'CHXX0023', 0),
(0, 'Dege', 'China', 'Asia', 'CHXX0344', 0),
(0, 'Delingha', 'China', 'Asia', 'CHXX0231', 0),
(0, 'Dengqen', 'China', 'Asia', 'CHXX0342', 0),
(0, 'Deqen', 'China', 'Asia', 'CHXX0360', 0),
(0, 'Dinghai', 'China', 'Asia', 'CHXX0455', 0),
(0, 'Dingtao', 'China', 'Asia', 'CHXX0320', 0),
(0, 'Dingxi', 'China', 'Asia', 'CHXX0024', 0),
(0, 'Dingxian', 'China', 'Asia', 'CHXX0025', 0),
(0, 'Dongfang', 'China', 'Asia', 'CHXX0504', 0),
(0, 'Dongsha Dao', 'China', 'Asia', 'CHXX0503', 0),
(0, 'Dongsheng', 'China', 'Asia', 'CHXX0255', 0),
(0, 'Dongtai', 'China', 'Asia', 'CHXX0445', 0),
(0, 'Dulan', 'China', 'Asia', 'CHXX0235', 0),
(0, 'Dunhua', 'China', 'Asia', 'CHXX0284', 0),
(0, 'Dunhuang', 'China', 'Asia', 'CHXX0223', 0),
(0, 'Duolun', 'China', 'Asia', 'CHXX0285', 0),
(0, 'Dushan', 'China', 'Asia', 'CHXX0432', 0),
(0, 'Ejin Qi', 'China', 'Asia', 'CHXX0220', 0),
(0, 'Emei Shan', 'China', 'Asia', 'CHXX0359', 0),
(0, 'Enshi', 'China', 'Asia', 'CHXX0406', 0),
(0, 'Erenhot', 'China', 'Asia', 'CHXX0240', 0),
(0, 'Fangxian', 'China', 'Asia', 'CHXX0395', 0),
(0, 'Fengcheng', 'China', 'Asia', 'CHXX0026', 0),
(0, 'Fengjie', 'China', 'Asia', 'CHXX0401', 0),
(0, 'Fengning', 'China', 'Asia', 'CHXX0292', 0),
(0, 'Fengtai', 'China', 'Asia', 'CHXX0027', 0),
(0, 'Fogang', 'China', 'Asia', 'CHXX0483', 0),
(0, 'Foshan', 'China', 'Asia', 'CHXX0028', 0),
(0, 'Fu-sui', 'China', 'Asia', 'CHXX0030', 0),
(0, 'Fuding', 'China', 'Asia', 'CHXX0469', 0),
(0, 'Fujin', 'China', 'Asia', 'CHXX0185', 0),
(0, 'Fushun', 'China', 'Asia', 'CHXX0029', 0),
(0, 'Fuyang', 'China', 'Asia', 'CHXX0442', 0),
(0, 'Fuyun', 'China', 'Asia', 'CHXX0197', 0),
(0, 'Fuzhou', 'China', 'Asia', 'CHXX0031', 0),
(0, 'Gangca', 'China', 'Asia', 'CHXX0232', 0),
(0, 'Gangu', 'China', 'Asia', 'CHXX0032', 0),
(0, 'Ganyu', 'China', 'Asia', 'CHXX0438', 0),
(0, 'Ganzhou', 'China', 'Asia', 'CHXX0436', 0),
(0, 'Gaoyao', 'China', 'Asia', 'CHXX0491', 0),
(0, 'Gaoyi', 'China', 'Asia', 'CHXX0033', 0),
(0, 'Garze', 'China', 'Asia', 'CHXX0345', 0),
(0, 'Gengma', 'China', 'Asia', 'CHXX0377', 0),
(0, 'Golmud', 'China', 'Asia', 'CHXX0234', 0),
(0, 'Gonggar', 'China', 'Asia', 'CHXX0034', 0),
(0, 'Gongxian', 'China', 'Asia', 'CHXX0035', 0),
(0, 'Guaizihu', 'China', 'Asia', 'CHXX0222', 0),
(0, 'Guang`an', 'China', 'Asia', 'CHXX0036', 0),
(0, 'Guangchang', 'China', 'Asia', 'CHXX0470', 0),
(0, 'Guanghua', 'China', 'Asia', 'CHXX0396', 0),
(0, 'Guangnan', 'China', 'Asia', 'CHXX0477', 0),
(0, 'Guangzhou', 'China', 'Asia', 'CHXX0037', 0),
(0, 'Guiding', 'China', 'Asia', 'CHXX0038', 0),
(0, 'Guilin', 'China', 'Asia', 'CHXX0434', 0),
(0, 'Guiping', 'China', 'Asia', 'CHXX0489', 0),
(0, 'Guiyang', 'China', 'Asia', 'CHXX0039', 0),
(0, 'Gushi', 'China', 'Asia', 'CHXX0443', 0),
(0, 'Guyang', 'China', 'Asia', 'CHXX0040', 0),
(0, 'Haicheng', 'China', 'Asia', 'CHXX0041', 0),
(0, 'Haikou', 'China', 'Asia', 'CHXX0502', 0),
(0, 'Hailar', 'China', 'Asia', 'CHXX0175', 0),
(0, 'Hails', 'China', 'Asia', 'CHXX0244', 0),
(0, 'Hailun', 'China', 'Asia', 'CHXX0183', 0),
(0, 'Haining', 'China', 'Asia', 'CHXX0042', 0),
(0, 'Haiyang', 'China', 'Asia', 'CHXX0319', 0),
(0, 'Haliut', 'China', 'Asia', 'CHXX0246', 0),
(0, 'Hami', 'China', 'Asia', 'CHXX0219', 0),
(0, 'Hangu', 'China', 'Asia', 'CHXX0043', 0),
(0, 'Hangzhou', 'China', 'Asia', 'CHXX0044', 0),
(0, 'Hanjiang', 'China', 'Asia', 'CHXX0045', 0),
(0, 'Hanzhong', 'China', 'Asia', 'CHXX0390', 0),
(0, 'Harbin', 'China', 'Asia', 'CHXX0046', 0),
(0, 'Hechi', 'China', 'Asia', 'CHXX0478', 0),
(0, 'Hechuan', 'China', 'Asia', 'CHXX0047', 0),
(0, 'Hefei', 'China', 'Asia', 'CHXX0448', 0),
(0, 'Hejiang', 'China', 'Asia', 'CHXX0048', 0),
(0, 'Henan', 'China', 'Asia', 'CHXX0337', 0),
(0, 'Hequ', 'China', 'Asia', 'CHXX0256', 0),
(0, 'Heyuan', 'China', 'Asia', 'CHXX0492', 0),
(0, 'Hezuo', 'China', 'Asia', 'CHXX0339', 0),
(0, 'Hoboksar', 'China', 'Asia', 'CHXX0199', 0),
(0, 'Hohhot', 'China', 'Asia', 'CHXX0249', 0),
(0, 'Hong Kong', 'China', 'Asia', 'CHXX0049', 0),
(0, 'Hotan', 'China', 'Asia', 'CHXX0216', 0),
(0, 'Hua Shan', 'China', 'Asia', 'CHXX0388', 0),
(0, 'Hua-yang', 'China', 'Asia', 'CHXX0052', 0),
(0, 'Huade', 'China', 'Asia', 'CHXX0248', 0),
(0, 'Huadian', 'China', 'Asia', 'CHXX0290', 0),
(0, 'Huailai', 'China', 'Asia', 'CHXX0301', 0),
(0, 'Huaiyin', 'China', 'Asia', 'CHXX0515', 0),
(0, 'Huajialing', 'China', 'Asia', 'CHXX0239', 0),
(0, 'Huang Shan', 'China', 'Asia', 'CHXX0453', 0),
(0, 'Huanghuashi', 'China', 'Asia', 'CHXX0517', 0),
(0, 'Huangpi', 'China', 'Asia', 'CHXX0050', 0),
(0, 'Huangshi', 'China', 'Asia', 'CHXX0051', 0),
(0, 'Huili', 'China', 'Asia', 'CHXX0366', 0),
(0, 'Huimin', 'China', 'Asia', 'CHXX0311', 0),
(0, 'Huinan', 'China', 'Asia', 'CHXX0516', 0),
(0, 'Huize', 'China', 'Asia', 'CHXX0367', 0),
(0, 'Huizhou', 'China', 'Asia', 'CHXX0053', 0),
(0, 'Hulan', 'China', 'Asia', 'CHXX0054', 0),
(0, 'Hulin', 'China', 'Asia', 'CHXX0194', 0),
(0, 'Huma', 'China', 'Asia', 'CHXX0172', 0),
(0, 'Huoshan', 'China', 'Asia', 'CHXX0447', 0),
(0, 'Hushitai', 'China', 'Asia', 'CHXX0055', 0),
(0, 'Huzhou', 'China', 'Asia', 'CHXX0056', 0),
(0, 'Jartai', 'China', 'Asia', 'CHXX0252', 0),
(0, 'Jarud Qi', 'China', 'Asia', 'CHXX0275', 0),
(0, 'Ji`An', 'China', 'Asia', 'CHXX0425', 0),
(0, 'Jiangcheng', 'China', 'Asia', 'CHXX0384', 0),
(0, 'Jiangjin', 'China', 'Asia', 'CHXX0057', 0),
(0, 'Jiangling', 'China', 'Asia', 'CHXX0408', 0),
(0, 'Jiangmen', 'China', 'Asia', 'CHXX0058', 0),
(0, 'Jianyang', 'China', 'Asia', 'CHXX0059', 0),
(0, 'Jiaonan', 'China', 'Asia', 'CHXX0060', 0),
(0, 'Jiaoxian', 'China', 'Asia', 'CHXX0061', 0),
(0, 'Jiaxing', 'China', 'Asia', 'CHXX0062', 0),
(0, 'Jiexiu', 'China', 'Asia', 'CHXX0268', 0),
(0, 'Jilin', 'China', 'Asia', 'CHXX0063', 0),
(0, 'Jinan', 'China', 'Asia', 'CHXX0064', 0),
(0, 'Jingdezhen', 'China', 'Asia', 'CHXX0457', 0),
(0, 'Jinghai', 'China', 'Asia', 'CHXX0065', 0),
(0, 'Jinghe', 'China', 'Asia', 'CHXX0202', 0),
(0, 'Jinghong', 'China', 'Asia', 'CHXX0380', 0),
(0, 'Jingyuan', 'China', 'Asia', 'CHXX0066', 0),
(0, 'Jining', 'China', 'Asia', 'CHXX0250', 0),
(0, 'Jinzhou', 'China', 'Asia', 'CHXX0067', 0),
(0, 'Jiujiang', 'China', 'Asia', 'CHXX0068', 0),
(0, 'Jiulong', 'China', 'Asia', 'CHXX0361', 0),
(0, 'Jiuquan', 'China', 'Asia', 'CHXX0226', 0),
(0, 'Jiutai', 'China', 'Asia', 'CHXX0069', 0),
(0, 'Jiuxian Shan', 'China', 'Asia', 'CHXX0475', 0),
(0, 'Jiuzhen', 'China', 'Asia', 'CHXX0070', 0),
(0, 'Jixi', 'China', 'Asia', 'CHXX0193', 0),
(0, 'Jurh', 'China', 'Asia', 'CHXX0245', 0),
(0, 'Jurong', 'China', 'Asia', 'CHXX0071', 0),
(0, 'Kaba He', 'China', 'Asia', 'CHXX0195', 0),
(0, 'Kaifeng', 'China', 'Asia', 'CHXX0072', 0),
(0, 'Kaiyang', 'China', 'Asia', 'CHXX0073', 0),
(0, 'Kangding', 'China', 'Asia', 'CHXX0358', 0),
(0, 'Karamay', 'China', 'Asia', 'CHXX0200', 0),
(0, 'Kashi', 'China', 'Asia', 'CHXX0074', 0),
(0, 'Keshan', 'China', 'Asia', 'CHXX0181', 0),
(0, 'King`s Park', 'China', 'Asia', 'CHXX0170', 0),
(0, 'Korla', 'China', 'Asia', 'CHXX0209', 0),
(0, 'Kowloon', 'China', 'Asia', 'CHXX0075', 0),
(0, 'Kuandian', 'China', 'Asia', 'CHXX0305', 0),
(0, 'Kunming', 'China', 'Asia', 'CHXX0076', 0),
(0, 'Kunyang', 'China', 'Asia', 'CHXX0077', 0),
(0, 'Kuqa', 'China', 'Asia', 'CHXX0208', 0),
(0, 'Lancang', 'China', 'Asia', 'CHXX0379', 0),
(0, 'Langzhong', 'China', 'Asia', 'CHXX0399', 0),
(0, 'Lanxi', 'China', 'Asia', 'CHXX0078', 0),
(0, 'Lanzhou', 'China', 'Asia', 'CHXX0079', 0),
(0, 'Lenghu', 'China', 'Asia', 'CHXX0227', 0),
(0, 'Leting', 'China', 'Asia', 'CHXX0307', 0),
(0, 'Lhasa', 'China', 'Asia', 'CHXX0080', 0),
(0, 'Lhunze', 'China', 'Asia', 'CHXX0329', 0),
(0, 'Lian Xian', 'China', 'Asia', 'CHXX0481', 0),
(0, 'Liangping', 'China', 'Asia', 'CHXX0405', 0),
(0, 'Lianping', 'China', 'Asia', 'CHXX0484', 0),
(0, 'Liaoyang', 'China', 'Asia', 'CHXX0081', 0),
(0, 'Lijing', 'China', 'Asia', 'CHXX0365', 0),
(0, 'Lincang', 'China', 'Asia', 'CHXX0378', 0),
(0, 'Lindong', 'China', 'Asia', 'CHXX0276', 0),
(0, 'Lingling', 'China', 'Asia', 'CHXX0429', 0),
(0, 'Lingxian', 'China', 'Asia', 'CHXX0310', 0),
(0, 'Linhai', 'China', 'Asia', 'CHXX0463', 0),
(0, 'Linhe', 'China', 'Asia', 'CHXX0253', 0),
(0, 'Linjiang', 'China', 'Asia', 'CHXX0297', 0),
(0, 'Lintong', 'China', 'Asia', 'CHXX0082', 0),
(0, 'Linxi', 'China', 'Asia', 'CHXX0281', 0),
(0, 'Lishi', 'China', 'Asia', 'CHXX0264', 0),
(0, 'Lishui', 'China', 'Asia', 'CHXX0461', 0),
(0, 'Litang', 'China', 'Asia', 'CHXX0353', 0),
(0, 'Liuyang', 'China', 'Asia', 'CHXX0083', 0),
(0, 'Liuzhou', 'China', 'Asia', 'CHXX0479', 0),
(0, 'Liyang', 'China', 'Asia', 'CHXX0450', 0),
(0, 'Longkou', 'China', 'Asia', 'CHXX0313', 0),
(0, 'Longli', 'China', 'Asia', 'CHXX0084', 0),
(0, 'Longzhou', 'China', 'Asia', 'CHXX0494', 0),
(0, 'Lu Shan', 'China', 'Asia', 'CHXX0456', 0),
(0, 'Luhe', 'China', 'Asia', 'CHXX0085', 0),
(0, 'Luodian', 'China', 'Asia', 'CHXX0431', 0),
(0, 'Luoyang', 'China', 'Asia', 'CHXX0086', 0),
(0, 'Lushi', 'China', 'Asia', 'CHXX0389', 0),
(0, 'Lushun', 'China', 'Asia', 'CHXX0087', 0),
(0, 'Lusi', 'China', 'Asia', 'CHXX0446', 0),
(0, 'Luxi', 'China', 'Asia', 'CHXX0376', 0),
(0, 'Luzhou', 'China', 'Asia', 'CHXX0088', 0),
(0, 'Macau', 'China', 'Asia', 'CHXX0512', 0),
(0, 'Macheng', 'China', 'Asia', 'CHXX0403', 0),
(0, 'Madoi', 'China', 'Asia', 'CHXX0335', 0),
(0, 'Manas', 'China', 'Asia', 'CHXX0089', 0),
(0, 'Mandal', 'China', 'Asia', 'CHXX0242', 0),
(0, 'Mangnai', 'China', 'Asia', 'CHXX0217', 0),
(0, 'Maoming', 'China', 'Asia', 'CHXX0090', 0),
(0, 'Mazong Shan', 'China', 'Asia', 'CHXX0221', 0),
(0, 'Mei Xian', 'China', 'Asia', 'CHXX0486', 0),
(0, 'Meishan', 'China', 'Asia', 'CHXX0091', 0),
(0, 'Mengla', 'China', 'Asia', 'CHXX0383', 0),
(0, 'Mengshan', 'China', 'Asia', 'CHXX0480', 0),
(0, 'Mengxian', 'China', 'Asia', 'CHXX0092', 0),
(0, 'Mengzi', 'China', 'Asia', 'CHXX0385', 0),
(0, 'Mianyang', 'China', 'Asia', 'CHXX0351', 0),
(0, 'Minhang', 'China', 'Asia', 'CHXX0093', 0),
(0, 'Minqin', 'China', 'Asia', 'CHXX0229', 0),
(0, 'Minqing', 'China', 'Asia', 'CHXX0094', 0),
(0, 'Miquan', 'China', 'Asia', 'CHXX0095', 0),
(0, 'Miyun', 'China', 'Asia', 'CHXX0096', 0),
(0, 'Mohe', 'China', 'Asia', 'CHXX0171', 0),
(0, 'Mudanjiang', 'China', 'Asia', 'CHXX0278', 0),
(0, 'Nagqu', 'China', 'Asia', 'CHXX0325', 0),
(0, 'Nanchang', 'China', 'Asia', 'CHXX0097', 0),
(0, 'Nancheng', 'China', 'Asia', 'CHXX0465', 0),
(0, 'Nanchong', 'China', 'Asia', 'CHXX0098', 0),
(0, 'Nanjing', 'China', 'Asia', 'CHXX0099', 0),
(0, 'Nanning', 'China', 'Asia', 'CHXX0100', 0),
(0, 'Nanping', 'China', 'Asia', 'CHXX0471', 0),
(0, 'Nansha Dao', 'China', 'Asia', 'CHXX0511', 0),
(0, 'Nantong', 'China', 'Asia', 'CHXX0101', 0),
(0, 'Nanxiang', 'China', 'Asia', 'CHXX0102', 0),
(0, 'Nanyang', 'China', 'Asia', 'CHXX0391', 0),
(0, 'Nanyue', 'China', 'Asia', 'CHXX0423', 0),
(0, 'Napo', 'China', 'Asia', 'CHXX0487', 0),
(0, 'Naran Bulag', 'China', 'Asia', 'CHXX0241', 0),
(0, 'Neijiang', 'China', 'Asia', 'CHXX0103', 0),
(0, 'Nenjiang', 'China', 'Asia', 'CHXX0177', 0),
(0, 'New Kowloon', 'China', 'Asia', 'CHXX0104', 0),
(0, 'Ningbo', 'China', 'Asia', 'CHXX0522', 0),
(0, 'Niuzhuang', 'China', 'Asia', 'CHXX0105', 0),
(0, 'Nyingchi', 'China', 'Asia', 'CHXX0356', 0),
(0, 'Otog Qi', 'China', 'Asia', 'CHXX0254', 0),
(0, 'Pagri', 'China', 'Asia', 'CHXX0330', 0),
(0, 'Pingliang', 'China', 'Asia', 'CHXX0270', 0),
(0, 'Pingtan', 'China', 'Asia', 'CHXX0476', 0),
(0, 'Pingwu', 'China', 'Asia', 'CHXX0350', 0),
(0, 'Pingyao', 'China', 'Asia', 'CHXX0106', 0),
(0, 'Pingyin', 'China', 'Asia', 'CHXX0107', 0),
(0, 'Pishan', 'China', 'Asia', 'CHXX0215', 0),
(0, 'Poli', 'China', 'Asia', 'CHXX0108', 0),
(0, 'Potou', 'China', 'Asia', 'CHXX0309', 0),
(0, 'Pucheng', 'China', 'Asia', 'CHXX0468', 0),
(0, 'Pukou', 'China', 'Asia', 'CHXX0109', 0),
(0, 'Qamdo', 'China', 'Asia', 'CHXX0343', 0),
(0, 'Qian Gorlos', 'China', 'Asia', 'CHXX0190', 0),
(0, 'Qijiaojing', 'China', 'Asia', 'CHXX0205', 0),
(0, 'Qingdao', 'China', 'Asia', 'CHXX0110', 0),
(0, 'Qinglong', 'China', 'Asia', 'CHXX0303', 0),
(0, 'Qingyuan', 'China', 'Asia', 'CHXX0289', 0),
(0, 'Qinhuangdao', 'China', 'Asia', 'CHXX0521', 0),
(0, 'Qinzhou', 'China', 'Asia', 'CHXX0498', 0),
(0, 'Qionghai', 'China', 'Asia', 'CHXX0506', 0),
(0, 'Qiqihar', 'China', 'Asia', 'CHXX0112', 0),
(0, 'Qitai', 'China', 'Asia', 'CHXX0113', 0),
(0, 'Qu Xian', 'China', 'Asia', 'CHXX0460', 0),
(0, 'Quanzhou', 'China', 'Asia', 'CHXX0114', 0),
(0, 'Qumarleb', 'China', 'Asia', 'CHXX0333', 0),
(0, 'Rizhao', 'China', 'Asia', 'CHXX0322', 0),
(0, 'Rongjiang', 'China', 'Asia', 'CHXX0433', 0),
(0, 'Ruili', 'China', 'Asia', 'CHXX0375', 0),
(0, 'Ruo`Ergai', 'China', 'Asia', 'CHXX0338', 0),
(0, 'Ruoqiang', 'China', 'Asia', 'CHXX0214', 0),
(0, 'Sangzhi', 'China', 'Asia', 'CHXX0410', 0),
(0, 'Sanhu Dao', 'China', 'Asia', 'CHXX0509', 0),
(0, 'Sansui', 'China', 'Asia', 'CHXX0426', 0),
(0, 'Sertar', 'China', 'Asia', 'CHXX0346', 0),
(0, 'Shache', 'China', 'Asia', 'CHXX0115', 0),
(0, 'Shangchuan Dao', 'China', 'Asia', 'CHXX0501', 0),
(0, 'Shanghai', 'China', 'Asia', 'CHXX0116', 0),
(0, 'Shangzhi', 'China', 'Asia', 'CHXX0192', 0),
(0, 'Shantou', 'China', 'Asia', 'CHXX0493', 0),
(0, 'Shanwei', 'China', 'Asia', 'CHXX0496', 0),
(0, 'Shaoguan', 'China', 'Asia', 'CHXX0482', 0),
(0, 'Shaowu', 'China', 'Asia', 'CHXX0466', 0),
(0, 'Shaoxing', 'China', 'Asia', 'CHXX0117', 0),
(0, 'Shaoyang', 'China', 'Asia', 'CHXX0422', 0),
(0, 'Shashi', 'China', 'Asia', 'CHXX0118', 0),
(0, 'Shengsi', 'China', 'Asia', 'CHXX0454', 0),
(0, 'Shengxian', 'China', 'Asia', 'CHXX0458', 0),
(0, 'Shenyang', 'China', 'Asia', 'CHXX0119', 0),
(0, 'Shenzhen', 'China', 'Asia', 'CHXX0120', 0),
(0, 'Sheyang', 'China', 'Asia', 'CHXX0441', 0),
(0, 'Shiguaigou', 'China', 'Asia', 'CHXX0121', 0),
(0, 'Shijiazhuang', 'China', 'Asia', 'CHXX0122', 0),
(0, 'Shilong', 'China', 'Asia', 'CHXX0123', 0),
(0, 'Shipu', 'China', 'Asia', 'CHXX0459', 0),
(0, 'Shiquanhe', 'China', 'Asia', 'CHXX0323', 0),
(0, 'Shuangcheng', 'China', 'Asia', 'CHXX0124', 0),
(0, 'Shule', 'China', 'Asia', 'CHXX0125', 0),
(0, 'Simao', 'China', 'Asia', 'CHXX0381', 0),
(0, 'Sinan', 'China', 'Asia', 'CHXX0420', 0),
(0, 'Siping', 'China', 'Asia', 'CHXX0283', 0),
(0, 'Sog Xian', 'China', 'Asia', 'CHXX0341', 0),
(0, 'Songpan', 'China', 'Asia', 'CHXX0349', 0),
(0, 'Stanley', 'China', 'Asia', 'CHXX0126', 0),
(0, 'Suifenhe', 'China', 'Asia', 'CHXX0279', 0),
(0, 'Suining', 'China', 'Asia', 'CHXX0127', 0),
(0, 'Sunwu', 'China', 'Asia', 'CHXX0178', 0),
(0, 'Suzhou', 'China', 'Asia', 'CHXX0520', 0),
(0, 'Tacheng', 'China', 'Asia', 'CHXX0198', 0),
(0, 'Taha', 'China', 'Asia', 'CHXX0128', 0),
(0, 'Tai Shan', 'China', 'Asia', 'CHXX0316', 0),
(0, 'Tailai', 'China', 'Asia', 'CHXX0186', 0),
(0, 'Taiyuan', 'China', 'Asia', 'CHXX0129', 0),
(0, 'Tanggu', 'China', 'Asia', 'CHXX0130', 0),
(0, 'Tangshan', 'China', 'Asia', 'CHXX0131', 0),
(0, 'Tengchong', 'China', 'Asia', 'CHXX0369', 0),
(0, 'Tiangang', 'China', 'Asia', 'CHXX0132', 0),
(0, 'Tianjin', 'China', 'Asia', 'CHXX0133', 0),
(0, 'Tianshui', 'China', 'Asia', 'CHXX0386', 0),
(0, 'Tieling', 'China', 'Asia', 'CHXX0134', 0),
(0, 'Tikanlik', 'China', 'Asia', 'CHXX0213', 0),
(0, 'Tingri', 'China', 'Asia', 'CHXX0328', 0),
(0, 'Tongdao', 'China', 'Asia', 'CHXX0427', 0),
(0, 'Tonghe', 'China', 'Asia', 'CHXX0191', 0),
(0, 'Tongliao', 'China', 'Asia', 'CHXX0282', 0),
(0, 'Tulihe', 'China', 'Asia', 'CHXX0173', 0),
(0, 'Tuotuohe', 'China', 'Asia', 'CHXX0331', 0),
(0, 'Turpan', 'China', 'Asia', 'CHXX0207', 0),
(0, 'Uliastai', 'China', 'Asia', 'CHXX0189', 0),
(0, 'Urumqi', 'China', 'Asia', 'CHXX0135', 0),
(0, 'Usu', 'China', 'Asia', 'CHXX0136', 0),
(0, 'Wanyuan', 'China', 'Asia', 'CHXX0393', 0),
(0, 'Weichang', 'China', 'Asia', 'CHXX0293', 0),
(0, 'Weifang', 'China', 'Asia', 'CHXX0318', 0),
(0, 'Weinan', 'China', 'Asia', 'CHXX0137', 0),
(0, 'Weining', 'China', 'Asia', 'CHXX0368', 0),
(0, 'Wenzhou', 'China', 'Asia', 'CHXX0462', 0),
(0, 'Wudaoliang', 'China', 'Asia', 'CHXX0238', 0),
(0, 'Wudu', 'China', 'Asia', 'CHXX0340', 0),
(0, 'Wugang', 'China', 'Asia', 'CHXX0428', 0),
(0, 'Wuhan', 'China', 'Asia', 'CHXX0138', 0),
(0, 'Wuhu', 'China', 'Asia', 'CHXX0449', 0),
(0, 'Wuming', 'China', 'Asia', 'CHXX0139', 0),
(0, 'Wushaoling', 'China', 'Asia', 'CHXX0233', 0),
(0, 'Wutai Shan', 'China', 'Asia', 'CHXX0257', 0),
(0, 'Wuyishan', 'China', 'Asia', 'CHXX0467', 0),
(0, 'Wuzhou', 'China', 'Asia', 'CHXX0490', 0),
(0, 'Xainza', 'China', 'Asia', 'CHXX0326', 0),
(0, 'Xi Ujimqin Qi', 'China', 'Asia', 'CHXX0274', 0),
(0, 'Xi`an', 'China', 'Asia', 'CHXX0141', 0),
(0, 'Xiamen', 'China', 'Asia', 'CHXX0140', 0),
(0, 'Xiangtan', 'China', 'Asia', 'CHXX0142', 0),
(0, 'Xianyang', 'China', 'Asia', 'CHXX0143', 0),
(0, 'Xiao`Ergou', 'China', 'Asia', 'CHXX0176', 0),
(0, 'Xiaogan', 'China', 'Asia', 'CHXX0144', 0),
(0, 'Xichang', 'China', 'Asia', 'CHXX0363', 0),
(0, 'Xifengzhen', 'China', 'Asia', 'CHXX0271', 0),
(0, 'Xigaze', 'China', 'Asia', 'CHXX0145', 0),
(0, 'Xihua', 'China', 'Asia', 'CHXX0392', 0),
(0, 'Xilin Hot', 'China', 'Asia', 'CHXX0280', 0),
(0, 'Xin Barag Youqi', 'China', 'Asia', 'CHXX0179', 0),
(0, 'Xin`an', 'China', 'Asia', 'CHXX0146', 0),
(0, 'Xingren', 'China', 'Asia', 'CHXX0430', 0),
(0, 'Xingtai', 'China', 'Asia', 'CHXX0266', 0),
(0, 'Xining', 'China', 'Asia', 'CHXX0236', 0),
(0, 'Xinjin', 'China', 'Asia', 'CHXX0147', 0),
(0, 'Xinxian', 'China', 'Asia', 'CHXX0315', 0),
(0, 'Xinxiang', 'China', 'Asia', 'CHXX0148', 0),
(0, 'Xinyang', 'China', 'Asia', 'CHXX0149', 0),
(0, 'Xinyi', 'China', 'Asia', 'CHXX0495', 0),
(0, 'Xisha Dao', 'China', 'Asia', 'CHXX0508', 0),
(0, 'Xiushui', 'China', 'Asia', 'CHXX0412', 0),
(0, 'Xunwu', 'China', 'Asia', 'CHXX0485', 0),
(0, 'Xuwen', 'China', 'Asia', 'CHXX0150', 0),
(0, 'Xuzhou', 'China', 'Asia', 'CHXX0437', 0),
(0, 'Ya`An', 'China', 'Asia', 'CHXX0354', 0),
(0, 'Yan An', 'China', 'Asia', 'CHXX0267', 0),
(0, 'Yanchi', 'China', 'Asia', 'CHXX0263', 0),
(0, 'Yangcheng', 'China', 'Asia', 'CHXX0273', 0),
(0, 'Yangjiang', 'China', 'Asia', 'CHXX0500', 0),
(0, 'Yangliuqing', 'China', 'Asia', 'CHXX0151', 0),
(0, 'Yangquan', 'China', 'Asia', 'CHXX0152', 0),
(0, 'Yanji', 'China', 'Asia', 'CHXX0291', 0),
(0, 'Yanzhou', 'China', 'Asia', 'CHXX0321', 0),
(0, 'Yaxian', 'China', 'Asia', 'CHXX0507', 0),
(0, 'Yibin', 'China', 'Asia', 'CHXX0362', 0),
(0, 'Yichang', 'China', 'Asia', 'CHXX0407', 0),
(0, 'Yichuan', 'China', 'Asia', 'CHXX0153', 0),
(0, 'Yichun', 'China', 'Asia', 'CHXX0518', 0),
(0, 'Yichun Heilongjiang', 'China', 'Asia', 'CHXX0513', 0),
(0, 'Yidu', 'China', 'Asia', 'CHXX0154', 0),
(0, 'Yilaxi', 'China', 'Asia', 'CHXX0155', 0),
(0, 'Yinchuan', 'China', 'Asia', 'CHXX0259', 0),
(0, 'Yingkou', 'China', 'Asia', 'CHXX0304', 0),
(0, 'Yining', 'China', 'Asia', 'CHXX0203', 0),
(0, 'Yiwu', 'China', 'Asia', 'CHXX0218', 0),
(0, 'Yiyang', 'China', 'Asia', 'CHXX0156', 0),
(0, 'Yiyuan', 'China', 'Asia', 'CHXX0317', 0),
(0, 'Yong`An', 'China', 'Asia', 'CHXX0473', 0),
(0, 'Yongchuan', 'China', 'Asia', 'CHXX0157', 0),
(0, 'Yongning', 'China', 'Asia', 'CHXX0158', 0),
(0, 'Yongshujiao', 'China', 'Asia', 'CHXX0510', 0),
(0, 'Youyang', 'China', 'Asia', 'CHXX0414', 0),
(0, 'Yu Xian', 'China', 'Asia', 'CHXX0258', 0),
(0, 'Yuanjiang', 'China', 'Asia', 'CHXX0382', 0),
(0, 'Yuanling', 'China', 'Asia', 'CHXX0415', 0),
(0, 'Yuanmou', 'China', 'Asia', 'CHXX0372', 0),
(0, 'Yuanping', 'China', 'Asia', 'CHXX0261', 0),
(0, 'Yucheng', 'China', 'Asia', 'CHXX0159', 0),
(0, 'Yuci', 'China', 'Asia', 'CHXX0160', 0),
(0, 'Yueyang', 'China', 'Asia', 'CHXX0411', 0),
(0, 'Yulin', 'China', 'Asia', 'CHXX0260', 0),
(0, 'Yumenzhen', 'China', 'Asia', 'CHXX0224', 0),
(0, 'Yuncheng', 'China', 'Asia', 'CHXX0272', 0),
(0, 'Yushe', 'China', 'Asia', 'CHXX0265', 0),
(0, 'Yushu', 'China', 'Asia', 'CHXX0334', 0),
(0, 'Zadoi', 'China', 'Asia', 'CHXX0332', 0),
(0, 'Zaoyang', 'China', 'Asia', 'CHXX0397', 0),
(0, 'Zhang Ping', 'China', 'Asia', 'CHXX0474', 0),
(0, 'Zhangjiakou', 'China', 'Asia', 'CHXX0300', 0),
(0, 'Zhangqiu', 'China', 'Asia', 'CHXX0161', 0),
(0, 'Zhangshu', 'China', 'Asia', 'CHXX0111', 0),
(0, 'Zhangwu', 'China', 'Asia', 'CHXX0288', 0),
(0, 'Zhangye', 'China', 'Asia', 'CHXX0228', 0),
(0, 'Zhangzhou', 'China', 'Asia', 'CHXX0162', 0),
(0, 'Zhanjiang', 'China', 'Asia', 'CHXX0163', 0),
(0, 'Zhanyi', 'China', 'Asia', 'CHXX0374', 0),
(0, 'Zhaotong', 'China', 'Asia', 'CHXX0364', 0),
(0, 'Zhengding', 'China', 'Asia', 'CHXX0164', 0),
(0, 'Zhengzhou', 'China', 'Asia', 'CHXX0165', 0),
(0, 'Zhenjiang', 'China', 'Asia', 'CHXX0166', 0),
(0, 'Zhijiang', 'China', 'Asia', 'CHXX0421', 0),
(0, 'Zhongning', 'China', 'Asia', 'CHXX0262', 0),
(0, 'Zhongxiang', 'China', 'Asia', 'CHXX0402', 0),
(0, 'Zhoucun', 'China', 'Asia', 'CHXX0167', 0),
(0, 'Zhumadian', 'China', 'Asia', 'CHXX0398', 0),
(0, 'Zhuozhou', 'China', 'Asia', 'CHXX0168', 0),
(0, 'Zibo', 'China', 'Asia', 'CHXX0169', 0),
(0, 'Zunyi', 'China', 'Asia', 'CHXX0419', 0),
(0, 'Akrotiri', 'Cyprus', 'Asia', 'CYXX0007', 0),
(0, 'C.kormakitis', 'Cyprus', 'Asia', 'CYXX0008', 0),
(0, 'Famagusta', 'Cyprus', 'Asia', 'CYXX0001', 0),
(0, 'Ktima', 'Cyprus', 'Asia', 'CYXX0002', 0),
(0, 'Larnaca', 'Cyprus', 'Asia', 'CYXX0003', 0),
(0, 'Limassol', 'Cyprus', 'Asia', 'CYXX0004', 0),
(0, 'Nicosia', 'Cyprus', 'Asia', 'CYXX0005', 0),
(0, 'Paphos', 'Cyprus', 'Asia', 'CYXX0006', 0),
(0, 'Polis', 'Cyprus', 'Asia', 'CYXX0009', 0),
(0, 'Rizokarpason', 'Cyprus', 'Asia', 'CYXX0010', 0),
(0, 'Troodos', 'Cyprus', 'Asia', 'CYXX0011', 0),
(0, 'Tymvou', 'Cyprus', 'Asia', 'CYXX0012', 0),
(0, 'Matuku', 'Fiji', 'Asia', 'FJXX0007', 0),
(0, 'Nadi', 'Fiji', 'Asia', 'FJXX0001', 0),
(0, 'Nambouwalu', 'Fiji', 'Asia', 'FJXX0002', 0),
(0, 'Nausori', 'Fiji', 'Asia', 'FJXX0005', 0),
(0, 'Ono-I-Lau', 'Fiji', 'Asia', 'FJXX0008', 0),
(0, 'Suva', 'Fiji', 'Asia', 'FJXX0009', 0),
(0, 'Vanua Mbalavu', 'Fiji', 'Asia', 'FJXX0010', 0),
(0, 'Viwa Island', 'Fiji', 'Asia', 'FJXX0004', 0),
(0, 'Vunisea', 'Fiji', 'Asia', 'FJXX0006', 0),
(0, 'Yasawa-I-Rara', 'Fiji', 'Asia', 'FJXX0003', 0),
(0, 'Gori', 'Georgia', 'Asia', 'GGXX0001', 0),
(0, 'K`ut`aisi', 'Georgia', 'Asia', 'GGXX0002', 0),
(0, 'Rustavi', 'Georgia', 'Asia', 'GGXX0003', 0),
(0, 'Tbilisi', 'Georgia', 'Asia', 'GGXX0004', 0),
(0, 'Agartala', 'India', 'Asia', 'INXX0153', 0),
(0, 'Agra', 'India', 'Asia', 'INXX0203', 0),
(0, 'Ahmedabad', 'India', 'Asia', 'INXX0001', 0),
(0, 'Ahmednagar', 'India', 'Asia', 'INXX0183', 0),
(0, 'Aizwal', 'India', 'Asia', 'INXX0200', 0),
(0, 'Ajmer', 'India', 'Asia', 'INXX0002', 0),
(0, 'Akola', 'India', 'Asia', 'INXX0160', 0),
(0, 'Aligarh', 'India', 'Asia', 'INXX0301', 0),
(0, 'Allahabad', 'India', 'Asia', 'INXX0003', 0),
(0, 'Alleppey', 'India', 'Asia', 'INXX0004', 0),
(0, 'Ambala', 'India', 'Asia', 'INXX0302', 0),
(0, 'Amer', 'India', 'Asia', 'INXX0005', 0),
(0, 'Amravati', 'India', 'Asia', 'INXX0006', 0),
(0, 'Amritsar', 'India', 'Asia', 'INXX0007', 0),
(0, 'Anakapalle', 'India', 'Asia', 'INXX0008', 0),
(0, 'Anand', 'India', 'Asia', 'INXX0303', 0),
(0, 'Anantapur', 'India', 'Asia', 'INXX0174', 0),
(0, 'Ara', 'India', 'Asia', 'INXX0009', 0),
(0, 'Aruppukkottai', 'India', 'Asia', 'INXX0010', 0),
(0, 'Asansol', 'India', 'Asia', 'INXX0304', 0),
(0, 'Auraiya', 'India', 'Asia', 'INXX0011', 0),
(0, 'Aurangabad', 'India', 'Asia', 'INXX0184', 0),
(0, 'Aurangabad Chikalthan Aerodrome', 'India', 'Asia', 'INXX0162', 0),
(0, 'Azamgarh', 'India', 'Asia', 'INXX0305', 0),
(0, 'Bagdogra', 'India', 'Asia', 'INXX0220', 0),
(0, 'Baharampur', 'India', 'Asia', 'INXX0306', 0),
(0, 'Balasore', 'India', 'Asia', 'INXX0158', 0),
(0, 'Balia', 'India', 'Asia', 'INXX0307', 0),
(0, 'Banda', 'India', 'Asia', 'INXX0308', 0),
(0, 'Bangalore', 'India', 'Asia', 'INXX0012', 0),
(0, 'Bankura', 'India', 'Asia', 'INXX0206', 0),
(0, 'Barddhaman', 'India', 'Asia', 'INXX0013', 0),
(0, 'Barrackpur', 'India', 'Asia', 'INXX0309', 0),
(0, 'Basirhat', 'India', 'Asia', 'INXX0014', 0),
(0, 'Batala', 'India', 'Asia', 'INXX0015', 0),
(0, 'Belgaum/Sambra', 'India', 'Asia', 'INXX0170', 0),
(0, 'Benares', 'India', 'Asia', 'INXX0016', 0),
(0, 'Bhandara', 'India', 'Asia', 'INXX0017', 0),
(0, 'Bharuch', 'India', 'Asia', 'INXX0310', 0),
(0, 'Bhatinda', 'India', 'Asia', 'INXX0311', 0),
(0, 'Bhatkal', 'India', 'Asia', 'INXX0018', 0),
(0, 'Bhatpara', 'India', 'Asia', 'INXX0019', 0),
(0, 'Bhavani', 'India', 'Asia', 'INXX0312', 0),
(0, 'Bhavnagar', 'India', 'Asia', 'INXX0221', 0),
(0, 'Bhind', 'India', 'Asia', 'INXX0313', 0),
(0, 'Bhiwandi', 'India', 'Asia', 'INXX0020', 0),
(0, 'Bhiwani', 'India', 'Asia', 'INXX0021', 0),
(0, 'Bhongir', 'India', 'Asia', 'INXX0022', 0),
(0, 'Bhopal', 'India', 'Asia', 'INXX0023', 0),
(0, 'Bhubaneshwar', 'India', 'Asia', 'INXX0024', 0),
(0, 'Bhuj-Rudramata', 'India', 'Asia', 'INXX0150', 0),
(0, 'Bidar', 'India', 'Asia', 'INXX0314', 0),
(0, 'Bihar Sharif', 'India', 'Asia', 'INXX0025', 0),
(0, 'Bijnaur', 'India', 'Asia', 'INXX0315', 0),
(0, 'Bikaner', 'India', 'Asia', 'INXX0141', 0),
(0, 'Bilaspur', 'India', 'Asia', 'INXX0316', 0),
(0, 'Bokaro', 'India', 'Asia', 'INXX0317', 0),
(0, 'Bombay', 'India', 'Asia', 'INXX0026', 0),
(0, 'Bulandshahr', 'India', 'Asia', 'INXX0027', 0),
(0, 'Buxar', 'India', 'Asia', 'INXX0318', 0),
(0, 'Calcutta', 'India', 'Asia', 'INXX0028', 0),
(0, 'Chamba', 'India', 'Asia', 'INXX0319', 0),
(0, 'Chandannagar', 'India', 'Asia', 'INXX0320', 0),
(0, 'Chandigarh', 'India', 'Asia', 'INXX0185', 0),
(0, 'Chavakkad', 'India', 'Asia', 'INXX0029', 0),
(0, 'Chennai', 'India', 'Asia', 'INXX0202', 0),
(0, 'Chhapra', 'India', 'Asia', 'INXX0030', 0),
(0, 'Chhindwara', 'India', 'Asia', 'INXX0321', 0),
(0, 'Chitradurga', 'India', 'Asia', 'INXX0173', 0),
(0, 'Chittoor', 'India', 'Asia', 'INXX0031', 0),
(0, 'Cochin', 'India', 'Asia', 'INXX0032', 0),
(0, 'Coimbatore/Peelamedu', 'India', 'Asia', 'INXX0177', 0),
(0, 'Coonoor', 'India', 'Asia', 'INXX0322', 0),
(0, 'Cuddalore', 'India', 'Asia', 'INXX0178', 0),
(0, 'Cuttack', 'India', 'Asia', 'INXX0033', 0),
(0, 'Dadra and Nagar Haveli', 'India', 'Asia', 'INXX0323', 0),
(0, 'Daman', 'India', 'Asia', 'INXX0034', 0),
(0, 'Daosa', 'India', 'Asia', 'INXX0035', 0),
(0, 'Darbhanga', 'India', 'Asia', 'INXX0324', 0),
(0, 'Darjeeling', 'India', 'Asia', 'INXX0036', 0),
(0, 'Daund', 'India', 'Asia', 'INXX0037', 0),
(0, 'Davanagere', 'India', 'Asia', 'INXX0325', 0),
(0, 'Dehradun', 'India', 'Asia', 'INXX0140', 0),
(0, 'Delhi', 'India', 'Asia', 'INXX0038', 0),
(0, 'Dewas', 'India', 'Asia', 'INXX0039', 0),
(0, 'Dhanbad', 'India', 'Asia', 'INXX0326', 0),
(0, 'Dharamsala', 'India', 'Asia', 'INXX0327', 0),
(0, 'Dharwad', 'India', 'Asia', 'INXX0328', 0),
(0, 'Dhule', 'India', 'Asia', 'INXX0329', 0),
(0, 'Dibrugarh/Mohanbari', 'India', 'Asia', 'INXX0143', 0),
(0, 'Dimapur', 'India', 'Asia', 'INXX0330', 0),
(0, 'Dindigul', 'India', 'Asia', 'INXX0040', 0),
(0, 'Dispur', 'India', 'Asia', 'INXX0187', 0),
(0, 'Dod Ballapur', 'India', 'Asia', 'INXX0041', 0),
(0, 'Duraha', 'India', 'Asia', 'INXX0042', 0),
(0, 'Durgapur', 'India', 'Asia', 'INXX0331', 0),
(0, 'Dwarka', 'India', 'Asia', 'INXX0332', 0),
(0, 'Elamanchili', 'India', 'Asia', 'INXX0043', 0),
(0, 'Erode', 'India', 'Asia', 'INXX0333', 0),
(0, 'Etawah', 'India', 'Asia', 'INXX0044', 0),
(0, 'Faizabad', 'India', 'Asia', 'INXX0045', 0),
(0, 'Faridabad', 'India', 'Asia', 'INXX0046', 0),
(0, 'Faridkot', 'India', 'Asia', 'INXX0334', 0),
(0, 'Fatehpur', 'India', 'Asia', 'INXX0047', 0),
(0, 'Ferozepur', 'India', 'Asia', 'INXX0335', 0),
(0, 'Firozabad', 'India', 'Asia', 'INXX0336', 0),
(0, 'Gadag', 'India', 'Asia', 'INXX0171', 0),
(0, 'Gandhinagar', 'India', 'Asia', 'INXX0048', 0),
(0, 'Gangtok', 'India', 'Asia', 'INXX0049', 0),
(0, 'Gaya', 'India', 'Asia', 'INXX0050', 0),
(0, 'Ghaziabad', 'India', 'Asia', 'INXX0051', 0),
(0, 'Ghazipur', 'India', 'Asia', 'INXX0052', 0),
(0, 'Goa', 'India', 'Asia', 'INXX0169', 0),
(0, 'Godhra', 'India', 'Asia', 'INXX0053', 0),
(0, 'Gondia', 'India', 'Asia', 'INXX0337', 0),
(0, 'Greater Noida', 'India', 'Asia', 'INXX0338', 0),
(0, 'Gudivada', 'India', 'Asia', 'INXX0339', 0),
(0, 'Gulbarga', 'India', 'Asia', 'INXX0340', 0),
(0, 'Guntur', 'India', 'Asia', 'INXX0341', 0),
(0, 'Gurgaon', 'India', 'Asia', 'INXX0342', 0),
(0, 'Guwahati', 'India', 'Asia', 'INXX0188', 0),
(0, 'Gwalior', 'India', 'Asia', 'INXX0146', 0),
(0, 'Haldia', 'India', 'Asia', 'INXX0343', 0),
(0, 'Hamirpur', 'India', 'Asia', 'INXX0344', 0),
(0, 'Haora', 'India', 'Asia', 'INXX0054', 0),
(0, 'Hardoi', 'India', 'Asia', 'INXX0345', 0),
(0, 'Haridwar', 'India', 'Asia', 'INXX0346', 0),
(0, 'Hathras', 'India', 'Asia', 'INXX0347', 0),
(0, 'Hazaribagh', 'India', 'Asia', 'INXX0348', 0),
(0, 'Hisar', 'India', 'Asia', 'INXX0055', 0),
(0, 'Honavar', 'India', 'Asia', 'INXX0212', 0),
(0, 'Hoshiarpur', 'India', 'Asia', 'INXX0056', 0),
(0, 'Howrah', 'India', 'Asia', 'INXX0349', 0),
(0, 'Hubli', 'India', 'Asia', 'INXX0350', 0),
(0, 'Hyderabad', 'India', 'Asia', 'INXX0057', 0),
(0, 'Imphal', 'India', 'Asia', 'INXX0189', 0),
(0, 'Indore', 'India', 'Asia', 'INXX0058', 0),
(0, 'Itanagar', 'India', 'Asia', 'INXX0190', 0),
(0, 'Jabalpur', 'India', 'Asia', 'INXX0151', 0),
(0, 'Jagdalpur', 'India', 'Asia', 'INXX0163', 0),
(0, 'Jaipur', 'India', 'Asia', 'INXX0059', 0),
(0, 'Jaisalmer', 'India', 'Asia', 'INXX0144', 0),
(0, 'Jalandhar', 'India', 'Asia', 'INXX0060', 0),
(0, 'Jammu', 'India', 'Asia', 'INXX0222', 0),
(0, 'Jamnagar', 'India', 'Asia', 'INXX0223', 0),
(0, 'Jamshedpur', 'India', 'Asia', 'INXX0156', 0),
(0, 'Jatni', 'India', 'Asia', 'INXX0061', 0),
(0, 'Jaunpur', 'India', 'Asia', 'INXX0062', 0),
(0, 'Jhansi', 'India', 'Asia', 'INXX0351', 0),
(0, 'Jharsuguda', 'India', 'Asia', 'INXX0063', 0),
(0, 'Jodhpur', 'India', 'Asia', 'INXX0145', 0),
(0, 'Jolarpet', 'India', 'Asia', 'INXX0352', 0),
(0, 'Jorhat', 'India', 'Asia', 'INXX0224', 0),
(0, 'Junagadh', 'India', 'Asia', 'INXX0353', 0),
(0, 'Kakinada', 'India', 'Asia', 'INXX0168', 0),
(0, 'Kalimpang', 'India', 'Asia', 'INXX0064', 0),
(0, 'Kalka', 'India', 'Asia', 'INXX0354', 0),
(0, 'Kalyan', 'India', 'Asia', 'INXX0065', 0),
(0, 'Kamthi', 'India', 'Asia', 'INXX0066', 0),
(0, 'Kanchipuram', 'India', 'Asia', 'INXX0355', 0),
(0, 'Kangra', 'India', 'Asia', 'INXX0356', 0),
(0, 'Kanpur', 'India', 'Asia', 'INXX0067', 0),
(0, 'Kanyakumari', 'India', 'Asia', 'INXX0357', 0),
(0, 'Karimnagar', 'India', 'Asia', 'INXX0358', 0),
(0, 'Karnal', 'India', 'Asia', 'INXX0359', 0),
(0, 'Kasaragod', 'India', 'Asia', 'INXX0068', 0),
(0, 'Katra', 'India', 'Asia', 'INXX0360', 0),
(0, 'Kaziranga', 'India', 'Asia', 'INXX0361', 0),
(0, 'Khadki', 'India', 'Asia', 'INXX0069', 0),
(0, 'Khajuraho', 'India', 'Asia', 'INXX0225', 0),
(0, 'Khambhat', 'India', 'Asia', 'INXX0362', 0),
(0, 'Khammam', 'India', 'Asia', 'INXX0070', 0),
(0, 'Kharagpur', 'India', 'Asia', 'INXX0071', 0),
(0, 'Kodaikanal', 'India', 'Asia', 'INXX0363', 0),
(0, 'Kohima', 'India', 'Asia', 'INXX0191', 0),
(0, 'Kolar', 'India', 'Asia', 'INXX0072', 0),
(0, 'Kolhapur', 'India', 'Asia', 'INXX0192', 0),
(0, 'Kolkata', 'India', 'Asia', 'INXX0300', 0),
(0, 'Koregaon', 'India', 'Asia', 'INXX0073', 0),
(0, 'Kottayam', 'India', 'Asia', 'INXX0364', 0),
(0, 'Kovur', 'India', 'Asia', 'INXX0205', 0),
(0, 'Kozhikode', 'India', 'Asia', 'INXX0176', 0),
(0, 'Kullu', 'India', 'Asia', 'INXX0365', 0),
(0, 'Kurnool', 'India', 'Asia', 'INXX0172', 0),
(0, 'Kutch', 'India', 'Asia', 'INXX0366', 0),
(0, 'Lonavala', 'India', 'Asia', 'INXX0367', 0),
(0, 'Lucknow', 'India', 'Asia', 'INXX0074', 0),
(0, 'Ludhiana', 'India', 'Asia', 'INXX0193', 0),
(0, 'Machilipatnam', 'India', 'Asia', 'INXX0167', 0),
(0, 'Madras', 'India', 'Asia', 'INXX0075', 0),
(0, 'Madurai', 'India', 'Asia', 'INXX0076', 0),
(0, 'Mahabaleswar', 'India', 'Asia', 'INXX0368', 0),
(0, 'Mahbubnagar', 'India', 'Asia', 'INXX0077', 0),
(0, 'Mahesana', 'India', 'Asia', 'INXX0078', 0),
(0, 'Malegaon', 'India', 'Asia', 'INXX0079', 0),
(0, 'Mandi', 'India', 'Asia', 'INXX0369', 0),
(0, 'Mandya', 'India', 'Asia', 'INXX0080', 0),
(0, 'Mangalagiri', 'India', 'Asia', 'INXX0370', 0),
(0, 'Mangalore', 'India', 'Asia', 'INXX0081', 0),
(0, 'Margao', 'India', 'Asia', 'INXX0371', 0),
(0, 'Mayurbhanj', 'India', 'Asia', 'INXX0372', 0),
(0, 'Medinipur', 'India', 'Asia', 'INXX0082', 0),
(0, 'Meerut', 'India', 'Asia', 'INXX0083', 0),
(0, 'Mhow', 'India', 'Asia', 'INXX0084', 0),
(0, 'Minicoy', 'India', 'Asia', 'INXX0181', 0),
(0, 'Mirzapur', 'India', 'Asia', 'INXX0085', 0),
(0, 'Moga', 'India', 'Asia', 'INXX0086', 0),
(0, 'Mohali', 'India', 'Asia', 'INXX0373', 0),
(0, 'Mokameh', 'India', 'Asia', 'INXX0374', 0),
(0, 'Motihari', 'India', 'Asia', 'INXX0375', 0),
(0, 'Mumbai', 'India', 'Asia', 'INXX0087', 0),
(0, 'Murshidabad', 'India', 'Asia', 'INXX0376', 0),
(0, 'Murud', 'India', 'Asia', 'INXX0088', 0),
(0, 'Mussoorie', 'India', 'Asia', 'INXX0377', 0),
(0, 'Muzaffarnagar', 'India', 'Asia', 'INXX0089', 0),
(0, 'Muzaffarpur', 'India', 'Asia', 'INXX0090', 0),
(0, 'Mysore', 'India', 'Asia', 'INXX0378', 0),
(0, 'Nadiad', 'India', 'Asia', 'INXX0091', 0),
(0, 'Nagercoil', 'India', 'Asia', 'INXX0092', 0),
(0, 'Nagpur', 'India', 'Asia', 'INXX0093', 0),
(0, 'Nalanda', 'India', 'Asia', 'INXX0379', 0),
(0, 'Nalgonda', 'India', 'Asia', 'INXX0380', 0),
(0, 'Nangal', 'India', 'Asia', 'INXX0381', 0),
(0, 'Nasik', 'India', 'Asia', 'INXX0194', 0),
(0, 'Navi Mumbai', 'India', 'Asia', 'INXX0382', 0),
(0, 'Navsari', 'India', 'Asia', 'INXX0383', 0),
(0, 'Nawabganj', 'India', 'Asia', 'INXX0094', 0),
(0, 'Nellore', 'India', 'Asia', 'INXX0095', 0),
(0, 'New Delhi', 'India', 'Asia', 'INXX0096', 0),
(0, 'New Delhi/Safdarjung', 'India', 'Asia', 'INXX0142', 0),
(0, 'Neyyattinkara', 'India', 'Asia', 'INXX0097', 0),
(0, 'Nizamabad', 'India', 'Asia', 'INXX0098', 0),
(0, 'Noida', 'India', 'Asia', 'INXX0384', 0),
(0, 'Osmanabad', 'India', 'Asia', 'INXX0385', 0),
(0, 'Palwal', 'India', 'Asia', 'INXX0386', 0),
(0, 'Panaji', 'India', 'Asia', 'INXX0387', 0),
(0, 'Panchkula', 'India', 'Asia', 'INXX0388', 0),
(0, 'Panipat', 'India', 'Asia', 'INXX0389', 0),
(0, 'Panvel', 'India', 'Asia', 'INXX0099', 0),
(0, 'Patan', 'India', 'Asia', 'INXX0390', 0),
(0, 'Pathankot', 'India', 'Asia', 'INXX0391', 0),
(0, 'Patiala', 'India', 'Asia', 'INXX0139', 0),
(0, 'Patna', 'India', 'Asia', 'INXX0100', 0),
(0, 'Pendra Road', 'India', 'Asia', 'INXX0155', 0),
(0, 'Pimpri-Chinchwad', 'India', 'Asia', 'INXX0392', 0),
(0, 'Pondicherry', 'India', 'Asia', 'INXX0101', 0),
(0, 'Porbandar', 'India', 'Asia', 'INXX0227', 0),
(0, 'Port Blair', 'India', 'Asia', 'INXX0179', 0),
(0, 'Pune', 'India', 'Asia', 'INXX0102', 0),
(0, 'Puri', 'India', 'Asia', 'INXX0103', 0),
(0, 'Purulia', 'India', 'Asia', 'INXX0393', 0),
(0, 'Quilon', 'India', 'Asia', 'INXX0104', 0),
(0, 'Rae Bareli', 'India', 'Asia', 'INXX0105', 0),
(0, 'Raichur', 'India', 'Asia', 'INXX0394', 0),
(0, 'Raigarh', 'India', 'Asia', 'INXX0106', 0),
(0, 'Raipur', 'India', 'Asia', 'INXX0228', 0),
(0, 'Rajahmundry', 'India', 'Asia', 'INXX0395', 0),
(0, 'Rajapalaiyam', 'India', 'Asia', 'INXX0107', 0),
(0, 'Rajkot', 'India', 'Asia', 'INXX0154', 0),
(0, 'Ranchi', 'India', 'Asia', 'INXX0152', 0),
(0, 'Rangareddy', 'India', 'Asia', 'INXX0396', 0),
(0, 'Ratlam', 'India', 'Asia', 'INXX0397', 0),
(0, 'Ratnagiri', 'India', 'Asia', 'INXX0165', 0),
(0, 'Rishikesh', 'India', 'Asia', 'INXX0398', 0),
(0, 'Rohtak', 'India', 'Asia', 'INXX0108', 0),
(0, 'Roorkee', 'India', 'Asia', 'INXX0399', 0),
(0, 'Rourkela', 'India', 'Asia', 'INXX0400', 0),
(0, 'Saharanpur', 'India', 'Asia', 'INXX0401', 0),
(0, 'Samastipur', 'India', 'Asia', 'INXX0402', 0),
(0, 'Sambalpur', 'India', 'Asia', 'INXX0109', 0),
(0, 'Sanwer', 'India', 'Asia', 'INXX0110', 0),
(0, 'Saraipali', 'India', 'Asia', 'INXX0111', 0),
(0, 'Satara', 'India', 'Asia', 'INXX0112', 0),
(0, 'Satna', 'India', 'Asia', 'INXX0149', 0),
(0, 'Sehore', 'India', 'Asia', 'INXX0113', 0),
(0, 'Shahjahanpur', 'India', 'Asia', 'INXX0403', 0),
(0, 'Shertallai', 'India', 'Asia', 'INXX0114', 0),
(0, 'Shillong', 'India', 'Asia', 'INXX0196', 0),
(0, 'Shimla', 'India', 'Asia', 'INXX0195', 0),
(0, 'Sholapur', 'India', 'Asia', 'INXX0166', 0),
(0, 'Silchar', 'India', 'Asia', 'INXX0404', 0),
(0, 'Siliguri', 'India', 'Asia', 'INXX0405', 0),
(0, 'Sindri', 'India', 'Asia', 'INXX0406', 0),
(0, 'Sitapur', 'India', 'Asia', 'INXX0115', 0),
(0, 'Sivakasi', 'India', 'Asia', 'INXX0116', 0),
(0, 'Siwan', 'India', 'Asia', 'INXX0407', 0),
(0, 'Solapur', 'India', 'Asia', 'INXX0117', 0),
(0, 'Sonipat', 'India', 'Asia', 'INXX0118', 0),
(0, 'Srikakulam', 'India', 'Asia', 'INXX0119', 0),
(0, 'Srinagar', 'India', 'Asia', 'INXX0197', 0),
(0, 'Sultanpur', 'India', 'Asia', 'INXX0408', 0),
(0, 'Surat', 'India', 'Asia', 'INXX0157', 0),
(0, 'Surendranagar', 'India', 'Asia', 'INXX0409', 0),
(0, 'Tambaram', 'India', 'Asia', 'INXX0120', 0),
(0, 'Tenali', 'India', 'Asia', 'INXX0410', 0),
(0, 'Tezpur', 'India', 'Asia', 'INXX0148', 0),
(0, 'Thane', 'India', 'Asia', 'INXX0121', 0),
(0, 'Thanjavur', 'India', 'Asia', 'INXX0411', 0),
(0, 'Thiruvananthapuram', 'India', 'Asia', 'INXX0198', 0),
(0, 'Thoothukudi', 'India', 'Asia', 'INXX0412', 0),
(0, 'Thrissur', 'India', 'Asia', 'INXX0413', 0),
(0, 'Tinsukia', 'India', 'Asia', 'INXX0414', 0),
(0, 'Tiruchchirapalli', 'India', 'Asia', 'INXX0180', 0),
(0, 'Tirupati', 'India', 'Asia', 'INXX0122', 0),
(0, 'Tirupur', 'India', 'Asia', 'INXX0415', 0),
(0, 'Tiruvottiyur', 'India', 'Asia', 'INXX0123', 0),
(0, 'Tonk', 'India', 'Asia', 'INXX0124', 0),
(0, 'Trivandrum', 'India', 'Asia', 'INXX0125', 0),
(0, 'Tumkur', 'India', 'Asia', 'INXX0126', 0),
(0, 'Udaipur', 'India', 'Asia', 'INXX0229', 0),
(0, 'Udhampur', 'India', 'Asia', 'INXX0416', 0),
(0, 'Udupi', 'India', 'Asia', 'INXX0127', 0),
(0, 'Ujjain', 'India', 'Asia', 'INXX0417', 0),
(0, 'Ulhasnagar', 'India', 'Asia', 'INXX0128', 0),
(0, 'Una', 'India', 'Asia', 'INXX0418', 0),
(0, 'Unnao', 'India', 'Asia', 'INXX0129', 0),
(0, 'Uttarkashi', 'India', 'Asia', 'INXX0420', 0),
(0, 'Vadodara', 'India', 'Asia', 'INXX0130', 0),
(0, 'Valsad', 'India', 'Asia', 'INXX0421', 0),
(0, 'Varanasi', 'India', 'Asia', 'INXX0199', 0),
(0, 'Vasai', 'India', 'Asia', 'INXX0422', 0),
(0, 'Vellore', 'India', 'Asia', 'INXX0131', 0),
(0, 'Veraval', 'India', 'Asia', 'INXX0159', 0),
(0, 'Vidisha', 'India', 'Asia', 'INXX0132', 0),
(0, 'Vijayawada', 'India', 'Asia', 'INXX0423', 0),
(0, 'Virudunagar', 'India', 'Asia', 'INXX0133', 0),
(0, 'Visakhapatnam', 'India', 'Asia', 'INXX0134', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Vizianagaram', 'India', 'Asia', 'INXX0135', 0),
(0, 'Warangal', 'India', 'Asia', 'INXX0136', 0),
(0, 'Wardha', 'India', 'Asia', 'INXX0137', 0),
(0, 'Wayanad', 'India', 'Asia', 'INXX0424', 0),
(0, 'Zahirabad', 'India', 'Asia', 'INXX0138', 0),
(0, 'Amahai', 'Indonesia', 'Asia', 'IDXX0001', 0),
(0, 'Ambon', 'Indonesia', 'Asia', 'IDXX0002', 0),
(0, 'Ampenan/Selaparang', 'Indonesia', 'Asia', 'IDXX0080', 0),
(0, 'Amurang', 'Indonesia', 'Asia', 'IDXX0003', 0),
(0, 'Baa', 'Indonesia', 'Asia', 'IDXX0004', 0),
(0, 'Bali', 'Indonesia', 'Asia', 'IDXX0005', 0),
(0, 'Balikpapan', 'Indonesia', 'Asia', 'IDXX0006', 0),
(0, 'Bandung', 'Indonesia', 'Asia', 'IDXX0007', 0),
(0, 'Bangil', 'Indonesia', 'Asia', 'IDXX0008', 0),
(0, 'Banjarmasin', 'Indonesia', 'Asia', 'IDXX0009', 0),
(0, 'Banyuwangi', 'Indonesia', 'Asia', 'IDXX0010', 0),
(0, 'Batam', 'Indonesia', 'Asia', 'IDXX0092', 0),
(0, 'Batang', 'Indonesia', 'Asia', 'IDXX0011', 0),
(0, 'Bengkulu', 'Indonesia', 'Asia', 'IDXX0012', 0),
(0, 'Biak/Mokmer', 'Indonesia', 'Asia', 'IDXX0085', 0),
(0, 'Bima', 'Indonesia', 'Asia', 'IDXX0082', 0),
(0, 'Binjai', 'Indonesia', 'Asia', 'IDXX0013', 0),
(0, 'Bogor', 'Indonesia', 'Asia', 'IDXX0014', 0),
(0, 'Cibatu', 'Indonesia', 'Asia', 'IDXX0015', 0),
(0, 'Cikampek', 'Indonesia', 'Asia', 'IDXX0016', 0),
(0, 'Cilacap', 'Indonesia', 'Asia', 'IDXX0072', 0),
(0, 'Cirebon', 'Indonesia', 'Asia', 'IDXX0017', 0),
(0, 'Curug/Budiarto', 'Indonesia', 'Asia', 'IDXX0068', 0),
(0, 'Delitua', 'Indonesia', 'Asia', 'IDXX0018', 0),
(0, 'Denpasar', 'Indonesia', 'Asia', 'IDXX0019', 0),
(0, 'Fak-Fak/Torea', 'Indonesia', 'Asia', 'IDXX0086', 0),
(0, 'Gorontalo/Jalaluddin', 'Indonesia', 'Asia', 'IDXX0077', 0),
(0, 'Gresik', 'Indonesia', 'Asia', 'IDXX0020', 0),
(0, 'Indramayu', 'Indonesia', 'Asia', 'IDXX0021', 0),
(0, 'Jakarta', 'Indonesia', 'Asia', 'IDXX0022', 0),
(0, 'Jakarta/Soekarno-Hatta', 'Indonesia', 'Asia', 'IDXX0069', 0),
(0, 'Jayapura/Sentani', 'Indonesia', 'Asia', 'IDXX0089', 0),
(0, 'Jepara', 'Indonesia', 'Asia', 'IDXX0023', 0),
(0, 'Kalianget Madura Island', 'Indonesia', 'Asia', 'IDXX0075', 0),
(0, 'Karawang', 'Indonesia', 'Asia', 'IDXX0024', 0),
(0, 'Kayuagung', 'Indonesia', 'Asia', 'IDXX0025', 0),
(0, 'Keramat', 'Indonesia', 'Asia', 'IDXX0091', 0),
(0, 'Klaten', 'Indonesia', 'Asia', 'IDXX0026', 0),
(0, 'Kokonao/Timuka', 'Indonesia', 'Asia', 'IDXX0090', 0),
(0, 'Kotabaru', 'Indonesia', 'Asia', 'IDXX0067', 0),
(0, 'Kretek', 'Indonesia', 'Asia', 'IDXX0027', 0),
(0, 'Kupang', 'Indonesia', 'Asia', 'IDXX0028', 0),
(0, 'Lais', 'Indonesia', 'Asia', 'IDXX0029', 0),
(0, 'Langsa', 'Indonesia', 'Asia', 'IDXX0030', 0),
(0, 'Manado', 'Indonesia', 'Asia', 'IDXX0031', 0),
(0, 'Mataram', 'Indonesia', 'Asia', 'IDXX0032', 0),
(0, 'Maumere/Wai Oti', 'Indonesia', 'Asia', 'IDXX0083', 0),
(0, 'Medan', 'Indonesia', 'Asia', 'IDXX0033', 0),
(0, 'Muaratewe/Beringin', 'Indonesia', 'Asia', 'IDXX0065', 0),
(0, 'Nabire', 'Indonesia', 'Asia', 'IDXX0087', 0),
(0, 'Natal', 'Indonesia', 'Asia', 'IDXX0034', 0),
(0, 'Padang', 'Indonesia', 'Asia', 'IDXX0035', 0),
(0, 'Palangkaraya/Panarung', 'Indonesia', 'Asia', 'IDXX0066', 0),
(0, 'Palembang', 'Indonesia', 'Asia', 'IDXX0036', 0),
(0, 'Palu/Mutiara', 'Indonesia', 'Asia', 'IDXX0078', 0),
(0, 'Pamekasan', 'Indonesia', 'Asia', 'IDXX0037', 0),
(0, 'Pangkalpinang', 'Indonesia', 'Asia', 'IDXX0062', 0),
(0, 'Pasuruan', 'Indonesia', 'Asia', 'IDXX0038', 0),
(0, 'Pedjongkoran', 'Indonesia', 'Asia', 'IDXX0039', 0),
(0, 'Pekalongan', 'Indonesia', 'Asia', 'IDXX0040', 0),
(0, 'Piru', 'Indonesia', 'Asia', 'IDXX0041', 0),
(0, 'Pontianak/Supadio', 'Indonesia', 'Asia', 'IDXX0064', 0),
(0, 'Probolinggo', 'Indonesia', 'Asia', 'IDXX0042', 0),
(0, 'Purwakarta', 'Indonesia', 'Asia', 'IDXX0043', 0),
(0, 'Rangkasbitung', 'Indonesia', 'Asia', 'IDXX0044', 0),
(0, 'Rengat/Japura', 'Indonesia', 'Asia', 'IDXX0061', 0),
(0, 'Samarinda', 'Indonesia', 'Asia', 'IDXX0045', 0),
(0, 'Sangkapura Bawean Island', 'Indonesia', 'Asia', 'IDXX0073', 0),
(0, 'Semarang', 'Indonesia', 'Asia', 'IDXX0046', 0),
(0, 'Serang', 'Indonesia', 'Asia', 'IDXX0047', 0),
(0, 'Sibolga/Pinangsori', 'Indonesia', 'Asia', 'IDXX0059', 0),
(0, 'Singaraja', 'Indonesia', 'Asia', 'IDXX0048', 0),
(0, 'Situbondo', 'Indonesia', 'Asia', 'IDXX0049', 0),
(0, 'Subang', 'Indonesia', 'Asia', 'IDXX0050', 0),
(0, 'Sumbawa Besar', 'Indonesia', 'Asia', 'IDXX0081', 0),
(0, 'Sungaigerong', 'Indonesia', 'Asia', 'IDXX0051', 0),
(0, 'Surabaya', 'Indonesia', 'Asia', 'IDXX0052', 0),
(0, 'Surabaya/Perak', 'Indonesia', 'Asia', 'IDXX0074', 0),
(0, 'Tanjungbalai', 'Indonesia', 'Asia', 'IDXX0053', 0),
(0, 'Tanjungkarang-Telukbetung', 'Indonesia', 'Asia', 'IDXX0054', 0),
(0, 'Tanjungpandan/Buluh Tumbang', 'Indonesia', 'Asia', 'IDXX0063', 0),
(0, 'Tanjungpinang', 'Indonesia', 'Asia', 'IDXX0055', 0),
(0, 'Tarempa', 'Indonesia', 'Asia', 'IDXX0060', 0),
(0, 'Tebingtinggi', 'Indonesia', 'Asia', 'IDXX0056', 0),
(0, 'Tegal', 'Indonesia', 'Asia', 'IDXX0057', 0),
(0, 'Ujung Pandang/Hasanuddin', 'Indonesia', 'Asia', 'IDXX0079', 0),
(0, 'Waingapu/Mau Hau', 'Indonesia', 'Asia', 'IDXX0084', 0),
(0, 'Wamena/Wamena', 'Indonesia', 'Asia', 'IDXX0088', 0),
(0, 'Yogyakarta', 'Indonesia', 'Asia', 'IDXX0058', 0),
(0, 'Abadan', 'Iran', 'Asia', 'IRXX0001', 0),
(0, 'Ahwaz', 'Iran', 'Asia', 'IRXX0032', 0),
(0, 'Arak', 'Iran', 'Asia', 'IRXX0030', 0),
(0, 'Azar Shahr', 'Iran', 'Asia', 'IRXX0002', 0),
(0, 'Babulsar', 'Iran', 'Asia', 'IRXX0026', 0),
(0, 'Bandar-E Anzali', 'Iran', 'Asia', 'IRXX0043', 0),
(0, 'Bandar-E Mahshahr', 'Iran', 'Asia', 'IRXX0040', 0),
(0, 'Bandarabbass', 'Iran', 'Asia', 'IRXX0033', 0),
(0, 'Birjand', 'Iran', 'Asia', 'IRXX0031', 0),
(0, 'Bojnurd', 'Iran', 'Asia', 'IRXX0042', 0),
(0, 'Dow Gonbadan', 'Iran', 'Asia', 'IRXX0037', 0),
(0, 'Esfahan', 'Iran', 'Asia', 'IRXX0003', 0),
(0, 'Eslamshahr', 'Iran', 'Asia', 'IRXX0004', 0),
(0, 'Fasa', 'Iran', 'Asia', 'IRXX0036', 0),
(0, 'Gorgan', 'Iran', 'Asia', 'IRXX0044', 0),
(0, 'Hamedan', 'Iran', 'Asia', 'IRXX0048', 0),
(0, 'Heleylah', 'Iran', 'Asia', 'IRXX0035', 0),
(0, 'Kanavis', 'Iran', 'Asia', 'IRXX0005', 0),
(0, 'Karaj', 'Iran', 'Asia', 'IRXX0006', 0),
(0, 'Kerman', 'Iran', 'Asia', 'IRXX0034', 0),
(0, 'Kermanshah', 'Iran', 'Asia', 'IRXX0029', 0),
(0, 'Khorramabad', 'Iran', 'Asia', 'IRXX0050', 0),
(0, 'Khoy', 'Iran', 'Asia', 'IRXX0022', 0),
(0, 'Maragheh', 'Iran', 'Asia', 'IRXX0049', 0),
(0, 'Marv Dasht', 'Iran', 'Asia', 'IRXX0007', 0),
(0, 'Masheh', 'Iran', 'Asia', 'IRXX0045', 0),
(0, 'Mashhad', 'Iran', 'Asia', 'IRXX0008', 0),
(0, 'Masjed Soleyman', 'Iran', 'Asia', 'IRXX0038', 0),
(0, 'Mehriz', 'Iran', 'Asia', 'IRXX0009', 0),
(0, 'Najafabad', 'Iran', 'Asia', 'IRXX0010', 0),
(0, 'Omidiyeh', 'Iran', 'Asia', 'IRXX0039', 0),
(0, 'Orumieh', 'Iran', 'Asia', 'IRXX0023', 0),
(0, 'Osku', 'Iran', 'Asia', 'IRXX0011', 0),
(0, 'Persepolis', 'Iran', 'Asia', 'IRXX0012', 0),
(0, 'Qomsheh', 'Iran', 'Asia', 'IRXX0013', 0),
(0, 'Ramsar', 'Iran', 'Asia', 'IRXX0025', 0),
(0, 'Rey', 'Iran', 'Asia', 'IRXX0014', 0),
(0, 'Sabzevar', 'Iran', 'Asia', 'IRXX0027', 0),
(0, 'Shahrekord', 'Iran', 'Asia', 'IRXX0047', 0),
(0, 'Shiraz', 'Iran', 'Asia', 'IRXX0015', 0),
(0, 'Tabriz', 'Iran', 'Asia', 'IRXX0016', 0),
(0, 'Taft', 'Iran', 'Asia', 'IRXX0017', 0),
(0, 'Tehran', 'Iran', 'Asia', 'IRXX0018', 0),
(0, 'Torbat-Heydarieh', 'Iran', 'Asia', 'IRXX0028', 0),
(0, 'Yasuj', 'Iran', 'Asia', 'IRXX0046', 0),
(0, 'Yazd', 'Iran', 'Asia', 'IRXX0019', 0),
(0, 'Zahedan', 'Iran', 'Asia', 'IRXX0020', 0),
(0, 'Zanjan', 'Iran', 'Asia', 'IRXX0024', 0),
(0, 'Zargan', 'Iran', 'Asia', 'IRXX0021', 0),
(0, 'Al Azamiyah', 'Iraq', 'Asia', 'IZXX0001', 0),
(0, 'Al Basrah', 'Iraq', 'Asia', 'IZXX0002', 0),
(0, 'Al Hillah', 'Iraq', 'Asia', 'IZXX0003', 0),
(0, 'Al Karkh', 'Iraq', 'Asia', 'IZXX0004', 0),
(0, 'Al Kazimiyah', 'Iraq', 'Asia', 'IZXX0005', 0),
(0, 'Al Kut', 'Iraq', 'Asia', 'IZXX0006', 0),
(0, 'An Nasiriyah', 'Iraq', 'Asia', 'IZXX0007', 0),
(0, 'Ar Rutbah', 'Iraq', 'Asia', 'IZXX0014', 0),
(0, 'Baghdad', 'Iraq', 'Asia', 'IZXX0008', 0),
(0, 'Baqubah', 'Iraq', 'Asia', 'IZXX0009', 0),
(0, 'Mosul', 'Iraq', 'Asia', 'IZXX0010', 0),
(0, 'Najaf', 'Iraq', 'Asia', 'IZXX0013', 0),
(0, 'Nineveh', 'Iraq', 'Asia', 'IZXX0011', 0),
(0, 'Tall Kayf', 'Iraq', 'Asia', 'IZXX0012', 0),
(0, 'Acre', 'Israel', 'Asia', 'ISXX0001', 0),
(0, 'Ariel', 'Israel', 'Asia', 'ISXX0029', 0),
(0, 'Bat Yam', 'Israel', 'Asia', 'ISXX0002', 0),
(0, 'Beersheba', 'Israel', 'Asia', 'ISXX0030', 0),
(0, 'Beit Lahm', 'Israel', 'Asia', 'ISXX0003', 0),
(0, 'Bene Beraq', 'Israel', 'Asia', 'ISXX0004', 0),
(0, 'Elat', 'Israel', 'Asia', 'ISXX0005', 0),
(0, 'Hadera', 'Israel', 'Asia', 'ISXX0006', 0),
(0, 'Haifa', 'Israel', 'Asia', 'ISXX0007', 0),
(0, 'Herzliyya', 'Israel', 'Asia', 'ISXX0008', 0),
(0, 'Holon', 'Israel', 'Asia', 'ISXX0009', 0),
(0, 'Jerusalem', 'Israel', 'Asia', 'ISXX0010', 0),
(0, 'Kiryat Shmone', 'Israel', 'Asia', 'ISXX0031', 0),
(0, 'Lod/Ben Gurion Airport', 'Israel', 'Asia', 'ISXX0011', 0),
(0, 'Nahariyya', 'Israel', 'Asia', 'ISXX0012', 0),
(0, 'Nazareth', 'Israel', 'Asia', 'ISXX0013', 0),
(0, 'Nesher', 'Israel', 'Asia', 'ISXX0014', 0),
(0, 'Netanya', 'Israel', 'Asia', 'ISXX0015', 0),
(0, 'Ovda', 'Israel', 'Asia', 'ISXX0016', 0),
(0, 'Petah Tiqwa', 'Israel', 'Asia', 'ISXX0017', 0),
(0, 'Qiryat Ata', 'Israel', 'Asia', 'ISXX0018', 0),
(0, 'Qiryat Bialik', 'Israel', 'Asia', 'ISXX0019', 0),
(0, 'Qiryat Motzkin', 'Israel', 'Asia', 'ISXX0020', 0),
(0, 'Qiryat Yam', 'Israel', 'Asia', 'ISXX0021', 0),
(0, 'Ramat Gan', 'Israel', 'Asia', 'ISXX0022', 0),
(0, 'Ramla', 'Israel', 'Asia', 'ISXX0023', 0),
(0, 'Rehovot', 'Israel', 'Asia', 'ISXX0024', 0),
(0, 'Rishon LeZiyyon', 'Israel', 'Asia', 'ISXX0025', 0),
(0, 'Tel Aviv-Yafo', 'Israel', 'Asia', 'ISXX0026', 0),
(0, 'Tiberius', 'Israel', 'Asia', 'ISXX0032', 0),
(0, 'Yotvata', 'Israel', 'Asia', 'ISXX0027', 0),
(0, 'Zova', 'Israel', 'Asia', 'ISXX0028', 0),
(0, 'Akita', 'Japan', 'Asia', 'JAXX0001', 0),
(0, 'Akune', 'Japan', 'Asia', 'JAXX0002', 0),
(0, 'Amagasaki', 'Japan', 'Asia', 'JAXX0003', 0),
(0, 'Aomori', 'Japan', 'Asia', 'JAXX0004', 0),
(0, 'Asahikawa', 'Japan', 'Asia', 'JAXX0005', 0),
(0, 'Chiba', 'Japan', 'Asia', 'JAXX0006', 0),
(0, 'Chitose', 'Japan', 'Asia', 'JAXX0121', 0),
(0, 'Choshi', 'Japan', 'Asia', 'JAXX0007', 0),
(0, 'Ebetsu', 'Japan', 'Asia', 'JAXX0008', 0),
(0, 'Fukuoka', 'Japan', 'Asia', 'JAXX0009', 0),
(0, 'Fukushima', 'Japan', 'Asia', 'JAXX0010', 0),
(0, 'Funabashi', 'Japan', 'Asia', 'JAXX0011', 0),
(0, 'Gifu', 'Japan', 'Asia', 'JAXX0012', 0),
(0, 'Hachinohe', 'Japan', 'Asia', 'JAXX0119', 0),
(0, 'Hachioji', 'Japan', 'Asia', 'JAXX0013', 0),
(0, 'Hakodate', 'Japan', 'Asia', 'JAXX0014', 0),
(0, 'Hakui', 'Japan', 'Asia', 'JAXX0015', 0),
(0, 'Hamamatsu', 'Japan', 'Asia', 'JAXX0116', 0),
(0, 'Higashi-osaka', 'Japan', 'Asia', 'JAXX0016', 0),
(0, 'Himeji', 'Japan', 'Asia', 'JAXX0017', 0),
(0, 'Hiroshima', 'Japan', 'Asia', 'JAXX0018', 0),
(0, 'Hitachi', 'Japan', 'Asia', 'JAXX0019', 0),
(0, 'Honjo', 'Japan', 'Asia', 'JAXX0020', 0),
(0, 'Ichikawa', 'Japan', 'Asia', 'JAXX0021', 0),
(0, 'Ichinomiya', 'Japan', 'Asia', 'JAXX0022', 0),
(0, 'Iizuka', 'Japan', 'Asia', 'JAXX0023', 0),
(0, 'Iwakuni', 'Japan', 'Asia', 'JAXX0024', 0),
(0, 'Izumi', 'Japan', 'Asia', 'JAXX0025', 0),
(0, 'Joetsu', 'Japan', 'Asia', 'JAXX0026', 0),
(0, 'Kadena Air Base', 'Japan', 'Asia', 'JAXX0027', 0),
(0, 'Kagoshima', 'Japan', 'Asia', 'JAXX0028', 0),
(0, 'Kamiiso', 'Japan', 'Asia', 'JAXX0029', 0),
(0, 'Kanazawa', 'Japan', 'Asia', 'JAXX0030', 0),
(0, 'Karatsu', 'Japan', 'Asia', 'JAXX0031', 0),
(0, 'Kariya', 'Japan', 'Asia', 'JAXX0032', 0),
(0, 'Kashiwazaki', 'Japan', 'Asia', 'JAXX0033', 0),
(0, 'Kasugai', 'Japan', 'Asia', 'JAXX0034', 0),
(0, 'Kawaguchi', 'Japan', 'Asia', 'JAXX0035', 0),
(0, 'Kawasaki', 'Japan', 'Asia', 'JAXX0036', 0),
(0, 'Kisakata', 'Japan', 'Asia', 'JAXX0037', 0),
(0, 'Kishiwada', 'Japan', 'Asia', 'JAXX0038', 0),
(0, 'Kitakyushu', 'Japan', 'Asia', 'JAXX0039', 0),
(0, 'Kobe', 'Japan', 'Asia', 'JAXX0040', 0),
(0, 'Kofu', 'Japan', 'Asia', 'JAXX0041', 0),
(0, 'Komatsu', 'Japan', 'Asia', 'JAXX0042', 0),
(0, 'Kumamoto', 'Japan', 'Asia', 'JAXX0043', 0),
(0, 'Kurashiki', 'Japan', 'Asia', 'JAXX0044', 0),
(0, 'Kure', 'Japan', 'Asia', 'JAXX0045', 0),
(0, 'Kurume', 'Japan', 'Asia', 'JAXX0046', 0),
(0, 'Kyoto', 'Japan', 'Asia', 'JAXX0047', 0),
(0, 'Machida', 'Japan', 'Asia', 'JAXX0048', 0),
(0, 'Matsudo', 'Japan', 'Asia', 'JAXX0049', 0),
(0, 'Matsumoto/Nagano', 'Japan', 'Asia', 'JAXX0050', 0),
(0, 'Matsuto', 'Japan', 'Asia', 'JAXX0051', 0),
(0, 'Matsuyama', 'Japan', 'Asia', 'JAXX0052', 0),
(0, 'Minamitorishima', 'Japan', 'Asia', 'JAXX0111', 0),
(0, 'Misawa', 'Japan', 'Asia', 'JAXX0120', 0),
(0, 'Mito', 'Japan', 'Asia', 'JAXX0053', 0),
(0, 'Miyazaki', 'Japan', 'Asia', 'JAXX0110', 0),
(0, 'Morioka', 'Japan', 'Asia', 'JAXX0103', 0),
(0, 'Motegi', 'Japan', 'Asia', 'JAXX0113', 0),
(0, 'Nagano', 'Japan', 'Asia', 'JAXX0105', 0),
(0, 'Nagaoka', 'Japan', 'Asia', 'JAXX0054', 0),
(0, 'Nagasaki', 'Japan', 'Asia', 'JAXX0055', 0),
(0, 'Nago', 'Japan', 'Asia', 'JAXX0056', 0),
(0, 'Nagoya', 'Japan', 'Asia', 'JAXX0057', 0),
(0, 'Naha', 'Japan', 'Asia', 'JAXX0058', 0),
(0, 'Nanao', 'Japan', 'Asia', 'JAXX0059', 0),
(0, 'Nara', 'Japan', 'Asia', 'JAXX0060', 0),
(0, 'Narita', 'Japan', 'Asia', 'JAXX0118', 0),
(0, 'Niigata', 'Japan', 'Asia', 'JAXX0061', 0),
(0, 'Noshiro', 'Japan', 'Asia', 'JAXX0062', 0),
(0, 'Ogaki', 'Japan', 'Asia', 'JAXX0063', 0),
(0, 'Okaya', 'Japan', 'Asia', 'JAXX0064', 0),
(0, 'Okayama', 'Japan', 'Asia', 'JAXX0065', 0),
(0, 'Okazaki', 'Japan', 'Asia', 'JAXX0066', 0),
(0, 'Okinawa', 'Japan', 'Asia', 'JAXX0067', 0),
(0, 'Omiya', 'Japan', 'Asia', 'JAXX0068', 0),
(0, 'Omura', 'Japan', 'Asia', 'JAXX0069', 0),
(0, 'Omuta', 'Japan', 'Asia', 'JAXX0070', 0),
(0, 'Osaka', 'Japan', 'Asia', 'JAXX0071', 0),
(0, 'Otaru', 'Japan', 'Asia', 'JAXX0072', 0),
(0, 'Otsu', 'Japan', 'Asia', 'JAXX0073', 0),
(0, 'Sagamihara', 'Japan', 'Asia', 'JAXX0074', 0),
(0, 'Saitama', 'Japan', 'Asia', 'JAXX0117', 0),
(0, 'Sakai', 'Japan', 'Asia', 'JAXX0075', 0),
(0, 'Sakai-Minato', 'Japan', 'Asia', 'JAXX0114', 0),
(0, 'Sakata', 'Japan', 'Asia', 'JAXX0076', 0),
(0, 'Sanjo', 'Japan', 'Asia', 'JAXX0077', 0),
(0, 'Sapporo', 'Japan', 'Asia', 'JAXX0078', 0),
(0, 'Sasebo', 'Japan', 'Asia', 'JAXX0079', 0),
(0, 'Sendai', 'Japan', 'Asia', 'JAXX0104', 0),
(0, 'Shimonoseki', 'Japan', 'Asia', 'JAXX0080', 0),
(0, 'Shizuoka', 'Japan', 'Asia', 'JAXX0107', 0),
(0, 'Suzuka', 'Japan', 'Asia', 'JAXX0112', 0),
(0, 'Takamatsu', 'Japan', 'Asia', 'JAXX0081', 0),
(0, 'Takaoka', 'Japan', 'Asia', 'JAXX0082', 0),
(0, 'Takatsuki', 'Japan', 'Asia', 'JAXX0083', 0),
(0, 'Tokuyama', 'Japan', 'Asia', 'JAXX0084', 0),
(0, 'Tokyo', 'Japan', 'Asia', 'JAXX0085', 0),
(0, 'Tottori', 'Japan', 'Asia', 'JAXX0122', 0),
(0, 'Toyama', 'Japan', 'Asia', 'JAXX0086', 0),
(0, 'Toyonaka', 'Japan', 'Asia', 'JAXX0087', 0),
(0, 'Toyota', 'Japan', 'Asia', 'JAXX0088', 0),
(0, 'Tsu', 'Japan', 'Asia', 'JAXX0089', 0),
(0, 'Tsuruoka', 'Japan', 'Asia', 'JAXX0090', 0),
(0, 'Ube', 'Japan', 'Asia', 'JAXX0091', 0),
(0, 'Ueda', 'Japan', 'Asia', 'JAXX0092', 0),
(0, 'Uji', 'Japan', 'Asia', 'JAXX0093', 0),
(0, 'Utsunomiya', 'Japan', 'Asia', 'JAXX0094', 0),
(0, 'Wakayama', 'Japan', 'Asia', 'JAXX0095', 0),
(0, 'Yamaguchi', 'Japan', 'Asia', 'JAXX0096', 0),
(0, 'Yao', 'Japan', 'Asia', 'JAXX0097', 0),
(0, 'Yokkaichi', 'Japan', 'Asia', 'JAXX0098', 0),
(0, 'Yokohama', 'Japan', 'Asia', 'JAXX0099', 0),
(0, 'Yonago', 'Japan', 'Asia', 'JAXX0115', 0),
(0, 'Yukuhashi', 'Japan', 'Asia', 'JAXX0100', 0),
(0, 'Al Aqabah', 'Jordan', 'Asia', 'JOXX0001', 0),
(0, 'Amman', 'Jordan', 'Asia', 'JOXX0002', 0),
(0, 'Az Zarqa`', 'Jordan', 'Asia', 'JOXX0003', 0),
(0, 'Madaba', 'Jordan', 'Asia', 'JOXX0004', 0),
(0, 'Queen Alia Airport', 'Jordan', 'Asia', 'JOXX0007', 0),
(0, 'Safi', 'Jordan', 'Asia', 'JOXX0008', 0),
(0, 'Sahab', 'Jordan', 'Asia', 'JOXX0005', 0),
(0, 'Zuwayza', 'Jordan', 'Asia', 'JOXX0006', 0),
(0, 'Akkuduk', 'Kazakhstan', 'Asia', 'KZXX0049', 0),
(0, 'Aktjubinsk', 'Kazakhstan', 'Asia', 'KZXX0025', 0),
(0, 'Alekseevka', 'Kazakhstan', 'Asia', 'KZXX0021', 0),
(0, 'Almaty', 'Kazakhstan', 'Asia', 'KZXX0001', 0),
(0, 'Aqmola', 'Kazakhstan', 'Asia', 'KZXX0002', 0),
(0, 'Aral`sk', 'Kazakhstan', 'Asia', 'KZXX0032', 0),
(0, 'Atbasar', 'Kazakhstan', 'Asia', 'KZXX0020', 0),
(0, 'Atyrau', 'Kazakhstan', 'Asia', 'KZXX0003', 0),
(0, 'Atyray', 'Kazakhstan', 'Asia', 'KZXX0031', 0),
(0, 'Aul Turara Ryskulova', 'Kazakhstan', 'Asia', 'KZXX0051', 0),
(0, 'Baikonur', 'Kazakhstan', 'Asia', 'KZXX0055', 0),
(0, 'Bakanas', 'Kazakhstan', 'Asia', 'KZXX0041', 0),
(0, 'Balhash', 'Kazakhstan', 'Asia', 'KZXX0033', 0),
(0, 'Balkasino', 'Kazakhstan', 'Asia', 'KZXX0015', 0),
(0, 'Berlik', 'Kazakhstan', 'Asia', 'KZXX0027', 0),
(0, 'Blacoveschenka', 'Kazakhstan', 'Asia', 'KZXX0011', 0),
(0, 'Cardara', 'Kazakhstan', 'Asia', 'KZXX0054', 0),
(0, 'Chapaevo', 'Kazakhstan', 'Asia', 'KZXX0026', 0),
(0, 'Ciili', 'Kazakhstan', 'Asia', 'KZXX0046', 0),
(0, 'Dzhambejty', 'Kazakhstan', 'Asia', 'KZXX0024', 0),
(0, 'Dzhusaly', 'Kazakhstan', 'Asia', 'KZXX0035', 0),
(0, 'Esil', 'Kazakhstan', 'Asia', 'KZXX0019', 0),
(0, 'Fort Sevcenko', 'Kazakhstan', 'Asia', 'KZXX0044', 0),
(0, 'Irtyshsk', 'Kazakhstan', 'Asia', 'KZXX0017', 0),
(0, 'Karaganda', 'Kazakhstan', 'Asia', 'KZXX0004', 0),
(0, 'Kokpekty', 'Kazakhstan', 'Asia', 'KZXX0039', 0),
(0, 'Kustanai', 'Kazakhstan', 'Asia', 'KZXX0013', 0),
(0, 'Kzyl-Orda', 'Kazakhstan', 'Asia', 'KZXX0045', 0),
(0, 'Leninogorsk', 'Kazakhstan', 'Asia', 'KZXX0038', 0),
(0, 'Lugovoj', 'Kazakhstan', 'Asia', 'KZXX0053', 0),
(0, 'Novotroitskoe', 'Kazakhstan', 'Asia', 'KZXX0048', 0),
(0, 'Novyj Ushtogan', 'Kazakhstan', 'Asia', 'KZXX0018', 0),
(0, 'Oskemen', 'Kazakhstan', 'Asia', 'KZXX0058', 0),
(0, 'Otar', 'Kazakhstan', 'Asia', 'KZXX0043', 0),
(0, 'Panfilov', 'Kazakhstan', 'Asia', 'KZXX0042', 0),
(0, 'Pavlodar', 'Kazakhstan', 'Asia', 'KZXX0037', 0),
(0, 'Petropavlovsk', 'Kazakhstan', 'Asia', 'KZXX0005', 0),
(0, 'Ruzaevka', 'Kazakhstan', 'Asia', 'KZXX0014', 0),
(0, 'Sam', 'Kazakhstan', 'Asia', 'KZXX0034', 0),
(0, 'Segondi', 'Kazakhstan', 'Asia', 'KZXX0057', 0),
(0, 'Shevchenko', 'Kazakhstan', 'Asia', 'KZXX0056', 0),
(0, 'Shymkent', 'Kazakhstan', 'Asia', 'KZXX0006', 0),
(0, 'Sorang', 'Kazakhstan', 'Asia', 'KZXX0007', 0),
(0, 'Stepnogorsk', 'Kazakhstan', 'Asia', 'KZXX0008', 0),
(0, 'Sucinsk', 'Kazakhstan', 'Asia', 'KZXX0016', 0),
(0, 'Taipak', 'Kazakhstan', 'Asia', 'KZXX0028', 0),
(0, 'Talghar', 'Kazakhstan', 'Asia', 'KZXX0009', 0),
(0, 'Temir', 'Kazakhstan', 'Asia', 'KZXX0029', 0),
(0, 'Temirtau', 'Kazakhstan', 'Asia', 'KZXX0010', 0),
(0, 'Turkestan', 'Kazakhstan', 'Asia', 'KZXX0047', 0),
(0, 'Uralsk', 'Kazakhstan', 'Asia', 'KZXX0022', 0),
(0, 'Urdzhar', 'Kazakhstan', 'Asia', 'KZXX0040', 0),
(0, 'Uricky', 'Kazakhstan', 'Asia', 'KZXX0012', 0),
(0, 'Zhaltyr', 'Kazakhstan', 'Asia', 'KZXX0023', 0),
(0, 'Zhambyl', 'Kazakhstan', 'Asia', 'KZXX0052', 0),
(0, 'Zhezkazgan', 'Kazakhstan', 'Asia', 'KZXX0030', 0),
(0, 'Zlikha', 'Kazakhstan', 'Asia', 'KZXX0036', 0),
(0, 'Butaritari', 'Kiribati', 'Asia', 'KRXX0001', 0),
(0, 'Christmas/Cassidy', 'Kiribati', 'Asia', 'KRXX0003', 0),
(0, 'Tarawa', 'Kiribati', 'Asia', 'KRXX0002', 0),
(0, 'Al Jahrah', 'Kuwait', 'Asia', 'KUXX0001', 0),
(0, 'As Sulaybiyah', 'Kuwait', 'Asia', 'KUXX0002', 0),
(0, 'Kuwait City', 'Kuwait', 'Asia', 'KUXX0003', 0),
(0, 'Bishkek', 'Kyrgyzstan', 'Asia', 'KGXX0001', 0),
(0, 'Dzangydzher', 'Kyrgyzstan', 'Asia', 'KGXX0011', 0),
(0, 'Dzhalal-Abad', 'Kyrgyzstan', 'Asia', 'KGXX0009', 0),
(0, 'Dzhangypakhta', 'Kyrgyzstan', 'Asia', 'KGXX0010', 0),
(0, 'Frunze', 'Kyrgyzstan', 'Asia', 'KGXX0002', 0),
(0, 'Kant', 'Kyrgyzstan', 'Asia', 'KGXX0003', 0),
(0, 'Naryn', 'Kyrgyzstan', 'Asia', 'KGXX0005', 0),
(0, 'Osh', 'Kyrgyzstan', 'Asia', 'KGXX0012', 0),
(0, 'Talas', 'Kyrgyzstan', 'Asia', 'KGXX0007', 0),
(0, 'Tian-Shan', 'Kyrgyzstan', 'Asia', 'KGXX0006', 0),
(0, 'Tokmak', 'Kyrgyzstan', 'Asia', 'KGXX0004', 0),
(0, 'Vientiane', 'Laos', 'Asia', 'LAXX0001', 0),
(0, 'Ash Shuwayfat', 'Lebanon', 'Asia', 'LEXX0001', 0),
(0, 'Babda', 'Lebanon', 'Asia', 'LEXX0002', 0),
(0, 'Beirut', 'Lebanon', 'Asia', 'LEXX0003', 0),
(0, 'Furn ash Shubbak', 'Lebanon', 'Asia', 'LEXX0004', 0),
(0, 'Houche-Al-Oumara', 'Lebanon', 'Asia', 'LEXX0006', 0),
(0, 'Juniyah', 'Lebanon', 'Asia', 'LEXX0005', 0),
(0, 'Tripoli', 'Lebanon', 'Asia', 'LEXX0007', 0),
(0, 'Batu Pahat', 'Malaysia', 'Asia', 'MYXX0001', 0),
(0, 'Bintulu', 'Malaysia', 'Asia', 'MYXX0025', 0),
(0, 'George Town', 'Malaysia', 'Asia', 'MYXX0002', 0),
(0, 'Ipoh', 'Malaysia', 'Asia', 'MYXX0003', 0),
(0, 'Jitra Kuala Nerang', 'Malaysia', 'Asia', 'MYXX0034', 0),
(0, 'Johor Bahru', 'Malaysia', 'Asia', 'MYXX0004', 0),
(0, 'Kajang', 'Malaysia', 'Asia', 'MYXX0005', 0),
(0, 'Klang', 'Malaysia', 'Asia', 'MYXX0006', 0),
(0, 'Kota Bharu', 'Malaysia', 'Asia', 'MYXX0023', 0),
(0, 'Kota Kinabalu', 'Malaysia', 'Asia', 'MYXX0028', 0),
(0, 'Kuala Dungun', 'Malaysia', 'Asia', 'MYXX0007', 0),
(0, 'Kuala Lumpur', 'Malaysia', 'Asia', 'MYXX0008', 0),
(0, 'Kuala Terengganu', 'Malaysia', 'Asia', 'MYXX0009', 0),
(0, 'Kuantan', 'Malaysia', 'Asia', 'MYXX0010', 0),
(0, 'Kuching', 'Malaysia', 'Asia', 'MYXX0011', 0),
(0, 'Kudat', 'Malaysia', 'Asia', 'MYXX0035', 0),
(0, 'Labuan', 'Malaysia', 'Asia', 'MYXX0027', 0),
(0, 'Langkawi', 'Malaysia', 'Asia', 'MYXX0032', 0),
(0, 'Lundu', 'Malaysia', 'Asia', 'MYXX0012', 0),
(0, 'Melaka', 'Malaysia', 'Asia', 'MYXX0013', 0),
(0, 'Mersing', 'Malaysia', 'Asia', 'MYXX0033', 0),
(0, 'Miri', 'Malaysia', 'Asia', 'MYXX0026', 0),
(0, 'Muar', 'Malaysia', 'Asia', 'MYXX0014', 0),
(0, 'Pekan', 'Malaysia', 'Asia', 'MYXX0015', 0),
(0, 'Penang/Bayan Lepas', 'Malaysia', 'Asia', 'MYXX0022', 0),
(0, 'Sandakan', 'Malaysia', 'Asia', 'MYXX0030', 0),
(0, 'Segamat', 'Malaysia', 'Asia', 'MYXX0016', 0),
(0, 'Sepang', 'Malaysia', 'Asia', 'MYXX0031', 0),
(0, 'Seremban', 'Malaysia', 'Asia', 'MYXX0017', 0),
(0, 'Serian', 'Malaysia', 'Asia', 'MYXX0018', 0),
(0, 'Sibu', 'Malaysia', 'Asia', 'MYXX0019', 0),
(0, 'Simanggang', 'Malaysia', 'Asia', 'MYXX0020', 0),
(0, 'Sitiawan', 'Malaysia', 'Asia', 'MYXX0024', 0),
(0, 'Tawau', 'Malaysia', 'Asia', 'MYXX0029', 0),
(0, 'Teluk Intan', 'Malaysia', 'Asia', 'MYXX0021', 0),
(0, 'Aldar', 'Mongolia', 'Asia', 'MGXX0001', 0),
(0, 'Altai', 'Mongolia', 'Asia', 'MGXX0023', 0),
(0, 'Arvaiheer', 'Mongolia', 'Asia', 'MGXX0028', 0),
(0, 'Baitag', 'Mongolia', 'Asia', 'MGXX0020', 0),
(0, 'Baruun-Urt', 'Mongolia', 'Asia', 'MGXX0033', 0),
(0, 'Baruunkharaa', 'Mongolia', 'Asia', 'MGXX0017', 0),
(0, 'Baruunturuun', 'Mongolia', 'Asia', 'MGXX0007', 0),
(0, 'Bayan-Ovoo', 'Mongolia', 'Asia', 'MGXX0031', 0),
(0, 'Bayanbulag', 'Mongolia', 'Asia', 'MGXX0022', 0),
(0, 'Bayandelger', 'Mongolia', 'Asia', 'MGXX0039', 0),
(0, 'Bayanhongor', 'Mongolia', 'Asia', 'MGXX0027', 0),
(0, 'Bulgan', 'Mongolia', 'Asia', 'MGXX0016', 0),
(0, 'Choibalsan', 'Mongolia', 'Asia', 'MGXX0019', 0),
(0, 'Choir', 'Mongolia', 'Asia', 'MGXX0030', 0),
(0, 'Dalanzadgad', 'Mongolia', 'Asia', 'MGXX0041', 0),
(0, 'Dashbalbar', 'Mongolia', 'Asia', 'MGXX0018', 0),
(0, 'Dzuunmod', 'Mongolia', 'Asia', 'MGXX0002', 0),
(0, 'Erdenemandal', 'Mongolia', 'Asia', 'MGXX0015', 0),
(0, 'Gaiuut', 'Mongolia', 'Asia', 'MGXX0025', 0),
(0, 'Hatgal', 'Mongolia', 'Asia', 'MGXX0005', 0),
(0, 'Hovd', 'Mongolia', 'Asia', 'MGXX0010', 0),
(0, 'Hujirt', 'Mongolia', 'Asia', 'MGXX0026', 0),
(0, 'Hutag', 'Mongolia', 'Asia', 'MGXX0014', 0),
(0, 'Khalkh-Gol', 'Mongolia', 'Asia', 'MGXX0034', 0),
(0, 'Maanti', 'Mongolia', 'Asia', 'MGXX0029', 0),
(0, 'Mandalgovi', 'Mongolia', 'Asia', 'MGXX0037', 0),
(0, 'Matad', 'Mongolia', 'Asia', 'MGXX0035', 0),
(0, 'Muren', 'Mongolia', 'Asia', 'MGXX0013', 0),
(0, 'Omno-Gobi', 'Mongolia', 'Asia', 'MGXX0009', 0),
(0, 'Rinchinlhumbe', 'Mongolia', 'Asia', 'MGXX0004', 0),
(0, 'Saikhan-Ovoo', 'Mongolia', 'Asia', 'MGXX0036', 0),
(0, 'Tarialan', 'Mongolia', 'Asia', 'MGXX0012', 0),
(0, 'Tosontsengel', 'Mongolia', 'Asia', 'MGXX0011', 0),
(0, 'Tsetserleg', 'Mongolia', 'Asia', 'MGXX0024', 0),
(0, 'Tsogt-Ovoo', 'Mongolia', 'Asia', 'MGXX0038', 0),
(0, 'Uigi', 'Mongolia', 'Asia', 'MGXX0008', 0),
(0, 'Ulaan-Gom', 'Mongolia', 'Asia', 'MGXX0006', 0),
(0, 'Ulan Bator', 'Mongolia', 'Asia', 'MGXX0003', 0),
(0, 'Uliastai', 'Mongolia', 'Asia', 'MGXX0021', 0),
(0, 'Underkhaan', 'Mongolia', 'Asia', 'MGXX0032', 0),
(0, 'Zamyn-Uud', 'Mongolia', 'Asia', 'MGXX0040', 0),
(0, 'Bhaktapur', 'Nepal', 'Asia', 'NPXX0001', 0),
(0, 'Kathmandu', 'Nepal', 'Asia', 'NPXX0002', 0),
(0, 'Kathmandu Airport', 'Nepal', 'Asia', 'NPXX0003', 0),
(0, 'Ile Lifou', 'New Caledonia', 'Asia', 'NCXX0007', 0),
(0, 'Ile Loop Chesterfield', 'New Caledonia', 'Asia', 'NCXX0002', 0),
(0, 'Ile Surprise', 'New Caledonia', 'Asia', 'NCXX0001', 0),
(0, 'Koumac Nlle-Caledonie', 'New Caledonia', 'Asia', 'NCXX0003', 0),
(0, 'La Tontouta Nlle-Caledonie', 'New Caledonia', 'Asia', 'NCXX0005', 0),
(0, 'Noumea Nlle-Caledonie', 'New Caledonia', 'Asia', 'NCXX0006', 0),
(0, 'Ouloup Ile Ouvea', 'New Caledonia', 'Asia', 'NCXX0004', 0),
(0, 'Anju', 'North Korea', 'Asia', 'KNXX0018', 0),
(0, 'Ch`ongjin', 'North Korea', 'Asia', 'KNXX0001', 0),
(0, 'Changjin', 'North Korea', 'Asia', 'KNXX0015', 0),
(0, 'Chongjin', 'North Korea', 'Asia', 'KNXX0012', 0),
(0, 'Haeju', 'North Korea', 'Asia', 'KNXX0002', 0),
(0, 'Hamhung', 'North Korea', 'Asia', 'KNXX0003', 0),
(0, 'Huichon', 'North Korea', 'Asia', 'KNXX0016', 0),
(0, 'Hyesan', 'North Korea', 'Asia', 'KNXX0013', 0),
(0, 'Kaesong', 'North Korea', 'Asia', 'KNXX0004', 0),
(0, 'Kanggye', 'North Korea', 'Asia', 'KNXX0014', 0),
(0, 'Namp`o', 'North Korea', 'Asia', 'KNXX0005', 0),
(0, 'Nampo', 'North Korea', 'Asia', 'KNXX0019', 0),
(0, 'Pyongyang', 'North Korea', 'Asia', 'KNXX0006', 0),
(0, 'Samjiyon', 'North Korea', 'Asia', 'KNXX0011', 0),
(0, 'Sariwon', 'North Korea', 'Asia', 'KNXX0020', 0),
(0, 'Senbong', 'North Korea', 'Asia', 'KNXX0010', 0),
(0, 'Sinpo', 'North Korea', 'Asia', 'KNXX0017', 0),
(0, 'Sinuiju', 'North Korea', 'Asia', 'KNXX0007', 0),
(0, 'Songnim', 'North Korea', 'Asia', 'KNXX0008', 0),
(0, 'Wonsan', 'North Korea', 'Asia', 'KNXX0009', 0),
(0, 'Adam', 'Oman', 'Asia', 'MUXX0013', 0),
(0, 'Al Rustaq', 'Oman', 'Asia', 'MUXX0015', 0),
(0, 'As Sib', 'Oman', 'Asia', 'MUXX0001', 0),
(0, 'Bahla', 'Oman', 'Asia', 'MUXX0020', 0),
(0, 'Buraimi', 'Oman', 'Asia', 'MUXX0005', 0),
(0, 'Fahud', 'Oman', 'Asia', 'MUXX0007', 0),
(0, 'Haima', 'Oman', 'Asia', 'MUXX0017', 0),
(0, 'Ibra', 'Oman', 'Asia', 'MUXX0016', 0),
(0, 'Khassab', 'Oman', 'Asia', 'MUXX0004', 0),
(0, 'Marmul', 'Oman', 'Asia', 'MUXX0010', 0),
(0, 'Masirah', 'Oman', 'Asia', 'MUXX0009', 0),
(0, 'Matrah', 'Oman', 'Asia', 'MUXX0002', 0),
(0, 'Muscat', 'Oman', 'Asia', 'MUXX0003', 0),
(0, 'Nizwa', 'Oman', 'Asia', 'MUXX0018', 0),
(0, 'Qairoon Hairiti', 'Oman', 'Asia', 'MUXX0014', 0),
(0, 'Saiq', 'Oman', 'Asia', 'MUXX0021', 0),
(0, 'Salalah', 'Oman', 'Asia', 'MUXX0012', 0),
(0, 'Samail', 'Oman', 'Asia', 'MUXX0019', 0),
(0, 'Sohar Majis', 'Oman', 'Asia', 'MUXX0006', 0),
(0, 'Sur', 'Oman', 'Asia', 'MUXX0008', 0),
(0, 'Taqah', 'Oman', 'Asia', 'MUXX0022', 0),
(0, 'Thumrait', 'Oman', 'Asia', 'MUXX0011', 0),
(0, 'Chiniot', 'Pakistan', 'Asia', 'PKXX0001', 0),
(0, 'Faisalabad', 'Pakistan', 'Asia', 'PKXX0002', 0),
(0, 'Gujranwala', 'Pakistan', 'Asia', 'PKXX0003', 0),
(0, 'Gujrat', 'Pakistan', 'Asia', 'PKXX0004', 0),
(0, 'Hyderabad', 'Pakistan', 'Asia', 'PKXX0005', 0),
(0, 'Islamabad', 'Pakistan', 'Asia', 'PKXX0006', 0),
(0, 'Jhang Sadar', 'Pakistan', 'Asia', 'PKXX0007', 0),
(0, 'Karachi', 'Pakistan', 'Asia', 'PKXX0008', 0),
(0, 'Kasur', 'Pakistan', 'Asia', 'PKXX0009', 0),
(0, 'Kohat', 'Pakistan', 'Asia', 'PKXX0010', 0),
(0, 'Lahore', 'Pakistan', 'Asia', 'PKXX0011', 0),
(0, 'Mardan', 'Pakistan', 'Asia', 'PKXX0012', 0),
(0, 'Multan', 'Pakistan', 'Asia', 'PKXX0022', 0),
(0, 'Nawabshah', 'Pakistan', 'Asia', 'PKXX0024', 0),
(0, 'Okara', 'Pakistan', 'Asia', 'PKXX0013', 0),
(0, 'Peshawar', 'Pakistan', 'Asia', 'PKXX0014', 0),
(0, 'Quetta', 'Pakistan', 'Asia', 'PKXX0021', 0),
(0, 'Rawalpindi', 'Pakistan', 'Asia', 'PKXX0015', 0),
(0, 'Sahiwal', 'Pakistan', 'Asia', 'PKXX0016', 0),
(0, 'Sargodha', 'Pakistan', 'Asia', 'PKXX0017', 0),
(0, 'Shekhupura', 'Pakistan', 'Asia', 'PKXX0018', 0),
(0, 'Sialkot', 'Pakistan', 'Asia', 'PKXX0019', 0),
(0, 'Sukkur', 'Pakistan', 'Asia', 'PKXX0023', 0),
(0, 'Thatta', 'Pakistan', 'Asia', 'PKXX0020', 0),
(0, 'Kerema', 'Papua New Guinea', 'Asia', 'PPXX0001', 0),
(0, 'Kikori', 'Papua New Guinea', 'Asia', 'PPXX0002', 0),
(0, 'Morobe', 'Papua New Guinea', 'Asia', 'PPXX0003', 0),
(0, 'Port Moresby', 'Papua New Guinea', 'Asia', 'PPXX0004', 0),
(0, 'Samarai', 'Papua New Guinea', 'Asia', 'PPXX0005', 0),
(0, 'Alabat', 'Philippines', 'Asia', 'RPXX0058', 0),
(0, 'Ambulong', 'Philippines', 'Asia', 'RPXX0056', 0),
(0, 'Angeles', 'Philippines', 'Asia', 'RPXX0001', 0),
(0, 'Aparri', 'Philippines', 'Asia', 'RPXX0042', 0),
(0, 'Bacolod', 'Philippines', 'Asia', 'RPXX0002', 0),
(0, 'Bacoor', 'Philippines', 'Asia', 'RPXX0003', 0),
(0, 'Baguio', 'Philippines', 'Asia', 'RPXX0046', 0),
(0, 'Baler Radar Site', 'Philippines', 'Asia', 'RPXX0049', 0),
(0, 'Basco', 'Philippines', 'Asia', 'RPXX0039', 0),
(0, 'Butuan', 'Philippines', 'Asia', 'RPXX0004', 0),
(0, 'Cabanatuan', 'Philippines', 'Asia', 'RPXX0048', 0),
(0, 'Cadiz', 'Philippines', 'Asia', 'RPXX0005', 0),
(0, 'Calapan', 'Philippines', 'Asia', 'RPXX0055', 0),
(0, 'Casiguran', 'Philippines', 'Asia', 'RPXX0050', 0),
(0, 'Catanduanes Radar Site', 'Philippines', 'Asia', 'RPXX0062', 0),
(0, 'Catarman', 'Philippines', 'Asia', 'RPXX0067', 0),
(0, 'Cavite', 'Philippines', 'Asia', 'RPXX0006', 0),
(0, 'Cebu City', 'Philippines', 'Asia', 'RPXX0007', 0),
(0, 'Coron', 'Philippines', 'Asia', 'RPXX0063', 0),
(0, 'Daet', 'Philippines', 'Asia', 'RPXX0059', 0),
(0, 'Dagupan', 'Philippines', 'Asia', 'RPXX0045', 0),
(0, 'Davao', 'Philippines', 'Asia', 'RPXX0008', 0),
(0, 'Dipolog', 'Philippines', 'Asia', 'RPXX0009', 0),
(0, 'General Santos', 'Philippines', 'Asia', 'RPXX0010', 0),
(0, 'Hinigaran', 'Philippines', 'Asia', 'RPXX0011', 0),
(0, 'Iba', 'Philippines', 'Asia', 'RPXX0044', 0),
(0, 'Iloilo', 'Philippines', 'Asia', 'RPXX0012', 0),
(0, 'Infanta', 'Philippines', 'Asia', 'RPXX0057', 0),
(0, 'Isabela', 'Philippines', 'Asia', 'RPXX0013', 0),
(0, 'Itbayat', 'Philippines', 'Asia', 'RPXX0038', 0),
(0, 'Jolo', 'Philippines', 'Asia', 'RPXX0014', 0),
(0, 'Laoag', 'Philippines', 'Asia', 'RPXX0041', 0),
(0, 'Legaspi', 'Philippines', 'Asia', 'RPXX0060', 0),
(0, 'Libagon', 'Philippines', 'Asia', 'RPXX0015', 0),
(0, 'Malolos', 'Philippines', 'Asia', 'RPXX0016', 0),
(0, 'Manila', 'Philippines', 'Asia', 'RPXX0017', 0),
(0, 'Masbate', 'Philippines', 'Asia', 'RPXX0018', 0),
(0, 'Meycauayan', 'Philippines', 'Asia', 'RPXX0019', 0),
(0, 'Mobo', 'Philippines', 'Asia', 'RPXX0020', 0),
(0, 'Munoz', 'Philippines', 'Asia', 'RPXX0047', 0),
(0, 'Nutol', 'Philippines', 'Asia', 'RPXX0021', 0),
(0, 'Olongapo', 'Philippines', 'Asia', 'RPXX0022', 0),
(0, 'Olutanga', 'Philippines', 'Asia', 'RPXX0023', 0),
(0, 'Orani', 'Philippines', 'Asia', 'RPXX0024', 0),
(0, 'Pagadian', 'Philippines', 'Asia', 'RPXX0025', 0),
(0, 'Pampanga', 'Philippines', 'Asia', 'RPXX0070', 0),
(0, 'Pasig', 'Philippines', 'Asia', 'RPXX0026', 0),
(0, 'Puerto Princesa', 'Philippines', 'Asia', 'RPXX0069', 0),
(0, 'Quezon City', 'Philippines', 'Asia', 'RPXX0027', 0),
(0, 'Romblon', 'Philippines', 'Asia', 'RPXX0065', 0),
(0, 'Roxas', 'Philippines', 'Asia', 'RPXX0028', 0),
(0, 'San Fernando', 'Philippines', 'Asia', 'RPXX0029', 0),
(0, 'San Jose', 'Philippines', 'Asia', 'RPXX0064', 0),
(0, 'San Pablo', 'Philippines', 'Asia', 'RPXX0030', 0),
(0, 'Sangley Point', 'Philippines', 'Asia', 'RPXX0053', 0),
(0, 'Santa Cruz', 'Philippines', 'Asia', 'RPXX0031', 0),
(0, 'Sapao', 'Philippines', 'Asia', 'RPXX0032', 0),
(0, 'Science Garden', 'Philippines', 'Asia', 'RPXX0054', 0),
(0, 'Surigao', 'Philippines', 'Asia', 'RPXX0033', 0),
(0, 'Tacloban', 'Philippines', 'Asia', 'RPXX0068', 0),
(0, 'Tandag', 'Philippines', 'Asia', 'RPXX0034', 0),
(0, 'Tarlac', 'Philippines', 'Asia', 'RPXX0035', 0),
(0, 'Tayabas', 'Philippines', 'Asia', 'RPXX0052', 0),
(0, 'Taytay', 'Philippines', 'Asia', 'RPXX0036', 0),
(0, 'Tuguegarao', 'Philippines', 'Asia', 'RPXX0043', 0),
(0, 'Vigan', 'Philippines', 'Asia', 'RPXX0040', 0),
(0, 'Virac', 'Philippines', 'Asia', 'RPXX0061', 0),
(0, 'Zamboanga', 'Philippines', 'Asia', 'RPXX0037', 0),
(0, 'Al Wakrah', 'Qatar', 'Asia', 'QAXX0001', 0),
(0, 'Ar Rayyan', 'Qatar', 'Asia', 'QAXX0002', 0),
(0, 'Doha', 'Qatar', 'Asia', 'QAXX0003', 0),
(0, 'Abakan', 'Russia', 'Asia', 'RSXX1349', 0),
(0, 'Abinsk', 'Russia', 'Asia', 'RSXX1409', 0),
(0, 'Achinsk', 'Russia', 'Asia', 'RSXX1385', 0),
(0, 'Adler', 'Russia', 'Asia', 'RSXX0446', 0),
(0, 'Agapovka', 'Russia', 'Asia', 'RSXX0002', 0),
(0, 'Agata', 'Russia', 'Asia', 'RSXX1347', 0),
(0, 'Aginskoe', 'Russia', 'Asia', 'RSXX0342', 0),
(0, 'Agzu', 'Russia', 'Asia', 'RSXX0383', 0),
(0, 'Akhtubinsk', 'Russia', 'Asia', 'RSXX1310', 0),
(0, 'Aksa', 'Russia', 'Asia', 'RSXX0348', 0),
(0, 'Alagir', 'Russia', 'Asia', 'RSXX1563', 0),
(0, 'Alapayevsk', 'Russia', 'Asia', 'RSXX1572', 0),
(0, 'Alatyr', 'Russia', 'Asia', 'RSXX0191', 0),
(0, 'Aldan', 'Russia', 'Asia', 'RSXX0352', 0),
(0, 'Alejskaja', 'Russia', 'Asia', 'RSXX0297', 0),
(0, 'Aleksandrov-Gaj', 'Russia', 'Asia', 'RSXX0421', 0),
(0, 'Aleksandrovsk-Sahalinskij', 'Russia', 'Asia', 'RSXX0397', 0),
(0, 'Aleksandrovskoe', 'Russia', 'Asia', 'RSXX1237', 0),
(0, 'Aleksin', 'Russia', 'Asia', 'RSXX1592', 0),
(0, 'Amderma', 'Russia', 'Asia', 'RSXX1518', 0),
(0, 'Amga', 'Russia', 'Asia', 'RSXX0145', 0),
(0, 'Amursk', 'Russia', 'Asia', 'RSXX1350', 0),
(0, 'Anadyr`', 'Russia', 'Asia', 'RSXX0003', 0),
(0, 'Anapa', 'Russia', 'Asia', 'RSXX1410', 0),
(0, 'Angarsk', 'Russia', 'Asia', 'RSXX0004', 0),
(0, 'Anucino', 'Russia', 'Asia', 'RSXX0393', 0),
(0, 'Apatity', 'Russia', 'Asia', 'RSXX1507', 0),
(0, 'Aprelevka', 'Russia', 'Asia', 'RSXX1465', 0),
(0, 'Apsheronsk', 'Russia', 'Asia', 'RSXX1411', 0),
(0, 'Arhangel`Sk', 'Russia', 'Asia', 'RSXX0194', 0),
(0, 'Arka', 'Russia', 'Asia', 'RSXX0148', 0),
(0, 'Arman`', 'Russia', 'Asia', 'RSXX0006', 0),
(0, 'Armavir', 'Russia', 'Asia', 'RSXX0441', 0),
(0, 'Arsen`yev', 'Russia', 'Asia', 'RSXX1533', 0),
(0, 'Artem', 'Russia', 'Asia', 'RSXX0007', 0),
(0, 'Arzamas', 'Russia', 'Asia', 'RSXX1515', 0),
(0, 'Asbest', 'Russia', 'Asia', 'RSXX1573', 0),
(0, 'Astrahanka', 'Russia', 'Asia', 'RSXX0390', 0),
(0, 'Astrakhan`', 'Russia', 'Asia', 'RSXX0008', 0),
(0, 'Azov', 'Russia', 'Asia', 'RSXX1550', 0),
(0, 'Babaevo', 'Russia', 'Asia', 'RSXX0169', 0),
(0, 'Babuskin', 'Russia', 'Asia', 'RSXX0335', 0),
(0, 'Baevo', 'Russia', 'Asia', 'RSXX0292', 0),
(0, 'Bagdarin', 'Russia', 'Asia', 'RSXX0317', 0),
(0, 'Bakaly', 'Russia', 'Asia', 'RSXX1242', 0),
(0, 'Bakchar', 'Russia', 'Asia', 'RSXX0254', 0),
(0, 'Balasiha', 'Russia', 'Asia', 'RSXX1466', 0),
(0, 'Balasov', 'Russia', 'Asia', 'RSXX0413', 0),
(0, 'Baltiysk', 'Russia', 'Asia', 'RSXX1369', 0),
(0, 'Barabinsk', 'Russia', 'Asia', 'RSXX0273', 0),
(0, 'Barnaul', 'Russia', 'Asia', 'RSXX0009', 0),
(0, 'Batamaj', 'Russia', 'Asia', 'RSXX0136', 0),
(0, 'Bataysk', 'Russia', 'Asia', 'RSXX0011', 0),
(0, 'Bavly', 'Russia', 'Asia', 'RSXX1585', 0),
(0, 'Baykal`sk', 'Russia', 'Asia', 'RSXX1358', 0),
(0, 'Beja', 'Russia', 'Asia', 'RSXX0300', 0),
(0, 'Belevo', 'Russia', 'Asia', 'RSXX0012', 0),
(0, 'Belgorod', 'Russia', 'Asia', 'RSXX1323', 0),
(0, 'Belogorsk', 'Russia', 'Asia', 'RSXX1307', 0),
(0, 'Belokurikha', 'Russia', 'Asia', 'RSXX1302', 0),
(0, 'Belomorsk', 'Russia', 'Asia', 'RSXX1391', 0),
(0, 'Belorechensk', 'Russia', 'Asia', 'RSXX1412', 0),
(0, 'Beloretsk', 'Russia', 'Asia', 'RSXX1319', 0),
(0, 'Belozersk', 'Russia', 'Asia', 'RSXX0223', 0),
(0, 'Belyj', 'Russia', 'Asia', 'RSXX0163', 0),
(0, 'Berdsk', 'Russia', 'Asia', 'RSXX0013', 0),
(0, 'Berezniki', 'Russia', 'Asia', 'RSXX0014', 0),
(0, 'Berezovo', 'Russia', 'Asia', 'RSXX0234', 0),
(0, 'Beringovskiy', 'Russia', 'Asia', 'RSXX0016', 0),
(0, 'Bijsk Zonal`Naja', 'Russia', 'Asia', 'RSXX0298', 0),
(0, 'Bikin', 'Russia', 'Asia', 'RSXX0017', 0),
(0, 'Bilibino', 'Russia', 'Asia', 'RSXX1335', 0),
(0, 'Birobidzan', 'Russia', 'Asia', 'RSXX0018', 0),
(0, 'Birobidzhan', 'Russia', 'Asia', 'RSXX0379', 0),
(0, 'Birsk', 'Russia', 'Asia', 'RSXX1243', 0),
(0, 'Blagovescensk', 'Russia', 'Asia', 'RSXX0372', 0),
(0, 'Bodajbo', 'Russia', 'Asia', 'RSXX0305', 0),
(0, 'Bogorodskoe', 'Russia', 'Asia', 'RSXX0366', 0),
(0, 'Bogotol', 'Russia', 'Asia', 'RSXX0265', 0),
(0, 'Bogucany', 'Russia', 'Asia', 'RSXX0252', 0),
(0, 'Bogucar', 'Russia', 'Asia', 'RSXX0418', 0),
(0, 'Bol`Shaja Murta', 'Russia', 'Asia', 'RSXX0260', 0),
(0, 'Bol`shoy Kamen`', 'Russia', 'Asia', 'RSXX0019', 0),
(0, 'Bol`Sie Uki', 'Russia', 'Asia', 'RSXX1225', 0),
(0, 'Bol`Soj Santar', 'Russia', 'Asia', 'RSXX0355', 0),
(0, 'Bologoe', 'Russia', 'Asia', 'RSXX0160', 0),
(0, 'Bomnak', 'Russia', 'Asia', 'RSXX0356', 0),
(0, 'Bor', 'Russia', 'Asia', 'RSXX1224', 0),
(0, 'Borovsk', 'Russia', 'Asia', 'RSXX1381', 0),
(0, 'Borzja', 'Russia', 'Asia', 'RSXX0350', 0),
(0, 'Bratsk', 'Russia', 'Asia', 'RSXX0306', 0),
(0, 'Brjansk', 'Russia', 'Asia', 'RSXX0167', 0),
(0, 'Bronnicy', 'Russia', 'Asia', 'RSXX1467', 0),
(0, 'Budennovsk', 'Russia', 'Asia', 'RSXX0443', 0),
(0, 'Bugul`Ma', 'Russia', 'Asia', 'RSXX1247', 0),
(0, 'Buguruslan', 'Russia', 'Asia', 'RSXX1523', 0),
(0, 'Buhta Providenja', 'Russia', 'Asia', 'RSXX0150', 0),
(0, 'Buj', 'Russia', 'Asia', 'RSXX0176', 0),
(0, 'Burukan', 'Russia', 'Asia', 'RSXX0360', 0),
(0, 'Buynaksk', 'Russia', 'Asia', 'RSXX1342', 0),
(0, 'Buzuluk', 'Russia', 'Asia', 'RSXX0021', 0),
(0, 'Bykovo Airport', 'Russia', 'Asia', 'RSXX1468', 0),
(0, 'Cehov', 'Russia', 'Asia', 'RSXX1469', 0),
(0, 'Cekunda', 'Russia', 'Asia', 'RSXX0373', 0),
(0, 'Cemal', 'Russia', 'Asia', 'RSXX0438', 0),
(0, 'Central`Nyj Rudnik', 'Russia', 'Asia', 'RSXX0279', 0),
(0, 'Cerepovec', 'Russia', 'Asia', 'RSXX0174', 0),
(0, 'Cerlak', 'Russia', 'Asia', 'RSXX1252', 0),
(0, 'Cerusti', 'Russia', 'Asia', 'RSXX1470', 0),
(0, 'Chany', 'Russia', 'Asia', 'RSXX0271', 0),
(0, 'Chapayevsk', 'Russia', 'Asia', 'RSXX0023', 0),
(0, 'Chara', 'Russia', 'Asia', 'RSXX0308', 0),
(0, 'Chaykovskiy', 'Russia', 'Asia', 'RSXX1536', 0),
(0, 'Cheboksary', 'Russia', 'Asia', 'RSXX1341', 0),
(0, 'Chelyabinsk', 'Russia', 'Asia', 'RSXX0024', 0),
(0, 'Chelyuskin', 'Russia', 'Asia', 'RSXX1594', 0),
(0, 'Cherdyn', 'Russia', 'Asia', 'RSXX1229', 0),
(0, 'Cherkessk', 'Russia', 'Asia', 'RSXX1374', 0),
(0, 'Chermoz', 'Russia', 'Asia', 'RSXX1537', 0),
(0, 'Chernjaevo', 'Russia', 'Asia', 'RSXX0362', 0),
(0, 'Chernyakhovsk', 'Russia', 'Asia', 'RSXX1370', 0),
(0, 'Cherskiy', 'Russia', 'Asia', 'RSXX1621', 0),
(0, 'Chita', 'Russia', 'Asia', 'RSXX0025', 0),
(0, 'Chokurdakh', 'Russia', 'Asia', 'RSXX1622', 0),
(0, 'Chusovoy', 'Russia', 'Asia', 'RSXX0026', 0),
(0, 'Cul`Man', 'Russia', 'Asia', 'RSXX0310', 0),
(0, 'Culym', 'Russia', 'Asia', 'RSXX0274', 0),
(0, 'Curapca', 'Russia', 'Asia', 'RSXX0140', 0),
(0, 'Dagomys', 'Russia', 'Asia', 'RSXX1413', 0),
(0, 'Dal`Nerechensk', 'Russia', 'Asia', 'RSXX0386', 0),
(0, 'Dankov', 'Russia', 'Asia', 'RSXX1458', 0),
(0, 'Darasun', 'Russia', 'Asia', 'RSXX0027', 0),
(0, 'Derbent', 'Russia', 'Asia', 'RSXX1343', 0),
(0, 'Dikson', 'Russia', 'Asia', 'RSXX1595', 0),
(0, 'Dimitrovgrad', 'Russia', 'Asia', 'RSXX0028', 0),
(0, 'Divnoe', 'Russia', 'Asia', 'RSXX0428', 0),
(0, 'Divnogorsk', 'Russia', 'Asia', 'RSXX1386', 0),
(0, 'Dmitrov', 'Russia', 'Asia', 'RSXX1471', 0),
(0, 'Dno', 'Russia', 'Asia', 'RSXX1543', 0),
(0, 'Dobryanka', 'Russia', 'Asia', 'RSXX0029', 0),
(0, 'Dolinsk', 'Russia', 'Asia', 'RSXX0030', 0),
(0, 'Dombay', 'Russia', 'Asia', 'RSXX1375', 0),
(0, 'Domodedovo International Airport', 'Russia', 'Asia', 'RSXX1472', 0),
(0, 'Dubna', 'Russia', 'Asia', 'RSXX1603', 0),
(0, 'Dudinka', 'Russia', 'Asia', 'RSXX1596', 0),
(0, 'Duvan', 'Russia', 'Asia', 'RSXX1231', 0),
(0, 'Dvinskoy Bereznik', 'Russia', 'Asia', 'RSXX1311', 0),
(0, 'Dzalinda', 'Russia', 'Asia', 'RSXX0325', 0),
(0, 'Dzerzhinsk', 'Russia', 'Asia', 'RSXX1516', 0),
(0, 'Dzherzhinskoe', 'Russia', 'Asia', 'RSXX0262', 0),
(0, 'Dzhubga', 'Russia', 'Asia', 'RSXX1414', 0),
(0, 'Egor`evsk', 'Russia', 'Asia', 'RSXX1473', 0),
(0, 'Ekaterinburg', 'Russia', 'Asia', 'RSXX1219', 0),
(0, 'Ekaterino-Nikol`Skoe', 'Russia', 'Asia', 'RSXX0378', 0),
(0, 'Ekimchan', 'Russia', 'Asia', 'RSXX0359', 0),
(0, 'El`ton', 'Russia', 'Asia', 'RSXX1607', 0),
(0, 'Elabuga', 'Russia', 'Asia', 'RSXX1228', 0),
(0, 'Elat`Ma', 'Russia', 'Asia', 'RSXX0189', 0),
(0, 'Elec', 'Russia', 'Asia', 'RSXX0207', 0),
(0, 'Elista', 'Russia', 'Asia', 'RSXX1396', 0),
(0, 'Engel`s', 'Russia', 'Asia', 'RSXX1556', 0),
(0, 'Enisejsk', 'Russia', 'Asia', 'RSXX0251', 0),
(0, 'Ermakovskoe', 'Russia', 'Asia', 'RSXX0295', 0),
(0, 'Erofej Pavlovic', 'Russia', 'Asia', 'RSXX0322', 0),
(0, 'Ersov', 'Russia', 'Asia', 'RSXX0415', 0),
(0, 'Fatezh', 'Russia', 'Asia', 'RSXX1439', 0),
(0, 'Frolovo', 'Russia', 'Asia', 'RSXX0032', 0),
(0, 'Gagarin', 'Russia', 'Asia', 'RSXX1561', 0),
(0, 'Gajny', 'Russia', 'Asia', 'RSXX1226', 0),
(0, 'Galich', 'Russia', 'Asia', 'RSXX1435', 0),
(0, 'Gatchina', 'Russia', 'Asia', 'RSXX1446', 0),
(0, 'Gavrilov-Yam', 'Russia', 'Asia', 'RSXX1634', 0),
(0, 'Gdov', 'Russia', 'Asia', 'RSXX1544', 0),
(0, 'Gelendzhik', 'Russia', 'Asia', 'RSXX1415', 0),
(0, 'Glazov', 'Russia', 'Asia', 'RSXX0033', 0),
(0, 'Gorin', 'Russia', 'Asia', 'RSXX0371', 0),
(0, 'Gorjacinsk', 'Russia', 'Asia', 'RSXX0327', 0),
(0, 'Gorno-Altaysk', 'Russia', 'Asia', 'RSXX1317', 0),
(0, 'Gorodets', 'Russia', 'Asia', 'RSXX0034', 0),
(0, 'Goryachiy klyuch', 'Russia', 'Asia', 'RSXX1416', 0),
(0, 'Groznyj', 'Russia', 'Asia', 'RSXX0448', 0),
(0, 'Gubakha', 'Russia', 'Asia', 'RSXX1538', 0),
(0, 'Gubkin', 'Russia', 'Asia', 'RSXX1324', 0),
(0, 'Gus`-Khrustal`ny', 'Russia', 'Asia', 'RSXX1609', 0),
(0, 'Gvasjugi', 'Russia', 'Asia', 'RSXX0382', 0),
(0, 'Hakasskaja', 'Russia', 'Asia', 'RSXX0293', 0),
(0, 'Hanty-Mansijsk', 'Russia', 'Asia', 'RSXX1234', 0),
(0, 'Hilok', 'Russia', 'Asia', 'RSXX0340', 0),
(0, 'Himki', 'Russia', 'Asia', 'RSXX1474', 0),
(0, 'Holmsk', 'Russia', 'Asia', 'RSXX0402', 0),
(0, 'Horinsk', 'Russia', 'Asia', 'RSXX0328', 0),
(0, 'Hularin', 'Russia', 'Asia', 'RSXX0370', 0),
(0, 'Idrinskoe', 'Russia', 'Asia', 'RSXX0289', 0),
(0, 'Igarka', 'Russia', 'Asia', 'RSXX1387', 0),
(0, 'Iglino', 'Russia', 'Asia', 'RSXX0036', 0),
(0, 'Ignasino', 'Russia', 'Asia', 'RSXX0323', 0),
(0, 'Ilyinskiy', 'Russia', 'Asia', 'RSXX0401', 0),
(0, 'Im Poliny Osipenko', 'Russia', 'Asia', 'RSXX0364', 0),
(0, 'Inta', 'Russia', 'Asia', 'RSXX1399', 0),
(0, 'Irbejskoe', 'Russia', 'Asia', 'RSXX0270', 0),
(0, 'Irbit', 'Russia', 'Asia', 'RSXX1574', 0),
(0, 'Irkutsk', 'Russia', 'Asia', 'RSXX0038', 0),
(0, 'Isil`Kul', 'Russia', 'Asia', 'RSXX1246', 0),
(0, 'Isim', 'Russia', 'Asia', 'RSXX1236', 0),
(0, 'Isit', 'Russia', 'Asia', 'RSXX0144', 0),
(0, 'Istra', 'Russia', 'Asia', 'RSXX0039', 0),
(0, 'Ivangorod', 'Russia', 'Asia', 'RSXX1253', 0),
(0, 'Ivanovo', 'Russia', 'Asia', 'RSXX1366', 0),
(0, 'Ivdel', 'Russia', 'Asia', 'RSXX1230', 0),
(0, 'Izhevsk', 'Russia', 'Asia', 'RSXX0237', 0),
(0, 'Jahroma', 'Russia', 'Asia', 'RSXX1475', 0),
(0, 'Janaul', 'Russia', 'Asia', 'RSXX0239', 0),
(0, 'Jarcevo', 'Russia', 'Asia', 'RSXX0131', 0),
(0, 'Jaskul', 'Russia', 'Asia', 'RSXX0429', 0),
(0, 'Jur`Evec', 'Russia', 'Asia', 'RSXX0180', 0),
(0, 'Juzhno-Kuril`Sk', 'Russia', 'Asia', 'RSXX0403', 0),
(0, 'Kachkanar', 'Russia', 'Asia', 'RSXX1575', 0),
(0, 'Kacug', 'Russia', 'Asia', 'RSXX0318', 0),
(0, 'Kalac', 'Russia', 'Asia', 'RSXX0417', 0),
(0, 'Kalach-na-Donu', 'Russia', 'Asia', 'RSXX1608', 0),
(0, 'Kalachinsk', 'Russia', 'Asia', 'RSXX1529', 0),
(0, 'Kalevala', 'Russia', 'Asia', 'RSXX1392', 0),
(0, 'Kaliningrad', 'Russia', 'Asia', 'RSXX0040', 0),
(0, 'Kaluga', 'Russia', 'Asia', 'RSXX0192', 0),
(0, 'Kamen`-na-Obi', 'Russia', 'Asia', 'RSXX1303', 0),
(0, 'Kamenomostskiy', 'Russia', 'Asia', 'RSXX1300', 0),
(0, 'Kamensk-Ural`skiy', 'Russia', 'Asia', 'RSXX1576', 0),
(0, 'Kamysin', 'Russia', 'Asia', 'RSXX0420', 0),
(0, 'Kamyslov', 'Russia', 'Asia', 'RSXX1220', 0),
(0, 'Kandalaksha', 'Russia', 'Asia', 'RSXX1508', 0),
(0, 'Kansk', 'Russia', 'Asia', 'RSXX0269', 0),
(0, 'Karaftit', 'Russia', 'Asia', 'RSXX0316', 0),
(0, 'Karasuk', 'Russia', 'Asia', 'RSXX0291', 0),
(0, 'Kargasok', 'Russia', 'Asia', 'RSXX0247', 0),
(0, 'Kargopol', 'Russia', 'Asia', 'RSXX0217', 0),
(0, 'Karpinsk', 'Russia', 'Asia', 'RSXX1577', 0),
(0, 'Kartaly', 'Russia', 'Asia', 'RSXX1329', 0),
(0, 'Karymskoye', 'Russia', 'Asia', 'RSXX0041', 0),
(0, 'Kasimov', 'Russia', 'Asia', 'RSXX1546', 0),
(0, 'Kaspiysk', 'Russia', 'Asia', 'RSXX1344', 0),
(0, 'Katav-Ivanovsk', 'Russia', 'Asia', 'RSXX1330', 0),
(0, 'Kazan`', 'Russia', 'Asia', 'RSXX0043', 0),
(0, 'Kazhim', 'Russia', 'Asia', 'RSXX1400', 0),
(0, 'Kedon', 'Russia', 'Asia', 'RSXX0151', 0),
(0, 'Kem`- Port', 'Russia', 'Asia', 'RSXX0193', 0),
(0, 'Kemerovo', 'Russia', 'Asia', 'RSXX0277', 0),
(0, 'Kezhma', 'Russia', 'Asia', 'RSXX1388', 0),
(0, 'Khabarovsk', 'Russia', 'Asia', 'RSXX0044', 0),
(0, 'Khasan', 'Russia', 'Asia', 'RSXX1534', 0),
(0, 'Khasavyurt', 'Russia', 'Asia', 'RSXX1345', 0),
(0, 'Khatanga', 'Russia', 'Asia', 'RSXX0453', 0),
(0, 'Kholm', 'Russia', 'Asia', 'RSXX0451', 0),
(0, 'Kholmogory', 'Russia', 'Asia', 'RSXX1312', 0),
(0, 'Khosta (Sochi)', 'Russia', 'Asia', 'RSXX1417', 0),
(0, 'Kimry', 'Russia', 'Asia', 'RSXX1604', 0),
(0, 'Kineshma', 'Russia', 'Asia', 'RSXX1367', 0),
(0, 'Kingisepp', 'Russia', 'Asia', 'RSXX0154', 0),
(0, 'Kirensk', 'Russia', 'Asia', 'RSXX0304', 0),
(0, 'Kirishi', 'Russia', 'Asia', 'RSXX1447', 0),
(0, 'Kirov', 'Russia', 'Asia', 'RSXX0175', 0),
(0, 'Kirovo-Chepetsk', 'Russia', 'Asia', 'RSXX1384', 0),
(0, 'Kirovsk', 'Russia', 'Asia', 'RSXX1509', 0),
(0, 'Kirovskij', 'Russia', 'Asia', 'RSXX0387', 0),
(0, 'Kirs', 'Russia', 'Asia', 'RSXX0215', 0),
(0, 'Kirzhach', 'Russia', 'Asia', 'RSXX1610', 0),
(0, 'Kiselevsk', 'Russia', 'Asia', 'RSXX0047', 0),
(0, 'Kislovodsk', 'Russia', 'Asia', 'RSXX1567', 0),
(0, 'Kizlyar', 'Russia', 'Asia', 'RSXX1346', 0),
(0, 'Kjahta', 'Russia', 'Asia', 'RSXX0345', 0),
(0, 'Klin', 'Russia', 'Asia', 'RSXX1476', 0),
(0, 'Kljuchi', 'Russia', 'Asia', 'RSXX0405', 0),
(0, 'Kljuci', 'Russia', 'Asia', 'RSXX0434', 0),
(0, 'Kochki', 'Russia', 'Asia', 'RSXX0284', 0),
(0, 'Kocubej', 'Russia', 'Asia', 'RSXX0444', 0),
(0, 'Kogalym', 'Russia', 'Asia', 'RSXX1352', 0),
(0, 'Kojnas', 'Russia', 'Asia', 'RSXX0196', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Kolba', 'Russia', 'Asia', 'RSXX0280', 0),
(0, 'Kolomna', 'Russia', 'Asia', 'RSXX1477', 0),
(0, 'Kolpasevo', 'Russia', 'Asia', 'RSXX0249', 0),
(0, 'Kolpino', 'Russia', 'Asia', 'RSXX0049', 0),
(0, 'Kolyvan', 'Russia', 'Asia', 'RSXX0275', 0),
(0, 'Kommunar', 'Russia', 'Asia', 'RSXX0288', 0),
(0, 'Komsomol`sk-na-Amure', 'Russia', 'Asia', 'RSXX1351', 0),
(0, 'Kondopoga', 'Russia', 'Asia', 'RSXX1393', 0),
(0, 'Korf', 'Russia', 'Asia', 'RSXX0153', 0),
(0, 'Korfovskiy', 'Russia', 'Asia', 'RSXX0050', 0),
(0, 'Korkino', 'Russia', 'Asia', 'RSXX0051', 0),
(0, 'Korolev', 'Russia', 'Asia', 'RSXX1478', 0),
(0, 'Korsakov', 'Russia', 'Asia', 'RSXX1557', 0),
(0, 'Kosh Agach', 'Russia', 'Asia', 'RSXX1318', 0),
(0, 'Koslan', 'Russia', 'Asia', 'RSXX0204', 0),
(0, 'Kostomuksha', 'Russia', 'Asia', 'RSXX1394', 0),
(0, 'Kostroma', 'Russia', 'Asia', 'RSXX1436', 0),
(0, 'Kotel`nich', 'Russia', 'Asia', 'RSXX1377', 0),
(0, 'Kotel`Nikovo', 'Russia', 'Asia', 'RSXX0424', 0),
(0, 'Kotlas', 'Russia', 'Asia', 'RSXX0052', 0),
(0, 'Kovrov', 'Russia', 'Asia', 'RSXX1611', 0),
(0, 'L`gov', 'Russia', 'Asia', 'RSXX1441', 0),
(0, 'Labinsk', 'Russia', 'Asia', 'RSXX1423', 0),
(0, 'Lazarevskaya', 'Russia', 'Asia', 'RSXX1424', 0),
(0, 'Lensk', 'Russia', 'Asia', 'RSXX0142', 0),
(0, 'Lipetsk', 'Russia', 'Asia', 'RSXX1459', 0),
(0, 'Ljuberzy', 'Russia', 'Asia', 'RSXX0056', 0),
(0, 'Lodeynoye Pole', 'Russia', 'Asia', 'RSXX1449', 0),
(0, 'Losinoborskoe', 'Russia', 'Asia', 'RSXX0250', 0),
(0, 'Lotosino', 'Russia', 'Asia', 'RSXX1479', 0),
(0, 'Luga', 'Russia', 'Asia', 'RSXX1450', 0),
(0, 'Luhovicy', 'Russia', 'Asia', 'RSXX1480', 0),
(0, 'Lukojanov', 'Russia', 'Asia', 'RSXX0190', 0),
(0, 'Lyuban`', 'Russia', 'Asia', 'RSXX1451', 0),
(0, 'Magadan', 'Russia', 'Asia', 'RSXX0057', 0),
(0, 'Magdagaci', 'Russia', 'Asia', 'RSXX0357', 0),
(0, 'Magnitogorsk', 'Russia', 'Asia', 'RSXX0058', 0),
(0, 'Mahackala', 'Russia', 'Asia', 'RSXX0449', 0),
(0, 'Majsk', 'Russia', 'Asia', 'RSXX0248', 0),
(0, 'Makushino', 'Russia', 'Asia', 'RSXX1398', 0),
(0, 'Malaya Vishera', 'Russia', 'Asia', 'RSXX1521', 0),
(0, 'Maloyaroslavets', 'Russia', 'Asia', 'RSXX1382', 0),
(0, 'Mama', 'Russia', 'Asia', 'RSXX0303', 0),
(0, 'Mariinsk', 'Russia', 'Asia', 'RSXX0264', 0),
(0, 'Markovo', 'Russia', 'Asia', 'RSXX0149', 0),
(0, 'Masljanino', 'Russia', 'Asia', 'RSXX0286', 0),
(0, 'Maykop', 'Russia', 'Asia', 'RSXX1301', 0),
(0, 'Mayya', 'Russia', 'Asia', 'RSXX0061', 0),
(0, 'Mednogorsk', 'Russia', 'Asia', 'RSXX1524', 0),
(0, 'Medvezegorsk', 'Russia', 'Asia', 'RSXX0206', 0),
(0, 'Meleuz', 'Russia', 'Asia', 'RSXX0243', 0),
(0, 'Merenga', 'Russia', 'Asia', 'RSXX1463', 0),
(0, 'Mezen`', 'Russia', 'Asia', 'RSXX1313', 0),
(0, 'Mezhdurechenskiy', 'Russia', 'Asia', 'RSXX1353', 0),
(0, 'Miass', 'Russia', 'Asia', 'RSXX0062', 0),
(0, 'Michurinsk', 'Russia', 'Asia', 'RSXX1589', 0),
(0, 'Millerovo', 'Russia', 'Asia', 'RSXX1551', 0),
(0, 'Mineral`Nye Vody', 'Russia', 'Asia', 'RSXX0442', 0),
(0, 'Minusinsk', 'Russia', 'Asia', 'RSXX1389', 0),
(0, 'Mirny', 'Russia', 'Asia', 'RSXX1425', 0),
(0, 'Mogoca', 'Russia', 'Asia', 'RSXX0321', 0),
(0, 'Mokshan', 'Russia', 'Asia', 'RSXX1532', 0),
(0, 'Monchegorsk', 'Russia', 'Asia', 'RSXX1510', 0),
(0, 'Mondy', 'Russia', 'Asia', 'RSXX0333', 0),
(0, 'Morozovsk', 'Russia', 'Asia', 'RSXX0422', 0),
(0, 'Morshansk', 'Russia', 'Asia', 'RSXX1590', 0),
(0, 'Moscow', 'Russia', 'Asia', 'RSXX0063', 0),
(0, 'Mostovskoy', 'Russia', 'Asia', 'RSXX1426', 0),
(0, 'Mozajsk', 'Russia', 'Asia', 'RSXX1481', 0),
(0, 'Mozdok', 'Russia', 'Asia', 'RSXX0445', 0),
(0, 'Mozhga', 'Russia', 'Asia', 'RSXX1606', 0),
(0, 'Mtsensk', 'Russia', 'Asia', 'RSXX1530', 0),
(0, 'Murashi', 'Russia', 'Asia', 'RSXX1378', 0),
(0, 'Murmansk', 'Russia', 'Asia', 'RSXX0452', 0),
(0, 'Murom', 'Russia', 'Asia', 'RSXX1612', 0),
(0, 'Mys Shmidta', 'Russia', 'Asia', 'RSXX1336', 0),
(0, 'Mytishchi', 'Russia', 'Asia', 'RSXX0065', 0),
(0, 'Naberezhnye Chelny', 'Russia', 'Asia', 'RSXX1586', 0),
(0, 'Nadym', 'Russia', 'Asia', 'RSXX1629', 0),
(0, 'Nagornyj', 'Russia', 'Asia', 'RSXX0313', 0),
(0, 'Nahodka', 'Russia', 'Asia', 'RSXX0066', 0),
(0, 'Nal`chik', 'Russia', 'Asia', 'RSXX1372', 0),
(0, 'Namtsy', 'Russia', 'Asia', 'RSXX0067', 0),
(0, 'Napas', 'Russia', 'Asia', 'RSXX0244', 0),
(0, 'Nar`yan-Mar', 'Russia', 'Asia', 'RSXX1519', 0),
(0, 'Naro-Fominsk', 'Russia', 'Asia', 'RSXX1482', 0),
(0, 'Narym', 'Russia', 'Asia', 'RSXX1601', 0),
(0, 'Nazimovo', 'Russia', 'Asia', 'RSXX0245', 0),
(0, 'Nazran`', 'Russia', 'Asia', 'RSXX1564', 0),
(0, 'Nazyvoevsk', 'Russia', 'Asia', 'RSXX1240', 0),
(0, 'Neftekamsk', 'Russia', 'Asia', 'RSXX1320', 0),
(0, 'Nefteyugansk', 'Russia', 'Asia', 'RSXX1354', 0),
(0, 'Nerchinsk', 'Russia', 'Asia', 'RSXX1339', 0),
(0, 'Nerchinskij Zavod', 'Russia', 'Asia', 'RSXX0344', 0),
(0, 'Nev`yansk', 'Russia', 'Asia', 'RSXX1580', 0),
(0, 'Nevel`sk', 'Russia', 'Asia', 'RSXX1558', 0),
(0, 'Nevinnomyssk', 'Russia', 'Asia', 'RSXX1568', 0),
(0, 'Nikol`Sk', 'Russia', 'Asia', 'RSXX0172', 0),
(0, 'Nikolaevsk-Na-Amure', 'Russia', 'Asia', 'RSXX0361', 0),
(0, 'Nikolaevskoe', 'Russia', 'Asia', 'RSXX0156', 0),
(0, 'Nikolo-Poloma', 'Russia', 'Asia', 'RSXX0177', 0),
(0, 'Nizhneangarsk', 'Russia', 'Asia', 'RSXX0311', 0),
(0, 'Nizhnekamsk', 'Russia', 'Asia', 'RSXX1587', 0),
(0, 'Nizhneudinsk', 'Russia', 'Asia', 'RSXX0282', 0),
(0, 'Nizhnevartovsk', 'Russia', 'Asia', 'RSXX1355', 0),
(0, 'Nizhniy Novgorod', 'Russia', 'Asia', 'RSXX0069', 0),
(0, 'Niznij Novgorod', 'Russia', 'Asia', 'RSXX0185', 0),
(0, 'Niznij Tagil', 'Russia', 'Asia', 'RSXX0070', 0),
(0, 'Njandoma', 'Russia', 'Asia', 'RSXX0219', 0),
(0, 'Njurba', 'Russia', 'Asia', 'RSXX0133', 0),
(0, 'Noginsk', 'Russia', 'Asia', 'RSXX0071', 0),
(0, 'Nogliki', 'Russia', 'Asia', 'RSXX0396', 0),
(0, 'Nolinsk', 'Russia', 'Asia', 'RSXX0183', 0),
(0, 'Noril`sk', 'Russia', 'Asia', 'RSXX1597', 0),
(0, 'Norsk', 'Russia', 'Asia', 'RSXX0363', 0),
(0, 'Novaya Igirma', 'Russia', 'Asia', 'RSXX1359', 0),
(0, 'Novgorod', 'Russia', 'Asia', 'RSXX0157', 0),
(0, 'Novocherkassk', 'Russia', 'Asia', 'RSXX0073', 0),
(0, 'Novokuybyshevsk', 'Russia', 'Asia', 'RSXX0075', 0),
(0, 'Novokuznetsk', 'Russia', 'Asia', 'RSXX0076', 0),
(0, 'Novomichurinsk', 'Russia', 'Asia', 'RSXX1547', 0),
(0, 'Novomoskovsk', 'Russia', 'Asia', 'RSXX1593', 0),
(0, 'Novorossiyka', 'Russia', 'Asia', 'RSXX1308', 0),
(0, 'Novorossiysk', 'Russia', 'Asia', 'RSXX1427', 0),
(0, 'Novoselenginsk', 'Russia', 'Asia', 'RSXX0338', 0),
(0, 'Novosibirsk', 'Russia', 'Asia', 'RSXX0077', 0),
(0, 'Novy Oskol', 'Russia', 'Asia', 'RSXX1325', 0),
(0, 'Novy Urengoy', 'Russia', 'Asia', 'RSXX1630', 0),
(0, 'Noyabr`sk', 'Russia', 'Asia', 'RSXX1631', 0),
(0, 'Nozovka', 'Russia', 'Asia', 'RSXX0227', 0),
(0, 'Nurlat', 'Russia', 'Asia', 'RSXX1588', 0),
(0, 'Ob ` Jacevo', 'Russia', 'Asia', 'RSXX0226', 0),
(0, 'Obluc`E', 'Russia', 'Asia', 'RSXX0377', 0),
(0, 'Obninsk', 'Russia', 'Asia', 'RSXX1383', 0),
(0, 'Oboyan`', 'Russia', 'Asia', 'RSXX1442', 0),
(0, 'Odesskoe', 'Russia', 'Asia', 'RSXX1251', 0),
(0, 'Odincovo', 'Russia', 'Asia', 'RSXX1639', 0),
(0, 'Ohansk', 'Russia', 'Asia', 'RSXX0228', 0),
(0, 'Ojmjakon', 'Russia', 'Asia', 'RSXX0138', 0),
(0, 'Okha', 'Russia', 'Asia', 'RSXX1559', 0),
(0, 'Okhotsk', 'Russia', 'Asia', 'RSXX1560', 0),
(0, 'Oktjabr`Skoe', 'Russia', 'Asia', 'RSXX1218', 0),
(0, 'Olekminsk', 'Russia', 'Asia', 'RSXX0143', 0),
(0, 'Olenegorsk', 'Russia', 'Asia', 'RSXX1511', 0),
(0, 'Olenek', 'Russia', 'Asia', 'RSXX1623', 0),
(0, 'Olovjannaja', 'Russia', 'Asia', 'RSXX0349', 0),
(0, 'Omsk', 'Russia', 'Asia', 'RSXX0080', 0),
(0, 'Onega', 'Russia', 'Asia', 'RSXX0201', 0),
(0, 'Oparino', 'Russia', 'Asia', 'RSXX0173', 0),
(0, 'Ordynskoe', 'Russia', 'Asia', 'RSXX0285', 0),
(0, 'Orehovo-Zuevo', 'Russia', 'Asia', 'RSXX1483', 0),
(0, 'Orel', 'Russia', 'Asia', 'RSXX0205', 0),
(0, 'Orenburg', 'Russia', 'Asia', 'RSXX0433', 0),
(0, 'Orlik', 'Russia', 'Asia', 'RSXX0301', 0),
(0, 'Orsk', 'Russia', 'Asia', 'RSXX1525', 0),
(0, 'Osa', 'Russia', 'Asia', 'RSXX1540', 0),
(0, 'Ostaskov', 'Russia', 'Asia', 'RSXX0161', 0),
(0, 'Ozernaja', 'Russia', 'Asia', 'RSXX0409', 0),
(0, 'Ozery', 'Russia', 'Asia', 'RSXX1484', 0),
(0, 'Partizansk', 'Russia', 'Asia', 'RSXX0394', 0),
(0, 'Pavelec', 'Russia', 'Asia', 'RSXX0202', 0),
(0, 'Pavlovskij Posad', 'Russia', 'Asia', 'RSXX1485', 0),
(0, 'Pechenga', 'Russia', 'Asia', 'RSXX1512', 0),
(0, 'Pechora', 'Russia', 'Asia', 'RSXX1401', 0),
(0, 'Penza', 'Russia', 'Asia', 'RSXX0211', 0),
(0, 'Pereslavl`-Zalesskiy', 'Russia', 'Asia', 'RSXX1613', 0),
(0, 'Perm`', 'Russia', 'Asia', 'RSXX0082', 0),
(0, 'Pervoural`sk', 'Russia', 'Asia', 'RSXX0084', 0),
(0, 'Petropavlovsk-Kamchatskiy', 'Russia', 'Asia', 'RSXX0407', 0),
(0, 'Petrovskij Zavod', 'Russia', 'Asia', 'RSXX0339', 0),
(0, 'Petrozavodsk', 'Russia', 'Asia', 'RSXX0212', 0),
(0, 'Petushki', 'Russia', 'Asia', 'RSXX1614', 0),
(0, 'Pevek', 'Russia', 'Asia', 'RSXX1337', 0),
(0, 'Pil`Vo', 'Russia', 'Asia', 'RSXX0398', 0),
(0, 'Pinega', 'Russia', 'Asia', 'RSXX1314', 0),
(0, 'Pirovskoe', 'Russia', 'Asia', 'RSXX0255', 0),
(0, 'Plesetsk', 'Russia', 'Asia', 'RSXX1315', 0),
(0, 'Podol`sk', 'Russia', 'Asia', 'RSXX0086', 0),
(0, 'Pogibi', 'Russia', 'Asia', 'RSXX0395', 0),
(0, 'Pokrovskaja', 'Russia', 'Asia', 'RSXX0141', 0),
(0, 'Poltavka', 'Russia', 'Asia', 'RSXX1249', 0),
(0, 'Poronajsk', 'Russia', 'Asia', 'RSXX0400', 0),
(0, 'Pos`Et', 'Russia', 'Asia', 'RSXX0392', 0),
(0, 'Poyarkovo', 'Russia', 'Asia', 'RSXX1309', 0),
(0, 'Priargunsk', 'Russia', 'Asia', 'RSXX0351', 0),
(0, 'Primorsko-Ahtarsk', 'Russia', 'Asia', 'RSXX0426', 0),
(0, 'Priozersk', 'Russia', 'Asia', 'RSXX1452', 0),
(0, 'Privodino', 'Russia', 'Asia', 'RSXX0088', 0),
(0, 'Progranichnoe', 'Russia', 'Asia', 'RSXX0399', 0),
(0, 'Progranichnyj', 'Russia', 'Asia', 'RSXX0389', 0),
(0, 'Psebay', 'Russia', 'Asia', 'RSXX1428', 0),
(0, 'Pskov', 'Russia', 'Asia', 'RSXX0158', 0),
(0, 'Pudino', 'Russia', 'Asia', 'RSXX0253', 0),
(0, 'Pudoz', 'Russia', 'Asia', 'RSXX0214', 0),
(0, 'Pushkin', 'Russia', 'Asia', 'RSXX0089', 0),
(0, 'Pushkinskiye Gory', 'Russia', 'Asia', 'RSXX1545', 0),
(0, 'Puskino', 'Russia', 'Asia', 'RSXX1486', 0),
(0, 'Pyatigorsk', 'Russia', 'Asia', 'RSXX1569', 0),
(0, 'Raduzhny', 'Russia', 'Asia', 'RSXX1356', 0),
(0, 'Ramenskoe', 'Russia', 'Asia', 'RSXX1487', 0),
(0, 'Reboly', 'Russia', 'Asia', 'RSXX0197', 0),
(0, 'Rebriha', 'Russia', 'Asia', 'RSXX0296', 0),
(0, 'Remontnoe', 'Russia', 'Asia', 'RSXX0425', 0),
(0, 'Rjazan', 'Russia', 'Asia', 'RSXX0198', 0),
(0, 'Romanovka', 'Russia', 'Asia', 'RSXX0320', 0),
(0, 'Roslavl', 'Russia', 'Asia', 'RSXX0166', 0),
(0, 'Rossosh`', 'Russia', 'Asia', 'RSXX1619', 0),
(0, 'Rostov', 'Russia', 'Asia', 'RSXX0179', 0),
(0, 'Rostov-na-Donu', 'Russia', 'Asia', 'RSXX0090', 0),
(0, 'Rubcovsk', 'Russia', 'Asia', 'RSXX0436', 0),
(0, 'Rudnaja Pristan', 'Russia', 'Asia', 'RSXX0391', 0),
(0, 'Ruza', 'Russia', 'Asia', 'RSXX1488', 0),
(0, 'Ryazhsk', 'Russia', 'Asia', 'RSXX1548', 0),
(0, 'Rybinsk', 'Russia', 'Asia', 'RSXX1635', 0),
(0, 'Ryl`sk', 'Russia', 'Asia', 'RSXX1443', 0),
(0, 'Rzhev', 'Russia', 'Asia', 'RSXX1605', 0),
(0, 'Sadrinsk', 'Russia', 'Asia', 'RSXX1235', 0),
(0, 'Sahovskaja', 'Russia', 'Asia', 'RSXX1489', 0),
(0, 'Saim', 'Russia', 'Asia', 'RSXX1232', 0),
(0, 'Saint Petersburg', 'Russia', 'Asia', 'RSXX0091', 0),
(0, 'Sakun`Ja', 'Russia', 'Asia', 'RSXX0182', 0),
(0, 'Sal`sk', 'Russia', 'Asia', 'RSXX1552', 0),
(0, 'Salavat', 'Russia', 'Asia', 'RSXX0092', 0),
(0, 'Salekhard', 'Russia', 'Asia', 'RSXX1632', 0),
(0, 'Samara', 'Russia', 'Asia', 'RSXX0094', 0),
(0, 'Samary', 'Russia', 'Asia', 'RSXX0230', 0),
(0, 'Sangary', 'Russia', 'Asia', 'RSXX0135', 0),
(0, 'Sar`Ja', 'Russia', 'Asia', 'RSXX0178', 0),
(0, 'Saransk', 'Russia', 'Asia', 'RSXX1460', 0),
(0, 'Sarapul', 'Russia', 'Asia', 'RSXX0095', 0),
(0, 'Saratov', 'Russia', 'Asia', 'RSXX0414', 0),
(0, 'Sarov', 'Russia', 'Asia', 'RSXX1461', 0),
(0, 'Sasovo', 'Russia', 'Asia', 'RSXX1549', 0),
(0, 'Satura', 'Russia', 'Asia', 'RSXX1490', 0),
(0, 'Sayansk', 'Russia', 'Asia', 'RSXX1360', 0),
(0, 'Scelkovo', 'Russia', 'Asia', 'RSXX1491', 0),
(0, 'Segeza', 'Russia', 'Asia', 'RSXX0200', 0),
(0, 'Sejmchan', 'Russia', 'Asia', 'RSXX0152', 0),
(0, 'Sektagli', 'Russia', 'Asia', 'RSXX0374', 0),
(0, 'Semyachiki', 'Russia', 'Asia', 'RSXX1437', 0),
(0, 'Senkursk', 'Russia', 'Asia', 'RSXX0208', 0),
(0, 'Serafimovic', 'Russia', 'Asia', 'RSXX0419', 0),
(0, 'Serbakul', 'Russia', 'Asia', 'RSXX1250', 0),
(0, 'Serebrjanye Prudy', 'Russia', 'Asia', 'RSXX1492', 0),
(0, 'Serednikovo', 'Russia', 'Asia', 'RSXX1493', 0),
(0, 'Sergiyev Posad', 'Russia', 'Asia', 'RSXX0096', 0),
(0, 'Serov', 'Russia', 'Asia', 'RSXX1581', 0),
(0, 'Serpuhov', 'Russia', 'Asia', 'RSXX1495', 0),
(0, 'Severnoe', 'Russia', 'Asia', 'RSXX0257', 0),
(0, 'Severo-Kuril`Sk', 'Russia', 'Asia', 'RSXX0404', 0),
(0, 'Severobaykal`sk', 'Russia', 'Asia', 'RSXX1327', 0),
(0, 'Severodvinsk', 'Russia', 'Asia', 'RSXX1316', 0),
(0, 'Severomorsk', 'Russia', 'Asia', 'RSXX1513', 0),
(0, 'Shakhterskiy', 'Russia', 'Asia', 'RSXX0099', 0),
(0, 'Shakhty', 'Russia', 'Asia', 'RSXX1553', 0),
(0, 'Shatki', 'Russia', 'Asia', 'RSXX1517', 0),
(0, 'Shchel`yayur', 'Russia', 'Asia', 'RSXX1402', 0),
(0, 'Shelagontsy', 'Russia', 'Asia', 'RSXX1624', 0),
(0, 'Sheregesh', 'Russia', 'Asia', 'RSXX1379', 0),
(0, 'Sheremetyevo International Airport', 'Russia', 'Asia', 'RSXX1494', 0),
(0, 'Shilka', 'Russia', 'Asia', 'RSXX0343', 0),
(0, 'Shuya', 'Russia', 'Asia', 'RSXX1368', 0),
(0, 'Sibay', 'Russia', 'Asia', 'RSXX1321', 0),
(0, 'Simanovsk', 'Russia', 'Asia', 'RSXX0367', 0),
(0, 'Sira', 'Russia', 'Asia', 'RSXX0287', 0),
(0, 'Skovorodino', 'Russia', 'Asia', 'RSXX0324', 0),
(0, 'Sladkovo', 'Russia', 'Asia', 'RSXX1598', 0),
(0, 'Slavgorod', 'Russia', 'Asia', 'RSXX1305', 0),
(0, 'Slavyansk-na-Kubani', 'Russia', 'Asia', 'RSXX1429', 0),
(0, 'Smidovich', 'Russia', 'Asia', 'RSXX0380', 0),
(0, 'Smolensk', 'Russia', 'Asia', 'RSXX0165', 0),
(0, 'Snezhinsk', 'Russia', 'Asia', 'RSXX1332', 0),
(0, 'Sobolevo', 'Russia', 'Asia', 'RSXX1438', 0),
(0, 'Sochi', 'Russia', 'Asia', 'RSXX1430', 0),
(0, 'Sol`-Iletsk', 'Russia', 'Asia', 'RSXX1526', 0),
(0, 'Solikamsk', 'Russia', 'Asia', 'RSXX1541', 0),
(0, 'Solnecnogorsk', 'Russia', 'Asia', 'RSXX1496', 0),
(0, 'Solnethnaya', 'Russia', 'Asia', 'RSXX0315', 0),
(0, 'Solonovka', 'Russia', 'Asia', 'RSXX0101', 0),
(0, 'Solovki', 'Russia', 'Asia', 'RSXX1395', 0),
(0, 'Sorochinsk', 'Russia', 'Asia', 'RSXX1527', 0),
(0, 'Sortavala', 'Russia', 'Asia', 'RSXX0210', 0),
(0, 'Sosnogorsk', 'Russia', 'Asia', 'RSXX1403', 0),
(0, 'Sosnovo-Ozerskoe', 'Russia', 'Asia', 'RSXX0330', 0),
(0, 'Sosnovy Bor', 'Russia', 'Asia', 'RSXX1453', 0),
(0, 'Sosva', 'Russia', 'Asia', 'RSXX0233', 0),
(0, 'Sovetskiy', 'Russia', 'Asia', 'RSXX1357', 0),
(0, 'Spasskiy', 'Russia', 'Asia', 'RSXX0102', 0),
(0, 'Sredny Vasjugan', 'Russia', 'Asia', 'RSXX0246', 0),
(0, 'Sretensk', 'Russia', 'Asia', 'RSXX0332', 0),
(0, 'Stanitsa Kanevskaya', 'Russia', 'Asia', 'RSXX1431', 0),
(0, 'Staraja Russa', 'Russia', 'Asia', 'RSXX0159', 0),
(0, 'Stary Oskol', 'Russia', 'Asia', 'RSXX1326', 0),
(0, 'Stavropol`', 'Russia', 'Asia', 'RSXX1570', 0),
(0, 'Sterlitamak', 'Russia', 'Asia', 'RSXX0241', 0),
(0, 'Stupino', 'Russia', 'Asia', 'RSXX1497', 0),
(0, 'Suhaja', 'Russia', 'Asia', 'RSXX0326', 0),
(0, 'Taganrog', 'Russia', 'Asia', 'RSXX0105', 0),
(0, 'Taldom', 'Russia', 'Asia', 'RSXX1498', 0),
(0, 'Talon', 'Russia', 'Asia', 'RSXX0106', 0),
(0, 'Tambey', 'Russia', 'Asia', 'RSXX1633', 0),
(0, 'Tambov', 'Russia', 'Asia', 'RSXX0209', 0),
(0, 'Tanhoj', 'Russia', 'Asia', 'RSXX0337', 0),
(0, 'Tara', 'Russia', 'Asia', 'RSXX1227', 0),
(0, 'Tarko-Sale', 'Russia', 'Asia', 'RSXX0229', 0),
(0, 'Tashtagol', 'Russia', 'Asia', 'RSXX1380', 0),
(0, 'Tastyp', 'Russia', 'Asia', 'RSXX0299', 0),
(0, 'Tatarsk', 'Russia', 'Asia', 'RSXX0272', 0),
(0, 'Tavda', 'Russia', 'Asia', 'RSXX1582', 0),
(0, 'Teberda', 'Russia', 'Asia', 'RSXX1376', 0),
(0, 'Temryuk', 'Russia', 'Asia', 'RSXX1432', 0),
(0, 'Teriberka', 'Russia', 'Asia', 'RSXX1514', 0),
(0, 'Ternej', 'Russia', 'Asia', 'RSXX0388', 0),
(0, 'Terney', 'Russia', 'Asia', 'RSXX1535', 0),
(0, 'Terskol', 'Russia', 'Asia', 'RSXX1373', 0),
(0, 'Tihoreck', 'Russia', 'Asia', 'RSXX0427', 0),
(0, 'Tihvin', 'Russia', 'Asia', 'RSXX0155', 0),
(0, 'Tiksi', 'Russia', 'Asia', 'RSXX1625', 0),
(0, 'Timashevsk', 'Russia', 'Asia', 'RSXX1433', 0),
(0, 'Tisul', 'Russia', 'Asia', 'RSXX0266', 0),
(0, 'Tivjaku', 'Russia', 'Asia', 'RSXX0381', 0),
(0, 'Tjuhtet', 'Russia', 'Asia', 'RSXX0259', 0),
(0, 'Tjukalinsk', 'Russia', 'Asia', 'RSXX1238', 0),
(0, 'Tjumen', 'Russia', 'Asia', 'RSXX0232', 0),
(0, 'Tobol`Sk', 'Russia', 'Asia', 'RSXX0224', 0),
(0, 'Toguchin', 'Russia', 'Asia', 'RSXX0276', 0),
(0, 'Tokma', 'Russia', 'Asia', 'RSXX1361', 0),
(0, 'Toko', 'Russia', 'Asia', 'RSXX0354', 0),
(0, 'Toksovo', 'Russia', 'Asia', 'RSXX1454', 0),
(0, 'Tol`yatti', 'Russia', 'Asia', 'RSXX1565', 0),
(0, 'Tompa', 'Russia', 'Asia', 'RSXX1328', 0),
(0, 'Tompo', 'Russia', 'Asia', 'RSXX0137', 0),
(0, 'Tomsk', 'Russia', 'Asia', 'RSXX0258', 0),
(0, 'Tosno', 'Russia', 'Asia', 'RSXX0108', 0),
(0, 'Tot`Ma', 'Russia', 'Asia', 'RSXX0171', 0),
(0, 'Troicko-Pecherskoe', 'Russia', 'Asia', 'RSXX0240', 0),
(0, 'Troitsko-Pechorsk', 'Russia', 'Asia', 'RSXX1404', 0),
(0, 'Troizk', 'Russia', 'Asia', 'RSXX1248', 0),
(0, 'Trubcevsk', 'Russia', 'Asia', 'RSXX0168', 0),
(0, 'Tsimlyansk', 'Russia', 'Asia', 'RSXX1554', 0),
(0, 'Tuapse', 'Russia', 'Asia', 'RSXX0440', 0),
(0, 'Tula', 'Russia', 'Asia', 'RSXX0109', 0),
(0, 'Tulpan', 'Russia', 'Asia', 'RSXX1542', 0),
(0, 'Tunka', 'Russia', 'Asia', 'RSXX0334', 0),
(0, 'Tura', 'Russia', 'Asia', 'RSXX0132', 0),
(0, 'Turinsk', 'Russia', 'Asia', 'RSXX0222', 0),
(0, 'Turocak', 'Russia', 'Asia', 'RSXX0439', 0),
(0, 'Turukhansk', 'Russia', 'Asia', 'RSXX1390', 0),
(0, 'Tutayev', 'Russia', 'Asia', 'RSXX1636', 0),
(0, 'Tutonchany', 'Russia', 'Asia', 'RSXX1348', 0),
(0, 'Tver', 'Russia', 'Asia', 'RSXX0184', 0),
(0, 'Tynda', 'Russia', 'Asia', 'RSXX0314', 0),
(0, 'Uakit', 'Russia', 'Asia', 'RSXX0312', 0),
(0, 'Udachnyy', 'Russia', 'Asia', 'RSXX1640', 0),
(0, 'Uega', 'Russia', 'Asia', 'RSXX0147', 0),
(0, 'Uelen', 'Russia', 'Asia', 'RSXX1338', 0),
(0, 'Ufa', 'Russia', 'Asia', 'RSXX0111', 0),
(0, 'Uglich', 'Russia', 'Asia', 'RSXX1637', 0),
(0, 'Uhta', 'Russia', 'Asia', 'RSXX0231', 0),
(0, 'Ujar', 'Russia', 'Asia', 'RSXX0268', 0),
(0, 'Ul`yanovsk', 'Russia', 'Asia', 'RSXX0113', 0),
(0, 'Ulan-Ude', 'Russia', 'Asia', 'RSXX0336', 0),
(0, 'Ulety', 'Russia', 'Asia', 'RSXX0341', 0),
(0, 'Ulyanovsk', 'Russia', 'Asia', 'RSXX0199', 0),
(0, 'Urjupinsk', 'Russia', 'Asia', 'RSXX0416', 0),
(0, 'Urmi', 'Russia', 'Asia', 'RSXX0375', 0),
(0, 'Usinsk', 'Russia', 'Asia', 'RSXX1405', 0),
(0, 'Usman`', 'Russia', 'Asia', 'RSXX1620', 0),
(0, 'Usol`ye-Sibirskoye', 'Russia', 'Asia', 'RSXX1362', 0),
(0, 'Ussuriysk', 'Russia', 'Asia', 'RSXX0114', 0),
(0, 'Ust` Kalmanka', 'Russia', 'Asia', 'RSXX1306', 0),
(0, 'Ust`- Barguzin', 'Russia', 'Asia', 'RSXX0319', 0),
(0, 'Ust`- Isim', 'Russia', 'Asia', 'RSXX0235', 0),
(0, 'Ust`- Judoma', 'Russia', 'Asia', 'RSXX0353', 0),
(0, 'Ust`- Kulom', 'Russia', 'Asia', 'RSXX1221', 0),
(0, 'Ust`- Kut', 'Russia', 'Asia', 'RSXX0307', 0),
(0, 'Ust`- Maja', 'Russia', 'Asia', 'RSXX0146', 0),
(0, 'Ust`- Njukzha', 'Russia', 'Asia', 'RSXX0309', 0),
(0, 'Ust`- Umal`Ta', 'Russia', 'Asia', 'RSXX0369', 0),
(0, 'Ust`-Ilimsk', 'Russia', 'Asia', 'RSXX1363', 0),
(0, 'Ust`-Ordynskiy', 'Russia', 'Asia', 'RSXX1364', 0),
(0, 'Ust`Kamchatsk', 'Russia', 'Asia', 'RSXX0406', 0),
(0, 'Ustyuzhna', 'Russia', 'Asia', 'RSXX1617', 0),
(0, 'Usugli', 'Russia', 'Asia', 'RSXX0331', 0),
(0, 'Uvarovo', 'Russia', 'Asia', 'RSXX1591', 0),
(0, 'Uybat', 'Russia', 'Asia', 'RSXX0294', 0),
(0, 'Uzur', 'Russia', 'Asia', 'RSXX0278', 0),
(0, 'Valday', 'Russia', 'Asia', 'RSXX1522', 0),
(0, 'Vanzil`- Kynak', 'Russia', 'Asia', 'RSXX1239', 0),
(0, 'Vel`Sk', 'Russia', 'Asia', 'RSXX0220', 0),
(0, 'Velikie Luki', 'Russia', 'Asia', 'RSXX0162', 0),
(0, 'Velikiy Ustyug', 'Russia', 'Asia', 'RSXX1618', 0),
(0, 'Vendinga', 'Russia', 'Asia', 'RSXX1406', 0),
(0, 'Verescagino', 'Russia', 'Asia', 'RSXX0221', 0),
(0, 'Verhneimbatsk', 'Russia', 'Asia', 'RSXX0236', 0),
(0, 'Verhnij Baskuncak', 'Russia', 'Asia', 'RSXX0423', 0),
(0, 'Verhnij Ufalej', 'Russia', 'Asia', 'RSXX1233', 0),
(0, 'Verkhne-Penzhino', 'Russia', 'Asia', 'RSXX1445', 0),
(0, 'Verkhniy Tagil', 'Russia', 'Asia', 'RSXX1583', 0),
(0, 'Verkhotur`ye', 'Russia', 'Asia', 'RSXX1584', 0),
(0, 'Verkhoyansk', 'Russia', 'Asia', 'RSXX1626', 0),
(0, 'Veselaja Gorka', 'Russia', 'Asia', 'RSXX0365', 0),
(0, 'Vesljana', 'Russia', 'Asia', 'RSXX0238', 0),
(0, 'Vidnoe', 'Russia', 'Asia', 'RSXX1499', 0),
(0, 'Vikulovo', 'Russia', 'Asia', 'RSXX1223', 0),
(0, 'Viljujsk', 'Russia', 'Asia', 'RSXX0134', 0),
(0, 'Vitim', 'Russia', 'Asia', 'RSXX0302', 0),
(0, 'Vjaz`Ma', 'Russia', 'Asia', 'RSXX0164', 0),
(0, 'Vladimir', 'Russia', 'Asia', 'RSXX0187', 0),
(0, 'Vladivostok', 'Russia', 'Asia', 'RSXX0116', 0),
(0, 'Vnukovo International Airport', 'Russia', 'Asia', 'RSXX1500', 0),
(0, 'Volciha', 'Russia', 'Asia', 'RSXX0435', 0),
(0, 'Volgodonsk', 'Russia', 'Asia', 'RSXX1555', 0),
(0, 'Volgograd', 'Russia', 'Asia', 'RSXX0117', 0),
(0, 'Volkhov', 'Russia', 'Asia', 'RSXX1455', 0),
(0, 'Vologda', 'Russia', 'Asia', 'RSXX0170', 0),
(0, 'Volokolamsk', 'Russia', 'Asia', 'RSXX1501', 0),
(0, 'Volzhskiy', 'Russia', 'Asia', 'RSXX0118', 0),
(0, 'Vorkuta', 'Russia', 'Asia', 'RSXX1407', 0),
(0, 'Vorogovo', 'Russia', 'Asia', 'RSXX1241', 0),
(0, 'Voronez', 'Russia', 'Asia', 'RSXX0412', 0),
(0, 'Voskresensk', 'Russia', 'Asia', 'RSXX1502', 0),
(0, 'Votkinsk', 'Russia', 'Asia', 'RSXX0120', 0),
(0, 'Vozega', 'Russia', 'Asia', 'RSXX0225', 0),
(0, 'Vsevolozhsk', 'Russia', 'Asia', 'RSXX1456', 0),
(0, 'Vuktyl', 'Russia', 'Asia', 'RSXX1408', 0),
(0, 'Vyborg', 'Russia', 'Asia', 'RSXX0121', 0),
(0, 'Vytegra', 'Russia', 'Asia', 'RSXX0216', 0),
(0, 'Wladikavkaz', 'Russia', 'Asia', 'RSXX0447', 0),
(0, 'Yakutsk', 'Russia', 'Asia', 'RSXX0122', 0),
(0, 'Yaroslavl`', 'Russia', 'Asia', 'RSXX1638', 0),
(0, 'Yasny', 'Russia', 'Asia', 'RSXX1528', 0),
(0, 'Yekaterinburg', 'Russia', 'Asia', 'RSXX0123', 0),
(0, 'Yel`nya', 'Russia', 'Asia', 'RSXX1562', 0),
(0, 'Yelizovo', 'Russia', 'Asia', 'RSXX0450', 0),
(0, 'Yerbogachen', 'Russia', 'Asia', 'RSXX1365', 0),
(0, 'Yessentuki', 'Russia', 'Asia', 'RSXX1571', 0),
(0, 'Yeysk', 'Russia', 'Asia', 'RSXX1434', 0),
(0, 'Yoshkar-Ola', 'Russia', 'Asia', 'RSXX1506', 0),
(0, 'Yur`yev-Pol`skiy', 'Russia', 'Asia', 'RSXX1616', 0),
(0, 'Yurovsk', 'Russia', 'Asia', 'RSXX1599', 0),
(0, 'Yuryuzan`', 'Russia', 'Asia', 'RSXX1322', 0),
(0, 'Yuzhno-Sakhalinsk', 'Russia', 'Asia', 'RSXX0125', 0),
(0, 'Yuzhnoural`sk', 'Russia', 'Asia', 'RSXX1333', 0),
(0, 'Zabaykal`sk', 'Russia', 'Asia', 'RSXX1340', 0),
(0, 'Zametcino', 'Russia', 'Asia', 'RSXX0203', 0),
(0, 'Zamokta', 'Russia', 'Asia', 'RSXX0329', 0),
(0, 'Zarajsk', 'Russia', 'Asia', 'RSXX1503', 0),
(0, 'Zavodoukovsk', 'Russia', 'Asia', 'RSXX1600', 0),
(0, 'Zeja', 'Russia', 'Asia', 'RSXX0358', 0),
(0, 'Zelenodol`sk', 'Russia', 'Asia', 'RSXX0126', 0),
(0, 'Zelenogorsk', 'Russia', 'Asia', 'RSXX1457', 0),
(0, 'Zelenograd', 'Russia', 'Asia', 'RSXX1504', 0),
(0, 'Zerdevka', 'Russia', 'Asia', 'RSXX0411', 0),
(0, 'Zheleznogorsk', 'Russia', 'Asia', 'RSXX1444', 0),
(0, 'Zhigansk', 'Russia', 'Asia', 'RSXX1627', 0),
(0, 'Zhigulevsk', 'Russia', 'Asia', 'RSXX1566', 0),
(0, 'Zilair', 'Russia', 'Asia', 'RSXX0432', 0),
(0, 'Zima', 'Russia', 'Asia', 'RSXX0127', 0),
(0, 'Zlatoust', 'Russia', 'Asia', 'RSXX1334', 0),
(0, 'Zmeinogorsk', 'Russia', 'Asia', 'RSXX0437', 0),
(0, 'Zolotoj', 'Russia', 'Asia', 'RSXX0384', 0),
(0, 'Zvenigorod', 'Russia', 'Asia', 'RSXX1505', 0),
(0, 'Kovrov', 'Russia', 'Asia', 'RSXX1611', 0),
(0, 'Koz`Modem`Jansk', 'Russia', 'Asia', 'RSXX0186', 0),
(0, 'Krasnaya Polyana', 'Russia', 'Asia', 'RSXX1418', 0),
(0, 'Krasnodar', 'Russia', 'Asia', 'RSXX0430', 0),
(0, 'Krasnokamsk', 'Russia', 'Asia', 'RSXX0053', 0),
(0, 'Krasnoozersk', 'Russia', 'Asia', 'RSXX0290', 0),
(0, 'Krasnosel`kup', 'Russia', 'Asia', 'RSXX1628', 0),
(0, 'Krasnotur`yinsk', 'Russia', 'Asia', 'RSXX1578', 0),
(0, 'Krasnoufimsk', 'Russia', 'Asia', 'RSXX1217', 0),
(0, 'Krasnoural`sk', 'Russia', 'Asia', 'RSXX1579', 0),
(0, 'Krasnovishersk', 'Russia', 'Asia', 'RSXX1539', 0),
(0, 'Krasnoyarsk', 'Russia', 'Asia', 'RSXX0267', 0),
(0, 'Krasnye Baki', 'Russia', 'Asia', 'RSXX0181', 0),
(0, 'Krasnyj Chikoj', 'Russia', 'Asia', 'RSXX0346', 0),
(0, 'Krasnyj Jar', 'Russia', 'Asia', 'RSXX0385', 0),
(0, 'Kreschenka', 'Russia', 'Asia', 'RSXX0263', 0),
(0, 'Kropotkin', 'Russia', 'Asia', 'RSXX1419', 0),
(0, 'Krymsk', 'Russia', 'Asia', 'RSXX1420', 0),
(0, 'Kudymkar', 'Russia', 'Asia', 'RSXX0218', 0),
(0, 'Kulu', 'Russia', 'Asia', 'RSXX1462', 0),
(0, 'Kulunda', 'Russia', 'Asia', 'RSXX1304', 0),
(0, 'Kungur', 'Russia', 'Asia', 'RSXX0054', 0),
(0, 'Kupino', 'Russia', 'Asia', 'RSXX0283', 0),
(0, 'Kur', 'Russia', 'Asia', 'RSXX0376', 0),
(0, 'Kurchatov', 'Russia', 'Asia', 'RSXX1440', 0),
(0, 'Kurgan', 'Russia', 'Asia', 'RSXX1245', 0),
(0, 'Kurganinsk', 'Russia', 'Asia', 'RSXX1421', 0),
(0, 'Kursk', 'Russia', 'Asia', 'RSXX0410', 0),
(0, 'Kurtamysh', 'Russia', 'Asia', 'RSXX1397', 0),
(0, 'Kushchevskaya', 'Russia', 'Asia', 'RSXX1422', 0),
(0, 'Kuznetsk', 'Russia', 'Asia', 'RSXX1531', 0),
(0, 'Kyra', 'Russia', 'Asia', 'RSXX0347', 0),
(0, 'Kyshtym', 'Russia', 'Asia', 'RSXX1331', 0),
(0, 'Kystovka', 'Russia', 'Asia', 'RSXX0256', 0),
(0, 'Kyzyl', 'Russia', 'Asia', 'RSXX1602', 0),
(0, 'Suhaja', 'Russia', 'Asia', 'RSXX0326', 0),
(0, 'Suhinici', 'Russia', 'Asia', 'RSXX0195', 0),
(0, 'Suhobuzimskoe', 'Russia', 'Asia', 'RSXX0261', 0),
(0, 'Sumiha', 'Russia', 'Asia', 'RSXX1244', 0),
(0, 'Suntar', 'Russia', 'Asia', 'RSXX0139', 0),
(0, 'Surgut', 'Russia', 'Asia', 'RSXX1222', 0),
(0, 'Susuman', 'Russia', 'Asia', 'RSXX1464', 0),
(0, 'Suzdal`', 'Russia', 'Asia', 'RSXX1615', 0),
(0, 'Suzun', 'Russia', 'Asia', 'RSXX1520', 0),
(0, 'Svetlogorsk', 'Russia', 'Asia', 'RSXX1371', 0),
(0, 'Svetlograd', 'Russia', 'Asia', 'RSXX0431', 0),
(0, 'Svobodnyj', 'Russia', 'Asia', 'RSXX0368', 0),
(0, 'Syktyvkar', 'Russia', 'Asia', 'RSXX0103', 0),
(0, 'Sym', 'Russia', 'Asia', 'RSXX0130', 0),
(0, 'Syzran', 'Russia', 'Asia', 'RSXX0213', 0),
(0, 'Syzran`', 'Russia', 'Asia', 'RSXX0104', 0),
(0, 'Abha', 'Saudi Arabia', 'Asia', 'SAXX0036', 0),
(0, 'Abyar Ali', 'Saudi Arabia', 'Asia', 'SAXX0001', 0),
(0, 'Ad Dammam', 'Saudi Arabia', 'Asia', 'SAXX0002', 0),
(0, 'Ad Dawadimi', 'Saudi Arabia', 'Asia', 'SAXX0042', 0),
(0, 'Al Ahsa', 'Saudi Arabia', 'Asia', 'SAXX0031', 0),
(0, 'Al Aqiq', 'Saudi Arabia', 'Asia', 'SAXX0041', 0),
(0, 'Al Hariq', 'Saudi Arabia', 'Asia', 'SAXX0003', 0),
(0, 'Al Hulwah', 'Saudi Arabia', 'Asia', 'SAXX0004', 0),
(0, 'Al Jawf', 'Saudi Arabia', 'Asia', 'SAXX0005', 0),
(0, 'Al Khubar', 'Saudi Arabia', 'Asia', 'SAXX0006', 0),
(0, 'Al Lith', 'Saudi Arabia', 'Asia', 'SAXX0007', 0),
(0, 'Al Qabiyah', 'Saudi Arabia', 'Asia', 'SAXX0008', 0),
(0, 'Al Qaysumah', 'Saudi Arabia', 'Asia', 'SAXX0026', 0),
(0, 'Arar', 'Saudi Arabia', 'Asia', 'SAXX0023', 0),
(0, 'As Sulaymaniyah', 'Saudi Arabia', 'Asia', 'SAXX0009', 0),
(0, 'Bahrah', 'Saudi Arabia', 'Asia', 'SAXX0010', 0),
(0, 'Bisha', 'Saudi Arabia', 'Asia', 'SAXX0035', 0),
(0, 'Gassim', 'Saudi Arabia', 'Asia', 'SAXX0030', 0),
(0, 'Gizan', 'Saudi Arabia', 'Asia', 'SAXX0040', 0),
(0, 'Guriat', 'Saudi Arabia', 'Asia', 'SAXX0024', 0),
(0, 'Hafar Al-Batin', 'Saudi Arabia', 'Asia', 'SAXX0043', 0),
(0, 'Hail', 'Saudi Arabia', 'Asia', 'SAXX0028', 0),
(0, 'Jeddah/Abdul Aziz', 'Saudi Arabia', 'Asia', 'SAXX0011', 0),
(0, 'Jiddah', 'Saudi Arabia', 'Asia', 'SAXX0012', 0),
(0, 'Khamis Mushait', 'Saudi Arabia', 'Asia', 'SAXX0037', 0),
(0, 'Mecca', 'Saudi Arabia', 'Asia', 'SAXX0013', 0),
(0, 'Medina', 'Saudi Arabia', 'Asia', 'SAXX0014', 0),
(0, 'Najran', 'Saudi Arabia', 'Asia', 'SAXX0038', 0),
(0, 'Qara', 'Saudi Arabia', 'Asia', 'SAXX0015', 0),
(0, 'Rabigh', 'Saudi Arabia', 'Asia', 'SAXX0016', 0),
(0, 'Rafha', 'Saudi Arabia', 'Asia', 'SAXX0025', 0),
(0, 'Riyadh', 'Saudi Arabia', 'Asia', 'SAXX0017', 0),
(0, 'Riyadh/Khaled', 'Saudi Arabia', 'Asia', 'SAXX0018', 0),
(0, 'Sakakah', 'Saudi Arabia', 'Asia', 'SAXX0019', 0),
(0, 'Sharurah', 'Saudi Arabia', 'Asia', 'SAXX0039', 0),
(0, 'Tabuk', 'Saudi Arabia', 'Asia', 'SAXX0027', 0),
(0, 'Taif', 'Saudi Arabia', 'Asia', 'SAXX0033', 0),
(0, 'Turaif', 'Saudi Arabia', 'Asia', 'SAXX0022', 0),
(0, 'Wadi Al Dawasser Airport', 'Saudi Arabia', 'Asia', 'SAXX0034', 0),
(0, 'Wejh', 'Saudi Arabia', 'Asia', 'SAXX0029', 0),
(0, 'Yenbo', 'Saudi Arabia', 'Asia', 'SAXX0032', 0),
(0, 'Zahran', 'Saudi Arabia', 'Asia', 'SAXX0021', 0),
(0, 'Bukit Panjang', 'Singapore', 'Asia', 'SNXX0001', 0),
(0, 'Bukit Timah', 'Singapore', 'Asia', 'SNXX0002', 0),
(0, 'Changi', 'Singapore', 'Asia', 'SNXX0003', 0),
(0, 'Paya Lebar', 'Singapore', 'Asia', 'SNXX0004', 0),
(0, 'Serangoon', 'Singapore', 'Asia', 'SNXX0005', 0),
(0, 'Singapore', 'Singapore', 'Asia', 'SNXX0006', 0),
(0, 'Auki', 'Solomon Islands', 'Asia', 'BPXX0003', 0),
(0, 'Honiara', 'Solomon Islands', 'Asia', 'BPXX0001', 0),
(0, 'Munda', 'Solomon Islands', 'Asia', 'BPXX0002', 0),
(0, 'Andong', 'South Korea', 'Asia', 'KSXX0001', 0),
(0, 'Anyang', 'South Korea', 'Asia', 'KSXX0002', 0),
(0, 'Ch`angwon', 'South Korea', 'Asia', 'KSXX0003', 0),
(0, 'Ch`onan', 'South Korea', 'Asia', 'KSXX0006', 0),
(0, 'Ch`ungju', 'South Korea', 'Asia', 'KSXX0007', 0),
(0, 'Cheju', 'South Korea', 'Asia', 'KSXX0004', 0),
(0, 'Cheju Upper/Radar', 'South Korea', 'Asia', 'KSXX0053', 0),
(0, 'Chinhae', 'South Korea', 'Asia', 'KSXX0005', 0),
(0, 'Chinju', 'South Korea', 'Asia', 'KSXX0055', 0),
(0, 'Cholwon', 'South Korea', 'Asia', 'KSXX0033', 0),
(0, 'Chonju', 'South Korea', 'Asia', 'KSXX0047', 0),
(0, 'Chunchon', 'South Korea', 'Asia', 'KSXX0035', 0),
(0, 'Chungju', 'South Korea', 'Asia', 'KSXX0057', 0),
(0, 'Chungmu', 'South Korea', 'Asia', 'KSXX0051', 0),
(0, 'Chupungnyong', 'South Korea', 'Asia', 'KSXX0044', 0),
(0, 'Haenam', 'South Korea', 'Asia', 'KSXX0008', 0),
(0, 'Inch`on', 'South Korea', 'Asia', 'KSXX0009', 0),
(0, 'Iri', 'South Korea', 'Asia', 'KSXX0010', 0),
(0, 'Kangnung', 'South Korea', 'Asia', 'KSXX0011', 0),
(0, 'Kimch`on', 'South Korea', 'Asia', 'KSXX0012', 0),
(0, 'Kunsan', 'South Korea', 'Asia', 'KSXX0046', 0),
(0, 'Kwangju', 'South Korea', 'Asia', 'KSXX0014', 0),
(0, 'Masan', 'South Korea', 'Asia', 'KSXX0048', 0),
(0, 'Miryang', 'South Korea', 'Asia', 'KSXX0016', 0),
(0, 'Mokp`o', 'South Korea', 'Asia', 'KSXX0017', 0),
(0, 'Osan', 'South Korea', 'Asia', 'KSXX0018', 0),
(0, 'P`ohang', 'South Korea', 'Asia', 'KSXX0019', 0),
(0, 'Pohang', 'South Korea', 'Asia', 'KSXX0045', 0),
(0, 'Polgyo', 'South Korea', 'Asia', 'KSXX0020', 0),
(0, 'Pusan', 'South Korea', 'Asia', 'KSXX0050', 0),
(0, 'Seoul', 'South Korea', 'Asia', 'KSXX0037', 0),
(0, 'Sogwipo', 'South Korea', 'Asia', 'KSXX0054', 0),
(0, 'Sokch`o', 'South Korea', 'Asia', 'KSXX0023', 0),
(0, 'Sokcho', 'South Korea', 'Asia', 'KSXX0032', 0),
(0, 'Songnam', 'South Korea', 'Asia', 'KSXX0024', 0),
(0, 'Sosan', 'South Korea', 'Asia', 'KSXX0042', 0),
(0, 'Suwon', 'South Korea', 'Asia', 'KSXX0025', 0),
(0, 'Taegu', 'South Korea', 'Asia', 'KSXX0026', 0),
(0, 'Taegwallyong', 'South Korea', 'Asia', 'KSXX0034', 0),
(0, 'Taejon', 'South Korea', 'Asia', 'KSXX0027', 0),
(0, 'Tonghae Radar Site', 'South Korea', 'Asia', 'KSXX0036', 0),
(0, 'Uisong', 'South Korea', 'Asia', 'KSXX0028', 0),
(0, 'Ulchin', 'South Korea', 'Asia', 'KSXX0043', 0),
(0, 'Ullungdo', 'South Korea', 'Asia', 'KSXX0039', 0),
(0, 'Ulsan', 'South Korea', 'Asia', 'KSXX0029', 0),
(0, 'Waegwan', 'South Korea', 'Asia', 'KSXX0030', 0),
(0, 'Wando', 'South Korea', 'Asia', 'KSXX0052', 0),
(0, 'Wonju', 'South Korea', 'Asia', 'KSXX0038', 0),
(0, 'Yangyang', 'South Korea', 'Asia', 'KSXX0056', 0),
(0, 'Yongwol', 'South Korea', 'Asia', 'KSXX0041', 0),
(0, 'Yosu', 'South Korea', 'Asia', 'KSXX0031', 0),
(0, 'Colombo', 'Sri Lanka', 'Asia', 'CEXX0001', 0),
(0, 'Katunayake', 'Sri Lanka', 'Asia', 'CEXX0005', 0),
(0, 'Moratuwa', 'Sri Lanka', 'Asia', 'CEXX0002', 0),
(0, 'Negombo', 'Sri Lanka', 'Asia', 'CEXX0003', 0),
(0, 'Sri Jayavardhanapura', 'Sri Lanka', 'Asia', 'CEXX0004', 0),
(0, 'Al Mismiyah', 'Syria', 'Asia', 'SYXX0001', 0),
(0, 'Al Qutayfah', 'Syria', 'Asia', 'SYXX0002', 0),
(0, 'Aleppo', 'Syria', 'Asia', 'SYXX0003', 0),
(0, 'Basel Assad International Airport', 'Syria', 'Asia', 'SYXX0014', 0),
(0, 'Damascus', 'Syria', 'Asia', 'SYXX0004', 0),
(0, 'Dara`A', 'Syria', 'Asia', 'SYXX0017', 0),
(0, 'Darayya', 'Syria', 'Asia', 'SYXX0005', 0),
(0, 'Deir Ezzor', 'Syria', 'Asia', 'SYXX0015', 0),
(0, 'Duma', 'Syria', 'Asia', 'SYXX0006', 0),
(0, 'Furqlus', 'Syria', 'Asia', 'SYXX0007', 0),
(0, 'Hims', 'Syria', 'Asia', 'SYXX0008', 0),
(0, 'Idlib', 'Syria', 'Asia', 'SYXX0009', 0),
(0, 'Kamishli', 'Syria', 'Asia', 'SYXX0013', 0),
(0, 'Manbij', 'Syria', 'Asia', 'SYXX0010', 0),
(0, 'Maskanah', 'Syria', 'Asia', 'SYXX0011', 0),
(0, 'Palmyra', 'Syria', 'Asia', 'SYXX0016', 0),
(0, 'Shinshar', 'Syria', 'Asia', 'SYXX0012', 0),
(0, 'Ch`i-shan', 'Taiwan', 'Asia', 'TWXX0005', 0),
(0, 'Chang-hua', 'Taiwan', 'Asia', 'TWXX0001', 0),
(0, 'Chi-lung', 'Taiwan', 'Asia', 'TWXX0003', 0),
(0, 'Chia-i', 'Taiwan', 'Asia', 'TWXX0002', 0),
(0, 'Chingmei', 'Taiwan', 'Asia', 'TWXX0004', 0),
(0, 'Chu-tung', 'Taiwan', 'Asia', 'TWXX0006', 0),
(0, 'Feng-yuan', 'Taiwan', 'Asia', 'TWXX0007', 0),
(0, 'Hengch`un', 'Taiwan', 'Asia', 'TWXX0008', 0),
(0, 'Hengchun', 'Taiwan', 'Asia', 'TWXX0027', 0),
(0, 'Hsin-chu', 'Taiwan', 'Asia', 'TWXX0009', 0),
(0, 'Hsin-tien', 'Taiwan', 'Asia', 'TWXX0010', 0),
(0, 'Hua-lien', 'Taiwan', 'Asia', 'TWXX0011', 0),
(0, 'Kangshan', 'Taiwan', 'Asia', 'TWXX0012', 0),
(0, 'Kao-hsiung', 'Taiwan', 'Asia', 'TWXX0013', 0),
(0, 'Miao-li', 'Taiwan', 'Asia', 'TWXX0014', 0),
(0, 'P`ing-tung', 'Taiwan', 'Asia', 'TWXX0015', 0),
(0, 'Su-ao', 'Taiwan', 'Asia', 'TWXX0016', 0),
(0, 'T`ai-chung', 'Taiwan', 'Asia', 'TWXX0019', 0),
(0, 'T`ai-nan', 'Taiwan', 'Asia', 'TWXX0020', 0),
(0, 'T`aipeihsien', 'Taiwan', 'Asia', 'TWXX0022', 0),
(0, 'T`aitung', 'Taiwan', 'Asia', 'TWXX0023', 0),
(0, 'T`ao-yuan', 'Taiwan', 'Asia', 'TWXX0025', 0),
(0, 'Ta-cho-shui', 'Taiwan', 'Asia', 'TWXX0017', 0),
(0, 'Ta-fan-lieh', 'Taiwan', 'Asia', 'TWXX0018', 0),
(0, 'Ta-wu', 'Taiwan', 'Asia', 'TWXX0026', 0),
(0, 'Taidong', 'Taiwan', 'Asia', 'TWXX0028', 0),
(0, 'Taipei', 'Taiwan', 'Asia', 'TWXX0021', 0),
(0, 'Tan-shui', 'Taiwan', 'Asia', 'TWXX0024', 0),
(0, 'Dushanbe', 'Tajikistan', 'Asia', 'TIXX0001', 0),
(0, 'Khudzhand', 'Tajikistan', 'Asia', 'TIXX0003', 0),
(0, 'Ordhonikidzeabad', 'Tajikistan', 'Asia', 'TIXX0002', 0),
(0, 'Ban Phai', 'Thailand', 'Asia', 'THXX0001', 0),
(0, 'Bangkok', 'Thailand', 'Asia', 'THXX0002', 0),
(0, 'Chaiyaphum', 'Thailand', 'Asia', 'THXX0038', 0),
(0, 'Chanthaburi', 'Thailand', 'Asia', 'THXX0044', 0),
(0, 'Chiang Mai', 'Thailand', 'Asia', 'THXX0003', 0),
(0, 'Chon Buri', 'Thailand', 'Asia', 'THXX0004', 0),
(0, 'Chum Phae', 'Thailand', 'Asia', 'THXX0005', 0),
(0, 'Hat Yai', 'Thailand', 'Asia', 'THXX0050', 0),
(0, 'Hua Hin', 'Thailand', 'Asia', 'THXX0006', 0),
(0, 'Kam Paeng Phet', 'Thailand', 'Asia', 'THXX0036', 0),
(0, 'Kanchanaburi', 'Thailand', 'Asia', 'THXX0043', 0),
(0, 'Khok Kloi', 'Thailand', 'Asia', 'THXX0007', 0),
(0, 'Khon Kaen', 'Thailand', 'Asia', 'THXX0008', 0),
(0, 'Ko Samui', 'Thailand', 'Asia', 'THXX0046', 0),
(0, 'Lampang', 'Thailand', 'Asia', 'THXX0009', 0),
(0, 'Lamphun', 'Thailand', 'Asia', 'THXX0010', 0),
(0, 'Loei', 'Thailand', 'Asia', 'THXX0033', 0),
(0, 'Lopburi', 'Thailand', 'Asia', 'THXX0053', 0),
(0, 'Mae Hong Son', 'Thailand', 'Asia', 'THXX0027', 0),
(0, 'Mae Rim', 'Thailand', 'Asia', 'THXX0011', 0),
(0, 'Mae Sariang', 'Thailand', 'Asia', 'THXX0029', 0),
(0, 'Mae Sot', 'Thailand', 'Asia', 'THXX0034', 0),
(0, 'Maha Sarakham', 'Thailand', 'Asia', 'THXX0012', 0),
(0, 'Mukdahan', 'Thailand', 'Asia', 'THXX0037', 0),
(0, 'Nakhon Pathom', 'Thailand', 'Asia', 'THXX0013', 0),
(0, 'Nakhon Ratchasima', 'Thailand', 'Asia', 'THXX0014', 0),
(0, 'Nakhon Si Thammarat', 'Thailand', 'Asia', 'THXX0048', 0),
(0, 'Nan', 'Thailand', 'Asia', 'THXX0031', 0),
(0, 'Narathiwat', 'Thailand', 'Asia', 'THXX0051', 0),
(0, 'Nong Khai', 'Thailand', 'Asia', 'THXX0032', 0),
(0, 'Nonthaburi', 'Thailand', 'Asia', 'THXX0054', 0),
(0, 'Pattaya', 'Thailand', 'Asia', 'THXX0015', 0),
(0, 'Phayao', 'Thailand', 'Asia', 'THXX0028', 0),
(0, 'Phetchaburi', 'Thailand', 'Asia', 'THXX0016', 0),
(0, 'Phitsanulok', 'Thailand', 'Asia', 'THXX0035', 0),
(0, 'Phra Nakhon Si Ayutthaya', 'Thailand', 'Asia', 'THXX0017', 0),
(0, 'Phuket', 'Thailand', 'Asia', 'THXX0018', 0),
(0, 'Prachin Buri', 'Thailand', 'Asia', 'THXX0042', 0),
(0, 'Prachuap Khirikhan', 'Thailand', 'Asia', 'THXX0045', 0),
(0, 'Roi Et', 'Thailand', 'Asia', 'THXX0019', 0),
(0, 'Sakhon Nakhon', 'Thailand', 'Asia', 'THXX0020', 0),
(0, 'Samut Prakan', 'Thailand', 'Asia', 'THXX0021', 0),
(0, 'Samut Sakhon', 'Thailand', 'Asia', 'THXX0022', 0),
(0, 'Saraphi', 'Thailand', 'Asia', 'THXX0023', 0),
(0, 'Songkhla', 'Thailand', 'Asia', 'THXX0049', 0),
(0, 'Suphan Buri', 'Thailand', 'Asia', 'THXX0041', 0),
(0, 'Surat Thani', 'Thailand', 'Asia', 'THXX0047', 0),
(0, 'Thai Muang', 'Thailand', 'Asia', 'THXX0024', 0),
(0, 'Thalang', 'Thailand', 'Asia', 'THXX0025', 0),
(0, 'Thong Pha Phum', 'Thailand', 'Asia', 'THXX0040', 0),
(0, 'Ubon Ratchathani', 'Thailand', 'Asia', 'THXX0039', 0),
(0, 'Udon Thani', 'Thailand', 'Asia', 'THXX0026', 0),
(0, 'Adana', 'Turkey', 'Asia', 'TUXX0061', 0),
(0, 'Adana/Incirlik', 'Turkey', 'Asia', 'TUXX0001', 0),
(0, 'Afyon', 'Turkey', 'Asia', 'TUXX0046', 0),
(0, 'Akhisar', 'Turkey', 'Asia', 'TUXX0044', 0),
(0, 'Alanya', 'Turkey', 'Asia', 'TUXX0080', 0),
(0, 'Anamur', 'Turkey', 'Asia', 'TUXX0066', 0),
(0, 'Ankara', 'Turkey', 'Asia', 'TUXX0002', 0),
(0, 'Ankara/Etimesgut', 'Turkey', 'Asia', 'TUXX0003', 0),
(0, 'Antalya', 'Turkey', 'Asia', 'TUXX0004', 0),
(0, 'Armutova', 'Turkey', 'Asia', 'TUXX0073', 0),
(0, 'Askale', 'Turkey', 'Asia', 'TUXX0005', 0),
(0, 'Aydin', 'Turkey', 'Asia', 'TUXX0051', 0),
(0, 'Ayvacik', 'Turkey', 'Asia', 'TUXX0071', 0),
(0, 'Bafra', 'Turkey', 'Asia', 'TUXX0006', 0),
(0, 'Balikesir', 'Turkey', 'Asia', 'TUXX0041', 0),
(0, 'Bandirma', 'Turkey', 'Asia', 'TUXX0038', 0),
(0, 'Bergama', 'Turkey', 'Asia', 'TUXX0074', 0),
(0, 'Bismil', 'Turkey', 'Asia', 'TUXX0007', 0),
(0, 'Bodrum', 'Turkey', 'Asia', 'TUXX0056', 0),
(0, 'Bolu', 'Turkey', 'Asia', 'TUXX0032', 0),
(0, 'Bucak', 'Turkey', 'Asia', 'TUXX0078', 0),
(0, 'Burhaniye', 'Turkey', 'Asia', 'TUXX0072', 0),
(0, 'Bursa', 'Turkey', 'Asia', 'TUXX0039', 0),
(0, 'Canakkale', 'Turkey', 'Asia', 'TUXX0037', 0),
(0, 'Cerkezmusellim', 'Turkey', 'Asia', 'TUXX0067', 0),
(0, 'Ceyhan', 'Turkey', 'Asia', 'TUXX0008', 0),
(0, 'Civril', 'Turkey', 'Asia', 'TUXX0076', 0),
(0, 'Corlu', 'Turkey', 'Asia', 'TUXX0083', 0),
(0, 'Corum', 'Turkey', 'Asia', 'TUXX0033', 0),
(0, 'Cubuk', 'Turkey', 'Asia', 'TUXX0009', 0),
(0, 'Dalaman', 'Turkey', 'Asia', 'TUXX0060', 0),
(0, 'Diyarbakir', 'Turkey', 'Asia', 'TUXX0010', 0),
(0, 'Edirne', 'Turkey', 'Asia', 'TUXX0030', 0),
(0, 'Elazig', 'Turkey', 'Asia', 'TUXX0049', 0),
(0, 'Elmadag', 'Turkey', 'Asia', 'TUXX0011', 0),
(0, 'Ergani', 'Turkey', 'Asia', 'TUXX0012', 0),
(0, 'Erzincan', 'Turkey', 'Asia', 'TUXX0035', 0),
(0, 'Erzurum', 'Turkey', 'Asia', 'TUXX0013', 0),
(0, 'Eskisehir', 'Turkey', 'Asia', 'TUXX0040', 0),
(0, 'Ezine', 'Turkey', 'Asia', 'TUXX0070', 0),
(0, 'Fethiye', 'Turkey', 'Asia', 'TUXX0081', 0),
(0, 'Finike', 'Turkey', 'Asia', 'TUXX0077', 0),
(0, 'Gaziantep', 'Turkey', 'Asia', 'TUXX0055', 0),
(0, 'Inegol', 'Turkey', 'Asia', 'TUXX0079', 0),
(0, 'Iskenderun', 'Turkey', 'Asia', 'TUXX0059', 0),
(0, 'Isparta', 'Turkey', 'Asia', 'TUXX0052', 0),
(0, 'Istanbul', 'Turkey', 'Asia', 'TUXX0014', 0),
(0, 'Izmir', 'Turkey', 'Asia', 'TUXX0015', 0),
(0, 'Izmir/Cumaovasi', 'Turkey', 'Asia', 'TUXX0016', 0),
(0, 'Izmit', 'Turkey', 'Asia', 'TUXX0017', 0),
(0, 'Kars', 'Turkey', 'Asia', 'TUXX0036', 0),
(0, 'Kartal', 'Turkey', 'Asia', 'TUXX0018', 0),
(0, 'Kayseri/Erkilet', 'Turkey', 'Asia', 'TUXX0047', 0),
(0, 'Kirikkale', 'Turkey', 'Asia', 'TUXX0019', 0),
(0, 'Kirsehir', 'Turkey', 'Asia', 'TUXX0042', 0),
(0, 'Konya', 'Turkey', 'Asia', 'TUXX0053', 0),
(0, 'Konya/Eregli', 'Turkey', 'Asia', 'TUXX0054', 0),
(0, 'Kusadasi', 'Turkey', 'Asia', 'TUXX0068', 0),
(0, 'Lapseki', 'Turkey', 'Asia', 'TUXX0069', 0),
(0, 'Malatya/Erhac', 'Turkey', 'Asia', 'TUXX0048', 0),
(0, 'Manavgat', 'Turkey', 'Asia', 'TUXX0020', 0),
(0, 'Merzifon', 'Turkey', 'Asia', 'TUXX0064', 0),
(0, 'Milas', 'Turkey', 'Asia', 'TUXX0075', 0),
(0, 'Mugla', 'Turkey', 'Asia', 'TUXX0057', 0),
(0, 'Mus', 'Turkey', 'Asia', 'TUXX0062', 0),
(0, 'Nevsehir', 'Turkey', 'Asia', 'TUXX0065', 0),
(0, 'Pamukkale', 'Turkey', 'Asia', 'TUXX0063', 0),
(0, 'Pasinler', 'Turkey', 'Asia', 'TUXX0021', 0),
(0, 'Sakarya', 'Turkey', 'Asia', 'TUXX0022', 0),
(0, 'Samsun', 'Turkey', 'Asia', 'TUXX0023', 0),
(0, 'Sariyer', 'Turkey', 'Asia', 'TUXX0024', 0),
(0, 'Siirt', 'Turkey', 'Asia', 'TUXX0050', 0),
(0, 'Silifke', 'Turkey', 'Asia', 'TUXX0058', 0),
(0, 'Sivas', 'Turkey', 'Asia', 'TUXX0034', 0),
(0, 'Tarsus', 'Turkey', 'Asia', 'TUXX0025', 0),
(0, 'Tekirdag', 'Turkey', 'Asia', 'TUXX0031', 0),
(0, 'Torbali', 'Turkey', 'Asia', 'TUXX0026', 0),
(0, 'Trabzon', 'Turkey', 'Asia', 'TUXX0029', 0),
(0, 'Tutuzlupinar', 'Turkey', 'Asia', 'TUXX0082', 0),
(0, 'Urla', 'Turkey', 'Asia', 'TUXX0027', 0),
(0, 'Usak', 'Turkey', 'Asia', 'TUXX0045', 0),
(0, 'Van', 'Turkey', 'Asia', 'TUXX0043', 0),
(0, 'Zonguldak', 'Turkey', 'Asia', 'TUXX0028', 0),
(0, 'Ashgabat Keshi', 'Turkmenistan', 'Asia', 'TXXX0018', 0),
(0, 'Ashkhabad', 'Turkmenistan', 'Asia', 'TXXX0001', 0),
(0, 'Bajramaly', 'Turkmenistan', 'Asia', 'TXXX0020', 0),
(0, 'Bakherden', 'Turkmenistan', 'Asia', 'TXXX0015', 0),
(0, 'Bami', 'Turkmenistan', 'Asia', 'TXXX0025', 0),
(0, 'Bezmein', 'Turkmenistan', 'Asia', 'TXXX0002', 0),
(0, 'Byrdalyk', 'Turkmenistan', 'Asia', 'TXXX0017', 0),
(0, 'Carsanga', 'Turkmenistan', 'Asia', 'TXXX0022', 0),
(0, 'Chardzhev', 'Turkmenistan', 'Asia', 'TXXX0012', 0),
(0, 'Darganata', 'Turkmenistan', 'Asia', 'TXXX0009', 0),
(0, 'Dashkhovuz', 'Turkmenistan', 'Asia', 'TXXX0007', 0),
(0, 'Ekezhe', 'Turkmenistan', 'Asia', 'TXXX0006', 0),
(0, 'Erbent', 'Turkmenistan', 'Asia', 'TXXX0011', 0),
(0, 'Esengyly', 'Turkmenistan', 'Asia', 'TXXX0013', 0),
(0, 'Gazandzhyk', 'Turkmenistan', 'Asia', 'TXXX0010', 0),
(0, 'Gyshgy', 'Turkmenistan', 'Asia', 'TXXX0024', 0),
(0, 'Gyzylarbat', 'Turkmenistan', 'Asia', 'TXXX0014', 0),
(0, 'Kara-Kala', 'Turkmenistan', 'Asia', 'TXXX0026', 0),
(0, 'Kerki', 'Turkmenistan', 'Asia', 'TXXX0021', 0),
(0, 'Nebit Dag', 'Turkmenistan', 'Asia', 'TXXX0027', 0),
(0, 'Saragt', 'Turkmenistan', 'Asia', 'TXXX0023', 0),
(0, 'Tarta', 'Turkmenistan', 'Asia', 'TXXX0003', 0),
(0, 'Tedzhen', 'Turkmenistan', 'Asia', 'TXXX0019', 0),
(0, 'Turkmenbashi', 'Turkmenistan', 'Asia', 'TXXX0008', 0),
(0, 'Turkmenbashy', 'Turkmenistan', 'Asia', 'TXXX0004', 0),
(0, 'Uchadzhi', 'Turkmenistan', 'Asia', 'TXXX0016', 0),
(0, 'Ufra', 'Turkmenistan', 'Asia', 'TXXX0005', 0),
(0, 'Abu Dhabi', 'United Arab Emirates', 'Asia', 'AEXX0001', 0),
(0, 'Ajman', 'United Arab Emirates', 'Asia', 'AEXX0002', 0),
(0, 'Ash Shariqah', 'United Arab Emirates', 'Asia', 'AEXX0003', 0),
(0, 'Dubai', 'United Arab Emirates', 'Asia', 'AEXX0004', 0),
(0, 'Fujairah', 'United Arab Emirates', 'Asia', 'AEXX0008', 0),
(0, 'Ras Al Khaimah', 'United Arab Emirates', 'Asia', 'AEXX0007', 0),
(0, 'Sharjah', 'United Arab Emirates', 'Asia', 'AEXX0005', 0),
(0, 'Umm al Qaywayn', 'United Arab Emirates', 'Asia', 'AEXX0006', 0),
(0, 'Ak-Bajtal', 'Uzbekistan', 'Asia', 'UZXX0006', 0),
(0, 'Almalyk', 'Uzbekistan', 'Asia', 'UZXX0001', 0),
(0, 'Buhara', 'Uzbekistan', 'Asia', 'UZXX0018', 0),
(0, 'Buzaubaj', 'Uzbekistan', 'Asia', 'UZXX0010', 0),
(0, 'Chimbaj', 'Uzbekistan', 'Asia', 'UZXX0007', 0),
(0, 'Dzizak', 'Uzbekistan', 'Asia', 'UZXX0014', 0),
(0, 'Fergana', 'Uzbekistan', 'Asia', 'UZXX0017', 0),
(0, 'Karshi', 'Uzbekistan', 'Asia', 'UZXX0019', 0),
(0, 'Kattakurgan', 'Uzbekistan', 'Asia', 'UZXX0002', 0),
(0, 'Kungrad', 'Uzbekistan', 'Asia', 'UZXX0005', 0),
(0, 'Namangan', 'Uzbekistan', 'Asia', 'UZXX0016', 0),
(0, 'Nukus', 'Uzbekistan', 'Asia', 'UZXX0008', 0),
(0, 'Nurata', 'Uzbekistan', 'Asia', 'UZXX0013', 0),
(0, 'Pskem', 'Uzbekistan', 'Asia', 'UZXX0012', 0),
(0, 'Samarkand', 'Uzbekistan', 'Asia', 'UZXX0003', 0),
(0, 'Syr-Dar`Ja', 'Uzbekistan', 'Asia', 'UZXX0015', 0),
(0, 'Tamdy', 'Uzbekistan', 'Asia', 'UZXX0011', 0),
(0, 'Tashkent', 'Uzbekistan', 'Asia', 'UZXX0004', 0),
(0, 'Termez', 'Uzbekistan', 'Asia', 'UZXX0020', 0),
(0, 'Urgench', 'Uzbekistan', 'Asia', 'UZXX0009', 0),
(0, 'Aneityum', 'Vanuatu', 'Asia', 'NHXX0004', 0),
(0, 'Bauerfield Efate', 'Vanuatu', 'Asia', 'NHXX0002', 0),
(0, 'Burtonfield Tanna', 'Vanuatu', 'Asia', 'NHXX0003', 0),
(0, 'Santo Island/Pekoa Airport', 'Vanuatu', 'Asia', 'NHXX0001', 0),
(0, 'An Nhon', 'Vietnam', 'Asia', 'VMXX0001', 0),
(0, 'Bac Giang', 'Vietnam', 'Asia', 'VMXX0002', 0),
(0, 'Bach Long Vi', 'Vietnam', 'Asia', 'VMXX0024', 0),
(0, 'Bien Hoa', 'Vietnam', 'Asia', 'VMXX0003', 0),
(0, 'Ca Mau', 'Vietnam', 'Asia', 'VMXX0031', 0),
(0, 'Can Tho', 'Vietnam', 'Asia', 'VMXX0004', 0),
(0, 'Cao Bang', 'Vietnam', 'Asia', 'VMXX0020', 0),
(0, 'Con Son', 'Vietnam', 'Asia', 'VMXX0033', 0),
(0, 'Da Nang', 'Vietnam', 'Asia', 'VMXX0028', 0),
(0, 'Dong Hoi', 'Vietnam', 'Asia', 'VMXX0027', 0),
(0, 'Haiphong', 'Vietnam', 'Asia', 'VMXX0005', 0),
(0, 'Hanoi', 'Vietnam', 'Asia', 'VMXX0006', 0),
(0, 'Ho Chi Minh City', 'Vietnam', 'Asia', 'VMXX0007', 0),
(0, 'Hoa Binh', 'Vietnam', 'Asia', 'VMXX0008', 0),
(0, 'Hue', 'Vietnam', 'Asia', 'VMXX0009', 0),
(0, 'Lang Son', 'Vietnam', 'Asia', 'VMXX0023', 0),
(0, 'Lao Cai', 'Vietnam', 'Asia', 'VMXX0019', 0),
(0, 'My Tho', 'Vietnam', 'Asia', 'VMXX0010', 0),
(0, 'Nam Dinh', 'Vietnam', 'Asia', 'VMXX0011', 0),
(0, 'Nha Trang', 'Vietnam', 'Asia', 'VMXX0029', 0),
(0, 'Phan Thiet', 'Vietnam', 'Asia', 'VMXX0012', 0),
(0, 'Phu Lien', 'Vietnam', 'Asia', 'VMXX0022', 0),
(0, 'Phu Quoc', 'Vietnam', 'Asia', 'VMXX0032', 0),
(0, 'Quy Nhon', 'Vietnam', 'Asia', 'VMXX0013', 0),
(0, 'Song Cau', 'Vietnam', 'Asia', 'VMXX0014', 0),
(0, 'Song Tu Tay South West Cay', 'Vietnam', 'Asia', 'VMXX0030', 0),
(0, 'Thai Nguyen', 'Vietnam', 'Asia', 'VMXX0015', 0),
(0, 'Thanh Hoa', 'Vietnam', 'Asia', 'VMXX0025', 0),
(0, 'Truong Sa', 'Vietnam', 'Asia', 'VMXX0034', 0),
(0, 'Tuy Hoa', 'Vietnam', 'Asia', 'VMXX0016', 0),
(0, 'Viet Tri', 'Vietnam', 'Asia', 'VMXX0017', 0),
(0, 'Vinh', 'Vietnam', 'Asia', 'VMXX0026', 0),
(0, 'Vung Tau', 'Vietnam', 'Asia', 'VMXX0018', 0),
(0, 'Bethlehem', 'West Bank', 'Asia', 'WEXX0001', 0),
(0, 'Hebron', 'West Bank', 'Asia', 'WEXX0002', 0),
(0, 'Nabulus', 'West Bank', 'Asia', 'WEXX0003', 0),
(0, 'Qalandiyah', 'West Bank', 'Asia', 'WEXX0004', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Ramallah', 'West Bank', 'Asia', 'WEXX0005', 0),
(0, 'Aden', 'Yemen', 'Asia', 'YMXX0001', 0),
(0, 'Al Ghaydan', 'Yemen', 'Asia', 'YMXX0011', 0),
(0, 'Al Hudaydah', 'Yemen', 'Asia', 'YMXX0002', 0),
(0, 'Al Mukalla', 'Yemen', 'Asia', 'YMXX0014', 0),
(0, 'Ash Shaykh Uthman', 'Yemen', 'Asia', 'YMXX0003', 0),
(0, 'Ghayl Ba Wazir', 'Yemen', 'Asia', 'YMXX0013', 0),
(0, 'Lahij', 'Yemen', 'Asia', 'YMXX0004', 0),
(0, 'Mamoudzou', 'Yemen', 'Asia', 'YMXX0007', 0),
(0, 'Mukayris', 'Yemen', 'Asia', 'YMXX0010', 0),
(0, 'Qashlu', 'Yemen', 'Asia', 'YMXX0015', 0),
(0, 'Sanaa', 'Yemen', 'Asia', 'YMXX0005', 0),
(0, 'Shaqra`', 'Yemen', 'Asia', 'YMXX0008', 0),
(0, 'Taizz', 'Yemen', 'Asia', 'YMXX0006', 0),
(0, 'Tarim', 'Yemen', 'Asia', 'YMXX0012', 0),
(0, 'Male', 'Maldives', 'Asia', 'MVXX0001', 0),
(0, 'Cocos Island Airport', 'Christmas Island', 'Asia', 'KTXX0002', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Abrolhos Island North Island', 'Australia', 'Australia', 'ASXX0200', 0),
(0, 'Adamsons Peak', 'Australia', 'Australia', 'ASXX0327', 0),
(0, 'Adelaide', 'Australia', 'Australia', 'ASXX0001', 0),
(0, 'Adele Island', 'Australia', 'Australia', 'ASXX0148', 0),
(0, 'Aireys Inlet', 'Australia', 'Australia', 'ASXX0292', 0),
(0, 'Albany', 'Australia', 'Australia', 'ASXX0413', 0),
(0, 'Albury Aeroport', 'Australia', 'Australia', 'ASXX0364', 0),
(0, 'Alexandra', 'Australia', 'Australia', 'ASXX0387', 0),
(0, 'Ali Curung Tennant Creek', 'Australia', 'Australia', 'ASXX0176', 0),
(0, 'Alice Springs', 'Australia', 'Australia', 'ASXX0002', 0),
(0, 'Amberley Aerodrome', 'Australia', 'Australia', 'ASXX0218', 0),
(0, 'Ararat', 'Australia', 'Australia', 'ASXX0288', 0),
(0, 'Archerfield Aerodrome', 'Australia', 'Australia', 'ASXX0220', 0),
(0, 'Armadale', 'Australia', 'Australia', 'ASXX0003', 0),
(0, 'Augusta', 'Australia', 'Australia', 'ASXX0404', 0),
(0, 'Avalon', 'Australia', 'Australia', 'ASXX0294', 0),
(0, 'Avon Downs', 'Australia', 'Australia', 'ASXX0004', 0),
(0, 'Ayers Rock', 'Australia', 'Australia', 'ASXX0005', 0),
(0, 'Ayr', 'Australia', 'Australia', 'ASXX0006', 0),
(0, 'Babinda', 'Australia', 'Australia', 'ASXX0007', 0),
(0, 'Badgingarra', 'Australia', 'Australia', 'ASXX0424', 0),
(0, 'Bajool', 'Australia', 'Australia', 'ASXX0008', 0),
(0, 'Balladonia', 'Australia', 'Australia', 'ASXX0239', 0),
(0, 'Ballarat', 'Australia', 'Australia', 'ASXX0293', 0),
(0, 'Ballina Airport', 'Australia', 'Australia', 'ASXX0224', 0),
(0, 'Bankstown', 'Australia', 'Australia', 'ASXX0009', 0),
(0, 'Bankstown Airport', 'Australia', 'Australia', 'ASXX0273', 0),
(0, 'Batchelor', 'Australia', 'Australia', 'ASXX0010', 0),
(0, 'Bathurst', 'Australia', 'Australia', 'ASXX0411', 0),
(0, 'Bathurst Island Cape Fourcroy', 'Australia', 'Australia', 'ASXX0385', 0),
(0, 'Beenleigh', 'Australia', 'Australia', 'ASXX0011', 0),
(0, 'Bega', 'Australia', 'Australia', 'ASXX0368', 0),
(0, 'Benalla', 'Australia', 'Australia', 'ASXX0307', 0),
(0, 'Bendigo Airport', 'Australia', 'Australia', 'ASXX0295', 0),
(0, 'Biloela Thangool Airport', 'Australia', 'Australia', 'ASXX0189', 0),
(0, 'Birdsville', 'Australia', 'Australia', 'ASXX0206', 0),
(0, 'Birdum', 'Australia', 'Australia', 'ASXX0012', 0),
(0, 'Black Point Port Essington', 'Australia', 'Australia', 'ASXX0134', 0),
(0, 'Blackall', 'Australia', 'Australia', 'ASXX0182', 0),
(0, 'Blacktown', 'Australia', 'Australia', 'ASXX0013', 0),
(0, 'Bombala', 'Australia', 'Australia', 'ASXX0320', 0),
(0, 'Boologooro', 'Australia', 'Australia', 'ASXX0014', 0),
(0, 'Bougainville Reef', 'Australia', 'Australia', 'ASXX0339', 0),
(0, 'Boulia', 'Australia', 'Australia', 'ASXX0180', 0),
(0, 'Bourke', 'Australia', 'Australia', 'ASXX0407', 0),
(0, 'Bowen', 'Australia', 'Australia', 'ASXX0015', 0),
(0, 'Bowen Airport', 'Australia', 'Australia', 'ASXX0184', 0),
(0, 'Bowral', 'Australia', 'Australia', 'ASXX0270', 0),
(0, 'Braidwood', 'Australia', 'Australia', 'ASXX0319', 0),
(0, 'Brisbane', 'Australia', 'Australia', 'ASXX0016', 0),
(0, 'Broad Arrow', 'Australia', 'Australia', 'ASXX0017', 0),
(0, 'Broadmeadows', 'Australia', 'Australia', 'ASXX0018', 0),
(0, 'Broken Hill Patton Street', 'Australia', 'Australia', 'ASXX0255', 0),
(0, 'Broome', 'Australia', 'Australia', 'ASXX0019', 0),
(0, 'Brunette Downs', 'Australia', 'Australia', 'ASXX0153', 0),
(0, 'Bryon Bay', 'Australia', 'Australia', 'ASXX0430', 0),
(0, 'Bullsbrook Pearce Amo', 'Australia', 'Australia', 'ASXX0232', 0),
(0, 'Bunbury', 'Australia', 'Australia', 'ASXX0228', 0),
(0, 'Bundaberg Aerodrome', 'Australia', 'Australia', 'ASXX0194', 0),
(0, 'Burketown', 'Australia', 'Australia', 'ASXX0157', 0),
(0, 'Bushy Park', 'Australia', 'Australia', 'ASXX0329', 0),
(0, 'Busselton', 'Australia', 'Australia', 'ASXX0426', 0),
(0, 'Cairns', 'Australia', 'Australia', 'ASXX0020', 0),
(0, 'Caloundra', 'Australia', 'Australia', 'ASXX0021', 0),
(0, 'Camooweal', 'Australia', 'Australia', 'ASXX0155', 0),
(0, 'Campbelltown', 'Australia', 'Australia', 'ASXX0022', 0),
(0, 'Canberra', 'Australia', 'Australia', 'ASXX0023', 0),
(0, 'Cape Borda', 'Australia', 'Australia', 'ASXX0277', 0),
(0, 'Cape Bruny', 'Australia', 'Australia', 'ASXX0330', 0),
(0, 'Cape Don', 'Australia', 'Australia', 'ASXX0131', 0),
(0, 'Cape Jaffa', 'Australia', 'Australia', 'ASXX0280', 0),
(0, 'Cape Moreton', 'Australia', 'Australia', 'ASXX0223', 0),
(0, 'Cape Naturaliste', 'Australia', 'Australia', 'ASXX0225', 0),
(0, 'Cape Nelson', 'Australia', 'Australia', 'ASXX0284', 0),
(0, 'Cape Sorell', 'Australia', 'Australia', 'ASXX0333', 0),
(0, 'Cape Willoughby', 'Australia', 'Australia', 'ASXX0283', 0),
(0, 'Carnarvon', 'Australia', 'Australia', 'ASXX0024', 0),
(0, 'Cato Island', 'Australia', 'Australia', 'ASXX0197', 0),
(0, 'Centre Island', 'Australia', 'Australia', 'ASXX0154', 0),
(0, 'Cerberus', 'Australia', 'Australia', 'ASXX0313', 0),
(0, 'Channel Point', 'Australia', 'Australia', 'ASXX0384', 0),
(0, 'Charleyville', 'Australia', 'Australia', 'ASXX0375', 0),
(0, 'Clare High School', 'Australia', 'Australia', 'ASXX0352', 0),
(0, 'Cloncurry', 'Australia', 'Australia', 'ASXX0025', 0),
(0, 'Cobar Airport', 'Australia', 'Australia', 'ASXX0262', 0),
(0, 'Coconut Island', 'Australia', 'Australia', 'ASXX0143', 0),
(0, 'Coen Airport', 'Australia', 'Australia', 'ASXX0144', 0),
(0, 'Coffs Harbour', 'Australia', 'Australia', 'ASXX0026', 0),
(0, 'Coldstream', 'Australia', 'Australia', 'ASXX0300', 0),
(0, 'Coles Point', 'Australia', 'Australia', 'ASXX0243', 0),
(0, 'Combienbar', 'Australia', 'Australia', 'ASXX0317', 0),
(0, 'Condobolin Airport', 'Australia', 'Australia', 'ASXX0356', 0),
(0, 'Coober Pedy', 'Australia', 'Australia', 'ASXX0408', 0),
(0, 'Cooktown', 'Australia', 'Australia', 'ASXX0027', 0),
(0, 'Coolangatta Airport', 'Australia', 'Australia', 'ASXX0222', 0),
(0, 'Coolgardie', 'Australia', 'Australia', 'ASXX0028', 0),
(0, 'Cooma Airport', 'Australia', 'Australia', 'ASXX0318', 0),
(0, 'Coonabarabran Namoi Street', 'Australia', 'Australia', 'ASXX0267', 0),
(0, 'Corrigin', 'Australia', 'Australia', 'ASXX0236', 0),
(0, 'Crackenback', 'Australia', 'Australia', 'ASXX0366', 0),
(0, 'Creal Reef', 'Australia', 'Australia', 'ASXX0187', 0),
(0, 'Cunnamulla', 'Australia', 'Australia', 'ASXX0210', 0),
(0, 'Currie', 'Australia', 'Australia', 'ASXX0394', 0),
(0, 'Curtin', 'Australia', 'Australia', 'ASXX0146', 0),
(0, 'Cygnet Bay', 'Australia', 'Australia', 'ASXX0145', 0),
(0, 'Cygnet River Kingstone Aerodrome', 'Australia', 'Australia', 'ASXX0362', 0),
(0, 'Dalby Airport', 'Australia', 'Australia', 'ASXX0213', 0),
(0, 'Daly Waters', 'Australia', 'Australia', 'ASXX0029', 0),
(0, 'Dampier', 'Australia', 'Australia', 'ASXX0030', 0),
(0, 'Dandenong', 'Australia', 'Australia', 'ASXX0031', 0),
(0, 'Darwin', 'Australia', 'Australia', 'ASXX0032', 0),
(0, 'Denham', 'Australia', 'Australia', 'ASXX0033', 0),
(0, 'Derby', 'Australia', 'Australia', 'ASXX0034', 0),
(0, 'Devonport Airport', 'Australia', 'Australia', 'ASXX0370', 0),
(0, 'Dongara', 'Australia', 'Australia', 'ASXX0035', 0),
(0, 'Dubbo', 'Australia', 'Australia', 'ASXX0265', 0),
(0, 'Dunns Hill', 'Australia', 'Australia', 'ASXX0303', 0),
(0, 'Dwellingup', 'Australia', 'Australia', 'ASXX0235', 0),
(0, 'Edinburgh M. O.', 'Australia', 'Australia', 'ASXX0353', 0),
(0, 'Edithburgh', 'Australia', 'Australia', 'ASXX0278', 0),
(0, 'Edmonton', 'Australia', 'Australia', 'ASXX0036', 0),
(0, 'Elcho Island', 'Australia', 'Australia', 'ASXX0140', 0),
(0, 'Elizabeth', 'Australia', 'Australia', 'ASXX0037', 0),
(0, 'Elliston Post Office', 'Australia', 'Australia', 'ASXX0241', 0),
(0, 'Emerald', 'Australia', 'Australia', 'ASXX0388', 0),
(0, 'Esperance', 'Australia', 'Australia', 'ASXX0038', 0),
(0, 'Esperance Aerodrome', 'Australia', 'Australia', 'ASXX0349', 0),
(0, 'Eucla Motel', 'Australia', 'Australia', 'ASXX0396', 0),
(0, 'Eudunda', 'Australia', 'Australia', 'ASXX0250', 0),
(0, 'Fairfield', 'Australia', 'Australia', 'ASXX0039', 0),
(0, 'Falls Creek', 'Australia', 'Australia', 'ASXX0314', 0),
(0, 'Finley', 'Australia', 'Australia', 'ASXX0305', 0),
(0, 'Flinders Island Airport', 'Australia', 'Australia', 'ASXX0335', 0),
(0, 'Flinders Reef', 'Australia', 'Australia', 'ASXX0163', 0),
(0, 'Forbes', 'Australia', 'Australia', 'ASXX0425', 0),
(0, 'Forrest', 'Australia', 'Australia', 'ASXX0376', 0),
(0, 'Frankston', 'Australia', 'Australia', 'ASXX0040', 0),
(0, 'Fremantle', 'Australia', 'Australia', 'ASXX0041', 0),
(0, 'Gabo Island', 'Australia', 'Australia', 'ASXX0321', 0),
(0, 'Gannet Cay', 'Australia', 'Australia', 'ASXX0190', 0),
(0, 'Garden Point', 'Australia', 'Australia', 'ASXX0383', 0),
(0, 'Gawler', 'Australia', 'Australia', 'ASXX0042', 0),
(0, 'Gayndah', 'Australia', 'Australia', 'ASXX0214', 0),
(0, 'Geelong', 'Australia', 'Australia', 'ASXX0043', 0),
(0, 'Geelong Airport', 'Australia', 'Australia', 'ASXX0296', 0),
(0, 'Gelantipy', 'Australia', 'Australia', 'ASXX0316', 0),
(0, 'Georgetown', 'Australia', 'Australia', 'ASXX0159', 0),
(0, 'Geraldton', 'Australia', 'Australia', 'ASXX0044', 0),
(0, 'Gibson', 'Australia', 'Australia', 'ASXX0045', 0),
(0, 'Gladstone', 'Australia', 'Australia', 'ASXX0046', 0),
(0, 'Gladstone Airport', 'Australia', 'Australia', 'ASXX0191', 0),
(0, 'Gold Coast', 'Australia', 'Australia', 'ASXX0047', 0),
(0, 'Gold Coast Seaway', 'Australia', 'Australia', 'ASXX0221', 0),
(0, 'Goldsworthy', 'Australia', 'Australia', 'ASXX0048', 0),
(0, 'Goondiwindi Airport', 'Australia', 'Australia', 'ASXX0212', 0),
(0, 'Gosford', 'Australia', 'Australia', 'ASXX0049', 0),
(0, 'Gosnells', 'Australia', 'Australia', 'ASXX0050', 0),
(0, 'Goulburn', 'Australia', 'Australia', 'ASXX0051', 0),
(0, 'Goulburn Airport', 'Australia', 'Australia', 'ASXX0358', 0),
(0, 'Granite Downs', 'Australia', 'Australia', 'ASXX0053', 0),
(0, 'Green Cape', 'Australia', 'Australia', 'ASXX0322', 0),
(0, 'Green Island', 'Australia', 'Australia', 'ASXX0340', 0),
(0, 'Greenough', 'Australia', 'Australia', 'ASXX0054', 0),
(0, 'Griffith', 'Australia', 'Australia', 'ASXX0260', 0),
(0, 'Gunnedah', 'Australia', 'Australia', 'ASXX0055', 0),
(0, 'Hall', 'Australia', 'Australia', 'ASXX0056', 0),
(0, 'Halls Creek', 'Australia', 'Australia', 'ASXX0402', 0),
(0, 'Hamilton Airport', 'Australia', 'Australia', 'ASXX0286', 0),
(0, 'Hamilton Island', 'Australia', 'Australia', 'ASXX0185', 0),
(0, 'Hay', 'Australia', 'Australia', 'ASXX0259', 0),
(0, 'Hay Miller Street', 'Australia', 'Australia', 'ASXX0257', 0),
(0, 'Heron Island', 'Australia', 'Australia', 'ASXX0193', 0),
(0, 'Hillston Airport', 'Australia', 'Australia', 'ASXX0258', 0),
(0, 'Hobart', 'Australia', 'Australia', 'ASXX0057', 0),
(0, 'Hobart Regional Office', 'Australia', 'Australia', 'ASXX0332', 0),
(0, 'Holmes Reef', 'Australia', 'Australia', 'ASXX0162', 0),
(0, 'Hopetoun', 'Australia', 'Australia', 'ASXX0058', 0),
(0, 'Hordern Vale', 'Australia', 'Australia', 'ASXX0418', 0),
(0, 'Horn Island', 'Australia', 'Australia', 'ASXX0142', 0),
(0, 'Horsham', 'Australia', 'Australia', 'ASXX0416', 0),
(0, 'Hunters Hill', 'Australia', 'Australia', 'ASXX0306', 0),
(0, 'Ingham', 'Australia', 'Australia', 'ASXX0059', 0),
(0, 'Ingham Composite', 'Australia', 'Australia', 'ASXX0341', 0),
(0, 'Injune Post Office', 'Australia', 'Australia', 'ASXX0211', 0),
(0, 'Innisfail', 'Australia', 'Australia', 'ASXX0060', 0),
(0, 'Ipswich', 'Australia', 'Australia', 'ASXX0061', 0),
(0, 'Ivanhoe Post Office', 'Australia', 'Australia', 'ASXX0256', 0),
(0, 'Jabiru Airport', 'Australia', 'Australia', 'ASXX0136', 0),
(0, 'Jerramungup Jacup', 'Australia', 'Australia', 'ASXX0348', 0),
(0, 'Jervis Bay', 'Australia', 'Australia', 'ASXX0325', 0),
(0, 'Jervois', 'Australia', 'Australia', 'ASXX0177', 0),
(0, 'Jimna', 'Australia', 'Australia', 'ASXX0421', 0),
(0, 'Jurien', 'Australia', 'Australia', 'ASXX0345', 0),
(0, 'Kalamunda', 'Australia', 'Australia', 'ASXX0234', 0),
(0, 'Kalbarri', 'Australia', 'Australia', 'ASXX0062', 0),
(0, 'Kalgoorlie', 'Australia', 'Australia', 'ASXX0063', 0),
(0, 'Kambalda/Lake Lefroy', 'Australia', 'Australia', 'ASXX0064', 0),
(0, 'Karratha Aerodrome', 'Australia', 'Australia', 'ASXX0342', 0),
(0, 'Karratha King Bay', 'Australia', 'Australia', 'ASXX0343', 0),
(0, 'Karratha Legendre Isalnd', 'Australia', 'Australia', 'ASXX0168', 0),
(0, 'Katherine Aerodrome', 'Australia', 'Australia', 'ASXX0133', 0),
(0, 'Katoomba', 'Australia', 'Australia', 'ASXX0269', 0),
(0, 'Keilor', 'Australia', 'Australia', 'ASXX0065', 0),
(0, 'Keith Post Office', 'Australia', 'Australia', 'ASXX0281', 0),
(0, 'Kilmore Gap', 'Australia', 'Australia', 'ASXX0298', 0),
(0, 'Kimberley Downs', 'Australia', 'Australia', 'ASXX0066', 0),
(0, 'Kingaroy', 'Australia', 'Australia', 'ASXX0215', 0),
(0, 'Kingston', 'Australia', 'Australia', 'ASXX0067', 0),
(0, 'Kollan Island', 'Australia', 'Australia', 'ASXX0391', 0),
(0, 'Kulgera', 'Australia', 'Australia', 'ASXX0202', 0),
(0, 'Kununurra', 'Australia', 'Australia', 'ASXX0397', 0),
(0, 'Kununurra Argyle Aerodrome', 'Australia', 'Australia', 'ASXX0150', 0),
(0, 'Kwinana', 'Australia', 'Australia', 'ASXX0068', 0),
(0, 'Kyancutta', 'Australia', 'Australia', 'ASXX0242', 0),
(0, 'Lady Elliot Island', 'Australia', 'Australia', 'ASXX0195', 0),
(0, 'Lake Grace', 'Australia', 'Australia', 'ASXX0237', 0),
(0, 'Lakes Entrance Composite', 'Australia', 'Australia', 'ASXX0365', 0),
(0, 'Lameroo', 'Australia', 'Australia', 'ASXX0254', 0),
(0, 'Lancelin', 'Australia', 'Australia', 'ASXX0346', 0),
(0, 'Larrimah', 'Australia', 'Australia', 'ASXX0069', 0),
(0, 'Latrobe Valley Airport', 'Australia', 'Australia', 'ASXX0309', 0),
(0, 'Launceston', 'Australia', 'Australia', 'ASXX0331', 0),
(0, 'Laverton', 'Australia', 'Australia', 'ASXX0405', 0),
(0, 'Learmonth', 'Australia', 'Australia', 'ASXX0381', 0),
(0, 'Leigh Creek Airport', 'Australia', 'Australia', 'ASXX0247', 0),
(0, 'Leonora', 'Australia', 'Australia', 'ASXX0201', 0),
(0, 'Longreach', 'Australia', 'Australia', 'ASXX0423', 0),
(0, 'Lookout Hill', 'Australia', 'Australia', 'ASXX0289', 0),
(0, 'Low Isles', 'Australia', 'Australia', 'ASXX0160', 0),
(0, 'Low Rocky Point', 'Australia', 'Australia', 'ASXX0371', 0),
(0, 'Loxton', 'Australia', 'Australia', 'ASXX0252', 0),
(0, 'Lucinda Point', 'Australia', 'Australia', 'ASXX0164', 0),
(0, 'Maatsuyker Island', 'Australia', 'Australia', 'ASXX0328', 0),
(0, 'Mackay', 'Australia', 'Australia', 'ASXX0070', 0),
(0, 'Macquarie Island', 'Australia', 'Australia', 'ASXX0337', 0),
(0, 'Maitland', 'Australia', 'Australia', 'ASXX0246', 0),
(0, 'Mandurah', 'Australia', 'Australia', 'ASXX0071', 0),
(0, 'Mangalore Airport', 'Australia', 'Australia', 'ASXX0304', 0),
(0, 'Maningrida', 'Australia', 'Australia', 'ASXX0139', 0),
(0, 'Marble Bar', 'Australia', 'Australia', 'ASXX0173', 0),
(0, 'Mareeba Airport', 'Australia', 'Australia', 'ASXX0161', 0),
(0, 'Marion', 'Australia', 'Australia', 'ASXX0072', 0),
(0, 'Marion Reef', 'Australia', 'Australia', 'ASXX0165', 0),
(0, 'Marla', 'Australia', 'Australia', 'ASXX0204', 0),
(0, 'Maroochydore Airport', 'Australia', 'Australia', 'ASXX0219', 0),
(0, 'Marree', 'Australia', 'Australia', 'ASXX0205', 0),
(0, 'Mary Kathleen', 'Australia', 'Australia', 'ASXX0073', 0),
(0, 'Maryborough', 'Australia', 'Australia', 'ASXX0217', 0),
(0, 'Mataranka', 'Australia', 'Australia', 'ASXX0074', 0),
(0, 'Mccluer Island', 'Australia', 'Australia', 'ASXX0135', 0),
(0, 'Meekatharra', 'Australia', 'Australia', 'ASXX0400', 0),
(0, 'Melbourne', 'Australia', 'Australia', 'ASXX0075', 0),
(0, 'Melbourne Airport', 'Australia', 'Australia', 'ASXX0301', 0),
(0, 'Merbein', 'Australia', 'Australia', 'ASXX0076', 0),
(0, 'Mettler', 'Australia', 'Australia', 'ASXX0347', 0),
(0, 'Mildura', 'Australia', 'Australia', 'ASXX0077', 0),
(0, 'Milingimbi', 'Australia', 'Australia', 'ASXX0138', 0),
(0, 'Moorabbin Airport', 'Australia', 'Australia', 'ASXX0302', 0),
(0, 'Moree', 'Australia', 'Australia', 'ASXX0390', 0),
(0, 'Mortlake', 'Australia', 'Australia', 'ASXX0290', 0),
(0, 'Moruya Heads', 'Australia', 'Australia', 'ASXX0323', 0),
(0, 'Mount Boyce', 'Australia', 'Australia', 'ASXX0268', 0),
(0, 'Mount Buller', 'Australia', 'Australia', 'ASXX0312', 0),
(0, 'Mount Gambier', 'Australia', 'Australia', 'ASXX0078', 0),
(0, 'Mount Hotham', 'Australia', 'Australia', 'ASXX0315', 0),
(0, 'Mount Isa', 'Australia', 'Australia', 'ASXX0079', 0),
(0, 'Mount Lawley Perth Metro', 'Australia', 'Australia', 'ASXX0230', 0),
(0, 'Mount Lofty', 'Australia', 'Australia', 'ASXX0355', 0),
(0, 'Mount Magnet', 'Australia', 'Australia', 'ASXX0401', 0),
(0, 'Mount Moornapa', 'Australia', 'Australia', 'ASXX0367', 0),
(0, 'Mount Morgan', 'Australia', 'Australia', 'ASXX0080', 0),
(0, 'Mount Wellington', 'Australia', 'Australia', 'ASXX0372', 0),
(0, 'Mudgee', 'Australia', 'Australia', 'ASXX0266', 0),
(0, 'Murrurundi', 'Australia', 'Australia', 'ASXX0272', 0),
(0, 'Nambour', 'Australia', 'Australia', 'ASXX0344', 0),
(0, 'Nambucca Heads', 'Australia', 'Australia', 'ASXX0081', 0),
(0, 'Naracoorte', 'Australia', 'Australia', 'ASXX0282', 0),
(0, 'New Norfolk', 'Australia', 'Australia', 'ASXX0082', 0),
(0, 'Newcastle', 'Australia', 'Australia', 'ASXX0083', 0),
(0, 'Newman', 'Australia', 'Australia', 'ASXX0399', 0),
(0, 'Noonamah', 'Australia', 'Australia', 'ASXX0085', 0),
(0, 'Norah Head Lighthouse', 'Australia', 'Australia', 'ASXX0361', 0),
(0, 'Norfolk Island Airport', 'Australia', 'Australia', 'ASXX0336', 0),
(0, 'Normanton', 'Australia', 'Australia', 'ASXX0158', 0),
(0, 'Norseman', 'Australia', 'Australia', 'ASXX0238', 0),
(0, 'North East Island', 'Australia', 'Australia', 'ASXX0141', 0),
(0, 'Nowra', 'Australia', 'Australia', 'ASXX0428', 0),
(0, 'Nullarbor', 'Australia', 'Australia', 'ASXX0412', 0),
(0, 'Nullo Mountains', 'Australia', 'Australia', 'ASXX0271', 0),
(0, 'Nuriootpa', 'Australia', 'Australia', 'ASXX0251', 0),
(0, 'Nyngan', 'Australia', 'Australia', 'ASXX0261', 0),
(0, 'Oakey', 'Australia', 'Australia', 'ASXX0422', 0),
(0, 'Onslow', 'Australia', 'Australia', 'ASXX0167', 0),
(0, 'Oodnadatta Airport', 'Australia', 'Australia', 'ASXX0203', 0),
(0, 'Paddington', 'Australia', 'Australia', 'ASXX0086', 0),
(0, 'Palmers Lookout', 'Australia', 'Australia', 'ASXX0334', 0),
(0, 'Parafield Airport', 'Australia', 'Australia', 'ASXX0354', 0),
(0, 'Parawa Second Valley Forest', 'Australia', 'Australia', 'ASXX0279', 0),
(0, 'Parramatta', 'Australia', 'Australia', 'ASXX0087', 0),
(0, 'Paynes Find', 'Australia', 'Australia', 'ASXX0199', 0),
(0, 'Penrith', 'Australia', 'Australia', 'ASXX0088', 0),
(0, 'Perth', 'Australia', 'Australia', 'ASXX0089', 0),
(0, 'Point Stuart', 'Australia', 'Australia', 'ASXX0130', 0),
(0, 'Port Adelaide', 'Australia', 'Australia', 'ASXX0090', 0),
(0, 'Port Arthur/Tasman Peninsula', 'Australia', 'Australia', 'ASXX0091', 0),
(0, 'Port Augusta West', 'Australia', 'Australia', 'ASXX0409', 0),
(0, 'Port Hedland', 'Australia', 'Australia', 'ASXX0092', 0),
(0, 'Port Hedland Bedout Island', 'Australia', 'Australia', 'ASXX0170', 0),
(0, 'Port Hedland Pardoo', 'Australia', 'Australia', 'ASXX0171', 0),
(0, 'Port Lincoln', 'Australia', 'Australia', 'ASXX0244', 0),
(0, 'Port Lincoln Aerodrome', 'Australia', 'Australia', 'ASXX0350', 0),
(0, 'Port Macquarie', 'Australia', 'Australia', 'ASXX0093', 0),
(0, 'Port Phillip Bay', 'Australia', 'Australia', 'ASXX0094', 0),
(0, 'Portland Airport', 'Australia', 'Australia', 'ASXX0285', 0),
(0, 'Proserpine Airport', 'Australia', 'Australia', 'ASXX0183', 0),
(0, 'Queanbeyan', 'Australia', 'Australia', 'ASXX0095', 0),
(0, 'Quilpie', 'Australia', 'Australia', 'ASXX0209', 0),
(0, 'Rapid Bay', 'Australia', 'Australia', 'ASXX0096', 0),
(0, 'Red Cliffs', 'Australia', 'Australia', 'ASXX0097', 0),
(0, 'Redcliffe', 'Australia', 'Australia', 'ASXX0098', 0),
(0, 'Redesdale', 'Australia', 'Australia', 'ASXX0297', 0),
(0, 'Renmark', 'Australia', 'Australia', 'ASXX0253', 0),
(0, 'Rhyll', 'Australia', 'Australia', 'ASXX0310', 0),
(0, 'Richmond', 'Australia', 'Australia', 'ASXX0099', 0),
(0, 'Richmond Amo', 'Australia', 'Australia', 'ASXX0359', 0),
(0, 'Rockhampton', 'Australia', 'Australia', 'ASXX0100', 0),
(0, 'Rockingham', 'Australia', 'Australia', 'ASXX0101', 0),
(0, 'Roebourne', 'Australia', 'Australia', 'ASXX0102', 0),
(0, 'Rollingstone/Halifax Bay', 'Australia', 'Australia', 'ASXX0103', 0),
(0, 'Roma', 'Australia', 'Australia', 'ASXX0389', 0),
(0, 'Rottnest Island', 'Australia', 'Australia', 'ASXX0226', 0),
(0, 'Rowley Shoals', 'Australia', 'Australia', 'ASXX0147', 0),
(0, 'Rum Jungle', 'Australia', 'Australia', 'ASXX0104', 0),
(0, 'Rumula', 'Australia', 'Australia', 'ASXX0105', 0),
(0, 'Salisbury', 'Australia', 'Australia', 'ASXX0106', 0),
(0, 'Sandy Cape', 'Australia', 'Australia', 'ASXX0196', 0),
(0, 'Scone Airport', 'Australia', 'Australia', 'ASXX0360', 0),
(0, 'Shark Bay Denham', 'Australia', 'Australia', 'ASXX0198', 0),
(0, 'Shellharbour', 'Australia', 'Australia', 'ASXX0107', 0),
(0, 'Sheoaks', 'Australia', 'Australia', 'ASXX0299', 0),
(0, 'Shepparton', 'Australia', 'Australia', 'ASXX0393', 0),
(0, 'Smithton', 'Australia', 'Australia', 'ASXX0419', 0),
(0, 'Smoky Cape Lighthouse Sw Rocks', 'Australia', 'Australia', 'ASXX0276', 0),
(0, 'Sorell', 'Australia', 'Australia', 'ASXX0108', 0),
(0, 'Southern Cross', 'Australia', 'Australia', 'ASXX0109', 0),
(0, 'Spearwood Jandakot Aerodrome', 'Australia', 'Australia', 'ASXX0231', 0),
(0, 'Springvale', 'Australia', 'Australia', 'ASXX0110', 0),
(0, 'St Lawrence Post Office', 'Australia', 'Australia', 'ASXX0186', 0),
(0, 'Strahan', 'Australia', 'Australia', 'ASXX0326', 0),
(0, 'Sunbury', 'Australia', 'Australia', 'ASXX0111', 0),
(0, 'Swan Hill', 'Australia', 'Australia', 'ASXX0291', 0),
(0, 'Swan Island', 'Australia', 'Australia', 'ASXX0373', 0),
(0, 'Swanbourne', 'Australia', 'Australia', 'ASXX0233', 0),
(0, 'Sydney', 'Australia', 'Australia', 'ASXX0112', 0),
(0, 'Sydney Regional Office', 'Australia', 'Australia', 'ASXX0274', 0),
(0, 'Tamworth', 'Australia', 'Australia', 'ASXX0113', 0),
(0, 'Tarago', 'Australia', 'Australia', 'ASXX0114', 0),
(0, 'Tarcoola', 'Australia', 'Australia', 'ASXX0240', 0),
(0, 'Taree', 'Australia', 'Australia', 'ASXX0386', 0),
(0, 'Tatura', 'Australia', 'Australia', 'ASXX0431', 0),
(0, 'Telfer Mining Centre', 'Australia', 'Australia', 'ASXX0398', 0),
(0, 'Tennant Creek', 'Australia', 'Australia', 'ASXX0115', 0),
(0, 'Thangoo', 'Australia', 'Australia', 'ASXX0116', 0),
(0, 'Thargomindah', 'Australia', 'Australia', 'ASXX0403', 0),
(0, 'Thevenard Island', 'Australia', 'Australia', 'ASXX0166', 0),
(0, 'Tibooburra', 'Australia', 'Australia', 'ASXX0207', 0),
(0, 'Tindal', 'Australia', 'Australia', 'ASXX0132', 0),
(0, 'Toowoomba', 'Australia', 'Australia', 'ASXX0429', 0),
(0, 'Town Of 1770', 'Australia', 'Australia', 'ASXX0192', 0),
(0, 'Townsville', 'Australia', 'Australia', 'ASXX0117', 0),
(0, 'Ulladulla', 'Australia', 'Australia', 'ASXX0324', 0),
(0, 'Urandangie', 'Australia', 'Australia', 'ASXX0178', 0),
(0, 'Victor Harbor', 'Australia', 'Australia', 'ASXX0118', 0),
(0, 'Victoria River Downs', 'Australia', 'Australia', 'ASXX0151', 0),
(0, 'Wagga Wagga', 'Australia', 'Australia', 'ASXX0415', 0),
(0, 'Walgett', 'Australia', 'Australia', 'ASXX0264', 0),
(0, 'Walgett Airport', 'Australia', 'Australia', 'ASXX0357', 0),
(0, 'Wangaratta Aerodrome', 'Australia', 'Australia', 'ASXX0308', 0),
(0, 'Wanneroo', 'Australia', 'Australia', 'ASXX0119', 0),
(0, 'Warrnambool Airport', 'Australia', 'Australia', 'ASXX0287', 0),
(0, 'Warruwi', 'Australia', 'Australia', 'ASXX0137', 0),
(0, 'Warwick', 'Australia', 'Australia', 'ASXX0216', 0),
(0, 'Watarrka Kings Canyon', 'Australia', 'Australia', 'ASXX0174', 0),
(0, 'Weipa City', 'Australia', 'Australia', 'ASXX0380', 0),
(0, 'Wentworth', 'Australia', 'Australia', 'ASXX0120', 0),
(0, 'Werris Creek', 'Australia', 'Australia', 'ASXX0121', 0),
(0, 'Whyalla', 'Australia', 'Australia', 'ASXX0245', 0),
(0, 'Whyalla Airport', 'Australia', 'Australia', 'ASXX0351', 0),
(0, 'Wilsons Promontory Light', 'Australia', 'Australia', 'ASXX0311', 0),
(0, 'Windorah', 'Australia', 'Australia', 'ASXX0208', 0),
(0, 'Winton', 'Australia', 'Australia', 'ASXX0123', 0),
(0, 'Winton Post Office', 'Australia', 'Australia', 'ASXX0181', 0),
(0, 'Wittenoom', 'Australia', 'Australia', 'ASXX0172', 0),
(0, 'Wollogorang', 'Australia', 'Australia', 'ASXX0156', 0),
(0, 'Wollongong', 'Australia', 'Australia', 'ASXX0124', 0),
(0, 'Wonthaggi Composite', 'Australia', 'Australia', 'ASXX0363', 0),
(0, 'Woolgoolga', 'Australia', 'Australia', 'ASXX0125', 0),
(0, 'Woomera', 'Australia', 'Australia', 'ASXX0382', 0),
(0, 'Wooramel', 'Australia', 'Australia', 'ASXX0126', 0),
(0, 'Wurruk', 'Australia', 'Australia', 'ASXX0417', 0),
(0, 'Wyndham', 'Australia', 'Australia', 'ASXX0149', 0),
(0, 'Wynyard Airport', 'Australia', 'Australia', 'ASXX0369', 0),
(0, 'Yass', 'Australia', 'Australia', 'ASXX0127', 0),
(0, 'Yeppoon', 'Australia', 'Australia', 'ASXX0128', 0),
(0, 'Yirrkala Mission', 'Australia', 'Australia', 'ASXX0420', 0),
(0, 'Yongala', 'Australia', 'Australia', 'ASXX0249', 0),
(0, 'Young', 'Australia', 'Australia', 'ASXX0263', 0),
(0, 'Yuendumu', 'Australia', 'Australia', 'ASXX0175', 0),
(0, 'Yunta', 'Australia', 'Australia', 'ASXX0410', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Crocus Hill', 'Anguilla', 'Caribbean', 'AVXX0001', 0),
(0, 'Codrington', 'Antigua And Barbuda', 'Caribbean', 'ACXX0001', 0),
(0, 'Saint John`s', 'Antigua And Barbuda', 'Caribbean', 'ACXX0002', 0),
(0, 'Oranjestad', 'Aruba', 'Caribbean', 'AAXX0001', 0),
(0, 'Queen Beatrix Airport', 'Aruba', 'Caribbean', 'AAXX0002', 0),
(0, 'Bridgetown', 'Barbados', 'Caribbean', 'BBXX0001', 0),
(0, 'Anegada', 'British Virgin Islands', 'Caribbean', 'VIXX0002', 0),
(0, 'Cooper Island', 'British Virgin Islands', 'Caribbean', 'VIXX0003', 0),
(0, 'Road Town', 'British Virgin Islands', 'Caribbean', 'VIXX0001', 0),
(0, 'Virgin Gorda', 'British Virgin Islands', 'Caribbean', 'VIXX0004', 0),
(0, 'Cayman Brac', 'Cayman Islands', 'Caribbean', 'CJXX0002', 0),
(0, 'George Town', 'Cayman Islands', 'Caribbean', 'CJXX0001', 0),
(0, 'Baracoa', 'Cuba', 'Caribbean', 'CUXX0021', 0),
(0, 'Bayamo', 'Cuba', 'Caribbean', 'CUXX0001', 0),
(0, 'Camaguey', 'Cuba', 'Caribbean', 'CUXX0002', 0),
(0, 'Cayo Coco', 'Cuba', 'Caribbean', 'CUXX0022', 0),
(0, 'Cienfuegus', 'Cuba', 'Caribbean', 'CUXX0017', 0),
(0, 'Guantanamo Bay NAS', 'Cuba', 'Caribbean', 'CUXX0016', 0),
(0, 'Havana', 'Cuba', 'Caribbean', 'CUXX0003', 0),
(0, 'Holguin', 'Cuba', 'Caribbean', 'CUXX0011', 0),
(0, 'Las Tunas', 'Cuba', 'Caribbean', 'CUXX0004', 0),
(0, 'Manzanillo', 'Cuba', 'Caribbean', 'CUXX0005', 0),
(0, 'Matanzas', 'Cuba', 'Caribbean', 'CUXX0006', 0),
(0, 'Moa', 'Cuba', 'Caribbean', 'CUXX0012', 0),
(0, 'Pinar del Rio', 'Cuba', 'Caribbean', 'CUXX0007', 0),
(0, 'Playa Giron', 'Cuba', 'Caribbean', 'CUXX0014', 0),
(0, 'Sancti Spiritus', 'Cuba', 'Caribbean', 'CUXX0008', 0),
(0, 'Santa Clara', 'Cuba', 'Caribbean', 'CUXX0009', 0),
(0, 'Santiago de Cuba', 'Cuba', 'Caribbean', 'CUXX0010', 0),
(0, 'Trinidad', 'Cuba', 'Caribbean', 'CUXX0013', 0),
(0, 'Varadero', 'Cuba', 'Caribbean', 'CUXX0020', 0),
(0, 'Marigot', 'Dominica', 'Caribbean', 'DOXX0001', 0),
(0, 'Roseau', 'Dominica', 'Caribbean', 'DOXX0002', 0),
(0, 'Azua', 'Dominican Republic', 'Caribbean', 'DRXX0021', 0),
(0, 'Bani', 'Dominican Republic', 'Caribbean', 'DRXX0025', 0),
(0, 'Barahona', 'Dominican Republic', 'Caribbean', 'DRXX0001', 0),
(0, 'Bavaro', 'Dominican Republic', 'Caribbean', 'DRXX0023', 0),
(0, 'Bonao', 'Dominican Republic', 'Caribbean', 'DRXX0002', 0),
(0, 'Cabarete', 'Dominican Republic', 'Caribbean', 'DRXX0013', 0),
(0, 'Cotui', 'Dominican Republic', 'Caribbean', 'DRXX0017', 0),
(0, 'El Seibo', 'Dominican Republic', 'Caribbean', 'DRXX0020', 0),
(0, 'Higuey', 'Dominican Republic', 'Caribbean', 'DRXX0024', 0),
(0, 'Isla Saona', 'Dominican Republic', 'Caribbean', 'DRXX0027', 0),
(0, 'La Romana', 'Dominican Republic', 'Caribbean', 'DRXX0003', 0),
(0, 'La Vega', 'Dominican Republic', 'Caribbean', 'DRXX0004', 0),
(0, 'Luperon', 'Dominican Republic', 'Caribbean', 'DRXX0010', 0),
(0, 'Mao', 'Dominican Republic', 'Caribbean', 'DRXX0028', 0),
(0, 'Monte Cristi', 'Dominican Republic', 'Caribbean', 'DRXX0012', 0),
(0, 'Monte Plata', 'Dominican Republic', 'Caribbean', 'DRXX0018', 0),
(0, 'Nagua', 'Dominican Republic', 'Caribbean', 'DRXX0014', 0),
(0, 'Puerto Plata', 'Dominican Republic', 'Caribbean', 'DRXX0005', 0),
(0, 'Punta Cana', 'Dominican Republic', 'Caribbean', 'DRXX0022', 0),
(0, 'Rio San Juan', 'Dominican Republic', 'Caribbean', 'DRXX0015', 0),
(0, 'Samana', 'Dominican Republic', 'Caribbean', 'DRXX0006', 0),
(0, 'San Cristobal', 'Dominican Republic', 'Caribbean', 'DRXX0026', 0),
(0, 'San Francisco De Macoris', 'Dominican Republic', 'Caribbean', 'DRXX0016', 0),
(0, 'San Pedro de Macoris', 'Dominican Republic', 'Caribbean', 'DRXX0007', 0),
(0, 'Santiago', 'Dominican Republic', 'Caribbean', 'DRXX0008', 0),
(0, 'Santo Domingo', 'Dominican Republic', 'Caribbean', 'DRXX0009', 0),
(0, 'Savana De La Mar', 'Dominican Republic', 'Caribbean', 'DRXX0019', 0),
(0, 'Sosua', 'Dominican Republic', 'Caribbean', 'DRXX0011', 0),
(0, 'Point Salines Airport', 'Grenada', 'Caribbean', 'GJXX0002', 0),
(0, 'Saint George`s', 'Grenada', 'Caribbean', 'GJXX0001', 0),
(0, 'Basse-Terre', 'Guadeloupe', 'Caribbean', 'GPXX0006', 0),
(0, 'Les Abymes', 'Guadeloupe', 'Caribbean', 'GPXX0001', 0),
(0, 'Petit-Bourg', 'Guadeloupe', 'Caribbean', 'GPXX0002', 0),
(0, 'Pointe-a-Pitre', 'Guadeloupe', 'Caribbean', 'GPXX0003', 0),
(0, 'Port-Louis', 'Guadeloupe', 'Caribbean', 'GPXX0004', 0),
(0, 'Saint Martin Island', 'Guadeloupe', 'Caribbean', 'GPXX0005', 0),
(0, 'St. Barthelemy', 'Guadeloupe', 'Caribbean', 'GPXX0007', 0),
(0, 'Gonaives', 'Haiti', 'Caribbean', 'HAXX0001', 0),
(0, 'Les Cayes', 'Haiti', 'Caribbean', 'HAXX0002', 0),
(0, 'Petionville', 'Haiti', 'Caribbean', 'HAXX0003', 0),
(0, 'Port-au-Prince', 'Haiti', 'Caribbean', 'HAXX0004', 0),
(0, 'Saint-Marc', 'Haiti', 'Caribbean', 'HAXX0005', 0),
(0, 'Black River', 'Jamaica', 'Caribbean', 'JMXX0010', 0),
(0, 'Christiana', 'Jamaica', 'Caribbean', 'JMXX0011', 0),
(0, 'Falmouth', 'Jamaica', 'Caribbean', 'JMXX0001', 0),
(0, 'Kingston', 'Jamaica', 'Caribbean', 'JMXX0002', 0),
(0, 'Montego Bay', 'Jamaica', 'Caribbean', 'JMXX0003', 0),
(0, 'Morant Bay', 'Jamaica', 'Caribbean', 'JMXX0004', 0),
(0, 'Negril', 'Jamaica', 'Caribbean', 'JMXX0009', 0),
(0, 'Ocho Rios', 'Jamaica', 'Caribbean', 'JMXX0005', 0),
(0, 'Port Antonio', 'Jamaica', 'Caribbean', 'JMXX0012', 0),
(0, 'Port Royal', 'Jamaica', 'Caribbean', 'JMXX0006', 0),
(0, 'Reading', 'Jamaica', 'Caribbean', 'JMXX0007', 0),
(0, 'Spanish Town', 'Jamaica', 'Caribbean', 'JMXX0008', 0),
(0, 'Fort-de-France', 'Martinique', 'Caribbean', 'MBXX0001', 0),
(0, 'Le Marin', 'Martinique', 'Caribbean', 'MBXX0002', 0),
(0, 'Saint-Joseph', 'Martinique', 'Caribbean', 'MBXX0003', 0),
(0, 'Saint-Pierre', 'Martinique', 'Caribbean', 'MBXX0004', 0),
(0, 'Montserrat', 'Montserrat', 'Caribbean', 'MHXX0001', 0),
(0, 'Curacao Island', 'Netherlands Antilles', 'Caribbean', 'NTXX0001', 0),
(0, 'Kralendijk', 'Netherlands Antilles', 'Caribbean', 'NTXX0002', 0),
(0, 'Saba', 'Netherlands Antilles', 'Caribbean', 'NTXX0003', 0),
(0, 'Saint Eustatius', 'Netherlands Antilles', 'Caribbean', 'NTXX0021', 0),
(0, 'St. Maarten', 'Netherlands Antilles', 'Caribbean', 'NTXX0004', 0),
(0, 'Castries', 'Saint Lucia', 'Caribbean', 'STXX0001', 0),
(0, 'Dennery', 'Saint Lucia', 'Caribbean', 'STXX0002', 0),
(0, 'Micoud', 'Saint Lucia', 'Caribbean', 'STXX0003', 0),
(0, 'Vieux Fort', 'Saint Lucia', 'Caribbean', 'STXX0004', 0),
(0, 'Basseterre', 'St. Kitts And Nevis', 'Caribbean', 'SCXX0001', 0),
(0, 'Nevis', 'St. Kitts And Nevis', 'Caribbean', 'SCXX0002', 0),
(0, 'Bequia', 'St. Vincent And The Grenadines', 'Caribbean', 'VCXX0001', 0),
(0, 'St. Vincent', 'St. Vincent And The Grenadines', 'Caribbean', 'VCXX0002', 0),
(0, 'The Grenadines', 'St. Vincent And The Grenadines', 'Caribbean', 'VCXX0003', 0),
(0, 'Acklins/Crooked Island', 'The Bahamas', 'Caribbean', 'BFXX0010', 0),
(0, 'Andros Town', 'The Bahamas', 'Caribbean', 'BFXX0001', 0),
(0, 'Bimini', 'The Bahamas', 'Caribbean', 'BFXX0009', 0),
(0, 'Cat Island', 'The Bahamas', 'Caribbean', 'BFXX0014', 0),
(0, 'Freeport', 'The Bahamas', 'Caribbean', 'BFXX0002', 0),
(0, 'George Town', 'The Bahamas', 'Caribbean', 'BFXX0006', 0),
(0, 'Governor`s Harbour', 'The Bahamas', 'Caribbean', 'BFXX0003', 0),
(0, 'Harbour Island', 'The Bahamas', 'Caribbean', 'BFXX0017', 0),
(0, 'Long Island', 'The Bahamas', 'Caribbean', 'BFXX0011', 0),
(0, 'Matthew Town', 'The Bahamas', 'Caribbean', 'BFXX0004', 0),
(0, 'Mayaguana', 'The Bahamas', 'Caribbean', 'BFXX0008', 0),
(0, 'Nassau', 'The Bahamas', 'Caribbean', 'BFXX0005', 0),
(0, 'Rum Cay', 'The Bahamas', 'Caribbean', 'BFXX0015', 0),
(0, 'San Salvador', 'The Bahamas', 'Caribbean', 'BFXX0012', 0),
(0, 'St. George`s Cay', 'The Bahamas', 'Caribbean', 'BFXX0016', 0),
(0, 'The Abacos', 'The Bahamas', 'Caribbean', 'BFXX0013', 0),
(0, 'The Berry Islands', 'The Bahamas', 'Caribbean', 'BFXX0007', 0),
(0, 'Arima', 'Trinidad And Tobago', 'Caribbean', 'TDXX0001', 0),
(0, 'Port-of-Spain', 'Trinidad And Tobago', 'Caribbean', 'TDXX0002', 0),
(0, 'San Fernando', 'Trinidad And Tobago', 'Caribbean', 'TDXX0003', 0),
(0, 'Scarborough', 'Trinidad And Tobago', 'Caribbean', 'TDXX0006', 0),
(0, 'Tobago', 'Trinidad And Tobago', 'Caribbean', 'TDXX0005', 0),
(0, 'Trinidad', 'Trinidad And Tobago', 'Caribbean', 'TDXX0004', 0),
(0, 'Grand Turk', 'Turks And Caicos Islands', 'Caribbean', 'TKXX0001', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Shkoder', 'Albania', 'Europe', 'ALXX0001', 0),
(0, 'Tirane', 'Albania', 'Europe', 'ALXX0002', 0),
(0, 'Aigen Im Ennstal', 'Austria', 'Europe', 'AUXX0034', 0),
(0, 'Amstetten', 'Austria', 'Europe', 'AUXX0038', 0),
(0, 'Bad Gleichenberg', 'Austria', 'Europe', 'AUXX0039', 0),
(0, 'Bad Goisen', 'Austria', 'Europe', 'AUXX0040', 0),
(0, 'Bad Hofgastein', 'Austria', 'Europe', 'AUXX0062', 0),
(0, 'Bad Ischl', 'Austria', 'Europe', 'AUXX0063', 0),
(0, 'Bad Mitterndorf', 'Austria', 'Europe', 'AUXX0130', 0),
(0, 'Bad Radkersburg', 'Austria', 'Europe', 'AUXX0113', 0),
(0, 'Baden', 'Austria', 'Europe', 'AUXX0001', 0),
(0, 'Bergheim', 'Austria', 'Europe', 'AUXX0002', 0),
(0, 'Bischofshofen', 'Austria', 'Europe', 'AUXX0041', 0),
(0, 'Bludenz', 'Austria', 'Europe', 'AUXX0073', 0),
(0, 'Braunau', 'Austria', 'Europe', 'AUXX0080', 0),
(0, 'Bregenz', 'Austria', 'Europe', 'AUXX0032', 0),
(0, 'Bruck an der Leitha', 'Austria', 'Europe', 'AUXX0091', 0),
(0, 'Bruck An Der Mur', 'Austria', 'Europe', 'AUXX0042', 0),
(0, 'Deutschlandsberg', 'Austria', 'Europe', 'AUXX0112', 0),
(0, 'Dornbirn', 'Austria', 'Europe', 'AUXX0071', 0),
(0, 'Eferding', 'Austria', 'Europe', 'AUXX0003', 0),
(0, 'Eisenstadt', 'Austria', 'Europe', 'AUXX0004', 0),
(0, 'Enns', 'Austria', 'Europe', 'AUXX0005', 0),
(0, 'Feldbach', 'Austria', 'Europe', 'AUXX0111', 0),
(0, 'Feldkirch', 'Austria', 'Europe', 'AUXX0072', 0),
(0, 'Feldkirchen', 'Austria', 'Europe', 'AUXX0117', 0),
(0, 'Freistadt', 'Austria', 'Europe', 'AUXX0079', 0),
(0, 'Friesach', 'Austria', 'Europe', 'AUXX0043', 0),
(0, 'Furstenfeld', 'Austria', 'Europe', 'AUXX0110', 0),
(0, 'Ganserndorf', 'Austria', 'Europe', 'AUXX0088', 0),
(0, 'Gleisdorf', 'Austria', 'Europe', 'AUXX0006', 0),
(0, 'Gmund', 'Austria', 'Europe', 'AUXX0086', 0),
(0, 'Gmunden', 'Austria', 'Europe', 'AUXX0044', 0),
(0, 'Gratkorn', 'Austria', 'Europe', 'AUXX0007', 0),
(0, 'Graz', 'Austria', 'Europe', 'AUXX0008', 0),
(0, 'Grieskirchen', 'Austria', 'Europe', 'AUXX0081', 0),
(0, 'Gussing', 'Austria', 'Europe', 'AUXX0100', 0),
(0, 'Hallein', 'Austria', 'Europe', 'AUXX0009', 0),
(0, 'Hartberg', 'Austria', 'Europe', 'AUXX0105', 0),
(0, 'Hermagor', 'Austria', 'Europe', 'AUXX0118', 0),
(0, 'Horn', 'Austria', 'Europe', 'AUXX0087', 0),
(0, 'Imst', 'Austria', 'Europe', 'AUXX0076', 0),
(0, 'Innsbruck', 'Austria', 'Europe', 'AUXX0010', 0),
(0, 'Ischgl', 'Austria', 'Europe', 'AUXX0123', 0),
(0, 'Jennersdorf', 'Austria', 'Europe', 'AUXX0101', 0),
(0, 'Judenburg', 'Austria', 'Europe', 'AUXX0109', 0),
(0, 'Kapfenberg', 'Austria', 'Europe', 'AUXX0129', 0),
(0, 'Kirchdorf', 'Austria', 'Europe', 'AUXX0046', 0),
(0, 'Kitzbuhel', 'Austria', 'Europe', 'AUXX0064', 0),
(0, 'Klagenfurt', 'Austria', 'Europe', 'AUXX0037', 0),
(0, 'Klosterneuburg', 'Austria', 'Europe', 'AUXX0011', 0),
(0, 'Knittelfeld', 'Austria', 'Europe', 'AUXX0106', 0),
(0, 'Korneuburg', 'Austria', 'Europe', 'AUXX0012', 0),
(0, 'Kufstein', 'Austria', 'Europe', 'AUXX0033', 0),
(0, 'Landeck', 'Austria', 'Europe', 'AUXX0075', 0),
(0, 'Lannach', 'Austria', 'Europe', 'AUXX0013', 0),
(0, 'Lech', 'Austria', 'Europe', 'AUXX0067', 0),
(0, 'Leibnitz', 'Austria', 'Europe', 'AUXX0014', 0),
(0, 'Leoben', 'Austria', 'Europe', 'AUXX0104', 0),
(0, 'Leonding', 'Austria', 'Europe', 'AUXX0015', 0),
(0, 'Lienz', 'Austria', 'Europe', 'AUXX0036', 0),
(0, 'Liezen', 'Austria', 'Europe', 'AUXX0102', 0),
(0, 'Lilienfeld', 'Austria', 'Europe', 'AUXX0093', 0),
(0, 'Linz', 'Austria', 'Europe', 'AUXX0016', 0),
(0, 'Mariazell', 'Austria', 'Europe', 'AUXX0035', 0),
(0, 'Matrei', 'Austria', 'Europe', 'AUXX0047', 0),
(0, 'Mattersburg', 'Austria', 'Europe', 'AUXX0097', 0),
(0, 'Mauterndorf', 'Austria', 'Europe', 'AUXX0050', 0),
(0, 'Melk', 'Austria', 'Europe', 'AUXX0090', 0),
(0, 'Mistelbach', 'Austria', 'Europe', 'AUXX0048', 0),
(0, 'Modling', 'Austria', 'Europe', 'AUXX0017', 0),
(0, 'Murau', 'Austria', 'Europe', 'AUXX0049', 0),
(0, 'Murzzuschlag', 'Austria', 'Europe', 'AUXX0103', 0),
(0, 'Neunkirchen', 'Austria', 'Europe', 'AUXX0095', 0),
(0, 'Neusiedl am See', 'Austria', 'Europe', 'AUXX0096', 0),
(0, 'Oberpullendorf', 'Austria', 'Europe', 'AUXX0098', 0),
(0, 'Oberwart', 'Austria', 'Europe', 'AUXX0099', 0),
(0, 'Perg', 'Austria', 'Europe', 'AUXX0082', 0),
(0, 'Puchberg', 'Austria', 'Europe', 'AUXX0128', 0),
(0, 'Ramsau', 'Austria', 'Europe', 'AUXX0126', 0),
(0, 'Rauris', 'Austria', 'Europe', 'AUXX0124', 0),
(0, 'Reichenau', 'Austria', 'Europe', 'AUXX0127', 0),
(0, 'Retz', 'Austria', 'Europe', 'AUXX0030', 0),
(0, 'Reutte', 'Austria', 'Europe', 'AUXX0074', 0),
(0, 'Ried', 'Austria', 'Europe', 'AUXX0051', 0),
(0, 'Rohrbach', 'Austria', 'Europe', 'AUXX0078', 0),
(0, 'Saint Poelten', 'Austria', 'Europe', 'AUXX0031', 0),
(0, 'Salzburg', 'Austria', 'Europe', 'AUXX0018', 0),
(0, 'Scheibbs', 'Austria', 'Europe', 'AUXX0092', 0),
(0, 'Schladming', 'Austria', 'Europe', 'AUXX0052', 0),
(0, 'Schwaz', 'Austria', 'Europe', 'AUXX0019', 0),
(0, 'Seiersberg', 'Austria', 'Europe', 'AUXX0020', 0),
(0, 'Sonnblick Mtn', 'Austria', 'Europe', 'AUXX0053', 0),
(0, 'Sonnenkopf', 'Austria', 'Europe', 'AUXX0070', 0),
(0, 'Spielberg', 'Austria', 'Europe', 'AUXX0061', 0),
(0, 'Spittal an der Drau', 'Austria', 'Europe', 'AUXX0119', 0),
(0, 'St. Cristoph', 'Austria', 'Europe', 'AUXX0069', 0),
(0, 'St. Johann', 'Austria', 'Europe', 'AUXX0045', 0),
(0, 'St. Veit', 'Austria', 'Europe', 'AUXX0116', 0),
(0, 'Steinach', 'Austria', 'Europe', 'AUXX0021', 0),
(0, 'Steyr', 'Austria', 'Europe', 'AUXX0083', 0),
(0, 'Steyregg', 'Austria', 'Europe', 'AUXX0022', 0),
(0, 'Stockerau', 'Austria', 'Europe', 'AUXX0023', 0),
(0, 'Stuben', 'Austria', 'Europe', 'AUXX0068', 0),
(0, 'Tamsweg', 'Austria', 'Europe', 'AUXX0077', 0),
(0, 'Traun', 'Austria', 'Europe', 'AUXX0024', 0),
(0, 'Tulln', 'Austria', 'Europe', 'AUXX0089', 0),
(0, 'Unken', 'Austria', 'Europe', 'AUXX0060', 0),
(0, 'Vienna', 'Austria', 'Europe', 'AUXX0025', 0),
(0, 'Villach', 'Austria', 'Europe', 'AUXX0065', 0),
(0, 'Vocklabruck', 'Austria', 'Europe', 'AUXX0084', 0),
(0, 'Voitsberg', 'Austria', 'Europe', 'AUXX0026', 0),
(0, 'Volkermarkt', 'Austria', 'Europe', 'AUXX0115', 0),
(0, 'Waidhofen an der Thaya', 'Austria', 'Europe', 'AUXX0085', 0),
(0, 'Waidhofen an der Ybbs', 'Austria', 'Europe', 'AUXX0094', 0),
(0, 'Waizenkirchen', 'Austria', 'Europe', 'AUXX0027', 0),
(0, 'Weiz', 'Austria', 'Europe', 'AUXX0107', 0),
(0, 'Wels', 'Austria', 'Europe', 'AUXX0028', 0),
(0, 'Wiener Neustadt', 'Austria', 'Europe', 'AUXX0029', 0),
(0, 'Windischgarsten', 'Austria', 'Europe', 'AUXX0125', 0),
(0, 'Wolfsberg', 'Austria', 'Europe', 'AUXX0114', 0),
(0, 'Zell Am See', 'Austria', 'Europe', 'AUXX0054', 0),
(0, 'Zeltweg', 'Austria', 'Europe', 'AUXX0055', 0),
(0, 'Zurs', 'Austria', 'Europe', 'AUXX0066', 0),
(0, 'Zwettl Stadt', 'Austria', 'Europe', 'AUXX0056', 0),
(0, 'Baranovici', 'Belarus', 'Europe', 'BOXX0020', 0),
(0, 'Bobruysr', 'Belarus', 'Europe', 'BOXX0022', 0),
(0, 'Borisov', 'Belarus', 'Europe', 'BOXX0001', 0),
(0, 'Brest', 'Belarus', 'Europe', 'BOXX0023', 0),
(0, 'Dobrush', 'Belarus', 'Europe', 'BOXX0002', 0),
(0, 'Dzerzhinsk', 'Belarus', 'Europe', 'BOXX0003', 0),
(0, 'Gomel`', 'Belarus', 'Europe', 'BOXX0004', 0),
(0, 'Grodno', 'Belarus', 'Europe', 'BOXX0016', 0),
(0, 'Kobrin', 'Belarus', 'Europe', 'BOXX0027', 0),
(0, 'Kostjvkovici', 'Belarus', 'Europe', 'BOXX0019', 0),
(0, 'Lepel', 'Belarus', 'Europe', 'BOXX0013', 0),
(0, 'Lida', 'Belarus', 'Europe', 'BOXX0017', 0),
(0, 'Lyntupy', 'Belarus', 'Europe', 'BOXX0012', 0),
(0, 'Minsk', 'Belarus', 'Europe', 'BOXX0005', 0),
(0, 'Mogilev', 'Belarus', 'Europe', 'BOXX0018', 0),
(0, 'Mozyr', 'Belarus', 'Europe', 'BOXX0026', 0),
(0, 'Mozyr`', 'Belarus', 'Europe', 'BOXX0006', 0),
(0, 'Orsa', 'Belarus', 'Europe', 'BOXX0015', 0),
(0, 'Pinsk', 'Belarus', 'Europe', 'BOXX0007', 0),
(0, 'Rakov', 'Belarus', 'Europe', 'BOXX0008', 0),
(0, 'Rechitsa', 'Belarus', 'Europe', 'BOXX0009', 0),
(0, 'Sluck', 'Belarus', 'Europe', 'BOXX0021', 0),
(0, 'Verhnedvinsk', 'Belarus', 'Europe', 'BOXX0011', 0),
(0, 'Vetka', 'Belarus', 'Europe', 'BOXX0010', 0),
(0, 'Vitebsk', 'Belarus', 'Europe', 'BOXX0014', 0),
(0, 'Zitkovici', 'Belarus', 'Europe', 'BOXX0025', 0),
(0, 'Anderlecht', 'Belgium', 'Europe', 'BEXX0001', 0),
(0, 'Ans', 'Belgium', 'Europe', 'BEXX0002', 0),
(0, 'Antwerp', 'Belgium', 'Europe', 'BEXX0003', 0),
(0, 'Aywaille', 'Belgium', 'Europe', 'BEXX0004', 0),
(0, 'Beauvechain', 'Belgium', 'Europe', 'BEXX0026', 0),
(0, 'Brussels', 'Belgium', 'Europe', 'BEXX0005', 0),
(0, 'Charleroi', 'Belgium', 'Europe', 'BEXX0006', 0),
(0, 'Dendermonde', 'Belgium', 'Europe', 'BEXX0007', 0),
(0, 'Diest', 'Belgium', 'Europe', 'BEXX0032', 0),
(0, 'Elsenborn', 'Belgium', 'Europe', 'BEXX0030', 0),
(0, 'Florennes', 'Belgium', 'Europe', 'BEXX0025', 0),
(0, 'Gent', 'Belgium', 'Europe', 'BEXX0008', 0),
(0, 'Halle', 'Belgium', 'Europe', 'BEXX0009', 0),
(0, 'Herstal', 'Belgium', 'Europe', 'BEXX0010', 0),
(0, 'Kleine Brogel', 'Belgium', 'Europe', 'BEXX0028', 0),
(0, 'Koksijde', 'Belgium', 'Europe', 'BEXX0021', 0),
(0, 'Liege', 'Belgium', 'Europe', 'BEXX0011', 0),
(0, 'Lokeren', 'Belgium', 'Europe', 'BEXX0012', 0),
(0, 'Mechelen', 'Belgium', 'Europe', 'BEXX0013', 0),
(0, 'Mons', 'Belgium', 'Europe', 'BEXX0014', 0),
(0, 'Munte', 'Belgium', 'Europe', 'BEXX0023', 0),
(0, 'Namur', 'Belgium', 'Europe', 'BEXX0015', 0),
(0, 'Oostende Airport', 'Belgium', 'Europe', 'BEXX0022', 0),
(0, 'Saint-Nicolas', 'Belgium', 'Europe', 'BEXX0016', 0),
(0, 'Schaerbeek', 'Belgium', 'Europe', 'BEXX0017', 0),
(0, 'Seraing', 'Belgium', 'Europe', 'BEXX0018', 0),
(0, 'Sint-Niklaas', 'Belgium', 'Europe', 'BEXX0019', 0),
(0, 'Spa', 'Belgium', 'Europe', 'BEXX0031', 0),
(0, 'Spa/La Sauveniere', 'Belgium', 'Europe', 'BEXX0029', 0),
(0, 'St-Hubert', 'Belgium', 'Europe', 'BEXX0027', 0),
(0, 'Uccle', 'Belgium', 'Europe', 'BEXX0024', 0),
(0, 'Vilvoorde', 'Belgium', 'Europe', 'BEXX0020', 0),
(0, 'Banja Luka', 'Bosnia And Herzegovina', 'Europe', 'BKXX0001', 0),
(0, 'Brcko', 'Bosnia And Herzegovina', 'Europe', 'BKXX0007', 0),
(0, 'Kotor-Varos', 'Bosnia And Herzegovina', 'Europe', 'BKXX0002', 0),
(0, 'Mostar', 'Bosnia And Herzegovina', 'Europe', 'BKXX0006', 0),
(0, 'Sanski Most', 'Bosnia And Herzegovina', 'Europe', 'BKXX0003', 0),
(0, 'Sarajevo', 'Bosnia And Herzegovina', 'Europe', 'BKXX0004', 0),
(0, 'Zenica', 'Bosnia And Herzegovina', 'Europe', 'BKXX0005', 0),
(0, 'Blagoevgrad', 'Bulgaria', 'Europe', 'BUXX0023', 0),
(0, 'Botev Vrah Top/Sommet', 'Bulgaria', 'Europe', 'BUXX0014', 0),
(0, 'Burgas', 'Bulgaria', 'Europe', 'BUXX0001', 0),
(0, 'Gotse Delchev', 'Bulgaria', 'Europe', 'BUXX0021', 0),
(0, 'Kavarna', 'Bulgaria', 'Europe', 'BUXX0019', 0),
(0, 'Kurdjali', 'Bulgaria', 'Europe', 'BUXX0016', 0),
(0, 'Lovetch', 'Bulgaria', 'Europe', 'BUXX0010', 0),
(0, 'Mussala Top/Sommet', 'Bulgaria', 'Europe', 'BUXX0013', 0),
(0, 'Pazardzhik', 'Bulgaria', 'Europe', 'BUXX0022', 0),
(0, 'Pernik', 'Bulgaria', 'Europe', 'BUXX0002', 0),
(0, 'Pleven', 'Bulgaria', 'Europe', 'BUXX0003', 0),
(0, 'Plovdiv', 'Bulgaria', 'Europe', 'BUXX0004', 0),
(0, 'Razgrad', 'Bulgaria', 'Europe', 'BUXX0012', 0),
(0, 'Rousse', 'Bulgaria', 'Europe', 'BUXX0011', 0),
(0, 'Sandanski', 'Bulgaria', 'Europe', 'BUXX0015', 0),
(0, 'Shabla', 'Bulgaria', 'Europe', 'BUXX0018', 0),
(0, 'Sliven', 'Bulgaria', 'Europe', 'BUXX0017', 0),
(0, 'Sofia', 'Bulgaria', 'Europe', 'BUXX0005', 0),
(0, 'Stara Zagora', 'Bulgaria', 'Europe', 'BUXX0006', 0),
(0, 'Tolbukhin', 'Bulgaria', 'Europe', 'BUXX0020', 0),
(0, 'Turnovo', 'Bulgaria', 'Europe', 'BUXX0024', 0),
(0, 'Varna', 'Bulgaria', 'Europe', 'BUXX0007', 0),
(0, 'Vidin', 'Bulgaria', 'Europe', 'BUXX0009', 0),
(0, 'Vraca', 'Bulgaria', 'Europe', 'BUXX0008', 0),
(0, 'Baskc', 'Croatia', 'Europe', 'HRXX0017', 0),
(0, 'Biograd', 'Croatia', 'Europe', 'HRXX0016', 0),
(0, 'Buje', 'Croatia', 'Europe', 'HRXX0024', 0),
(0, 'Cres', 'Croatia', 'Europe', 'HRXX0019', 0),
(0, 'Dubrovnik', 'Croatia', 'Europe', 'HRXX0001', 0),
(0, 'Gornji Humac', 'Croatia', 'Europe', 'HRXX0012', 0),
(0, 'Karlovac', 'Croatia', 'Europe', 'HRXX0002', 0),
(0, 'Korcula', 'Croatia', 'Europe', 'HRXX0020', 0),
(0, 'Labin', 'Croatia', 'Europe', 'HRXX0023', 0),
(0, 'Mali Losinj', 'Croatia', 'Europe', 'HRXX0022', 0),
(0, 'Mali Ston', 'Croatia', 'Europe', 'HRXX0021', 0),
(0, 'Marina', 'Croatia', 'Europe', 'HRXX0015', 0),
(0, 'Osijek', 'Croatia', 'Europe', 'HRXX0003', 0),
(0, 'Pag', 'Croatia', 'Europe', 'HRXX0014', 0),
(0, 'Pula', 'Croatia', 'Europe', 'HRXX0007', 0),
(0, 'Rijeka', 'Croatia', 'Europe', 'HRXX0006', 0),
(0, 'Rovinj', 'Croatia', 'Europe', 'HRXX0018', 0),
(0, 'Sibenik', 'Croatia', 'Europe', 'HRXX0011', 0),
(0, 'Slavonski Brod', 'Croatia', 'Europe', 'HRXX0013', 0),
(0, 'Split', 'Croatia', 'Europe', 'HRXX0004', 0),
(0, 'Zadar', 'Croatia', 'Europe', 'HRXX0010', 0),
(0, 'Zagreb', 'Croatia', 'Europe', 'HRXX0005', 0),
(0, 'Beroun', 'Czech Republic', 'Europe', 'EZXX0001', 0),
(0, 'Breclav', 'Czech Republic', 'Europe', 'EZXX0035', 0),
(0, 'Brno', 'Czech Republic', 'Europe', 'EZXX0002', 0),
(0, 'Budweis', 'Czech Republic', 'Europe', 'EZXX0030', 0),
(0, 'Cervena', 'Czech Republic', 'Europe', 'EZXX0027', 0),
(0, 'Cesky Tesin', 'Czech Republic', 'Europe', 'EZXX0003', 0),
(0, 'Cheb', 'Czech Republic', 'Europe', 'EZXX0017', 0),
(0, 'Chomutov', 'Czech Republic', 'Europe', 'EZXX0044', 0),
(0, 'Churanov', 'Czech Republic', 'Europe', 'EZXX0019', 0),
(0, 'Dormazlice', 'Czech Republic', 'Europe', 'EZXX0040', 0),
(0, 'Frydek', 'Czech Republic', 'Europe', 'EZXX0004', 0),
(0, 'Hodonin', 'Czech Republic', 'Europe', 'EZXX0036', 0),
(0, 'Holesov', 'Czech Republic', 'Europe', 'EZXX0028', 0),
(0, 'Jaromer', 'Czech Republic', 'Europe', 'EZXX0032', 0),
(0, 'Jesenik', 'Czech Republic', 'Europe', 'EZXX0037', 0),
(0, 'Jicin', 'Czech Republic', 'Europe', 'EZXX0031', 0),
(0, 'Jindrichuv Hradec', 'Czech Republic', 'Europe', 'EZXX0039', 0),
(0, 'Karlovy Vary', 'Czech Republic', 'Europe', 'EZXX0045', 0),
(0, 'Karvina', 'Czech Republic', 'Europe', 'EZXX0005', 0),
(0, 'Kladno', 'Czech Republic', 'Europe', 'EZXX0006', 0),
(0, 'Klatovy', 'Czech Republic', 'Europe', 'EZXX0041', 0),
(0, 'Kocelovice', 'Czech Republic', 'Europe', 'EZXX0021', 0),
(0, 'Kolin', 'Czech Republic', 'Europe', 'EZXX0007', 0),
(0, 'Kostelni Myslova', 'Czech Republic', 'Europe', 'EZXX0024', 0),
(0, 'Liberec', 'Czech Republic', 'Europe', 'EZXX0023', 0),
(0, 'Lysa Hora', 'Czech Republic', 'Europe', 'EZXX0029', 0),
(0, 'Milesovka', 'Czech Republic', 'Europe', 'EZXX0020', 0),
(0, 'Nachod', 'Czech Republic', 'Europe', 'EZXX0047', 0),
(0, 'Olomouc', 'Czech Republic', 'Europe', 'EZXX0038', 0),
(0, 'Opava', 'Czech Republic', 'Europe', 'EZXX0008', 0),
(0, 'Ostrava', 'Czech Republic', 'Europe', 'EZXX0009', 0),
(0, 'Pardubice', 'Czech Republic', 'Europe', 'EZXX0034', 0),
(0, 'Pilsen', 'Czech Republic', 'Europe', 'EZXX0010', 0),
(0, 'Pisek', 'Czech Republic', 'Europe', 'EZXX0011', 0),
(0, 'Prague', 'Czech Republic', 'Europe', 'EZXX0012', 0),
(0, 'Praha-Libus', 'Czech Republic', 'Europe', 'EZXX0022', 0),
(0, 'Pribyslav', 'Czech Republic', 'Europe', 'EZXX0025', 0),
(0, 'Primda', 'Czech Republic', 'Europe', 'EZXX0018', 0),
(0, 'Prostejov', 'Czech Republic', 'Europe', 'EZXX0049', 0),
(0, 'Rosice', 'Czech Republic', 'Europe', 'EZXX0013', 0),
(0, 'Slavkov u Brna', 'Czech Republic', 'Europe', 'EZXX0014', 0),
(0, 'Strakonice', 'Czech Republic', 'Europe', 'EZXX0042', 0),
(0, 'Sumperk', 'Czech Republic', 'Europe', 'EZXX0048', 0),
(0, 'Tabor', 'Czech Republic', 'Europe', 'EZXX0015', 0),
(0, 'Trebic', 'Czech Republic', 'Europe', 'EZXX0033', 0),
(0, 'Trutnov', 'Czech Republic', 'Europe', 'EZXX0046', 0),
(0, 'Turnov', 'Czech Republic', 'Europe', 'EZXX0043', 0),
(0, 'Usti nad Labem', 'Czech Republic', 'Europe', 'EZXX0016', 0),
(0, 'Usti Nad Orlici', 'Czech Republic', 'Europe', 'EZXX0026', 0),
(0, 'Aalborg', 'Denmark', 'Europe', 'DAXX0002', 0),
(0, 'Abenra', 'Denmark', 'Europe', 'DAXX0001', 0),
(0, 'Arhus', 'Denmark', 'Europe', 'DAXX0003', 0),
(0, 'Augustenborg', 'Denmark', 'Europe', 'DAXX0004', 0),
(0, 'Billund', 'Denmark', 'Europe', 'DAXX0005', 0),
(0, 'Birkerod', 'Denmark', 'Europe', 'DAXX0006', 0),
(0, 'Bramming', 'Denmark', 'Europe', 'DAXX0007', 0),
(0, 'Brande', 'Denmark', 'Europe', 'DAXX0008', 0),
(0, 'Copenhagen', 'Denmark', 'Europe', 'DAXX0009', 0),
(0, 'Esbjerg', 'Denmark', 'Europe', 'DAXX0010', 0),
(0, 'Filskov', 'Denmark', 'Europe', 'DAXX0011', 0),
(0, 'Fredericia', 'Denmark', 'Europe', 'DAXX0049', 0),
(0, 'Frederikshavn', 'Denmark', 'Europe', 'DAXX0012', 0),
(0, 'Frostrup', 'Denmark', 'Europe', 'DAXX0013', 0),
(0, 'Grena', 'Denmark', 'Europe', 'DAXX0050', 0),
(0, 'Grimstrup', 'Denmark', 'Europe', 'DAXX0014', 0),
(0, 'Hals', 'Denmark', 'Europe', 'DAXX0048', 0),
(0, 'Hammer Odde', 'Denmark', 'Europe', 'DAXX0042', 0),
(0, 'Hasle', 'Denmark', 'Europe', 'DAXX0015', 0),
(0, 'Helsingor', 'Denmark', 'Europe', 'DAXX0016', 0),
(0, 'Herning', 'Denmark', 'Europe', 'DAXX0017', 0),
(0, 'Hillerod', 'Denmark', 'Europe', 'DAXX0018', 0),
(0, 'Holstebro', 'Denmark', 'Europe', 'DAXX0019', 0),
(0, 'Horsens', 'Denmark', 'Europe', 'DAXX0051', 0),
(0, 'Horsholm', 'Denmark', 'Europe', 'DAXX0020', 0),
(0, 'Kalundborg', 'Denmark', 'Europe', 'DAXX0053', 0),
(0, 'Karup', 'Denmark', 'Europe', 'DAXX0021', 0),
(0, 'Koge', 'Denmark', 'Europe', 'DAXX0022', 0),
(0, 'Norup', 'Denmark', 'Europe', 'DAXX0023', 0),
(0, 'Nykobing', 'Denmark', 'Europe', 'DAXX0056', 0),
(0, 'Odense', 'Denmark', 'Europe', 'DAXX0024', 0),
(0, 'Ornslund', 'Denmark', 'Europe', 'DAXX0043', 0),
(0, 'Osterild', 'Denmark', 'Europe', 'DAXX0025', 0),
(0, 'Randers', 'Denmark', 'Europe', 'DAXX0026', 0),
(0, 'Ribe', 'Denmark', 'Europe', 'DAXX0027', 0),
(0, 'Ronne', 'Denmark', 'Europe', 'DAXX0028', 0),
(0, 'Roskilde', 'Denmark', 'Europe', 'DAXX0029', 0),
(0, 'Sandvig', 'Denmark', 'Europe', 'DAXX0030', 0),
(0, 'Sindal Flyveplads', 'Denmark', 'Europe', 'DAXX0045', 0),
(0, 'Sjorring', 'Denmark', 'Europe', 'DAXX0031', 0),
(0, 'Skagen', 'Denmark', 'Europe', 'DAXX0046', 0),
(0, 'Skanderborg', 'Denmark', 'Europe', 'DAXX0052', 0),
(0, 'Skive', 'Denmark', 'Europe', 'DAXX0055', 0),
(0, 'Skrydstrup', 'Denmark', 'Europe', 'DAXX0032', 0),
(0, 'Sonderborg', 'Denmark', 'Europe', 'DAXX0033', 0),
(0, 'Soro Syd', 'Denmark', 'Europe', 'DAXX0047', 0),
(0, 'Spang', 'Denmark', 'Europe', 'DAXX0034', 0),
(0, 'Svendborg', 'Denmark', 'Europe', 'DAXX0054', 0),
(0, 'Tastrup', 'Denmark', 'Europe', 'DAXX0035', 0),
(0, 'Thisted', 'Denmark', 'Europe', 'DAXX0036', 0),
(0, 'Thorshavn', 'Denmark', 'Europe', 'DAXX0041', 0),
(0, 'Torning', 'Denmark', 'Europe', 'DAXX0037', 0),
(0, 'Varde', 'Denmark', 'Europe', 'DAXX0038', 0),
(0, 'Verstervig', 'Denmark', 'Europe', 'DAXX0044', 0),
(0, 'Veslos', 'Denmark', 'Europe', 'DAXX0039', 0),
(0, 'Viborg', 'Denmark', 'Europe', 'DAXX0040', 0),
(0, 'Kardla', 'Estonia', 'Europe', 'ENXX0015', 0),
(0, 'Kunda', 'Estonia', 'Europe', 'ENXX0007', 0),
(0, 'Kuressaare', 'Estonia', 'Europe', 'ENXX0012', 0),
(0, 'Maardu', 'Estonia', 'Europe', 'ENXX0002', 0),
(0, 'Narva', 'Estonia', 'Europe', 'ENXX0008', 0),
(0, 'Pjarnu', 'Estonia', 'Europe', 'ENXX0013', 0),
(0, 'Raasiku', 'Estonia', 'Europe', 'ENXX0003', 0),
(0, 'Ristna', 'Estonia', 'Europe', 'ENXX0009', 0),
(0, 'Tallinn', 'Estonia', 'Europe', 'ENXX0004', 0),
(0, 'Tartu', 'Estonia', 'Europe', 'ENXX0005', 0),
(0, 'Turi', 'Estonia', 'Europe', 'ENXX0010', 0),
(0, 'Valga', 'Estonia', 'Europe', 'ENXX0014', 0),
(0, 'Valke-Maarja', 'Estonia', 'Europe', 'ENXX0011', 0),
(0, 'Espoo', 'Finland', 'Europe', 'FIXX0001', 0),
(0, 'Helsinki', 'Finland', 'Europe', 'FIXX0002', 0),
(0, 'Hyvinkaa', 'Finland', 'Europe', 'FIXX0003', 0),
(0, 'Ilomantsi', 'Finland', 'Europe', 'FIXX0024', 0),
(0, 'Imatra', 'Finland', 'Europe', 'FIXX0044', 0),
(0, 'Ivalo', 'Finland', 'Europe', 'FIXX0050', 0),
(0, 'Jarvenpaa', 'Finland', 'Europe', 'FIXX0004', 0),
(0, 'Joensuu', 'Finland', 'Europe', 'FIXX0049', 0),
(0, 'Jokioinen', 'Finland', 'Europe', 'FIXX0027', 0),
(0, 'Jomala', 'Finland', 'Europe', 'FIXX0028', 0),
(0, 'Jyvaskyla', 'Finland', 'Europe', 'FIXX0025', 0),
(0, 'Kaaresuvanto', 'Finland', 'Europe', 'FIXX0055', 0),
(0, 'Kajaani', 'Finland', 'Europe', 'FIXX0021', 0),
(0, 'Kalajoki', 'Finland', 'Europe', 'FIXX0035', 0),
(0, 'Kauhava', 'Finland', 'Europe', 'FIXX0052', 0),
(0, 'Kemi', 'Finland', 'Europe', 'FIXX0005', 0),
(0, 'Kerava', 'Finland', 'Europe', 'FIXX0006', 0),
(0, 'Kevo', 'Finland', 'Europe', 'FIXX0033', 0),
(0, 'Kittila', 'Finland', 'Europe', 'FIXX0048', 0),
(0, 'Kokkola', 'Finland', 'Europe', 'FIXX0007', 0),
(0, 'Korsnas', 'Finland', 'Europe', 'FIXX0008', 0),
(0, 'Kuopio', 'Finland', 'Europe', 'FIXX0023', 0),
(0, 'Kuusamo', 'Finland', 'Europe', 'FIXX0047', 0),
(0, 'Kuusankoski', 'Finland', 'Europe', 'FIXX0038', 0),
(0, 'Lahti', 'Finland', 'Europe', 'FIXX0037', 0),
(0, 'Laihia', 'Finland', 'Europe', 'FIXX0009', 0),
(0, 'Laitila', 'Finland', 'Europe', 'FIXX0010', 0),
(0, 'Lappeentranta', 'Finland', 'Europe', 'FIXX0040', 0),
(0, 'Mikkeli', 'Finland', 'Europe', 'FIXX0051', 0),
(0, 'Muonio', 'Finland', 'Europe', 'FIXX0034', 0),
(0, 'Mynamaki', 'Finland', 'Europe', 'FIXX0011', 0),
(0, 'Nivala', 'Finland', 'Europe', 'FIXX0022', 0),
(0, 'Oravainen', 'Finland', 'Europe', 'FIXX0012', 0),
(0, 'Oulu', 'Finland', 'Europe', 'FIXX0013', 0),
(0, 'Pori', 'Finland', 'Europe', 'FIXX0026', 0),
(0, 'Porvoo', 'Finland', 'Europe', 'FIXX0014', 0),
(0, 'Pudasjarvi', 'Finland', 'Europe', 'FIXX0041', 0),
(0, 'Raahe', 'Finland', 'Europe', 'FIXX0045', 0),
(0, 'Rankki', 'Finland', 'Europe', 'FIXX0029', 0),
(0, 'Rauma', 'Finland', 'Europe', 'FIXX0015', 0),
(0, 'Rovaniemi', 'Finland', 'Europe', 'FIXX0053', 0),
(0, 'Russaro', 'Finland', 'Europe', 'FIXX0030', 0),
(0, 'Salla', 'Finland', 'Europe', 'FIXX0042', 0),
(0, 'Salo', 'Finland', 'Europe', 'FIXX0016', 0),
(0, 'Savonlinna', 'Finland', 'Europe', 'FIXX0039', 0),
(0, 'Seinajoki', 'Finland', 'Europe', 'FIXX0017', 0),
(0, 'Sodankyla', 'Finland', 'Europe', 'FIXX0032', 0),
(0, 'Svetogorsk', 'Finland', 'Europe', 'FIXX0046', 0),
(0, 'Tammisaari', 'Finland', 'Europe', 'FIXX0036', 0),
(0, 'Tampere/Pirkkala', 'Finland', 'Europe', 'FIXX0031', 0),
(0, 'Turku', 'Finland', 'Europe', 'FIXX0018', 0),
(0, 'Vaasa', 'Finland', 'Europe', 'FIXX0019', 0),
(0, 'Vantaa', 'Finland', 'Europe', 'FIXX0020', 0),
(0, 'Varkaus', 'Finland', 'Europe', 'FIXX0054', 0),
(0, 'Ylivieska', 'Finland', 'Europe', 'FIXX0043', 0),
(0, 'Aast', 'France', 'Europe', 'FRAQ0001', 0),
(0, 'Abainville', 'France', 'Europe', 'FRLO0001', 0),
(0, 'Abancourt', 'France', 'Europe', 'FRXX1438', 0),
(0, 'Abaucourt', 'France', 'Europe', 'FRLO0002', 0),
(0, 'Abbans-Dessous', 'France', 'Europe', 'FRFC0001', 0),
(0, 'Abbans-Dessus', 'France', 'Europe', 'FRFC0002', 0),
(0, 'Abbecourt', 'France', 'Europe', 'FRPI0001', 0),
(0, 'Abbecourt', 'France', 'Europe', 'FRPI0002', 0),
(0, 'Abbenans', 'France', 'Europe', 'FRFC0003', 0),
(0, 'Abbeville', 'France', 'Europe', 'FRXX0111', 0),
(0, 'Abbevillers', 'France', 'Europe', 'FRFC0004', 0),
(0, 'Abeilhan', 'France', 'Europe', 'FRLR0001', 0),
(0, 'Abelcourt', 'France', 'Europe', 'FRFC0005', 0),
(0, 'Abere', 'France', 'Europe', 'FRAQ0002', 0),
(0, 'Abergement-le-Grand', 'France', 'Europe', 'FRFC0006', 0),
(0, 'Abergement-le-Petit', 'France', 'Europe', 'FRFC0007', 0),
(0, 'Abidos', 'France', 'Europe', 'FRAQ0003', 0),
(0, 'Abitain', 'France', 'Europe', 'FRAQ0004', 0),
(0, 'Abjat-sur-Bandiat', 'France', 'Europe', 'FRAQ0005', 0),
(0, 'Ablaincourt-Pressoir', 'France', 'Europe', 'FRPI0003', 0),
(0, 'Ablainzevelle', 'France', 'Europe', 'FRNC0001', 0),
(0, 'Ablancourt', 'France', 'Europe', 'FRCA0001', 0),
(0, 'Ableiges', 'France', 'Europe', 'FRIF0001', 0),
(0, 'Ablis', 'France', 'Europe', 'FRIF0002', 0),
(0, 'Ablon', 'France', 'Europe', 'FRBN0001', 0),
(0, 'Ablon-sur-Seine', 'France', 'Europe', 'FRXX1570', 0),
(0, 'Aboen', 'France', 'Europe', 'FRRA0001', 0),
(0, 'Aboncourt-Gesincourt', 'France', 'Europe', 'FRFC0008', 0),
(0, 'Abondance', 'France', 'Europe', 'FRRA0002', 0),
(0, 'Abondant', 'France', 'Europe', 'FRXX5930', 0),
(0, 'Abos', 'France', 'Europe', 'FRAQ0006', 0),
(0, 'Abrest', 'France', 'Europe', 'FRAU0001', 0),
(0, 'Abries', 'France', 'Europe', 'FRPA0001', 0),
(0, 'Abscon', 'France', 'Europe', 'FRXX4851', 0),
(0, 'Abzac', 'France', 'Europe', 'FRAQ0007', 0),
(0, 'Abzac', 'France', 'Europe', 'FRPC0001', 0),
(0, 'Accolans', 'France', 'Europe', 'FRFC0009', 0),
(0, 'Accolay', 'France', 'Europe', 'FRBO0001', 0),
(0, 'Accons', 'France', 'Europe', 'FRRA0003', 0),
(0, 'Accous', 'France', 'Europe', 'FRAQ0008', 0),
(0, 'Achen', 'France', 'Europe', 'FRXX1220', 0),
(0, 'Achenheim', 'France', 'Europe', 'FRXX5834', 0),
(0, 'Acheres', 'France', 'Europe', 'FRCE0001', 0),
(0, 'Acheres', 'France', 'Europe', 'FRXX5109', 0),
(0, 'Acheres-la-Foret', 'France', 'Europe', 'FRXX3754', 0),
(0, 'Achery', 'France', 'Europe', 'FRPI0004', 0),
(0, 'Acheville', 'France', 'Europe', 'FRNC0002', 0),
(0, 'Achey', 'France', 'Europe', 'FRFC0010', 0),
(0, 'Achicourt', 'France', 'Europe', 'FRNC0003', 0),
(0, 'Achiet-le-Grand', 'France', 'Europe', 'FRNC0004', 0),
(0, 'Achiet-le-Petit', 'France', 'Europe', 'FRNC0005', 0),
(0, 'Achun', 'France', 'Europe', 'FRBO0002', 0),
(0, 'Achy', 'France', 'Europe', 'FRPI0005', 0),
(0, 'Acigne', 'France', 'Europe', 'FRXX1618', 0),
(0, 'Aclou', 'France', 'Europe', 'FRHN0001', 0),
(0, 'Acoua', 'France', 'Europe', 'FRXX7838', 0),
(0, 'Acq', 'France', 'Europe', 'FRNC0006', 0),
(0, 'Acqueville', 'France', 'Europe', 'FRBN0002', 0),
(0, 'Acqueville', 'France', 'Europe', 'FRBN0003', 0),
(0, 'Acquin-Westbecourt', 'France', 'Europe', 'FRNC0007', 0),
(0, 'Acy', 'France', 'Europe', 'FRPI0006', 0),
(0, 'Adaincourt', 'France', 'Europe', 'FRLO0003', 0),
(0, 'Adainville', 'France', 'Europe', 'FRIF0003', 0),
(0, 'Adast', 'France', 'Europe', 'FRMP0001', 0),
(0, 'Ade', 'France', 'Europe', 'FRMP0002', 0),
(0, 'Adelange', 'France', 'Europe', 'FRLO0004', 0),
(0, 'Adelans-et-le-Val-de-Bithaine', 'France', 'Europe', 'FRFC0011', 0),
(0, 'Adervielle-Pouchergues', 'France', 'Europe', 'FRMP0003', 0),
(0, 'Adilly', 'France', 'Europe', 'FRPC0002', 0),
(0, 'Adinfer', 'France', 'Europe', 'FRNC0008', 0),
(0, 'Adissan', 'France', 'Europe', 'FRLR0002', 0),
(0, 'Adon', 'France', 'Europe', 'FRCE0002', 0),
(0, 'Adriers', 'France', 'Europe', 'FRPC0003', 0),
(0, 'Aeroport D`Orly', 'France', 'Europe', 'FRXX1542', 0),
(0, 'Afaahiti', 'France', 'Europe', 'FRXX7865', 0),
(0, 'Affieux', 'France', 'Europe', 'FRLI0001', 0),
(0, 'Affleville', 'France', 'Europe', 'FRLO0005', 0),
(0, 'Affoux', 'France', 'Europe', 'FRRA0004', 0),
(0, 'Affracourt', 'France', 'Europe', 'FRLO0006', 0),
(0, 'Affringues', 'France', 'Europe', 'FRNC0009', 0),
(0, 'Agassac', 'France', 'Europe', 'FRMP0004', 0),
(0, 'Baalon', 'France', 'Europe', 'FRLO0077', 0),
(0, 'Baalons', 'France', 'Europe', 'FRCA0073', 0),
(0, 'Baboeuf', 'France', 'Europe', 'FRPI0086', 0),
(0, 'Baby', 'France', 'Europe', 'FRIF0032', 0),
(0, 'Bach', 'France', 'Europe', 'FRMP0153', 0),
(0, 'Bachant', 'France', 'Europe', 'FRNC0059', 0),
(0, 'Bachas', 'France', 'Europe', 'FRMP0154', 0),
(0, 'Bachivillers', 'France', 'Europe', 'FRPI0087', 0),
(0, 'Bachos', 'France', 'Europe', 'FRMP0155', 0),
(0, 'Bachy', 'France', 'Europe', 'FRNC0060', 0),
(0, 'Bacilly', 'France', 'Europe', 'FRBN0046', 0),
(0, 'Baconnes', 'France', 'Europe', 'FRCA0074', 0),
(0, 'Bacouel', 'France', 'Europe', 'FRPI0088', 0),
(0, 'Bacourt', 'France', 'Europe', 'FRLO0078', 0),
(0, 'Badaroux', 'France', 'Europe', 'FRLR0054', 0),
(0, 'Badens', 'France', 'Europe', 'FRLR0055', 0),
(0, 'Badevel', 'France', 'Europe', 'FRXX1053', 0),
(0, 'Badonvilliers-Gerauvilliers', 'France', 'Europe', 'FRLO0079', 0),
(0, 'Baerendorf', 'France', 'Europe', 'FRAL0009', 0),
(0, 'Bagard', 'France', 'Europe', 'FRLR0056', 0),
(0, 'Bagat-en-Quercy', 'France', 'Europe', 'FRMP0156', 0),
(0, 'Bage-la-Ville', 'France', 'Europe', 'FRRA0107', 0),
(0, 'Bagert', 'France', 'Europe', 'FRMP0157', 0),
(0, 'Bages', 'France', 'Europe', 'FRXX4317', 0),
(0, 'Bagiry', 'France', 'Europe', 'FRMP0158', 0),
(0, 'Bagnac-sur-Cele', 'France', 'Europe', 'FRMP0159', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRAU0039', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRCA0075', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRCE0037', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRLO0080', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRPC0060', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRPI0089', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRPL0032', 0),
(0, 'Bagneux', 'France', 'Europe', 'FRXX2216', 0),
(0, 'Bagnizeau', 'France', 'Europe', 'FRPC0061', 0),
(0, 'Bagnoles', 'France', 'Europe', 'FRLR0057', 0),
(0, 'Bagnolet', 'France', 'Europe', 'FRXX4605', 0),
(0, 'Bagnols', 'France', 'Europe', 'FRRA0108', 0),
(0, 'Bagnols-sur-Ceze', 'France', 'Europe', 'FRXX7701', 0),
(0, 'Bagnot', 'France', 'Europe', 'FRBO0054', 0),
(0, 'Baho', 'France', 'Europe', 'FRXX5316', 0),
(0, 'Bahus-Soubiran', 'France', 'Europe', 'FRAQ0094', 0),
(0, 'Baie-Mahault', 'France', 'Europe', 'FRXX7718', 0),
(0, 'Baigneaux', 'France', 'Europe', 'FRAQ0095', 0),
(0, 'Baigneaux', 'France', 'Europe', 'FRCE0038', 0),
(0, 'Baigneaux', 'France', 'Europe', 'FRCE0039', 0),
(0, 'Baignes', 'France', 'Europe', 'FRFC0089', 0),
(0, 'Baignolet', 'France', 'Europe', 'FRCE0040', 0),
(0, 'Baigts', 'France', 'Europe', 'FRAQ0096', 0),
(0, 'Baillargues', 'France', 'Europe', 'FRLR0058', 0),
(0, 'Bailleul', 'France', 'Europe', 'FRBN0047', 0),
(0, 'Bailleul', 'France', 'Europe', 'FRPI0090', 0),
(0, 'Bailleul-sur-Therain', 'France', 'Europe', 'FRXX4297', 0),
(0, 'Bailleulmont', 'France', 'Europe', 'FRNC0061', 0),
(0, 'Bailleulval', 'France', 'Europe', 'FRNC0062', 0),
(0, 'Bailleval', 'France', 'Europe', 'FRPI0091', 0),
(0, 'Baillif', 'France', 'Europe', 'FRXX7719', 0),
(0, 'Bailly', 'France', 'Europe', 'FRPI0092', 0),
(0, 'Bailly', 'France', 'Europe', 'FRXX3560', 0),
(0, 'Bailly-Carrois', 'France', 'Europe', 'FRIF0033', 0),
(0, 'Bailly-Romainvilliers', 'France', 'Europe', 'FRIF0034', 0),
(0, 'Baincthun', 'France', 'Europe', 'FRNC0063', 0),
(0, 'Bainghen', 'France', 'Europe', 'FRNC0064', 0),
(0, 'Bains', 'France', 'Europe', 'FRAU0040', 0),
(0, 'Bairols', 'France', 'Europe', 'FRPA0033', 0),
(0, 'Bais', 'France', 'Europe', 'FRPL0033', 0),
(0, 'Baissey', 'France', 'Europe', 'FRCA0076', 0),
(0, 'Baives', 'France', 'Europe', 'FRNC0065', 0),
(0, 'Baix', 'France', 'Europe', 'FRRA0109', 0),
(0, 'Baixas', 'France', 'Europe', 'FRXX2782', 0),
(0, 'Baizieux', 'France', 'Europe', 'FRPI0093', 0),
(0, 'Bajamont', 'France', 'Europe', 'FRAQ0097', 0),
(0, 'Bajonnette', 'France', 'Europe', 'FRMP0160', 0),
(0, 'Bajus', 'France', 'Europe', 'FRNC0066', 0),
(0, 'Balacet', 'France', 'Europe', 'FRMP0161', 0),
(0, 'Balagueres', 'France', 'Europe', 'FRMP0162', 0),
(0, 'Balaiseaux', 'France', 'Europe', 'FRFC0090', 0),
(0, 'Balan', 'France', 'Europe', 'FRRA0110', 0),
(0, 'Balanod', 'France', 'Europe', 'FRFC0091', 0),
(0, 'Balansun', 'France', 'Europe', 'FRAQ0098', 0),
(0, 'Balanzac', 'France', 'Europe', 'FRPC0062', 0),
(0, 'Cabanac', 'France', 'Europe', 'FRMP0364', 0),
(0, 'Cabanac-et-Villagrains', 'France', 'Europe', 'FRAQ0231', 0),
(0, 'Cabanac-Seguenville', 'France', 'Europe', 'FRMP0365', 0),
(0, 'Cabanes', 'France', 'Europe', 'FRMP0366', 0),
(0, 'Cabanes', 'France', 'Europe', 'FRMP0367', 0),
(0, 'Cabannes', 'France', 'Europe', 'FRXX1076', 0),
(0, 'Cabara', 'France', 'Europe', 'FRAQ0232', 0),
(0, 'Cabasse', 'France', 'Europe', 'FRPA0080', 0),
(0, 'Cabestany', 'France', 'Europe', 'FRXX6495', 0),
(0, 'Cabidos', 'France', 'Europe', 'FRAQ0233', 0),
(0, 'Cabourg', 'France', 'Europe', 'FRBN0155', 0),
(0, 'Cabrerets', 'France', 'Europe', 'FRMP0368', 0),
(0, 'Cabrerolles', 'France', 'Europe', 'FRLR0109', 0),
(0, 'Cabrespine', 'France', 'Europe', 'FRLR0110', 0),
(0, 'Cabrieres', 'France', 'Europe', 'FRLR0111', 0),
(0, 'Cabrieres', 'France', 'Europe', 'FRPA0081', 0),
(0, 'Cabrieres-d`Avignon', 'France', 'Europe', 'FRPA0082', 0),
(0, 'Cabries', 'France', 'Europe', 'FRPA0083', 0),
(0, 'Cabris', 'France', 'Europe', 'FRPA0084', 0),
(0, 'Cacao', 'France', 'Europe', 'FRXX7787', 0),
(0, 'Cachan', 'France', 'Europe', 'FRXX1567', 0),
(0, 'Cachen', 'France', 'Europe', 'FRAQ0234', 0),
(0, 'Cachy', 'France', 'Europe', 'FRPI0264', 0),
(0, 'Cadalen', 'France', 'Europe', 'FRMP0369', 0),
(0, 'Cadarcet', 'France', 'Europe', 'FRMP0370', 0),
(0, 'Cadarsac', 'France', 'Europe', 'FRAQ0235', 0),
(0, 'Cadaujac', 'France', 'Europe', 'FRAQ0236', 0),
(0, 'Cadeac', 'France', 'Europe', 'FRMP0371', 0),
(0, 'Cadeilhan', 'France', 'Europe', 'FRMP0372', 0),
(0, 'Cadeillan', 'France', 'Europe', 'FRMP0373', 0),
(0, 'Cademene', 'France', 'Europe', 'FRFC0204', 0),
(0, 'Caderousse', 'France', 'Europe', 'FRXX3022', 0),
(0, 'Cadillon', 'France', 'Europe', 'FRAQ0237', 0),
(0, 'Cadix', 'France', 'Europe', 'FRMP0374', 0),
(0, 'Cadolive', 'France', 'Europe', 'FRXX4799', 0),
(0, 'Cadouin', 'France', 'Europe', 'FRAQ0238', 0),
(0, 'Cadours', 'France', 'Europe', 'FRMP0375', 0),
(0, 'Cadrieu', 'France', 'Europe', 'FRMP0376', 0),
(0, 'Caen', 'France', 'Europe', 'FRXX0020', 0),
(0, 'Caer', 'France', 'Europe', 'FRHN0111', 0),
(0, 'Caestre', 'France', 'Europe', 'FRNC0187', 0),
(0, 'Caffiers', 'France', 'Europe', 'FRNC0188', 0),
(0, 'Cagnano', 'France', 'Europe', 'FRCO0024', 0),
(0, 'Cagnes-sur-Mer', 'France', 'Europe', 'FRXX0021', 0),
(0, 'Cagnicourt', 'France', 'Europe', 'FRNC0189', 0),
(0, 'Cagnoncles', 'France', 'Europe', 'FRNC0190', 0),
(0, 'Cagnotte', 'France', 'Europe', 'FRAQ0239', 0),
(0, 'Cagny', 'France', 'Europe', 'FRPI0265', 0),
(0, 'Cagny', 'France', 'Europe', 'FRXX3231', 0),
(0, 'Cahagnes', 'France', 'Europe', 'FRBN0156', 0),
(0, 'Cahagnolles', 'France', 'Europe', 'FRBN0157', 0),
(0, 'Cahaignes', 'France', 'Europe', 'FRHN0112', 0),
(0, 'Cahan', 'France', 'Europe', 'FRBN0158', 0),
(0, 'Caharet', 'France', 'Europe', 'FRMP0377', 0),
(0, 'Cahon', 'France', 'Europe', 'FRPI0266', 0),
(0, 'Cahors', 'France', 'Europe', 'FRXX0022', 0),
(0, 'Cahus', 'France', 'Europe', 'FRMP0378', 0),
(0, 'Cahuzac', 'France', 'Europe', 'FRAQ0240', 0),
(0, 'Cahuzac', 'France', 'Europe', 'FRLR0112', 0),
(0, 'Cahuzac', 'France', 'Europe', 'FRMP0379', 0),
(0, 'Cahuzac-sur-Adour', 'France', 'Europe', 'FRMP0380', 0),
(0, 'Caignac', 'France', 'Europe', 'FRMP0381', 0),
(0, 'Cailhau', 'France', 'Europe', 'FRLR0113', 0),
(0, 'Cailhavel', 'France', 'Europe', 'FRLR0114', 0),
(0, 'Cailla', 'France', 'Europe', 'FRLR0115', 0),
(0, 'Caillac', 'France', 'Europe', 'FRMP0382', 0),
(0, 'Caillavet', 'France', 'Europe', 'FRMP0383', 0),
(0, 'Caille', 'France', 'Europe', 'FRPA0085', 0),
(0, 'Cailleville', 'France', 'Europe', 'FRHN0113', 0),
(0, 'Cairanne', 'France', 'Europe', 'FRPA0086', 0),
(0, 'Cairon', 'France', 'Europe', 'FRBN0159', 0),
(0, 'Caisnes', 'France', 'Europe', 'FRPI0267', 0),
(0, 'Caissargues', 'France', 'Europe', 'FRXX3957', 0),
(0, 'Caix', 'France', 'Europe', 'FRPI0268', 0),
(0, 'Caixas', 'France', 'Europe', 'FRLR0116', 0),
(0, 'Caixon', 'France', 'Europe', 'FRMP0384', 0),
(0, 'Calacuccia', 'France', 'Europe', 'FRCO0025', 0),
(0, 'Calais', 'France', 'Europe', 'FRXX0272', 0),
(0, 'Calamane', 'France', 'Europe', 'FRMP0385', 0),
(0, 'Calas', 'France', 'Europe', 'FRPA0087', 0),
(0, 'Calavante', 'France', 'Europe', 'FRMP0386', 0),
(0, 'D`Huison-Longueville', 'France', 'Europe', 'FRIF0161', 0),
(0, 'Dachstein', 'France', 'Europe', 'FRAL0077', 0),
(0, 'Dadonville', 'France', 'Europe', 'FRCE0261', 0),
(0, 'Daglan', 'France', 'Europe', 'FRAQ0370', 0),
(0, 'Dagny', 'France', 'Europe', 'FRIF0162', 0),
(0, 'Dagonville', 'France', 'Europe', 'FRLO0342', 0),
(0, 'Dahlenheim', 'France', 'Europe', 'FRAL0078', 0),
(0, 'Daignac', 'France', 'Europe', 'FRAQ0371', 0),
(0, 'Daillancourt', 'France', 'Europe', 'FRCA0353', 0),
(0, 'Daillecourt', 'France', 'Europe', 'FRCA0354', 0),
(0, 'Dainville', 'France', 'Europe', 'FRXX1446', 0),
(0, 'Dalem', 'France', 'Europe', 'FRLO0343', 0),
(0, 'Dalhain', 'France', 'Europe', 'FRLO0344', 0),
(0, 'Dalhunden', 'France', 'Europe', 'FRAL0079', 0),
(0, 'Dallet', 'France', 'Europe', 'FRXX1262', 0),
(0, 'Dallon', 'France', 'Europe', 'FRPI0432', 0),
(0, 'Dalou', 'France', 'Europe', 'FRMP0595', 0),
(0, 'Dalstein', 'France', 'Europe', 'FRLO0345', 0),
(0, 'Daluis', 'France', 'Europe', 'FRPA0152', 0),
(0, 'Dambelin', 'France', 'Europe', 'FRFC0382', 0),
(0, 'Dambenois', 'France', 'Europe', 'FRFC0383', 0),
(0, 'Dambenoit-les-Colombe', 'France', 'Europe', 'FRFC0384', 0),
(0, 'Damblain', 'France', 'Europe', 'FRLO0346', 0),
(0, 'Damblainville', 'France', 'Europe', 'FRBN0296', 0),
(0, 'Dambron', 'France', 'Europe', 'FRCE0262', 0),
(0, 'Dame-Marie', 'France', 'Europe', 'FRBN0297', 0),
(0, 'Dame-Marie', 'France', 'Europe', 'FRHN0172', 0),
(0, 'Damelevieres', 'France', 'Europe', 'FRLO0347', 0),
(0, 'Dameraucourt', 'France', 'Europe', 'FRPI0433', 0),
(0, 'Damerey', 'France', 'Europe', 'FRBO0343', 0),
(0, 'Damery', 'France', 'Europe', 'FRCA0355', 0),
(0, 'Damery', 'France', 'Europe', 'FRPI0434', 0),
(0, 'Damgan', 'France', 'Europe', 'FRXX5046', 0),
(0, 'Damigny', 'France', 'Europe', 'FRBN0298', 0),
(0, 'Damloup', 'France', 'Europe', 'FRLO0348', 0),
(0, 'Dammard', 'France', 'Europe', 'FRPI0435', 0),
(0, 'Dammarie', 'France', 'Europe', 'FRCE0263', 0),
(0, 'Dammartin-en-Serve', 'France', 'Europe', 'FRXX5838', 0),
(0, 'Dammartin-Marpain', 'France', 'Europe', 'FRFC0385', 0),
(0, 'Damousies', 'France', 'Europe', 'FRNC0260', 0),
(0, 'Damparis', 'France', 'Europe', 'FRFC0386', 0),
(0, 'Dampierre', 'France', 'Europe', 'FRBN0299', 0),
(0, 'Dampierre', 'France', 'Europe', 'FRCA0356', 0),
(0, 'Dampierre', 'France', 'Europe', 'FRFC0387', 0),
(0, 'Dampierre-en-Bray', 'France', 'Europe', 'FRHN0173', 0),
(0, 'Dampierre-en-Yvelines', 'France', 'Europe', 'FRIF0163', 0),
(0, 'Dampjoux', 'France', 'Europe', 'FRFC0388', 0),
(0, 'Dampleux', 'France', 'Europe', 'FRPI0436', 0),
(0, 'Dampmart', 'France', 'Europe', 'FRIF0164', 0),
(0, 'Dampniat', 'France', 'Europe', 'FRLI0107', 0),
(0, 'Damprichard', 'France', 'Europe', 'FRXX6173', 0),
(0, 'Dampsmesnil', 'France', 'Europe', 'FRHN0174', 0),
(0, 'Dampvitoux', 'France', 'Europe', 'FRLO0349', 0),
(0, 'Damremont', 'France', 'Europe', 'FRCA0357', 0),
(0, 'Damvillers', 'France', 'Europe', 'FRLO0350', 0),
(0, 'Damvix', 'France', 'Europe', 'FRPL0186', 0),
(0, 'Dance', 'France', 'Europe', 'FRBN0300', 0),
(0, 'Dance', 'France', 'Europe', 'FRRA0471', 0),
(0, 'Dancevoir', 'France', 'Europe', 'FRCA0358', 0),
(0, 'Dancourt', 'France', 'Europe', 'FRHN0175', 0),
(0, 'Dancourt-Popincourt', 'France', 'Europe', 'FRPI0437', 0),
(0, 'Dancy', 'France', 'Europe', 'FRCE0264', 0),
(0, 'Danestal', 'France', 'Europe', 'FRBN0301', 0),
(0, 'Dange-Saint-Romain', 'France', 'Europe', 'FRPC0286', 0),
(0, 'Dangeau', 'France', 'Europe', 'FRCE0265', 0),
(0, 'Dangers', 'France', 'Europe', 'FRCE0266', 0),
(0, 'Dangeul', 'France', 'Europe', 'FRPL0187', 0),
(0, 'Dangolsheim', 'France', 'Europe', 'FRAL0080', 0),
(0, 'Dangu', 'France', 'Europe', 'FRHN0176', 0),
(0, 'Dangy', 'France', 'Europe', 'FRBN0302', 0),
(0, 'Danizy', 'France', 'Europe', 'FRPI0438', 0),
(0, 'Danjoutin', 'France', 'Europe', 'FRMP0596', 0),
(0, 'Dannelbourg', 'France', 'Europe', 'FRLO0351', 0),
(0, 'Dannemarie', 'France', 'Europe', 'FRAL0081', 0),
(0, 'Dannemarie', 'France', 'Europe', 'FRFC0389', 0),
(0, 'Dannemarie', 'France', 'Europe', 'FRIF0165', 0),
(0, 'Dannemoine', 'France', 'Europe', 'FRBO0344', 0),
(0, 'Dannemois', 'France', 'Europe', 'FRIF0166', 0),
(0, 'Dannes', 'France', 'Europe', 'FRXX4219', 0),
(0, 'Dannevoux', 'France', 'Europe', 'FRLO0352', 0),
(0, 'Danze', 'France', 'Europe', 'FRCE0267', 0),
(0, 'Eaubonne', 'France', 'Europe', 'FRXX2285', 0),
(0, 'Eaunes', 'France', 'Europe', 'FRMP0625', 0),
(0, 'Eaux-Puiseaux', 'France', 'Europe', 'FRCA0391', 0),
(0, 'Eauze', 'France', 'Europe', 'FRMP0626', 0),
(0, 'Ebange', 'France', 'Europe', 'FRLO0402', 0),
(0, 'Ebaty', 'France', 'Europe', 'FRBO0370', 0),
(0, 'Ebblinghem', 'France', 'Europe', 'FRNC0280', 0),
(0, 'Ebeon', 'France', 'Europe', 'FRPC0295', 0),
(0, 'Ebersheim', 'France', 'Europe', 'FRAL0104', 0),
(0, 'Ebersviller', 'France', 'Europe', 'FRLO0403', 0),
(0, 'Eblange', 'France', 'Europe', 'FRLO0404', 0),
(0, 'Ebouleau', 'France', 'Europe', 'FRPI0479', 0),
(0, 'Ebreon', 'France', 'Europe', 'FRPC0296', 0),
(0, 'Ebreuil', 'France', 'Europe', 'FRAU0217', 0),
(0, 'Ecaillon', 'France', 'Europe', 'FRNC0281', 0),
(0, 'Ecajeul', 'France', 'Europe', 'FRBN0318', 0),
(0, 'Ecalles-Alix', 'France', 'Europe', 'FRHN0190', 0),
(0, 'Ecaquelon', 'France', 'Europe', 'FRHN0191', 0),
(0, 'Ecausseville', 'France', 'Europe', 'FRBN0319', 0),
(0, 'Ecauville', 'France', 'Europe', 'FRHN0192', 0),
(0, 'Echalas', 'France', 'Europe', 'FRRA0509', 0),
(0, 'Echallat', 'France', 'Europe', 'FRPC0297', 0),
(0, 'Echallon', 'France', 'Europe', 'FRRA0510', 0),
(0, 'Echalot', 'France', 'Europe', 'FRBO0371', 0),
(0, 'Echalou', 'France', 'Europe', 'FRBN0320', 0),
(0, 'Echandelys', 'France', 'Europe', 'FRXX4316', 0),
(0, 'Echannay', 'France', 'Europe', 'FRBO0372', 0),
(0, 'Echarcon', 'France', 'Europe', 'FRIF0174', 0),
(0, 'Echassieres', 'France', 'Europe', 'FRAU0218', 0),
(0, 'Echauffour', 'France', 'Europe', 'FRBN0321', 0),
(0, 'Echavanne', 'France', 'Europe', 'FRFC0413', 0),
(0, 'Echay', 'France', 'Europe', 'FRFC0414', 0),
(0, 'Echebrune', 'France', 'Europe', 'FRPC0298', 0),
(0, 'Echemines', 'France', 'Europe', 'FRCA0392', 0),
(0, 'Echemire', 'France', 'Europe', 'FRPL0204', 0),
(0, 'Echenans', 'France', 'Europe', 'FRFC0415', 0),
(0, 'Echenans-sous-Mont-Vaudois', 'France', 'Europe', 'FRFC0416', 0),
(0, 'Echenay', 'France', 'Europe', 'FRCA0393', 0),
(0, 'Echenevex', 'France', 'Europe', 'FRRA0511', 0),
(0, 'Echenon', 'France', 'Europe', 'FRBO0373', 0),
(0, 'Echenoz-la-Meline', 'France', 'Europe', 'FRFC0417', 0),
(0, 'Echenoz-le-Sec', 'France', 'Europe', 'FRFC0418', 0),
(0, 'Echery', 'France', 'Europe', 'FRAL0105', 0),
(0, 'Echevanne', 'France', 'Europe', 'FRFC0419', 0),
(0, 'Echevannes', 'France', 'Europe', 'FRBO0374', 0),
(0, 'Echevannes', 'France', 'Europe', 'FRFC0420', 0),
(0, 'Echevis', 'France', 'Europe', 'FRRA0512', 0),
(0, 'Echevronne', 'France', 'Europe', 'FRBO0375', 0),
(0, 'Echigey', 'France', 'Europe', 'FRBO0376', 0),
(0, 'Echillais', 'France', 'Europe', 'FRPC0299', 0),
(0, 'Echilleuses', 'France', 'Europe', 'FRCE0285', 0),
(0, 'Echire', 'France', 'Europe', 'FRPC0300', 0),
(0, 'Echirolles', 'France', 'Europe', 'FRXX4195', 0),
(0, 'Echouboulains', 'France', 'Europe', 'FRIF0175', 0),
(0, 'Echourgnac', 'France', 'Europe', 'FRAQ0398', 0),
(0, 'Eckartswiller', 'France', 'Europe', 'FRAL0106', 0),
(0, 'Eckbolsheim', 'France', 'Europe', 'FRXX4319', 0),
(0, 'Eckwersheim', 'France', 'Europe', 'FRAL0107', 0),
(0, 'Eclaibes', 'France', 'Europe', 'FRNC0282', 0),
(0, 'Eclaires', 'France', 'Europe', 'FRCA0394', 0),
(0, 'Eclance', 'France', 'Europe', 'FRCA0395', 0),
(0, 'Eclans-Nenon', 'France', 'Europe', 'FRFC0421', 0),
(0, 'Eclaron-Braucourt-Sainte-Liviere', 'France', 'Europe', 'FRCA0396', 0),
(0, 'Eclassan', 'France', 'Europe', 'FRRA0513', 0),
(0, 'Ecleux', 'France', 'Europe', 'FRFC0422', 0),
(0, 'Eclimeux', 'France', 'Europe', 'FRNC0283', 0),
(0, 'Eclose', 'France', 'Europe', 'FRRA0514', 0),
(0, 'Ecluzelles', 'France', 'Europe', 'FRCE0286', 0),
(0, 'Ecly', 'France', 'Europe', 'FRCA0397', 0),
(0, 'Ecoche', 'France', 'Europe', 'FRRA0515', 0),
(0, 'Ecoivres', 'France', 'Europe', 'FRNC0284', 0),
(0, 'Ecole', 'France', 'Europe', 'FRRA0516', 0),
(0, 'Ecole-Valentin', 'France', 'Europe', 'FRFC0423', 0),
(0, 'Ecollemont', 'France', 'Europe', 'FRCA0398', 0),
(0, 'Ecoman', 'France', 'Europe', 'FRCE0287', 0),
(0, 'Ecoqueneauville', 'France', 'Europe', 'FRBN0322', 0),
(0, 'Ecorcei', 'France', 'Europe', 'FRBN0323', 0),
(0, 'Ecorches', 'France', 'Europe', 'FRBN0324', 0),
(0, 'Ecordal', 'France', 'Europe', 'FRCA0399', 0),
(0, 'Ecorpain', 'France', 'Europe', 'FRPL0205', 0),
(0, 'Ecos', 'France', 'Europe', 'FRHN0193', 0),
(0, 'Fa', 'France', 'Europe', 'FRLR0227', 0),
(0, 'Faa`a', 'France', 'Europe', 'FRXX7848', 0),
(0, 'Faaite', 'France', 'Europe', 'FRXX7924', 0),
(0, 'Faaone', 'France', 'Europe', 'FRXX7866', 0),
(0, 'Fabas', 'France', 'Europe', 'FRMP0694', 0),
(0, 'Fabas', 'France', 'Europe', 'FRMP0695', 0),
(0, 'Fabas', 'France', 'Europe', 'FRMP0696', 0),
(0, 'Fabras', 'France', 'Europe', 'FRRA0553', 0),
(0, 'Fabregues', 'France', 'Europe', 'FRXX0039', 0),
(0, 'Fabrezan', 'France', 'Europe', 'FRLR0228', 0),
(0, 'Faches-Thumesnil', 'France', 'Europe', 'FRXX3724', 0),
(0, 'Fachin', 'France', 'Europe', 'FRXX5196', 0),
(0, 'Facture', 'France', 'Europe', 'FRAQ0433', 0),
(0, 'Fagnieres', 'France', 'Europe', 'FRCA0428', 0),
(0, 'Fagnon', 'France', 'Europe', 'FRCA0429', 0),
(0, 'Failly', 'France', 'Europe', 'FRLO0435', 0),
(0, 'Faimbe', 'France', 'Europe', 'FRFC0461', 0),
(0, 'Fains', 'France', 'Europe', 'FRHN0222', 0),
(0, 'Faissault', 'France', 'Europe', 'FRCA0430', 0),
(0, 'Fajoles', 'France', 'Europe', 'FRMP0697', 0),
(0, 'Fakarava', 'France', 'Europe', 'FRXX7902', 0),
(0, 'Falaise', 'France', 'Europe', 'FRCA0431', 0),
(0, 'Falck', 'France', 'Europe', 'FRLO0436', 0),
(0, 'Faleyras', 'France', 'Europe', 'FRAQ0434', 0),
(0, 'Falga', 'France', 'Europe', 'FRMP0698', 0),
(0, 'Falgueyrat', 'France', 'Europe', 'FRAQ0435', 0),
(0, 'Falicon', 'France', 'Europe', 'FRXX4688', 0),
(0, 'Falkwiller', 'France', 'Europe', 'FRAL0123', 0),
(0, 'Fallencourt', 'France', 'Europe', 'FRHN0223', 0),
(0, 'Fallerans', 'France', 'Europe', 'FRFC0462', 0),
(0, 'Falleron', 'France', 'Europe', 'FRPL0214', 0),
(0, 'Falletans', 'France', 'Europe', 'FRFC0463', 0),
(0, 'Fallon', 'France', 'Europe', 'FRFC0464', 0),
(0, 'Fals', 'France', 'Europe', 'FRAQ0436', 0),
(0, 'Falvy', 'France', 'Europe', 'FRPI0538', 0),
(0, 'Famars', 'France', 'Europe', 'FRNC0332', 0),
(0, 'Famechon', 'France', 'Europe', 'FRNC0333', 0),
(0, 'Famechon', 'France', 'Europe', 'FRPI0539', 0),
(0, 'Fameck', 'France', 'Europe', 'FRLO0437', 0),
(0, 'Familly', 'France', 'Europe', 'FRBN0349', 0),
(0, 'Fampoux', 'France', 'Europe', 'FRNC0334', 0),
(0, 'Fangatau', 'France', 'Europe', 'FRXX7903', 0),
(0, 'Fangatau Fakahina', 'France', 'Europe', 'FRXX7904', 0),
(0, 'Fanjeaux', 'France', 'Europe', 'FRLR0229', 0),
(0, 'Fanlac', 'France', 'Europe', 'FRAQ0437', 0),
(0, 'Faramans', 'France', 'Europe', 'FRRA0554', 0),
(0, 'Faramans', 'France', 'Europe', 'FRRA0555', 0),
(0, 'Farbus', 'France', 'Europe', 'FRNC0335', 0),
(0, 'Farceaux', 'France', 'Europe', 'FRHN0224', 0),
(0, 'Farebersviller', 'France', 'Europe', 'FRLO0438', 0),
(0, 'Fareins', 'France', 'Europe', 'FRRA0556', 0),
(0, 'Farges', 'France', 'Europe', 'FRRA0557', 0),
(0, 'Farges-Allichamps', 'France', 'Europe', 'FRCE0307', 0),
(0, 'Fargniers', 'France', 'Europe', 'FRPI0540', 0),
(0, 'Fargues', 'France', 'Europe', 'FRAQ0438', 0),
(0, 'Fargues', 'France', 'Europe', 'FRMP0699', 0),
(0, 'Farincourt', 'France', 'Europe', 'FRCA0432', 0),
(0, 'Farinole', 'France', 'Europe', 'FRXX3076', 0),
(0, 'Farnay', 'France', 'Europe', 'FRRA0558', 0),
(0, 'Faronville', 'France', 'Europe', 'FRCE0308', 0),
(0, 'Fatines', 'France', 'Europe', 'FRPL0215', 0),
(0, 'Fatu-Hiva', 'France', 'Europe', 'FRXX7883', 0),
(0, 'Fauch', 'France', 'Europe', 'FRMP0700', 0),
(0, 'Faucigny', 'France', 'Europe', 'FRRA0559', 0),
(0, 'Faucompierre', 'France', 'Europe', 'FRLO0439', 0),
(0, 'Faucon', 'France', 'Europe', 'FRPA0174', 0),
(0, 'Fauconcourt', 'France', 'Europe', 'FRLO0440', 0),
(0, 'Faucoucourt', 'France', 'Europe', 'FRPI0541', 0),
(0, 'Faudoas', 'France', 'Europe', 'FRMP0701', 0),
(0, 'Faugeres', 'France', 'Europe', 'FRLR0230', 0),
(0, 'Faugeres', 'France', 'Europe', 'FRRA0560', 0),
(0, 'Fauguernon', 'France', 'Europe', 'FRBN0350', 0),
(0, 'Fauguerolles', 'France', 'Europe', 'FRAQ0439', 0),
(0, 'Fauillet', 'France', 'Europe', 'FRAQ0440', 0),
(0, 'Faulquemont', 'France', 'Europe', 'FRLO0441', 0),
(0, 'Faulx', 'France', 'Europe', 'FRLO0442', 0),
(0, 'Faumont', 'France', 'Europe', 'FRNC0336', 0),
(0, 'Fauquembergues', 'France', 'Europe', 'FRNC0337', 0),
(0, 'Faurilles', 'France', 'Europe', 'FRAQ0441', 0),
(0, 'Fauroux', 'France', 'Europe', 'FRMP0702', 0),
(0, 'Fauverney', 'France', 'Europe', 'FRBO0406', 0),
(0, 'Gaas', 'France', 'Europe', 'FRAQ0469', 0),
(0, 'Gabarnac', 'France', 'Europe', 'FRAQ0470', 0),
(0, 'Gabarret', 'France', 'Europe', 'FRXX3819', 0),
(0, 'Gabas', 'France', 'Europe', 'FRAQ0471', 0),
(0, 'Gabaston', 'France', 'Europe', 'FRAQ0472', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Gabat', 'France', 'Europe', 'FRAQ0473', 0),
(0, 'Gabian', 'France', 'Europe', 'FRLR0257', 0),
(0, 'Gabillou', 'France', 'Europe', 'FRAQ0474', 0),
(0, 'Gabre', 'France', 'Europe', 'FRMP0766', 0),
(0, 'Gabriac', 'France', 'Europe', 'FRMP0767', 0),
(0, 'Gabrias', 'France', 'Europe', 'FRLR0258', 0),
(0, 'Gace', 'France', 'Europe', 'FRBN0381', 0),
(0, 'Gacogne', 'France', 'Europe', 'FRBO0455', 0),
(0, 'Gadancourt', 'France', 'Europe', 'FRIF0213', 0),
(0, 'Gadencourt', 'France', 'Europe', 'FRHN0257', 0),
(0, 'Gael', 'France', 'Europe', 'FRBR0010', 0),
(0, 'Gageac-et-Rouillac', 'France', 'Europe', 'FRAQ0475', 0),
(0, 'Gagnac-sur-Cere', 'France', 'Europe', 'FRMP0768', 0),
(0, 'Gagnac-sur-Garonne', 'France', 'Europe', 'FRMP0769', 0),
(0, 'Gagnieres', 'France', 'Europe', 'FRXX3921', 0),
(0, 'Gagny', 'France', 'Europe', 'FRXX5265', 0),
(0, 'Gahard', 'France', 'Europe', 'FRBR0011', 0),
(0, 'Gailhan', 'France', 'Europe', 'FRPA0186', 0),
(0, 'Gaillac', 'France', 'Europe', 'FRXX2092', 0),
(0, 'Gaillac-d`Aveyron', 'France', 'Europe', 'FRXX4726', 0),
(0, 'Gaillac-Toulza', 'France', 'Europe', 'FRXX4268', 0),
(0, 'Gaillagos', 'France', 'Europe', 'FRMP0770', 0),
(0, 'Gaillan-en-Medoc', 'France', 'Europe', 'FRAQ0476', 0),
(0, 'Gaillard', 'France', 'Europe', 'FRXX0460', 0),
(0, 'Gaillardbois-Cressenville', 'France', 'Europe', 'FRHN0258', 0),
(0, 'Gaillefontaine', 'France', 'Europe', 'FRXX6752', 0),
(0, 'Gailleres', 'France', 'Europe', 'FRAQ0477', 0),
(0, 'Gaillon', 'France', 'Europe', 'FRHN0259', 0),
(0, 'Gaillon-sur-Montcient', 'France', 'Europe', 'FRIF0214', 0),
(0, 'Gainneville', 'France', 'Europe', 'FRHN0260', 0),
(0, 'Gaja-et-Villedieu', 'France', 'Europe', 'FRLR0259', 0),
(0, 'Gaja-la-Selve', 'France', 'Europe', 'FRLR0260', 0),
(0, 'Gajac', 'France', 'Europe', 'FRAQ0478', 0),
(0, 'Gajan', 'France', 'Europe', 'FRMP0771', 0),
(0, 'Gajan', 'France', 'Europe', 'FRPA0187', 0),
(0, 'Gajoubert', 'France', 'Europe', 'FRLI0144', 0),
(0, 'Galametz', 'France', 'Europe', 'FRNC0378', 0),
(0, 'Galan', 'France', 'Europe', 'FRMP0772', 0),
(0, 'Galapian', 'France', 'Europe', 'FRAQ0479', 0),
(0, 'Galargues', 'France', 'Europe', 'FRLR0261', 0),
(0, 'Galeria', 'France', 'Europe', 'FRXX4828', 0),
(0, 'Galey', 'France', 'Europe', 'FRMP0773', 0),
(0, 'Galez', 'France', 'Europe', 'FRMP0774', 0),
(0, 'Galfingue', 'France', 'Europe', 'FRAL0148', 0),
(0, 'Galgan', 'France', 'Europe', 'FRMP0775', 0),
(0, 'Galgon', 'France', 'Europe', 'FRXX2791', 0),
(0, 'Galiax', 'France', 'Europe', 'FRMP0776', 0),
(0, 'Galie', 'France', 'Europe', 'FRMP0777', 0),
(0, 'Galinagues', 'France', 'Europe', 'FRLR0262', 0),
(0, 'Gallardon', 'France', 'Europe', 'FRXX3367', 0),
(0, 'Gallargues-le-Montueux', 'France', 'Europe', 'FRXX3300', 0),
(0, 'Gallician', 'France', 'Europe', 'FRPA0188', 0),
(0, 'Galluis', 'France', 'Europe', 'FRIF0215', 0),
(0, 'Gamaches', 'France', 'Europe', 'FRHN0261', 0),
(0, 'Gamaches-en-Vexin', 'France', 'Europe', 'FRHN0262', 0),
(0, 'Gamarde-les-Bains', 'France', 'Europe', 'FRAQ0480', 0),
(0, 'Gamarthe', 'France', 'Europe', 'FRAQ0481', 0),
(0, 'Gambais', 'France', 'Europe', 'FRXX4604', 0),
(0, 'Gambaiseuil', 'France', 'Europe', 'FRIF0216', 0),
(0, 'Gambier', 'France', 'Europe', 'FRXX7898', 0),
(0, 'Gambsheim', 'France', 'Europe', 'FRXX2160', 0),
(0, 'Gan', 'France', 'Europe', 'FRXX5605', 0),
(0, 'Ganac', 'France', 'Europe', 'FRMP0778', 0),
(0, 'Ganagobie', 'France', 'Europe', 'FRPA0189', 0),
(0, 'Gancourt-Saint-Etienne', 'France', 'Europe', 'FRHN0263', 0),
(0, 'Gandelain', 'France', 'Europe', 'FRBN0382', 0),
(0, 'Gandelu', 'France', 'Europe', 'FRPI0631', 0),
(0, 'Gandrange', 'France', 'Europe', 'FRXX5181', 0),
(0, 'Ganges', 'France', 'Europe', 'FRLR0263', 0),
(0, 'Gannat', 'France', 'Europe', 'FRXX1705', 0),
(0, 'Gannay-sur-Loire', 'France', 'Europe', 'FRAU0252', 0),
(0, 'Gannes', 'France', 'Europe', 'FRPI0632', 0),
(0, 'Gans', 'France', 'Europe', 'FRAQ0482', 0),
(0, 'Ganties', 'France', 'Europe', 'FRMP0779', 0),
(0, 'Ganzeville', 'France', 'Europe', 'FRHN0264', 0),
(0, 'Gap', 'France', 'Europe', 'FRXX3892', 0),
(0, 'Haamene', 'France', 'Europe', 'FRXX7880', 0),
(0, 'Habarcq', 'France', 'Europe', 'FRNC0408', 0),
(0, 'Habas', 'France', 'Europe', 'FRXX6430', 0),
(0, 'Habere-Lullin', 'France', 'Europe', 'FRRA0647', 0),
(0, 'Habere-Poche', 'France', 'Europe', 'FRRA0648', 0),
(0, 'Hablainville', 'France', 'Europe', 'FRXX1669', 0),
(0, 'Habloville', 'France', 'Europe', 'FRBN0434', 0),
(0, 'Haboudange', 'France', 'Europe', 'FRLO0600', 0),
(0, 'Habsheim', 'France', 'Europe', 'FRAL0186', 0),
(0, 'Hachan', 'France', 'Europe', 'FRMP0889', 0),
(0, 'Hacourt', 'France', 'Europe', 'FRCA0536', 0),
(0, 'Hacqueville', 'France', 'Europe', 'FRHN0319', 0),
(0, 'Hadancourt-le-Haut-Clocher', 'France', 'Europe', 'FRPI0706', 0),
(0, 'Hadigny-les-Verrieres', 'France', 'Europe', 'FRXX5967', 0),
(0, 'Hadol', 'France', 'Europe', 'FRLO0601', 0),
(0, 'Hadonville-les-Lachaussee', 'France', 'Europe', 'FRLO0602', 0),
(0, 'Haegen', 'France', 'Europe', 'FRAL0187', 0),
(0, 'Hagecourt', 'France', 'Europe', 'FRLO0603', 0),
(0, 'Hagedet', 'France', 'Europe', 'FRMP0890', 0),
(0, 'Hagen', 'France', 'Europe', 'FRLO0604', 0),
(0, 'Hagenbach', 'France', 'Europe', 'FRAL0188', 0),
(0, 'Hagenthal-le-Bas', 'France', 'Europe', 'FRAL0189', 0),
(0, 'Hagenthal-le-Haut', 'France', 'Europe', 'FRAL0190', 0),
(0, 'Haget', 'France', 'Europe', 'FRMP0891', 0),
(0, 'Hagetaubin', 'France', 'Europe', 'FRAQ0550', 0),
(0, 'Hagetmau', 'France', 'Europe', 'FRAQ0551', 0),
(0, 'Hageville', 'France', 'Europe', 'FRLO0605', 0),
(0, 'Hagneville-et-Roncourt', 'France', 'Europe', 'FRLO0606', 0),
(0, 'Hagnicourt', 'France', 'Europe', 'FRCA0537', 0),
(0, 'Hagondange', 'France', 'Europe', 'FRXX4923', 0),
(0, 'Haguenau', 'France', 'Europe', 'FRXX0042', 0),
(0, 'Haigneville', 'France', 'Europe', 'FRLO0607', 0),
(0, 'Haillainville', 'France', 'Europe', 'FRLO0608', 0),
(0, 'Hailles', 'France', 'Europe', 'FRPI0707', 0),
(0, 'Haillicourt', 'France', 'Europe', 'FRXX1207', 0),
(0, 'Haimps', 'France', 'Europe', 'FRPC0380', 0),
(0, 'Haims', 'France', 'Europe', 'FRPC0381', 0),
(0, 'Hainvillers', 'France', 'Europe', 'FRPI0708', 0),
(0, 'Haironville', 'France', 'Europe', 'FRLO0609', 0),
(0, 'Haisnes', 'France', 'Europe', 'FRXX5146', 0),
(0, 'Hakamaii', 'France', 'Europe', 'FRXX7889', 0),
(0, 'Haleine', 'France', 'Europe', 'FRBN0435', 0),
(0, 'Halinghen', 'France', 'Europe', 'FRNC0409', 0),
(0, 'Hallencourt', 'France', 'Europe', 'FRPI0709', 0),
(0, 'Hallennes-lez-Haubourdin', 'France', 'Europe', 'FRXX3009', 0),
(0, 'Hallering', 'France', 'Europe', 'FRLO0610', 0),
(0, 'Halles-sous-les-Cotes', 'France', 'Europe', 'FRLO0611', 0),
(0, 'Hallignicourt', 'France', 'Europe', 'FRCA0538', 0),
(0, 'Hallines', 'France', 'Europe', 'FRNC0410', 0),
(0, 'Halling-les-Boulay', 'France', 'Europe', 'FRLO0612', 0),
(0, 'Hallivillers', 'France', 'Europe', 'FRPI0710', 0),
(0, 'Halloville', 'France', 'Europe', 'FRLO0613', 0),
(0, 'Halloy', 'France', 'Europe', 'FRPI0711', 0),
(0, 'Halloy', 'France', 'Europe', 'FRPI0712', 0),
(0, 'Halloy-les-Pernois', 'France', 'Europe', 'FRXX5915', 0),
(0, 'Hallu', 'France', 'Europe', 'FRPI0713', 0),
(0, 'Halluin', 'France', 'Europe', 'FRXX4403', 0),
(0, 'Halsou', 'France', 'Europe', 'FRAQ0552', 0),
(0, 'Halstroff', 'France', 'Europe', 'FRLO0614', 0),
(0, 'Ham', 'France', 'Europe', 'FRXX2920', 0),
(0, 'Ham-en-Artois', 'France', 'Europe', 'FRXX1332', 0),
(0, 'Ham-les-Moines', 'France', 'Europe', 'FRCA0539', 0),
(0, 'Ham-sous-Varsberg', 'France', 'Europe', 'FRXX5161', 0),
(0, 'Ham-sur-Meuse', 'France', 'Europe', 'FRCA0540', 0),
(0, 'Hamars', 'France', 'Europe', 'FRBN0436', 0),
(0, 'Hambach', 'France', 'Europe', 'FRXX5191', 0),
(0, 'Hambers', 'France', 'Europe', 'FRPL0262', 0),
(0, 'Hamblain-les-Pres', 'France', 'Europe', 'FRNC0411', 0),
(0, 'Hambye', 'France', 'Europe', 'FRXX5973', 0),
(0, 'Hamel', 'France', 'Europe', 'FRXX4500', 0),
(0, 'Hamelet', 'France', 'Europe', 'FRPI0714', 0),
(0, 'Hamelin', 'France', 'Europe', 'FRBN0437', 0),
(0, 'Hamelincourt', 'France', 'Europe', 'FRNC0412', 0),
(0, 'Hames-Boucres', 'France', 'Europe', 'FRNC0413', 0),
(0, 'Hammeville', 'France', 'Europe', 'FRLO0615', 0),
(0, 'Hamonville', 'France', 'Europe', 'FRLO0616', 0),
(0, 'Hampigny', 'France', 'Europe', 'FRCA0541', 0),
(0, 'Hampont', 'France', 'Europe', 'FRLO0617', 0),
(0, 'Han-devant-Pierrepont', 'France', 'Europe', 'FRLO0618', 0),
(0, 'Han-les-Juvigny', 'France', 'Europe', 'FRLO0619', 0),
(0, 'Han-sur-Meuse', 'France', 'Europe', 'FRLO0620', 0),
(0, 'Ibarrolle', 'France', 'Europe', 'FRAQ0577', 0),
(0, 'Ibigny', 'France', 'Europe', 'FRLO0710', 0),
(0, 'Ibos', 'France', 'Europe', 'FRXX3413', 0),
(0, 'Ichtratzheim', 'France', 'Europe', 'FRAL0240', 0),
(0, 'Ichy', 'France', 'Europe', 'FRIF0258', 0),
(0, 'Idaux-Mendy', 'France', 'Europe', 'FRAQ0578', 0),
(0, 'Idrac-Respailles', 'France', 'Europe', 'FRMP0908', 0),
(0, 'Idron', 'France', 'Europe', 'FRXX6315', 0),
(0, 'Ids-Saint-Roch', 'France', 'Europe', 'FRCE0402', 0),
(0, 'Iffendic', 'France', 'Europe', 'FRXX6474', 0),
(0, 'Ifs', 'France', 'Europe', 'FRXX2424', 0),
(0, 'Ige', 'France', 'Europe', 'FRBN0468', 0),
(0, 'Ige', 'France', 'Europe', 'FRBO0516', 0),
(0, 'Ignaucourt', 'France', 'Europe', 'FRPI0777', 0),
(0, 'Ignaux', 'France', 'Europe', 'FRMP0909', 0),
(0, 'Igney', 'France', 'Europe', 'FRLO0711', 0),
(0, 'Igney', 'France', 'Europe', 'FRLO0712', 0),
(0, 'Ignol', 'France', 'Europe', 'FRCE0403', 0),
(0, 'Igny', 'France', 'Europe', 'FRFC0594', 0),
(0, 'Igny', 'France', 'Europe', 'FRXX1543', 0),
(0, 'Igny-Comblizy', 'France', 'Europe', 'FRCA0582', 0),
(0, 'Igon', 'France', 'Europe', 'FRAQ0579', 0),
(0, 'Igornay', 'France', 'Europe', 'FRBO0517', 0),
(0, 'Igoville', 'France', 'Europe', 'FRXX4024', 0),
(0, 'Iguerande', 'France', 'Europe', 'FRBO0518', 0),
(0, 'Iholdy', 'France', 'Europe', 'FRAQ0580', 0),
(0, 'Ile Napoleon', 'France', 'Europe', 'FRAL0241', 0),
(0, 'Ile Rousse', 'France', 'Europe', 'FRXX0156', 0),
(0, 'Ile-aux-Moines', 'France', 'Europe', 'FRXX1499', 0),
(0, 'Ile-d`Aix', 'France', 'Europe', 'FRXX3979', 0),
(0, 'Ile-d`Arz', 'France', 'Europe', 'FRXX1500', 0),
(0, 'Ile-d`Houat', 'France', 'Europe', 'FRBR0057', 0),
(0, 'Ile-de-Batz', 'France', 'Europe', 'FRXX0155', 0),
(0, 'Ile-de-Brehat', 'France', 'Europe', 'FRXX2508', 0),
(0, 'Ile-de-Sein', 'France', 'Europe', 'FRXX3956', 0),
(0, 'Ile-des-Pins', 'France', 'Europe', 'FRXX7952', 0),
(0, 'Ile-Molene', 'France', 'Europe', 'FRXX6159', 0),
(0, 'Ile-Tudy', 'France', 'Europe', 'FRXX1047', 0),
(0, 'Ilhan', 'France', 'Europe', 'FRMP0910', 0),
(0, 'Ilharre', 'France', 'Europe', 'FRAQ0581', 0),
(0, 'Ilhat', 'France', 'Europe', 'FRMP0911', 0),
(0, 'Ilheu', 'France', 'Europe', 'FRMP0912', 0),
(0, 'Illange', 'France', 'Europe', 'FRLO0713', 0),
(0, 'Illartein', 'France', 'Europe', 'FRMP0913', 0),
(0, 'Illats', 'France', 'Europe', 'FRAQ0582', 0),
(0, 'Ille-sur-Tet', 'France', 'Europe', 'FRXX5309', 0),
(0, 'Illeville-sur-Montfort', 'France', 'Europe', 'FRHN0363', 0),
(0, 'Illfurth', 'France', 'Europe', 'FRAL0242', 0),
(0, 'Illhaeusern', 'France', 'Europe', 'FRAL0243', 0),
(0, 'Illiat', 'France', 'Europe', 'FRRA0661', 0),
(0, 'Illier-et-Laramade', 'France', 'Europe', 'FRMP0914', 0),
(0, 'Illiers-Combray', 'France', 'Europe', 'FRCE0404', 0),
(0, 'Illiers-l`Eveque', 'France', 'Europe', 'FRXX6240', 0),
(0, 'Illies', 'France', 'Europe', 'FRNC0482', 0),
(0, 'Illifaut', 'France', 'Europe', 'FRBR0058', 0),
(0, 'Illkirch-Graffenstaden', 'France', 'Europe', 'FRXX2159', 0),
(0, 'Illois', 'France', 'Europe', 'FRHN0364', 0),
(0, 'Illoud', 'France', 'Europe', 'FRCA0583', 0),
(0, 'Illy', 'France', 'Europe', 'FRCA0584', 0),
(0, 'Illzach', 'France', 'Europe', 'FRXX5812', 0),
(0, 'Ilonse', 'France', 'Europe', 'FRPA0212', 0),
(0, 'Imbleville', 'France', 'Europe', 'FRHN0365', 0),
(0, 'Imbsheim', 'France', 'Europe', 'FRAL0244', 0),
(0, 'Imecourt', 'France', 'Europe', 'FRCA0585', 0),
(0, 'Imling', 'France', 'Europe', 'FRLO0714', 0),
(0, 'Imphy', 'France', 'Europe', 'FRBO0519', 0),
(0, 'Inaumont', 'France', 'Europe', 'FRCA0586', 0),
(0, 'Incarville', 'France', 'Europe', 'FRHN0366', 0),
(0, 'Incheville', 'France', 'Europe', 'FRXX2089', 0),
(0, 'Inchy', 'France', 'Europe', 'FRXX5059', 0),
(0, 'Inchy-en-Artois', 'France', 'Europe', 'FRXX2637', 0),
(0, 'Incourt', 'France', 'Europe', 'FRNC0483', 0),
(0, 'Indevillers', 'France', 'Europe', 'FRFC0595', 0),
(0, 'Indret', 'France', 'Europe', 'FRPL0267', 0),
(0, 'Ineuil', 'France', 'Europe', 'FRCE0405', 0),
(0, 'Infreville', 'France', 'Europe', 'FRHN0367', 0),
(0, 'Ingenheim', 'France', 'Europe', 'FRAL0245', 0),
(0, 'Ingersheim', 'France', 'Europe', 'FRXX6597', 0),
(0, 'Inghem', 'France', 'Europe', 'FRNC0484', 0),
(0, 'Inglange', 'France', 'Europe', 'FRLO0715', 0),
(0, 'Ingolsheim', 'France', 'Europe', 'FRAL0246', 0),
(0, 'Jablines', 'France', 'Europe', 'FRIF0262', 0),
(0, 'Jabreilles-les-Bordes', 'France', 'Europe', 'FRLI0161', 0),
(0, 'Jabrun', 'France', 'Europe', 'FRAU0281', 0),
(0, 'Jacob-Bellecombette', 'France', 'Europe', 'FRXX6419', 0),
(0, 'Jacou', 'France', 'Europe', 'FRXX1880', 0),
(0, 'Jacque', 'France', 'Europe', 'FRMP0922', 0),
(0, 'Jagny-sous-Bois', 'France', 'Europe', 'FRIF0263', 0),
(0, 'Jaignes', 'France', 'Europe', 'FRIF0264', 0),
(0, 'Jaillans', 'France', 'Europe', 'FRRA0673', 0),
(0, 'Jaillon', 'France', 'Europe', 'FRLO0724', 0),
(0, 'Jailly', 'France', 'Europe', 'FRBO0527', 0),
(0, 'Jailly-les-Moulins', 'France', 'Europe', 'FRBO0528', 0),
(0, 'Jainvillotte', 'France', 'Europe', 'FRLO0725', 0),
(0, 'Jalesches', 'France', 'Europe', 'FRLI0162', 0),
(0, 'Jaleyrac', 'France', 'Europe', 'FRAU0282', 0),
(0, 'Jaligny-sur-Besbre', 'France', 'Europe', 'FRAU0283', 0),
(0, 'Jallais', 'France', 'Europe', 'FRXX3766', 0),
(0, 'Jallanges', 'France', 'Europe', 'FRBO0529', 0),
(0, 'Jallans', 'France', 'Europe', 'FRCE0414', 0),
(0, 'Jallaucourt', 'France', 'Europe', 'FRLO0726', 0),
(0, 'Jallerange', 'France', 'Europe', 'FRFC0599', 0),
(0, 'Jallieu', 'France', 'Europe', 'FRRA0674', 0),
(0, 'Jalognes', 'France', 'Europe', 'FRCE0415', 0),
(0, 'Jalogny', 'France', 'Europe', 'FRBO0530', 0),
(0, 'Jalons', 'France', 'Europe', 'FRCA0593', 0),
(0, 'Jambles', 'France', 'Europe', 'FRBO0531', 0),
(0, 'Jambville', 'France', 'Europe', 'FRIF0265', 0),
(0, 'Jamericourt', 'France', 'Europe', 'FRPI0783', 0),
(0, 'Jametz', 'France', 'Europe', 'FRLO0727', 0),
(0, 'Jameyzieu', 'France', 'Europe', 'FRRA0675', 0),
(0, 'Janailhac', 'France', 'Europe', 'FRLI0163', 0),
(0, 'Janaillat', 'France', 'Europe', 'FRLI0164', 0),
(0, 'Jancigny', 'France', 'Europe', 'FRBO0532', 0),
(0, 'Jandun', 'France', 'Europe', 'FRCA0594', 0),
(0, 'Janneyrias', 'France', 'Europe', 'FRRA0676', 0),
(0, 'Jans', 'France', 'Europe', 'FRPL0269', 0),
(0, 'Jansac', 'France', 'Europe', 'FRRA0677', 0),
(0, 'Janville', 'France', 'Europe', 'FRCE0416', 0),
(0, 'Janville', 'France', 'Europe', 'FRPI0784', 0),
(0, 'Janville', 'France', 'Europe', 'FRXX1807', 0),
(0, 'Janville-sur-Juine', 'France', 'Europe', 'FRXX4510', 0),
(0, 'Janvilliers', 'France', 'Europe', 'FRCA0595', 0),
(0, 'Janvry', 'France', 'Europe', 'FRCA0596', 0),
(0, 'Janvry', 'France', 'Europe', 'FRIF0266', 0),
(0, 'Janze', 'France', 'Europe', 'FRXX2573', 0),
(0, 'Jarcieu', 'France', 'Europe', 'FRRA0678', 0),
(0, 'Jard-sur-Mer', 'France', 'Europe', 'FRXX3831', 0),
(0, 'Jardin', 'France', 'Europe', 'FRRA0679', 0),
(0, 'Jardres', 'France', 'Europe', 'FRPC0388', 0),
(0, 'Jargeau', 'France', 'Europe', 'FRXX1301', 0),
(0, 'Jarjayes', 'France', 'Europe', 'FRPA0214', 0),
(0, 'Jarmenil', 'France', 'Europe', 'FRLO0728', 0),
(0, 'Jarnac', 'France', 'Europe', 'FRPC0389', 0),
(0, 'Jarnac-Champagne', 'France', 'Europe', 'FRXX4740', 0),
(0, 'Jarnages', 'France', 'Europe', 'FRLI0165', 0),
(0, 'Jarnioux', 'France', 'Europe', 'FRRA0680', 0),
(0, 'Jarnosse', 'France', 'Europe', 'FRRA0681', 0),
(0, 'Jarny', 'France', 'Europe', 'FRLO0729', 0),
(0, 'Jarret', 'France', 'Europe', 'FRMP0923', 0),
(0, 'Jarrie', 'France', 'Europe', 'FRXX5004', 0),
(0, 'Jarrier', 'France', 'Europe', 'FRRA0682', 0),
(0, 'Jars', 'France', 'Europe', 'FRCE0417', 0),
(0, 'Jarsy', 'France', 'Europe', 'FRRA0683', 0),
(0, 'Jarville-la-Malgrange', 'France', 'Europe', 'FRXX6807', 0),
(0, 'Jarze', 'France', 'Europe', 'FRPL0270', 0),
(0, 'Jas', 'France', 'Europe', 'FRRA0684', 0),
(0, 'Jasney', 'France', 'Europe', 'FRFC0600', 0),
(0, 'Jassans-Riottier', 'France', 'Europe', 'FRXX4129', 0),
(0, 'Jasseines', 'France', 'Europe', 'FRCA0597', 0),
(0, 'Jasseron', 'France', 'Europe', 'FRRA0685', 0),
(0, 'Jasses', 'France', 'Europe', 'FRAQ0590', 0),
(0, 'Jatxou', 'France', 'Europe', 'FRAQ0591', 0),
(0, 'Jau-Dignac-et-Loirac', 'France', 'Europe', 'FRAQ0592', 0),
(0, 'Jaucourt', 'France', 'Europe', 'FRCA0598', 0),
(0, 'Jaudrais', 'France', 'Europe', 'FRCE0418', 0),
(0, 'Jaujac', 'France', 'Europe', 'FRRA0686', 0),
(0, 'Jauldes', 'France', 'Europe', 'FRXX1062', 0),
(0, 'Jaulges', 'France', 'Europe', 'FRBO0533', 0),
(0, 'Jaulgonne', 'France', 'Europe', 'FRPI0785', 0),
(0, 'Jaulnay', 'France', 'Europe', 'FRCE0419', 0),
(0, 'Jaulnes', 'France', 'Europe', 'FRIF0267', 0),
(0, 'Kaala-Gomen', 'France', 'Europe', 'FRXX7938', 0),
(0, 'Kalhausen', 'France', 'Europe', 'FRLO0755', 0),
(0, 'Kaltenhouse', 'France', 'Europe', 'FRAL0257', 0),
(0, 'Kanfen', 'France', 'Europe', 'FRLO0756', 0),
(0, 'Kani-Keli', 'France', 'Europe', 'FRXX7837', 0),
(0, 'Kappelen', 'France', 'Europe', 'FRAL0258', 0),
(0, 'Kappelkinger', 'France', 'Europe', 'FRLO0757', 0),
(0, 'Katiu', 'France', 'Europe', 'FRXX7927', 0),
(0, 'Katzenthal', 'France', 'Europe', 'FRAL0259', 0),
(0, 'Kauehi', 'France', 'Europe', 'FRXX7925', 0),
(0, 'Kauffenheim', 'France', 'Europe', 'FRAL0260', 0),
(0, 'Kaukura', 'France', 'Europe', 'FRXX7923', 0),
(0, 'Kaw', 'France', 'Europe', 'FRXX7788', 0),
(0, 'Kaysersberg', 'France', 'Europe', 'FRXX2178', 0),
(0, 'Kedange-sur-Canner', 'France', 'Europe', 'FRXX1487', 0),
(0, 'Keffenach', 'France', 'Europe', 'FRAL0261', 0),
(0, 'Kembs', 'France', 'Europe', 'FRXX1195', 0),
(0, 'Kemplich', 'France', 'Europe', 'FRLO0758', 0),
(0, 'Kerbach', 'France', 'Europe', 'FRXX1952', 0),
(0, 'Kerbors', 'France', 'Europe', 'FRBR0065', 0),
(0, 'Kerfot', 'France', 'Europe', 'FRBR0066', 0),
(0, 'Kerfourn', 'France', 'Europe', 'FRBR0067', 0),
(0, 'Kergloff', 'France', 'Europe', 'FRBR0068', 0),
(0, 'Kergrist', 'France', 'Europe', 'FRBR0069', 0),
(0, 'Kergrist-Moelou', 'France', 'Europe', 'FRBR0070', 0),
(0, 'Kerhostin', 'France', 'Europe', 'FRBR0071', 0),
(0, 'Kerien', 'France', 'Europe', 'FRBR0072', 0),
(0, 'Kerlaz', 'France', 'Europe', 'FRBR0073', 0),
(0, 'Kerling-les-Sierck', 'France', 'Europe', 'FRLO0759', 0),
(0, 'Kerlouan', 'France', 'Europe', 'FRXX3953', 0),
(0, 'Kermaria-Sulard', 'France', 'Europe', 'FRBR0074', 0),
(0, 'Kermoroc`h', 'France', 'Europe', 'FRBR0075', 0),
(0, 'Kermouster', 'France', 'Europe', 'FRBR0076', 0),
(0, 'Kernascleden', 'France', 'Europe', 'FRBR0077', 0),
(0, 'Kernevel', 'France', 'Europe', 'FRBR0078', 0),
(0, 'Kernilis', 'France', 'Europe', 'FRBR0079', 0),
(0, 'Kernoues', 'France', 'Europe', 'FRBR0080', 0),
(0, 'Kerpert', 'France', 'Europe', 'FRBR0081', 0),
(0, 'Kerprich-aux-Bois', 'France', 'Europe', 'FRLO0760', 0),
(0, 'Kersaint-Plabennec', 'France', 'Europe', 'FRBR0082', 0),
(0, 'Kertugal', 'France', 'Europe', 'FRBR0083', 0),
(0, 'Kertzfeld', 'France', 'Europe', 'FRXX6551', 0),
(0, 'Kervignac', 'France', 'Europe', 'FRBR0084', 0),
(0, 'Keskastel', 'France', 'Europe', 'FRAL0262', 0),
(0, 'Kesseldorf', 'France', 'Europe', 'FRXX4436', 0),
(0, 'Kienheim', 'France', 'Europe', 'FRAL0263', 0),
(0, 'Kientzheim', 'France', 'Europe', 'FRAL0264', 0),
(0, 'Kiffis', 'France', 'Europe', 'FRAL0265', 0),
(0, 'Killem', 'France', 'Europe', 'FRNC0493', 0),
(0, 'Kilstett', 'France', 'Europe', 'FRXX6595', 0),
(0, 'Kindwiller', 'France', 'Europe', 'FRAL0266', 0),
(0, 'Kingersheim', 'France', 'Europe', 'FRXX6612', 0),
(0, 'Kintzheim', 'France', 'Europe', 'FRAL0267', 0),
(0, 'Kirchberg', 'France', 'Europe', 'FRAL0268', 0),
(0, 'Kirchheim', 'France', 'Europe', 'FRAL0269', 0),
(0, 'Kirrberg', 'France', 'Europe', 'FRXX2869', 0),
(0, 'Kirrwiller-Bosselshausen', 'France', 'Europe', 'FRAL0270', 0),
(0, 'Kirsch-les-Sierck', 'France', 'Europe', 'FRLO0761', 0),
(0, 'Kirschnaumen', 'France', 'Europe', 'FRLO0762', 0),
(0, 'Kirviller', 'France', 'Europe', 'FRLO0763', 0),
(0, 'Klang', 'France', 'Europe', 'FRLO0764', 0),
(0, 'Kleinfrankenheim', 'France', 'Europe', 'FRAL0271', 0),
(0, 'Kleingoeft', 'France', 'Europe', 'FRAL0272', 0),
(0, 'Klingenthal', 'France', 'Europe', 'FRAL0273', 0),
(0, 'Knoeringue', 'France', 'Europe', 'FRAL0274', 0),
(0, 'Knoersheim', 'France', 'Europe', 'FRAL0275', 0),
(0, 'Knutange', 'France', 'Europe', 'FRLO0765', 0),
(0, 'Koeking', 'France', 'Europe', 'FRLO0766', 0),
(0, 'Koenigsmacker', 'France', 'Europe', 'FRLO0767', 0),
(0, 'Koestlach', 'France', 'Europe', 'FRAL0276', 0),
(0, 'Koetzingue', 'France', 'Europe', 'FRAL0277', 0),
(0, 'Koeur-la-Grande', 'France', 'Europe', 'FRLO0768', 0),
(0, 'Koeur-la-Petite', 'France', 'Europe', 'FRLO0769', 0),
(0, 'Kogenheim', 'France', 'Europe', 'FRAL0278', 0),
(0, 'Kolbsheim', 'France', 'Europe', 'FRAL0279', 0),
(0, 'Kone', 'France', 'Europe', 'FRXX7956', 0),
(0, 'Kouaoua', 'France', 'Europe', 'FRXX7939', 0),
(0, 'Koumac', 'France', 'Europe', 'FRXX7955', 0),
(0, 'Koungou', 'France', 'Europe', 'FRXX7834', 0),
(0, 'Kourou', 'France', 'Europe', 'FRXX7772', 0),
(0, 'Krafft', 'France', 'Europe', 'FRAL0280', 0),
(0, 'L`Abergement-Clemenciat', 'France', 'Europe', 'FRRA0704', 0),
(0, 'L`Abergement-de-Cuisery', 'France', 'Europe', 'FRXX4982', 0),
(0, 'L`Abergement-de-Varey', 'France', 'Europe', 'FRRA0705', 0),
(0, 'L`Abergement-Sainte-Colombe', 'France', 'Europe', 'FRBO0552', 0),
(0, 'L`Absie', 'France', 'Europe', 'FRPC0407', 0),
(0, 'L`Aigle', 'France', 'Europe', 'FRBN0480', 0),
(0, 'L`Aiguillon', 'France', 'Europe', 'FRMP0939', 0),
(0, 'L`Aiguillon-sur-Mer', 'France', 'Europe', 'FRPL0286', 0),
(0, 'L`Aiguillon-sur-Vie', 'France', 'Europe', 'FRPL0287', 0),
(0, 'L`Ajoupa-Bouillon', 'France', 'Europe', 'FRXX7746', 0),
(0, 'L`Albenc', 'France', 'Europe', 'FRRA0706', 0),
(0, 'L`Alpe-d`Huez', 'France', 'Europe', 'FRXX0230', 0),
(0, 'L`Arbresle', 'France', 'Europe', 'FRRA0707', 0),
(0, 'L`Argentiere-la-Bessee', 'France', 'Europe', 'FRPA0217', 0),
(0, 'L`Aubepin', 'France', 'Europe', 'FRFC0606', 0),
(0, 'L`Ecaille', 'France', 'Europe', 'FRCA0620', 0),
(0, 'L`Echelle', 'France', 'Europe', 'FRCA0621', 0),
(0, 'L`Echelle-Saint-Aurin', 'France', 'Europe', 'FRPI0800', 0),
(0, 'L`Ecouvotte', 'France', 'Europe', 'FRFC0607', 0),
(0, 'L`Eglise-aux-Bois', 'France', 'Europe', 'FRLI0170', 0),
(0, 'L`Eguille', 'France', 'Europe', 'FRPC0408', 0),
(0, 'L`Epinay-le-Comte', 'France', 'Europe', 'FRBN0481', 0),
(0, 'L`Epine', 'France', 'Europe', 'FRCA0622', 0),
(0, 'L`Epine', 'France', 'Europe', 'FRPA0218', 0),
(0, 'L`Epine', 'France', 'Europe', 'FRXX1418', 0),
(0, 'L`Epine-aux-Bois', 'France', 'Europe', 'FRPI0801', 0),
(0, 'L`Escale', 'France', 'Europe', 'FRXX6110', 0),
(0, 'L`Escarene', 'France', 'Europe', 'FRPA0219', 0),
(0, 'L`Estrechure', 'France', 'Europe', 'FRLR0299', 0),
(0, 'L`Etang-Bertrand', 'France', 'Europe', 'FRBN0482', 0),
(0, 'L`Etang-la-Ville', 'France', 'Europe', 'FRXX2130', 0),
(0, 'L`Etang-Sale', 'France', 'Europe', 'FRXX7812', 0),
(0, 'L`Etang-Vergy', 'France', 'Europe', 'FRBO0553', 0),
(0, 'L`Etoile', 'France', 'Europe', 'FRFC0608', 0),
(0, 'L`Etoile', 'France', 'Europe', 'FRXX5373', 0),
(0, 'L`Habit', 'France', 'Europe', 'FRHN0378', 0),
(0, 'L`Hay-les-Roses', 'France', 'Europe', 'FRXX1568', 0),
(0, 'L`Herbergement', 'France', 'Europe', 'FRPL0288', 0),
(0, 'L`Herm', 'France', 'Europe', 'FRMP0940', 0),
(0, 'L`Hermenault', 'France', 'Europe', 'FRPL0289', 0),
(0, 'L`Hermitage', 'France', 'Europe', 'FRBR0085', 0),
(0, 'L`Hermitage-Lorge', 'France', 'Europe', 'FRBR0086', 0),
(0, 'L`Hermitiere', 'France', 'Europe', 'FRBN0483', 0),
(0, 'L`Home-Chamondot', 'France', 'Europe', 'FRBN0484', 0),
(0, 'L`Honor-de-Cos', 'France', 'Europe', 'FRMP0941', 0),
(0, 'L`Hopital', 'France', 'Europe', 'FRXX1953', 0),
(0, 'L`Hopital-d`Orion', 'France', 'Europe', 'FRAQ0606', 0),
(0, 'L`Hopital-du-Grosbois', 'France', 'Europe', 'FRFC0610', 0),
(0, 'L`Hopital-le-Grand', 'France', 'Europe', 'FRRA0708', 0),
(0, 'L`Hopital-le-Mercier', 'France', 'Europe', 'FRBO0554', 0),
(0, 'L`Hopital-Saint-Blaise', 'France', 'Europe', 'FRAQ0605', 0),
(0, 'L`Hopital-Saint-Lieffroy', 'France', 'Europe', 'FRFC0609', 0),
(0, 'L`Hopital-sous-Rochefort', 'France', 'Europe', 'FRRA0709', 0),
(0, 'L`Horme', 'France', 'Europe', 'FRXX5840', 0),
(0, 'L`Hosmes', 'France', 'Europe', 'FRHN0379', 0),
(0, 'L`Hospitalet', 'France', 'Europe', 'FRPA0220', 0),
(0, 'L`Hospitalet-du-Larzac', 'France', 'Europe', 'FRMP0942', 0),
(0, 'L`Hospitalet-pres-l`Andorre', 'France', 'Europe', 'FRXX1533', 0),
(0, 'L`Hotellerie', 'France', 'Europe', 'FRBN0485', 0),
(0, 'L`Hotellerie-de-Flee', 'France', 'Europe', 'FRPL0290', 0),
(0, 'L`Houmeau', 'France', 'Europe', 'FRPC0409', 0),
(0, 'L`Huisserie', 'France', 'Europe', 'FRPL0291', 0),
(0, 'L`Ile-Bouchard', 'France', 'Europe', 'FRCE0427', 0),
(0, 'L`Ile-d`Elle', 'France', 'Europe', 'FRPC0410', 0),
(0, 'L`Ile-d`Olonne', 'France', 'Europe', 'FRPL0292', 0),
(0, 'L`Ile-d`Yeu', 'France', 'Europe', 'FRPL0293', 0),
(0, 'L`Ile-Rousse', 'France', 'Europe', 'FRCO0085', 0),
(0, 'L`Ile-Saint-Denis', 'France', 'Europe', 'FRXX2986', 0),
(0, 'L`Isle-Adam', 'France', 'Europe', 'FRXX2379', 0),
(0, 'L`Isle-Arne', 'France', 'Europe', 'FRMP0943', 0),
(0, 'L`Isle-Bouzon', 'France', 'Europe', 'FRMP0944', 0),
(0, 'L`Isle-d`Abeau', 'France', 'Europe', 'FRXX3418', 0),
(0, 'L`Isle-d`Espagnac', 'France', 'Europe', 'FRXX5497', 0),
(0, 'L`Isle-de-Noe', 'France', 'Europe', 'FRMP0945', 0),
(0, 'L`Isle-en-Dodon', 'France', 'Europe', 'FRMP0946', 0),
(0, 'L`Isle-Jourdain', 'France', 'Europe', 'FRPC0411', 0),
(0, 'L`Isle-Jourdain', 'France', 'Europe', 'FRXX0332', 0),
(0, 'L`Isle-sur-la-Sorgue', 'France', 'Europe', 'FRPA0221', 0),
(0, 'L`Isle-sur-le-Doubs', 'France', 'Europe', 'FRFC0611', 0),
(0, 'L`Isle-sur-Serein', 'France', 'Europe', 'FRBO0555', 0),
(0, 'L`Oie', 'France', 'Europe', 'FRPL0294', 0),
(0, 'Maast-et-Violaine', 'France', 'Europe', 'FRPI0989', 0),
(0, 'Maatz', 'France', 'Europe', 'FRCA0810', 0),
(0, 'Mably', 'France', 'Europe', 'FRRA1016', 0),
(0, 'Macau', 'France', 'Europe', 'FRXX6507', 0),
(0, 'Macaye', 'France', 'Europe', 'FRAQ0854', 0),
(0, 'Mace', 'France', 'Europe', 'FRBN0782', 0),
(0, 'Macey', 'France', 'Europe', 'FRBN0783', 0),
(0, 'Macey', 'France', 'Europe', 'FRCA0811', 0),
(0, 'Machault', 'France', 'Europe', 'FRCA0812', 0),
(0, 'Machault', 'France', 'Europe', 'FRXX6618', 0),
(0, 'Mache', 'France', 'Europe', 'FRPL0524', 0),
(0, 'Machecoul', 'France', 'Europe', 'FRXX5720', 0),
(0, 'Machecourt', 'France', 'Europe', 'FRPI0990', 0),
(0, 'Machemont', 'France', 'Europe', 'FRPI0991', 0),
(0, 'Macheren', 'France', 'Europe', 'FRLO0959', 0),
(0, 'Machezal', 'France', 'Europe', 'FRRA1017', 0),
(0, 'Machiel', 'France', 'Europe', 'FRPI0992', 0),
(0, 'Machilly', 'France', 'Europe', 'FRRA1018', 0),
(0, 'Machy', 'France', 'Europe', 'FRCA0813', 0),
(0, 'Machy', 'France', 'Europe', 'FRPI0993', 0),
(0, 'Macinaggio', 'France', 'Europe', 'FRXX2556', 0),
(0, 'Mackenheim', 'France', 'Europe', 'FRAL0325', 0),
(0, 'Mackwiller', 'France', 'Europe', 'FRAL0326', 0),
(0, 'Maclas', 'France', 'Europe', 'FRRA1019', 0),
(0, 'Maclaunay', 'France', 'Europe', 'FRCA0814', 0),
(0, 'Macogny', 'France', 'Europe', 'FRPI0994', 0),
(0, 'Macon', 'France', 'Europe', 'FRXX0056', 0),
(0, 'Maconcourt', 'France', 'Europe', 'FRCA0815', 0),
(0, 'Maconcourt', 'France', 'Europe', 'FRLO0960', 0),
(0, 'Maconge', 'France', 'Europe', 'FRBO0695', 0),
(0, 'Macornay', 'France', 'Europe', 'FRFC0798', 0),
(0, 'Macot-la-Plagne', 'France', 'Europe', 'FRRA1020', 0),
(0, 'Macouria', 'France', 'Europe', 'FRXX7790', 0),
(0, 'Macqueville', 'France', 'Europe', 'FRPC0569', 0),
(0, 'Macquigny', 'France', 'Europe', 'FRPI0995', 0),
(0, 'Madaillan', 'France', 'Europe', 'FRAQ0855', 0),
(0, 'Madecourt', 'France', 'Europe', 'FRLO0961', 0),
(0, 'Madegney', 'France', 'Europe', 'FRLO0962', 0),
(0, 'Madic', 'France', 'Europe', 'FRAU0433', 0),
(0, 'Madiere', 'France', 'Europe', 'FRMP1315', 0),
(0, 'Madirac', 'France', 'Europe', 'FRAQ0856', 0),
(0, 'Madiran', 'France', 'Europe', 'FRMP1316', 0),
(0, 'Madonne-et-Lamerey', 'France', 'Europe', 'FRLO0963', 0),
(0, 'Madranges', 'France', 'Europe', 'FRXX5495', 0),
(0, 'Madre', 'France', 'Europe', 'FRPL0525', 0),
(0, 'Madriat', 'France', 'Europe', 'FRAU0434', 0),
(0, 'Mael-Carhaix', 'France', 'Europe', 'FRXX4019', 0),
(0, 'Mael-Pestivien', 'France', 'Europe', 'FRBR0292', 0),
(0, 'Maennolsheim', 'France', 'Europe', 'FRAL0327', 0),
(0, 'Maffliers', 'France', 'Europe', 'FRIF0353', 0),
(0, 'Maffrecourt', 'France', 'Europe', 'FRCA0816', 0),
(0, 'Magagnosc', 'France', 'Europe', 'FRXX1017', 0),
(0, 'Magalas', 'France', 'Europe', 'FRLR0432', 0),
(0, 'Magenta', 'France', 'Europe', 'FRCA0817', 0),
(0, 'Magescq', 'France', 'Europe', 'FRAQ0857', 0),
(0, 'Magland', 'France', 'Europe', 'FRRA1021', 0),
(0, 'Magnac-Bourg', 'France', 'Europe', 'FRLI0259', 0),
(0, 'Magnac-Laval', 'France', 'Europe', 'FRXX4387', 0),
(0, 'Magnac-Lavalette-Villars', 'France', 'Europe', 'FRPC0570', 0),
(0, 'Magnac-sur-Touvre', 'France', 'Europe', 'FRPC0571', 0),
(0, 'Magnan', 'France', 'Europe', 'FRMP1317', 0),
(0, 'Magnant', 'France', 'Europe', 'FRCA0818', 0),
(0, 'Magnanville', 'France', 'Europe', 'FRIF0354', 0),
(0, 'Magnas', 'France', 'Europe', 'FRMP1318', 0),
(0, 'Magnat-l`Etrange', 'France', 'Europe', 'FRLI0260', 0),
(0, 'Magne', 'France', 'Europe', 'FRXX6770', 0),
(0, 'Magnet', 'France', 'Europe', 'FRAU0435', 0),
(0, 'Magneux', 'France', 'Europe', 'FRCA0819', 0),
(0, 'Magneux', 'France', 'Europe', 'FRCA0820', 0),
(0, 'Magneux-Haute-Rive', 'France', 'Europe', 'FRRA1022', 0),
(0, 'Magneville', 'France', 'Europe', 'FRBN0784', 0),
(0, 'Magnicourt', 'France', 'Europe', 'FRCA0821', 0),
(0, 'Magnicourt-en-Comte', 'France', 'Europe', 'FRNC0579', 0),
(0, 'Magnicourt-sur-Canche', 'France', 'Europe', 'FRNC0580', 0),
(0, 'Magnien', 'France', 'Europe', 'FRBO0696', 0),
(0, 'Magnieres', 'France', 'Europe', 'FRXX4641', 0),
(0, 'Magnieu', 'France', 'Europe', 'FRRA1023', 0),
(0, 'Magnivray', 'France', 'Europe', 'FRFC0799', 0),
(0, 'Magnoncourt', 'France', 'Europe', 'FRFC0800', 0),
(0, 'Magny', 'France', 'Europe', 'FRAL0328', 0),
(0, 'Magny', 'France', 'Europe', 'FRBO0697', 0),
(0, 'Nabas', 'France', 'Europe', 'FRAQ1031', 0),
(0, 'Nabinaud', 'France', 'Europe', 'FRPC0678', 0),
(0, 'Nabirat', 'France', 'Europe', 'FRAQ1032', 0),
(0, 'Nabringhen', 'France', 'Europe', 'FRNC0648', 0),
(0, 'Nachamps', 'France', 'Europe', 'FRPC0679', 0),
(0, 'Nadaillac', 'France', 'Europe', 'FRAQ1033', 0),
(0, 'Nadaillac-de-Rouge', 'France', 'Europe', 'FRXX3114', 0),
(0, 'Nades', 'France', 'Europe', 'FRAU0525', 0),
(0, 'Nadillac', 'France', 'Europe', 'FRMP1611', 0),
(0, 'Naftel', 'France', 'Europe', 'FRBN0909', 0),
(0, 'Nagel-Seez-Mesnil', 'France', 'Europe', 'FRHN0610', 0),
(0, 'Nages', 'France', 'Europe', 'FRMP1612', 0),
(0, 'Nages-et-Solorgues', 'France', 'Europe', 'FRXX3197', 0),
(0, 'Nahuja', 'France', 'Europe', 'FRLR0543', 0),
(0, 'Nailhac', 'France', 'Europe', 'FRAQ1034', 0),
(0, 'Naillat', 'France', 'Europe', 'FRLI0301', 0),
(0, 'Nailloux', 'France', 'Europe', 'FRMP1613', 0),
(0, 'Nailly', 'France', 'Europe', 'FRBO0877', 0),
(0, 'Naintre', 'France', 'Europe', 'FRXX6593', 0),
(0, 'Nainville-les-Roches', 'France', 'Europe', 'FRXX5959', 0),
(0, 'Naisey-les-Granges', 'France', 'Europe', 'FRFC0955', 0),
(0, 'Naives-en-Blois', 'France', 'Europe', 'FRLO1139', 0),
(0, 'Naives-Rosieres', 'France', 'Europe', 'FRLO1138', 0),
(0, 'Naix-aux-Forges', 'France', 'Europe', 'FRLO1140', 0),
(0, 'Naizin', 'France', 'Europe', 'FRBR0352', 0),
(0, 'Najac', 'France', 'Europe', 'FRMP1614', 0),
(0, 'Nalliers', 'France', 'Europe', 'FRPC0680', 0),
(0, 'Nalliers', 'France', 'Europe', 'FRXX3809', 0),
(0, 'Nalzen', 'France', 'Europe', 'FRMP1615', 0),
(0, 'Nambsheim', 'France', 'Europe', 'FRAL0375', 0),
(0, 'Nampcel', 'France', 'Europe', 'FRPI1176', 0),
(0, 'Nampcelles-la-Cour', 'France', 'Europe', 'FRPI1177', 0),
(0, 'Nampont', 'France', 'Europe', 'FRPI1178', 0),
(0, 'Namps-au-Mont', 'France', 'Europe', 'FRPI1179', 0),
(0, 'Namps-Maisnil', 'France', 'Europe', 'FRXX5206', 0),
(0, 'Nampteuil-sous-Muret', 'France', 'Europe', 'FRPI1180', 0),
(0, 'Nampty', 'France', 'Europe', 'FRPI1181', 0),
(0, 'Nan-sous-Thil', 'France', 'Europe', 'FRBO0878', 0),
(0, 'Nanc-les-Saint-Amour', 'France', 'Europe', 'FRFC0956', 0),
(0, 'Nancay', 'France', 'Europe', 'FRCE0770', 0),
(0, 'Nance', 'France', 'Europe', 'FRFC0957', 0),
(0, 'Nances', 'France', 'Europe', 'FRRA1229', 0),
(0, 'Nanclars', 'France', 'Europe', 'FRPC0681', 0),
(0, 'Nancois-le-Grand', 'France', 'Europe', 'FRLO1141', 0),
(0, 'Nancois-sur-Ornain', 'France', 'Europe', 'FRLO1142', 0),
(0, 'Nancras', 'France', 'Europe', 'FRPC0682', 0),
(0, 'Nancray', 'France', 'Europe', 'FRFC0958', 0),
(0, 'Nancray-sur-Rimarde', 'France', 'Europe', 'FRXX1929', 0),
(0, 'Nancuise', 'France', 'Europe', 'FRFC0959', 0),
(0, 'Nancy', 'France', 'Europe', 'FRXX5361', 0),
(0, 'Nancy-sur-Cluses', 'France', 'Europe', 'FRXX5084', 0),
(0, 'Nancy/Essey', 'France', 'Europe', 'FRXX0115', 0),
(0, 'Nandax', 'France', 'Europe', 'FRRA1230', 0),
(0, 'Nandy', 'France', 'Europe', 'FRIF0425', 0),
(0, 'Nangeville', 'France', 'Europe', 'FRCE0771', 0),
(0, 'Nangis', 'France', 'Europe', 'FRIF0426', 0),
(0, 'Nangy', 'France', 'Europe', 'FRRA1231', 0),
(0, 'Nannay', 'France', 'Europe', 'FRBO0879', 0),
(0, 'Nans', 'France', 'Europe', 'FRFC0960', 0),
(0, 'Nans-les-Pins', 'France', 'Europe', 'FRXX4274', 0),
(0, 'Nans-sous-Sainte-Anne', 'France', 'Europe', 'FRXX6172', 0),
(0, 'Nant', 'France', 'Europe', 'FRXX3201', 0),
(0, 'Nant-le-Grand', 'France', 'Europe', 'FRLO1143', 0),
(0, 'Nant-le-Petit', 'France', 'Europe', 'FRLO1144', 0),
(0, 'Nanteau-sur-Essonne', 'France', 'Europe', 'FRIF0427', 0),
(0, 'Nanteau-sur-Lunain', 'France', 'Europe', 'FRIF0428', 0),
(0, 'Nanterre', 'France', 'Europe', 'FRXX0202', 0),
(0, 'Nantes', 'France', 'Europe', 'FRXX0072', 0),
(0, 'Nantes-en-Ratier', 'France', 'Europe', 'FRXX2310', 0),
(0, 'Nanteuil', 'France', 'Europe', 'FRPC0683', 0),
(0, 'Nanteuil-Auriac-de-Bourzac', 'France', 'Europe', 'FRAQ1035', 0),
(0, 'Nanteuil-en-Vallee', 'France', 'Europe', 'FRXX3270', 0),
(0, 'Nanteuil-la-Foret', 'France', 'Europe', 'FRCA0981', 0),
(0, 'Nanteuil-la-Fosse', 'France', 'Europe', 'FRPI1183', 0),
(0, 'Nanteuil-le-Haudouin', 'France', 'Europe', 'FRXX3500', 0),
(0, 'Nanteuil-les-Meaux', 'France', 'Europe', 'FRXX1424', 0),
(0, 'Nanteuil-Notre-Dame', 'France', 'Europe', 'FRPI1182', 0),
(0, 'Nanteuil-sur-Aisne', 'France', 'Europe', 'FRCA0982', 0),
(0, 'Nanteuil-sur-Marne', 'France', 'Europe', 'FRIF0429', 0),
(0, 'Nantey', 'France', 'Europe', 'FRFC0961', 0),
(0, 'Nantheuil', 'France', 'Europe', 'FRAQ1036', 0),
(0, 'Obenheim', 'France', 'Europe', 'FRAL0402', 0),
(0, 'Oberbronn', 'France', 'Europe', 'FRAL0403', 0),
(0, 'Oberbruck', 'France', 'Europe', 'FRAL0404', 0),
(0, 'Oberdorf', 'France', 'Europe', 'FRXX4890', 0),
(0, 'Oberdorf-Spachbach', 'France', 'Europe', 'FRAL0405', 0),
(0, 'Oberdorff', 'France', 'Europe', 'FRLO1187', 0),
(0, 'Oberentzen', 'France', 'Europe', 'FRAL0406', 0),
(0, 'Obergailbach', 'France', 'Europe', 'FRLO1188', 0),
(0, 'Oberhaslach', 'France', 'Europe', 'FRXX3794', 0),
(0, 'Oberhausbergen', 'France', 'Europe', 'FRXX4433', 0),
(0, 'Oberhergheim', 'France', 'Europe', 'FRAL0407', 0),
(0, 'Oberhoffen-les-Wissembourg', 'France', 'Europe', 'FRAL0408', 0),
(0, 'Oberhoffen-sur-Moder', 'France', 'Europe', 'FRXX3025', 0),
(0, 'Oberlarg', 'France', 'Europe', 'FRAL0409', 0),
(0, 'Oberlauterbach', 'France', 'Europe', 'FRAL0410', 0),
(0, 'Obermodern-Zutzendorf', 'France', 'Europe', 'FRAL0411', 0),
(0, 'Obermorschwihr', 'France', 'Europe', 'FRAL0412', 0),
(0, 'Obermorschwiller', 'France', 'Europe', 'FRAL0413', 0),
(0, 'Obernai', 'France', 'Europe', 'FRXX5835', 0),
(0, 'Oberroedern', 'France', 'Europe', 'FRAL0414', 0),
(0, 'Obersaasheim', 'France', 'Europe', 'FRAL0415', 0),
(0, 'Oberschaeffolsheim', 'France', 'Europe', 'FRXX2158', 0),
(0, 'Obersoultzbach', 'France', 'Europe', 'FRAL0416', 0),
(0, 'Obersteinbach', 'France', 'Europe', 'FRAL0417', 0),
(0, 'Oberstinzel', 'France', 'Europe', 'FRLO1189', 0),
(0, 'Obervisse', 'France', 'Europe', 'FRLO1190', 0),
(0, 'Obies', 'France', 'Europe', 'FRNC0684', 0),
(0, 'Objat', 'France', 'Europe', 'FRLI0319', 0),
(0, 'Oblinghem', 'France', 'Europe', 'FRNC0685', 0),
(0, 'Obrechies', 'France', 'Europe', 'FRNC0686', 0),
(0, 'Obreck', 'France', 'Europe', 'FRLO1191', 0),
(0, 'Obsonville', 'France', 'Europe', 'FRIF0441', 0),
(0, 'Obterre', 'France', 'Europe', 'FRCE0814', 0),
(0, 'Obtree', 'France', 'Europe', 'FRBO0906', 0),
(0, 'Ocana', 'France', 'Europe', 'FRXX3238', 0),
(0, 'Occagnes', 'France', 'Europe', 'FRBN0946', 0),
(0, 'Occey', 'France', 'Europe', 'FRCA1017', 0),
(0, 'Occhiatana', 'France', 'Europe', 'FRCO0119', 0),
(0, 'Occoches', 'France', 'Europe', 'FRPI1222', 0),
(0, 'Ochancourt', 'France', 'Europe', 'FRPI1223', 0),
(0, 'Oches', 'France', 'Europe', 'FRCA1018', 0),
(0, 'Ochey', 'France', 'Europe', 'FRLO1192', 0),
(0, 'Ochiaz', 'France', 'Europe', 'FRRA1267', 0),
(0, 'Ochtezeele', 'France', 'Europe', 'FRNC0687', 0),
(0, 'Ocquerre', 'France', 'Europe', 'FRIF0442', 0),
(0, 'Ocqueville', 'France', 'Europe', 'FRHN0638', 0),
(0, 'Octeville-l`Avenel', 'France', 'Europe', 'FRBN0947', 0),
(0, 'Octeville-sur-Mer', 'France', 'Europe', 'FRXX4392', 0),
(0, 'Octon', 'France', 'Europe', 'FRLR0562', 0),
(0, 'Odars', 'France', 'Europe', 'FRMP1643', 0),
(0, 'Odeillo-Via', 'France', 'Europe', 'FRLR0563', 0),
(0, 'Odenas', 'France', 'Europe', 'FRRA1268', 0),
(0, 'Oderen', 'France', 'Europe', 'FRXX1199', 0),
(0, 'Odival', 'France', 'Europe', 'FRCA1019', 0),
(0, 'Odomez', 'France', 'Europe', 'FRNC0688', 0),
(0, 'Odos', 'France', 'Europe', 'FRXX6372', 0),
(0, 'Odratzheim', 'France', 'Europe', 'FRAL0418', 0),
(0, 'Oelleville', 'France', 'Europe', 'FRLO1193', 0),
(0, 'Oermingen', 'France', 'Europe', 'FRXX3589', 0),
(0, 'OEuf-en-Ternois', 'France', 'Europe', 'FRNC0683', 0),
(0, 'OEuilly', 'France', 'Europe', 'FRXX1886', 0),
(0, 'OEuilly', 'France', 'Europe', 'FRXX5345', 0),
(0, 'Oeutrange', 'France', 'Europe', 'FRLO1194', 0),
(0, 'Oey', 'France', 'Europe', 'FRLO1195', 0),
(0, 'Oeyregave', 'France', 'Europe', 'FRAQ1058', 0),
(0, 'Oeyreluy', 'France', 'Europe', 'FRAQ1059', 0),
(0, 'Offekerque', 'France', 'Europe', 'FRNC0689', 0),
(0, 'Offemont', 'France', 'Europe', 'FRMP1644', 0),
(0, 'Offendorf', 'France', 'Europe', 'FRAL0419', 0),
(0, 'Offenheim', 'France', 'Europe', 'FRAL0420', 0),
(0, 'Offignies', 'France', 'Europe', 'FRPI1224', 0),
(0, 'Offin', 'France', 'Europe', 'FRNC0690', 0),
(0, 'Offlanges', 'France', 'Europe', 'FRFC0992', 0),
(0, 'Offoy', 'France', 'Europe', 'FRPI1225', 0),
(0, 'Offoy', 'France', 'Europe', 'FRPI1226', 0),
(0, 'Offranville', 'France', 'Europe', 'FRHN0639', 0),
(0, 'Offrethun', 'France', 'Europe', 'FRNC0691', 0),
(0, 'Offroicourt', 'France', 'Europe', 'FRLO1196', 0),
(0, 'Offwiller', 'France', 'Europe', 'FRAL0421', 0),
(0, 'Ogenne-Camptort', 'France', 'Europe', 'FRXX2587', 0),
(0, 'Ogeu-les-Bains', 'France', 'Europe', 'FRXX5817', 0),
(0, 'Paars', 'France', 'Europe', 'FRPI1260', 0),
(0, 'Pabu', 'France', 'Europe', 'FRBR0363', 0),
(0, 'Pace', 'France', 'Europe', 'FRBN0969', 0),
(0, 'Pace', 'France', 'Europe', 'FRXX5129', 0),
(0, 'Pact', 'France', 'Europe', 'FRRA1292', 0),
(0, 'Pacy-sur-Armancon', 'France', 'Europe', 'FRXX3839', 0),
(0, 'Pacy-sur-Eure', 'France', 'Europe', 'FRXX3281', 0),
(0, 'Padern', 'France', 'Europe', 'FRLR0573', 0),
(0, 'Padies', 'France', 'Europe', 'FRMP1679', 0),
(0, 'Padirac', 'France', 'Europe', 'FRMP1680', 0),
(0, 'Padoux', 'France', 'Europe', 'FRLO1221', 0),
(0, 'Paea', 'France', 'Europe', 'FRXX7857', 0),
(0, 'Pageas', 'France', 'Europe', 'FRLI0322', 0),
(0, 'Pagney', 'France', 'Europe', 'FRFC1023', 0),
(0, 'Pagney-derriere-Barine', 'France', 'Europe', 'FRLO1222', 0),
(0, 'Pagnoz', 'France', 'Europe', 'FRFC1024', 0),
(0, 'Pagny-la-Blanche-Cote', 'France', 'Europe', 'FRLO1223', 0),
(0, 'Pagny-la-Ville', 'France', 'Europe', 'FRBO0930', 0),
(0, 'Pagny-le-Chateau', 'France', 'Europe', 'FRBO0931', 0),
(0, 'Pagny-les-Goin', 'France', 'Europe', 'FRLO1224', 0),
(0, 'Pagny-sur-Meuse', 'France', 'Europe', 'FRLO1225', 0),
(0, 'Pagny-sur-Moselle', 'France', 'Europe', 'FRXX5999', 0),
(0, 'Pagolle', 'France', 'Europe', 'FRAQ1089', 0),
(0, 'Pailhac', 'France', 'Europe', 'FRMP1681', 0),
(0, 'Pailhares', 'France', 'Europe', 'FRRA1293', 0),
(0, 'Pailherols', 'France', 'Europe', 'FRAU0555', 0),
(0, 'Pailhes', 'France', 'Europe', 'FRLR0574', 0),
(0, 'Pailhes', 'France', 'Europe', 'FRMP1682', 0),
(0, 'Paillart', 'France', 'Europe', 'FRPI1261', 0),
(0, 'Paille', 'France', 'Europe', 'FRPC0715', 0),
(0, 'Paillencourt', 'France', 'Europe', 'FRXX1443', 0),
(0, 'Paillet', 'France', 'Europe', 'FRAQ1090', 0),
(0, 'Pailloles', 'France', 'Europe', 'FRXX2370', 0),
(0, 'Pailly', 'France', 'Europe', 'FRBO0932', 0),
(0, 'Paimboeuf', 'France', 'Europe', 'FRXX2010', 0),
(0, 'Paimpol', 'France', 'Europe', 'FRXX6226', 0),
(0, 'Paimpont', 'France', 'Europe', 'FRBR0364', 0),
(0, 'Painblanc', 'France', 'Europe', 'FRBO0933', 0),
(0, 'Pair-et-Grandrupt', 'France', 'Europe', 'FRLO1226', 0),
(0, 'Paissy', 'France', 'Europe', 'FRPI1262', 0),
(0, 'Paisy-Cosdon', 'France', 'Europe', 'FRCA1051', 0),
(0, 'Paita', 'France', 'Europe', 'FRXX7958', 0),
(0, 'Paizay-le-Chapt', 'France', 'Europe', 'FRPC0717', 0),
(0, 'Paizay-le-Sec', 'France', 'Europe', 'FRPC0718', 0),
(0, 'Paizay-le-Tort', 'France', 'Europe', 'FRPC0719', 0),
(0, 'Paizay-Naudouin-Embourie', 'France', 'Europe', 'FRPC0716', 0),
(0, 'Pajay', 'France', 'Europe', 'FRRA1294', 0),
(0, 'Paladru', 'France', 'Europe', 'FRXX5760', 0),
(0, 'Palairac', 'France', 'Europe', 'FRLR0575', 0),
(0, 'Palais-Bourbon', 'France', 'Europe', 'FRXX6513', 0),
(0, 'Palaiseau', 'France', 'Europe', 'FRXX6087', 0),
(0, 'Palaiseul', 'France', 'Europe', 'FRCA1052', 0),
(0, 'Palaja', 'France', 'Europe', 'FRXX5391', 0),
(0, 'Palaminy', 'France', 'Europe', 'FRMP1683', 0),
(0, 'Palante', 'France', 'Europe', 'FRFC1025', 0),
(0, 'Palantine', 'France', 'Europe', 'FRFC1026', 0),
(0, 'Palasca', 'France', 'Europe', 'FRCO0131', 0),
(0, 'Palau-de-Cerdagne', 'France', 'Europe', 'FRLR0576', 0),
(0, 'Palau-del-Vidre', 'France', 'Europe', 'FRLR0577', 0),
(0, 'Palavas-les-Flots', 'France', 'Europe', 'FRXX6477', 0),
(0, 'Palazinges', 'France', 'Europe', 'FRLI0323', 0),
(0, 'Paley', 'France', 'Europe', 'FRIF0459', 0),
(0, 'Paleyrac', 'France', 'Europe', 'FRAQ1091', 0),
(0, 'Palhers', 'France', 'Europe', 'FRLR0578', 0),
(0, 'Palinges', 'France', 'Europe', 'FRBO0934', 0),
(0, 'Palis', 'France', 'Europe', 'FRCA1053', 0),
(0, 'Palise', 'France', 'Europe', 'FRFC1027', 0),
(0, 'Palisse', 'France', 'Europe', 'FRLI0324', 0),
(0, 'Palladuc', 'France', 'Europe', 'FRAU0556', 0),
(0, 'Pallanne', 'France', 'Europe', 'FRMP1684', 0),
(0, 'Palleau', 'France', 'Europe', 'FRBO0935', 0),
(0, 'Pallegney', 'France', 'Europe', 'FRLO1227', 0),
(0, 'Palleville', 'France', 'Europe', 'FRMP1685', 0),
(0, 'Palluau', 'France', 'Europe', 'FRPL0656', 0),
(0, 'Palluau-sur-Indre', 'France', 'Europe', 'FRCE0850', 0),
(0, 'Palluaud', 'France', 'Europe', 'FRPC0720', 0),
(0, 'Pallud', 'France', 'Europe', 'FRRA1295', 0),
(0, 'Palluel', 'France', 'Europe', 'FRNC0703', 0),
(0, 'Palmas', 'France', 'Europe', 'FRMP1686', 0),
(0, 'Palneca', 'France', 'Europe', 'FRXX3987', 0),
(0, 'Palogneux', 'France', 'Europe', 'FRRA1296', 0),
(0, 'Quaedypre', 'France', 'Europe', 'FRNC0731', 0),
(0, 'Quaix-en-Chartreuse', 'France', 'Europe', 'FRRA1412', 0),
(0, 'Quantilly', 'France', 'Europe', 'FRCE0919', 0),
(0, 'Quarante', 'France', 'Europe', 'FRLR0652', 0),
(0, 'Quarouble', 'France', 'Europe', 'FRXX4857', 0),
(0, 'Quarre-les-Tombes', 'France', 'Europe', 'FRXX3002', 0),
(0, 'Quasquara', 'France', 'Europe', 'FRXX3226', 0),
(0, 'Quatre-Champs', 'France', 'Europe', 'FRCA1152', 0),
(0, 'Quatremare', 'France', 'Europe', 'FRHN0685', 0),
(0, 'Quatzenheim', 'France', 'Europe', 'FRAL0444', 0),
(0, 'Queant', 'France', 'Europe', 'FRNC0732', 0),
(0, 'Queaux', 'France', 'Europe', 'FRPC0786', 0),
(0, 'Quebriac', 'France', 'Europe', 'FRBR0479', 0),
(0, 'Quedillac', 'France', 'Europe', 'FRBR0480', 0),
(0, 'Queige', 'France', 'Europe', 'FRXX4236', 0),
(0, 'Quelaines-Saint-Gault', 'France', 'Europe', 'FRXX3084', 0),
(0, 'Quelmes', 'France', 'Europe', 'FRNC0733', 0),
(0, 'Quelneuc', 'France', 'Europe', 'FRXX3681', 0),
(0, 'Quemeneven', 'France', 'Europe', 'FRBR0481', 0),
(0, 'Quemigny-Poisot', 'France', 'Europe', 'FRBO1018', 0),
(0, 'Quemigny-sur-Seine', 'France', 'Europe', 'FRXX1068', 0),
(0, 'Quemper-Guezennec', 'France', 'Europe', 'FRBR0482', 0),
(0, 'Quemperven', 'France', 'Europe', 'FRBR0483', 0),
(0, 'Quend', 'France', 'Europe', 'FRXX4476', 0),
(0, 'Quenne', 'France', 'Europe', 'FRBO1019', 0),
(0, 'Quenoche', 'France', 'Europe', 'FRFC1100', 0),
(0, 'Quenza', 'France', 'Europe', 'FRXX1799', 0),
(0, 'Quercamps', 'France', 'Europe', 'FRNC0734', 0),
(0, 'Quercitello', 'France', 'Europe', 'FRCO0174', 0),
(0, 'Querenaing', 'France', 'Europe', 'FRXX1596', 0),
(0, 'Querigut', 'France', 'Europe', 'FRXX6287', 0),
(0, 'Quernes', 'France', 'Europe', 'FRNC0735', 0),
(0, 'Querqueville', 'France', 'Europe', 'FRBN1021', 0),
(0, 'Querre', 'France', 'Europe', 'FRPL0710', 0),
(0, 'Querrien', 'France', 'Europe', 'FRXX1759', 0),
(0, 'Querrieu', 'France', 'Europe', 'FRPI1350', 0),
(0, 'Quers', 'France', 'Europe', 'FRFC1101', 0),
(0, 'Quesmy', 'France', 'Europe', 'FRPI1351', 0),
(0, 'Quesney-Guesnon', 'France', 'Europe', 'FRXX3166', 0),
(0, 'Quesnoy-le-Montant', 'France', 'Europe', 'FRPI1352', 0),
(0, 'Quesnoy-sur-Airaines', 'France', 'Europe', 'FRXX1504', 0),
(0, 'Quesnoy-sur-Deule', 'France', 'Europe', 'FRXX6602', 0),
(0, 'Quesques', 'France', 'Europe', 'FRNC0736', 0),
(0, 'Quessigny', 'France', 'Europe', 'FRHN0686', 0),
(0, 'Quessoy', 'France', 'Europe', 'FRBR0484', 0),
(0, 'Quessy', 'France', 'Europe', 'FRPI1353', 0),
(0, 'Questembert', 'France', 'Europe', 'FRXX1527', 0),
(0, 'Questrecques', 'France', 'Europe', 'FRNC0737', 0),
(0, 'Quet-en-Beaumont', 'France', 'Europe', 'FRRA1413', 0),
(0, 'Quetieville', 'France', 'Europe', 'FRBN1022', 0),
(0, 'Quetigny', 'France', 'Europe', 'FRBO1020', 0),
(0, 'Quettehou', 'France', 'Europe', 'FRBN1023', 0),
(0, 'Quettetot', 'France', 'Europe', 'FRBN1024', 0),
(0, 'Quetteville', 'France', 'Europe', 'FRBN1025', 0),
(0, 'Quettreville-sur-Sienne', 'France', 'Europe', 'FRXX2360', 0),
(0, 'Queudes', 'France', 'Europe', 'FRCA1153', 0),
(0, 'Queuille', 'France', 'Europe', 'FRAU0597', 0),
(0, 'Quevauvillers', 'France', 'Europe', 'FRPI1354', 0),
(0, 'Queven', 'France', 'Europe', 'FRXX1495', 0),
(0, 'Quevert', 'France', 'Europe', 'FRXX3181', 0),
(0, 'Quevillon', 'France', 'Europe', 'FRHN0687', 0),
(0, 'Quevilloncourt', 'France', 'Europe', 'FRLO1291', 0),
(0, 'Quevreville-la-Poterie', 'France', 'Europe', 'FRHN0688', 0),
(0, 'Queyrac', 'France', 'Europe', 'FRAQ1185', 0),
(0, 'Queyrieres', 'France', 'Europe', 'FRAU0598', 0),
(0, 'Queyssac', 'France', 'Europe', 'FRAQ1186', 0),
(0, 'Queyssac-les-Vignes', 'France', 'Europe', 'FRXX4010', 0),
(0, 'Quezac', 'France', 'Europe', 'FRAU0599', 0),
(0, 'Quiberon', 'France', 'Europe', 'FRXX2292', 0),
(0, 'Quiberville', 'France', 'Europe', 'FRHN0689', 0),
(0, 'Quibou', 'France', 'Europe', 'FRBN1026', 0),
(0, 'Quie', 'France', 'Europe', 'FRMP1825', 0),
(0, 'Quiers', 'France', 'Europe', 'FRIF0490', 0),
(0, 'Quiers-sur-Bezonde', 'France', 'Europe', 'FRXX4163', 0),
(0, 'Quiery-la-Motte', 'France', 'Europe', 'FRNC0738', 0),
(0, 'Quierzy', 'France', 'Europe', 'FRPI1355', 0),
(0, 'Quiestede', 'France', 'Europe', 'FRNC0739', 0),
(0, 'Quievelon', 'France', 'Europe', 'FRNC0740', 0),
(0, 'Quievrechain', 'France', 'Europe', 'FRXX2717', 0),
(0, 'Quievrecourt', 'France', 'Europe', 'FRHN0690', 0),
(0, 'Quievy', 'France', 'Europe', 'FRXX5105', 0),
(0, 'Rabastens', 'France', 'Europe', 'FRXX5823', 0),
(0, 'Rabastens-de-Bigorre', 'France', 'Europe', 'FRXX1229', 0),
(0, 'Rabat-les-Trois-Seigneurs', 'France', 'Europe', 'FRMP1829', 0),
(0, 'Rablay-sur-Layon', 'France', 'Europe', 'FRPL0712', 0),
(0, 'Rabodanges', 'France', 'Europe', 'FRBN1028', 0),
(0, 'Rabou', 'France', 'Europe', 'FRPA0463', 0),
(0, 'Rabouillet', 'France', 'Europe', 'FRXX1399', 0),
(0, 'Racecourt', 'France', 'Europe', 'FRLO1293', 0),
(0, 'Rachecourt-sur-Marne', 'France', 'Europe', 'FRXX2338', 0),
(0, 'Rachecourt-Suzemont', 'France', 'Europe', 'FRCA1156', 0),
(0, 'Raches', 'France', 'Europe', 'FRXX1889', 0),
(0, 'Racines', 'France', 'Europe', 'FRCA1157', 0),
(0, 'Racquinghem', 'France', 'Europe', 'FRNC0743', 0),
(0, 'Racrange', 'France', 'Europe', 'FRLO1294', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Raddon-et-Chapendu', 'France', 'Europe', 'FRXX6416', 0),
(0, 'Radenac', 'France', 'Europe', 'FRBR0489', 0),
(0, 'Radepont', 'France', 'Europe', 'FRHN0692', 0),
(0, 'Radinghem', 'France', 'Europe', 'FRNC0744', 0),
(0, 'Radinghem-en-Weppes', 'France', 'Europe', 'FRNC0745', 0),
(0, 'Radon', 'France', 'Europe', 'FRBN1029', 0),
(0, 'Radonvilliers', 'France', 'Europe', 'FRCA1158', 0),
(0, 'Raedersdorf', 'France', 'Europe', 'FRAL0445', 0),
(0, 'Raedersheim', 'France', 'Europe', 'FRAL0446', 0),
(0, 'Raffetot', 'France', 'Europe', 'FRHN0693', 0),
(0, 'Rageade', 'France', 'Europe', 'FRAU0600', 0),
(0, 'Rahart', 'France', 'Europe', 'FRCE0921', 0),
(0, 'Rahay', 'France', 'Europe', 'FRPL0713', 0),
(0, 'Rahling', 'France', 'Europe', 'FRLO1295', 0),
(0, 'Rahon', 'France', 'Europe', 'FRFC1106', 0),
(0, 'Rahon', 'France', 'Europe', 'FRFC1107', 0),
(0, 'Rai', 'France', 'Europe', 'FRXX2046', 0),
(0, 'Raids', 'France', 'Europe', 'FRBN1030', 0),
(0, 'Raillencourt-Sainte-Olle', 'France', 'Europe', 'FRNC0746', 0),
(0, 'Railleu', 'France', 'Europe', 'FRLR0656', 0),
(0, 'Raillicourt', 'France', 'Europe', 'FRCA1159', 0),
(0, 'Raillimont', 'France', 'Europe', 'FRPI1360', 0),
(0, 'Raimbeaucourt', 'France', 'Europe', 'FRXX1442', 0),
(0, 'Rainans', 'France', 'Europe', 'FRFC1108', 0),
(0, 'Raincheval', 'France', 'Europe', 'FRPI1361', 0),
(0, 'Raincourt', 'France', 'Europe', 'FRFC1109', 0),
(0, 'Rainfreville', 'France', 'Europe', 'FRHN0694', 0),
(0, 'Rainneville', 'France', 'Europe', 'FRPI1362', 0),
(0, 'Rainsars', 'France', 'Europe', 'FRNC0747', 0),
(0, 'Rainville', 'France', 'Europe', 'FRLO1296', 0),
(0, 'Rainvillers', 'France', 'Europe', 'FRXX1293', 0),
(0, 'Raismes', 'France', 'Europe', 'FRXX6008', 0),
(0, 'Raissac', 'France', 'Europe', 'FRMP1830', 0),
(0, 'Raissac-d`Aude', 'France', 'Europe', 'FRLR0657', 0),
(0, 'Raissac-sur-Lampy', 'France', 'Europe', 'FRLR0658', 0),
(0, 'Raival', 'France', 'Europe', 'FRLO1297', 0),
(0, 'Raivavae', 'France', 'Europe', 'FRXX7893', 0),
(0, 'Raix', 'France', 'Europe', 'FRPC0788', 0),
(0, 'Ramasse', 'France', 'Europe', 'FRRA1417', 0),
(0, 'Ramatuelle', 'France', 'Europe', 'FRXX3507', 0),
(0, 'Rambaud', 'France', 'Europe', 'FRPA0464', 0),
(0, 'Rambervillers', 'France', 'Europe', 'FRXX4531', 0),
(0, 'Rambluzin-et-Benoite-Vaux', 'France', 'Europe', 'FRLO1298', 0),
(0, 'Rambouillet', 'France', 'Europe', 'FRXX2308', 0),
(0, 'Rambucourt', 'France', 'Europe', 'FRLO1299', 0),
(0, 'Ramburelles', 'France', 'Europe', 'FRPI1363', 0),
(0, 'Rambures', 'France', 'Europe', 'FRPI1364', 0),
(0, 'Ramecourt', 'France', 'Europe', 'FRLO1300', 0),
(0, 'Ramecourt', 'France', 'Europe', 'FRNC0748', 0),
(0, 'Ramerupt', 'France', 'Europe', 'FRCA1160', 0),
(0, 'Ramicourt', 'France', 'Europe', 'FRPI1365', 0),
(0, 'Ramillies', 'France', 'Europe', 'FRNC0749', 0),
(0, 'Rammersmatt', 'France', 'Europe', 'FRAL0447', 0),
(0, 'Ramonchamp', 'France', 'Europe', 'FRLO1301', 0),
(0, 'Ramonville-Saint-Agne', 'France', 'Europe', 'FRXX2862', 0),
(0, 'Ramoulu', 'France', 'Europe', 'FRCE0922', 0),
(0, 'Ramous', 'France', 'Europe', 'FRAQ1189', 0),
(0, 'Ramousies', 'France', 'Europe', 'FRNC0750', 0),
(0, 'Ramouzens', 'France', 'Europe', 'FRMP1831', 0),
(0, 'Rampan', 'France', 'Europe', 'FRBN1031', 0),
(0, 'Rampieux', 'France', 'Europe', 'FRAQ1190', 0),
(0, 'Rampillon', 'France', 'Europe', 'FRIF0491', 0),
(0, 'Rampont', 'France', 'Europe', 'FRLO1302', 0),
(0, 'Rampoux', 'France', 'Europe', 'FRMP1832', 0),
(0, 'Rance', 'France', 'Europe', 'FRRA1418', 0),
(0, 'Rancenay', 'France', 'Europe', 'FRFC1110', 0),
(0, 'Rancennes', 'France', 'Europe', 'FRCA1161', 0),
(0, 'Saacy-sur-Marne', 'France', 'Europe', 'FRXX2625', 0),
(0, 'Saales', 'France', 'Europe', 'FRAL0500', 0),
(0, 'Saane-Saint-Just', 'France', 'Europe', 'FRHN0726', 0),
(0, 'Saasenheim', 'France', 'Europe', 'FRAL0501', 0),
(0, 'Sabadel-Latronquiere', 'France', 'Europe', 'FRMP1903', 0),
(0, 'Sabadel-Lauzes', 'France', 'Europe', 'FRMP1904', 0),
(0, 'Sabaillan', 'France', 'Europe', 'FRMP1905', 0),
(0, 'Sabalos', 'France', 'Europe', 'FRMP1906', 0),
(0, 'Sabarat', 'France', 'Europe', 'FRMP1907', 0),
(0, 'Sabarros', 'France', 'Europe', 'FRMP1908', 0),
(0, 'Sabazan', 'France', 'Europe', 'FRMP1909', 0),
(0, 'Sable-sur-Sarthe', 'France', 'Europe', 'FRXX4348', 0),
(0, 'Sablet', 'France', 'Europe', 'FRPA0498', 0),
(0, 'Sablieres', 'France', 'Europe', 'FRRA1492', 0),
(0, 'Sablonceaux', 'France', 'Europe', 'FRPC0824', 0),
(0, 'Sablonnieres', 'France', 'Europe', 'FRIF0513', 0),
(0, 'Sablons', 'France', 'Europe', 'FRAQ1226', 0),
(0, 'Sablons', 'France', 'Europe', 'FRRA1493', 0),
(0, 'Sabonneres', 'France', 'Europe', 'FRMP1910', 0),
(0, 'Sabran', 'France', 'Europe', 'FRPA0499', 0),
(0, 'Sabres', 'France', 'Europe', 'FRXX3826', 0),
(0, 'Saccourvielle', 'France', 'Europe', 'FRMP1911', 0),
(0, 'Sace', 'France', 'Europe', 'FRPL0737', 0),
(0, 'Sacey', 'France', 'Europe', 'FRBN1075', 0),
(0, 'Sache', 'France', 'Europe', 'FRCE0966', 0),
(0, 'Sachin', 'France', 'Europe', 'FRNC0803', 0),
(0, 'Sachy', 'France', 'Europe', 'FRCA1223', 0),
(0, 'Sacierges-Saint-Martin', 'France', 'Europe', 'FRCE0967', 0),
(0, 'Saclas', 'France', 'Europe', 'FRIF0514', 0),
(0, 'Saclay', 'France', 'Europe', 'FRIF0515', 0),
(0, 'Saconin-et-Breuil', 'France', 'Europe', 'FRPI1451', 0),
(0, 'Sacoue', 'France', 'Europe', 'FRMP1912', 0),
(0, 'Sacquenay', 'France', 'Europe', 'FRBO1060', 0),
(0, 'Sacquenville', 'France', 'Europe', 'FRHN0727', 0),
(0, 'Sacy', 'France', 'Europe', 'FRBO1061', 0),
(0, 'Sacy', 'France', 'Europe', 'FRCA1224', 0),
(0, 'Sacy-le-Grand', 'France', 'Europe', 'FRPI1452', 0),
(0, 'Sacy-le-Petit', 'France', 'Europe', 'FRPI1453', 0),
(0, 'Sada', 'France', 'Europe', 'FRXX7839', 0),
(0, 'Sadeillan', 'France', 'Europe', 'FRMP1913', 0),
(0, 'Sadillac', 'France', 'Europe', 'FRAQ1227', 0),
(0, 'Sadirac', 'France', 'Europe', 'FRAQ1228', 0),
(0, 'Sadournin', 'France', 'Europe', 'FRMP1914', 0),
(0, 'Sadroc', 'France', 'Europe', 'FRLI0359', 0),
(0, 'Saessolsheim', 'France', 'Europe', 'FRAL0502', 0),
(0, 'Saffais', 'France', 'Europe', 'FRLO1411', 0),
(0, 'Saffloz', 'France', 'Europe', 'FRFC1173', 0),
(0, 'Saffre', 'France', 'Europe', 'FRPL0738', 0),
(0, 'Saffres', 'France', 'Europe', 'FRBO1062', 0),
(0, 'Sagelat', 'France', 'Europe', 'FRAQ1229', 0),
(0, 'Sagnat', 'France', 'Europe', 'FRLI0360', 0),
(0, 'Sagnes-et-Goudoulet', 'France', 'Europe', 'FRRA1494', 0),
(0, 'Sagone', 'France', 'Europe', 'FRXX2930', 0),
(0, 'Sagonne', 'France', 'Europe', 'FRCE0968', 0),
(0, 'Sagy', 'France', 'Europe', 'FRBO1063', 0),
(0, 'Sagy', 'France', 'Europe', 'FRIF0516', 0),
(0, 'Sahorre', 'France', 'Europe', 'FRLR0703', 0),
(0, 'Sahune', 'France', 'Europe', 'FRRA1495', 0),
(0, 'Sahurs', 'France', 'Europe', 'FRHN0728', 0),
(0, 'Sai', 'France', 'Europe', 'FRBN1076', 0),
(0, 'Saignes', 'France', 'Europe', 'FRMP1915', 0),
(0, 'Saignes', 'France', 'Europe', 'FRXX3212', 0),
(0, 'Saigneville', 'France', 'Europe', 'FRPI1454', 0),
(0, 'Saignon', 'France', 'Europe', 'FRPA0500', 0),
(0, 'Saiguede', 'France', 'Europe', 'FRMP1916', 0),
(0, 'Sail-les-Bains', 'France', 'Europe', 'FRRA1496', 0),
(0, 'Sail-sous-Couzan', 'France', 'Europe', 'FRXX2628', 0),
(0, 'Sailhan', 'France', 'Europe', 'FRMP1917', 0),
(0, 'Saillac', 'France', 'Europe', 'FRLI0361', 0),
(0, 'Saillac', 'France', 'Europe', 'FRMP1918', 0),
(0, 'Saillagouse', 'France', 'Europe', 'FRLR0704', 0),
(0, 'Saillans', 'France', 'Europe', 'FRAQ1230', 0),
(0, 'Saillans', 'France', 'Europe', 'FRRA1497', 0),
(0, 'Saillant', 'France', 'Europe', 'FRAU0631', 0),
(0, 'Saillat-sur-Vienne', 'France', 'Europe', 'FRXX6693', 0),
(0, 'Saille', 'France', 'Europe', 'FRPL0739', 0),
(0, 'Saillenard', 'France', 'Europe', 'FRBO1064', 0),
(0, 'Sailly', 'France', 'Europe', 'FRBO1065', 0),
(0, 'Sailly', 'France', 'Europe', 'FRCA1225', 0),
(0, 'Sailly', 'France', 'Europe', 'FRCA1226', 0),
(0, 'Sailly', 'France', 'Europe', 'FRIF0517', 0),
(0, 'Tabaille-Usquain', 'France', 'Europe', 'FRAQ1653', 0),
(0, 'Tabanac', 'France', 'Europe', 'FRXX6665', 0),
(0, 'Tabre', 'France', 'Europe', 'FRMP2286', 0),
(0, 'Tachoires', 'France', 'Europe', 'FRMP2287', 0),
(0, 'Tacoignieres', 'France', 'Europe', 'FRIF0591', 0),
(0, 'Taconnay', 'France', 'Europe', 'FRBO1342', 0),
(0, 'Taden', 'France', 'Europe', 'FRBR0701', 0),
(0, 'Tadousse-Ussau', 'France', 'Europe', 'FRAQ1654', 0),
(0, 'Taglio-Isolaccio', 'France', 'Europe', 'FRCO0207', 0),
(0, 'Tagnon', 'France', 'Europe', 'FRCA1415', 0),
(0, 'Tagolsheim', 'France', 'Europe', 'FRAL0576', 0),
(0, 'Tagsdorf', 'France', 'Europe', 'FRXX4451', 0),
(0, 'Tahaa', 'France', 'Europe', 'FRXX7879', 0),
(0, 'Tahuata', 'France', 'Europe', 'FRXX7886', 0),
(0, 'Tailhac', 'France', 'Europe', 'FRAU0840', 0),
(0, 'Taillades', 'France', 'Europe', 'FRXX6012', 0),
(0, 'Taillancourt', 'France', 'Europe', 'FRLO1571', 0),
(0, 'Taillant', 'France', 'Europe', 'FRPC1071', 0),
(0, 'Taillebois', 'France', 'Europe', 'FRBN1385', 0),
(0, 'Taillebourg', 'France', 'Europe', 'FRAQ1655', 0),
(0, 'Taillebourg', 'France', 'Europe', 'FRPC1072', 0),
(0, 'Taillecavat', 'France', 'Europe', 'FRAQ1656', 0),
(0, 'Taillecourt', 'France', 'Europe', 'FRXX3967', 0),
(0, 'Taillefontaine', 'France', 'Europe', 'FRPI1587', 0),
(0, 'Taillepied', 'France', 'Europe', 'FRBN1386', 0),
(0, 'Taillet', 'France', 'Europe', 'FRLR0879', 0),
(0, 'Taillette', 'France', 'Europe', 'FRCA1416', 0),
(0, 'Tailleville', 'France', 'Europe', 'FRBN1387', 0),
(0, 'Taillis', 'France', 'Europe', 'FRBR0702', 0),
(0, 'Tailly', 'France', 'Europe', 'FRBO1343', 0),
(0, 'Tailly', 'France', 'Europe', 'FRCA1417', 0),
(0, 'Tailly', 'France', 'Europe', 'FRPI1588', 0),
(0, 'Tain-l`Hermitage', 'France', 'Europe', 'FRRA1950', 0),
(0, 'Taingy', 'France', 'Europe', 'FRBO1344', 0),
(0, 'Taintrux', 'France', 'Europe', 'FRLO1572', 0),
(0, 'Taisnieres-en-Thierache', 'France', 'Europe', 'FRNC0894', 0),
(0, 'Taisnieres-sur-Hon', 'France', 'Europe', 'FRNC0895', 0),
(0, 'Taisnil', 'France', 'Europe', 'FRPI1589', 0),
(0, 'Taissy', 'France', 'Europe', 'FRCA1418', 0),
(0, 'Taix', 'France', 'Europe', 'FRMP2288', 0),
(0, 'Taize', 'France', 'Europe', 'FRBO1345', 0),
(0, 'Taize', 'France', 'Europe', 'FRPC1073', 0),
(0, 'Taize-Aizie', 'France', 'Europe', 'FRPC1074', 0),
(0, 'Taizy', 'France', 'Europe', 'FRCA1419', 0),
(0, 'Tajan', 'France', 'Europe', 'FRMP2289', 0),
(0, 'Takapoto', 'France', 'Europe', 'FRXX7920', 0),
(0, 'Takaroa', 'France', 'Europe', 'FRXX7919', 0),
(0, 'Talairan', 'France', 'Europe', 'FRLR0880', 0),
(0, 'Talais', 'France', 'Europe', 'FRAQ1657', 0),
(0, 'Talange', 'France', 'Europe', 'FRXX5657', 0),
(0, 'Talant', 'France', 'Europe', 'FRXX6146', 0),
(0, 'Talasani', 'France', 'Europe', 'FRCO0208', 0),
(0, 'Talau', 'France', 'Europe', 'FRLR0881', 0),
(0, 'Talazac', 'France', 'Europe', 'FRMP2290', 0),
(0, 'Talcy', 'France', 'Europe', 'FRBO1346', 0),
(0, 'Talcy', 'France', 'Europe', 'FRCE1196', 0),
(0, 'Talence', 'France', 'Europe', 'FRXX0096', 0),
(0, 'Talencieux', 'France', 'Europe', 'FRRA1951', 0),
(0, 'Talensac', 'France', 'Europe', 'FRBR0703', 0),
(0, 'Talissieu', 'France', 'Europe', 'FRRA1952', 0),
(0, 'Talizat', 'France', 'Europe', 'FRAU0841', 0),
(0, 'Tallans', 'France', 'Europe', 'FRFC1269', 0),
(0, 'Tallard', 'France', 'Europe', 'FRPA0623', 0),
(0, 'Tallenay', 'France', 'Europe', 'FRFC1270', 0),
(0, 'Tallende', 'France', 'Europe', 'FRAU0842', 0),
(0, 'Taller', 'France', 'Europe', 'FRAQ1658', 0),
(0, 'Talloires', 'France', 'Europe', 'FRRA1953', 0),
(0, 'Tallone', 'France', 'Europe', 'FRXX1869', 0),
(0, 'Tallud-Sainte-Gemme', 'France', 'Europe', 'FRPL0983', 0),
(0, 'Talmas', 'France', 'Europe', 'FRPI1590', 0),
(0, 'Talmay', 'France', 'Europe', 'FRBO1347', 0),
(0, 'Talmont-Saint-Hilaire', 'France', 'Europe', 'FRPL0984', 0),
(0, 'Talmont-sur-Gironde', 'France', 'Europe', 'FRPC1075', 0),
(0, 'Talmontiers', 'France', 'Europe', 'FRHN0924', 0),
(0, 'Taloire', 'France', 'Europe', 'FRPA0624', 0),
(0, 'Talon', 'France', 'Europe', 'FRBO1348', 0),
(0, 'Talus-Saint-Prix', 'France', 'Europe', 'FRCA1420', 0),
(0, 'Taluyers', 'France', 'Europe', 'FRRA1954', 0),
(0, 'Tamaris-sur-Mer', 'France', 'Europe', 'FRPA0625', 0),
(0, 'Tamerville', 'France', 'Europe', 'FRBN1388', 0),
(0, 'Tamnay-en-Bazois', 'France', 'Europe', 'FRBO1349', 0),
(0, 'Ua-Huka', 'France', 'Europe', 'FRXX7887', 0),
(0, 'Ua-Pou', 'France', 'Europe', 'FRXX7888', 0),
(0, 'Uberach', 'France', 'Europe', 'FRAL0587', 0),
(0, 'Ubexy', 'France', 'Europe', 'FRLO1631', 0),
(0, 'Ubraye', 'France', 'Europe', 'FRPA0654', 0),
(0, 'Ucciani', 'France', 'Europe', 'FRXX4756', 0),
(0, 'Ucel', 'France', 'Europe', 'FRRA2016', 0),
(0, 'Uchacq-et-Parentis', 'France', 'Europe', 'FRXX3687', 0),
(0, 'Uchaud', 'France', 'Europe', 'FRXX1139', 0),
(0, 'Uchaux', 'France', 'Europe', 'FRPA0655', 0),
(0, 'Uchentein', 'France', 'Europe', 'FRMP2369', 0),
(0, 'Uchizy', 'France', 'Europe', 'FRBO1419', 0),
(0, 'Uchon', 'France', 'Europe', 'FRBO1420', 0),
(0, 'Uckange', 'France', 'Europe', 'FRLO1632', 0),
(0, 'Ueberkumen', 'France', 'Europe', 'FRAL0588', 0),
(0, 'Ueberstrass', 'France', 'Europe', 'FRXX4145', 0),
(0, 'Uffheim', 'France', 'Europe', 'FRAL0589', 0),
(0, 'Uffholtz', 'France', 'Europe', 'FRAL0590', 0),
(0, 'Ugine', 'France', 'Europe', 'FRXX1283', 0),
(0, 'Uglas', 'France', 'Europe', 'FRMP2370', 0),
(0, 'Ugnouas', 'France', 'Europe', 'FRMP2371', 0),
(0, 'Ugny', 'France', 'Europe', 'FRLO1633', 0),
(0, 'Ugny-l`Equipee', 'France', 'Europe', 'FRPI1646', 0),
(0, 'Ugny-le-Gay', 'France', 'Europe', 'FRPI1647', 0),
(0, 'Ugny-sur-Meuse', 'France', 'Europe', 'FRLO1634', 0),
(0, 'Uhart-Mixe', 'France', 'Europe', 'FRAQ1694', 0),
(0, 'Uhlwiller', 'France', 'Europe', 'FRAL0591', 0),
(0, 'Uhrwiller', 'France', 'Europe', 'FRAL0592', 0),
(0, 'Ulcot', 'France', 'Europe', 'FRPC1111', 0),
(0, 'Ully-Saint-Georges', 'France', 'Europe', 'FRXX2735', 0),
(0, 'Umpeau', 'France', 'Europe', 'FRCE1251', 0),
(0, 'Uncey-le-Franc', 'France', 'Europe', 'FRBO1421', 0),
(0, 'Unchair', 'France', 'Europe', 'FRCA1482', 0),
(0, 'Ungersheim', 'France', 'Europe', 'FRXX5896', 0),
(0, 'Unias', 'France', 'Europe', 'FRRA2017', 0),
(0, 'Unienville', 'France', 'Europe', 'FRCA1483', 0),
(0, 'Unieux', 'France', 'Europe', 'FRXX3403', 0),
(0, 'Unverre', 'France', 'Europe', 'FRCE1252', 0),
(0, 'Unzent', 'France', 'Europe', 'FRMP2372', 0),
(0, 'Upaix', 'France', 'Europe', 'FRPA0656', 0),
(0, 'Upie', 'France', 'Europe', 'FRRA2018', 0),
(0, 'Ur', 'France', 'Europe', 'FRLR0917', 0),
(0, 'Urau', 'France', 'Europe', 'FRMP2373', 0),
(0, 'Urbalacone', 'France', 'Europe', 'FRCO0218', 0),
(0, 'Urbanya', 'France', 'Europe', 'FRLR0918', 0),
(0, 'Urbeis', 'France', 'Europe', 'FRAL0593', 0),
(0, 'Urbes', 'France', 'Europe', 'FRXX1482', 0),
(0, 'Urbise', 'France', 'Europe', 'FRRA2019', 0),
(0, 'Urcay', 'France', 'Europe', 'FRAU0877', 0),
(0, 'Urcel', 'France', 'Europe', 'FRPI1648', 0),
(0, 'Urcerey', 'France', 'Europe', 'FRXX1572', 0),
(0, 'Urciers', 'France', 'Europe', 'FRCE1253', 0),
(0, 'Urcuit', 'France', 'Europe', 'FRAQ1695', 0),
(0, 'Urcy', 'France', 'Europe', 'FRBO1422', 0),
(0, 'Urdens', 'France', 'Europe', 'FRMP2374', 0),
(0, 'Urdes', 'France', 'Europe', 'FRAQ1696', 0),
(0, 'Urdos', 'France', 'Europe', 'FRAQ1697', 0),
(0, 'Urepel', 'France', 'Europe', 'FRAQ1698', 0),
(0, 'Urgons', 'France', 'Europe', 'FRAQ1699', 0),
(0, 'Urgosse', 'France', 'Europe', 'FRMP2375', 0),
(0, 'Uriage-les-Bains', 'France', 'Europe', 'FRRA2020', 0),
(0, 'Urimenil', 'France', 'Europe', 'FRLO1635', 0),
(0, 'Urmatt', 'France', 'Europe', 'FRAL0594', 0),
(0, 'Urost', 'France', 'Europe', 'FRAQ1700', 0),
(0, 'Urou-et-Crennes', 'France', 'Europe', 'FRXX5303', 0),
(0, 'Urrugne', 'France', 'Europe', 'FRXX4298', 0),
(0, 'Urs', 'France', 'Europe', 'FRMP2376', 0),
(0, 'Urschenheim', 'France', 'Europe', 'FRAL0595', 0),
(0, 'Urt', 'France', 'Europe', 'FRAQ1701', 0),
(0, 'Urtaca', 'France', 'Europe', 'FRCO0219', 0),
(0, 'Urtiere', 'France', 'Europe', 'FRFC1307', 0),
(0, 'Uruffe', 'France', 'Europe', 'FRLO1636', 0),
(0, 'Urval', 'France', 'Europe', 'FRAQ1702', 0),
(0, 'Urville', 'France', 'Europe', 'FRBN1435', 0),
(0, 'Urville', 'France', 'Europe', 'FRBN1436', 0),
(0, 'Urville', 'France', 'Europe', 'FRCA1484', 0),
(0, 'Urville', 'France', 'Europe', 'FRLO1637', 0),
(0, 'Urville-Nacqueville', 'France', 'Europe', 'FRXX2139', 0),
(0, 'Urvillers', 'France', 'Europe', 'FRXX2398', 0),
(0, 'Ury', 'France', 'Europe', 'FRIF0608', 0),
(0, 'Urzy', 'France', 'Europe', 'FRBO1423', 0),
(0, 'Vaas', 'France', 'Europe', 'FRPL1024', 0),
(0, 'Vabre', 'France', 'Europe', 'FRMP2382', 0),
(0, 'Vabre-Tizac', 'France', 'Europe', 'FRXX4724', 0),
(0, 'Vabres', 'France', 'Europe', 'FRAU0881', 0),
(0, 'Vabres', 'France', 'Europe', 'FRLR0921', 0),
(0, 'Vabres-l`Abbaye', 'France', 'Europe', 'FRMP2383', 0),
(0, 'Vacherauville', 'France', 'Europe', 'FRLO1639', 0),
(0, 'Vacheres', 'France', 'Europe', 'FRPA0659', 0),
(0, 'Vacheres-en-Quint', 'France', 'Europe', 'FRRA2024', 0),
(0, 'Vacheresse', 'France', 'Europe', 'FRRA2025', 0),
(0, 'Vacheresses-les-Basses', 'France', 'Europe', 'FRCE1254', 0),
(0, 'Vacognes-Neuilly', 'France', 'Europe', 'FRBN1438', 0),
(0, 'Vacon', 'France', 'Europe', 'FRLO1640', 0),
(0, 'Vacquerie', 'France', 'Europe', 'FRPI1649', 0),
(0, 'Vacquerie-le-Boucq', 'France', 'Europe', 'FRNC0927', 0),
(0, 'Vacqueriette-Erquieres', 'France', 'Europe', 'FRNC0928', 0),
(0, 'Vacqueville', 'France', 'Europe', 'FRLO1641', 0),
(0, 'Vacqueyras', 'France', 'Europe', 'FRXX4580', 0),
(0, 'Vacquieres', 'France', 'Europe', 'FRLR0922', 0),
(0, 'Vacquiers', 'France', 'Europe', 'FRMP2384', 0),
(0, 'Vadans', 'France', 'Europe', 'FRFC1310', 0),
(0, 'Vadans', 'France', 'Europe', 'FRFC1311', 0),
(0, 'Vadelaincourt', 'France', 'Europe', 'FRLO1642', 0),
(0, 'Vadenay', 'France', 'Europe', 'FRCA1485', 0),
(0, 'Vadencourt', 'France', 'Europe', 'FRPI1650', 0),
(0, 'Vadencourt', 'France', 'Europe', 'FRPI1651', 0),
(0, 'Vadonville', 'France', 'Europe', 'FRLO1643', 0),
(0, 'Vagnas', 'France', 'Europe', 'FRRA2026', 0),
(0, 'Vagney', 'France', 'Europe', 'FRLO1644', 0),
(0, 'Vahitahi', 'France', 'Europe', 'FRXX7926', 0),
(0, 'Vahl-Ebersing', 'France', 'Europe', 'FRLO1645', 0),
(0, 'Vahl-les-Benestroff', 'France', 'Europe', 'FRLO1646', 0),
(0, 'Vahl-les-Faulquemont', 'France', 'Europe', 'FRLO1647', 0),
(0, 'Vaiges', 'France', 'Europe', 'FRPL1025', 0),
(0, 'Vailhan', 'France', 'Europe', 'FRLR0923', 0),
(0, 'Vailhauques', 'France', 'Europe', 'FRLR0924', 0),
(0, 'Vailhourles', 'France', 'Europe', 'FRMP2385', 0),
(0, 'Vaillac', 'France', 'Europe', 'FRMP2386', 0),
(0, 'Vaillant', 'France', 'Europe', 'FRCA1486', 0),
(0, 'Vailly', 'France', 'Europe', 'FRCA1487', 0),
(0, 'Vailly', 'France', 'Europe', 'FRXX2772', 0),
(0, 'Vailly-sur-Aisne', 'France', 'Europe', 'FRXX6305', 0),
(0, 'Vailly-sur-Sauldre', 'France', 'Europe', 'FRXX4786', 0),
(0, 'Vains', 'France', 'Europe', 'FRBN1439', 0),
(0, 'Vairao', 'France', 'Europe', 'FRXX7871', 0),
(0, 'Vaire', 'France', 'Europe', 'FRPL1026', 0),
(0, 'Vaire-Arcier', 'France', 'Europe', 'FRFC1312', 0),
(0, 'Vaire-le-Petit', 'France', 'Europe', 'FRFC1313', 0),
(0, 'Vaires-sur-Marne', 'France', 'Europe', 'FRXX6360', 0),
(0, 'Vaison-la-Romaine', 'France', 'Europe', 'FRXX3780', 0),
(0, 'Vaissac', 'France', 'Europe', 'FRMP2387', 0),
(0, 'Vaite', 'France', 'Europe', 'FRFC1314', 0),
(0, 'Vaivre', 'France', 'Europe', 'FRFC1315', 0),
(0, 'Vaivre-et-Montoille', 'France', 'Europe', 'FRFC1316', 0),
(0, 'Val Cenis', 'France', 'Europe', 'FRXX0536', 0),
(0, 'Val d`Allos La Foux', 'France', 'Europe', 'FRXX0524', 0),
(0, 'Val Pompadour', 'France', 'Europe', 'FRXX4548', 0),
(0, 'Val Thorens', 'France', 'Europe', 'FRXX0494', 0),
(0, 'Val-d`Epy', 'France', 'Europe', 'FRFC1317', 0),
(0, 'Val-d`Isere', 'France', 'Europe', 'FRXX0493', 0),
(0, 'Val-d`Ize', 'France', 'Europe', 'FRBR0777', 0),
(0, 'Val-d`Ornain', 'France', 'Europe', 'FRLO1648', 0),
(0, 'Val-de-Bride', 'France', 'Europe', 'FRLO1649', 0),
(0, 'Val-de-Fier', 'France', 'Europe', 'FRRA2027', 0),
(0, 'Val-de-la-Haye', 'France', 'Europe', 'FRXX5691', 0),
(0, 'Val-de-Mercy', 'France', 'Europe', 'FRBO1426', 0),
(0, 'Val-de-Meuse', 'France', 'Europe', 'FRCA1488', 0),
(0, 'Val-de-Roulans', 'France', 'Europe', 'FRFC1318', 0),
(0, 'Val-de-Vesle', 'France', 'Europe', 'FRXX6819', 0),
(0, 'Val-des-Pres', 'France', 'Europe', 'FRPA0660', 0),
(0, 'Val-et-Chatillon', 'France', 'Europe', 'FRLO1650', 0),
(0, 'Val-Suzon', 'France', 'Europe', 'FRBO1425', 0),
(0, 'Valady', 'France', 'Europe', 'FRMP2388', 0),
(0, 'Valailles', 'France', 'Europe', 'FRHN0967', 0),
(0, 'Valaire', 'France', 'Europe', 'FRCE1255', 0),
(0, 'Valanjou', 'France', 'Europe', 'FRXX5036', 0),
(0, 'Valaurie', 'France', 'Europe', 'FRRA2028', 0),
(0, 'Valavoire', 'France', 'Europe', 'FRPA0661', 0),
(0, 'Valay', 'France', 'Europe', 'FRFC1319', 0),
(0, 'Valbeleix', 'France', 'Europe', 'FRAU0882', 0),
(0, 'Valbelle', 'France', 'Europe', 'FRPA0662', 0),
(0, 'Waben', 'France', 'Europe', 'FRNC0966', 0),
(0, 'Wackenbach', 'France', 'Europe', 'FRAL0609', 0),
(0, 'Wacquemoulin', 'France', 'Europe', 'FRPI1767', 0),
(0, 'Wacquinghen', 'France', 'Europe', 'FRNC0967', 0),
(0, 'Wadelincourt', 'France', 'Europe', 'FRCA1662', 0),
(0, 'Wadimont', 'France', 'Europe', 'FRCA1663', 0),
(0, 'Wadonville-en-Woevre', 'France', 'Europe', 'FRLO1803', 0),
(0, 'Wagenbach', 'France', 'Europe', 'FRAL0610', 0),
(0, 'Wagnon', 'France', 'Europe', 'FRCA1664', 0),
(0, 'Wahagnies', 'France', 'Europe', 'FRXX6575', 0),
(0, 'Wahlbach', 'France', 'Europe', 'FRAL0611', 0),
(0, 'Wahlenheim', 'France', 'Europe', 'FRAL0612', 0),
(0, 'Wail', 'France', 'Europe', 'FRNC0968', 0),
(0, 'Wailly', 'France', 'Europe', 'FRNC0969', 0),
(0, 'Wailly', 'France', 'Europe', 'FRPI1768', 0),
(0, 'Wailly-Beaucamp', 'France', 'Europe', 'FRNC0970', 0),
(0, 'Walbach', 'France', 'Europe', 'FRAL0613', 0),
(0, 'Walbourg', 'France', 'Europe', 'FRXX6026', 0),
(0, 'Waldersbach', 'France', 'Europe', 'FRAL0614', 0),
(0, 'Waldhambach', 'France', 'Europe', 'FRXX2119', 0),
(0, 'Waldhouse', 'France', 'Europe', 'FRLO1804', 0),
(0, 'Waldighofen', 'France', 'Europe', 'FRXX4146', 0),
(0, 'Waldolwisheim', 'France', 'Europe', 'FRAL0615', 0),
(0, 'Waldweistroff', 'France', 'Europe', 'FRLO1805', 0),
(0, 'Waldwisse', 'France', 'Europe', 'FRLO1806', 0),
(0, 'Walheim', 'France', 'Europe', 'FRAL0616', 0),
(0, 'Walincourt-Selvigny', 'France', 'Europe', 'FRNC0971', 0),
(0, 'Wallers', 'France', 'Europe', 'FRXX5827', 0),
(0, 'Wallers-Trelon', 'France', 'Europe', 'FRNC0972', 0),
(0, 'Wallon-Cappel', 'France', 'Europe', 'FRNC0973', 0),
(0, 'Walschbronn', 'France', 'Europe', 'FRLO1807', 0),
(0, 'Walscheid', 'France', 'Europe', 'FRLO1808', 0),
(0, 'Waltembourg', 'France', 'Europe', 'FRLO1809', 0),
(0, 'Waltenheim', 'France', 'Europe', 'FRAL0617', 0),
(0, 'Waltenheim-sur-Zorn', 'France', 'Europe', 'FRAL0618', 0),
(0, 'Waly', 'France', 'Europe', 'FRLO1810', 0),
(0, 'Wambaix', 'France', 'Europe', 'FRNC0974', 0),
(0, 'Wambercourt', 'France', 'Europe', 'FRNC0975', 0),
(0, 'Wambez', 'France', 'Europe', 'FRPI1769', 0),
(0, 'Wambrechies', 'France', 'Europe', 'FRXX2043', 0),
(0, 'Wamin', 'France', 'Europe', 'FRNC0976', 0),
(0, 'Wanchy-Capval', 'France', 'Europe', 'FRXX6374', 0),
(0, 'Wancourt', 'France', 'Europe', 'FRNC0977', 0),
(0, 'Wandignies-Hamage', 'France', 'Europe', 'FRNC0978', 0),
(0, 'Wanel', 'France', 'Europe', 'FRPI1770', 0),
(0, 'Wangen', 'France', 'Europe', 'FRAL0619', 0),
(0, 'Wangenbourg-Engenthal', 'France', 'Europe', 'FRXX4418', 0),
(0, 'Wannehain', 'France', 'Europe', 'FRNC0979', 0),
(0, 'Wanquetin', 'France', 'Europe', 'FRNC0980', 0),
(0, 'Warcq', 'France', 'Europe', 'FRCA1665', 0),
(0, 'Warcq', 'France', 'Europe', 'FRLO1811', 0),
(0, 'Wardrecques', 'France', 'Europe', 'FRNC0981', 0),
(0, 'Warfusee-Abancourt', 'France', 'Europe', 'FRPI1771', 0),
(0, 'Wargemoulin-Hurlus', 'France', 'Europe', 'FRCA1666', 0),
(0, 'Wargnies', 'France', 'Europe', 'FRPI1772', 0),
(0, 'Wargnies-le-Grand', 'France', 'Europe', 'FRNC0982', 0),
(0, 'Wargnies-le-Petit', 'France', 'Europe', 'FRNC0983', 0),
(0, 'Warhem', 'France', 'Europe', 'FRNC0984', 0),
(0, 'Warlaing', 'France', 'Europe', 'FRNC0985', 0),
(0, 'Warlencourt-Eaucourt', 'France', 'Europe', 'FRNC0986', 0),
(0, 'Warlincourt-les-Pas', 'France', 'Europe', 'FRNC0987', 0),
(0, 'Warloy-Baillon', 'France', 'Europe', 'FRXX3693', 0),
(0, 'Warluis', 'France', 'Europe', 'FRPI1773', 0),
(0, 'Warlus', 'France', 'Europe', 'FRNC0988', 0),
(0, 'Warlus', 'France', 'Europe', 'FRPI1774', 0),
(0, 'Warluzel', 'France', 'Europe', 'FRNC0989', 0),
(0, 'Warmeriville', 'France', 'Europe', 'FRCA1667', 0),
(0, 'Warnecourt', 'France', 'Europe', 'FRCA1668', 0),
(0, 'Warneton', 'France', 'Europe', 'FRNC0990', 0),
(0, 'Warsy', 'France', 'Europe', 'FRPI1775', 0),
(0, 'Warvillers', 'France', 'Europe', 'FRPI1776', 0),
(0, 'Wasigny', 'France', 'Europe', 'FRCA1669', 0),
(0, 'Wasnes-au-Bac', 'France', 'Europe', 'FRNC0991', 0),
(0, 'Wasquehal', 'France', 'Europe', 'FRXX2849', 0),
(0, 'Wasselonne', 'France', 'Europe', 'FRXX4590', 0),
(0, 'Wasserbourg', 'France', 'Europe', 'FRAL0620', 0),
(0, 'Wassigny', 'France', 'Europe', 'FRPI1777', 0),
(0, 'Wassy', 'France', 'Europe', 'FRXX5349', 0),
(0, 'Watigny', 'France', 'Europe', 'FRPI1778', 0),
(0, 'Watronville', 'France', 'Europe', 'FRLO1812', 0),
(0, 'Watten', 'France', 'Europe', 'FRXX5056', 0),
(0, 'Xaffevillers', 'France', 'Europe', 'FRLO1826', 0),
(0, 'Xaintrailles', 'France', 'Europe', 'FRAQ1765', 0),
(0, 'Xaintray', 'France', 'Europe', 'FRPC1191', 0),
(0, 'Xambes', 'France', 'Europe', 'FRPC1192', 0),
(0, 'Xammes', 'France', 'Europe', 'FRLO1827', 0),
(0, 'Xamontarupt', 'France', 'Europe', 'FRLO1828', 0),
(0, 'Xanrey', 'France', 'Europe', 'FRLO1829', 0),
(0, 'Xanton-Chassenon', 'France', 'Europe', 'FRPL1068', 0),
(0, 'Xaronval', 'France', 'Europe', 'FRLO1830', 0),
(0, 'Xermamenil', 'France', 'Europe', 'FRLO1831', 0),
(0, 'Xertigny', 'France', 'Europe', 'FRLO1832', 0),
(0, 'Xeuilley', 'France', 'Europe', 'FRXX3655', 0),
(0, 'Xirocourt', 'France', 'Europe', 'FRLO1833', 0),
(0, 'Xivray-et-Marvoisin', 'France', 'Europe', 'FRLO1834', 0),
(0, 'Xivry-Circourt', 'France', 'Europe', 'FRLO1835', 0),
(0, 'Xocourt', 'France', 'Europe', 'FRLO1836', 0),
(0, 'Xonrupt-Longemer', 'France', 'Europe', 'FRLO1837', 0),
(0, 'Xonville', 'France', 'Europe', 'FRLO1838', 0),
(0, 'Xouaxange', 'France', 'Europe', 'FRLO1839', 0),
(0, 'Xousse', 'France', 'Europe', 'FRLO1840', 0),
(0, 'Xures', 'France', 'Europe', 'FRLO1841', 0),
(0, 'Y', 'France', 'Europe', 'FRPI1787', 0),
(0, 'Yainville', 'France', 'Europe', 'FRHN1010', 0),
(0, 'Yate', 'France', 'Europe', 'FRXX7953', 0),
(0, 'Yaucourt-Bussus', 'France', 'Europe', 'FRPI1788', 0),
(0, 'Ychoux', 'France', 'Europe', 'FRAQ1766', 0),
(0, 'Ydes', 'France', 'Europe', 'FRXX3970', 0),
(0, 'Yebleron', 'France', 'Europe', 'FRHN1011', 0),
(0, 'Yebles', 'France', 'Europe', 'FRIF0671', 0),
(0, 'Yenne', 'France', 'Europe', 'FRRA2165', 0),
(0, 'Yermenonville', 'France', 'Europe', 'FRCE1368', 0),
(0, 'Yerres', 'France', 'Europe', 'FRXX6774', 0),
(0, 'Yerville', 'France', 'Europe', 'FRHN1012', 0),
(0, 'Yevre-la-Ville', 'France', 'Europe', 'FRCE1369', 0),
(0, 'Yevre-le-Chatel', 'France', 'Europe', 'FRCE1370', 0),
(0, 'Yevres', 'France', 'Europe', 'FRCE1371', 0),
(0, 'Yevres-le-Petit', 'France', 'Europe', 'FRCA1672', 0),
(0, 'Yffiniac', 'France', 'Europe', 'FRXX6150', 0),
(0, 'Ygos-Saint-Saturnin', 'France', 'Europe', 'FRXX6608', 0),
(0, 'Ygrande', 'France', 'Europe', 'FRAU0950', 0),
(0, 'Ymare', 'France', 'Europe', 'FRHN1013', 0),
(0, 'Ymeray', 'France', 'Europe', 'FRCE1372', 0),
(0, 'Ymonville', 'France', 'Europe', 'FRCE1373', 0),
(0, 'Yolet', 'France', 'Europe', 'FRAU0951', 0),
(0, 'Yoncq', 'France', 'Europe', 'FRCA1673', 0),
(0, 'Yonval', 'France', 'Europe', 'FRPI1789', 0),
(0, 'Youx', 'France', 'Europe', 'FRAU0952', 0),
(0, 'Yport', 'France', 'Europe', 'FRHN1014', 0),
(0, 'Ypreville', 'France', 'Europe', 'FRHN1015', 0),
(0, 'Ypreville-Biville', 'France', 'Europe', 'FRHN1016', 0),
(0, 'Yquebeuf', 'France', 'Europe', 'FRHN1017', 0),
(0, 'Yquelon', 'France', 'Europe', 'FRBN1505', 0),
(0, 'Yronde-et-Buron', 'France', 'Europe', 'FRAU0953', 0),
(0, 'Yrouerre', 'France', 'Europe', 'FRBO1565', 0),
(0, 'Yssac-la-Tourette', 'France', 'Europe', 'FRAU0954', 0),
(0, 'Yssandon', 'France', 'Europe', 'FRLI0571', 0),
(0, 'Yssingeaux', 'France', 'Europe', 'FRXX1927', 0),
(0, 'Ytrac', 'France', 'Europe', 'FRAU0955', 0),
(0, 'Ytres', 'France', 'Europe', 'FRNC1017', 0),
(0, 'Yutz', 'France', 'Europe', 'FRXX5193', 0),
(0, 'Yvecrique', 'France', 'Europe', 'FRHN1018', 0),
(0, 'Yvernaumont', 'France', 'Europe', 'FRCA1674', 0),
(0, 'Yversay', 'France', 'Europe', 'FRPC1193', 0),
(0, 'Yves', 'France', 'Europe', 'FRXX6186', 0),
(0, 'Yvetot', 'France', 'Europe', 'FRXX6530', 0),
(0, 'Yvetot-Bocage', 'France', 'Europe', 'FRBN1506', 0),
(0, 'Yvias', 'France', 'Europe', 'FRXX5533', 0),
(0, 'Yviers', 'France', 'Europe', 'FRPC1194', 0),
(0, 'Yvignac-la-Tour', 'France', 'Europe', 'FRBR0788', 0),
(0, 'Yville-sur-Seine', 'France', 'Europe', 'FRHN1019', 0),
(0, 'Yvoire', 'France', 'Europe', 'FRRA2166', 0),
(0, 'Yvoy-le-Marron', 'France', 'Europe', 'FRCE1374', 0),
(0, 'Yvrac', 'France', 'Europe', 'FRAQ1767', 0),
(0, 'Yvrac-et-Malleyrand', 'France', 'Europe', 'FRPC1195', 0),
(0, 'Yvrandes', 'France', 'Europe', 'FRBN1507', 0),
(0, 'Yvre-l`Eveque', 'France', 'Europe', 'FRXX2670', 0),
(0, 'Yvre-le-Polin', 'France', 'Europe', 'FRXX2668', 0),
(0, 'Yvrench', 'France', 'Europe', 'FRPI1790', 0),
(0, 'Yvrencheux', 'France', 'Europe', 'FRPI1791', 0),
(0, 'Yzengremer', 'France', 'Europe', 'FRPI1792', 0),
(0, 'Yzernay', 'France', 'Europe', 'FRPL1069', 0),
(0, 'Yzeron', 'France', 'Europe', 'FRRA2167', 0),
(0, 'Yzeure', 'France', 'Europe', 'FRAU0956', 0),
(0, 'Yzeures-sur-Creuse', 'France', 'Europe', 'FRXX2333', 0),
(0, 'Yzeux', 'France', 'Europe', 'FRPI1793', 0),
(0, 'Yzosse', 'France', 'Europe', 'FRAQ1768', 0),
(0, 'Zaessingue', 'France', 'Europe', 'FRAL0669', 0),
(0, 'Zalana', 'France', 'Europe', 'FRXX5571', 0),
(0, 'Zarbeling', 'France', 'Europe', 'FRLO1842', 0),
(0, 'Zegerscappel', 'France', 'Europe', 'FRNC1018', 0),
(0, 'Zehnacker', 'France', 'Europe', 'FRAL0670', 0),
(0, 'Zeinheim', 'France', 'Europe', 'FRAL0671', 0),
(0, 'Zellenberg', 'France', 'Europe', 'FRAL0672', 0),
(0, 'Zellwiller', 'France', 'Europe', 'FRAL0673', 0),
(0, 'Zermezeele', 'France', 'Europe', 'FRNC1019', 0),
(0, 'Zerubia', 'France', 'Europe', 'FRXX3986', 0),
(0, 'Zetting', 'France', 'Europe', 'FRLO1843', 0),
(0, 'Zevaco', 'France', 'Europe', 'FRXX1027', 0),
(0, 'Zicavo', 'France', 'Europe', 'FRXX2465', 0),
(0, 'Zigliara', 'France', 'Europe', 'FRCO0236', 0),
(0, 'Zilia', 'France', 'Europe', 'FRCO0237', 0),
(0, 'Zilling', 'France', 'Europe', 'FRLO1844', 0),
(0, 'Zillisheim', 'France', 'Europe', 'FRAL0674', 0),
(0, 'Zimmerbach', 'France', 'Europe', 'FRAL0675', 0),
(0, 'Zimmersheim', 'France', 'Europe', 'FRAL0676', 0),
(0, 'Zimming', 'France', 'Europe', 'FRLO1845', 0),
(0, 'Zincourt', 'France', 'Europe', 'FRLO1846', 0),
(0, 'Zinswiller', 'France', 'Europe', 'FRAL0677', 0),
(0, 'Zittersheim', 'France', 'Europe', 'FRAL0678', 0),
(0, 'Zoebersdorf', 'France', 'Europe', 'FRAL0679', 0),
(0, 'Zollingen', 'France', 'Europe', 'FRAL0680', 0),
(0, 'Zommange', 'France', 'Europe', 'FRLO1847', 0),
(0, 'Zonza', 'France', 'Europe', 'FRXX1800', 0),
(0, 'Zoteux', 'France', 'Europe', 'FRNC1020', 0),
(0, 'Zouafques', 'France', 'Europe', 'FRNC1021', 0),
(0, 'Zoufftgen', 'France', 'Europe', 'FRLO1848', 0),
(0, 'Zoza', 'France', 'Europe', 'FRCO0238', 0),
(0, 'Zuani', 'France', 'Europe', 'FRCO0239', 0),
(0, 'Zudausques', 'France', 'Europe', 'FRNC1022', 0),
(0, 'Zutkerque', 'France', 'Europe', 'FRNC1023', 0),
(0, 'Zutzendorf', 'France', 'Europe', 'FRAL0681', 0),
(0, 'Zuydcoote', 'France', 'Europe', 'FRXX4306', 0),
(0, 'Zuytpeene', 'France', 'Europe', 'FRNC1024', 0),
(0, 'Agassac', 'France', 'Europe', 'FRMP0004', 0),
(0, 'Agay', 'France', 'Europe', 'FRPA0002', 0),
(0, 'Agde', 'France', 'Europe', 'FRXX4397', 0),
(0, 'Agel', 'France', 'Europe', 'FRLR0003', 0),
(0, 'Agen', 'France', 'Europe', 'FRXX0135', 0),
(0, 'Agencourt', 'France', 'Europe', 'FRBO0003', 0),
(0, 'Agenville', 'France', 'Europe', 'FRPI0007', 0),
(0, 'Agenvillers', 'France', 'Europe', 'FRPI0008', 0),
(0, 'Ageville', 'France', 'Europe', 'FRCA0002', 0),
(0, 'Agey', 'France', 'Europe', 'FRBO0004', 0),
(0, 'Aghione', 'France', 'Europe', 'FRCO0001', 0),
(0, 'Agme', 'France', 'Europe', 'FRAQ0009', 0),
(0, 'Agneaux', 'France', 'Europe', 'FRBN0004', 0),
(0, 'Agnetz', 'France', 'Europe', 'FRPI0009', 0),
(0, 'Agnieres', 'France', 'Europe', 'FRNC0010', 0),
(0, 'Agnieres', 'France', 'Europe', 'FRPI0010', 0),
(0, 'Agnin', 'France', 'Europe', 'FRRA0005', 0),
(0, 'Agnos', 'France', 'Europe', 'FRAQ0010', 0),
(0, 'Agny', 'France', 'Europe', 'FRNC0011', 0),
(0, 'Agon-Coutainville', 'France', 'Europe', 'FRXX2840', 0),
(0, 'Agones', 'France', 'Europe', 'FRLR0004', 0),
(0, 'Agonges', 'France', 'Europe', 'FRAU0002', 0),
(0, 'Agonnay', 'France', 'Europe', 'FRPC0004', 0),
(0, 'Agris', 'France', 'Europe', 'FRPC0005', 0),
(0, 'Agudelle', 'France', 'Europe', 'FRPC0006', 0),
(0, 'Aguessac', 'France', 'Europe', 'FRMP0005', 0),
(0, 'Aguilcourt', 'France', 'Europe', 'FRPI0011', 0),
(0, 'Agy', 'France', 'Europe', 'FRBN0005', 0),
(0, 'Ahe', 'France', 'Europe', 'FRXX7908', 0),
(0, 'Ahetze', 'France', 'Europe', 'FRAQ0011', 0),
(0, 'Aheville', 'France', 'Europe', 'FRLO0007', 0),
(0, 'Ahuille', 'France', 'Europe', 'FRPL0001', 0),
(0, 'Ahun', 'France', 'Europe', 'FRLI0002', 0),
(0, 'Ahuy', 'France', 'Europe', 'FRBO0005', 0),
(0, 'Aibes', 'France', 'Europe', 'FRXX3723', 0),
(0, 'Aibre', 'France', 'Europe', 'FRFC0012', 0),
(0, 'Aiffres', 'France', 'Europe', 'FRPC0007', 0),
(0, 'Aigaliers', 'France', 'Europe', 'FRPA0003', 0),
(0, 'Aiglepierre', 'France', 'Europe', 'FRFC0013', 0),
(0, 'Aiglun', 'France', 'Europe', 'FRPA0004', 0),
(0, 'Aiglun', 'France', 'Europe', 'FRPA0005', 0),
(0, 'Aignan', 'France', 'Europe', 'FRMP0006', 0),
(0, 'Aigne', 'France', 'Europe', 'FRLR0005', 0),
(0, 'Aigne', 'France', 'Europe', 'FRPL0002', 0),
(0, 'Aignerville', 'France', 'Europe', 'FRBN0006', 0),
(0, 'Aignes', 'France', 'Europe', 'FRMP0007', 0),
(0, 'Aigneville', 'France', 'Europe', 'FRPI0012', 0),
(0, 'Aigny', 'France', 'Europe', 'FRCA0003', 0),
(0, 'Aigonnay', 'France', 'Europe', 'FRPC0008', 0),
(0, 'Aigre', 'France', 'Europe', 'FRPC0009', 0),
(0, 'Aigrefeuille', 'France', 'Europe', 'FRMP0008', 0),
(0, 'Aigremont', 'France', 'Europe', 'FRBO0006', 0),
(0, 'Aigremont', 'France', 'Europe', 'FRCA0004', 0),
(0, 'Aigremont', 'France', 'Europe', 'FRIF0004', 0),
(0, 'Aigremont', 'France', 'Europe', 'FRLR0006', 0),
(0, 'Aiguebelle', 'France', 'Europe', 'FRRA0006', 0),
(0, 'Aiguefonde', 'France', 'Europe', 'FRMP0009', 0),
(0, 'Aigueperse', 'France', 'Europe', 'FRRA0007', 0),
(0, 'Aigues-Juntes', 'France', 'Europe', 'FRMP0010', 0),
(0, 'Aigues-Vives', 'France', 'Europe', 'FRLR0007', 0),
(0, 'Aigues-Vives', 'France', 'Europe', 'FRLR0008', 0),
(0, 'Aigues-Vives', 'France', 'Europe', 'FRMP0011', 0),
(0, 'Aigues-Vives', 'France', 'Europe', 'FRXX6269', 0),
(0, 'Aigueze', 'France', 'Europe', 'FRRA0008', 0),
(0, 'Aiguilhe', 'France', 'Europe', 'FRAU0003', 0),
(0, 'Aiguilles', 'France', 'Europe', 'FRXX2409', 0),
(0, 'Aiguines', 'France', 'Europe', 'FRPA0006', 0),
(0, 'Ailhon', 'France', 'Europe', 'FRRA0009', 0),
(0, 'Aillas', 'France', 'Europe', 'FRAQ0012', 0),
(0, 'Ailleux', 'France', 'Europe', 'FRRA0010', 0),
(0, 'Aillevans', 'France', 'Europe', 'FRFC0014', 0),
(0, 'Ailleville', 'France', 'Europe', 'FRCA0005', 0),
(0, 'Aillianville', 'France', 'Europe', 'FRCA0006', 0),
(0, 'Aillieres-Beauvoir', 'France', 'Europe', 'FRPL0003', 0),
(0, 'Ailloncourt', 'France', 'Europe', 'FRFC0015', 0),
(0, 'Ailly', 'France', 'Europe', 'FRHN0002', 0),
(0, 'Ailly-sur-Somme', 'France', 'Europe', 'FRXX7004', 0),
(0, 'Aimargues', 'France', 'Europe', 'FRXX1137', 0),
(0, 'Ainay-le-Vieil', 'France', 'Europe', 'FRCE0003', 0),
(0, 'Aincourt', 'France', 'Europe', 'FRIF0005', 0),
(0, 'Balanzac', 'France', 'Europe', 'FRPC0062', 0),
(0, 'Balaruc-le-Vieux', 'France', 'Europe', 'FRLR0059', 0),
(0, 'Balaruc-les-Bains', 'France', 'Europe', 'FRXX3306', 0),
(0, 'Balatre', 'France', 'Europe', 'FRPI0094', 0),
(0, 'Balazuc', 'France', 'Europe', 'FRRA0111', 0),
(0, 'Balbigny', 'France', 'Europe', 'FRRA0112', 0),
(0, 'Balbronn', 'France', 'Europe', 'FRAL0010', 0),
(0, 'Baldersheim', 'France', 'Europe', 'FRAL0011', 0),
(0, 'Baleix', 'France', 'Europe', 'FRAQ0099', 0),
(0, 'Balesta', 'France', 'Europe', 'FRMP0163', 0),
(0, 'Baleyssagues', 'France', 'Europe', 'FRAQ0100', 0),
(0, 'Balgau', 'France', 'Europe', 'FRAL0012', 0),
(0, 'Balham', 'France', 'Europe', 'FRCA0077', 0),
(0, 'Balignac', 'France', 'Europe', 'FRMP0164', 0),
(0, 'Balignicourt', 'France', 'Europe', 'FRCA0078', 0),
(0, 'Balines', 'France', 'Europe', 'FRHN0028', 0),
(0, 'Balinghem', 'France', 'Europe', 'FRNC0067', 0),
(0, 'Baliros', 'France', 'Europe', 'FRAQ0101', 0),
(0, 'Balizac', 'France', 'Europe', 'FRAQ0102', 0),
(0, 'Ballainvilliers', 'France', 'Europe', 'FRIF0035', 0),
(0, 'Ballaison', 'France', 'Europe', 'FRRA0113', 0),
(0, 'Ballancourt-sur-Essonne', 'France', 'Europe', 'FRXX3054', 0),
(0, 'Ballans', 'France', 'Europe', 'FRPC0063', 0),
(0, 'Ballee', 'France', 'Europe', 'FRPL0034', 0),
(0, 'Balleville', 'France', 'Europe', 'FRLO0081', 0),
(0, 'Ballon', 'France', 'Europe', 'FRPL0035', 0),
(0, 'Ballons', 'France', 'Europe', 'FRRA0114', 0),
(0, 'Ballore', 'France', 'Europe', 'FRBO0055', 0),
(0, 'Ballots', 'France', 'Europe', 'FRPL0036', 0),
(0, 'Balloy', 'France', 'Europe', 'FRIF0036', 0),
(0, 'Balma', 'France', 'Europe', 'FRMP0165', 0),
(0, 'Balmont', 'France', 'Europe', 'FRXX1521', 0),
(0, 'Balogna', 'France', 'Europe', 'FRCO0014', 0),
(0, 'Balot', 'France', 'Europe', 'FRBO0056', 0),
(0, 'Balsac', 'France', 'Europe', 'FRMP0166', 0),
(0, 'Balschwiller', 'France', 'Europe', 'FRAL0013', 0),
(0, 'Baltzenheim', 'France', 'Europe', 'FRAL0014', 0),
(0, 'Balzac', 'France', 'Europe', 'FRPC0064', 0),
(0, 'Bambecque', 'France', 'Europe', 'FRNC0068', 0),
(0, 'Bambiderstroff', 'France', 'Europe', 'FRLO0082', 0),
(0, 'Ban-de-Sapt', 'France', 'Europe', 'FRLO0084', 0),
(0, 'Ban-Saint-Martin', 'France', 'Europe', 'FRLO0083', 0),
(0, 'Ban-sur-Meurthe-Clefcy', 'France', 'Europe', 'FRLO0085', 0),
(0, 'Banassac', 'France', 'Europe', 'FRLR0060', 0),
(0, 'Banat', 'France', 'Europe', 'FRMP0167', 0),
(0, 'Bancigny', 'France', 'Europe', 'FRPI0095', 0),
(0, 'Bancourt', 'France', 'Europe', 'FRNC0069', 0),
(0, 'Bandol', 'France', 'Europe', 'FRXX5732', 0),
(0, 'Bandraboua', 'France', 'Europe', 'FRXX7840', 0),
(0, 'Bandrele', 'France', 'Europe', 'FRXX7836', 0),
(0, 'Baneins', 'France', 'Europe', 'FRRA0115', 0),
(0, 'Banios', 'France', 'Europe', 'FRMP0168', 0),
(0, 'Banize', 'France', 'Europe', 'FRLI0026', 0),
(0, 'Bannans', 'France', 'Europe', 'FRFC0092', 0),
(0, 'Bannay', 'France', 'Europe', 'FRCA0079', 0),
(0, 'Bannay', 'France', 'Europe', 'FRLO0086', 0),
(0, 'Banne', 'France', 'Europe', 'FRRA0116', 0),
(0, 'Bannes', 'France', 'Europe', 'FRCA0080', 0),
(0, 'Bannes', 'France', 'Europe', 'FRCA0081', 0),
(0, 'Bannes', 'France', 'Europe', 'FRMP0169', 0),
(0, 'Bannes', 'France', 'Europe', 'FRPL0037', 0),
(0, 'Bannoncourt', 'France', 'Europe', 'FRLO0087', 0),
(0, 'Bannost-Villegagnon', 'France', 'Europe', 'FRIF0037', 0),
(0, 'Banon', 'France', 'Europe', 'FRPA0034', 0),
(0, 'Banos', 'France', 'Europe', 'FRAQ0103', 0),
(0, 'Bans', 'France', 'Europe', 'FRFC0093', 0),
(0, 'Banteux', 'France', 'Europe', 'FRNC0070', 0),
(0, 'Banthelu', 'France', 'Europe', 'FRIF0038', 0),
(0, 'Bantheville', 'France', 'Europe', 'FRLO0088', 0),
(0, 'Bantigny', 'France', 'Europe', 'FRNC0071', 0),
(0, 'Bantouzelle', 'France', 'Europe', 'FRNC0072', 0),
(0, 'Banvillars', 'France', 'Europe', 'FRMP0170', 0),
(0, 'Banville', 'France', 'Europe', 'FRBN0048', 0),
(0, 'Banvou', 'France', 'Europe', 'FRBN0049', 0),
(0, 'Banyuls de la Marenda', 'France', 'Europe', 'FRXX2787', 0),
(0, 'Baon', 'France', 'Europe', 'FRBO0057', 0),
(0, 'Bar', 'France', 'Europe', 'FRLI0027', 0),
(0, 'Bar-le-Duc', 'France', 'Europe', 'FRXX0203', 0),
(0, 'Barace', 'France', 'Europe', 'FRPL0038', 0),
(0, 'Baraigne', 'France', 'Europe', 'FRLR0061', 0),
(0, 'Calavante', 'France', 'Europe', 'FRMP0386', 0),
(0, 'Calcatoggio', 'France', 'Europe', 'FRXX6206', 0),
(0, 'Cales', 'France', 'Europe', 'FRAQ0241', 0),
(0, 'Cales', 'France', 'Europe', 'FRMP0387', 0),
(0, 'Calignac', 'France', 'Europe', 'FRAQ0242', 0),
(0, 'Caligny', 'France', 'Europe', 'FRBN0160', 0),
(0, 'Callas', 'France', 'Europe', 'FRPA0088', 0),
(0, 'Callen', 'France', 'Europe', 'FRAQ0243', 0),
(0, 'Calleville', 'France', 'Europe', 'FRHN0114', 0),
(0, 'Callian', 'France', 'Europe', 'FRMP0388', 0),
(0, 'Callian', 'France', 'Europe', 'FRPA0089', 0),
(0, 'Calmont', 'France', 'Europe', 'FRMP0389', 0),
(0, 'Calmoutier', 'France', 'Europe', 'FRFC0205', 0),
(0, 'Caloire', 'France', 'Europe', 'FRRA0246', 0),
(0, 'Calonges', 'France', 'Europe', 'FRAQ0244', 0),
(0, 'Calorguen', 'France', 'Europe', 'FRBR0004', 0),
(0, 'Caluire-et-Cuire', 'France', 'Europe', 'FRXX5687', 0),
(0, 'Calviac', 'France', 'Europe', 'FRMP0390', 0),
(0, 'Calviac-en-Perigord', 'France', 'Europe', 'FRAQ0245', 0),
(0, 'Calvignac', 'France', 'Europe', 'FRMP0391', 0),
(0, 'Calvinet', 'France', 'Europe', 'FRAU0088', 0),
(0, 'Calvisson', 'France', 'Europe', 'FRXX1128', 0),
(0, 'Calzan', 'France', 'Europe', 'FRMP0392', 0),
(0, 'Camales', 'France', 'Europe', 'FRMP0393', 0),
(0, 'Camarade', 'France', 'Europe', 'FRMP0394', 0),
(0, 'Camarsac', 'France', 'Europe', 'FRAQ0246', 0),
(0, 'Cambayrac', 'France', 'Europe', 'FRMP0395', 0),
(0, 'Cambernard', 'France', 'Europe', 'FRMP0396', 0),
(0, 'Cambernon', 'France', 'Europe', 'FRBN0161', 0),
(0, 'Cambes', 'France', 'Europe', 'FRAQ0247', 0),
(0, 'Cambes', 'France', 'Europe', 'FRAQ0248', 0),
(0, 'Cambes', 'France', 'Europe', 'FRMP0397', 0),
(0, 'Cambia', 'France', 'Europe', 'FRCO0026', 0),
(0, 'Cambiac', 'France', 'Europe', 'FRMP0398', 0),
(0, 'Cambieure', 'France', 'Europe', 'FRLR0117', 0),
(0, 'Camblain-Chatelain', 'France', 'Europe', 'FRXX5708', 0),
(0, 'Cambligneul', 'France', 'Europe', 'FRNC0191', 0),
(0, 'Cambon', 'France', 'Europe', 'FRMP0399', 0),
(0, 'Cambon-les-Lavaur', 'France', 'Europe', 'FRMP0400', 0),
(0, 'Camboulazet', 'France', 'Europe', 'FRMP0401', 0),
(0, 'Camboulit', 'France', 'Europe', 'FRMP0402', 0),
(0, 'Cambounes', 'France', 'Europe', 'FRMP0403', 0),
(0, 'Cambrai', 'France', 'Europe', 'FRXX0145', 0),
(0, 'Cambremer', 'France', 'Europe', 'FRBN0162', 0),
(0, 'Cambron', 'France', 'Europe', 'FRPI0269', 0),
(0, 'Camburat', 'France', 'Europe', 'FRMP0404', 0),
(0, 'Camelin', 'France', 'Europe', 'FRPI0270', 0),
(0, 'Cametours', 'France', 'Europe', 'FRBN0163', 0),
(0, 'Camiers', 'France', 'Europe', 'FRNC0192', 0),
(0, 'Camiran', 'France', 'Europe', 'FRAQ0249', 0),
(0, 'Camjac', 'France', 'Europe', 'FRMP0405', 0),
(0, 'Camon', 'France', 'Europe', 'FRMP0406', 0),
(0, 'Camon', 'France', 'Europe', 'FRPI0271', 0),
(0, 'Camopi', 'France', 'Europe', 'FRXX7783', 0),
(0, 'Camous', 'France', 'Europe', 'FRMP0407', 0),
(0, 'Campagnac', 'France', 'Europe', 'FRMP0408', 0),
(0, 'Campagnac', 'France', 'Europe', 'FRMP0409', 0),
(0, 'Campagnan', 'France', 'Europe', 'FRLR0118', 0),
(0, 'Campagne', 'France', 'Europe', 'FRAQ0250', 0),
(0, 'Campagne', 'France', 'Europe', 'FRLR0119', 0),
(0, 'Campagne', 'France', 'Europe', 'FRPI0272', 0),
(0, 'Campagnolles', 'France', 'Europe', 'FRBN0164', 0),
(0, 'Campan', 'France', 'Europe', 'FRMP0410', 0),
(0, 'Camparan', 'France', 'Europe', 'FRMP0411', 0),
(0, 'Campeaux', 'France', 'Europe', 'FRBN0165', 0),
(0, 'Campeaux', 'France', 'Europe', 'FRPI0273', 0),
(0, 'Campes', 'France', 'Europe', 'FRMP0412', 0),
(0, 'Campi', 'France', 'Europe', 'FRCO0027', 0),
(0, 'Campigneulles-les-Grandes', 'France', 'Europe', 'FRNC0193', 0),
(0, 'Campigneulles-les-Petites', 'France', 'Europe', 'FRNC0194', 0),
(0, 'Campigny', 'France', 'Europe', 'FRBN0166', 0),
(0, 'Campigny', 'France', 'Europe', 'FRHN0115', 0),
(0, 'Campile', 'France', 'Europe', 'FRCO0028', 0),
(0, 'Campistrous', 'France', 'Europe', 'FRMP0413', 0),
(0, 'Campitello', 'France', 'Europe', 'FRCO0029', 0),
(0, 'Camplong', 'France', 'Europe', 'FRLR0120', 0),
(0, 'Campneuseville', 'France', 'Europe', 'FRHN0116', 0),
(0, 'Campo', 'France', 'Europe', 'FRCO0030', 0),
(0, 'Campremy', 'France', 'Europe', 'FRPI0274', 0),
(0, 'Camprieu', 'France', 'Europe', 'FRLR0121', 0),
(0, 'Danze', 'France', 'Europe', 'FRCE0267', 0),
(0, 'Daon', 'France', 'Europe', 'FRPL0188', 0),
(0, 'Daours', 'France', 'Europe', 'FRPI0439', 0),
(0, 'Darazac', 'France', 'Europe', 'FRLI0108', 0),
(0, 'Darbonnay', 'France', 'Europe', 'FRFC0390', 0),
(0, 'Darbres', 'France', 'Europe', 'FRRA0472', 0),
(0, 'Darcey', 'France', 'Europe', 'FRBO0345', 0),
(0, 'Dardenac', 'France', 'Europe', 'FRAQ0372', 0),
(0, 'Dardenay', 'France', 'Europe', 'FRCA0359', 0),
(0, 'Dardez', 'France', 'Europe', 'FRHN0177', 0),
(0, 'Dardilly', 'France', 'Europe', 'FRXX5152', 0),
(0, 'Dareize', 'France', 'Europe', 'FRRA0473', 0),
(0, 'Dargies', 'France', 'Europe', 'FRPI0440', 0),
(0, 'Dargnies', 'France', 'Europe', 'FRXX5911', 0),
(0, 'Darmannes', 'France', 'Europe', 'FRCA0360', 0),
(0, 'Darmont', 'France', 'Europe', 'FRLO0353', 0),
(0, 'Darnac', 'France', 'Europe', 'FRLI0109', 0),
(0, 'Darnetal', 'France', 'Europe', 'FRHN0178', 0),
(0, 'Darnets', 'France', 'Europe', 'FRLI0110', 0),
(0, 'Darney', 'France', 'Europe', 'FRLO0354', 0),
(0, 'Darnieulles', 'France', 'Europe', 'FRLO0355', 0),
(0, 'Darois', 'France', 'Europe', 'FRBO0346', 0),
(0, 'Darvault', 'France', 'Europe', 'FRIF0167', 0),
(0, 'Darvoy', 'France', 'Europe', 'FRCE0268', 0),
(0, 'Dasle', 'France', 'Europe', 'FRFC0391', 0),
(0, 'Daubensand', 'France', 'Europe', 'FRAL0082', 0),
(0, 'Daubeze', 'France', 'Europe', 'FRAQ0373', 0),
(0, 'Daudes', 'France', 'Europe', 'FRCA0361', 0),
(0, 'Daumeray', 'France', 'Europe', 'FRXX2979', 0),
(0, 'Dausse', 'France', 'Europe', 'FRAQ0374', 0),
(0, 'Daux', 'France', 'Europe', 'FRMP0597', 0),
(0, 'Davaye', 'France', 'Europe', 'FRBO0347', 0),
(0, 'Davejean', 'France', 'Europe', 'FRLR0210', 0),
(0, 'Davenescourt', 'France', 'Europe', 'FRPI0441', 0),
(0, 'Davezieux', 'France', 'Europe', 'FRRA0474', 0),
(0, 'Davignac', 'France', 'Europe', 'FRLI0111', 0),
(0, 'Davrey', 'France', 'Europe', 'FRCA0362', 0),
(0, 'Davron', 'France', 'Europe', 'FRIF0168', 0),
(0, 'Dax', 'France', 'Europe', 'FRXX0149', 0),
(0, 'Deauville', 'France', 'Europe', 'FRXX0150', 0),
(0, 'Deaux', 'France', 'Europe', 'FRLR0211', 0),
(0, 'Decazeville', 'France', 'Europe', 'FRXX0334', 0),
(0, 'Dechy', 'France', 'Europe', 'FRXX4101', 0),
(0, 'Dedeling', 'France', 'Europe', 'FRLO0356', 0),
(0, 'Degagnac', 'France', 'Europe', 'FRMP0598', 0),
(0, 'Degre', 'France', 'Europe', 'FRPL0189', 0),
(0, 'Dehault', 'France', 'Europe', 'FRPL0190', 0),
(0, 'Deheries', 'France', 'Europe', 'FRNC0261', 0),
(0, 'Dehlingen', 'France', 'Europe', 'FRAL0083', 0),
(0, 'Deinvillers', 'France', 'Europe', 'FRLO0357', 0),
(0, 'Delain', 'France', 'Europe', 'FRFC0392', 0),
(0, 'Delettes', 'France', 'Europe', 'FRNC0262', 0),
(0, 'Delincourt', 'France', 'Europe', 'FRPI0442', 0),
(0, 'Delouze-Rosieres', 'France', 'Europe', 'FRLO0358', 0),
(0, 'Delut', 'France', 'Europe', 'FRLO0359', 0),
(0, 'Deluz', 'France', 'Europe', 'FRXX1864', 0),
(0, 'Demangevelle', 'France', 'Europe', 'FRFC0393', 0),
(0, 'Dembeni', 'France', 'Europe', 'FRXX7841', 0),
(0, 'Demi-Quartier', 'France', 'Europe', 'FRRA0475', 0),
(0, 'Demigny', 'France', 'Europe', 'FRBO0348', 0),
(0, 'Demouville', 'France', 'Europe', 'FRXX3234', 0),
(0, 'Demu', 'France', 'Europe', 'FRMP0599', 0),
(0, 'Demuin', 'France', 'Europe', 'FRPI0443', 0),
(0, 'Denat', 'France', 'Europe', 'FRMP0600', 0),
(0, 'Denaze', 'France', 'Europe', 'FRPL0191', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Denee', 'France', 'Europe', 'FRPL0192', 0),
(0, 'Denestanville', 'France', 'Europe', 'FRHN0179', 0),
(0, 'Deneuille-les-Chantelle', 'France', 'Europe', 'FRAU0201', 0),
(0, 'Deneuvre', 'France', 'Europe', 'FRLO0360', 0),
(0, 'Denevre', 'France', 'Europe', 'FRFC0394', 0),
(0, 'Denezieres', 'France', 'Europe', 'FRFC0395', 0),
(0, 'Denguin', 'France', 'Europe', 'FRAQ0375', 0),
(0, 'Denice', 'France', 'Europe', 'FRRA0476', 0),
(0, 'Denier', 'France', 'Europe', 'FRNC0263', 0),
(0, 'Denipaire', 'France', 'Europe', 'FRLO0361', 0),
(0, 'Dennebroeucq', 'France', 'Europe', 'FRNC0264', 0),
(0, 'Denneville', 'France', 'Europe', 'FRBN0303', 0),
(0, 'Dennevy', 'France', 'Europe', 'FRBO0349', 0),
(0, 'Denney', 'France', 'Europe', 'FRMP0601', 0),
(0, 'Denonville', 'France', 'Europe', 'FRCE0269', 0),
(0, 'Ecos', 'France', 'Europe', 'FRHN0193', 0),
(0, 'Ecot', 'France', 'Europe', 'FRFC0424', 0),
(0, 'Ecots', 'France', 'Europe', 'FRBN0325', 0),
(0, 'Ecouche', 'France', 'Europe', 'FRBN0326', 0),
(0, 'Ecouen', 'France', 'Europe', 'FRXX3127', 0),
(0, 'Ecouflant', 'France', 'Europe', 'FRXX1702', 0),
(0, 'Ecouis', 'France', 'Europe', 'FRHN0194', 0),
(0, 'Ecourt-Saint-Quentin', 'France', 'Europe', 'FRNC0285', 0),
(0, 'Ecouviez', 'France', 'Europe', 'FRLO0405', 0),
(0, 'Ecoyeux', 'France', 'Europe', 'FRPC0301', 0),
(0, 'Ecquedecques', 'France', 'Europe', 'FRNC0286', 0),
(0, 'Ecques', 'France', 'Europe', 'FRNC0287', 0),
(0, 'Ecquetot', 'France', 'Europe', 'FRHN0195', 0),
(0, 'Ecquevilly', 'France', 'Europe', 'FRXX2084', 0),
(0, 'Ecrainville', 'France', 'Europe', 'FRHN0196', 0),
(0, 'Ecrammeville', 'France', 'Europe', 'FRBN0327', 0),
(0, 'Ecriennes', 'France', 'Europe', 'FRCA0400', 0),
(0, 'Ecrille', 'France', 'Europe', 'FRFC0425', 0),
(0, 'Ecromagny', 'France', 'Europe', 'FRFC0426', 0),
(0, 'Ecrosnes', 'France', 'Europe', 'FRCE0288', 0),
(0, 'Ecrouves', 'France', 'Europe', 'FRLO0406', 0),
(0, 'Ecuble', 'France', 'Europe', 'FRCE0289', 0),
(0, 'Ecueil', 'France', 'Europe', 'FRCA0401', 0),
(0, 'Ecueille', 'France', 'Europe', 'FRCE0290', 0),
(0, 'Ecuelin', 'France', 'Europe', 'FRNC0288', 0),
(0, 'Ecuelle', 'France', 'Europe', 'FRFC0427', 0),
(0, 'Ecuelles', 'France', 'Europe', 'FRBO0377', 0),
(0, 'Ecuelles', 'France', 'Europe', 'FRIF0176', 0),
(0, 'Ecuille', 'France', 'Europe', 'FRPL0206', 0),
(0, 'Ecuires', 'France', 'Europe', 'FRNC0289', 0),
(0, 'Ecuisses', 'France', 'Europe', 'FRBO0378', 0),
(0, 'Eculleville', 'France', 'Europe', 'FRBN0328', 0),
(0, 'Ecully', 'France', 'Europe', 'FRXX3395', 0),
(0, 'Ecurat', 'France', 'Europe', 'FRPC0302', 0),
(0, 'Ecurcey', 'France', 'Europe', 'FRFC0428', 0),
(0, 'Ecurie', 'France', 'Europe', 'FRNC0290', 0),
(0, 'Ecutigny', 'France', 'Europe', 'FRBO0379', 0),
(0, 'Ecuvilly', 'France', 'Europe', 'FRPI0480', 0),
(0, 'Edon', 'France', 'Europe', 'FRPC0303', 0),
(0, 'Eecke', 'France', 'Europe', 'FRNC0291', 0),
(0, 'Effiat', 'France', 'Europe', 'FRAU0219', 0),
(0, 'Effincourt', 'France', 'Europe', 'FRCA0402', 0),
(0, 'Effry', 'France', 'Europe', 'FRPI0481', 0),
(0, 'Egleny', 'France', 'Europe', 'FRBO0380', 0),
(0, 'Egletons', 'France', 'Europe', 'FRLI0121', 0),
(0, 'Egligny', 'France', 'Europe', 'FRXX3669', 0),
(0, 'Eglingen', 'France', 'Europe', 'FRAL0108', 0),
(0, 'Eglisolles', 'France', 'Europe', 'FRAU0220', 0),
(0, 'Egly', 'France', 'Europe', 'FRXX2961', 0),
(0, 'Egreville', 'France', 'Europe', 'FRXX2624', 0),
(0, 'Egry', 'France', 'Europe', 'FRCE0291', 0),
(0, 'Eguelshardt', 'France', 'Europe', 'FRLO0407', 0),
(0, 'Eguenigue', 'France', 'Europe', 'FRMP0627', 0),
(0, 'Eguilles', 'France', 'Europe', 'FRXX1077', 0),
(0, 'Eguilley', 'France', 'Europe', 'FRFC0429', 0),
(0, 'Eguilly', 'France', 'Europe', 'FRBO0381', 0),
(0, 'Eguzon-Chantome', 'France', 'Europe', 'FRCE0292', 0),
(0, 'Ehuns', 'France', 'Europe', 'FRFC0430', 0),
(0, 'Eichhoffen', 'France', 'Europe', 'FRAL0109', 0),
(0, 'Eincheville', 'France', 'Europe', 'FRLO0408', 0),
(0, 'Eix', 'France', 'Europe', 'FRLO0409', 0),
(0, 'el Pertus', 'France', 'Europe', 'FRLR0985', 0),
(0, 'Elancourt', 'France', 'Europe', 'FRXX3762', 0),
(0, 'Elbach', 'France', 'Europe', 'FRAL0110', 0),
(0, 'Elencourt', 'France', 'Europe', 'FRPI0482', 0),
(0, 'Elesmes', 'France', 'Europe', 'FRNC0292', 0),
(0, 'Eletot', 'France', 'Europe', 'FRHN0197', 0),
(0, 'Elincourt', 'France', 'Europe', 'FRNC0293', 0),
(0, 'Elincourt-Sainte-Marguerite', 'France', 'Europe', 'FRXX4295', 0),
(0, 'Elise-Daucourt', 'France', 'Europe', 'FRCA0403', 0),
(0, 'Ellecourt', 'France', 'Europe', 'FRHN0198', 0),
(0, 'Elliant', 'France', 'Europe', 'FRXX1760', 0),
(0, 'Ellon', 'France', 'Europe', 'FRBN0329', 0),
(0, 'Elnes', 'France', 'Europe', 'FRNC0294', 0),
(0, 'Eloie', 'France', 'Europe', 'FRMP0628', 0),
(0, 'Eloise', 'France', 'Europe', 'FRRA0517', 0),
(0, 'Eloyes', 'France', 'Europe', 'FRXX2259', 0),
(0, 'Elsenheim', 'France', 'Europe', 'FRAL0111', 0),
(0, 'Elvange', 'France', 'Europe', 'FRLO0410', 0),
(0, 'Elysee', 'France', 'Europe', 'FRXX4328', 0),
(0, 'Fauverney', 'France', 'Europe', 'FRBO0406', 0),
(0, 'Fauville', 'France', 'Europe', 'FRHN0225', 0),
(0, 'Faux', 'France', 'Europe', 'FRAQ0442', 0),
(0, 'Faux', 'France', 'Europe', 'FRCA0433', 0),
(0, 'Faux-Fresnay', 'France', 'Europe', 'FRCA0434', 0),
(0, 'Faux-Mazuras', 'France', 'Europe', 'FRLI0131', 0),
(0, 'Faux-Villecerf', 'France', 'Europe', 'FRCA0435', 0),
(0, 'Favalello', 'France', 'Europe', 'FRCO0065', 0),
(0, 'Favars', 'France', 'Europe', 'FRLI0132', 0),
(0, 'Faveraye-Machelles', 'France', 'Europe', 'FRPL0216', 0),
(0, 'Faverdines', 'France', 'Europe', 'FRCE0309', 0),
(0, 'Faverelles', 'France', 'Europe', 'FRCE0310', 0),
(0, 'Faverges', 'France', 'Europe', 'FRRA0561', 0),
(0, 'Faverois', 'France', 'Europe', 'FRMP0703', 0),
(0, 'Faverolles', 'France', 'Europe', 'FRBN0351', 0),
(0, 'Faverolles', 'France', 'Europe', 'FRCA0436', 0),
(0, 'Faverolles', 'France', 'Europe', 'FRCE0311', 0),
(0, 'Faverolles', 'France', 'Europe', 'FRCE0312', 0),
(0, 'Faverolles', 'France', 'Europe', 'FRPI0542', 0),
(0, 'Faverolles', 'France', 'Europe', 'FRPI0543', 0),
(0, 'Favieres', 'France', 'Europe', 'FRCE0313', 0),
(0, 'Favieres', 'France', 'Europe', 'FRIF0189', 0),
(0, 'Favieres', 'France', 'Europe', 'FRLO0443', 0),
(0, 'Favieres', 'France', 'Europe', 'FRPI0544', 0),
(0, 'Favray', 'France', 'Europe', 'FRXX0225', 0),
(0, 'Favresse', 'France', 'Europe', 'FRCA0437', 0),
(0, 'Favreuil', 'France', 'Europe', 'FRNC0338', 0),
(0, 'Favrieux', 'France', 'Europe', 'FRIF0190', 0),
(0, 'Fay', 'France', 'Europe', 'FRBN0352', 0),
(0, 'Fay', 'France', 'Europe', 'FRPI0545', 0),
(0, 'Fay', 'France', 'Europe', 'FRPL0217', 0),
(0, 'Faycelles', 'France', 'Europe', 'FRMP0704', 0),
(0, 'Faye', 'France', 'Europe', 'FRCE0314', 0),
(0, 'Fayence', 'France', 'Europe', 'FRPA0175', 0),
(0, 'Fayet', 'France', 'Europe', 'FRMP0705', 0),
(0, 'Fayet', 'France', 'Europe', 'FRPI0546', 0),
(0, 'Faymont', 'France', 'Europe', 'FRFC0465', 0),
(0, 'Faymoreau', 'France', 'Europe', 'FRPL0218', 0),
(0, 'Fays', 'France', 'Europe', 'FRCA0438', 0),
(0, 'Fays', 'France', 'Europe', 'FRLO0444', 0),
(0, 'Fayssac', 'France', 'Europe', 'FRMP0706', 0),
(0, 'Feas', 'France', 'Europe', 'FRAQ0443', 0),
(0, 'Febvin-Palfart', 'France', 'Europe', 'FRNC0339', 0),
(0, 'Fechain', 'France', 'Europe', 'FRNC0340', 0),
(0, 'Fecocourt', 'France', 'Europe', 'FRLO0445', 0),
(0, 'Fedry', 'France', 'Europe', 'FRFC0466', 0),
(0, 'Fegersheim', 'France', 'Europe', 'FRAL0124', 0),
(0, 'Feigeres', 'France', 'Europe', 'FRRA0562', 0),
(0, 'Feigneux', 'France', 'Europe', 'FRPI0547', 0),
(0, 'Feignies', 'France', 'Europe', 'FRXX2067', 0),
(0, 'Feillens', 'France', 'Europe', 'FRRA0563', 0),
(0, 'Feings', 'France', 'Europe', 'FRBN0353', 0),
(0, 'Feings', 'France', 'Europe', 'FRCE0315', 0),
(0, 'Fel', 'France', 'Europe', 'FRBN0354', 0),
(0, 'Felce', 'France', 'Europe', 'FRCO0066', 0),
(0, 'Feldbach', 'France', 'Europe', 'FRAL0125', 0),
(0, 'Feldkirch', 'France', 'Europe', 'FRAL0126', 0),
(0, 'Feliceto', 'France', 'Europe', 'FRCO0067', 0),
(0, 'Felines', 'France', 'Europe', 'FRAU0237', 0),
(0, 'Felines', 'France', 'Europe', 'FRRA0564', 0),
(0, 'Felines-sur-Rimandoule', 'France', 'Europe', 'FRRA0565', 0),
(0, 'Felleries', 'France', 'Europe', 'FRNC0341', 0),
(0, 'Felletin', 'France', 'Europe', 'FRLI0133', 0),
(0, 'Felon', 'France', 'Europe', 'FRMP0707', 0),
(0, 'Felzins', 'France', 'Europe', 'FRMP0708', 0),
(0, 'Fenain', 'France', 'Europe', 'FRXX6673', 0),
(0, 'Fenay', 'France', 'Europe', 'FRBO0407', 0),
(0, 'Fendeille', 'France', 'Europe', 'FRLR0231', 0),
(0, 'Fenery', 'France', 'Europe', 'FRPC0319', 0),
(0, 'Feneu', 'France', 'Europe', 'FRPL0219', 0),
(0, 'Feniers', 'France', 'Europe', 'FRLI0134', 0),
(0, 'Fenioux', 'France', 'Europe', 'FRPC0320', 0),
(0, 'Fenioux', 'France', 'Europe', 'FRPC0321', 0),
(0, 'Fenneviller', 'France', 'Europe', 'FRLO0446', 0),
(0, 'Fenols', 'France', 'Europe', 'FRMP0709', 0),
(0, 'Fenouillet', 'France', 'Europe', 'FRLR0232', 0),
(0, 'Fenouillet', 'France', 'Europe', 'FRMP0710', 0),
(0, 'Fepin', 'France', 'Europe', 'FRCA0439', 0),
(0, 'Ferdrupt', 'France', 'Europe', 'FRLO0447', 0),
(0, 'Fere-Champenoise', 'France', 'Europe', 'FRCA0440', 0),
(0, 'Gap', 'France', 'Europe', 'FRXX3892', 0),
(0, 'Gapennes', 'France', 'Europe', 'FRPI0633', 0),
(0, 'Gapree', 'France', 'Europe', 'FRBN0383', 0),
(0, 'Garac', 'France', 'Europe', 'FRMP0780', 0),
(0, 'Garancieres', 'France', 'Europe', 'FRXX6525', 0),
(0, 'Garancieres-en-Beauce', 'France', 'Europe', 'FRCE0342', 0),
(0, 'Garancieres-en-Drouais', 'France', 'Europe', 'FRCE0343', 0),
(0, 'Garanou', 'France', 'Europe', 'FRMP0781', 0),
(0, 'Garat', 'France', 'Europe', 'FRXX2522', 0),
(0, 'Garcelles-Secqueville', 'France', 'Europe', 'FRXX3937', 0),
(0, 'Garche', 'France', 'Europe', 'FRLO0506', 0),
(0, 'Garches', 'France', 'Europe', 'FRXX2935', 0),
(0, 'Garchizy', 'France', 'Europe', 'FRXX6536', 0),
(0, 'Garchy', 'France', 'Europe', 'FRBO0456', 0),
(0, 'Gardanne', 'France', 'Europe', 'FRXX1033', 0),
(0, 'Gardefort', 'France', 'Europe', 'FRCE0344', 0),
(0, 'Gardegan-et-Tourtirac', 'France', 'Europe', 'FRAQ0483', 0),
(0, 'Garderes', 'France', 'Europe', 'FRMP0782', 0),
(0, 'Gardes-le-Pontaroux', 'France', 'Europe', 'FRPC0344', 0),
(0, 'Gardie', 'France', 'Europe', 'FRLR0264', 0),
(0, 'Gardonne', 'France', 'Europe', 'FRAQ0484', 0),
(0, 'Gardouch', 'France', 'Europe', 'FRMP0783', 0),
(0, 'Garein', 'France', 'Europe', 'FRAQ0485', 0),
(0, 'Garencieres', 'France', 'Europe', 'FRHN0265', 0),
(0, 'Garennes-sur-Eure', 'France', 'Europe', 'FRXX4782', 0),
(0, 'Garentreville', 'France', 'Europe', 'FRIF0217', 0),
(0, 'Gareoult', 'France', 'Europe', 'FRPA0190', 0),
(0, 'Garganvillar', 'France', 'Europe', 'FRMP0784', 0),
(0, 'Gargas', 'France', 'Europe', 'FRMP0785', 0),
(0, 'Gargas', 'France', 'Europe', 'FRPA0191', 0),
(0, 'Gargenville', 'France', 'Europe', 'FRIF0218', 0),
(0, 'Garges-les-Gonesse', 'France', 'Europe', 'FRXX3871', 0),
(0, 'Gargilesse-Dampierre', 'France', 'Europe', 'FRCE0345', 0),
(0, 'Garidech', 'France', 'Europe', 'FRMP0786', 0),
(0, 'Garies', 'France', 'Europe', 'FRMP0787', 0),
(0, 'Garigny', 'France', 'Europe', 'FRCE0346', 0),
(0, 'Garin', 'France', 'Europe', 'FRMP0788', 0),
(0, 'Garindein', 'France', 'Europe', 'FRAQ0486', 0),
(0, 'Garlan', 'France', 'Europe', 'FRBR0012', 0),
(0, 'Garlede-Mondebat', 'France', 'Europe', 'FRAQ0487', 0),
(0, 'Garlin', 'France', 'Europe', 'FRAQ0488', 0),
(0, 'Garnat-sur-Engievre', 'France', 'Europe', 'FRAU0253', 0),
(0, 'Garnay', 'France', 'Europe', 'FRCE0347', 0),
(0, 'Garnerans', 'France', 'Europe', 'FRRA0592', 0),
(0, 'Garnetot', 'France', 'Europe', 'FRBN0384', 0),
(0, 'Garons', 'France', 'Europe', 'FRXX5450', 0),
(0, 'Garos', 'France', 'Europe', 'FRAQ0489', 0),
(0, 'Garravet', 'France', 'Europe', 'FRMP0789', 0),
(0, 'Garrebourg', 'France', 'Europe', 'FRLO0507', 0),
(0, 'Garrevaques', 'France', 'Europe', 'FRMP0790', 0),
(0, 'Garrey', 'France', 'Europe', 'FRAQ0490', 0),
(0, 'Garrigues', 'France', 'Europe', 'FRLR0265', 0),
(0, 'Garrigues', 'France', 'Europe', 'FRMP0791', 0),
(0, 'Garrigues-Sainte-Eulalie', 'France', 'Europe', 'FRPA0192', 0),
(0, 'Garris', 'France', 'Europe', 'FRAQ0491', 0),
(0, 'Garrosse', 'France', 'Europe', 'FRAQ0492', 0),
(0, 'Gars', 'France', 'Europe', 'FRPA0193', 0),
(0, 'Gartempe', 'France', 'Europe', 'FRLI0145', 0),
(0, 'Gas', 'France', 'Europe', 'FRCE0348', 0),
(0, 'Gasny', 'France', 'Europe', 'FRIF0219', 0),
(0, 'Gasques', 'France', 'Europe', 'FRMP0792', 0),
(0, 'Gassin', 'France', 'Europe', 'FRXX5028', 0),
(0, 'Gastes', 'France', 'Europe', 'FRAQ0493', 0),
(0, 'Gastines', 'France', 'Europe', 'FRPL0235', 0),
(0, 'Gastins', 'France', 'Europe', 'FRIF0220', 0),
(0, 'Gasville-Oiseme', 'France', 'Europe', 'FRCE0349', 0),
(0, 'Gatelles', 'France', 'Europe', 'FRCE0350', 0),
(0, 'Gatey', 'France', 'Europe', 'FRFC0517', 0),
(0, 'Gathemo', 'France', 'Europe', 'FRBN0385', 0),
(0, 'Gatteville-le-Phare', 'France', 'Europe', 'FRXX5364', 0),
(0, 'Gattieres', 'France', 'Europe', 'FRXX2414', 0),
(0, 'Gatuzieres', 'France', 'Europe', 'FRLR0266', 0),
(0, 'Gaubertin', 'France', 'Europe', 'FRCE0351', 0),
(0, 'Gauchin-Legal', 'France', 'Europe', 'FRXX6584', 0),
(0, 'Gauchin-Verloingt', 'France', 'Europe', 'FRNC0379', 0),
(0, 'Gauchy', 'France', 'Europe', 'FRXX5393', 0),
(0, 'Gauciel', 'France', 'Europe', 'FRHN0266', 0),
(0, 'Gaud', 'France', 'Europe', 'FRMP0793', 0),
(0, 'Gaudechart', 'France', 'Europe', 'FRPI0634', 0),
(0, 'Gaudent', 'France', 'Europe', 'FRMP0794', 0),
(0, 'Han-sur-Meuse', 'France', 'Europe', 'FRLO0620', 0),
(0, 'Han-sur-Nied', 'France', 'Europe', 'FRLO0621', 0),
(0, 'Hanc', 'France', 'Europe', 'FRPC0382', 0),
(0, 'Hanches', 'France', 'Europe', 'FRCE0386', 0),
(0, 'Hancourt', 'France', 'Europe', 'FRPI0715', 0),
(0, 'Handschuheim', 'France', 'Europe', 'FRXX6025', 0),
(0, 'Hane', 'France', 'Europe', 'FRXX7890', 0),
(0, 'Hangard', 'France', 'Europe', 'FRPI0716', 0),
(0, 'Hangenbieten', 'France', 'Europe', 'FRXX5163', 0),
(0, 'Hangest-en-Santerre', 'France', 'Europe', 'FRXX4477', 0),
(0, 'Hangest-sur-Somme', 'France', 'Europe', 'FRXX5202', 0),
(0, 'Hangviller', 'France', 'Europe', 'FRLO0622', 0),
(0, 'Hannaches', 'France', 'Europe', 'FRPI0717', 0),
(0, 'Hannapes', 'France', 'Europe', 'FRPI0718', 0),
(0, 'Hannappes', 'France', 'Europe', 'FRXX3253', 0),
(0, 'Hannescamps', 'France', 'Europe', 'FRNC0414', 0),
(0, 'Hannocourt', 'France', 'Europe', 'FRLO0623', 0),
(0, 'Hannogne-Saint-Martin', 'France', 'Europe', 'FRCA0542', 0),
(0, 'Hannogne-Saint-Remy', 'France', 'Europe', 'FRCA0543', 0),
(0, 'Hannonville-sous-les-Cotes', 'France', 'Europe', 'FRLO0625', 0),
(0, 'Hannonville-Suzemont', 'France', 'Europe', 'FRLO0624', 0),
(0, 'Hans', 'France', 'Europe', 'FRCA0544', 0),
(0, 'Hantay', 'France', 'Europe', 'FRNC0415', 0),
(0, 'Hanvec', 'France', 'Europe', 'FRBR0047', 0),
(0, 'Hanviller', 'France', 'Europe', 'FRLO0626', 0),
(0, 'Hanvoile', 'France', 'Europe', 'FRPI0719', 0),
(0, 'Hao', 'France', 'Europe', 'FRXX7905', 0),
(0, 'Haplincourt', 'France', 'Europe', 'FRNC0416', 0),
(0, 'Happencourt', 'France', 'Europe', 'FRPI0720', 0),
(0, 'Happonvilliers', 'France', 'Europe', 'FRCE0387', 0),
(0, 'Haramont', 'France', 'Europe', 'FRPI0721', 0),
(0, 'Haraucourt', 'France', 'Europe', 'FRCA0545', 0),
(0, 'Haraucourt', 'France', 'Europe', 'FRLO0627', 0),
(0, 'Haraucourt-sur-Seille', 'France', 'Europe', 'FRLO0628', 0),
(0, 'Haraumont', 'France', 'Europe', 'FRLO0629', 0),
(0, 'Haravesnes', 'France', 'Europe', 'FRNC0417', 0),
(0, 'Haravilliers', 'France', 'Europe', 'FRIF0246', 0),
(0, 'Harbonnieres', 'France', 'Europe', 'FRXX6644', 0),
(0, 'Harbouey', 'France', 'Europe', 'FRLO0630', 0),
(0, 'Harcanville', 'France', 'Europe', 'FRHN0320', 0),
(0, 'Harchechamp', 'France', 'Europe', 'FRLO0631', 0),
(0, 'Harcigny', 'France', 'Europe', 'FRPI0722', 0),
(0, 'Harcourt', 'France', 'Europe', 'FRXX1105', 0),
(0, 'Harcy', 'France', 'Europe', 'FRCA0546', 0),
(0, 'Hardancourt', 'France', 'Europe', 'FRLO0632', 0),
(0, 'Hardanges', 'France', 'Europe', 'FRPL0263', 0),
(0, 'Hardecourt-aux-Bois', 'France', 'Europe', 'FRPI0723', 0),
(0, 'Hardelot-Plage', 'France', 'Europe', 'FRNC0418', 0),
(0, 'Hardencourt-Cocherel', 'France', 'Europe', 'FRHN0321', 0),
(0, 'Hardifort', 'France', 'Europe', 'FRNC0419', 0),
(0, 'Hardinghen', 'France', 'Europe', 'FRXX3627', 0),
(0, 'Hardinvast', 'France', 'Europe', 'FRBN0438', 0),
(0, 'Hardivillers', 'France', 'Europe', 'FRXX2012', 0),
(0, 'Hardivillers-en-Vexin', 'France', 'Europe', 'FRPI0724', 0),
(0, 'Hardricourt', 'France', 'Europe', 'FRIF0247', 0),
(0, 'Hareville', 'France', 'Europe', 'FRLO0633', 0),
(0, 'Harfleur', 'France', 'Europe', 'FRXX3414', 0),
(0, 'Hargarten-aux-Mines', 'France', 'Europe', 'FRXX1909', 0),
(0, 'Hargeville', 'France', 'Europe', 'FRIF0248', 0),
(0, 'Hargeville-sur-Chee', 'France', 'Europe', 'FRLO0634', 0),
(0, 'Hargicourt', 'France', 'Europe', 'FRPI0725', 0),
(0, 'Hargicourt', 'France', 'Europe', 'FRPI0726', 0),
(0, 'Hargnies', 'France', 'Europe', 'FRCA0547', 0),
(0, 'Hargnies', 'France', 'Europe', 'FRNC0420', 0),
(0, 'Haricourt', 'France', 'Europe', 'FRXX3255', 0),
(0, 'Harly', 'France', 'Europe', 'FRPI0727', 0),
(0, 'Harmeville', 'France', 'Europe', 'FRCA0548', 0),
(0, 'Harmonville', 'France', 'Europe', 'FRLO0635', 0),
(0, 'Harnes', 'France', 'Europe', 'FRXX4223', 0),
(0, 'Harol', 'France', 'Europe', 'FRLO0636', 0),
(0, 'Haroue', 'France', 'Europe', 'FRLO0637', 0),
(0, 'Harponville', 'France', 'Europe', 'FRPI0728', 0),
(0, 'Harprich', 'France', 'Europe', 'FRLO0638', 0),
(0, 'Harquency', 'France', 'Europe', 'FRHN0322', 0),
(0, 'Harreberg', 'France', 'Europe', 'FRLO0639', 0),
(0, 'Harreville-les-Chanteurs', 'France', 'Europe', 'FRXX3836', 0),
(0, 'Harricourt', 'France', 'Europe', 'FRCA0549', 0),
(0, 'Harricourt', 'France', 'Europe', 'FRCA0550', 0),
(0, 'Harsault', 'France', 'Europe', 'FRLO0640', 0),
(0, 'Harskirchen', 'France', 'Europe', 'FRAL0191', 0),
(0, 'Ingolsheim', 'France', 'Europe', 'FRAL0246', 0),
(0, 'Ingouville', 'France', 'Europe', 'FRHN0368', 0),
(0, 'Ingrandes', 'France', 'Europe', 'FRCE0406', 0),
(0, 'Ingrandes', 'France', 'Europe', 'FRPC0386', 0),
(0, 'Ingrandes', 'France', 'Europe', 'FRXX5385', 0),
(0, 'Ingrandes-de-Touraine', 'France', 'Europe', 'FRCE0407', 0),
(0, 'Ingrannes', 'France', 'Europe', 'FRCE0408', 0),
(0, 'Ingre', 'France', 'Europe', 'FRCE0409', 0),
(0, 'Inguiniel', 'France', 'Europe', 'FRBR0059', 0),
(0, 'Ingwiller', 'France', 'Europe', 'FRXX5875', 0),
(0, 'Injoux-Genissiat', 'France', 'Europe', 'FRRA0662', 0),
(0, 'Innenheim', 'France', 'Europe', 'FRAL0247', 0),
(0, 'Innimond', 'France', 'Europe', 'FRRA0663', 0),
(0, 'Inor', 'France', 'Europe', 'FRLO0716', 0),
(0, 'Insming', 'France', 'Europe', 'FRLO0717', 0),
(0, 'Insviller', 'France', 'Europe', 'FRLO0718', 0),
(0, 'Intraville', 'France', 'Europe', 'FRHN0369', 0),
(0, 'Intres', 'France', 'Europe', 'FRRA0664', 0),
(0, 'Intreville', 'France', 'Europe', 'FRCE0410', 0),
(0, 'Intville-la-Guetard', 'France', 'Europe', 'FRCE0411', 0),
(0, 'Inval-Boiron', 'France', 'Europe', 'FRPI0778', 0),
(0, 'Inxent', 'France', 'Europe', 'FRNC0485', 0),
(0, 'Inzinzac-Lochrist', 'France', 'Europe', 'FRBR0060', 0),
(0, 'Ippecourt', 'France', 'Europe', 'FRLO0719', 0),
(0, 'Ippling', 'France', 'Europe', 'FRLO0720', 0),
(0, 'Iracoubo', 'France', 'Europe', 'FRXX7785', 0),
(0, 'Irai', 'France', 'Europe', 'FRBN0469', 0),
(0, 'Irais', 'France', 'Europe', 'FRPC0387', 0),
(0, 'Irancy', 'France', 'Europe', 'FRBO0520', 0),
(0, 'Ire-le-Sec', 'France', 'Europe', 'FRLO0721', 0),
(0, 'Irigny', 'France', 'Europe', 'FRXX3436', 0),
(0, 'Irissarry', 'France', 'Europe', 'FRXX2662', 0),
(0, 'Irles', 'France', 'Europe', 'FRPI0779', 0),
(0, 'Irmstett', 'France', 'Europe', 'FRAL0248', 0),
(0, 'Irodouer', 'France', 'Europe', 'FRBR0061', 0),
(0, 'Iron', 'France', 'Europe', 'FRPI0780', 0),
(0, 'Irouleguy', 'France', 'Europe', 'FRAQ0583', 0),
(0, 'Irreville', 'France', 'Europe', 'FRHN0370', 0),
(0, 'Irvillac', 'France', 'Europe', 'FRBR0062', 0),
(0, 'Is-en-Bassigny', 'France', 'Europe', 'FRXX4628', 0),
(0, 'Is-sur-Tille', 'France', 'Europe', 'FRXX3356', 0),
(0, 'Isbergues', 'France', 'Europe', 'FRXX4221', 0),
(0, 'Isches', 'France', 'Europe', 'FRLO0722', 0),
(0, 'Isdes', 'France', 'Europe', 'FRXX2690', 0),
(0, 'Isenay', 'France', 'Europe', 'FRBO0521', 0),
(0, 'Isigny-le-Buat', 'France', 'Europe', 'FRXX5363', 0),
(0, 'Isigny-sur-Mer', 'France', 'Europe', 'FRXX6130', 0),
(0, 'Island', 'France', 'Europe', 'FRBO0522', 0),
(0, 'Isle', 'France', 'Europe', 'FRXX3601', 0),
(0, 'Isle-Aubigny', 'France', 'Europe', 'FRCA0587', 0),
(0, 'Isle-Aumont', 'France', 'Europe', 'FRCA0588', 0),
(0, 'Isle-et-Bardais', 'France', 'Europe', 'FRAU0278', 0),
(0, 'Isle-Saint-Georges', 'France', 'Europe', 'FRXX1523', 0),
(0, 'Isle-sur-Marne', 'France', 'Europe', 'FRCA0589', 0),
(0, 'Isles-les-Meldeuses', 'France', 'Europe', 'FRIF0259', 0),
(0, 'Isles-les-Villenoy', 'France', 'Europe', 'FRXX6346', 0),
(0, 'Isles-sur-Suippe', 'France', 'Europe', 'FRXX1679', 0),
(0, 'Isneauville', 'France', 'Europe', 'FRHN0371', 0),
(0, 'Isola', 'France', 'Europe', 'FRXX0229', 0),
(0, 'Isola 2000', 'France', 'Europe', 'FRXX0499', 0),
(0, 'Isolaccio-di-Fiumorbo', 'France', 'Europe', 'FRCO0084', 0),
(0, 'Isomes', 'France', 'Europe', 'FRCA0590', 0),
(0, 'Ispagnac', 'France', 'Europe', 'FRXX5382', 0),
(0, 'Isques', 'France', 'Europe', 'FRNC0486', 0),
(0, 'Issac', 'France', 'Europe', 'FRAQ0584', 0),
(0, 'Issamoulenc', 'France', 'Europe', 'FRRA0665', 0),
(0, 'Issancourt-et-Rumel', 'France', 'Europe', 'FRCA0591', 0),
(0, 'Issanlas', 'France', 'Europe', 'FRRA0666', 0),
(0, 'Issans', 'France', 'Europe', 'FRFC0596', 0),
(0, 'Issarles', 'France', 'Europe', 'FRRA0667', 0),
(0, 'Isse', 'France', 'Europe', 'FRCA0592', 0),
(0, 'Isse', 'France', 'Europe', 'FRXX1288', 0),
(0, 'Issel', 'France', 'Europe', 'FRLR0290', 0),
(0, 'Issendolus', 'France', 'Europe', 'FRMP0915', 0),
(0, 'Issenhausen', 'France', 'Europe', 'FRAL0249', 0),
(0, 'Issenheim', 'France', 'Europe', 'FRAL0250', 0),
(0, 'Issepts', 'France', 'Europe', 'FRMP0916', 0),
(0, 'Isserpent', 'France', 'Europe', 'FRAU0279', 0),
(0, 'Isserteaux', 'France', 'Europe', 'FRAU0280', 0),
(0, 'Issigeac', 'France', 'Europe', 'FRAQ0585', 0),
(0, 'Jaulnes', 'France', 'Europe', 'FRIF0267', 0),
(0, 'Jaulny', 'France', 'Europe', 'FRLO0730', 0),
(0, 'Jaulzy', 'France', 'Europe', 'FRPI0786', 0),
(0, 'Jaunac', 'France', 'Europe', 'FRRA0687', 0),
(0, 'Jaunay-Clan', 'France', 'Europe', 'FRXX5870', 0),
(0, 'Jaure', 'France', 'Europe', 'FRAQ0593', 0),
(0, 'Jaure', 'France', 'Europe', 'FRAQ0594', 0),
(0, 'Jausiers', 'France', 'Europe', 'FRXX2404', 0),
(0, 'Jaux', 'France', 'Europe', 'FRXX2747', 0),
(0, 'Jauze', 'France', 'Europe', 'FRPL0271', 0),
(0, 'Javaugues', 'France', 'Europe', 'FRAU0284', 0),
(0, 'Javene', 'France', 'Europe', 'FRBR0063', 0),
(0, 'Javerdat', 'France', 'Europe', 'FRLI0166', 0),
(0, 'Javerlhac-et-la-Chapelle-Saint-Robert', 'France', 'Europe', 'FRAQ0595', 0),
(0, 'Javernant', 'France', 'Europe', 'FRCA0599', 0),
(0, 'Javols', 'France', 'Europe', 'FRLR0291', 0),
(0, 'Javouhey', 'France', 'Europe', 'FRXX7780', 0),
(0, 'Javrezac', 'France', 'Europe', 'FRPC0390', 0),
(0, 'Javron-les-Chapelles', 'France', 'Europe', 'FRPL0272', 0),
(0, 'Jax', 'France', 'Europe', 'FRAU0285', 0),
(0, 'Jaxu', 'France', 'Europe', 'FRAQ0596', 0),
(0, 'Jayac', 'France', 'Europe', 'FRAQ0597', 0),
(0, 'Jayat', 'France', 'Europe', 'FRRA0688', 0),
(0, 'Jazeneuil', 'France', 'Europe', 'FRPC0391', 0),
(0, 'Jazennes', 'France', 'Europe', 'FRPC0392', 0),
(0, 'Jeancourt', 'France', 'Europe', 'FRPI0787', 0),
(0, 'Jeandelaincourt', 'France', 'Europe', 'FRXX3093', 0),
(0, 'Jeandelize', 'France', 'Europe', 'FRLO0731', 0),
(0, 'Jeanmenil', 'France', 'Europe', 'FRLO0732', 0),
(0, 'Jeansagniere', 'France', 'Europe', 'FRXX5641', 0),
(0, 'Jeantes', 'France', 'Europe', 'FRPI0788', 0),
(0, 'Jebsheim', 'France', 'Europe', 'FRAL0253', 0),
(0, 'Jegun', 'France', 'Europe', 'FRMP0924', 0),
(0, 'Jenlain', 'France', 'Europe', 'FRNC0490', 0),
(0, 'Jenzat', 'France', 'Europe', 'FRAU0286', 0),
(0, 'Jesonville', 'France', 'Europe', 'FRLO0733', 0),
(0, 'Jessains', 'France', 'Europe', 'FRCA0600', 0),
(0, 'Jetterswiller', 'France', 'Europe', 'FRAL0254', 0),
(0, 'Jettingen', 'France', 'Europe', 'FRAL0255', 0),
(0, 'Jeu-les-Bois', 'France', 'Europe', 'FRCE0421', 0),
(0, 'Jeu-Maloches', 'France', 'Europe', 'FRCE0420', 0),
(0, 'Jeufosse', 'France', 'Europe', 'FRIF0268', 0),
(0, 'Jeugny', 'France', 'Europe', 'FRCA0601', 0),
(0, 'Jeumont', 'France', 'Europe', 'FRXX4307', 0),
(0, 'Jeurre', 'France', 'Europe', 'FRFC0601', 0),
(0, 'Jeux-les-Bard', 'France', 'Europe', 'FRBO0534', 0),
(0, 'Jeuxey', 'France', 'Europe', 'FRXX5375', 0),
(0, 'Jevoncourt', 'France', 'Europe', 'FRLO0734', 0),
(0, 'Jezainville', 'France', 'Europe', 'FRLO0735', 0),
(0, 'Jezeau', 'France', 'Europe', 'FRMP0925', 0),
(0, 'Joannas', 'France', 'Europe', 'FRRA0689', 0),
(0, 'Job', 'France', 'Europe', 'FRXX6500', 0),
(0, 'Jobourg', 'France', 'Europe', 'FRBN0470', 0),
(0, 'Joch', 'France', 'Europe', 'FRLR0292', 0),
(0, 'Joeuf', 'France', 'Europe', 'FRXX3849', 0),
(0, 'Joganville', 'France', 'Europe', 'FRBN0471', 0),
(0, 'Joigny', 'France', 'Europe', 'FRBO0535', 0),
(0, 'Joigny-sur-Meuse', 'France', 'Europe', 'FRCA0602', 0),
(0, 'Joinville', 'France', 'Europe', 'FRXX3090', 0),
(0, 'Joinville-le-Pont', 'France', 'Europe', 'FRXX4546', 0),
(0, 'Joiselle', 'France', 'Europe', 'FRCA0603', 0),
(0, 'Jolimetz', 'France', 'Europe', 'FRNC0491', 0),
(0, 'Jolivet', 'France', 'Europe', 'FRLO0736', 0),
(0, 'Jonage', 'France', 'Europe', 'FRRA0690', 0),
(0, 'Joncels', 'France', 'Europe', 'FRLR0293', 0),
(0, 'Joncheres', 'France', 'Europe', 'FRRA0691', 0),
(0, 'Joncherey', 'France', 'Europe', 'FRMP0926', 0),
(0, 'Jonchery', 'France', 'Europe', 'FRCA0604', 0),
(0, 'Jonchery-sur-Suippe', 'France', 'Europe', 'FRCA0605', 0),
(0, 'Jonchery-sur-Vesle', 'France', 'Europe', 'FRXX3107', 0),
(0, 'Joncourt', 'France', 'Europe', 'FRPI0789', 0),
(0, 'Joncreuil', 'France', 'Europe', 'FRCA0606', 0),
(0, 'Joncy', 'France', 'Europe', 'FRBO0536', 0),
(0, 'Jongieux', 'France', 'Europe', 'FRRA0692', 0),
(0, 'Jonquerets-de-Livet', 'France', 'Europe', 'FRXX4805', 0),
(0, 'Jonquery', 'France', 'Europe', 'FRCA0607', 0),
(0, 'Jonquieres', 'France', 'Europe', 'FRLR0294', 0),
(0, 'Jonquieres', 'France', 'Europe', 'FRLR0295', 0),
(0, 'Jonquieres', 'France', 'Europe', 'FRMP0927', 0),
(0, 'Jonquieres', 'France', 'Europe', 'FRPI0790', 0),
(0, 'Krafft', 'France', 'Europe', 'FRAL0280', 0),
(0, 'Krautergersheim', 'France', 'Europe', 'FRXX3645', 0),
(0, 'Krautwiller', 'France', 'Europe', 'FRAL0281', 0),
(0, 'Kriegsheim', 'France', 'Europe', 'FRAL0282', 0),
(0, 'Kruth', 'France', 'Europe', 'FRXX4149', 0),
(0, 'Kuhlendorf', 'France', 'Europe', 'FRAL0283', 0),
(0, 'Kunheim', 'France', 'Europe', 'FRXX2888', 0),
(0, 'Kuntzig', 'France', 'Europe', 'FRLO0770', 0),
(0, 'Kurtzenhouse', 'France', 'Europe', 'FRAL0284', 0),
(0, 'Kuttolsheim', 'France', 'Europe', 'FRAL0285', 0),
(0, 'Kutzenhausen', 'France', 'Europe', 'FRAL0286', 0),
(0, 'L`Oie', 'France', 'Europe', 'FRPL0294', 0),
(0, 'L`Orbrie', 'France', 'Europe', 'FRPL0295', 0),
(0, 'L`Oudon', 'France', 'Europe', 'FRBN0486', 0),
(0, 'L`Union', 'France', 'Europe', 'FRMP0947', 0),
(0, 'La Bachellerie', 'France', 'Europe', 'FRAQ0607', 0),
(0, 'La Baconniere', 'France', 'Europe', 'FRXX3082', 0),
(0, 'La Baffe', 'France', 'Europe', 'FRXX2257', 0),
(0, 'La Baleine', 'France', 'Europe', 'FRBN0487', 0),
(0, 'La Balme', 'France', 'Europe', 'FRRA0710', 0),
(0, 'La Balme-d`Epy', 'France', 'Europe', 'FRFC0612', 0),
(0, 'La Balme-de-Sillingy', 'France', 'Europe', 'FRXX2080', 0),
(0, 'La Balme-de-Thuy', 'France', 'Europe', 'FRRA0711', 0),
(0, 'La Balme-les-Grottes', 'France', 'Europe', 'FRRA0712', 0),
(0, 'La Barben', 'France', 'Europe', 'FRPA0222', 0),
(0, 'La Barde', 'France', 'Europe', 'FRPC0412', 0),
(0, 'La Baroche-Gondouin', 'France', 'Europe', 'FRPL0296', 0),
(0, 'La Baroche-sous-Luce', 'France', 'Europe', 'FRXX2047', 0),
(0, 'La Barre', 'France', 'Europe', 'FRFC0613', 0),
(0, 'La Barre', 'France', 'Europe', 'FRFC0614', 0),
(0, 'La Barre-de-Monts', 'France', 'Europe', 'FRXX4652', 0),
(0, 'La Barre-de-Semilly', 'France', 'Europe', 'FRXX6812', 0),
(0, 'La Barre-en-Ouche', 'France', 'Europe', 'FRXX2200', 0),
(0, 'La Barthe-de-Neste', 'France', 'Europe', 'FRXX6371', 0),
(0, 'La Basse-Vaivre', 'France', 'Europe', 'FRFC0615', 0),
(0, 'La Bassee', 'France', 'Europe', 'FRXX5057', 0),
(0, 'La Bastide', 'France', 'Europe', 'FRLR0300', 0),
(0, 'La Bastide', 'France', 'Europe', 'FRPA0223', 0),
(0, 'La Bastide-Clairence', 'France', 'Europe', 'FRAQ0608', 0),
(0, 'La Bastide-d`Engras', 'France', 'Europe', 'FRPA0224', 0),
(0, 'La Bastide-de-Besplas', 'France', 'Europe', 'FRMP0950', 0),
(0, 'La Bastide-de-Bousignac', 'France', 'Europe', 'FRMP0951', 0),
(0, 'La Bastide-de-Lordat', 'France', 'Europe', 'FRMP0952', 0),
(0, 'La Bastide-de-Serou', 'France', 'Europe', 'FRXX1532', 0),
(0, 'La Bastide-des-Jourdans', 'France', 'Europe', 'FRXX4581', 0),
(0, 'La Bastide-du-Salat', 'France', 'Europe', 'FRMP0953', 0),
(0, 'La Bastide-l`Eveque', 'France', 'Europe', 'FRMP0954', 0),
(0, 'La Bastide-Pradines', 'France', 'Europe', 'FRMP0948', 0),
(0, 'La Bastide-Puylaurent', 'France', 'Europe', 'FRXX2384', 0),
(0, 'La Bastide-Solages', 'France', 'Europe', 'FRMP0949', 0),
(0, 'La Bastide-sur-l`Hers', 'France', 'Europe', 'FRMP0955', 0),
(0, 'La Bastidonne', 'France', 'Europe', 'FRPA0225', 0),
(0, 'La Bataille', 'France', 'Europe', 'FRPC0413', 0),
(0, 'La Bathie', 'France', 'Europe', 'FRXX2307', 0),
(0, 'La Batie-Cremezin', 'France', 'Europe', 'FRRA0713', 0),
(0, 'La Batie-des-Fonds', 'France', 'Europe', 'FRRA0717', 0),
(0, 'La Batie-Divisin', 'France', 'Europe', 'FRRA0714', 0),
(0, 'La Batie-Montgascon', 'France', 'Europe', 'FRRA0715', 0),
(0, 'La Batie-Montsaleon', 'France', 'Europe', 'FRPA0226', 0),
(0, 'La Batie-Neuve', 'France', 'Europe', 'FRXX5400', 0),
(0, 'La Batie-Rolland', 'France', 'Europe', 'FRRA0716', 0),
(0, 'La Batie-Vieille', 'France', 'Europe', 'FRPA0227', 0),
(0, 'La Bauche', 'France', 'Europe', 'FRRA0718', 0),
(0, 'La Baule-Escoublac', 'France', 'Europe', 'FRXX2008', 0),
(0, 'La Baume', 'France', 'Europe', 'FRRA0719', 0),
(0, 'La Baume-Cornillane', 'France', 'Europe', 'FRRA0720', 0),
(0, 'La Baume-d`Hostun', 'France', 'Europe', 'FRXX2482', 0),
(0, 'La Baume-de-Transit', 'France', 'Europe', 'FRRA0721', 0),
(0, 'La Baussaine', 'France', 'Europe', 'FRBR0087', 0),
(0, 'La Bazeuge', 'France', 'Europe', 'FRLI0171', 0),
(0, 'La Bazoche-Gouet', 'France', 'Europe', 'FRXX5623', 0),
(0, 'La Bazoge', 'France', 'Europe', 'FRBN0488', 0),
(0, 'La Bazoge', 'France', 'Europe', 'FRXX0043', 0),
(0, 'La Bazoge-Montpincon', 'France', 'Europe', 'FRPL0297', 0),
(0, 'La Bazoque', 'France', 'Europe', 'FRBN0489', 0),
(0, 'La Bazoque', 'France', 'Europe', 'FRBN0490', 0),
(0, 'La Bazouge-de-Chemere', 'France', 'Europe', 'FRPL0298', 0),
(0, 'La Bazouge-des-Alleux', 'France', 'Europe', 'FRPL0299', 0),
(0, 'La Bazouge-du-Desert', 'France', 'Europe', 'FRBR0088', 0),
(0, 'La Beaume', 'France', 'Europe', 'FRPA0228', 0),
(0, 'La Begude-de-Mazenc', 'France', 'Europe', 'FRXX1659', 0),
(0, 'La Belliere', 'France', 'Europe', 'FRBN0491', 0),
(0, 'La Belliere', 'France', 'Europe', 'FRHN0380', 0),
(0, 'La Belliole', 'France', 'Europe', 'FRBO0556', 0),
(0, 'La Benate', 'France', 'Europe', 'FRPC0414', 0),
(0, 'La Benisson-Dieu', 'France', 'Europe', 'FRRA0722', 0),
(0, 'La Berliere', 'France', 'Europe', 'FRCA0623', 0),
(0, 'La Bernardiere', 'France', 'Europe', 'FRXX3043', 0),
(0, 'La Bernerie-en-Retz', 'France', 'Europe', 'FRXX5049', 0),
(0, 'La Berthenoux', 'France', 'Europe', 'FRCE0428', 0),
(0, 'La Besace', 'France', 'Europe', 'FRCA0624', 0),
(0, 'Magny', 'France', 'Europe', 'FRBO0697', 0),
(0, 'Magny', 'France', 'Europe', 'FRCE0615', 0),
(0, 'Magny-Chatelard', 'France', 'Europe', 'FRFC0801', 0),
(0, 'Magny-Cours', 'France', 'Europe', 'FRXX3676', 0),
(0, 'Magny-Danigon', 'France', 'Europe', 'FRFC0802', 0),
(0, 'Magny-en-Bessin', 'France', 'Europe', 'FRBN0785', 0),
(0, 'Magny-en-Vexin', 'France', 'Europe', 'FRXX6831', 0),
(0, 'Magny-Fouchard', 'France', 'Europe', 'FRCA0822', 0),
(0, 'Magny-Jobert', 'France', 'Europe', 'FRFC0803', 0),
(0, 'Magny-la-Campagne', 'France', 'Europe', 'FRBN0786', 0),
(0, 'Magny-la-Fosse', 'France', 'Europe', 'FRPI0996', 0),
(0, 'Magny-la-Ville', 'France', 'Europe', 'FRBO0702', 0),
(0, 'Magny-Lambert', 'France', 'Europe', 'FRBO0698', 0),
(0, 'Magny-le-Desert', 'France', 'Europe', 'FRXX2851', 0),
(0, 'Magny-le-Freule', 'France', 'Europe', 'FRBN0787', 0),
(0, 'Magny-le-Hongre', 'France', 'Europe', 'FRXX5636', 0),
(0, 'Magny-les-Aubigny', 'France', 'Europe', 'FRBO0703', 0),
(0, 'Magny-les-Hameaux', 'France', 'Europe', 'FRXX5117', 0),
(0, 'Magny-les-Jussey', 'France', 'Europe', 'FRFC0805', 0),
(0, 'Magny-les-Villers', 'France', 'Europe', 'FRBO0704', 0),
(0, 'Magny-Lormes', 'France', 'Europe', 'FRBO0699', 0),
(0, 'Magny-Montarlot', 'France', 'Europe', 'FRBO0700', 0),
(0, 'Magny-Saint-Medard', 'France', 'Europe', 'FRBO0701', 0),
(0, 'Magny-sur-Tille', 'France', 'Europe', 'FRBO0705', 0),
(0, 'Magny-Vernois', 'France', 'Europe', 'FRFC0804', 0),
(0, 'Magoar', 'France', 'Europe', 'FRBR0293', 0),
(0, 'Magrie', 'France', 'Europe', 'FRLR0433', 0),
(0, 'Magrin', 'France', 'Europe', 'FRMP1319', 0),
(0, 'Magstatt-le-Bas', 'France', 'Europe', 'FRAL0329', 0),
(0, 'Magstatt-le-Haut', 'France', 'Europe', 'FRAL0330', 0),
(0, 'Mahaena', 'France', 'Europe', 'FRXX7852', 0),
(0, 'Mahalon', 'France', 'Europe', 'FRXX3951', 0),
(0, 'Maheru', 'France', 'Europe', 'FRBN0788', 0),
(0, 'Mahina', 'France', 'Europe', 'FRXX7855', 0),
(0, 'Maiche', 'France', 'Europe', 'FRFC0806', 0),
(0, 'Maidieres', 'France', 'Europe', 'FRLO0964', 0),
(0, 'Maignaut-Tauzia', 'France', 'Europe', 'FRMP1320', 0),
(0, 'Maigne', 'France', 'Europe', 'FRPL0526', 0),
(0, 'Maignelay-Montigny', 'France', 'Europe', 'FRPI0997', 0),
(0, 'Mailhac', 'France', 'Europe', 'FRLR0434', 0),
(0, 'Mailhac-sur-Benaize', 'France', 'Europe', 'FRLI0261', 0),
(0, 'Mailhoc', 'France', 'Europe', 'FRMP1321', 0),
(0, 'Mailholas', 'France', 'Europe', 'FRMP1322', 0),
(0, 'Maillane', 'France', 'Europe', 'FRXX1844', 0),
(0, 'Maillas', 'France', 'Europe', 'FRAQ0858', 0),
(0, 'Maillat', 'France', 'Europe', 'FRRA1024', 0),
(0, 'Maille', 'France', 'Europe', 'FRCE0616', 0),
(0, 'Maille', 'France', 'Europe', 'FRPC0572', 0),
(0, 'Maille', 'France', 'Europe', 'FRPL0527', 0),
(0, 'Maillebois', 'France', 'Europe', 'FRCE0617', 0),
(0, 'Mailleres', 'France', 'Europe', 'FRAQ0859', 0),
(0, 'Mailleroncourt-Charette', 'France', 'Europe', 'FRFC0807', 0),
(0, 'Mailleroncourt-Saint-Pancras', 'France', 'Europe', 'FRFC0808', 0),
(0, 'Maillet', 'France', 'Europe', 'FRAU0436', 0),
(0, 'Maillet', 'France', 'Europe', 'FRCE0618', 0),
(0, 'Mailley-et-Chazelot', 'France', 'Europe', 'FRFC0809', 0),
(0, 'Maillezais', 'France', 'Europe', 'FRPL0528', 0),
(0, 'Maillot', 'France', 'Europe', 'FRBO0706', 0),
(0, 'Mailly', 'France', 'Europe', 'FRBO0707', 0),
(0, 'Mailly-Champagne', 'France', 'Europe', 'FRCA0823', 0),
(0, 'Mailly-la-Ville', 'France', 'Europe', 'FRXX2237', 0),
(0, 'Mailly-le-Camp', 'France', 'Europe', 'FRXX3292', 0),
(0, 'Mailly-le-Chateau', 'France', 'Europe', 'FRXX4567', 0),
(0, 'Mailly-Maillet', 'France', 'Europe', 'FRXX1509', 0),
(0, 'Mailly-Raineval', 'France', 'Europe', 'FRPI0998', 0),
(0, 'Mailly-sur-Seille', 'France', 'Europe', 'FRXX6730', 0),
(0, 'Maimbeville', 'France', 'Europe', 'FRPI0999', 0),
(0, 'Mainbresson', 'France', 'Europe', 'FRCA0824', 0),
(0, 'Mainbressy', 'France', 'Europe', 'FRCA0825', 0),
(0, 'Maincourt-sur-Yvette', 'France', 'Europe', 'FRIF0355', 0),
(0, 'Maincy', 'France', 'Europe', 'FRIF0356', 0),
(0, 'Maine-de-Boixe', 'France', 'Europe', 'FRXX1655', 0),
(0, 'Mainfonds', 'France', 'Europe', 'FRPC0573', 0),
(0, 'Maing', 'France', 'Europe', 'FRXX1890', 0),
(0, 'Mainneville', 'France', 'Europe', 'FRHN0534', 0),
(0, 'Mainsat', 'France', 'Europe', 'FRLI0262', 0),
(0, 'Maintenay', 'France', 'Europe', 'FRNC0581', 0),
(0, 'Maintenon', 'France', 'Europe', 'FRXX3323', 0),
(0, 'Mainterne', 'France', 'Europe', 'FRCE0619', 0),
(0, 'Mainville', 'France', 'Europe', 'FRXX2275', 0),
(0, 'Nantheuil', 'France', 'Europe', 'FRAQ1036', 0),
(0, 'Nanthiat', 'France', 'Europe', 'FRAQ1037', 0),
(0, 'Nantiat', 'France', 'Europe', 'FRLI0302', 0),
(0, 'Nantille', 'France', 'Europe', 'FRPC0684', 0),
(0, 'Nantillois', 'France', 'Europe', 'FRLO1145', 0),
(0, 'Nantilly', 'France', 'Europe', 'FRFC0962', 0),
(0, 'Nantoin', 'France', 'Europe', 'FRRA1232', 0),
(0, 'Nantois', 'France', 'Europe', 'FRLO1146', 0),
(0, 'Nanton', 'France', 'Europe', 'FRBO0880', 0),
(0, 'Nantouard', 'France', 'Europe', 'FRFC0963', 0),
(0, 'Nantouillet', 'France', 'Europe', 'FRIF0430', 0),
(0, 'Nantoux', 'France', 'Europe', 'FRBO0881', 0),
(0, 'Nantua', 'France', 'Europe', 'FRXX2606', 0),
(0, 'Naours', 'France', 'Europe', 'FRPI1184', 0),
(0, 'Napt', 'France', 'Europe', 'FRRA1233', 0),
(0, 'Napuka', 'France', 'Europe', 'FRXX7910', 0),
(0, 'Narbefontaine', 'France', 'Europe', 'FRLO1147', 0),
(0, 'Narbief', 'France', 'Europe', 'FRFC0964', 0),
(0, 'Narbonne', 'France', 'Europe', 'FRXX0338', 0),
(0, 'Narbonne-Plage', 'France', 'Europe', 'FRLR0544', 0),
(0, 'Narcastet', 'France', 'Europe', 'FRAQ1038', 0),
(0, 'Narcy', 'France', 'Europe', 'FRBO0882', 0),
(0, 'Narcy', 'France', 'Europe', 'FRCA0983', 0),
(0, 'Nargis', 'France', 'Europe', 'FRCE0772', 0),
(0, 'Narnhac', 'France', 'Europe', 'FRAU0526', 0),
(0, 'Narp', 'France', 'Europe', 'FRAQ1039', 0),
(0, 'Narrosse', 'France', 'Europe', 'FRAQ1040', 0),
(0, 'Narthoux', 'France', 'Europe', 'FRMP1616', 0),
(0, 'Nasbinals', 'France', 'Europe', 'FRLR0545', 0),
(0, 'Nassandres', 'France', 'Europe', 'FRXX4779', 0),
(0, 'Nassiet', 'France', 'Europe', 'FRAQ1041', 0),
(0, 'Nassigny', 'France', 'Europe', 'FRAU0527', 0),
(0, 'Nastringues', 'France', 'Europe', 'FRAQ1042', 0),
(0, 'Nattages', 'France', 'Europe', 'FRRA1234', 0),
(0, 'Natzwiller', 'France', 'Europe', 'FRAL0376', 0),
(0, 'Naucelle', 'France', 'Europe', 'FRMP1617', 0),
(0, 'Naucelles', 'France', 'Europe', 'FRAU0528', 0),
(0, 'Naujac-sur-Mer', 'France', 'Europe', 'FRXX5849', 0),
(0, 'Naujan-et-Postiac', 'France', 'Europe', 'FRAQ1043', 0),
(0, 'Nauroy', 'France', 'Europe', 'FRPI1185', 0),
(0, 'Naussac', 'France', 'Europe', 'FRLR0546', 0),
(0, 'Naussac', 'France', 'Europe', 'FRMP1618', 0),
(0, 'Naussannes', 'France', 'Europe', 'FRAQ1044', 0),
(0, 'Nauvay', 'France', 'Europe', 'FRPL0622', 0),
(0, 'Nauviale', 'France', 'Europe', 'FRMP1619', 0),
(0, 'Navacelles', 'France', 'Europe', 'FRLR0547', 0),
(0, 'Navailles-Angos', 'France', 'Europe', 'FRXX2589', 0),
(0, 'Navarrenx', 'France', 'Europe', 'FRAQ1045', 0),
(0, 'Naveil', 'France', 'Europe', 'FRCE0773', 0),
(0, 'Navenne', 'France', 'Europe', 'FRFC0965', 0),
(0, 'Naves', 'France', 'Europe', 'FRAU0529', 0),
(0, 'Naves', 'France', 'Europe', 'FRMP1620', 0),
(0, 'Naves', 'France', 'Europe', 'FRRA1235', 0),
(0, 'Naves', 'France', 'Europe', 'FRRA1236', 0),
(0, 'Naves', 'France', 'Europe', 'FRXX2947', 0),
(0, 'Naves', 'France', 'Europe', 'FRXX5471', 0),
(0, 'Naves-Parmelan', 'France', 'Europe', 'FRRA1237', 0),
(0, 'Navilly', 'France', 'Europe', 'FRBO0883', 0),
(0, 'Nay', 'France', 'Europe', 'FRAQ1046', 0),
(0, 'Nay', 'France', 'Europe', 'FRBN0910', 0),
(0, 'Nayemont-les-Fosses', 'France', 'Europe', 'FRLO1148', 0),
(0, 'Nazelles-Negron', 'France', 'Europe', 'FRCE0774', 0),
(0, 'Neac', 'France', 'Europe', 'FRAQ1047', 0),
(0, 'Neant-sur-Yvel', 'France', 'Europe', 'FRBR0353', 0),
(0, 'Neau', 'France', 'Europe', 'FRPL0623', 0),
(0, 'Neaufles-Auvergny', 'France', 'Europe', 'FRHN0611', 0),
(0, 'Neaufles-Saint-Martin', 'France', 'Europe', 'FRXX6241', 0),
(0, 'Neauphe-sous-Essai', 'France', 'Europe', 'FRBN0911', 0),
(0, 'Neauphe-sur-Dive', 'France', 'Europe', 'FRBN0912', 0),
(0, 'Neauphle-le-Chateau', 'France', 'Europe', 'FRXX3602', 0),
(0, 'Neauphle-le-Vieux', 'France', 'Europe', 'FRIF0431', 0),
(0, 'Neauphlette', 'France', 'Europe', 'FRIF0432', 0),
(0, 'Neaux', 'France', 'Europe', 'FRRA1238', 0),
(0, 'Nebian', 'France', 'Europe', 'FRLR0548', 0),
(0, 'Nebias', 'France', 'Europe', 'FRLR0549', 0),
(0, 'Nebing', 'France', 'Europe', 'FRLO1149', 0),
(0, 'Nebouzat', 'France', 'Europe', 'FRAU0530', 0),
(0, 'Necy', 'France', 'Europe', 'FRBN0913', 0),
(0, 'Nedde', 'France', 'Europe', 'FRLI0303', 0),
(0, 'Nedon', 'France', 'Europe', 'FRNC0649', 0),
(0, 'Ogeu-les-Bains', 'France', 'Europe', 'FRXX5817', 0),
(0, 'Ogeviller', 'France', 'Europe', 'FRLO1197', 0),
(0, 'Ogliastro', 'France', 'Europe', 'FRCO0120', 0),
(0, 'Ognes', 'France', 'Europe', 'FRCA1020', 0),
(0, 'Ognes', 'France', 'Europe', 'FRPI1227', 0),
(0, 'Ognes', 'France', 'Europe', 'FRPI1228', 0),
(0, 'Ogneville', 'France', 'Europe', 'FRLO1198', 0),
(0, 'Ognolles', 'France', 'Europe', 'FRPI1229', 0),
(0, 'Ognon', 'France', 'Europe', 'FRPI1230', 0),
(0, 'Ogy', 'France', 'Europe', 'FRLO1199', 0),
(0, 'Ohain', 'France', 'Europe', 'FRNC0692', 0),
(0, 'Oherville', 'France', 'Europe', 'FRHN0640', 0),
(0, 'Ohis', 'France', 'Europe', 'FRPI1231', 0),
(0, 'Ohlungen', 'France', 'Europe', 'FRAL0422', 0),
(0, 'Ohnenheim', 'France', 'Europe', 'FRAL0423', 0),
(0, 'Ohnheim', 'France', 'Europe', 'FRAL0424', 0),
(0, 'Oigney', 'France', 'Europe', 'FRFC0993', 0),
(0, 'Oignies', 'France', 'Europe', 'FRXX5642', 0),
(0, 'Oigny', 'France', 'Europe', 'FRBO0907', 0),
(0, 'Oigny', 'France', 'Europe', 'FRCE0815', 0),
(0, 'Oigny-en-Valois', 'France', 'Europe', 'FRPI1232', 0),
(0, 'Oingt', 'France', 'Europe', 'FRRA1269', 0),
(0, 'Oinville-Saint-Liphard', 'France', 'Europe', 'FRCE0816', 0),
(0, 'Oinville-sous-Auneau', 'France', 'Europe', 'FRCE0817', 0),
(0, 'Oinville-sur-Montcient', 'France', 'Europe', 'FRXX1616', 0),
(0, 'Oiron', 'France', 'Europe', 'FRPC0703', 0),
(0, 'Oiry', 'France', 'Europe', 'FRCA1021', 0),
(0, 'Oiselay-et-Grachaux', 'France', 'Europe', 'FRXX4975', 0),
(0, 'Oisemont', 'France', 'Europe', 'FRPI1233', 0),
(0, 'Oisilly', 'France', 'Europe', 'FRBO0908', 0),
(0, 'Oisly', 'France', 'Europe', 'FRCE0818', 0),
(0, 'Oison', 'France', 'Europe', 'FRCE0819', 0),
(0, 'Oisseau', 'France', 'Europe', 'FRPL0650', 0),
(0, 'Oisseau-le-Petit', 'France', 'Europe', 'FRXX4931', 0),
(0, 'Oissel', 'France', 'Europe', 'FRXX3442', 0),
(0, 'Oissery', 'France', 'Europe', 'FRIF0443', 0),
(0, 'Oissy', 'France', 'Europe', 'FRPI1234', 0),
(0, 'Oisy', 'France', 'Europe', 'FRBO0909', 0),
(0, 'Oisy', 'France', 'Europe', 'FRNC0693', 0),
(0, 'Oisy', 'France', 'Europe', 'FRPI1235', 0),
(0, 'Oisy-le-Verger', 'France', 'Europe', 'FRXX2579', 0),
(0, 'Oize', 'France', 'Europe', 'FRPL0651', 0),
(0, 'Oizon', 'France', 'Europe', 'FRCE0820', 0),
(0, 'Olargues', 'France', 'Europe', 'FRLR0564', 0),
(0, 'Olby', 'France', 'Europe', 'FRAU0543', 0),
(0, 'Olcani', 'France', 'Europe', 'FRCO0121', 0),
(0, 'Oleac-Debat', 'France', 'Europe', 'FRXX2805', 0),
(0, 'Oleac-Dessus', 'France', 'Europe', 'FRMP1645', 0),
(0, 'Olemps', 'France', 'Europe', 'FRXX2423', 0),
(0, 'Olendon', 'France', 'Europe', 'FRBN0948', 0),
(0, 'Oletta', 'France', 'Europe', 'FRCO0122', 0),
(0, 'Olette', 'France', 'Europe', 'FRXX5714', 0),
(0, 'Olivese', 'France', 'Europe', 'FRCO0123', 0),
(0, 'Olivet', 'France', 'Europe', 'FRCE0821', 0),
(0, 'Olivet', 'France', 'Europe', 'FRPL0652', 0),
(0, 'Olizy', 'France', 'Europe', 'FRCA1022', 0),
(0, 'Olizy-Primat', 'France', 'Europe', 'FRCA1023', 0),
(0, 'Olizy-sur-Chiers', 'France', 'Europe', 'FRLO1200', 0),
(0, 'Ollainville', 'France', 'Europe', 'FRLO1201', 0),
(0, 'Ollainville', 'France', 'Europe', 'FRXX1535', 0),
(0, 'Ollans', 'France', 'Europe', 'FRFC0994', 0),
(0, 'Olle', 'France', 'Europe', 'FRCE0822', 0),
(0, 'Olley', 'France', 'Europe', 'FRLO1202', 0),
(0, 'Ollezy', 'France', 'Europe', 'FRPI1236', 0),
(0, 'Ollieres', 'France', 'Europe', 'FRLO1203', 0),
(0, 'Ollieres', 'France', 'Europe', 'FRPA0414', 0),
(0, 'Olliergues', 'France', 'Europe', 'FRAU0544', 0),
(0, 'Ollioules', 'France', 'Europe', 'FRXX2726', 0),
(0, 'Olloix', 'France', 'Europe', 'FRAU0545', 0),
(0, 'Olmet', 'France', 'Europe', 'FRAU0546', 0),
(0, 'Olmeta-di-Capocorso', 'France', 'Europe', 'FRCO0124', 0),
(0, 'Olmeta-di-Tuda', 'France', 'Europe', 'FRXX2221', 0),
(0, 'Olmeto', 'France', 'Europe', 'FRXX2473', 0),
(0, 'Olmi-Cappella', 'France', 'Europe', 'FRXX5951', 0),
(0, 'Olmiccia', 'France', 'Europe', 'FRCO0125', 0),
(0, 'Olmo', 'France', 'Europe', 'FRCO0126', 0),
(0, 'Olonne-sur-Mer', 'France', 'Europe', 'FRXX3830', 0),
(0, 'Olonzac', 'France', 'Europe', 'FRXX5045', 0),
(0, 'Oloron-Sainte-Marie', 'France', 'Europe', 'FRXX3348', 0),
(0, 'Ols-et-Rinhodes', 'France', 'Europe', 'FRMP1646', 0),
(0, 'Palogneux', 'France', 'Europe', 'FRRA1296', 0),
(0, 'Paluel', 'France', 'Europe', 'FRHN0649', 0),
(0, 'Pamfou', 'France', 'Europe', 'FRIF0460', 0),
(0, 'Pamiers', 'France', 'Europe', 'FRXX4834', 0),
(0, 'Pampelonne', 'France', 'Europe', 'FRMP1687', 0),
(0, 'Pamplie', 'France', 'Europe', 'FRPC0721', 0),
(0, 'Pamproux', 'France', 'Europe', 'FRPC0722', 0),
(0, 'Panassac', 'France', 'Europe', 'FRMP1688', 0),
(0, 'Panazol', 'France', 'Europe', 'FRXX6692', 0),
(0, 'Pance', 'France', 'Europe', 'FRXX6259', 0),
(0, 'Pancey', 'France', 'Europe', 'FRCA1054', 0),
(0, 'Pancheraccia', 'France', 'Europe', 'FRCO0132', 0),
(0, 'Pancy-Courtecon', 'France', 'Europe', 'FRPI1263', 0),
(0, 'Pandrignes', 'France', 'Europe', 'FRLI0325', 0),
(0, 'Pange', 'France', 'Europe', 'FRLO1228', 0),
(0, 'Panges', 'France', 'Europe', 'FRBO0936', 0),
(0, 'Panilleuse', 'France', 'Europe', 'FRHN0650', 0),
(0, 'Panissage', 'France', 'Europe', 'FRRA1297', 0),
(0, 'Panissieres', 'France', 'Europe', 'FRXX1214', 0),
(0, 'Panjas', 'France', 'Europe', 'FRMP1689', 0),
(0, 'Panlatte', 'France', 'Europe', 'FRHN0651', 0),
(0, 'Pannece', 'France', 'Europe', 'FRPL0657', 0),
(0, 'Pannecieres', 'France', 'Europe', 'FRCE0851', 0),
(0, 'Pannes', 'France', 'Europe', 'FRCE0852', 0),
(0, 'Pannes', 'France', 'Europe', 'FRLO1229', 0),
(0, 'Pannessieres', 'France', 'Europe', 'FRFC1028', 0),
(0, 'Panon', 'France', 'Europe', 'FRPL0658', 0),
(0, 'Panossas', 'France', 'Europe', 'FRRA1298', 0),
(0, 'Pantin', 'France', 'Europe', 'FRXX3749', 0),
(0, 'Panzoult', 'France', 'Europe', 'FRCE0853', 0),
(0, 'Papara', 'France', 'Europe', 'FRXX7858', 0),
(0, 'Papeari', 'France', 'Europe', 'FRXX7873', 0),
(0, 'Papeete', 'France', 'Europe', 'FRXX7860', 0),
(0, 'Papenoo', 'France', 'Europe', 'FRXX7853', 0),
(0, 'Papetoai', 'France', 'Europe', 'FRXX7875', 0),
(0, 'Papleux', 'France', 'Europe', 'FRPI1264', 0),
(0, 'Paradou', 'France', 'Europe', 'FRPA0421', 0),
(0, 'Parame', 'France', 'Europe', 'FRBR0365', 0),
(0, 'Parassy', 'France', 'Europe', 'FRCE0854', 0),
(0, 'Parata', 'France', 'Europe', 'FRCO0133', 0),
(0, 'Paray-Douaville', 'France', 'Europe', 'FRIF0461', 0),
(0, 'Paray-le-Fresil', 'France', 'Europe', 'FRAU0557', 0),
(0, 'Paray-le-Monial', 'France', 'Europe', 'FRXX0411', 0),
(0, 'Paray-sous-Briailles', 'France', 'Europe', 'FRAU0558', 0),
(0, 'Paray-Vieille-Poste', 'France', 'Europe', 'FRXX3815', 0),
(0, 'Paraza', 'France', 'Europe', 'FRLR0579', 0),
(0, 'Parbayse', 'France', 'Europe', 'FRAQ1092', 0),
(0, 'Parc-d`Anxtot', 'France', 'Europe', 'FRHN0652', 0),
(0, 'Parcay-les-Pins', 'France', 'Europe', 'FRPL0659', 0),
(0, 'Parcay-Meslay', 'France', 'Europe', 'FRCE0855', 0),
(0, 'Parcay-sur-Vienne', 'France', 'Europe', 'FRXX1374', 0),
(0, 'Parce', 'France', 'Europe', 'FRXX5589', 0),
(0, 'Parce-sur-Sarthe', 'France', 'Europe', 'FRPL0660', 0),
(0, 'Parcey', 'France', 'Europe', 'FRFC1029', 0),
(0, 'Parcieux', 'France', 'Europe', 'FRRA1299', 0),
(0, 'Parcoul', 'France', 'Europe', 'FRAQ1093', 0),
(0, 'Parcy-et-Tigny', 'France', 'Europe', 'FRPI1265', 0),
(0, 'Pardailhan', 'France', 'Europe', 'FRLR0580', 0),
(0, 'Pardaillan', 'France', 'Europe', 'FRAQ1094', 0),
(0, 'Pardies', 'France', 'Europe', 'FRXX1976', 0),
(0, 'Pardies-Pietat', 'France', 'Europe', 'FRAQ1095', 0),
(0, 'Pardines', 'France', 'Europe', 'FRAU0559', 0),
(0, 'Pareac', 'France', 'Europe', 'FRMP1690', 0),
(0, 'Pareid', 'France', 'Europe', 'FRLO1230', 0),
(0, 'Parempuyre', 'France', 'Europe', 'FRAQ1096', 0),
(0, 'Parennes', 'France', 'Europe', 'FRPL0661', 0),
(0, 'Parent', 'France', 'Europe', 'FRAU0560', 0),
(0, 'Parentignat', 'France', 'Europe', 'FRAU0561', 0),
(0, 'Parentis-en-Born', 'France', 'Europe', 'FRXX0381', 0),
(0, 'Parenty', 'France', 'Europe', 'FRNC0704', 0),
(0, 'Parey-Saint-Cesaire', 'France', 'Europe', 'FRXX3771', 0),
(0, 'Parey-sous-Montfort', 'France', 'Europe', 'FRLO1231', 0),
(0, 'Parfondeval', 'France', 'Europe', 'FRBN0970', 0),
(0, 'Parfondeval', 'France', 'Europe', 'FRPI1266', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Parfondru', 'France', 'Europe', 'FRPI1267', 0),
(0, 'Parfondrupt', 'France', 'Europe', 'FRLO1232', 0),
(0, 'Parfouru-sur-Odon', 'France', 'Europe', 'FRBN0971', 0),
(0, 'Pargnan', 'France', 'Europe', 'FRPI1268', 0),
(0, 'Pargny', 'France', 'Europe', 'FRPI1269', 0),
(0, 'Pargny-Filain', 'France', 'Europe', 'FRPI1270', 0),
(0, 'Quievy', 'France', 'Europe', 'FRXX5105', 0),
(0, 'Quilen', 'France', 'Europe', 'FRNC0741', 0),
(0, 'Quillan', 'France', 'Europe', 'FRLR0653', 0),
(0, 'Quillebeuf-sur-Seine', 'France', 'Europe', 'FRXX2502', 0),
(0, 'Quilly', 'France', 'Europe', 'FRCA1154', 0),
(0, 'Quilly', 'France', 'Europe', 'FRXX5777', 0),
(0, 'Quily', 'France', 'Europe', 'FRBR0485', 0),
(0, 'Quimerch', 'France', 'Europe', 'FRBR0486', 0),
(0, 'Quimiac', 'France', 'Europe', 'FRPL0711', 0),
(0, 'Quimper', 'France', 'Europe', 'FRXX0079', 0),
(0, 'Quimperle', 'France', 'Europe', 'FRXX5440', 0),
(0, 'Quincampoix', 'France', 'Europe', 'FRXX5092', 0),
(0, 'Quincampoix-Fleuzy', 'France', 'Europe', 'FRXX6472', 0),
(0, 'Quincay', 'France', 'Europe', 'FRPC0787', 0),
(0, 'Quincerot', 'France', 'Europe', 'FRBO1021', 0),
(0, 'Quincerot', 'France', 'Europe', 'FRBO1022', 0),
(0, 'Quincey', 'France', 'Europe', 'FRBO1023', 0),
(0, 'Quincey', 'France', 'Europe', 'FRCA1155', 0),
(0, 'Quincey', 'France', 'Europe', 'FRFC1102', 0),
(0, 'Quincie-en-Beaujolais', 'France', 'Europe', 'FRXX2104', 0),
(0, 'Quincieu', 'France', 'Europe', 'FRXX5325', 0),
(0, 'Quincieux', 'France', 'Europe', 'FRRA1414', 0),
(0, 'Quincy', 'France', 'Europe', 'FRCE0920', 0),
(0, 'Quincy-Basse', 'France', 'Europe', 'FRPI1356', 0),
(0, 'Quincy-Landzecourt', 'France', 'Europe', 'FRLO1292', 0),
(0, 'Quincy-le-Vicomte', 'France', 'Europe', 'FRBO1024', 0),
(0, 'Quincy-sous-le-Mont', 'France', 'Europe', 'FRPI1357', 0),
(0, 'Quincy-sous-Senart', 'France', 'Europe', 'FRXX6775', 0),
(0, 'Quincy-Voisins', 'France', 'Europe', 'FRXX5689', 0),
(0, 'Quineville', 'France', 'Europe', 'FRBN1027', 0),
(0, 'Quingey', 'France', 'Europe', 'FRFC1103', 0),
(0, 'Quinquempoix', 'France', 'Europe', 'FRPI1358', 0),
(0, 'Quins', 'France', 'Europe', 'FRMP1826', 0),
(0, 'Quinsac', 'France', 'Europe', 'FRAQ1187', 0),
(0, 'Quinsac', 'France', 'Europe', 'FRAQ1188', 0),
(0, 'Quinson', 'France', 'Europe', 'FRPA0462', 0),
(0, 'Quinssaines', 'France', 'Europe', 'FRXX3906', 0),
(0, 'Quint-Fonsegrives', 'France', 'Europe', 'FRMP1827', 0),
(0, 'Quintal', 'France', 'Europe', 'FRRA1415', 0),
(0, 'Quintenas', 'France', 'Europe', 'FRRA1416', 0),
(0, 'Quintenic', 'France', 'Europe', 'FRBR0487', 0),
(0, 'Quintigny', 'France', 'Europe', 'FRFC1104', 0),
(0, 'Quintillan', 'France', 'Europe', 'FRLR0654', 0),
(0, 'Quintin', 'France', 'Europe', 'FRXX4043', 0),
(0, 'Quirbajou', 'France', 'Europe', 'FRLR0655', 0),
(0, 'Quiry-le-Sec', 'France', 'Europe', 'FRXX5910', 0),
(0, 'Quissac', 'France', 'Europe', 'FRMP1828', 0),
(0, 'Quissac', 'France', 'Europe', 'FRXX5578', 0),
(0, 'Quistinic', 'France', 'Europe', 'FRBR0488', 0),
(0, 'Quittebeuf', 'France', 'Europe', 'FRHN0691', 0),
(0, 'Quitteur', 'France', 'Europe', 'FRFC1105', 0),
(0, 'Quivieres', 'France', 'Europe', 'FRPI1359', 0),
(0, 'Quoeux-Haut-Mainil', 'France', 'Europe', 'FRNC0742', 0),
(0, 'Rancennes', 'France', 'Europe', 'FRCA1161', 0),
(0, 'Rances', 'France', 'Europe', 'FRCA1162', 0),
(0, 'Ranchal', 'France', 'Europe', 'FRXX3582', 0),
(0, 'Ranchette', 'France', 'Europe', 'FRFC1111', 0),
(0, 'Ranchicourt', 'France', 'Europe', 'FRNC0751', 0),
(0, 'Ranchot', 'France', 'Europe', 'FRFC1112', 0),
(0, 'Ranchy', 'France', 'Europe', 'FRBN1032', 0),
(0, 'Rancogne', 'France', 'Europe', 'FRPC0789', 0),
(0, 'Rancon', 'France', 'Europe', 'FRLI0343', 0),
(0, 'Ranconnieres', 'France', 'Europe', 'FRCA1163', 0),
(0, 'Rancoudray', 'France', 'Europe', 'FRBN1033', 0),
(0, 'Rancourt', 'France', 'Europe', 'FRLO1303', 0),
(0, 'Rancourt', 'France', 'Europe', 'FRPI1366', 0),
(0, 'Rancourt-sur-Ornain', 'France', 'Europe', 'FRLO1304', 0),
(0, 'Rancy', 'France', 'Europe', 'FRBO1025', 0),
(0, 'Randan', 'France', 'Europe', 'FRAU0601', 0),
(0, 'Randens', 'France', 'Europe', 'FRRA1419', 0),
(0, 'Randevillers', 'France', 'Europe', 'FRFC1113', 0),
(0, 'Randonnai', 'France', 'Europe', 'FRBN1034', 0),
(0, 'Ranes', 'France', 'Europe', 'FRBN1035', 0),
(0, 'Rang', 'France', 'Europe', 'FRFC1114', 0),
(0, 'Rang-du-Fliers', 'France', 'Europe', 'FRNC0752', 0),
(0, 'Rangecourt', 'France', 'Europe', 'FRCA1164', 0),
(0, 'Rangen', 'France', 'Europe', 'FRAL0448', 0),
(0, 'Rangiroa', 'France', 'Europe', 'FRXX7913', 0),
(0, 'Ranguevaux', 'France', 'Europe', 'FRLO1305', 0),
(0, 'Rannee', 'France', 'Europe', 'FRBR0490', 0),
(0, 'Ranrupt', 'France', 'Europe', 'FRAL0449', 0),
(0, 'Rans', 'France', 'Europe', 'FRFC1115', 0),
(0, 'Ransart', 'France', 'Europe', 'FRNC0753', 0),
(0, 'Ranspach', 'France', 'Europe', 'FRAL0450', 0),
(0, 'Ranspach-le-Bas', 'France', 'Europe', 'FRAL0451', 0),
(0, 'Ranspach-le-Haut', 'France', 'Europe', 'FRAL0452', 0),
(0, 'Rantechaux', 'France', 'Europe', 'FRFC1116', 0),
(0, 'Rantigny', 'France', 'Europe', 'FRPI1367', 0),
(0, 'Ranton', 'France', 'Europe', 'FRPC0790', 0),
(0, 'Rantzwiller', 'France', 'Europe', 'FRXX2086', 0),
(0, 'Ranville', 'France', 'Europe', 'FRXX3236', 0),
(0, 'Ranville-Breuillaud', 'France', 'Europe', 'FRPC0791', 0),
(0, 'Ranzevelle', 'France', 'Europe', 'FRFC1117', 0),
(0, 'Ranzieres', 'France', 'Europe', 'FRLO1306', 0),
(0, 'Raon-aux-Bois', 'France', 'Europe', 'FRXX5965', 0),
(0, 'Raon-l`Etape', 'France', 'Europe', 'FRLO1307', 0),
(0, 'Raon-les-Leau', 'France', 'Europe', 'FRLO1308', 0),
(0, 'Raon-sur-Plaine', 'France', 'Europe', 'FRXX2253', 0),
(0, 'Rapa', 'France', 'Europe', 'FRXX7894', 0),
(0, 'Rapaggio', 'France', 'Europe', 'FRCO0175', 0),
(0, 'Rapale', 'France', 'Europe', 'FRCO0176', 0),
(0, 'Rapey', 'France', 'Europe', 'FRLO1309', 0),
(0, 'Raphele', 'France', 'Europe', 'FRXX6657', 0),
(0, 'Rapilly', 'France', 'Europe', 'FRBN1036', 0),
(0, 'Rapsecourt', 'France', 'Europe', 'FRCA1165', 0),
(0, 'Raray', 'France', 'Europe', 'FRPI1368', 0),
(0, 'Rarecourt', 'France', 'Europe', 'FRLO1310', 0),
(0, 'Rasigueres', 'France', 'Europe', 'FRLR0659', 0),
(0, 'Raslay', 'France', 'Europe', 'FRPC0792', 0),
(0, 'Rasteau', 'France', 'Europe', 'FRPA0465', 0),
(0, 'Ratenelle', 'France', 'Europe', 'FRBO1026', 0),
(0, 'Ratieres', 'France', 'Europe', 'FRRA1420', 0),
(0, 'Ratte', 'France', 'Europe', 'FRBO1027', 0),
(0, 'Ratzwiller', 'France', 'Europe', 'FRAL0453', 0),
(0, 'Raucoules', 'France', 'Europe', 'FRAU0602', 0),
(0, 'Raucourt', 'France', 'Europe', 'FRLO1311', 0),
(0, 'Raucourt-au-Bois', 'France', 'Europe', 'FRXX1350', 0),
(0, 'Raucourt-et-Flaba', 'France', 'Europe', 'FRXX4832', 0),
(0, 'Raulecourt', 'France', 'Europe', 'FRLO1312', 0),
(0, 'Raulhac', 'France', 'Europe', 'FRAU0603', 0),
(0, 'Rauret', 'France', 'Europe', 'FRAU0604', 0),
(0, 'Rauville-la-Bigot', 'France', 'Europe', 'FRXX3615', 0),
(0, 'Rauville-la-Place', 'France', 'Europe', 'FRBN1037', 0),
(0, 'Rauwiller', 'France', 'Europe', 'FRAL0454', 0),
(0, 'Rauzan', 'France', 'Europe', 'FRAQ1191', 0),
(0, 'Raveau', 'France', 'Europe', 'FRBO1028', 0),
(0, 'Ravel', 'France', 'Europe', 'FRAU0605', 0),
(0, 'Ravel-et-Ferriers', 'France', 'Europe', 'FRXX1812', 0),
(0, 'Ravenel', 'France', 'Europe', 'FRPI1369', 0),
(0, 'Ravennefontaines', 'France', 'Europe', 'FRCA1166', 0),
(0, 'Ravenoville', 'France', 'Europe', 'FRBN1038', 0),
(0, 'Raves', 'France', 'Europe', 'FRLO1313', 0),
(0, 'Ravieres', 'France', 'Europe', 'FRBO1029', 0),
(0, 'Sailly', 'France', 'Europe', 'FRIF0517', 0),
(0, 'Sailly-Achatel', 'France', 'Europe', 'FRLO1412', 0),
(0, 'Sailly-au-Bois', 'France', 'Europe', 'FRNC0804', 0),
(0, 'Sailly-en-Ostrevent', 'France', 'Europe', 'FRNC0805', 0),
(0, 'Sailly-Flibeaucourt', 'France', 'Europe', 'FRXX5918', 0),
(0, 'Sailly-Labourse', 'France', 'Europe', 'FRXX3626', 0),
(0, 'Sailly-Laurette', 'France', 'Europe', 'FRPI1455', 0),
(0, 'Sailly-le-Sec', 'France', 'Europe', 'FRPI1457', 0),
(0, 'Sailly-lez-Cambrai', 'France', 'Europe', 'FRNC0806', 0),
(0, 'Sailly-lez-Lannoy', 'France', 'Europe', 'FRNC0807', 0),
(0, 'Sailly-Saillisel', 'France', 'Europe', 'FRPI1456', 0),
(0, 'Sailly-sur-la-Lys', 'France', 'Europe', 'FRNC0808', 0),
(0, 'Sain-Bel', 'France', 'Europe', 'FRRA1498', 0),
(0, 'Saincaize-Meauce', 'France', 'Europe', 'FRBO1066', 0),
(0, 'Sainghin-en-Melantois', 'France', 'Europe', 'FRXX2846', 0),
(0, 'Sainghin-en-Weppes', 'France', 'Europe', 'FRXX6675', 0),
(0, 'Sainneville', 'France', 'Europe', 'FRHN0729', 0),
(0, 'Sainpuits', 'France', 'Europe', 'FRBO1067', 0),
(0, 'Sains', 'France', 'Europe', 'FRBR0511', 0),
(0, 'Sains-du-Nord', 'France', 'Europe', 'FRXX2228', 0),
(0, 'Sains-en-Amienois', 'France', 'Europe', 'FRXX6651', 0),
(0, 'Sains-en-Gohelle', 'France', 'Europe', 'FRXX5145', 0),
(0, 'Sains-les-Fressin', 'France', 'Europe', 'FRXX6414', 0),
(0, 'Sains-les-Marquion', 'France', 'Europe', 'FRNC0809', 0),
(0, 'Sains-les-Pernes', 'France', 'Europe', 'FRNC0810', 0),
(0, 'Sains-Morainvillers', 'France', 'Europe', 'FRPI1458', 0),
(0, 'Sains-Richaumont', 'France', 'Europe', 'FRXX4488', 0),
(0, 'Saint Gervais', 'France', 'Europe', 'FRXX0523', 0),
(0, 'Saint Jean Montclar', 'France', 'Europe', 'FRXX0437', 0),
(0, 'Saint Leger les Melezes', 'France', 'Europe', 'FRXX0454', 0),
(0, 'Saint Martin-Chennetron', 'France', 'Europe', 'FRIF0518', 0),
(0, 'Saint Sorlin d`Arves', 'France', 'Europe', 'FRXX0507', 0),
(0, 'Saint-Aaron', 'France', 'Europe', 'FRBR0512', 0),
(0, 'Saint-Abit', 'France', 'Europe', 'FRAQ1231', 0),
(0, 'Saint-Abraham', 'France', 'Europe', 'FRBR0513', 0),
(0, 'Saint-Acheul', 'France', 'Europe', 'FRPI1459', 0),
(0, 'Saint-Adjutory', 'France', 'Europe', 'FRPC0825', 0),
(0, 'Saint-Adrien', 'France', 'Europe', 'FRBR0514', 0),
(0, 'Saint-Affrique', 'France', 'Europe', 'FRXX3963', 0),
(0, 'Saint-Affrique-les-Montagnes', 'France', 'Europe', 'FRMP1919', 0),
(0, 'Saint-Agathon', 'France', 'Europe', 'FRBR0515', 0),
(0, 'Saint-Agil', 'France', 'Europe', 'FRCE0969', 0),
(0, 'Saint-Agnan', 'France', 'Europe', 'FRBO1068', 0),
(0, 'Saint-Agnan', 'France', 'Europe', 'FRBO1069', 0),
(0, 'Saint-Agnan', 'France', 'Europe', 'FRBO1070', 0),
(0, 'Saint-Agnan', 'France', 'Europe', 'FRMP1920', 0),
(0, 'Saint-Agnan', 'France', 'Europe', 'FRPI1460', 0),
(0, 'Saint-Agnan-en-Vercors', 'France', 'Europe', 'FRRA1499', 0),
(0, 'Saint-Agnan-le-Malherbe', 'France', 'Europe', 'FRBN1077', 0),
(0, 'Saint-Agnan-sur-Sarthe', 'France', 'Europe', 'FRBN1078', 0),
(0, 'Saint-Agnant', 'France', 'Europe', 'FRXX6188', 0),
(0, 'Saint-Agnant-de-Versillat', 'France', 'Europe', 'FRXX2602', 0),
(0, 'Saint-Agnant-pres-Crocq', 'France', 'Europe', 'FRXX2601', 0),
(0, 'Saint-Agnant-sous-les-Cotes', 'France', 'Europe', 'FRLO1413', 0),
(0, 'Saint-Agne', 'France', 'Europe', 'FRAQ1232', 0),
(0, 'Saint-Agnet', 'France', 'Europe', 'FRXX3061', 0),
(0, 'Saint-Agnin-sur-Bion', 'France', 'Europe', 'FRRA1500', 0),
(0, 'Saint-Agoulin', 'France', 'Europe', 'FRAU0632', 0),
(0, 'Saint-Agreve', 'France', 'Europe', 'FRXX2533', 0),
(0, 'Saint-Aignan', 'France', 'Europe', 'FRAQ1233', 0),
(0, 'Saint-Aignan', 'France', 'Europe', 'FRCA1227', 0),
(0, 'Saint-Aignan', 'France', 'Europe', 'FRMP1921', 0),
(0, 'Saint-Aignan', 'France', 'Europe', 'FRPL0740', 0),
(0, 'Saint-Aignan', 'France', 'Europe', 'FRXX4292', 0),
(0, 'Saint-Aignan', 'France', 'Europe', 'FRXX6055', 0),
(0, 'Saint-Aignan-de-Couptrain', 'France', 'Europe', 'FRPL0741', 0),
(0, 'Saint-Aignan-de-Cramesnil', 'France', 'Europe', 'FRBN1079', 0),
(0, 'Saint-Aignan-des-Gues', 'France', 'Europe', 'FRXX2687', 0),
(0, 'Saint-Aignan-des-Noyers', 'France', 'Europe', 'FRCE0970', 0),
(0, 'Saint-Aignan-Grandlieu', 'France', 'Europe', 'FRXX4300', 0),
(0, 'Saint-Aignan-le-Jaillard', 'France', 'Europe', 'FRCE0971', 0),
(0, 'Saint-Aignan-sur-Roe', 'France', 'Europe', 'FRXX2349', 0),
(0, 'Saint-Aignan-sur-Ry', 'France', 'Europe', 'FRHN0730', 0),
(0, 'Saint-Aigny', 'France', 'Europe', 'FRCE0972', 0),
(0, 'Saint-Aigulin', 'France', 'Europe', 'FRXX2462', 0),
(0, 'Saint-Ail', 'France', 'Europe', 'FRXX4573', 0),
(0, 'Saint-Albain', 'France', 'Europe', 'FRBO1071', 0),
(0, 'Saint-Alban', 'France', 'Europe', 'FRBR0516', 0),
(0, 'Saint-Alban', 'France', 'Europe', 'FRMP1922', 0),
(0, 'Saint-Alban', 'France', 'Europe', 'FRXX3365', 0),
(0, 'Tamnay-en-Bazois', 'France', 'Europe', 'FRBO1349', 0),
(0, 'Tamnies', 'France', 'Europe', 'FRAQ1659', 0),
(0, 'Tanaron', 'France', 'Europe', 'FRPA0626', 0),
(0, 'Tanavelle', 'France', 'Europe', 'FRAU0843', 0),
(0, 'Tanay', 'France', 'Europe', 'FRBO1350', 0),
(0, 'Tancarville', 'France', 'Europe', 'FRHN0925', 0),
(0, 'Tancoigne', 'France', 'Europe', 'FRPL0985', 0),
(0, 'Tancon', 'France', 'Europe', 'FRBO1351', 0),
(0, 'Tanconville', 'France', 'Europe', 'FRLO1573', 0),
(0, 'Tancrou', 'France', 'Europe', 'FRIF0592', 0),
(0, 'Tancua', 'France', 'Europe', 'FRFC1271', 0),
(0, 'Tangry', 'France', 'Europe', 'FRNC0896', 0),
(0, 'Taninges', 'France', 'Europe', 'FRRA1955', 0),
(0, 'Tanis', 'France', 'Europe', 'FRBN1389', 0),
(0, 'Tannay', 'France', 'Europe', 'FRBO1352', 0),
(0, 'Tannay', 'France', 'Europe', 'FRCA1421', 0),
(0, 'Tanneron', 'France', 'Europe', 'FRPA0627', 0),
(0, 'Tannerre-en-Puisaye', 'France', 'Europe', 'FRXX1645', 0),
(0, 'Tannieres', 'France', 'Europe', 'FRPI1591', 0),
(0, 'Tannois', 'France', 'Europe', 'FRLO1574', 0),
(0, 'Tanques', 'France', 'Europe', 'FRBN1390', 0),
(0, 'Tantonville', 'France', 'Europe', 'FRXX1668', 0),
(0, 'Tanus', 'France', 'Europe', 'FRMP2291', 0),
(0, 'Tanville', 'France', 'Europe', 'FRBN1391', 0),
(0, 'Tanzac', 'France', 'Europe', 'FRPC1076', 0),
(0, 'Taponas', 'France', 'Europe', 'FRRA1956', 0),
(0, 'Taponnat-Fleurignac', 'France', 'Europe', 'FRPC1077', 0),
(0, 'Taputapuatea', 'France', 'Europe', 'FRXX7881', 0),
(0, 'Tarabel', 'France', 'Europe', 'FRMP2292', 0),
(0, 'Taradeau', 'France', 'Europe', 'FRPA0628', 0),
(0, 'Tarare', 'France', 'Europe', 'FRRA1957', 0),
(0, 'Tarascon', 'France', 'Europe', 'FRXX5487', 0),
(0, 'Tarascon-sur-Ariege', 'France', 'Europe', 'FRXX5575', 0),
(0, 'Tarasteix', 'France', 'Europe', 'FRMP2293', 0),
(0, 'Tarbes', 'France', 'Europe', 'FRXX0097', 0),
(0, 'Tarcenay', 'France', 'Europe', 'FRFC1272', 0),
(0, 'Tardais', 'France', 'Europe', 'FRCE1197', 0),
(0, 'Tardes', 'France', 'Europe', 'FRLI0533', 0),
(0, 'Tardets-Sorholus', 'France', 'Europe', 'FRXX1336', 0),
(0, 'Tardinghen', 'France', 'Europe', 'FRNC0897', 0),
(0, 'Tarentaise', 'France', 'Europe', 'FRRA1958', 0),
(0, 'Tarerach', 'France', 'Europe', 'FRLR0882', 0),
(0, 'Targassonne', 'France', 'Europe', 'FRXX1395', 0),
(0, 'Targe', 'France', 'Europe', 'FRPC1078', 0),
(0, 'Target', 'France', 'Europe', 'FRAU0844', 0),
(0, 'Targon', 'France', 'Europe', 'FRAQ1660', 0),
(0, 'Tarnac', 'France', 'Europe', 'FRLI0534', 0),
(0, 'Tarnes', 'France', 'Europe', 'FRAQ1661', 0),
(0, 'Tarnos', 'France', 'Europe', 'FRXX3512', 0),
(0, 'Taron-Sadirac-Viellenave', 'France', 'Europe', 'FRXX6483', 0),
(0, 'Tarquimpol', 'France', 'Europe', 'FRLO1575', 0),
(0, 'Tarrano', 'France', 'Europe', 'FRCO0209', 0),
(0, 'Tarsac', 'France', 'Europe', 'FRMP2294', 0),
(0, 'Tarsacq', 'France', 'Europe', 'FRAQ1662', 0),
(0, 'Tarsul', 'France', 'Europe', 'FRBO1353', 0),
(0, 'Tart-l`Abbaye', 'France', 'Europe', 'FRBO1354', 0),
(0, 'Tart-le-Bas', 'France', 'Europe', 'FRBO1355', 0),
(0, 'Tart-le-Haut', 'France', 'Europe', 'FRBO1356', 0),
(0, 'Tartaras', 'France', 'Europe', 'FRRA1959', 0),
(0, 'Tartas', 'France', 'Europe', 'FRXX3058', 0),
(0, 'Tartecourt', 'France', 'Europe', 'FRFC1273', 0),
(0, 'Tartiers', 'France', 'Europe', 'FRPI1592', 0),
(0, 'Tartigny', 'France', 'Europe', 'FRPI1593', 0),
(0, 'Tartonne', 'France', 'Europe', 'FRPA0629', 0),
(0, 'Tarzy', 'France', 'Europe', 'FRCA1422', 0),
(0, 'Tasque', 'France', 'Europe', 'FRMP2295', 0),
(0, 'Tasse', 'France', 'Europe', 'FRPL0986', 0),
(0, 'Tassenieres', 'France', 'Europe', 'FRFC1274', 0),
(0, 'Tassille', 'France', 'Europe', 'FRPL0987', 0),
(0, 'Tassin-la-Demi-Lune', 'France', 'Europe', 'FRXX5815', 0),
(0, 'Tasso', 'France', 'Europe', 'FRCO0210', 0),
(0, 'Tatakoto', 'France', 'Europe', 'FRXX7921', 0),
(0, 'Tatinghem', 'France', 'Europe', 'FRNC0898', 0),
(0, 'Tattone', 'France', 'Europe', 'FRCO0211', 0),
(0, 'Taugon', 'France', 'Europe', 'FRPC1079', 0),
(0, 'Taulanne', 'France', 'Europe', 'FRPA0630', 0),
(0, 'Taule', 'France', 'Europe', 'FRXX2443', 0),
(0, 'Taulignan', 'France', 'Europe', 'FRRA1960', 0),
(0, 'Taulis', 'France', 'Europe', 'FRLR0883', 0),
(0, 'Taupont', 'France', 'Europe', 'FRBR0704', 0),
(0, 'Urzy', 'France', 'Europe', 'FRBO1423', 0),
(0, 'Us', 'France', 'Europe', 'FRIF0609', 0),
(0, 'Usclades-et-Rieutord', 'France', 'Europe', 'FRRA2021', 0),
(0, 'Usclas-d`Herault', 'France', 'Europe', 'FRLR0919', 0),
(0, 'Usclas-du-Bosc', 'France', 'Europe', 'FRLR0920', 0),
(0, 'Usinens', 'France', 'Europe', 'FRRA2022', 0),
(0, 'Ussac', 'France', 'Europe', 'FRLI0545', 0),
(0, 'Ussat', 'France', 'Europe', 'FRMP2377', 0),
(0, 'Usseau', 'France', 'Europe', 'FRPC1112', 0),
(0, 'Usseau', 'France', 'Europe', 'FRPC1113', 0),
(0, 'Ussel', 'France', 'Europe', 'FRAU0878', 0),
(0, 'Ussel', 'France', 'Europe', 'FRLI0546', 0),
(0, 'Ussel', 'France', 'Europe', 'FRMP2378', 0),
(0, 'Ussel-d`Allier', 'France', 'Europe', 'FRAU0879', 0),
(0, 'Usson', 'France', 'Europe', 'FRAU0880', 0),
(0, 'Usson-du-Poitou', 'France', 'Europe', 'FRXX4426', 0),
(0, 'Usson-en-Forez', 'France', 'Europe', 'FRXX1947', 0),
(0, 'Ussy', 'France', 'Europe', 'FRBN1437', 0),
(0, 'Ussy-sur-Marne', 'France', 'Europe', 'FRIF0610', 0),
(0, 'Ustaritz', 'France', 'Europe', 'FRXX4108', 0),
(0, 'Ustou', 'France', 'Europe', 'FRXX6284', 0),
(0, 'Utelle', 'France', 'Europe', 'FRPA0657', 0),
(0, 'Uttenheim', 'France', 'Europe', 'FRAL0596', 0),
(0, 'Uttenhoffen', 'France', 'Europe', 'FRAL0597', 0),
(0, 'Uttwiller', 'France', 'Europe', 'FRAL0598', 0),
(0, 'Uvea', 'France', 'Europe', 'FRXX7844', 0),
(0, 'Uvernet-Fours', 'France', 'Europe', 'FRPA0658', 0),
(0, 'Uxeau', 'France', 'Europe', 'FRBO1424', 0),
(0, 'Uxegney', 'France', 'Europe', 'FRXX4526', 0),
(0, 'Uxelles', 'France', 'Europe', 'FRFC1308', 0),
(0, 'Uxem', 'France', 'Europe', 'FRNC0926', 0),
(0, 'Uz', 'France', 'Europe', 'FRMP2379', 0),
(0, 'Uza', 'France', 'Europe', 'FRAQ1703', 0),
(0, 'Uzan', 'France', 'Europe', 'FRAQ1704', 0),
(0, 'Uzay-le-Venon', 'France', 'Europe', 'FRXX6680', 0),
(0, 'Uzech', 'France', 'Europe', 'FRMP2380', 0),
(0, 'Uzein', 'France', 'Europe', 'FRAQ1705', 0),
(0, 'Uzel', 'France', 'Europe', 'FRXX6225', 0),
(0, 'Uzelle', 'France', 'Europe', 'FRFC1309', 0),
(0, 'Uzemain', 'France', 'Europe', 'FRLO1638', 0),
(0, 'Uzer', 'France', 'Europe', 'FRMP2381', 0),
(0, 'Uzer', 'France', 'Europe', 'FRRA2023', 0),
(0, 'Uzerche', 'France', 'Europe', 'FRXX6215', 0),
(0, 'Uzes', 'France', 'Europe', 'FRXX3301', 0),
(0, 'Uzeste', 'France', 'Europe', 'FRAQ1706', 0),
(0, 'Uzos', 'France', 'Europe', 'FRAQ1707', 0),
(0, 'Valbelle', 'France', 'Europe', 'FRPA0662', 0),
(0, 'Valberg', 'France', 'Europe', 'FRPA0663', 0),
(0, 'Valbois', 'France', 'Europe', 'FRLO1651', 0),
(0, 'Valbonnais', 'France', 'Europe', 'FRRA2029', 0),
(0, 'Valbonne', 'France', 'Europe', 'FRXX4683', 0),
(0, 'Valcabrere', 'France', 'Europe', 'FRMP2389', 0),
(0, 'Valcanville', 'France', 'Europe', 'FRBN1440', 0),
(0, 'Valcebollere', 'France', 'Europe', 'FRLR0925', 0),
(0, 'Valcivieres', 'France', 'Europe', 'FRAU0883', 0),
(0, 'Valcourt', 'France', 'Europe', 'FRCA1489', 0),
(0, 'Valdahon', 'France', 'Europe', 'FRXX1861', 0),
(0, 'Valdampierre', 'France', 'Europe', 'FRPI1652', 0),
(0, 'Valdeblore', 'France', 'Europe', 'FRPA0664', 0),
(0, 'Valdeblore', 'France', 'Europe', 'FRPA0665', 0),
(0, 'Valdelancourt', 'France', 'Europe', 'FRCA1490', 0),
(0, 'Valderies', 'France', 'Europe', 'FRMP2390', 0),
(0, 'Valderoure', 'France', 'Europe', 'FRPA0666', 0),
(0, 'Valdieu-Lutran', 'France', 'Europe', 'FRAL0599', 0),
(0, 'Valdivienne', 'France', 'Europe', 'FRPC1114', 0),
(0, 'Valdoie', 'France', 'Europe', 'FRMP2391', 0),
(0, 'Valdrome', 'France', 'Europe', 'FRRA2030', 0),
(0, 'Valdurenque', 'France', 'Europe', 'FRMP2392', 0),
(0, 'Valeille', 'France', 'Europe', 'FRRA2031', 0),
(0, 'Valeilles', 'France', 'Europe', 'FRMP2393', 0),
(0, 'Valeins', 'France', 'Europe', 'FRRA2032', 0),
(0, 'Valempoulieres', 'France', 'Europe', 'FRFC1320', 0),
(0, 'Valencay', 'France', 'Europe', 'FRCE1256', 0),
(0, 'Valence', 'France', 'Europe', 'FRMP2394', 0),
(0, 'Valence', 'France', 'Europe', 'FRPC1115', 0),
(0, 'Valence', 'France', 'Europe', 'FRXX0102', 0),
(0, 'Valence-d`Albigeois', 'France', 'Europe', 'FRMP2395', 0),
(0, 'Valence-en-Brie', 'France', 'Europe', 'FRXX5317', 0),
(0, 'Valence-sur-Baise', 'France', 'Europe', 'FRXX5187', 0),
(0, 'Valenciennes', 'France', 'Europe', 'FRXX0429', 0),
(0, 'Valencin', 'France', 'Europe', 'FRRA2033', 0),
(0, 'Valencogne', 'France', 'Europe', 'FRXX6459', 0),
(0, 'Valennes', 'France', 'Europe', 'FRPL1027', 0),
(0, 'Valensole', 'France', 'Europe', 'FRXX6112', 0),
(0, 'Valentigney', 'France', 'Europe', 'FRXX4821', 0),
(0, 'Valentine', 'France', 'Europe', 'FRMP2396', 0),
(0, 'Valenton', 'France', 'Europe', 'FRIF0611', 0),
(0, 'Valergues', 'France', 'Europe', 'FRLR0926', 0),
(0, 'Valernes', 'France', 'Europe', 'FRPA0667', 0),
(0, 'Valescourt', 'France', 'Europe', 'FRPI1653', 0),
(0, 'Valette', 'France', 'Europe', 'FRAU0884', 0),
(0, 'Valeuil', 'France', 'Europe', 'FRAQ1708', 0),
(0, 'Valeyrac', 'France', 'Europe', 'FRAQ1709', 0),
(0, 'Valezan', 'France', 'Europe', 'FRRA2034', 0),
(0, 'Valff', 'France', 'Europe', 'FRAL0600', 0),
(0, 'Valfin-sur-Valouse', 'France', 'Europe', 'FRFC1321', 0),
(0, 'Valflaunes', 'France', 'Europe', 'FRLR0927', 0),
(0, 'Valfleury', 'France', 'Europe', 'FRRA2035', 0),
(0, 'Valframbert', 'France', 'Europe', 'FRBN1441', 0),
(0, 'Valfrejus', 'France', 'Europe', 'FRXX0550', 0),
(0, 'Valfroicourt', 'France', 'Europe', 'FRLO1652', 0),
(0, 'Valgorge', 'France', 'Europe', 'FRRA2036', 0),
(0, 'Valhey', 'France', 'Europe', 'FRLO1653', 0),
(0, 'Valhuon', 'France', 'Europe', 'FRNC0929', 0),
(0, 'Valiergues', 'France', 'Europe', 'FRLI0547', 0),
(0, 'Valignat', 'France', 'Europe', 'FRAU0885', 0),
(0, 'Valigny', 'France', 'Europe', 'FRAU0886', 0),
(0, 'Valines', 'France', 'Europe', 'FRPI1654', 0),
(0, 'Valjouffrey', 'France', 'Europe', 'FRXX6460', 0),
(0, 'Valjouze', 'France', 'Europe', 'FRAU0887', 0),
(0, 'Vallabregues', 'France', 'Europe', 'FRPA0668', 0),
(0, 'Vallabrix', 'France', 'Europe', 'FRPA0669', 0),
(0, 'Vallan', 'France', 'Europe', 'FRXX3770', 0),
(0, 'Vallangoujard', 'France', 'Europe', 'FRIF0612', 0),
(0, 'Vallans', 'France', 'Europe', 'FRPC1116', 0),
(0, 'Vallant-Saint-Georges', 'France', 'Europe', 'FRCA1491', 0),
(0, 'Vallauris', 'France', 'Europe', 'FRXX5403', 0),
(0, 'Valle-d`Alesani', 'France', 'Europe', 'FRCO0220', 0),
(0, 'Valle-d`Orezza', 'France', 'Europe', 'FRXX3172', 0),
(0, 'Valle-di-Mezzana', 'France', 'Europe', 'FRCO0221', 0),
(0, 'Valle-di-Rostino', 'France', 'Europe', 'FRXX3173', 0),
(0, 'Vallecalle', 'France', 'Europe', 'FRCO0222', 0),
(0, 'Vallegue', 'France', 'Europe', 'FRMP2397', 0),
(0, 'Valleiry', 'France', 'Europe', 'FRXX4304', 0),
(0, 'Vallenay', 'France', 'Europe', 'FRCE1257', 0),
(0, 'Vallentigny', 'France', 'Europe', 'FRCA1492', 0),
(0, 'Watten', 'France', 'Europe', 'FRXX5056', 0),
(0, 'Wattignies', 'France', 'Europe', 'FRNC0992', 0),
(0, 'Wattignies-la-Victoire', 'France', 'Europe', 'FRXX1354', 0),
(0, 'Wattrelos', 'France', 'Europe', 'FRXX4518', 0),
(0, 'Wattwiller', 'France', 'Europe', 'FRXX5627', 0),
(0, 'Wavignies', 'France', 'Europe', 'FRPI1779', 0),
(0, 'Waville', 'France', 'Europe', 'FRLO1813', 0),
(0, 'Wavrans-sur-l`Aa', 'France', 'Europe', 'FRNC0994', 0),
(0, 'Wavrans-sur-Ternoise', 'France', 'Europe', 'FRNC0993', 0),
(0, 'Wavrechain-sous-Denain', 'France', 'Europe', 'FRXX4853', 0),
(0, 'Wavrechain-sous-Faulx', 'France', 'Europe', 'FRXX5037', 0),
(0, 'Wavrille', 'France', 'Europe', 'FRLO1814', 0),
(0, 'Wavrin', 'France', 'Europe', 'FRXX1344', 0),
(0, 'Waziers', 'France', 'Europe', 'FRXX5097', 0),
(0, 'Weckolsheim', 'France', 'Europe', 'FRAL0621', 0),
(0, 'Wegscheid', 'France', 'Europe', 'FRAL0622', 0),
(0, 'Weinbourg', 'France', 'Europe', 'FRAL0623', 0),
(0, 'Weislingen', 'France', 'Europe', 'FRAL0624', 0),
(0, 'Weitbruch', 'France', 'Europe', 'FRAL0625', 0),
(0, 'Weiterswiller', 'France', 'Europe', 'FRAL0626', 0),
(0, 'Welles-Perennes', 'France', 'Europe', 'FRPI1780', 0),
(0, 'Wemaers-Cappel', 'France', 'Europe', 'FRNC0995', 0),
(0, 'Wentzwiller', 'France', 'Europe', 'FRAL0627', 0),
(0, 'Werentzhouse', 'France', 'Europe', 'FRAL0628', 0),
(0, 'Wervicq-Sud', 'France', 'Europe', 'FRXX3513', 0),
(0, 'West-Cappel', 'France', 'Europe', 'FRNC0996', 0),
(0, 'Westbecourt', 'France', 'Europe', 'FRNC0997', 0),
(0, 'Westhalten', 'France', 'Europe', 'FRAL0629', 0),
(0, 'Westhoffen', 'France', 'Europe', 'FRAL0630', 0),
(0, 'Westhouse', 'France', 'Europe', 'FRAL0631', 0),
(0, 'Westhouse-Marmoutier', 'France', 'Europe', 'FRAL0632', 0),
(0, 'Westrehem', 'France', 'Europe', 'FRNC0998', 0),
(0, 'Wettolsheim', 'France', 'Europe', 'FRAL0633', 0),
(0, 'Weyer', 'France', 'Europe', 'FRAL0634', 0),
(0, 'Weyersheim', 'France', 'Europe', 'FRAL0635', 0),
(0, 'Wickerschwihr', 'France', 'Europe', 'FRAL0636', 0),
(0, 'Wickersheim-Wilshausen', 'France', 'Europe', 'FRAL0637', 0),
(0, 'Wicquinghem', 'France', 'Europe', 'FRNC0999', 0),
(0, 'Wicres', 'France', 'Europe', 'FRNC1000', 0),
(0, 'Widehem', 'France', 'Europe', 'FRNC1001', 0),
(0, 'Widensolen', 'France', 'Europe', 'FRAL0638', 0),
(0, 'Wiege-Faty', 'France', 'Europe', 'FRPI1781', 0),
(0, 'Wiencourt-l`Equipee', 'France', 'Europe', 'FRPI1782', 0),
(0, 'Wierre-au-Bois', 'France', 'Europe', 'FRXX1933', 0),
(0, 'Wierre-Effroy', 'France', 'Europe', 'FRNC1002', 0),
(0, 'Wiesviller', 'France', 'Europe', 'FRLO1815', 0),
(0, 'Wignehies', 'France', 'Europe', 'FRXX3339', 0),
(0, 'Wignicourt', 'France', 'Europe', 'FRCA1670', 0),
(0, 'Wihr-au-Val', 'France', 'Europe', 'FRAL0639', 0),
(0, 'Wihr-en-Plaine', 'France', 'Europe', 'FRXX2176', 0),
(0, 'Wildenstein', 'France', 'Europe', 'FRAL0640', 0),
(0, 'Wildersbach', 'France', 'Europe', 'FRAL0641', 0),
(0, 'Willeman', 'France', 'Europe', 'FRNC1003', 0),
(0, 'Willems', 'France', 'Europe', 'FRXX4366', 0),
(0, 'Willencourt', 'France', 'Europe', 'FRNC1004', 0),
(0, 'Willer', 'France', 'Europe', 'FRAL0642', 0),
(0, 'Willer-sur-Thur', 'France', 'Europe', 'FRXX1197', 0),
(0, 'Willeroncourt', 'France', 'Europe', 'FRLO1816', 0),
(0, 'Willerval', 'France', 'Europe', 'FRNC1005', 0),
(0, 'Willerwald', 'France', 'Europe', 'FRLO1817', 0),
(0, 'Willgottheim', 'France', 'Europe', 'FRAL0643', 0),
(0, 'Williers', 'France', 'Europe', 'FRCA1671', 0),
(0, 'Willies', 'France', 'Europe', 'FRNC1006', 0),
(0, 'Wilshausen', 'France', 'Europe', 'FRAL0644', 0),
(0, 'Wilwisheim', 'France', 'Europe', 'FRAL0645', 0),
(0, 'Wimereux', 'France', 'Europe', 'FRXX1935', 0),
(0, 'Wimille', 'France', 'Europe', 'FRNC1007', 0),
(0, 'Wimmenau', 'France', 'Europe', 'FRAL0646', 0),
(0, 'Wimy', 'France', 'Europe', 'FRPI1783', 0),
(0, 'Windstein', 'France', 'Europe', 'FRAL0647', 0),
(0, 'Wingen', 'France', 'Europe', 'FRAL0648', 0),
(0, 'Wingen-sur-Moder', 'France', 'Europe', 'FRAL0649', 0),
(0, 'Wingersheim', 'France', 'Europe', 'FRAL0650', 0),
(0, 'Wingles', 'France', 'Europe', 'FRXX1996', 0),
(0, 'Winkel', 'France', 'Europe', 'FRAL0651', 0),
(0, 'Winnezeele', 'France', 'Europe', 'FRNC1008', 0),
(0, 'Wintersbourg', 'France', 'Europe', 'FRXX4540', 0),
(0, 'Wintershouse', 'France', 'Europe', 'FRAL0652', 0),
(0, 'Wintzenbach', 'France', 'Europe', 'FRAL0653', 0),
(0, 'Wintzenheim', 'France', 'Europe', 'FRXX2621', 0),
(0, 'Aincreville', 'France', 'Europe', 'FRLO0008', 0),
(0, 'Aingeray', 'France', 'Europe', 'FRLO0009', 0),
(0, 'Aingoulaincourt', 'France', 'Europe', 'FRCA0007', 0),
(0, 'Ainvelle', 'France', 'Europe', 'FRFC0016', 0),
(0, 'Ainvelle', 'France', 'Europe', 'FRLO0010', 0),
(0, 'Airaines', 'France', 'Europe', 'FRPI0013', 0),
(0, 'Airan', 'France', 'Europe', 'FRBN0007', 0),
(0, 'Aire', 'France', 'Europe', 'FRCA0008', 0),
(0, 'Aire-sur-l`Adour', 'France', 'Europe', 'FRXX0328', 0),
(0, 'Airel', 'France', 'Europe', 'FRBN0008', 0),
(0, 'Airion', 'France', 'Europe', 'FRPI0014', 0),
(0, 'Airoux', 'France', 'Europe', 'FRLR0009', 0),
(0, 'Airvault', 'France', 'Europe', 'FRPC0010', 0),
(0, 'Aiserey', 'France', 'Europe', 'FRBO0007', 0),
(0, 'Aisonville-et-Bernoville', 'France', 'Europe', 'FRPI0015', 0),
(0, 'Aissey', 'France', 'Europe', 'FRFC0017', 0),
(0, 'Aiton', 'France', 'Europe', 'FRRA0011', 0),
(0, 'Aix', 'France', 'Europe', 'FRLI0003', 0),
(0, 'Aix', 'France', 'Europe', 'FRNC0012', 0),
(0, 'Aix-en-Ergny', 'France', 'Europe', 'FRNC0013', 0),
(0, 'Aix-en-Provence', 'France', 'Europe', 'FRXX0001', 0),
(0, 'Aizac', 'France', 'Europe', 'FRRA0012', 0),
(0, 'Aizanville', 'France', 'Europe', 'FRCA0009', 0),
(0, 'Aizecq', 'France', 'Europe', 'FRPC0011', 0),
(0, 'Aizelles', 'France', 'Europe', 'FRPI0016', 0),
(0, 'Aizy-Jouy', 'France', 'Europe', 'FRPI0017', 0),
(0, 'Ajac', 'France', 'Europe', 'FRLR0010', 0),
(0, 'Ajaccio', 'France', 'Europe', 'FRXX0129', 0),
(0, 'Ajain', 'France', 'Europe', 'FRLI0004', 0),
(0, 'Ajat', 'France', 'Europe', 'FRAQ0013', 0),
(0, 'Ajoncourt', 'France', 'Europe', 'FRLO0011', 0),
(0, 'Ajoux', 'France', 'Europe', 'FRRA0013', 0),
(0, 'Alaigne', 'France', 'Europe', 'FRLR0011', 0),
(0, 'Alaincourt', 'France', 'Europe', 'FRFC0018', 0),
(0, 'Alairac', 'France', 'Europe', 'FRLR0012', 0),
(0, 'Alaise', 'France', 'Europe', 'FRFC0019', 0),
(0, 'Alan', 'France', 'Europe', 'FRMP0012', 0),
(0, 'Alba-la-Romaine', 'France', 'Europe', 'FRRA0014', 0),
(0, 'Alban', 'France', 'Europe', 'FRMP0013', 0),
(0, 'Albas', 'France', 'Europe', 'FRLR0013', 0),
(0, 'Albas', 'France', 'Europe', 'FRMP0014', 0),
(0, 'Albens', 'France', 'Europe', 'FRRA0015', 0),
(0, 'Albert', 'France', 'Europe', 'FRPI0018', 0),
(0, 'Albertacce', 'France', 'Europe', 'FRCO0002', 0),
(0, 'Albi', 'France', 'Europe', 'FRXX0002', 0),
(0, 'Albiac', 'France', 'Europe', 'FRMP0015', 0),
(0, 'Albiac', 'France', 'Europe', 'FRMP0016', 0),
(0, 'Albias', 'France', 'Europe', 'FRXX4998', 0),
(0, 'Albieres', 'France', 'Europe', 'FRLR0014', 0),
(0, 'Albies', 'France', 'Europe', 'FRMP0017', 0),
(0, 'Albiez Montrond', 'France', 'Europe', 'FRXX0440', 0),
(0, 'Albiez-le-Jeune', 'France', 'Europe', 'FRRA0017', 0),
(0, 'Albiez-Montrond', 'France', 'Europe', 'FRRA0016', 0),
(0, 'Albignac', 'France', 'Europe', 'FRLI0005', 0),
(0, 'Albine', 'France', 'Europe', 'FRMP0018', 0),
(0, 'Albiosc', 'France', 'Europe', 'FRXX5217', 0),
(0, 'Albitreccia', 'France', 'Europe', 'FRCO0003', 0),
(0, 'Alboussiere', 'France', 'Europe', 'FRRA0018', 0),
(0, 'Albussac', 'France', 'Europe', 'FRLI0006', 0),
(0, 'Alby-sur-Cheran', 'France', 'Europe', 'FRRA0019', 0),
(0, 'Alembon', 'France', 'Europe', 'FRNC0014', 0),
(0, 'Alencon', 'France', 'Europe', 'FRXX0207', 0),
(0, 'Ales', 'France', 'Europe', 'FRXX0427', 0),
(0, 'Aleu', 'France', 'Europe', 'FRMP0019', 0),
(0, 'Alexain', 'France', 'Europe', 'FRXX2266', 0),
(0, 'Aleyrac', 'France', 'Europe', 'FRRA0020', 0),
(0, 'Alfortville', 'France', 'Europe', 'FRXX3052', 0),
(0, 'Algans', 'France', 'Europe', 'FRMP0020', 0),
(0, 'Algrange', 'France', 'Europe', 'FRXX1222', 0),
(0, 'Alieze', 'France', 'Europe', 'FRFC0020', 0),
(0, 'Alincthun', 'France', 'Europe', 'FRNC0015', 0),
(0, 'Alissas', 'France', 'Europe', 'FRRA0021', 0),
(0, 'Alix', 'France', 'Europe', 'FRRA0022', 0),
(0, 'Alixan', 'France', 'Europe', 'FRRA0023', 0),
(0, 'Alizay', 'France', 'Europe', 'FRHN0003', 0),
(0, 'Allain', 'France', 'Europe', 'FRLO0012', 0),
(0, 'Allaines', 'France', 'Europe', 'FRPI0019', 0),
(0, 'Allaines-Mervilliers', 'France', 'Europe', 'FRCE0004', 0),
(0, 'Allamont', 'France', 'Europe', 'FRLO0013', 0),
(0, 'Allamps', 'France', 'Europe', 'FRLO0014', 0),
(0, 'Baralle', 'France', 'Europe', 'FRNC0073', 0),
(0, 'Barastre', 'France', 'Europe', 'FRNC0074', 0),
(0, 'Baratier', 'France', 'Europe', 'FRPA0035', 0),
(0, 'Barbachen', 'France', 'Europe', 'FRMP0171', 0),
(0, 'Barbaggio', 'France', 'Europe', 'FRCO0015', 0),
(0, 'Barbaira', 'France', 'Europe', 'FRLR0062', 0),
(0, 'Barbaise', 'France', 'Europe', 'FRCA0082', 0),
(0, 'Barbas', 'France', 'Europe', 'FRLO0089', 0),
(0, 'Barbaste', 'France', 'Europe', 'FRAQ0104', 0),
(0, 'Barbatre', 'France', 'Europe', 'FRXX2315', 0),
(0, 'Barbazan', 'France', 'Europe', 'FRMP0172', 0),
(0, 'Barbazan-Debat', 'France', 'Europe', 'FRMP0173', 0),
(0, 'Barbazan-Dessus', 'France', 'Europe', 'FRMP0174', 0),
(0, 'Barbentane', 'France', 'Europe', 'FRXX6195', 0),
(0, 'Barberaz', 'France', 'Europe', 'FRRA0117', 0),
(0, 'Barbery', 'France', 'Europe', 'FRBN0050', 0),
(0, 'Barbery', 'France', 'Europe', 'FRPI0096', 0),
(0, 'Barbeville', 'France', 'Europe', 'FRBN0051', 0),
(0, 'Barbey', 'France', 'Europe', 'FRIF0039', 0),
(0, 'Barbey-Seroux', 'France', 'Europe', 'FRLO0090', 0),
(0, 'Barbezieres', 'France', 'Europe', 'FRPC0065', 0),
(0, 'Barbezieux-Saint-Hilaire', 'France', 'Europe', 'FRPC0066', 0),
(0, 'Barbieres', 'France', 'Europe', 'FRRA0118', 0),
(0, 'Barbonval', 'France', 'Europe', 'FRPI0097', 0),
(0, 'Barbonville', 'France', 'Europe', 'FRLO0091', 0),
(0, 'Barbuise', 'France', 'Europe', 'FRCA0083', 0),
(0, 'Barby', 'France', 'Europe', 'FRRA0119', 0),
(0, 'Barcelonne', 'France', 'Europe', 'FRRA0120', 0),
(0, 'Barchain', 'France', 'Europe', 'FRLO0092', 0),
(0, 'Barcillonnette', 'France', 'Europe', 'FRPA0036', 0),
(0, 'Barcy', 'France', 'Europe', 'FRIF0040', 0),
(0, 'Bard', 'France', 'Europe', 'FRRA0121', 0),
(0, 'Bardenac', 'France', 'Europe', 'FRPC0067', 0),
(0, 'Bardigues', 'France', 'Europe', 'FRMP0175', 0),
(0, 'Bareges', 'France', 'Europe', 'FRXX0217', 0),
(0, 'Bareilles', 'France', 'Europe', 'FRMP0176', 0),
(0, 'Baren', 'France', 'Europe', 'FRMP0177', 0),
(0, 'Barenton-Bugny', 'France', 'Europe', 'FRPI0098', 0),
(0, 'Barenton-Cel', 'France', 'Europe', 'FRPI0099', 0),
(0, 'Barfleur', 'France', 'Europe', 'FRBN0052', 0),
(0, 'Bargeme', 'France', 'Europe', 'FRPA0037', 0),
(0, 'Bargemon', 'France', 'Europe', 'FRPA0038', 0),
(0, 'Barges', 'France', 'Europe', 'FRAU0041', 0),
(0, 'Barges', 'France', 'Europe', 'FRBO0058', 0),
(0, 'Barges', 'France', 'Europe', 'FRFC0094', 0),
(0, 'Bargny', 'France', 'Europe', 'FRPI0100', 0),
(0, 'Barie', 'France', 'Europe', 'FRAQ0105', 0),
(0, 'Barinque', 'France', 'Europe', 'FRAQ0106', 0),
(0, 'Barjac', 'France', 'Europe', 'FRLR0063', 0),
(0, 'Barjac', 'France', 'Europe', 'FRLR0064', 0),
(0, 'Barjac', 'France', 'Europe', 'FRMP0178', 0),
(0, 'Barjols', 'France', 'Europe', 'FRPA0039', 0),
(0, 'Barjon', 'France', 'Europe', 'FRBO0059', 0),
(0, 'Barles', 'France', 'Europe', 'FRPA0040', 0),
(0, 'Barlest', 'France', 'Europe', 'FRMP0179', 0),
(0, 'Barleux', 'France', 'Europe', 'FRPI0101', 0),
(0, 'Barlin', 'France', 'Europe', 'FRNC0075', 0),
(0, 'Barly', 'France', 'Europe', 'FRNC0076', 0),
(0, 'Barly', 'France', 'Europe', 'FRPI0102', 0),
(0, 'Barnas', 'France', 'Europe', 'FRRA0122', 0),
(0, 'Barnave', 'France', 'Europe', 'FRRA0123', 0),
(0, 'Baromesnil', 'France', 'Europe', 'FRHN0029', 0),
(0, 'Baron', 'France', 'Europe', 'FRAQ0107', 0),
(0, 'Baron', 'France', 'Europe', 'FRBO0060', 0),
(0, 'Baronville', 'France', 'Europe', 'FRLO0093', 0),
(0, 'Baroville', 'France', 'Europe', 'FRCA0084', 0),
(0, 'Barquet', 'France', 'Europe', 'FRHN0030', 0),
(0, 'Barr', 'France', 'Europe', 'FRAL0015', 0),
(0, 'Barran', 'France', 'Europe', 'FRMP0180', 0),
(0, 'Barrancoueu', 'France', 'Europe', 'FRMP0181', 0),
(0, 'Barras', 'France', 'Europe', 'FRPA0041', 0),
(0, 'Barraux', 'France', 'Europe', 'FRRA0124', 0),
(0, 'Barre', 'France', 'Europe', 'FRMP0182', 0),
(0, 'Barreme', 'France', 'Europe', 'FRPA0042', 0),
(0, 'Barret', 'France', 'Europe', 'FRPC0068', 0),
(0, 'Barretaine', 'France', 'Europe', 'FRFC0095', 0),
(0, 'Barrettali', 'France', 'Europe', 'FRCO0016', 0),
(0, 'Barricourt', 'France', 'Europe', 'FRCA0085', 0),
(0, 'Barro', 'France', 'Europe', 'FRPC0069', 0),
(0, 'Barrou', 'France', 'Europe', 'FRCE0041', 0),
(0, 'Camprond', 'France', 'Europe', 'FRBN0167', 0),
(0, 'Camps-Saint-Mathurin-Leobazel', 'France', 'Europe', 'FRLI0059', 0),
(0, 'Camps-sur-l`Isle', 'France', 'Europe', 'FRAQ0251', 0),
(0, 'Campsas', 'France', 'Europe', 'FRMP0414', 0),
(0, 'Campsegret', 'France', 'Europe', 'FRAQ0252', 0),
(0, 'Campuac', 'France', 'Europe', 'FRMP0415', 0),
(0, 'Campugnan', 'France', 'Europe', 'FRAQ0253', 0),
(0, 'Campuzan', 'France', 'Europe', 'FRMP0416', 0),
(0, 'Camurac', 'France', 'Europe', 'FRLR0122', 0),
(0, 'Canale-di-Verde', 'France', 'Europe', 'FRCO0031', 0),
(0, 'Canals', 'France', 'Europe', 'FRMP0417', 0),
(0, 'Canaples', 'France', 'Europe', 'FRPI0275', 0),
(0, 'Canapville', 'France', 'Europe', 'FRBN0168', 0),
(0, 'Canapville', 'France', 'Europe', 'FRBN0169', 0),
(0, 'Canari', 'France', 'Europe', 'FRCO0032', 0),
(0, 'Canavaggia', 'France', 'Europe', 'FRCO0033', 0),
(0, 'Cancale', 'France', 'Europe', 'FRXX6758', 0),
(0, 'Canchy', 'France', 'Europe', 'FRBN0170', 0),
(0, 'Canchy', 'France', 'Europe', 'FRPI0276', 0),
(0, 'Candas', 'France', 'Europe', 'FRXX2207', 0),
(0, 'Cande', 'France', 'Europe', 'FRPL0092', 0),
(0, 'Candor', 'France', 'Europe', 'FRPI0277', 0),
(0, 'Candresse', 'France', 'Europe', 'FRAQ0254', 0),
(0, 'Canehan', 'France', 'Europe', 'FRHN0117', 0),
(0, 'Canens', 'France', 'Europe', 'FRMP0418', 0),
(0, 'Canenx-et-Reaut', 'France', 'Europe', 'FRAQ0255', 0),
(0, 'Canet', 'France', 'Europe', 'FRLR0123', 0),
(0, 'Canet', 'France', 'Europe', 'FRLR0124', 0),
(0, 'Canet-en-Roussillon', 'France', 'Europe', 'FRXX7703', 0),
(0, 'Canettemont', 'France', 'Europe', 'FRNC0195', 0),
(0, 'Cangey', 'France', 'Europe', 'FRCE0120', 0),
(0, 'Canilhac', 'France', 'Europe', 'FRLR0125', 0),
(0, 'Canisy', 'France', 'Europe', 'FRBN0171', 0),
(0, 'Canlers', 'France', 'Europe', 'FRNC0196', 0),
(0, 'Canly', 'France', 'Europe', 'FRPI0278', 0),
(0, 'Cannectancourt', 'France', 'Europe', 'FRPI0279', 0),
(0, 'Cannelle', 'France', 'Europe', 'FRCO0034', 0),
(0, 'Cannes', 'France', 'Europe', 'FRXX0023', 0),
(0, 'Cannes-Ecluse', 'France', 'Europe', 'FRIF0090', 0),
(0, 'Cannessieres', 'France', 'Europe', 'FRPI0280', 0),
(0, 'Cannet', 'France', 'Europe', 'FRMP0419', 0),
(0, 'Canohes', 'France', 'Europe', 'FRXX4230', 0),
(0, 'Canon', 'France', 'Europe', 'FRBN0172', 0),
(0, 'Canouville', 'France', 'Europe', 'FRHN0118', 0),
(0, 'Cantaous', 'France', 'Europe', 'FRMP0420', 0),
(0, 'Cantaron', 'France', 'Europe', 'FRPA0090', 0),
(0, 'Cante', 'France', 'Europe', 'FRMP0421', 0),
(0, 'Canteleux', 'France', 'Europe', 'FRNC0197', 0),
(0, 'Canteloup', 'France', 'Europe', 'FRBN0173', 0),
(0, 'Canteloup', 'France', 'Europe', 'FRBN0174', 0),
(0, 'Cantenac', 'France', 'Europe', 'FRAQ0256', 0),
(0, 'Cantiers', 'France', 'Europe', 'FRHN0119', 0),
(0, 'Cantigny', 'France', 'Europe', 'FRPI0281', 0),
(0, 'Cantillac', 'France', 'Europe', 'FRAQ0257', 0),
(0, 'Cantin', 'France', 'Europe', 'FRNC0198', 0),
(0, 'Cantoin', 'France', 'Europe', 'FRMP0422', 0),
(0, 'Cantois', 'France', 'Europe', 'FRAQ0258', 0),
(0, 'Caorches-Saint-Nicolas', 'France', 'Europe', 'FRHN0120', 0),
(0, 'Caouennec-Lanvezeac', 'France', 'Europe', 'FRBR0005', 0),
(0, 'Caours', 'France', 'Europe', 'FRPI0282', 0),
(0, 'Cap Cepet', 'France', 'Europe', 'FRXX0127', 0),
(0, 'Capbis', 'France', 'Europe', 'FRAQ0259', 0),
(0, 'Capbreton', 'France', 'Europe', 'FRXX2881', 0),
(0, 'Capdrot', 'France', 'Europe', 'FRAQ0260', 0),
(0, 'Capelle-Fermont', 'France', 'Europe', 'FRNC0199', 0),
(0, 'Capendu', 'France', 'Europe', 'FRLR0126', 0),
(0, 'Capens', 'France', 'Europe', 'FRMP0423', 0),
(0, 'Capestang', 'France', 'Europe', 'FRLR0127', 0),
(0, 'Capesterre-Belle-Eau', 'France', 'Europe', 'FRXX7725', 0),
(0, 'Capesterre-de-Marie-Galante', 'France', 'Europe', 'FRXX7732', 0),
(0, 'Capinghem', 'France', 'Europe', 'FRNC0200', 0),
(0, 'Caplong', 'France', 'Europe', 'FRAQ0261', 0),
(0, 'Cappel', 'France', 'Europe', 'FRLO0239', 0),
(0, 'Cappelle-Brouck', 'France', 'Europe', 'FRNC0201', 0),
(0, 'Cappelle-la-Grande', 'France', 'Europe', 'FRXX2229', 0),
(0, 'Cappy', 'France', 'Europe', 'FRPI0283', 0),
(0, 'Captieux', 'France', 'Europe', 'FRAQ0262', 0),
(0, 'Capvern', 'France', 'Europe', 'FRMP0424', 0),
(0, 'Capvern les Bains', 'France', 'Europe', 'FRXX0461', 0),
(0, 'Caragoudes', 'France', 'Europe', 'FRMP0425', 0),
(0, 'Denting', 'France', 'Europe', 'FRLO0362', 0),
(0, 'Derbamont', 'France', 'Europe', 'FRLO0363', 0),
(0, 'Derce', 'France', 'Europe', 'FRPC0287', 0),
(0, 'Derchigny', 'France', 'Europe', 'FRHN0180', 0),
(0, 'Dercy', 'France', 'Europe', 'FRPI0444', 0),
(0, 'Dernacueillette', 'France', 'Europe', 'FRLR0212', 0),
(0, 'Dernancourt', 'France', 'Europe', 'FRPI0445', 0),
(0, 'Desaignes', 'France', 'Europe', 'FRRA0477', 0),
(0, 'Desandans', 'France', 'Europe', 'FRFC0396', 0),
(0, 'Descartes', 'France', 'Europe', 'FRXX2876', 0),
(0, 'Desertines', 'France', 'Europe', 'FRPL0193', 0),
(0, 'Desertines', 'France', 'Europe', 'FRXX5388', 0),
(0, 'Deservillers', 'France', 'Europe', 'FRFC0397', 0),
(0, 'Desges', 'France', 'Europe', 'FRAU0202', 0),
(0, 'Deshaies', 'France', 'Europe', 'FRXX7721', 0),
(0, 'Desmonts', 'France', 'Europe', 'FRCE0270', 0),
(0, 'Desnes', 'France', 'Europe', 'FRFC0398', 0),
(0, 'Desseling', 'France', 'Europe', 'FRLO0364', 0),
(0, 'Dessenheim', 'France', 'Europe', 'FRAL0084', 0),
(0, 'Dessia', 'France', 'Europe', 'FRFC0399', 0),
(0, 'Destord', 'France', 'Europe', 'FRLO0365', 0),
(0, 'Destry', 'France', 'Europe', 'FRLO0366', 0),
(0, 'Desvres', 'France', 'Europe', 'FRNC0265', 0),
(0, 'Detrier', 'France', 'Europe', 'FRRA0478', 0),
(0, 'Dettey', 'France', 'Europe', 'FRBO0350', 0),
(0, 'Deuil-la-Barre', 'France', 'Europe', 'FRXX2377', 0),
(0, 'Deuillet', 'France', 'Europe', 'FRPI0446', 0),
(0, 'Deulemont', 'France', 'Europe', 'FRNC0266', 0),
(0, 'Deux-Chaises', 'France', 'Europe', 'FRAU0203', 0),
(0, 'Deux-Evailles', 'France', 'Europe', 'FRPL0194', 0),
(0, 'Deux-Jumeaux', 'France', 'Europe', 'FRBN0304', 0),
(0, 'Deux-Verges', 'France', 'Europe', 'FRAU0204', 0),
(0, 'Deuxville', 'France', 'Europe', 'FRLO0367', 0),
(0, 'Devay', 'France', 'Europe', 'FRBO0351', 0),
(0, 'Devecey', 'France', 'Europe', 'FRFC0400', 0),
(0, 'Devesset', 'France', 'Europe', 'FRRA0479', 0),
(0, 'Deveze', 'France', 'Europe', 'FRMP0602', 0),
(0, 'Deviat', 'France', 'Europe', 'FRPC0288', 0),
(0, 'Devillac', 'France', 'Europe', 'FRAQ0376', 0),
(0, 'Deville', 'France', 'Europe', 'FRCA0363', 0),
(0, 'Deville-les-Rouen', 'France', 'Europe', 'FRXX5821', 0),
(0, 'Devise', 'France', 'Europe', 'FRPI0447', 0),
(0, 'Devrouze', 'France', 'Europe', 'FRBO0352', 0),
(0, 'Deyme', 'France', 'Europe', 'FRMP0603', 0),
(0, 'Deyvillers', 'France', 'Europe', 'FRLO0368', 0),
(0, 'Dhuisy', 'France', 'Europe', 'FRIF0169', 0),
(0, 'Dhuizel', 'France', 'Europe', 'FRPI0448', 0),
(0, 'Diancey', 'France', 'Europe', 'FRBO0353', 0),
(0, 'Diane-Capelle', 'France', 'Europe', 'FRLO0369', 0),
(0, 'Diant', 'France', 'Europe', 'FRIF0170', 0),
(0, 'Diarville', 'France', 'Europe', 'FRLO0370', 0),
(0, 'Diconne', 'France', 'Europe', 'FRBO0354', 0),
(0, 'Dicy', 'France', 'Europe', 'FRBO0355', 0),
(0, 'Didenheim', 'France', 'Europe', 'FRXX1378', 0),
(0, 'Diebolsheim', 'France', 'Europe', 'FRAL0085', 0),
(0, 'Diefmatten', 'France', 'Europe', 'FRAL0086', 0),
(0, 'Dieme', 'France', 'Europe', 'FRRA0480', 0),
(0, 'Diemoz', 'France', 'Europe', 'FRRA0481', 0),
(0, 'Dienay', 'France', 'Europe', 'FRBO0356', 0),
(0, 'Dienne', 'France', 'Europe', 'FRAU0205', 0),
(0, 'Dienne', 'France', 'Europe', 'FRPC0289', 0),
(0, 'Dienville', 'France', 'Europe', 'FRCA0364', 0),
(0, 'Dieppe', 'France', 'Europe', 'FRXX0224', 0),
(0, 'Dierre', 'France', 'Europe', 'FRCE0271', 0),
(0, 'Diesen', 'France', 'Europe', 'FRLO0371', 0),
(0, 'Dietwiller', 'France', 'Europe', 'FRAL0087', 0),
(0, 'Dieudonne', 'France', 'Europe', 'FRPI0449', 0),
(0, 'Dieulivol', 'France', 'Europe', 'FRAQ0377', 0),
(0, 'Dieupentale', 'France', 'Europe', 'FRMP0604', 0),
(0, 'Dieuze', 'France', 'Europe', 'FRXX0395', 0),
(0, 'Dieval', 'France', 'Europe', 'FRNC0267', 0),
(0, 'Digeon', 'France', 'Europe', 'FRPI0450', 0),
(0, 'Diges', 'France', 'Europe', 'FRBO0357', 0),
(0, 'Digna', 'France', 'Europe', 'FRBO0358', 0),
(0, 'Dignac', 'France', 'Europe', 'FRPC0290', 0),
(0, 'Digne-les-Bains', 'France', 'Europe', 'FRXX0211', 0),
(0, 'Dignonville', 'France', 'Europe', 'FRLO0372', 0),
(0, 'Digny', 'France', 'Europe', 'FRCE0272', 0),
(0, 'Digosville', 'France', 'Europe', 'FRBN0305', 0),
(0, 'Digulleville', 'France', 'Europe', 'FRBN0306', 0),
(0, 'Elzange', 'France', 'Europe', 'FRLO0411', 0),
(0, 'Emalleville', 'France', 'Europe', 'FRHN0199', 0),
(0, 'Emance', 'France', 'Europe', 'FRIF0177', 0),
(0, 'Emanville', 'France', 'Europe', 'FRHN0200', 0),
(0, 'Emanville', 'France', 'Europe', 'FRHN0201', 0),
(0, 'Embermenil', 'France', 'Europe', 'FRLO0412', 0),
(0, 'Embourie', 'France', 'Europe', 'FRPC0304', 0),
(0, 'Embres-et-Castelmaure', 'France', 'Europe', 'FRLR0218', 0),
(0, 'Embreville', 'France', 'Europe', 'FRPI0483', 0),
(0, 'Embrun', 'France', 'Europe', 'FRXX0124', 0),
(0, 'Embry', 'France', 'Europe', 'FRNC0295', 0),
(0, 'Emerainville', 'France', 'Europe', 'FRXX5613', 0),
(0, 'Emerchicourt', 'France', 'Europe', 'FRXX5792', 0),
(0, 'Emeringes', 'France', 'Europe', 'FRRA0518', 0),
(0, 'Emeville', 'France', 'Europe', 'FRXX4992', 0),
(0, 'Emieville', 'France', 'Europe', 'FRBN0330', 0),
(0, 'Emlingen', 'France', 'Europe', 'FRAL0112', 0),
(0, 'Emmerin', 'France', 'Europe', 'FRNC0296', 0),
(0, 'Emondeville', 'France', 'Europe', 'FRBN0331', 0),
(0, 'Empeaux', 'France', 'Europe', 'FRMP0629', 0),
(0, 'Empurany', 'France', 'Europe', 'FRXX1516', 0),
(0, 'Empure', 'France', 'Europe', 'FRPC0305', 0),
(0, 'Empury', 'France', 'Europe', 'FRBO0382', 0),
(0, 'Encausse', 'France', 'Europe', 'FRMP0630', 0),
(0, 'Enchenberg', 'France', 'Europe', 'FRXX3408', 0),
(0, 'Encourtiech', 'France', 'Europe', 'FRMP0631', 0),
(0, 'Endoufielle', 'France', 'Europe', 'FRMP0632', 0),
(0, 'Enfonvelle', 'France', 'Europe', 'FRCA0404', 0),
(0, 'Engayrac', 'France', 'Europe', 'FRAQ0399', 0),
(0, 'Engente', 'France', 'Europe', 'FRCA0405', 0),
(0, 'Engenthal', 'France', 'Europe', 'FRAL0113', 0),
(0, 'Engenville', 'France', 'Europe', 'FRCE0293', 0),
(0, 'Enghien-les-Bains', 'France', 'Europe', 'FRXX6721', 0),
(0, 'Engins', 'France', 'Europe', 'FRRA0519', 0),
(0, 'Englancourt', 'France', 'Europe', 'FRPI0484', 0),
(0, 'Englebelmer', 'France', 'Europe', 'FRPI0485', 0),
(0, 'Englefontaine', 'France', 'Europe', 'FRNC0297', 0),
(0, 'Englos', 'France', 'Europe', 'FRNC0298', 0),
(0, 'Engomer', 'France', 'Europe', 'FRMP0633', 0),
(0, 'Engravies', 'France', 'Europe', 'FRMP0634', 0),
(0, 'Enguiales', 'France', 'Europe', 'FRMP0635', 0),
(0, 'Enguinegatte', 'France', 'Europe', 'FRNC0299', 0),
(0, 'Engwiller', 'France', 'Europe', 'FRAL0114', 0),
(0, 'Ennemain', 'France', 'Europe', 'FRPI0486', 0),
(0, 'Ennery', 'France', 'Europe', 'FRIF0178', 0),
(0, 'Ennery', 'France', 'Europe', 'FRXX1218', 0),
(0, 'Ennezat', 'France', 'Europe', 'FRAU0221', 0),
(0, 'Ennordres', 'France', 'Europe', 'FRCE0294', 0),
(0, 'Ens', 'France', 'Europe', 'FRMP0636', 0),
(0, 'Ensigne', 'France', 'Europe', 'FRPC0306', 0),
(0, 'Entrages', 'France', 'Europe', 'FRPA0156', 0),
(0, 'Entraigues', 'France', 'Europe', 'FRAU0222', 0),
(0, 'Entraigues', 'France', 'Europe', 'FRRA0520', 0),
(0, 'Entraigues-sur-la-Sorgue', 'France', 'Europe', 'FRXX6014', 0),
(0, 'Entrammes', 'France', 'Europe', 'FRPL0207', 0),
(0, 'Entrange', 'France', 'Europe', 'FRLO0413', 0),
(0, 'Entraunes', 'France', 'Europe', 'FRPA0157', 0),
(0, 'Entre-Deux', 'France', 'Europe', 'FRXX7800', 0),
(0, 'Entre-deux-Eaux', 'France', 'Europe', 'FRLO0414', 0),
(0, 'Entre-deux-Guiers', 'France', 'Europe', 'FRRA0521', 0),
(0, 'Entre-deux-Monts', 'France', 'Europe', 'FRFC0431', 0),
(0, 'Entrechaux', 'France', 'Europe', 'FRPA0158', 0),
(0, 'Entremont', 'France', 'Europe', 'FRRA0522', 0),
(0, 'Entrepierres', 'France', 'Europe', 'FRPA0159', 0),
(0, 'Entressen', 'France', 'Europe', 'FRXX3708', 0),
(0, 'Entrevaux', 'France', 'Europe', 'FRPA0160', 0),
(0, 'Entrevennes', 'France', 'Europe', 'FRPA0161', 0),
(0, 'Entrevernes', 'France', 'Europe', 'FRRA0523', 0),
(0, 'Entzheim', 'France', 'Europe', 'FRXX4437', 0),
(0, 'Enval', 'France', 'Europe', 'FRAU0223', 0),
(0, 'Envermeu', 'France', 'Europe', 'FRHN0202', 0),
(0, 'Envronville', 'France', 'Europe', 'FRHN0203', 0),
(0, 'Eoulx', 'France', 'Europe', 'FRPA0162', 0),
(0, 'Eourres', 'France', 'Europe', 'FRPA0163', 0),
(0, 'Eoux', 'France', 'Europe', 'FRMP0637', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Epagne', 'France', 'Europe', 'FRCA0406', 0),
(0, 'Epagny', 'France', 'Europe', 'FRBO0383', 0),
(0, 'Epagny', 'France', 'Europe', 'FRPI0487', 0),
(0, 'Epagny', 'France', 'Europe', 'FRRA0524', 0),
(0, 'Epannes', 'France', 'Europe', 'FRPC0307', 0),
(0, 'Ferebrianges', 'France', 'Europe', 'FRCA0441', 0),
(0, 'Ferfay', 'France', 'Europe', 'FRXX2765', 0),
(0, 'Fericy', 'France', 'Europe', 'FRIF0191', 0),
(0, 'Ferin', 'France', 'Europe', 'FRNC0342', 0),
(0, 'Fermanville', 'France', 'Europe', 'FRBN0355', 0),
(0, 'Fermont', 'France', 'Europe', 'FRLO0448', 0),
(0, 'Fernoel', 'France', 'Europe', 'FRAU0238', 0),
(0, 'Ferolles', 'France', 'Europe', 'FRCE0316', 0),
(0, 'Ferolles-Attilly', 'France', 'Europe', 'FRIF0192', 0),
(0, 'Feron', 'France', 'Europe', 'FRNC0343', 0),
(0, 'Ferques', 'France', 'Europe', 'FRNC0344', 0),
(0, 'Ferran', 'France', 'Europe', 'FRLR0233', 0),
(0, 'Ferrensac', 'France', 'Europe', 'FRAQ0444', 0),
(0, 'Ferrere', 'France', 'Europe', 'FRMP0711', 0),
(0, 'Ferrette', 'France', 'Europe', 'FRAL0127', 0),
(0, 'Ferreux-Quincey', 'France', 'Europe', 'FRCA0442', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRAQ0445', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRBN0356', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRLO0449', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRMP0712', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRPC0322', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRPI0548', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRPI0549', 0),
(0, 'Ferrieres', 'France', 'Europe', 'FRRA0566', 0),
(0, 'Ferrieres-en-Brie', 'France', 'Europe', 'FRXX1894', 0),
(0, 'Ferrussac', 'France', 'Europe', 'FRAU0239', 0),
(0, 'Fertans', 'France', 'Europe', 'FRFC0467', 0),
(0, 'Fervaches', 'France', 'Europe', 'FRBN0357', 0),
(0, 'Fescamps', 'France', 'Europe', 'FRPI0550', 0),
(0, 'Fesmy-le-Sart', 'France', 'Europe', 'FRPI0551', 0),
(0, 'Fesques', 'France', 'Europe', 'FRHN0226', 0),
(0, 'Fessanvilliers-Mattanvilliers', 'France', 'Europe', 'FRCE0317', 0),
(0, 'Fessevillers', 'France', 'Europe', 'FRFC0468', 0),
(0, 'Fessy', 'France', 'Europe', 'FRRA0567', 0),
(0, 'Festalemps', 'France', 'Europe', 'FRAQ0446', 0),
(0, 'Festieux', 'France', 'Europe', 'FRPI0552', 0),
(0, 'Festigny', 'France', 'Europe', 'FRBO0408', 0),
(0, 'Festigny', 'France', 'Europe', 'FRCA0443', 0),
(0, 'Festubert', 'France', 'Europe', 'FRNC0345', 0),
(0, 'Fetigny', 'France', 'Europe', 'FRFC0469', 0),
(0, 'Feucherolles', 'France', 'Europe', 'FRXX2803', 0),
(0, 'Feuchy', 'France', 'Europe', 'FRNC0346', 0),
(0, 'Feugarolles', 'France', 'Europe', 'FRAQ0447', 0),
(0, 'Feugeres', 'France', 'Europe', 'FRBN0358', 0),
(0, 'Feuges', 'France', 'Europe', 'FRCA0444', 0),
(0, 'Feuguerolles', 'France', 'Europe', 'FRHN0227', 0),
(0, 'Feuilla', 'France', 'Europe', 'FRLR0234', 0),
(0, 'Feuillade', 'France', 'Europe', 'FRPC0323', 0),
(0, 'Feuilleres', 'France', 'Europe', 'FRPI0553', 0),
(0, 'Feule', 'France', 'Europe', 'FRFC0470', 0),
(0, 'Feuquieres', 'France', 'Europe', 'FRXX4280', 0),
(0, 'Feurs', 'France', 'Europe', 'FRXX0390', 0),
(0, 'Feusines', 'France', 'Europe', 'FRCE0318', 0),
(0, 'Feux', 'France', 'Europe', 'FRCE0319', 0),
(0, 'Feves', 'France', 'Europe', 'FRXX5655', 0),
(0, 'Fey', 'France', 'Europe', 'FRLO0450', 0),
(0, 'Feyt', 'France', 'Europe', 'FRLI0135', 0),
(0, 'Feytiat', 'France', 'Europe', 'FRXX4503', 0),
(0, 'Feyzin', 'France', 'Europe', 'FRXX2677', 0),
(0, 'Fiac', 'France', 'Europe', 'FRMP0713', 0),
(0, 'Ficaja', 'France', 'Europe', 'FRCO0068', 0),
(0, 'Ficheux', 'France', 'Europe', 'FRNC0347', 0),
(0, 'Fieffes-Montrelet', 'France', 'Europe', 'FRPI0554', 0),
(0, 'Fiefs', 'France', 'Europe', 'FRNC0348', 0),
(0, 'Fiennes', 'France', 'Europe', 'FRNC0349', 0),
(0, 'Fienvillers', 'France', 'Europe', 'FRPI0555', 0),
(0, 'Fieulaine', 'France', 'Europe', 'FRPI0556', 0),
(0, 'Fieux', 'France', 'Europe', 'FRAQ0448', 0),
(0, 'Figanieres', 'France', 'Europe', 'FRXX6458', 0),
(0, 'Figari', 'France', 'Europe', 'FRXX5473', 0),
(0, 'Figarol', 'France', 'Europe', 'FRMP0714', 0),
(0, 'Figeac', 'France', 'Europe', 'FRXX0383', 0),
(0, 'Fignevelle', 'France', 'Europe', 'FRLO0451', 0),
(0, 'Fignieres', 'France', 'Europe', 'FRPI0557', 0),
(0, 'Filain', 'France', 'Europe', 'FRFC0471', 0),
(0, 'Filain', 'France', 'Europe', 'FRPI0558', 0),
(0, 'Fillieres', 'France', 'Europe', 'FRLO0452', 0),
(0, 'Fillievres', 'France', 'Europe', 'FRNC0350', 0),
(0, 'Fillinges', 'France', 'Europe', 'FRRA0568', 0),
(0, 'Fillols', 'France', 'Europe', 'FRLR0235', 0),
(0, 'Gaudiempre', 'France', 'Europe', 'FRNC0380', 0),
(0, 'Gaudies', 'France', 'Europe', 'FRMP0795', 0),
(0, 'Gaudonville', 'France', 'Europe', 'FRMP0796', 0),
(0, 'Gaudreville-la-Riviere', 'France', 'Europe', 'FRHN0267', 0),
(0, 'Gaugeac', 'France', 'Europe', 'FRAQ0494', 0),
(0, 'Gaujac', 'France', 'Europe', 'FRAQ0495', 0),
(0, 'Gaujac', 'France', 'Europe', 'FRMP0797', 0),
(0, 'Gaujac', 'France', 'Europe', 'FRPA0194', 0),
(0, 'Gaujacq', 'France', 'Europe', 'FRXX6050', 0),
(0, 'Gaujan', 'France', 'Europe', 'FRMP0798', 0),
(0, 'Gaure', 'France', 'Europe', 'FRMP0799', 0),
(0, 'Gauriac', 'France', 'Europe', 'FRAQ0496', 0),
(0, 'Gauriaguet', 'France', 'Europe', 'FRAQ0497', 0),
(0, 'Gaussan', 'France', 'Europe', 'FRMP0800', 0),
(0, 'Gausson', 'France', 'Europe', 'FRBR0013', 0),
(0, 'Gauville', 'France', 'Europe', 'FRBN0386', 0),
(0, 'Gauville', 'France', 'Europe', 'FRPI0635', 0),
(0, 'Gauville-la-Campagne', 'France', 'Europe', 'FRHN0268', 0),
(0, 'Gavarnie', 'France', 'Europe', 'FRMP0801', 0),
(0, 'Gavarret-sur-Aulouste', 'France', 'Europe', 'FRMP0802', 0),
(0, 'Gavaudun', 'France', 'Europe', 'FRAQ0498', 0),
(0, 'Gavet', 'France', 'Europe', 'FRRA0593', 0),
(0, 'Gavignano', 'France', 'Europe', 'FRCO0075', 0),
(0, 'Gavisse', 'France', 'Europe', 'FRLO0508', 0),
(0, 'Gavray', 'France', 'Europe', 'FRBN0387', 0),
(0, 'Gavrelle', 'France', 'Europe', 'FRNC0381', 0),
(0, 'Gavres', 'France', 'Europe', 'FRXX5200', 0),
(0, 'Gavrus', 'France', 'Europe', 'FRBN0388', 0),
(0, 'Gayan', 'France', 'Europe', 'FRMP0803', 0),
(0, 'Gaye', 'France', 'Europe', 'FRCA0479', 0),
(0, 'Gayon', 'France', 'Europe', 'FRAQ0499', 0),
(0, 'Gazaupouy', 'France', 'Europe', 'FRMP0804', 0),
(0, 'Gazave', 'France', 'Europe', 'FRMP0805', 0),
(0, 'Gazax-et-Baccarisse', 'France', 'Europe', 'FRMP0806', 0),
(0, 'Gazeran', 'France', 'Europe', 'FRIF0221', 0),
(0, 'Gazost', 'France', 'Europe', 'FRMP0807', 0),
(0, 'Geanges', 'France', 'Europe', 'FRBO0457', 0),
(0, 'Geaune', 'France', 'Europe', 'FRAQ0500', 0),
(0, 'Geay', 'France', 'Europe', 'FRPC0345', 0),
(0, 'Geay', 'France', 'Europe', 'FRPC0346', 0),
(0, 'Gedre', 'France', 'Europe', 'FRMP0808', 0),
(0, 'Gee', 'France', 'Europe', 'FRPL0236', 0),
(0, 'Gee-Riviere', 'France', 'Europe', 'FRXX3647', 0),
(0, 'Geffosses', 'France', 'Europe', 'FRBN0389', 0),
(0, 'Gefosse-Fontenay', 'France', 'Europe', 'FRBN0390', 0),
(0, 'Gehee', 'France', 'Europe', 'FRXX2074', 0),
(0, 'Geishouse', 'France', 'Europe', 'FRAL0149', 0),
(0, 'Geispitzen', 'France', 'Europe', 'FRAL0150', 0),
(0, 'Geispolsheim', 'France', 'Europe', 'FRXX1401', 0),
(0, 'Geiswasser', 'France', 'Europe', 'FRAL0151', 0),
(0, 'Geiswiller', 'France', 'Europe', 'FRAL0152', 0),
(0, 'Gelacourt', 'France', 'Europe', 'FRLO0509', 0),
(0, 'Gelannes', 'France', 'Europe', 'FRCA0480', 0),
(0, 'Gelaucourt', 'France', 'Europe', 'FRLO0510', 0),
(0, 'Gellainville', 'France', 'Europe', 'FRCE0352', 0),
(0, 'Gelle', 'France', 'Europe', 'FRMP0809', 0),
(0, 'Gellenoncourt', 'France', 'Europe', 'FRLO0511', 0),
(0, 'Gelles', 'France', 'Europe', 'FRXX4204', 0),
(0, 'Gellin', 'France', 'Europe', 'FRFC0518', 0),
(0, 'Gelos', 'France', 'Europe', 'FRAQ0501', 0),
(0, 'Geloux', 'France', 'Europe', 'FRAQ0502', 0),
(0, 'Gelucourt', 'France', 'Europe', 'FRLO0512', 0),
(0, 'Gelvecourt-et-Adompt', 'France', 'Europe', 'FRLO0513', 0),
(0, 'Gemages', 'France', 'Europe', 'FRBN0391', 0),
(0, 'Gemaingoutte', 'France', 'Europe', 'FRLO0514', 0),
(0, 'Gembrie', 'France', 'Europe', 'FRMP0810', 0),
(0, 'Gemeaux', 'France', 'Europe', 'FRBO0458', 0),
(0, 'Gemenos', 'France', 'Europe', 'FRXX1074', 0),
(0, 'Gemigny', 'France', 'Europe', 'FRCE0353', 0),
(0, 'Gemil', 'France', 'Europe', 'FRMP0811', 0),
(0, 'Gemmelaincourt', 'France', 'Europe', 'FRLO0515', 0),
(0, 'Gemonval', 'France', 'Europe', 'FRFC0519', 0),
(0, 'Gemonville', 'France', 'Europe', 'FRLO0516', 0),
(0, 'Gemozac', 'France', 'Europe', 'FRPC0347', 0),
(0, 'Genac', 'France', 'Europe', 'FRPC0348', 0),
(0, 'Genainville', 'France', 'Europe', 'FRIF0222', 0),
(0, 'Genas', 'France', 'Europe', 'FRXX3635', 0),
(0, 'Genat', 'France', 'Europe', 'FRMP0812', 0),
(0, 'Genay', 'France', 'Europe', 'FRBO0459', 0),
(0, 'Genay', 'France', 'Europe', 'FRXX4248', 0),
(0, 'Hartennes-et-Taux', 'France', 'Europe', 'FRPI0729', 0),
(0, 'Hartmannswiller', 'France', 'Europe', 'FRAL0192', 0),
(0, 'Hartzviller', 'France', 'Europe', 'FRXX6629', 0),
(0, 'Harville', 'France', 'Europe', 'FRLO0641', 0),
(0, 'Hary', 'France', 'Europe', 'FRPI0730', 0),
(0, 'Haselbourg', 'France', 'Europe', 'FRXX3674', 0),
(0, 'Hasnon', 'France', 'Europe', 'FRXX6672', 0),
(0, 'Hasparren', 'France', 'Europe', 'FRXX6312', 0),
(0, 'Haspelschiedt', 'France', 'Europe', 'FRLO0642', 0),
(0, 'Haspres', 'France', 'Europe', 'FRXX4102', 0),
(0, 'Hastingues', 'France', 'Europe', 'FRAQ0553', 0),
(0, 'Hatiheu', 'France', 'Europe', 'FRXX7891', 0),
(0, 'Hatten', 'France', 'Europe', 'FRXX6564', 0),
(0, 'Hattencourt', 'France', 'Europe', 'FRPI0731', 0),
(0, 'Hattenville', 'France', 'Europe', 'FRHN0323', 0),
(0, 'Hattigny', 'France', 'Europe', 'FRLO0643', 0),
(0, 'Hattmatt', 'France', 'Europe', 'FRAL0193', 0),
(0, 'Hattonchatel', 'France', 'Europe', 'FRLO0644', 0),
(0, 'Hattonville', 'France', 'Europe', 'FRLO0645', 0),
(0, 'Hattstatt', 'France', 'Europe', 'FRAL0194', 0),
(0, 'Hauban', 'France', 'Europe', 'FRMP0892', 0),
(0, 'Haubourdin', 'France', 'Europe', 'FRNC0421', 0),
(0, 'Hauconcourt', 'France', 'Europe', 'FRLO0646', 0),
(0, 'Haucourt', 'France', 'Europe', 'FRHN0324', 0),
(0, 'Haucourt', 'France', 'Europe', 'FRNC0422', 0),
(0, 'Haucourt', 'France', 'Europe', 'FRPI0732', 0),
(0, 'Haucourt-en-Cambresis', 'France', 'Europe', 'FRNC0423', 0),
(0, 'Haucourt-la-Rigole', 'France', 'Europe', 'FRLO0647', 0),
(0, 'Haucourt-Moulaine', 'France', 'Europe', 'FRXX1479', 0),
(0, 'Haudainville', 'France', 'Europe', 'FRLO0648', 0),
(0, 'Haudiomont', 'France', 'Europe', 'FRLO0649', 0),
(0, 'Haudivillers', 'France', 'Europe', 'FRPI0733', 0),
(0, 'Haudonville', 'France', 'Europe', 'FRLO0650', 0),
(0, 'Haudrecy', 'France', 'Europe', 'FRCA0551', 0),
(0, 'Haudricourt', 'France', 'Europe', 'FRHN0325', 0),
(0, 'Haulchin', 'France', 'Europe', 'FRNC0424', 0),
(0, 'Haulies', 'France', 'Europe', 'FRMP0893', 0),
(0, 'Haulme', 'France', 'Europe', 'FRCA0552', 0),
(0, 'Haumont-les-Lachaussee', 'France', 'Europe', 'FRLO0651', 0),
(0, 'Haumont-pres-Samogneux', 'France', 'Europe', 'FRLO0652', 0),
(0, 'Hauriet', 'France', 'Europe', 'FRAQ0554', 0),
(0, 'Hausgauen', 'France', 'Europe', 'FRAL0195', 0),
(0, 'Haussez', 'France', 'Europe', 'FRHN0326', 0),
(0, 'Haussignemont', 'France', 'Europe', 'FRCA0553', 0),
(0, 'Haussimont', 'France', 'Europe', 'FRCA0554', 0),
(0, 'Haussonville', 'France', 'Europe', 'FRLO0653', 0),
(0, 'Haussy', 'France', 'Europe', 'FRXX4409', 0),
(0, 'Haut de Bonce', 'France', 'Europe', 'FRRA0649', 0),
(0, 'Haut-Clocher', 'France', 'Europe', 'FRLO0654', 0),
(0, 'Haut-de-Bosdarros', 'France', 'Europe', 'FRAQ0556', 0),
(0, 'Haut-du-Them-Chateau-Lambert', 'France', 'Europe', 'FRFC0580', 0),
(0, 'Haut-Lieu', 'France', 'Europe', 'FRNC0425', 0),
(0, 'Haut-Loquin', 'France', 'Europe', 'FRNC0426', 0),
(0, 'Haut-Mainil', 'France', 'Europe', 'FRXX3455', 0),
(0, 'Haut-Mauco', 'France', 'Europe', 'FRAQ0555', 0),
(0, 'Hautaget', 'France', 'Europe', 'FRMP0894', 0),
(0, 'Hautbos', 'France', 'Europe', 'FRPI0734', 0),
(0, 'Haute-Amance', 'France', 'Europe', 'FRCA0555', 0),
(0, 'Haute-Avesnes', 'France', 'Europe', 'FRNC0427', 0),
(0, 'Haute-Epine', 'France', 'Europe', 'FRPI0735', 0),
(0, 'Haute-Goulaine', 'France', 'Europe', 'FRXX6440', 0),
(0, 'Haute-Indre', 'France', 'Europe', 'FRXX5775', 0),
(0, 'Haute-Isle', 'France', 'Europe', 'FRIF0249', 0),
(0, 'Haute-Kontz', 'France', 'Europe', 'FRLO0655', 0),
(0, 'Haute-Rivoire', 'France', 'Europe', 'FRRA0650', 0),
(0, 'Haute-Vigneulles', 'France', 'Europe', 'FRXX4402', 0),
(0, 'Hautecloque', 'France', 'Europe', 'FRNC0428', 0),
(0, 'Hautecote', 'France', 'Europe', 'FRNC0429', 0),
(0, 'Hautecour', 'France', 'Europe', 'FRFC0581', 0),
(0, 'Hautecour', 'France', 'Europe', 'FRRA0651', 0),
(0, 'Hautecourt-les-Broville', 'France', 'Europe', 'FRLO0656', 0),
(0, 'Hautecourt-Romaneche', 'France', 'Europe', 'FRXX2608', 0),
(0, 'Hautefage', 'France', 'Europe', 'FRLI0159', 0),
(0, 'Hautefage-la-Tour', 'France', 'Europe', 'FRAQ0557', 0),
(0, 'Hautefaye', 'France', 'Europe', 'FRAQ0558', 0),
(0, 'Hautefeuille', 'France', 'Europe', 'FRIF0250', 0),
(0, 'Hautefond', 'France', 'Europe', 'FRBO0511', 0),
(0, 'Hautefontaine', 'France', 'Europe', 'FRPI0736', 0),
(0, 'Hautefort', 'France', 'Europe', 'FRXX1740', 0),
(0, 'Hauteluce', 'France', 'Europe', 'FRXX0228', 0),
(0, 'Issirac', 'France', 'Europe', 'FRPA0213', 0),
(0, 'Issoire', 'France', 'Europe', 'FRXX2298', 0),
(0, 'Issoncourt', 'France', 'Europe', 'FRLO0723', 0),
(0, 'Issor', 'France', 'Europe', 'FRAQ0586', 0),
(0, 'Issou', 'France', 'Europe', 'FRIF0260', 0),
(0, 'Issoudun', 'France', 'Europe', 'FRXX5342', 0),
(0, 'Issoudun-Letrieix', 'France', 'Europe', 'FRLI0160', 0),
(0, 'Issus', 'France', 'Europe', 'FRMP0917', 0),
(0, 'Issy-l`Eveque', 'France', 'Europe', 'FRBO0523', 0),
(0, 'Issy-les-Moulineaux', 'France', 'Europe', 'FRXX4492', 0),
(0, 'Istres', 'France', 'Europe', 'FRXX0157', 0),
(0, 'Isturits', 'France', 'Europe', 'FRAQ0587', 0),
(0, 'Itancourt', 'France', 'Europe', 'FRPI0781', 0),
(0, 'Iteuil', 'France', 'Europe', 'FRXX2153', 0),
(0, 'Ithorots-Olhaiby', 'France', 'Europe', 'FRAQ0588', 0),
(0, 'Ittenheim', 'France', 'Europe', 'FRAL0251', 0),
(0, 'Itteville', 'France', 'Europe', 'FRXX5960', 0),
(0, 'Ittlenheim', 'France', 'Europe', 'FRAL0252', 0),
(0, 'Itxassou', 'France', 'Europe', 'FRXX5047', 0),
(0, 'Itzac', 'France', 'Europe', 'FRMP0918', 0),
(0, 'Ivergny', 'France', 'Europe', 'FRNC0487', 0),
(0, 'Iverny', 'France', 'Europe', 'FRIF0261', 0),
(0, 'Iviers', 'France', 'Europe', 'FRPI0782', 0),
(0, 'Iville', 'France', 'Europe', 'FRHN0372', 0),
(0, 'Ivors', 'France', 'Europe', 'FRXX3483', 0),
(0, 'Ivory', 'France', 'Europe', 'FRFC0597', 0),
(0, 'Ivoy-le-Pre', 'France', 'Europe', 'FRCE0412', 0),
(0, 'Ivrey', 'France', 'Europe', 'FRFC0598', 0),
(0, 'Ivry-en-Montagne', 'France', 'Europe', 'FRBO0524', 0),
(0, 'Ivry-la-Bataille', 'France', 'Europe', 'FRXX6235', 0),
(0, 'Ivry-le-Temple', 'France', 'Europe', 'FRXX6471', 0),
(0, 'Ivry-sur-Seine', 'France', 'Europe', 'FRXX4544', 0),
(0, 'Iwuy', 'France', 'Europe', 'FRNC0488', 0),
(0, 'Izaourt', 'France', 'Europe', 'FRMP0919', 0),
(0, 'Izaut-de-l`Hotel', 'France', 'Europe', 'FRXX3630', 0),
(0, 'Izaux', 'France', 'Europe', 'FRMP0920', 0),
(0, 'Ize', 'France', 'Europe', 'FRPL0268', 0),
(0, 'Izeaux', 'France', 'Europe', 'FRXX2671', 0),
(0, 'Izel-les-Equerchin', 'France', 'Europe', 'FRNC0489', 0),
(0, 'Izel-les-Hameaux', 'France', 'Europe', 'FRXX4167', 0),
(0, 'Izenave', 'France', 'Europe', 'FRRA0668', 0),
(0, 'Izernore', 'France', 'Europe', 'FRRA0669', 0),
(0, 'Izeron', 'France', 'Europe', 'FRRA0670', 0),
(0, 'Izeure', 'France', 'Europe', 'FRBO0525', 0),
(0, 'Izier', 'France', 'Europe', 'FRBO0526', 0),
(0, 'Izieu', 'France', 'Europe', 'FRRA0671', 0),
(0, 'Izon', 'France', 'Europe', 'FRAQ0589', 0),
(0, 'Izon-la-Bruisse', 'France', 'Europe', 'FRRA0672', 0),
(0, 'Izotges', 'France', 'Europe', 'FRMP0921', 0),
(0, 'Izy', 'France', 'Europe', 'FRCE0413', 0),
(0, 'Jonquieres', 'France', 'Europe', 'FRXX1600', 0),
(0, 'Jonquieres-Saint-Vincent', 'France', 'Europe', 'FRXX5579', 0),
(0, 'Jons', 'France', 'Europe', 'FRRA0693', 0),
(0, 'Jonval', 'France', 'Europe', 'FRCA0608', 0),
(0, 'Jonvelle', 'France', 'Europe', 'FRFC0602', 0),
(0, 'Jonville-en-Woevre', 'France', 'Europe', 'FRLO0737', 0),
(0, 'Jonzac', 'France', 'Europe', 'FRPC0393', 0),
(0, 'Jonzier-Epagny', 'France', 'Europe', 'FRRA0694', 0),
(0, 'Jonzieux', 'France', 'Europe', 'FRRA0695', 0),
(0, 'Joppecourt', 'France', 'Europe', 'FRLO0738', 0),
(0, 'Jorquenay', 'France', 'Europe', 'FRCA0609', 0),
(0, 'Jort', 'France', 'Europe', 'FRBN0472', 0),
(0, 'Jorxey', 'France', 'Europe', 'FRLO0739', 0),
(0, 'Josat', 'France', 'Europe', 'FRAU0287', 0),
(0, 'Joserand', 'France', 'Europe', 'FRAU0288', 0),
(0, 'Josnes', 'France', 'Europe', 'FRCE0422', 0),
(0, 'Josse', 'France', 'Europe', 'FRAQ0598', 0),
(0, 'Josselin', 'France', 'Europe', 'FRXX5889', 0),
(0, 'Jossigny', 'France', 'Europe', 'FRIF0269', 0),
(0, 'Jou-sous-Monjou', 'France', 'Europe', 'FRAU0289', 0),
(0, 'Jouac', 'France', 'Europe', 'FRXX2974', 0),
(0, 'Jouaignes', 'France', 'Europe', 'FRPI0791', 0),
(0, 'Jouancy', 'France', 'Europe', 'FRBO0537', 0),
(0, 'Jouarre', 'France', 'Europe', 'FRXX5633', 0),
(0, 'Jouars-Pontchartrain', 'France', 'Europe', 'FRXX2081', 0),
(0, 'Jouaville', 'France', 'Europe', 'FRLO0740', 0),
(0, 'Joucas', 'France', 'Europe', 'FRPA0215', 0),
(0, 'Joucou', 'France', 'Europe', 'FRLR0296', 0),
(0, 'Joudes', 'France', 'Europe', 'FRBO0538', 0),
(0, 'Joudreville', 'France', 'Europe', 'FRLO0741', 0),
(0, 'Joue-du-Bois', 'France', 'Europe', 'FRXX4284', 0),
(0, 'Joue-du-Plain', 'France', 'Europe', 'FRBN0473', 0),
(0, 'Joue-en-Charnie', 'France', 'Europe', 'FRPL0274', 0),
(0, 'Joue-Etiau', 'France', 'Europe', 'FRPL0273', 0),
(0, 'Joue-l`Abbe', 'France', 'Europe', 'FRPL0275', 0),
(0, 'Joue-les-Tours', 'France', 'Europe', 'FRXX4442', 0),
(0, 'Joue-sur-Erdre', 'France', 'Europe', 'FRPL0276', 0),
(0, 'Jouet-sur-l`Aubois', 'France', 'Europe', 'FRXX2913', 0),
(0, 'Jouey', 'France', 'Europe', 'FRBO0539', 0),
(0, 'Jougne', 'France', 'Europe', 'FRFC0603', 0),
(0, 'Jouhe', 'France', 'Europe', 'FRFC0604', 0),
(0, 'Jouhet', 'France', 'Europe', 'FRPC0394', 0),
(0, 'Jouillat', 'France', 'Europe', 'FRLI0167', 0),
(0, 'Jouques', 'France', 'Europe', 'FRXX1803', 0),
(0, 'Jouqueviel', 'France', 'Europe', 'FRMP0928', 0),
(0, 'Jourgnac', 'France', 'Europe', 'FRLI0168', 0),
(0, 'Journans', 'France', 'Europe', 'FRRA0696', 0),
(0, 'Journet', 'France', 'Europe', 'FRPC0395', 0),
(0, 'Journiac', 'France', 'Europe', 'FRAQ0599', 0),
(0, 'Journy', 'France', 'Europe', 'FRNC0492', 0),
(0, 'Jours-en-Vaux', 'France', 'Europe', 'FRBO0540', 0),
(0, 'Jours-les-Baigneux', 'France', 'Europe', 'FRBO0541', 0),
(0, 'Joursac', 'France', 'Europe', 'FRAU0290', 0),
(0, 'Jousse', 'France', 'Europe', 'FRPC0396', 0),
(0, 'Jouveaux', 'France', 'Europe', 'FRHN0373', 0),
(0, 'Jouvencon', 'France', 'Europe', 'FRBO0542', 0),
(0, 'Joux', 'France', 'Europe', 'FRRA0697', 0),
(0, 'Joux-la-Ville', 'France', 'Europe', 'FRXX6792', 0),
(0, 'Jouy', 'France', 'Europe', 'FRBO0543', 0),
(0, 'Jouy', 'France', 'Europe', 'FRCE0423', 0),
(0, 'Jouy', 'France', 'Europe', 'FRPI0792', 0),
(0, 'Jouy-aux-Arches', 'France', 'Europe', 'FRXX1331', 0),
(0, 'Jouy-en-Argonne', 'France', 'Europe', 'FRLO0742', 0),
(0, 'Jouy-en-Josas', 'France', 'Europe', 'FRXX6547', 0),
(0, 'Jouy-en-Pithiverais', 'France', 'Europe', 'FRCE0424', 0),
(0, 'Jouy-le-Chatel', 'France', 'Europe', 'FRXX1409', 0),
(0, 'Jouy-le-Moutier', 'France', 'Europe', 'FRXX1696', 0),
(0, 'Jouy-le-Potier', 'France', 'Europe', 'FRXX4901', 0),
(0, 'Jouy-les-Reims', 'France', 'Europe', 'FRCA0610', 0),
(0, 'Jouy-Mauvoisin', 'France', 'Europe', 'FRIF0270', 0),
(0, 'Jouy-sous-Thelle', 'France', 'Europe', 'FRXX5010', 0),
(0, 'Jouy-sur-Eure', 'France', 'Europe', 'FRHN0374', 0),
(0, 'Jouy-sur-Morin', 'France', 'Europe', 'FRIF0271', 0),
(0, 'Joyeuse', 'France', 'Europe', 'FRRA0698', 0),
(0, 'Joyeux', 'France', 'Europe', 'FRRA0699', 0),
(0, 'Joze', 'France', 'Europe', 'FRAU0291', 0),
(0, 'Ju-Belloc', 'France', 'Europe', 'FRXX2186', 0),
(0, 'Juan-les-Pins', 'France', 'Europe', 'FRXX1723', 0),
(0, 'Juaye-Mondaye', 'France', 'Europe', 'FRBN0474', 0),
(0, 'Jubainville', 'France', 'Europe', 'FRLO0743', 0),
(0, 'La Besliere', 'France', 'Europe', 'FRBN0492', 0),
(0, 'La Besseyre-Saint-Mary', 'France', 'Europe', 'FRAU0296', 0),
(0, 'La Bezole', 'France', 'Europe', 'FRLR0301', 0),
(0, 'La Bigne', 'France', 'Europe', 'FRBN0493', 0),
(0, 'La Bigottiere', 'France', 'Europe', 'FRPL0300', 0),
(0, 'La Biolle', 'France', 'Europe', 'FRRA0723', 0),
(0, 'La Bloutiere', 'France', 'Europe', 'FRBN0494', 0),
(0, 'La Bocca', 'France', 'Europe', 'FRXX4678', 0),
(0, 'La Bohalle', 'France', 'Europe', 'FRPL0301', 0),
(0, 'La Boisse', 'France', 'Europe', 'FRRA0724', 0),
(0, 'La Boissiere', 'France', 'Europe', 'FRBN0495', 0),
(0, 'La Boissiere', 'France', 'Europe', 'FRFC0616', 0),
(0, 'La Boissiere', 'France', 'Europe', 'FRHN0381', 0),
(0, 'La Boissiere', 'France', 'Europe', 'FRLR0302', 0),
(0, 'La Boissiere', 'France', 'Europe', 'FRPL0302', 0),
(0, 'La Boissiere-d`Ans', 'France', 'Europe', 'FRAQ0609', 0),
(0, 'La Boissiere-de-Montaigu', 'France', 'Europe', 'FRPL0303', 0),
(0, 'La Boissiere-des-Landes', 'France', 'Europe', 'FRPL0304', 0),
(0, 'La Boissiere-du-Dore', 'France', 'Europe', 'FRPL0305', 0),
(0, 'La Boissiere-Ecole', 'France', 'Europe', 'FRIF0275', 0),
(0, 'La Boissiere-en-Gatine', 'France', 'Europe', 'FRPC0415', 0),
(0, 'La Boissiere-sur-Evre', 'France', 'Europe', 'FRPL0306', 0),
(0, 'La Bollene-Vesubie', 'France', 'Europe', 'FRPA0229', 0),
(0, 'La Bonneville', 'France', 'Europe', 'FRBN0496', 0),
(0, 'La Bonneville-sur-Iton', 'France', 'Europe', 'FRHN0382', 0),
(0, 'La Bosse', 'France', 'Europe', 'FRCE0429', 0),
(0, 'La Bosse', 'France', 'Europe', 'FRFC0617', 0),
(0, 'La Bosse', 'France', 'Europe', 'FRPL0307', 0),
(0, 'La Bosse-de-Bretagne', 'France', 'Europe', 'FRBR0089', 0),
(0, 'La Bouexiere', 'France', 'Europe', 'FRBR0090', 0),
(0, 'La Bouilladisse', 'France', 'Europe', 'FRXX3227', 0),
(0, 'La Bouille', 'France', 'Europe', 'FRHN0383', 0),
(0, 'La Bouillie', 'France', 'Europe', 'FRBR0091', 0),
(0, 'La Boulaye', 'France', 'Europe', 'FRBO0557', 0),
(0, 'La Boulouze', 'France', 'Europe', 'FRBN0497', 0),
(0, 'La Bourboule', 'France', 'Europe', 'FRXX6015', 0),
(0, 'La Bourdiniere-Saint-Loup', 'France', 'Europe', 'FRCE0430', 0),
(0, 'La Bourgonce', 'France', 'Europe', 'FRLO0771', 0),
(0, 'La Boussac', 'France', 'Europe', 'FRBR0092', 0),
(0, 'La Bouteille', 'France', 'Europe', 'FRPI0802', 0),
(0, 'La Brede', 'France', 'Europe', 'FRAQ0610', 0),
(0, 'La Bree-les-Bains', 'France', 'Europe', 'FRXX2512', 0),
(0, 'La Breille-les-Pins', 'France', 'Europe', 'FRPL0308', 0),
(0, 'La Breole', 'France', 'Europe', 'FRPA0230', 0),
(0, 'La Bresse', 'France', 'Europe', 'FRXX0514', 0),
(0, 'La Breteniere', 'France', 'Europe', 'FRFC0618', 0),
(0, 'La Breteniere', 'France', 'Europe', 'FRFC0619', 0),
(0, 'La Bretonniere-la-Claye', 'France', 'Europe', 'FRPL0309', 0),
(0, 'La Breviere', 'France', 'Europe', 'FRBN0498', 0),
(0, 'La Bridoire', 'France', 'Europe', 'FRRA0725', 0),
(0, 'La Brigue', 'France', 'Europe', 'FRPA0231', 0),
(0, 'La Brillanne', 'France', 'Europe', 'FRXX3147', 0),
(0, 'La Brionne', 'France', 'Europe', 'FRLI0172', 0),
(0, 'La Broque', 'France', 'Europe', 'FRAL0287', 0),
(0, 'La Brosse-Montceaux', 'France', 'Europe', 'FRIF0276', 0),
(0, 'La Brousse', 'France', 'Europe', 'FRPC0416', 0),
(0, 'La Bruere-sur-Loir', 'France', 'Europe', 'FRPL0310', 0),
(0, 'La Bruffiere', 'France', 'Europe', 'FRXX3042', 0),
(0, 'La Bruguiere', 'France', 'Europe', 'FRPA0232', 0),
(0, 'La Brulatte', 'France', 'Europe', 'FRPL0311', 0),
(0, 'La Bruyere', 'France', 'Europe', 'FRFC0620', 0),
(0, 'La Buisse', 'France', 'Europe', 'FRRA0726', 0),
(0, 'La Buissiere', 'France', 'Europe', 'FRRA0727', 0),
(0, 'La Burbanche', 'France', 'Europe', 'FRRA0728', 0),
(0, 'La Bussiere', 'France', 'Europe', 'FRCE0431', 0),
(0, 'La Bussiere', 'France', 'Europe', 'FRPC0417', 0),
(0, 'La Bussiere-sur-Ouche', 'France', 'Europe', 'FRXX6679', 0),
(0, 'La Buxerette', 'France', 'Europe', 'FRCE0432', 0),
(0, 'La Cabanasse', 'France', 'Europe', 'FRXX1398', 0),
(0, 'La Cadiere-d`Azur', 'France', 'Europe', 'FRXX1314', 0),
(0, 'La Cadiere-et-Cambo', 'France', 'Europe', 'FRLR0303', 0),
(0, 'La Caillere-Saint-Hilaire', 'France', 'Europe', 'FRPL0312', 0),
(0, 'La Caine', 'France', 'Europe', 'FRBN0499', 0),
(0, 'La Calmette', 'France', 'Europe', 'FRPA0233', 0),
(0, 'La Calotterie', 'France', 'Europe', 'FRNC0494', 0),
(0, 'La Calvaire', 'France', 'Europe', 'FRXX0235', 0),
(0, 'La Cambe', 'France', 'Europe', 'FRBN0500', 0),
(0, 'La Canourgue', 'France', 'Europe', 'FRLR0304', 0),
(0, 'La Capelle', 'France', 'Europe', 'FRLR0305', 0),
(0, 'La Capelle', 'France', 'Europe', 'FRXX1887', 0),
(0, 'Mainvillers', 'France', 'Europe', 'FRLO0965', 0),
(0, 'Mainvilliers', 'France', 'Europe', 'FRCE0620', 0),
(0, 'Mainvilliers', 'France', 'Europe', 'FRCE0621', 0),
(0, 'Mainxe', 'France', 'Europe', 'FRPC0574', 0),
(0, 'Mainzac', 'France', 'Europe', 'FRPC0575', 0),
(0, 'Maire', 'France', 'Europe', 'FRPC0576', 0),
(0, 'Maire-Levescault', 'France', 'Europe', 'FRPC0577', 0),
(0, 'Mairieux', 'France', 'Europe', 'FRNC0582', 0),
(0, 'Mairy', 'France', 'Europe', 'FRCA0826', 0),
(0, 'Mairy-Mainville', 'France', 'Europe', 'FRLO0966', 0),
(0, 'Mairy-sur-Marne', 'France', 'Europe', 'FRCA0827', 0),
(0, 'Maisdon-sur-Sevre', 'France', 'Europe', 'FRPL0529', 0),
(0, 'Maisey-le-Duc', 'France', 'Europe', 'FRBO0708', 0),
(0, 'Maisnieres', 'France', 'Europe', 'FRPI1000', 0),
(0, 'Maisnil', 'France', 'Europe', 'FRNC0583', 0),
(0, 'Maisnil-les-Ruitz', 'France', 'Europe', 'FRXX4903', 0),
(0, 'Maisnil-les-Teneur', 'France', 'Europe', 'FRNC0584', 0),
(0, 'Maisod', 'France', 'Europe', 'FRFC0810', 0),
(0, 'Maison Rouge', 'France', 'Europe', 'FRIF0357', 0),
(0, 'Maison-des-Champs', 'France', 'Europe', 'FRCA0828', 0),
(0, 'Maison-Feyne', 'France', 'Europe', 'FRLI0263', 0),
(0, 'Maison-Maugis', 'France', 'Europe', 'FRBN0789', 0),
(0, 'Maison-Ponthieu', 'France', 'Europe', 'FRXX4478', 0),
(0, 'Maison-Roland', 'France', 'Europe', 'FRPI1001', 0),
(0, 'Maison-Rouge', 'France', 'Europe', 'FRIF0358', 0),
(0, 'Maisoncelle', 'France', 'Europe', 'FRNC0585', 0),
(0, 'Maisoncelle-et-Villers', 'France', 'Europe', 'FRCA0829', 0),
(0, 'Maisoncelle-Saint-Pierre', 'France', 'Europe', 'FRPI1002', 0),
(0, 'Maisoncelle-Tuilerie', 'France', 'Europe', 'FRPI1003', 0),
(0, 'Maisoncelles', 'France', 'Europe', 'FRCA0830', 0),
(0, 'Maisoncelles', 'France', 'Europe', 'FRPL0530', 0),
(0, 'Maisoncelles-du-Maine', 'France', 'Europe', 'FRPL0531', 0),
(0, 'Maisoncelles-en-Brie', 'France', 'Europe', 'FRIF0359', 0),
(0, 'Maisoncelles-en-Gatinais', 'France', 'Europe', 'FRIF0360', 0),
(0, 'Maisoncelles-la-Jourdan', 'France', 'Europe', 'FRXX3935', 0),
(0, 'Maisoncelles-Pelvey', 'France', 'Europe', 'FRBN0790', 0),
(0, 'Maisoncelles-sur-Ajon', 'France', 'Europe', 'FRBN0791', 0),
(0, 'Maisonnais', 'France', 'Europe', 'FRCE0622', 0),
(0, 'Maisonnais-sur-Tardoire', 'France', 'Europe', 'FRLI0264', 0),
(0, 'Maisonnay', 'France', 'Europe', 'FRPC0578', 0),
(0, 'Maisonneuve', 'France', 'Europe', 'FRPC0579', 0),
(0, 'Maisonnisses', 'France', 'Europe', 'FRLI0265', 0),
(0, 'Maisons', 'France', 'Europe', 'FRBN0792', 0),
(0, 'Maisons', 'France', 'Europe', 'FRCE0623', 0),
(0, 'Maisons', 'France', 'Europe', 'FRLR0435', 0),
(0, 'Maisons-Alfort', 'France', 'Europe', 'FRXX6092', 0),
(0, 'Maisons-du-Bois-Lievremont', 'France', 'Europe', 'FRFC0811', 0),
(0, 'Maisons-en-Champagne', 'France', 'Europe', 'FRCA0831', 0),
(0, 'Maisons-Laffitte', 'France', 'Europe', 'FRXX3039', 0),
(0, 'Maisons-les-Chaource', 'France', 'Europe', 'FRXX5549', 0),
(0, 'Maisons-les-Soulaines', 'France', 'Europe', 'FRCA0832', 0),
(0, 'Maisonsgoutte', 'France', 'Europe', 'FRAL0331', 0),
(0, 'Maisontiers', 'France', 'Europe', 'FRPC0580', 0),
(0, 'Maisse', 'France', 'Europe', 'FRIF0361', 0),
(0, 'Maissemy', 'France', 'Europe', 'FRPI1004', 0),
(0, 'Maisy', 'France', 'Europe', 'FRBN0793', 0),
(0, 'Maixe', 'France', 'Europe', 'FRLO0967', 0),
(0, 'Maizeray', 'France', 'Europe', 'FRLO0968', 0),
(0, 'Maizeroy', 'France', 'Europe', 'FRLO0969', 0),
(0, 'Maizery', 'France', 'Europe', 'FRLO0970', 0),
(0, 'Maizet', 'France', 'Europe', 'FRBN0794', 0),
(0, 'Maizey', 'France', 'Europe', 'FRLO0971', 0),
(0, 'Maizicourt', 'France', 'Europe', 'FRPI1005', 0),
(0, 'Maizieres', 'France', 'Europe', 'FRBN0795', 0),
(0, 'Maizieres', 'France', 'Europe', 'FRCA0833', 0),
(0, 'Maizieres', 'France', 'Europe', 'FRLO0972', 0),
(0, 'Maizieres', 'France', 'Europe', 'FRNC0586', 0),
(0, 'Maizieres', 'France', 'Europe', 'FRXX5310', 0),
(0, 'Maizieres-la-Grande-Paroisse', 'France', 'Europe', 'FRXX1136', 0),
(0, 'Maizieres-les-Brienne', 'France', 'Europe', 'FRCA0834', 0),
(0, 'Maizieres-les-Metz', 'France', 'Europe', 'FRXX5338', 0),
(0, 'Maizieres-les-Vic', 'France', 'Europe', 'FRLO0973', 0),
(0, 'Maizieres-sur-Amance', 'France', 'Europe', 'FRCA0835', 0),
(0, 'Maizilly', 'France', 'Europe', 'FRRA1025', 0),
(0, 'Maizy', 'France', 'Europe', 'FRPI1006', 0),
(0, 'Majastres', 'France', 'Europe', 'FRPA0351', 0),
(0, 'Makatea', 'France', 'Europe', 'FRXX7928', 0),
(0, 'Makemo', 'France', 'Europe', 'FRXX7907', 0),
(0, 'Malabat', 'France', 'Europe', 'FRMP1323', 0),
(0, 'Malafretaz', 'France', 'Europe', 'FRRA1026', 0),
(0, 'Nedonchel', 'France', 'Europe', 'FRNC0650', 0),
(0, 'Neewiller-pres-Lauterbourg', 'France', 'Europe', 'FRAL0377', 0),
(0, 'Neffes', 'France', 'Europe', 'FRPA0407', 0),
(0, 'Neffies', 'France', 'Europe', 'FRLR0550', 0),
(0, 'Nefiach', 'France', 'Europe', 'FRLR0551', 0),
(0, 'Negrepelisse', 'France', 'Europe', 'FRMP1621', 0),
(0, 'Negreville', 'France', 'Europe', 'FRBN0914', 0),
(0, 'Negrondes', 'France', 'Europe', 'FRAQ1048', 0),
(0, 'Nehou', 'France', 'Europe', 'FRBN0915', 0),
(0, 'Nehwiller-pres-Woerth', 'France', 'Europe', 'FRAL0378', 0),
(0, 'Nelling', 'France', 'Europe', 'FRLO1150', 0),
(0, 'Nemes', 'France', 'Europe', 'FRXX1637', 0),
(0, 'Nemours', 'France', 'Europe', 'FRIF0433', 0),
(0, 'Nempont-Saint-Firmin', 'France', 'Europe', 'FRXX5703', 0),
(0, 'Nenigan', 'France', 'Europe', 'FRMP1622', 0),
(0, 'Nenon', 'France', 'Europe', 'FRFC0966', 0),
(0, 'Neons-sur-Creuse', 'France', 'Europe', 'FRCE0775', 0),
(0, 'Neoules', 'France', 'Europe', 'FRPA0408', 0),
(0, 'Neoux', 'France', 'Europe', 'FRLI0304', 0),
(0, 'Nepvant', 'France', 'Europe', 'FRLO1151', 0),
(0, 'Nerac', 'France', 'Europe', 'FRXX5376', 0),
(0, 'Nerbis', 'France', 'Europe', 'FRAQ1049', 0),
(0, 'Nercillac', 'France', 'Europe', 'FRPC0685', 0),
(0, 'Nere', 'France', 'Europe', 'FRPC0686', 0),
(0, 'Neret', 'France', 'Europe', 'FRCE0776', 0),
(0, 'Nerigean', 'France', 'Europe', 'FRAQ1050', 0),
(0, 'Nerignac', 'France', 'Europe', 'FRPC0687', 0),
(0, 'Neris-les-Bains', 'France', 'Europe', 'FRXX3904', 0),
(0, 'Nermier', 'France', 'Europe', 'FRFC0967', 0),
(0, 'Nernier', 'France', 'Europe', 'FRRA1239', 0),
(0, 'Neron', 'France', 'Europe', 'FRCE0777', 0),
(0, 'Neronde', 'France', 'Europe', 'FRRA1240', 0),
(0, 'Neronde-sur-Dore', 'France', 'Europe', 'FRAU0531', 0),
(0, 'Nerondes', 'France', 'Europe', 'FRCE0778', 0),
(0, 'Nerpol-et-Serres', 'France', 'Europe', 'FRRA1241', 0),
(0, 'Ners', 'France', 'Europe', 'FRLR0552', 0),
(0, 'Nersac', 'France', 'Europe', 'FRPC0688', 0),
(0, 'Nervieux', 'France', 'Europe', 'FRRA1242', 0),
(0, 'Nerville-la-Foret', 'France', 'Europe', 'FRXX4564', 0),
(0, 'Nery', 'France', 'Europe', 'FRPI1186', 0),
(0, 'Neschers', 'France', 'Europe', 'FRAU0532', 0),
(0, 'Nescus', 'France', 'Europe', 'FRMP1623', 0),
(0, 'Nesle-et-Massoult', 'France', 'Europe', 'FRBO0884', 0),
(0, 'Nesle-Hodeng', 'France', 'Europe', 'FRHN0612', 0),
(0, 'Nesle-l`Hopital', 'France', 'Europe', 'FRPI1187', 0),
(0, 'Nesle-la-Reposte', 'France', 'Europe', 'FRCA0984', 0),
(0, 'Nesle-le-Repons', 'France', 'Europe', 'FRCA0985', 0),
(0, 'Nesle-Normandeuse', 'France', 'Europe', 'FRHN0613', 0),
(0, 'Nesles', 'France', 'Europe', 'FRNC0651', 0),
(0, 'Nesles-la-Gilberde', 'France', 'Europe', 'FRIF0434', 0),
(0, 'Nesles-la-Montagne', 'France', 'Europe', 'FRXX5599', 0),
(0, 'Nesles-la-Vallee', 'France', 'Europe', 'FRXX4554', 0),
(0, 'Neslette', 'France', 'Europe', 'FRHN0614', 0),
(0, 'Nesmy', 'France', 'Europe', 'FRPL0624', 0),
(0, 'Nesploy', 'France', 'Europe', 'FRCE0779', 0),
(0, 'Nespouls', 'France', 'Europe', 'FRLI0305', 0),
(0, 'Nessa', 'France', 'Europe', 'FRCO0115', 0),
(0, 'Nestier', 'France', 'Europe', 'FRMP1624', 0),
(0, 'Nettancourt', 'France', 'Europe', 'FRLO1152', 0),
(0, 'Netzenbach', 'France', 'Europe', 'FRAL0379', 0),
(0, 'Neublans-Abergement', 'France', 'Europe', 'FRFC0968', 0),
(0, 'Neubois', 'France', 'Europe', 'FRAL0380', 0),
(0, 'Neuchatel-Urtiere', 'France', 'Europe', 'FRFC0969', 0),
(0, 'Neuf-Berquin', 'France', 'Europe', 'FRNC0652', 0),
(0, 'Neuf-Brisach', 'France', 'Europe', 'FRXX6527', 0),
(0, 'Neuf-Eglise', 'France', 'Europe', 'FRAU0533', 0),
(0, 'Neuf-Marche', 'France', 'Europe', 'FRHN0615', 0),
(0, 'Neuf-Mesnil', 'France', 'Europe', 'FRNC0653', 0),
(0, 'Neufbosc', 'France', 'Europe', 'FRHN0616', 0),
(0, 'Neufchateau', 'France', 'Europe', 'FRLO1153', 0),
(0, 'Neufchatel-en-Bray', 'France', 'Europe', 'FRXX2681', 0),
(0, 'Neufchatel-en-Saosnois', 'France', 'Europe', 'FRPL0625', 0),
(0, 'Neufchatel-Hardelot', 'France', 'Europe', 'FRXX1405', 0),
(0, 'Neufchatel-sur-Aisne', 'France', 'Europe', 'FRXX5595', 0),
(0, 'Neufchef', 'France', 'Europe', 'FRLO1154', 0),
(0, 'Neufchelles', 'France', 'Europe', 'FRPI1188', 0),
(0, 'Neuffons', 'France', 'Europe', 'FRAQ1051', 0),
(0, 'Neuffontaines', 'France', 'Europe', 'FRBO0885', 0),
(0, 'Neufgrange', 'France', 'Europe', 'FRLO1155', 0),
(0, 'Neuflieux', 'France', 'Europe', 'FRPI1189', 0),
(0, 'Oltingue', 'France', 'Europe', 'FRAL0425', 0),
(0, 'Olwisheim', 'France', 'Europe', 'FRAL0426', 0),
(0, 'Ombleze', 'France', 'Europe', 'FRRA1270', 0),
(0, 'Omecourt', 'France', 'Europe', 'FRPI1237', 0),
(0, 'Omelmont', 'France', 'Europe', 'FRLO1204', 0),
(0, 'Omerville', 'France', 'Europe', 'FRIF0444', 0),
(0, 'Omessa', 'France', 'Europe', 'FRXX1147', 0),
(0, 'Omet', 'France', 'Europe', 'FRAQ1060', 0),
(0, 'Omex', 'France', 'Europe', 'FRMP1647', 0),
(0, 'Omey', 'France', 'Europe', 'FRCA1024', 0),
(0, 'Omicourt', 'France', 'Europe', 'FRCA1025', 0),
(0, 'Omiecourt', 'France', 'Europe', 'FRPI1238', 0),
(0, 'Omissy', 'France', 'Europe', 'FRPI1239', 0),
(0, 'Ommeel', 'France', 'Europe', 'FRBN0949', 0),
(0, 'Ommeray', 'France', 'Europe', 'FRLO1205', 0),
(0, 'Ommoy', 'France', 'Europe', 'FRBN0950', 0),
(0, 'Omont', 'France', 'Europe', 'FRCA1026', 0),
(0, 'Omonville', 'France', 'Europe', 'FRHN0641', 0),
(0, 'Omonville-la-Petite', 'France', 'Europe', 'FRBN0951', 0),
(0, 'Omonville-la-Rogue', 'France', 'Europe', 'FRBN0952', 0),
(0, 'Omps', 'France', 'Europe', 'FRAU0547', 0),
(0, 'Oms', 'France', 'Europe', 'FRLR0565', 0),
(0, 'Onans', 'France', 'Europe', 'FRFC0995', 0),
(0, 'Onard', 'France', 'Europe', 'FRAQ1061', 0),
(0, 'Onay', 'France', 'Europe', 'FRFC0996', 0),
(0, 'Oncieu', 'France', 'Europe', 'FRRA1271', 0),
(0, 'Oncourt', 'France', 'Europe', 'FRLO1206', 0),
(0, 'Oncy-sur-Ecole', 'France', 'Europe', 'FRIF0445', 0),
(0, 'Ondefontaine', 'France', 'Europe', 'FRBN0953', 0),
(0, 'Ondes', 'France', 'Europe', 'FRMP1648', 0),
(0, 'Ondres', 'France', 'Europe', 'FRXX5335', 0),
(0, 'Ondreville-sur-Essonne', 'France', 'Europe', 'FRXX1413', 0),
(0, 'Onesse-et-Laharie', 'France', 'Europe', 'FRAQ1062', 0),
(0, 'Onet-le-Chateau', 'France', 'Europe', 'FRMP1649', 0),
(0, 'Oneux', 'France', 'Europe', 'FRPI1240', 0),
(0, 'Ongles', 'France', 'Europe', 'FRPA0415', 0),
(0, 'Onglieres', 'France', 'Europe', 'FRFC0997', 0),
(0, 'Onjon', 'France', 'Europe', 'FRCA1027', 0),
(0, 'Onlay', 'France', 'Europe', 'FRBO0910', 0),
(0, 'Onnaing', 'France', 'Europe', 'FRXX3622', 0),
(0, 'Onnion', 'France', 'Europe', 'FRRA1272', 0),
(0, 'Onoz', 'France', 'Europe', 'FRFC0998', 0),
(0, 'Ons-en-Bray', 'France', 'Europe', 'FRPI1241', 0),
(0, 'Ontex', 'France', 'Europe', 'FRRA1273', 0),
(0, 'Onville', 'France', 'Europe', 'FRXX2622', 0),
(0, 'Onvillers', 'France', 'Europe', 'FRPI1242', 0),
(0, 'Onzain', 'France', 'Europe', 'FRCE0823', 0),
(0, 'Oo', 'France', 'Europe', 'FRMP1650', 0),
(0, 'Oost-Cappel', 'France', 'Europe', 'FRXX5780', 0),
(0, 'Opera', 'France', 'Europe', 'FRXX2071', 0),
(0, 'Opoul-Perillos', 'France', 'Europe', 'FRLR0566', 0),
(0, 'Oppede', 'France', 'Europe', 'FRXX6746', 0),
(0, 'Oppedette', 'France', 'Europe', 'FRPA0416', 0),
(0, 'Oppenans', 'France', 'Europe', 'FRFC0999', 0),
(0, 'Oppy', 'France', 'Europe', 'FRNC0694', 0),
(0, 'Optevoz', 'France', 'Europe', 'FRRA1274', 0),
(0, 'Oraas', 'France', 'Europe', 'FRAQ1063', 0),
(0, 'Oradour', 'France', 'Europe', 'FRAU0548', 0),
(0, 'Oradour', 'France', 'Europe', 'FRPC0704', 0),
(0, 'Oradour-Fanais', 'France', 'Europe', 'FRPC0705', 0),
(0, 'Oradour-Saint-Genest', 'France', 'Europe', 'FRXX5952', 0),
(0, 'Oradour-sur-Glane', 'France', 'Europe', 'FRXX4520', 0),
(0, 'Oradour-sur-Vayres', 'France', 'Europe', 'FRXX4386', 0),
(0, 'Orain', 'France', 'Europe', 'FRBO0911', 0),
(0, 'Orainville', 'France', 'Europe', 'FRPI1243', 0),
(0, 'Oraison', 'France', 'Europe', 'FRPA0417', 0),
(0, 'Orange', 'France', 'Europe', 'FRXX0167', 0),
(0, 'Orbagna', 'France', 'Europe', 'FRFC1000', 0),
(0, 'Orbais-l`Abbaye', 'France', 'Europe', 'FRCA1028', 0),
(0, 'Orban', 'France', 'Europe', 'FRMP1651', 0),
(0, 'Orbec', 'France', 'Europe', 'FRXX6132', 0),
(0, 'Orbeil', 'France', 'Europe', 'FRAU0549', 0),
(0, 'Orbessan', 'France', 'Europe', 'FRMP1652', 0),
(0, 'Orbey', 'France', 'Europe', 'FRXX4452', 0),
(0, 'Orbigny', 'France', 'Europe', 'FRCE0824', 0),
(0, 'Orbigny-au-Mont', 'France', 'Europe', 'FRCA1029', 0),
(0, 'Orbigny-au-Val', 'France', 'Europe', 'FRCA1030', 0),
(0, 'Orbois', 'France', 'Europe', 'FRBN0954', 0),
(0, 'Orcay', 'France', 'Europe', 'FRCE0825', 0),
(0, 'Orcemont', 'France', 'Europe', 'FRIF0446', 0),
(0, 'Pargny-la-Dhuys', 'France', 'Europe', 'FRPI1271', 0),
(0, 'Pargny-les-Bois', 'France', 'Europe', 'FRPI1272', 0),
(0, 'Pargny-les-Reims', 'France', 'Europe', 'FRXX3112', 0),
(0, 'Pargny-Resson', 'France', 'Europe', 'FRCA1055', 0),
(0, 'Pargny-sous-Mureau', 'France', 'Europe', 'FRXX3867', 0),
(0, 'Pargny-sur-Saulx', 'France', 'Europe', 'FRXX3857', 0),
(0, 'Pargues', 'France', 'Europe', 'FRCA1056', 0),
(0, 'Parignargues', 'France', 'Europe', 'FRPA0422', 0),
(0, 'Parigne', 'France', 'Europe', 'FRBR0366', 0),
(0, 'Parigne-l`Eveque', 'France', 'Europe', 'FRXX4583', 0),
(0, 'Parigne-le-Polin', 'France', 'Europe', 'FRPL0662', 0),
(0, 'Parigne-sur-Braye', 'France', 'Europe', 'FRPL0663', 0),
(0, 'Parigny', 'France', 'Europe', 'FRBN0972', 0),
(0, 'Parigny', 'France', 'Europe', 'FRRA1300', 0),
(0, 'Parigny-la-Rose', 'France', 'Europe', 'FRBO0937', 0),
(0, 'Parigny-les-Vaux', 'France', 'Europe', 'FRBO0938', 0),
(0, 'Paris', 'France', 'Europe', 'FRXX0076', 0),
(0, 'Paris-l`Hopital', 'France', 'Europe', 'FRBO0939', 0),
(0, 'Paris/Charles De Gaulle', 'France', 'Europe', 'FRXX0077', 0),
(0, 'Parisot', 'France', 'Europe', 'FRMP1691', 0),
(0, 'Parisot', 'France', 'Europe', 'FRMP1692', 0),
(0, 'Parlan', 'France', 'Europe', 'FRAU0562', 0),
(0, 'Parlanges', 'France', 'Europe', 'FRRA1301', 0),
(0, 'Parleboscq', 'France', 'Europe', 'FRAQ1097', 0),
(0, 'Parly', 'France', 'Europe', 'FRBO0940', 0),
(0, 'Parmain', 'France', 'Europe', 'FRXX6725', 0),
(0, 'Parmilieu', 'France', 'Europe', 'FRRA1302', 0),
(0, 'Parnac', 'France', 'Europe', 'FRCE0856', 0),
(0, 'Parnac', 'France', 'Europe', 'FRMP1693', 0),
(0, 'Parnans', 'France', 'Europe', 'FRRA1303', 0),
(0, 'Parnay', 'France', 'Europe', 'FRCE0857', 0),
(0, 'Parnay', 'France', 'Europe', 'FRPL0664', 0),
(0, 'Parne-sur-Roc', 'France', 'Europe', 'FRXX6067', 0),
(0, 'Parnes', 'France', 'Europe', 'FRPI1273', 0),
(0, 'Parnoy-en-Bassigny', 'France', 'Europe', 'FRCA1057', 0),
(0, 'Parois', 'France', 'Europe', 'FRLO1233', 0),
(0, 'Paron', 'France', 'Europe', 'FRBO0941', 0),
(0, 'Paroy', 'France', 'Europe', 'FRFC1030', 0),
(0, 'Paroy', 'France', 'Europe', 'FRIF0462', 0),
(0, 'Paroy-en-Othe', 'France', 'Europe', 'FRXX3745', 0),
(0, 'Paroy-sur-Saulx', 'France', 'Europe', 'FRCA1058', 0),
(0, 'Paroy-sur-Tholon', 'France', 'Europe', 'FRBO0942', 0),
(0, 'Parpecay', 'France', 'Europe', 'FRCE0858', 0),
(0, 'Parpeville', 'France', 'Europe', 'FRPI1274', 0),
(0, 'Parranquet', 'France', 'Europe', 'FRAQ1098', 0),
(0, 'Parroy', 'France', 'Europe', 'FRLO1234', 0),
(0, 'Pars-les-Chavanges', 'France', 'Europe', 'FRCA1059', 0),
(0, 'Pars-les-Romilly', 'France', 'Europe', 'FRCA1060', 0),
(0, 'Parsac', 'France', 'Europe', 'FRAQ1099', 0),
(0, 'Parsac', 'France', 'Europe', 'FRLI0326', 0),
(0, 'Parthenay', 'France', 'Europe', 'FRXX0316', 0),
(0, 'Parthenay-de-Bretagne', 'France', 'Europe', 'FRBR0367', 0),
(0, 'Partinello', 'France', 'Europe', 'FRCO0134', 0),
(0, 'Parux', 'France', 'Europe', 'FRLO1235', 0),
(0, 'Parves', 'France', 'Europe', 'FRRA1304', 0),
(0, 'Parville', 'France', 'Europe', 'FRHN0653', 0),
(0, 'Parvillers-le-Quesnoy', 'France', 'Europe', 'FRPI1275', 0),
(0, 'Parzac', 'France', 'Europe', 'FRPC0723', 0),
(0, 'Pas-de-Jeu', 'France', 'Europe', 'FRPC0724', 0),
(0, 'Pas-en-Artois', 'France', 'Europe', 'FRXX3392', 0),
(0, 'Pasilly', 'France', 'Europe', 'FRBO0943', 0),
(0, 'Paslieres', 'France', 'Europe', 'FRAU0563', 0),
(0, 'Pasly', 'France', 'Europe', 'FRPI1276', 0),
(0, 'Pasques', 'France', 'Europe', 'FRBO0944', 0),
(0, 'Passa', 'France', 'Europe', 'FRLR0581', 0),
(0, 'Passais', 'France', 'Europe', 'FRXX1603', 0),
(0, 'Passavant', 'France', 'Europe', 'FRFC1031', 0),
(0, 'Passavant-en-Argonne', 'France', 'Europe', 'FRCA1061', 0),
(0, 'Passavant-la-Rochere', 'France', 'Europe', 'FRFC1032', 0),
(0, 'Passavant-sur-Layon', 'France', 'Europe', 'FRPL0665', 0),
(0, 'Passel', 'France', 'Europe', 'FRPI1277', 0),
(0, 'Passenans', 'France', 'Europe', 'FRFC1033', 0),
(0, 'Passin', 'France', 'Europe', 'FRRA1305', 0),
(0, 'Passins', 'France', 'Europe', 'FRRA1306', 0),
(0, 'Passirac', 'France', 'Europe', 'FRPC0725', 0),
(0, 'Passonfontaine', 'France', 'Europe', 'FRXX6272', 0),
(0, 'Passy', 'France', 'Europe', 'FRBO0945', 0),
(0, 'Passy', 'France', 'Europe', 'FRBO0946', 0),
(0, 'Passy', 'France', 'Europe', 'FRRA1307', 0),
(0, 'Passy-en-Valois', 'France', 'Europe', 'FRPI1278', 0),
(0, 'Ravigny', 'France', 'Europe', 'FRPL0714', 0),
(0, 'Raville', 'France', 'Europe', 'FRLO1314', 0),
(0, 'Raville-sur-Sanon', 'France', 'Europe', 'FRLO1315', 0),
(0, 'Ravilloles', 'France', 'Europe', 'FRFC1118', 0),
(0, 'Ravine-Des-Cabris', 'France', 'Europe', 'FRXX7817', 0),
(0, 'Ray-sur-Saone', 'France', 'Europe', 'FRFC1119', 0),
(0, 'Raye-sur-Authie', 'France', 'Europe', 'FRNC0754', 0),
(0, 'Rayet', 'France', 'Europe', 'FRAQ1192', 0),
(0, 'Raymond', 'France', 'Europe', 'FRCE0923', 0),
(0, 'Raynans', 'France', 'Europe', 'FRFC1120', 0),
(0, 'Rayol-Canadel-sur-Mer', 'France', 'Europe', 'FRXX1315', 0),
(0, 'Rayssac', 'France', 'Europe', 'FRMP1833', 0),
(0, 'Razac-d`Eymet', 'France', 'Europe', 'FRAQ1193', 0),
(0, 'Razac-de-Saussignac', 'France', 'Europe', 'FRAQ1194', 0),
(0, 'Razac-sur-l`Isle', 'France', 'Europe', 'FRXX5434', 0),
(0, 'Raze', 'France', 'Europe', 'FRFC1121', 0),
(0, 'Razecueille', 'France', 'Europe', 'FRMP1834', 0),
(0, 'Razengues', 'France', 'Europe', 'FRMP1835', 0),
(0, 'Razes', 'France', 'Europe', 'FRXX1642', 0),
(0, 'Razimet', 'France', 'Europe', 'FRAQ1195', 0),
(0, 'Razines', 'France', 'Europe', 'FRCE0924', 0),
(0, 'Real', 'France', 'Europe', 'FRLR0660', 0),
(0, 'Realcamp', 'France', 'Europe', 'FRHN0695', 0),
(0, 'Reallon', 'France', 'Europe', 'FRXX0508', 0),
(0, 'Realmont', 'France', 'Europe', 'FRXX2926', 0),
(0, 'Realville', 'France', 'Europe', 'FRXX4250', 0),
(0, 'Reans', 'France', 'Europe', 'FRXX4440', 0),
(0, 'Reao', 'France', 'Europe', 'FRXX7917', 0),
(0, 'Reau', 'France', 'Europe', 'FRIF0492', 0),
(0, 'Reaumont', 'France', 'Europe', 'FRRA1421', 0),
(0, 'Reaumur', 'France', 'Europe', 'FRPL0715', 0),
(0, 'Reaup-Lisse', 'France', 'Europe', 'FRAQ1196', 0),
(0, 'Reauville', 'France', 'Europe', 'FRRA1422', 0),
(0, 'Reaux', 'France', 'Europe', 'FRPC0793', 0),
(0, 'Rebais', 'France', 'Europe', 'FRIF0493', 0),
(0, 'Rebecques', 'France', 'Europe', 'FRNC0755', 0),
(0, 'Rebenacq', 'France', 'Europe', 'FRAQ1197', 0),
(0, 'Rebergues', 'France', 'Europe', 'FRNC0756', 0),
(0, 'Rebets', 'France', 'Europe', 'FRHN0696', 0),
(0, 'Rebeuville', 'France', 'Europe', 'FRLO1316', 0),
(0, 'Rebigue', 'France', 'Europe', 'FRMP1836', 0),
(0, 'Rebouc', 'France', 'Europe', 'FRMP1837', 0),
(0, 'Rebourguil', 'France', 'Europe', 'FRMP1838', 0),
(0, 'Rebourseaux', 'France', 'Europe', 'FRBO1030', 0),
(0, 'Reboursin', 'France', 'Europe', 'FRCE0925', 0),
(0, 'Rebrechien', 'France', 'Europe', 'FRCE0926', 0),
(0, 'Rebreuve-Ranchicourt', 'France', 'Europe', 'FRNC0757', 0),
(0, 'Rebreuve-sur-Canche', 'France', 'Europe', 'FRNC0758', 0),
(0, 'Rebreuviette', 'France', 'Europe', 'FRNC0759', 0),
(0, 'Recanoz', 'France', 'Europe', 'FRFC1122', 0),
(0, 'Recey-sur-Ource', 'France', 'Europe', 'FRXX1745', 0),
(0, 'Rechesy', 'France', 'Europe', 'FRXX5272', 0),
(0, 'Rechicourt', 'France', 'Europe', 'FRLO1317', 0),
(0, 'Rechicourt-la-Petite', 'France', 'Europe', 'FRLO1318', 0),
(0, 'Rechicourt-le-Chateau', 'France', 'Europe', 'FRXX1432', 0),
(0, 'Recicourt', 'France', 'Europe', 'FRLO1319', 0),
(0, 'Reclainville', 'France', 'Europe', 'FRCE0927', 0),
(0, 'Reclesne', 'France', 'Europe', 'FRBO1031', 0),
(0, 'Reclinghem', 'France', 'Europe', 'FRNC0760', 0),
(0, 'Reclonville', 'France', 'Europe', 'FRLO1320', 0),
(0, 'Recloses', 'France', 'Europe', 'FRIF0494', 0),
(0, 'Recologne', 'France', 'Europe', 'FRFC1123', 0),
(0, 'Recologne', 'France', 'Europe', 'FRFC1124', 0),
(0, 'Recologne-les-Rioz', 'France', 'Europe', 'FRFC1125', 0),
(0, 'Recoubeau-Jansac', 'France', 'Europe', 'FRRA1423', 0),
(0, 'Recoules-d`Aubrac', 'France', 'Europe', 'FRXX3130', 0),
(0, 'Recoules-de-Fumas', 'France', 'Europe', 'FRLR0661', 0),
(0, 'Recoules-Previnquieres', 'France', 'Europe', 'FRMP1839', 0),
(0, 'Recourt', 'France', 'Europe', 'FRCA1167', 0),
(0, 'Recourt', 'France', 'Europe', 'FRNC0761', 0),
(0, 'Recourt-le-Creux', 'France', 'Europe', 'FRLO1321', 0),
(0, 'Recouvrance', 'France', 'Europe', 'FRMP1840', 0),
(0, 'Recques-sur-Course', 'France', 'Europe', 'FRNC0762', 0),
(0, 'Recques-sur-Hem', 'France', 'Europe', 'FRNC0763', 0),
(0, 'Recquignies', 'France', 'Europe', 'FRXX1170', 0),
(0, 'Reculfoz', 'France', 'Europe', 'FRFC1126', 0),
(0, 'Recurt', 'France', 'Europe', 'FRMP1841', 0),
(0, 'Recy', 'France', 'Europe', 'FRCA1168', 0),
(0, 'Redange', 'France', 'Europe', 'FRLO1322', 0),
(0, 'Redene', 'France', 'Europe', 'FRBR0491', 0),
(0, 'Saint-Alban-Auriolles', 'France', 'Europe', 'FRRA1501', 0),
(0, 'Saint-Alban-d`Ay', 'France', 'Europe', 'FRXX3249', 0),
(0, 'Saint-Alban-de-Montbel', 'France', 'Europe', 'FRXX3470', 0),
(0, 'Saint-Alban-de-Roche', 'France', 'Europe', 'FRXX5324', 0),
(0, 'Saint-Alban-des-Hurtieres', 'France', 'Europe', 'FRXX2002', 0),
(0, 'Saint-Alban-des-Villards', 'France', 'Europe', 'FRRA1502', 0),
(0, 'Saint-Alban-du-Rhone', 'France', 'Europe', 'FRRA1503', 0),
(0, 'Saint-Alban-en-Montagne', 'France', 'Europe', 'FRRA1504', 0),
(0, 'Saint-Alban-les-Eaux', 'France', 'Europe', 'FRXX4179', 0),
(0, 'Saint-Alban-Leysse', 'France', 'Europe', 'FRXX3027', 0),
(0, 'Saint-Alban-sur-Limagnole', 'France', 'Europe', 'FRXX2373', 0),
(0, 'Saint-Albin-de-Vaulserre', 'France', 'Europe', 'FRXX6378', 0),
(0, 'Saint-Alexandre', 'France', 'Europe', 'FRPA0501', 0),
(0, 'Saint-Algis', 'France', 'Europe', 'FRPI1461', 0),
(0, 'Saint-Allouestre', 'France', 'Europe', 'FRBR0517', 0),
(0, 'Saint-Alpinien', 'France', 'Europe', 'FRLI0362', 0),
(0, 'Saint-Alyre-d`Arlanc', 'France', 'Europe', 'FRAU0633', 0),
(0, 'Saint-Alyre-es-Montagne', 'France', 'Europe', 'FRXX1224', 0),
(0, 'Saint-Amadou', 'France', 'Europe', 'FRMP1923', 0),
(0, 'Saint-Amancet', 'France', 'Europe', 'FRMP1924', 0),
(0, 'Saint-Amand', 'France', 'Europe', 'FRBN1080', 0),
(0, 'Saint-Amand', 'France', 'Europe', 'FRLI0363', 0),
(0, 'Saint-Amand', 'France', 'Europe', 'FRNC0811', 0),
(0, 'Saint-Amand-de-Belves', 'France', 'Europe', 'FRAQ1234', 0),
(0, 'Saint-Amand-de-Coly', 'France', 'Europe', 'FRAQ1235', 0),
(0, 'Saint-Amand-de-Vergt', 'France', 'Europe', 'FRAQ1236', 0),
(0, 'Saint-Amand-des-Hautes-Terres', 'France', 'Europe', 'FRHN0731', 0),
(0, 'Saint-Amand-en-Puisaye', 'France', 'Europe', 'FRXX2898', 0),
(0, 'Saint-Amand-Jartoudeix', 'France', 'Europe', 'FRLI0364', 0),
(0, 'Saint-Amand-le-Petit', 'France', 'Europe', 'FRLI0366', 0),
(0, 'Saint-Amand-les-Eaux', 'France', 'Europe', 'FRXX4855', 0),
(0, 'Saint-Amand-Longpre', 'France', 'Europe', 'FRXX5939', 0),
(0, 'Saint-Amand-Magnazeix', 'France', 'Europe', 'FRLI0365', 0),
(0, 'Saint-Amand-Mont-Rond', 'France', 'Europe', 'FRXX0402', 0),
(0, 'Saint-Amand-Montrond', 'France', 'Europe', 'FRXX3258', 0),
(0, 'Saint-Amand-sur-Fion', 'France', 'Europe', 'FRCA1228', 0),
(0, 'Saint-Amand-sur-Ornain', 'France', 'Europe', 'FRLO1414', 0),
(0, 'Saint-Amand-sur-Sevre', 'France', 'Europe', 'FRXX5372', 0),
(0, 'Saint-Amandin', 'France', 'Europe', 'FRAU0634', 0),
(0, 'Saint-Amans', 'France', 'Europe', 'FRLR0705', 0),
(0, 'Saint-Amans', 'France', 'Europe', 'FRLR0706', 0),
(0, 'Saint-Amans', 'France', 'Europe', 'FRMP1925', 0),
(0, 'Saint-Amans-de-Pellagal', 'France', 'Europe', 'FRXX6033', 0),
(0, 'Saint-Amans-des-Cots', 'France', 'Europe', 'FRXX2420', 0),
(0, 'Saint-Amans-du-Pech', 'France', 'Europe', 'FRMP1927', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Saint-Amans-Soult', 'France', 'Europe', 'FRMP1926', 0),
(0, 'Saint-Amans-Valtoret', 'France', 'Europe', 'FRXX5923', 0),
(0, 'Saint-Amant', 'France', 'Europe', 'FRXX6210', 0),
(0, 'Saint-Amant-de-Boixe', 'France', 'Europe', 'FRXX2519', 0),
(0, 'Saint-Amant-de-Bonnieure', 'France', 'Europe', 'FRPC0826', 0),
(0, 'Saint-Amant-de-Graves', 'France', 'Europe', 'FRXX4758', 0),
(0, 'Saint-Amant-de-Nouere', 'France', 'Europe', 'FRXX1119', 0),
(0, 'Saint-Amant-Roche-Savine', 'France', 'Europe', 'FRAU0635', 0),
(0, 'Saint-Amant-Tallende', 'France', 'Europe', 'FRXX5302', 0),
(0, 'Saint-Amarin', 'France', 'Europe', 'FRXX2617', 0),
(0, 'Saint-Ambreuil', 'France', 'Europe', 'FRBO1072', 0),
(0, 'Saint-Ambroix', 'France', 'Europe', 'FRCE0973', 0),
(0, 'Saint-Ambroix', 'France', 'Europe', 'FRXX3298', 0),
(0, 'Saint-Ame', 'France', 'Europe', 'FRXX4523', 0),
(0, 'Saint-Amour', 'France', 'Europe', 'FRXX1501', 0),
(0, 'Saint-Amour-Bellevue', 'France', 'Europe', 'FRBO1073', 0),
(0, 'Saint-Anastaise', 'France', 'Europe', 'FRAU0636', 0),
(0, 'Saint-Andelain', 'France', 'Europe', 'FRBO1074', 0),
(0, 'Saint-Andeol', 'France', 'Europe', 'FRRA1505', 0),
(0, 'Saint-Andeol', 'France', 'Europe', 'FRRA1506', 0),
(0, 'Saint-Andeol-de-Berg', 'France', 'Europe', 'FRRA1507', 0),
(0, 'Saint-Andeol-de-Clerguemort', 'France', 'Europe', 'FRLR0707', 0),
(0, 'Saint-Andeol-de-Fourchades', 'France', 'Europe', 'FRRA1508', 0),
(0, 'Saint-Andeol-de-Vals', 'France', 'Europe', 'FRRA1509', 0),
(0, 'Saint-Andeol-le-Chateau', 'France', 'Europe', 'FRXX4994', 0),
(0, 'Saint-Andeux', 'France', 'Europe', 'FRBO1075', 0),
(0, 'Saint-Andiol', 'France', 'Europe', 'FRXX4748', 0),
(0, 'Saint-Andoche', 'France', 'Europe', 'FRXX5789', 0),
(0, 'Saint-Andre', 'France', 'Europe', 'FRLR0708', 0),
(0, 'Saint-Andre', 'France', 'Europe', 'FRMP1928', 0),
(0, 'Saint-Andre', 'France', 'Europe', 'FRMP1929', 0),
(0, 'Saint-Andre', 'France', 'Europe', 'FRMP1930', 0),
(0, 'Saint-Andre', 'France', 'Europe', 'FRRA1510', 0),
(0, 'Saint-Andre', 'France', 'Europe', 'FRXX7825', 0),
(0, 'Saint-Andre-Capceze', 'France', 'Europe', 'FRXX2385', 0),
(0, 'Tauriac', 'France', 'Europe', 'FRAQ1663', 0),
(0, 'Tauriac', 'France', 'Europe', 'FRMP2296', 0),
(0, 'Tauriac', 'France', 'Europe', 'FRMP2297', 0),
(0, 'Tauriac-de-Camares', 'France', 'Europe', 'FRMP2298', 0),
(0, 'Tauriac-de-Naucelle', 'France', 'Europe', 'FRMP2299', 0),
(0, 'Tauriers', 'France', 'Europe', 'FRRA1961', 0),
(0, 'Taurignan-Castet', 'France', 'Europe', 'FRMP2300', 0),
(0, 'Taurignan-Vieux', 'France', 'Europe', 'FRMP2301', 0),
(0, 'Taurinya', 'France', 'Europe', 'FRLR0884', 0),
(0, 'Taurize', 'France', 'Europe', 'FRLR0885', 0),
(0, 'Taussac', 'France', 'Europe', 'FRMP2302', 0),
(0, 'Taussac-la-Billiere', 'France', 'Europe', 'FRLR0886', 0),
(0, 'Taussat-les-Bains', 'France', 'Europe', 'FRXX2937', 0),
(0, 'Tautavel', 'France', 'Europe', 'FRLR0887', 0),
(0, 'Tautira', 'France', 'Europe', 'FRXX7868', 0),
(0, 'Tauves', 'France', 'Europe', 'FRXX1250', 0),
(0, 'Tauxieres-Mutry', 'France', 'Europe', 'FRCA1423', 0),
(0, 'Tauxigny', 'France', 'Europe', 'FRCE1198', 0),
(0, 'Tavaco', 'France', 'Europe', 'FRCO0212', 0),
(0, 'Tavant', 'France', 'Europe', 'FRCE1199', 0),
(0, 'Tavaux', 'France', 'Europe', 'FRXX6605', 0),
(0, 'Tavaux-et-Pontsericourt', 'France', 'Europe', 'FRPI1594', 0),
(0, 'Tavel', 'France', 'Europe', 'FRPA0631', 0),
(0, 'Tavera', 'France', 'Europe', 'FRXX1838', 0),
(0, 'Tavernay', 'France', 'Europe', 'FRBO1357', 0),
(0, 'Tavernes', 'France', 'Europe', 'FRPA0632', 0),
(0, 'Taverny', 'France', 'Europe', 'FRXX1693', 0),
(0, 'Tavers', 'France', 'Europe', 'FRXX5009', 0),
(0, 'Tavey', 'France', 'Europe', 'FRFC1275', 0),
(0, 'Taxat-Senat', 'France', 'Europe', 'FRAU0845', 0),
(0, 'Taxenne', 'France', 'Europe', 'FRFC1276', 0),
(0, 'Tayac', 'France', 'Europe', 'FRAQ1664', 0),
(0, 'Taybosc', 'France', 'Europe', 'FRMP2303', 0),
(0, 'Tayrac', 'France', 'Europe', 'FRAQ1665', 0),
(0, 'Tayrac', 'France', 'Europe', 'FRMP2304', 0),
(0, 'Tazilly', 'France', 'Europe', 'FRBO1358', 0),
(0, 'Teahupoo', 'France', 'Europe', 'FRXX7869', 0),
(0, 'Teche', 'France', 'Europe', 'FRRA1962', 0),
(0, 'Tecou', 'France', 'Europe', 'FRMP2305', 0),
(0, 'Teigny', 'France', 'Europe', 'FRBO1359', 0),
(0, 'Teilhede', 'France', 'Europe', 'FRXX1955', 0),
(0, 'Teilhet', 'France', 'Europe', 'FRAU0846', 0),
(0, 'Teilhet', 'France', 'Europe', 'FRMP2306', 0),
(0, 'Teillay', 'France', 'Europe', 'FRXX5127', 0),
(0, 'Teillay-le-Gaudin', 'France', 'Europe', 'FRCE1200', 0),
(0, 'Teille', 'France', 'Europe', 'FRPL0988', 0),
(0, 'Teille', 'France', 'Europe', 'FRPL0989', 0),
(0, 'Teillet', 'France', 'Europe', 'FRMP2307', 0),
(0, 'Teillet-Argenty', 'France', 'Europe', 'FRXX3880', 0),
(0, 'Teillots', 'France', 'Europe', 'FRAQ1666', 0),
(0, 'Teissieres-de-Cornet', 'France', 'Europe', 'FRAU0847', 0),
(0, 'Teissieres-les-Boulies', 'France', 'Europe', 'FRAU0848', 0),
(0, 'Telgruc-sur-Mer', 'France', 'Europe', 'FRXX3945', 0),
(0, 'Tellancourt', 'France', 'Europe', 'FRLO1576', 0),
(0, 'Tellecey', 'France', 'Europe', 'FRBO1360', 0),
(0, 'Tellieres-le-Plessis', 'France', 'Europe', 'FRBN1392', 0),
(0, 'Teloche', 'France', 'Europe', 'FRPL0990', 0),
(0, 'Temple-Laguyon', 'France', 'Europe', 'FRAQ1667', 0),
(0, 'Templemars', 'France', 'Europe', 'FRXX6671', 0),
(0, 'Templeuve', 'France', 'Europe', 'FRXX4107', 0),
(0, 'Templeux-la-Fosse', 'France', 'Europe', 'FRPI1595', 0),
(0, 'Templeux-le-Guerard', 'France', 'Europe', 'FRXX3692', 0),
(0, 'Tenarunga', 'France', 'Europe', 'FRXX7930', 0),
(0, 'Tenay', 'France', 'Europe', 'FRXX5215', 0),
(0, 'Tence', 'France', 'Europe', 'FRAU0849', 0),
(0, 'Tencin', 'France', 'Europe', 'FRRA1963', 0),
(0, 'Tende', 'France', 'Europe', 'FRXX3898', 0),
(0, 'Tendon', 'France', 'Europe', 'FRLO1577', 0),
(0, 'Tendron', 'France', 'Europe', 'FRCE1201', 0),
(0, 'Tendu', 'France', 'Europe', 'FRCE1202', 0),
(0, 'Teneur', 'France', 'Europe', 'FRNC0899', 0),
(0, 'Tennie', 'France', 'Europe', 'FRPL0991', 0),
(0, 'Tenteling', 'France', 'Europe', 'FRXX1488', 0),
(0, 'Terce', 'France', 'Europe', 'FRPC1080', 0),
(0, 'Tercillat', 'France', 'Europe', 'FRLI0535', 0),
(0, 'Tercis-les-Bains', 'France', 'Europe', 'FRXX3374', 0),
(0, 'Terdeghem', 'France', 'Europe', 'FRNC0900', 0),
(0, 'Tergnier', 'France', 'Europe', 'FRPI1596', 0),
(0, 'Terjat', 'France', 'Europe', 'FRAU0850', 0),
(0, 'Termes', 'France', 'Europe', 'FRCA1424', 0),
(0, 'Vallerange', 'France', 'Europe', 'FRLO1654', 0),
(0, 'Vallerargues', 'France', 'Europe', 'FRPA0670', 0),
(0, 'Valleraugue', 'France', 'Europe', 'FRLR0928', 0),
(0, 'Valleres', 'France', 'Europe', 'FRCE1258', 0),
(0, 'Valleret', 'France', 'Europe', 'FRCA1493', 0),
(0, 'Vallereuil', 'France', 'Europe', 'FRAQ1710', 0),
(0, 'Vallerois-le-Bois', 'France', 'Europe', 'FRFC1323', 0),
(0, 'Vallerois-Lorioz', 'France', 'Europe', 'FRFC1322', 0),
(0, 'Valleroy', 'France', 'Europe', 'FRCA1494', 0),
(0, 'Valleroy', 'France', 'Europe', 'FRFC1324', 0),
(0, 'Valleroy', 'France', 'Europe', 'FRXX1396', 0),
(0, 'Valleroy-aux-Saules', 'France', 'Europe', 'FRLO1655', 0),
(0, 'Valleroy-le-Sec', 'France', 'Europe', 'FRLO1656', 0),
(0, 'Vallery', 'France', 'Europe', 'FRBO1427', 0),
(0, 'Vallerysthal', 'France', 'Europe', 'FRLO1657', 0),
(0, 'Vallesvilles', 'France', 'Europe', 'FRMP2398', 0),
(0, 'Vallet', 'France', 'Europe', 'FRPC1117', 0),
(0, 'Vallet', 'France', 'Europe', 'FRXX4986', 0),
(0, 'Valletot', 'France', 'Europe', 'FRHN0968', 0),
(0, 'Vallica', 'France', 'Europe', 'FRCO0223', 0),
(0, 'Valliere', 'France', 'Europe', 'FRXX3359', 0),
(0, 'Vallieres', 'France', 'Europe', 'FRCA1495', 0),
(0, 'Vallieres', 'France', 'Europe', 'FRLI0548', 0),
(0, 'Vallieres', 'France', 'Europe', 'FRRA2037', 0),
(0, 'Vallieres-les-Grandes', 'France', 'Europe', 'FRCE1259', 0),
(0, 'Valliguieres', 'France', 'Europe', 'FRPA0671', 0),
(0, 'Valliquerville', 'France', 'Europe', 'FRHN0969', 0),
(0, 'Valloire', 'France', 'Europe', 'FRXX0495', 0),
(0, 'Vallois', 'France', 'Europe', 'FRLO1658', 0),
(0, 'Vallon-en-Sully', 'France', 'Europe', 'FRXX1727', 0),
(0, 'Vallon-Pont-d`Arc', 'France', 'Europe', 'FRRA2038', 0),
(0, 'Vallon-sur-Gee', 'France', 'Europe', 'FRXX3417', 0),
(0, 'Vallorcine', 'France', 'Europe', 'FRXX3548', 0),
(0, 'Vallouise', 'France', 'Europe', 'FRXX1720', 0),
(0, 'Valmanya', 'France', 'Europe', 'FRLR0929', 0),
(0, 'Valmascle', 'France', 'Europe', 'FRLR0930', 0),
(0, 'Valmeinier', 'France', 'Europe', 'FRXX0496', 0),
(0, 'Valmestroff', 'France', 'Europe', 'FRLO1659', 0),
(0, 'Valmigere', 'France', 'Europe', 'FRLR0931', 0),
(0, 'Valmondois', 'France', 'Europe', 'FRXX5989', 0),
(0, 'Valmont', 'France', 'Europe', 'FRHN0970', 0),
(0, 'Valmont', 'France', 'Europe', 'FRXX3619', 0),
(0, 'Valmorel la Belle', 'France', 'Europe', 'FRXX0537', 0),
(0, 'Valmunster', 'France', 'Europe', 'FRLO1660', 0),
(0, 'Valmy', 'France', 'Europe', 'FRCA1496', 0),
(0, 'Valognes', 'France', 'Europe', 'FRXX0103', 0),
(0, 'Valojoulx', 'France', 'Europe', 'FRAQ1711', 0),
(0, 'Valonne', 'France', 'Europe', 'FRFC1325', 0),
(0, 'Valoreille', 'France', 'Europe', 'FRFC1326', 0),
(0, 'Valouse', 'France', 'Europe', 'FRRA2039', 0),
(0, 'Valprionde', 'France', 'Europe', 'FRMP2399', 0),
(0, 'Valprivas', 'France', 'Europe', 'FRAU0888', 0),
(0, 'Valpuiseaux', 'France', 'Europe', 'FRIF0613', 0),
(0, 'Valras-Plage', 'France', 'Europe', 'FRXX4291', 0),
(0, 'Valreas', 'France', 'Europe', 'FRPA0672', 0),
(0, 'Valros', 'France', 'Europe', 'FRLR0932', 0),
(0, 'Valroufie', 'France', 'Europe', 'FRMP2400', 0),
(0, 'Vals', 'France', 'Europe', 'FRMP2401', 0),
(0, 'Vals-le-Chastel', 'France', 'Europe', 'FRAU0889', 0),
(0, 'Vals-les-Bains', 'France', 'Europe', 'FRXX5514', 0),
(0, 'Vals-pres-le-Puy', 'France', 'Europe', 'FRXX5007', 0),
(0, 'Valseme', 'France', 'Europe', 'FRBN1442', 0),
(0, 'Valserres', 'France', 'Europe', 'FRPA0673', 0),
(0, 'Valsonne', 'France', 'Europe', 'FRRA2040', 0),
(0, 'Valuejols', 'France', 'Europe', 'FRAU0890', 0),
(0, 'Valvigneres', 'France', 'Europe', 'FRRA2041', 0),
(0, 'Valz-sous-Chateauneuf', 'France', 'Europe', 'FRAU0891', 0),
(0, 'Valzergues', 'France', 'Europe', 'FRMP2402', 0),
(0, 'Vanault-le-Chatel', 'France', 'Europe', 'FRCA1497', 0),
(0, 'Vanault-les-Dames', 'France', 'Europe', 'FRCA1498', 0),
(0, 'Vancais', 'France', 'Europe', 'FRPC1118', 0),
(0, 'Vance', 'France', 'Europe', 'FRPL1028', 0),
(0, 'Vanclans', 'France', 'Europe', 'FRFC1327', 0),
(0, 'Vancroit', 'France', 'Europe', 'FRXX0266', 0),
(0, 'Vandeins', 'France', 'Europe', 'FRRA2042', 0),
(0, 'Vandelans', 'France', 'Europe', 'FRFC1328', 0),
(0, 'Vandeleville', 'France', 'Europe', 'FRLO1661', 0),
(0, 'Vandelicourt', 'France', 'Europe', 'FRPI1655', 0),
(0, 'Vandenesse', 'France', 'Europe', 'FRBO1428', 0),
(0, 'Vandenesse-en-Auxois', 'France', 'Europe', 'FRBO1429', 0),
(0, 'Wintzenheim-Kochersberg', 'France', 'Europe', 'FRXX5113', 0),
(0, 'Wintzfelden', 'France', 'Europe', 'FRAL0654', 0),
(0, 'Wirwignes', 'France', 'Europe', 'FRNC1009', 0),
(0, 'Wiry-au-Mont', 'France', 'Europe', 'FRPI1784', 0),
(0, 'Wisches', 'France', 'Europe', 'FRAL0655', 0),
(0, 'Wisembach', 'France', 'Europe', 'FRLO1818', 0),
(0, 'Wiseppe', 'France', 'Europe', 'FRLO1819', 0),
(0, 'Wismes', 'France', 'Europe', 'FRNC1010', 0),
(0, 'Wisques', 'France', 'Europe', 'FRNC1011', 0),
(0, 'Wissant', 'France', 'Europe', 'FRXX2700', 0),
(0, 'Wissembourg', 'France', 'Europe', 'FRXX6504', 0),
(0, 'Wissignicourt', 'France', 'Europe', 'FRPI1785', 0),
(0, 'Wissous', 'France', 'Europe', 'FRXX6773', 0),
(0, 'Witry-les-Reims', 'France', 'Europe', 'FRXX2325', 0),
(0, 'Wittelsheim', 'France', 'Europe', 'FRXX2179', 0),
(0, 'Wittenheim', 'France', 'Europe', 'FRXX6526', 0),
(0, 'Witternesse', 'France', 'Europe', 'FRNC1012', 0),
(0, 'Witternheim', 'France', 'Europe', 'FRAL0656', 0),
(0, 'Wittersdorf', 'France', 'Europe', 'FRAL0657', 0),
(0, 'Wittersheim', 'France', 'Europe', 'FRAL0658', 0),
(0, 'Wittes', 'France', 'Europe', 'FRNC1013', 0),
(0, 'Wittisheim', 'France', 'Europe', 'FRXX4371', 0),
(0, 'Wittring', 'France', 'Europe', 'FRXX5204', 0),
(0, 'Wiwersheim', 'France', 'Europe', 'FRAL0659', 0),
(0, 'Wizernes', 'France', 'Europe', 'FRNC1014', 0),
(0, 'Woel', 'France', 'Europe', 'FRLO1820', 0),
(0, 'Woelfling-les-Sarreguemines', 'France', 'Europe', 'FRLO1821', 0),
(0, 'Woellenheim', 'France', 'Europe', 'FRAL0660', 0),
(0, 'Woerth', 'France', 'Europe', 'FRAL0661', 0),
(0, 'Woignarue', 'France', 'Europe', 'FRXX1506', 0),
(0, 'Woimbey', 'France', 'Europe', 'FRLO1822', 0),
(0, 'Woincourt', 'France', 'Europe', 'FRXX5203', 0),
(0, 'Woinville', 'France', 'Europe', 'FRLO1823', 0),
(0, 'Woippy', 'France', 'Europe', 'FRLO1824', 0),
(0, 'Woirel', 'France', 'Europe', 'FRPI1786', 0),
(0, 'Wolfersdorf', 'France', 'Europe', 'FRAL0662', 0),
(0, 'Wolfgantzen', 'France', 'Europe', 'FRAL0663', 0),
(0, 'Wolfisheim', 'France', 'Europe', 'FRXX2867', 0),
(0, 'Wolfskirchen', 'France', 'Europe', 'FRAL0664', 0),
(0, 'Wolschheim', 'France', 'Europe', 'FRAL0665', 0),
(0, 'Wolschwiller', 'France', 'Europe', 'FRAL0666', 0),
(0, 'Wolxheim', 'France', 'Europe', 'FRAL0667', 0),
(0, 'Wormhout', 'France', 'Europe', 'FRXX5787', 0),
(0, 'Woustviller', 'France', 'Europe', 'FRXX6535', 0),
(0, 'Wuenheim', 'France', 'Europe', 'FRAL0668', 0),
(0, 'Wuisse', 'France', 'Europe', 'FRLO1825', 0),
(0, 'Wulverdinghe', 'France', 'Europe', 'FRNC1015', 0),
(0, 'Wy-dit-Joli-Village', 'France', 'Europe', 'FRIF0670', 0),
(0, 'Wylder', 'France', 'Europe', 'FRNC1016', 0),
(0, 'Allan', 'France', 'Europe', 'FRRA0024', 0),
(0, 'Allarmont', 'France', 'Europe', 'FRLO0015', 0),
(0, 'Allassac', 'France', 'Europe', 'FRLI0007', 0),
(0, 'Allauch', 'France', 'Europe', 'FRPA0007', 0),
(0, 'Allegre', 'France', 'Europe', 'FRAU0004', 0),
(0, 'Allegre-les-Fumades', 'France', 'Europe', 'FRLR0015', 0),
(0, 'Alleins', 'France', 'Europe', 'FRXX1123', 0),
(0, 'Allemant', 'France', 'Europe', 'FRCA0010', 0),
(0, 'Allemant', 'France', 'Europe', 'FRPI0020', 0),
(0, 'Allenay', 'France', 'Europe', 'FRPI0021', 0),
(0, 'Allenc', 'France', 'Europe', 'FRLR0016', 0),
(0, 'Allenjoie', 'France', 'Europe', 'FRFC0021', 0),
(0, 'Allennes-les-Marais', 'France', 'Europe', 'FRXX5858', 0),
(0, 'Allerey', 'France', 'Europe', 'FRBO0008', 0),
(0, 'Allerey-sur-Saone', 'France', 'Europe', 'FRBO0009', 0),
(0, 'Alleriot', 'France', 'Europe', 'FRBO0010', 0),
(0, 'Allery', 'France', 'Europe', 'FRPI0022', 0),
(0, 'Allevard', 'France', 'Europe', 'FRRA0025', 0),
(0, 'Alleves', 'France', 'Europe', 'FRRA0026', 0),
(0, 'Allex', 'France', 'Europe', 'FRRA0027', 0),
(0, 'Alleyrat', 'France', 'Europe', 'FRLI0008', 0),
(0, 'Alleyrat', 'France', 'Europe', 'FRLI0009', 0),
(0, 'Alliancelles', 'France', 'Europe', 'FRCA0011', 0),
(0, 'Alliat', 'France', 'Europe', 'FRMP0021', 0),
(0, 'Allibaudieres', 'France', 'Europe', 'FRCA0012', 0),
(0, 'Allichamps', 'France', 'Europe', 'FRCA0013', 0),
(0, 'Allier', 'France', 'Europe', 'FRMP0022', 0),
(0, 'Allinges', 'France', 'Europe', 'FRRA0028', 0),
(0, 'Allogny', 'France', 'Europe', 'FRCE0005', 0),
(0, 'Allondans', 'France', 'Europe', 'FRFC0022', 0),
(0, 'Allondaz', 'France', 'Europe', 'FRRA0029', 0),
(0, 'Allonne', 'France', 'Europe', 'FRPC0012', 0),
(0, 'Allonne', 'France', 'Europe', 'FRPI0023', 0),
(0, 'Allonnes', 'France', 'Europe', 'FRCE0006', 0),
(0, 'Allonnes', 'France', 'Europe', 'FRXX4206', 0),
(0, 'Allons', 'France', 'Europe', 'FRPA0008', 0),
(0, 'Allonville', 'France', 'Europe', 'FRPI0024', 0),
(0, 'Allonzier-la-Caille', 'France', 'Europe', 'FRRA0030', 0),
(0, 'Allos', 'France', 'Europe', 'FRXX1013', 0),
(0, 'Allouagne', 'France', 'Europe', 'FRXX4417', 0),
(0, 'Alloue', 'France', 'Europe', 'FRPC0013', 0),
(0, 'Alluy', 'France', 'Europe', 'FRBO0011', 0),
(0, 'Ally', 'France', 'Europe', 'FRAU0005', 0),
(0, 'Almayrac', 'France', 'Europe', 'FRMP0023', 0),
(0, 'Almeneches', 'France', 'Europe', 'FRBN0009', 0),
(0, 'Alo', 'France', 'Europe', 'FRXX7845', 0),
(0, 'Alos', 'France', 'Europe', 'FRMP0024', 0),
(0, 'Alpuech', 'France', 'Europe', 'FRMP0025', 0),
(0, 'Alquines', 'France', 'Europe', 'FRNC0016', 0),
(0, 'Alrance', 'France', 'Europe', 'FRMP0026', 0),
(0, 'Alsting', 'France', 'Europe', 'FRXX2655', 0),
(0, 'Altagene', 'France', 'Europe', 'FRCO0004', 0),
(0, 'Altenach', 'France', 'Europe', 'FRAL0001', 0),
(0, 'Altenbach', 'France', 'Europe', 'FRAL0002', 0),
(0, 'Altenstadt', 'France', 'Europe', 'FRAL0003', 0),
(0, 'Altier', 'France', 'Europe', 'FRLR0017', 0),
(0, 'Altillac', 'France', 'Europe', 'FRLI0010', 0),
(0, 'Altrippe', 'France', 'Europe', 'FRLO0016', 0),
(0, 'Alzen', 'France', 'Europe', 'FRMP0027', 0),
(0, 'Alzi', 'France', 'Europe', 'FRCO0005', 0),
(0, 'Alzing', 'France', 'Europe', 'FRLO0017', 0),
(0, 'Alzon', 'France', 'Europe', 'FRLR0018', 0),
(0, 'Alzonne', 'France', 'Europe', 'FRLR0019', 0),
(0, 'Amage', 'France', 'Europe', 'FRFC0023', 0),
(0, 'Amagney', 'France', 'Europe', 'FRFC0024', 0),
(0, 'Amailloux', 'France', 'Europe', 'FRPC0014', 0),
(0, 'Amance', 'France', 'Europe', 'FRCA0014', 0),
(0, 'Amance', 'France', 'Europe', 'FRFC0025', 0),
(0, 'Amance', 'France', 'Europe', 'FRLO0018', 0),
(0, 'Amancey', 'France', 'Europe', 'FRFC0026', 0),
(0, 'Amancy', 'France', 'Europe', 'FRRA0031', 0),
(0, 'Amange', 'France', 'Europe', 'FRFC0027', 0),
(0, 'Amanty', 'France', 'Europe', 'FRLO0019', 0),
(0, 'Amanvillers', 'France', 'Europe', 'FRXX2896', 0),
(0, 'Amareins', 'France', 'Europe', 'FRRA0032', 0),
(0, 'Amarens', 'France', 'Europe', 'FRMP0028', 0),
(0, 'Amazy', 'France', 'Europe', 'FRBO0012', 0),
(0, 'Ambacourt', 'France', 'Europe', 'FRLO0020', 0),
(0, 'Ambax', 'France', 'Europe', 'FRMP0029', 0),
(0, 'Ambazac', 'France', 'Europe', 'FRLI0011', 0),
(0, 'Barry', 'France', 'Europe', 'FRMP0183', 0),
(0, 'Bars', 'France', 'Europe', 'FRAQ0108', 0),
(0, 'Bars', 'France', 'Europe', 'FRMP0184', 0),
(0, 'Barsac', 'France', 'Europe', 'FRAQ0109', 0),
(0, 'Barsac', 'France', 'Europe', 'FRRA0125', 0),
(0, 'Bart', 'France', 'Europe', 'FRFC0096', 0),
(0, 'Barthe', 'France', 'Europe', 'FRMP0185', 0),
(0, 'Bartherans', 'France', 'Europe', 'FRFC0097', 0),
(0, 'Bartres', 'France', 'Europe', 'FRMP0186', 0),
(0, 'Barville', 'France', 'Europe', 'FRBN0053', 0),
(0, 'Barville', 'France', 'Europe', 'FRHN0031', 0),
(0, 'Barville', 'France', 'Europe', 'FRLO0094', 0),
(0, 'Barzan', 'France', 'Europe', 'FRPC0070', 0),
(0, 'Barzun', 'France', 'Europe', 'FRAQ0110', 0),
(0, 'Bas de Bonce', 'France', 'Europe', 'FRRA0126', 0),
(0, 'Bas-Lieu', 'France', 'Europe', 'FRNC0077', 0),
(0, 'Bas-Mauco', 'France', 'Europe', 'FRAQ0111', 0),
(0, 'Bascons', 'France', 'Europe', 'FRAQ0112', 0),
(0, 'Bascous', 'France', 'Europe', 'FRMP0187', 0),
(0, 'Baslieux', 'France', 'Europe', 'FRLO0095', 0),
(0, 'Basly', 'France', 'Europe', 'FRBN0054', 0),
(0, 'Bassac', 'France', 'Europe', 'FRPC0071', 0),
(0, 'Bassanne', 'France', 'Europe', 'FRAQ0113', 0),
(0, 'Basse-Ham', 'France', 'Europe', 'FRLO0096', 0),
(0, 'Basse-Pointe', 'France', 'Europe', 'FRXX7748', 0),
(0, 'Basse-sur-le-Rupt', 'France', 'Europe', 'FRLO0097', 0),
(0, 'Basse-Terre', 'France', 'Europe', 'FRXX7705', 0),
(0, 'Bassemberg', 'France', 'Europe', 'FRAL0016', 0),
(0, 'Basseneville', 'France', 'Europe', 'FRBN0055', 0),
(0, 'Bassens', 'France', 'Europe', 'FRRA0127', 0),
(0, 'Bassens', 'France', 'Europe', 'FRXX2941', 0),
(0, 'Bassercles', 'France', 'Europe', 'FRAQ0114', 0),
(0, 'Basses', 'France', 'Europe', 'FRPC0072', 0),
(0, 'Basseux', 'France', 'Europe', 'FRNC0078', 0),
(0, 'Bassevelle', 'France', 'Europe', 'FRIF0041', 0),
(0, 'Bassignac', 'France', 'Europe', 'FRAU0042', 0),
(0, 'Bassigney', 'France', 'Europe', 'FRFC0098', 0),
(0, 'Bassing', 'France', 'Europe', 'FRLO0098', 0),
(0, 'Bassoles-Aulers', 'France', 'Europe', 'FRPI0103', 0),
(0, 'Bassoncourt', 'France', 'Europe', 'FRCA0086', 0),
(0, 'Bassou', 'France', 'Europe', 'FRBO0061', 0),
(0, 'Bassu', 'France', 'Europe', 'FRCA0087', 0),
(0, 'Bassuet', 'France', 'Europe', 'FRCA0088', 0),
(0, 'Bassurels', 'France', 'Europe', 'FRLR0065', 0),
(0, 'Bassy', 'France', 'Europe', 'FRRA0128', 0),
(0, 'Bastanes', 'France', 'Europe', 'FRAQ0115', 0),
(0, 'Bastelica', 'France', 'Europe', 'FRXX5474', 0),
(0, 'Bastelicaccia', 'France', 'Europe', 'FRXX3240', 0),
(0, 'Bastennes', 'France', 'Europe', 'FRAQ0116', 0),
(0, 'Bastia', 'France', 'Europe', 'FRXX0130', 0),
(0, 'Basville', 'France', 'Europe', 'FRLI0028', 0),
(0, 'Bathernay', 'France', 'Europe', 'FRRA0129', 0),
(0, 'Batilly', 'France', 'Europe', 'FRBN0056', 0),
(0, 'Batilly', 'France', 'Europe', 'FRXX5104', 0),
(0, 'Batilly-en-Gatinais', 'France', 'Europe', 'FRCE0042', 0),
(0, 'Bats', 'France', 'Europe', 'FRAQ0117', 0),
(0, 'Batsere', 'France', 'Europe', 'FRMP0188', 0),
(0, 'Battenans-Varin', 'France', 'Europe', 'FRFC0099', 0),
(0, 'Battenheim', 'France', 'Europe', 'FRAL0017', 0),
(0, 'Battexey', 'France', 'Europe', 'FRLO0099', 0),
(0, 'Battigny', 'France', 'Europe', 'FRLO0100', 0),
(0, 'Battrans', 'France', 'Europe', 'FRFC0100', 0),
(0, 'Batz-sur-Mer', 'France', 'Europe', 'FRXX6485', 0),
(0, 'Baubigny', 'France', 'Europe', 'FRBO0062', 0),
(0, 'Baudement', 'France', 'Europe', 'FRCA0089', 0),
(0, 'Baudignan', 'France', 'Europe', 'FRAQ0118', 0),
(0, 'Baudignecourt', 'France', 'Europe', 'FRLO0101', 0),
(0, 'Baudoncourt', 'France', 'Europe', 'FRFC0101', 0),
(0, 'Baudonvilliers', 'France', 'Europe', 'FRLO0102', 0),
(0, 'Baudre', 'France', 'Europe', 'FRBN0057', 0),
(0, 'Baudrecourt', 'France', 'Europe', 'FRCA0090', 0),
(0, 'Baudrecourt', 'France', 'Europe', 'FRLO0103', 0),
(0, 'Baudremont', 'France', 'Europe', 'FRLO0104', 0),
(0, 'Baudres', 'France', 'Europe', 'FRCE0043', 0),
(0, 'Baudreville', 'France', 'Europe', 'FRBN0058', 0),
(0, 'Baudreville', 'France', 'Europe', 'FRCE0044', 0),
(0, 'Baudricourt', 'France', 'Europe', 'FRLO0105', 0),
(0, 'Baudrieres', 'France', 'Europe', 'FRBO0063', 0),
(0, 'Bauduen', 'France', 'Europe', 'FRPA0043', 0),
(0, 'Bauge', 'France', 'Europe', 'FRPL0039', 0),
(0, 'Caramany', 'France', 'Europe', 'FRLR0128', 0),
(0, 'Carantec', 'France', 'Europe', 'FRXX3946', 0),
(0, 'Carantilly', 'France', 'Europe', 'FRBN0175', 0),
(0, 'Carayac', 'France', 'Europe', 'FRMP0426', 0),
(0, 'Carbay', 'France', 'Europe', 'FRPL0093', 0),
(0, 'Carbes', 'France', 'Europe', 'FRMP0427', 0),
(0, 'Carbini', 'France', 'Europe', 'FRCO0035', 0),
(0, 'Carbon-Blanc', 'France', 'Europe', 'FRXX0024', 0),
(0, 'Carbonne', 'France', 'Europe', 'FRMP0428', 0),
(0, 'Carbuccia', 'France', 'Europe', 'FRCO0036', 0),
(0, 'Carcagny', 'France', 'Europe', 'FRBN0176', 0),
(0, 'Carcanieres', 'France', 'Europe', 'FRMP0429', 0),
(0, 'Carcans', 'France', 'Europe', 'FRXX5078', 0),
(0, 'Carcassonne', 'France', 'Europe', 'FRXX0025', 0),
(0, 'Carces', 'France', 'Europe', 'FRPA0091', 0),
(0, 'Carcheto-Brustico', 'France', 'Europe', 'FRCO0037', 0),
(0, 'Cardan', 'France', 'Europe', 'FRAQ0263', 0),
(0, 'Cardeilhac', 'France', 'Europe', 'FRMP0430', 0),
(0, 'Cardesse', 'France', 'Europe', 'FRAQ0264', 0),
(0, 'Cardet', 'France', 'Europe', 'FRLR0129', 0),
(0, 'Cardo', 'France', 'Europe', 'FRCO0038', 0),
(0, 'Cardonnette', 'France', 'Europe', 'FRPI0284', 0),
(0, 'Cardonville', 'France', 'Europe', 'FRBN0177', 0),
(0, 'Carelles', 'France', 'Europe', 'FRPL0094', 0),
(0, 'Carency', 'France', 'Europe', 'FRNC0202', 0),
(0, 'Carennac', 'France', 'Europe', 'FRMP0431', 0),
(0, 'Cargese', 'France', 'Europe', 'FRXX5476', 0),
(0, 'Cargiaca', 'France', 'Europe', 'FRXX4008', 0),
(0, 'Carignan-de-Bordeaux', 'France', 'Europe', 'FRAQ0265', 0),
(0, 'Carisey', 'France', 'Europe', 'FRBO0161', 0),
(0, 'Carla-Bayle', 'France', 'Europe', 'FRMP0432', 0),
(0, 'Carlat', 'France', 'Europe', 'FRAU0089', 0),
(0, 'Carlepont', 'France', 'Europe', 'FRPI0285', 0),
(0, 'Carling', 'France', 'Europe', 'FRLO0240', 0),
(0, 'Carlipa', 'France', 'Europe', 'FRLR0130', 0),
(0, 'Carlucet', 'France', 'Europe', 'FRMP0433', 0),
(0, 'Carlus', 'France', 'Europe', 'FRMP0434', 0),
(0, 'Carly', 'France', 'Europe', 'FRNC0203', 0),
(0, 'Carnas', 'France', 'Europe', 'FRLR0131', 0),
(0, 'Carnetin', 'France', 'Europe', 'FRIF0091', 0),
(0, 'Carneville', 'France', 'Europe', 'FRBN0178', 0),
(0, 'Carnieres', 'France', 'Europe', 'FRXX4852', 0),
(0, 'Carnin', 'France', 'Europe', 'FRNC0204', 0),
(0, 'Carniol', 'France', 'Europe', 'FRPA0092', 0),
(0, 'Carnoules', 'France', 'Europe', 'FRXX2740', 0),
(0, 'Carnoux-en-Provence', 'France', 'Europe', 'FRXX5480', 0),
(0, 'Carnoy', 'France', 'Europe', 'FRPI0286', 0),
(0, 'Carolles', 'France', 'Europe', 'FRBN0179', 0),
(0, 'Caromb', 'France', 'Europe', 'FRPA0093', 0),
(0, 'Caroual', 'France', 'Europe', 'FRXX1113', 0),
(0, 'Carpentras', 'France', 'Europe', 'FRXX0146', 0),
(0, 'Carpineto', 'France', 'Europe', 'FRCO0039', 0),
(0, 'Carpiquet', 'France', 'Europe', 'FRXX3999', 0),
(0, 'Carquebut', 'France', 'Europe', 'FRBN0180', 0),
(0, 'Carquefou', 'France', 'Europe', 'FRXX0026', 0),
(0, 'Carqueiranne', 'France', 'Europe', 'FRXX5755', 0),
(0, 'Carrepuis', 'France', 'Europe', 'FRPI0287', 0),
(0, 'Carrere', 'France', 'Europe', 'FRAQ0266', 0),
(0, 'Carrieres-sur-Seine', 'France', 'Europe', 'FRXX5801', 0),
(0, 'Carro', 'France', 'Europe', 'FRPA0094', 0),
(0, 'Carros', 'France', 'Europe', 'FRPA0095', 0),
(0, 'Carrouges', 'France', 'Europe', 'FRBN0181', 0),
(0, 'Cars', 'France', 'Europe', 'FRAQ0267', 0),
(0, 'Carsan', 'France', 'Europe', 'FRPA0096', 0),
(0, 'Carsix', 'France', 'Europe', 'FRHN0121', 0),
(0, 'Carspach', 'France', 'Europe', 'FRAL0068', 0),
(0, 'Cartelegue', 'France', 'Europe', 'FRAQ0268', 0),
(0, 'Carticasi', 'France', 'Europe', 'FRCO0040', 0),
(0, 'Cartignies', 'France', 'Europe', 'FRNC0205', 0),
(0, 'Cartigny', 'France', 'Europe', 'FRPI0288', 0),
(0, 'Carves', 'France', 'Europe', 'FRAQ0269', 0),
(0, 'Carville', 'France', 'Europe', 'FRBN0182', 0),
(0, 'Carvin', 'France', 'Europe', 'FRXX4970', 0),
(0, 'Casabianca', 'France', 'Europe', 'FRCO0041', 0),
(0, 'Casaglione', 'France', 'Europe', 'FRCO0042', 0),
(0, 'Casalabriva', 'France', 'Europe', 'FRCO0043', 0),
(0, 'Casalta', 'France', 'Europe', 'FRCO0044', 0),
(0, 'Casanova', 'France', 'Europe', 'FRCO0045', 0),
(0, 'Caseneuve', 'France', 'Europe', 'FRPA0097', 0),
(0, 'Cassaber', 'France', 'Europe', 'FRAQ0270', 0),
(0, 'Dijon', 'France', 'Europe', 'FRXX0036', 0),
(0, 'Dimancheville', 'France', 'Europe', 'FRCE0273', 0),
(0, 'Dimbsthal', 'France', 'Europe', 'FRAL0088', 0),
(0, 'Dimechaux', 'France', 'Europe', 'FRNC0268', 0),
(0, 'Dimont', 'France', 'Europe', 'FRNC0269', 0),
(0, 'Dinoze', 'France', 'Europe', 'FRLO0373', 0),
(0, 'Dinsac', 'France', 'Europe', 'FRLI0112', 0),
(0, 'Dinsheim-sur-Bruche', 'France', 'Europe', 'FRAL0089', 0),
(0, 'Dinteville', 'France', 'Europe', 'FRCA0365', 0),
(0, 'Dionay', 'France', 'Europe', 'FRRA0482', 0),
(0, 'Dions', 'France', 'Europe', 'FRPA0153', 0),
(0, 'Diors', 'France', 'Europe', 'FRCE0274', 0),
(0, 'Diou', 'France', 'Europe', 'FRAU0206', 0),
(0, 'Diou', 'France', 'Europe', 'FRCE0275', 0),
(0, 'Dirac', 'France', 'Europe', 'FRPC0291', 0),
(0, 'Dirol', 'France', 'Europe', 'FRBO0359', 0),
(0, 'Dissais', 'France', 'Europe', 'FRPL0195', 0),
(0, 'Dissangis', 'France', 'Europe', 'FRBO0360', 0),
(0, 'Distre', 'France', 'Europe', 'FRPL0196', 0),
(0, 'Distroff', 'France', 'Europe', 'FRXX5192', 0),
(0, 'Diusse', 'France', 'Europe', 'FRAQ0378', 0),
(0, 'Divajeu', 'France', 'Europe', 'FRRA0483', 0),
(0, 'Dival', 'France', 'Europe', 'FRCA0366', 0),
(0, 'Dives', 'France', 'Europe', 'FRPI0451', 0),
(0, 'Dixmont', 'France', 'Europe', 'FRBO0361', 0),
(0, 'Dizimieu', 'France', 'Europe', 'FRRA0484', 0),
(0, 'Dizy', 'France', 'Europe', 'FRCA0367', 0),
(0, 'Doazit', 'France', 'Europe', 'FRAQ0379', 0),
(0, 'Doazon', 'France', 'Europe', 'FRAQ0380', 0),
(0, 'Docelles', 'France', 'Europe', 'FRLO0374', 0),
(0, 'Dognen', 'France', 'Europe', 'FRAQ0381', 0),
(0, 'Dogneville', 'France', 'Europe', 'FRLO0375', 0),
(0, 'Dohem', 'France', 'Europe', 'FRNC0270', 0),
(0, 'Dohis', 'France', 'Europe', 'FRPI0452', 0),
(0, 'Doignies', 'France', 'Europe', 'FRNC0271', 0),
(0, 'Doingt', 'France', 'Europe', 'FRPI0453', 0),
(0, 'Doissat', 'France', 'Europe', 'FRAQ0382', 0),
(0, 'Doissin', 'France', 'Europe', 'FRRA0485', 0),
(0, 'Doix', 'France', 'Europe', 'FRPL0197', 0),
(0, 'Dolaincourt', 'France', 'Europe', 'FRLO0376', 0),
(0, 'Dolancourt', 'France', 'Europe', 'FRCA0368', 0),
(0, 'Dolcourt', 'France', 'Europe', 'FRLO0377', 0),
(0, 'Dole', 'France', 'Europe', 'FRXX0419', 0),
(0, 'Dolignon', 'France', 'Europe', 'FRPI0454', 0),
(0, 'Dolleren', 'France', 'Europe', 'FRAL0090', 0),
(0, 'Dollon', 'France', 'Europe', 'FRPL0198', 0),
(0, 'Dolmayrac', 'France', 'Europe', 'FRAQ0383', 0),
(0, 'Dolus-d`Oleron', 'France', 'Europe', 'FRXX4016', 0),
(0, 'Dolving', 'France', 'Europe', 'FRLO0378', 0),
(0, 'Domaize', 'France', 'Europe', 'FRAU0207', 0),
(0, 'Domancy', 'France', 'Europe', 'FRRA0486', 0),
(0, 'Domarin', 'France', 'Europe', 'FRRA0487', 0),
(0, 'Domazan', 'France', 'Europe', 'FRPA0154', 0),
(0, 'Domblain', 'France', 'Europe', 'FRCA0369', 0),
(0, 'Domblans', 'France', 'Europe', 'FRFC0401', 0),
(0, 'Dombras', 'France', 'Europe', 'FRLO0379', 0),
(0, 'Domecy-sur-le-Vault', 'France', 'Europe', 'FRBO0362', 0),
(0, 'Domeliers', 'France', 'Europe', 'FRPI0455', 0),
(0, 'Domene', 'France', 'Europe', 'FRXX7006', 0),
(0, 'Domerat', 'France', 'Europe', 'FRAU0208', 0),
(0, 'Domesmont', 'France', 'Europe', 'FRPI0456', 0),
(0, 'Domessargues', 'France', 'Europe', 'FRLR0213', 0),
(0, 'Domessin', 'France', 'Europe', 'FRRA0488', 0),
(0, 'Domeyrat', 'France', 'Europe', 'FRAU0209', 0),
(0, 'Domeyrot', 'France', 'Europe', 'FRLI0113', 0),
(0, 'Domfaing', 'France', 'Europe', 'FRLO0380', 0),
(0, 'Domfessel', 'France', 'Europe', 'FRAL0091', 0),
(0, 'Domfront', 'France', 'Europe', 'FRBN0307', 0),
(0, 'Domfront', 'France', 'Europe', 'FRPI0457', 0),
(0, 'Domgermain', 'France', 'Europe', 'FRXX3095', 0),
(0, 'Dominois', 'France', 'Europe', 'FRPI0458', 0),
(0, 'Domjean', 'France', 'Europe', 'FRBN0308', 0),
(0, 'Domjevin', 'France', 'Europe', 'FRLO0381', 0),
(0, 'Domjulien', 'France', 'Europe', 'FRLO0382', 0),
(0, 'Domleger-Longvillers', 'France', 'Europe', 'FRPI0459', 0),
(0, 'Domloup', 'France', 'Europe', 'FRBR0008', 0),
(0, 'Dommarie-Eulmont', 'France', 'Europe', 'FRLO0383', 0),
(0, 'Dommarien', 'France', 'Europe', 'FRCA0370', 0),
(0, 'Dommartin', 'France', 'Europe', 'FRBO0363', 0),
(0, 'Dommartin', 'France', 'Europe', 'FRFC0402', 0),
(0, 'Eparcy', 'France', 'Europe', 'FRPI0488', 0),
(0, 'Epargnes', 'France', 'Europe', 'FRPC0308', 0),
(0, 'Epaumesnil', 'France', 'Europe', 'FRPI0489', 0),
(0, 'Epaux-Bezu', 'France', 'Europe', 'FRPI0490', 0),
(0, 'Epeautrolles', 'France', 'Europe', 'FRCE0295', 0),
(0, 'Epecamps', 'France', 'Europe', 'FRPI0491', 0),
(0, 'Epegard', 'France', 'Europe', 'FRHN0204', 0),
(0, 'Epehy', 'France', 'Europe', 'FRPI0492', 0),
(0, 'Epenancourt', 'France', 'Europe', 'FRPI0493', 0),
(0, 'Epenede', 'France', 'Europe', 'FRPC0309', 0),
(0, 'Epenouse', 'France', 'Europe', 'FRFC0432', 0),
(0, 'Epenoy', 'France', 'Europe', 'FRFC0433', 0),
(0, 'Epense', 'France', 'Europe', 'FRCA0407', 0),
(0, 'Eperlecques', 'France', 'Europe', 'FRNC0300', 0),
(0, 'Epernon', 'France', 'Europe', 'FRXX2567', 0),
(0, 'Eperrais', 'France', 'Europe', 'FRBN0332', 0),
(0, 'Epersy', 'France', 'Europe', 'FRRA0525', 0),
(0, 'Epertully', 'France', 'Europe', 'FRBO0384', 0),
(0, 'Epervans', 'France', 'Europe', 'FRBO0385', 0),
(0, 'Epeugney', 'France', 'Europe', 'FRFC0434', 0),
(0, 'Epfig', 'France', 'Europe', 'FRAL0115', 0),
(0, 'Epiais', 'France', 'Europe', 'FRCE0296', 0),
(0, 'Epiais-Rhus', 'France', 'Europe', 'FRIF0179', 0),
(0, 'Epieds', 'France', 'Europe', 'FRHN0205', 0),
(0, 'Epieds', 'France', 'Europe', 'FRPI0494', 0),
(0, 'Epieds', 'France', 'Europe', 'FRPL0208', 0),
(0, 'Epierre', 'France', 'Europe', 'FRRA0526', 0),
(0, 'Epinal', 'France', 'Europe', 'FRXX0152', 0),
(0, 'Epinant', 'France', 'Europe', 'FRCA0408', 0),
(0, 'Epinay', 'France', 'Europe', 'FRHN0206', 0),
(0, 'Epinay-Champlatreux', 'France', 'Europe', 'FRIF0180', 0),
(0, 'Epinay-sous-Senart', 'France', 'Europe', 'FRXX3737', 0),
(0, 'Epinay-sur-Seine', 'France', 'Europe', 'FRXX3750', 0),
(0, 'Epineuil', 'France', 'Europe', 'FRBO0386', 0),
(0, 'Epineuse', 'France', 'Europe', 'FRPI0495', 0),
(0, 'Epinonville', 'France', 'Europe', 'FRLO0415', 0),
(0, 'Epinouze', 'France', 'Europe', 'FRRA0527', 0),
(0, 'Epinoy', 'France', 'Europe', 'FRNC0301', 0),
(0, 'Epire', 'France', 'Europe', 'FRPL0209', 0),
(0, 'Epiry', 'France', 'Europe', 'FRBO0387', 0),
(0, 'Episy', 'France', 'Europe', 'FRIF0181', 0),
(0, 'Epizon', 'France', 'Europe', 'FRCA0409', 0),
(0, 'Eplessier', 'France', 'Europe', 'FRPI0496', 0),
(0, 'Eply', 'France', 'Europe', 'FRLO0416', 0),
(0, 'Epoisses', 'France', 'Europe', 'FRBO0388', 0),
(0, 'Epone', 'France', 'Europe', 'FRXX2131', 0),
(0, 'Epothemont', 'France', 'Europe', 'FRCA0410', 0),
(0, 'Epouville', 'France', 'Europe', 'FRHN0207', 0),
(0, 'Epoye', 'France', 'Europe', 'FRCA0411', 0),
(0, 'Eppe-Sauvage', 'France', 'Europe', 'FRNC0302', 0),
(0, 'Eppes', 'France', 'Europe', 'FRPI0497', 0),
(0, 'Eppeville', 'France', 'Europe', 'FRPI0498', 0),
(0, 'Epretot', 'France', 'Europe', 'FRHN0208', 0),
(0, 'Epreville', 'France', 'Europe', 'FRHN0209', 0),
(0, 'Epron', 'France', 'Europe', 'FRBN0333', 0),
(0, 'Eps', 'France', 'Europe', 'FRNC0303', 0),
(0, 'Epuisay', 'France', 'Europe', 'FRCE0297', 0),
(0, 'Equancourt', 'France', 'Europe', 'FRPI0499', 0),
(0, 'Equemauville', 'France', 'Europe', 'FRBN0334', 0),
(0, 'Equennes-Eramecourt', 'France', 'Europe', 'FRPI0500', 0),
(0, 'Equeurdreville-Hainneville', 'France', 'Europe', 'FRXX2873', 0),
(0, 'Equevilley', 'France', 'Europe', 'FRFC0435', 0),
(0, 'Equevillon', 'France', 'Europe', 'FRFC0436', 0),
(0, 'Equihen-Plage', 'France', 'Europe', 'FRXX6413', 0),
(0, 'Equilly', 'France', 'Europe', 'FRBN0335', 0),
(0, 'Equirre', 'France', 'Europe', 'FRNC0304', 0),
(0, 'Eragny', 'France', 'Europe', 'FRXX2286', 0),
(0, 'Eraines', 'France', 'Europe', 'FRBN0336', 0),
(0, 'Eramecourt', 'France', 'Europe', 'FRPI0501', 0),
(0, 'Eraville', 'France', 'Europe', 'FRPC0310', 0),
(0, 'Erce', 'France', 'Europe', 'FRMP0638', 0),
(0, 'Erceville', 'France', 'Europe', 'FRCE0298', 0),
(0, 'Erches', 'France', 'Europe', 'FRPI0502', 0),
(0, 'Ercheu', 'France', 'Europe', 'FRXX2234', 0),
(0, 'Erchin', 'France', 'Europe', 'FRNC0305', 0),
(0, 'Ercourt', 'France', 'Europe', 'FRPI0503', 0),
(0, 'Ercuis', 'France', 'Europe', 'FRPI0504', 0),
(0, 'Erdeven', 'France', 'Europe', 'FRXX5292', 0),
(0, 'Ergersheim', 'France', 'Europe', 'FRAL0116', 0),
(0, 'Ergnies', 'France', 'Europe', 'FRPI0505', 0),
(0, 'Fillonniere', 'France', 'Europe', 'FRRA0569', 0),
(0, 'Filstroff', 'France', 'Europe', 'FRLO0453', 0),
(0, 'Fimenil', 'France', 'Europe', 'FRLO0454', 0),
(0, 'Finestret', 'France', 'Europe', 'FRLR0236', 0),
(0, 'Finhan', 'France', 'Europe', 'FRMP0715', 0),
(0, 'Fins', 'France', 'Europe', 'FRPI0559', 0),
(0, 'Fiquefleur-Equainville', 'France', 'Europe', 'FRHN0228', 0),
(0, 'Firbeix', 'France', 'Europe', 'FRAQ0449', 0),
(0, 'Firfol', 'France', 'Europe', 'FRBN0359', 0),
(0, 'Firminy', 'France', 'Europe', 'FRXX2627', 0),
(0, 'Fislis', 'France', 'Europe', 'FRAL0128', 0),
(0, 'Fismes', 'France', 'Europe', 'FRCA0445', 0),
(0, 'Fitignieu', 'France', 'Europe', 'FRRA0570', 0),
(0, 'Fitilieu', 'France', 'Europe', 'FRRA0571', 0),
(0, 'Fitou', 'France', 'Europe', 'FRLR0237', 0),
(0, 'Fitz-James', 'France', 'Europe', 'FRPI0560', 0),
(0, 'Fixem', 'France', 'Europe', 'FRLO0455', 0),
(0, 'Fixin', 'France', 'Europe', 'FRBO0409', 0),
(0, 'Flabas', 'France', 'Europe', 'FRLO0456', 0),
(0, 'Flabeuville', 'France', 'Europe', 'FRLO0457', 0),
(0, 'Flacey', 'France', 'Europe', 'FRBO0410', 0),
(0, 'Flacey', 'France', 'Europe', 'FRCE0320', 0),
(0, 'Flacheres', 'France', 'Europe', 'FRRA0572', 0),
(0, 'Flacourt', 'France', 'Europe', 'FRIF0193', 0),
(0, 'Flacy', 'France', 'Europe', 'FRBO0411', 0),
(0, 'Flagey', 'France', 'Europe', 'FRCA0446', 0),
(0, 'Flagey', 'France', 'Europe', 'FRFC0472', 0),
(0, 'Flagnac', 'France', 'Europe', 'FRMP0716', 0),
(0, 'Flagy', 'France', 'Europe', 'FRBO0412', 0),
(0, 'Flagy', 'France', 'Europe', 'FRFC0473', 0),
(0, 'Flagy', 'France', 'Europe', 'FRIF0194', 0),
(0, 'Flaine', 'France', 'Europe', 'FRXX0531', 0),
(0, 'Flainval', 'France', 'Europe', 'FRLO0458', 0),
(0, 'Flamanville', 'France', 'Europe', 'FRBN0360', 0),
(0, 'Flamanville', 'France', 'Europe', 'FRHN0229', 0),
(0, 'Flamarens', 'France', 'Europe', 'FRMP0717', 0),
(0, 'Flammerans', 'France', 'Europe', 'FRBO0413', 0),
(0, 'Flammerecourt', 'France', 'Europe', 'FRCA0447', 0),
(0, 'Flangebouche', 'France', 'Europe', 'FRFC0474', 0),
(0, 'Flassan', 'France', 'Europe', 'FRXX2302', 0),
(0, 'Flassigny', 'France', 'Europe', 'FRLO0459', 0),
(0, 'Flastroff', 'France', 'Europe', 'FRLO0460', 0),
(0, 'Flat', 'France', 'Europe', 'FRAU0240', 0),
(0, 'Flaucourt', 'France', 'Europe', 'FRPI0561', 0),
(0, 'Flaugeac', 'France', 'Europe', 'FRAQ0450', 0),
(0, 'Flaugnac', 'France', 'Europe', 'FRMP0718', 0),
(0, 'Flaujagues', 'France', 'Europe', 'FRAQ0451', 0),
(0, 'Flaumont-Waudrechies', 'France', 'Europe', 'FRNC0351', 0),
(0, 'Flaux', 'France', 'Europe', 'FRPA0176', 0),
(0, 'Flavacourt', 'France', 'Europe', 'FRPI0562', 0),
(0, 'Flaviac', 'France', 'Europe', 'FRRA0573', 0),
(0, 'Flavignac', 'France', 'Europe', 'FRLI0136', 0),
(0, 'Flavignerot', 'France', 'Europe', 'FRBO0414', 0),
(0, 'Flavigny', 'France', 'Europe', 'FRCA0448', 0),
(0, 'Flavigny', 'France', 'Europe', 'FRCE0321', 0),
(0, 'Flavin', 'France', 'Europe', 'FRMP0719', 0),
(0, 'Flavy-le-Martel', 'France', 'Europe', 'FRXX3144', 0),
(0, 'Flaxieu', 'France', 'Europe', 'FRRA0574', 0),
(0, 'Flaxlanden', 'France', 'Europe', 'FRAL0129', 0),
(0, 'Flayat', 'France', 'Europe', 'FRLI0137', 0),
(0, 'Flayosc', 'France', 'Europe', 'FRXX2037', 0),
(0, 'Fleac', 'France', 'Europe', 'FRPC0324', 0),
(0, 'Flechin', 'France', 'Europe', 'FRNC0352', 0),
(0, 'Flechy', 'France', 'Europe', 'FRPI0563', 0),
(0, 'Flee', 'France', 'Europe', 'FRBO0415', 0),
(0, 'Flee', 'France', 'Europe', 'FRPL0220', 0),
(0, 'Fleigneux', 'France', 'Europe', 'FRCA0449', 0),
(0, 'Fleisheim', 'France', 'Europe', 'FRLO0461', 0),
(0, 'Fleix', 'France', 'Europe', 'FRPC0325', 0),
(0, 'Flers', 'France', 'Europe', 'FRNC0353', 0),
(0, 'Flers', 'France', 'Europe', 'FRPI0564', 0),
(0, 'Flers-en-Escrebieux', 'France', 'Europe', 'FRXX5781', 0),
(0, 'Flesquieres', 'France', 'Europe', 'FRNC0354', 0),
(0, 'Flesselles', 'France', 'Europe', 'FRPI0565', 0),
(0, 'Fletrange', 'France', 'Europe', 'FRLO0462', 0),
(0, 'Fletre', 'France', 'Europe', 'FRNC0355', 0),
(0, 'Fleurac', 'France', 'Europe', 'FRAQ0452', 0),
(0, 'Fleurac', 'France', 'Europe', 'FRPC0326', 0),
(0, 'Fleurat', 'France', 'Europe', 'FRLI0138', 0),
(0, 'Fleurbaix', 'France', 'Europe', 'FRNC0356', 0),
(0, 'Gencay', 'France', 'Europe', 'FRPC0349', 0),
(0, 'Gendreville', 'France', 'Europe', 'FRLO0517', 0),
(0, 'Gendrey', 'France', 'Europe', 'FRXX4450', 0),
(0, 'Gene', 'France', 'Europe', 'FRPL0237', 0),
(0, 'Genebrieres', 'France', 'Europe', 'FRMP0813', 0),
(0, 'Genech', 'France', 'Europe', 'FRNC0382', 0),
(0, 'Genelard', 'France', 'Europe', 'FRBO0460', 0),
(0, 'Generac', 'France', 'Europe', 'FRAQ0503', 0),
(0, 'Generac', 'France', 'Europe', 'FRXX1858', 0),
(0, 'Generargues', 'France', 'Europe', 'FRLR0267', 0),
(0, 'Generest', 'France', 'Europe', 'FRMP0814', 0),
(0, 'Generville', 'France', 'Europe', 'FRLR0268', 0),
(0, 'Geneslay', 'France', 'Europe', 'FRBN0392', 0),
(0, 'Genestelle', 'France', 'Europe', 'FRRA0594', 0),
(0, 'Geneston', 'France', 'Europe', 'FRPL0238', 0),
(0, 'Genets', 'France', 'Europe', 'FRBN0393', 0),
(0, 'Geneuille', 'France', 'Europe', 'FRFC0520', 0),
(0, 'Genevreuille', 'France', 'Europe', 'FRFC0521', 0),
(0, 'Genevrey', 'France', 'Europe', 'FRFC0522', 0),
(0, 'Genevrieres', 'France', 'Europe', 'FRCA0481', 0),
(0, 'Geney', 'France', 'Europe', 'FRFC0523', 0),
(0, 'Genicourt', 'France', 'Europe', 'FRXX6001', 0),
(0, 'Genicourt-sous-Conde', 'France', 'Europe', 'FRLO0518', 0),
(0, 'Genicourt-sur-Meuse', 'France', 'Europe', 'FRLO0519', 0),
(0, 'Genilac', 'France', 'Europe', 'FRRA0595', 0),
(0, 'Genille', 'France', 'Europe', 'FRCE0354', 0),
(0, 'Genis', 'France', 'Europe', 'FRAQ0504', 0),
(0, 'Genissac', 'France', 'Europe', 'FRAQ0505', 0),
(0, 'Genissieux', 'France', 'Europe', 'FRRA0596', 0),
(0, 'Genlis', 'France', 'Europe', 'FRBO0461', 0),
(0, 'Gennes', 'France', 'Europe', 'FRFC0524', 0),
(0, 'Gennes', 'France', 'Europe', 'FRPL0239', 0),
(0, 'Gennes-Ivergny', 'France', 'Europe', 'FRNC0383', 0),
(0, 'Gennes-sur-Glaize', 'France', 'Europe', 'FRXX6065', 0),
(0, 'Gennes-sur-Seiche', 'France', 'Europe', 'FRPL0240', 0),
(0, 'Genneteil', 'France', 'Europe', 'FRPL0241', 0),
(0, 'Gennetines', 'France', 'Europe', 'FRAU0254', 0),
(0, 'Genneton', 'France', 'Europe', 'FRPC0350', 0),
(0, 'Genneville', 'France', 'Europe', 'FRBN0394', 0),
(0, 'Gennevilliers', 'France', 'Europe', 'FRXX4493', 0),
(0, 'Genod', 'France', 'Europe', 'FRFC0525', 0),
(0, 'Genolhac', 'France', 'Europe', 'FRLR0269', 0),
(0, 'Genos', 'France', 'Europe', 'FRXX5308', 0),
(0, 'Genouillac', 'France', 'Europe', 'FRPC0351', 0),
(0, 'Genouillac', 'France', 'Europe', 'FRXX5618', 0),
(0, 'Genouille', 'France', 'Europe', 'FRPC0352', 0),
(0, 'Genouille', 'France', 'Europe', 'FRPC0353', 0),
(0, 'Genouilleux', 'France', 'Europe', 'FRRA0597', 0),
(0, 'Genouilly', 'France', 'Europe', 'FRBO0462', 0),
(0, 'Genouilly', 'France', 'Europe', 'FRCE0355', 0),
(0, 'Genrupt', 'France', 'Europe', 'FRCA0482', 0),
(0, 'Gensac', 'France', 'Europe', 'FRAQ0506', 0),
(0, 'Gensac', 'France', 'Europe', 'FRMP0815', 0),
(0, 'Gensac', 'France', 'Europe', 'FRMP0816', 0),
(0, 'Gensac-de-Boulogne', 'France', 'Europe', 'FRMP0817', 0),
(0, 'Gensac-la-Pallue', 'France', 'Europe', 'FRXX6245', 0),
(0, 'Gensac-sur-Garonne', 'France', 'Europe', 'FRMP0818', 0),
(0, 'Gente', 'France', 'Europe', 'FRPC0354', 0),
(0, 'Gentelles', 'France', 'Europe', 'FRPI0636', 0),
(0, 'Gentilly', 'France', 'Europe', 'FRXX1638', 0),
(0, 'Gentioux-Pigerolles', 'France', 'Europe', 'FRXX2603', 0),
(0, 'Genvry', 'France', 'Europe', 'FRPI0637', 0),
(0, 'Georfans', 'France', 'Europe', 'FRFC0526', 0),
(0, 'Geovreisset', 'France', 'Europe', 'FRRA0598', 0),
(0, 'Geovreissiat', 'France', 'Europe', 'FRRA0599', 0),
(0, 'Ger', 'France', 'Europe', 'FRAQ0507', 0),
(0, 'Ger', 'France', 'Europe', 'FRMP0819', 0),
(0, 'Ger', 'France', 'Europe', 'FRXX3106', 0),
(0, 'Geraise', 'France', 'Europe', 'FRFC0527', 0),
(0, 'Gerardmer', 'France', 'Europe', 'FRXX0525', 0),
(0, 'Geraudot', 'France', 'Europe', 'FRCA0483', 0),
(0, 'Gerauvilliers', 'France', 'Europe', 'FRLO0520', 0),
(0, 'Gerbaix', 'France', 'Europe', 'FRRA0600', 0),
(0, 'Gerbamont', 'France', 'Europe', 'FRLO0521', 0),
(0, 'Gerbecourt', 'France', 'Europe', 'FRLO0522', 0),
(0, 'Gerbecourt-et-Haplemont', 'France', 'Europe', 'FRLO0523', 0),
(0, 'Gerbepal', 'France', 'Europe', 'FRLO0524', 0),
(0, 'Gerberoy', 'France', 'Europe', 'FRPI0638', 0),
(0, 'Gerbeviller', 'France', 'Europe', 'FRLO0525', 0),
(0, 'Gercourt-et-Drillancourt', 'France', 'Europe', 'FRLO0526', 0),
(0, 'Hautepierre-le-Chatelet', 'France', 'Europe', 'FRFC0582', 0),
(0, 'Hauterive', 'France', 'Europe', 'FRAU0272', 0),
(0, 'Hauterive', 'France', 'Europe', 'FRBN0439', 0),
(0, 'Hauterive', 'France', 'Europe', 'FRBO0512', 0),
(0, 'Hauterive-la-Fresse', 'France', 'Europe', 'FRFC0583', 0),
(0, 'Hauterives', 'France', 'Europe', 'FRXX4766', 0),
(0, 'Hauteroche', 'France', 'Europe', 'FRBO0513', 0),
(0, 'Hautes-Duyes', 'France', 'Europe', 'FRPA0211', 0),
(0, 'Hautesvignes', 'France', 'Europe', 'FRAQ0559', 0),
(0, 'Hautevelle', 'France', 'Europe', 'FRFC0584', 0),
(0, 'Hautevesnes', 'France', 'Europe', 'FRPI0737', 0),
(0, 'Hauteville', 'France', 'Europe', 'FRCA0556', 0),
(0, 'Hauteville', 'France', 'Europe', 'FRCA0557', 0),
(0, 'Hauteville', 'France', 'Europe', 'FRNC0430', 0),
(0, 'Hauteville', 'France', 'Europe', 'FRPI0738', 0),
(0, 'Hauteville', 'France', 'Europe', 'FRRA0652', 0),
(0, 'Hauteville-Gondon', 'France', 'Europe', 'FRRA0653', 0),
(0, 'Hauteville-la-Guichard', 'France', 'Europe', 'FRBN0440', 0),
(0, 'Hauteville-les-Dijon', 'France', 'Europe', 'FRXX1900', 0),
(0, 'Hauteville-Lompnes', 'France', 'Europe', 'FRXX0413', 0),
(0, 'Hauteville-sur-Fier', 'France', 'Europe', 'FRRA0654', 0),
(0, 'Hauteville-sur-Mer', 'France', 'Europe', 'FRBN0441', 0),
(0, 'Haution', 'France', 'Europe', 'FRPI0739', 0),
(0, 'Hautmont', 'France', 'Europe', 'FRXX2776', 0),
(0, 'Hautmougey', 'France', 'Europe', 'FRLO0657', 0),
(0, 'Hautot-l`Auvray', 'France', 'Europe', 'FRHN0328', 0),
(0, 'Hautot-le-Vatois', 'France', 'Europe', 'FRHN0329', 0),
(0, 'Hautot-Saint-Sulpice', 'France', 'Europe', 'FRHN0327', 0),
(0, 'Hautot-sur-Mer', 'France', 'Europe', 'FRXX1981', 0),
(0, 'Hautot-sur-Seine', 'France', 'Europe', 'FRHN0330', 0),
(0, 'Hautteville-Bocage', 'France', 'Europe', 'FRBN0442', 0),
(0, 'Hautvillers', 'France', 'Europe', 'FRCA0558', 0),
(0, 'Hautvillers-Ouville', 'France', 'Europe', 'FRPI0740', 0),
(0, 'Hauville', 'France', 'Europe', 'FRHN0331', 0),
(0, 'Hauvine', 'France', 'Europe', 'FRCA0559', 0),
(0, 'Haux', 'France', 'Europe', 'FRAQ0560', 0),
(0, 'Haux', 'France', 'Europe', 'FRAQ0561', 0),
(0, 'Havange', 'France', 'Europe', 'FRXX1431', 0),
(0, 'Havelu', 'France', 'Europe', 'FRCE0388', 0),
(0, 'Haveluy', 'France', 'Europe', 'FRXX1434', 0),
(0, 'Havernas', 'France', 'Europe', 'FRPI0741', 0),
(0, 'Haverskerque', 'France', 'Europe', 'FRNC0431', 0),
(0, 'Havrincourt', 'France', 'Europe', 'FRNC0432', 0),
(0, 'Havys', 'France', 'Europe', 'FRCA0560', 0),
(0, 'Hayange', 'France', 'Europe', 'FRXX4384', 0),
(0, 'Haybes', 'France', 'Europe', 'FRCA0561', 0),
(0, 'Hayes', 'France', 'Europe', 'FRLO0658', 0),
(0, 'Haynecourt', 'France', 'Europe', 'FRXX2847', 0),
(0, 'Hazebrouck', 'France', 'Europe', 'FRXX1888', 0),
(0, 'Hazembourg', 'France', 'Europe', 'FRLO0659', 0),
(0, 'Heauville', 'France', 'Europe', 'FRBN0443', 0),
(0, 'Hebecourt', 'France', 'Europe', 'FRHN0332', 0),
(0, 'Hebecourt', 'France', 'Europe', 'FRPI0742', 0),
(0, 'Hebecrevon', 'France', 'Europe', 'FRXX6569', 0),
(0, 'Heberville', 'France', 'Europe', 'FRHN0333', 0),
(0, 'Hebuterne', 'France', 'Europe', 'FRNC0433', 0),
(0, 'Heches', 'France', 'Europe', 'FRMP0895', 0),
(0, 'Hecken', 'France', 'Europe', 'FRAL0196', 0),
(0, 'Hecmanville', 'France', 'Europe', 'FRHN0334', 0),
(0, 'Hecourt', 'France', 'Europe', 'FRHN0335', 0),
(0, 'Hecourt', 'France', 'Europe', 'FRPI0743', 0),
(0, 'Hecq', 'France', 'Europe', 'FRNC0434', 0),
(0, 'Hectomare', 'France', 'Europe', 'FRHN0336', 0),
(0, 'Hedauville', 'France', 'Europe', 'FRPI0744', 0),
(0, 'Hede', 'France', 'Europe', 'FRXX3030', 0),
(0, 'Hedouville', 'France', 'Europe', 'FRIF0251', 0),
(0, 'Hegeney', 'France', 'Europe', 'FRAL0197', 0),
(0, 'Hegenheim', 'France', 'Europe', 'FRAL0198', 0),
(0, 'Heidolsheim', 'France', 'Europe', 'FRAL0199', 0),
(0, 'Heidwiller', 'France', 'Europe', 'FRAL0200', 0),
(0, 'Heiligenberg', 'France', 'Europe', 'FRAL0201', 0),
(0, 'Heiligenstein', 'France', 'Europe', 'FRXX2789', 0),
(0, 'Heillecourt', 'France', 'Europe', 'FRLO0660', 0),
(0, 'Heilles', 'France', 'Europe', 'FRPI0745', 0),
(0, 'Heilly', 'France', 'Europe', 'FRPI0746', 0),
(0, 'Heiltz-l`Eveque', 'France', 'Europe', 'FRCA0562', 0),
(0, 'Heiltz-le-Hutier', 'France', 'Europe', 'FRCA0563', 0),
(0, 'Heiltz-le-Maurupt', 'France', 'Europe', 'FRCA0564', 0),
(0, 'Heimersdorf', 'France', 'Europe', 'FRAL0202', 0),
(0, 'Heimsbrunn', 'France', 'Europe', 'FRXX3373', 0),
(0, 'Jubecourt', 'France', 'Europe', 'FRLO0744', 0),
(0, 'Jublains', 'France', 'Europe', 'FRPL0277', 0),
(0, 'Jugazan', 'France', 'Europe', 'FRAQ0600', 0),
(0, 'Jugeals-Nazareth', 'France', 'Europe', 'FRLI0169', 0),
(0, 'Jugon-les-Lacs', 'France', 'Europe', 'FRBR0064', 0),
(0, 'Jugy', 'France', 'Europe', 'FRBO0544', 0),
(0, 'Juicq', 'France', 'Europe', 'FRPC0397', 0),
(0, 'Juif', 'France', 'Europe', 'FRBO0545', 0),
(0, 'Juignac', 'France', 'Europe', 'FRPC0398', 0),
(0, 'Juigne-des-Moutiers', 'France', 'Europe', 'FRPL0278', 0),
(0, 'Juigne-sur-Loire', 'France', 'Europe', 'FRPL0279', 0),
(0, 'Juigne-sur-Sarthe', 'France', 'Europe', 'FRPL0280', 0),
(0, 'Juignettes', 'France', 'Europe', 'FRHN0375', 0),
(0, 'Juillac', 'France', 'Europe', 'FRAQ0601', 0),
(0, 'Juillac', 'France', 'Europe', 'FRMP0929', 0),
(0, 'Juillac', 'France', 'Europe', 'FRXX5527', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Juillac-le-Coq', 'France', 'Europe', 'FRPC0399', 0),
(0, 'Juillaguet', 'France', 'Europe', 'FRPC0400', 0),
(0, 'Juillan', 'France', 'Europe', 'FRXX1230', 0),
(0, 'Juille', 'France', 'Europe', 'FRPC0401', 0),
(0, 'Juille', 'France', 'Europe', 'FRPC0402', 0),
(0, 'Juille', 'France', 'Europe', 'FRPL0281', 0),
(0, 'Juillenay', 'France', 'Europe', 'FRBO0546', 0),
(0, 'Juilles', 'France', 'Europe', 'FRMP0930', 0),
(0, 'Juilley', 'France', 'Europe', 'FRBN0475', 0),
(0, 'Juilly', 'France', 'Europe', 'FRBO0547', 0),
(0, 'Juilly', 'France', 'Europe', 'FRIF0272', 0),
(0, 'Jujols', 'France', 'Europe', 'FRLR0297', 0),
(0, 'Jujurieux', 'France', 'Europe', 'FRXX7003', 0),
(0, 'Julianges', 'France', 'Europe', 'FRLR0298', 0),
(0, 'Julienas', 'France', 'Europe', 'FRXX6589', 0),
(0, 'Julienne', 'France', 'Europe', 'FRPC0403', 0),
(0, 'Jullianges', 'France', 'Europe', 'FRAU0292', 0),
(0, 'Jullie', 'France', 'Europe', 'FRRA0700', 0),
(0, 'Jullouville', 'France', 'Europe', 'FRXX3103', 0),
(0, 'Jully', 'France', 'Europe', 'FRBO0548', 0),
(0, 'Jully-les-Buxy', 'France', 'Europe', 'FRBO0549', 0),
(0, 'Jully-sur-Sarce', 'France', 'Europe', 'FRCA0611', 0),
(0, 'Julos', 'France', 'Europe', 'FRMP0931', 0),
(0, 'Julvecourt', 'France', 'Europe', 'FRLO0745', 0),
(0, 'Jumeauville', 'France', 'Europe', 'FRIF0273', 0),
(0, 'Jumeaux', 'France', 'Europe', 'FRAU0293', 0),
(0, 'Jumel', 'France', 'Europe', 'FRPI0793', 0),
(0, 'Jumelles', 'France', 'Europe', 'FRHN0376', 0),
(0, 'Jumelles', 'France', 'Europe', 'FRPL0282', 0),
(0, 'Jumencourt', 'France', 'Europe', 'FRPI0794', 0),
(0, 'Jumieges', 'France', 'Europe', 'FRHN0377', 0),
(0, 'Jumigny', 'France', 'Europe', 'FRPI0795', 0),
(0, 'Jumilhac-le-Grand', 'France', 'Europe', 'FRXX3939', 0),
(0, 'Junas', 'France', 'Europe', 'FRPA0216', 0),
(0, 'Junay', 'France', 'Europe', 'FRBO0550', 0),
(0, 'Juncalas', 'France', 'Europe', 'FRMP0932', 0),
(0, 'Jungholtz', 'France', 'Europe', 'FRAL0256', 0),
(0, 'Junhac', 'France', 'Europe', 'FRAU0294', 0),
(0, 'Juniville', 'France', 'Europe', 'FRCA0612', 0),
(0, 'Jupilles', 'France', 'Europe', 'FRPL0283', 0),
(0, 'Jurancon', 'France', 'Europe', 'FRAQ0602', 0),
(0, 'Juranville', 'France', 'Europe', 'FRCE0425', 0),
(0, 'Jure', 'France', 'Europe', 'FRRA0701', 0),
(0, 'Jurignac', 'France', 'Europe', 'FRPC0404', 0),
(0, 'Jurques', 'France', 'Europe', 'FRBN0476', 0),
(0, 'Jurvielle', 'France', 'Europe', 'FRMP0933', 0),
(0, 'Jury', 'France', 'Europe', 'FRLO0746', 0),
(0, 'Juscorps', 'France', 'Europe', 'FRPC0405', 0),
(0, 'Jusix', 'France', 'Europe', 'FRAQ0603', 0),
(0, 'Jussac', 'France', 'Europe', 'FRAU0295', 0),
(0, 'Jussarupt', 'France', 'Europe', 'FRLO0747', 0),
(0, 'Jussas', 'France', 'Europe', 'FRPC0406', 0),
(0, 'Jussecourt-Minecourt', 'France', 'Europe', 'FRCA0613', 0),
(0, 'Jussey', 'France', 'Europe', 'FRFC0605', 0),
(0, 'Jussy', 'France', 'Europe', 'FRBO0551', 0),
(0, 'Jussy', 'France', 'Europe', 'FRLO0748', 0),
(0, 'Jussy', 'France', 'Europe', 'FRPI0796', 0),
(0, 'Jussy-Champagne', 'France', 'Europe', 'FRCE0426', 0),
(0, 'Jussy-le-Chaudrier', 'France', 'Europe', 'FRXX4793', 0),
(0, 'Justian', 'France', 'Europe', 'FRMP0934', 0),
(0, 'Justine-Herbigny', 'France', 'Europe', 'FRCA0614', 0),
(0, 'Justiniac', 'France', 'Europe', 'FRMP0935', 0),
(0, 'Jutigny', 'France', 'Europe', 'FRIF0274', 0),
(0, 'Juvaincourt', 'France', 'Europe', 'FRLO0749', 0),
(0, 'La Capelle-Balaguier', 'France', 'Europe', 'FRMP0956', 0),
(0, 'La Capelle-Bleys', 'France', 'Europe', 'FRMP0957', 0),
(0, 'La Capelle-Bonance', 'France', 'Europe', 'FRXX5451', 0),
(0, 'La Capelle-et-Masmolene', 'France', 'Europe', 'FRPA0234', 0),
(0, 'La Capelle-les-Boulogne', 'France', 'Europe', 'FRNC0495', 0),
(0, 'La Capte', 'France', 'Europe', 'FRPA0235', 0),
(0, 'La Carneille', 'France', 'Europe', 'FRBN0501', 0),
(0, 'La Cassagne', 'France', 'Europe', 'FRAQ0611', 0),
(0, 'La Cassaigne', 'France', 'Europe', 'FRLR0306', 0),
(0, 'La Cassine', 'France', 'Europe', 'FRCA0625', 0),
(0, 'La Cauchie', 'France', 'Europe', 'FRNC0496', 0),
(0, 'La Caunette', 'France', 'Europe', 'FRLR0307', 0),
(0, 'La Caure', 'France', 'Europe', 'FRCA0626', 0),
(0, 'La Cavalerie', 'France', 'Europe', 'FRMP0958', 0),
(0, 'La Celette', 'France', 'Europe', 'FRCE0433', 0),
(0, 'La Celle', 'France', 'Europe', 'FRAU0297', 0),
(0, 'La Celle', 'France', 'Europe', 'FRAU0298', 0),
(0, 'La Celle', 'France', 'Europe', 'FRCE0434', 0),
(0, 'La Celle', 'France', 'Europe', 'FRPA0236', 0),
(0, 'La Celle-Conde', 'France', 'Europe', 'FRCE0435', 0),
(0, 'La Celle-Dunoise', 'France', 'Europe', 'FRLI0173', 0),
(0, 'La Celle-en-Morvan', 'France', 'Europe', 'FRBO0558', 0),
(0, 'La Celle-Guenand', 'France', 'Europe', 'FRCE0436', 0),
(0, 'La Celle-les-Bordes', 'France', 'Europe', 'FRXX6562', 0),
(0, 'La Celle-Saint-Avant', 'France', 'Europe', 'FRCE0437', 0),
(0, 'La Celle-Saint-Cloud', 'France', 'Europe', 'FRXX2108', 0),
(0, 'La Celle-Saint-Cyr', 'France', 'Europe', 'FRXX2238', 0),
(0, 'La Celle-sous-Chantemerle', 'France', 'Europe', 'FRCA0627', 0),
(0, 'La Celle-sous-Gouzon', 'France', 'Europe', 'FRXX1903', 0),
(0, 'La Celle-sous-Montmirail', 'France', 'Europe', 'FRPI0803', 0),
(0, 'La Celle-sur-Loire', 'France', 'Europe', 'FRXX4468', 0),
(0, 'La Celle-sur-Morin', 'France', 'Europe', 'FRIF0277', 0),
(0, 'La Celle-sur-Nievre', 'France', 'Europe', 'FRBO0559', 0),
(0, 'La Cellette', 'France', 'Europe', 'FRLI0174', 0),
(0, 'La Cellette', 'France', 'Europe', 'FRXX6407', 0),
(0, 'La Cerlangue', 'France', 'Europe', 'FRHN0384', 0),
(0, 'La Cerleau', 'France', 'Europe', 'FRCA0628', 0),
(0, 'La Chabanne', 'France', 'Europe', 'FRAU0299', 0),
(0, 'La Chabossiere', 'France', 'Europe', 'FRXX3472', 0),
(0, 'La Chaise', 'France', 'Europe', 'FRCA0629', 0),
(0, 'La Chaise-Baudouin', 'France', 'Europe', 'FRBN0502', 0),
(0, 'La Chaise-Dieu', 'France', 'Europe', 'FRXX3384', 0),
(0, 'La Chaize-Giraud', 'France', 'Europe', 'FRPL0313', 0),
(0, 'La Chaize-le-Vicomte', 'France', 'Europe', 'FRXX2306', 0),
(0, 'La Chamba', 'France', 'Europe', 'FRRA0729', 0),
(0, 'La Chambonie', 'France', 'Europe', 'FRRA0730', 0),
(0, 'La Chambre', 'France', 'Europe', 'FRRA0731', 0),
(0, 'La Champenoise', 'France', 'Europe', 'FRCE0438', 0),
(0, 'La Chapelaude', 'France', 'Europe', 'FRAU0300', 0),
(0, 'La Chapelle', 'France', 'Europe', 'FRAU0301', 0),
(0, 'La Chapelle', 'France', 'Europe', 'FRCA0630', 0),
(0, 'La Chapelle', 'France', 'Europe', 'FRPC0418', 0),
(0, 'La Chapelle', 'France', 'Europe', 'FRRA0732', 0),
(0, 'La Chapelle', 'France', 'Europe', 'FRRA0733', 0),
(0, 'La Chapelle', 'France', 'Europe', 'FRRA0734', 0),
(0, 'La Chapelle-Achard', 'France', 'Europe', 'FRPL0314', 0),
(0, 'La Chapelle-Anthenaise', 'France', 'Europe', 'FRXX1665', 0),
(0, 'La Chapelle-au-Mans', 'France', 'Europe', 'FRBO0564', 0),
(0, 'La Chapelle-au-Moine', 'France', 'Europe', 'FRBN0512', 0),
(0, 'La Chapelle-au-Riboul', 'France', 'Europe', 'FRPL0331', 0),
(0, 'La Chapelle-Aubareil', 'France', 'Europe', 'FRAQ0612', 0),
(0, 'La Chapelle-aux-Bois', 'France', 'Europe', 'FRXX6698', 0),
(0, 'La Chapelle-aux-Brocs', 'France', 'Europe', 'FRLI0178', 0),
(0, 'La Chapelle-aux-Chasses', 'France', 'Europe', 'FRAU0306', 0),
(0, 'La Chapelle-aux-Choux', 'France', 'Europe', 'FRPL0332', 0),
(0, 'La Chapelle-aux-Filtzmeens', 'France', 'Europe', 'FRBR0104', 0),
(0, 'La Chapelle-aux-Lys', 'France', 'Europe', 'FRPL0333', 0),
(0, 'La Chapelle-aux-Naux', 'France', 'Europe', 'FRCE0451', 0),
(0, 'La Chapelle-aux-Saints', 'France', 'Europe', 'FRLI0179', 0),
(0, 'La Chapelle-Baloue', 'France', 'Europe', 'FRLI0175', 0),
(0, 'La Chapelle-Basse-Mer', 'France', 'Europe', 'FRPL0315', 0),
(0, 'La Chapelle-Baton', 'France', 'Europe', 'FRXX6591', 0),
(0, 'La Chapelle-Bayvel', 'France', 'Europe', 'FRXX6258', 0),
(0, 'La Chapelle-Bertin', 'France', 'Europe', 'FRAU0302', 0),
(0, 'La Chapelle-Bertrand', 'France', 'Europe', 'FRPC0419', 0),
(0, 'La Chapelle-Biche', 'France', 'Europe', 'FRBN0503', 0),
(0, 'La Chapelle-Blanche', 'France', 'Europe', 'FRBR0093', 0),
(0, 'La Chapelle-Blanche', 'France', 'Europe', 'FRRA0735', 0),
(0, 'La Chapelle-Blanche-Saint-Martin', 'France', 'Europe', 'FRCE0439', 0),
(0, 'La Chapelle-Bouexic', 'France', 'Europe', 'FRBR0094', 0),
(0, 'Malain', 'France', 'Europe', 'FRBO0709', 0),
(0, 'Malaincourt', 'France', 'Europe', 'FRLO0974', 0),
(0, 'Malaincourt-sur-Meuse', 'France', 'Europe', 'FRCA0836', 0),
(0, 'Malakoff', 'France', 'Europe', 'FRXX3714', 0),
(0, 'Malancourt', 'France', 'Europe', 'FRLO0975', 0),
(0, 'Malancourt-la-Montagne', 'France', 'Europe', 'FRLO0976', 0),
(0, 'Malandry', 'France', 'Europe', 'FRCA0837', 0),
(0, 'Malange', 'France', 'Europe', 'FRFC0812', 0),
(0, 'Malans', 'France', 'Europe', 'FRFC0813', 0),
(0, 'Malans', 'France', 'Europe', 'FRFC0814', 0),
(0, 'Malansac', 'France', 'Europe', 'FRXX1595', 0),
(0, 'Malarce-sur-la-Thines', 'France', 'Europe', 'FRRA1027', 0),
(0, 'Malataverne', 'France', 'Europe', 'FRXX1130', 0),
(0, 'Malaucene', 'France', 'Europe', 'FRXX3015', 0),
(0, 'Malaucourt-sur-Seille', 'France', 'Europe', 'FRLO0977', 0),
(0, 'Malaumont', 'France', 'Europe', 'FRLO0978', 0),
(0, 'Malaunay', 'France', 'Europe', 'FRXX4594', 0),
(0, 'Malause', 'France', 'Europe', 'FRMP1324', 0),
(0, 'Malaussanne', 'France', 'Europe', 'FRAQ0860', 0),
(0, 'Malaussene', 'France', 'Europe', 'FRPA0352', 0),
(0, 'Malauzat', 'France', 'Europe', 'FRAU0437', 0),
(0, 'Malaville', 'France', 'Europe', 'FRPC0581', 0),
(0, 'Malavillers', 'France', 'Europe', 'FRLO0979', 0),
(0, 'Malay', 'France', 'Europe', 'FRBO0710', 0),
(0, 'Malay-le-Grand', 'France', 'Europe', 'FRBO0711', 0),
(0, 'Malay-le-Petit', 'France', 'Europe', 'FRBO0712', 0),
(0, 'Malbo', 'France', 'Europe', 'FRAU0438', 0),
(0, 'Malbosc', 'France', 'Europe', 'FRLR0436', 0),
(0, 'Malbouhans', 'France', 'Europe', 'FRFC0815', 0),
(0, 'Malbouzon', 'France', 'Europe', 'FRXX3131', 0),
(0, 'Malbrans', 'France', 'Europe', 'FRFC0816', 0),
(0, 'Malbuisson', 'France', 'Europe', 'FRFC0817', 0),
(0, 'Male', 'France', 'Europe', 'FRXX6469', 0),
(0, 'Malegoude', 'France', 'Europe', 'FRMP1325', 0),
(0, 'Malemort-du-Comtat', 'France', 'Europe', 'FRXX5327', 0),
(0, 'Malemort-sur-Correze', 'France', 'Europe', 'FRXX4765', 0),
(0, 'Malesherbes', 'France', 'Europe', 'FRCE0624', 0),
(0, 'Malestroit', 'France', 'Europe', 'FRXX4498', 0),
(0, 'Maletable', 'France', 'Europe', 'FRBN0796', 0),
(0, 'Maleville', 'France', 'Europe', 'FRMP1326', 0),
(0, 'Malguenac', 'France', 'Europe', 'FRBR0294', 0),
(0, 'Malicornay', 'France', 'Europe', 'FRCE0625', 0),
(0, 'Malicorne', 'France', 'Europe', 'FRAU0439', 0),
(0, 'Malicorne', 'France', 'Europe', 'FRBO0713', 0),
(0, 'Malicorne', 'France', 'Europe', 'FRXX0057', 0),
(0, 'Malicorne-sur-Sarthe', 'France', 'Europe', 'FRXX3786', 0),
(0, 'Maligny', 'France', 'Europe', 'FRBO0714', 0),
(0, 'Maligny', 'France', 'Europe', 'FRBO0715', 0),
(0, 'Malijai', 'France', 'Europe', 'FRXX6116', 0),
(0, 'Malincourt', 'France', 'Europe', 'FRNC0587', 0),
(0, 'Malintrat', 'France', 'Europe', 'FRXX1963', 0),
(0, 'Malissard', 'France', 'Europe', 'FRRA1028', 0),
(0, 'Mallefougasse-Auges', 'France', 'Europe', 'FRPA0353', 0),
(0, 'Malleloy', 'France', 'Europe', 'FRXX5353', 0),
(0, 'Mallemoisson', 'France', 'Europe', 'FRPA0354', 0),
(0, 'Mallemort', 'France', 'Europe', 'FRXX4051', 0),
(0, 'Malleon', 'France', 'Europe', 'FRMP1327', 0),
(0, 'Malleret', 'France', 'Europe', 'FRXX5223', 0),
(0, 'Malleret-Boussac', 'France', 'Europe', 'FRLI0266', 0),
(0, 'Mallerey', 'France', 'Europe', 'FRFC0818', 0),
(0, 'Malleval', 'France', 'Europe', 'FRRA1029', 0),
(0, 'Malleval-en-Vercors', 'France', 'Europe', 'FRRA1030', 0),
(0, 'Malleville-les-Gres', 'France', 'Europe', 'FRHN0535', 0),
(0, 'Malleville-sur-le-Bec', 'France', 'Europe', 'FRHN0536', 0),
(0, 'Mallievre', 'France', 'Europe', 'FRPL0532', 0),
(0, 'Malling', 'France', 'Europe', 'FRLO0980', 0),
(0, 'Malloue', 'France', 'Europe', 'FRBN0797', 0),
(0, 'Malmy', 'France', 'Europe', 'FRCA0838', 0),
(0, 'Malmy', 'France', 'Europe', 'FRCA0839', 0),
(0, 'Malo-les-Bains', 'France', 'Europe', 'FRXX5601', 0),
(0, 'Malons-et-Elze', 'France', 'Europe', 'FRLR0437', 0),
(0, 'Malouy', 'France', 'Europe', 'FRHN0537', 0),
(0, 'Malpart', 'France', 'Europe', 'FRPI1007', 0),
(0, 'Malpas', 'France', 'Europe', 'FRFC0819', 0),
(0, 'Malras', 'France', 'Europe', 'FRLR0438', 0),
(0, 'Malrevers', 'France', 'Europe', 'FRAU0440', 0),
(0, 'Malroy', 'France', 'Europe', 'FRLO0981', 0),
(0, 'Maltat', 'France', 'Europe', 'FRBO0716', 0),
(0, 'Maltot', 'France', 'Europe', 'FRXX4752', 0),
(0, 'Malval', 'France', 'Europe', 'FRLI0267', 0),
(0, 'Neuflize', 'France', 'Europe', 'FRCA0986', 0),
(0, 'Neufmaison', 'France', 'Europe', 'FRCA0987', 0),
(0, 'Neufmaisons', 'France', 'Europe', 'FRLO1156', 0),
(0, 'Neufmanil', 'France', 'Europe', 'FRCA0988', 0),
(0, 'Neufmesnil', 'France', 'Europe', 'FRBN0916', 0),
(0, 'Neufmontiers-les-Meaux', 'France', 'Europe', 'FRXX2181', 0),
(0, 'Neufmoulin', 'France', 'Europe', 'FRPI1190', 0),
(0, 'Neufmoulins', 'France', 'Europe', 'FRLO1157', 0),
(0, 'Neufmoutiers-en-Brie', 'France', 'Europe', 'FRIF0435', 0),
(0, 'Neufvillage', 'France', 'Europe', 'FRLO1158', 0),
(0, 'Neufvy-sur-Aronde', 'France', 'Europe', 'FRPI1191', 0),
(0, 'Neugartheim-Ittlenheim', 'France', 'Europe', 'FRAL0381', 0),
(0, 'Neuhaeusel', 'France', 'Europe', 'FRAL0382', 0),
(0, 'Neuil', 'France', 'Europe', 'FRCE0780', 0),
(0, 'Neuilh', 'France', 'Europe', 'FRMP1625', 0),
(0, 'Neuillac', 'France', 'Europe', 'FRPC0689', 0),
(0, 'Neuillay-les-Bois', 'France', 'Europe', 'FRCE0781', 0),
(0, 'Neuille', 'France', 'Europe', 'FRPL0626', 0),
(0, 'Neuille-le-Lierre', 'France', 'Europe', 'FRCE0782', 0),
(0, 'Neuille-Pont-Pierre', 'France', 'Europe', 'FRXX6600', 0),
(0, 'Neuilly', 'France', 'Europe', 'FRBO0886', 0),
(0, 'Neuilly', 'France', 'Europe', 'FRBO0887', 0),
(0, 'Neuilly', 'France', 'Europe', 'FRXX3256', 0),
(0, 'Neuilly-en-Donjon', 'France', 'Europe', 'FRAU0534', 0),
(0, 'Neuilly-en-Dun', 'France', 'Europe', 'FRCE0783', 0),
(0, 'Neuilly-en-Sancerre', 'France', 'Europe', 'FRCE0784', 0),
(0, 'Neuilly-en-Thelle', 'France', 'Europe', 'FRXX2733', 0),
(0, 'Neuilly-en-Vexin', 'France', 'Europe', 'FRXX6726', 0),
(0, 'Neuilly-l`Eveque', 'France', 'Europe', 'FRCA0989', 0),
(0, 'Neuilly-l`Hopital', 'France', 'Europe', 'FRPI1192', 0),
(0, 'Neuilly-la-Foret', 'France', 'Europe', 'FRBN0917', 0),
(0, 'Neuilly-le-Bisson', 'France', 'Europe', 'FRBN0918', 0),
(0, 'Neuilly-le-Brignon', 'France', 'Europe', 'FRCE0785', 0),
(0, 'Neuilly-le-Dien', 'France', 'Europe', 'FRPI1193', 0),
(0, 'Neuilly-le-Malherbe', 'France', 'Europe', 'FRBN0919', 0),
(0, 'Neuilly-le-Real', 'France', 'Europe', 'FRXX2418', 0),
(0, 'Neuilly-le-Vendin', 'France', 'Europe', 'FRPL0627', 0),
(0, 'Neuilly-Plaisance', 'France', 'Europe', 'FRXX2265', 0),
(0, 'Neuilly-Saint-Front', 'France', 'Europe', 'FRXX1005', 0),
(0, 'Neuilly-sous-Clermont', 'France', 'Europe', 'FRPI1194', 0),
(0, 'Neuilly-sur-Eure', 'France', 'Europe', 'FRBN0920', 0),
(0, 'Neuilly-sur-Marne', 'France', 'Europe', 'FRXX5374', 0),
(0, 'Neuilly-sur-Seine', 'France', 'Europe', 'FRXX0295', 0),
(0, 'Neuilly-sur-Suize', 'France', 'Europe', 'FRCA0990', 0),
(0, 'Neulette', 'France', 'Europe', 'FRNC0654', 0),
(0, 'Neulise', 'France', 'Europe', 'FRXX4182', 0),
(0, 'Neulles', 'France', 'Europe', 'FRPC0690', 0),
(0, 'Neulliac', 'France', 'Europe', 'FRBR0354', 0),
(0, 'Neung-sur-Beuvron', 'France', 'Europe', 'FRXX5073', 0),
(0, 'Neunkirchen-les-Bouzonville', 'France', 'Europe', 'FRLO1159', 0),
(0, 'Neure', 'France', 'Europe', 'FRAU0535', 0),
(0, 'Neurey-en-Vaux', 'France', 'Europe', 'FRFC0970', 0),
(0, 'Neurey-les-la-Demie', 'France', 'Europe', 'FRFC0971', 0),
(0, 'Neussargues-Moissac', 'France', 'Europe', 'FRXX6178', 0),
(0, 'Neuve-Chapelle', 'France', 'Europe', 'FRNC0655', 0),
(0, 'Neuve-Eglise', 'France', 'Europe', 'FRAL0383', 0),
(0, 'Neuve-Maison', 'France', 'Europe', 'FRPI1195', 0),
(0, 'Neuvecelle', 'France', 'Europe', 'FRRA1243', 0),
(0, 'Neuveglise', 'France', 'Europe', 'FRXX1057', 0),
(0, 'Neuvelle-les-Champlitte', 'France', 'Europe', 'FRFC0972', 0),
(0, 'Neuvelle-les-Cromary', 'France', 'Europe', 'FRFC0973', 0),
(0, 'Neuvelle-les-Grancey', 'France', 'Europe', 'FRBO0888', 0),
(0, 'Neuvelle-les-la-Charite', 'France', 'Europe', 'FRFC0974', 0),
(0, 'Neuvelle-les-Voisey', 'France', 'Europe', 'FRXX6075', 0),
(0, 'Neuves-Maisons', 'France', 'Europe', 'FRXX4646', 0),
(0, 'Neuvic', 'France', 'Europe', 'FRXX1188', 0),
(0, 'Neuvic', 'France', 'Europe', 'FRXX2479', 0),
(0, 'Neuvic-Entier', 'France', 'Europe', 'FRXX4385', 0),
(0, 'Neuvicq', 'France', 'Europe', 'FRPC0691', 0),
(0, 'Neuvicq-le-Chateau', 'France', 'Europe', 'FRXX3245', 0),
(0, 'Neuvillalais', 'France', 'Europe', 'FRPL0628', 0),
(0, 'Neuville', 'France', 'Europe', 'FRLI0306', 0),
(0, 'Neuville', 'France', 'Europe', 'FRXX2389', 0),
(0, 'Neuville-au-Bois', 'France', 'Europe', 'FRPI1198', 0),
(0, 'Neuville-au-Cornet', 'France', 'Europe', 'FRNC0659', 0),
(0, 'Neuville-au-Plain', 'France', 'Europe', 'FRBN0921', 0),
(0, 'Neuville-aux-Bois', 'France', 'Europe', 'FRXX5008', 0),
(0, 'Neuville-Bosc', 'France', 'Europe', 'FRPI1196', 0),
(0, 'Neuville-Bourjonval', 'France', 'Europe', 'FRNC0656', 0),
(0, 'Neuville-Coppegueule', 'France', 'Europe', 'FRXX1689', 0),
(0, 'Orcenais', 'France', 'Europe', 'FRCE0826', 0),
(0, 'Orcet', 'France', 'Europe', 'FRAU0550', 0),
(0, 'Orcevaux', 'France', 'Europe', 'FRCA1031', 0),
(0, 'Orchaise', 'France', 'Europe', 'FRCE0827', 0),
(0, 'Orchamps', 'France', 'Europe', 'FRFC1001', 0),
(0, 'Orchamps-Vennes', 'France', 'Europe', 'FRXX2452', 0),
(0, 'Orches', 'France', 'Europe', 'FRPC0706', 0),
(0, 'Orchies', 'France', 'Europe', 'FRXX2757', 0),
(0, 'Orcier', 'France', 'Europe', 'FRRA1275', 0),
(0, 'Orcieres', 'France', 'Europe', 'FRXX0252', 0),
(0, 'Orcinas', 'France', 'Europe', 'FRRA1276', 0),
(0, 'Orcines', 'France', 'Europe', 'FRXX5764', 0),
(0, 'Orcival', 'France', 'Europe', 'FRAU0551', 0),
(0, 'Orconte', 'France', 'Europe', 'FRCA1032', 0),
(0, 'Ordan-Larroque', 'France', 'Europe', 'FRXX5188', 0),
(0, 'Ordiarp', 'France', 'Europe', 'FRAQ1064', 0),
(0, 'Ordizan', 'France', 'Europe', 'FRMP1653', 0),
(0, 'Ordonnac', 'France', 'Europe', 'FRAQ1065', 0),
(0, 'Ordonnaz', 'France', 'Europe', 'FRRA1277', 0),
(0, 'Ore', 'France', 'Europe', 'FRMP1654', 0),
(0, 'Oregue', 'France', 'Europe', 'FRAQ1066', 0),
(0, 'Oreilla', 'France', 'Europe', 'FRLR0567', 0),
(0, 'Orelle', 'France', 'Europe', 'FRRA1278', 0),
(0, 'Oresmaux', 'France', 'Europe', 'FRPI1244', 0),
(0, 'Organ', 'France', 'Europe', 'FRMP1655', 0),
(0, 'Orgeans-Blanchefontaine', 'France', 'Europe', 'FRFC1002', 0),
(0, 'Orgedeuil', 'France', 'Europe', 'FRPC0707', 0),
(0, 'Orgeix', 'France', 'Europe', 'FRMP1656', 0),
(0, 'Orgelet', 'France', 'Europe', 'FRXX5175', 0),
(0, 'Orgeres', 'France', 'Europe', 'FRBN0955', 0),
(0, 'Orgeres', 'France', 'Europe', 'FRXX4092', 0),
(0, 'Orgeres-en-Beauce', 'France', 'Europe', 'FRXX4085', 0),
(0, 'Orgeres-la-Roche', 'France', 'Europe', 'FRPL0653', 0),
(0, 'Orgerus', 'France', 'Europe', 'FRIF0447', 0),
(0, 'Orges', 'France', 'Europe', 'FRCA1033', 0),
(0, 'Orgeux', 'France', 'Europe', 'FRBO0912', 0),
(0, 'Orgeval', 'France', 'Europe', 'FRPI1245', 0),
(0, 'Orgeval', 'France', 'Europe', 'FRXX6561', 0),
(0, 'Orgibet', 'France', 'Europe', 'FRMP1657', 0),
(0, 'Orglandes', 'France', 'Europe', 'FRBN0956', 0),
(0, 'Orgnac-l`Aven', 'France', 'Europe', 'FRRA1279', 0),
(0, 'Orgnac-sur-Vezere', 'France', 'Europe', 'FRLI0320', 0),
(0, 'Orgon', 'France', 'Europe', 'FRXX1082', 0),
(0, 'Orgueil', 'France', 'Europe', 'FRMP1658', 0),
(0, 'Oricourt', 'France', 'Europe', 'FRFC1003', 0),
(0, 'Orieux', 'France', 'Europe', 'FRMP1659', 0),
(0, 'Orignac', 'France', 'Europe', 'FRMP1660', 0),
(0, 'Origne', 'France', 'Europe', 'FRAQ1067', 0),
(0, 'Origne', 'France', 'Europe', 'FRPL0654', 0),
(0, 'Orignolles', 'France', 'Europe', 'FRPC0708', 0),
(0, 'Origny', 'France', 'Europe', 'FRBO0913', 0),
(0, 'Origny-en-Thierache', 'France', 'Europe', 'FRXX2395', 0),
(0, 'Origny-le-Butin', 'France', 'Europe', 'FRBN0957', 0),
(0, 'Origny-le-Roux', 'France', 'Europe', 'FRBN0958', 0),
(0, 'Origny-le-Sec', 'France', 'Europe', 'FRCA1034', 0),
(0, 'Origny-Sainte-Benoite', 'France', 'Europe', 'FRXX6306', 0),
(0, 'Orin', 'France', 'Europe', 'FRAQ1068', 0),
(0, 'Orincles', 'France', 'Europe', 'FRMP1661', 0),
(0, 'Oriocourt', 'France', 'Europe', 'FRLO1207', 0),
(0, 'Oriol-en-Royans', 'France', 'Europe', 'FRRA1280', 0),
(0, 'Oriolles', 'France', 'Europe', 'FRPC0709', 0),
(0, 'Orion', 'France', 'Europe', 'FRAQ1069', 0),
(0, 'Oris-en-Rattier', 'France', 'Europe', 'FRRA1281', 0),
(0, 'Orist', 'France', 'Europe', 'FRAQ1070', 0),
(0, 'Orival', 'France', 'Europe', 'FRPC0710', 0),
(0, 'Orival', 'France', 'Europe', 'FRPI1246', 0),
(0, 'Orival', 'France', 'Europe', 'FRXX3446', 0),
(0, 'Orleans', 'France', 'Europe', 'FRXX0074', 0),
(0, 'Orleat', 'France', 'Europe', 'FRAU0552', 0),
(0, 'Orleix', 'France', 'Europe', 'FRXX1394', 0),
(0, 'Orliac', 'France', 'Europe', 'FRAQ1071', 0),
(0, 'Orliac-de-Bar', 'France', 'Europe', 'FRLI0321', 0),
(0, 'Orliaguet', 'France', 'Europe', 'FRAQ1072', 0),
(0, 'Orlienas', 'France', 'Europe', 'FRXX2105', 0),
(0, 'Orlu', 'France', 'Europe', 'FRCE0828', 0),
(0, 'Orlu', 'France', 'Europe', 'FRMP1662', 0),
(0, 'Orly', 'France', 'Europe', 'FRXX2271', 0),
(0, 'Orly-sur-Morin', 'France', 'Europe', 'FRIF0448', 0),
(0, 'Ormancey', 'France', 'Europe', 'FRCA1035', 0),
(0, 'Ormeaux', 'France', 'Europe', 'FRIF0449', 0),
(0, 'Passy-Grigny', 'France', 'Europe', 'FRCA1062', 0),
(0, 'Passy-sur-Marne', 'France', 'Europe', 'FRXX3145', 0),
(0, 'Passy-sur-Seine', 'France', 'Europe', 'FRIF0463', 0),
(0, 'Pastricciola', 'France', 'Europe', 'FRCO0135', 0),
(0, 'Patay', 'France', 'Europe', 'FRXX3387', 0),
(0, 'Patornay', 'France', 'Europe', 'FRFC1034', 0),
(0, 'Patrimonio', 'France', 'Europe', 'FRCO0136', 0),
(0, 'Pau', 'France', 'Europe', 'FRXX0168', 0),
(0, 'Paucourt', 'France', 'Europe', 'FRCE0859', 0),
(0, 'Paudy', 'France', 'Europe', 'FRCE0860', 0),
(0, 'Pauilhac', 'France', 'Europe', 'FRMP1694', 0),
(0, 'Pauillac', 'France', 'Europe', 'FRXX1358', 0),
(0, 'Paule', 'France', 'Europe', 'FRBR0368', 0),
(0, 'Paulhac', 'France', 'Europe', 'FRMP1695', 0),
(0, 'Paulhac', 'France', 'Europe', 'FRXX3214', 0),
(0, 'Paulhac-en-Margeride', 'France', 'Europe', 'FRLR0582', 0),
(0, 'Paulhaguet', 'France', 'Europe', 'FRAU0564', 0),
(0, 'Paulhan', 'France', 'Europe', 'FRLR0583', 0),
(0, 'Paulhe', 'France', 'Europe', 'FRXX3907', 0),
(0, 'Paulhenc', 'France', 'Europe', 'FRMP1696', 0),
(0, 'Paulhiac', 'France', 'Europe', 'FRAQ1100', 0),
(0, 'Pauligne', 'France', 'Europe', 'FRLR0584', 0),
(0, 'Paulin', 'France', 'Europe', 'FRAQ1101', 0),
(0, 'Paulinet', 'France', 'Europe', 'FRXX5924', 0),
(0, 'Paulmy', 'France', 'Europe', 'FRCE0861', 0),
(0, 'Paulnay', 'France', 'Europe', 'FRCE0862', 0),
(0, 'Paulx', 'France', 'Europe', 'FRPL0666', 0),
(0, 'Paunat', 'France', 'Europe', 'FRAQ1102', 0),
(0, 'Paussac-et-Saint-Vivien', 'France', 'Europe', 'FRXX1908', 0),
(0, 'Pautaines-Augeville', 'France', 'Europe', 'FRCA1063', 0),
(0, 'Pauvres', 'France', 'Europe', 'FRCA1064', 0),
(0, 'Pavant', 'France', 'Europe', 'FRPI1279', 0),
(0, 'Pavezin', 'France', 'Europe', 'FRRA1308', 0),
(0, 'Pavie', 'France', 'Europe', 'FRXX4334', 0),
(0, 'Pavilly', 'France', 'Europe', 'FRHN0654', 0),
(0, 'Payns', 'France', 'Europe', 'FRCA1065', 0),
(0, 'Payra-sur-l`Hers', 'France', 'Europe', 'FRLR0585', 0),
(0, 'Payrac', 'France', 'Europe', 'FRMP1697', 0),
(0, 'Payre', 'France', 'Europe', 'FRPC0726', 0),
(0, 'Payrignac', 'France', 'Europe', 'FRMP1698', 0),
(0, 'Payrin-Augmontel', 'France', 'Europe', 'FRXX4354', 0),
(0, 'Payros-Cazautets', 'France', 'Europe', 'FRAQ1103', 0),
(0, 'Payroux', 'France', 'Europe', 'FRPC0727', 0),
(0, 'Payssous', 'France', 'Europe', 'FRMP1699', 0),
(0, 'Payzac', 'France', 'Europe', 'FRRA1309', 0),
(0, 'Payzac', 'France', 'Europe', 'FRXX2611', 0),
(0, 'Pazayac', 'France', 'Europe', 'FRAQ1104', 0),
(0, 'Paziols', 'France', 'Europe', 'FRLR0586', 0),
(0, 'Pazy', 'France', 'Europe', 'FRBO0947', 0),
(0, 'Peas', 'France', 'Europe', 'FRCA1066', 0),
(0, 'Peaugres', 'France', 'Europe', 'FRRA1310', 0),
(0, 'Peaule', 'France', 'Europe', 'FRBR0369', 0),
(0, 'Peault', 'France', 'Europe', 'FRPL0667', 0),
(0, 'Pebees', 'France', 'Europe', 'FRMP1700', 0),
(0, 'Pebrac', 'France', 'Europe', 'FRAU0565', 0),
(0, 'Pech', 'France', 'Europe', 'FRXX2562', 0),
(0, 'Pech-Luna', 'France', 'Europe', 'FRLR0587', 0),
(0, 'Pechabou', 'France', 'Europe', 'FRMP1701', 0),
(0, 'Pecharic-et-le-Py', 'France', 'Europe', 'FRXX3886', 0),
(0, 'Pechaudier', 'France', 'Europe', 'FRMP1702', 0),
(0, 'Pechbonnieu', 'France', 'Europe', 'FRXX5148', 0),
(0, 'Pechbusque', 'France', 'Europe', 'FRMP1703', 0),
(0, 'Pecorade', 'France', 'Europe', 'FRAQ1105', 0),
(0, 'Pecquencourt', 'France', 'Europe', 'FRXX3534', 0),
(0, 'Pecqueuse', 'France', 'Europe', 'FRIF0464', 0),
(0, 'Pecy', 'France', 'Europe', 'FRIF0465', 0),
(0, 'Pedernec', 'France', 'Europe', 'FRBR0370', 0),
(0, 'Pegairolles-de-Bueges', 'France', 'Europe', 'FRLR0588', 0),
(0, 'Pegairolles-de-l`Escalette', 'France', 'Europe', 'FRLR0589', 0),
(0, 'Pegomas', 'France', 'Europe', 'FRXX4684', 0),
(0, 'Peguilhan', 'France', 'Europe', 'FRMP1704', 0),
(0, 'Peigney', 'France', 'Europe', 'FRCA1067', 0),
(0, 'Peillac', 'France', 'Europe', 'FRBR0371', 0),
(0, 'Peille', 'France', 'Europe', 'FRXX7700', 0),
(0, 'Peillon', 'France', 'Europe', 'FRPA0423', 0),
(0, 'Peillonnex', 'France', 'Europe', 'FRRA1311', 0),
(0, 'Peintre', 'France', 'Europe', 'FRFC1035', 0),
(0, 'Peipin', 'France', 'Europe', 'FRPA0424', 0),
(0, 'Peira-Cava', 'France', 'Europe', 'FRPA0425', 0),
(0, 'Peisey Vallandry', 'France', 'Europe', 'FRXX0445', 0),
(0, 'Redessan', 'France', 'Europe', 'FRPA0466', 0),
(0, 'Reding', 'France', 'Europe', 'FRXX2653', 0),
(0, 'Redon', 'France', 'Europe', 'FRXX0304', 0),
(0, 'Redortiers', 'France', 'Europe', 'FRPA0467', 0),
(0, 'Reez-Fosse-Martin', 'France', 'Europe', 'FRPI1370', 0),
(0, 'Reffannes', 'France', 'Europe', 'FRPC0794', 0),
(0, 'Reffroy', 'France', 'Europe', 'FRLO1323', 0),
(0, 'Reffuveille', 'France', 'Europe', 'FRBN1039', 0),
(0, 'Refranche', 'France', 'Europe', 'FRFC1127', 0),
(0, 'Regades', 'France', 'Europe', 'FRMP1842', 0),
(0, 'Regat', 'France', 'Europe', 'FRMP1843', 0),
(0, 'Regina', 'France', 'Europe', 'FRXX7795', 0),
(0, 'Regnauville', 'France', 'Europe', 'FRNC0764', 0),
(0, 'Regnevelle', 'France', 'Europe', 'FRLO1324', 0),
(0, 'Regneville-sur-Mer', 'France', 'Europe', 'FRBN1040', 0),
(0, 'Regneville-sur-Meuse', 'France', 'Europe', 'FRLO1325', 0),
(0, 'Regney', 'France', 'Europe', 'FRLO1326', 0),
(0, 'Regnie-Durette', 'France', 'Europe', 'FRRA1424', 0),
(0, 'Regniere-Ecluse', 'France', 'Europe', 'FRPI1371', 0),
(0, 'Regniowez', 'France', 'Europe', 'FRCA1169', 0),
(0, 'Regny', 'France', 'Europe', 'FRPI1372', 0),
(0, 'Regny', 'France', 'Europe', 'FRRA1425', 0),
(0, 'Reguiny', 'France', 'Europe', 'FRBR0492', 0),
(0, 'Reguisheim', 'France', 'Europe', 'FRXX6345', 0),
(0, 'Regusse', 'France', 'Europe', 'FRPA0468', 0),
(0, 'Rehaincourt', 'France', 'Europe', 'FRLO1327', 0),
(0, 'Rehainviller', 'France', 'Europe', 'FRLO1328', 0),
(0, 'Rehaupal', 'France', 'Europe', 'FRLO1329', 0),
(0, 'Reherrey', 'France', 'Europe', 'FRLO1330', 0),
(0, 'Rehon', 'France', 'Europe', 'FRXX5281', 0),
(0, 'Reichsfeld', 'France', 'Europe', 'FRAL0455', 0),
(0, 'Reichshoffen', 'France', 'Europe', 'FRXX6501', 0),
(0, 'Reichstett', 'France', 'Europe', 'FRXX5107', 0),
(0, 'Reignac', 'France', 'Europe', 'FRAQ1198', 0),
(0, 'Reignac', 'France', 'Europe', 'FRXX5498', 0),
(0, 'Reignac-sur-Indre', 'France', 'Europe', 'FRXX4337', 0),
(0, 'Reignat', 'France', 'Europe', 'FRAU0606', 0),
(0, 'Reigneville-Bocage', 'France', 'Europe', 'FRBN1041', 0),
(0, 'Reignier', 'France', 'Europe', 'FRXX3798', 0),
(0, 'Reigny', 'France', 'Europe', 'FRCE0928', 0),
(0, 'Reilhac', 'France', 'Europe', 'FRAU0607', 0),
(0, 'Reilhac', 'France', 'Europe', 'FRAU0608', 0),
(0, 'Reilhac', 'France', 'Europe', 'FRMP1844', 0),
(0, 'Reilhaguet', 'France', 'Europe', 'FRMP1845', 0),
(0, 'Reilhanette', 'France', 'Europe', 'FRRA1426', 0),
(0, 'Reillanne', 'France', 'Europe', 'FRPA0469', 0),
(0, 'Reillon', 'France', 'Europe', 'FRLO1331', 0),
(0, 'Reilly', 'France', 'Europe', 'FRPI1373', 0),
(0, 'Reimerswiller', 'France', 'Europe', 'FRAL0456', 0),
(0, 'Reims', 'France', 'Europe', 'FRXX0080', 0),
(0, 'Reims-la-Brulee', 'France', 'Europe', 'FRCA1170', 0),
(0, 'Reinhardsmunster', 'France', 'Europe', 'FRAL0457', 0),
(0, 'Reiningue', 'France', 'Europe', 'FRXX1200', 0),
(0, 'Reipertswiller', 'France', 'Europe', 'FRAL0458', 0),
(0, 'Reithouse', 'France', 'Europe', 'FRFC1128', 0),
(0, 'Reitwiller', 'France', 'Europe', 'FRAL0459', 0),
(0, 'Rejaumont', 'France', 'Europe', 'FRMP1846', 0),
(0, 'Rejaumont', 'France', 'Europe', 'FRMP1847', 0),
(0, 'Rejet-de-Beaulieu', 'France', 'Europe', 'FRXX3575', 0),
(0, 'Relanges', 'France', 'Europe', 'FRLO1332', 0),
(0, 'Relans', 'France', 'Europe', 'FRFC1129', 0),
(0, 'Relevant', 'France', 'Europe', 'FRRA1427', 0),
(0, 'Rely', 'France', 'Europe', 'FRNC0765', 0),
(0, 'Remaisnil', 'France', 'Europe', 'FRPI1374', 0),
(0, 'Remalard', 'France', 'Europe', 'FRXX2044', 0),
(0, 'Remaucourt', 'France', 'Europe', 'FRCA1171', 0),
(0, 'Remaucourt', 'France', 'Europe', 'FRPI1375', 0),
(0, 'Remaugies', 'France', 'Europe', 'FRPI1376', 0),
(0, 'Remauville', 'France', 'Europe', 'FRIF0495', 0),
(0, 'Rembercourt-Sommaisne', 'France', 'Europe', 'FRLO1333', 0),
(0, 'Rembercourt-sur-Mad', 'France', 'Europe', 'FRLO1334', 0),
(0, 'Remecourt', 'France', 'Europe', 'FRPI1377', 0),
(0, 'Remelfang', 'France', 'Europe', 'FRLO1335', 0),
(0, 'Remelfing', 'France', 'Europe', 'FRLO1336', 0),
(0, 'Remeling', 'France', 'Europe', 'FRLO1337', 0),
(0, 'Remennecourt', 'France', 'Europe', 'FRLO1338', 0),
(0, 'Remenoville', 'France', 'Europe', 'FRLO1339', 0),
(0, 'Remerangles', 'France', 'Europe', 'FRPI1378', 0),
(0, 'Remereville', 'France', 'Europe', 'FRLO1340', 0),
(0, 'Remering', 'France', 'Europe', 'FRLO1341', 0),
(0, 'Saint-Andre-d`Allas', 'France', 'Europe', 'FRAQ1237', 0),
(0, 'Saint-Andre-d`Apchon', 'France', 'Europe', 'FRRA1511', 0),
(0, 'Saint-Andre-d`Embrun', 'France', 'Europe', 'FRPA0502', 0),
(0, 'Saint-Andre-d`Hebertot', 'France', 'Europe', 'FRBN1081', 0),
(0, 'Saint-Andre-d`Huiriat', 'France', 'Europe', 'FRRA1512', 0),
(0, 'Saint-Andre-d`Olerargues', 'France', 'Europe', 'FRPA0503', 0),
(0, 'Saint-Andre-de-Bage', 'France', 'Europe', 'FRRA1513', 0),
(0, 'Saint-Andre-de-Boege', 'France', 'Europe', 'FRXX1615', 0),
(0, 'Saint-Andre-de-Bohon', 'France', 'Europe', 'FRBN1082', 0),
(0, 'Saint-Andre-de-Briouze', 'France', 'Europe', 'FRBN1083', 0),
(0, 'Saint-Andre-de-Bueges', 'France', 'Europe', 'FRLR0709', 0),
(0, 'Saint-Andre-de-Chalencon', 'France', 'Europe', 'FRAU0637', 0),
(0, 'Saint-Andre-de-Corcy', 'France', 'Europe', 'FRXX3932', 0),
(0, 'Saint-Andre-de-Cruzieres', 'France', 'Europe', 'FRRA1514', 0),
(0, 'Saint-Andre-de-Cubzac', 'France', 'Europe', 'FRAQ1238', 0),
(0, 'Saint-Andre-de-Double', 'France', 'Europe', 'FRAQ1239', 0),
(0, 'Saint-Andre-de-l`Epine', 'France', 'Europe', 'FRBN1085', 0),
(0, 'Saint-Andre-de-l`Eure', 'France', 'Europe', 'FRHN0732', 0),
(0, 'Saint-Andre-de-la-Marche', 'France', 'Europe', 'FRPL0743', 0),
(0, 'Saint-Andre-de-la-Roche', 'France', 'Europe', 'FRXX3159', 0),
(0, 'Saint-Andre-de-Lancize', 'France', 'Europe', 'FRLR0710', 0),
(0, 'Saint-Andre-de-Lidon', 'France', 'Europe', 'FRXX1121', 0),
(0, 'Saint-Andre-de-Majencoules', 'France', 'Europe', 'FRXX5560', 0),
(0, 'Saint-Andre-de-Messei', 'France', 'Europe', 'FRBN1084', 0),
(0, 'Saint-Andre-de-Najac', 'France', 'Europe', 'FRXX3961', 0),
(0, 'Saint-Andre-de-Roquelongue', 'France', 'Europe', 'FRLR0711', 0),
(0, 'Saint-Andre-de-Roquepertuis', 'France', 'Europe', 'FRXX6266', 0),
(0, 'Saint-Andre-de-Rosans', 'France', 'Europe', 'FRXX3149', 0),
(0, 'Saint-Andre-de-Sangonis', 'France', 'Europe', 'FRXX1879', 0),
(0, 'Saint-Andre-de-Seignanx', 'France', 'Europe', 'FRAQ1240', 0),
(0, 'Saint-Andre-de-Valborgne', 'France', 'Europe', 'FRXX3303', 0),
(0, 'Saint-Andre-de-Vezines', 'France', 'Europe', 'FRXX1742', 0),
(0, 'Saint-Andre-des-Eaux', 'France', 'Europe', 'FRBR0518', 0),
(0, 'Saint-Andre-des-Eaux', 'France', 'Europe', 'FRXX1268', 0),
(0, 'Saint-Andre-du-Bois', 'France', 'Europe', 'FRAQ1241', 0),
(0, 'Saint-Andre-en-Barrois', 'France', 'Europe', 'FRLO1415', 0),
(0, 'Saint-Andre-en-Bresse', 'France', 'Europe', 'FRBO1076', 0),
(0, 'Saint-Andre-en-Morvan', 'France', 'Europe', 'FRBO1077', 0),
(0, 'Saint-Andre-en-Royans', 'France', 'Europe', 'FRRA1515', 0),
(0, 'Saint-Andre-en-Terre-Plaine', 'France', 'Europe', 'FRBO1078', 0),
(0, 'Saint-Andre-en-Vivarais', 'France', 'Europe', 'FRRA1516', 0),
(0, 'Saint-Andre-et-Appelles', 'France', 'Europe', 'FRAQ1242', 0),
(0, 'Saint-Andre-Farivillers', 'France', 'Europe', 'FRPI1462', 0),
(0, 'Saint-Andre-Goule-d`Oie', 'France', 'Europe', 'FRPL0742', 0),
(0, 'Saint-Andre-la-Cote', 'France', 'Europe', 'FRRA1517', 0),
(0, 'Saint-Andre-Lachamp', 'France', 'Europe', 'FRXX4802', 0),
(0, 'Saint-Andre-le-Bouchoux', 'France', 'Europe', 'FRRA1518', 0),
(0, 'Saint-Andre-le-Coq', 'France', 'Europe', 'FRAU0638', 0),
(0, 'Saint-Andre-le-Desert', 'France', 'Europe', 'FRBO1079', 0),
(0, 'Saint-Andre-le-Gaz', 'France', 'Europe', 'FRXX2125', 0),
(0, 'Saint-Andre-le-Puy', 'France', 'Europe', 'FRRA1519', 0),
(0, 'Saint-Andre-les-Alpes', 'France', 'Europe', 'FRXX6111', 0),
(0, 'Saint-Andre-les-Vergers', 'France', 'Europe', 'FRXX4836', 0),
(0, 'Saint-Andre-lez-Lille', 'France', 'Europe', 'FRXX3535', 0),
(0, 'Saint-Andre-sur-Cailly', 'France', 'Europe', 'FRXX6375', 0),
(0, 'Saint-Andre-sur-Orne', 'France', 'Europe', 'FRBN1086', 0),
(0, 'Saint-Andre-sur-Sevre', 'France', 'Europe', 'FRPC0827', 0),
(0, 'Saint-Andre-sur-Vieux-Jonc', 'France', 'Europe', 'FRRA1520', 0),
(0, 'Saint-Andre-Treize-Voies', 'France', 'Europe', 'FRXX3792', 0),
(0, 'Saint-Androny', 'France', 'Europe', 'FRAQ1243', 0),
(0, 'Saint-Ange-et-Torcay', 'France', 'Europe', 'FRCE0974', 0),
(0, 'Saint-Ange-le-Viel', 'France', 'Europe', 'FRIF0519', 0),
(0, 'Saint-Angeau', 'France', 'Europe', 'FRPC0828', 0),
(0, 'Saint-Angel', 'France', 'Europe', 'FRAU0639', 0),
(0, 'Saint-Angel', 'France', 'Europe', 'FRAU0640', 0),
(0, 'Saint-Angel', 'France', 'Europe', 'FRLI0367', 0),
(0, 'Saint-Antheme', 'France', 'Europe', 'FRXX4203', 0),
(0, 'Saint-Anthot', 'France', 'Europe', 'FRBO1080', 0),
(0, 'Saint-Antoine', 'France', 'Europe', 'FRAQ1244', 0),
(0, 'Saint-Antoine', 'France', 'Europe', 'FRAU0641', 0),
(0, 'Saint-Antoine', 'France', 'Europe', 'FRFC1174', 0),
(0, 'Saint-Antoine', 'France', 'Europe', 'FRXX3555', 0),
(0, 'Saint-Antoine-Cumond', 'France', 'Europe', 'FRPC0829', 0),
(0, 'Saint-Antoine-d`Auberoche', 'France', 'Europe', 'FRAQ1245', 0),
(0, 'Saint-Antoine-de-Breuilh', 'France', 'Europe', 'FRXX4131', 0),
(0, 'Saint-Antoine-de-Ficalba', 'France', 'Europe', 'FRAQ1246', 0),
(0, 'Saint-Antoine-du-Queyret', 'France', 'Europe', 'FRAQ1247', 0),
(0, 'Saint-Antoine-du-Rocher', 'France', 'Europe', 'FRCE0975', 0),
(0, 'Saint-Antoine-l`Abbaye', 'France', 'Europe', 'FRRA1521', 0),
(0, 'Saint-Antoine-la-Foret', 'France', 'Europe', 'FRHN0733', 0),
(0, 'Termes', 'France', 'Europe', 'FRLR0888', 0),
(0, 'Termes', 'France', 'Europe', 'FRLR0889', 0),
(0, 'Termes-d`Armagnac', 'France', 'Europe', 'FRMP2308', 0),
(0, 'Termignon', 'France', 'Europe', 'FRRA1964', 0),
(0, 'Termignon La Vanoise', 'France', 'Europe', 'FRXX0450', 0),
(0, 'Terminiers', 'France', 'Europe', 'FRCE1203', 0),
(0, 'Ternand', 'France', 'Europe', 'FRRA1965', 0),
(0, 'Ternant', 'France', 'Europe', 'FRBO1361', 0),
(0, 'Ternant', 'France', 'Europe', 'FRBO1362', 0),
(0, 'Ternant', 'France', 'Europe', 'FRPC1081', 0),
(0, 'Ternant-les-Eaux', 'France', 'Europe', 'FRAU0851', 0),
(0, 'Ternas', 'France', 'Europe', 'FRNC0901', 0),
(0, 'Ternat', 'France', 'Europe', 'FRCA1425', 0),
(0, 'Ternay', 'France', 'Europe', 'FRCE1204', 0),
(0, 'Ternay', 'France', 'Europe', 'FRPC1082', 0),
(0, 'Ternay', 'France', 'Europe', 'FRRA1966', 0),
(0, 'Ternuay-Melay-et-Saint-Hilaire', 'France', 'Europe', 'FRFC1277', 0),
(0, 'Terny-Sorny', 'France', 'Europe', 'FRPI1597', 0),
(0, 'Terramesnil', 'France', 'Europe', 'FRPI1598', 0),
(0, 'Terrans', 'France', 'Europe', 'FRBO1363', 0),
(0, 'Terrasson-Lavilledieu', 'France', 'Europe', 'FRXX4876', 0),
(0, 'Terrats', 'France', 'Europe', 'FRLR0890', 0),
(0, 'Terraube', 'France', 'Europe', 'FRMP2309', 0),
(0, 'Terre-Clapier', 'France', 'Europe', 'FRMP2310', 0),
(0, 'Terre-de-Bas', 'France', 'Europe', 'FRXX7729', 0),
(0, 'Terre-de-Haut', 'France', 'Europe', 'FRXX7730', 0),
(0, 'Terre-Natale', 'France', 'Europe', 'FRCA1426', 0),
(0, 'Terrebasse', 'France', 'Europe', 'FRMP2311', 0),
(0, 'Terrefondree', 'France', 'Europe', 'FRBO1364', 0),
(0, 'Terrehault', 'France', 'Europe', 'FRPL0992', 0),
(0, 'Terrenoire', 'France', 'Europe', 'FRXX5639', 0),
(0, 'Terroles', 'France', 'Europe', 'FRLR0891', 0),
(0, 'Terron-sur-Aisne', 'France', 'Europe', 'FRCA1427', 0),
(0, 'Terrou', 'France', 'Europe', 'FRMP2312', 0),
(0, 'Tersanne', 'France', 'Europe', 'FRRA1967', 0),
(0, 'Tersannes', 'France', 'Europe', 'FRLI0536', 0),
(0, 'Terssac', 'France', 'Europe', 'FRMP2313', 0),
(0, 'Tertry', 'France', 'Europe', 'FRPI1599', 0),
(0, 'Terves', 'France', 'Europe', 'FRPC1083', 0),
(0, 'Terville', 'France', 'Europe', 'FRXX2886', 0),
(0, 'Tessancourt-sur-Aubette', 'France', 'Europe', 'FRIF0593', 0),
(0, 'Tesse-Froulay', 'France', 'Europe', 'FRXX5609', 0),
(0, 'Tesse-la-Madeleine', 'France', 'Europe', 'FRXX6468', 0),
(0, 'Tessel', 'France', 'Europe', 'FRBN1393', 0),
(0, 'Tessens', 'France', 'Europe', 'FRRA1968', 0),
(0, 'Tesson', 'France', 'Europe', 'FRPC1084', 0),
(0, 'Tessonniere', 'France', 'Europe', 'FRPC1085', 0),
(0, 'Tessy-sur-Vire', 'France', 'Europe', 'FRXX5123', 0),
(0, 'Tetaigne', 'France', 'Europe', 'FRCA1428', 0),
(0, 'Tete de Viraysse', 'France', 'Europe', 'FRXX0263', 0),
(0, 'Teteghem', 'France', 'Europe', 'FRXX3008', 0),
(0, 'Teterchen', 'France', 'Europe', 'FRLO1578', 0),
(0, 'Tethieu', 'France', 'Europe', 'FRAQ1668', 0),
(0, 'Teting-sur-Nied', 'France', 'Europe', 'FRXX2968', 0),
(0, 'Teuillac', 'France', 'Europe', 'FRAQ1669', 0),
(0, 'Teulat', 'France', 'Europe', 'FRMP2314', 0),
(0, 'Teurtheville-Bocage', 'France', 'Europe', 'FRXX3104', 0),
(0, 'Teurtheville-Hague', 'France', 'Europe', 'FRXX6809', 0),
(0, 'Teyjat', 'France', 'Europe', 'FRAQ1670', 0),
(0, 'Teyran', 'France', 'Europe', 'FRXX3328', 0),
(0, 'Teyssieres', 'France', 'Europe', 'FRRA1969', 0),
(0, 'Teyssieu', 'France', 'Europe', 'FRMP2315', 0),
(0, 'Teyssode', 'France', 'Europe', 'FRMP2316', 0),
(0, 'Thaas', 'France', 'Europe', 'FRCA1429', 0),
(0, 'Thaims', 'France', 'Europe', 'FRPC1086', 0),
(0, 'Thaire', 'France', 'Europe', 'FRXX1122', 0),
(0, 'Thaix', 'France', 'Europe', 'FRBO1365', 0),
(0, 'Thal-Drulingen', 'France', 'Europe', 'FRAL0577', 0),
(0, 'Thal-Marmoutier', 'France', 'Europe', 'FRAL0578', 0),
(0, 'Thalamy', 'France', 'Europe', 'FRLI0537', 0),
(0, 'Thann', 'France', 'Europe', 'FRXX5814', 0),
(0, 'Thannenkirch', 'France', 'Europe', 'FRAL0579', 0),
(0, 'Thanville', 'France', 'Europe', 'FRAL0580', 0),
(0, 'Thaon', 'France', 'Europe', 'FRBN1394', 0),
(0, 'Thaon-les-Vosges', 'France', 'Europe', 'FRXX5964', 0),
(0, 'Tharaux', 'France', 'Europe', 'FRLR0892', 0),
(0, 'Tharoiseau', 'France', 'Europe', 'FRBO1366', 0),
(0, 'Tharon-Plage', 'France', 'Europe', 'FRPL0993', 0),
(0, 'Tharot', 'France', 'Europe', 'FRBO1367', 0),
(0, 'Thaumiers', 'France', 'Europe', 'FRCE1205', 0),
(0, 'Vandeuil', 'France', 'Europe', 'FRCA1499', 0),
(0, 'Vandieres', 'France', 'Europe', 'FRCA1500', 0),
(0, 'Vandieres', 'France', 'Europe', 'FRXX3096', 0),
(0, 'Vandoeuvre-les-Nancy', 'France', 'Europe', 'FRXX6724', 0),
(0, 'Vandoncourt', 'France', 'Europe', 'FRXX2450', 0),
(0, 'Vandre', 'France', 'Europe', 'FRPC1119', 0),
(0, 'Vandrimare', 'France', 'Europe', 'FRXX6233', 0),
(0, 'Vandy', 'France', 'Europe', 'FRCA1501', 0),
(0, 'Vanlay', 'France', 'Europe', 'FRCA1502', 0),
(0, 'Vannaire', 'France', 'Europe', 'FRBO1430', 0),
(0, 'Vanne', 'France', 'Europe', 'FRFC1329', 0),
(0, 'Vannecourt', 'France', 'Europe', 'FRLO1662', 0),
(0, 'Vannecrocq', 'France', 'Europe', 'FRHN0971', 0),
(0, 'Vannes', 'France', 'Europe', 'FRXX0176', 0),
(0, 'Vannes-le-Chatel', 'France', 'Europe', 'FRXX4639', 0),
(0, 'Vannes-sur-Cosson', 'France', 'Europe', 'FRCE1260', 0),
(0, 'Vannoz', 'France', 'Europe', 'FRFC1330', 0),
(0, 'Vanosc', 'France', 'Europe', 'FRRA2043', 0),
(0, 'Vantoux', 'France', 'Europe', 'FRBO1431', 0),
(0, 'Vantoux', 'France', 'Europe', 'FRLO1663', 0),
(0, 'Vantoux-et-Longevelle', 'France', 'Europe', 'FRFC1331', 0),
(0, 'Vanves', 'France', 'Europe', 'FRXX3713', 0),
(0, 'Vanvey', 'France', 'Europe', 'FRBO1432', 0),
(0, 'Vanville', 'France', 'Europe', 'FRIF0614', 0),
(0, 'Vanxains', 'France', 'Europe', 'FRAQ1712', 0),
(0, 'Vany', 'France', 'Europe', 'FRLO1664', 0),
(0, 'Vanzac', 'France', 'Europe', 'FRPC1120', 0),
(0, 'Vanzay', 'France', 'Europe', 'FRPC1121', 0),
(0, 'Vanzy', 'France', 'Europe', 'FRRA2044', 0),
(0, 'Vaour', 'France', 'Europe', 'FRMP2403', 0),
(0, 'Varacieux', 'France', 'Europe', 'FRRA2045', 0),
(0, 'Varades', 'France', 'Europe', 'FRXX6423', 0),
(0, 'Varages', 'France', 'Europe', 'FRPA0674', 0),
(0, 'Varaignes', 'France', 'Europe', 'FRAQ1713', 0),
(0, 'Varaire', 'France', 'Europe', 'FRMP2404', 0),
(0, 'Varaize', 'France', 'Europe', 'FRPC1122', 0),
(0, 'Varambon', 'France', 'Europe', 'FRRA2046', 0),
(0, 'Varanges', 'France', 'Europe', 'FRBO1433', 0),
(0, 'Varangeville', 'France', 'Europe', 'FRLO1665', 0),
(0, 'Varaville', 'France', 'Europe', 'FRXX1743', 0),
(0, 'Varces-Allieres-et-Risset', 'France', 'Europe', 'FRRA2047', 0),
(0, 'Vareilles', 'France', 'Europe', 'FRBO1434', 0),
(0, 'Vareilles', 'France', 'Europe', 'FRBO1435', 0),
(0, 'Vareilles', 'France', 'Europe', 'FRLI0549', 0),
(0, 'Varen', 'France', 'Europe', 'FRXX3487', 0),
(0, 'Varengeville-sur-Mer', 'France', 'Europe', 'FRXX2808', 0),
(0, 'Varenguebec', 'France', 'Europe', 'FRBN1443', 0),
(0, 'Varenne-l`Arconce', 'France', 'Europe', 'FRBO1437', 0),
(0, 'Varenne-Saint-Germain', 'France', 'Europe', 'FRBO1436', 0),
(0, 'Varennes', 'France', 'Europe', 'FRAQ1714', 0),
(0, 'Varennes', 'France', 'Europe', 'FRBO1438', 0),
(0, 'Varennes', 'France', 'Europe', 'FRCE1261', 0),
(0, 'Varennes', 'France', 'Europe', 'FRMP2405', 0),
(0, 'Varennes', 'France', 'Europe', 'FRMP2406', 0),
(0, 'Varennes', 'France', 'Europe', 'FRPC1123', 0),
(0, 'Varennes', 'France', 'Europe', 'FRPI1656', 0),
(0, 'Varennes-Changy', 'France', 'Europe', 'FRCE1262', 0),
(0, 'Varennes-en-Argonne', 'France', 'Europe', 'FRXX5291', 0),
(0, 'Varennes-Jarcy', 'France', 'Europe', 'FRIF0615', 0),
(0, 'Varennes-le-Grand', 'France', 'Europe', 'FRBO1439', 0),
(0, 'Varennes-les-Macon', 'France', 'Europe', 'FRBO1440', 0),
(0, 'Varennes-les-Narcy', 'France', 'Europe', 'FRXX4467', 0),
(0, 'Varennes-Saint-Honorat', 'France', 'Europe', 'FRXX4162', 0),
(0, 'Varennes-Saint-Sauveur', 'France', 'Europe', 'FRXX1211', 0),
(0, 'Varennes-sous-Dun', 'France', 'Europe', 'FRBO1441', 0),
(0, 'Varennes-sur-Allier', 'France', 'Europe', 'FRXX5409', 0),
(0, 'Varennes-sur-Amance', 'France', 'Europe', 'FRCA1503', 0),
(0, 'Varennes-sur-Fouzon', 'France', 'Europe', 'FRXX2875', 0),
(0, 'Varennes-sur-le-Doubs', 'France', 'Europe', 'FRBO1442', 0),
(0, 'Varennes-sur-Loire', 'France', 'Europe', 'FRXX3689', 0),
(0, 'Varennes-sur-Morge', 'France', 'Europe', 'FRAU0892', 0),
(0, 'Varennes-sur-Seine', 'France', 'Europe', 'FRXX6617', 0),
(0, 'Varennes-sur-Teche', 'France', 'Europe', 'FRAU0893', 0),
(0, 'Varennes-sur-Usson', 'France', 'Europe', 'FRAU0894', 0),
(0, 'Varennes-Vauzelles', 'France', 'Europe', 'FRXX1592', 0),
(0, 'Vares', 'France', 'Europe', 'FRAQ1715', 0),
(0, 'Varesnes', 'France', 'Europe', 'FRPI1657', 0),
(0, 'Varessia', 'France', 'Europe', 'FRFC1332', 0),
(0, 'Varetz', 'France', 'Europe', 'FRXX1834', 0),
(0, 'Varilhes', 'France', 'Europe', 'FRMP2407', 0),
(0, 'Ambenay', 'France', 'Europe', 'FRHN0004', 0),
(0, 'Amberac', 'France', 'Europe', 'FRPC0015', 0),
(0, 'Ambernac', 'France', 'Europe', 'FRPC0016', 0),
(0, 'Amberre', 'France', 'Europe', 'FRPC0017', 0),
(0, 'Ambes', 'France', 'Europe', 'FRXX2836', 0),
(0, 'Ambialet', 'France', 'Europe', 'FRMP0030', 0),
(0, 'Ambiegna', 'France', 'Europe', 'FRCO0006', 0),
(0, 'Ambierle', 'France', 'Europe', 'FRXX3382', 0),
(0, 'Ambievillers', 'France', 'Europe', 'FRLO0021', 0),
(0, 'Ambillou', 'France', 'Europe', 'FRCE0007', 0),
(0, 'Ambilly', 'France', 'Europe', 'FRRA0033', 0),
(0, 'Amblaincourt', 'France', 'Europe', 'FRLO0022', 0),
(0, 'Amblainville', 'France', 'Europe', 'FRPI0025', 0),
(0, 'Ambleny', 'France', 'Europe', 'FRPI0026', 0),
(0, 'Ambleon', 'France', 'Europe', 'FRRA0034', 0),
(0, 'Ambleteuse', 'France', 'Europe', 'FRXX4205', 0),
(0, 'Ambleville', 'France', 'Europe', 'FRIF0006', 0),
(0, 'Ambleville', 'France', 'Europe', 'FRPC0018', 0),
(0, 'Amblie', 'France', 'Europe', 'FRBN0010', 0),
(0, 'Amblimont', 'France', 'Europe', 'FRCA0015', 0),
(0, 'Ambloy', 'France', 'Europe', 'FRCE0008', 0),
(0, 'Amboise', 'France', 'Europe', 'FRXX0349', 0),
(0, 'Ambonil', 'France', 'Europe', 'FRRA0035', 0),
(0, 'Ambonnay', 'France', 'Europe', 'FRCA0016', 0),
(0, 'Ambonville', 'France', 'Europe', 'FRCA0017', 0),
(0, 'Ambourville', 'France', 'Europe', 'FRHN0005', 0),
(0, 'Ambres', 'France', 'Europe', 'FRMP0031', 0),
(0, 'Ambricourt', 'France', 'Europe', 'FRNC0017', 0),
(0, 'Ambrief', 'France', 'Europe', 'FRPI0027', 0),
(0, 'Ambrieres', 'France', 'Europe', 'FRCA0018', 0),
(0, 'Ambrines', 'France', 'Europe', 'FRNC0018', 0),
(0, 'Ambronay', 'France', 'Europe', 'FRRA0036', 0),
(0, 'Ambrugeat', 'France', 'Europe', 'FRLI0012', 0),
(0, 'Ambrumesnil', 'France', 'Europe', 'FRHN0006', 0),
(0, 'Ambutrix', 'France', 'Europe', 'FRRA0037', 0),
(0, 'Amecourt', 'France', 'Europe', 'FRHN0007', 0),
(0, 'Amelecourt', 'France', 'Europe', 'FRLO0023', 0),
(0, 'Amenoncourt', 'France', 'Europe', 'FRLO0024', 0),
(0, 'Amenucourt', 'France', 'Europe', 'FRIF0007', 0),
(0, 'Ames', 'France', 'Europe', 'FRNC0019', 0),
(0, 'Amettes', 'France', 'Europe', 'FRNC0020', 0),
(0, 'Ameuvelle', 'France', 'Europe', 'FRLO0025', 0),
(0, 'Amfreville', 'France', 'Europe', 'FRBN0011', 0),
(0, 'Amfreville', 'France', 'Europe', 'FRBN0012', 0),
(0, 'Amfreville-la-Mi-Voie', 'France', 'Europe', 'FRXX2133', 0),
(0, 'Amfroipret', 'France', 'Europe', 'FRNC0021', 0),
(0, 'Amiens', 'France', 'Europe', 'FRXX0269', 0),
(0, 'Amifontaine', 'France', 'Europe', 'FRPI0028', 0),
(0, 'Amigny', 'France', 'Europe', 'FRBN0013', 0),
(0, 'Amigny-Rouy', 'France', 'Europe', 'FRPI0029', 0),
(0, 'Amillis', 'France', 'Europe', 'FRIF0008', 0),
(0, 'Amilly', 'France', 'Europe', 'FRCE0009', 0),
(0, 'Amilly', 'France', 'Europe', 'FRCE0010', 0),
(0, 'Amions', 'France', 'Europe', 'FRRA0038', 0),
(0, 'Amirat', 'France', 'Europe', 'FRPA0009', 0),
(0, 'Ammerschwihr', 'France', 'Europe', 'FRXX4148', 0),
(0, 'Ammeville', 'France', 'Europe', 'FRBN0014', 0),
(0, 'Amneville', 'France', 'Europe', 'FRXX1950', 0),
(0, 'Amoncourt', 'France', 'Europe', 'FRFC0028', 0),
(0, 'Amondans', 'France', 'Europe', 'FRFC0029', 0),
(0, 'Amont-et-Effreney', 'France', 'Europe', 'FRFC0030', 0),
(0, 'Amou', 'France', 'Europe', 'FRAQ0014', 0),
(0, 'Ampilly-les-Bordes', 'France', 'Europe', 'FRBO0013', 0),
(0, 'Amplaing', 'France', 'Europe', 'FRMP0032', 0),
(0, 'Amplepuis', 'France', 'Europe', 'FRRA0039', 0),
(0, 'Amplier', 'France', 'Europe', 'FRNC0022', 0),
(0, 'Ampoigne', 'France', 'Europe', 'FRPL0004', 0),
(0, 'Amponville', 'France', 'Europe', 'FRIF0009', 0),
(0, 'Ampriani', 'France', 'Europe', 'FRCO0007', 0),
(0, 'Ampuis', 'France', 'Europe', 'FRRA0040', 0),
(0, 'Ampus', 'France', 'Europe', 'FRXX6432', 0),
(0, 'Amure', 'France', 'Europe', 'FRPC0019', 0),
(0, 'Anaa', 'France', 'Europe', 'FRXX7899', 0),
(0, 'Anais', 'France', 'Europe', 'FRPC0020', 0),
(0, 'Anais', 'France', 'Europe', 'FRPC0021', 0),
(0, 'Anan', 'France', 'Europe', 'FRMP0033', 0),
(0, 'Ance', 'France', 'Europe', 'FRAQ0015', 0),
(0, 'Anceaumeville', 'France', 'Europe', 'FRHN0008', 0),
(0, 'Anceins', 'France', 'Europe', 'FRBN0015', 0),
(0, 'Ancelle', 'France', 'Europe', 'FRXX0453', 0),
(0, 'Baugy', 'France', 'Europe', 'FRBO0064', 0),
(0, 'Baugy', 'France', 'Europe', 'FRCE0045', 0),
(0, 'Baugy', 'France', 'Europe', 'FRPI0104', 0),
(0, 'Baulay', 'France', 'Europe', 'FRFC0102', 0),
(0, 'Baule', 'France', 'Europe', 'FRCE0046', 0),
(0, 'Baulne', 'France', 'Europe', 'FRIF0042', 0),
(0, 'Baulny', 'France', 'Europe', 'FRLO0106', 0),
(0, 'Baulou', 'France', 'Europe', 'FRMP0189', 0),
(0, 'Baune', 'France', 'Europe', 'FRPL0040', 0),
(0, 'Baupte', 'France', 'Europe', 'FRBN0059', 0),
(0, 'Bauvin', 'France', 'Europe', 'FRXX4854', 0),
(0, 'Bauzemont', 'France', 'Europe', 'FRLO0107', 0),
(0, 'Bauzy', 'France', 'Europe', 'FRCE0047', 0),
(0, 'Bavans', 'France', 'Europe', 'FRFC0103', 0),
(0, 'Bavelincourt', 'France', 'Europe', 'FRPI0105', 0),
(0, 'Bavent', 'France', 'Europe', 'FRBN0060', 0),
(0, 'Baverans', 'France', 'Europe', 'FRFC0104', 0),
(0, 'Bavilliers', 'France', 'Europe', 'FRMP0190', 0),
(0, 'Bavincourt', 'France', 'Europe', 'FRNC0079', 0),
(0, 'Bax', 'France', 'Europe', 'FRMP0191', 0),
(0, 'Bay', 'France', 'Europe', 'FRFC0105', 0),
(0, 'Bay', 'France', 'Europe', 'FRPI0106', 0),
(0, 'Bayac', 'France', 'Europe', 'FRAQ0119', 0),
(0, 'Bayard-sur-Marne', 'France', 'Europe', 'FRCA0091', 0),
(0, 'Bayas', 'France', 'Europe', 'FRAQ0120', 0),
(0, 'Baye', 'France', 'Europe', 'FRCA0092', 0),
(0, 'Bayecourt', 'France', 'Europe', 'FRLO0108', 0),
(0, 'Bayel', 'France', 'Europe', 'FRCA0093', 0),
(0, 'Bayencourt', 'France', 'Europe', 'FRNC0080', 0),
(0, 'Bayers', 'France', 'Europe', 'FRPC0073', 0),
(0, 'Bayet', 'France', 'Europe', 'FRAU0043', 0),
(0, 'Bayeux', 'France', 'Europe', 'FRXX0010', 0),
(0, 'Bayon', 'France', 'Europe', 'FRLO0109', 0),
(0, 'Bayon-sur-Gironde', 'France', 'Europe', 'FRAQ0121', 0),
(0, 'Bayonne', 'France', 'Europe', 'FRXX1891', 0),
(0, 'Bayons', 'France', 'Europe', 'FRPA0044', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Bayonvillers', 'France', 'Europe', 'FRPI0107', 0),
(0, 'Bazac', 'France', 'Europe', 'FRAQ0122', 0),
(0, 'Bazailles', 'France', 'Europe', 'FRLO0110', 0),
(0, 'Bazainville', 'France', 'Europe', 'FRIF0043', 0),
(0, 'Bazancourt', 'France', 'Europe', 'FRCA0094', 0),
(0, 'Bazancourt', 'France', 'Europe', 'FRPI0108', 0),
(0, 'Bazarnes', 'France', 'Europe', 'FRBO0065', 0),
(0, 'Bazas', 'France', 'Europe', 'FRXX0324', 0),
(0, 'Bazauges', 'France', 'Europe', 'FRPC0074', 0),
(0, 'Bazegney', 'France', 'Europe', 'FRLO0111', 0),
(0, 'Bazelat', 'France', 'Europe', 'FRLI0029', 0),
(0, 'Bazemont', 'France', 'Europe', 'FRIF0044', 0),
(0, 'Bazens', 'France', 'Europe', 'FRAQ0123', 0),
(0, 'Bazentin', 'France', 'Europe', 'FRPI0109', 0),
(0, 'Bazenville', 'France', 'Europe', 'FRBN0061', 0),
(0, 'Bazet', 'France', 'Europe', 'FRXX1383', 0),
(0, 'Bazian', 'France', 'Europe', 'FRMP0192', 0),
(0, 'Bazicourt', 'France', 'Europe', 'FRPI0110', 0),
(0, 'Baziege', 'France', 'Europe', 'FRMP0193', 0),
(0, 'Bazien', 'France', 'Europe', 'FRLO0112', 0),
(0, 'Bazillac', 'France', 'Europe', 'FRMP0194', 0),
(0, 'Bazinghen', 'France', 'Europe', 'FRNC0081', 0),
(0, 'Bazinval', 'France', 'Europe', 'FRHN0032', 0),
(0, 'Bazoches', 'France', 'Europe', 'FRBO0066', 0),
(0, 'Bazolles', 'France', 'Europe', 'FRBO0067', 0),
(0, 'Bazoncourt', 'France', 'Europe', 'FRLO0113', 0),
(0, 'Bazoques', 'France', 'Europe', 'FRHN0033', 0),
(0, 'Bazordan', 'France', 'Europe', 'FRMP0195', 0),
(0, 'Bazougers', 'France', 'Europe', 'FRPL0041', 0),
(0, 'Bazugues', 'France', 'Europe', 'FRMP0196', 0),
(0, 'Bazus', 'France', 'Europe', 'FRMP0197', 0),
(0, 'Bealcourt', 'France', 'Europe', 'FRPI0111', 0),
(0, 'Bealencourt', 'France', 'Europe', 'FRNC0082', 0),
(0, 'Beard', 'France', 'Europe', 'FRBO0068', 0),
(0, 'Beaubery', 'France', 'Europe', 'FRBO0069', 0),
(0, 'Beaubray', 'France', 'Europe', 'FRHN0034', 0),
(0, 'Beaucamps-Ligny', 'France', 'Europe', 'FRNC0083', 0),
(0, 'Beaucens', 'France', 'Europe', 'FRMP0198', 0),
(0, 'Beauchalot', 'France', 'Europe', 'FRMP0199', 0),
(0, 'Beauchamp', 'France', 'Europe', 'FRXX5378', 0),
(0, 'Beauchamps', 'France', 'Europe', 'FRBN0062', 0),
(0, 'Beauchamps', 'France', 'Europe', 'FRXX5207', 0),
(0, 'Beaucharmoy', 'France', 'Europe', 'FRCA0095', 0),
(0, 'Beauchastel', 'France', 'Europe', 'FRRA0130', 0),
(0, 'Cassagnas', 'France', 'Europe', 'FRLR0132', 0),
(0, 'Cassagne', 'France', 'Europe', 'FRMP0435', 0),
(0, 'Cassagnes', 'France', 'Europe', 'FRMP0436', 0),
(0, 'Cassagnoles', 'France', 'Europe', 'FRLR0133', 0),
(0, 'Cassagnoles', 'France', 'Europe', 'FRLR0134', 0),
(0, 'Cassaigne', 'France', 'Europe', 'FRMP0437', 0),
(0, 'Cassaignes', 'France', 'Europe', 'FRLR0135', 0),
(0, 'Cassano', 'France', 'Europe', 'FRCO0046', 0),
(0, 'Cassen', 'France', 'Europe', 'FRAQ0271', 0),
(0, 'Casseneuil', 'France', 'Europe', 'FRAQ0272', 0),
(0, 'Casseuil', 'France', 'Europe', 'FRAQ0273', 0),
(0, 'Cassignas', 'France', 'Europe', 'FRAQ0274', 0),
(0, 'Cassis', 'France', 'Europe', 'FRXX2469', 0),
(0, 'Cassuejouls', 'France', 'Europe', 'FRMP0438', 0),
(0, 'Casta', 'France', 'Europe', 'FRCO0047', 0),
(0, 'Castagnede', 'France', 'Europe', 'FRAQ0275', 0),
(0, 'Castagnede', 'France', 'Europe', 'FRMP0439', 0),
(0, 'Castagniers', 'France', 'Europe', 'FRPA0098', 0),
(0, 'Castandet', 'France', 'Europe', 'FRAQ0276', 0),
(0, 'Castanet', 'France', 'Europe', 'FRMP0440', 0),
(0, 'Castanet', 'France', 'Europe', 'FRMP0441', 0),
(0, 'Castanet', 'France', 'Europe', 'FRMP0442', 0),
(0, 'Castans', 'France', 'Europe', 'FRLR0136', 0),
(0, 'Castel-Sarrazin', 'France', 'Europe', 'FRAQ0277', 0),
(0, 'Castelbajac', 'France', 'Europe', 'FRMP0443', 0),
(0, 'Castelbiague', 'France', 'Europe', 'FRMP0444', 0),
(0, 'Castelculier', 'France', 'Europe', 'FRAQ0278', 0),
(0, 'Castelferrus', 'France', 'Europe', 'FRMP0445', 0),
(0, 'Castelfranc', 'France', 'Europe', 'FRMP0446', 0),
(0, 'Castelgaillard', 'France', 'Europe', 'FRMP0447', 0),
(0, 'Castelginest', 'France', 'Europe', 'FRXX5185', 0),
(0, 'Casteljaloux', 'France', 'Europe', 'FRXX0319', 0),
(0, 'Casteljau', 'France', 'Europe', 'FRRA0247', 0),
(0, 'Castella', 'France', 'Europe', 'FRAQ0279', 0),
(0, 'Castellane', 'France', 'Europe', 'FRXX0365', 0),
(0, 'Castellar', 'France', 'Europe', 'FRPA0099', 0),
(0, 'Castellet', 'France', 'Europe', 'FRPA0100', 0),
(0, 'Castello-di-Rostino', 'France', 'Europe', 'FRCO0048', 0),
(0, 'Castelmary', 'France', 'Europe', 'FRMP0448', 0),
(0, 'Castelmaurou', 'France', 'Europe', 'FRMP0449', 0),
(0, 'Castelmayran', 'France', 'Europe', 'FRMP0450', 0),
(0, 'Castelnau-d`Auzan', 'France', 'Europe', 'FRXX4333', 0),
(0, 'Castelnau-de-Medoc', 'France', 'Europe', 'FRXX0027', 0),
(0, 'Castelnau-le-Lez', 'France', 'Europe', 'FRXX3613', 0),
(0, 'Castelnau-sur-Gupie', 'France', 'Europe', 'FRXX3860', 0),
(0, 'Castelnau-Tursan', 'France', 'Europe', 'FRAQ0280', 0),
(0, 'Castelnau-Valence', 'France', 'Europe', 'FRLR0137', 0),
(0, 'Castelnaudary', 'France', 'Europe', 'FRXX0330', 0),
(0, 'Castelnavet', 'France', 'Europe', 'FRMP0451', 0),
(0, 'Castelner', 'France', 'Europe', 'FRAQ0281', 0),
(0, 'Castelreng', 'France', 'Europe', 'FRLR0138', 0),
(0, 'Castels', 'France', 'Europe', 'FRAQ0282', 0),
(0, 'Castera-Lou', 'France', 'Europe', 'FRMP0452', 0),
(0, 'Casterets', 'France', 'Europe', 'FRMP0453', 0),
(0, 'Casteron', 'France', 'Europe', 'FRMP0454', 0),
(0, 'Castet', 'France', 'Europe', 'FRAQ0283', 0),
(0, 'Castet-Arrouy', 'France', 'Europe', 'FRMP0455', 0),
(0, 'Castetbon', 'France', 'Europe', 'FRAQ0284', 0),
(0, 'Castetis', 'France', 'Europe', 'FRAQ0285', 0),
(0, 'Castetner', 'France', 'Europe', 'FRAQ0286', 0),
(0, 'Castetpugon', 'France', 'Europe', 'FRAQ0287', 0),
(0, 'Castex', 'France', 'Europe', 'FRMP0456', 0),
(0, 'Castex', 'France', 'Europe', 'FRMP0457', 0),
(0, 'Castex-d`Armagnac', 'France', 'Europe', 'FRMP0458', 0),
(0, 'Castifao', 'France', 'Europe', 'FRCO0049', 0),
(0, 'Castiglione', 'France', 'Europe', 'FRCO0050', 0),
(0, 'Castillon', 'France', 'Europe', 'FRBN0183', 0),
(0, 'Castillon', 'France', 'Europe', 'FRMP0459', 0),
(0, 'Castillonnes', 'France', 'Europe', 'FRAQ0288', 0),
(0, 'Castin', 'France', 'Europe', 'FRMP0460', 0),
(0, 'Castineta', 'France', 'Europe', 'FRCO0051', 0),
(0, 'Castirla', 'France', 'Europe', 'FRCO0052', 0),
(0, 'Castres', 'France', 'Europe', 'FRXX0331', 0),
(0, 'Castries', 'France', 'Europe', 'FRLR0139', 0),
(0, 'Catenay', 'France', 'Europe', 'FRHN0122', 0),
(0, 'Catenoy', 'France', 'Europe', 'FRPI0289', 0),
(0, 'Cateri', 'France', 'Europe', 'FRCO0053', 0),
(0, 'Catheux', 'France', 'Europe', 'FRPI0290', 0),
(0, 'Catigny', 'France', 'Europe', 'FRPI0291', 0),
(0, 'Catonvielle', 'France', 'Europe', 'FRMP0461', 0),
(0, 'Dommartin', 'France', 'Europe', 'FRPI0460', 0),
(0, 'Dommartin', 'France', 'Europe', 'FRRA0489', 0),
(0, 'Dommartin', 'France', 'Europe', 'FRRA0490', 0),
(0, 'Dommartin-Lettree', 'France', 'Europe', 'FRCA0371', 0),
(0, 'Dommartin-sous-Amance', 'France', 'Europe', 'FRLO0384', 0),
(0, 'Dommartin-sous-Hans', 'France', 'Europe', 'FRCA0372', 0),
(0, 'Dommery', 'France', 'Europe', 'FRCA0373', 0),
(0, 'Dommiers', 'France', 'Europe', 'FRPI0461', 0),
(0, 'Domnon-les-Dieuze', 'France', 'Europe', 'FRLO0385', 0),
(0, 'Domont', 'France', 'Europe', 'FRXX6093', 0),
(0, 'Dompcevrin', 'France', 'Europe', 'FRLO0386', 0),
(0, 'Dompierre', 'France', 'Europe', 'FRBN0309', 0),
(0, 'Dompierre', 'France', 'Europe', 'FRLO0387', 0),
(0, 'Dompierre', 'France', 'Europe', 'FRPI0462', 0),
(0, 'Dompierre-Becquincourt', 'France', 'Europe', 'FRXX5208', 0),
(0, 'Dompierre-les-Ormes', 'France', 'Europe', 'FRXX6717', 0),
(0, 'Dompierre-sur-Mer', 'France', 'Europe', 'FRXX2346', 0),
(0, 'Dompnac', 'France', 'Europe', 'FRRA0491', 0),
(0, 'Domprel', 'France', 'Europe', 'FRFC0403', 0),
(0, 'Dompremy', 'France', 'Europe', 'FRCA0374', 0),
(0, 'Domprix', 'France', 'Europe', 'FRLO0388', 0),
(0, 'Domps', 'France', 'Europe', 'FRLI0114', 0),
(0, 'Domptail', 'France', 'Europe', 'FRLO0389', 0),
(0, 'Domptin', 'France', 'Europe', 'FRPI0463', 0),
(0, 'Domqueur', 'France', 'Europe', 'FRPI0464', 0),
(0, 'Domremy-la-Canne', 'France', 'Europe', 'FRLO0390', 0),
(0, 'Domsure', 'France', 'Europe', 'FRRA0492', 0),
(0, 'Domvallier', 'France', 'Europe', 'FRLO0391', 0),
(0, 'Domvast', 'France', 'Europe', 'FRPI0465', 0),
(0, 'Don', 'France', 'Europe', 'FRXX4405', 0),
(0, 'Donazac', 'France', 'Europe', 'FRLR0214', 0),
(0, 'Donchery', 'France', 'Europe', 'FRCA0375', 0),
(0, 'Doncieres', 'France', 'Europe', 'FRLO0392', 0),
(0, 'Dondas', 'France', 'Europe', 'FRAQ0384', 0),
(0, 'Donges', 'France', 'Europe', 'FRXX4988', 0),
(0, 'Donjeux', 'France', 'Europe', 'FRCA0376', 0),
(0, 'Donjeux', 'France', 'Europe', 'FRLO0393', 0),
(0, 'Donnay', 'France', 'Europe', 'FRBN0310', 0),
(0, 'Donnazac', 'France', 'Europe', 'FRMP0605', 0),
(0, 'Donnelay', 'France', 'Europe', 'FRLO0394', 0),
(0, 'Donnemarie', 'France', 'Europe', 'FRCA0377', 0),
(0, 'Donnement', 'France', 'Europe', 'FRCA0378', 0),
(0, 'Donnery', 'France', 'Europe', 'FRCE0276', 0),
(0, 'Donneville', 'France', 'Europe', 'FRMP0606', 0),
(0, 'Donnezac', 'France', 'Europe', 'FRAQ0385', 0),
(0, 'Dontreix', 'France', 'Europe', 'FRLI0115', 0),
(0, 'Dontrien', 'France', 'Europe', 'FRCA0379', 0),
(0, 'Donville-les-Bains', 'France', 'Europe', 'FRXX5855', 0),
(0, 'Donzac', 'France', 'Europe', 'FRAQ0386', 0),
(0, 'Donzacq', 'France', 'Europe', 'FRAQ0387', 0),
(0, 'Donzenac', 'France', 'Europe', 'FRLI0116', 0),
(0, 'Donzere', 'France', 'Europe', 'FRRA0493', 0),
(0, 'Donzy-le-National', 'France', 'Europe', 'FRXX5268', 0),
(0, 'Doranges', 'France', 'Europe', 'FRAU0210', 0),
(0, 'Dorans', 'France', 'Europe', 'FRMP0607', 0),
(0, 'Dorat', 'France', 'Europe', 'FRAU0211', 0),
(0, 'Dorceau', 'France', 'Europe', 'FRBN0311', 0),
(0, 'Dordives', 'France', 'Europe', 'FRXX1985', 0),
(0, 'Dorignies', 'France', 'Europe', 'FRXX5058', 0),
(0, 'Dormans', 'France', 'Europe', 'FRCA0380', 0),
(0, 'Dormelles', 'France', 'Europe', 'FRIF0171', 0),
(0, 'Dornas', 'France', 'Europe', 'FRRA0494', 0),
(0, 'Dornecy', 'France', 'Europe', 'FRXX1470', 0),
(0, 'Dornes', 'France', 'Europe', 'FRXX2899', 0),
(0, 'Dornot', 'France', 'Europe', 'FRLO0395', 0),
(0, 'Dorres', 'France', 'Europe', 'FRLR0215', 0),
(0, 'Dortan', 'France', 'Europe', 'FRRA0495', 0),
(0, 'Dosches', 'France', 'Europe', 'FRCA0381', 0),
(0, 'Dosnon', 'France', 'Europe', 'FRCA0382', 0),
(0, 'Dossainville', 'France', 'Europe', 'FRCE0277', 0),
(0, 'Douains', 'France', 'Europe', 'FRHN0181', 0),
(0, 'Douaumont', 'France', 'Europe', 'FRLO0396', 0),
(0, 'Doubs', 'France', 'Europe', 'FRFC0404', 0),
(0, 'Doucelles', 'France', 'Europe', 'FRPL0199', 0),
(0, 'Douchapt', 'France', 'Europe', 'FRAQ0388', 0),
(0, 'Douchy', 'France', 'Europe', 'FRCE0278', 0),
(0, 'Douchy', 'France', 'Europe', 'FRPI0466', 0),
(0, 'Doucier', 'France', 'Europe', 'FRFC0405', 0),
(0, 'Doucy', 'France', 'Europe', 'FRRA0496', 0),
(0, 'Doudeauville', 'France', 'Europe', 'FRHN0182', 0),
(0, 'Ergny', 'France', 'Europe', 'FRNC0306', 0),
(0, 'Ergue-Gaberic', 'France', 'Europe', 'FRXX1761', 0),
(0, 'Erin', 'France', 'Europe', 'FRNC0307', 0),
(0, 'Eringes', 'France', 'Europe', 'FRBO0389', 0),
(0, 'Eringhem', 'France', 'Europe', 'FRNC0308', 0),
(0, 'Eriseul', 'France', 'Europe', 'FRCA0412', 0),
(0, 'Erlon', 'France', 'Europe', 'FRPI0506', 0),
(0, 'Erloy', 'France', 'Europe', 'FRPI0507', 0),
(0, 'Ermenouville', 'France', 'Europe', 'FRHN0210', 0),
(0, 'Ermont', 'France', 'Europe', 'FRXX2375', 0),
(0, 'Ernee', 'France', 'Europe', 'FRPL0210', 0),
(0, 'Ernemont-la-Villette', 'France', 'Europe', 'FRHN0211', 0),
(0, 'Ernes', 'France', 'Europe', 'FRBN0337', 0),
(0, 'Erneville-aux-Bois', 'France', 'Europe', 'FRLO0417', 0),
(0, 'Erome', 'France', 'Europe', 'FRRA0528', 0),
(0, 'Erondelle', 'France', 'Europe', 'FRPI0508', 0),
(0, 'Erone', 'France', 'Europe', 'FRCO0064', 0),
(0, 'Eroudeville', 'France', 'Europe', 'FRBN0338', 0),
(0, 'Erp', 'France', 'Europe', 'FRMP0639', 0),
(0, 'Erquery', 'France', 'Europe', 'FRPI0509', 0),
(0, 'Erquieres', 'France', 'Europe', 'FRNC0309', 0),
(0, 'Erquinghem-Lys', 'France', 'Europe', 'FRXX3338', 0),
(0, 'Erquinvillers', 'France', 'Europe', 'FRPI0510', 0),
(0, 'Errevet', 'France', 'Europe', 'FRFC0437', 0),
(0, 'Errouville', 'France', 'Europe', 'FRLO0418', 0),
(0, 'Ersa', 'France', 'Europe', 'FRXX4079', 0),
(0, 'Erstroff', 'France', 'Europe', 'FRLO0419', 0),
(0, 'Ervauville', 'France', 'Europe', 'FRCE0299', 0),
(0, 'Ervillers', 'France', 'Europe', 'FRNC0310', 0),
(0, 'Esbareich', 'France', 'Europe', 'FRMP0640', 0),
(0, 'Esbarres', 'France', 'Europe', 'FRBO0390', 0),
(0, 'Esbly', 'France', 'Europe', 'FRIF0182', 0),
(0, 'Escala', 'France', 'Europe', 'FRMP0641', 0),
(0, 'Escalans', 'France', 'Europe', 'FRAQ0400', 0),
(0, 'Escales', 'France', 'Europe', 'FRLR0219', 0),
(0, 'Escalles', 'France', 'Europe', 'FRNC0311', 0),
(0, 'Escalquens', 'France', 'Europe', 'FRXX6625', 0),
(0, 'Escames', 'France', 'Europe', 'FRPI0511', 0),
(0, 'Escamps', 'France', 'Europe', 'FRBO0391', 0),
(0, 'Escamps', 'France', 'Europe', 'FRMP0642', 0),
(0, 'Escandolieres', 'France', 'Europe', 'FRMP0643', 0),
(0, 'Escanecrabe', 'France', 'Europe', 'FRMP0644', 0),
(0, 'Escardes', 'France', 'Europe', 'FRCA0413', 0),
(0, 'Escarmain', 'France', 'Europe', 'FRNC0312', 0),
(0, 'Escassefort', 'France', 'Europe', 'FRAQ0401', 0),
(0, 'Escatalens', 'France', 'Europe', 'FRMP0645', 0),
(0, 'Escaudain', 'France', 'Europe', 'FRXX2773', 0),
(0, 'Escaudes', 'France', 'Europe', 'FRAQ0402', 0),
(0, 'Escaudoeuvres', 'France', 'Europe', 'FRNC0313', 0),
(0, 'Escaunets', 'France', 'Europe', 'FRMP0646', 0),
(0, 'Escautpont', 'France', 'Europe', 'FRXX2848', 0),
(0, 'Escazeaux', 'France', 'Europe', 'FRMP0647', 0),
(0, 'Eschau', 'France', 'Europe', 'FRXX1400', 0),
(0, 'Eschbach', 'France', 'Europe', 'FRAL0117', 0),
(0, 'Eschbourg', 'France', 'Europe', 'FRAL0118', 0),
(0, 'Eschentzwiller', 'France', 'Europe', 'FRAL0119', 0),
(0, 'Escherange', 'France', 'Europe', 'FRLO0420', 0),
(0, 'Esches', 'France', 'Europe', 'FRPI0512', 0),
(0, 'Eschwiller', 'France', 'Europe', 'FRAL0120', 0),
(0, 'Esclagne', 'France', 'Europe', 'FRMP0648', 0),
(0, 'Esclainvillers', 'France', 'Europe', 'FRPI0513', 0),
(0, 'Esclanedes', 'France', 'Europe', 'FRLR0220', 0),
(0, 'Esclangon', 'France', 'Europe', 'FRPA0164', 0),
(0, 'Esclassan-Labastide', 'France', 'Europe', 'FRMP0649', 0),
(0, 'Esclavelles', 'France', 'Europe', 'FRHN0212', 0),
(0, 'Esclavolles-Lurey', 'France', 'Europe', 'FRCA0414', 0),
(0, 'Escles', 'France', 'Europe', 'FRLO0421', 0),
(0, 'Esclottes', 'France', 'Europe', 'FRAQ0403', 0),
(0, 'Escobecques', 'France', 'Europe', 'FRNC0314', 0),
(0, 'Escoeuilles', 'France', 'Europe', 'FRNC0315', 0),
(0, 'Escoire', 'France', 'Europe', 'FRAQ0404', 0),
(0, 'Escondeaux', 'France', 'Europe', 'FRMP0650', 0),
(0, 'Escorailles', 'France', 'Europe', 'FRAU0224', 0),
(0, 'Escorneboeuf', 'France', 'Europe', 'FRMP0651', 0),
(0, 'Escorpain', 'France', 'Europe', 'FRCE0300', 0),
(0, 'Escosse', 'France', 'Europe', 'FRMP0652', 0),
(0, 'Escot', 'France', 'Europe', 'FRAQ0405', 0),
(0, 'Escots', 'France', 'Europe', 'FRMP0653', 0),
(0, 'Escou', 'France', 'Europe', 'FRAQ0406', 0),
(0, 'Escoubes', 'France', 'Europe', 'FRAQ0407', 0),
(0, 'Fleure', 'France', 'Europe', 'FRBN0361', 0),
(0, 'Fleure', 'France', 'Europe', 'FRPC0327', 0),
(0, 'Fleurey', 'France', 'Europe', 'FRFC0475', 0),
(0, 'Fleurie', 'France', 'Europe', 'FRRA0575', 0),
(0, 'Fleuriel', 'France', 'Europe', 'FRAU0241', 0),
(0, 'Fleurigny', 'France', 'Europe', 'FRBO0416', 0),
(0, 'Fleurines', 'France', 'Europe', 'FRPI0566', 0),
(0, 'Fleurville', 'France', 'Europe', 'FRBO0417', 0),
(0, 'Fleury', 'France', 'Europe', 'FRBN0362', 0),
(0, 'Fleury', 'France', 'Europe', 'FRLO0463', 0),
(0, 'Fleury', 'France', 'Europe', 'FRNC0357', 0),
(0, 'Fleury', 'France', 'Europe', 'FRPI0567', 0),
(0, 'Fleury', 'France', 'Europe', 'FRPI0568', 0),
(0, 'Fleury', 'France', 'Europe', 'FRPI0569', 0),
(0, 'Fleury', 'France', 'Europe', 'FRXX5390', 0),
(0, 'Fleury-devant-Douaumont', 'France', 'Europe', 'FRLO0464', 0),
(0, 'Fleury-Merogis', 'France', 'Europe', 'FRIF0195', 0),
(0, 'Fleville', 'France', 'Europe', 'FRCA0450', 0),
(0, 'Flevy', 'France', 'Europe', 'FRLO0465', 0),
(0, 'Flexanville', 'France', 'Europe', 'FRIF0196', 0),
(0, 'Flexbourg', 'France', 'Europe', 'FRAL0130', 0),
(0, 'Fley', 'France', 'Europe', 'FRBO0418', 0),
(0, 'Fleys', 'France', 'Europe', 'FRBO0419', 0),
(0, 'Flez-Cuzy', 'France', 'Europe', 'FRBO0420', 0),
(0, 'Fligny', 'France', 'Europe', 'FRCA0451', 0),
(0, 'Flin', 'France', 'Europe', 'FRLO0466', 0),
(0, 'Flines-lez-Raches', 'France', 'Europe', 'FRXX2166', 0),
(0, 'Flipou', 'France', 'Europe', 'FRHN0230', 0),
(0, 'Flirey', 'France', 'Europe', 'FRLO0467', 0),
(0, 'Flize', 'France', 'Europe', 'FRCA0452', 0),
(0, 'Flocourt', 'France', 'Europe', 'FRLO0468', 0),
(0, 'Flocques', 'France', 'Europe', 'FRHN0231', 0),
(0, 'Flogny-la-Chapelle', 'France', 'Europe', 'FRBO0421', 0),
(0, 'Floing', 'France', 'Europe', 'FRCA0453', 0),
(0, 'Floirac', 'France', 'Europe', 'FRMP0720', 0),
(0, 'Floirac', 'France', 'Europe', 'FRPC0328', 0),
(0, 'Floirac', 'France', 'Europe', 'FRXX4321', 0),
(0, 'Florac', 'France', 'Europe', 'FRLR0238', 0),
(0, 'Florange', 'France', 'Europe', 'FRXX4858', 0),
(0, 'Floremont', 'France', 'Europe', 'FRLO0469', 0),
(0, 'Florensac', 'France', 'Europe', 'FRXX1866', 0),
(0, 'Florentia', 'France', 'Europe', 'FRFC0476', 0),
(0, 'Florentin', 'France', 'Europe', 'FRMP0721', 0),
(0, 'Floressas', 'France', 'Europe', 'FRMP0722', 0),
(0, 'Florimont', 'France', 'Europe', 'FRMP0723', 0),
(0, 'Floringhem', 'France', 'Europe', 'FRNC0358', 0),
(0, 'Flornoy', 'France', 'Europe', 'FRCA0454', 0),
(0, 'Flottemanville', 'France', 'Europe', 'FRBN0363', 0),
(0, 'Floudes', 'France', 'Europe', 'FRAQ0453', 0),
(0, 'Floure', 'France', 'Europe', 'FRLR0239', 0),
(0, 'Flourens', 'France', 'Europe', 'FRMP0724', 0),
(0, 'Floursies', 'France', 'Europe', 'FRNC0359', 0),
(0, 'Floyon', 'France', 'Europe', 'FRNC0360', 0),
(0, 'Flumet', 'France', 'Europe', 'FRXX0472', 0),
(0, 'Fluquieres', 'France', 'Europe', 'FRPI0570', 0),
(0, 'Fluy', 'France', 'Europe', 'FRPI0571', 0),
(0, 'Foameix-Ornel', 'France', 'Europe', 'FRLO0470', 0),
(0, 'Foce', 'France', 'Europe', 'FRCO0069', 0),
(0, 'Focicchia', 'France', 'Europe', 'FRCO0070', 0),
(0, 'Foecy', 'France', 'Europe', 'FRCE0322', 0),
(0, 'Foisches', 'France', 'Europe', 'FRCA0455', 0),
(0, 'Foissac', 'France', 'Europe', 'FRMP0725', 0),
(0, 'Foissac', 'France', 'Europe', 'FRPA0177', 0),
(0, 'Foissiat', 'France', 'Europe', 'FRRA0576', 0),
(0, 'Foissy', 'France', 'Europe', 'FRBO0422', 0),
(0, 'Foix', 'France', 'Europe', 'FRXX0204', 0),
(0, 'Folcarde', 'France', 'Europe', 'FRMP0726', 0),
(0, 'Folelli', 'France', 'Europe', 'FRCO0071', 0),
(0, 'Folembray', 'France', 'Europe', 'FRXX1711', 0),
(0, 'Folies', 'France', 'Europe', 'FRPI0572', 0),
(0, 'Folles', 'France', 'Europe', 'FRLI0139', 0),
(0, 'Folleville', 'France', 'Europe', 'FRHN0232', 0),
(0, 'Folleville', 'France', 'Europe', 'FRPI0573', 0),
(0, 'Folligny', 'France', 'Europe', 'FRBN0364', 0),
(0, 'Fomerey', 'France', 'Europe', 'FRLO0471', 0),
(0, 'Fomperron', 'France', 'Europe', 'FRPC0329', 0),
(0, 'Foncegrive', 'France', 'Europe', 'FRBO0423', 0),
(0, 'Fonches-Fonchette', 'France', 'Europe', 'FRPI0574', 0),
(0, 'Foncine-le-Bas', 'France', 'Europe', 'FRXX6606', 0),
(0, 'Foncine-le-Haut', 'France', 'Europe', 'FRXX3659', 0),
(0, 'Gercy', 'France', 'Europe', 'FRPI0639', 0),
(0, 'Gerde', 'France', 'Europe', 'FRMP0820', 0),
(0, 'Gerderest', 'France', 'Europe', 'FRAQ0508', 0),
(0, 'Gere-Belesten', 'France', 'Europe', 'FRAQ0509', 0),
(0, 'Gergny', 'France', 'Europe', 'FRPI0640', 0),
(0, 'Gergueil', 'France', 'Europe', 'FRBO0463', 0),
(0, 'Gergy', 'France', 'Europe', 'FRXX3398', 0),
(0, 'Gerland', 'France', 'Europe', 'FRBO0464', 0),
(0, 'Germ', 'France', 'Europe', 'FRMP0821', 0),
(0, 'Germagnat', 'France', 'Europe', 'FRRA0601', 0),
(0, 'Germagny', 'France', 'Europe', 'FRBO0465', 0),
(0, 'Germaine', 'France', 'Europe', 'FRCA0484', 0),
(0, 'Germaine', 'France', 'Europe', 'FRPI0641', 0),
(0, 'Germaines', 'France', 'Europe', 'FRCA0485', 0),
(0, 'Germainville', 'France', 'Europe', 'FRCE0356', 0),
(0, 'Germainvilliers', 'France', 'Europe', 'FRCA0486', 0),
(0, 'Germay', 'France', 'Europe', 'FRCA0487', 0),
(0, 'Germefontaine', 'France', 'Europe', 'FRFC0528', 0),
(0, 'Germenay', 'France', 'Europe', 'FRBO0466', 0),
(0, 'Germignac', 'France', 'Europe', 'FRPC0355', 0),
(0, 'Germigney', 'France', 'Europe', 'FRFC0529', 0),
(0, 'Germigney', 'France', 'Europe', 'FRFC0530', 0),
(0, 'Germignonville', 'France', 'Europe', 'FRCE0357', 0),
(0, 'Germigny', 'France', 'Europe', 'FRBO0467', 0),
(0, 'Germigny', 'France', 'Europe', 'FRCA0488', 0),
(0, 'Germigny-des-Pres', 'France', 'Europe', 'FRXX4302', 0),
(0, 'Germigny-l`Eveque', 'France', 'Europe', 'FRXX5115', 0),
(0, 'Germigny-l`Exempt', 'France', 'Europe', 'FRCE0358', 0),
(0, 'Germigny-sous-Coulombs', 'France', 'Europe', 'FRXX2626', 0),
(0, 'Germigny-sur-Loire', 'France', 'Europe', 'FRBO0468', 0),
(0, 'Germinon', 'France', 'Europe', 'FRCA0489', 0),
(0, 'Germiny', 'France', 'Europe', 'FRLO0527', 0),
(0, 'Germisay', 'France', 'Europe', 'FRCA0490', 0),
(0, 'Germolles-sur-Grosne', 'France', 'Europe', 'FRBO0469', 0),
(0, 'Germond-Rouvre', 'France', 'Europe', 'FRPC0356', 0),
(0, 'Germondans', 'France', 'Europe', 'FRFC0531', 0),
(0, 'Germont', 'France', 'Europe', 'FRCA0491', 0),
(0, 'Germonville', 'France', 'Europe', 'FRLO0528', 0),
(0, 'Germs-sur-l`Oussouet', 'France', 'Europe', 'FRMP0822', 0),
(0, 'Gernelle', 'France', 'Europe', 'FRCA0492', 0),
(0, 'Gernicourt', 'France', 'Europe', 'FRPI0642', 0),
(0, 'Geronce', 'France', 'Europe', 'FRAQ0510', 0),
(0, 'Gerponville', 'France', 'Europe', 'FRHN0269', 0),
(0, 'Gerrots', 'France', 'Europe', 'FRBN0395', 0),
(0, 'Gerstheim', 'France', 'Europe', 'FRAL0153', 0),
(0, 'Gertwiller', 'France', 'Europe', 'FRAL0154', 0),
(0, 'Geruge', 'France', 'Europe', 'FRFC0532', 0),
(0, 'Gervans', 'France', 'Europe', 'FRRA0602', 0),
(0, 'Gerville', 'France', 'Europe', 'FRXX5671', 0),
(0, 'Gerville-la-Foret', 'France', 'Europe', 'FRBN0396', 0),
(0, 'Gery', 'France', 'Europe', 'FRLO0529', 0),
(0, 'Gerzat', 'France', 'Europe', 'FRXX1991', 0),
(0, 'Gesincourt', 'France', 'Europe', 'FRFC0533', 0),
(0, 'Gesnes', 'France', 'Europe', 'FRPL0242', 0),
(0, 'Gesnes-en-Argonne', 'France', 'Europe', 'FRLO0530', 0),
(0, 'Gesnes-le-Gandelin', 'France', 'Europe', 'FRPL0243', 0),
(0, 'Gespunsart', 'France', 'Europe', 'FRCA0493', 0),
(0, 'Gestas', 'France', 'Europe', 'FRAQ0511', 0),
(0, 'Geste', 'France', 'Europe', 'FRPL0244', 0),
(0, 'Gestel', 'France', 'Europe', 'FRXX1563', 0),
(0, 'Gesties', 'France', 'Europe', 'FRMP0823', 0),
(0, 'Gesvres', 'France', 'Europe', 'FRPL0245', 0),
(0, 'Gesvres-le-Chapitre', 'France', 'Europe', 'FRXX5612', 0),
(0, 'Getigne', 'France', 'Europe', 'FRXX2714', 0),
(0, 'Geu', 'France', 'Europe', 'FRMP0824', 0),
(0, 'Geudertheim', 'France', 'Europe', 'FRXX2866', 0),
(0, 'Geues-d`Oloron', 'France', 'Europe', 'FRAQ0512', 0),
(0, 'Geus-d`Arzacq', 'France', 'Europe', 'FRXX2588', 0),
(0, 'Geveze', 'France', 'Europe', 'FRXX6475', 0),
(0, 'Gevigney-et-Mercey', 'France', 'Europe', 'FRXX3461', 0),
(0, 'Geville', 'France', 'Europe', 'FRLO0531', 0),
(0, 'Gevingey', 'France', 'Europe', 'FRFC0534', 0),
(0, 'Gevresin', 'France', 'Europe', 'FRFC0535', 0),
(0, 'Gevrey-Chambertin', 'France', 'Europe', 'FRXX6798', 0),
(0, 'Gevrolles', 'France', 'Europe', 'FRBO0470', 0),
(0, 'Gevry', 'France', 'Europe', 'FRFC0536', 0),
(0, 'Gex', 'France', 'Europe', 'FRXX2607', 0),
(0, 'Geyssans', 'France', 'Europe', 'FRRA0603', 0),
(0, 'Gez', 'France', 'Europe', 'FRMP0825', 0),
(0, 'Gez-ez-Angles', 'France', 'Europe', 'FRMP0826', 0),
(0, 'Heining-les-Bouzonville', 'France', 'Europe', 'FRXX4924', 0),
(0, 'Heippes', 'France', 'Europe', 'FRLO0661', 0),
(0, 'Heiteren', 'France', 'Europe', 'FRAL0203', 0),
(0, 'Heiwiller', 'France', 'Europe', 'FRAL0204', 0),
(0, 'Helesmes', 'France', 'Europe', 'FRNC0435', 0),
(0, 'Helette', 'France', 'Europe', 'FRXX5607', 0),
(0, 'Helfaut', 'France', 'Europe', 'FRXX1333', 0),
(0, 'Helfrantzkirch', 'France', 'Europe', 'FRAL0205', 0),
(0, 'Hellean', 'France', 'Europe', 'FRBR0048', 0),
(0, 'Hellemmes-Lille', 'France', 'Europe', 'FRXX1435', 0),
(0, 'Hellenvilliers', 'France', 'Europe', 'FRHN0337', 0),
(0, 'Helleville', 'France', 'Europe', 'FRBN0444', 0),
(0, 'Hellimer', 'France', 'Europe', 'FRLO0662', 0),
(0, 'Heloup', 'France', 'Europe', 'FRBN0445', 0),
(0, 'Helstroff', 'France', 'Europe', 'FRLO0663', 0),
(0, 'Hem', 'France', 'Europe', 'FRXX4631', 0),
(0, 'Hem-Hardinval', 'France', 'Europe', 'FRPI0747', 0),
(0, 'Hem-Lenglet', 'France', 'Europe', 'FRNC0436', 0),
(0, 'Hem-Monacu', 'France', 'Europe', 'FRXX2206', 0),
(0, 'Hemevez', 'France', 'Europe', 'FRBN0446', 0),
(0, 'Hemevillers', 'France', 'Europe', 'FRPI0748', 0),
(0, 'Hemilly', 'France', 'Europe', 'FRLO0664', 0),
(0, 'Heming', 'France', 'Europe', 'FRLO0665', 0),
(0, 'Hemonstoir', 'France', 'Europe', 'FRBR0049', 0),
(0, 'Henamenil', 'France', 'Europe', 'FRLO0666', 0),
(0, 'Henanbihen', 'France', 'Europe', 'FRBR0050', 0),
(0, 'Henansal', 'France', 'Europe', 'FRBR0051', 0),
(0, 'Hendaye', 'France', 'Europe', 'FRXX1227', 0),
(0, 'Hendecourt-les-Cagnicourt', 'France', 'Europe', 'FRXX3453', 0),
(0, 'Hendecourt-les-Ransart', 'France', 'Europe', 'FRXX4945', 0),
(0, 'Henencourt', 'France', 'Europe', 'FRPI0749', 0),
(0, 'Henflingen', 'France', 'Europe', 'FRAL0206', 0),
(0, 'Hengoat', 'France', 'Europe', 'FRBR0052', 0),
(0, 'Hengwiller', 'France', 'Europe', 'FRAL0207', 0),
(0, 'Henin-Beaumont', 'France', 'Europe', 'FRXX2852', 0),
(0, 'Henin-sur-Cojeul', 'France', 'Europe', 'FRXX5866', 0),
(0, 'Heninel', 'France', 'Europe', 'FRNC0437', 0),
(0, 'Hennebont', 'France', 'Europe', 'FRXX1497', 0),
(0, 'Hennecourt', 'France', 'Europe', 'FRLO0667', 0),
(0, 'Hennemont', 'France', 'Europe', 'FRLO0668', 0),
(0, 'Henneveux', 'France', 'Europe', 'FRXX2143', 0),
(0, 'Hennezel', 'France', 'Europe', 'FRLO0669', 0),
(0, 'Hennezis', 'France', 'Europe', 'FRHN0338', 0),
(0, 'Henon', 'France', 'Europe', 'FRBR0053', 0),
(0, 'Henonville', 'France', 'Europe', 'FRXX4991', 0),
(0, 'Henouville', 'France', 'Europe', 'FRHN0339', 0),
(0, 'Henrichemont', 'France', 'Europe', 'FRXX3242', 0),
(0, 'Henridorff', 'France', 'Europe', 'FRXX6574', 0),
(0, 'Henriville', 'France', 'Europe', 'FRLO0670', 0),
(0, 'Henu', 'France', 'Europe', 'FRNC0438', 0),
(0, 'Henvic', 'France', 'Europe', 'FRBR0054', 0),
(0, 'Herange', 'France', 'Europe', 'FRLO0671', 0),
(0, 'Herbault', 'France', 'Europe', 'FRCE0389', 0),
(0, 'Herbecourt', 'France', 'Europe', 'FRPI0750', 0),
(0, 'Herbelles', 'France', 'Europe', 'FRNC0439', 0),
(0, 'Herbeuval', 'France', 'Europe', 'FRCA0565', 0),
(0, 'Herbeuville', 'France', 'Europe', 'FRLO0672', 0),
(0, 'Herbeville', 'France', 'Europe', 'FRIF0252', 0),
(0, 'Herbeviller', 'France', 'Europe', 'FRXX2340', 0),
(0, 'Herbeys', 'France', 'Europe', 'FRXX3423', 0),
(0, 'Herbignac', 'France', 'Europe', 'FRXX4987', 0),
(0, 'Herbinghen', 'France', 'Europe', 'FRNC0440', 0),
(0, 'Herbisse', 'France', 'Europe', 'FRCA0566', 0),
(0, 'Herbitzheim', 'France', 'Europe', 'FRAL0208', 0),
(0, 'Herblay', 'France', 'Europe', 'FRXX6828', 0),
(0, 'Herbsheim', 'France', 'Europe', 'FRAL0209', 0),
(0, 'Herce', 'France', 'Europe', 'FRPL0264', 0),
(0, 'Herchies', 'France', 'Europe', 'FRPI0751', 0),
(0, 'Herenguerville', 'France', 'Europe', 'FRBN0447', 0),
(0, 'Herepian', 'France', 'Europe', 'FRLR0286', 0),
(0, 'Heres', 'France', 'Europe', 'FRMP0896', 0),
(0, 'Hergnies', 'France', 'Europe', 'FRXX6735', 0),
(0, 'Hergugney', 'France', 'Europe', 'FRLO0673', 0),
(0, 'Heric', 'France', 'Europe', 'FRXX5050', 0),
(0, 'Hericourt', 'France', 'Europe', 'FRFC0585', 0),
(0, 'Hericourt', 'France', 'Europe', 'FRNC0441', 0),
(0, 'Hericourt-en-Caux', 'France', 'Europe', 'FRXX3447', 0),
(0, 'Hericourt-sur-Therain', 'France', 'Europe', 'FRPI0752', 0),
(0, 'Hericy', 'France', 'Europe', 'FRXX4896', 0),
(0, 'Herimenil', 'France', 'Europe', 'FRLO0674', 0),
(0, 'Juvancourt', 'France', 'Europe', 'FRCA0615', 0),
(0, 'Juvanze', 'France', 'Europe', 'FRCA0616', 0),
(0, 'Juvardeil', 'France', 'Europe', 'FRPL0284', 0),
(0, 'Juvelize', 'France', 'Europe', 'FRLO0750', 0),
(0, 'Juvignac', 'France', 'Europe', 'FRXX5588', 0),
(0, 'Juvigne', 'France', 'Europe', 'FRPL0285', 0),
(0, 'Juvignies', 'France', 'Europe', 'FRPI0797', 0),
(0, 'Juvigny', 'France', 'Europe', 'FRCA0617', 0),
(0, 'Juvigny', 'France', 'Europe', 'FRPI0798', 0),
(0, 'Juvigny', 'France', 'Europe', 'FRRA0702', 0),
(0, 'Juvigny-en-Perthois', 'France', 'Europe', 'FRLO0751', 0),
(0, 'Juvigny-le-Tertre', 'France', 'Europe', 'FRXX6085', 0),
(0, 'Juvigny-sous-Andaine', 'France', 'Europe', 'FRBN0477', 0),
(0, 'Juvigny-sur-Loison', 'France', 'Europe', 'FRLO0752', 0),
(0, 'Juvigny-sur-Orne', 'France', 'Europe', 'FRBN0478', 0),
(0, 'Juvigny-sur-Seulles', 'France', 'Europe', 'FRBN0479', 0),
(0, 'Juville', 'France', 'Europe', 'FRLO0753', 0),
(0, 'Juvinas', 'France', 'Europe', 'FRRA0703', 0),
(0, 'Juvincourt-et-Damary', 'France', 'Europe', 'FRPI0799', 0),
(0, 'Juvisy-sur-Orge', 'France', 'Europe', 'FRXX5986', 0),
(0, 'Juvrecourt', 'France', 'Europe', 'FRLO0754', 0),
(0, 'Juxue', 'France', 'Europe', 'FRAQ0604', 0),
(0, 'Juzanvigny', 'France', 'Europe', 'FRCA0618', 0),
(0, 'Juzennecourt', 'France', 'Europe', 'FRCA0619', 0),
(0, 'Juzes', 'France', 'Europe', 'FRMP0936', 0),
(0, 'Juzet-d`Izaut', 'France', 'Europe', 'FRMP0937', 0),
(0, 'Juzet-de-Luchon', 'France', 'Europe', 'FRMP0938', 0),
(0, 'Juziers', 'France', 'Europe', 'FRXX5087', 0),
(0, 'La Chapelle-Caro', 'France', 'Europe', 'FRBR0095', 0),
(0, 'La Chapelle-Cecelin', 'France', 'Europe', 'FRBN0504', 0),
(0, 'La Chapelle-Chaussee', 'France', 'Europe', 'FRBR0096', 0),
(0, 'La Chapelle-Craonnaise', 'France', 'Europe', 'FRXX3081', 0),
(0, 'La Chapelle-d`Abondance', 'France', 'Europe', 'FRXX6027', 0),
(0, 'La Chapelle-d`Alagnon', 'France', 'Europe', 'FRAU0307', 0),
(0, 'La Chapelle-d`Aligne', 'France', 'Europe', 'FRPL0334', 0),
(0, 'La Chapelle-d`Andaine', 'France', 'Europe', 'FRBN0513', 0),
(0, 'La Chapelle-d`Angillon', 'France', 'Europe', 'FRCE0452', 0),
(0, 'La Chapelle-d`Armentieres', 'France', 'Europe', 'FRXX3477', 0),
(0, 'La Chapelle-d`Aunainville', 'France', 'Europe', 'FRCE0453', 0),
(0, 'La Chapelle-d`Aurec', 'France', 'Europe', 'FRAU0308', 0),
(0, 'La Chapelle-de-Bragny', 'France', 'Europe', 'FRBO0565', 0),
(0, 'La Chapelle-de-Brain', 'France', 'Europe', 'FRBR0105', 0),
(0, 'La Chapelle-de-Guinchay', 'France', 'Europe', 'FRXX3838', 0),
(0, 'La Chapelle-de-la-Tour', 'France', 'Europe', 'FRRA0741', 0),
(0, 'La Chapelle-de-Mardore', 'France', 'Europe', 'FRXX6385', 0),
(0, 'La Chapelle-de-Surieu', 'France', 'Europe', 'FRRA0740', 0),
(0, 'La Chapelle-des-Fougeretz', 'France', 'Europe', 'FRBR0106', 0),
(0, 'La Chapelle-des-Marais', 'France', 'Europe', 'FRPL0335', 0),
(0, 'La Chapelle-des-Pots', 'France', 'Europe', 'FRPC0425', 0),
(0, 'La Chapelle-devant-Bruyeres', 'France', 'Europe', 'FRLO0772', 0),
(0, 'La Chapelle-du-Bard', 'France', 'Europe', 'FRXX5736', 0),
(0, 'La Chapelle-du-Bois', 'France', 'Europe', 'FRPL0336', 0),
(0, 'La Chapelle-du-Bois-des-Faulx', 'France', 'Europe', 'FRHN0387', 0),
(0, 'La Chapelle-du-Bourgay', 'France', 'Europe', 'FRHN0388', 0),
(0, 'La Chapelle-du-Chatelard', 'France', 'Europe', 'FRRA0742', 0),
(0, 'La Chapelle-du-Fest', 'France', 'Europe', 'FRBN0514', 0),
(0, 'La Chapelle-du-Genet', 'France', 'Europe', 'FRPL0337', 0),
(0, 'La Chapelle-du-Lou', 'France', 'Europe', 'FRBR0107', 0),
(0, 'La Chapelle-du-Mont-de-France', 'France', 'Europe', 'FRBO0566', 0),
(0, 'La Chapelle-du-Mont-du-Chat', 'France', 'Europe', 'FRRA0743', 0),
(0, 'La Chapelle-du-Noyer', 'France', 'Europe', 'FRCE0454', 0),
(0, 'La Chapelle-en-Juger', 'France', 'Europe', 'FRXX3101', 0),
(0, 'La Chapelle-en-Lafaye', 'France', 'Europe', 'FRRA0744', 0),
(0, 'La Chapelle-en-Serval', 'France', 'Europe', 'FRXX3501', 0),
(0, 'La Chapelle-en-Valgaudemar', 'France', 'Europe', 'FRPA0237', 0),
(0, 'La Chapelle-en-Vercors', 'France', 'Europe', 'FRXX6244', 0),
(0, 'La Chapelle-en-Vexin', 'France', 'Europe', 'FRIF0283', 0),
(0, 'La Chapelle-Encherie', 'France', 'Europe', 'FRCE0440', 0),
(0, 'La Chapelle-Engerbold', 'France', 'Europe', 'FRBN0505', 0),
(0, 'La Chapelle-Erbree', 'France', 'Europe', 'FRBR0097', 0),
(0, 'La Chapelle-Faucher', 'France', 'Europe', 'FRXX6154', 0),
(0, 'La Chapelle-Felcourt', 'France', 'Europe', 'FRCA0631', 0),
(0, 'La Chapelle-Forainvilliers', 'France', 'Europe', 'FRCE0441', 0),
(0, 'La Chapelle-Fortin', 'France', 'Europe', 'FRCE0442', 0),
(0, 'La Chapelle-Gaceline', 'France', 'Europe', 'FRBR0098', 0),
(0, 'La Chapelle-Gaudin', 'France', 'Europe', 'FRPC0420', 0),
(0, 'La Chapelle-Gaugain', 'France', 'Europe', 'FRXX2661', 0),
(0, 'La Chapelle-Gauthier', 'France', 'Europe', 'FRIF0278', 0),
(0, 'La Chapelle-Gauthier', 'France', 'Europe', 'FRXX1090', 0),
(0, 'La Chapelle-Geneste', 'France', 'Europe', 'FRAU0303', 0),
(0, 'La Chapelle-Glain', 'France', 'Europe', 'FRPL0316', 0),
(0, 'La Chapelle-Gonaguet', 'France', 'Europe', 'FRAQ0613', 0),
(0, 'La Chapelle-Gresignac', 'France', 'Europe', 'FRAQ0614', 0),
(0, 'La Chapelle-Hareng', 'France', 'Europe', 'FRHN0385', 0),
(0, 'La Chapelle-Haute-Grue', 'France', 'Europe', 'FRBN0506', 0),
(0, 'La Chapelle-Hermier', 'France', 'Europe', 'FRPL0317', 0),
(0, 'La Chapelle-Heulin', 'France', 'Europe', 'FRPL0318', 0),
(0, 'La Chapelle-Hugon', 'France', 'Europe', 'FRXX5522', 0),
(0, 'La Chapelle-Hullin', 'France', 'Europe', 'FRXX2263', 0),
(0, 'La Chapelle-Huon', 'France', 'Europe', 'FRPL0319', 0),
(0, 'La Chapelle-Iger', 'France', 'Europe', 'FRIF0279', 0),
(0, 'La Chapelle-Janson', 'France', 'Europe', 'FRBR0099', 0),
(0, 'La Chapelle-la-Reine', 'France', 'Europe', 'FRXX5638', 0),
(0, 'La Chapelle-Largeau', 'France', 'Europe', 'FRPC0421', 0),
(0, 'La Chapelle-Lasson', 'France', 'Europe', 'FRCA0632', 0),
(0, 'La Chapelle-Launay', 'France', 'Europe', 'FRPL0320', 0),
(0, 'La Chapelle-Laurent', 'France', 'Europe', 'FRAU0304', 0),
(0, 'La Chapelle-les-Luxeuil', 'France', 'Europe', 'FRFC0622', 0),
(0, 'La Chapelle-Marcousse', 'France', 'Europe', 'FRAU0305', 0),
(0, 'La Chapelle-Montabourlet', 'France', 'Europe', 'FRAQ0615', 0),
(0, 'La Chapelle-Montbrandeix', 'France', 'Europe', 'FRXX2249', 0),
(0, 'La Chapelle-Monthodon', 'France', 'Europe', 'FRXX4098', 0),
(0, 'La Chapelle-Montligeon', 'France', 'Europe', 'FRBN0507', 0),
(0, 'La Chapelle-Montlinard', 'France', 'Europe', 'FRCE0443', 0),
(0, 'La Chapelle-Montmartin', 'France', 'Europe', 'FRCE0444', 0),
(0, 'La Chapelle-Montmoreau', 'France', 'Europe', 'FRAQ0616', 0),
(0, 'La Chapelle-Mouliere', 'France', 'Europe', 'FRPC0422', 0),
(0, 'La Chapelle-Moutils', 'France', 'Europe', 'FRIF0280', 0),
(0, 'Malvalette', 'France', 'Europe', 'FRXX6348', 0),
(0, 'Malves-en-Minervois', 'France', 'Europe', 'FRLR0439', 0),
(0, 'Malvezie', 'France', 'Europe', 'FRXX5019', 0),
(0, 'Malvieres', 'France', 'Europe', 'FRAU0441', 0),
(0, 'Malvies', 'France', 'Europe', 'FRLR0440', 0),
(0, 'Malville', 'France', 'Europe', 'FRPL0533', 0),
(0, 'Malvillers', 'France', 'Europe', 'FRFC0820', 0),
(0, 'Malzeville', 'France', 'Europe', 'FRXX2357', 0),
(0, 'Malzy', 'France', 'Europe', 'FRPI1008', 0),
(0, 'Mambouhans', 'France', 'Europe', 'FRFC0821', 0),
(0, 'Mamers', 'France', 'Europe', 'FRPL0534', 0),
(0, 'Mametz', 'France', 'Europe', 'FRNC0588', 0),
(0, 'Mametz', 'France', 'Europe', 'FRPI1009', 0),
(0, 'Mamey', 'France', 'Europe', 'FRXX4562', 0),
(0, 'Mamirolle', 'France', 'Europe', 'FRFC0822', 0),
(0, 'Mana', 'France', 'Europe', 'FRXX7792', 0),
(0, 'Manas', 'France', 'Europe', 'FRRA1031', 0),
(0, 'Manas-Bastanous', 'France', 'Europe', 'FRMP1328', 0),
(0, 'Manaurie', 'France', 'Europe', 'FRAQ0861', 0),
(0, 'Mance', 'France', 'Europe', 'FRLO0982', 0),
(0, 'Mancenans', 'France', 'Europe', 'FRFC0823', 0),
(0, 'Mancenans-Lizerne', 'France', 'Europe', 'FRXX5438', 0),
(0, 'Mancey', 'France', 'Europe', 'FRBO0717', 0),
(0, 'Manchecourt', 'France', 'Europe', 'FRCE0626', 0),
(0, 'Manciet', 'France', 'Europe', 'FRMP1329', 0),
(0, 'Mancieulles', 'France', 'Europe', 'FRXX2882', 0),
(0, 'Mancioux', 'France', 'Europe', 'FRMP1330', 0),
(0, 'Mancy', 'France', 'Europe', 'FRCA0840', 0),
(0, 'Mandacou', 'France', 'Europe', 'FRAQ0862', 0),
(0, 'Mandagout', 'France', 'Europe', 'FRLR0441', 0),
(0, 'Mandailles-Saint-Julien', 'France', 'Europe', 'FRAU0442', 0),
(0, 'Mandelieu-la-Napoule', 'France', 'Europe', 'FRPA0355', 0),
(0, 'Manderen', 'France', 'Europe', 'FRLO0983', 0),
(0, 'Mandeure', 'France', 'Europe', 'FRXX5460', 0),
(0, 'Mandeville', 'France', 'Europe', 'FRHN0538', 0),
(0, 'Mandeville-en-Bessin', 'France', 'Europe', 'FRBN0798', 0),
(0, 'Mandray', 'France', 'Europe', 'FRLO0984', 0),
(0, 'Mandres', 'France', 'Europe', 'FRHN0539', 0),
(0, 'Mandres-aux-Quatre-Tours', 'France', 'Europe', 'FRLO0985', 0),
(0, 'Mandres-en-Barrois', 'France', 'Europe', 'FRLO0986', 0),
(0, 'Mandres-la-Cote', 'France', 'Europe', 'FRXX1662', 0),
(0, 'Mandres-les-Roses', 'France', 'Europe', 'FRXX6681', 0),
(0, 'Mandres-sur-Vair', 'France', 'Europe', 'FRLO0987', 0),
(0, 'Mandrevillars', 'France', 'Europe', 'FRMP1331', 0),
(0, 'Manduel', 'France', 'Europe', 'FRXX1772', 0),
(0, 'Mane', 'France', 'Europe', 'FRMP1332', 0),
(0, 'Mane', 'France', 'Europe', 'FRPA0356', 0),
(0, 'Maneglise', 'France', 'Europe', 'FRHN0540', 0),
(0, 'Manehouville', 'France', 'Europe', 'FRHN0541', 0),
(0, 'Manent-Montane', 'France', 'Europe', 'FRMP1333', 0),
(0, 'Manerbe', 'France', 'Europe', 'FRBN0799', 0),
(0, 'Mangiennes', 'France', 'Europe', 'FRLO0988', 0),
(0, 'Manglieu', 'France', 'Europe', 'FRAU0443', 0),
(0, 'Mangonville', 'France', 'Europe', 'FRLO0989', 0),
(0, 'Manhac', 'France', 'Europe', 'FRMP1334', 0),
(0, 'Manheulles', 'France', 'Europe', 'FRLO0990', 0),
(0, 'Manhoue', 'France', 'Europe', 'FRLO0991', 0),
(0, 'Manicamp', 'France', 'Europe', 'FRPI1010', 0),
(0, 'Manicourt', 'France', 'Europe', 'FRPI1011', 0),
(0, 'Manigod', 'France', 'Europe', 'FRXX0516', 0),
(0, 'Manihi', 'France', 'Europe', 'FRXX7909', 0),
(0, 'Manin', 'France', 'Europe', 'FRNC0589', 0),
(0, 'Maninghem', 'France', 'Europe', 'FRXX5644', 0),
(0, 'Maninghen-Henne', 'France', 'Europe', 'FRNC0590', 0),
(0, 'Manlay', 'France', 'Europe', 'FRBO0718', 0),
(0, 'Manneville-es-Plains', 'France', 'Europe', 'FRHN0542', 0),
(0, 'Manneville-la-Goupil', 'France', 'Europe', 'FRHN0543', 0),
(0, 'Manneville-la-Pipard', 'France', 'Europe', 'FRBN0800', 0),
(0, 'Manneville-la-Raoult', 'France', 'Europe', 'FRHN0544', 0),
(0, 'Manneville-sur-Risle', 'France', 'Europe', 'FRHN0545', 0),
(0, 'Mannevillette', 'France', 'Europe', 'FRHN0546', 0),
(0, 'Mano', 'France', 'Europe', 'FRAQ0863', 0),
(0, 'Manois', 'France', 'Europe', 'FRCA0841', 0),
(0, 'Manom', 'France', 'Europe', 'FRLO0992', 0),
(0, 'Manoncourt-en-Vermois', 'France', 'Europe', 'FRLO0993', 0),
(0, 'Manoncourt-en-Woevre', 'France', 'Europe', 'FRLO0994', 0),
(0, 'Manoncourt-sur-Seille', 'France', 'Europe', 'FRLO0995', 0),
(0, 'Manonville', 'France', 'Europe', 'FRLO0996', 0),
(0, 'Manonviller', 'France', 'Europe', 'FRLO0997', 0),
(0, 'Manosque', 'France', 'Europe', 'FRXX0364', 0),
(0, 'Neuville-Day', 'France', 'Europe', 'FRXX3250', 0),
(0, 'Neuville-de-Poitou', 'France', 'Europe', 'FRXX2151', 0),
(0, 'Neuville-en-Avesnois', 'France', 'Europe', 'FRNC0660', 0),
(0, 'Neuville-en-Beaumont', 'France', 'Europe', 'FRBN0922', 0),
(0, 'Neuville-en-Ferrain', 'France', 'Europe', 'FRXX3478', 0),
(0, 'Neuville-en-Verdunois', 'France', 'Europe', 'FRLO1160', 0),
(0, 'Neuville-Ferrieres', 'France', 'Europe', 'FRHN0617', 0),
(0, 'Neuville-les-Dames', 'France', 'Europe', 'FRXX6333', 0),
(0, 'Neuville-les-Decize', 'France', 'Europe', 'FRBO0889', 0),
(0, 'Neuville-les-Dieppe', 'France', 'Europe', 'FRHN0618', 0),
(0, 'Neuville-les-Loeuilly', 'France', 'Europe', 'FRPI1199', 0),
(0, 'Neuville-les-This', 'France', 'Europe', 'FRCA0991', 0),
(0, 'Neuville-les-Vaucouleurs', 'France', 'Europe', 'FRLO1161', 0),
(0, 'Neuville-lez-Beaulieu', 'France', 'Europe', 'FRCA0992', 0),
(0, 'Neuville-pres-Sees', 'France', 'Europe', 'FRBN0923', 0),
(0, 'Neuville-Saint-Amand', 'France', 'Europe', 'FRPI1197', 0),
(0, 'Neuville-Saint-Remy', 'France', 'Europe', 'FRXX2785', 0),
(0, 'Neuville-Saint-Vaast', 'France', 'Europe', 'FRNC0657', 0),
(0, 'Neuville-sous-Arzillieres', 'France', 'Europe', 'FRCA0993', 0),
(0, 'Neuville-sous-Montreuil', 'France', 'Europe', 'FRNC0661', 0),
(0, 'Neuville-sur-Ailette', 'France', 'Europe', 'FRPI1200', 0),
(0, 'Neuville-sur-Ain', 'France', 'Europe', 'FRRA1244', 0),
(0, 'Neuville-sur-Authou', 'France', 'Europe', 'FRHN0619', 0),
(0, 'Neuville-sur-Brenne', 'France', 'Europe', 'FRCE0786', 0),
(0, 'Neuville-sur-Escaut', 'France', 'Europe', 'FRXX4408', 0),
(0, 'Neuville-sur-Margival', 'France', 'Europe', 'FRPI1201', 0),
(0, 'Neuville-sur-Oise', 'France', 'Europe', 'FRXX4657', 0),
(0, 'Neuville-sur-Ornain', 'France', 'Europe', 'FRLO1162', 0),
(0, 'Neuville-sur-Saone', 'France', 'Europe', 'FRXX1605', 0),
(0, 'Neuville-sur-Sarthe', 'France', 'Europe', 'FRPL0629', 0),
(0, 'Neuville-sur-Seine', 'France', 'Europe', 'FRCA0994', 0),
(0, 'Neuville-sur-Touques', 'France', 'Europe', 'FRBN0924', 0),
(0, 'Neuville-sur-Vannes', 'France', 'Europe', 'FRCA0995', 0),
(0, 'Neuville-Vitasse', 'France', 'Europe', 'FRNC0658', 0),
(0, 'Neuviller-la-Roche', 'France', 'Europe', 'FRAL0384', 0),
(0, 'Neuviller-les-Badonviller', 'France', 'Europe', 'FRXX3768', 0),
(0, 'Neuviller-sur-Moselle', 'France', 'Europe', 'FRLO1163', 0),
(0, 'Neuvillers-sur-Fave', 'France', 'Europe', 'FRLO1164', 0),
(0, 'Neuvillette', 'France', 'Europe', 'FRPI1202', 0),
(0, 'Neuvillette', 'France', 'Europe', 'FRPI1203', 0),
(0, 'Neuvillette-en-Charnie', 'France', 'Europe', 'FRPL0630', 0),
(0, 'Neuvilley', 'France', 'Europe', 'FRFC0975', 0),
(0, 'Neuvilly', 'France', 'Europe', 'FRNC0662', 0),
(0, 'Neuvilly-en-Argonne', 'France', 'Europe', 'FRXX6733', 0),
(0, 'Neuvireuil', 'France', 'Europe', 'FRNC0663', 0),
(0, 'Neuvizy', 'France', 'Europe', 'FRCA0996', 0),
(0, 'Neuvy', 'France', 'Europe', 'FRAU0536', 0),
(0, 'Neuvy', 'France', 'Europe', 'FRCA0997', 0),
(0, 'Neuvy', 'France', 'Europe', 'FRCE0787', 0),
(0, 'Neuvy-au-Houlme', 'France', 'Europe', 'FRBN0925', 0),
(0, 'Neuvy-Bouin', 'France', 'Europe', 'FRPC0692', 0),
(0, 'Neuvy-Deux-Clochers', 'France', 'Europe', 'FRCE0788', 0),
(0, 'Neuvy-en-Beauce', 'France', 'Europe', 'FRCE0790', 0),
(0, 'Neuvy-en-Champagne', 'France', 'Europe', 'FRPL0631', 0),
(0, 'Neuvy-en-Dunois', 'France', 'Europe', 'FRCE0791', 0),
(0, 'Neuvy-en-Mauges', 'France', 'Europe', 'FRPL0632', 0),
(0, 'Neuvy-en-Sullias', 'France', 'Europe', 'FRXX6394', 0),
(0, 'Neuvy-Grandchamp', 'France', 'Europe', 'FRXX5060', 0),
(0, 'Neuvy-le-Barrois', 'France', 'Europe', 'FRCE0792', 0),
(0, 'Neuvy-le-Roi', 'France', 'Europe', 'FRCE0793', 0),
(0, 'Neuvy-Pailloux', 'France', 'Europe', 'FRCE0789', 0),
(0, 'Neuvy-Saint-Sepulchre', 'France', 'Europe', 'FRXX5881', 0),
(0, 'Neuvy-Sautour', 'France', 'Europe', 'FRXX5285', 0),
(0, 'Neuvy-sur-Barangeon', 'France', 'Europe', 'FRXX3259', 0),
(0, 'Neuvy-sur-Loire', 'France', 'Europe', 'FRXX1491', 0),
(0, 'Neuwiller', 'France', 'Europe', 'FRAL0385', 0),
(0, 'Neuwiller-les-Saverne', 'France', 'Europe', 'FRXX5112', 0),
(0, 'Nevache', 'France', 'Europe', 'FRPA0409', 0),
(0, 'Nevers', 'France', 'Europe', 'FRXX0164', 0),
(0, 'Nevez', 'France', 'Europe', 'FRXX1768', 0),
(0, 'Nevian', 'France', 'Europe', 'FRLR0553', 0),
(0, 'Neville', 'France', 'Europe', 'FRHN0620', 0),
(0, 'Neville-sur-Mer', 'France', 'Europe', 'FRBN0926', 0),
(0, 'Nevoy', 'France', 'Europe', 'FRCE0794', 0),
(0, 'Nevy-les-Dole', 'France', 'Europe', 'FRFC0976', 0),
(0, 'Nevy-sur-Seille', 'France', 'Europe', 'FRFC0977', 0),
(0, 'Nexon', 'France', 'Europe', 'FRLI0307', 0),
(0, 'Ney', 'France', 'Europe', 'FRFC0978', 0),
(0, 'Neydens', 'France', 'Europe', 'FRRA1245', 0),
(0, 'Neyron', 'France', 'Europe', 'FRRA1246', 0),
(0, 'Ormenans', 'France', 'Europe', 'FRFC1004', 0),
(0, 'Ormersviller', 'France', 'Europe', 'FRLO1208', 0),
(0, 'Ormes', 'France', 'Europe', 'FRBO0914', 0),
(0, 'Ormes', 'France', 'Europe', 'FRCA1036', 0),
(0, 'Ormes', 'France', 'Europe', 'FRCA1037', 0),
(0, 'Ormes', 'France', 'Europe', 'FRCE0829', 0),
(0, 'Ormes', 'France', 'Europe', 'FRHN0642', 0),
(0, 'Ormes-et-Ville', 'France', 'Europe', 'FRLO1209', 0),
(0, 'Ormesson', 'France', 'Europe', 'FRIF0450', 0),
(0, 'Ormesson-sur-Marne', 'France', 'Europe', 'FRXX5982', 0),
(0, 'Ormoiche', 'France', 'Europe', 'FRFC1005', 0),
(0, 'Ormoy', 'France', 'Europe', 'FRBO0915', 0),
(0, 'Ormoy', 'France', 'Europe', 'FRCE0830', 0),
(0, 'Ormoy', 'France', 'Europe', 'FRFC1006', 0),
(0, 'Ormoy-la-Riviere', 'France', 'Europe', 'FRIF0451', 0),
(0, 'Ormoy-le-Davien', 'France', 'Europe', 'FRPI1248', 0),
(0, 'Ormoy-les-Sexfontaines', 'France', 'Europe', 'FRXX2355', 0),
(0, 'Ormoy-sur-Aube', 'France', 'Europe', 'FRCA1038', 0),
(0, 'Ormoy-Villers', 'France', 'Europe', 'FRPI1247', 0),
(0, 'Ornacieux', 'France', 'Europe', 'FRRA1282', 0),
(0, 'Ornaisons', 'France', 'Europe', 'FRLR0568', 0),
(0, 'Ornans', 'France', 'Europe', 'FRFC1007', 0),
(0, 'Ornel', 'France', 'Europe', 'FRLO1210', 0),
(0, 'Ornes', 'France', 'Europe', 'FRLO1211', 0),
(0, 'Ornex', 'France', 'Europe', 'FRXX4121', 0),
(0, 'Ornezan', 'France', 'Europe', 'FRMP1663', 0),
(0, 'Orniac', 'France', 'Europe', 'FRMP1664', 0),
(0, 'Ornolac-Ussat-les-Bains', 'France', 'Europe', 'FRMP1665', 0),
(0, 'Ornon', 'France', 'Europe', 'FRRA1283', 0),
(0, 'Orny', 'France', 'Europe', 'FRLO1212', 0),
(0, 'Oroer', 'France', 'Europe', 'FRPI1249', 0),
(0, 'Orofara', 'France', 'Europe', 'FRXX7856', 0),
(0, 'Oroix', 'France', 'Europe', 'FRMP1666', 0),
(0, 'Oron', 'France', 'Europe', 'FRLO1213', 0),
(0, 'Oroux', 'France', 'Europe', 'FRPC0711', 0),
(0, 'Orphin', 'France', 'Europe', 'FRIF0452', 0),
(0, 'Orpierre', 'France', 'Europe', 'FRPA0418', 0),
(0, 'Orquevaux', 'France', 'Europe', 'FRCA1039', 0),
(0, 'Orret', 'France', 'Europe', 'FRBO0916', 0),
(0, 'Orriule', 'France', 'Europe', 'FRAQ1073', 0),
(0, 'Orrouer', 'France', 'Europe', 'FRCE0831', 0),
(0, 'Orrouy', 'France', 'Europe', 'FRXX2720', 0),
(0, 'Orry-la-Ville', 'France', 'Europe', 'FRXX2734', 0),
(0, 'Ors', 'France', 'Europe', 'FRNC0695', 0),
(0, 'Orsan', 'France', 'Europe', 'FRPA0419', 0),
(0, 'Orsanco', 'France', 'Europe', 'FRAQ1074', 0),
(0, 'Orsans', 'France', 'Europe', 'FRFC1008', 0),
(0, 'Orsans', 'France', 'Europe', 'FRLR0569', 0),
(0, 'Orsay', 'France', 'Europe', 'FRXX5240', 0),
(0, 'Orschwihr', 'France', 'Europe', 'FRAL0427', 0),
(0, 'Orschwiller', 'France', 'Europe', 'FRAL0428', 0),
(0, 'Orsennes', 'France', 'Europe', 'FRXX2051', 0),
(0, 'Orsinval', 'France', 'Europe', 'FRNC0696', 0),
(0, 'Orsonnette', 'France', 'Europe', 'FRAU0553', 0),
(0, 'Orsonville', 'France', 'Europe', 'FRIF0453', 0),
(0, 'Ortaffa', 'France', 'Europe', 'FRXX4229', 0),
(0, 'Ortale', 'France', 'Europe', 'FRCO0127', 0),
(0, 'Orthevielle', 'France', 'Europe', 'FRAQ1075', 0),
(0, 'Orthez', 'France', 'Europe', 'FRXX0327', 0),
(0, 'Orthoux-Serignac-Quilhan', 'France', 'Europe', 'FRLR0570', 0),
(0, 'Ortillon', 'France', 'Europe', 'FRCA1040', 0),
(0, 'Ortiporio', 'France', 'Europe', 'FRCO0128', 0),
(0, 'Orto', 'France', 'Europe', 'FRCO0129', 0),
(0, 'Ortoncourt', 'France', 'Europe', 'FRLO1214', 0),
(0, 'Orus', 'France', 'Europe', 'FRMP1667', 0),
(0, 'Orval', 'France', 'Europe', 'FRBN0959', 0),
(0, 'Orval', 'France', 'Europe', 'FRCE0832', 0),
(0, 'Orvault', 'France', 'Europe', 'FRXX0075', 0),
(0, 'Orvaux', 'France', 'Europe', 'FRHN0643', 0),
(0, 'Orve', 'France', 'Europe', 'FRFC1009', 0),
(0, 'Orveau', 'France', 'Europe', 'FRIF0454', 0),
(0, 'Orveau-Bellesauve', 'France', 'Europe', 'FRXX3389', 0),
(0, 'Orville', 'France', 'Europe', 'FRBN0960', 0),
(0, 'Orville', 'France', 'Europe', 'FRBO0917', 0),
(0, 'Orville', 'France', 'Europe', 'FRCE0833', 0),
(0, 'Orville', 'France', 'Europe', 'FRCE0834', 0),
(0, 'Orville', 'France', 'Europe', 'FRNC0697', 0),
(0, 'Orvillers-Sorel', 'France', 'Europe', 'FRPI1250', 0),
(0, 'Orvilliers', 'France', 'Europe', 'FRIF0455', 0),
(0, 'Orvilliers-Saint-Julien', 'France', 'Europe', 'FRCA1041', 0),
(0, 'Peisey-Nancroix', 'France', 'Europe', 'FRXX2001', 0),
(0, 'Pel-et-Der', 'France', 'Europe', 'FRCA1068', 0),
(0, 'Pelissanne', 'France', 'Europe', 'FRXX1060', 0),
(0, 'Pellafol', 'France', 'Europe', 'FRRA1312', 0),
(0, 'Pelleautier', 'France', 'Europe', 'FRPA0426', 0),
(0, 'Pellefigue', 'France', 'Europe', 'FRMP1705', 0),
(0, 'Pellegrue', 'France', 'Europe', 'FRAQ1106', 0),
(0, 'Pelleport', 'France', 'Europe', 'FRMP1706', 0),
(0, 'Pellerey', 'France', 'Europe', 'FRBO0948', 0),
(0, 'Pellevoisin', 'France', 'Europe', 'FRCE0863', 0),
(0, 'Pellouailles-les-Vignes', 'France', 'Europe', 'FRXX2386', 0),
(0, 'Pelonne', 'France', 'Europe', 'FRRA1313', 0),
(0, 'Pelouse', 'France', 'Europe', 'FRLR0590', 0),
(0, 'Pelousey', 'France', 'Europe', 'FRFC1036', 0),
(0, 'Peltre', 'France', 'Europe', 'FRXX5654', 0),
(0, 'Pelussin', 'France', 'Europe', 'FRRA1314', 0),
(0, 'Pelves', 'France', 'Europe', 'FRNC0705', 0),
(0, 'Pelvoux', 'France', 'Europe', 'FRXX6121', 0),
(0, 'Penchard', 'France', 'Europe', 'FRIF0466', 0),
(0, 'Pencran', 'France', 'Europe', 'FRBR0372', 0),
(0, 'Pende', 'France', 'Europe', 'FRPI1280', 0),
(0, 'Penestin', 'France', 'Europe', 'FRXX1498', 0),
(0, 'Penguily', 'France', 'Europe', 'FRBR0373', 0),
(0, 'Penin', 'France', 'Europe', 'FRNC0706', 0),
(0, 'Penly', 'France', 'Europe', 'FRHN0655', 0),
(0, 'Penmarch', 'France', 'Europe', 'FRXX3950', 0),
(0, 'Pennautier', 'France', 'Europe', 'FRLR0591', 0),
(0, 'Penne', 'France', 'Europe', 'FRMP1707', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Penne-d`Agenais', 'France', 'Europe', 'FRAQ1107', 0),
(0, 'Pennedepie', 'France', 'Europe', 'FRBN0973', 0),
(0, 'Pennes-le-Sec', 'France', 'Europe', 'FRRA1315', 0),
(0, 'Pennesieres', 'France', 'Europe', 'FRFC1037', 0),
(0, 'Penol', 'France', 'Europe', 'FRRA1316', 0),
(0, 'Pensol', 'France', 'Europe', 'FRLI0327', 0),
(0, 'Penta-Acquatella', 'France', 'Europe', 'FRCO0137', 0),
(0, 'Penta-di-Casinca', 'France', 'Europe', 'FRXX1737', 0),
(0, 'Penvenan', 'France', 'Europe', 'FRXX4784', 0),
(0, 'Peone', 'France', 'Europe', 'FRPA0427', 0),
(0, 'Pepieux', 'France', 'Europe', 'FRLR0592', 0),
(0, 'Perassay', 'France', 'Europe', 'FRCE0864', 0),
(0, 'Peray', 'France', 'Europe', 'FRPL0668', 0),
(0, 'Perceneige', 'France', 'Europe', 'FRBO0949', 0),
(0, 'Percey', 'France', 'Europe', 'FRXX6702', 0),
(0, 'Percey-le-Grand', 'France', 'Europe', 'FRFC1038', 0),
(0, 'Percey-le-Pautel', 'France', 'Europe', 'FRCA1069', 0),
(0, 'Perchede', 'France', 'Europe', 'FRMP1708', 0),
(0, 'Percy', 'France', 'Europe', 'FRBN0974', 0),
(0, 'Percy', 'France', 'Europe', 'FRRA1317', 0),
(0, 'Percy-en-Auge', 'France', 'Europe', 'FRBN0975', 0),
(0, 'Perdreauville', 'France', 'Europe', 'FRIF0467', 0),
(0, 'Pere', 'France', 'Europe', 'FRMP1709', 0),
(0, 'Pere', 'France', 'Europe', 'FRPC0728', 0),
(0, 'Pereille', 'France', 'Europe', 'FRXX1153', 0),
(0, 'Perelli', 'France', 'Europe', 'FRCO0138', 0),
(0, 'Perenchies', 'France', 'Europe', 'FRXX2165', 0),
(0, 'Peret', 'France', 'Europe', 'FRLR0593', 0),
(0, 'Peret-Bel-Air', 'France', 'Europe', 'FRLI0328', 0),
(0, 'Pereuil', 'France', 'Europe', 'FRPC0729', 0),
(0, 'Pereyres', 'France', 'Europe', 'FRRA1318', 0),
(0, 'Pergain-Taillac', 'France', 'Europe', 'FRXX3557', 0),
(0, 'Peri', 'France', 'Europe', 'FRCO0139', 0),
(0, 'Periers', 'France', 'Europe', 'FRBN0976', 0),
(0, 'Periers-en-Auge', 'France', 'Europe', 'FRXX6129', 0),
(0, 'Periers-sur-le-Dan', 'France', 'Europe', 'FRXX4694', 0),
(0, 'Perignac', 'France', 'Europe', 'FRPC0730', 0),
(0, 'Perignac', 'France', 'Europe', 'FRPC0731', 0),
(0, 'Perignat-les-Sarlieve', 'France', 'Europe', 'FRXX6403', 0),
(0, 'Perignat-sur-Allier', 'France', 'Europe', 'FRXX5682', 0),
(0, 'Perigne', 'France', 'Europe', 'FRPC0732', 0),
(0, 'Perigneux', 'France', 'Europe', 'FRRA1319', 0),
(0, 'Perigny', 'France', 'Europe', 'FRAU0566', 0),
(0, 'Perigny', 'France', 'Europe', 'FRBN0977', 0),
(0, 'Perigny', 'France', 'Europe', 'FRCE0865', 0),
(0, 'Perigny', 'France', 'Europe', 'FRXX1842', 0),
(0, 'Perigny-la-Rose', 'France', 'Europe', 'FRCA1070', 0),
(0, 'Perigueux', 'France', 'Europe', 'FRXX0169', 0),
(0, 'Perillos', 'France', 'Europe', 'FRLR0594', 0),
(0, 'Perissac', 'France', 'Europe', 'FRAQ1108', 0),
(0, 'Perles', 'France', 'Europe', 'FRPI1281', 0),
(0, 'Perles-et-Castelet', 'France', 'Europe', 'FRMP1710', 0),
(0, 'Remering-les-Puttelange', 'France', 'Europe', 'FRLO1342', 0),
(0, 'Remicourt', 'France', 'Europe', 'FRLO1343', 0),
(0, 'Remiencourt', 'France', 'Europe', 'FRPI1379', 0),
(0, 'Remies', 'France', 'Europe', 'FRPI1380', 0),
(0, 'Remigny', 'France', 'Europe', 'FRBO1032', 0),
(0, 'Remigny', 'France', 'Europe', 'FRPI1381', 0),
(0, 'Remilly', 'France', 'Europe', 'FRBO1033', 0),
(0, 'Remilly', 'France', 'Europe', 'FRLO1344', 0),
(0, 'Remilly-Aillicourt', 'France', 'Europe', 'FRCA1172', 0),
(0, 'Remilly-en-Montagne', 'France', 'Europe', 'FRBO1034', 0),
(0, 'Remilly-les-Pothees', 'France', 'Europe', 'FRCA1173', 0),
(0, 'Remilly-sur-Lozon', 'France', 'Europe', 'FRBN1042', 0),
(0, 'Remilly-sur-Tille', 'France', 'Europe', 'FRXX6189', 0),
(0, 'Remilly-Wirquin', 'France', 'Europe', 'FRNC0766', 0),
(0, 'Reminiac', 'France', 'Europe', 'FRBR0493', 0),
(0, 'Remire-Montjoly', 'France', 'Europe', 'FRXX7789', 0),
(0, 'Remiremont', 'France', 'Europe', 'FRXX1550', 0),
(0, 'Remoiville', 'France', 'Europe', 'FRLO1345', 0),
(0, 'Remollon', 'France', 'Europe', 'FRPA0470', 0),
(0, 'Remomeix', 'France', 'Europe', 'FRLO1346', 0),
(0, 'Remoncourt', 'France', 'Europe', 'FRLO1347', 0),
(0, 'Remoncourt', 'France', 'Europe', 'FRLO1348', 0),
(0, 'Remondans-Vaivre', 'France', 'Europe', 'FRFC1130', 0),
(0, 'Remonville', 'France', 'Europe', 'FRCA1174', 0),
(0, 'Remoray-Boujeons', 'France', 'Europe', 'FRFC1131', 0),
(0, 'Remouille', 'France', 'Europe', 'FRPL0716', 0),
(0, 'Remoulins', 'France', 'Europe', 'FRPA0471', 0),
(0, 'Removille', 'France', 'Europe', 'FRLO1349', 0),
(0, 'Rempnat', 'France', 'Europe', 'FRLI0344', 0),
(0, 'Remungol', 'France', 'Europe', 'FRBR0494', 0),
(0, 'Remuzat', 'France', 'Europe', 'FRRA1428', 0),
(0, 'Remy', 'France', 'Europe', 'FRNC0767', 0),
(0, 'Remy', 'France', 'Europe', 'FRPI1382', 0),
(0, 'Renac', 'France', 'Europe', 'FRBR0495', 0),
(0, 'Renage', 'France', 'Europe', 'FRRA1429', 0),
(0, 'Renaison', 'France', 'Europe', 'FRRA1430', 0),
(0, 'Renansart', 'France', 'Europe', 'FRPI1383', 0),
(0, 'Renaucourt', 'France', 'Europe', 'FRFC1132', 0),
(0, 'Renauvoid', 'France', 'Europe', 'FRLO1350', 0),
(0, 'Renay', 'France', 'Europe', 'FRCE0929', 0),
(0, 'Renaze', 'France', 'Europe', 'FRPL0717', 0),
(0, 'Rencurel', 'France', 'Europe', 'FRRA1431', 0),
(0, 'Rene', 'France', 'Europe', 'FRPL0718', 0),
(0, 'Renedale', 'France', 'Europe', 'FRFC1133', 0),
(0, 'Renescure', 'France', 'Europe', 'FRXX5228', 0),
(0, 'Reneve', 'France', 'Europe', 'FRBO1035', 0),
(0, 'Rening', 'France', 'Europe', 'FRLO1351', 0),
(0, 'Rennemoulin', 'France', 'Europe', 'FRIF0496', 0),
(0, 'Rennepont', 'France', 'Europe', 'FRCA1175', 0),
(0, 'Rennes', 'France', 'Europe', 'FRXX0114', 0),
(0, 'Rennes-en-Grenouilles', 'France', 'Europe', 'FRPL0719', 0),
(0, 'Rennes-le-Chateau', 'France', 'Europe', 'FRLR0662', 0),
(0, 'Rennes-les-Bains', 'France', 'Europe', 'FRLR0663', 0),
(0, 'Rennes-sur-Loue', 'France', 'Europe', 'FRFC1134', 0),
(0, 'Renneval', 'France', 'Europe', 'FRPI1384', 0),
(0, 'Renneville', 'France', 'Europe', 'FRHN0697', 0),
(0, 'Renneville', 'France', 'Europe', 'FRMP1848', 0),
(0, 'Renneville', 'France', 'Europe', 'FRPI1385', 0),
(0, 'Rentieres', 'France', 'Europe', 'FRAU0609', 0),
(0, 'Renty', 'France', 'Europe', 'FRNC0768', 0),
(0, 'Renung', 'France', 'Europe', 'FRAQ1199', 0),
(0, 'Renwez', 'France', 'Europe', 'FRCA1176', 0),
(0, 'Reotier', 'France', 'Europe', 'FRPA0472', 0),
(0, 'Repaix', 'France', 'Europe', 'FRLO1352', 0),
(0, 'Reparsac', 'France', 'Europe', 'FRPC0795', 0),
(0, 'Repel', 'France', 'Europe', 'FRLO1353', 0),
(0, 'Repentigny', 'France', 'Europe', 'FRBN1043', 0),
(0, 'Replonges', 'France', 'Europe', 'FRXX6302', 0),
(0, 'Reppe', 'France', 'Europe', 'FRMP1849', 0),
(0, 'Requeil', 'France', 'Europe', 'FRPL0720', 0),
(0, 'Requista', 'France', 'Europe', 'FRXX0336', 0),
(0, 'Resenlieu', 'France', 'Europe', 'FRBN1044', 0),
(0, 'Resigny', 'France', 'Europe', 'FRPI1386', 0),
(0, 'Resson', 'France', 'Europe', 'FRLO1354', 0),
(0, 'Ressons-l`Abbaye', 'France', 'Europe', 'FRPI1387', 0),
(0, 'Ressons-le-Long', 'France', 'Europe', 'FRPI1388', 0),
(0, 'Ressons-sur-Matz', 'France', 'Europe', 'FRXX2025', 0),
(0, 'Restigne', 'France', 'Europe', 'FRCE0930', 0),
(0, 'Restinclieres', 'France', 'Europe', 'FRLR0664', 0),
(0, 'Retaud', 'France', 'Europe', 'FRPC0796', 0),
(0, 'Saint-Antoine-les-Plantades', 'France', 'Europe', 'FRLI0368', 0),
(0, 'Saint-Antoine-sur-l`Isle', 'France', 'Europe', 'FRAQ1248', 0),
(0, 'Saint-Antonin', 'France', 'Europe', 'FRMP1931', 0),
(0, 'Saint-Antonin', 'France', 'Europe', 'FRPA0504', 0),
(0, 'Saint-Antonin-de-Lacalm', 'France', 'Europe', 'FRMP1932', 0),
(0, 'Saint-Antonin-de-Sommaire', 'France', 'Europe', 'FRXX6220', 0),
(0, 'Saint-Antonin-du-Var', 'France', 'Europe', 'FRPA0505', 0),
(0, 'Saint-Antonin-Noble-Val', 'France', 'Europe', 'FRXX5326', 0),
(0, 'Saint-Antonin-sur-Bayon', 'France', 'Europe', 'FRPA0506', 0),
(0, 'Saint-Aoustrille', 'France', 'Europe', 'FRCE0976', 0),
(0, 'Saint-Aout', 'France', 'Europe', 'FRXX4395', 0),
(0, 'Saint-Apollinaire', 'France', 'Europe', 'FRPA0507', 0),
(0, 'Saint-Apollinaire', 'France', 'Europe', 'FRXX3222', 0),
(0, 'Saint-Apollinaire-de-Rias', 'France', 'Europe', 'FRRA1522', 0),
(0, 'Saint-Appolinaire', 'France', 'Europe', 'FRRA1523', 0),
(0, 'Saint-Appolinard', 'France', 'Europe', 'FRRA1524', 0),
(0, 'Saint-Appolinard', 'France', 'Europe', 'FRRA1525', 0),
(0, 'Saint-Aquilin', 'France', 'Europe', 'FRAQ1249', 0),
(0, 'Saint-Aquilin-de-Corbion', 'France', 'Europe', 'FRBN1087', 0),
(0, 'Saint-Aquilin-de-Pacy', 'France', 'Europe', 'FRHN0734', 0),
(0, 'Saint-Araille', 'France', 'Europe', 'FRMP1933', 0),
(0, 'Saint-Arailles', 'France', 'Europe', 'FRMP1934', 0),
(0, 'Saint-Arcons-d`Allier', 'France', 'Europe', 'FRAU0642', 0),
(0, 'Saint-Arcons-de-Barges', 'France', 'Europe', 'FRAU0643', 0),
(0, 'Saint-Arey', 'France', 'Europe', 'FRRA1526', 0),
(0, 'Saint-Armel', 'France', 'Europe', 'FRBR0519', 0),
(0, 'Saint-Armel', 'France', 'Europe', 'FRBR0520', 0),
(0, 'Saint-Armou', 'France', 'Europe', 'FRAQ1250', 0),
(0, 'Saint-Arnac', 'France', 'Europe', 'FRLR0712', 0),
(0, 'Saint-Arnoult', 'France', 'Europe', 'FRBN1088', 0),
(0, 'Saint-Arnoult', 'France', 'Europe', 'FRCE0977', 0),
(0, 'Saint-Arnoult', 'France', 'Europe', 'FRHN0735', 0),
(0, 'Saint-Arnoult', 'France', 'Europe', 'FRPI1463', 0),
(0, 'Saint-Arnoult-des-Bois', 'France', 'Europe', 'FRCE0978', 0),
(0, 'Saint-Arnoult-en-Yvelines', 'France', 'Europe', 'FRXX6761', 0),
(0, 'Saint-Arroman', 'France', 'Europe', 'FRMP1935', 0),
(0, 'Saint-Arroman', 'France', 'Europe', 'FRMP1936', 0),
(0, 'Saint-Arroumex', 'France', 'Europe', 'FRMP1937', 0),
(0, 'Saint-Astier', 'France', 'Europe', 'FRXX2604', 0),
(0, 'Saint-Auban', 'France', 'Europe', 'FRXX3901', 0),
(0, 'Saint-Auban-d`Oze', 'France', 'Europe', 'FRPA0508', 0),
(0, 'Saint-Auban-sur-l`Ouveze', 'France', 'Europe', 'FRRA1527', 0),
(0, 'Saint-Aubert', 'France', 'Europe', 'FRXX3337', 0),
(0, 'Saint-Aubert-sur-Orne', 'France', 'Europe', 'FRBN1089', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRAQ1251', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRAQ1252', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRBO1081', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRCA1229', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRCE0979', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRIF0520', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRNC0812', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRNC0813', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRPI1464', 0),
(0, 'Saint-Aubin', 'France', 'Europe', 'FRXX5891', 0),
(0, 'Saint-Aubin-Celloville', 'France', 'Europe', 'FRHN0736', 0),
(0, 'Saint-Aubin-Chateau-Neuf', 'France', 'Europe', 'FRBO1082', 0),
(0, 'Saint-Aubin-d`Appenai', 'France', 'Europe', 'FRBN1091', 0),
(0, 'Saint-Aubin-d`Arquenay', 'France', 'Europe', 'FRXX1054', 0),
(0, 'Saint-Aubin-d`Aubigne', 'France', 'Europe', 'FRBR0521', 0),
(0, 'Saint-Aubin-d`Ecrosville', 'France', 'Europe', 'FRHN0739', 0),
(0, 'Saint-Aubin-de-Baubigne', 'France', 'Europe', 'FRPC0830', 0),
(0, 'Saint-Aubin-de-Blaye', 'France', 'Europe', 'FRAQ1253', 0),
(0, 'Saint-Aubin-de-Bonneval', 'France', 'Europe', 'FRXX5142', 0),
(0, 'Saint-Aubin-de-Branne', 'France', 'Europe', 'FRAQ1254', 0),
(0, 'Saint-Aubin-de-Cadelech', 'France', 'Europe', 'FRXX4715', 0),
(0, 'Saint-Aubin-de-Courteraie', 'France', 'Europe', 'FRBN1092', 0),
(0, 'Saint-Aubin-de-Cretot', 'France', 'Europe', 'FRHN0740', 0),
(0, 'Saint-Aubin-de-Lanquais', 'France', 'Europe', 'FRXX6155', 0),
(0, 'Saint-Aubin-de-Locquenay', 'France', 'Europe', 'FRPL0744', 0),
(0, 'Saint-Aubin-de-Luigne', 'France', 'Europe', 'FRPL0745', 0),
(0, 'Saint-Aubin-de-Medoc', 'France', 'Europe', 'FRAQ1255', 0),
(0, 'Saint-Aubin-de-Nabirat', 'France', 'Europe', 'FRAQ1256', 0),
(0, 'Saint-Aubin-de-Scellon', 'France', 'Europe', 'FRHN0741', 0),
(0, 'Saint-Aubin-de-Terregatte', 'France', 'Europe', 'FRBN1093', 0),
(0, 'Saint-Aubin-des-Bois', 'France', 'Europe', 'FRBN1094', 0),
(0, 'Saint-Aubin-des-Bois', 'France', 'Europe', 'FRXX4132', 0),
(0, 'Saint-Aubin-des-Chateaux', 'France', 'Europe', 'FRPL0746', 0),
(0, 'Saint-Aubin-des-Chaumes', 'France', 'Europe', 'FRBO1083', 0),
(0, 'Saint-Aubin-des-Coudrais', 'France', 'Europe', 'FRPL0747', 0),
(0, 'Saint-Aubin-des-Grois', 'France', 'Europe', 'FRBN1095', 0),
(0, 'Thauron', 'France', 'Europe', 'FRLI0538', 0),
(0, 'Thauvenay', 'France', 'Europe', 'FRCE1206', 0),
(0, 'Thebe', 'France', 'Europe', 'FRMP2317', 0),
(0, 'Theding', 'France', 'Europe', 'FRLO1579', 0),
(0, 'Thedirac', 'France', 'Europe', 'FRMP2318', 0),
(0, 'Thegra', 'France', 'Europe', 'FRMP2319', 0),
(0, 'Thehillac', 'France', 'Europe', 'FRBR0705', 0),
(0, 'Theil-Rabier', 'France', 'Europe', 'FRPC1087', 0),
(0, 'Theillay', 'France', 'Europe', 'FRCE1207', 0),
(0, 'Theillement', 'France', 'Europe', 'FRHN0926', 0),
(0, 'Theix', 'France', 'Europe', 'FRAU0852', 0),
(0, 'Theix', 'France', 'Europe', 'FRXX5197', 0),
(0, 'Theize', 'France', 'Europe', 'FRRA1970', 0),
(0, 'Thel', 'France', 'Europe', 'FRRA1971', 0),
(0, 'Theligny', 'France', 'Europe', 'FRPL0994', 0),
(0, 'Thelis-la-Combe', 'France', 'Europe', 'FRRA1972', 0),
(0, 'Thelod', 'France', 'Europe', 'FRLO1580', 0),
(0, 'Thelonne', 'France', 'Europe', 'FRCA1430', 0),
(0, 'Thelus', 'France', 'Europe', 'FRNC0902', 0),
(0, 'Themericourt', 'France', 'Europe', 'FRIF0594', 0),
(0, 'Themines', 'France', 'Europe', 'FRMP2320', 0),
(0, 'Theminettes', 'France', 'Europe', 'FRMP2321', 0),
(0, 'Thenac', 'France', 'Europe', 'FRAQ1671', 0),
(0, 'Thenac', 'France', 'Europe', 'FRXX4739', 0),
(0, 'Thenailles', 'France', 'Europe', 'FRPI1600', 0),
(0, 'Thenay', 'France', 'Europe', 'FRCE1208', 0),
(0, 'Thenay', 'France', 'Europe', 'FRCE1209', 0),
(0, 'Thenelles', 'France', 'Europe', 'FRPI1601', 0),
(0, 'Thenesol', 'France', 'Europe', 'FRRA1973', 0),
(0, 'Theneuil', 'France', 'Europe', 'FRCE1210', 0),
(0, 'Theneuille', 'France', 'Europe', 'FRAU0853', 0),
(0, 'Thenezay', 'France', 'Europe', 'FRPC1088', 0),
(0, 'Thenioux', 'France', 'Europe', 'FRCE1211', 0),
(0, 'Thenissey', 'France', 'Europe', 'FRBO1368', 0),
(0, 'Thenisy', 'France', 'Europe', 'FRIF0595', 0),
(0, 'Thennelieres', 'France', 'Europe', 'FRCA1431', 0),
(0, 'Thennes', 'France', 'Europe', 'FRPI1602', 0),
(0, 'Thenon', 'France', 'Europe', 'FRAQ1672', 0),
(0, 'Thenorgues', 'France', 'Europe', 'FRCA1432', 0),
(0, 'Theoule-sur-Mer', 'France', 'Europe', 'FRXX2416', 0),
(0, 'Therdonne', 'France', 'Europe', 'FRPI1603', 0),
(0, 'Therines', 'France', 'Europe', 'FRPI1604', 0),
(0, 'Thermes-Magnoac', 'France', 'Europe', 'FRMP2322', 0),
(0, 'Therondels', 'France', 'Europe', 'FRMP2323', 0),
(0, 'Therouanne', 'France', 'Europe', 'FRXX4416', 0),
(0, 'Therouldeville', 'France', 'Europe', 'FRHN0927', 0),
(0, 'Thervay', 'France', 'Europe', 'FRFC1278', 0),
(0, 'Thesee', 'France', 'Europe', 'FRCE1212', 0),
(0, 'Thesy', 'France', 'Europe', 'FRFC1279', 0),
(0, 'Theuley', 'France', 'Europe', 'FRFC1280', 0),
(0, 'Theus', 'France', 'Europe', 'FRPA0633', 0),
(0, 'Theuville', 'France', 'Europe', 'FRCE1213', 0),
(0, 'Theuville', 'France', 'Europe', 'FRIF0596', 0),
(0, 'Theuville-aux-Maillots', 'France', 'Europe', 'FRHN0928', 0),
(0, 'Theuvy-Acheres', 'France', 'Europe', 'FRCE1214', 0),
(0, 'Thevet-Saint-Julien', 'France', 'Europe', 'FRCE1215', 0),
(0, 'Theville', 'France', 'Europe', 'FRBN1395', 0),
(0, 'Thevray', 'France', 'Europe', 'FRHN0929', 0),
(0, 'They-sous-Montfort', 'France', 'Europe', 'FRLO1581', 0),
(0, 'They-sous-Vaudemont', 'France', 'Europe', 'FRXX2815', 0),
(0, 'Theys', 'France', 'Europe', 'FRRA1974', 0),
(0, 'Theza', 'France', 'Europe', 'FRLR0893', 0),
(0, 'Thezac', 'France', 'Europe', 'FRAQ1673', 0),
(0, 'Thezac', 'France', 'Europe', 'FRPC1089', 0),
(0, 'Thezan-des-Corbieres', 'France', 'Europe', 'FRLR0894', 0),
(0, 'Thezan-les-Beziers', 'France', 'Europe', 'FRLR0895', 0),
(0, 'Theze', 'France', 'Europe', 'FRAQ1674', 0),
(0, 'Theze', 'France', 'Europe', 'FRPA0634', 0),
(0, 'Thezey-Saint-Martin', 'France', 'Europe', 'FRLO1582', 0),
(0, 'Theziers', 'France', 'Europe', 'FRXX5581', 0),
(0, 'Thezillieu', 'France', 'Europe', 'FRRA1975', 0),
(0, 'Thezy-Glimont', 'France', 'Europe', 'FRPI1605', 0),
(0, 'Thiais', 'France', 'Europe', 'FRXX3755', 0),
(0, 'Thiancourt', 'France', 'Europe', 'FRMP2324', 0),
(0, 'Thianges', 'France', 'Europe', 'FRBO1369', 0),
(0, 'Thiant', 'France', 'Europe', 'FRNC0903', 0),
(0, 'Thiat', 'France', 'Europe', 'FRXX2970', 0),
(0, 'Thiaucourt-Regnieville', 'France', 'Europe', 'FRLO1583', 0),
(0, 'Thiaville-sur-Meurthe', 'France', 'Europe', 'FRLO1584', 0),
(0, 'Thiberville', 'France', 'Europe', 'FRHN0930', 0),
(0, 'Varinfroy', 'France', 'Europe', 'FRPI1658', 0),
(0, 'Variscourt', 'France', 'Europe', 'FRPI1659', 0),
(0, 'Varize', 'France', 'Europe', 'FRCE1263', 0),
(0, 'Varize', 'France', 'Europe', 'FRLO1666', 0),
(0, 'Varmonzey', 'France', 'Europe', 'FRLO1667', 0),
(0, 'Varneville', 'France', 'Europe', 'FRLO1668', 0),
(0, 'Varneville-Bretteville', 'France', 'Europe', 'FRHN0972', 0),
(0, 'Varney', 'France', 'Europe', 'FRLO1669', 0),
(0, 'Varogne', 'France', 'Europe', 'FRFC1333', 0),
(0, 'Varois-et-Chaignot', 'France', 'Europe', 'FRXX3931', 0),
(0, 'Varouville', 'France', 'Europe', 'FRBN1444', 0),
(0, 'Varrains', 'France', 'Europe', 'FRPL1029', 0),
(0, 'Varreddes', 'France', 'Europe', 'FRIF0616', 0),
(0, 'Vars', 'France', 'Europe', 'FRFC1334', 0),
(0, 'Vars', 'France', 'Europe', 'FRPC1124', 0),
(0, 'Vars', 'France', 'Europe', 'FRXX0267', 0),
(0, 'Vars-sur-Roseix', 'France', 'Europe', 'FRLI0550', 0),
(0, 'Varsberg', 'France', 'Europe', 'FRLO1670', 0),
(0, 'Varzay', 'France', 'Europe', 'FRPC1125', 0),
(0, 'Varzy', 'France', 'Europe', 'FRBO1443', 0),
(0, 'Vascoeuil', 'France', 'Europe', 'FRHN0973', 0),
(0, 'Vasles', 'France', 'Europe', 'FRXX2319', 0),
(0, 'Vasouy', 'France', 'Europe', 'FRBN1445', 0),
(0, 'Vasperviller', 'France', 'Europe', 'FRLO1671', 0),
(0, 'Vassel', 'France', 'Europe', 'FRAU0895', 0),
(0, 'Vasselay', 'France', 'Europe', 'FRCE1264', 0),
(0, 'Vasselin', 'France', 'Europe', 'FRRA2048', 0),
(0, 'Vassens', 'France', 'Europe', 'FRPI1660', 0),
(0, 'Vasseny', 'France', 'Europe', 'FRPI1661', 0),
(0, 'Vassieux-en-Vercors', 'France', 'Europe', 'FRRA2049', 0),
(0, 'Vassimont-et-Chapelaine', 'France', 'Europe', 'FRCA1504', 0),
(0, 'Vassincourt', 'France', 'Europe', 'FRLO1672', 0),
(0, 'Vassogne', 'France', 'Europe', 'FRPI1662', 0),
(0, 'Vassonville', 'France', 'Europe', 'FRHN0974', 0),
(0, 'Vassy', 'France', 'Europe', 'FRBN1446', 0),
(0, 'Vassy', 'France', 'Europe', 'FRBO1444', 0),
(0, 'Vasteville', 'France', 'Europe', 'FRBN1447', 0),
(0, 'Vatan', 'France', 'Europe', 'FRXX4288', 0),
(0, 'Vathimenil', 'France', 'Europe', 'FRLO1673', 0),
(0, 'Vatierville', 'France', 'Europe', 'FRHN0975', 0),
(0, 'Vatilieu', 'France', 'Europe', 'FRRA2050', 0),
(0, 'Vatimont', 'France', 'Europe', 'FRLO1674', 0),
(0, 'Vatry', 'France', 'Europe', 'FRCA1505', 0),
(0, 'Vattetot-sous-Beaumont', 'France', 'Europe', 'FRHN0976', 0),
(0, 'Vattetot-sur-Mer', 'France', 'Europe', 'FRXX4314', 0),
(0, 'Vatteville', 'France', 'Europe', 'FRHN0977', 0),
(0, 'Vatteville-la-Rue', 'France', 'Europe', 'FRHN0978', 0),
(0, 'Vaubadon', 'France', 'Europe', 'FRBN1448', 0),
(0, 'Vauban', 'France', 'Europe', 'FRBO1445', 0),
(0, 'Vaubecourt', 'France', 'Europe', 'FRLO1675', 0),
(0, 'Vaubexy', 'France', 'Europe', 'FRLO1676', 0),
(0, 'Vauce', 'France', 'Europe', 'FRPL1030', 0),
(0, 'Vaucelles', 'France', 'Europe', 'FRBN1449', 0),
(0, 'Vaucelles-et-Beffecourt', 'France', 'Europe', 'FRPI1663', 0),
(0, 'Vauchamps', 'France', 'Europe', 'FRCA1506', 0),
(0, 'Vauchamps', 'France', 'Europe', 'FRFC1335', 0),
(0, 'Vauchassis', 'France', 'Europe', 'FRCA1507', 0),
(0, 'Vauchelles', 'France', 'Europe', 'FRPI1664', 0),
(0, 'Vauchelles-les-Authie', 'France', 'Europe', 'FRPI1665', 0),
(0, 'Vauchelles-les-Domart', 'France', 'Europe', 'FRXX5912', 0),
(0, 'Vauchelles-les-Quesnoy', 'France', 'Europe', 'FRPI1666', 0),
(0, 'Vauchignon', 'France', 'Europe', 'FRBO1446', 0),
(0, 'Vauchonvilliers', 'France', 'Europe', 'FRCA1508', 0),
(0, 'Vauchoux', 'France', 'Europe', 'FRFC1336', 0),
(0, 'Vauchretien', 'France', 'Europe', 'FRPL1031', 0),
(0, 'Vauciennes', 'France', 'Europe', 'FRCA1509', 0),
(0, 'Vauciennes', 'France', 'Europe', 'FRPI1667', 0),
(0, 'Vauclaix', 'France', 'Europe', 'FRBO1447', 0),
(0, 'Vauclerc', 'France', 'Europe', 'FRCA1510', 0),
(0, 'Vaucluse', 'France', 'Europe', 'FRFC1337', 0),
(0, 'Vauclusotte', 'France', 'Europe', 'FRFC1338', 0),
(0, 'Vaucogne', 'France', 'Europe', 'FRCA1511', 0),
(0, 'Vauconcourt-Nervezain', 'France', 'Europe', 'FRFC1339', 0),
(0, 'Vaucouleurs', 'France', 'Europe', 'FRLO1677', 0),
(0, 'Vaucourt', 'France', 'Europe', 'FRLO1678', 0),
(0, 'Vaucourtois', 'France', 'Europe', 'FRIF0617', 0),
(0, 'Vaucresson', 'France', 'Europe', 'FRXX6660', 0),
(0, 'Vaudancourt', 'France', 'Europe', 'FRPI1668', 0),
(0, 'Vaudebarrier', 'France', 'Europe', 'FRBO1448', 0),
(0, 'Vaudelnay', 'France', 'Europe', 'FRPL1032', 0),
(0, 'Ancemont', 'France', 'Europe', 'FRLO0026', 0),
(0, 'Ancenis', 'France', 'Europe', 'FRXX0305', 0),
(0, 'Ancerviller', 'France', 'Europe', 'FRLO0027', 0),
(0, 'Ancette', 'France', 'Europe', 'FRXX0216', 0),
(0, 'Ancey', 'France', 'Europe', 'FRBO0014', 0),
(0, 'Anchamps', 'France', 'Europe', 'FRCA0019', 0),
(0, 'Anche', 'France', 'Europe', 'FRCE0011', 0),
(0, 'Anche', 'France', 'Europe', 'FRPC0022', 0),
(0, 'Ancienville', 'France', 'Europe', 'FRPI0030', 0),
(0, 'Ancier', 'France', 'Europe', 'FRFC0031', 0),
(0, 'Ancinnes', 'France', 'Europe', 'FRPL0005', 0),
(0, 'Ancizan', 'France', 'Europe', 'FRMP0034', 0),
(0, 'Ancone', 'France', 'Europe', 'FRRA0041', 0),
(0, 'Ancourt', 'France', 'Europe', 'FRHN0009', 0),
(0, 'Ancteville', 'France', 'Europe', 'FRBN0016', 0),
(0, 'Anctoville', 'France', 'Europe', 'FRBN0017', 0),
(0, 'Ancy', 'France', 'Europe', 'FRRA0042', 0),
(0, 'Ancy-le-Franc', 'France', 'Europe', 'FRBO0015', 0),
(0, 'Ancy-le-Libre', 'France', 'Europe', 'FRBO0016', 0),
(0, 'Andainville', 'France', 'Europe', 'FRPI0031', 0),
(0, 'Andance', 'France', 'Europe', 'FRRA0043', 0),
(0, 'Andancette', 'France', 'Europe', 'FRRA0044', 0),
(0, 'Andard', 'France', 'Europe', 'FRPL0006', 0),
(0, 'Ande', 'France', 'Europe', 'FRHN0010', 0),
(0, 'Andechy', 'France', 'Europe', 'FRPI0032', 0),
(0, 'Andelain', 'France', 'Europe', 'FRPI0033', 0),
(0, 'Andelaroche', 'France', 'Europe', 'FRAU0006', 0),
(0, 'Andelarre', 'France', 'Europe', 'FRFC0032', 0),
(0, 'Andelarrot', 'France', 'Europe', 'FRFC0033', 0),
(0, 'Andelat', 'France', 'Europe', 'FRAU0007', 0),
(0, 'Andelnans', 'France', 'Europe', 'FRMP0035', 0),
(0, 'Andelot-Blancheville', 'France', 'Europe', 'FRCA0020', 0),
(0, 'Andelu', 'France', 'Europe', 'FRIF0010', 0),
(0, 'Andernay', 'France', 'Europe', 'FRLO0028', 0),
(0, 'Andernos-les-Bains', 'France', 'Europe', 'FRXX0323', 0),
(0, 'Anderny', 'France', 'Europe', 'FRLO0029', 0),
(0, 'Andevanne', 'France', 'Europe', 'FRCA0021', 0),
(0, 'Andeville', 'France', 'Europe', 'FRPI0034', 0),
(0, 'Andigne', 'France', 'Europe', 'FRPL0007', 0),
(0, 'Andillac', 'France', 'Europe', 'FRMP0036', 0),
(0, 'Andilly', 'France', 'Europe', 'FRIF0011', 0),
(0, 'Andilly', 'France', 'Europe', 'FRLO0030', 0),
(0, 'Andilly', 'France', 'Europe', 'FRRA0045', 0),
(0, 'Andiran', 'France', 'Europe', 'FRAQ0016', 0),
(0, 'Andoins', 'France', 'Europe', 'FRAQ0017', 0),
(0, 'Andolsheim', 'France', 'Europe', 'FRAL0004', 0),
(0, 'Andonville', 'France', 'Europe', 'FRCE0012', 0),
(0, 'Andornay', 'France', 'Europe', 'FRFC0034', 0),
(0, 'Andouille', 'France', 'Europe', 'FRPL0008', 0),
(0, 'Andouque', 'France', 'Europe', 'FRMP0037', 0),
(0, 'Andrein', 'France', 'Europe', 'FRAQ0018', 0),
(0, 'Andres', 'France', 'Europe', 'FRNC0023', 0),
(0, 'Andrest', 'France', 'Europe', 'FRMP0038', 0),
(0, 'Andresy', 'France', 'Europe', 'FRXX1617', 0),
(0, 'Andreze', 'France', 'Europe', 'FRPL0009', 0),
(0, 'Andrezel', 'France', 'Europe', 'FRIF0012', 0),
(0, 'Andrezieux-Boutheon', 'France', 'Europe', 'FRRA0046', 0),
(0, 'Andryes', 'France', 'Europe', 'FRBO0017', 0),
(0, 'Anduze', 'France', 'Europe', 'FRLR0020', 0),
(0, 'Aneres', 'France', 'Europe', 'FRMP0039', 0),
(0, 'Angais', 'France', 'Europe', 'FRAQ0019', 0),
(0, 'Ange', 'France', 'Europe', 'FRCE0013', 0),
(0, 'Angecourt', 'France', 'Europe', 'FRCA0022', 0),
(0, 'Angeduc', 'France', 'Europe', 'FRPC0023', 0),
(0, 'Angely', 'France', 'Europe', 'FRBO0018', 0),
(0, 'Angeot', 'France', 'Europe', 'FRMP0040', 0),
(0, 'Angers', 'France', 'Europe', 'FRXX0137', 0),
(0, 'Angerville', 'France', 'Europe', 'FRBN0018', 0),
(0, 'Angerville', 'France', 'Europe', 'FRXX5958', 0),
(0, 'Angervilliers', 'France', 'Europe', 'FRIF0013', 0),
(0, 'Angeville', 'France', 'Europe', 'FRMP0041', 0),
(0, 'Angey', 'France', 'Europe', 'FRBN0019', 0),
(0, 'Angicourt', 'France', 'Europe', 'FRPI0035', 0),
(0, 'Angiens', 'France', 'Europe', 'FRHN0011', 0),
(0, 'Angirey', 'France', 'Europe', 'FRFC0035', 0),
(0, 'Angivillers', 'France', 'Europe', 'FRPI0036', 0),
(0, 'Anglade', 'France', 'Europe', 'FRAQ0020', 0),
(0, 'Anglars', 'France', 'Europe', 'FRMP0042', 0),
(0, 'Anglars-Nozac', 'France', 'Europe', 'FRMP0043', 0),
(0, 'Anglemont', 'France', 'Europe', 'FRLO0031', 0),
(0, 'Beauche', 'France', 'Europe', 'FRCE0048', 0),
(0, 'Beauchemin', 'France', 'Europe', 'FRCA0096', 0),
(0, 'Beauchene', 'France', 'Europe', 'FRBN0063', 0),
(0, 'Beauchene', 'France', 'Europe', 'FRCE0049', 0),
(0, 'Beauchery-Saint-Martin', 'France', 'Europe', 'FRIF0045', 0),
(0, 'Beauclair', 'France', 'Europe', 'FRLO0114', 0),
(0, 'Beaucourt', 'France', 'Europe', 'FRMP0200', 0),
(0, 'Beaucouze', 'France', 'Europe', 'FRPL0042', 0),
(0, 'Beaucroissant', 'France', 'Europe', 'FRRA0131', 0),
(0, 'Beaudeduit', 'France', 'Europe', 'FRPI0112', 0),
(0, 'Beaudignies', 'France', 'Europe', 'FRNC0084', 0),
(0, 'Beaudricourt', 'France', 'Europe', 'FRNC0085', 0),
(0, 'Beaufai', 'France', 'Europe', 'FRBN0064', 0),
(0, 'Beaufay', 'France', 'Europe', 'FRPL0043', 0),
(0, 'Beauficel', 'France', 'Europe', 'FRBN0065', 0),
(0, 'Beaufin', 'France', 'Europe', 'FRRA0132', 0),
(0, 'Beaufort', 'France', 'Europe', 'FRLR0066', 0),
(0, 'Beaufort', 'France', 'Europe', 'FRMP0201', 0),
(0, 'Beaufort', 'France', 'Europe', 'FRNC0086', 0),
(0, 'Beaufort', 'France', 'Europe', 'FRRA0133', 0),
(0, 'Beaufort-Blavincourt', 'France', 'Europe', 'FRNC0087', 0),
(0, 'Beaufou', 'France', 'Europe', 'FRPL0044', 0),
(0, 'Beaufour-Druval', 'France', 'Europe', 'FRBN0066', 0),
(0, 'Beaufremont', 'France', 'Europe', 'FRLO0115', 0),
(0, 'Beaugas', 'France', 'Europe', 'FRAQ0124', 0),
(0, 'Beaugeay', 'France', 'Europe', 'FRPC0075', 0),
(0, 'Beaujeu', 'France', 'Europe', 'FRPA0045', 0),
(0, 'Beaulandais', 'France', 'Europe', 'FRBN0067', 0),
(0, 'Beaulencourt', 'France', 'Europe', 'FRNC0088', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRAU0044', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRAU0045', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRBN0068', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRBN0069', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRBO0070', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRBO0071', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRCA0097', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRCE0050', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRLR0067', 0),
(0, 'Beaulieu', 'France', 'Europe', 'FRRA0134', 0),
(0, 'Beaulieu-sur-Loire', 'France', 'Europe', 'FRXX5695', 0),
(0, 'Beaulieu-sur-Mer', 'France', 'Europe', 'FRXX3153', 0),
(0, 'Beaulon', 'France', 'Europe', 'FRAU0046', 0),
(0, 'Beaumais', 'France', 'Europe', 'FRBN0070', 0),
(0, 'Beaumarches', 'France', 'Europe', 'FRMP0202', 0),
(0, 'Beaumat', 'France', 'Europe', 'FRMP0203', 0),
(0, 'Beaume', 'France', 'Europe', 'FRPI0113', 0),
(0, 'Beaumenil', 'France', 'Europe', 'FRLO0116', 0),
(0, 'Beaumesnil', 'France', 'Europe', 'FRBN0071', 0),
(0, 'Beaumesnil', 'France', 'Europe', 'FRHN0035', 0),
(0, 'Beaumettes', 'France', 'Europe', 'FRPA0046', 0),
(0, 'Beaumetz', 'France', 'Europe', 'FRPI0114', 0),
(0, 'Beaumetz-les-Loges', 'France', 'Europe', 'FRNC0089', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRBO0072', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRLI0030', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRLO0117', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRMP0204', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRPC0076', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRRA0135', 0),
(0, 'Beaumont', 'France', 'Europe', 'FRXX0335', 0),
(0, 'Beaumont-du-Lac', 'France', 'Europe', 'FRLI0031', 0),
(0, 'Beaumont-en-Verdunois', 'France', 'Europe', 'FRLO0118', 0),
(0, 'Beaunay', 'France', 'Europe', 'FRCA0098', 0),
(0, 'Beaune', 'France', 'Europe', 'FRRA0136', 0),
(0, 'Beaune', 'France', 'Europe', 'FRXX0392', 0),
(0, 'Beaune-les-Mines', 'France', 'Europe', 'FRXX3738', 0),
(0, 'Beaunotte', 'France', 'Europe', 'FRBO0073', 0),
(0, 'Beaupont', 'France', 'Europe', 'FRRA0137', 0),
(0, 'Beaupouyet', 'France', 'Europe', 'FRAQ0125', 0),
(0, 'Beaupreau', 'France', 'Europe', 'FRPL0045', 0),
(0, 'Beaupuy', 'France', 'Europe', 'FRAQ0126', 0),
(0, 'Beaupuy', 'France', 'Europe', 'FRMP0205', 0),
(0, 'Beaupuy', 'France', 'Europe', 'FRMP0206', 0),
(0, 'Beaupuy', 'France', 'Europe', 'FRMP0207', 0),
(0, 'Beauquesne', 'France', 'Europe', 'FRPI0115', 0),
(0, 'Beaurain', 'France', 'Europe', 'FRNC0090', 0),
(0, 'Beaurains', 'France', 'Europe', 'FRNC0091', 0),
(0, 'Beaurecueil', 'France', 'Europe', 'FRPA0047', 0),
(0, 'Beauregard', 'France', 'Europe', 'FRMP0208', 0),
(0, 'Beauregard', 'France', 'Europe', 'FRRA0138', 0),
(0, 'Beauregard-l`Eveque', 'France', 'Europe', 'FRXX3450', 0),
(0, 'Cattenieres', 'France', 'Europe', 'FRNC0206', 0),
(0, 'Cattenom', 'France', 'Europe', 'FRLO0241', 0),
(0, 'Catteville', 'France', 'Europe', 'FRBN0184', 0),
(0, 'Catus', 'France', 'Europe', 'FRMP0462', 0),
(0, 'Catz', 'France', 'Europe', 'FRBN0185', 0),
(0, 'Caubeyres', 'France', 'Europe', 'FRAQ0289', 0),
(0, 'Caubiac', 'France', 'Europe', 'FRMP0463', 0),
(0, 'Caubous', 'France', 'Europe', 'FRMP0464', 0),
(0, 'Caubous', 'France', 'Europe', 'FRMP0465', 0),
(0, 'Caucalieres', 'France', 'Europe', 'FRMP0466', 0),
(0, 'Caucourt', 'France', 'Europe', 'FRNC0207', 0),
(0, 'Caudan', 'France', 'Europe', 'FRXX3782', 0),
(0, 'Caudebronde', 'France', 'Europe', 'FRLR0140', 0),
(0, 'Caudecoste', 'France', 'Europe', 'FRAQ0290', 0),
(0, 'Caudeval', 'France', 'Europe', 'FRMP0467', 0),
(0, 'Caudrot', 'France', 'Europe', 'FRAQ0291', 0),
(0, 'Caudry', 'France', 'Europe', 'FRNC0208', 0),
(0, 'Cauffry', 'France', 'Europe', 'FRPI0292', 0),
(0, 'Caujac', 'France', 'Europe', 'FRMP0468', 0),
(0, 'Caulaincourt', 'France', 'Europe', 'FRPI0293', 0),
(0, 'Caulieres', 'France', 'Europe', 'FRPI0294', 0),
(0, 'Caullery', 'France', 'Europe', 'FRNC0209', 0),
(0, 'Caumont', 'France', 'Europe', 'FRAQ0292', 0),
(0, 'Caumont', 'France', 'Europe', 'FRMP0469', 0),
(0, 'Caumont', 'France', 'Europe', 'FRMP0470', 0),
(0, 'Caumont', 'France', 'Europe', 'FRMP0471', 0),
(0, 'Caumont', 'France', 'Europe', 'FRNC0210', 0),
(0, 'Caumont', 'France', 'Europe', 'FRPI0295', 0),
(0, 'Caumont-sur-Durance', 'France', 'Europe', 'FRXX4586', 0),
(0, 'Cauna', 'France', 'Europe', 'FRAQ0293', 0),
(0, 'Caunay', 'France', 'Europe', 'FRPC0153', 0),
(0, 'Cauneille', 'France', 'Europe', 'FRAQ0294', 0),
(0, 'Caupenne', 'France', 'Europe', 'FRAQ0295', 0),
(0, 'Caurel', 'France', 'Europe', 'FRCA0194', 0),
(0, 'Cauro', 'France', 'Europe', 'FRCO0054', 0),
(0, 'Cauroir', 'France', 'Europe', 'FRNC0211', 0),
(0, 'Cauroy', 'France', 'Europe', 'FRCA0195', 0),
(0, 'Caussade', 'France', 'Europe', 'FRMP0472', 0),
(0, 'Causse-Begon', 'France', 'Europe', 'FRLR0141', 0),
(0, 'Causse-et-Diege', 'France', 'Europe', 'FRMP0473', 0),
(0, 'Caussens', 'France', 'Europe', 'FRMP0474', 0),
(0, 'Causses-et-Veyran', 'France', 'Europe', 'FRLR0142', 0),
(0, 'Caussiniojouls', 'France', 'Europe', 'FRLR0143', 0),
(0, 'Caussols', 'France', 'Europe', 'FRPA0101', 0),
(0, 'Caussou', 'France', 'Europe', 'FRMP0475', 0),
(0, 'Cauterets', 'France', 'Europe', 'FRXX0220', 0),
(0, 'Cauvicourt', 'France', 'Europe', 'FRBN0186', 0),
(0, 'Cauvignac', 'France', 'Europe', 'FRAQ0296', 0),
(0, 'Cauvigny', 'France', 'Europe', 'FRPI0296', 0),
(0, 'Cauville', 'France', 'Europe', 'FRBN0187', 0),
(0, 'Caux', 'France', 'Europe', 'FRXX1878', 0),
(0, 'Cauzac', 'France', 'Europe', 'FRAQ0297', 0),
(0, 'Cavagnac', 'France', 'Europe', 'FRMP0476', 0),
(0, 'Cavalaire-sur-Mer', 'France', 'Europe', 'FRXX2018', 0),
(0, 'Cavaliere', 'France', 'Europe', 'FRPA0102', 0),
(0, 'Cavanac', 'France', 'Europe', 'FRLR0144', 0),
(0, 'Cavarc', 'France', 'Europe', 'FRAQ0298', 0),
(0, 'Caveirac', 'France', 'Europe', 'FRXX5562', 0),
(0, 'Caves', 'France', 'Europe', 'FRLR0145', 0),
(0, 'Cavignac', 'France', 'Europe', 'FRAQ0299', 0),
(0, 'Cavigny', 'France', 'Europe', 'FRBN0188', 0),
(0, 'Cavillargues', 'France', 'Europe', 'FRPA0103', 0),
(0, 'Cavillon', 'France', 'Europe', 'FRPI0297', 0),
(0, 'Caychax', 'France', 'Europe', 'FRMP0477', 0),
(0, 'Cayenne', 'France', 'Europe', 'FRXX7771', 0),
(0, 'Cayeux-sur-Mer', 'France', 'Europe', 'FRXX1505', 0),
(0, 'Caylus', 'France', 'Europe', 'FRMP0478', 0),
(0, 'Cayrac', 'France', 'Europe', 'FRMP0479', 0),
(0, 'Cayres', 'France', 'Europe', 'FRAU0090', 0),
(0, 'Cayriech', 'France', 'Europe', 'FRMP0480', 0),
(0, 'Cayrols', 'France', 'Europe', 'FRAU0091', 0),
(0, 'Cazac', 'France', 'Europe', 'FRMP0481', 0),
(0, 'Cazalis', 'France', 'Europe', 'FRAQ0300', 0),
(0, 'Cazalis', 'France', 'Europe', 'FRAQ0301', 0),
(0, 'Cazalrenoux', 'France', 'Europe', 'FRLR0146', 0),
(0, 'Cazals', 'France', 'Europe', 'FRMP0482', 0),
(0, 'Cazarilh', 'France', 'Europe', 'FRMP0483', 0),
(0, 'Cazats', 'France', 'Europe', 'FRAQ0302', 0),
(0, 'Cazaubon', 'France', 'Europe', 'FRMP0484', 0),
(0, 'Cazaugitat', 'France', 'Europe', 'FRAQ0303', 0),
(0, 'Doudeauville', 'France', 'Europe', 'FRNC0272', 0),
(0, 'Doudeauville-en-Vexin', 'France', 'Europe', 'FRHN0183', 0),
(0, 'Doudelainville', 'France', 'Europe', 'FRPI0467', 0),
(0, 'Doudrac', 'France', 'Europe', 'FRAQ0389', 0),
(0, 'Doue', 'France', 'Europe', 'FRIF0172', 0),
(0, 'Doue', 'France', 'Europe', 'FRXX0311', 0),
(0, 'Douelle', 'France', 'Europe', 'FRMP0608', 0),
(0, 'Douilly', 'France', 'Europe', 'FRPI0468', 0),
(0, 'Doulaincourt-Saucourt', 'France', 'Europe', 'FRCA0383', 0),
(0, 'Doulaize', 'France', 'Europe', 'FRFC0406', 0),
(0, 'Doulcon', 'France', 'Europe', 'FRLO0397', 0),
(0, 'Doulezon', 'France', 'Europe', 'FRAQ0390', 0),
(0, 'Doullens', 'France', 'Europe', 'FRPI0469', 0),
(0, 'Doumy', 'France', 'Europe', 'FRAQ0391', 0),
(0, 'Dounoux', 'France', 'Europe', 'FRLO0398', 0),
(0, 'Dourbies', 'France', 'Europe', 'FRLR0216', 0),
(0, 'Dourges', 'France', 'Europe', 'FRXX4414', 0),
(0, 'Dourgne', 'France', 'Europe', 'FRMP0609', 0),
(0, 'Douriez', 'France', 'Europe', 'FRNC0273', 0),
(0, 'Dourlers', 'France', 'Europe', 'FRNC0274', 0),
(0, 'Dournazac', 'France', 'Europe', 'FRLI0117', 0),
(0, 'Dournon', 'France', 'Europe', 'FRFC0407', 0),
(0, 'Dours', 'France', 'Europe', 'FRMP0610', 0),
(0, 'Doussard', 'France', 'Europe', 'FRRA0497', 0),
(0, 'Doussay', 'France', 'Europe', 'FRPC0292', 0),
(0, 'Douvaine', 'France', 'Europe', 'FRRA0498', 0),
(0, 'Douvrend', 'France', 'Europe', 'FRHN0184', 0),
(0, 'Douvres', 'France', 'Europe', 'FRRA0499', 0),
(0, 'Douvrin', 'France', 'Europe', 'FRNC0275', 0),
(0, 'Doux', 'France', 'Europe', 'FRCA0384', 0),
(0, 'Doux', 'France', 'Europe', 'FRPC0293', 0),
(0, 'Douzains', 'France', 'Europe', 'FRAQ0392', 0),
(0, 'Douzat', 'France', 'Europe', 'FRPC0294', 0),
(0, 'Douzens', 'France', 'Europe', 'FRLR0217', 0),
(0, 'Douzillac', 'France', 'Europe', 'FRAQ0393', 0),
(0, 'Douzy', 'France', 'Europe', 'FRCA0385', 0),
(0, 'Doville', 'France', 'Europe', 'FRBN0312', 0),
(0, 'Doye', 'France', 'Europe', 'FRFC0408', 0),
(0, 'Doyet', 'France', 'Europe', 'FRAU0212', 0),
(0, 'Dozule', 'France', 'Europe', 'FRBN0313', 0),
(0, 'Drace', 'France', 'Europe', 'FRRA0500', 0),
(0, 'Drache', 'France', 'Europe', 'FRCE0279', 0),
(0, 'Drachenbronn-Birlenbach', 'France', 'Europe', 'FRAL0092', 0),
(0, 'Dragey-Ronthon', 'France', 'Europe', 'FRBN0314', 0),
(0, 'Draguignan', 'France', 'Europe', 'FRXX1311', 0),
(0, 'Drain', 'France', 'Europe', 'FRPL0200', 0),
(0, 'Draize', 'France', 'Europe', 'FRCA0386', 0),
(0, 'Drambon', 'France', 'Europe', 'FRBO0364', 0),
(0, 'Dramelay', 'France', 'Europe', 'FRFC0409', 0),
(0, 'Drancy', 'France', 'Europe', 'FRXX0293', 0),
(0, 'Dravegny', 'France', 'Europe', 'FRPI0470', 0),
(0, 'Dree', 'France', 'Europe', 'FRBO0365', 0),
(0, 'Dreslincourt', 'France', 'Europe', 'FRPI0471', 0),
(0, 'Dreuil-Hamel', 'France', 'Europe', 'FRPI0472', 0),
(0, 'Dreuilhe', 'France', 'Europe', 'FRMP0611', 0),
(0, 'Dreux', 'France', 'Europe', 'FRXX0037', 0),
(0, 'Drevant', 'France', 'Europe', 'FRCE0280', 0),
(0, 'Dricourt', 'France', 'Europe', 'FRCA0387', 0),
(0, 'Driencourt', 'France', 'Europe', 'FRPI0473', 0),
(0, 'Drignac', 'France', 'Europe', 'FRLI0118', 0),
(0, 'Drincham', 'France', 'Europe', 'FRNC0276', 0),
(0, 'Drocourt', 'France', 'Europe', 'FRIF0173', 0),
(0, 'Drocourt', 'France', 'Europe', 'FRNC0277', 0),
(0, 'Droisy', 'France', 'Europe', 'FRHN0185', 0),
(0, 'Droisy', 'France', 'Europe', 'FRRA0501', 0),
(0, 'Droitaumont', 'France', 'Europe', 'FRLO0399', 0),
(0, 'Droitfontaine', 'France', 'Europe', 'FRFC0410', 0),
(0, 'Droiturier', 'France', 'Europe', 'FRAU0213', 0),
(0, 'Droizy', 'France', 'Europe', 'FRPI0474', 0),
(0, 'Drom', 'France', 'Europe', 'FRRA0502', 0),
(0, 'Dromesnil', 'France', 'Europe', 'FRPI0475', 0),
(0, 'Drosay', 'France', 'Europe', 'FRHN0186', 0),
(0, 'Drosnay', 'France', 'Europe', 'FRCA0388', 0),
(0, 'Droue', 'France', 'Europe', 'FRCE0281', 0),
(0, 'Drouilly', 'France', 'Europe', 'FRCA0389', 0),
(0, 'Drouville', 'France', 'Europe', 'FRLO0400', 0),
(0, 'Droux', 'France', 'Europe', 'FRLI0119', 0),
(0, 'Droyes', 'France', 'Europe', 'FRCA0390', 0),
(0, 'Drubec', 'France', 'Europe', 'FRBN0315', 0),
(0, 'Drucat', 'France', 'Europe', 'FRPI0476', 0),
(0, 'Escoublac-la-Baule', 'France', 'Europe', 'FRXX0303', 0),
(0, 'Escoulis', 'France', 'Europe', 'FRMP0654', 0),
(0, 'Escouloubre', 'France', 'Europe', 'FRLR0221', 0),
(0, 'Escource', 'France', 'Europe', 'FRAQ0408', 0),
(0, 'Escoussans', 'France', 'Europe', 'FRAQ0409', 0),
(0, 'Escoussens', 'France', 'Europe', 'FRMP0655', 0),
(0, 'Escout', 'France', 'Europe', 'FRXX5664', 0),
(0, 'Escoutoux', 'France', 'Europe', 'FRAU0225', 0),
(0, 'Escoville', 'France', 'Europe', 'FRBN0339', 0),
(0, 'Escragnolles', 'France', 'Europe', 'FRPA0165', 0),
(0, 'Escrennes', 'France', 'Europe', 'FRCE0301', 0),
(0, 'Escrignelles', 'France', 'Europe', 'FRCE0302', 0),
(0, 'Escueillens-et-Saint-Just-de-Belengard', 'France', 'Europe', 'FRLR0222', 0),
(0, 'Escures', 'France', 'Europe', 'FRAQ0410', 0),
(0, 'Escurolles', 'France', 'Europe', 'FRAU0226', 0),
(0, 'Esery', 'France', 'Europe', 'FRRA0529', 0),
(0, 'Eslettes', 'France', 'Europe', 'FRHN0213', 0),
(0, 'Esley', 'France', 'Europe', 'FRLO0422', 0),
(0, 'Esmans', 'France', 'Europe', 'FRIF0183', 0),
(0, 'Esmery-Hallon', 'France', 'Europe', 'FRPI0514', 0),
(0, 'Esmoulieres', 'France', 'Europe', 'FRFC0438', 0),
(0, 'Esmoulins', 'France', 'Europe', 'FRFC0439', 0),
(0, 'Esnandes', 'France', 'Europe', 'FRPC0311', 0),
(0, 'Esnans', 'France', 'Europe', 'FRFC0440', 0),
(0, 'Esnes', 'France', 'Europe', 'FRNC0316', 0),
(0, 'Esnon', 'France', 'Europe', 'FRBO0392', 0),
(0, 'Esnouveaux', 'France', 'Europe', 'FRCA0415', 0),
(0, 'Espagnac', 'France', 'Europe', 'FRLI0122', 0),
(0, 'Espagnac-Sainte-Eulalie', 'France', 'Europe', 'FRMP0656', 0),
(0, 'Espalais', 'France', 'Europe', 'FRMP0657', 0),
(0, 'Espalem', 'France', 'Europe', 'FRAU0227', 0),
(0, 'Espalion', 'France', 'Europe', 'FRMP0658', 0),
(0, 'Espanes', 'France', 'Europe', 'FRMP0659', 0),
(0, 'Espaon', 'France', 'Europe', 'FRMP0660', 0),
(0, 'Esparron', 'France', 'Europe', 'FRMP0661', 0),
(0, 'Esparron', 'France', 'Europe', 'FRPA0166', 0),
(0, 'Esparron', 'France', 'Europe', 'FRPA0167', 0),
(0, 'Esparros', 'France', 'Europe', 'FRMP0662', 0),
(0, 'Esparsac', 'France', 'Europe', 'FRMP0663', 0),
(0, 'Espartignac', 'France', 'Europe', 'FRLI0123', 0),
(0, 'Espas', 'France', 'Europe', 'FRMP0664', 0),
(0, 'Espaubourg', 'France', 'Europe', 'FRPI0515', 0),
(0, 'Espeche', 'France', 'Europe', 'FRMP0665', 0),
(0, 'Espechede', 'France', 'Europe', 'FRAQ0411', 0),
(0, 'Espedaillac', 'France', 'Europe', 'FRMP0666', 0),
(0, 'Espeluche', 'France', 'Europe', 'FRRA0530', 0),
(0, 'Espenel', 'France', 'Europe', 'FRRA0531', 0),
(0, 'Esperausses', 'France', 'Europe', 'FRMP0667', 0),
(0, 'Esperce', 'France', 'Europe', 'FRMP0668', 0),
(0, 'Espere', 'France', 'Europe', 'FRMP0669', 0),
(0, 'Espeyrac', 'France', 'Europe', 'FRMP0670', 0),
(0, 'Espeyroux', 'France', 'Europe', 'FRMP0671', 0),
(0, 'Espezel', 'France', 'Europe', 'FRLR0223', 0),
(0, 'Espieilh', 'France', 'Europe', 'FRMP0672', 0),
(0, 'Espiens', 'France', 'Europe', 'FRAQ0412', 0),
(0, 'Espiet', 'France', 'Europe', 'FRAQ0413', 0),
(0, 'Espinas', 'France', 'Europe', 'FRMP0673', 0),
(0, 'Espinasse', 'France', 'Europe', 'FRAU0228', 0),
(0, 'Espinasse', 'France', 'Europe', 'FRAU0229', 0),
(0, 'Espinasses', 'France', 'Europe', 'FRPA0168', 0),
(0, 'Espinchal', 'France', 'Europe', 'FRAU0230', 0),
(0, 'Espins', 'France', 'Europe', 'FRBN0340', 0),
(0, 'Espirat', 'France', 'Europe', 'FRAU0231', 0),
(0, 'Espiute', 'France', 'Europe', 'FRAQ0414', 0),
(0, 'Esplantas', 'France', 'Europe', 'FRAU0232', 0),
(0, 'Esplas', 'France', 'Europe', 'FRMP0674', 0),
(0, 'Esplas-de-Serou', 'France', 'Europe', 'FRMP0675', 0),
(0, 'Espoey', 'France', 'Europe', 'FRAQ0415', 0),
(0, 'Espondeilhan', 'France', 'Europe', 'FRLR0224', 0),
(0, 'Esprels', 'France', 'Europe', 'FRFC0441', 0),
(0, 'Esqueheries', 'France', 'Europe', 'FRPI0516', 0),
(0, 'Esquelbecq', 'France', 'Europe', 'FRNC0317', 0),
(0, 'Esquennoy', 'France', 'Europe', 'FRPI0517', 0),
(0, 'Esquerchin', 'France', 'Europe', 'FRNC0318', 0),
(0, 'Esquerdes', 'France', 'Europe', 'FRNC0319', 0),
(0, 'Essarois', 'France', 'Europe', 'FRBO0393', 0),
(0, 'Essavilly', 'France', 'Europe', 'FRFC0442', 0),
(0, 'Esse', 'France', 'Europe', 'FRPC0312', 0),
(0, 'Essegney', 'France', 'Europe', 'FRLO0423', 0),
(0, 'Essert', 'France', 'Europe', 'FRBO0394', 0),
(0, 'Fondamente', 'France', 'Europe', 'FRMP0727', 0),
(0, 'Fondremand', 'France', 'Europe', 'FRFC0477', 0),
(0, 'Fonds-Saint-Denis', 'France', 'Europe', 'FRXX7766', 0),
(0, 'Fongalop', 'France', 'Europe', 'FRAQ0454', 0),
(0, 'Fongrave', 'France', 'Europe', 'FRAQ0455', 0),
(0, 'Fongueusemare', 'France', 'Europe', 'FRHN0233', 0),
(0, 'Fonroque', 'France', 'Europe', 'FRAQ0456', 0),
(0, 'Fons', 'France', 'Europe', 'FRMP0728', 0),
(0, 'Fons', 'France', 'Europe', 'FRRA0577', 0),
(0, 'Fonsommes', 'France', 'Europe', 'FRPI0575', 0),
(0, 'Fonsorbes', 'France', 'Europe', 'FRMP0729', 0),
(0, 'Font Romeu', 'France', 'Europe', 'FRXX0551', 0),
(0, 'Fontain', 'France', 'Europe', 'FRFC0478', 0),
(0, 'Fontaine', 'France', 'Europe', 'FRCA0456', 0),
(0, 'Fontaine', 'France', 'Europe', 'FRMP0730', 0),
(0, 'Fontaine', 'France', 'Europe', 'FRXX4254', 0),
(0, 'Fontaine-Chaalis', 'France', 'Europe', 'FRPI0576', 0),
(0, 'Fontaine-Fourches', 'France', 'Europe', 'FRIF0197', 0),
(0, 'Fontaine-Francaise', 'France', 'Europe', 'FRBO0424', 0),
(0, 'Fontaine-Guerin', 'France', 'Europe', 'FRPL0221', 0),
(0, 'Fontaine-l`Abbe', 'France', 'Europe', 'FRHN0234', 0),
(0, 'Fontaine-le-Port', 'France', 'Europe', 'FRIF0198', 0),
(0, 'Fontaine-les-Clerval', 'France', 'Europe', 'FRFC0479', 0),
(0, 'Fontaine-Macon', 'France', 'Europe', 'FRCA0457', 0),
(0, 'Fontaine-Milon', 'France', 'Europe', 'FRPL0222', 0),
(0, 'Fontaine-Raoul', 'France', 'Europe', 'FRCE0323', 0),
(0, 'Fontaine-Simon', 'France', 'Europe', 'FRCE0324', 0),
(0, 'Fontainebleau', 'France', 'Europe', 'FRXX3399', 0),
(0, 'Fontainebrux', 'France', 'Europe', 'FRFC0480', 0),
(0, 'Fontaines', 'France', 'Europe', 'FRBO0425', 0),
(0, 'Fontaines', 'France', 'Europe', 'FRBO0426', 0),
(0, 'Fontaines', 'France', 'Europe', 'FRPL0223', 0),
(0, 'Fontains', 'France', 'Europe', 'FRIF0199', 0),
(0, 'Fontan', 'France', 'Europe', 'FRPA0178', 0),
(0, 'Fontanes', 'France', 'Europe', 'FRLR0240', 0),
(0, 'Fontanes', 'France', 'Europe', 'FRLR0241', 0),
(0, 'Fontanes', 'France', 'Europe', 'FRMP0731', 0),
(0, 'Fontanes', 'France', 'Europe', 'FRRA0578', 0),
(0, 'Fontanges', 'France', 'Europe', 'FRAU0242', 0),
(0, 'Fontangy', 'France', 'Europe', 'FRBO0427', 0),
(0, 'Fontanieres', 'France', 'Europe', 'FRLI0140', 0),
(0, 'Fontannes', 'France', 'Europe', 'FRAU0243', 0),
(0, 'Fontans', 'France', 'Europe', 'FRLR0242', 0),
(0, 'Fontareches', 'France', 'Europe', 'FRPA0179', 0),
(0, 'Fontclaireau', 'France', 'Europe', 'FRPC0330', 0),
(0, 'Fontcouverte', 'France', 'Europe', 'FRLR0243', 0),
(0, 'Fontcouverte', 'France', 'Europe', 'FRPC0331', 0),
(0, 'Fontcouverte-la Toussuire', 'France', 'Europe', 'FRRA0579', 0),
(0, 'Fontenailles', 'France', 'Europe', 'FRBO0428', 0),
(0, 'Fontenailles', 'France', 'Europe', 'FRIF0200', 0),
(0, 'Fontenay', 'France', 'Europe', 'FRBN0365', 0),
(0, 'Fontenay', 'France', 'Europe', 'FRBO0429', 0),
(0, 'Fontenay', 'France', 'Europe', 'FRCE0325', 0),
(0, 'Fontenay', 'France', 'Europe', 'FRHN0235', 0),
(0, 'Fontenay', 'France', 'Europe', 'FRHN0236', 0),
(0, 'Fontenay', 'France', 'Europe', 'FRLO0472', 0),
(0, 'Fontenay-aux-Roses', 'France', 'Europe', 'FRXX4632', 0),
(0, 'Fontenay-le-Comte', 'France', 'Europe', 'FRXX0315', 0),
(0, 'Fontenay-le-Fleury', 'France', 'Europe', 'FRXX2111', 0),
(0, 'Fontenay-sous-Bois', 'France', 'Europe', 'FRXX6715', 0),
(0, 'Fontenay-sous-Fouronnes', 'France', 'Europe', 'FRBO0430', 0),
(0, 'Fontenay-Tresigny', 'France', 'Europe', 'FRIF0201', 0),
(0, 'Fontenelle', 'France', 'Europe', 'FRBO0431', 0),
(0, 'Fontenelle', 'France', 'Europe', 'FRMP0732', 0),
(0, 'Fontenelle', 'France', 'Europe', 'FRPI0577', 0),
(0, 'Fontenermont', 'France', 'Europe', 'FRBN0366', 0),
(0, 'Fontenet', 'France', 'Europe', 'FRPC0332', 0),
(0, 'Fontenille-Saint-Martin-d`Entraigues', 'France', 'Europe', 'FRPC0333', 0),
(0, 'Fontenilles', 'France', 'Europe', 'FRMP0733', 0),
(0, 'Fontenotte', 'France', 'Europe', 'FRFC0481', 0),
(0, 'Fontenouilles', 'France', 'Europe', 'FRBO0432', 0),
(0, 'Fontenoy', 'France', 'Europe', 'FRBO0433', 0),
(0, 'Fontenoy', 'France', 'Europe', 'FRPI0578', 0),
(0, 'Fontenu', 'France', 'Europe', 'FRFC0482', 0),
(0, 'Fonteny', 'France', 'Europe', 'FRFC0483', 0),
(0, 'Fonteny', 'France', 'Europe', 'FRLO0473', 0),
(0, 'Fontes', 'France', 'Europe', 'FRLR0244', 0),
(0, 'Fontette', 'France', 'Europe', 'FRCA0458', 0),
(0, 'Fontevraud-l`Abbaye', 'France', 'Europe', 'FRXX4278', 0),
(0, 'Fontgombault', 'France', 'Europe', 'FRCE0326', 0),
(0, 'Gezaincourt', 'France', 'Europe', 'FRPI0643', 0),
(0, 'Gezier-et-Fontenelay', 'France', 'Europe', 'FRFC0537', 0),
(0, 'Gezoncourt', 'France', 'Europe', 'FRLO0532', 0),
(0, 'Ghisonaccia', 'France', 'Europe', 'FRCO0076', 0),
(0, 'Ghisoni', 'France', 'Europe', 'FRXX6140', 0),
(0, 'Ghissignies', 'France', 'Europe', 'FRNC0384', 0),
(0, 'Ghyvelde', 'France', 'Europe', 'FRXX1433', 0),
(0, 'Giat', 'France', 'Europe', 'FRAU0255', 0),
(0, 'Gibeaumeix', 'France', 'Europe', 'FRLO0533', 0),
(0, 'Gibel', 'France', 'Europe', 'FRMP0827', 0),
(0, 'Gibercourt', 'France', 'Europe', 'FRPI0644', 0),
(0, 'Giberville', 'France', 'Europe', 'FRXX4001', 0),
(0, 'Gibles', 'France', 'Europe', 'FRBO0471', 0),
(0, 'Gibourne', 'France', 'Europe', 'FRPC0357', 0),
(0, 'Gibret', 'France', 'Europe', 'FRAQ0513', 0),
(0, 'Gidy', 'France', 'Europe', 'FRXX1984', 0),
(0, 'Giel-Courteilles', 'France', 'Europe', 'FRBN0397', 0),
(0, 'Gien', 'France', 'Europe', 'FRXX0401', 0),
(0, 'Gien-sur-Cure', 'France', 'Europe', 'FRBO0472', 0),
(0, 'Giens', 'France', 'Europe', 'FRPA0195', 0),
(0, 'Gieres', 'France', 'Europe', 'FRXX2730', 0),
(0, 'Gieville', 'France', 'Europe', 'FRBN0398', 0),
(0, 'Gievres', 'France', 'Europe', 'FRCE0359', 0),
(0, 'Giey-sur-Aujon', 'France', 'Europe', 'FRCA0494', 0),
(0, 'Giez', 'France', 'Europe', 'FRXX0542', 0),
(0, 'Gif-sur-Yvette', 'France', 'Europe', 'FRXX3121', 0),
(0, 'Giffaumont-Champaubert', 'France', 'Europe', 'FRCA0495', 0),
(0, 'Gigean', 'France', 'Europe', 'FRXX2570', 0),
(0, 'Gignac', 'France', 'Europe', 'FRLR0270', 0),
(0, 'Gignac', 'France', 'Europe', 'FRMP0828', 0),
(0, 'Gignac', 'France', 'Europe', 'FRPA0196', 0),
(0, 'Gignac-la-Nerthe', 'France', 'Europe', 'FRXX3230', 0),
(0, 'Gignat', 'France', 'Europe', 'FRAU0256', 0),
(0, 'Gigneville', 'France', 'Europe', 'FRLO0534', 0),
(0, 'Gigney', 'France', 'Europe', 'FRLO0535', 0),
(0, 'Gigny', 'France', 'Europe', 'FRBO0473', 0),
(0, 'Gigny', 'France', 'Europe', 'FRFC0538', 0),
(0, 'Gigny-Bussy', 'France', 'Europe', 'FRCA0496', 0),
(0, 'Gigny-sur-Saone', 'France', 'Europe', 'FRBO0474', 0),
(0, 'Gigondas', 'France', 'Europe', 'FRPA0197', 0),
(0, 'Gigors', 'France', 'Europe', 'FRPA0198', 0),
(0, 'Gigors-et-Lozeron', 'France', 'Europe', 'FRRA0604', 0),
(0, 'Gigouzac', 'France', 'Europe', 'FRMP0829', 0),
(0, 'Gijounet', 'France', 'Europe', 'FRMP0830', 0),
(0, 'Gildwiller', 'France', 'Europe', 'FRAL0155', 0),
(0, 'Gilette', 'France', 'Europe', 'FRPA0199', 0),
(0, 'Gilhac-et-Bruzac', 'France', 'Europe', 'FRRA0605', 0),
(0, 'Gilhoc-sur-Ormeze', 'France', 'Europe', 'FRRA0606', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Gillancourt', 'France', 'Europe', 'FRCA0497', 0),
(0, 'Gillaume', 'France', 'Europe', 'FRCA0498', 0),
(0, 'Gilles', 'France', 'Europe', 'FRCE0360', 0),
(0, 'Gilley', 'France', 'Europe', 'FRCA0499', 0),
(0, 'Gilley', 'France', 'Europe', 'FRXX1860', 0),
(0, 'Gillois', 'France', 'Europe', 'FRFC0539', 0),
(0, 'Gillonnay', 'France', 'Europe', 'FRRA0607', 0),
(0, 'Gilly-les-Citeaux', 'France', 'Europe', 'FRXX6063', 0),
(0, 'Gilly-sur-Isere', 'France', 'Europe', 'FRXX3464', 0),
(0, 'Gilly-sur-Loire', 'France', 'Europe', 'FRBO0475', 0),
(0, 'Gilocourt', 'France', 'Europe', 'FRPI0645', 0),
(0, 'Gimat', 'France', 'Europe', 'FRMP0831', 0),
(0, 'Gimbrede', 'France', 'Europe', 'FRMP0832', 0),
(0, 'Gimbrett', 'France', 'Europe', 'FRAL0156', 0),
(0, 'Gimeaux', 'France', 'Europe', 'FRAU0257', 0),
(0, 'Gimecourt', 'France', 'Europe', 'FRLO0536', 0),
(0, 'Gimel-les-Cascades', 'France', 'Europe', 'FRLI0146', 0),
(0, 'Gimeux', 'France', 'Europe', 'FRPC0358', 0),
(0, 'Gimont', 'France', 'Europe', 'FRMP0833', 0),
(0, 'Gimouille', 'France', 'Europe', 'FRBO0476', 0),
(0, 'Ginai', 'France', 'Europe', 'FRBN0399', 0),
(0, 'Ginals', 'France', 'Europe', 'FRMP0834', 0),
(0, 'Ginasservis', 'France', 'Europe', 'FRPA0200', 0),
(0, 'Ginchy', 'France', 'Europe', 'FRPI0646', 0),
(0, 'Gincla', 'France', 'Europe', 'FRLR0271', 0),
(0, 'Gincrey', 'France', 'Europe', 'FRLO0537', 0),
(0, 'Gindou', 'France', 'Europe', 'FRMP0835', 0),
(0, 'Ginestas', 'France', 'Europe', 'FRLR0272', 0),
(0, 'Ginestet', 'France', 'Europe', 'FRAQ0514', 0),
(0, 'Gingsheim', 'France', 'Europe', 'FRAL0157', 0),
(0, 'Ginoles', 'France', 'Europe', 'FRLR0273', 0),
(0, 'Ginouillac', 'France', 'Europe', 'FRMP0836', 0),
(0, 'Herimoncourt', 'France', 'Europe', 'FRFC0586', 0),
(0, 'Herin', 'France', 'Europe', 'FRNC0442', 0),
(0, 'Herissart', 'France', 'Europe', 'FRPI0753', 0),
(0, 'Herisson', 'France', 'Europe', 'FRAU0273', 0),
(0, 'Herleville', 'France', 'Europe', 'FRPI0754', 0),
(0, 'Herlies', 'France', 'Europe', 'FRXX1343', 0),
(0, 'Herlin-le-Sec', 'France', 'Europe', 'FRNC0443', 0),
(0, 'Herlincourt', 'France', 'Europe', 'FRNC0444', 0),
(0, 'Herly', 'France', 'Europe', 'FRNC0445', 0),
(0, 'Herly', 'France', 'Europe', 'FRPI0755', 0),
(0, 'Herm', 'France', 'Europe', 'FRAQ0562', 0),
(0, 'Hermanville', 'France', 'Europe', 'FRHN0340', 0),
(0, 'Hermanville-sur-Mer', 'France', 'Europe', 'FRXX6202', 0),
(0, 'Hermaville', 'France', 'Europe', 'FRNC0446', 0),
(0, 'Herme', 'France', 'Europe', 'FRIF0253', 0),
(0, 'Hermelange', 'France', 'Europe', 'FRLO0675', 0),
(0, 'Hermelinghen', 'France', 'Europe', 'FRNC0447', 0),
(0, 'Herment', 'France', 'Europe', 'FRAU0274', 0),
(0, 'Hermeray', 'France', 'Europe', 'FRIF0254', 0),
(0, 'Hermerswiller', 'France', 'Europe', 'FRAL0210', 0),
(0, 'Hermes', 'France', 'Europe', 'FRXX5772', 0),
(0, 'Hermeville', 'France', 'Europe', 'FRHN0341', 0),
(0, 'Hermeville-en-Woevre', 'France', 'Europe', 'FRLO0676', 0),
(0, 'Hermies', 'France', 'Europe', 'FRNC0448', 0),
(0, 'Hermillon', 'France', 'Europe', 'FRRA0655', 0),
(0, 'Hermin', 'France', 'Europe', 'FRNC0449', 0),
(0, 'Hermival-les-Vaux', 'France', 'Europe', 'FRBN0448', 0),
(0, 'Hermonville', 'France', 'Europe', 'FRCA0567', 0),
(0, 'Hernicourt', 'France', 'Europe', 'FRNC0450', 0),
(0, 'Herny', 'France', 'Europe', 'FRLO0677', 0),
(0, 'Heronchelles', 'France', 'Europe', 'FRHN0342', 0),
(0, 'Herouville', 'France', 'Europe', 'FRIF0255', 0),
(0, 'Herouville-Saint-Clair', 'France', 'Europe', 'FRXX5414', 0),
(0, 'Herouvillette', 'France', 'Europe', 'FRXX3235', 0),
(0, 'Herpelmont', 'France', 'Europe', 'FRLO0678', 0),
(0, 'Herpont', 'France', 'Europe', 'FRCA0568', 0),
(0, 'Herpy-l`Arlesienne', 'France', 'Europe', 'FRXX1149', 0),
(0, 'Herqueville', 'France', 'Europe', 'FRBN0449', 0),
(0, 'Herqueville', 'France', 'Europe', 'FRHN0343', 0),
(0, 'Herran', 'France', 'Europe', 'FRMP0897', 0),
(0, 'Herre', 'France', 'Europe', 'FRAQ0563', 0),
(0, 'Herrere', 'France', 'Europe', 'FRAQ0564', 0),
(0, 'Herrin', 'France', 'Europe', 'FRNC0451', 0),
(0, 'Herrlisheim', 'France', 'Europe', 'FRXX4372', 0),
(0, 'Herrlisheim-pres-Colmar', 'France', 'Europe', 'FRXX5089', 0),
(0, 'Herry', 'France', 'Europe', 'FRCE0390', 0),
(0, 'Hersbach', 'France', 'Europe', 'FRAL0211', 0),
(0, 'Herserange', 'France', 'Europe', 'FRXX2281', 0),
(0, 'Hersin-Coupigny', 'France', 'Europe', 'FRXX4244', 0),
(0, 'Hertzing', 'France', 'Europe', 'FRLO0679', 0),
(0, 'Hervelinghen', 'France', 'Europe', 'FRNC0452', 0),
(0, 'Hervilly', 'France', 'Europe', 'FRPI0756', 0),
(0, 'Hery', 'France', 'Europe', 'FRXX2288', 0),
(0, 'Hery-sur-Alby', 'France', 'Europe', 'FRRA0656', 0),
(0, 'Herzeele', 'France', 'Europe', 'FRNC0453', 0),
(0, 'Hesbecourt', 'France', 'Europe', 'FRPI0757', 0),
(0, 'Hescamps', 'France', 'Europe', 'FRXX2205', 0),
(0, 'Hesdigneul-les-Bethune', 'France', 'Europe', 'FRXX2701', 0),
(0, 'Hesdigneul-les-Boulogne', 'France', 'Europe', 'FRNC0454', 0),
(0, 'Hesdin', 'France', 'Europe', 'FRXX6581', 0),
(0, 'Hesdin-l`Abbe', 'France', 'Europe', 'FRNC0455', 0),
(0, 'Hesingue', 'France', 'Europe', 'FRXX4344', 0),
(0, 'Hesmond', 'France', 'Europe', 'FRNC0456', 0),
(0, 'Hesse', 'France', 'Europe', 'FRLO0680', 0),
(0, 'Hessenheim', 'France', 'Europe', 'FRAL0212', 0),
(0, 'Hestroff', 'France', 'Europe', 'FRLO0681', 0),
(0, 'Hestrud', 'France', 'Europe', 'FRNC0457', 0),
(0, 'Hestrus', 'France', 'Europe', 'FRNC0458', 0),
(0, 'Hetomesnil', 'France', 'Europe', 'FRPI0758', 0),
(0, 'Hettange-Grande', 'France', 'Europe', 'FRXX2650', 0),
(0, 'Hettenschlag', 'France', 'Europe', 'FRAL0213', 0),
(0, 'Heubecourt-Haricourt', 'France', 'Europe', 'FRHN0344', 0),
(0, 'Heuchin', 'France', 'Europe', 'FRNC0459', 0),
(0, 'Heucourt-Croquoison', 'France', 'Europe', 'FRPI0759', 0),
(0, 'Heudebouville', 'France', 'Europe', 'FRHN0345', 0),
(0, 'Heudicourt', 'France', 'Europe', 'FRXX4783', 0),
(0, 'Heudicourt', 'France', 'Europe', 'FRXX6824', 0),
(0, 'Heudicourt-sous-les-Cotes', 'France', 'Europe', 'FRLO0682', 0),
(0, 'Heudreville-en-Lieuvin', 'France', 'Europe', 'FRHN0346', 0),
(0, 'Heudreville-sur-Eure', 'France', 'Europe', 'FRXX5520', 0),
(0, 'La Chapelle-Naude', 'France', 'Europe', 'FRBO0560', 0),
(0, 'La Chapelle-Neuve', 'France', 'Europe', 'FRBR0100', 0),
(0, 'La Chapelle-Neuve', 'France', 'Europe', 'FRBR0101', 0),
(0, 'La Chapelle-Onzerain', 'France', 'Europe', 'FRCE0445', 0),
(0, 'La Chapelle-Orthemale', 'France', 'Europe', 'FRCE0446', 0),
(0, 'La Chapelle-Palluau', 'France', 'Europe', 'FRPL0321', 0),
(0, 'La Chapelle-Pechaud', 'France', 'Europe', 'FRAQ0617', 0),
(0, 'La Chapelle-Pouilloux', 'France', 'Europe', 'FRXX1598', 0),
(0, 'La Chapelle-pres-Sees', 'France', 'Europe', 'FRXX4413', 0),
(0, 'La Chapelle-Rablais', 'France', 'Europe', 'FRIF0281', 0),
(0, 'La Chapelle-Rainsouin', 'France', 'Europe', 'FRPL0322', 0),
(0, 'La Chapelle-Rambaud', 'France', 'Europe', 'FRRA0736', 0),
(0, 'La Chapelle-Reanville', 'France', 'Europe', 'FRXX6290', 0),
(0, 'La Chapelle-Rousselin', 'France', 'Europe', 'FRPL0323', 0),
(0, 'La Chapelle-Saint-Andre', 'France', 'Europe', 'FRBO0561', 0),
(0, 'La Chapelle-Saint-Aubert', 'France', 'Europe', 'FRBR0102', 0),
(0, 'La Chapelle-Saint-Aubin', 'France', 'Europe', 'FRPL0324', 0),
(0, 'La Chapelle-Saint-Etienne', 'France', 'Europe', 'FRPC0423', 0),
(0, 'La Chapelle-Saint-Florent', 'France', 'Europe', 'FRPL0325', 0),
(0, 'La Chapelle-Saint-Fray', 'France', 'Europe', 'FRPL0326', 0),
(0, 'La Chapelle-Saint-Geraud', 'France', 'Europe', 'FRXX6190', 0),
(0, 'La Chapelle-Saint-Jean', 'France', 'Europe', 'FRAQ0618', 0),
(0, 'La Chapelle-Saint-Laud', 'France', 'Europe', 'FRPL0327', 0),
(0, 'La Chapelle-Saint-Laurent', 'France', 'Europe', 'FRXX3812', 0),
(0, 'La Chapelle-Saint-Laurian', 'France', 'Europe', 'FRCE0447', 0),
(0, 'La Chapelle-Saint-Luc', 'France', 'Europe', 'FRXX3294', 0),
(0, 'La Chapelle-Saint-Martial', 'France', 'Europe', 'FRLI0176', 0),
(0, 'La Chapelle-Saint-Martin', 'France', 'Europe', 'FRRA0737', 0),
(0, 'La Chapelle-Saint-Martin-en-Plaine', 'France', 'Europe', 'FRCE0448', 0),
(0, 'La Chapelle-Saint-Maurice', 'France', 'Europe', 'FRRA0738', 0),
(0, 'La Chapelle-Saint-Mesmin', 'France', 'Europe', 'FRXX1982', 0),
(0, 'La Chapelle-Saint-Ouen', 'France', 'Europe', 'FRHN0386', 0),
(0, 'La Chapelle-Saint-Quillain', 'France', 'Europe', 'FRFC0621', 0),
(0, 'La Chapelle-Saint-Remy', 'France', 'Europe', 'FRPL0328', 0),
(0, 'La Chapelle-Saint-Sauveur', 'France', 'Europe', 'FRPL0329', 0),
(0, 'La Chapelle-Saint-Sauveur', 'France', 'Europe', 'FRXX2780', 0),
(0, 'La Chapelle-Saint-Sepulcre', 'France', 'Europe', 'FRCE0449', 0),
(0, 'La Chapelle-Saint-Sulpice', 'France', 'Europe', 'FRIF0282', 0),
(0, 'La Chapelle-Saint-Ursin', 'France', 'Europe', 'FRXX3261', 0),
(0, 'La Chapelle-Souef', 'France', 'Europe', 'FRBN0508', 0),
(0, 'La Chapelle-sous-Brancion', 'France', 'Europe', 'FRBO0567', 0),
(0, 'La Chapelle-sous-Dun', 'France', 'Europe', 'FRBO0568', 0),
(0, 'La Chapelle-sous-Orbais', 'France', 'Europe', 'FRCA0633', 0),
(0, 'La Chapelle-sous-Uchon', 'France', 'Europe', 'FRBO0569', 0),
(0, 'La Chapelle-sur-Aveyron', 'France', 'Europe', 'FRCE0455', 0),
(0, 'La Chapelle-sur-Chezy', 'France', 'Europe', 'FRXX1006', 0),
(0, 'La Chapelle-sur-Coise', 'France', 'Europe', 'FRRA0745', 0),
(0, 'La Chapelle-sur-Crecy', 'France', 'Europe', 'FRXX4155', 0),
(0, 'La Chapelle-sur-Dun', 'France', 'Europe', 'FRHN0389', 0),
(0, 'La Chapelle-sur-Erdre', 'France', 'Europe', 'FRXX1286', 0),
(0, 'La Chapelle-sur-Furieuse', 'France', 'Europe', 'FRFC0623', 0),
(0, 'La Chapelle-sur-Loire', 'France', 'Europe', 'FRXX3650', 0),
(0, 'La Chapelle-sur-Oreuse', 'France', 'Europe', 'FRBO0570', 0),
(0, 'La Chapelle-sur-Oudon', 'France', 'Europe', 'FRPL0338', 0),
(0, 'La Chapelle-sur-Usson', 'France', 'Europe', 'FRAU0309', 0),
(0, 'La Chapelle-Taillefert', 'France', 'Europe', 'FRLI0177', 0),
(0, 'La Chapelle-Thecle', 'France', 'Europe', 'FRBO0562', 0),
(0, 'La Chapelle-Themer', 'France', 'Europe', 'FRPL0330', 0),
(0, 'La Chapelle-Thireuil', 'France', 'Europe', 'FRPC0424', 0),
(0, 'La Chapelle-Thouarault', 'France', 'Europe', 'FRBR0103', 0),
(0, 'La Chapelle-Uree', 'France', 'Europe', 'FRBN0509', 0),
(0, 'La Chapelle-Vaupelteigne', 'France', 'Europe', 'FRBO0563', 0),
(0, 'La Chapelle-Vendomoise', 'France', 'Europe', 'FRXX6667', 0),
(0, 'La Chapelle-Vicomtesse', 'France', 'Europe', 'FRCE0450', 0),
(0, 'La Chapelle-Viel', 'France', 'Europe', 'FRBN0510', 0),
(0, 'La Chapelle-Villars', 'France', 'Europe', 'FRRA0739', 0),
(0, 'La Chapelle-Yvon', 'France', 'Europe', 'FRBN0511', 0),
(0, 'La Chapelotte', 'France', 'Europe', 'FRCE0456', 0),
(0, 'La Charce', 'France', 'Europe', 'FRRA0746', 0),
(0, 'La Charite-sur-Loire', 'France', 'Europe', 'FRBO0571', 0),
(0, 'La Charme', 'France', 'Europe', 'FRFC0624', 0),
(0, 'La Charmee', 'France', 'Europe', 'FRBO0572', 0),
(0, 'La Charriere', 'France', 'Europe', 'FRPC0426', 0),
(0, 'La Chartre-sur-le-Loir', 'France', 'Europe', 'FRXX3415', 0),
(0, 'La Chassagne', 'France', 'Europe', 'FRFC0625', 0),
(0, 'La Chataigneraie', 'France', 'Europe', 'FRPL0339', 0),
(0, 'La Chatelaine', 'France', 'Europe', 'FRFC0626', 0),
(0, 'La Chatre', 'France', 'Europe', 'FRXX0398', 0),
(0, 'La Chatre-Langlin', 'France', 'Europe', 'FRCE0457', 0),
(0, 'La Chaudiere', 'France', 'Europe', 'FRRA0747', 0),
(0, 'Manot', 'France', 'Europe', 'FRPC0582', 0),
(0, 'Manou', 'France', 'Europe', 'FRCE0627', 0),
(0, 'Manre', 'France', 'Europe', 'FRCA0842', 0),
(0, 'Mansac', 'France', 'Europe', 'FRXX4005', 0),
(0, 'Mansan', 'France', 'Europe', 'FRMP1335', 0),
(0, 'Mansat-la-Courriere', 'France', 'Europe', 'FRLI0268', 0),
(0, 'Mansempuy', 'France', 'Europe', 'FRMP1336', 0),
(0, 'Mansencome', 'France', 'Europe', 'FRMP1337', 0),
(0, 'Manses', 'France', 'Europe', 'FRMP1338', 0),
(0, 'Mansigne', 'France', 'Europe', 'FRPL0535', 0),
(0, 'Mansle', 'France', 'Europe', 'FRPC0583', 0),
(0, 'Manso', 'France', 'Europe', 'FRCO0096', 0),
(0, 'Manson', 'France', 'Europe', 'FRAU0444', 0),
(0, 'Mansonville', 'France', 'Europe', 'FRMP1339', 0),
(0, 'Manspach', 'France', 'Europe', 'FRAL0332', 0),
(0, 'Mant', 'France', 'Europe', 'FRAQ0864', 0),
(0, 'Mantallot', 'France', 'Europe', 'FRBR0295', 0),
(0, 'Mantenay-Montlin', 'France', 'Europe', 'FRRA1032', 0),
(0, 'Mantes-la-Jolie', 'France', 'Europe', 'FRXX0356', 0),
(0, 'Mantes-la-Ville', 'France', 'Europe', 'FRXX2132', 0),
(0, 'Mantet', 'France', 'Europe', 'FRLR0442', 0),
(0, 'Manteyer', 'France', 'Europe', 'FRPA0357', 0),
(0, 'Manthelan', 'France', 'Europe', 'FRCE0628', 0),
(0, 'Manthelon', 'France', 'Europe', 'FRHN0547', 0),
(0, 'Manthes', 'France', 'Europe', 'FRRA1033', 0),
(0, 'Mantilly', 'France', 'Europe', 'FRBN0801', 0),
(0, 'Mantoche', 'France', 'Europe', 'FRFC0824', 0),
(0, 'Mantry', 'France', 'Europe', 'FRXX2198', 0),
(0, 'Manvieux', 'France', 'Europe', 'FRBN0802', 0),
(0, 'Many', 'France', 'Europe', 'FRLO0998', 0),
(0, 'Manzac-sur-Vern', 'France', 'Europe', 'FRAQ0865', 0),
(0, 'Manzat', 'France', 'Europe', 'FRXX5658', 0),
(0, 'Manziat', 'France', 'Europe', 'FRXX3333', 0),
(0, 'Marac', 'France', 'Europe', 'FRCA0843', 0),
(0, 'Marainville-sur-Madon', 'France', 'Europe', 'FRXX6696', 0),
(0, 'Marainviller', 'France', 'Europe', 'FRLO0999', 0),
(0, 'Marais-Vernier', 'France', 'Europe', 'FRHN0548', 0),
(0, 'Marambat', 'France', 'Europe', 'FRMP1340', 0),
(0, 'Marandeuil', 'France', 'Europe', 'FRBO0719', 0),
(0, 'Marange-Silvange', 'France', 'Europe', 'FRXX5352', 0),
(0, 'Marange-Zondrange', 'France', 'Europe', 'FRLO1000', 0),
(0, 'Marangea', 'France', 'Europe', 'FRFC0825', 0),
(0, 'Marans', 'France', 'Europe', 'FRPC0584', 0),
(0, 'Marans', 'France', 'Europe', 'FRPL0536', 0),
(0, 'Maransin', 'France', 'Europe', 'FRAQ0866', 0),
(0, 'Marant', 'France', 'Europe', 'FRNC0591', 0),
(0, 'Maranville', 'France', 'Europe', 'FRXX2356', 0),
(0, 'Maranwez', 'France', 'Europe', 'FRCA0844', 0),
(0, 'Marast', 'France', 'Europe', 'FRFC0826', 0),
(0, 'Marat', 'France', 'Europe', 'FRAU0445', 0),
(0, 'Marato', 'France', 'Europe', 'FRXX6207', 0),
(0, 'Marault', 'France', 'Europe', 'FRCA0845', 0),
(0, 'Maraussan', 'France', 'Europe', 'FRLR0443', 0),
(0, 'Maravat', 'France', 'Europe', 'FRMP1341', 0),
(0, 'Maray', 'France', 'Europe', 'FRCE0629', 0),
(0, 'Maraye-en-Othe', 'France', 'Europe', 'FRCA0846', 0),
(0, 'Marbache', 'France', 'Europe', 'FRXX5893', 0),
(0, 'Marbaix', 'France', 'Europe', 'FRNC0592', 0),
(0, 'Marbeuf', 'France', 'Europe', 'FRHN0549', 0),
(0, 'Marbeville', 'France', 'Europe', 'FRCA0847', 0),
(0, 'Marbotte', 'France', 'Europe', 'FRLO1001', 0),
(0, 'Marboue', 'France', 'Europe', 'FRCE0630', 0),
(0, 'Marboz', 'France', 'Europe', 'FRXX4846', 0),
(0, 'Marby', 'France', 'Europe', 'FRCA0848', 0),
(0, 'Marc-la-Tour', 'France', 'Europe', 'FRLI0269', 0),
(0, 'Marcais', 'France', 'Europe', 'FRCE0631', 0),
(0, 'Marcay', 'France', 'Europe', 'FRCE0632', 0),
(0, 'Marcay', 'France', 'Europe', 'FRPC0585', 0),
(0, 'Marce', 'France', 'Europe', 'FRPL0537', 0),
(0, 'Marce-sur-Esves', 'France', 'Europe', 'FRCE0633', 0),
(0, 'Marcei', 'France', 'Europe', 'FRBN0803', 0),
(0, 'Marcelcave', 'France', 'Europe', 'FRPI1012', 0),
(0, 'Marcellaz', 'France', 'Europe', 'FRRA1034', 0),
(0, 'Marcellaz-Albanais', 'France', 'Europe', 'FRRA1035', 0),
(0, 'Marcellois', 'France', 'Europe', 'FRBO0720', 0),
(0, 'Marcellus', 'France', 'Europe', 'FRAQ0867', 0),
(0, 'Marcenais', 'France', 'Europe', 'FRXX3544', 0),
(0, 'Marcenat', 'France', 'Europe', 'FRAU0446', 0),
(0, 'Marcenat', 'France', 'Europe', 'FRAU0447', 0),
(0, 'Marcenay', 'France', 'Europe', 'FRBO0721', 0),
(0, 'Nezel', 'France', 'Europe', 'FRXX5098', 0),
(0, 'Nezignan-l`Eveque', 'France', 'Europe', 'FRLR0554', 0),
(0, 'Niafles', 'France', 'Europe', 'FRPL0633', 0),
(0, 'Niaux', 'France', 'Europe', 'FRMP1626', 0),
(0, 'Nibas', 'France', 'Europe', 'FRPI1204', 0),
(0, 'Nibelle', 'France', 'Europe', 'FRCE0795', 0),
(0, 'Nibles', 'France', 'Europe', 'FRPA0410', 0),
(0, 'Nice', 'France', 'Europe', 'FRXX0073', 0),
(0, 'Nicey', 'France', 'Europe', 'FRBO0890', 0),
(0, 'Nicey-sur-Aire', 'France', 'Europe', 'FRLO1165', 0),
(0, 'Nicole', 'France', 'Europe', 'FRXX2367', 0),
(0, 'Nicorps', 'France', 'Europe', 'FRBN0927', 0),
(0, 'Niderhoff', 'France', 'Europe', 'FRXX4886', 0),
(0, 'Niderviller', 'France', 'Europe', 'FRXX1564', 0),
(0, 'Niederbronn-les-Bains', 'France', 'Europe', 'FRAL0386', 0),
(0, 'Niederbruck', 'France', 'Europe', 'FRAL0387', 0),
(0, 'Niederentzen', 'France', 'Europe', 'FRAL0388', 0),
(0, 'Niederhaslach', 'France', 'Europe', 'FRAL0389', 0),
(0, 'Niederhausbergen', 'France', 'Europe', 'FRXX5160', 0),
(0, 'Niederhergheim', 'France', 'Europe', 'FRAL0390', 0),
(0, 'Niederlarg', 'France', 'Europe', 'FRAL0391', 0),
(0, 'Niederlauterbach', 'France', 'Europe', 'FRAL0392', 0),
(0, 'Niedermorschwihr', 'France', 'Europe', 'FRAL0393', 0),
(0, 'Niedernai', 'France', 'Europe', 'FRAL0394', 0),
(0, 'Niederroedern', 'France', 'Europe', 'FRAL0395', 0),
(0, 'Niederschaeffolsheim', 'France', 'Europe', 'FRAL0396', 0),
(0, 'Niederseebach', 'France', 'Europe', 'FRAL0397', 0),
(0, 'Niedersoultzbach', 'France', 'Europe', 'FRAL0398', 0),
(0, 'Niedersteinbach', 'France', 'Europe', 'FRAL0399', 0),
(0, 'Niederstinzel', 'France', 'Europe', 'FRLO1166', 0),
(0, 'Niedervisse', 'France', 'Europe', 'FRLO1167', 0),
(0, 'Nielles-les-Ardres', 'France', 'Europe', 'FRNC0664', 0),
(0, 'Nielles-les-Blequin', 'France', 'Europe', 'FRXX6481', 0),
(0, 'Nielles-les-Calais', 'France', 'Europe', 'FRNC0665', 0),
(0, 'Nieppe', 'France', 'Europe', 'FRXX5166', 0),
(0, 'Niergnies', 'France', 'Europe', 'FRXX5828', 0),
(0, 'Nieudan', 'France', 'Europe', 'FRAU0537', 0),
(0, 'Nieuil', 'France', 'Europe', 'FRXX6211', 0),
(0, 'Nieuil-l`Espoir', 'France', 'Europe', 'FRPC0693', 0),
(0, 'Nieul', 'France', 'Europe', 'FRLI0308', 0),
(0, 'Nieul-le-Dolent', 'France', 'Europe', 'FRXX6823', 0),
(0, 'Nieul-le-Virouil', 'France', 'Europe', 'FRPC0694', 0),
(0, 'Nieul-les-Saintes', 'France', 'Europe', 'FRPC0695', 0),
(0, 'Nieul-sur-l`Autise', 'France', 'Europe', 'FRPL0634', 0),
(0, 'Nieul-sur-Mer', 'France', 'Europe', 'FRXX3273', 0),
(0, 'Nieulle-sur-Seudre', 'France', 'Europe', 'FRXX5219', 0),
(0, 'Nieurlet', 'France', 'Europe', 'FRNC0666', 0),
(0, 'Nievroz', 'France', 'Europe', 'FRRA1247', 0),
(0, 'Niffer', 'France', 'Europe', 'FRAL0400', 0),
(0, 'Niherne', 'France', 'Europe', 'FRCE0796', 0),
(0, 'Nijon', 'France', 'Europe', 'FRCA0998', 0),
(0, 'Nilvange', 'France', 'Europe', 'FRXX3405', 0),
(0, 'Nimes', 'France', 'Europe', 'FRXX0165', 0),
(0, 'Ninville', 'France', 'Europe', 'FRCA0999', 0),
(0, 'Niort', 'France', 'Europe', 'FRXX0166', 0),
(0, 'Niort-de-Sault', 'France', 'Europe', 'FRLR0555', 0),
(0, 'Niort-la-Fontaine', 'France', 'Europe', 'FRPL0635', 0),
(0, 'Niozelles', 'France', 'Europe', 'FRPA0411', 0),
(0, 'Nissan-lez-Enserune', 'France', 'Europe', 'FRXX5132', 0),
(0, 'Nistos', 'France', 'Europe', 'FRMP1627', 0),
(0, 'Nitry', 'France', 'Europe', 'FRBO0891', 0),
(0, 'Nitting', 'France', 'Europe', 'FRLO1168', 0),
(0, 'Niutahi', 'France', 'Europe', 'FRXX7901', 0),
(0, 'Nivelle', 'France', 'Europe', 'FRNC0667', 0),
(0, 'Nivillac', 'France', 'Europe', 'FRXX6734', 0),
(0, 'Nivillers', 'France', 'Europe', 'FRPI1205', 0),
(0, 'Nivolas-Vermelle', 'France', 'Europe', 'FRRA1248', 0),
(0, 'Nivollet-Montgriffon', 'France', 'Europe', 'FRRA1249', 0),
(0, 'Nixeville-Blercourt', 'France', 'Europe', 'FRLO1169', 0),
(0, 'Nizan-Gesse', 'France', 'Europe', 'FRMP1628', 0),
(0, 'Nizas', 'France', 'Europe', 'FRLR0556', 0),
(0, 'Nizas', 'France', 'Europe', 'FRMP1629', 0),
(0, 'Nizerolles', 'France', 'Europe', 'FRAU0538', 0),
(0, 'Nizy-le-Comte', 'France', 'Europe', 'FRXX4847', 0),
(0, 'Noailhac', 'France', 'Europe', 'FRLI0309', 0),
(0, 'Noailhac', 'France', 'Europe', 'FRMP1630', 0),
(0, 'Noailhac', 'France', 'Europe', 'FRMP1631', 0),
(0, 'Noaillac', 'France', 'Europe', 'FRAQ1052', 0),
(0, 'Noaillan', 'France', 'Europe', 'FRXX2794', 0),
(0, 'Noailles', 'France', 'Europe', 'FRLI0310', 0),
(0, 'Orx', 'France', 'Europe', 'FRAQ1076', 0),
(0, 'Os-Marsillon', 'France', 'Europe', 'FRAQ1077', 0),
(0, 'Osani', 'France', 'Europe', 'FRCO0130', 0),
(0, 'Osches', 'France', 'Europe', 'FRLO1215', 0),
(0, 'Osenbach', 'France', 'Europe', 'FRAL0429', 0),
(0, 'Oslon', 'France', 'Europe', 'FRBO0918', 0),
(0, 'Osly-Courtil', 'France', 'Europe', 'FRPI1251', 0),
(0, 'Osmanville', 'France', 'Europe', 'FRBN0961', 0),
(0, 'Osmery', 'France', 'Europe', 'FRCE0835', 0),
(0, 'Osmets', 'France', 'Europe', 'FRMP1668', 0),
(0, 'Osmoy', 'France', 'Europe', 'FRCE0836', 0),
(0, 'Osmoy', 'France', 'Europe', 'FRIF0456', 0),
(0, 'Osmoy-Saint-Valery', 'France', 'Europe', 'FRHN0644', 0),
(0, 'Osne-le-Val', 'France', 'Europe', 'FRCA1042', 0),
(0, 'Osnes', 'France', 'Europe', 'FRCA1043', 0),
(0, 'Osny', 'France', 'Europe', 'FRXX1698', 0),
(0, 'Ossages', 'France', 'Europe', 'FRAQ1078', 0),
(0, 'Ossas-Suhare', 'France', 'Europe', 'FRAQ1079', 0),
(0, 'Osse', 'France', 'Europe', 'FRBR0362', 0),
(0, 'Osse', 'France', 'Europe', 'FRFC1010', 0),
(0, 'Osse-en-Aspe', 'France', 'Europe', 'FRXX2768', 0),
(0, 'Osseja', 'France', 'Europe', 'FRXX4978', 0),
(0, 'Osselle', 'France', 'Europe', 'FRFC1011', 0),
(0, 'Ossen', 'France', 'Europe', 'FRMP1669', 0),
(0, 'Ossenx', 'France', 'Europe', 'FRAQ1080', 0),
(0, 'Osserain-Rivareyte', 'France', 'Europe', 'FRAQ1081', 0),
(0, 'Osses', 'France', 'Europe', 'FRAQ1082', 0),
(0, 'Ossey-les-Trois-Maisons', 'France', 'Europe', 'FRCA1044', 0),
(0, 'Ossun', 'France', 'Europe', 'FRXX2665', 0),
(0, 'Ossun-ez-Angles', 'France', 'Europe', 'FRMP1670', 0),
(0, 'Ostabat-Asme', 'France', 'Europe', 'FRAQ1083', 0),
(0, 'Ostel', 'France', 'Europe', 'FRPI1252', 0),
(0, 'Ostheim', 'France', 'Europe', 'FRAL0430', 0),
(0, 'Osthoffen', 'France', 'Europe', 'FRXX1459', 0),
(0, 'Osthouse', 'France', 'Europe', 'FRAL0431', 0),
(0, 'Ostreville', 'France', 'Europe', 'FRNC0698', 0),
(0, 'Ostricourt', 'France', 'Europe', 'FRXX6669', 0),
(0, 'Ostwald', 'France', 'Europe', 'FRXX4434', 0),
(0, 'Ota', 'France', 'Europe', 'FRXX1837', 0),
(0, 'Othe', 'France', 'Europe', 'FRLO1216', 0),
(0, 'Othis', 'France', 'Europe', 'FRXX1899', 0),
(0, 'Ottange', 'France', 'Europe', 'FRXX2127', 0),
(0, 'Ottersthal', 'France', 'Europe', 'FRAL0432', 0),
(0, 'Otterswiller', 'France', 'Europe', 'FRAL0433', 0),
(0, 'Ottmarsheim', 'France', 'Europe', 'FRXX2615', 0),
(0, 'Ottonville', 'France', 'Europe', 'FRLO1217', 0),
(0, 'Ottrott', 'France', 'Europe', 'FRXX6554', 0),
(0, 'Ottwiller', 'France', 'Europe', 'FRAL0434', 0),
(0, 'Ouagne', 'France', 'Europe', 'FRBO0919', 0),
(0, 'Ouainville', 'France', 'Europe', 'FRHN0645', 0),
(0, 'Ouanary', 'France', 'Europe', 'FRXX7794', 0),
(0, 'Ouanne', 'France', 'Europe', 'FRXX1584', 0),
(0, 'Ouarville', 'France', 'Europe', 'FRCE0837', 0),
(0, 'Ouchamps', 'France', 'Europe', 'FRCE0838', 0),
(0, 'Ouches', 'France', 'Europe', 'FRRA1284', 0),
(0, 'Oucques', 'France', 'Europe', 'FRXX2943', 0),
(0, 'Oudalle', 'France', 'Europe', 'FRHN0646', 0),
(0, 'Oudan', 'France', 'Europe', 'FRBO0920', 0),
(0, 'Oudeuil', 'France', 'Europe', 'FRPI1253', 0),
(0, 'Oudezeele', 'France', 'Europe', 'FRNC0699', 0),
(0, 'Oudincourt', 'France', 'Europe', 'FRCA1045', 0),
(0, 'Oudon', 'France', 'Europe', 'FRXX2009', 0),
(0, 'Oudrenne', 'France', 'Europe', 'FRLO1218', 0),
(0, 'Oudry', 'France', 'Europe', 'FRBO0921', 0),
(0, 'Ouegoa', 'France', 'Europe', 'FRXX7941', 0),
(0, 'Oueilloux', 'France', 'Europe', 'FRMP1671', 0),
(0, 'Ouerre', 'France', 'Europe', 'FRCE0839', 0),
(0, 'Ouessant', 'France', 'Europe', 'FRXX0113', 0),
(0, 'Ouezy', 'France', 'Europe', 'FRBN0962', 0),
(0, 'Ouffieres', 'France', 'Europe', 'FRBN0963', 0),
(0, 'Ouge', 'France', 'Europe', 'FRFC1012', 0),
(0, 'Ouges', 'France', 'Europe', 'FRBO0922', 0),
(0, 'Ougney', 'France', 'Europe', 'FRFC1013', 0),
(0, 'Ougney-Douvot', 'France', 'Europe', 'FRFC1014', 0),
(0, 'Ougny', 'France', 'Europe', 'FRBO0923', 0),
(0, 'Ouhans', 'France', 'Europe', 'FRFC1015', 0),
(0, 'Ouides', 'France', 'Europe', 'FRAU0554', 0),
(0, 'Ouillon', 'France', 'Europe', 'FRAQ1084', 0),
(0, 'Ouilly-du-Houley', 'France', 'Europe', 'FRXX1753', 0),
(0, 'Ouilly-le-Tesson', 'France', 'Europe', 'FRBN0964', 0),
(0, 'Pern', 'France', 'Europe', 'FRXX6399', 0),
(0, 'Pernand-Vergelesses', 'France', 'Europe', 'FRBO0950', 0),
(0, 'Pernant', 'France', 'Europe', 'FRPI1282', 0),
(0, 'Pernay', 'France', 'Europe', 'FRCE0866', 0),
(0, 'Pernes', 'France', 'Europe', 'FRXX6425', 0),
(0, 'Pernes-les-Boulogne', 'France', 'Europe', 'FRXX2818', 0),
(0, 'Pernes-les-Fontaines', 'France', 'Europe', 'FRXX6011', 0),
(0, 'Pernois', 'France', 'Europe', 'FRPI1283', 0),
(0, 'Pero-Casevecchie', 'France', 'Europe', 'FRCO0140', 0),
(0, 'Perols', 'France', 'Europe', 'FRXX2029', 0),
(0, 'Perols-sur-Vezere', 'France', 'Europe', 'FRXX4033', 0),
(0, 'Peron', 'France', 'Europe', 'FRRA1320', 0),
(0, 'Peronnas', 'France', 'Europe', 'FRXX1885', 0),
(0, 'Peronne', 'France', 'Europe', 'FRBO0951', 0),
(0, 'Peronne', 'France', 'Europe', 'FRPI1284', 0),
(0, 'Peronne-en-Melantois', 'France', 'Europe', 'FRXX1440', 0),
(0, 'Peronville', 'France', 'Europe', 'FRCE0867', 0),
(0, 'Perouges', 'France', 'Europe', 'FRRA1321', 0),
(0, 'Perouse', 'France', 'Europe', 'FRXX5289', 0),
(0, 'Peroy-les-Gombries', 'France', 'Europe', 'FRPI1285', 0),
(0, 'Perpezac-le-Blanc', 'France', 'Europe', 'FRXX2510', 0),
(0, 'Perpezac-le-Noir', 'France', 'Europe', 'FRXX5494', 0),
(0, 'Perpezat', 'France', 'Europe', 'FRAU0567', 0),
(0, 'Perpignan', 'France', 'Europe', 'FRXX0128', 0),
(0, 'Perquie', 'France', 'Europe', 'FRAQ1109', 0),
(0, 'Perrancey-les-Vieux-Moulins', 'France', 'Europe', 'FRCA1071', 0),
(0, 'Perrecy-les-Forges', 'France', 'Europe', 'FRXX5816', 0),
(0, 'Perret', 'France', 'Europe', 'FRBR0374', 0),
(0, 'Perreuil', 'France', 'Europe', 'FRBO0952', 0),
(0, 'Perreuse', 'France', 'Europe', 'FRBO0953', 0),
(0, 'Perreux', 'France', 'Europe', 'FRBO0954', 0),
(0, 'Perreux', 'France', 'Europe', 'FRRA1322', 0),
(0, 'Perrex', 'France', 'Europe', 'FRRA1323', 0),
(0, 'Perrier', 'France', 'Europe', 'FRAU0568', 0),
(0, 'Perrieres', 'France', 'Europe', 'FRBN0978', 0),
(0, 'Perriers-en-Beauficel', 'France', 'Europe', 'FRXX2136', 0),
(0, 'Perriers-la-Campagne', 'France', 'Europe', 'FRHN0656', 0),
(0, 'Perriers-sur-Andelle', 'France', 'Europe', 'FRXX4084', 0),
(0, 'Perrignier', 'France', 'Europe', 'FRXX1341', 0),
(0, 'Perrigny', 'France', 'Europe', 'FRBO0955', 0),
(0, 'Perrigny', 'France', 'Europe', 'FRFC1039', 0),
(0, 'Perrigny-les-Dijon', 'France', 'Europe', 'FRBO0956', 0),
(0, 'Perrigny-sur-Armancon', 'France', 'Europe', 'FRBO0957', 0),
(0, 'Perrigny-sur-l`Ognon', 'France', 'Europe', 'FRBO0959', 0),
(0, 'Perrigny-sur-Loire', 'France', 'Europe', 'FRBO0958', 0),
(0, 'Perrogney-les-Fontaines', 'France', 'Europe', 'FRCA1072', 0),
(0, 'Perros-Guirec', 'France', 'Europe', 'FRXX3266', 0),
(0, 'Perrou', 'France', 'Europe', 'FRBN0979', 0),
(0, 'Perrouse', 'France', 'Europe', 'FRFC1040', 0),
(0, 'Perroy', 'France', 'Europe', 'FRXX5903', 0),
(0, 'Perruel', 'France', 'Europe', 'FRHN0657', 0),
(0, 'Perrusse', 'France', 'Europe', 'FRCA1073', 0),
(0, 'Perrusson', 'France', 'Europe', 'FRCE0868', 0),
(0, 'Pers', 'France', 'Europe', 'FRAU0569', 0),
(0, 'Pers', 'France', 'Europe', 'FRPC0733', 0),
(0, 'Pers-en-Gatinais', 'France', 'Europe', 'FRCE0869', 0),
(0, 'Pers-Jussy', 'France', 'Europe', 'FRXX2801', 0),
(0, 'Persac', 'France', 'Europe', 'FRPC0734', 0),
(0, 'Persan', 'France', 'Europe', 'FRXX6094', 0),
(0, 'Persquen', 'France', 'Europe', 'FRBR0375', 0),
(0, 'Pertain', 'France', 'Europe', 'FRPI1286', 0),
(0, 'Perthes', 'France', 'Europe', 'FRCA1074', 0),
(0, 'Perthes', 'France', 'Europe', 'FRCA1075', 0),
(0, 'Perthes', 'France', 'Europe', 'FRIF0468', 0),
(0, 'Perthes-les-Brienne', 'France', 'Europe', 'FRCA1076', 0),
(0, 'Pertheville-Ners', 'France', 'Europe', 'FRBN0980', 0),
(0, 'Pertuis', 'France', 'Europe', 'FRXX6738', 0),
(0, 'Pervencheres', 'France', 'Europe', 'FRBN0981', 0),
(0, 'Perville', 'France', 'Europe', 'FRMP1711', 0),
(0, 'Pescadoires', 'France', 'Europe', 'FRMP1712', 0),
(0, 'Peschadoires', 'France', 'Europe', 'FRXX2299', 0),
(0, 'Peseux', 'France', 'Europe', 'FRFC1041', 0),
(0, 'Peseux', 'France', 'Europe', 'FRFC1042', 0),
(0, 'Peslieres', 'France', 'Europe', 'FRAU0570', 0),
(0, 'Pesmes', 'France', 'Europe', 'FRFC1043', 0),
(0, 'Pessac', 'France', 'Europe', 'FRXX0078', 0),
(0, 'Pessac-sur-Dordogne', 'France', 'Europe', 'FRXX3610', 0),
(0, 'Pessan', 'France', 'Europe', 'FRMP1713', 0),
(0, 'Pessans', 'France', 'Europe', 'FRFC1044', 0),
(0, 'Pessat-Villeneuve', 'France', 'Europe', 'FRAU0571', 0),
(0, 'Reterre', 'France', 'Europe', 'FRLI0345', 0),
(0, 'Rethel', 'France', 'Europe', 'FRXX1101', 0),
(0, 'Retheuil', 'France', 'Europe', 'FRPI1389', 0),
(0, 'Rethondes', 'France', 'Europe', 'FRXX1292', 0),
(0, 'Rethonvillers', 'France', 'Europe', 'FRPI1390', 0),
(0, 'Rethoville', 'France', 'Europe', 'FRBN1045', 0),
(0, 'Retiers', 'France', 'Europe', 'FRXX2535', 0),
(0, 'Retjons', 'France', 'Europe', 'FRAQ1200', 0),
(0, 'Retonfey', 'France', 'Europe', 'FRXX5267', 0),
(0, 'Retonval', 'France', 'Europe', 'FRHN0698', 0),
(0, 'Retournac', 'France', 'Europe', 'FRAU0610', 0),
(0, 'Retschwiller', 'France', 'Europe', 'FRAL0460', 0),
(0, 'Rettel', 'France', 'Europe', 'FRLO1355', 0),
(0, 'Rety', 'France', 'Europe', 'FRNC0769', 0),
(0, 'Retzwiller', 'France', 'Europe', 'FRAL0461', 0),
(0, 'Reugney', 'France', 'Europe', 'FRFC1135', 0),
(0, 'Reugny', 'France', 'Europe', 'FRAU0611', 0),
(0, 'Reugny', 'France', 'Europe', 'FRCE0931', 0),
(0, 'Reuil', 'France', 'Europe', 'FRCA1177', 0),
(0, 'Reuil-en-Brie', 'France', 'Europe', 'FRIF0497', 0),
(0, 'Reuil-sur-Breche', 'France', 'Europe', 'FRPI1391', 0),
(0, 'Reuilly', 'France', 'Europe', 'FRCE0932', 0),
(0, 'Reuilly', 'France', 'Europe', 'FRHN0699', 0),
(0, 'Reuilly-Sauvigny', 'France', 'Europe', 'FRPI1392', 0),
(0, 'Reulle-Vergy', 'France', 'Europe', 'FRBO1036', 0),
(0, 'Reumont', 'France', 'Europe', 'FRNC0770', 0),
(0, 'Reutenbourg', 'France', 'Europe', 'FRAL0462', 0),
(0, 'Reuves', 'France', 'Europe', 'FRCA1178', 0),
(0, 'Reuville', 'France', 'Europe', 'FRHN0700', 0),
(0, 'Reux', 'France', 'Europe', 'FRBN1046', 0),
(0, 'Reveillon', 'France', 'Europe', 'FRBN1047', 0),
(0, 'Reveillon', 'France', 'Europe', 'FRCA1179', 0),
(0, 'Revel', 'France', 'Europe', 'FRPA0473', 0),
(0, 'Revel', 'France', 'Europe', 'FRRA1432', 0),
(0, 'Revel', 'France', 'Europe', 'FRXX6449', 0),
(0, 'Revel-Tourdan', 'France', 'Europe', 'FRXX4935', 0),
(0, 'Revelles', 'France', 'Europe', 'FRPI1393', 0),
(0, 'Revens', 'France', 'Europe', 'FRLR0665', 0),
(0, 'Reventin-Vaugris', 'France', 'Europe', 'FRXX4933', 0),
(0, 'Revercourt', 'France', 'Europe', 'FRCE0933', 0),
(0, 'Revest-des-Brousses', 'France', 'Europe', 'FRPA0475', 0),
(0, 'Revest-du-Bion', 'France', 'Europe', 'FRPA0476', 0),
(0, 'Revest-les-Roches', 'France', 'Europe', 'FRXX4687', 0),
(0, 'Revest-Saint-Martin', 'France', 'Europe', 'FRPA0474', 0),
(0, 'Reviers', 'France', 'Europe', 'FRBN1048', 0),
(0, 'Revigny', 'France', 'Europe', 'FRFC1136', 0),
(0, 'Revigny-sur-Ornain', 'France', 'Europe', 'FRXX2171', 0),
(0, 'Reville', 'France', 'Europe', 'FRBN1049', 0),
(0, 'Reville-aux-Bois', 'France', 'Europe', 'FRLO1356', 0),
(0, 'Revillon', 'France', 'Europe', 'FRPI1394', 0),
(0, 'Revin', 'France', 'Europe', 'FRXX4081', 0),
(0, 'Revonnas', 'France', 'Europe', 'FRRA1433', 0),
(0, 'Rexingen', 'France', 'Europe', 'FRAL0463', 0),
(0, 'Rexpoede', 'France', 'Europe', 'FRNC0771', 0),
(0, 'Reyersviller', 'France', 'Europe', 'FRXX3346', 0),
(0, 'Reygade', 'France', 'Europe', 'FRLI0346', 0),
(0, 'Reynel', 'France', 'Europe', 'FRCA1180', 0),
(0, 'Reynes', 'France', 'Europe', 'FRLR0666', 0),
(0, 'Reynier', 'France', 'Europe', 'FRPA0477', 0),
(0, 'Reynies', 'France', 'Europe', 'FRMP1850', 0),
(0, 'Reyrevignes', 'France', 'Europe', 'FRMP1851', 0),
(0, 'Reyrieux', 'France', 'Europe', 'FRRA1434', 0),
(0, 'Reyssouze', 'France', 'Europe', 'FRRA1435', 0),
(0, 'Reyvroz', 'France', 'Europe', 'FRRA1436', 0),
(0, 'Rezay', 'France', 'Europe', 'FRCE0934', 0),
(0, 'Reze', 'France', 'Europe', 'FRXX0081', 0),
(0, 'Rezentieres', 'France', 'Europe', 'FRAU0612', 0),
(0, 'Rezonville', 'France', 'Europe', 'FRLO1357', 0),
(0, 'Rezza', 'France', 'Europe', 'FRCO0177', 0),
(0, 'Rheges', 'France', 'Europe', 'FRCA1181', 0),
(0, 'Rhinau', 'France', 'Europe', 'FRXX6596', 0),
(0, 'Rhodes', 'France', 'Europe', 'FRLO1358', 0),
(0, 'Rhodon', 'France', 'Europe', 'FRCE0935', 0),
(0, 'Rhodon', 'France', 'Europe', 'FRIF0498', 0),
(0, 'Rhuis', 'France', 'Europe', 'FRPI1395', 0),
(0, 'Ri', 'France', 'Europe', 'FRBN1050', 0),
(0, 'Ria-Sirach', 'France', 'Europe', 'FRLR0667', 0),
(0, 'Riaille', 'France', 'Europe', 'FRXX2715', 0),
(0, 'Rians', 'France', 'Europe', 'FRCE0936', 0),
(0, 'Rians', 'France', 'Europe', 'FRPA0478', 0),
(0, 'Saint-Aubin-des-Hayes', 'France', 'Europe', 'FRHN0742', 0),
(0, 'Saint-Aubin-des-Landes', 'France', 'Europe', 'FRBR0522', 0),
(0, 'Saint-Aubin-des-Ormeaux', 'France', 'Europe', 'FRPL0748', 0),
(0, 'Saint-Aubin-des-Preaux', 'France', 'Europe', 'FRBN1096', 0),
(0, 'Saint-Aubin-du-Cormier', 'France', 'Europe', 'FRXX1165', 0),
(0, 'Saint-Aubin-du-Desert', 'France', 'Europe', 'FRPL0749', 0),
(0, 'Saint-Aubin-du-Pavail', 'France', 'Europe', 'FRBR0523', 0),
(0, 'Saint-Aubin-du-Perron', 'France', 'Europe', 'FRBN1097', 0),
(0, 'Saint-Aubin-du-Plain', 'France', 'Europe', 'FRXX3778', 0),
(0, 'Saint-Aubin-du-Thenney', 'France', 'Europe', 'FRHN0743', 0),
(0, 'Saint-Aubin-en-Bray', 'France', 'Europe', 'FRPI1466', 0),
(0, 'Saint-Aubin-en-Charollais', 'France', 'Europe', 'FRXX4912', 0),
(0, 'Saint-Aubin-Epinay', 'France', 'Europe', 'FRHN0737', 0),
(0, 'Saint-Aubin-Fosse-Louvain', 'France', 'Europe', 'FRXX3844', 0),
(0, 'Saint-Aubin-la-Plaine', 'France', 'Europe', 'FRPL0750', 0),
(0, 'Saint-Aubin-le-Cauf', 'France', 'Europe', 'FRHN0744', 0),
(0, 'Saint-Aubin-le-Cloud', 'France', 'Europe', 'FRXX6043', 0),
(0, 'Saint-Aubin-le-Depeint', 'France', 'Europe', 'FRCE0980', 0),
(0, 'Saint-Aubin-le-Guichard', 'France', 'Europe', 'FRHN0745', 0),
(0, 'Saint-Aubin-le-Monial', 'France', 'Europe', 'FRAU0644', 0),
(0, 'Saint-Aubin-le-Vertueux', 'France', 'Europe', 'FRXX4013', 0),
(0, 'Saint-Aubin-Lebizay', 'France', 'Europe', 'FRBN1090', 0),
(0, 'Saint-Aubin-les-Elbeuf', 'France', 'Europe', 'FRXX6390', 0),
(0, 'Saint-Aubin-les-Forges', 'France', 'Europe', 'FRBO1084', 0),
(0, 'Saint-Aubin-Montenoy', 'France', 'Europe', 'FRXX3697', 0),
(0, 'Saint-Aubin-Riviere', 'France', 'Europe', 'FRPI1465', 0),
(0, 'Saint-Aubin-Routot', 'France', 'Europe', 'FRHN0738', 0),
(0, 'Saint-Aubin-sous-Erquery', 'France', 'Europe', 'FRXX6447', 0),
(0, 'Saint-Aubin-sur-Aire', 'France', 'Europe', 'FRLO1416', 0),
(0, 'Saint-Aubin-sur-Algot', 'France', 'Europe', 'FRBN1098', 0),
(0, 'Saint-Aubin-sur-Gaillon', 'France', 'Europe', 'FRXX6237', 0),
(0, 'Saint-Aubin-sur-Loire', 'France', 'Europe', 'FRBO1085', 0),
(0, 'Saint-Aubin-sur-Mer', 'France', 'Europe', 'FRHN0746', 0),
(0, 'Saint-Aubin-sur-Mer', 'France', 'Europe', 'FRXX2471', 0),
(0, 'Saint-Aubin-sur-Quillebeuf', 'France', 'Europe', 'FRHN0747', 0),
(0, 'Saint-Aubin-sur-Scie', 'France', 'Europe', 'FRHN0748', 0),
(0, 'Saint-Aubin-sur-Yonne', 'France', 'Europe', 'FRXX4535', 0),
(0, 'Saint-Augustin', 'France', 'Europe', 'FRXX2472', 0),
(0, 'Saint-Augustin', 'France', 'Europe', 'FRXX4151', 0),
(0, 'Saint-Augustin', 'France', 'Europe', 'FRXX6223', 0),
(0, 'Saint-Augustin-des-Bois', 'France', 'Europe', 'FRPL0751', 0),
(0, 'Saint-Aulaire', 'France', 'Europe', 'FRLI0369', 0),
(0, 'Saint-Aulais-la-Chapelle', 'France', 'Europe', 'FRPC0831', 0),
(0, 'Saint-Aulaye', 'France', 'Europe', 'FRAQ1257', 0),
(0, 'Saint-Aunes', 'France', 'Europe', 'FRLR0713', 0),
(0, 'Saint-Aunix-Lengros', 'France', 'Europe', 'FRMP1938', 0),
(0, 'Saint-Aupre', 'France', 'Europe', 'FRRA1528', 0),
(0, 'Saint-Austremoine', 'France', 'Europe', 'FRAU0645', 0),
(0, 'Saint-Auvent', 'France', 'Europe', 'FRLI0370', 0),
(0, 'Saint-Avaugourd-des-Landes', 'France', 'Europe', 'FRPL0752', 0),
(0, 'Saint-Ave', 'France', 'Europe', 'FRXX3680', 0),
(0, 'Saint-Aventin', 'France', 'Europe', 'FRMP1939', 0),
(0, 'Saint-Avertin', 'France', 'Europe', 'FRXX3651', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRAQ1258', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRAQ1259', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRAU0646', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRCE0981', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRPC0832', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRRA1529', 0),
(0, 'Saint-Avit', 'France', 'Europe', 'FRXX5210', 0),
(0, 'Saint-Avit-de-Soulege', 'France', 'Europe', 'FRAQ1262', 0),
(0, 'Saint-Avit-de-Tardes', 'France', 'Europe', 'FRLI0371', 0),
(0, 'Saint-Avit-de-Vialard', 'France', 'Europe', 'FRAQ1263', 0),
(0, 'Saint-Avit-Frandat', 'France', 'Europe', 'FRMP1940', 0),
(0, 'Saint-Avit-le-Pauvre', 'France', 'Europe', 'FRLI0372', 0),
(0, 'Saint-Avit-les-Guespieres', 'France', 'Europe', 'FRCE0982', 0),
(0, 'Saint-Avit-Riviere', 'France', 'Europe', 'FRAQ1260', 0),
(0, 'Saint-Avit-Saint-Nazaire', 'France', 'Europe', 'FRAQ1261', 0),
(0, 'Saint-Avit-Senieur', 'France', 'Europe', 'FRXX3184', 0),
(0, 'Saint-Avold', 'France', 'Europe', 'FRXX3409', 0),
(0, 'Saint-Avre', 'France', 'Europe', 'FRRA1530', 0),
(0, 'Saint-Ay', 'France', 'Europe', 'FRCE0983', 0),
(0, 'Saint-Aybert', 'France', 'Europe', 'FRNC0814', 0),
(0, 'Saint-Aygulf', 'France', 'Europe', 'FRXX3732', 0),
(0, 'Saint-Babel', 'France', 'Europe', 'FRAU0647', 0),
(0, 'Saint-Baldoph', 'France', 'Europe', 'FRXX4233', 0),
(0, 'Saint-Bandry', 'France', 'Europe', 'FRPI1467', 0),
(0, 'Saint-Baraing', 'France', 'Europe', 'FRFC1175', 0),
(0, 'Saint-Barbant', 'France', 'Europe', 'FRLI0373', 0),
(0, 'Saint-Bard', 'France', 'Europe', 'FRLI0374', 0),
(0, 'Thibie', 'France', 'Europe', 'FRCA1433', 0),
(0, 'Thibivillers', 'France', 'Europe', 'FRPI1606', 0),
(0, 'Thibouville', 'France', 'Europe', 'FRHN0931', 0),
(0, 'Thicourt', 'France', 'Europe', 'FRLO1585', 0),
(0, 'Thiebaumenil', 'France', 'Europe', 'FRLO1586', 0),
(0, 'Thieblemont-Faremont', 'France', 'Europe', 'FRCA1434', 0),
(0, 'Thiebouhans', 'France', 'Europe', 'FRFC1281', 0),
(0, 'Thieffrain', 'France', 'Europe', 'FRCA1435', 0),
(0, 'Thieffrans', 'France', 'Europe', 'FRFC1282', 0),
(0, 'Thiefosse', 'France', 'Europe', 'FRLO1587', 0),
(0, 'Thiel-sur-Acolin', 'France', 'Europe', 'FRAU0854', 0),
(0, 'Thiembronne', 'France', 'Europe', 'FRNC0904', 0),
(0, 'Thienans', 'France', 'Europe', 'FRFC1283', 0),
(0, 'Thiennes', 'France', 'Europe', 'FRNC0905', 0),
(0, 'Thiepval', 'France', 'Europe', 'FRPI1607', 0),
(0, 'Thiergeville', 'France', 'Europe', 'FRHN0932', 0),
(0, 'Thiernu', 'France', 'Europe', 'FRPI1608', 0),
(0, 'Thiers', 'France', 'Europe', 'FRXX2698', 0),
(0, 'Thiers-sur-Theve', 'France', 'Europe', 'FRPI1609', 0),
(0, 'Thierville', 'France', 'Europe', 'FRHN0933', 0),
(0, 'Thierville-sur-Meuse', 'France', 'Europe', 'FRXX5888', 0),
(0, 'Thiery', 'France', 'Europe', 'FRPA0635', 0),
(0, 'Thiescourt', 'France', 'Europe', 'FRPI1610', 0),
(0, 'Thietreville', 'France', 'Europe', 'FRHN0934', 0),
(0, 'Thieulloy-l`Abbaye', 'France', 'Europe', 'FRXX2239', 0),
(0, 'Thieulloy-la-Ville', 'France', 'Europe', 'FRPI1611', 0),
(0, 'Thieuloy-Saint-Antoine', 'France', 'Europe', 'FRPI1612', 0),
(0, 'Thieux', 'France', 'Europe', 'FRIF0597', 0),
(0, 'Thieux', 'France', 'Europe', 'FRPI1613', 0),
(0, 'Thieville', 'France', 'Europe', 'FRBN1396', 0),
(0, 'Thievres', 'France', 'Europe', 'FRPI1614', 0),
(0, 'Thievres', 'France', 'Europe', 'FRPI1615', 0),
(0, 'Thiezac', 'France', 'Europe', 'FRXX2213', 0),
(0, 'Thignonville', 'France', 'Europe', 'FRCE1216', 0),
(0, 'Thil', 'France', 'Europe', 'FRCA1436', 0),
(0, 'Thil', 'France', 'Europe', 'FRCA1437', 0),
(0, 'Thil', 'France', 'Europe', 'FRMP2325', 0),
(0, 'Thil', 'France', 'Europe', 'FRRA1976', 0),
(0, 'Thil', 'France', 'Europe', 'FRXX4143', 0),
(0, 'Thil-Manneville', 'France', 'Europe', 'FRHN0935', 0),
(0, 'Thil-sur-Arroux', 'France', 'Europe', 'FRBO1370', 0),
(0, 'Thilay', 'France', 'Europe', 'FRCA1438', 0),
(0, 'Thilleux', 'France', 'Europe', 'FRCA1439', 0),
(0, 'Thillois', 'France', 'Europe', 'FRCA1440', 0),
(0, 'Thillombois', 'France', 'Europe', 'FRLO1588', 0),
(0, 'Thillot', 'France', 'Europe', 'FRLO1589', 0),
(0, 'Thilouze', 'France', 'Europe', 'FRCE1217', 0),
(0, 'Thimert-Gatelles', 'France', 'Europe', 'FRCE1218', 0),
(0, 'Thimonville', 'France', 'Europe', 'FRLO1590', 0),
(0, 'Thimory', 'France', 'Europe', 'FRCE1219', 0),
(0, 'Thin-le-Moutier', 'France', 'Europe', 'FRXX4080', 0),
(0, 'Thines', 'France', 'Europe', 'FRRA1977', 0),
(0, 'Thio', 'France', 'Europe', 'FRXX7949', 0),
(0, 'Thiolieres', 'France', 'Europe', 'FRAU0855', 0),
(0, 'Thionne', 'France', 'Europe', 'FRAU0856', 0),
(0, 'Thionville', 'France', 'Europe', 'FRXX4472', 0),
(0, 'Thiouville', 'France', 'Europe', 'FRHN0936', 0),
(0, 'Thiraucourt', 'France', 'Europe', 'FRLO1591', 0),
(0, 'Thire', 'France', 'Europe', 'FRPL0995', 0),
(0, 'Thiron Gardais', 'France', 'Europe', 'FRXX3368', 0),
(0, 'This', 'France', 'Europe', 'FRCA1441', 0),
(0, 'Thise', 'France', 'Europe', 'FRFC1284', 0),
(0, 'Thivars', 'France', 'Europe', 'FRCE1220', 0),
(0, 'Thivencelle', 'France', 'Europe', 'FRXX3726', 0),
(0, 'Thiverny', 'France', 'Europe', 'FRPI1616', 0),
(0, 'Thiverval-Grignon', 'France', 'Europe', 'FRXX5811', 0),
(0, 'Thivet', 'France', 'Europe', 'FRCA1442', 0),
(0, 'Thiviers', 'France', 'Europe', 'FRAQ1675', 0),
(0, 'Thiville', 'France', 'Europe', 'FRCE1221', 0),
(0, 'Thizay', 'France', 'Europe', 'FRCE1222', 0),
(0, 'Thizay', 'France', 'Europe', 'FRCE1223', 0),
(0, 'Thizy', 'France', 'Europe', 'FRBO1371', 0),
(0, 'Thizy', 'France', 'Europe', 'FRRA1978', 0),
(0, 'Thoard', 'France', 'Europe', 'FRPA0636', 0),
(0, 'Thodure', 'France', 'Europe', 'FRRA1979', 0),
(0, 'Thoigne', 'France', 'Europe', 'FRPL0996', 0),
(0, 'Thoiras', 'France', 'Europe', 'FRLR0896', 0),
(0, 'Thoire-sous-Contensor', 'France', 'Europe', 'FRPL0997', 0),
(0, 'Thoire-sur-Dinan', 'France', 'Europe', 'FRPL0998', 0),
(0, 'Thoires', 'France', 'Europe', 'FRBO1372', 0),
(0, 'Vaudeloges', 'France', 'Europe', 'FRBN1450', 0),
(0, 'Vaudemange', 'France', 'Europe', 'FRCA1512', 0),
(0, 'Vaudemont', 'France', 'Europe', 'FRLO1679', 0),
(0, 'Vaudes', 'France', 'Europe', 'FRCA1513', 0),
(0, 'Vaudesincourt', 'France', 'Europe', 'FRCA1514', 0),
(0, 'Vaudesson', 'France', 'Europe', 'FRPI1669', 0),
(0, 'Vaudeurs', 'France', 'Europe', 'FRXX3746', 0),
(0, 'Vaudevant', 'France', 'Europe', 'FRRA2051', 0),
(0, 'Vaudeville', 'France', 'Europe', 'FRLO1680', 0),
(0, 'Vaudeville', 'France', 'Europe', 'FRLO1681', 0),
(0, 'Vaudeville-le-Haut', 'France', 'Europe', 'FRLO1682', 0),
(0, 'Vaudherland', 'France', 'Europe', 'FRIF0618', 0),
(0, 'Vaudigny', 'France', 'Europe', 'FRLO1683', 0),
(0, 'Vaudoncourt', 'France', 'Europe', 'FRLO1684', 0),
(0, 'Vaudoncourt', 'France', 'Europe', 'FRLO1685', 0),
(0, 'Vaudoncourt', 'France', 'Europe', 'FRLO1686', 0),
(0, 'Vaudoy-en-Brie', 'France', 'Europe', 'FRXX5610', 0),
(0, 'Vaudreching', 'France', 'Europe', 'FRLO1687', 0),
(0, 'Vaudrecourt', 'France', 'Europe', 'FRCA1515', 0),
(0, 'Vaudremont', 'France', 'Europe', 'FRCA1516', 0),
(0, 'Vaudreuille', 'France', 'Europe', 'FRMP2408', 0),
(0, 'Vaudreville', 'France', 'Europe', 'FRBN1451', 0),
(0, 'Vaudrey', 'France', 'Europe', 'FRFC1340', 0),
(0, 'Vaudricourt', 'France', 'Europe', 'FRPI1670', 0),
(0, 'Vaudrimesnil', 'France', 'Europe', 'FRBN1452', 0),
(0, 'Vaudringhem', 'France', 'Europe', 'FRNC0930', 0),
(0, 'Vaudrivillers', 'France', 'Europe', 'FRFC1341', 0),
(0, 'Vaudry', 'France', 'Europe', 'FRBN1453', 0),
(0, 'Vaufrege', 'France', 'Europe', 'FRPA0675', 0),
(0, 'Vaufrey', 'France', 'Europe', 'FRFC1342', 0),
(0, 'Vaugines', 'France', 'Europe', 'FRPA0676', 0),
(0, 'Vaugneray', 'France', 'Europe', 'FRRA2052', 0),
(0, 'Vaugrigneuse', 'France', 'Europe', 'FRXX2962', 0),
(0, 'Vauhallan', 'France', 'Europe', 'FRIF0619', 0),
(0, 'Vaujany', 'France', 'Europe', 'FRXX0465', 0),
(0, 'Vaujours', 'France', 'Europe', 'FRXX1560', 0),
(0, 'Vaulandry', 'France', 'Europe', 'FRXX2387', 0),
(0, 'Vaulnaveys-le-Bas', 'France', 'Europe', 'FRRA2053', 0),
(0, 'Vaulnaveys-le-Haut', 'France', 'Europe', 'FRXX1248', 0),
(0, 'Vaulry', 'France', 'Europe', 'FRLI0551', 0),
(0, 'Vault-de-Lugny', 'France', 'Europe', 'FRBO1449', 0),
(0, 'Vaulx', 'France', 'Europe', 'FRNC0931', 0),
(0, 'Vaulx', 'France', 'Europe', 'FRRA2054', 0),
(0, 'Vaulx-en-Velin', 'France', 'Europe', 'FRXX3784', 0),
(0, 'Vaulx-Milieu', 'France', 'Europe', 'FRRA2055', 0),
(0, 'Vaulx-Vraucourt', 'France', 'Europe', 'FRXX2145', 0),
(0, 'Vaumas', 'France', 'Europe', 'FRAU0896', 0),
(0, 'Vaumeilh', 'France', 'Europe', 'FRPA0677', 0),
(0, 'Vaumoise', 'France', 'Europe', 'FRXX3481', 0),
(0, 'Vaumort', 'France', 'Europe', 'FRBO1450', 0),
(0, 'Vaunac', 'France', 'Europe', 'FRAQ1716', 0),
(0, 'Vaunaveys-la-Rochette', 'France', 'Europe', 'FRRA2056', 0),
(0, 'Vaunoise', 'France', 'Europe', 'FRBN1454', 0),
(0, 'Vaupillon', 'France', 'Europe', 'FRCE1265', 0),
(0, 'Vaupoisson', 'France', 'Europe', 'FRCA1517', 0),
(0, 'Vauquois', 'France', 'Europe', 'FRLO1688', 0),
(0, 'Vaureal', 'France', 'Europe', 'FRXX5340', 0),
(0, 'Vaureilles', 'France', 'Europe', 'FRMP2409', 0),
(0, 'Vausseroux', 'France', 'Europe', 'FRPC1126', 0),
(0, 'Vautebis', 'France', 'Europe', 'FRPC1127', 0),
(0, 'Vauthiermont', 'France', 'Europe', 'FRMP2410', 0),
(0, 'Vautorte', 'France', 'Europe', 'FRPL1033', 0),
(0, 'Vauvenargues', 'France', 'Europe', 'FRXX3994', 0),
(0, 'Vauvert', 'France', 'Europe', 'FRPA0678', 0),
(0, 'Vauville', 'France', 'Europe', 'FRBN1455', 0),
(0, 'Vauville', 'France', 'Europe', 'FRBN1456', 0),
(0, 'Vauvillers', 'France', 'Europe', 'FRFC1343', 0),
(0, 'Vauvillers', 'France', 'Europe', 'FRPI1671', 0),
(0, 'Vaux', 'France', 'Europe', 'FRAU0897', 0),
(0, 'Vaux', 'France', 'Europe', 'FRBO1451', 0),
(0, 'Vaux', 'France', 'Europe', 'FRMP2411', 0),
(0, 'Vaux', 'France', 'Europe', 'FRPC1128', 0),
(0, 'Vaux-Andigny', 'France', 'Europe', 'FRXX5593', 0),
(0, 'Vaux-Champagne', 'France', 'Europe', 'FRCA1518', 0),
(0, 'Vaux-devant-Damloup', 'France', 'Europe', 'FRLO1689', 0),
(0, 'Vaux-en-Amienois', 'France', 'Europe', 'FRPI1673', 0),
(0, 'Vaux-en-Beaujolais', 'France', 'Europe', 'FRXX4208', 0),
(0, 'Vaux-en-Bugey', 'France', 'Europe', 'FRXX5214', 0),
(0, 'Vaux-en-Dieulet', 'France', 'Europe', 'FRCA1521', 0),
(0, 'Vaux-en-Pre', 'France', 'Europe', 'FRBO1453', 0),
(0, 'Angles', 'France', 'Europe', 'FRPA0010', 0),
(0, 'Angles', 'France', 'Europe', 'FRXX6590', 0),
(0, 'Anglet', 'France', 'Europe', 'FRXX5606', 0),
(0, 'Angliers', 'France', 'Europe', 'FRPC0024', 0),
(0, 'Angliers', 'France', 'Europe', 'FRPC0025', 0),
(0, 'Anglure', 'France', 'Europe', 'FRCA0023', 0),
(0, 'Anglus', 'France', 'Europe', 'FRCA0024', 0),
(0, 'Angoisse', 'France', 'Europe', 'FRAQ0021', 0),
(0, 'Angomont', 'France', 'Europe', 'FRLO0032', 0),
(0, 'Angos', 'France', 'Europe', 'FRMP0044', 0),
(0, 'Angouleme', 'France', 'Europe', 'FRXX0314', 0),
(0, 'Angoulins-sur-Mer', 'France', 'Europe', 'FRXX1092', 0),
(0, 'Angoume', 'France', 'Europe', 'FRAQ0022', 0),
(0, 'Angous', 'France', 'Europe', 'FRAQ0023', 0),
(0, 'Angoville', 'France', 'Europe', 'FRBN0020', 0),
(0, 'Angres', 'France', 'Europe', 'FRXX6582', 0),
(0, 'Angresse', 'France', 'Europe', 'FRAQ0024', 0),
(0, 'Angrie', 'France', 'Europe', 'FRPL0010', 0),
(0, 'Anguerny', 'France', 'Europe', 'FRBN0021', 0),
(0, 'Angy', 'France', 'Europe', 'FRPI0037', 0),
(0, 'Anhiers', 'France', 'Europe', 'FRNC0024', 0),
(0, 'Aniane', 'France', 'Europe', 'FRLR0021', 0),
(0, 'Anisy', 'France', 'Europe', 'FRBN0022', 0),
(0, 'Anjeux', 'France', 'Europe', 'FRFC0036', 0),
(0, 'Anjou', 'France', 'Europe', 'FRRA0047', 0),
(0, 'Anjouin', 'France', 'Europe', 'FRCE0014', 0),
(0, 'Anjoutey', 'France', 'Europe', 'FRMP0045', 0),
(0, 'Anla', 'France', 'Europe', 'FRMP0046', 0),
(0, 'Anlezy', 'France', 'Europe', 'FRBO0019', 0),
(0, 'Anlhiac', 'France', 'Europe', 'FRAQ0025', 0),
(0, 'Annay', 'France', 'Europe', 'FRBO0020', 0),
(0, 'Annebecq', 'France', 'Europe', 'FRBN0023', 0),
(0, 'Annecy', 'France', 'Europe', 'FRXX0360', 0),
(0, 'Annecy-le-Vieux', 'France', 'Europe', 'FRXX4327', 0),
(0, 'Annemasse', 'France', 'Europe', 'FRXX0003', 0),
(0, 'Anneot', 'France', 'Europe', 'FRBO0021', 0),
(0, 'Annepont', 'France', 'Europe', 'FRPC0026', 0),
(0, 'Annequin', 'France', 'Europe', 'FRNC0025', 0),
(0, 'Anneyron', 'France', 'Europe', 'FRRA0048', 0),
(0, 'Annezay', 'France', 'Europe', 'FRPC0027', 0),
(0, 'Annoeullin', 'France', 'Europe', 'FRXX4359', 0),
(0, 'Annoire', 'France', 'Europe', 'FRFC0037', 0),
(0, 'Annois', 'France', 'Europe', 'FRPI0038', 0),
(0, 'Annonay', 'France', 'Europe', 'FRXX0409', 0),
(0, 'Annonville', 'France', 'Europe', 'FRCA0025', 0),
(0, 'Annoux', 'France', 'Europe', 'FRBO0022', 0),
(0, 'Annoville', 'France', 'Europe', 'FRBN0024', 0),
(0, 'Anor', 'France', 'Europe', 'FRXX6307', 0),
(0, 'Anos', 'France', 'Europe', 'FRAQ0026', 0),
(0, 'Anould', 'France', 'Europe', 'FRLO0033', 0),
(0, 'Anoux', 'France', 'Europe', 'FRLO0034', 0),
(0, 'Anoye', 'France', 'Europe', 'FRAQ0027', 0),
(0, 'Anquetierville', 'France', 'Europe', 'FRHN0012', 0),
(0, 'Anrosey', 'France', 'Europe', 'FRCA0026', 0),
(0, 'Ansacq', 'France', 'Europe', 'FRPI0039', 0),
(0, 'Ansan', 'France', 'Europe', 'FRMP0047', 0),
(0, 'Ansauville', 'France', 'Europe', 'FRLO0035', 0),
(0, 'Ansauvillers', 'France', 'Europe', 'FRPI0040', 0),
(0, 'Anse', 'France', 'Europe', 'FRRA0049', 0),
(0, 'Anse-Bertrand', 'France', 'Europe', 'FRXX7717', 0),
(0, 'Anserville', 'France', 'Europe', 'FRPI0041', 0),
(0, 'Ansigny', 'France', 'Europe', 'FRRA0050', 0),
(0, 'Ansost', 'France', 'Europe', 'FRMP0048', 0),
(0, 'Anstaing', 'France', 'Europe', 'FRNC0026', 0),
(0, 'Antagnac', 'France', 'Europe', 'FRAQ0028', 0),
(0, 'Anterrieux', 'France', 'Europe', 'FRAU0008', 0),
(0, 'Anteuil', 'France', 'Europe', 'FRFC0038', 0),
(0, 'Antezant-la-Chapelle', 'France', 'Europe', 'FRPC0028', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Anthe', 'France', 'Europe', 'FRAQ0029', 0),
(0, 'Anthelupt', 'France', 'Europe', 'FRLO0036', 0),
(0, 'Anthenay', 'France', 'Europe', 'FRCA0027', 0),
(0, 'Antheny', 'France', 'Europe', 'FRCA0028', 0),
(0, 'Antheuil', 'France', 'Europe', 'FRBO0023', 0),
(0, 'Anthien', 'France', 'Europe', 'FRBO0024', 0),
(0, 'Anthon', 'France', 'Europe', 'FRRA0051', 0),
(0, 'Anthy-sur-Leman', 'France', 'Europe', 'FRRA0052', 0),
(0, 'Antibes', 'France', 'Europe', 'FRXX0004', 0),
(0, 'Antichan', 'France', 'Europe', 'FRMP0049', 0),
(0, 'Antignac', 'France', 'Europe', 'FRAU0009', 0),
(0, 'Antignac', 'France', 'Europe', 'FRMP0050', 0),
(0, 'Beaurepaire', 'France', 'Europe', 'FRHN0036', 0),
(0, 'Beaurepaire', 'France', 'Europe', 'FRPI0116', 0),
(0, 'Beaurepaire', 'France', 'Europe', 'FRPL0046', 0),
(0, 'Beaurepaire', 'France', 'Europe', 'FRRA0139', 0),
(0, 'Beaurevoir', 'France', 'Europe', 'FRPI0117', 0),
(0, 'Beaurieres', 'France', 'Europe', 'FRRA0140', 0),
(0, 'Beaurieux', 'France', 'Europe', 'FRNC0092', 0),
(0, 'Beaurieux', 'France', 'Europe', 'FRPI0118', 0),
(0, 'Beauronne', 'France', 'Europe', 'FRAQ0127', 0),
(0, 'Beausemblant', 'France', 'Europe', 'FRRA0141', 0),
(0, 'Beausoleil', 'France', 'Europe', 'FRXX2246', 0),
(0, 'Beaussac', 'France', 'Europe', 'FRAQ0128', 0),
(0, 'Beaussais', 'France', 'Europe', 'FRPC0077', 0),
(0, 'Beaussault', 'France', 'Europe', 'FRHN0037', 0),
(0, 'Beausse', 'France', 'Europe', 'FRPL0047', 0),
(0, 'Beauteville', 'France', 'Europe', 'FRMP0209', 0),
(0, 'Beautheil', 'France', 'Europe', 'FRIF0046', 0),
(0, 'Beautor', 'France', 'Europe', 'FRPI0119', 0),
(0, 'Beautot', 'France', 'Europe', 'FRHN0038', 0),
(0, 'Beauvain', 'France', 'Europe', 'FRBN0072', 0),
(0, 'Beauvais', 'France', 'Europe', 'FRXX0011', 0),
(0, 'Beauval', 'France', 'Europe', 'FRXX5913', 0),
(0, 'Beauval-en-Caux', 'France', 'Europe', 'FRHN0039', 0),
(0, 'Beauvallon', 'France', 'Europe', 'FRRA0142', 0),
(0, 'Beauvau', 'France', 'Europe', 'FRPL0048', 0),
(0, 'Beauvene', 'France', 'Europe', 'FRRA0143', 0),
(0, 'Beauvernois', 'France', 'Europe', 'FRBO0074', 0),
(0, 'Beauville', 'France', 'Europe', 'FRMP0210', 0),
(0, 'Beauville', 'France', 'Europe', 'FRXX3124', 0),
(0, 'Beauvilliers', 'France', 'Europe', 'FRCE0051', 0),
(0, 'Beauvilliers', 'France', 'Europe', 'FRCE0052', 0),
(0, 'Beauvilliers', 'France', 'Europe', 'FRXX2936', 0),
(0, 'Beauvoir', 'France', 'Europe', 'FRBN0073', 0),
(0, 'Beauvoir', 'France', 'Europe', 'FRBO0075', 0),
(0, 'Beauvoir', 'France', 'Europe', 'FRIF0047', 0),
(0, 'Beauvoir', 'France', 'Europe', 'FRPI0120', 0),
(0, 'Beauvoir-en-Royans', 'France', 'Europe', 'FRRA0144', 0),
(0, 'Beauvoir-sur-Mer', 'France', 'Europe', 'FRXX7704', 0),
(0, 'Beauvois', 'France', 'Europe', 'FRNC0093', 0),
(0, 'Beauvois-en-Cambresis', 'France', 'Europe', 'FRXX5944', 0),
(0, 'Beauvoisin', 'France', 'Europe', 'FRFC0106', 0),
(0, 'Beauvoisin', 'France', 'Europe', 'FRRA0145', 0),
(0, 'Beauvoisin', 'France', 'Europe', 'FRXX6267', 0),
(0, 'Beaux', 'France', 'Europe', 'FRAU0047', 0),
(0, 'Beauzac', 'France', 'Europe', 'FRXX3494', 0),
(0, 'Beauzelle', 'France', 'Europe', 'FRMP0211', 0),
(0, 'Beauziac', 'France', 'Europe', 'FRAQ0129', 0),
(0, 'Bebing', 'France', 'Europe', 'FRLO0119', 0),
(0, 'Beblenheim', 'France', 'Europe', 'FRXX3566', 0),
(0, 'Beccas', 'France', 'Europe', 'FRMP0212', 0),
(0, 'Beceleuf', 'France', 'Europe', 'FRPC0078', 0),
(0, 'Bechamps', 'France', 'Europe', 'FRLO0120', 0),
(0, 'Becheresse', 'France', 'Europe', 'FRPC0079', 0),
(0, 'Bechy', 'France', 'Europe', 'FRLO0121', 0),
(0, 'Beconne', 'France', 'Europe', 'FRRA0146', 0),
(0, 'Becourt', 'France', 'Europe', 'FRNC0094', 0),
(0, 'Becquigny', 'France', 'Europe', 'FRPI0121', 0),
(0, 'Becquigny', 'France', 'Europe', 'FRPI0122', 0),
(0, 'Bedarrides', 'France', 'Europe', 'FRXX3781', 0),
(0, 'Bedechan', 'France', 'Europe', 'FRMP0213', 0),
(0, 'Bedeille', 'France', 'Europe', 'FRAQ0130', 0),
(0, 'Bedeille', 'France', 'Europe', 'FRMP0214', 0),
(0, 'Bedenac', 'France', 'Europe', 'FRPC0080', 0),
(0, 'Bedoues', 'France', 'Europe', 'FRLR0068', 0),
(0, 'Bedous', 'France', 'Europe', 'FRAQ0131', 0),
(0, 'Beduer', 'France', 'Europe', 'FRMP0215', 0),
(0, 'Beffes', 'France', 'Europe', 'FRCE0053', 0),
(0, 'Beffia', 'France', 'Europe', 'FRFC0107', 0),
(0, 'Begaar', 'France', 'Europe', 'FRAQ0132', 0),
(0, 'Begadan', 'France', 'Europe', 'FRAQ0133', 0),
(0, 'Begles', 'France', 'Europe', 'FRXX5183', 0),
(0, 'Begnecourt', 'France', 'Europe', 'FRLO0122', 0),
(0, 'Begole', 'France', 'Europe', 'FRMP0216', 0),
(0, 'Beguey', 'France', 'Europe', 'FRAQ0134', 0),
(0, 'Behagnies', 'France', 'Europe', 'FRNC0095', 0),
(0, 'Behen', 'France', 'Europe', 'FRPI0123', 0),
(0, 'Behencourt', 'France', 'Europe', 'FRPI0124', 0),
(0, 'Behericourt', 'France', 'Europe', 'FRPI0125', 0),
(0, 'Behlenheim', 'France', 'Europe', 'FRAL0018', 0),
(0, 'Behonne', 'France', 'Europe', 'FRLO0123', 0),
(0, 'Cazaunous', 'France', 'Europe', 'FRMP0485', 0),
(0, 'Cazaux', 'France', 'Europe', 'FRMP0486', 0),
(0, 'Cazavet', 'France', 'Europe', 'FRMP0487', 0),
(0, 'Cazedarnes', 'France', 'Europe', 'FRLR0147', 0),
(0, 'Cazeneuve', 'France', 'Europe', 'FRMP0488', 0),
(0, 'Cazeres', 'France', 'Europe', 'FRMP0489', 0),
(0, 'Cazes-Mondenard', 'France', 'Europe', 'FRMP0490', 0),
(0, 'Cazevieille', 'France', 'Europe', 'FRLR0148', 0),
(0, 'Cazideroque', 'France', 'Europe', 'FRAQ0304', 0),
(0, 'Cazilhac', 'France', 'Europe', 'FRLR0149', 0),
(0, 'Cazilhac', 'France', 'Europe', 'FRLR0150', 0),
(0, 'Cazillac', 'France', 'Europe', 'FRMP0491', 0),
(0, 'Cazoules', 'France', 'Europe', 'FRMP0492', 0),
(0, 'Ceauce', 'France', 'Europe', 'FRBN0189', 0),
(0, 'Ceaulmont', 'France', 'Europe', 'FRCE0121', 0),
(0, 'Ceaux', 'France', 'Europe', 'FRBN0190', 0),
(0, 'Cebazan', 'France', 'Europe', 'FRLR0151', 0),
(0, 'Cebazat', 'France', 'Europe', 'FRXX1989', 0),
(0, 'Ceffia', 'France', 'Europe', 'FRFC0206', 0),
(0, 'Ceffonds', 'France', 'Europe', 'FRCA0196', 0),
(0, 'Ceignes', 'France', 'Europe', 'FRRA0248', 0),
(0, 'Ceillac', 'France', 'Europe', 'FRPA0104', 0),
(0, 'Ceilloux', 'France', 'Europe', 'FRAU0092', 0),
(0, 'Ceintrey', 'France', 'Europe', 'FRLO0242', 0),
(0, 'Celle', 'France', 'Europe', 'FRCE0122', 0),
(0, 'Cellefrouin', 'France', 'Europe', 'FRPC0154', 0),
(0, 'Celles', 'France', 'Europe', 'FRAQ0305', 0),
(0, 'Celles', 'France', 'Europe', 'FRAU0093', 0),
(0, 'Celles', 'France', 'Europe', 'FRLR0152', 0),
(0, 'Celles', 'France', 'Europe', 'FRMP0493', 0),
(0, 'Celles', 'France', 'Europe', 'FRPC0155', 0),
(0, 'Cellettes', 'France', 'Europe', 'FRCE0123', 0),
(0, 'Cellettes', 'France', 'Europe', 'FRPC0156', 0),
(0, 'Celliers', 'France', 'Europe', 'FRRA0249', 0),
(0, 'Cellieu', 'France', 'Europe', 'FRRA0250', 0),
(0, 'Cellule', 'France', 'Europe', 'FRAU0094', 0),
(0, 'Celon', 'France', 'Europe', 'FRCE0124', 0),
(0, 'Celoux', 'France', 'Europe', 'FRAU0095', 0),
(0, 'Celsoy', 'France', 'Europe', 'FRCA0197', 0),
(0, 'Cemboing', 'France', 'Europe', 'FRFC0207', 0),
(0, 'Cempuis', 'France', 'Europe', 'FRPI0298', 0),
(0, 'Cenac', 'France', 'Europe', 'FRAQ0306', 0),
(0, 'Cenans', 'France', 'Europe', 'FRFC0208', 0),
(0, 'Cendras', 'France', 'Europe', 'FRLR0153', 0),
(0, 'Cendrecourt', 'France', 'Europe', 'FRFC0209', 0),
(0, 'Cendrey', 'France', 'Europe', 'FRFC0210', 0),
(0, 'Cendrieux', 'France', 'Europe', 'FRAQ0307', 0),
(0, 'Cenomes', 'France', 'Europe', 'FRMP0494', 0),
(0, 'Cenon', 'France', 'Europe', 'FRXX2068', 0),
(0, 'Censeau', 'France', 'Europe', 'FRFC0211', 0),
(0, 'Censerey', 'France', 'Europe', 'FRBO0162', 0),
(0, 'Censy', 'France', 'Europe', 'FRBO0163', 0),
(0, 'Centres', 'France', 'Europe', 'FRMP0495', 0),
(0, 'Cenves', 'France', 'Europe', 'FRRA0251', 0),
(0, 'Cepet', 'France', 'Europe', 'FRMP0496', 0),
(0, 'Cepie', 'France', 'Europe', 'FRLR0154', 0),
(0, 'Cepoy', 'France', 'Europe', 'FRCE0125', 0),
(0, 'Ceran', 'France', 'Europe', 'FRMP0497', 0),
(0, 'Cerbois', 'France', 'Europe', 'FRCE0126', 0),
(0, 'Cercier', 'France', 'Europe', 'FRRA0252', 0),
(0, 'Cercles', 'France', 'Europe', 'FRAQ0308', 0),
(0, 'Cercottes', 'France', 'Europe', 'FRCE0127', 0),
(0, 'Cercoux', 'France', 'Europe', 'FRPC0157', 0),
(0, 'Cerdon', 'France', 'Europe', 'FRCE0128', 0),
(0, 'Cerdon', 'France', 'Europe', 'FRRA0253', 0),
(0, 'Cere', 'France', 'Europe', 'FRAQ0309', 0),
(0, 'Cerelles', 'France', 'Europe', 'FRCE0129', 0),
(0, 'Cerences', 'France', 'Europe', 'FRBN0191', 0),
(0, 'Cereste', 'France', 'Europe', 'FRXX2401', 0),
(0, 'Cerfontaine', 'France', 'Europe', 'FRNC0212', 0),
(0, 'Cergy', 'France', 'Europe', 'FRXX0297', 0),
(0, 'Cerilly', 'France', 'Europe', 'FRAU0096', 0),
(0, 'Cerilly', 'France', 'Europe', 'FRBO0164', 0),
(0, 'Cerilly', 'France', 'Europe', 'FRBO0165', 0),
(0, 'Cerise', 'France', 'Europe', 'FRBN0192', 0),
(0, 'Cerisiers', 'France', 'Europe', 'FRBO0166', 0),
(0, 'Cerisy', 'France', 'Europe', 'FRPI0299', 0),
(0, 'Cerisy-Buleux', 'France', 'Europe', 'FRPI0300', 0),
(0, 'Cerizay', 'France', 'Europe', 'FRPC0158', 0),
(0, 'Cerizy', 'France', 'Europe', 'FRPI0301', 0),
(0, 'Drucourt', 'France', 'Europe', 'FRHN0187', 0),
(0, 'Drudas', 'France', 'Europe', 'FRMP0612', 0),
(0, 'Druelle', 'France', 'Europe', 'FRMP0613', 0),
(0, 'Drugeac', 'France', 'Europe', 'FRLI0120', 0),
(0, 'Druillat', 'France', 'Europe', 'FRRA0503', 0),
(0, 'Drulhe', 'France', 'Europe', 'FRMP0614', 0),
(0, 'Drulingen', 'France', 'Europe', 'FRAL0093', 0),
(0, 'Drusenheim', 'France', 'Europe', 'FRAL0094', 0),
(0, 'Druy-Parigny', 'France', 'Europe', 'FRBO0366', 0),
(0, 'Druye', 'France', 'Europe', 'FRCE0282', 0),
(0, 'Dry', 'France', 'Europe', 'FRCE0283', 0),
(0, 'Ducey', 'France', 'Europe', 'FRBN0316', 0),
(0, 'Duclair', 'France', 'Europe', 'FRHN0188', 0),
(0, 'Ducos', 'France', 'Europe', 'FRXX7753', 0),
(0, 'Duerne', 'France', 'Europe', 'FRRA0504', 0),
(0, 'Duesme', 'France', 'Europe', 'FRBO0367', 0),
(0, 'Duffort', 'France', 'Europe', 'FRMP0615', 0),
(0, 'Dugny', 'France', 'Europe', 'FRXX6714', 0),
(0, 'Duingt', 'France', 'Europe', 'FRRA0505', 0),
(0, 'Duisans', 'France', 'Europe', 'FRNC0278', 0),
(0, 'Dullin', 'France', 'Europe', 'FRRA0506', 0),
(0, 'Dumbea', 'France', 'Europe', 'FRXX7950', 0),
(0, 'Dumes', 'France', 'Europe', 'FRAQ0394', 0),
(0, 'Dun', 'France', 'Europe', 'FRMP0616', 0),
(0, 'Duneau', 'France', 'Europe', 'FRPL0201', 0),
(0, 'Dunes', 'France', 'Europe', 'FRMP0617', 0),
(0, 'Dunet', 'France', 'Europe', 'FRCE0284', 0),
(0, 'Dung', 'France', 'Europe', 'FRFC0411', 0),
(0, 'Duniere-sur-Eyrieux', 'France', 'Europe', 'FRRA0507', 0),
(0, 'Dunieres', 'France', 'Europe', 'FRAU0214', 0),
(0, 'Dunkerque', 'France', 'Europe', 'FRXX0151', 0),
(0, 'Duntzenheim', 'France', 'Europe', 'FRAL0095', 0),
(0, 'Duppigheim', 'France', 'Europe', 'FRAL0096', 0),
(0, 'Duran', 'France', 'Europe', 'FRMP0618', 0),
(0, 'Durance', 'France', 'Europe', 'FRAQ0395', 0),
(0, 'Duranus', 'France', 'Europe', 'FRPA0155', 0),
(0, 'Duranville', 'France', 'Europe', 'FRHN0189', 0),
(0, 'Duras', 'France', 'Europe', 'FRAQ0396', 0),
(0, 'Duravel', 'France', 'Europe', 'FRMP0619', 0),
(0, 'Durban', 'France', 'Europe', 'FRMP0620', 0),
(0, 'Durbans', 'France', 'Europe', 'FRMP0621', 0),
(0, 'Durcet', 'France', 'Europe', 'FRBN0317', 0),
(0, 'Dureil', 'France', 'Europe', 'FRPL0202', 0),
(0, 'Durenque', 'France', 'Europe', 'FRMP0622', 0),
(0, 'Durette', 'France', 'Europe', 'FRRA0508', 0),
(0, 'Durfort', 'France', 'Europe', 'FRMP0623', 0),
(0, 'Durfort', 'France', 'Europe', 'FRMP0624', 0),
(0, 'Durfort-Lacapelette', 'France', 'Europe', 'FRXX2313', 0),
(0, 'Durlinsdorf', 'France', 'Europe', 'FRAL0097', 0),
(0, 'Durmenach', 'France', 'Europe', 'FRAL0098', 0),
(0, 'Durmignat', 'France', 'Europe', 'FRAU0215', 0),
(0, 'Durnes', 'France', 'Europe', 'FRFC0412', 0),
(0, 'Durningen', 'France', 'Europe', 'FRAL0099', 0),
(0, 'Durrenbach', 'France', 'Europe', 'FRAL0100', 0),
(0, 'Durrenentzen', 'France', 'Europe', 'FRAL0101', 0),
(0, 'Durstel', 'France', 'Europe', 'FRAL0102', 0),
(0, 'Durtal', 'France', 'Europe', 'FRPL0203', 0),
(0, 'Durtol', 'France', 'Europe', 'FRAU0216', 0),
(0, 'Dury', 'France', 'Europe', 'FRNC0279', 0),
(0, 'Dury', 'France', 'Europe', 'FRPI0477', 0),
(0, 'Dussac', 'France', 'Europe', 'FRAQ0397', 0),
(0, 'Duttlenheim', 'France', 'Europe', 'FRAL0103', 0),
(0, 'Duvy', 'France', 'Europe', 'FRPI0478', 0),
(0, 'Duzey', 'France', 'Europe', 'FRLO0401', 0),
(0, 'Dye', 'France', 'Europe', 'FRBO0368', 0),
(0, 'Dyo', 'France', 'Europe', 'FRBO0369', 0),
(0, 'Dzaoudzi', 'France', 'Europe', 'FRXX7835', 0),
(0, 'Essert', 'France', 'Europe', 'FRXX4551', 0),
(0, 'Essert-Romand', 'France', 'Europe', 'FRRA0532', 0),
(0, 'Essertaux', 'France', 'Europe', 'FRPI0518', 0),
(0, 'Essertenne', 'France', 'Europe', 'FRBO0395', 0),
(0, 'Esserval-Combe', 'France', 'Europe', 'FRFC0443', 0),
(0, 'Esserval-Tartre', 'France', 'Europe', 'FRFC0444', 0),
(0, 'Essey', 'France', 'Europe', 'FRBO0396', 0),
(0, 'Essey-les-Nancy', 'France', 'Europe', 'FRXX2358', 0),
(0, 'Essia', 'France', 'Europe', 'FRFC0445', 0),
(0, 'Essises', 'France', 'Europe', 'FRPI0519', 0),
(0, 'Esson', 'France', 'Europe', 'FRBN0341', 0),
(0, 'Essoyes', 'France', 'Europe', 'FRCA0416', 0),
(0, 'Estables', 'France', 'Europe', 'FRLR0225', 0),
(0, 'Establet', 'France', 'Europe', 'FRRA0533', 0),
(0, 'Estadens', 'France', 'Europe', 'FRMP0676', 0),
(0, 'Estagel', 'France', 'Europe', 'FRXX5061', 0),
(0, 'Estaing', 'France', 'Europe', 'FRMP0677', 0),
(0, 'Estaing', 'France', 'Europe', 'FRMP0678', 0),
(0, 'Estaires', 'France', 'Europe', 'FRNC0320', 0),
(0, 'Estal', 'France', 'Europe', 'FRMP0679', 0),
(0, 'Estampes', 'France', 'Europe', 'FRMP0680', 0),
(0, 'Estampures', 'France', 'Europe', 'FRMP0681', 0),
(0, 'Estancarbon', 'France', 'Europe', 'FRMP0682', 0),
(0, 'Estandeuil', 'France', 'Europe', 'FRAU0233', 0),
(0, 'Estang', 'France', 'Europe', 'FRMP0683', 0),
(0, 'Estarvielle', 'France', 'Europe', 'FRMP0684', 0),
(0, 'Esteil', 'France', 'Europe', 'FRAU0234', 0),
(0, 'Estenos', 'France', 'Europe', 'FRMP0685', 0),
(0, 'Estensan', 'France', 'Europe', 'FRMP0686', 0),
(0, 'Esternay', 'France', 'Europe', 'FRCA0417', 0),
(0, 'Esterre', 'France', 'Europe', 'FRMP0687', 0),
(0, 'Estevelles', 'France', 'Europe', 'FRNC0321', 0),
(0, 'Esteville', 'France', 'Europe', 'FRHN0214', 0),
(0, 'Estezargues', 'France', 'Europe', 'FRPA0169', 0),
(0, 'Estialescq', 'France', 'Europe', 'FRAQ0416', 0),
(0, 'Estibeaux', 'France', 'Europe', 'FRAQ0417', 0),
(0, 'Estigarde', 'France', 'Europe', 'FRAQ0418', 0),
(0, 'Estillac', 'France', 'Europe', 'FRAQ0419', 0),
(0, 'Estipouy', 'France', 'Europe', 'FRMP0688', 0),
(0, 'Estirac', 'France', 'Europe', 'FRMP0689', 0),
(0, 'Estivals', 'France', 'Europe', 'FRLI0124', 0),
(0, 'Estivareilles', 'France', 'Europe', 'FRAU0235', 0),
(0, 'Estivareilles', 'France', 'Europe', 'FRRA0534', 0),
(0, 'Estivaux', 'France', 'Europe', 'FRLI0125', 0),
(0, 'Estos', 'France', 'Europe', 'FRAQ0420', 0),
(0, 'Estoublon', 'France', 'Europe', 'FRPA0170', 0),
(0, 'Estouches', 'France', 'Europe', 'FRIF0184', 0),
(0, 'Estouy', 'France', 'Europe', 'FRCE0303', 0),
(0, 'Estrablin', 'France', 'Europe', 'FRRA0535', 0),
(0, 'Estramiac', 'France', 'Europe', 'FRMP0690', 0),
(0, 'Estreboeuf', 'France', 'Europe', 'FRPI0520', 0),
(0, 'Estree', 'France', 'Europe', 'FRNC0322', 0),
(0, 'Estree-Blanche', 'France', 'Europe', 'FRNC0323', 0),
(0, 'Estreelles', 'France', 'Europe', 'FRNC0324', 0),
(0, 'Estrees', 'France', 'Europe', 'FRNC0325', 0),
(0, 'Estrees', 'France', 'Europe', 'FRPI0521', 0),
(0, 'Estrennes', 'France', 'Europe', 'FRLO0424', 0),
(0, 'Estreux', 'France', 'Europe', 'FRNC0326', 0),
(0, 'Estry', 'France', 'Europe', 'FRBN0342', 0),
(0, 'Esvres', 'France', 'Europe', 'FRCE0304', 0),
(0, 'Eswars', 'France', 'Europe', 'FRNC0327', 0),
(0, 'Etable', 'France', 'Europe', 'FRRA0536', 0),
(0, 'Etables', 'France', 'Europe', 'FRRA0537', 0),
(0, 'Etables-sur-Mer', 'France', 'Europe', 'FRXX5532', 0),
(0, 'Etagnac', 'France', 'Europe', 'FRPC0313', 0),
(0, 'Etaimpuis', 'France', 'Europe', 'FRHN0215', 0),
(0, 'Etaing', 'France', 'Europe', 'FRNC0328', 0),
(0, 'Etainhus', 'France', 'Europe', 'FRHN0216', 0),
(0, 'Etais', 'France', 'Europe', 'FRBO0397', 0),
(0, 'Etalans', 'France', 'Europe', 'FRFC0446', 0),
(0, 'Etalle', 'France', 'Europe', 'FRCA0418', 0),
(0, 'Etalleville', 'France', 'Europe', 'FRHN0217', 0),
(0, 'Etalon', 'France', 'Europe', 'FRPI0522', 0),
(0, 'Etaules', 'France', 'Europe', 'FRBO0398', 0),
(0, 'Etaules', 'France', 'Europe', 'FRXX6224', 0),
(0, 'Etauliers', 'France', 'Europe', 'FRAQ0421', 0),
(0, 'Etaves-et-Bocquiaux', 'France', 'Europe', 'FRPI0523', 0),
(0, 'Etavigny', 'France', 'Europe', 'FRPI0524', 0),
(0, 'Eteimbes', 'France', 'Europe', 'FRAL0121', 0),
(0, 'Etelfay', 'France', 'Europe', 'FRPI0525', 0),
(0, 'Fontguenand', 'France', 'Europe', 'FRCE0327', 0),
(0, 'Fontjoncouse', 'France', 'Europe', 'FRLR0245', 0),
(0, 'Fontpedrouse', 'France', 'Europe', 'FRLR0246', 0),
(0, 'Fontrailles', 'France', 'Europe', 'FRMP0734', 0),
(0, 'Fontvannes', 'France', 'Europe', 'FRCA0459', 0),
(0, 'Fontvieille', 'France', 'Europe', 'FRXX4800', 0),
(0, 'Forcalqueiret', 'France', 'Europe', 'FRPA0180', 0),
(0, 'Force', 'France', 'Europe', 'FRPL0224', 0),
(0, 'Forceville', 'France', 'Europe', 'FRPI0579', 0),
(0, 'Forcey', 'France', 'Europe', 'FRCA0460', 0),
(0, 'Forciolo', 'France', 'Europe', 'FRCO0072', 0),
(0, 'Forest-Montiers', 'France', 'Europe', 'FRPI0580', 0),
(0, 'Foreste', 'France', 'Europe', 'FRPI0581', 0),
(0, 'Foret de Risoul', 'France', 'Europe', 'FRXX0226', 0),
(0, 'Forfry', 'France', 'Europe', 'FRIF0202', 0),
(0, 'Forges', 'France', 'Europe', 'FRBN0367', 0),
(0, 'Forges', 'France', 'Europe', 'FRBO0434', 0),
(0, 'Forges', 'France', 'Europe', 'FRIF0203', 0),
(0, 'Forges', 'France', 'Europe', 'FRLI0141', 0),
(0, 'Forges', 'France', 'Europe', 'FRPC0334', 0),
(0, 'Forges', 'France', 'Europe', 'FRPL0225', 0),
(0, 'Forgues', 'France', 'Europe', 'FRMP0735', 0),
(0, 'Forleans', 'France', 'Europe', 'FRBO0435', 0),
(0, 'Formentin', 'France', 'Europe', 'FRBN0368', 0),
(0, 'Formerie', 'France', 'Europe', 'FRPI0582', 0),
(0, 'Formigny', 'France', 'Europe', 'FRBN0369', 0),
(0, 'Fornex', 'France', 'Europe', 'FRMP0736', 0),
(0, 'Fors', 'France', 'Europe', 'FRPC0335', 0),
(0, 'Forstfeld', 'France', 'Europe', 'FRAL0131', 0),
(0, 'Forstheim', 'France', 'Europe', 'FRAL0132', 0),
(0, 'Fort De France', 'France', 'Europe', 'FRXX7764', 0),
(0, 'Fort-de-France', 'France', 'Europe', 'FRXX7740', 0),
(0, 'Fort-du-Plasne', 'France', 'Europe', 'FRFC0484', 0),
(0, 'Fort-Mahon-Plage', 'France', 'Europe', 'FRXX3729', 0),
(0, 'Fort-Mardyck', 'France', 'Europe', 'FRNC0361', 0),
(0, 'Fort-Moville', 'France', 'Europe', 'FRHN0237', 0),
(0, 'Fortschwihr', 'France', 'Europe', 'FRAL0133', 0),
(0, 'Fos', 'France', 'Europe', 'FRLR0247', 0),
(0, 'Fos', 'France', 'Europe', 'FRMP0737', 0),
(0, 'Fos-sur-Mer', 'France', 'Europe', 'FRXX1059', 0),
(0, 'Fosse', 'France', 'Europe', 'FRCA0461', 0),
(0, 'Fosse', 'France', 'Europe', 'FRCE0328', 0),
(0, 'Fosse', 'France', 'Europe', 'FRLR0248', 0),
(0, 'Fosse Nouvelle', 'France', 'Europe', 'FRCE0329', 0),
(0, 'Fossemagne', 'France', 'Europe', 'FRAQ0457', 0),
(0, 'Fossemanant', 'France', 'Europe', 'FRPI0583', 0),
(0, 'Fosses', 'France', 'Europe', 'FRIF0204', 0),
(0, 'Fosses-et-Baleyssac', 'France', 'Europe', 'FRAQ0458', 0),
(0, 'Fosseuse', 'France', 'Europe', 'FRPI0584', 0),
(0, 'Fosseux', 'France', 'Europe', 'FRNC0362', 0),
(0, 'Fossieux', 'France', 'Europe', 'FRLO0474', 0),
(0, 'Fossoy', 'France', 'Europe', 'FRPI0585', 0),
(0, 'Foucarmont', 'France', 'Europe', 'FRHN0238', 0),
(0, 'Foucart', 'France', 'Europe', 'FRHN0239', 0),
(0, 'Foucarville', 'France', 'Europe', 'FRBN0370', 0),
(0, 'Fouchanges', 'France', 'Europe', 'FRBO0436', 0),
(0, 'Fouchecourt', 'France', 'Europe', 'FRFC0485', 0),
(0, 'Fouchecourt', 'France', 'Europe', 'FRLO0475', 0),
(0, 'Foucherans', 'France', 'Europe', 'FRFC0486', 0),
(0, 'Foucherans', 'France', 'Europe', 'FRFC0487', 0),
(0, 'Foucheres', 'France', 'Europe', 'FRBO0437', 0),
(0, 'Foucheres', 'France', 'Europe', 'FRCA0462', 0),
(0, 'Foucherolles', 'France', 'Europe', 'FRCE0330', 0),
(0, 'Fouchy', 'France', 'Europe', 'FRAL0134', 0),
(0, 'Foucrainville', 'France', 'Europe', 'FRHN0240', 0),
(0, 'Fouday', 'France', 'Europe', 'FRAL0135', 0),
(0, 'Fouencamps', 'France', 'Europe', 'FRPI0586', 0),
(0, 'Foufflin-Ricametz', 'France', 'Europe', 'FRNC0363', 0),
(0, 'Foug', 'France', 'Europe', 'FRLO0476', 0),
(0, 'Fougaron', 'France', 'Europe', 'FRMP0738', 0),
(0, 'Fougere', 'France', 'Europe', 'FRPL0226', 0),
(0, 'Fougere', 'France', 'Europe', 'FRPL0227', 0),
(0, 'Fougeres', 'France', 'Europe', 'FRXX0373', 0),
(0, 'Fougerolles', 'France', 'Europe', 'FRXX5802', 0),
(0, 'Fougueyrolles', 'France', 'Europe', 'FRAQ0459', 0),
(0, 'Fouilleuse', 'France', 'Europe', 'FRPI0587', 0),
(0, 'Fouilloy', 'France', 'Europe', 'FRPI0588', 0),
(0, 'Fouilloy', 'France', 'Europe', 'FRPI0589', 0),
(0, 'Foulain', 'France', 'Europe', 'FRCA0463', 0),
(0, 'Foulangues', 'France', 'Europe', 'FRPI0590', 0),
(0, 'Gintrac', 'France', 'Europe', 'FRMP0837', 0),
(0, 'Giocatojo', 'France', 'Europe', 'FRCO0077', 0),
(0, 'Gionges', 'France', 'Europe', 'FRCA0500', 0),
(0, 'Giou-de-Mamou', 'France', 'Europe', 'FRAU0258', 0),
(0, 'Gioux', 'France', 'Europe', 'FRLI0147', 0),
(0, 'Gipcy', 'France', 'Europe', 'FRAU0259', 0),
(0, 'Girac', 'France', 'Europe', 'FRMP0838', 0),
(0, 'Girancourt', 'France', 'Europe', 'FRLO0538', 0),
(0, 'Giraumont', 'France', 'Europe', 'FRPI0647', 0),
(0, 'Giraumont', 'France', 'Europe', 'FRXX2199', 0),
(0, 'Girauvoisin', 'France', 'Europe', 'FRLO0539', 0),
(0, 'Gircourt-les-Vieville', 'France', 'Europe', 'FRLO0540', 0),
(0, 'Girecourt-sur-Durbion', 'France', 'Europe', 'FRLO0541', 0),
(0, 'Girefontaine', 'France', 'Europe', 'FRFC0540', 0),
(0, 'Giremoutiers', 'France', 'Europe', 'FRIF0223', 0),
(0, 'Girgols', 'France', 'Europe', 'FRAU0260', 0),
(0, 'Giriviller', 'France', 'Europe', 'FRLO0542', 0),
(0, 'Girmont', 'France', 'Europe', 'FRLO0543', 0),
(0, 'Girmont-Val-d`Ajol', 'France', 'Europe', 'FRXX4525', 0),
(0, 'Girolles', 'France', 'Europe', 'FRBO0477', 0),
(0, 'Girolles', 'France', 'Europe', 'FRXX5779', 0),
(0, 'Giromagny', 'France', 'Europe', 'FRMP0839', 0),
(0, 'Giron', 'France', 'Europe', 'FRRA0608', 0),
(0, 'Gironcourt-sur-Vraine', 'France', 'Europe', 'FRXX6697', 0),
(0, 'Gironde-sur-Dropt', 'France', 'Europe', 'FRAQ0515', 0),
(0, 'Girondelle', 'France', 'Europe', 'FRCA0501', 0),
(0, 'Gironville', 'France', 'Europe', 'FRXX2680', 0),
(0, 'Gironville-et-Neuville', 'France', 'Europe', 'FRCE0361', 0),
(0, 'Gironville-sous-les-Cotes', 'France', 'Europe', 'FRLO0544', 0),
(0, 'Gironville-sur-Essonne', 'France', 'Europe', 'FRXX4614', 0),
(0, 'Giroussens', 'France', 'Europe', 'FRMP0840', 0),
(0, 'Giroux', 'France', 'Europe', 'FRCE0362', 0),
(0, 'Girovillers-sous-Montfort', 'France', 'Europe', 'FRLO0545', 0),
(0, 'Giry', 'France', 'Europe', 'FRBO0478', 0),
(0, 'Gisay-la-Coudre', 'France', 'Europe', 'FRHN0270', 0),
(0, 'Giscaro', 'France', 'Europe', 'FRMP0841', 0),
(0, 'Giscos', 'France', 'Europe', 'FRAQ0516', 0),
(0, 'Gisors', 'France', 'Europe', 'FRXX6256', 0),
(0, 'Gissac', 'France', 'Europe', 'FRMP0842', 0),
(0, 'Gissey-le-Vieil', 'France', 'Europe', 'FRBO0479', 0),
(0, 'Gissey-sous-Flavigny', 'France', 'Europe', 'FRBO0480', 0),
(0, 'Gissey-sur-Ouche', 'France', 'Europe', 'FRBO0481', 0),
(0, 'Gisy-les-Nobles', 'France', 'Europe', 'FRBO0482', 0),
(0, 'Giuncaggio', 'France', 'Europe', 'FRCO0078', 0),
(0, 'Giuncheto', 'France', 'Europe', 'FRCO0079', 0),
(0, 'Givardon', 'France', 'Europe', 'FRCE0363', 0),
(0, 'Givarlais', 'France', 'Europe', 'FRAU0261', 0),
(0, 'Givenchy-en-Gohelle', 'France', 'Europe', 'FRXX5725', 0),
(0, 'Givenchy-le-Noble', 'France', 'Europe', 'FRNC0385', 0),
(0, 'Givenchy-les-la-Bassee', 'France', 'Europe', 'FRXX2858', 0),
(0, 'Giverny', 'France', 'Europe', 'FRIF0224', 0),
(0, 'Giverville', 'France', 'Europe', 'FRHN0271', 0),
(0, 'Givet', 'France', 'Europe', 'FRXX6283', 0),
(0, 'Givonne', 'France', 'Europe', 'FRCA0502', 0),
(0, 'Givors', 'France', 'Europe', 'FRRA0609', 0),
(0, 'Givraines', 'France', 'Europe', 'FRCE0364', 0),
(0, 'Givrand', 'France', 'Europe', 'FRPL0246', 0),
(0, 'Givrauval', 'France', 'Europe', 'FRLO0546', 0),
(0, 'Givrezac', 'France', 'Europe', 'FRPC0359', 0),
(0, 'Givron', 'France', 'Europe', 'FRCA0503', 0),
(0, 'Givry', 'France', 'Europe', 'FRCA0504', 0),
(0, 'Givry', 'France', 'Europe', 'FRXX1604', 0),
(0, 'Givry-en-Argonne', 'France', 'Europe', 'FRXX1683', 0),
(0, 'Givry-les-Loisy', 'France', 'Europe', 'FRCA0505', 0),
(0, 'Givrycourt', 'France', 'Europe', 'FRLO0547', 0),
(0, 'Gizaucourt', 'France', 'Europe', 'FRCA0506', 0),
(0, 'Gizay', 'France', 'Europe', 'FRPC0360', 0),
(0, 'Gizeux', 'France', 'Europe', 'FRCE0365', 0),
(0, 'Gizia', 'France', 'Europe', 'FRFC0541', 0),
(0, 'Gizy', 'France', 'Europe', 'FRPI0648', 0),
(0, 'Glageon', 'France', 'Europe', 'FRNC0386', 0),
(0, 'Glaignes', 'France', 'Europe', 'FRPI0649', 0),
(0, 'Glainans', 'France', 'Europe', 'FRFC0542', 0),
(0, 'Glaine-Montaigut', 'France', 'Europe', 'FRAU0262', 0),
(0, 'Glaire', 'France', 'Europe', 'FRCA0507', 0),
(0, 'Glamondans', 'France', 'Europe', 'FRFC0543', 0),
(0, 'Gland', 'France', 'Europe', 'FRBO0483', 0),
(0, 'Gland', 'France', 'Europe', 'FRPI0650', 0),
(0, 'Glandage', 'France', 'Europe', 'FRRA0610', 0),
(0, 'Glandon', 'France', 'Europe', 'FRLI0148', 0),
(0, 'Heugas', 'France', 'Europe', 'FRAQ0565', 0),
(0, 'Heugleville-sur-Scie', 'France', 'Europe', 'FRXX4188', 0),
(0, 'Heugnes', 'France', 'Europe', 'FRCE0391', 0),
(0, 'Heugon', 'France', 'Europe', 'FRBN0450', 0),
(0, 'Heugueville-sur-Sienne', 'France', 'Europe', 'FRBN0451', 0),
(0, 'Heuilley-Cotton', 'France', 'Europe', 'FRCA0569', 0),
(0, 'Heuilley-le-Grand', 'France', 'Europe', 'FRCA0570', 0),
(0, 'Heuilley-sur-Saone', 'France', 'Europe', 'FRBO0514', 0),
(0, 'Heuland', 'France', 'Europe', 'FRBN0452', 0),
(0, 'Heume-l`Eglise', 'France', 'Europe', 'FRAU0275', 0),
(0, 'Heuqueville', 'France', 'Europe', 'FRHN0347', 0),
(0, 'Heuqueville', 'France', 'Europe', 'FRHN0348', 0),
(0, 'Heuringhem', 'France', 'Europe', 'FRXX4245', 0),
(0, 'Heurteauville', 'France', 'Europe', 'FRHN0349', 0),
(0, 'Heurtevent', 'France', 'Europe', 'FRBN0453', 0),
(0, 'Heusse', 'France', 'Europe', 'FRBN0454', 0),
(0, 'Heutregiville', 'France', 'Europe', 'FRCA0571', 0),
(0, 'Heuzecourt', 'France', 'Europe', 'FRPI0760', 0),
(0, 'Hevilliers', 'France', 'Europe', 'FRLO0683', 0),
(0, 'Heyrieux', 'France', 'Europe', 'FRXX1414', 0),
(0, 'Hezecques', 'France', 'Europe', 'FRNC0460', 0),
(0, 'Hibarette', 'France', 'Europe', 'FRMP0898', 0),
(0, 'Hieres-sur-Amby', 'France', 'Europe', 'FRXX5323', 0),
(0, 'Hierges', 'France', 'Europe', 'FRCA0572', 0),
(0, 'Hiermont', 'France', 'Europe', 'FRPI0761', 0),
(0, 'Hiers-Brouage', 'France', 'Europe', 'FRXX1795', 0),
(0, 'Hiersac', 'France', 'Europe', 'FRPC0383', 0),
(0, 'Hiesse', 'France', 'Europe', 'FRPC0384', 0),
(0, 'Hiesville', 'France', 'Europe', 'FRBN0455', 0),
(0, 'Hieville', 'France', 'Europe', 'FRBN0456', 0),
(0, 'Higueres-Souye', 'France', 'Europe', 'FRAQ0566', 0),
(0, 'Hiis', 'France', 'Europe', 'FRMP0899', 0),
(0, 'Hikueru', 'France', 'Europe', 'FRXX7906', 0),
(0, 'Hilbesheim', 'France', 'Europe', 'FRLO0684', 0),
(0, 'Hillion', 'France', 'Europe', 'FRBR0055', 0),
(0, 'Hilsenheim', 'France', 'Europe', 'FRAL0214', 0),
(0, 'Hilsprich', 'France', 'Europe', 'FRLO0685', 0),
(0, 'Hinacourt', 'France', 'Europe', 'FRPI0762', 0),
(0, 'Hinckange', 'France', 'Europe', 'FRLO0686', 0),
(0, 'Hindisheim', 'France', 'Europe', 'FRAL0215', 0),
(0, 'Hindlingen', 'France', 'Europe', 'FRAL0216', 0),
(0, 'Hinges', 'France', 'Europe', 'FRNC0461', 0),
(0, 'Hinsbourg', 'France', 'Europe', 'FRAL0217', 0),
(0, 'Hinsingen', 'France', 'Europe', 'FRAL0218', 0),
(0, 'Hinx', 'France', 'Europe', 'FRAQ0567', 0),
(0, 'Hipsheim', 'France', 'Europe', 'FRAL0219', 0),
(0, 'Hirel', 'France', 'Europe', 'FRXX6297', 0),
(0, 'Hirschland', 'France', 'Europe', 'FRAL0220', 0),
(0, 'Hirsingue', 'France', 'Europe', 'FRXX2618', 0),
(0, 'Hirson', 'France', 'Europe', 'FRPI0763', 0),
(0, 'Hirtzbach', 'France', 'Europe', 'FRXX1460', 0),
(0, 'Hirtzfelden', 'France', 'Europe', 'FRAL0221', 0),
(0, 'His', 'France', 'Europe', 'FRMP0900', 0),
(0, 'Hitiaa O Te Ra', 'France', 'Europe', 'FRXX7851', 0),
(0, 'Hitte', 'France', 'Europe', 'FRMP0901', 0),
(0, 'Hiva-Oa', 'France', 'Europe', 'FRXX7884', 0),
(0, 'Hochfelden', 'France', 'Europe', 'FRAL0222', 0),
(0, 'Hochstatt', 'France', 'Europe', 'FRAL0223', 0),
(0, 'Hochstett', 'France', 'Europe', 'FRAL0224', 0),
(0, 'Hocquigny', 'France', 'Europe', 'FRBN0457', 0),
(0, 'Hocquincourt', 'France', 'Europe', 'FRPI0764', 0),
(0, 'Hocquinghen', 'France', 'Europe', 'FRNC0462', 0),
(0, 'Hodenc-en-Bray', 'France', 'Europe', 'FRPI0765', 0),
(0, 'Hodenc-l`Eveque', 'France', 'Europe', 'FRPI0766', 0),
(0, 'Hodeng-au-Bosc', 'France', 'Europe', 'FRPI0767', 0),
(0, 'Hodeng-Hodenger', 'France', 'Europe', 'FRHN0350', 0),
(0, 'Hodent', 'France', 'Europe', 'FRIF0256', 0),
(0, 'Hoedic', 'France', 'Europe', 'FRBR0056', 0),
(0, 'Hoenheim', 'France', 'Europe', 'FRXX3643', 0),
(0, 'Hoerdt', 'France', 'Europe', 'FRXX4419', 0),
(0, 'Hoeville', 'France', 'Europe', 'FRLO0687', 0),
(0, 'Hoffen', 'France', 'Europe', 'FRAL0225', 0),
(0, 'Hohatzenheim', 'France', 'Europe', 'FRAL0226', 0),
(0, 'Hohengoeft', 'France', 'Europe', 'FRAL0227', 0),
(0, 'Hohfrankenheim', 'France', 'Europe', 'FRAL0228', 0),
(0, 'Hohwiller', 'France', 'Europe', 'FRAL0229', 0),
(0, 'Holacourt', 'France', 'Europe', 'FRLO0688', 0),
(0, 'Holling', 'France', 'Europe', 'FRLO0689', 0),
(0, 'Holnon', 'France', 'Europe', 'FRXX1712', 0),
(0, 'Holque', 'France', 'Europe', 'FRNC0463', 0),
(0, 'La Chaulme', 'France', 'Europe', 'FRAU0310', 0),
(0, 'La Chaume', 'France', 'Europe', 'FRBO0573', 0),
(0, 'La Chaumusse', 'France', 'Europe', 'FRFC0627', 0),
(0, 'La Chaussade', 'France', 'Europe', 'FRLI0180', 0),
(0, 'La Chaussaire', 'France', 'Europe', 'FRPL0340', 0),
(0, 'La Chaussee', 'France', 'Europe', 'FRHN0390', 0),
(0, 'La Chaussee', 'France', 'Europe', 'FRPC0427', 0),
(0, 'La Chaussee-d`Ivry', 'France', 'Europe', 'FRCE0458', 0),
(0, 'La Chaussee-Saint-Victor', 'France', 'Europe', 'FRXX1525', 0),
(0, 'La Chaussee-sur-Marne', 'France', 'Europe', 'FRXX5367', 0),
(0, 'La Chaussee-Tirancourt', 'France', 'Europe', 'FRPI0804', 0),
(0, 'La Chaux', 'France', 'Europe', 'FRBN0515', 0),
(0, 'La Chaux', 'France', 'Europe', 'FRBO0574', 0),
(0, 'La Chaux', 'France', 'Europe', 'FRFC0628', 0),
(0, 'La Chaux-du-Dombief', 'France', 'Europe', 'FRXX2908', 0),
(0, 'La Chaux-en-Bresse', 'France', 'Europe', 'FRFC0629', 0),
(0, 'La Chavanne', 'France', 'Europe', 'FRRA0748', 0),
(0, 'La Chavatte', 'France', 'Europe', 'FRPI0805', 0),
(0, 'La Chaze-de-Peyre', 'France', 'Europe', 'FRLR0308', 0),
(0, 'La Chenalotte', 'France', 'Europe', 'FRFC0630', 0),
(0, 'La Cheppe', 'France', 'Europe', 'FRCA0634', 0),
(0, 'La Chevallerais', 'France', 'Europe', 'FRPL0341', 0),
(0, 'La Chevillotte', 'France', 'Europe', 'FRFC0631', 0),
(0, 'La Chevrerie', 'France', 'Europe', 'FRPC0428', 0),
(0, 'La Chevroliere', 'France', 'Europe', 'FRXX2699', 0),
(0, 'La Cheze', 'France', 'Europe', 'FRBR0108', 0),
(0, 'La Chiappa', 'France', 'Europe', 'FRXX0178', 0),
(0, 'La Chomette', 'France', 'Europe', 'FRAU0311', 0),
(0, 'La Ciotat', 'France', 'Europe', 'FRXX4746', 0),
(0, 'La Clarte', 'France', 'Europe', 'FRBR0109', 0),
(0, 'La Claye', 'France', 'Europe', 'FRPL0342', 0),
(0, 'La Clayette', 'France', 'Europe', 'FRXX3440', 0),
(0, 'La Clisse', 'France', 'Europe', 'FRPC0429', 0),
(0, 'La Clotte', 'France', 'Europe', 'FRPC0430', 0),
(0, 'La Clusaz', 'France', 'Europe', 'FRXX0231', 0),
(0, 'La Cluse', 'France', 'Europe', 'FRPA0238', 0),
(0, 'La Cluse', 'France', 'Europe', 'FRRA0749', 0),
(0, 'La Cluse-et-Mijoux', 'France', 'Europe', 'FRFC0632', 0),
(0, 'La Cochere', 'France', 'Europe', 'FRBN0516', 0),
(0, 'La Collancelle', 'France', 'Europe', 'FRBO0575', 0),
(0, 'La Colle-sur-Loup', 'France', 'Europe', 'FRXX4682', 0),
(0, 'La Colombe', 'France', 'Europe', 'FRBN0517', 0),
(0, 'La Colombe', 'France', 'Europe', 'FRCE0459', 0),
(0, 'La Combe-de-Lancey', 'France', 'Europe', 'FRRA0750', 0),
(0, 'La Combelle', 'France', 'Europe', 'FRAU0312', 0),
(0, 'La Comelle', 'France', 'Europe', 'FRBO0576', 0),
(0, 'La Compote', 'France', 'Europe', 'FRRA0751', 0),
(0, 'La Comte', 'France', 'Europe', 'FRNC0497', 0),
(0, 'La Copechagniere', 'France', 'Europe', 'FRPL0343', 0),
(0, 'La Coquille', 'France', 'Europe', 'FRAQ0619', 0),
(0, 'La Corbiere', 'France', 'Europe', 'FRFC0633', 0),
(0, 'La Cornuaille', 'France', 'Europe', 'FRPL0344', 0),
(0, 'La Cote', 'France', 'Europe', 'FRFC0634', 0),
(0, 'La Cote-d`Aime', 'France', 'Europe', 'FRRA0752', 0),
(0, 'La Cote-d`Arbroz', 'France', 'Europe', 'FRRA0753', 0),
(0, 'La Cote-en-Couzan', 'France', 'Europe', 'FRRA0754', 0),
(0, 'La Cote-Saint-Andre', 'France', 'Europe', 'FRXX0412', 0),
(0, 'La Cotiniere', 'France', 'Europe', 'FRPC0431', 0),
(0, 'La Couarde', 'France', 'Europe', 'FRPC0432', 0),
(0, 'La Couarde-sur-Mer', 'France', 'Europe', 'FRXX3981', 0),
(0, 'La Coucourde', 'France', 'Europe', 'FRRA0755', 0),
(0, 'La Coudre', 'France', 'Europe', 'FRXX0179', 0),
(0, 'La Coulonche', 'France', 'Europe', 'FRBN0518', 0),
(0, 'La Cour-Marigny', 'France', 'Europe', 'FRCE0460', 0),
(0, 'La Courbe', 'France', 'Europe', 'FRBN0519', 0),
(0, 'La Courneuve', 'France', 'Europe', 'FRXX5264', 0),
(0, 'La Couronne', 'France', 'Europe', 'FRXX3975', 0),
(0, 'La Courtete', 'France', 'Europe', 'FRLR0309', 0),
(0, 'La Courtine', 'France', 'Europe', 'FRLI0181', 0),
(0, 'La Couture', 'France', 'Europe', 'FRNC0498', 0),
(0, 'La Couture', 'France', 'Europe', 'FRPL0345', 0),
(0, 'La Couture-Boussey', 'France', 'Europe', 'FRXX6239', 0),
(0, 'La Couvertoirade', 'France', 'Europe', 'FRMP0959', 0),
(0, 'La Couyere', 'France', 'Europe', 'FRBR0110', 0),
(0, 'La Crau', 'France', 'Europe', 'FRXX5003', 0),
(0, 'La Cressonniere', 'France', 'Europe', 'FRBN0520', 0),
(0, 'La Creuse', 'France', 'Europe', 'FRFC0635', 0),
(0, 'La Crique', 'France', 'Europe', 'FRHN0391', 0),
(0, 'La Croisille', 'France', 'Europe', 'FRHN0392', 0),
(0, 'La Croisille-sur-Briance', 'France', 'Europe', 'FRLI0182', 0),
(0, 'Marcenod', 'France', 'Europe', 'FRRA1036', 0),
(0, 'Marcey-les-Greves', 'France', 'Europe', 'FRBN0804', 0),
(0, 'Marchainville', 'France', 'Europe', 'FRBN0805', 0),
(0, 'Marchais', 'France', 'Europe', 'FRPI1013', 0),
(0, 'Marchais-Beton', 'France', 'Europe', 'FRBO0722', 0),
(0, 'Marchais-en-Brie', 'France', 'Europe', 'FRXX6113', 0),
(0, 'Marchal', 'France', 'Europe', 'FRAU0448', 0),
(0, 'Marchamp', 'France', 'Europe', 'FRRA1037', 0),
(0, 'Marchampt', 'France', 'Europe', 'FRRA1038', 0),
(0, 'Marchastel', 'France', 'Europe', 'FRAU0449', 0),
(0, 'Marchastel', 'France', 'Europe', 'FRLR0444', 0),
(0, 'Marchaux', 'France', 'Europe', 'FRFC0827', 0),
(0, 'Marche-Allouarde', 'France', 'Europe', 'FRPI1014', 0),
(0, 'Marchelepot', 'France', 'Europe', 'FRPI1015', 0),
(0, 'Marchemaisons', 'France', 'Europe', 'FRBN0806', 0),
(0, 'Marchemoret', 'France', 'Europe', 'FRIF0362', 0),
(0, 'Marchenoir', 'France', 'Europe', 'FRCE0634', 0),
(0, 'Marcheprime', 'France', 'Europe', 'FRAQ0868', 0),
(0, 'Marches', 'France', 'Europe', 'FRRA1039', 0),
(0, 'Marcheseuil', 'France', 'Europe', 'FRBO0723', 0),
(0, 'Marchesieux', 'France', 'Europe', 'FRBN0807', 0),
(0, 'Marcheville', 'France', 'Europe', 'FRCE0635', 0),
(0, 'Marcheville', 'France', 'Europe', 'FRPI1016', 0),
(0, 'Marcheville-en-Woevre', 'France', 'Europe', 'FRLO1002', 0),
(0, 'Marchezais', 'France', 'Europe', 'FRCE0636', 0),
(0, 'Marchiennes', 'France', 'Europe', 'FRXX1471', 0),
(0, 'Marciac', 'France', 'Europe', 'FRMP1342', 0),
(0, 'Marcieu', 'France', 'Europe', 'FRRA1040', 0),
(0, 'Marcieux', 'France', 'Europe', 'FRRA1041', 0),
(0, 'Marcigny', 'France', 'Europe', 'FRXX1279', 0),
(0, 'Marcigny-sous-Thil', 'France', 'Europe', 'FRBO0724', 0),
(0, 'Marcilhac-sur-Cele', 'France', 'Europe', 'FRXX1260', 0),
(0, 'Marcillac', 'France', 'Europe', 'FRXX5771', 0),
(0, 'Marcillac-la-Croisille', 'France', 'Europe', 'FRXX4764', 0),
(0, 'Marcillac-la-Croze', 'France', 'Europe', 'FRLI0270', 0),
(0, 'Marcillac-Lanville', 'France', 'Europe', 'FRXX4759', 0),
(0, 'Marcillac-Saint-Quentin', 'France', 'Europe', 'FRAQ0869', 0),
(0, 'Marcillac-Vallon', 'France', 'Europe', 'FRMP1343', 0),
(0, 'Marcillat', 'France', 'Europe', 'FRAU0450', 0),
(0, 'Marcillat-en-Combraille', 'France', 'Europe', 'FRXX3164', 0),
(0, 'Marcille-la-Ville', 'France', 'Europe', 'FRXX4636', 0),
(0, 'Marcille-Raoul', 'France', 'Europe', 'FRXX6473', 0),
(0, 'Marcille-Robert', 'France', 'Europe', 'FRBR0296', 0),
(0, 'Marcilloles', 'France', 'Europe', 'FRRA1042', 0),
(0, 'Marcilly', 'France', 'Europe', 'FRBN0808', 0),
(0, 'Marcilly', 'France', 'Europe', 'FRIF0363', 0),
(0, 'Marcilly-d`Azergues', 'France', 'Europe', 'FRRA1043', 0),
(0, 'Marcilly-en-Bassigny', 'France', 'Europe', 'FRXX3834', 0),
(0, 'Marcilly-en-Beauce', 'France', 'Europe', 'FRCE0637', 0),
(0, 'Marcilly-en-Gault', 'France', 'Europe', 'FRCE0638', 0),
(0, 'Marcilly-en-Villette', 'France', 'Europe', 'FRCE0639', 0),
(0, 'Marcilly-et-Dracy', 'France', 'Europe', 'FRBO0726', 0),
(0, 'Marcilly-la-Campagne', 'France', 'Europe', 'FRHN0550', 0),
(0, 'Marcilly-la-Gueurce', 'France', 'Europe', 'FRBO0727', 0),
(0, 'Marcilly-le-Chatel', 'France', 'Europe', 'FRRA1044', 0),
(0, 'Marcilly-le-Hayer', 'France', 'Europe', 'FRXX6262', 0),
(0, 'Marcilly-les-Buxy', 'France', 'Europe', 'FRBO0728', 0),
(0, 'Marcilly-Ogny', 'France', 'Europe', 'FRBO0725', 0),
(0, 'Marcilly-sur-Eure', 'France', 'Europe', 'FRXX2505', 0),
(0, 'Marcilly-sur-Maulne', 'France', 'Europe', 'FRCE0640', 0),
(0, 'Marcilly-sur-Seine', 'France', 'Europe', 'FRCA0849', 0),
(0, 'Marcilly-sur-Tille', 'France', 'Europe', 'FRBO0729', 0),
(0, 'Marcilly-sur-Vienne', 'France', 'Europe', 'FRCE0641', 0),
(0, 'Marck', 'France', 'Europe', 'FRXX6355', 0),
(0, 'Marckolsheim', 'France', 'Europe', 'FRXX5114', 0),
(0, 'Marclopt', 'France', 'Europe', 'FRRA1045', 0),
(0, 'Marcoing', 'France', 'Europe', 'FRNC0593', 0),
(0, 'Marcoles', 'France', 'Europe', 'FRAU0451', 0),
(0, 'Marcollin', 'France', 'Europe', 'FRRA1046', 0),
(0, 'Marcols-les-Eaux', 'France', 'Europe', 'FRRA1047', 0),
(0, 'Marcon', 'France', 'Europe', 'FRPL0538', 0),
(0, 'Marconne', 'France', 'Europe', 'FRNC0594', 0),
(0, 'Marconnelle', 'France', 'Europe', 'FRNC0595', 0),
(0, 'Marcorignan', 'France', 'Europe', 'FRLR0445', 0),
(0, 'Marcoussis', 'France', 'Europe', 'FRXX4613', 0),
(0, 'Marcoux', 'France', 'Europe', 'FRRA1048', 0),
(0, 'Marcoux', 'France', 'Europe', 'FRXX5389', 0),
(0, 'Marcq', 'France', 'Europe', 'FRCA0850', 0),
(0, 'Marcq', 'France', 'Europe', 'FRIF0364', 0),
(0, 'Marcq-en-Baroeul', 'France', 'Europe', 'FRXX5065', 0),
(0, 'Noailles', 'France', 'Europe', 'FRMP1632', 0),
(0, 'Noailles', 'France', 'Europe', 'FRXX6445', 0),
(0, 'Noailly', 'France', 'Europe', 'FRRA1250', 0),
(0, 'Noalhac', 'France', 'Europe', 'FRLR0557', 0),
(0, 'Noalhat', 'France', 'Europe', 'FRAU0539', 0),
(0, 'Noards', 'France', 'Europe', 'FRHN0621', 0),
(0, 'Nocario', 'France', 'Europe', 'FRCO0116', 0),
(0, 'Noce', 'France', 'Europe', 'FRBN0928', 0),
(0, 'Noceta', 'France', 'Europe', 'FRXX3171', 0),
(0, 'Nochize', 'France', 'Europe', 'FRBO0892', 0),
(0, 'Nod-sur-Seine', 'France', 'Europe', 'FRBO0893', 0),
(0, 'Nods', 'France', 'Europe', 'FRFC0979', 0),
(0, 'Noe', 'France', 'Europe', 'FRBO0894', 0),
(0, 'Noe', 'France', 'Europe', 'FRMP1633', 0),
(0, 'Noe-les-Mallets', 'France', 'Europe', 'FRXX4814', 0),
(0, 'Noel-Cerneux', 'France', 'Europe', 'FRFC0980', 0),
(0, 'Noellet', 'France', 'Europe', 'FRPL0636', 0),
(0, 'Noeux-les-Auxi', 'France', 'Europe', 'FRNC0668', 0),
(0, 'Noeux-les-Mines', 'France', 'Europe', 'FRXX3527', 0),
(0, 'Nogaret', 'France', 'Europe', 'FRMP1634', 0),
(0, 'Nogaro', 'France', 'Europe', 'FRMP1635', 0),
(0, 'Nogent', 'France', 'Europe', 'FRCA1000', 0),
(0, 'Nogent-en-Othe', 'France', 'Europe', 'FRCA1001', 0),
(0, 'Nogent-l`Abbesse', 'France', 'Europe', 'FRCA1002', 0),
(0, 'Nogent-l`Artaud', 'France', 'Europe', 'FRPI1206', 0),
(0, 'Nogent-le-Bernard', 'France', 'Europe', 'FRXX2991', 0),
(0, 'Nogent-le-Phaye', 'France', 'Europe', 'FRXX6339', 0),
(0, 'Nogent-le-Roi', 'France', 'Europe', 'FRXX2566', 0),
(0, 'Nogent-le-Rotrou', 'France', 'Europe', 'FRXX4136', 0),
(0, 'Nogent-le-Sec', 'France', 'Europe', 'FRXX4769', 0),
(0, 'Nogent-les-Montbard', 'France', 'Europe', 'FRBO0895', 0),
(0, 'Nogent-sur-Aube', 'France', 'Europe', 'FRXX4059', 0),
(0, 'Nogent-sur-Eure', 'France', 'Europe', 'FRCE0797', 0),
(0, 'Nogent-sur-Loir', 'France', 'Europe', 'FRPL0637', 0),
(0, 'Nogent-sur-Marne', 'France', 'Europe', 'FRXX3051', 0),
(0, 'Nogent-sur-Oise', 'France', 'Europe', 'FRXX2752', 0),
(0, 'Nogent-sur-Seine', 'France', 'Europe', 'FRXX4061', 0),
(0, 'Nogent-sur-Vernisson', 'France', 'Europe', 'FRXX4164', 0),
(0, 'Nogentel', 'France', 'Europe', 'FRPI1207', 0),
(0, 'Nogna', 'France', 'Europe', 'FRFC0981', 0),
(0, 'Nogueres', 'France', 'Europe', 'FRAQ1053', 0),
(0, 'Nohanent', 'France', 'Europe', 'FRXX5683', 0),
(0, 'Nohant-en-Gout', 'France', 'Europe', 'FRCE0799', 0),
(0, 'Nohant-en-Gracay', 'France', 'Europe', 'FRCE0800', 0),
(0, 'Nohant-Vic', 'France', 'Europe', 'FRCE0798', 0),
(0, 'Nohedes', 'France', 'Europe', 'FRLR0558', 0),
(0, 'Nohic', 'France', 'Europe', 'FRMP1636', 0),
(0, 'Noidan', 'France', 'Europe', 'FRBO0896', 0),
(0, 'Noidans-le-Ferroux', 'France', 'Europe', 'FRFC0982', 0),
(0, 'Noidans-les-Vesoul', 'France', 'Europe', 'FRFC0983', 0),
(0, 'Noidant-Chatenoy', 'France', 'Europe', 'FRCA1003', 0),
(0, 'Noidant-le-Rocheux', 'France', 'Europe', 'FRCA1004', 0),
(0, 'Noilhan', 'France', 'Europe', 'FRMP1637', 0),
(0, 'Nointel', 'France', 'Europe', 'FRIF0436', 0),
(0, 'Nointel', 'France', 'Europe', 'FRPI1208', 0),
(0, 'Nointot', 'France', 'Europe', 'FRHN0622', 0),
(0, 'Noircourt', 'France', 'Europe', 'FRPI1209', 0),
(0, 'Noirefontaine', 'France', 'Europe', 'FRFC0984', 0),
(0, 'Noiremont', 'France', 'Europe', 'FRPI1210', 0),
(0, 'Noiretable', 'France', 'Europe', 'FRRA1251', 0),
(0, 'Noirlieu', 'France', 'Europe', 'FRCA1005', 0),
(0, 'Noirlieu', 'France', 'Europe', 'FRPC0696', 0),
(0, 'Noirmoutier-en-l`Ile', 'France', 'Europe', 'FRXX1612', 0),
(0, 'Noiron', 'France', 'Europe', 'FRFC0985', 0),
(0, 'Noiron-sous-Gevrey', 'France', 'Europe', 'FRBO0897', 0),
(0, 'Noiron-sur-Beze', 'France', 'Europe', 'FRBO0898', 0),
(0, 'Noiron-sur-Seine', 'France', 'Europe', 'FRBO0899', 0),
(0, 'Noironte', 'France', 'Europe', 'FRFC0986', 0),
(0, 'Noirpalu', 'France', 'Europe', 'FRBN0929', 0),
(0, 'Noirterre', 'France', 'Europe', 'FRPC0697', 0),
(0, 'Noirval', 'France', 'Europe', 'FRCA1006', 0),
(0, 'Noiseau', 'France', 'Europe', 'FRXX4656', 0),
(0, 'Noisiel', 'France', 'Europe', 'FRXX3355', 0),
(0, 'Noisseville', 'France', 'Europe', 'FRLO1170', 0),
(0, 'Noisy-le-Grand', 'France', 'Europe', 'FRXX5975', 0),
(0, 'Noisy-le-Roi', 'France', 'Europe', 'FRXX5843', 0),
(0, 'Noisy-le-Sec', 'France', 'Europe', 'FRXX2981', 0),
(0, 'Noisy-Rudignon', 'France', 'Europe', 'FRXX4305', 0),
(0, 'Noisy-sur-Ecole', 'France', 'Europe', 'FRXX5899', 0),
(0, 'Noisy-sur-Oise', 'France', 'Europe', 'FRIF0437', 0),
(0, 'Ouilly-le-Vicomte', 'France', 'Europe', 'FRBN0965', 0),
(0, 'Ouistreham', 'France', 'Europe', 'FRXX3910', 0),
(0, 'Oulches', 'France', 'Europe', 'FRCE0840', 0),
(0, 'Oulches-la-Vallee-Foulon', 'France', 'Europe', 'FRPI1254', 0),
(0, 'Oulchy-la-Ville', 'France', 'Europe', 'FRPI1255', 0),
(0, 'Oulchy-le-Chateau', 'France', 'Europe', 'FRXX4096', 0),
(0, 'Oulins', 'France', 'Europe', 'FRCE0841', 0),
(0, 'Oulles', 'France', 'Europe', 'FRRA1285', 0),
(0, 'Oullins', 'France', 'Europe', 'FRXX1973', 0),
(0, 'Oulmes', 'France', 'Europe', 'FRPL0655', 0),
(0, 'Oulon', 'France', 'Europe', 'FRBO0924', 0),
(0, 'Ounans', 'France', 'Europe', 'FRFC1016', 0),
(0, 'Oupia', 'France', 'Europe', 'FRLR0571', 0),
(0, 'Our', 'France', 'Europe', 'FRFC1017', 0),
(0, 'Ourches', 'France', 'Europe', 'FRRA1286', 0),
(0, 'Ourches-sur-Meuse', 'France', 'Europe', 'FRLO1219', 0),
(0, 'Ourde', 'France', 'Europe', 'FRMP1672', 0),
(0, 'Ourdis-Cotdoussan', 'France', 'Europe', 'FRMP1673', 0),
(0, 'Ourdon', 'France', 'Europe', 'FRMP1674', 0),
(0, 'Ourouer', 'France', 'Europe', 'FRBO0925', 0),
(0, 'Ourouer-les-Bourdelins', 'France', 'Europe', 'FRXX4787', 0),
(0, 'Ouroux', 'France', 'Europe', 'FRRA1287', 0),
(0, 'Ouroux-en-Morvan', 'France', 'Europe', 'FRBO0926', 0),
(0, 'Ouroux-sous-le-Bois-Sainte-Marie', 'France', 'Europe', 'FRBO0927', 0),
(0, 'Ouroux-sur-Saone', 'France', 'Europe', 'FRXX2640', 0),
(0, 'Oursbelille', 'France', 'Europe', 'FRXX5684', 0),
(0, 'Oursel-Maison', 'France', 'Europe', 'FRPI1256', 0),
(0, 'Ourton', 'France', 'Europe', 'FRXX2705', 0),
(0, 'Ourville-en-Caux', 'France', 'Europe', 'FRHN0647', 0),
(0, 'Ousse', 'France', 'Europe', 'FRAQ1085', 0),
(0, 'Ousse-Suzan', 'France', 'Europe', 'FRAQ1086', 0),
(0, 'Oussieres', 'France', 'Europe', 'FRFC1018', 0),
(0, 'Ousson-sur-Loire', 'France', 'Europe', 'FRXX4537', 0),
(0, 'Oussoy-en-Gatinais', 'France', 'Europe', 'FRCE0842', 0),
(0, 'Oust', 'France', 'Europe', 'FRMP1675', 0),
(0, 'Oust-Marest', 'France', 'Europe', 'FRPI1257', 0),
(0, 'Ouste', 'France', 'Europe', 'FRMP1676', 0),
(0, 'Outarville', 'France', 'Europe', 'FRCE0843', 0),
(0, 'Outines', 'France', 'Europe', 'FRCA1046', 0),
(0, 'Outreau', 'France', 'Europe', 'FRXX3454', 0),
(0, 'Outrebois', 'France', 'Europe', 'FRPI1258', 0),
(0, 'Outremecourt', 'France', 'Europe', 'FRCA1047', 0),
(0, 'Outrepont', 'France', 'Europe', 'FRCA1048', 0),
(0, 'Outriaz', 'France', 'Europe', 'FRRA1288', 0),
(0, 'Outtersteene', 'France', 'Europe', 'FRNC0700', 0),
(0, 'Ouvans', 'France', 'Europe', 'FRFC1019', 0),
(0, 'Ouve-Wirquin', 'France', 'Europe', 'FRNC0701', 0),
(0, 'Ouvea', 'France', 'Europe', 'FRXX7936', 0),
(0, 'Ouveillan', 'France', 'Europe', 'FRLR0572', 0),
(0, 'Ouville', 'France', 'Europe', 'FRBN0966', 0),
(0, 'Ouville-l`Abbaye', 'France', 'Europe', 'FRHN0648', 0),
(0, 'Ouville-la-Bien-Tournee', 'France', 'Europe', 'FRBN0967', 0),
(0, 'Ouville-la-Riviere', 'France', 'Europe', 'FRXX2830', 0),
(0, 'Ouvrouer-les-Champs', 'France', 'Europe', 'FRCE0844', 0),
(0, 'Ouzilly', 'France', 'Europe', 'FRPC0712', 0),
(0, 'Ouzouer-des-Champs', 'France', 'Europe', 'FRCE0845', 0),
(0, 'Ouzouer-le-Doyen', 'France', 'Europe', 'FRCE0846', 0),
(0, 'Ouzouer-le-Marche', 'France', 'Europe', 'FRXX2224', 0),
(0, 'Ouzouer-sous-Bellegarde', 'France', 'Europe', 'FRCE0847', 0),
(0, 'Ouzouer-sur-Loire', 'France', 'Europe', 'FRXX3449', 0),
(0, 'Ouzouer-sur-Trezee', 'France', 'Europe', 'FRXX4258', 0),
(0, 'Ouzous', 'France', 'Europe', 'FRMP1677', 0),
(0, 'Ovanches', 'France', 'Europe', 'FRFC1020', 0),
(0, 'Ovillers-la-Boisselle', 'France', 'Europe', 'FRPI1259', 0),
(0, 'Oxelaere', 'France', 'Europe', 'FRNC0702', 0),
(0, 'Oye', 'France', 'Europe', 'FRBO0928', 0),
(0, 'Oye-et-Pallet', 'France', 'Europe', 'FRFC1021', 0),
(0, 'Oye-Plage', 'France', 'Europe', 'FRXX6412', 0),
(0, 'Oyes', 'France', 'Europe', 'FRCA1049', 0),
(0, 'Oyeu', 'France', 'Europe', 'FRRA1289', 0),
(0, 'Oyonnax', 'France', 'Europe', 'FRXX0366', 0),
(0, 'Oyre', 'France', 'Europe', 'FRPC0713', 0),
(0, 'Oyrieres', 'France', 'Europe', 'FRFC1022', 0),
(0, 'Oysonville', 'France', 'Europe', 'FRCE0848', 0),
(0, 'Oytier-Saint-Oblas', 'France', 'Europe', 'FRXX1319', 0),
(0, 'Oz', 'France', 'Europe', 'FRRA1290', 0),
(0, 'Oz-en-Oisans', 'France', 'Europe', 'FRXX0515', 0),
(0, 'Ozan', 'France', 'Europe', 'FRRA1291', 0),
(0, 'Oze', 'France', 'Europe', 'FRPA0420', 0),
(0, 'Ozenay', 'France', 'Europe', 'FRBO0929', 0),
(0, 'Pessines', 'France', 'Europe', 'FRPC0735', 0),
(0, 'Pessoulens', 'France', 'Europe', 'FRMP1714', 0),
(0, 'Petersbach', 'France', 'Europe', 'FRAL0435', 0),
(0, 'Petit-Auverne', 'France', 'Europe', 'FRPL0669', 0),
(0, 'Petit-Bersac', 'France', 'Europe', 'FRAQ1110', 0),
(0, 'Petit-Bourg', 'France', 'Europe', 'FRXX7737', 0),
(0, 'Petit-Canal', 'France', 'Europe', 'FRXX7726', 0),
(0, 'Petit-Coeur', 'France', 'Europe', 'FRRA1324', 0),
(0, 'Petit-Couronne', 'France', 'Europe', 'FRXX1234', 0),
(0, 'Petit-Croix', 'France', 'Europe', 'FRMP1715', 0),
(0, 'Petit-Failly', 'France', 'Europe', 'FRLO1236', 0),
(0, 'Petit-Fayt', 'France', 'Europe', 'FRXX2584', 0),
(0, 'Petit-Fort-Philippe', 'France', 'Europe', 'FRNC0707', 0),
(0, 'Petit-Landau', 'France', 'Europe', 'FRAL0436', 0),
(0, 'Petit-Mars', 'France', 'Europe', 'FRPL0670', 0),
(0, 'Petit-Mesnil', 'France', 'Europe', 'FRCA1077', 0),
(0, 'Petit-Noir', 'France', 'Europe', 'FRFC1045', 0),
(0, 'Petit-Palais-et-Cornemps', 'France', 'Europe', 'FRAQ1111', 0),
(0, 'Petit-Rederching', 'France', 'Europe', 'FRLO1237', 0),
(0, 'Petit-Tenquin', 'France', 'Europe', 'FRLO1238', 0),
(0, 'Petit-Verly', 'France', 'Europe', 'FRXX5397', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Petite-Chaux', 'France', 'Europe', 'FRFC1046', 0),
(0, 'Petite-Foret', 'France', 'Europe', 'FRXX3006', 0),
(0, 'Petite-Ile', 'France', 'Europe', 'FRXX7814', 0),
(0, 'Petite-Rosselle', 'France', 'Europe', 'FRXX2614', 0),
(0, 'Petitmagny', 'France', 'Europe', 'FRMP1716', 0),
(0, 'Petitmont', 'France', 'Europe', 'FRLO1239', 0),
(0, 'Petiville', 'France', 'Europe', 'FRBN0982', 0),
(0, 'Petiville', 'France', 'Europe', 'FRHN0658', 0),
(0, 'Petosse', 'France', 'Europe', 'FRPL0671', 0),
(0, 'Petreto-Bicchisano', 'France', 'Europe', 'FRXX6193', 0),
(0, 'Pettoncourt', 'France', 'Europe', 'FRLO1240', 0),
(0, 'Pettonville', 'France', 'Europe', 'FRLO1241', 0),
(0, 'Peujard', 'France', 'Europe', 'FRAQ1112', 0),
(0, 'Peumerit', 'France', 'Europe', 'FRBR0376', 0),
(0, 'Peumerit-Quintin', 'France', 'Europe', 'FRBR0377', 0),
(0, 'Peuplingues', 'France', 'Europe', 'FRNC0708', 0),
(0, 'Peuton', 'France', 'Europe', 'FRPL0672', 0),
(0, 'Peuvillers', 'France', 'Europe', 'FRLO1242', 0),
(0, 'Peux-et-Couffouleux', 'France', 'Europe', 'FRMP1717', 0),
(0, 'Pevange', 'France', 'Europe', 'FRLO1243', 0),
(0, 'Pevy', 'France', 'Europe', 'FRCA1078', 0),
(0, 'Pexiora', 'France', 'Europe', 'FRLR0595', 0),
(0, 'Pexonne', 'France', 'Europe', 'FRLO1244', 0),
(0, 'Pey', 'France', 'Europe', 'FRAQ1113', 0),
(0, 'Peymeinade', 'France', 'Europe', 'FRXX3155', 0),
(0, 'Peynier', 'France', 'Europe', 'FRPA0428', 0),
(0, 'Peypin', 'France', 'Europe', 'FRXX3993', 0),
(0, 'Peypin-d`Aigues', 'France', 'Europe', 'FRPA0429', 0),
(0, 'Peyrabout', 'France', 'Europe', 'FRLI0329', 0),
(0, 'Peyragudes', 'France', 'Europe', 'FRXX0518', 0),
(0, 'Peyrat-de-Bellac', 'France', 'Europe', 'FRXX1546', 0),
(0, 'Peyrat-la-Noniere', 'France', 'Europe', 'FRXX2598', 0),
(0, 'Peyrat-le-Chateau', 'France', 'Europe', 'FRXX2973', 0),
(0, 'Peyraube', 'France', 'Europe', 'FRMP1718', 0),
(0, 'Peyraud', 'France', 'Europe', 'FRRA1325', 0),
(0, 'Peyre', 'France', 'Europe', 'FRAQ1114', 0),
(0, 'Peyrecave', 'France', 'Europe', 'FRMP1719', 0),
(0, 'Peyrefitte-du-Razes', 'France', 'Europe', 'FRXX4825', 0),
(0, 'Peyrefitte-sur-l`Hers', 'France', 'Europe', 'FRLR0596', 0),
(0, 'Peyregoux', 'France', 'Europe', 'FRMP1720', 0),
(0, 'Peyrehorade', 'France', 'Europe', 'FRXX1646', 0),
(0, 'Peyreleau', 'France', 'Europe', 'FRMP1721', 0),
(0, 'Peyrelevade', 'France', 'Europe', 'FRLI0330', 0),
(0, 'Peyrelongue-Abos', 'France', 'Europe', 'FRAQ1115', 0),
(0, 'Peyremale', 'France', 'Europe', 'FRLR0597', 0),
(0, 'Peyrens', 'France', 'Europe', 'FRLR0598', 0),
(0, 'Peyrestortes', 'France', 'Europe', 'FRLR0599', 0),
(0, 'Peyret-Saint-Andre', 'France', 'Europe', 'FRMP1722', 0),
(0, 'Peyriac-de-Mer', 'France', 'Europe', 'FRXX1003', 0),
(0, 'Peyriac-Minervois', 'France', 'Europe', 'FRLR0600', 0),
(0, 'Peyriat', 'France', 'Europe', 'FRRA1326', 0),
(0, 'Peyriere', 'France', 'Europe', 'FRAQ1116', 0),
(0, 'Peyrieu', 'France', 'Europe', 'FRRA1327', 0),
(0, 'Peyrignac', 'France', 'Europe', 'FRAQ1117', 0),
(0, 'Peyriguere', 'France', 'Europe', 'FRMP1723', 0),
(0, 'Peyrilhac', 'France', 'Europe', 'FRLI0331', 0),
(0, 'Peyrillac-et-Millac', 'France', 'Europe', 'FRAQ1118', 0),
(0, 'Peyrilles', 'France', 'Europe', 'FRMP1724', 0),
(0, 'Peyrins', 'France', 'Europe', 'FRXX5528', 0),
(0, 'Riantec', 'France', 'Europe', 'FRXX5199', 0),
(0, 'Riaucourt', 'France', 'Europe', 'FRCA1182', 0),
(0, 'Riaville', 'France', 'Europe', 'FRLO1359', 0),
(0, 'Ribagnac', 'France', 'Europe', 'FRAQ1201', 0),
(0, 'Ribarrouy', 'France', 'Europe', 'FRAQ1202', 0),
(0, 'Ribaute', 'France', 'Europe', 'FRLR0668', 0),
(0, 'Ribaute-les-Tavernes', 'France', 'Europe', 'FRXX4819', 0),
(0, 'Ribeaucourt', 'France', 'Europe', 'FRLO1360', 0),
(0, 'Ribeaucourt', 'France', 'Europe', 'FRPI1396', 0),
(0, 'Ribeauville', 'France', 'Europe', 'FRNC0772', 0),
(0, 'Ribeauville', 'France', 'Europe', 'FRXX6610', 0),
(0, 'Ribecourt-Dreslincourt', 'France', 'Europe', 'FRPI1397', 0),
(0, 'Ribecourt-la-Tour', 'France', 'Europe', 'FRNC0773', 0),
(0, 'Ribemont', 'France', 'Europe', 'FRPI1398', 0),
(0, 'Ribemont-sur-Ancre', 'France', 'Europe', 'FRXX5953', 0),
(0, 'Ribennes', 'France', 'Europe', 'FRLR0669', 0),
(0, 'Riberac', 'France', 'Europe', 'FRAQ1203', 0),
(0, 'Ribes', 'France', 'Europe', 'FRRA1437', 0),
(0, 'Ribeyret', 'France', 'Europe', 'FRPA0479', 0),
(0, 'Ribiers', 'France', 'Europe', 'FRPA0480', 0),
(0, 'Riblaire', 'France', 'Europe', 'FRPC0797', 0),
(0, 'Ribouisse', 'France', 'Europe', 'FRLR0670', 0),
(0, 'Riboux', 'France', 'Europe', 'FRXX3992', 0),
(0, 'Ricarville', 'France', 'Europe', 'FRHN0701', 0),
(0, 'Ricarville-du-Val', 'France', 'Europe', 'FRHN0702', 0),
(0, 'Ricaud', 'France', 'Europe', 'FRLR0671', 0),
(0, 'Ricaud', 'France', 'Europe', 'FRMP1852', 0),
(0, 'Richardmenil', 'France', 'Europe', 'FRXX2290', 0),
(0, 'Richarville', 'France', 'Europe', 'FRIF0499', 0),
(0, 'Riche', 'France', 'Europe', 'FRLO1361', 0),
(0, 'Richebourg', 'France', 'Europe', 'FRCA1183', 0),
(0, 'Richebourg', 'France', 'Europe', 'FRIF0500', 0),
(0, 'Richebourg', 'France', 'Europe', 'FRXX2856', 0),
(0, 'Richecourt', 'France', 'Europe', 'FRLO1362', 0),
(0, 'Richelieu', 'France', 'Europe', 'FRCE0937', 0),
(0, 'Richeling', 'France', 'Europe', 'FRLO1363', 0),
(0, 'Richemont', 'France', 'Europe', 'FRHN0703', 0),
(0, 'Richemont', 'France', 'Europe', 'FRPC0798', 0),
(0, 'Richemont', 'France', 'Europe', 'FRXX1216', 0),
(0, 'Richerenches', 'France', 'Europe', 'FRXX2305', 0),
(0, 'Richet', 'France', 'Europe', 'FRAQ1204', 0),
(0, 'Richeval', 'France', 'Europe', 'FRLO1364', 0),
(0, 'Richeville', 'France', 'Europe', 'FRHN0704', 0),
(0, 'Richtolsheim', 'France', 'Europe', 'FRAL0464', 0),
(0, 'Richwiller', 'France', 'Europe', 'FRAL0465', 0),
(0, 'Ricourt', 'France', 'Europe', 'FRMP1853', 0),
(0, 'Ricquebourg', 'France', 'Europe', 'FRPI1399', 0),
(0, 'Riec-sur-Belon', 'France', 'Europe', 'FRXX4716', 0),
(0, 'Riedheim', 'France', 'Europe', 'FRAL0466', 0),
(0, 'Riedisheim', 'France', 'Europe', 'FRXX5898', 0),
(0, 'Riedseltz', 'France', 'Europe', 'FRAL0467', 0),
(0, 'Riedwihr', 'France', 'Europe', 'FRAL0468', 0),
(0, 'Riel-les-Eaux', 'France', 'Europe', 'FRBO1037', 0),
(0, 'Riencourt', 'France', 'Europe', 'FRPI1400', 0),
(0, 'Riencourt-les-Bapaume', 'France', 'Europe', 'FRNC0774', 0),
(0, 'Riencourt-les-Cagnicourt', 'France', 'Europe', 'FRNC0775', 0),
(0, 'Riervescemont', 'France', 'Europe', 'FRMP1854', 0),
(0, 'Riespach', 'France', 'Europe', 'FRAL0469', 0),
(0, 'Rieucaze', 'France', 'Europe', 'FRMP1855', 0),
(0, 'Rieucros', 'France', 'Europe', 'FRXX1155', 0),
(0, 'Rieulay', 'France', 'Europe', 'FRNC0776', 0),
(0, 'Rieumajou', 'France', 'Europe', 'FRMP1856', 0),
(0, 'Rieumes', 'France', 'Europe', 'FRMP1857', 0),
(0, 'Rieupeyroux', 'France', 'Europe', 'FRMP1858', 0),
(0, 'Rieussec', 'France', 'Europe', 'FRLR0672', 0),
(0, 'Rieutort-de-Randon', 'France', 'Europe', 'FRXX6832', 0),
(0, 'Rieux', 'France', 'Europe', 'FRCA1184', 0),
(0, 'Rieux', 'France', 'Europe', 'FRHN0705', 0),
(0, 'Rieux', 'France', 'Europe', 'FRMP1859', 0),
(0, 'Rieux', 'France', 'Europe', 'FRPI1401', 0),
(0, 'Rieux', 'France', 'Europe', 'FRXX4411', 0),
(0, 'Rieux-de-Pelleport', 'France', 'Europe', 'FRXX4502', 0),
(0, 'Rieux-en-Cambresis', 'France', 'Europe', 'FRXX5860', 0),
(0, 'Rieux-en-Val', 'France', 'Europe', 'FRLR0673', 0),
(0, 'Rieux-Minervois', 'France', 'Europe', 'FRXX5557', 0),
(0, 'Riez', 'France', 'Europe', 'FRPA0481', 0),
(0, 'Rigarda', 'France', 'Europe', 'FRLR0674', 0),
(0, 'Rigaud', 'France', 'Europe', 'FRPA0482', 0),
(0, 'Rignac', 'France', 'Europe', 'FRMP1860', 0),
(0, 'Rignac', 'France', 'Europe', 'FRMP1861', 0),
(0, 'Saint-Bardoux', 'France', 'Europe', 'FRRA1531', 0),
(0, 'Saint-Barnabe', 'France', 'Europe', 'FRBR0524', 0),
(0, 'Saint-Barthelemy', 'France', 'Europe', 'FRAQ1264', 0),
(0, 'Saint-Barthelemy', 'France', 'Europe', 'FRBN1099', 0),
(0, 'Saint-Barthelemy', 'France', 'Europe', 'FRBR0525', 0),
(0, 'Saint-Barthelemy', 'France', 'Europe', 'FRIF0521', 0),
(0, 'Saint-Barthelemy', 'France', 'Europe', 'FRRA1532', 0),
(0, 'Saint-Barthelemy', 'France', 'Europe', 'FRXX5077', 0),
(0, 'Saint-Barthelemy-d`Agenais', 'France', 'Europe', 'FRXX6088', 0),
(0, 'Saint-Barthelemy-d`Anjou', 'France', 'Europe', 'FRPL0753', 0),
(0, 'Saint-Barthelemy-de-Bellegarde', 'France', 'Europe', 'FRAQ1265', 0),
(0, 'Saint-Barthelemy-de-Bussiere', 'France', 'Europe', 'FRAQ1266', 0),
(0, 'Saint-Barthelemy-de-Sechilienne', 'France', 'Europe', 'FRRA1535', 0),
(0, 'Saint-Barthelemy-de-Vals', 'France', 'Europe', 'FRRA1536', 0),
(0, 'Saint-Barthelemy-Grozon', 'France', 'Europe', 'FRRA1533', 0),
(0, 'Saint-Barthelemy-le-Meil', 'France', 'Europe', 'FRRA1537', 0),
(0, 'Saint-Barthelemy-le-Plain', 'France', 'Europe', 'FRRA1538', 0),
(0, 'Saint-Barthelemy-Lestra', 'France', 'Europe', 'FRRA1534', 0),
(0, 'Saint-Basile', 'France', 'Europe', 'FRXX6249', 0),
(0, 'Saint-Baslemont', 'France', 'Europe', 'FRLO1417', 0),
(0, 'Saint-Baudel', 'France', 'Europe', 'FRCE0984', 0),
(0, 'Saint-Baudelle', 'France', 'Europe', 'FRPL0754', 0),
(0, 'Saint-Baudille-de-la-Tour', 'France', 'Europe', 'FRRA1539', 0),
(0, 'Saint-Baudille-et-Pipet', 'France', 'Europe', 'FRRA1540', 0),
(0, 'Saint-Bauld', 'France', 'Europe', 'FRCE0985', 0),
(0, 'Saint-Baussant', 'France', 'Europe', 'FRLO1418', 0),
(0, 'Saint-Bauzeil', 'France', 'Europe', 'FRMP1941', 0),
(0, 'Saint-Bauzely', 'France', 'Europe', 'FRPA0509', 0),
(0, 'Saint-Bauzile', 'France', 'Europe', 'FRLR0714', 0),
(0, 'Saint-Bauzile', 'France', 'Europe', 'FRRA1541', 0),
(0, 'Saint-Bauzille-de-la-Sylve', 'France', 'Europe', 'FRLR0716', 0),
(0, 'Saint-Bauzille-de-Montmel', 'France', 'Europe', 'FRLR0715', 0),
(0, 'Saint-Bauzille-de-Putois', 'France', 'Europe', 'FRXX3522', 0),
(0, 'Saint-Bazile', 'France', 'Europe', 'FRLI0375', 0),
(0, 'Saint-Bazile-de-la-Roche', 'France', 'Europe', 'FRLI0377', 0),
(0, 'Saint-Bazile-de-Meyssac', 'France', 'Europe', 'FRLI0376', 0),
(0, 'Saint-Beat', 'France', 'Europe', 'FRXX2146', 0),
(0, 'Saint-Beaulize', 'France', 'Europe', 'FRMP1942', 0),
(0, 'Saint-Beauzeil', 'France', 'Europe', 'FRMP1943', 0),
(0, 'Saint-Beauzely', 'France', 'Europe', 'FRXX5420', 0),
(0, 'Saint-Beauzile', 'France', 'Europe', 'FRMP1944', 0),
(0, 'Saint-Beauzire', 'France', 'Europe', 'FRAU0648', 0),
(0, 'Saint-Beauzire', 'France', 'Europe', 'FRAU0649', 0),
(0, 'Saint-Benezet', 'France', 'Europe', 'FRLR0717', 0),
(0, 'Saint-Benigne', 'France', 'Europe', 'FRRA1542', 0),
(0, 'Saint-Benin', 'France', 'Europe', 'FRNC0815', 0),
(0, 'Saint-Benin-d`Azy', 'France', 'Europe', 'FRBO1086', 0),
(0, 'Saint-Benin-des-Bois', 'France', 'Europe', 'FRBO1087', 0),
(0, 'Saint-Benoist-sur-Mer', 'France', 'Europe', 'FRPL0755', 0),
(0, 'Saint-Benoist-sur-Vanne', 'France', 'Europe', 'FRCA1230', 0),
(0, 'Saint-Benoit', 'France', 'Europe', 'FRLR0718', 0),
(0, 'Saint-Benoit', 'France', 'Europe', 'FRPA0510', 0),
(0, 'Saint-Benoit', 'France', 'Europe', 'FRRA1543', 0),
(0, 'Saint-Benoit', 'France', 'Europe', 'FRXX3637', 0),
(0, 'Saint-Benoit', 'France', 'Europe', 'FRXX7830', 0),
(0, 'Saint-Benoit-d`Hebertot', 'France', 'Europe', 'FRBN1100', 0),
(0, 'Saint-Benoit-de-Carmaux', 'France', 'Europe', 'FRXX5822', 0),
(0, 'Saint-Benoit-des-Ombres', 'France', 'Europe', 'FRHN0749', 0),
(0, 'Saint-Benoit-des-Ondes', 'France', 'Europe', 'FRXX6784', 0),
(0, 'Saint-Benoit-du-Sault', 'France', 'Europe', 'FRXX1329', 0),
(0, 'Saint-Benoit-en-Diois', 'France', 'Europe', 'FRRA1544', 0),
(0, 'Saint-Benoit-en-Woevre', 'France', 'Europe', 'FRLO1419', 0),
(0, 'Saint-Benoit-la-Chipotte', 'France', 'Europe', 'FRLO1420', 0),
(0, 'Saint-Benoit-la-Foret', 'France', 'Europe', 'FRXX5080', 0),
(0, 'Saint-Benoit-sur-Loire', 'France', 'Europe', 'FRXX5697', 0),
(0, 'Saint-Benoit-sur-Seine', 'France', 'Europe', 'FRXX4809', 0),
(0, 'Saint-Berain', 'France', 'Europe', 'FRXX1928', 0),
(0, 'Saint-Berain-sous-Sanvignes', 'France', 'Europe', 'FRBO1088', 0),
(0, 'Saint-Berain-sur-Dheune', 'France', 'Europe', 'FRBO1089', 0),
(0, 'Saint-Bernard', 'France', 'Europe', 'FRBO1090', 0),
(0, 'Saint-Bernard', 'France', 'Europe', 'FRLO1421', 0),
(0, 'Saint-Bernard', 'France', 'Europe', 'FRRA1545', 0),
(0, 'Saint-Bernard', 'France', 'Europe', 'FRRA1546', 0),
(0, 'Saint-Beron', 'France', 'Europe', 'FRXX2711', 0),
(0, 'Saint-Berthevin', 'France', 'Europe', 'FRXX6076', 0),
(0, 'Saint-Berthevin-la-Tanniere', 'France', 'Europe', 'FRPL0756', 0),
(0, 'Saint-Bertrand-de-Comminges', 'France', 'Europe', 'FRMP1945', 0),
(0, 'Saint-Biez-en-Belin', 'France', 'Europe', 'FRPL0757', 0),
(0, 'Saint-Bihy', 'France', 'Europe', 'FRBR0526', 0),
(0, 'Saint-Blaise', 'France', 'Europe', 'FRPA0511', 0),
(0, 'Thoirette', 'France', 'Europe', 'FRRA1980', 0),
(0, 'Thoiria', 'France', 'Europe', 'FRFC1285', 0),
(0, 'Thoiry', 'France', 'Europe', 'FRIF0598', 0),
(0, 'Thoiry', 'France', 'Europe', 'FRXX3335', 0),
(0, 'Thoissey', 'France', 'Europe', 'FRRA1981', 0),
(0, 'Thoissia', 'France', 'Europe', 'FRFC1286', 0),
(0, 'Thoisy-la-Berchere', 'France', 'Europe', 'FRBO1373', 0),
(0, 'Thoisy-le-Desert', 'France', 'Europe', 'FRBO1374', 0),
(0, 'Thoix', 'France', 'Europe', 'FRPI1617', 0),
(0, 'Thol-les-Millieres', 'France', 'Europe', 'FRCA1443', 0),
(0, 'Thollet', 'France', 'Europe', 'FRPC1090', 0),
(0, 'Thollon-les-Memises', 'France', 'Europe', 'FRRA1982', 0),
(0, 'Thomer-la-Sogne', 'France', 'Europe', 'FRXX3282', 0),
(0, 'Thomery', 'France', 'Europe', 'FRXX1923', 0),
(0, 'Thomirey', 'France', 'Europe', 'FRBO1375', 0),
(0, 'Thonac', 'France', 'Europe', 'FRAQ1676', 0),
(0, 'Thones', 'France', 'Europe', 'FRRA1983', 0),
(0, 'Thonnance-les-Joinville', 'France', 'Europe', 'FRCA1444', 0),
(0, 'Thonnance-les-Moulins', 'France', 'Europe', 'FRCA1445', 0),
(0, 'Thonne-la-Long', 'France', 'Europe', 'FRLO1592', 0),
(0, 'Thonne-le-Thil', 'France', 'Europe', 'FRLO1593', 0),
(0, 'Thonne-les-Pres', 'France', 'Europe', 'FRLO1594', 0),
(0, 'Thonnelle', 'France', 'Europe', 'FRLO1595', 0),
(0, 'Thonon-les-Bains', 'France', 'Europe', 'FRXX1376', 0),
(0, 'Thonville', 'France', 'Europe', 'FRLO1596', 0),
(0, 'Thorailles', 'France', 'Europe', 'FRCE1224', 0),
(0, 'Thoraise', 'France', 'Europe', 'FRFC1287', 0),
(0, 'Thorame-Basse', 'France', 'Europe', 'FRPA0637', 0),
(0, 'Thorame-Haute', 'France', 'Europe', 'FRPA0638', 0),
(0, 'Thoras', 'France', 'Europe', 'FRAU0857', 0),
(0, 'Thore-la-Rochette', 'France', 'Europe', 'FRCE1225', 0),
(0, 'Thoree-les-Pins', 'France', 'Europe', 'FRPL0999', 0),
(0, 'Thorenc', 'France', 'Europe', 'FRPA0639', 0),
(0, 'Thorens-Glieres', 'France', 'Europe', 'FRXX6540', 0),
(0, 'Thorey', 'France', 'Europe', 'FRBO1376', 0),
(0, 'Thorey-en-Plaine', 'France', 'Europe', 'FRBO1377', 0),
(0, 'Thorey-Lyautey', 'France', 'Europe', 'FRLO1597', 0),
(0, 'Thorey-sous-Charny', 'France', 'Europe', 'FRBO1378', 0),
(0, 'Thorey-sur-Ouche', 'France', 'Europe', 'FRBO1379', 0),
(0, 'Thorigne', 'France', 'Europe', 'FRPC1091', 0),
(0, 'Thorigne-d`Anjou', 'France', 'Europe', 'FRPL1000', 0),
(0, 'Thorigne-en-Charnie', 'France', 'Europe', 'FRPL1001', 0),
(0, 'Thorigne-Fouillard', 'France', 'Europe', 'FRXX3285', 0),
(0, 'Thorigne-sur-Due', 'France', 'Europe', 'FRXX3018', 0),
(0, 'Thorigny', 'France', 'Europe', 'FRPL1002', 0),
(0, 'Thorigny-sur-le-Mignon', 'France', 'Europe', 'FRPC1092', 0),
(0, 'Thorigny-sur-Marne', 'France', 'Europe', 'FRXX1918', 0),
(0, 'Thorigny-sur-Oreuse', 'France', 'Europe', 'FRXX4534', 0),
(0, 'Thorrenc', 'France', 'Europe', 'FRRA1984', 0),
(0, 'Thors', 'France', 'Europe', 'FRCA1446', 0),
(0, 'Thors', 'France', 'Europe', 'FRPC1093', 0),
(0, 'Thory', 'France', 'Europe', 'FRBO1380', 0),
(0, 'Thory', 'France', 'Europe', 'FRPI1618', 0),
(0, 'Thoste', 'France', 'Europe', 'FRBO1381', 0),
(0, 'Thou', 'France', 'Europe', 'FRXX1983', 0),
(0, 'Thouarce', 'France', 'Europe', 'FRPL1003', 0),
(0, 'Thouare-sur-Loire', 'France', 'Europe', 'FRXX2716', 0),
(0, 'Thouars', 'France', 'Europe', 'FRXX3806', 0),
(0, 'Thouars-sur-Arize', 'France', 'Europe', 'FRMP2326', 0),
(0, 'Thouars-sur-Garonne', 'France', 'Europe', 'FRXX4651', 0),
(0, 'Thouarsais-Bouildroux', 'France', 'Europe', 'FRXX3040', 0),
(0, 'Thourie', 'France', 'Europe', 'FRXX2572', 0),
(0, 'Thouron', 'France', 'Europe', 'FRLI0539', 0),
(0, 'Thourotte', 'France', 'Europe', 'FRPI1619', 0),
(0, 'Thoury', 'France', 'Europe', 'FRCE1226', 0),
(0, 'Thoury-Ferottes', 'France', 'Europe', 'FRXX3728', 0),
(0, 'Thoux', 'France', 'Europe', 'FRMP2327', 0),
(0, 'Thuboeuf', 'France', 'Europe', 'FRXX3843', 0),
(0, 'Thuellin', 'France', 'Europe', 'FRRA1985', 0),
(0, 'Thues-Entre-Valls', 'France', 'Europe', 'FRLR0897', 0),
(0, 'Thueyts', 'France', 'Europe', 'FRRA1986', 0),
(0, 'Thugny-Trugny', 'France', 'Europe', 'FRCA1447', 0),
(0, 'Thuilley-aux-Groseilles', 'France', 'Europe', 'FRXX3098', 0),
(0, 'Thuillieres', 'France', 'Europe', 'FRLO1598', 0),
(0, 'Thuir', 'France', 'Europe', 'FRXX3462', 0),
(0, 'Thuisy', 'France', 'Europe', 'FRCA1448', 0),
(0, 'Thuit-Hebert', 'France', 'Europe', 'FRXX4778', 0),
(0, 'Thulay', 'France', 'Europe', 'FRFC1288', 0),
(0, 'Thumereville', 'France', 'Europe', 'FRLO1599', 0),
(0, 'Thumeries', 'France', 'Europe', 'FRXX3344', 0),
(0, 'Vaux-en-Vermandois', 'France', 'Europe', 'FRPI1674', 0),
(0, 'Vaux-et-Chantegrue', 'France', 'Europe', 'FRFC1344', 0),
(0, 'Vaux-la-Douce', 'France', 'Europe', 'FRCA1522', 0),
(0, 'Vaux-la-Grande', 'France', 'Europe', 'FRLO1690', 0),
(0, 'Vaux-la-Petite', 'France', 'Europe', 'FRLO1691', 0),
(0, 'Vaux-Lavalette', 'France', 'Europe', 'FRPC1129', 0),
(0, 'Vaux-le-Moncelot', 'France', 'Europe', 'FRFC1345', 0),
(0, 'Vaux-le-Penil', 'France', 'Europe', 'FRIF0620', 0),
(0, 'Vaux-les-Mouron', 'France', 'Europe', 'FRCA1523', 0),
(0, 'Vaux-les-Mouzon', 'France', 'Europe', 'FRCA1524', 0),
(0, 'Vaux-les-Palameix', 'France', 'Europe', 'FRLO1692', 0),
(0, 'Vaux-les-Pres', 'France', 'Europe', 'FRFC1346', 0),
(0, 'Vaux-les-Rubigny', 'France', 'Europe', 'FRCA1525', 0),
(0, 'Vaux-les-Saint-Claude', 'France', 'Europe', 'FRXX2910', 0),
(0, 'Vaux-Marquenneville', 'France', 'Europe', 'FRPI1672', 0),
(0, 'Vaux-Montreuil', 'France', 'Europe', 'FRCA1519', 0),
(0, 'Vaux-Rouillac', 'France', 'Europe', 'FRPC1130', 0),
(0, 'Vaux-Saules', 'France', 'Europe', 'FRBO1452', 0),
(0, 'Vaux-sous-Aubigny', 'France', 'Europe', 'FRXX3071', 0),
(0, 'Vaux-sur-Aure', 'France', 'Europe', 'FRBN1457', 0),
(0, 'Vaux-sur-Blaise', 'France', 'Europe', 'FRCA1526', 0),
(0, 'Vaux-sur-Eure', 'France', 'Europe', 'FRHN0979', 0),
(0, 'Vaux-sur-Lunain', 'France', 'Europe', 'FRIF0621', 0),
(0, 'Vaux-sur-Mer', 'France', 'Europe', 'FRXX1796', 0),
(0, 'Vaux-sur-Poligny', 'France', 'Europe', 'FRXX1475', 0),
(0, 'Vaux-sur-Risle', 'France', 'Europe', 'FRHN0980', 0),
(0, 'Vaux-sur-Saint-Urbain', 'France', 'Europe', 'FRCA1527', 0),
(0, 'Vaux-sur-Seine', 'France', 'Europe', 'FRXX2802', 0),
(0, 'Vaux-sur-Seulles', 'France', 'Europe', 'FRBN1458', 0),
(0, 'Vaux-sur-Somme', 'France', 'Europe', 'FRXX2208', 0),
(0, 'Vaux-sur-Vienne', 'France', 'Europe', 'FRXX2865', 0),
(0, 'Vaux-Villaine', 'France', 'Europe', 'FRCA1520', 0),
(0, 'Vauxaillon', 'France', 'Europe', 'FRPI1675', 0),
(0, 'Vauxbons', 'France', 'Europe', 'FRCA1528', 0),
(0, 'Vauxbuin', 'France', 'Europe', 'FRPI1676', 0),
(0, 'Vauxcere', 'France', 'Europe', 'FRPI1677', 0),
(0, 'Vauxrenard', 'France', 'Europe', 'FRXX5155', 0),
(0, 'Vauxrezis', 'France', 'Europe', 'FRPI1678', 0),
(0, 'Vauxtin', 'France', 'Europe', 'FRPI1679', 0),
(0, 'Vavincourt', 'France', 'Europe', 'FRLO1693', 0),
(0, 'Vavray-le-Grand', 'France', 'Europe', 'FRCA1529', 0),
(0, 'Vavray-le-Petit', 'France', 'Europe', 'FRCA1530', 0),
(0, 'Vaxainville', 'France', 'Europe', 'FRLO1694', 0),
(0, 'Vaxoncourt', 'France', 'Europe', 'FRLO1695', 0),
(0, 'Vaxy', 'France', 'Europe', 'FRLO1696', 0),
(0, 'Vay', 'France', 'Europe', 'FRPL1034', 0),
(0, 'Vaychis', 'France', 'Europe', 'FRMP2412', 0),
(0, 'Vaylats', 'France', 'Europe', 'FRMP2413', 0),
(0, 'Vayrac', 'France', 'Europe', 'FRMP2414', 0),
(0, 'Vayres', 'France', 'Europe', 'FRLI0552', 0),
(0, 'Vayres', 'France', 'Europe', 'FRXX2837', 0),
(0, 'Vayres-sur-Essonne', 'France', 'Europe', 'FRXX2245', 0),
(0, 'Vazeilles-Limandre', 'France', 'Europe', 'FRAU0898', 0),
(0, 'Vazeilles-pres-Saugues', 'France', 'Europe', 'FRAU0899', 0),
(0, 'Vazerac', 'France', 'Europe', 'FRMP2415', 0),
(0, 'Veauce', 'France', 'Europe', 'FRAU0900', 0),
(0, 'Veauche', 'France', 'Europe', 'FRXX4377', 0),
(0, 'Veauchette', 'France', 'Europe', 'FRRA2057', 0),
(0, 'Veaugues', 'France', 'Europe', 'FRCE1266', 0),
(0, 'Veaunes', 'France', 'Europe', 'FRRA2058', 0),
(0, 'Veauville-les-Baons', 'France', 'Europe', 'FRHN0981', 0),
(0, 'Veauville-les-Quelles', 'France', 'Europe', 'FRHN0982', 0),
(0, 'Vebre', 'France', 'Europe', 'FRMP2416', 0),
(0, 'Vebret', 'France', 'Europe', 'FRAU0901', 0),
(0, 'Vebron', 'France', 'Europe', 'FRLR0933', 0),
(0, 'Veckersviller', 'France', 'Europe', 'FRLO1697', 0),
(0, 'Veckring', 'France', 'Europe', 'FRLO1698', 0),
(0, 'Vecoux', 'France', 'Europe', 'FRLO1699', 0),
(0, 'Vecquemont', 'France', 'Europe', 'FRPI1680', 0),
(0, 'Vecqueville', 'France', 'Europe', 'FRCA1531', 0),
(0, 'Vedene', 'France', 'Europe', 'FRXX2296', 0),
(0, 'Vedrines-Saint-Loup', 'France', 'Europe', 'FRAU0902', 0),
(0, 'Veel', 'France', 'Europe', 'FRLO1700', 0),
(0, 'Vegennes', 'France', 'Europe', 'FRLI0553', 0),
(0, 'Veho', 'France', 'Europe', 'FRLO1701', 0),
(0, 'Veigne', 'France', 'Europe', 'FRXX1465', 0),
(0, 'Veigy-Foncenex', 'France', 'Europe', 'FRXX0458', 0),
(0, 'Veilhes', 'France', 'Europe', 'FRMP2417', 0),
(0, 'Veilleins', 'France', 'Europe', 'FRCE1267', 0),
(0, 'Veilly', 'France', 'Europe', 'FRBO1454', 0),
(0, 'Antignac', 'France', 'Europe', 'FRPC0029', 0),
(0, 'Antigny', 'France', 'Europe', 'FRPC0030', 0),
(0, 'Antigny', 'France', 'Europe', 'FRPL0011', 0),
(0, 'Antilly', 'France', 'Europe', 'FRLO0037', 0),
(0, 'Antilly', 'France', 'Europe', 'FRPI0042', 0),
(0, 'Antin', 'France', 'Europe', 'FRMP0051', 0),
(0, 'Antisanti', 'France', 'Europe', 'FRCO0008', 0),
(0, 'Antist', 'France', 'Europe', 'FRMP0052', 0),
(0, 'Antogny le Tillac', 'France', 'Europe', 'FRCE0015', 0),
(0, 'Antoigne', 'France', 'Europe', 'FRPL0012', 0),
(0, 'Antoigny', 'France', 'Europe', 'FRBN0025', 0),
(0, 'Antoingt', 'France', 'Europe', 'FRAU0010', 0),
(0, 'Antonaves', 'France', 'Europe', 'FRPA0011', 0),
(0, 'Antonne-et-Trigonant', 'France', 'Europe', 'FRAQ0030', 0),
(0, 'Antony', 'France', 'Europe', 'FRXX0294', 0),
(0, 'Antorpe', 'France', 'Europe', 'FRFC0039', 0),
(0, 'Antraigues-sur-Volane', 'France', 'Europe', 'FRRA0053', 0),
(0, 'Antran', 'France', 'Europe', 'FRPC0031', 0),
(0, 'Antras', 'France', 'Europe', 'FRMP0053', 0),
(0, 'Antras', 'France', 'Europe', 'FRMP0054', 0),
(0, 'Antrenas', 'France', 'Europe', 'FRLR0022', 0),
(0, 'Antugnac', 'France', 'Europe', 'FRLR0023', 0),
(0, 'Antully', 'France', 'Europe', 'FRBO0025', 0),
(0, 'Anveville', 'France', 'Europe', 'FRHN0013', 0),
(0, 'Anville', 'France', 'Europe', 'FRPC0032', 0),
(0, 'Anvin', 'France', 'Europe', 'FRNC0027', 0),
(0, 'Anzeling', 'France', 'Europe', 'FRLO0038', 0),
(0, 'Anzex', 'France', 'Europe', 'FRAQ0031', 0),
(0, 'Anzin', 'France', 'Europe', 'FRXX1347', 0),
(0, 'Aoste', 'France', 'Europe', 'FRRA0054', 0),
(0, 'Aougny', 'France', 'Europe', 'FRCA0029', 0),
(0, 'Aouze', 'France', 'Europe', 'FRLO0039', 0),
(0, 'Apatou', 'France', 'Europe', 'FRXX7779', 0),
(0, 'Apchat', 'France', 'Europe', 'FRAU0011', 0),
(0, 'Apchon', 'France', 'Europe', 'FRAU0012', 0),
(0, 'Apinac', 'France', 'Europe', 'FRRA0055', 0),
(0, 'Appelle', 'France', 'Europe', 'FRMP0055', 0),
(0, 'Appenans', 'France', 'Europe', 'FRFC0040', 0),
(0, 'Appenwihr', 'France', 'Europe', 'FRAL0005', 0),
(0, 'Appeville', 'France', 'Europe', 'FRBN0026', 0),
(0, 'Appilly', 'France', 'Europe', 'FRPI0043', 0),
(0, 'Appoigny', 'France', 'Europe', 'FRXX6703', 0),
(0, 'Apprieu', 'France', 'Europe', 'FRRA0056', 0),
(0, 'Appy', 'France', 'Europe', 'FRMP0056', 0),
(0, 'Apremont', 'France', 'Europe', 'FRFC0041', 0),
(0, 'Apremont', 'France', 'Europe', 'FRPI0044', 0),
(0, 'Apremont', 'France', 'Europe', 'FRPL0013', 0),
(0, 'Apremont', 'France', 'Europe', 'FRRA0057', 0),
(0, 'Apremont', 'France', 'Europe', 'FRRA0058', 0),
(0, 'Apremont-sur-Allier', 'France', 'Europe', 'FRCE0016', 0),
(0, 'Aprey', 'France', 'Europe', 'FRCA0030', 0),
(0, 'Apt', 'France', 'Europe', 'FRXX0428', 0),
(0, 'Arabaux', 'France', 'Europe', 'FRMP0057', 0),
(0, 'Aragnouet', 'France', 'Europe', 'FRMP0058', 0),
(0, 'Aragon', 'France', 'Europe', 'FRLR0024', 0),
(0, 'Aramits', 'France', 'Europe', 'FRAQ0032', 0),
(0, 'Aramon', 'France', 'Europe', 'FRPA0012', 0),
(0, 'Arandas', 'France', 'Europe', 'FRRA0059', 0),
(0, 'Arandon', 'France', 'Europe', 'FRRA0060', 0),
(0, 'Araujuzon', 'France', 'Europe', 'FRAQ0033', 0),
(0, 'Araules', 'France', 'Europe', 'FRAU0013', 0),
(0, 'Araux', 'France', 'Europe', 'FRAQ0034', 0),
(0, 'Arbanats', 'France', 'Europe', 'FRAQ0035', 0),
(0, 'Arbas', 'France', 'Europe', 'FRMP0059', 0),
(0, 'Arbecey', 'France', 'Europe', 'FRFC0042', 0),
(0, 'Arbellara', 'France', 'Europe', 'FRCO0009', 0),
(0, 'Arbeost', 'France', 'Europe', 'FRXX1384', 0),
(0, 'Arbigny', 'France', 'Europe', 'FRRA0061', 0),
(0, 'Arbin', 'France', 'Europe', 'FRRA0062', 0),
(0, 'Arbis', 'France', 'Europe', 'FRAQ0036', 0),
(0, 'Arbon', 'France', 'Europe', 'FRMP0060', 0),
(0, 'Arbonne-la-Foret', 'France', 'Europe', 'FRIF0014', 0),
(0, 'Arboras', 'France', 'Europe', 'FRLR0025', 0),
(0, 'Arbori', 'France', 'Europe', 'FRCO0010', 0),
(0, 'Arbot', 'France', 'Europe', 'FRCA0031', 0),
(0, 'Arbouans', 'France', 'Europe', 'FRFC0043', 0),
(0, 'Arboucave', 'France', 'Europe', 'FRAQ0037', 0),
(0, 'Arbus', 'France', 'Europe', 'FRAQ0038', 0),
(0, 'Arbusigny', 'France', 'Europe', 'FRRA0063', 0),
(0, 'Arc-et-Senans', 'France', 'Europe', 'FRXX6174', 0),
(0, 'Behoust', 'France', 'Europe', 'FRIF0048', 0),
(0, 'Behuard', 'France', 'Europe', 'FRPL0049', 0),
(0, 'Beille', 'France', 'Europe', 'FRPL0050', 0),
(0, 'Beine', 'France', 'Europe', 'FRBO0076', 0),
(0, 'Beissat', 'France', 'Europe', 'FRLI0032', 0),
(0, 'Belarga', 'France', 'Europe', 'FRLR0069', 0),
(0, 'Belaye', 'France', 'Europe', 'FRMP0217', 0),
(0, 'Belberaud', 'France', 'Europe', 'FRMP0218', 0),
(0, 'Belbeuf', 'France', 'Europe', 'FRHN0040', 0),
(0, 'Belcaire', 'France', 'Europe', 'FRLR0070', 0),
(0, 'Belcastel', 'France', 'Europe', 'FRMP0219', 0),
(0, 'Belcastel', 'France', 'Europe', 'FRMP0220', 0),
(0, 'Belcodene', 'France', 'Europe', 'FRPA0048', 0),
(0, 'Belesta', 'France', 'Europe', 'FRMP0221', 0),
(0, 'Beleymas', 'France', 'Europe', 'FRAQ0135', 0),
(0, 'Belfahy', 'France', 'Europe', 'FRFC0108', 0),
(0, 'Belfays', 'France', 'Europe', 'FRFC0109', 0),
(0, 'Belflou', 'France', 'Europe', 'FRLR0071', 0),
(0, 'Belfort', 'France', 'Europe', 'FRXX0012', 0),
(0, 'Belgeard', 'France', 'Europe', 'FRPL0051', 0),
(0, 'Belgentier', 'France', 'Europe', 'FRPA0049', 0),
(0, 'Belgodere', 'France', 'Europe', 'FRCO0017', 0),
(0, 'Belhade', 'France', 'Europe', 'FRAQ0136', 0),
(0, 'Beliet', 'France', 'Europe', 'FRAQ0137', 0),
(0, 'Beligneux', 'France', 'Europe', 'FRRA0147', 0),
(0, 'Belin-Beliet', 'France', 'Europe', 'FRAQ0138', 0),
(0, 'Belis', 'France', 'Europe', 'FRAQ0139', 0),
(0, 'Bellaing', 'France', 'Europe', 'FRNC0096', 0),
(0, 'Bellancourt', 'France', 'Europe', 'FRPI0126', 0),
(0, 'Bellange', 'France', 'Europe', 'FRLO0124', 0),
(0, 'Bellavilliers', 'France', 'Europe', 'FRBN0074', 0),
(0, 'Belleau', 'France', 'Europe', 'FRLO0125', 0),
(0, 'Belleau', 'France', 'Europe', 'FRPI0127', 0),
(0, 'Bellebat', 'France', 'Europe', 'FRAQ0140', 0),
(0, 'Bellebrune', 'France', 'Europe', 'FRNC0097', 0),
(0, 'Bellechassagne', 'France', 'Europe', 'FRLI0033', 0),
(0, 'Bellechaume', 'France', 'Europe', 'FRBO0077', 0),
(0, 'Bellecombe', 'France', 'Europe', 'FRFC0110', 0),
(0, 'Bellefond', 'France', 'Europe', 'FRAQ0141', 0),
(0, 'Bellefond', 'France', 'Europe', 'FRBO0078', 0),
(0, 'Bellefonds', 'France', 'Europe', 'FRPC0081', 0),
(0, 'Bellefontaine', 'France', 'Europe', 'FRBN0075', 0),
(0, 'Bellefontaine', 'France', 'Europe', 'FRFC0111', 0),
(0, 'Bellefontaine', 'France', 'Europe', 'FRIF0049', 0),
(0, 'Bellefontaine', 'France', 'Europe', 'FRLO0126', 0),
(0, 'Bellefontaine', 'France', 'Europe', 'FRXX7751', 0),
(0, 'Bellefosse', 'France', 'Europe', 'FRAL0019', 0),
(0, 'Bellegarde', 'France', 'Europe', 'FRXX1771', 0),
(0, 'Bellegarde-Poussieu', 'France', 'Europe', 'FRRA0148', 0),
(0, 'Bellegarde-Sainte-Marie', 'France', 'Europe', 'FRMP0222', 0),
(0, 'Belleherbe', 'France', 'Europe', 'FRFC0112', 0),
(0, 'Bellemagny', 'France', 'Europe', 'FRAL0020', 0),
(0, 'Bellenaves', 'France', 'Europe', 'FRAU0048', 0),
(0, 'Belleneuve', 'France', 'Europe', 'FRBO0079', 0),
(0, 'Bellenglise', 'France', 'Europe', 'FRPI0128', 0),
(0, 'Bellengreville', 'France', 'Europe', 'FRBN0076', 0),
(0, 'Bellengreville', 'France', 'Europe', 'FRHN0041', 0),
(0, 'Belleray', 'France', 'Europe', 'FRLO0127', 0),
(0, 'Belleroche', 'France', 'Europe', 'FRRA0149', 0),
(0, 'Belles-Forets', 'France', 'Europe', 'FRLO0128', 0),
(0, 'Belleserre', 'France', 'Europe', 'FRMP0223', 0),
(0, 'Bellesserre', 'France', 'Europe', 'FRMP0224', 0),
(0, 'Belleu', 'France', 'Europe', 'FRPI0129', 0),
(0, 'Belleuse', 'France', 'Europe', 'FRPI0130', 0),
(0, 'Bellevaux', 'France', 'Europe', 'FRRA0150', 0),
(0, 'Belleville', 'France', 'Europe', 'FRPC0082', 0),
(0, 'Belleville', 'France', 'Europe', 'FRXX3661', 0),
(0, 'Belleville-sur-Loire', 'France', 'Europe', 'FRCE0054', 0),
(0, 'Belleville-sur-Meuse', 'France', 'Europe', 'FRXX1594', 0),
(0, 'Belley', 'France', 'Europe', 'FRCA0099', 0),
(0, 'Belley', 'France', 'Europe', 'FRXX0414', 0),
(0, 'Belleydoux', 'France', 'Europe', 'FRRA0151', 0),
(0, 'Bellicourt', 'France', 'Europe', 'FRPI0131', 0),
(0, 'Bellignies', 'France', 'Europe', 'FRNC0098', 0),
(0, 'Belloc', 'France', 'Europe', 'FRMP0225', 0),
(0, 'Bellocq', 'France', 'Europe', 'FRAQ0142', 0),
(0, 'Bellon', 'France', 'Europe', 'FRPC0083', 0),
(0, 'Bellonne', 'France', 'Europe', 'FRNC0099', 0),
(0, 'Bellot', 'France', 'Europe', 'FRIF0050', 0),
(0, 'Bellou', 'France', 'Europe', 'FRBN0077', 0),
(0, 'Cernans', 'France', 'Europe', 'FRFC0212', 0),
(0, 'Cernay', 'France', 'Europe', 'FRBN0193', 0),
(0, 'Cernay', 'France', 'Europe', 'FRCE0130', 0),
(0, 'Cernay', 'France', 'Europe', 'FRPC0159', 0),
(0, 'Cerneux', 'France', 'Europe', 'FRIF0092', 0),
(0, 'Cernex', 'France', 'Europe', 'FRRA0254', 0),
(0, 'Cerniebaud', 'France', 'Europe', 'FRFC0213', 0),
(0, 'Cernion', 'France', 'Europe', 'FRCA0198', 0),
(0, 'Cernon', 'France', 'Europe', 'FRCA0199', 0),
(0, 'Cernon', 'France', 'Europe', 'FRFC0214', 0),
(0, 'Cernoy', 'France', 'Europe', 'FRPI0302', 0),
(0, 'Cernusson', 'France', 'Europe', 'FRPL0095', 0),
(0, 'Cerny', 'France', 'Europe', 'FRIF0093', 0),
(0, 'Ceron', 'France', 'Europe', 'FRBO0167', 0),
(0, 'Cerons', 'France', 'Europe', 'FRAQ0310', 0),
(0, 'Cerqueux', 'France', 'Europe', 'FRBN0194', 0),
(0, 'Cers', 'France', 'Europe', 'FRLR0155', 0),
(0, 'Cersay', 'France', 'Europe', 'FRPC0160', 0),
(0, 'Cerseuil', 'France', 'Europe', 'FRPI0303', 0),
(0, 'Cersot', 'France', 'Europe', 'FRBO0168', 0),
(0, 'Certilleux', 'France', 'Europe', 'FRLO0243', 0),
(0, 'Certines', 'France', 'Europe', 'FRRA0255', 0),
(0, 'Cervens', 'France', 'Europe', 'FRRA0256', 0),
(0, 'Cervera de la Marenda', 'France', 'Europe', 'FRXX4313', 0),
(0, 'Cervieres', 'France', 'Europe', 'FRPA0105', 0),
(0, 'Cervon', 'France', 'Europe', 'FRBO0169', 0),
(0, 'Cesarville-Dossainville', 'France', 'Europe', 'FRCE0131', 0),
(0, 'Cescau', 'France', 'Europe', 'FRAQ0311', 0),
(0, 'Cescau', 'France', 'Europe', 'FRMP0498', 0),
(0, 'Cessac', 'France', 'Europe', 'FRAQ0312', 0),
(0, 'Cessales', 'France', 'Europe', 'FRMP0499', 0),
(0, 'Cesse', 'France', 'Europe', 'FRLO0244', 0),
(0, 'Cesseins', 'France', 'Europe', 'FRRA0257', 0),
(0, 'Cessenon-sur-Orb', 'France', 'Europe', 'FRLR0156', 0),
(0, 'Cessens', 'France', 'Europe', 'FRRA0258', 0),
(0, 'Cesseras', 'France', 'Europe', 'FRLR0157', 0),
(0, 'Cesset', 'France', 'Europe', 'FRAU0097', 0),
(0, 'Cesseville', 'France', 'Europe', 'FRHN0123', 0),
(0, 'Cessey', 'France', 'Europe', 'FRFC0215', 0),
(0, 'Cessieres', 'France', 'Europe', 'FRPI0304', 0),
(0, 'Cessieu', 'France', 'Europe', 'FRRA0259', 0),
(0, 'Cesson', 'France', 'Europe', 'FRIF0094', 0),
(0, 'Cesson-Sevigne', 'France', 'Europe', 'FRXX4600', 0),
(0, 'Cestas', 'France', 'Europe', 'FRXX6666', 0),
(0, 'Cestayrols', 'France', 'Europe', 'FRMP0500', 0),
(0, 'Ceton', 'France', 'Europe', 'FRBN0195', 0),
(0, 'Ceyras', 'France', 'Europe', 'FRLR0158', 0),
(0, 'Ceyrat', 'France', 'Europe', 'FRAU0098', 0),
(0, 'Ceyreste', 'France', 'Europe', 'FRPA0106', 0),
(0, 'Ceyroux', 'France', 'Europe', 'FRLI0060', 0),
(0, 'Ceyssat', 'France', 'Europe', 'FRAU0099', 0),
(0, 'Ceyzeriat', 'France', 'Europe', 'FRRA0260', 0),
(0, 'Ceyzerieu', 'France', 'Europe', 'FRRA0261', 0),
(0, 'Cezac', 'France', 'Europe', 'FRAQ0313', 0),
(0, 'Cezac', 'France', 'Europe', 'FRMP0501', 0),
(0, 'Cezais', 'France', 'Europe', 'FRPL0096', 0),
(0, 'Cezan', 'France', 'Europe', 'FRMP0502', 0),
(0, 'Cezay', 'France', 'Europe', 'FRRA0262', 0),
(0, 'Cezens', 'France', 'Europe', 'FRAU0100', 0),
(0, 'Cezia', 'France', 'Europe', 'FRFC0216', 0),
(0, 'Cezy', 'France', 'Europe', 'FRXX4536', 0),
(0, 'Chabanais', 'France', 'Europe', 'FRPC0161', 0),
(0, 'Chabeuil', 'France', 'Europe', 'FRRA0263', 0),
(0, 'Chabons', 'France', 'Europe', 'FRRA0264', 0),
(0, 'Chabottes', 'France', 'Europe', 'FRPA0107', 0),
(0, 'Chabournay', 'France', 'Europe', 'FRPC0162', 0),
(0, 'Chabrac', 'France', 'Europe', 'FRPC0163', 0),
(0, 'Chabreloche', 'France', 'Europe', 'FRAU0101', 0),
(0, 'Chabrieres', 'France', 'Europe', 'FRPA0108', 0),
(0, 'Chabrignac', 'France', 'Europe', 'FRLI0061', 0),
(0, 'Chabrillan', 'France', 'Europe', 'FRRA0265', 0),
(0, 'Chabris', 'France', 'Europe', 'FRCE0132', 0),
(0, 'Chace', 'France', 'Europe', 'FRPL0097', 0),
(0, 'Chacenay', 'France', 'Europe', 'FRCA0200', 0),
(0, 'Chacrise', 'France', 'Europe', 'FRPI0305', 0),
(0, 'Chadeleuf', 'France', 'Europe', 'FRAU0102', 0),
(0, 'Chadenac', 'France', 'Europe', 'FRPC0164', 0),
(0, 'Chadenet', 'France', 'Europe', 'FRLR0159', 0),
(0, 'Chadrac', 'France', 'Europe', 'FRAU0103', 0),
(0, 'Chadron', 'France', 'Europe', 'FRAU0104', 0),
(0, 'Etercy', 'France', 'Europe', 'FRRA0538', 0),
(0, 'Eternoz', 'France', 'Europe', 'FRFC0447', 0),
(0, 'Eterpigny', 'France', 'Europe', 'FRNC0329', 0),
(0, 'Eterpigny', 'France', 'Europe', 'FRPI0526', 0),
(0, 'Eterville', 'France', 'Europe', 'FRBN0343', 0),
(0, 'Etevaux', 'France', 'Europe', 'FRBO0399', 0),
(0, 'Eth', 'France', 'Europe', 'FRNC0330', 0),
(0, 'Etienville', 'France', 'Europe', 'FRBN0344', 0),
(0, 'Etigny', 'France', 'Europe', 'FRBO0400', 0),
(0, 'Etinehem', 'France', 'Europe', 'FRPI0527', 0),
(0, 'Etiolles', 'France', 'Europe', 'FRIF0185', 0),
(0, 'Etival', 'France', 'Europe', 'FRFC0448', 0),
(0, 'Etivey', 'France', 'Europe', 'FRBO0401', 0),
(0, 'Etobon', 'France', 'Europe', 'FRFC0449', 0),
(0, 'Etoges', 'France', 'Europe', 'FRCA0419', 0),
(0, 'Eton', 'France', 'Europe', 'FRLO0425', 0),
(0, 'Etormay', 'France', 'Europe', 'FRBO0402', 0),
(0, 'Etouars', 'France', 'Europe', 'FRAQ0422', 0),
(0, 'Etourvy', 'France', 'Europe', 'FRCA0420', 0),
(0, 'Etoutteville', 'France', 'Europe', 'FRHN0218', 0),
(0, 'Etouvans', 'France', 'Europe', 'FRFC0450', 0),
(0, 'Etouvelles', 'France', 'Europe', 'FRPI0528', 0),
(0, 'Etouvy', 'France', 'Europe', 'FRBN0345', 0),
(0, 'Etouy', 'France', 'Europe', 'FRPI0529', 0),
(0, 'Etrabonne', 'France', 'Europe', 'FRFC0451', 0),
(0, 'Etrappe', 'France', 'Europe', 'FRFC0452', 0),
(0, 'Etrat', 'France', 'Europe', 'FRRA0539', 0),
(0, 'Etray', 'France', 'Europe', 'FRFC0453', 0),
(0, 'Etraye', 'France', 'Europe', 'FRLO0426', 0),
(0, 'Etreaupont', 'France', 'Europe', 'FRPI0530', 0),
(0, 'Etrechet', 'France', 'Europe', 'FRCE0305', 0),
(0, 'Etrechy', 'France', 'Europe', 'FRCA0421', 0),
(0, 'Etrechy', 'France', 'Europe', 'FRCE0306', 0),
(0, 'Etreham', 'France', 'Europe', 'FRBN0346', 0),
(0, 'Etreillers', 'France', 'Europe', 'FRPI0531', 0),
(0, 'Etrejust', 'France', 'Europe', 'FRPI0532', 0),
(0, 'Etrembieres', 'France', 'Europe', 'FRRA0540', 0),
(0, 'Etrepagny', 'France', 'Europe', 'FRHN0219', 0),
(0, 'Etrepigney', 'France', 'Europe', 'FRFC0454', 0),
(0, 'Etrepigny', 'France', 'Europe', 'FRCA0422', 0),
(0, 'Etrepilly', 'France', 'Europe', 'FRIF0186', 0),
(0, 'Etrepilly', 'France', 'Europe', 'FRPI0533', 0),
(0, 'Etrepy', 'France', 'Europe', 'FRCA0423', 0),
(0, 'Etreux', 'France', 'Europe', 'FRPI0534', 0),
(0, 'Etreval', 'France', 'Europe', 'FRLO0427', 0),
(0, 'Etreville', 'France', 'Europe', 'FRHN0220', 0),
(0, 'Etrez', 'France', 'Europe', 'FRRA0541', 0),
(0, 'Etriac', 'France', 'Europe', 'FRPC0314', 0),
(0, 'Etriche', 'France', 'Europe', 'FRPL0211', 0),
(0, 'Etricourt-Manancourt', 'France', 'Europe', 'FRPI0535', 0),
(0, 'Etrigny', 'France', 'Europe', 'FRBO0403', 0),
(0, 'Etrochey', 'France', 'Europe', 'FRBO0404', 0),
(0, 'Etroeungt', 'France', 'Europe', 'FRNC0331', 0),
(0, 'Etroitefontaine', 'France', 'Europe', 'FRFC0455', 0),
(0, 'Etroussat', 'France', 'Europe', 'FRAU0236', 0),
(0, 'Etsaut', 'France', 'Europe', 'FRAQ0423', 0),
(0, 'Etting', 'France', 'Europe', 'FRLO0428', 0),
(0, 'Etueffont', 'France', 'Europe', 'FRMP0691', 0),
(0, 'Etupes', 'France', 'Europe', 'FRXX3968', 0),
(0, 'Eturqueraye', 'France', 'Europe', 'FRHN0221', 0),
(0, 'Etusson', 'France', 'Europe', 'FRPC0315', 0),
(0, 'Etuz', 'France', 'Europe', 'FRFC0456', 0),
(0, 'Etzling', 'France', 'Europe', 'FRLO0429', 0),
(0, 'Euffigneix', 'France', 'Europe', 'FRCA0424', 0),
(0, 'Eulmont', 'France', 'Europe', 'FRLO0430', 0),
(0, 'Eup', 'France', 'Europe', 'FRMP0692', 0),
(0, 'Eurre', 'France', 'Europe', 'FRRA0542', 0),
(0, 'Eus', 'France', 'Europe', 'FRLR0226', 0),
(0, 'Euvezin', 'France', 'Europe', 'FRLO0431', 0),
(0, 'Euville', 'France', 'Europe', 'FRLO0432', 0),
(0, 'Euvy', 'France', 'Europe', 'FRCA0425', 0),
(0, 'Evaille', 'France', 'Europe', 'FRPL0212', 0),
(0, 'Evans', 'France', 'Europe', 'FRFC0457', 0),
(0, 'Eve', 'France', 'Europe', 'FRPI0536', 0),
(0, 'Evecquemont', 'France', 'Europe', 'FRIF0187', 0),
(0, 'Evenos', 'France', 'Europe', 'FRPA0171', 0),
(0, 'Everly', 'France', 'Europe', 'FRXX4110', 0),
(0, 'Evette-Salbert', 'France', 'Europe', 'FRXX3757', 0),
(0, 'Eveux', 'France', 'Europe', 'FRRA0543', 0),
(0, 'Evian', 'France', 'Europe', 'FRXX0299', 0),
(0, 'Foulayronnes', 'France', 'Europe', 'FRXX3869', 0),
(0, 'Foulbec', 'France', 'Europe', 'FRHN0241', 0),
(0, 'Foulcrey', 'France', 'Europe', 'FRLO0477', 0),
(0, 'Fouleix', 'France', 'Europe', 'FRAQ0460', 0),
(0, 'Foulenay', 'France', 'Europe', 'FRFC0488', 0),
(0, 'Fouligny', 'France', 'Europe', 'FRLO0478', 0),
(0, 'Foulognes', 'France', 'Europe', 'FRBN0371', 0),
(0, 'Foulzy', 'France', 'Europe', 'FRCA0464', 0),
(0, 'Fouquebrune', 'France', 'Europe', 'FRPC0336', 0),
(0, 'Fouquenies', 'France', 'Europe', 'FRPI0591', 0),
(0, 'Fouquereuil', 'France', 'Europe', 'FRNC0364', 0),
(0, 'Fouquerolles', 'France', 'Europe', 'FRPI0592', 0),
(0, 'Fouquescourt', 'France', 'Europe', 'FRPI0593', 0),
(0, 'Fouqueure', 'France', 'Europe', 'FRPC0337', 0),
(0, 'Fouqueville', 'France', 'Europe', 'FRHN0242', 0),
(0, 'Fouquieres-les-Lens', 'France', 'Europe', 'FRXX4169', 0),
(0, 'Four', 'France', 'Europe', 'FRRA0580', 0),
(0, 'Fouras', 'France', 'Europe', 'FRPC0338', 0),
(0, 'Fourbanne', 'France', 'Europe', 'FRFC0489', 0),
(0, 'Fourcatier-et-Maison-Neuve', 'France', 'Europe', 'FRFC0490', 0),
(0, 'Fources', 'France', 'Europe', 'FRMP0739', 0),
(0, 'Fourches', 'France', 'Europe', 'FRBN0372', 0),
(0, 'Fourcigny', 'France', 'Europe', 'FRPI0594', 0),
(0, 'Fourdrain', 'France', 'Europe', 'FRPI0595', 0),
(0, 'Fourdrinoy', 'France', 'Europe', 'FRPI0596', 0),
(0, 'Fourg', 'France', 'Europe', 'FRFC0491', 0),
(0, 'Fourges', 'France', 'Europe', 'FRIF0205', 0),
(0, 'Fourilles', 'France', 'Europe', 'FRAU0244', 0),
(0, 'Fourmetot', 'France', 'Europe', 'FRHN0243', 0),
(0, 'Fourmies', 'France', 'Europe', 'FRXX5793', 0),
(0, 'Fournaudin', 'France', 'Europe', 'FRBO0438', 0),
(0, 'Fourneaux', 'France', 'Europe', 'FRBN0373', 0),
(0, 'Fourneaux', 'France', 'Europe', 'FRRA0581', 0),
(0, 'Fourneaux', 'France', 'Europe', 'FRRA0582', 0),
(0, 'Fournels', 'France', 'Europe', 'FRLR0249', 0),
(0, 'Fournes', 'France', 'Europe', 'FRPA0181', 0),
(0, 'Fournets-Luisans', 'France', 'Europe', 'FRFC0492', 0),
(0, 'Fourneville', 'France', 'Europe', 'FRBN0374', 0),
(0, 'Fournival', 'France', 'Europe', 'FRPI0597', 0),
(0, 'Fournoules', 'France', 'Europe', 'FRAU0245', 0),
(0, 'Fouronnes', 'France', 'Europe', 'FRBO0439', 0),
(0, 'Fourques', 'France', 'Europe', 'FRPA0182', 0),
(0, 'Fourqueux', 'France', 'Europe', 'FRXX3797', 0),
(0, 'Fourquevaux', 'France', 'Europe', 'FRMP0740', 0),
(0, 'Fours', 'France', 'Europe', 'FRAQ0461', 0),
(0, 'Fours', 'France', 'Europe', 'FRBO0440', 0),
(0, 'Fourtou', 'France', 'Europe', 'FRLR0250', 0),
(0, 'Foussais-Payre', 'France', 'Europe', 'FRPL0228', 0),
(0, 'Foussemagne', 'France', 'Europe', 'FRMP0741', 0),
(0, 'Foussignac', 'France', 'Europe', 'FRPC0339', 0),
(0, 'Foussignargues', 'France', 'Europe', 'FRLR0251', 0),
(0, 'Fouzilhon', 'France', 'Europe', 'FRLR0252', 0),
(0, 'Foville', 'France', 'Europe', 'FRLO0479', 0),
(0, 'Fozieres', 'France', 'Europe', 'FRLR0253', 0),
(0, 'Fozzano', 'France', 'Europe', 'FRCO0073', 0),
(0, 'Fragnes', 'France', 'Europe', 'FRBO0441', 0),
(0, 'Frahier-et-Chatebier', 'France', 'Europe', 'FRFC0493', 0),
(0, 'Fraimbois', 'France', 'Europe', 'FRLO0480', 0),
(0, 'Frain', 'France', 'Europe', 'FRLO0481', 0),
(0, 'Frais', 'France', 'Europe', 'FRMP0742', 0),
(0, 'Frais Marais', 'France', 'Europe', 'FRNC0365', 0),
(0, 'Fraisans', 'France', 'Europe', 'FRFC0494', 0),
(0, 'Fraisse', 'France', 'Europe', 'FRAQ0462', 0),
(0, 'Fraisses', 'France', 'Europe', 'FRXX6362', 0),
(0, 'Fraissines', 'France', 'Europe', 'FRMP0743', 0),
(0, 'Fralignes', 'France', 'Europe', 'FRCA0465', 0),
(0, 'Frambouhans', 'France', 'Europe', 'FRFC0495', 0),
(0, 'Framecourt', 'France', 'Europe', 'FRNC0366', 0),
(0, 'Framerville-Rainecourt', 'France', 'Europe', 'FRPI0598', 0),
(0, 'Framicourt', 'France', 'Europe', 'FRPI0599', 0),
(0, 'Framont', 'France', 'Europe', 'FRFC0496', 0),
(0, 'Frampas', 'France', 'Europe', 'FRCA0466', 0),
(0, 'Francalmont', 'France', 'Europe', 'FRFC0497', 0),
(0, 'Francardo', 'France', 'Europe', 'FRCO0074', 0),
(0, 'Francarville', 'France', 'Europe', 'FRMP0744', 0),
(0, 'Francastel', 'France', 'Europe', 'FRPI0600', 0),
(0, 'Francazal', 'France', 'Europe', 'FRMP0745', 0),
(0, 'Francescas', 'France', 'Europe', 'FRAQ0463', 0),
(0, 'Francheleins', 'France', 'Europe', 'FRRA0583', 0),
(0, 'Franchesse', 'France', 'Europe', 'FRAU0246', 0),
(0, 'Glanes', 'France', 'Europe', 'FRMP0843', 0),
(0, 'Glanges', 'France', 'Europe', 'FRLI0149', 0),
(0, 'Glannes', 'France', 'Europe', 'FRCA0508', 0),
(0, 'Glanon', 'France', 'Europe', 'FRBO0484', 0),
(0, 'Glanville', 'France', 'Europe', 'FRBN0400', 0),
(0, 'Glatens', 'France', 'Europe', 'FRMP0844', 0),
(0, 'Glatigny', 'France', 'Europe', 'FRLO0548', 0),
(0, 'Glatigny', 'France', 'Europe', 'FRPI0651', 0),
(0, 'Glay', 'France', 'Europe', 'FRFC0544', 0),
(0, 'Gleize', 'France', 'Europe', 'FRRA0611', 0),
(0, 'Glenac', 'France', 'Europe', 'FRBR0014', 0),
(0, 'Glenat', 'France', 'Europe', 'FRAU0263', 0),
(0, 'Glenay', 'France', 'Europe', 'FRPC0361', 0),
(0, 'Glenic', 'France', 'Europe', 'FRXX4873', 0),
(0, 'Glennes', 'France', 'Europe', 'FRPI0652', 0),
(0, 'Glenouze', 'France', 'Europe', 'FRPC0362', 0),
(0, 'Glere', 'France', 'Europe', 'FRFC0545', 0),
(0, 'Glicourt', 'France', 'Europe', 'FRHN0272', 0),
(0, 'Glisolles', 'France', 'Europe', 'FRHN0273', 0),
(0, 'Glisy', 'France', 'Europe', 'FRXX4481', 0),
(0, 'Glomel', 'France', 'Europe', 'FRBR0015', 0),
(0, 'Glonville', 'France', 'Europe', 'FRXX1670', 0),
(0, 'Glorianes', 'France', 'Europe', 'FRLR0274', 0),
(0, 'Glos', 'France', 'Europe', 'FRBN0401', 0),
(0, 'Glos-la-Ferriere', 'France', 'Europe', 'FRBN0402', 0),
(0, 'Glos-sur-Risle', 'France', 'Europe', 'FRHN0274', 0),
(0, 'Gluiras', 'France', 'Europe', 'FRRA0612', 0),
(0, 'Glun', 'France', 'Europe', 'FRRA0613', 0),
(0, 'Glux-en-Glenne', 'France', 'Europe', 'FRBO0485', 0),
(0, 'Goas', 'France', 'Europe', 'FRMP0845', 0),
(0, 'Godenvillers', 'France', 'Europe', 'FRPI0653', 0),
(0, 'Goderville', 'France', 'Europe', 'FRXX1352', 0),
(0, 'Godewaersvelde', 'France', 'Europe', 'FRNC0387', 0),
(0, 'Godisson', 'France', 'Europe', 'FRBN0403', 0),
(0, 'Godoncourt', 'France', 'Europe', 'FRLO0549', 0),
(0, 'Goerlingen', 'France', 'Europe', 'FRAL0158', 0),
(0, 'Goersdorf', 'France', 'Europe', 'FRAL0159', 0),
(0, 'Goes', 'France', 'Europe', 'FRAQ0517', 0),
(0, 'Goetzenbruck', 'France', 'Europe', 'FRXX2635', 0),
(0, 'Goeulzin', 'France', 'Europe', 'FRXX2949', 0),
(0, 'Gogney', 'France', 'Europe', 'FRLO0550', 0),
(0, 'Gognies-Chaussee', 'France', 'Europe', 'FRNC0388', 0),
(0, 'Gohory', 'France', 'Europe', 'FRXX6292', 0),
(0, 'Goin', 'France', 'Europe', 'FRLO0551', 0),
(0, 'Goincourt', 'France', 'Europe', 'FRPI0654', 0),
(0, 'Golancourt', 'France', 'Europe', 'FRPI0655', 0),
(0, 'Golbey', 'France', 'Europe', 'FRXX4524', 0),
(0, 'Goldbach-Altenbach', 'France', 'Europe', 'FRAL0160', 0),
(0, 'Golfe-Juan', 'France', 'Europe', 'FRPA0201', 0),
(0, 'Golfech', 'France', 'Europe', 'FRMP0846', 0),
(0, 'Golinhac', 'France', 'Europe', 'FRXX6167', 0),
(0, 'Golleville', 'France', 'Europe', 'FRBN0404', 0),
(0, 'Gombergean', 'France', 'Europe', 'FRCE0366', 0),
(0, 'Gomelange', 'France', 'Europe', 'FRLO0552', 0),
(0, 'Gomene', 'France', 'Europe', 'FRBR0016', 0),
(0, 'Gomer', 'France', 'Europe', 'FRAQ0518', 0),
(0, 'Gometz-la-Ville', 'France', 'Europe', 'FRIF0225', 0),
(0, 'Gometz-le-Chatel', 'France', 'Europe', 'FRXX6658', 0),
(0, 'Gomiecourt', 'France', 'Europe', 'FRNC0389', 0),
(0, 'Gommecourt', 'France', 'Europe', 'FRIF0226', 0),
(0, 'Gommecourt', 'France', 'Europe', 'FRNC0390', 0),
(0, 'Gommegnies', 'France', 'Europe', 'FRNC0391', 0),
(0, 'Gommenec`h', 'France', 'Europe', 'FRBR0017', 0),
(0, 'Gommersdorf', 'France', 'Europe', 'FRAL0161', 0),
(0, 'Gommerville', 'France', 'Europe', 'FRCE0367', 0),
(0, 'Gommerville', 'France', 'Europe', 'FRHN0275', 0),
(0, 'Gommeville', 'France', 'Europe', 'FRBO0486', 0),
(0, 'Gomont', 'France', 'Europe', 'FRCA0509', 0),
(0, 'Gonaincourt', 'France', 'Europe', 'FRCA0510', 0),
(0, 'Gonas', 'France', 'Europe', 'FRRA0614', 0),
(0, 'Goncelin', 'France', 'Europe', 'FRRA0615', 0),
(0, 'Goncourt', 'France', 'Europe', 'FRCA0511', 0),
(0, 'Gond-Pontouvre', 'France', 'Europe', 'FRXX3241', 0),
(0, 'Gondecourt', 'France', 'Europe', 'FRXX5785', 0),
(0, 'Gondenans-les-Moulins', 'France', 'Europe', 'FRFC0547', 0),
(0, 'Gondenans-Montby', 'France', 'Europe', 'FRFC0546', 0),
(0, 'Gondeville', 'France', 'Europe', 'FRPC0363', 0),
(0, 'Gondrecourt-Aix', 'France', 'Europe', 'FRLO0553', 0),
(0, 'Gondrecourt-le-Chateau', 'France', 'Europe', 'FRXX1593', 0),
(0, 'Gondreville', 'France', 'Europe', 'FRCE0368', 0),
(0, 'Holtzheim', 'France', 'Europe', 'FRXX4435', 0),
(0, 'Holtzwihr', 'France', 'Europe', 'FRAL0230', 0),
(0, 'Holving', 'France', 'Europe', 'FRXX2654', 0),
(0, 'Hombleux', 'France', 'Europe', 'FRPI0768', 0),
(0, 'Homblieres', 'France', 'Europe', 'FRPI0769', 0),
(0, 'Hombourg', 'France', 'Europe', 'FRAL0231', 0),
(0, 'Hombourg-Budange', 'France', 'Europe', 'FRLO0690', 0),
(0, 'Hombourg-Haut', 'France', 'Europe', 'FRXX4185', 0),
(0, 'Homecourt', 'France', 'Europe', 'FRXX5362', 0),
(0, 'Hommarting', 'France', 'Europe', 'FRLO0691', 0),
(0, 'Hommert', 'France', 'Europe', 'FRLO0692', 0),
(0, 'Hommes', 'France', 'Europe', 'FRCE0392', 0),
(0, 'Homps', 'France', 'Europe', 'FRLR0287', 0),
(0, 'Homps', 'France', 'Europe', 'FRMP0902', 0),
(0, 'Hon-Hergies', 'France', 'Europe', 'FRNC0464', 0),
(0, 'Hondainville', 'France', 'Europe', 'FRXX2021', 0),
(0, 'Hondeghem', 'France', 'Europe', 'FRNC0465', 0),
(0, 'Hondevilliers', 'France', 'Europe', 'FRIF0257', 0),
(0, 'Hondouville', 'France', 'Europe', 'FRHN0351', 0),
(0, 'Hondschoote', 'France', 'Europe', 'FRNC0466', 0),
(0, 'Honfleur', 'France', 'Europe', 'FRXX2435', 0),
(0, 'Honguemare-Guenouville', 'France', 'Europe', 'FRHN0352', 0),
(0, 'Honnechy', 'France', 'Europe', 'FRNC0467', 0),
(0, 'Honnecourt-sur-Escaut', 'France', 'Europe', 'FRXX1436', 0),
(0, 'Honskirch', 'France', 'Europe', 'FRXX5136', 0),
(0, 'Hontanx', 'France', 'Europe', 'FRAQ0568', 0),
(0, 'Hopital-Camfrout', 'France', 'Europe', 'FRXX3944', 0),
(0, 'Horbourg-Wihr', 'France', 'Europe', 'FRAL0232', 0),
(0, 'Hordain', 'France', 'Europe', 'FRNC0468', 0),
(0, 'Horgues', 'France', 'Europe', 'FRMP0903', 0),
(0, 'Hornaing', 'France', 'Europe', 'FRXX5946', 0),
(0, 'Hornoy-le-Bourg', 'France', 'Europe', 'FRPI0770', 0),
(0, 'Horsarrieu', 'France', 'Europe', 'FRAQ0569', 0),
(0, 'Horville-en-Ornois', 'France', 'Europe', 'FRLO0693', 0),
(0, 'Hossegor', 'France', 'Europe', 'FRAQ0570', 0),
(0, 'Hosta', 'France', 'Europe', 'FRAQ0571', 0),
(0, 'Hoste', 'France', 'Europe', 'FRLO0694', 0),
(0, 'Hostens', 'France', 'Europe', 'FRAQ0572', 0),
(0, 'Hostias', 'France', 'Europe', 'FRRA0657', 0),
(0, 'Hostun', 'France', 'Europe', 'FRRA0658', 0),
(0, 'Hotonnes', 'France', 'Europe', 'FRRA0659', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Hotot-en-Auge', 'France', 'Europe', 'FRBN0458', 0),
(0, 'Hottot-les-Bagues', 'France', 'Europe', 'FRBN0459', 0),
(0, 'Hottviller', 'France', 'Europe', 'FRLO0695', 0),
(0, 'Houailou', 'France', 'Europe', 'FRXX7937', 0),
(0, 'Houchin', 'France', 'Europe', 'FRNC0469', 0),
(0, 'Houdain', 'France', 'Europe', 'FRNC0470', 0),
(0, 'Houdain-lez-Bavay', 'France', 'Europe', 'FRXX5064', 0),
(0, 'Houdan', 'France', 'Europe', 'FRXX2100', 0),
(0, 'Houdancourt', 'France', 'Europe', 'FRXX5745', 0),
(0, 'Houdelaincourt', 'France', 'Europe', 'FRLO0696', 0),
(0, 'Houdelaucourt-sur-Othain', 'France', 'Europe', 'FRLO0697', 0),
(0, 'Houdelmont', 'France', 'Europe', 'FRLO0698', 0),
(0, 'Houdemont', 'France', 'Europe', 'FRXX1671', 0),
(0, 'Houdetot', 'France', 'Europe', 'FRHN0353', 0),
(0, 'Houdilcourt', 'France', 'Europe', 'FRCA0573', 0),
(0, 'Houdreville', 'France', 'Europe', 'FRLO0699', 0),
(0, 'Houecourt', 'France', 'Europe', 'FRLO0700', 0),
(0, 'Houeilles', 'France', 'Europe', 'FRAQ0573', 0),
(0, 'Houesville', 'France', 'Europe', 'FRXX1558', 0),
(0, 'Houetteville', 'France', 'Europe', 'FRHN0354', 0),
(0, 'Houeville', 'France', 'Europe', 'FRLO0701', 0),
(0, 'Houeydets', 'France', 'Europe', 'FRMP0904', 0),
(0, 'Houilles', 'France', 'Europe', 'FRXX2083', 0),
(0, 'Houlbec-Cocherel', 'France', 'Europe', 'FRHN0355', 0),
(0, 'Houlbec-pres-le-Gros-Theil', 'France', 'Europe', 'FRHN0356', 0),
(0, 'Houldizy', 'France', 'Europe', 'FRCA0574', 0),
(0, 'Houlette', 'France', 'Europe', 'FRPC0385', 0),
(0, 'Houlgate', 'France', 'Europe', 'FRBN0460', 0),
(0, 'Houlle', 'France', 'Europe', 'FRNC0471', 0),
(0, 'Hounoux', 'France', 'Europe', 'FRLR0288', 0),
(0, 'Houplin-Ancoisne', 'France', 'Europe', 'FRXX5139', 0),
(0, 'Houplines', 'France', 'Europe', 'FRXX6463', 0),
(0, 'Houppeville', 'France', 'Europe', 'FRHN0357', 0),
(0, 'Houquetot', 'France', 'Europe', 'FRHN0358', 0),
(0, 'Houquetot', 'France', 'Europe', 'FRHN0359', 0),
(0, 'Hourc', 'France', 'Europe', 'FRMP0905', 0),
(0, 'Hourges', 'France', 'Europe', 'FRCA0575', 0),
(0, 'Hours', 'France', 'Europe', 'FRAQ0574', 0),
(0, 'Hourtin', 'France', 'Europe', 'FRAQ0575', 0),
(0, 'La Croix-aux-Bois', 'France', 'Europe', 'FRCA0635', 0),
(0, 'La Croix-aux-Mines', 'France', 'Europe', 'FRXX6699', 0),
(0, 'La Croix-Avranchin', 'France', 'Europe', 'FRBN0521', 0),
(0, 'La Croix-Blanche', 'France', 'Europe', 'FRAQ0620', 0),
(0, 'La Croix-Comtesse', 'France', 'Europe', 'FRPC0433', 0),
(0, 'La Croix-de-la-Rochette', 'France', 'Europe', 'FRRA0756', 0),
(0, 'La Croix-du-Perche', 'France', 'Europe', 'FRCE0461', 0),
(0, 'La Croix-en-Brie', 'France', 'Europe', 'FRXX4891', 0),
(0, 'La Croix-en-Champagne', 'France', 'Europe', 'FRCA0636', 0),
(0, 'La Croix-en-Touraine', 'France', 'Europe', 'FRXX1373', 0),
(0, 'La Croix-Hellean', 'France', 'Europe', 'FRBR0111', 0),
(0, 'La Croix-Rouge', 'France', 'Europe', 'FRPA0239', 0),
(0, 'La Croix-Saint-Leufroy', 'France', 'Europe', 'FRXX1104', 0),
(0, 'La Croix-sur-Gartempe', 'France', 'Europe', 'FRLI0183', 0),
(0, 'La Croix-sur-Ourcq', 'France', 'Europe', 'FRPI0806', 0),
(0, 'La Croix-sur-Roudoule', 'France', 'Europe', 'FRXX4680', 0),
(0, 'La Croix-Valmer', 'France', 'Europe', 'FRXX4271', 0),
(0, 'La Croixille', 'France', 'Europe', 'FRPL0346', 0),
(0, 'La Cropte', 'France', 'Europe', 'FRPL0347', 0),
(0, 'La Croupte', 'France', 'Europe', 'FRBN0522', 0),
(0, 'La Crouzille', 'France', 'Europe', 'FRAU0313', 0),
(0, 'La Cula', 'France', 'Europe', 'FRRA0757', 0),
(0, 'La Cure', 'France', 'Europe', 'FRFC0636', 0),
(0, 'La Dagueniere', 'France', 'Europe', 'FRPL0348', 0),
(0, 'La Defense', 'France', 'Europe', 'FRXX2247', 0),
(0, 'La Demie', 'France', 'Europe', 'FRFC0637', 0),
(0, 'La Desirade', 'France', 'Europe', 'FRXX7722', 0),
(0, 'La Destrousse', 'France', 'Europe', 'FRXX3177', 0),
(0, 'La Digne-d`Amont', 'France', 'Europe', 'FRLR0310', 0),
(0, 'La Digne-d`Aval', 'France', 'Europe', 'FRLR0311', 0),
(0, 'La Dominelais', 'France', 'Europe', 'FRBR0112', 0),
(0, 'La Doree', 'France', 'Europe', 'FRPL0349', 0),
(0, 'La Dornac', 'France', 'Europe', 'FRAQ0621', 0),
(0, 'La Douze', 'France', 'Europe', 'FRXX6337', 0),
(0, 'La Fage-Montivernoux', 'France', 'Europe', 'FRLR0312', 0),
(0, 'La Fage-Saint-Julien', 'France', 'Europe', 'FRLR0313', 0),
(0, 'La Fajolle', 'France', 'Europe', 'FRLR0314', 0),
(0, 'La Faloise', 'France', 'Europe', 'FRPI0807', 0),
(0, 'La Fare-en-Champsaur', 'France', 'Europe', 'FRPA0240', 0),
(0, 'La Fare-les-Oliviers', 'France', 'Europe', 'FRXX1079', 0),
(0, 'La Farlede', 'France', 'Europe', 'FRXX6433', 0),
(0, 'La Faurie', 'France', 'Europe', 'FRXX1015', 0),
(0, 'La Faute-sur-Mer', 'France', 'Europe', 'FRXX6036', 0),
(0, 'La Faviere', 'France', 'Europe', 'FRFC0638', 0),
(0, 'La Faye', 'France', 'Europe', 'FRPC0434', 0),
(0, 'La Fere', 'France', 'Europe', 'FRPI0808', 0),
(0, 'La Feree', 'France', 'Europe', 'FRCA0637', 0),
(0, 'La Fermete', 'France', 'Europe', 'FRBO0577', 0),
(0, 'La Ferriere', 'France', 'Europe', 'FRBR0113', 0),
(0, 'La Ferriere', 'France', 'Europe', 'FRCE0462', 0),
(0, 'La Ferriere', 'France', 'Europe', 'FRRA0758', 0),
(0, 'La Ferriere', 'France', 'Europe', 'FRXX5315', 0),
(0, 'La Ferriere-Airoux', 'France', 'Europe', 'FRPC0435', 0),
(0, 'La Ferriere-au-Doyen', 'France', 'Europe', 'FRBN0527', 0),
(0, 'La Ferriere-aux-Etangs', 'France', 'Europe', 'FRXX1445', 0),
(0, 'La Ferriere-Bechet', 'France', 'Europe', 'FRBN0523', 0),
(0, 'La Ferriere-Bochard', 'France', 'Europe', 'FRBN0524', 0),
(0, 'La Ferriere-de-Flee', 'France', 'Europe', 'FRPL0350', 0),
(0, 'La Ferriere-Duval', 'France', 'Europe', 'FRBN0525', 0),
(0, 'La Ferriere-en-Parthenay', 'France', 'Europe', 'FRXX6041', 0),
(0, 'La Ferriere-Harang', 'France', 'Europe', 'FRBN0526', 0),
(0, 'La Ferriere-sur-Risle', 'France', 'Europe', 'FRXX4029', 0),
(0, 'La Ferte', 'France', 'Europe', 'FRFC0639', 0),
(0, 'La Ferte-Alais', 'France', 'Europe', 'FRXX1639', 0),
(0, 'La Ferte-Beauharnais', 'France', 'Europe', 'FRCE0463', 0),
(0, 'La Ferte-Bernard', 'France', 'Europe', 'FRXX4191', 0),
(0, 'La Ferte-Chevresis', 'France', 'Europe', 'FRXX5596', 0),
(0, 'La Ferte-Frenel', 'France', 'Europe', 'FRXX5862', 0),
(0, 'La Ferte-Gaucher', 'France', 'Europe', 'FRXX1942', 0),
(0, 'La Ferte-Hauterive', 'France', 'Europe', 'FRAU0314', 0),
(0, 'La Ferte-Imbault', 'France', 'Europe', 'FRCE0464', 0),
(0, 'La Ferte-Loupiere', 'France', 'Europe', 'FRBO0578', 0),
(0, 'La Ferte-Mace', 'France', 'Europe', 'FRBN0528', 0),
(0, 'La Ferte-Milon', 'France', 'Europe', 'FRXX5394', 0),
(0, 'La Ferte-Saint-Aubin', 'France', 'Europe', 'FRXX0353', 0),
(0, 'La Ferte-Saint-Cyr', 'France', 'Europe', 'FRCE0465', 0),
(0, 'La Ferte-Saint-Samson', 'France', 'Europe', 'FRHN0393', 0),
(0, 'La Ferte-sous-Jouarre', 'France', 'Europe', 'FRXX4114', 0),
(0, 'La Ferte-sur-Chiers', 'France', 'Europe', 'FRLO0773', 0),
(0, 'La Ferte-Vidame', 'France', 'Europe', 'FRXX4133', 0),
(0, 'Marcq-en-Ostrevent', 'France', 'Europe', 'FRXX3621', 0),
(0, 'Marcy', 'France', 'Europe', 'FRBO0730', 0),
(0, 'Marcy', 'France', 'Europe', 'FRPI1017', 0),
(0, 'Marcy', 'France', 'Europe', 'FRRA1049', 0),
(0, 'Marcy-l`Etoile', 'France', 'Europe', 'FRRA1050', 0),
(0, 'Marcy-sous-Marle', 'France', 'Europe', 'FRPI1018', 0),
(0, 'Mardeuil', 'France', 'Europe', 'FRCA0851', 0),
(0, 'Mardie', 'France', 'Europe', 'FRCE0642', 0),
(0, 'Mardilly', 'France', 'Europe', 'FRBN0809', 0),
(0, 'Mardor', 'France', 'Europe', 'FRCA0852', 0),
(0, 'Mardore', 'France', 'Europe', 'FRRA1051', 0),
(0, 'Mardyck', 'France', 'Europe', 'FRXX3624', 0),
(0, 'Mare', 'France', 'Europe', 'FRXX7948', 0),
(0, 'Mareau-aux-Bois', 'France', 'Europe', 'FRCE0643', 0),
(0, 'Mareau-aux-Pres', 'France', 'Europe', 'FRCE0644', 0),
(0, 'Mareil-en-Champagne', 'France', 'Europe', 'FRPL0539', 0),
(0, 'Mareil-en-France', 'France', 'Europe', 'FRXX1576', 0),
(0, 'Mareil-le-Guyon', 'France', 'Europe', 'FRIF0365', 0),
(0, 'Mareil-Marly', 'France', 'Europe', 'FRXX5086', 0),
(0, 'Mareil-sur-Loir', 'France', 'Europe', 'FRXX4926', 0),
(0, 'Mareil-sur-Mauldre', 'France', 'Europe', 'FRXX4375', 0),
(0, 'Mareilles', 'France', 'Europe', 'FRCA0853', 0),
(0, 'Marenla', 'France', 'Europe', 'FRNC0596', 0),
(0, 'Marennes', 'France', 'Europe', 'FRPC0586', 0),
(0, 'Marennes', 'France', 'Europe', 'FRXX2148', 0),
(0, 'Maresche', 'France', 'Europe', 'FRPL0540', 0),
(0, 'Maresches', 'France', 'Europe', 'FRNC0597', 0),
(0, 'Maresquel-Ecquemicourt', 'France', 'Europe', 'FRNC0598', 0),
(0, 'Marest', 'France', 'Europe', 'FRNC0599', 0),
(0, 'Marest-Dampcourt', 'France', 'Europe', 'FRPI1019', 0),
(0, 'Marest-sur-Matz', 'France', 'Europe', 'FRPI1020', 0),
(0, 'Marestaing', 'France', 'Europe', 'FRMP1344', 0),
(0, 'Marestmontiers', 'France', 'Europe', 'FRPI1021', 0),
(0, 'Maresville', 'France', 'Europe', 'FRNC0600', 0),
(0, 'Maretz', 'France', 'Europe', 'FRXX3343', 0),
(0, 'Mareugheol', 'France', 'Europe', 'FRAU0452', 0),
(0, 'Mareuil', 'France', 'Europe', 'FRPC0587', 0),
(0, 'Mareuil', 'France', 'Europe', 'FRXX6800', 0),
(0, 'Mareuil-Caubert', 'France', 'Europe', 'FRXX5909', 0),
(0, 'Mareuil-en-Brie', 'France', 'Europe', 'FRXX4623', 0),
(0, 'Mareuil-en-Dole', 'France', 'Europe', 'FRPI1022', 0),
(0, 'Mareuil-la-Motte', 'France', 'Europe', 'FRPI1023', 0),
(0, 'Mareuil-le-Port', 'France', 'Europe', 'FRXX1651', 0),
(0, 'Mareuil-les-Meaux', 'France', 'Europe', 'FRIF0366', 0),
(0, 'Mareuil-sur-Arnon', 'France', 'Europe', 'FRXX1831', 0),
(0, 'Mareuil-sur-Ay', 'France', 'Europe', 'FRXX6814', 0),
(0, 'Mareuil-sur-Cher', 'France', 'Europe', 'FRCE0645', 0),
(0, 'Mareuil-sur-Lay-Dissais', 'France', 'Europe', 'FRXX6750', 0),
(0, 'Mareuil-sur-Ourcq', 'France', 'Europe', 'FRXX1324', 0),
(0, 'Marey', 'France', 'Europe', 'FRLO1003', 0),
(0, 'Marey-les-Fussey', 'France', 'Europe', 'FRBO0731', 0),
(0, 'Marey-sur-Tille', 'France', 'Europe', 'FRBO0732', 0),
(0, 'Marfaux', 'France', 'Europe', 'FRCA0854', 0),
(0, 'Marfontaine', 'France', 'Europe', 'FRPI1024', 0),
(0, 'Marfoz', 'France', 'Europe', 'FRRA1052', 0),
(0, 'Margaux', 'France', 'Europe', 'FRAQ0870', 0),
(0, 'Margencel', 'France', 'Europe', 'FRRA1053', 0),
(0, 'Margency', 'France', 'Europe', 'FRXX2284', 0),
(0, 'Margerides', 'France', 'Europe', 'FRLI0271', 0),
(0, 'Margerie-Chantagret', 'France', 'Europe', 'FRRA1054', 0),
(0, 'Margerie-Hancourt', 'France', 'Europe', 'FRCA0855', 0),
(0, 'Marges', 'France', 'Europe', 'FRRA1055', 0),
(0, 'Margilley', 'France', 'Europe', 'FRFC0828', 0),
(0, 'Margival', 'France', 'Europe', 'FRPI1025', 0),
(0, 'Margny', 'France', 'Europe', 'FRCA0856', 0),
(0, 'Margny', 'France', 'Europe', 'FRCA0857', 0),
(0, 'Margny-aux-Cerises', 'France', 'Europe', 'FRPI1026', 0),
(0, 'Margny-les-Compiegne', 'France', 'Europe', 'FRXX5742', 0),
(0, 'Margny-sur-Matz', 'France', 'Europe', 'FRPI1027', 0),
(0, 'Margon', 'France', 'Europe', 'FRCE0646', 0),
(0, 'Margon', 'France', 'Europe', 'FRLR0446', 0),
(0, 'Margouet-Meymes', 'France', 'Europe', 'FRXX5186', 0),
(0, 'Margueray', 'France', 'Europe', 'FRBN0810', 0),
(0, 'Marguerittes', 'France', 'Europe', 'FRPA0358', 0),
(0, 'Margueron', 'France', 'Europe', 'FRAQ0871', 0),
(0, 'Marguestau', 'France', 'Europe', 'FRMP1345', 0),
(0, 'Margut', 'France', 'Europe', 'FRXX2560', 0),
(0, 'Mariac', 'France', 'Europe', 'FRRA1056', 0),
(0, 'Mariaud', 'France', 'Europe', 'FRPA0359', 0),
(0, 'Maricourt', 'France', 'Europe', 'FRPI1028', 0),
(0, 'Noizay', 'France', 'Europe', 'FRCE0801', 0),
(0, 'Noize', 'France', 'Europe', 'FRPC0698', 0),
(0, 'Nojals-et-Clotte', 'France', 'Europe', 'FRAQ1054', 0),
(0, 'Nojeon-en-Vexin', 'France', 'Europe', 'FRHN0623', 0),
(0, 'Nolay', 'France', 'Europe', 'FRBO0900', 0),
(0, 'Nolay', 'France', 'Europe', 'FRBO0901', 0),
(0, 'Nolleval', 'France', 'Europe', 'FRHN0624', 0),
(0, 'Nollieux', 'France', 'Europe', 'FRRA1252', 0),
(0, 'Nomain', 'France', 'Europe', 'FRNC0669', 0),
(0, 'Nomdieu', 'France', 'Europe', 'FRAQ1055', 0),
(0, 'Nomecourt', 'France', 'Europe', 'FRCA1007', 0),
(0, 'Nomeny', 'France', 'Europe', 'FRLO1171', 0),
(0, 'Nomexy', 'France', 'Europe', 'FRLO1172', 0),
(0, 'Nommay', 'France', 'Europe', 'FRFC0987', 0),
(0, 'Nompatelize', 'France', 'Europe', 'FRLO1173', 0),
(0, 'Nonac', 'France', 'Europe', 'FRPC0699', 0),
(0, 'Nonancourt', 'France', 'Europe', 'FRCE0802', 0),
(0, 'Nonant', 'France', 'Europe', 'FRBN0930', 0),
(0, 'Nonant-le-Pin', 'France', 'Europe', 'FRXX1325', 0),
(0, 'Nonards', 'France', 'Europe', 'FRLI0311', 0),
(0, 'Nonaville', 'France', 'Europe', 'FRPC0700', 0),
(0, 'Noncourt-sur-le-Rongeant', 'France', 'Europe', 'FRXX6788', 0),
(0, 'Nonette', 'France', 'Europe', 'FRAU0540', 0),
(0, 'Nonglard', 'France', 'Europe', 'FRRA1253', 0),
(0, 'Nonhigny', 'France', 'Europe', 'FRLO1174', 0),
(0, 'Nonieres', 'France', 'Europe', 'FRRA1254', 0),
(0, 'Nonsard-Lamarche', 'France', 'Europe', 'FRLO1175', 0),
(0, 'Nontron', 'France', 'Europe', 'FRXX4884', 0),
(0, 'Nonville', 'France', 'Europe', 'FRIF0438', 0),
(0, 'Nonville', 'France', 'Europe', 'FRLO1176', 0),
(0, 'Nonvilliers-Grandhoux', 'France', 'Europe', 'FRCE0803', 0),
(0, 'Nonza', 'France', 'Europe', 'FRCO0117', 0),
(0, 'Nonzeville', 'France', 'Europe', 'FRLO1177', 0),
(0, 'Noordpeene', 'France', 'Europe', 'FRNC0670', 0),
(0, 'Nordausques', 'France', 'Europe', 'FRNC0671', 0),
(0, 'Nordheim', 'France', 'Europe', 'FRAL0401', 0),
(0, 'Nordhouse', 'France', 'Europe', 'FRXX3024', 0),
(0, 'Noreuil', 'France', 'Europe', 'FRNC0672', 0),
(0, 'Norges-la-Ville', 'France', 'Europe', 'FRBO0902', 0),
(0, 'Normandel', 'France', 'Europe', 'FRBN0931', 0),
(0, 'Normanville', 'France', 'Europe', 'FRHN0625', 0),
(0, 'Normanville', 'France', 'Europe', 'FRHN0626', 0),
(0, 'Normee', 'France', 'Europe', 'FRCA1008', 0),
(0, 'Normier', 'France', 'Europe', 'FRBO0903', 0),
(0, 'Norolles', 'France', 'Europe', 'FRBN0932', 0),
(0, 'Noron-l`Abbaye', 'France', 'Europe', 'FRBN0933', 0),
(0, 'Noron-la-Poterie', 'France', 'Europe', 'FRBN0934', 0),
(0, 'Noroy', 'France', 'Europe', 'FRPI1211', 0),
(0, 'Noroy-le-Bourg', 'France', 'Europe', 'FRFC0988', 0),
(0, 'Noroy-les-Jussey', 'France', 'Europe', 'FRFC0989', 0),
(0, 'Noroy-sur-Ourcq', 'France', 'Europe', 'FRPI1212', 0),
(0, 'Norrent-Fontes', 'France', 'Europe', 'FRNC0673', 0),
(0, 'Norrey-en-Auge', 'France', 'Europe', 'FRBN0935', 0),
(0, 'Norrey-en-Bessin', 'France', 'Europe', 'FRBN0936', 0),
(0, 'Norrois', 'France', 'Europe', 'FRCA1009', 0),
(0, 'Norroy', 'France', 'Europe', 'FRLO1178', 0),
(0, 'Norroy-le-Sec', 'France', 'Europe', 'FRXX4643', 0),
(0, 'Norroy-le-Veneur', 'France', 'Europe', 'FRXX3662', 0),
(0, 'Norroy-les-Pont-a-Mousson', 'France', 'Europe', 'FRLO1179', 0),
(0, 'Nort-Leulinghem', 'France', 'Europe', 'FRNC0674', 0),
(0, 'Nort-sur-Erdre', 'France', 'Europe', 'FRXX3473', 0),
(0, 'Nortkerque', 'France', 'Europe', 'FRNC0675', 0),
(0, 'Norville', 'France', 'Europe', 'FRHN0627', 0),
(0, 'Nossage-et-Benevent', 'France', 'Europe', 'FRPA0412', 0),
(0, 'Nossoncourt', 'France', 'Europe', 'FRLO1180', 0),
(0, 'Nostang', 'France', 'Europe', 'FRBR0355', 0),
(0, 'Noth', 'France', 'Europe', 'FRLI0312', 0),
(0, 'Nothalten', 'France', 'Europe', 'FRXX6751', 0),
(0, 'Notre-Dame-d`Aliermont', 'France', 'Europe', 'FRHN0628', 0),
(0, 'Notre-Dame-d`Allencon', 'France', 'Europe', 'FRPL0638', 0),
(0, 'Notre-Dame-d`Elle', 'France', 'Europe', 'FRBN0937', 0),
(0, 'Notre-Dame-d`Epine', 'France', 'Europe', 'FRHN0629', 0),
(0, 'Notre-Dame-d`Estrees', 'France', 'Europe', 'FRBN0938', 0),
(0, 'Notre-Dame-d`Oe', 'France', 'Europe', 'FRCE0804', 0),
(0, 'Notre-Dame-de-Bellecombe', 'France', 'Europe', 'FRXX0444', 0),
(0, 'Notre-Dame-de-Bliquetuit', 'France', 'Europe', 'FRHN0630', 0),
(0, 'Notre-Dame-de-Boisset', 'France', 'Europe', 'FRRA1255', 0),
(0, 'Notre-Dame-de-Bondeville', 'France', 'Europe', 'FRXX2832', 0),
(0, 'Notre-Dame-de-Cenilly', 'France', 'Europe', 'FRXX5133', 0),
(0, 'Notre-Dame-de-Commiers', 'France', 'Europe', 'FRRA1256', 0),
(0, 'Ozenx-Montestrucq', 'France', 'Europe', 'FRAQ1087', 0),
(0, 'Ozerailles', 'France', 'Europe', 'FRLO1220', 0),
(0, 'Ozeville', 'France', 'Europe', 'FRBN0968', 0),
(0, 'Ozieres', 'France', 'Europe', 'FRCA1050', 0),
(0, 'Ozillac', 'France', 'Europe', 'FRPC0714', 0),
(0, 'Ozoir-la-Ferriere', 'France', 'Europe', 'FRXX5649', 0),
(0, 'Ozoir-le-Breuil', 'France', 'Europe', 'FRCE0849', 0),
(0, 'Ozolles', 'France', 'Europe', 'FRXX2267', 0),
(0, 'Ozon', 'France', 'Europe', 'FRMP1678', 0),
(0, 'Ozouer-le-Repos', 'France', 'Europe', 'FRIF0457', 0),
(0, 'Ozouer-le-Voulgis', 'France', 'Europe', 'FRIF0458', 0),
(0, 'Ozourt', 'France', 'Europe', 'FRAQ1088', 0),
(0, 'Peyrissac', 'France', 'Europe', 'FRLI0332', 0),
(0, 'Peyrissas', 'France', 'Europe', 'FRMP1725', 0),
(0, 'Peyrole', 'France', 'Europe', 'FRMP1726', 0),
(0, 'Peyroles', 'France', 'Europe', 'FRXX6164', 0),
(0, 'Peyrolles', 'France', 'Europe', 'FRLR0601', 0),
(0, 'Peyrolles-en-Provence', 'France', 'Europe', 'FRXX4798', 0),
(0, 'Peyroules', 'France', 'Europe', 'FRXX3139', 0),
(0, 'Peyrouse', 'France', 'Europe', 'FRMP1727', 0),
(0, 'Peyrouzet', 'France', 'Europe', 'FRMP1728', 0),
(0, 'Peyruis', 'France', 'Europe', 'FRXX5399', 0),
(0, 'Peyrun', 'France', 'Europe', 'FRMP1729', 0),
(0, 'Peyrus', 'France', 'Europe', 'FRRA1328', 0),
(0, 'Peyrusse', 'France', 'Europe', 'FRAU0572', 0),
(0, 'Peyrusse-Grande', 'France', 'Europe', 'FRMP1730', 0),
(0, 'Peyrusse-le-Roc', 'France', 'Europe', 'FRXX6168', 0),
(0, 'Peyrusse-Massas', 'France', 'Europe', 'FRXX1368', 0),
(0, 'Peyrusse-Vieille', 'France', 'Europe', 'FRMP1731', 0),
(0, 'Peyssies', 'France', 'Europe', 'FRMP1732', 0),
(0, 'Peyzac-le-Moustier', 'France', 'Europe', 'FRXX4599', 0),
(0, 'Peyzieux-sur-Saone', 'France', 'Europe', 'FRRA1329', 0),
(0, 'Pezarches', 'France', 'Europe', 'FRIF0469', 0),
(0, 'Peze-le-Robert', 'France', 'Europe', 'FRPL0673', 0),
(0, 'Pezenas', 'France', 'Europe', 'FRLR0602', 0),
(0, 'Pezenes-les-Mines', 'France', 'Europe', 'FRLR0603', 0),
(0, 'Pezens', 'France', 'Europe', 'FRXX4074', 0),
(0, 'Pezilla-de-Conflent', 'France', 'Europe', 'FRLR0604', 0),
(0, 'Pezilla-la-Riviere', 'France', 'Europe', 'FRXX3540', 0),
(0, 'Pezou', 'France', 'Europe', 'FRCE0870', 0),
(0, 'Pezuls', 'France', 'Europe', 'FRAQ1119', 0),
(0, 'Pezy', 'France', 'Europe', 'FRCE0871', 0),
(0, 'Pfaffenheim', 'France', 'Europe', 'FRAL0437', 0),
(0, 'Pfaffenhoffen', 'France', 'Europe', 'FRXX2118', 0),
(0, 'Pfalzweyer', 'France', 'Europe', 'FRLO1245', 0),
(0, 'Pfastatt', 'France', 'Europe', 'FRXX1481', 0),
(0, 'Pfetterhouse', 'France', 'Europe', 'FRXX3565', 0),
(0, 'Pfettisheim', 'France', 'Europe', 'FRAL0438', 0),
(0, 'Pfulgriesheim', 'France', 'Europe', 'FRAL0439', 0),
(0, 'Phaffans', 'France', 'Europe', 'FRMP1733', 0),
(0, 'Phalempin', 'France', 'Europe', 'FRXX5782', 0),
(0, 'Phalsbourg', 'France', 'Europe', 'FRXX1219', 0),
(0, 'Philippsbourg', 'France', 'Europe', 'FRLO1246', 0),
(0, 'Philondenx', 'France', 'Europe', 'FRAQ1120', 0),
(0, 'Phlin', 'France', 'Europe', 'FRLO1247', 0),
(0, 'Pia', 'France', 'Europe', 'FRXX5715', 0),
(0, 'Piace', 'France', 'Europe', 'FRPL0674', 0),
(0, 'Piana', 'France', 'Europe', 'FRXX1086', 0),
(0, 'Pianello', 'France', 'Europe', 'FRCO0141', 0),
(0, 'Piano', 'France', 'Europe', 'FRCO0142', 0),
(0, 'Pianottoli-Caldarello', 'France', 'Europe', 'FRXX2474', 0),
(0, 'Piau Engaly', 'France', 'Europe', 'FRXX0452', 0),
(0, 'Piazzali', 'France', 'Europe', 'FRXX5419', 0),
(0, 'Piazzole', 'France', 'Europe', 'FRCO0143', 0),
(0, 'Piblange', 'France', 'Europe', 'FRXX3345', 0),
(0, 'Pibrac', 'France', 'Europe', 'FRXX1486', 0),
(0, 'Picarreau', 'France', 'Europe', 'FRFC1047', 0),
(0, 'Picauville', 'France', 'Europe', 'FRBN0983', 0),
(0, 'Pichanges', 'France', 'Europe', 'FRBO0960', 0),
(0, 'Picherande', 'France', 'Europe', 'FRXX1988', 0),
(0, 'Picquigny', 'France', 'Europe', 'FRPI1287', 0),
(0, 'Pie-d`Orezza', 'France', 'Europe', 'FRCO0144', 0),
(0, 'Pied Aigu', 'France', 'Europe', 'FRXX0253', 0),
(0, 'Pied-de-Borne', 'France', 'Europe', 'FRLR0605', 0),
(0, 'Piedicorte-di-Gaggio', 'France', 'Europe', 'FRXX5950', 0),
(0, 'Piedicroce', 'France', 'Europe', 'FRCO0145', 0),
(0, 'Piedigriggio', 'France', 'Europe', 'FRCO0146', 0),
(0, 'Piedipartino', 'France', 'Europe', 'FRCO0147', 0),
(0, 'Piegon', 'France', 'Europe', 'FRRA1330', 0),
(0, 'Piegros-la-Clastre', 'France', 'Europe', 'FRRA1331', 0),
(0, 'Piegut', 'France', 'Europe', 'FRPA0430', 0),
(0, 'Piegut-Pluviers', 'France', 'Europe', 'FRXX3050', 0),
(0, 'Piencourt', 'France', 'Europe', 'FRHN0659', 0),
(0, 'Piennes', 'France', 'Europe', 'FRXX3767', 0),
(0, 'Piennes-Onvillers', 'France', 'Europe', 'FRPI1288', 0),
(0, 'Piepape', 'France', 'Europe', 'FRCA1079', 0),
(0, 'Pierlas', 'France', 'Europe', 'FRPA0431', 0),
(0, 'Pierre Besse', 'France', 'Europe', 'FRXX0254', 0),
(0, 'Pierre-Benite', 'France', 'Europe', 'FRXX2814', 0),
(0, 'Pierre-Buffiere', 'France', 'Europe', 'FRLI0333', 0),
(0, 'Pierre-Chatel', 'France', 'Europe', 'FRRA1332', 0),
(0, 'Pierre-de-Bresse', 'France', 'Europe', 'FRBO0962', 0),
(0, 'Rignat', 'France', 'Europe', 'FRRA1438', 0),
(0, 'Rignaucourt', 'France', 'Europe', 'FRLO1365', 0),
(0, 'Rigne', 'France', 'Europe', 'FRPC0799', 0),
(0, 'Rigney', 'France', 'Europe', 'FRFC1137', 0),
(0, 'Rignieux-le-Franc', 'France', 'Europe', 'FRRA1439', 0),
(0, 'Rignosot', 'France', 'Europe', 'FRFC1138', 0),
(0, 'Rignovelle', 'France', 'Europe', 'FRFC1139', 0),
(0, 'Rigny', 'France', 'Europe', 'FRFC1140', 0),
(0, 'Rigny-la-Nonneuse', 'France', 'Europe', 'FRCA1185', 0),
(0, 'Rigny-la-Salle', 'France', 'Europe', 'FRLO1367', 0),
(0, 'Rigny-le-Ferron', 'France', 'Europe', 'FRCA1186', 0),
(0, 'Rigny-Saint-Martin', 'France', 'Europe', 'FRLO1366', 0),
(0, 'Rigny-sur-Arroux', 'France', 'Europe', 'FRBO1038', 0),
(0, 'Rigny-Usse', 'France', 'Europe', 'FRCE0938', 0),
(0, 'Riguepeu', 'France', 'Europe', 'FRMP1862', 0),
(0, 'Rilhac-Lastours', 'France', 'Europe', 'FRLI0347', 0),
(0, 'Rilhac-Rancon', 'France', 'Europe', 'FRXX4521', 0),
(0, 'Rilhac-Treignac', 'France', 'Europe', 'FRLI0348', 0),
(0, 'Rilhac-Xaintrie', 'France', 'Europe', 'FRLI0349', 0),
(0, 'Rillans', 'France', 'Europe', 'FRFC1141', 0),
(0, 'Rille', 'France', 'Europe', 'FRCE0939', 0),
(0, 'Rillieux-la-Pape', 'France', 'Europe', 'FRXX4172', 0),
(0, 'Rilly-la-Montagne', 'France', 'Europe', 'FRXX4625', 0),
(0, 'Rilly-Sainte-Syre', 'France', 'Europe', 'FRXX4812', 0),
(0, 'Rilly-sur-Aisne', 'France', 'Europe', 'FRCA1187', 0),
(0, 'Rilly-sur-Loire', 'France', 'Europe', 'FRXX5937', 0),
(0, 'Rilly-sur-Vienne', 'France', 'Europe', 'FRCE0940', 0),
(0, 'Rimatara', 'France', 'Europe', 'FRXX7895', 0),
(0, 'Rimaucourt', 'France', 'Europe', 'FRCA1188', 0),
(0, 'Rimbach-pres-Guebwiller', 'France', 'Europe', 'FRAL0470', 0),
(0, 'Rimbach-pres-Masevaux', 'France', 'Europe', 'FRAL0471', 0),
(0, 'Rimbachzell', 'France', 'Europe', 'FRAL0472', 0),
(0, 'Rimbez-et-Baudiets', 'France', 'Europe', 'FRAQ1205', 0),
(0, 'Rimboval', 'France', 'Europe', 'FRNC0777', 0),
(0, 'Rimeize', 'France', 'Europe', 'FRLR0675', 0),
(0, 'Rimling', 'France', 'Europe', 'FRXX5337', 0),
(0, 'Rimogne', 'France', 'Europe', 'FRCA1189', 0),
(0, 'Rimon-et-Savel', 'France', 'Europe', 'FRRA1440', 0),
(0, 'Rimondeix', 'France', 'Europe', 'FRLI0350', 0),
(0, 'Rimons', 'France', 'Europe', 'FRAQ1206', 0),
(0, 'Rimont', 'France', 'Europe', 'FRXX3322', 0),
(0, 'Rimou', 'France', 'Europe', 'FRBR0496', 0),
(0, 'Rimplas', 'France', 'Europe', 'FRPA0483', 0),
(0, 'Rimsdorf', 'France', 'Europe', 'FRAL0473', 0),
(0, 'Ringeldorf', 'France', 'Europe', 'FRAL0474', 0),
(0, 'Ringendorf', 'France', 'Europe', 'FRAL0475', 0),
(0, 'Rinxent', 'France', 'Europe', 'FRXX6354', 0),
(0, 'Riocaud', 'France', 'Europe', 'FRAQ1207', 0),
(0, 'Riolas', 'France', 'Europe', 'FRMP1863', 0),
(0, 'Riols', 'France', 'Europe', 'FRLR0676', 0),
(0, 'Riom', 'France', 'Europe', 'FRXX6404', 0),
(0, 'Riom-es-Montagnes', 'France', 'Europe', 'FRAU0613', 0),
(0, 'Rioms', 'France', 'Europe', 'FRRA1441', 0),
(0, 'Rion-des-Landes', 'France', 'Europe', 'FRXX6051', 0),
(0, 'Rions', 'France', 'Europe', 'FRXX6623', 0),
(0, 'Riorges', 'France', 'Europe', 'FRXX3401', 0),
(0, 'Riotord', 'France', 'Europe', 'FRAU0614', 0),
(0, 'Riouperoux', 'France', 'Europe', 'FRRA1442', 0),
(0, 'Rioux', 'France', 'Europe', 'FRPC0800', 0),
(0, 'Rioux-Martin', 'France', 'Europe', 'FRPC0801', 0),
(0, 'Rioz', 'France', 'Europe', 'FRFC1142', 0),
(0, 'Riquewihr', 'France', 'Europe', 'FRXX5182', 0),
(0, 'Ris', 'France', 'Europe', 'FRAU0615', 0),
(0, 'Ris', 'France', 'Europe', 'FRXX4947', 0),
(0, 'Ris-Orangis', 'France', 'Europe', 'FRXX1573', 0),
(0, 'Riscle', 'France', 'Europe', 'FRMP1864', 0),
(0, 'Risoul', 'France', 'Europe', 'FRXX0538', 0),
(0, 'Ristolas', 'France', 'Europe', 'FRXX3895', 0),
(0, 'Rittershoffen', 'France', 'Europe', 'FRAL0476', 0),
(0, 'Ritzing', 'France', 'Europe', 'FRLO1368', 0),
(0, 'Riunogues (Riunoguers)', 'France', 'Europe', 'FRLR0677', 0),
(0, 'Riupeyrous', 'France', 'Europe', 'FRAQ1208', 0),
(0, 'Rivarennes', 'France', 'Europe', 'FRCE0941', 0),
(0, 'Rivarennes', 'France', 'Europe', 'FRCE0942', 0),
(0, 'Rivas', 'France', 'Europe', 'FRRA1443', 0),
(0, 'Rive-de-Gier', 'France', 'Europe', 'FRRA1444', 0),
(0, 'Rivecourt', 'France', 'Europe', 'FRPI1402', 0),
(0, 'Rivedoux-Plage', 'France', 'Europe', 'FRXX5509', 0),
(0, 'Rivehaute', 'France', 'Europe', 'FRAQ1209', 0),
(0, 'Rivel', 'France', 'Europe', 'FRLR0678', 0),
(0, 'Saint-Blaise', 'France', 'Europe', 'FRRA1547', 0),
(0, 'Saint-Blaise-du-Buis', 'France', 'Europe', 'FRRA1548', 0),
(0, 'Saint-Blaise-la-Roche', 'France', 'Europe', 'FRXX1457', 0),
(0, 'Saint-Blancard', 'France', 'Europe', 'FRXX6626', 0),
(0, 'Saint-Blimont', 'France', 'Europe', 'FRXX3701', 0),
(0, 'Saint-Blin', 'France', 'Europe', 'FRCA1231', 0),
(0, 'Saint-Boes', 'France', 'Europe', 'FRAQ1267', 0),
(0, 'Saint-Bohaire', 'France', 'Europe', 'FRCE0986', 0),
(0, 'Saint-Boil', 'France', 'Europe', 'FRBO1091', 0),
(0, 'Saint-Boingt', 'France', 'Europe', 'FRLO1422', 0),
(0, 'Saint-Bois', 'France', 'Europe', 'FRRA1549', 0),
(0, 'Saint-Bomer', 'France', 'Europe', 'FRCE0987', 0),
(0, 'Saint-Bomer-les-Forges', 'France', 'Europe', 'FRXX5833', 0),
(0, 'Saint-Bon', 'France', 'Europe', 'FRCA1232', 0),
(0, 'Saint-Bon-Tarentaise', 'France', 'Europe', 'FRXX4231', 0),
(0, 'Saint-Bonnet', 'France', 'Europe', 'FRPC0833', 0),
(0, 'Saint-Bonnet-Avalouze', 'France', 'Europe', 'FRLI0378', 0),
(0, 'Saint-Bonnet-Briance', 'France', 'Europe', 'FRLI0379', 0),
(0, 'Saint-Bonnet-de-Bellac', 'France', 'Europe', 'FRLI0380', 0),
(0, 'Saint-Bonnet-de-Chavagne', 'France', 'Europe', 'FRRA1550', 0),
(0, 'Saint-Bonnet-de-Chirac', 'France', 'Europe', 'FRLR0719', 0),
(0, 'Saint-Bonnet-de-Condat', 'France', 'Europe', 'FRAU0650', 0),
(0, 'Saint-Bonnet-de-Cray', 'France', 'Europe', 'FRBO1092', 0),
(0, 'Saint-Bonnet-de-Four', 'France', 'Europe', 'FRAU0651', 0),
(0, 'Saint-Bonnet-de-Joux', 'France', 'Europe', 'FRXX4311', 0),
(0, 'Saint-Bonnet-de-Montauroux', 'France', 'Europe', 'FRLR0720', 0),
(0, 'Saint-Bonnet-de-Mure', 'France', 'Europe', 'FRXX6588', 0),
(0, 'Saint-Bonnet-de-Rochefort', 'France', 'Europe', 'FRAU0652', 0),
(0, 'Saint-Bonnet-de-Salendrinque', 'France', 'Europe', 'FRLR0721', 0),
(0, 'Saint-Bonnet-de-Salers', 'France', 'Europe', 'FRAU0653', 0),
(0, 'Saint-Bonnet-de-Valclerieux', 'France', 'Europe', 'FRRA1551', 0),
(0, 'Saint-Bonnet-de-Vieille-Vigne', 'France', 'Europe', 'FRBO1093', 0),
(0, 'Saint-Bonnet-des-Bruyeres', 'France', 'Europe', 'FRRA1552', 0),
(0, 'Saint-Bonnet-des-Quarts', 'France', 'Europe', 'FRXX1945', 0),
(0, 'Saint-Bonnet-du-Gard', 'France', 'Europe', 'FRXX4838', 0),
(0, 'Saint-Bonnet-Elvert', 'France', 'Europe', 'FRXX1798', 0),
(0, 'Saint-Bonnet-en-Bresse', 'France', 'Europe', 'FRBO1094', 0),
(0, 'Saint-Bonnet-en-Champsaur', 'France', 'Europe', 'FRXX2410', 0),
(0, 'Saint-Bonnet-l`Enfantier', 'France', 'Europe', 'FRLI0381', 0),
(0, 'Saint-Bonnet-la-Riviere', 'France', 'Europe', 'FRLI0382', 0),
(0, 'Saint-Bonnet-le-Bourg', 'France', 'Europe', 'FRAU0654', 0),
(0, 'Saint-Bonnet-le-Chastel', 'France', 'Europe', 'FRXX1967', 0),
(0, 'Saint-Bonnet-le-Chateau', 'France', 'Europe', 'FRXX3404', 0),
(0, 'Saint-Bonnet-le-Courreau', 'France', 'Europe', 'FRXX2629', 0),
(0, 'Saint-Bonnet-le-Froid', 'France', 'Europe', 'FRRA1553', 0),
(0, 'Saint-Bonnet-le-Troncy', 'France', 'Europe', 'FRRA1554', 0),
(0, 'Saint-Bonnet-les-Allier', 'France', 'Europe', 'FRAU0655', 0),
(0, 'Saint-Bonnet-les-Oules', 'France', 'Europe', 'FRRA1555', 0),
(0, 'Saint-Bonnet-les-Tours-de-Merle', 'France', 'Europe', 'FRLI0383', 0),
(0, 'Saint-Bonnet-pres-Bort', 'France', 'Europe', 'FRLI0384', 0),
(0, 'Saint-Bonnet-pres-Orcival', 'France', 'Europe', 'FRXX6405', 0),
(0, 'Saint-Bonnet-pres-Riom', 'France', 'Europe', 'FRAU0656', 0),
(0, 'Saint-Bonnet-sur-Gironde', 'France', 'Europe', 'FRXX4049', 0),
(0, 'Saint-Bonnet-Troncais', 'France', 'Europe', 'FRXX1731', 0),
(0, 'Saint-Bonnot', 'France', 'Europe', 'FRBO1095', 0),
(0, 'Saint-Bouize', 'France', 'Europe', 'FRCE0988', 0),
(0, 'Saint-Brancher', 'France', 'Europe', 'FRBO1096', 0),
(0, 'Saint-Branchs', 'France', 'Europe', 'FRXX5882', 0),
(0, 'Saint-Brandan', 'France', 'Europe', 'FRBR0527', 0),
(0, 'Saint-Bres', 'France', 'Europe', 'FRMP1946', 0),
(0, 'Saint-Bres', 'France', 'Europe', 'FRXX1876', 0),
(0, 'Saint-Bresson', 'France', 'Europe', 'FRFC1176', 0),
(0, 'Saint-Bresson', 'France', 'Europe', 'FRLR0722', 0),
(0, 'Saint-Bressou', 'France', 'Europe', 'FRMP1947', 0),
(0, 'Saint-Brevin-les-Pins', 'France', 'Europe', 'FRXX2005', 0),
(0, 'Saint-Briac-sur-Mer', 'France', 'Europe', 'FRBR0528', 0),
(0, 'Saint-Brice', 'France', 'Europe', 'FRAQ1268', 0),
(0, 'Saint-Brice', 'France', 'Europe', 'FRBN1101', 0),
(0, 'Saint-Brice', 'France', 'Europe', 'FRBN1102', 0),
(0, 'Saint-Brice', 'France', 'Europe', 'FRIF0522', 0),
(0, 'Saint-Brice', 'France', 'Europe', 'FRPC0834', 0),
(0, 'Saint-Brice', 'France', 'Europe', 'FRPL0758', 0),
(0, 'Saint-Brice-Courcelles', 'France', 'Europe', 'FRXX6820', 0),
(0, 'Saint-Brice-de-Landelles', 'France', 'Europe', 'FRBN1103', 0),
(0, 'Saint-Brice-en-Cogles', 'France', 'Europe', 'FRXX2330', 0),
(0, 'Saint-Brice-sous-Foret', 'France', 'Europe', 'FRXX1697', 0),
(0, 'Saint-Brice-sous-Ranes', 'France', 'Europe', 'FRBN1104', 0),
(0, 'Saint-Brice-sur-Vienne', 'France', 'Europe', 'FRLI0385', 0),
(0, 'Saint-Brieuc', 'France', 'Europe', 'FRXX0086', 0),
(0, 'Saint-Brieuc-de-Mauron', 'France', 'Europe', 'FRBR0529', 0),
(0, 'Thun-l`Eveque', 'France', 'Europe', 'FRXX2774', 0),
(0, 'Thun-Saint-Amand', 'France', 'Europe', 'FRNC0906', 0),
(0, 'Thun-Saint-Martin', 'France', 'Europe', 'FRNC0907', 0),
(0, 'Thurageau', 'France', 'Europe', 'FRPC1094', 0),
(0, 'Thure', 'France', 'Europe', 'FRXX4431', 0),
(0, 'Thuret', 'France', 'Europe', 'FRAU0858', 0),
(0, 'Thurey', 'France', 'Europe', 'FRBO1382', 0),
(0, 'Thurey-le-Mont', 'France', 'Europe', 'FRXX1658', 0),
(0, 'Thurins', 'France', 'Europe', 'FRRA1987', 0),
(0, 'Thury', 'France', 'Europe', 'FRBO1383', 0),
(0, 'Thury', 'France', 'Europe', 'FRBO1384', 0),
(0, 'Thury-en-Valois', 'France', 'Europe', 'FRPI1620', 0),
(0, 'Thury-Harcourt', 'France', 'Europe', 'FRXX4696', 0),
(0, 'Thury-sous-Clermont', 'France', 'Europe', 'FRPI1621', 0),
(0, 'Thusy', 'France', 'Europe', 'FRRA1988', 0),
(0, 'Thuy', 'France', 'Europe', 'FRMP2328', 0),
(0, 'Thyez', 'France', 'Europe', 'FRRA1989', 0),
(0, 'Thyl', 'France', 'Europe', 'FRRA1990', 0),
(0, 'Tiarei', 'France', 'Europe', 'FRXX7854', 0),
(0, 'Tibiran-Jaunac', 'France', 'Europe', 'FRXX5685', 0),
(0, 'Ticheville', 'France', 'Europe', 'FRBN1397', 0),
(0, 'Tichey', 'France', 'Europe', 'FRBO1385', 0),
(0, 'Tieffenbach', 'France', 'Europe', 'FRAL0581', 0),
(0, 'Tierce', 'France', 'Europe', 'FRXX4661', 0),
(0, 'Tiercelet', 'France', 'Europe', 'FRLO1600', 0),
(0, 'Tierceville', 'France', 'Europe', 'FRBN1398', 0),
(0, 'Tieste-Uragnoux', 'France', 'Europe', 'FRMP2329', 0),
(0, 'Tiffauges', 'France', 'Europe', 'FRPL1004', 0),
(0, 'Tigeaux', 'France', 'Europe', 'FRIF0599', 0),
(0, 'Tigery', 'France', 'Europe', 'FRIF0600', 0),
(0, 'Tignac', 'France', 'Europe', 'FRMP2330', 0),
(0, 'Tigne', 'France', 'Europe', 'FRPL1005', 0),
(0, 'Tignecourt', 'France', 'Europe', 'FRLO1601', 0),
(0, 'Tignes', 'France', 'Europe', 'FRXX0492', 0),
(0, 'Tignieu-Jameyzieu', 'France', 'Europe', 'FRXX4197', 0),
(0, 'Tigny-Noyelle', 'France', 'Europe', 'FRNC0908', 0),
(0, 'Tigy', 'France', 'Europe', 'FRCE1227', 0),
(0, 'Tikehau', 'France', 'Europe', 'FRXX7916', 0),
(0, 'Til-Chatel', 'France', 'Europe', 'FRBO1386', 0),
(0, 'Tilh', 'France', 'Europe', 'FRAQ1677', 0),
(0, 'Tilhouse', 'France', 'Europe', 'FRMP2331', 0),
(0, 'Tillac', 'France', 'Europe', 'FRMP2332', 0),
(0, 'Tillay-le-Peneux', 'France', 'Europe', 'FRCE1228', 0),
(0, 'Tille', 'France', 'Europe', 'FRPI1622', 0),
(0, 'Tillenay', 'France', 'Europe', 'FRBO1387', 0),
(0, 'Tilleul-Dame-Agnes', 'France', 'Europe', 'FRHN0937', 0),
(0, 'Tilleux', 'France', 'Europe', 'FRLO1602', 0),
(0, 'Tillieres', 'France', 'Europe', 'FRPL1006', 0),
(0, 'Tillieres-sur-Avre', 'France', 'Europe', 'FRXX5354', 0),
(0, 'Tilloloy', 'France', 'Europe', 'FRPI1623', 0),
(0, 'Tillou', 'France', 'Europe', 'FRPC1095', 0),
(0, 'Tilloy-et-Bellay', 'France', 'Europe', 'FRCA1449', 0),
(0, 'Tilloy-Floriville', 'France', 'Europe', 'FRXX2204', 0),
(0, 'Tilloy-les-Conty', 'France', 'Europe', 'FRPI1624', 0),
(0, 'Tilloy-les-Hermaville', 'France', 'Europe', 'FRNC0909', 0),
(0, 'Tilloy-les-Mofflaines', 'France', 'Europe', 'FRXX2702', 0),
(0, 'Tilloy-lez-Cambrai', 'France', 'Europe', 'FRNC0910', 0),
(0, 'Tilloy-lez-Marchiennes', 'France', 'Europe', 'FRNC0911', 0),
(0, 'Tilly', 'France', 'Europe', 'FRIF0601', 0),
(0, 'Tilly', 'France', 'Europe', 'FRXX4335', 0),
(0, 'Tilly', 'France', 'Europe', 'FRXX6234', 0),
(0, 'Tilly-Capelle', 'France', 'Europe', 'FRNC0912', 0),
(0, 'Tilly-la-Campagne', 'France', 'Europe', 'FRBN1399', 0),
(0, 'Tilly-sur-Meuse', 'France', 'Europe', 'FRLO1603', 0),
(0, 'Tilly-sur-Seulles', 'France', 'Europe', 'FRXX6131', 0),
(0, 'Tilques', 'France', 'Europe', 'FRNC0913', 0),
(0, 'Tincey-et-Pontrebeau', 'France', 'Europe', 'FRXX1450', 0),
(0, 'Tinchebray', 'France', 'Europe', 'FRBN1400', 0),
(0, 'Tincourt-Boucly', 'France', 'Europe', 'FRXX4506', 0),
(0, 'Tincques', 'France', 'Europe', 'FRXX5865', 0),
(0, 'Tincry', 'France', 'Europe', 'FRLO1604', 0),
(0, 'Tingry', 'France', 'Europe', 'FRNC0914', 0),
(0, 'Tinqueux', 'France', 'Europe', 'FRXX4618', 0),
(0, 'Tinteniac', 'France', 'Europe', 'FRXX1883', 0),
(0, 'Tintry', 'France', 'Europe', 'FRBO1388', 0),
(0, 'Tintury', 'France', 'Europe', 'FRBO1389', 0),
(0, 'Tiranges', 'France', 'Europe', 'FRAU0859', 0),
(0, 'Tirent-Pontejac', 'France', 'Europe', 'FRMP2333', 0),
(0, 'Tirepied', 'France', 'Europe', 'FRBN1401', 0),
(0, 'Tissey', 'France', 'Europe', 'FRBO1390', 0),
(0, 'Veix', 'France', 'Europe', 'FRLI0554', 0),
(0, 'Velaine-en-Haye', 'France', 'Europe', 'FRLO1702', 0),
(0, 'Velaine-sous-Amance', 'France', 'Europe', 'FRLO1703', 0),
(0, 'Velaines', 'France', 'Europe', 'FRLO1704', 0),
(0, 'Velanne', 'France', 'Europe', 'FRRA2059', 0),
(0, 'Velars-sur-Ouche', 'France', 'Europe', 'FRBO1455', 0),
(0, 'Velaux', 'France', 'Europe', 'FRXX2529', 0),
(0, 'Velennes', 'France', 'Europe', 'FRPI1681', 0),
(0, 'Velennes', 'France', 'Europe', 'FRPI1682', 0),
(0, 'Velesmes-Echevanne', 'France', 'Europe', 'FRFC1347', 0),
(0, 'Velesmes-Essarts', 'France', 'Europe', 'FRFC1348', 0),
(0, 'Velet', 'France', 'Europe', 'FRFC1349', 0),
(0, 'Velieux', 'France', 'Europe', 'FRLR0934', 0),
(0, 'Velines', 'France', 'Europe', 'FRAQ1717', 0),
(0, 'Velizy-Villacoublay', 'France', 'Europe', 'FRXX2822', 0),
(0, 'Velle-le-Chatel', 'France', 'Europe', 'FRFC1350', 0),
(0, 'Velle-sur-Moselle', 'France', 'Europe', 'FRLO1705', 0),
(0, 'Velleches', 'France', 'Europe', 'FRCE1268', 0),
(0, 'Vellechevreux-et-Courbenans', 'France', 'Europe', 'FRFC1351', 0),
(0, 'Velleclaire', 'France', 'Europe', 'FRFC1352', 0),
(0, 'Vellefaux', 'France', 'Europe', 'FRFC1353', 0),
(0, 'Vellefrey-et-Vellefrange', 'France', 'Europe', 'FRFC1354', 0),
(0, 'Vellefrie', 'France', 'Europe', 'FRFC1355', 0),
(0, 'Velleguindry-et-Levrecey', 'France', 'Europe', 'FRFC1356', 0),
(0, 'Velleminfroy', 'France', 'Europe', 'FRFC1357', 0),
(0, 'Vellemoz', 'France', 'Europe', 'FRFC1358', 0),
(0, 'Velleron', 'France', 'Europe', 'FRXX3789', 0),
(0, 'Vellerot-les-Belvoir', 'France', 'Europe', 'FRFC1359', 0),
(0, 'Vellerot-les-Vercel', 'France', 'Europe', 'FRFC1360', 0),
(0, 'Velles', 'France', 'Europe', 'FRCA1532', 0),
(0, 'Velles', 'France', 'Europe', 'FRCE1269', 0),
(0, 'Vellescot', 'France', 'Europe', 'FRMP2418', 0),
(0, 'Vellevans', 'France', 'Europe', 'FRFC1361', 0),
(0, 'Vellexon-Queutrey-et-Vaudey', 'France', 'Europe', 'FRFC1362', 0),
(0, 'Velloreille-les-Choye', 'France', 'Europe', 'FRFC1363', 0),
(0, 'Velluire', 'France', 'Europe', 'FRPL1035', 0),
(0, 'Velogny', 'France', 'Europe', 'FRBO1456', 0),
(0, 'Velone-Orneto', 'France', 'Europe', 'FRCO0224', 0),
(0, 'Velorcey', 'France', 'Europe', 'FRFC1364', 0),
(0, 'Velosnes', 'France', 'Europe', 'FRLO1706', 0),
(0, 'Velotte-et-Tatignecourt', 'France', 'Europe', 'FRLO1707', 0),
(0, 'Velu', 'France', 'Europe', 'FRNC0932', 0),
(0, 'Velving', 'France', 'Europe', 'FRLO1708', 0),
(0, 'Velye', 'France', 'Europe', 'FRCA1533', 0),
(0, 'Velzic', 'France', 'Europe', 'FRAU0903', 0),
(0, 'Vemars', 'France', 'Europe', 'FRIF0622', 0),
(0, 'Venables', 'France', 'Europe', 'FRHN0983', 0),
(0, 'Venaco', 'France', 'Europe', 'FRXX2427', 0),
(0, 'Venansault', 'France', 'Europe', 'FRXX6023', 0),
(0, 'Venanson', 'France', 'Europe', 'FRPA0679', 0),
(0, 'Venarey-les-Laumes', 'France', 'Europe', 'FRXX2597', 0),
(0, 'Venarsal', 'France', 'Europe', 'FRLI0555', 0),
(0, 'Venas', 'France', 'Europe', 'FRAU0904', 0),
(0, 'Venasque', 'France', 'Europe', 'FRPA0680', 0),
(0, 'Vence', 'France', 'Europe', 'FRXX1722', 0),
(0, 'Vendargues', 'France', 'Europe', 'FRXX0104', 0),
(0, 'Vendat', 'France', 'Europe', 'FRAU0905', 0),
(0, 'Vendays-Montalivet', 'France', 'Europe', 'FRXX2755', 0),
(0, 'Vendegies-au-Bois', 'France', 'Europe', 'FRNC0933', 0),
(0, 'Vendegies-sur-Ecaillon', 'France', 'Europe', 'FRXX2580', 0),
(0, 'Vendel', 'France', 'Europe', 'FRBR0778', 0),
(0, 'Vendelles', 'France', 'Europe', 'FRXX1708', 0),
(0, 'Vendemian', 'France', 'Europe', 'FRLR0935', 0),
(0, 'Vendenesse-les-Charolles', 'France', 'Europe', 'FRXX6019', 0),
(0, 'Vendenesse-sur-Arroux', 'France', 'Europe', 'FRBO1457', 0),
(0, 'Vendenheim', 'France', 'Europe', 'FRXX4592', 0),
(0, 'Vendes', 'France', 'Europe', 'FRBN1459', 0),
(0, 'Vendeuil', 'France', 'Europe', 'FRPI1683', 0),
(0, 'Vendeuil-Caply', 'France', 'Europe', 'FRPI1684', 0),
(0, 'Vendeuvre', 'France', 'Europe', 'FRBN1460', 0),
(0, 'Vendeuvre-du-Poitou', 'France', 'Europe', 'FRXX1455', 0),
(0, 'Vendeuvre-sur-Barse', 'France', 'Europe', 'FRXX2538', 0),
(0, 'Vendeville', 'France', 'Europe', 'FRNC0934', 0),
(0, 'Vendhuile', 'France', 'Europe', 'FRXX4669', 0),
(0, 'Vendieres', 'France', 'Europe', 'FRPI1685', 0),
(0, 'Vendin-le-Vieil', 'France', 'Europe', 'FRXX4171', 0),
(0, 'Vendin-les-Bethune', 'France', 'Europe', 'FRXX5704', 0),
(0, 'Vendine', 'France', 'Europe', 'FRMP2419', 0),
(0, 'Vendoeuvres', 'France', 'Europe', 'FRCE1270', 0),
(0, 'Vendoire', 'France', 'Europe', 'FRAQ1718', 0),
(0, 'Arc-les-Gray', 'France', 'Europe', 'FRFC0044', 0),
(0, 'Arcachon', 'France', 'Europe', 'FRXX3648', 0),
(0, 'Arcais', 'France', 'Europe', 'FRPC0033', 0),
(0, 'Arcambal', 'France', 'Europe', 'FRMP0061', 0),
(0, 'Arcay', 'France', 'Europe', 'FRCE0017', 0),
(0, 'Arcay', 'France', 'Europe', 'FRPC0034', 0),
(0, 'Arceau', 'France', 'Europe', 'FRBO0026', 0),
(0, 'Arcelot', 'France', 'Europe', 'FRBO0027', 0),
(0, 'Arcenant', 'France', 'Europe', 'FRBO0028', 0),
(0, 'Arcens', 'France', 'Europe', 'FRRA0064', 0),
(0, 'Arces-Dilo', 'France', 'Europe', 'FRBO0029', 0),
(0, 'Arcey', 'France', 'Europe', 'FRBO0030', 0),
(0, 'Arcey', 'France', 'Europe', 'FRFC0045', 0),
(0, 'Archail', 'France', 'Europe', 'FRPA0013', 0),
(0, 'Archamps', 'France', 'Europe', 'FRRA0065', 0),
(0, 'Archelange', 'France', 'Europe', 'FRFC0046', 0),
(0, 'Arches', 'France', 'Europe', 'FRAU0014', 0),
(0, 'Arches', 'France', 'Europe', 'FRXX1553', 0),
(0, 'Archignac', 'France', 'Europe', 'FRAQ0039', 0),
(0, 'Archignat', 'France', 'Europe', 'FRAU0015', 0),
(0, 'Archigny', 'France', 'Europe', 'FRPC0035', 0),
(0, 'Archingeay', 'France', 'Europe', 'FRPC0036', 0),
(0, 'Archon', 'France', 'Europe', 'FRPI0045', 0),
(0, 'Arcine', 'France', 'Europe', 'FRRA0066', 0),
(0, 'Arcinges', 'France', 'Europe', 'FRRA0067', 0),
(0, 'Arcins', 'France', 'Europe', 'FRAQ0040', 0),
(0, 'Arcomie', 'France', 'Europe', 'FRLR0026', 0),
(0, 'Arcon', 'France', 'Europe', 'FRFC0047', 0),
(0, 'Arcon', 'France', 'Europe', 'FRRA0068', 0),
(0, 'Arconnay', 'France', 'Europe', 'FRPL0014', 0),
(0, 'Arconsat', 'France', 'Europe', 'FRAU0016', 0),
(0, 'Arconville', 'France', 'Europe', 'FRCA0032', 0),
(0, 'Arcueil', 'France', 'Europe', 'FRXX6766', 0),
(0, 'Ardelles', 'France', 'Europe', 'FRCE0018', 0),
(0, 'Ardelu', 'France', 'Europe', 'FRCE0019', 0),
(0, 'Ardenais', 'France', 'Europe', 'FRCE0020', 0),
(0, 'Ardengost', 'France', 'Europe', 'FRMP0062', 0),
(0, 'Ardevon', 'France', 'Europe', 'FRBN0027', 0),
(0, 'Ardiege', 'France', 'Europe', 'FRMP0063', 0),
(0, 'Ardilleux', 'France', 'Europe', 'FRPC0037', 0),
(0, 'Ardillieres', 'France', 'Europe', 'FRPC0038', 0),
(0, 'Ardin', 'France', 'Europe', 'FRPC0039', 0),
(0, 'Ardizas', 'France', 'Europe', 'FRMP0064', 0),
(0, 'Ardoix', 'France', 'Europe', 'FRRA0069', 0),
(0, 'Ardon', 'France', 'Europe', 'FRCE0021', 0),
(0, 'Ardon', 'France', 'Europe', 'FRFC0048', 0),
(0, 'Ardouval', 'France', 'Europe', 'FRHN0014', 0),
(0, 'Ardres', 'France', 'Europe', 'FRNC0028', 0),
(0, 'Areches', 'France', 'Europe', 'FRRA0070', 0),
(0, 'Areches Beaufort', 'France', 'Europe', 'FRXX0463', 0),
(0, 'Aren', 'France', 'Europe', 'FRAQ0041', 0),
(0, 'Arengosse', 'France', 'Europe', 'FRAQ0042', 0),
(0, 'Arenthon', 'France', 'Europe', 'FRRA0071', 0),
(0, 'Ares', 'France', 'Europe', 'FRXX3722', 0),
(0, 'Aresches', 'France', 'Europe', 'FRFC0049', 0),
(0, 'Arette', 'France', 'Europe', 'FRAQ0043', 0),
(0, 'Arfeuille-Chatain', 'France', 'Europe', 'FRLI0013', 0),
(0, 'Arfons', 'France', 'Europe', 'FRMP0065', 0),
(0, 'Argagnon', 'France', 'Europe', 'FRAQ0044', 0),
(0, 'Arganchy', 'France', 'Europe', 'FRBN0028', 0),
(0, 'Argancon', 'France', 'Europe', 'FRCA0033', 0),
(0, 'Argancy', 'France', 'Europe', 'FRLO0040', 0),
(0, 'Argein', 'France', 'Europe', 'FRMP0066', 0),
(0, 'Argeles Plage', 'France', 'Europe', 'FRXX5717', 0),
(0, 'Argeles-Bagneres', 'France', 'Europe', 'FRMP0067', 0),
(0, 'Argeliers', 'France', 'Europe', 'FRLR0027', 0),
(0, 'Argelliers', 'France', 'Europe', 'FRLR0028', 0),
(0, 'Argelos', 'France', 'Europe', 'FRAQ0045', 0),
(0, 'Argelos', 'France', 'Europe', 'FRAQ0046', 0),
(0, 'Argelouse', 'France', 'Europe', 'FRAQ0047', 0),
(0, 'Argences', 'France', 'Europe', 'FRBN0029', 0),
(0, 'Argens', 'France', 'Europe', 'FRPA0014', 0),
(0, 'Argens-Minervois', 'France', 'Europe', 'FRLR0029', 0),
(0, 'Argentan', 'France', 'Europe', 'FRXX0368', 0),
(0, 'Argentenay', 'France', 'Europe', 'FRBO0031', 0),
(0, 'Argenteuil', 'France', 'Europe', 'FRXX0282', 0),
(0, 'Argentiere', 'France', 'Europe', 'FRXX0464', 0),
(0, 'Argentieres', 'France', 'Europe', 'FRIF0015', 0),
(0, 'Argentine', 'France', 'Europe', 'FRRA0072', 0),
(0, 'Argenton', 'France', 'Europe', 'FRAQ0048', 0),
(0, 'Belloy', 'France', 'Europe', 'FRPI0132', 0),
(0, 'Belloy-sur-Somme', 'France', 'Europe', 'FRPI0133', 0),
(0, 'Belluire', 'France', 'Europe', 'FRPC0084', 0),
(0, 'Belmesnil', 'France', 'Europe', 'FRHN0042', 0),
(0, 'Belmont', 'France', 'Europe', 'FRCA0100', 0),
(0, 'Belmont', 'France', 'Europe', 'FRFC0113', 0),
(0, 'Belmont', 'France', 'Europe', 'FRFC0114', 0),
(0, 'Belmont', 'France', 'Europe', 'FRFC0115', 0),
(0, 'Belmont', 'France', 'Europe', 'FRMP0226', 0),
(0, 'Belmont', 'France', 'Europe', 'FRRA0152', 0),
(0, 'Belmont', 'France', 'Europe', 'FRRA0153', 0),
(0, 'Belmont-d`Azergues', 'France', 'Europe', 'FRRA0155', 0),
(0, 'Belmont-Luthezieu', 'France', 'Europe', 'FRRA0154', 0),
(0, 'Belmontet', 'France', 'Europe', 'FRMP0227', 0),
(0, 'Belonchamp', 'France', 'Europe', 'FRFC0116', 0),
(0, 'Belpech', 'France', 'Europe', 'FRLR0072', 0),
(0, 'Belrain', 'France', 'Europe', 'FRLO0129', 0),
(0, 'Belrupt', 'France', 'Europe', 'FRLO0130', 0),
(0, 'Belus', 'France', 'Europe', 'FRAQ0143', 0),
(0, 'Belval', 'France', 'Europe', 'FRBN0078', 0),
(0, 'Belval', 'France', 'Europe', 'FRCA0101', 0),
(0, 'Belval', 'France', 'Europe', 'FRLO0131', 0),
(0, 'Belvedere', 'France', 'Europe', 'FRPA0050', 0),
(0, 'Belverne', 'France', 'Europe', 'FRFC0117', 0),
(0, 'Belveze', 'France', 'Europe', 'FRMP0228', 0),
(0, 'Belvezet', 'France', 'Europe', 'FRLR0073', 0),
(0, 'Belvezet', 'France', 'Europe', 'FRPA0051', 0),
(0, 'Belvianes-et-Cavirac', 'France', 'Europe', 'FRLR0074', 0),
(0, 'Belvis', 'France', 'Europe', 'FRLR0075', 0),
(0, 'Belvoir', 'France', 'Europe', 'FRFC0118', 0),
(0, 'Bemecourt', 'France', 'Europe', 'FRHN0043', 0),
(0, 'Benac', 'France', 'Europe', 'FRMP0229', 0),
(0, 'Benac', 'France', 'Europe', 'FRMP0230', 0),
(0, 'Benagues', 'France', 'Europe', 'FRMP0231', 0),
(0, 'Benais', 'France', 'Europe', 'FRCE0055', 0),
(0, 'Benaix', 'France', 'Europe', 'FRMP0232', 0),
(0, 'Benamenil', 'France', 'Europe', 'FRLO0132', 0),
(0, 'Benarville', 'France', 'Europe', 'FRHN0044', 0),
(0, 'Benassay', 'France', 'Europe', 'FRPC0085', 0),
(0, 'Benay', 'France', 'Europe', 'FRPI0134', 0),
(0, 'Benayes', 'France', 'Europe', 'FRLI0034', 0),
(0, 'Bendejun', 'France', 'Europe', 'FRPA0052', 0),
(0, 'Benejacq', 'France', 'Europe', 'FRAQ0144', 0),
(0, 'Benest', 'France', 'Europe', 'FRPC0086', 0),
(0, 'Benesville', 'France', 'Europe', 'FRHN0045', 0),
(0, 'Benet', 'France', 'Europe', 'FRPL0052', 0),
(0, 'Beneuvre', 'France', 'Europe', 'FRBO0080', 0),
(0, 'Benevent-et-Charbillac', 'France', 'Europe', 'FRPA0053', 0),
(0, 'Benifontaine', 'France', 'Europe', 'FRNC0100', 0),
(0, 'Bennecourt', 'France', 'Europe', 'FRIF0051', 0),
(0, 'Bennetot', 'France', 'Europe', 'FRHN0046', 0),
(0, 'Benney', 'France', 'Europe', 'FRLO0133', 0),
(0, 'Bennwihr', 'France', 'Europe', 'FRAL0021', 0),
(0, 'Bennwihr Gare', 'France', 'Europe', 'FRXX2220', 0),
(0, 'Benoisey', 'France', 'Europe', 'FRBO0081', 0),
(0, 'Benoitville', 'France', 'Europe', 'FRBN0079', 0),
(0, 'Benon', 'France', 'Europe', 'FRPC0087', 0),
(0, 'Benonces', 'France', 'Europe', 'FRRA0156', 0),
(0, 'Benouville', 'France', 'Europe', 'FRHN0047', 0),
(0, 'Benque', 'France', 'Europe', 'FRMP0233', 0),
(0, 'Benque', 'France', 'Europe', 'FRMP0234', 0),
(0, 'Benquet', 'France', 'Europe', 'FRAQ0145', 0),
(0, 'Beny', 'France', 'Europe', 'FRRA0157', 0),
(0, 'Beon', 'France', 'Europe', 'FRBO0082', 0),
(0, 'Beon', 'France', 'Europe', 'FRRA0158', 0),
(0, 'Berat', 'France', 'Europe', 'FRMP0235', 0),
(0, 'Beraut', 'France', 'Europe', 'FRMP0236', 0),
(0, 'Berbezit', 'France', 'Europe', 'FRAU0049', 0),
(0, 'Berbiguieres', 'France', 'Europe', 'FRAQ0146', 0),
(0, 'Berc', 'France', 'Europe', 'FRLR0076', 0),
(0, 'Berche', 'France', 'Europe', 'FRFC0119', 0),
(0, 'Bercheres-Saint-Germain', 'France', 'Europe', 'FRCE0056', 0),
(0, 'Bercloux', 'France', 'Europe', 'FRPC0088', 0),
(0, 'Berd`huis', 'France', 'Europe', 'FRBN0080', 0),
(0, 'Berdoues', 'France', 'Europe', 'FRMP0237', 0),
(0, 'Berelles', 'France', 'Europe', 'FRNC0101', 0),
(0, 'Berentzwiller', 'France', 'Europe', 'FRAL0022', 0),
(0, 'Berenx', 'France', 'Europe', 'FRAQ0147', 0),
(0, 'Berfay', 'France', 'Europe', 'FRPL0053', 0),
(0, 'Berganty', 'France', 'Europe', 'FRMP0238', 0),
(0, 'Chadurie', 'France', 'Europe', 'FRPC0165', 0),
(0, 'Chaffois', 'France', 'Europe', 'FRFC0217', 0),
(0, 'Chagnon', 'France', 'Europe', 'FRRA0266', 0),
(0, 'Chagny', 'France', 'Europe', 'FRBO0170', 0),
(0, 'Chagny', 'France', 'Europe', 'FRCA0201', 0),
(0, 'Chahaignes', 'France', 'Europe', 'FRPL0098', 0),
(0, 'Chahains', 'France', 'Europe', 'FRBN0196', 0),
(0, 'Chaignay', 'France', 'Europe', 'FRBO0171', 0),
(0, 'Chaignes', 'France', 'Europe', 'FRHN0124', 0),
(0, 'Chail', 'France', 'Europe', 'FRPC0166', 0),
(0, 'Chaillac', 'France', 'Europe', 'FRCE0133', 0),
(0, 'Chailland', 'France', 'Europe', 'FRXX6071', 0),
(0, 'Chaille-sous-les-Ormeaux', 'France', 'Europe', 'FRPL0099', 0),
(0, 'Chailles', 'France', 'Europe', 'FRCE0134', 0),
(0, 'Chaillevette', 'France', 'Europe', 'FRXX5508', 0),
(0, 'Chaillevois', 'France', 'Europe', 'FRPI0306', 0),
(0, 'Chailley', 'France', 'Europe', 'FRXX2289', 0),
(0, 'Chaillol', 'France', 'Europe', 'FRXX0554', 0),
(0, 'Chaillon', 'France', 'Europe', 'FRLO0245', 0),
(0, 'Chailloue', 'France', 'Europe', 'FRBN0197', 0),
(0, 'Chailly-en-Biere', 'France', 'Europe', 'FRXX1537', 0),
(0, 'Chaingy', 'France', 'Europe', 'FRCE0135', 0),
(0, 'Chaintreaux', 'France', 'Europe', 'FRIF0095', 0),
(0, 'Chaix', 'France', 'Europe', 'FRPL0100', 0),
(0, 'Chalabre', 'France', 'Europe', 'FRLR0160', 0),
(0, 'Chalagnac', 'France', 'Europe', 'FRAQ0314', 0),
(0, 'Chalaines', 'France', 'Europe', 'FRLO0246', 0),
(0, 'Chalais', 'France', 'Europe', 'FRCE0136', 0),
(0, 'Chalais', 'France', 'Europe', 'FRPC0167', 0),
(0, 'Chalais', 'France', 'Europe', 'FRPC0168', 0),
(0, 'Chalamont', 'France', 'Europe', 'FRRA0267', 0),
(0, 'Chalancey', 'France', 'Europe', 'FRCA0202', 0),
(0, 'Chalancon', 'France', 'Europe', 'FRRA0268', 0),
(0, 'Chalandray', 'France', 'Europe', 'FRPC0169', 0),
(0, 'Chalandrey', 'France', 'Europe', 'FRBN0198', 0),
(0, 'Chalandry', 'France', 'Europe', 'FRPI0307', 0),
(0, 'Chalaux', 'France', 'Europe', 'FRBO0172', 0),
(0, 'Chaleins', 'France', 'Europe', 'FRRA0269', 0),
(0, 'Chaleix', 'France', 'Europe', 'FRAQ0315', 0),
(0, 'Chaley', 'France', 'Europe', 'FRRA0270', 0),
(0, 'Chaleze', 'France', 'Europe', 'FRFC0218', 0),
(0, 'Chalezeule', 'France', 'Europe', 'FRFC0219', 0),
(0, 'Chaliers', 'France', 'Europe', 'FRAU0105', 0),
(0, 'Chalifert', 'France', 'Europe', 'FRIF0096', 0),
(0, 'Chaligny', 'France', 'Europe', 'FRLO0247', 0),
(0, 'Chalinargues', 'France', 'Europe', 'FRAU0106', 0),
(0, 'Chalindrey', 'France', 'Europe', 'FRXX0415', 0),
(0, 'Chalivoy-Milon', 'France', 'Europe', 'FRCE0137', 0),
(0, 'Challans', 'France', 'Europe', 'FRXX0307', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Challement', 'France', 'Europe', 'FRBO0173', 0),
(0, 'Challerange', 'France', 'Europe', 'FRCA0203', 0),
(0, 'Challes', 'France', 'Europe', 'FRPL0101', 0),
(0, 'Challes', 'France', 'Europe', 'FRRA0271', 0),
(0, 'Challet', 'France', 'Europe', 'FRCE0138', 0),
(0, 'Challignac', 'France', 'Europe', 'FRPC0170', 0),
(0, 'Challonges', 'France', 'Europe', 'FRRA0272', 0),
(0, 'Chalmaison', 'France', 'Europe', 'FRIF0097', 0),
(0, 'Chalmoux', 'France', 'Europe', 'FRBO0174', 0),
(0, 'Chalon-sur-Saone', 'France', 'Europe', 'FRXX0418', 0),
(0, 'Chalons', 'France', 'Europe', 'FRLI0062', 0),
(0, 'Chalons-en-Champagne', 'France', 'Europe', 'FRXX2362', 0),
(0, 'Chalons-sur-Marne', 'France', 'Europe', 'FRXX0394', 0),
(0, 'Chalonvillars', 'France', 'Europe', 'FRFC0220', 0),
(0, 'Chaltrait', 'France', 'Europe', 'FRCA0204', 0),
(0, 'Chalus', 'France', 'Europe', 'FRAU0107', 0),
(0, 'Chalvignac', 'France', 'Europe', 'FRAU0108', 0),
(0, 'Chalvraines', 'France', 'Europe', 'FRCA0205', 0),
(0, 'Chamadelle', 'France', 'Europe', 'FRAQ0316', 0),
(0, 'Chamagne', 'France', 'Europe', 'FRLO0248', 0),
(0, 'Chamagnieu', 'France', 'Europe', 'FRRA0273', 0),
(0, 'Chamalieres', 'France', 'Europe', 'FRXX2656', 0),
(0, 'Chamant', 'France', 'Europe', 'FRPI0308', 0),
(0, 'Chamarandes-Choignes', 'France', 'Europe', 'FRCA0206', 0),
(0, 'Chamaret', 'France', 'Europe', 'FRRA0274', 0),
(0, 'Chambain', 'France', 'Europe', 'FRBO0175', 0),
(0, 'Chambeire', 'France', 'Europe', 'FRBO0176', 0),
(0, 'Chambellay', 'France', 'Europe', 'FRPL0102', 0),
(0, 'Chambeon', 'France', 'Europe', 'FRRA0275', 0),
(0, 'Chamberat', 'France', 'Europe', 'FRAU0109', 0),
(0, 'Chamberaud', 'France', 'Europe', 'FRLI0063', 0),
(0, 'Evigny', 'France', 'Europe', 'FRCA0426', 0),
(0, 'Evillers', 'France', 'Europe', 'FRFC0458', 0),
(0, 'Evin-Malmaison', 'France', 'Europe', 'FRXX2115', 0),
(0, 'Evires', 'France', 'Europe', 'FRRA0544', 0),
(0, 'Evrange', 'France', 'Europe', 'FRLO0433', 0),
(0, 'Evrecy', 'France', 'Europe', 'FRBN0347', 0),
(0, 'Evres', 'France', 'Europe', 'FRLO0434', 0),
(0, 'Evreux', 'France', 'Europe', 'FRXX0038', 0),
(0, 'Evricourt', 'France', 'Europe', 'FRPI0537', 0),
(0, 'Evron', 'France', 'Europe', 'FRPL0213', 0),
(0, 'Evry', 'France', 'Europe', 'FRBO0405', 0),
(0, 'Evry', 'France', 'Europe', 'FRXX0201', 0),
(0, 'Evry-Gregy-sur-Yerre', 'France', 'Europe', 'FRIF0188', 0),
(0, 'Excenevex', 'France', 'Europe', 'FRRA0545', 0),
(0, 'Excideuil', 'France', 'Europe', 'FRAQ0424', 0),
(0, 'Exermont', 'France', 'Europe', 'FRCA0427', 0),
(0, 'Exincourt', 'France', 'Europe', 'FRFC0459', 0),
(0, 'Exireuil', 'France', 'Europe', 'FRPC0316', 0),
(0, 'Exmes', 'France', 'Europe', 'FRBN0348', 0),
(0, 'Exoudun', 'France', 'Europe', 'FRPC0317', 0),
(0, 'Expiremont', 'France', 'Europe', 'FRPC0318', 0),
(0, 'Eybens', 'France', 'Europe', 'FRRA0546', 0),
(0, 'Eybouleuf', 'France', 'Europe', 'FRLI0126', 0),
(0, 'Eyburie', 'France', 'Europe', 'FRLI0127', 0),
(0, 'Eycheil', 'France', 'Europe', 'FRMP0693', 0),
(0, 'Eydoche', 'France', 'Europe', 'FRRA0547', 0),
(0, 'Eygalayes', 'France', 'Europe', 'FRRA0548', 0),
(0, 'Eygalieres', 'France', 'Europe', 'FRXX5486', 0),
(0, 'Eygaliers', 'France', 'Europe', 'FRRA0549', 0),
(0, 'Eygliers', 'France', 'Europe', 'FRPA0172', 0),
(0, 'Eyguians', 'France', 'Europe', 'FRPA0173', 0),
(0, 'Eyguieres', 'France', 'Europe', 'FRXX1075', 0),
(0, 'Eygurande', 'France', 'Europe', 'FRLI0128', 0),
(0, 'Eyliac', 'France', 'Europe', 'FRAQ0425', 0),
(0, 'Eymet', 'France', 'Europe', 'FRAQ0426', 0),
(0, 'Eymeux', 'France', 'Europe', 'FRRA0550', 0),
(0, 'Eymoutiers', 'France', 'Europe', 'FRLI0129', 0),
(0, 'Eynesse', 'France', 'Europe', 'FRAQ0427', 0),
(0, 'Eyragues', 'France', 'Europe', 'FRXX3990', 0),
(0, 'Eyrein', 'France', 'Europe', 'FRLI0130', 0),
(0, 'Eyrenville', 'France', 'Europe', 'FRAQ0428', 0),
(0, 'Eyres-Moncube', 'France', 'Europe', 'FRAQ0429', 0),
(0, 'Eyroles', 'France', 'Europe', 'FRRA0551', 0),
(0, 'Eysines', 'France', 'Europe', 'FRAQ0430', 0),
(0, 'Eysson', 'France', 'Europe', 'FRFC0460', 0),
(0, 'Eysus', 'France', 'Europe', 'FRAQ0431', 0),
(0, 'Eywiller', 'France', 'Europe', 'FRAL0122', 0),
(0, 'Eyzahut', 'France', 'Europe', 'FRRA0552', 0),
(0, 'Eyzerac', 'France', 'Europe', 'FRAQ0432', 0),
(0, 'Ezanville', 'France', 'Europe', 'FRXX3056', 0),
(0, 'Eze', 'France', 'Europe', 'FRXX3154', 0),
(0, 'Francheville', 'France', 'Europe', 'FRBN0375', 0),
(0, 'Francheville', 'France', 'Europe', 'FRBO0442', 0),
(0, 'Francheville', 'France', 'Europe', 'FRCA0467', 0),
(0, 'Francheville', 'France', 'Europe', 'FRFC0498', 0),
(0, 'Francheville', 'France', 'Europe', 'FRHN0244', 0),
(0, 'Francheville', 'France', 'Europe', 'FRLO0482', 0),
(0, 'Francheville', 'France', 'Europe', 'FRXX6386', 0),
(0, 'Francieres', 'France', 'Europe', 'FRPI0601', 0),
(0, 'Francieres', 'France', 'Europe', 'FRPI0602', 0),
(0, 'Francin', 'France', 'Europe', 'FRRA0584', 0),
(0, 'Francois', 'France', 'Europe', 'FRPC0340', 0),
(0, 'Francon', 'France', 'Europe', 'FRMP0746', 0),
(0, 'Franconville', 'France', 'Europe', 'FRLO0483', 0),
(0, 'Francoules', 'France', 'Europe', 'FRMP0747', 0),
(0, 'Francourt', 'France', 'Europe', 'FRFC0499', 0),
(0, 'Francourville', 'France', 'Europe', 'FRCE0331', 0),
(0, 'Francs', 'France', 'Europe', 'FRAQ0464', 0),
(0, 'Francueil', 'France', 'Europe', 'FRCE0332', 0),
(0, 'Franey', 'France', 'Europe', 'FRFC0500', 0),
(0, 'Frangy', 'France', 'Europe', 'FRRA0585', 0),
(0, 'Franken', 'France', 'Europe', 'FRAL0136', 0),
(0, 'Franleu', 'France', 'Europe', 'FRPI0603', 0),
(0, 'Franois', 'France', 'Europe', 'FRFC0501', 0),
(0, 'Franquevaux', 'France', 'Europe', 'FRPA0183', 0),
(0, 'Franquevielle', 'France', 'Europe', 'FRMP0748', 0),
(0, 'Franqueville', 'France', 'Europe', 'FRHN0245', 0),
(0, 'Franqueville', 'France', 'Europe', 'FRPI0604', 0),
(0, 'Franqueville', 'France', 'Europe', 'FRPI0605', 0),
(0, 'Franqueville-Saint-Pierre', 'France', 'Europe', 'FRHN0246', 0),
(0, 'Frans', 'France', 'Europe', 'FRRA0586', 0),
(0, 'Fransart', 'France', 'Europe', 'FRPI0606', 0),
(0, 'Franseches', 'France', 'Europe', 'FRLI0142', 0),
(0, 'Fransu', 'France', 'Europe', 'FRPI0607', 0),
(0, 'Fransures', 'France', 'Europe', 'FRPI0608', 0),
(0, 'Franvillers', 'France', 'Europe', 'FRPI0609', 0),
(0, 'Franxault', 'France', 'Europe', 'FRBO0443', 0),
(0, 'Frapelle', 'France', 'Europe', 'FRLO0484', 0),
(0, 'Fraquelfing', 'France', 'Europe', 'FRLO0485', 0),
(0, 'Fraroz', 'France', 'Europe', 'FRFC0502', 0),
(0, 'Frasne', 'France', 'Europe', 'FRFC0503', 0),
(0, 'Frasne-les-Meulieres', 'France', 'Europe', 'FRFC0504', 0),
(0, 'Frasnoy', 'France', 'Europe', 'FRNC0367', 0),
(0, 'Frasseto', 'France', 'Europe', 'FRXX2518', 0),
(0, 'Frauenberg', 'France', 'Europe', 'FRLO0486', 0),
(0, 'Frausseilles', 'France', 'Europe', 'FRMP0749', 0),
(0, 'Fravaux', 'France', 'Europe', 'FRCA0468', 0),
(0, 'Frayssinet', 'France', 'Europe', 'FRMP0750', 0),
(0, 'Frayssinhes', 'France', 'Europe', 'FRMP0751', 0),
(0, 'Fraze', 'France', 'Europe', 'FRCE0333', 0),
(0, 'Freauville', 'France', 'Europe', 'FRHN0247', 0),
(0, 'Frebecourt', 'France', 'Europe', 'FRLO0487', 0),
(0, 'Frebuans', 'France', 'Europe', 'FRFC0505', 0),
(0, 'Frechede', 'France', 'Europe', 'FRMP0752', 0),
(0, 'Frechencourt', 'France', 'Europe', 'FRPI0610', 0),
(0, 'Frechendets', 'France', 'Europe', 'FRMP0753', 0),
(0, 'Freconrupt', 'France', 'Europe', 'FRAL0137', 0),
(0, 'Frecourt', 'France', 'Europe', 'FRCA0469', 0),
(0, 'Frederic-Fontaine', 'France', 'Europe', 'FRFC0506', 0),
(0, 'Fredille', 'France', 'Europe', 'FRCE0334', 0),
(0, 'Fregimont', 'France', 'Europe', 'FRAQ0465', 0),
(0, 'Fregouville', 'France', 'Europe', 'FRMP0754', 0),
(0, 'Frehel', 'France', 'Europe', 'FRBR0009', 0),
(0, 'Freigne', 'France', 'Europe', 'FRPL0229', 0),
(0, 'Freissinieres', 'France', 'Europe', 'FRPA0184', 0),
(0, 'Freistroff', 'France', 'Europe', 'FRLO0488', 0),
(0, 'Freix-Anglards', 'France', 'Europe', 'FRAU0247', 0),
(0, 'Frejairolles', 'France', 'Europe', 'FRMP0755', 0),
(0, 'Frejeville', 'France', 'Europe', 'FRMP0756', 0),
(0, 'Frejus', 'France', 'Europe', 'FRXX0040', 0),
(0, 'Freland', 'France', 'Europe', 'FRAL0138', 0),
(0, 'Frelinghien', 'France', 'Europe', 'FRXX4856', 0),
(0, 'Fremainville', 'France', 'Europe', 'FRIF0206', 0),
(0, 'Fremecourt', 'France', 'Europe', 'FRXX5277', 0),
(0, 'Fremenil', 'France', 'Europe', 'FRLO0489', 0),
(0, 'Fremery', 'France', 'Europe', 'FRLO0490', 0),
(0, 'Fremestroff', 'France', 'Europe', 'FRLO0491', 0),
(0, 'Fremicourt', 'France', 'Europe', 'FRNC0368', 0),
(0, 'Fremontiers', 'France', 'Europe', 'FRPI0611', 0),
(0, 'Fremonville', 'France', 'Europe', 'FRLO0492', 0),
(0, 'Frencq', 'France', 'Europe', 'FRNC0369', 0),
(0, 'Gondreville', 'France', 'Europe', 'FRPI0656', 0),
(0, 'Gondreville', 'France', 'Europe', 'FRXX5180', 0),
(0, 'Gondrexange', 'France', 'Europe', 'FRXX1416', 0),
(0, 'Gondrexon', 'France', 'Europe', 'FRLO0554', 0),
(0, 'Gondrin', 'France', 'Europe', 'FRMP0847', 0),
(0, 'Gonesse', 'France', 'Europe', 'FRXX2326', 0),
(0, 'Gonez', 'France', 'Europe', 'FRMP0848', 0),
(0, 'Gonfaron', 'France', 'Europe', 'FRXX2739', 0),
(0, 'Gonfreville', 'France', 'Europe', 'FRBN0405', 0),
(0, 'Gonfreville-Caillot', 'France', 'Europe', 'FRHN0276', 0),
(0, 'Gonfreville-l`Orcher', 'France', 'Europe', 'FRHN0277', 0),
(0, 'Gonnehem', 'France', 'Europe', 'FRXX1934', 0),
(0, 'Gonnelieu', 'France', 'Europe', 'FRNC0392', 0),
(0, 'Gonnetot', 'France', 'Europe', 'FRHN0278', 0),
(0, 'Gonneville', 'France', 'Europe', 'FRBN0406', 0),
(0, 'Gonneville-en-Auge', 'France', 'Europe', 'FRBN0407', 0),
(0, 'Gonneville-la-Mallet', 'France', 'Europe', 'FRHN0279', 0),
(0, 'Gonneville-sur-Honfleur', 'France', 'Europe', 'FRBN0408', 0),
(0, 'Gonneville-sur-Mer', 'France', 'Europe', 'FRXX5432', 0),
(0, 'Gonneville-sur-Scie', 'France', 'Europe', 'FRHN0280', 0),
(0, 'Gonsans', 'France', 'Europe', 'FRXX5461', 0),
(0, 'Gontaud-de-Nogaret', 'France', 'Europe', 'FRAQ0519', 0),
(0, 'Gonvillars', 'France', 'Europe', 'FRFC0548', 0),
(0, 'Gonzeville', 'France', 'Europe', 'FRHN0281', 0),
(0, 'Goos', 'France', 'Europe', 'FRAQ0520', 0),
(0, 'Gorbio', 'France', 'Europe', 'FRPA0202', 0),
(0, 'Gorcy', 'France', 'Europe', 'FRXX1547', 0),
(0, 'Gordes', 'France', 'Europe', 'FRXX5294', 0),
(0, 'Gorenflos', 'France', 'Europe', 'FRPI0657', 0),
(0, 'Gorges', 'France', 'Europe', 'FRBN0409', 0),
(0, 'Gorges', 'France', 'Europe', 'FRPI0658', 0),
(0, 'Gorges', 'France', 'Europe', 'FRPL0247', 0),
(0, 'Gorhey', 'France', 'Europe', 'FRLO0555', 0),
(0, 'Gornac', 'France', 'Europe', 'FRAQ0521', 0),
(0, 'Gornies', 'France', 'Europe', 'FRLR0275', 0),
(0, 'Gorre', 'France', 'Europe', 'FRLI0150', 0),
(0, 'Gorrevod', 'France', 'Europe', 'FRRA0616', 0),
(0, 'Gorron', 'France', 'Europe', 'FRPL0248', 0),
(0, 'Gorses', 'France', 'Europe', 'FRMP0849', 0),
(0, 'Gorze', 'France', 'Europe', 'FRLO0556', 0),
(0, 'Gosnay', 'France', 'Europe', 'FRXX2052', 0),
(0, 'Gosne', 'France', 'Europe', 'FRBR0018', 0),
(0, 'Gosselming', 'France', 'Europe', 'FRLO0557', 0),
(0, 'Gotein-Libarrenx', 'France', 'Europe', 'FRAQ0522', 0),
(0, 'Gottenhouse', 'France', 'Europe', 'FRAL0162', 0),
(0, 'Gottesheim', 'France', 'Europe', 'FRAL0163', 0),
(0, 'Gouaix', 'France', 'Europe', 'FRIF0227', 0),
(0, 'Goualade', 'France', 'Europe', 'FRAQ0523', 0),
(0, 'Gouarec', 'France', 'Europe', 'FRXX1116', 0),
(0, 'Gouaux', 'France', 'Europe', 'FRMP0850', 0),
(0, 'Gouaux-de-Larboust', 'France', 'Europe', 'FRMP0851', 0),
(0, 'Gouaux-de-Luchon', 'France', 'Europe', 'FRMP0852', 0),
(0, 'Gouberville', 'France', 'Europe', 'FRBN0410', 0),
(0, 'Gouchaupre', 'France', 'Europe', 'FRHN0282', 0),
(0, 'Goudargues', 'France', 'Europe', 'FRPA0203', 0),
(0, 'Goudelancourt-les-Berrieux', 'France', 'Europe', 'FRPI0659', 0),
(0, 'Goudelancourt-les-Pierrepont', 'France', 'Europe', 'FRPI0660', 0),
(0, 'Goudelin', 'France', 'Europe', 'FRXX4036', 0),
(0, 'Goudet', 'France', 'Europe', 'FRXX5738', 0),
(0, 'Goudex', 'France', 'Europe', 'FRMP0853', 0),
(0, 'Goudon', 'France', 'Europe', 'FRMP0854', 0),
(0, 'Goudourville', 'France', 'Europe', 'FRXX7702', 0),
(0, 'Gouesnach', 'France', 'Europe', 'FRXX3955', 0),
(0, 'Gouesnou', 'France', 'Europe', 'FRXX1767', 0),
(0, 'Gouex', 'France', 'Europe', 'FRPC0364', 0),
(0, 'Gouezec', 'France', 'Europe', 'FRBR0019', 0),
(0, 'Gougenheim', 'France', 'Europe', 'FRAL0164', 0),
(0, 'Gouhelans', 'France', 'Europe', 'FRFC0549', 0),
(0, 'Gouhenans', 'France', 'Europe', 'FRXX5712', 0),
(0, 'Gouillons', 'France', 'Europe', 'FRCE0369', 0),
(0, 'Gouise', 'France', 'Europe', 'FRAU0264', 0),
(0, 'Goujounac', 'France', 'Europe', 'FRMP0855', 0),
(0, 'Goulet', 'France', 'Europe', 'FRBN0411', 0),
(0, 'Goulien', 'France', 'Europe', 'FRBR0020', 0),
(0, 'Goulier', 'France', 'Europe', 'FRMP0856', 0),
(0, 'Goulles', 'France', 'Europe', 'FRLI0151', 0),
(0, 'Gouloux', 'France', 'Europe', 'FRBO0487', 0),
(0, 'Goult', 'France', 'Europe', 'FRPA0204', 0),
(0, 'Goulven', 'France', 'Europe', 'FRBR0021', 0),
(0, 'Goumois', 'France', 'Europe', 'FRFC0550', 0),
(0, 'Houry', 'France', 'Europe', 'FRPI0771', 0),
(0, 'Houssay', 'France', 'Europe', 'FRCE0393', 0),
(0, 'Houssay', 'France', 'Europe', 'FRPL0265', 0),
(0, 'Houssaye-Beranger', 'France', 'Europe', 'FRHN0360', 0),
(0, 'Houssen', 'France', 'Europe', 'FRXX3664', 0),
(0, 'Housseras', 'France', 'Europe', 'FRLO0702', 0),
(0, 'Housset', 'France', 'Europe', 'FRPI0772', 0),
(0, 'Housseville', 'France', 'Europe', 'FRLO0703', 0),
(0, 'Houtaud', 'France', 'Europe', 'FRFC0587', 0),
(0, 'Houtkerque', 'France', 'Europe', 'FRNC0472', 0),
(0, 'Houtteville', 'France', 'Europe', 'FRBN0461', 0),
(0, 'Houville-en-Vexin', 'France', 'Europe', 'FRHN0361', 0),
(0, 'Houville-la-Branche', 'France', 'Europe', 'FRCE0394', 0),
(0, 'Houvin-Houvigneul', 'France', 'Europe', 'FRNC0473', 0),
(0, 'Houx', 'France', 'Europe', 'FRCE0395', 0),
(0, 'Hoymille', 'France', 'Europe', 'FRXX6493', 0),
(0, 'Huahine', 'France', 'Europe', 'FRXX7877', 0),
(0, 'Huanne-Montmartin', 'France', 'Europe', 'FRXX1141', 0),
(0, 'Hubersent', 'France', 'Europe', 'FRNC0474', 0),
(0, 'Hubert-Folie', 'France', 'Europe', 'FRBN0462', 0),
(0, 'Huberville', 'France', 'Europe', 'FRBN0463', 0),
(0, 'Huby-Saint-Leu', 'France', 'Europe', 'FRNC0475', 0),
(0, 'Huchenneville', 'France', 'Europe', 'FRPI0773', 0),
(0, 'Huclier', 'France', 'Europe', 'FRNC0476', 0),
(0, 'Hucqueliers', 'France', 'Europe', 'FRNC0477', 0),
(0, 'Hudimesnil', 'France', 'Europe', 'FRBN0464', 0),
(0, 'Hudiviller', 'France', 'Europe', 'FRLO0704', 0),
(0, 'Huelgoat', 'France', 'Europe', 'FRXX5359', 0),
(0, 'Huest', 'France', 'Europe', 'FRHN0362', 0),
(0, 'Huetre', 'France', 'Europe', 'FRCE0396', 0),
(0, 'Huez', 'France', 'Europe', 'FRXX4275', 0),
(0, 'Hugier', 'France', 'Europe', 'FRFC0588', 0),
(0, 'Hugleville-en-Caux', 'France', 'Europe', 'FRXX6392', 0),
(0, 'Huille', 'France', 'Europe', 'FRPL0266', 0),
(0, 'Huilliecourt', 'France', 'Europe', 'FRCA0576', 0),
(0, 'Huilly-sur-Seille', 'France', 'Europe', 'FRBO0515', 0),
(0, 'Huiron', 'France', 'Europe', 'FRCA0577', 0),
(0, 'Huismes', 'France', 'Europe', 'FRCE0397', 0),
(0, 'Huisnes-sur-Mer', 'France', 'Europe', 'FRXX4575', 0),
(0, 'Huisseau-en-Beauce', 'France', 'Europe', 'FRCE0398', 0),
(0, 'Huisseau-sur-Cosson', 'France', 'Europe', 'FRCE0399', 0),
(0, 'Huisseau-sur-Mauves', 'France', 'Europe', 'FRCE0400', 0),
(0, 'Hulluch', 'France', 'Europe', 'FRNC0478', 0),
(0, 'Hultehouse', 'France', 'Europe', 'FRLO0705', 0),
(0, 'Humbauville', 'France', 'Europe', 'FRCA0578', 0),
(0, 'Humbecourt', 'France', 'Europe', 'FRCA0579', 0),
(0, 'Humbercamps', 'France', 'Europe', 'FRXX5867', 0),
(0, 'Humbercourt', 'France', 'Europe', 'FRPI0774', 0),
(0, 'Humbert', 'France', 'Europe', 'FRNC0479', 0),
(0, 'Humberville', 'France', 'Europe', 'FRCA0580', 0),
(0, 'Humbligny', 'France', 'Europe', 'FRCE0401', 0),
(0, 'Humeroeuille', 'France', 'Europe', 'FRNC0480', 0),
(0, 'Humes-Jorquenay', 'France', 'Europe', 'FRCA0581', 0),
(0, 'Humieres', 'France', 'Europe', 'FRNC0481', 0),
(0, 'Hunawihr', 'France', 'Europe', 'FRAL0233', 0),
(0, 'Hundling', 'France', 'Europe', 'FRLO0706', 0),
(0, 'Hundsbach', 'France', 'Europe', 'FRAL0234', 0),
(0, 'Huningue', 'France', 'Europe', 'FRXX6614', 0),
(0, 'Hunspach', 'France', 'Europe', 'FRAL0235', 0),
(0, 'Hunting', 'France', 'Europe', 'FRLO0707', 0),
(0, 'Huos', 'France', 'Europe', 'FRMP0906', 0),
(0, 'Huparlac', 'France', 'Europe', 'FRMP0907', 0),
(0, 'Huppain', 'France', 'Europe', 'FRBN0465', 0),
(0, 'Huppy', 'France', 'Europe', 'FRPI0775', 0),
(0, 'Hurbache', 'France', 'Europe', 'FRLO0708', 0),
(0, 'Hure', 'France', 'Europe', 'FRAQ0576', 0),
(0, 'Hurecourt', 'France', 'Europe', 'FRFC0589', 0),
(0, 'Hures-la-Parade', 'France', 'Europe', 'FRLR0289', 0),
(0, 'Huriel', 'France', 'Europe', 'FRAU0276', 0),
(0, 'Hurigny', 'France', 'Europe', 'FRXX5661', 0),
(0, 'Hurtieres', 'France', 'Europe', 'FRRA0660', 0),
(0, 'Hurtigheim', 'France', 'Europe', 'FRAL0236', 0),
(0, 'Husseren-les-Chateaux', 'France', 'Europe', 'FRAL0237', 0),
(0, 'Husseren-Wesserling', 'France', 'Europe', 'FRXX1912', 0),
(0, 'Hussigny-Godbrange', 'France', 'Europe', 'FRXX4574', 0),
(0, 'Husson', 'France', 'Europe', 'FRBN0466', 0),
(0, 'Huttendorf', 'France', 'Europe', 'FRAL0238', 0),
(0, 'Huttenheim', 'France', 'Europe', 'FRAL0239', 0),
(0, 'Hyds', 'France', 'Europe', 'FRAU0277', 0),
(0, 'Hyemondans', 'France', 'Europe', 'FRFC0590', 0),
(0, 'La Ferte-Villeneuil', 'France', 'Europe', 'FRCE0466', 0),
(0, 'La Feuillade', 'France', 'Europe', 'FRAQ0622', 0),
(0, 'La Feuillee', 'France', 'Europe', 'FRBR0114', 0),
(0, 'La Feuillie', 'France', 'Europe', 'FRBN0529', 0),
(0, 'La Feuillie', 'France', 'Europe', 'FRHN0394', 0),
(0, 'La Flachere', 'France', 'Europe', 'FRRA0759', 0),
(0, 'La Flamengrie', 'France', 'Europe', 'FRNC0499', 0),
(0, 'La Flamengrie', 'France', 'Europe', 'FRPI0809', 0),
(0, 'La Fleche', 'France', 'Europe', 'FRPL0351', 0),
(0, 'La Flocelliere', 'France', 'Europe', 'FRPL0352', 0),
(0, 'La Flotte', 'France', 'Europe', 'FRXX1091', 0),
(0, 'La Foa', 'France', 'Europe', 'FRXX7957', 0),
(0, 'La Folie', 'France', 'Europe', 'FRBN0530', 0),
(0, 'La Folletiere', 'France', 'Europe', 'FRHN0395', 0),
(0, 'La Folletiere-Abenon', 'France', 'Europe', 'FRHN0396', 0),
(0, 'La Fontaine-Saint-Martin', 'France', 'Europe', 'FRPL0353', 0),
(0, 'La Fontelaye', 'France', 'Europe', 'FRHN0397', 0),
(0, 'La Fontenelle', 'France', 'Europe', 'FRBR0115', 0),
(0, 'La Fontenelle', 'France', 'Europe', 'FRCE0467', 0),
(0, 'La Force', 'France', 'Europe', 'FRAQ0623', 0),
(0, 'La Force', 'France', 'Europe', 'FRLR0315', 0),
(0, 'La Forclaz', 'France', 'Europe', 'FRRA0760', 0),
(0, 'La Forest-Landerneau', 'France', 'Europe', 'FRBR0116', 0),
(0, 'La Forestiere', 'France', 'Europe', 'FRCA0638', 0),
(0, 'La Foret-Auvray', 'France', 'Europe', 'FRBN0531', 0),
(0, 'La Foret-de-Tesse', 'France', 'Europe', 'FRXX5536', 0),
(0, 'La Foret-du-Parc', 'France', 'Europe', 'FRHN0398', 0),
(0, 'La Foret-du-Temple', 'France', 'Europe', 'FRLI0184', 0),
(0, 'La Foret-Fouesnant', 'France', 'Europe', 'FRXX3954', 0),
(0, 'La Foret-le-Roi', 'France', 'Europe', 'FRIF0285', 0),
(0, 'La Foret-Sainte-Croix', 'France', 'Europe', 'FRIF0284', 0),
(0, 'La Foret-sur-Sevre', 'France', 'Europe', 'FRXX6040', 0),
(0, 'La Forge', 'France', 'Europe', 'FRLO0774', 0),
(0, 'La Forie', 'France', 'Europe', 'FRAU0315', 0),
(0, 'La Forteresse', 'France', 'Europe', 'FRRA0761', 0),
(0, 'La Fosse-Corduan', 'France', 'Europe', 'FRCA0639', 0),
(0, 'La Fosse-de-Tigne', 'France', 'Europe', 'FRPL0354', 0),
(0, 'La Fouillade', 'France', 'Europe', 'FRMP0960', 0),
(0, 'La Fouillouse', 'France', 'Europe', 'FRXX2645', 0),
(0, 'La Foye-Monjault', 'France', 'Europe', 'FRXX4611', 0),
(0, 'La Framboisiere', 'France', 'Europe', 'FRCE0468', 0),
(0, 'La Francheville', 'France', 'Europe', 'FRXX2211', 0),
(0, 'La Franqui-Plage', 'France', 'Europe', 'FRXX6135', 0),
(0, 'La Frasnee', 'France', 'Europe', 'FRFC0640', 0),
(0, 'La Frasse', 'France', 'Europe', 'FRRA0762', 0),
(0, 'La Frediere', 'France', 'Europe', 'FRPC0436', 0),
(0, 'La Freissinouse', 'France', 'Europe', 'FRPA0241', 0),
(0, 'La Frenaye', 'France', 'Europe', 'FRHN0399', 0),
(0, 'La Fresnaie-Fayel', 'France', 'Europe', 'FRBN0532', 0),
(0, 'La Fresnais', 'France', 'Europe', 'FRXX3330', 0),
(0, 'La Fresnaye-au-Sauvage', 'France', 'Europe', 'FRBN0533', 0),
(0, 'La Fresnaye-sur-Chedouet', 'France', 'Europe', 'FRXX1241', 0),
(0, 'La Frette', 'France', 'Europe', 'FRBO0579', 0),
(0, 'La Frette', 'France', 'Europe', 'FRRA0763', 0),
(0, 'La Frette-sur-Seine', 'France', 'Europe', 'FRXX3129', 0),
(0, 'La Gacilly', 'France', 'Europe', 'FRXX2225', 0),
(0, 'La Gaillarde', 'France', 'Europe', 'FRHN0400', 0),
(0, 'La Garde', 'France', 'Europe', 'FRLR0316', 0),
(0, 'La Garde', 'France', 'Europe', 'FRRA0764', 0),
(0, 'La Garde', 'France', 'Europe', 'FRXX2017', 0),
(0, 'La Garde-Adhemar', 'France', 'Europe', 'FRRA0765', 0),
(0, 'La Garde-Freinet', 'France', 'Europe', 'FRXX2036', 0),
(0, 'La Garenne-Colombes', 'France', 'Europe', 'FRXX5929', 0),
(0, 'La Garnache', 'France', 'Europe', 'FRXX3811', 0),
(0, 'La Gaubretiere', 'France', 'Europe', 'FRPL0355', 0),
(0, 'La Gaudaine', 'France', 'Europe', 'FRCE0469', 0),
(0, 'La Gaude', 'France', 'Europe', 'FRXX1019', 0),
(0, 'La Gavotte', 'France', 'Europe', 'FRPA0242', 0),
(0, 'La Genete', 'France', 'Europe', 'FRBO0580', 0),
(0, 'La Genetouze', 'France', 'Europe', 'FRPC0437', 0),
(0, 'La Genetouze', 'France', 'Europe', 'FRPL0356', 0),
(0, 'La Genevraie', 'France', 'Europe', 'FRBN0534', 0),
(0, 'La Genevraye', 'France', 'Europe', 'FRIF0286', 0),
(0, 'La Genevroye', 'France', 'Europe', 'FRCA0640', 0),
(0, 'La Geneytouse', 'France', 'Europe', 'FRLI0185', 0),
(0, 'La Giettaz', 'France', 'Europe', 'FRRA0766', 0),
(0, 'La Gimond', 'France', 'Europe', 'FRRA0767', 0),
(0, 'La Glacerie', 'France', 'Europe', 'FRXX5856', 0),
(0, 'La Godefroy', 'France', 'Europe', 'FRBN0535', 0),
(0, 'La Godivelle', 'France', 'Europe', 'FRAU0316', 0),
(0, 'Marie', 'France', 'Europe', 'FRPA0360', 0),
(0, 'Marienau', 'France', 'Europe', 'FRLO1004', 0),
(0, 'Marienthal', 'France', 'Europe', 'FRAL0333', 0),
(0, 'Marieulles', 'France', 'Europe', 'FRLO1005', 0),
(0, 'Marieux', 'France', 'Europe', 'FRNC0601', 0),
(0, 'Marigna-sur-Valouse', 'France', 'Europe', 'FRFC0829', 0),
(0, 'Marignac', 'France', 'Europe', 'FRMP1346', 0),
(0, 'Marignac', 'France', 'Europe', 'FRMP1347', 0),
(0, 'Marignac', 'France', 'Europe', 'FRPC0588', 0),
(0, 'Marignac-en-Diois', 'France', 'Europe', 'FRRA1057', 0),
(0, 'Marignac-Lasclares', 'France', 'Europe', 'FRMP1348', 0),
(0, 'Marignac-Laspeyres', 'France', 'Europe', 'FRMP1349', 0),
(0, 'Marignana', 'France', 'Europe', 'FRXX4757', 0),
(0, 'Marignane', 'France', 'Europe', 'FRXX0058', 0),
(0, 'Marigne', 'France', 'Europe', 'FRPL0541', 0),
(0, 'Marigne-Laille', 'France', 'Europe', 'FRPL0542', 0),
(0, 'Marigne-Peuton', 'France', 'Europe', 'FRPL0543', 0),
(0, 'Marignier', 'France', 'Europe', 'FRXX3550', 0),
(0, 'Marignieu', 'France', 'Europe', 'FRRA1058', 0),
(0, 'Marigny', 'France', 'Europe', 'FRAU0453', 0),
(0, 'Marigny', 'France', 'Europe', 'FRBN0811', 0),
(0, 'Marigny', 'France', 'Europe', 'FRBO0733', 0),
(0, 'Marigny', 'France', 'Europe', 'FRFC0830', 0),
(0, 'Marigny', 'France', 'Europe', 'FRPC0589', 0),
(0, 'Marigny', 'France', 'Europe', 'FRXX3856', 0),
(0, 'Marigny-Brizay', 'France', 'Europe', 'FRPC0590', 0),
(0, 'Marigny-Chemereau', 'France', 'Europe', 'FRPC0591', 0),
(0, 'Marigny-en-Orxois', 'France', 'Europe', 'FRXX1713', 0),
(0, 'Marigny-l`Eglise', 'France', 'Europe', 'FRBO0734', 0),
(0, 'Marigny-le-Cahouet', 'France', 'Europe', 'FRBO0735', 0),
(0, 'Marigny-le-Chatel', 'France', 'Europe', 'FRXX5553', 0),
(0, 'Marigny-les-Reullee', 'France', 'Europe', 'FRBO0736', 0),
(0, 'Marigny-les-Usages', 'France', 'Europe', 'FRXX6397', 0),
(0, 'Marigny-Marmande', 'France', 'Europe', 'FRXX3800', 0),
(0, 'Marigny-Saint-Marcel', 'France', 'Europe', 'FRRA1059', 0),
(0, 'Marigny-sur-Yonne', 'France', 'Europe', 'FRXX1322', 0),
(0, 'Marillac-le-Franc', 'France', 'Europe', 'FRPC0592', 0),
(0, 'Marillet', 'France', 'Europe', 'FRPL0544', 0),
(0, 'Marimbault', 'France', 'Europe', 'FRAQ0872', 0),
(0, 'Marimont-les-Benestroff', 'France', 'Europe', 'FRLO1006', 0),
(0, 'Marin', 'France', 'Europe', 'FRRA1060', 0),
(0, 'Marine de Luri', 'France', 'Europe', 'FRXX3919', 0),
(0, 'Marine de Pietracorbara', 'France', 'Europe', 'FRXX1030', 0),
(0, 'Marines', 'France', 'Europe', 'FRIF0367', 0),
(0, 'Maringes', 'France', 'Europe', 'FRRA1061', 0),
(0, 'Maringues', 'France', 'Europe', 'FRXX6408', 0),
(0, 'Mariol', 'France', 'Europe', 'FRAU0454', 0),
(0, 'Marions', 'France', 'Europe', 'FRAQ0873', 0),
(0, 'Maripasoula', 'France', 'Europe', 'FRXX7793', 0),
(0, 'Marizy', 'France', 'Europe', 'FRBO0737', 0),
(0, 'Marizy-Saint-Mard', 'France', 'Europe', 'FRPI1029', 0),
(0, 'Marizy-Sainte-Genevieve', 'France', 'Europe', 'FRPI1030', 0),
(0, 'Marle', 'France', 'Europe', 'FRXX2577', 0),
(0, 'Marlemont', 'France', 'Europe', 'FRCA0858', 0),
(0, 'Marlenheim', 'France', 'Europe', 'FRXX2872', 0),
(0, 'Marlens', 'France', 'Europe', 'FRRA1062', 0),
(0, 'Marlers', 'France', 'Europe', 'FRPI1031', 0),
(0, 'Marles-en-Brie', 'France', 'Europe', 'FRIF0368', 0),
(0, 'Marles-les-Mines', 'France', 'Europe', 'FRXX3476', 0),
(0, 'Marles-sur-Canche', 'France', 'Europe', 'FRNC0602', 0),
(0, 'Marlhes', 'France', 'Europe', 'FRRA1063', 0),
(0, 'Marliac', 'France', 'Europe', 'FRMP1350', 0),
(0, 'Marliens', 'France', 'Europe', 'FRBO0738', 0),
(0, 'Marlieux', 'France', 'Europe', 'FRRA1064', 0),
(0, 'Marlioz', 'France', 'Europe', 'FRRA1065', 0),
(0, 'Marly', 'France', 'Europe', 'FRXX2173', 0),
(0, 'Marly', 'France', 'Europe', 'FRXX3541', 0),
(0, 'Marly-Gomont', 'France', 'Europe', 'FRPI1032', 0),
(0, 'Marly-la-Ville', 'France', 'Europe', 'FRXX5971', 0),
(0, 'Marly-le-Roi', 'France', 'Europe', 'FRXX2823', 0),
(0, 'Marly-sous-Issy', 'France', 'Europe', 'FRXX1975', 0),
(0, 'Marly-sur-Arroux', 'France', 'Europe', 'FRBO0739', 0),
(0, 'Marmagne', 'France', 'Europe', 'FRBO0740', 0),
(0, 'Marmagne', 'France', 'Europe', 'FRBO0741', 0),
(0, 'Marmagne', 'France', 'Europe', 'FRCE0647', 0),
(0, 'Marmande', 'France', 'Europe', 'FRXX0326', 0),
(0, 'Marmanhac', 'France', 'Europe', 'FRAU0455', 0),
(0, 'Marmeaux', 'France', 'Europe', 'FRBO0742', 0),
(0, 'Marmesse', 'France', 'Europe', 'FRCA0859', 0),
(0, 'Marminiac', 'France', 'Europe', 'FRMP1351', 0),
(0, 'Notre-Dame-de-Courson', 'France', 'Europe', 'FRBN0939', 0),
(0, 'Notre-Dame-de-Fresnay', 'France', 'Europe', 'FRBN0940', 0),
(0, 'Notre-Dame-de-Grace', 'France', 'Europe', 'FRPL0639', 0),
(0, 'Notre-Dame-de-Gravenchon', 'France', 'Europe', 'FRHN0631', 0),
(0, 'Notre-Dame-de-l`Isle', 'France', 'Europe', 'FRHN0632', 0),
(0, 'Notre-Dame-de-l`Osier', 'France', 'Europe', 'FRRA1258', 0),
(0, 'Notre-Dame-de-la-Rouviere', 'France', 'Europe', 'FRLR0560', 0),
(0, 'Notre-Dame-de-Livaye', 'France', 'Europe', 'FRBN0941', 0),
(0, 'Notre-Dame-de-Livoye', 'France', 'Europe', 'FRBN0942', 0),
(0, 'Notre-Dame-de-Londres', 'France', 'Europe', 'FRLR0559', 0),
(0, 'Notre-Dame-de-Mesage', 'France', 'Europe', 'FRRA1257', 0),
(0, 'Notre-Dame-de-Monts', 'France', 'Europe', 'FRXX3044', 0),
(0, 'Notre-Dame-de-Riez', 'France', 'Europe', 'FRPL0640', 0),
(0, 'Notre-Dame-de-Sanilhac', 'France', 'Europe', 'FRXX6157', 0),
(0, 'Notre-Dame-de-Vaulx', 'France', 'Europe', 'FRXX1244', 0),
(0, 'Notre-Dame-des-Landes', 'France', 'Europe', 'FRXX6410', 0),
(0, 'Notre-Dame-des-Langueurs', 'France', 'Europe', 'FRPL0641', 0),
(0, 'Notre-Dame-des-Millieres', 'France', 'Europe', 'FRRA1259', 0),
(0, 'Notre-Dame-du-Bec', 'France', 'Europe', 'FRHN0633', 0),
(0, 'Notre-Dame-du-Cruet', 'France', 'Europe', 'FRRA1260', 0),
(0, 'Notre-Dame-du-Guildo', 'France', 'Europe', 'FRBR0356', 0),
(0, 'Notre-Dame-du-Hamel', 'France', 'Europe', 'FRHN0634', 0),
(0, 'Notre-Dame-du-Parc', 'France', 'Europe', 'FRHN0635', 0),
(0, 'Notre-Dame-du-Pe', 'France', 'Europe', 'FRXX3734', 0),
(0, 'Notre-Dame-du-Pre', 'France', 'Europe', 'FRRA1261', 0),
(0, 'Notre-Dame-du-Rocher', 'France', 'Europe', 'FRBN0943', 0),
(0, 'Notre-Dame-du-Touchet', 'France', 'Europe', 'FRXX3614', 0),
(0, 'Nottonville', 'France', 'Europe', 'FRCE0805', 0),
(0, 'Nouaille-Maupertuis', 'France', 'Europe', 'FRXX1454', 0),
(0, 'Nouainville', 'France', 'Europe', 'FRBN0944', 0),
(0, 'Nouan-le-Fuzelier', 'France', 'Europe', 'FRXX2944', 0),
(0, 'Nouan-sur-Loire', 'France', 'Europe', 'FRCE0806', 0),
(0, 'Nouans', 'France', 'Europe', 'FRPL0642', 0),
(0, 'Nouans-les-Fontaines', 'France', 'Europe', 'FRXX5883', 0),
(0, 'Nouart', 'France', 'Europe', 'FRCA1010', 0),
(0, 'Nouatre', 'France', 'Europe', 'FRCE0807', 0),
(0, 'Noueilles', 'France', 'Europe', 'FRMP1638', 0),
(0, 'Nougaroulet', 'France', 'Europe', 'FRMP1639', 0),
(0, 'Nouhant', 'France', 'Europe', 'FRLI0313', 0),
(0, 'Nouic', 'France', 'Europe', 'FRLI0314', 0),
(0, 'Nouilhan', 'France', 'Europe', 'FRMP1640', 0),
(0, 'Nouillonpont', 'France', 'Europe', 'FRLO1181', 0),
(0, 'Nouilly', 'France', 'Europe', 'FRLO1182', 0),
(0, 'Noulens', 'France', 'Europe', 'FRMP1641', 0),
(0, 'Noumea', 'France', 'Europe', 'FRXX7934', 0),
(0, 'Nourard-le-Franc', 'France', 'Europe', 'FRPI1213', 0),
(0, 'Nourray', 'France', 'Europe', 'FRCE0808', 0),
(0, 'Nousse', 'France', 'Europe', 'FRAQ1056', 0),
(0, 'Nousseviller-les-Bitche', 'France', 'Europe', 'FRLO1183', 0),
(0, 'Nousseviller-Saint-Nabor', 'France', 'Europe', 'FRXX1391', 0),
(0, 'Nousty', 'France', 'Europe', 'FRAQ1057', 0),
(0, 'Nouvelle-Eglise', 'France', 'Europe', 'FRNC0676', 0),
(0, 'Nouvion', 'France', 'Europe', 'FRXX2924', 0),
(0, 'Nouvion-et-Catillon', 'France', 'Europe', 'FRPI1214', 0),
(0, 'Nouvion-le-Comte', 'France', 'Europe', 'FRXX1012', 0),
(0, 'Nouvion-le-Vineux', 'France', 'Europe', 'FRPI1215', 0),
(0, 'Nouvion-sur-Meuse', 'France', 'Europe', 'FRXX2495', 0),
(0, 'Nouvoitou', 'France', 'Europe', 'FRXX1648', 0),
(0, 'Nouvron-Vingre', 'France', 'Europe', 'FRPI1216', 0),
(0, 'Nouzerines', 'France', 'Europe', 'FRLI0315', 0),
(0, 'Nouzerolles', 'France', 'Europe', 'FRLI0316', 0),
(0, 'Nouziers', 'France', 'Europe', 'FRLI0317', 0),
(0, 'Nouzilly', 'France', 'Europe', 'FRCE0809', 0),
(0, 'Nouzonville', 'France', 'Europe', 'FRXX4833', 0),
(0, 'Novacelles', 'France', 'Europe', 'FRAU0541', 0),
(0, 'Novalaise', 'France', 'Europe', 'FRXX4235', 0),
(0, 'Novale', 'France', 'Europe', 'FRCO0118', 0),
(0, 'Noveant-sur-Moselle', 'France', 'Europe', 'FRXX2843', 0),
(0, 'Novel', 'France', 'Europe', 'FRRA1262', 0),
(0, 'Novella', 'France', 'Europe', 'FRXX5237', 0),
(0, 'Noves', 'France', 'Europe', 'FRXX6194', 0),
(0, 'Noviant-aux-Pres', 'France', 'Europe', 'FRLO1184', 0),
(0, 'Novillard', 'France', 'Europe', 'FRXX4549', 0),
(0, 'Novillars', 'France', 'Europe', 'FRFC0990', 0),
(0, 'Novillers', 'France', 'Europe', 'FRPI1217', 0),
(0, 'Novion-Porcien', 'France', 'Europe', 'FRCA1011', 0),
(0, 'Novy-Chevrieres', 'France', 'Europe', 'FRCA1012', 0),
(0, 'Noyal', 'France', 'Europe', 'FRBR0357', 0),
(0, 'Noyal-Chatillon-sur-Seiche', 'France', 'Europe', 'FRBR0358', 0),
(0, 'Noyal-Muzillac', 'France', 'Europe', 'FRBR0359', 0),
(0, 'Pierre-la-Treiche', 'France', 'Europe', 'FRLO1249', 0),
(0, 'Pierre-Levee', 'France', 'Europe', 'FRIF0470', 0),
(0, 'Pierre-Morains', 'France', 'Europe', 'FRCA1080', 0),
(0, 'Pierre-Percee', 'France', 'Europe', 'FRLO1248', 0),
(0, 'Pierre-Perthuis', 'France', 'Europe', 'FRBO0961', 0),
(0, 'Pierreclos', 'France', 'Europe', 'FRBO0963', 0),
(0, 'Pierrecourt', 'France', 'Europe', 'FRFC1048', 0),
(0, 'Pierrecourt', 'France', 'Europe', 'FRHN0660', 0),
(0, 'Pierrefeu', 'France', 'Europe', 'FRPA0432', 0),
(0, 'Pierrefeu-du-Var', 'France', 'Europe', 'FRXX5024', 0),
(0, 'Pierrefiche', 'France', 'Europe', 'FRLR0606', 0),
(0, 'Pierrefiche', 'France', 'Europe', 'FRMP1734', 0),
(0, 'Pierrefiques', 'France', 'Europe', 'FRHN0661', 0),
(0, 'Pierrefitte', 'France', 'Europe', 'FRLO1250', 0),
(0, 'Pierrefitte', 'France', 'Europe', 'FRPC0736', 0),
(0, 'Pierrefitte', 'France', 'Europe', 'FRXX6204', 0),
(0, 'Pierrefitte-en-Auge', 'France', 'Europe', 'FRBN0984', 0),
(0, 'Pierrefitte-en-Beauvaisis', 'France', 'Europe', 'FRPI1289', 0),
(0, 'Pierrefitte-en-Cinglais', 'France', 'Europe', 'FRXX4751', 0),
(0, 'Pierrefitte-es-Bois', 'France', 'Europe', 'FRCE0872', 0),
(0, 'Pierrefitte-Nestalas', 'France', 'Europe', 'FRXX4186', 0),
(0, 'Pierrefitte-sur-Aire', 'France', 'Europe', 'FRXX4445', 0),
(0, 'Pierrefitte-sur-Loire', 'France', 'Europe', 'FRAU0573', 0),
(0, 'Pierrefitte-sur-Sauldre', 'France', 'Europe', 'FRCE0873', 0),
(0, 'Pierrefitte-sur-Seine', 'France', 'Europe', 'FRXX2984', 0),
(0, 'Pierrefonds', 'France', 'Europe', 'FRXX5011', 0),
(0, 'Pierrefontaine-les-Blamont', 'France', 'Europe', 'FRFC1049', 0),
(0, 'Pierrefontaine-les-Varans', 'France', 'Europe', 'FRXX2456', 0),
(0, 'Pierrefontaines', 'France', 'Europe', 'FRCA1081', 0),
(0, 'Pierrefort', 'France', 'Europe', 'FRAU0574', 0),
(0, 'Pierregot', 'France', 'Europe', 'FRPI1290', 0),
(0, 'Pierrelatte', 'France', 'Europe', 'FRXX1849', 0),
(0, 'Pierrelaye', 'France', 'Europe', 'FRXX3128', 0),
(0, 'Pierrelongue', 'France', 'Europe', 'FRRA1333', 0),
(0, 'Pierremande', 'France', 'Europe', 'FRPI1291', 0),
(0, 'Pierremont', 'France', 'Europe', 'FRNC0709', 0),
(0, 'Pierremont-sur-Amance', 'France', 'Europe', 'FRCA1082', 0),
(0, 'Pierrepont', 'France', 'Europe', 'FRBN0985', 0),
(0, 'Pierrepont', 'France', 'Europe', 'FRLO1251', 0),
(0, 'Pierrepont', 'France', 'Europe', 'FRPI1292', 0),
(0, 'Pierrepont-sur-Avre', 'France', 'Europe', 'FRXX6648', 0),
(0, 'Pierrepont-sur-l`Arentele', 'France', 'Europe', 'FRLO1252', 0),
(0, 'Pierrerue', 'France', 'Europe', 'FRLR0607', 0),
(0, 'Pierrerue', 'France', 'Europe', 'FRPA0433', 0),
(0, 'Pierres', 'France', 'Europe', 'FRBN0986', 0),
(0, 'Pierres', 'France', 'Europe', 'FRCE0874', 0),
(0, 'Pierreval', 'France', 'Europe', 'FRHN0662', 0),
(0, 'Pierrevert', 'France', 'Europe', 'FRXX6793', 0),
(0, 'Pierreville', 'France', 'Europe', 'FRBN0987', 0),
(0, 'Pierreville', 'France', 'Europe', 'FRLO1253', 0),
(0, 'Pierrevillers', 'France', 'Europe', 'FRLO1254', 0),
(0, 'Pierric', 'France', 'Europe', 'FRPL0675', 0),
(0, 'Pierry', 'France', 'Europe', 'FRCA1083', 0),
(0, 'Pietra-di-Verde', 'France', 'Europe', 'FRCO0148', 0),
(0, 'Pietracorbara', 'France', 'Europe', 'FRCO0149', 0),
(0, 'Pietralba', 'France', 'Europe', 'FRCO0150', 0),
(0, 'Pietranera', 'France', 'Europe', 'FRCO0151', 0),
(0, 'Pietrapola', 'France', 'Europe', 'FRXX4827', 0),
(0, 'Pietraserena', 'France', 'Europe', 'FRCO0152', 0),
(0, 'Pietricaggio', 'France', 'Europe', 'FRCO0153', 0),
(0, 'Pietrosella', 'France', 'Europe', 'FRXX6209', 0),
(0, 'Pietroso', 'France', 'Europe', 'FRCO0154', 0),
(0, 'Piets-Plasence-Moustrou', 'France', 'Europe', 'FRAQ1121', 0),
(0, 'Pieusse', 'France', 'Europe', 'FRLR0608', 0),
(0, 'Pieve', 'France', 'Europe', 'FRCO0155', 0),
(0, 'Piffonds', 'France', 'Europe', 'FRBO0964', 0),
(0, 'Pigeon', 'France', 'Europe', 'FRXX7762', 0),
(0, 'Pigerolles', 'France', 'Europe', 'FRLI0334', 0),
(0, 'Pigna', 'France', 'Europe', 'FRCO0156', 0),
(0, 'Pignan', 'France', 'Europe', 'FRLR0609', 0),
(0, 'Pignans', 'France', 'Europe', 'FRXX5030', 0),
(0, 'Pignicourt', 'France', 'Europe', 'FRPI1293', 0),
(0, 'Pignols', 'France', 'Europe', 'FRAU0575', 0),
(0, 'Pigny', 'France', 'Europe', 'FRCE0875', 0),
(0, 'Pihem', 'France', 'Europe', 'FRNC0710', 0),
(0, 'Pihen-les-Guines', 'France', 'Europe', 'FRNC0711', 0),
(0, 'Pila-Canale', 'France', 'Europe', 'FRCO0157', 0),
(0, 'Pillac', 'France', 'Europe', 'FRPC0737', 0),
(0, 'Pillemoine', 'France', 'Europe', 'FRFC1050', 0),
(0, 'Pillon', 'France', 'Europe', 'FRLO1255', 0),
(0, 'Riverenert', 'France', 'Europe', 'FRMP1865', 0),
(0, 'Riverie', 'France', 'Europe', 'FRRA1445', 0),
(0, 'Rivery', 'France', 'Europe', 'FRXX6645', 0),
(0, 'Rives', 'France', 'Europe', 'FRAQ1210', 0),
(0, 'Rives', 'France', 'Europe', 'FRRA1446', 0),
(0, 'Rivesaltes', 'France', 'Europe', 'FRXX4980', 0),
(0, 'Riviere', 'France', 'Europe', 'FRCE0943', 0),
(0, 'Riviere', 'France', 'Europe', 'FRXX1251', 0),
(0, 'Riviere-les-Fosses', 'France', 'Europe', 'FRCA1190', 0),
(0, 'Riviere-Pilote', 'France', 'Europe', 'FRXX7741', 0),
(0, 'Riviere-Saas-et-Gourby', 'France', 'Europe', 'FRAQ1211', 0),
(0, 'Riviere-Salee', 'France', 'Europe', 'FRXX7745', 0),
(0, 'Riviere-sur-Tarn', 'France', 'Europe', 'FRXX1741', 0),
(0, 'Rivieres', 'France', 'Europe', 'FRLR0679', 0),
(0, 'Rivieres', 'France', 'Europe', 'FRMP1866', 0),
(0, 'Rivieres', 'France', 'Europe', 'FRPC0802', 0),
(0, 'Rivieres-le-Bois', 'France', 'Europe', 'FRXX6804', 0),
(0, 'Riville', 'France', 'Europe', 'FRHN0706', 0),
(0, 'Rivolet', 'France', 'Europe', 'FRRA1447', 0),
(0, 'Rix', 'France', 'Europe', 'FRBO1039', 0),
(0, 'Rix', 'France', 'Europe', 'FRFC1143', 0),
(0, 'Rixheim', 'France', 'Europe', 'FRXX5813', 0),
(0, 'Rizaucourt-Buchey', 'France', 'Europe', 'FRCA1191', 0),
(0, 'Roaillan', 'France', 'Europe', 'FRAQ1212', 0),
(0, 'Roaix', 'France', 'Europe', 'FRPA0484', 0),
(0, 'Roanne', 'France', 'Europe', 'FRXX0082', 0),
(0, 'Roannes-Saint-Mary', 'France', 'Europe', 'FRAU0616', 0),
(0, 'Robecourt', 'France', 'Europe', 'FRLO1369', 0),
(0, 'Robecq', 'France', 'Europe', 'FRNC0778', 0),
(0, 'Robehomme', 'France', 'Europe', 'FRBN1051', 0),
(0, 'Robersart', 'France', 'Europe', 'FRNC0779', 0),
(0, 'Robert-Espagne', 'France', 'Europe', 'FRLO1370', 0),
(0, 'Robert-Magny-Laneuville-a-Remy', 'France', 'Europe', 'FRCA1192', 0),
(0, 'Robertot', 'France', 'Europe', 'FRHN0707', 0),
(0, 'Roberval', 'France', 'Europe', 'FRPI1403', 0),
(0, 'Robiac-Rochessadoule', 'France', 'Europe', 'FRLR0680', 0),
(0, 'Robion', 'France', 'Europe', 'FRXX3788', 0),
(0, 'Rocamadour', 'France', 'Europe', 'FRMP1867', 0),
(0, 'Rocbaron', 'France', 'Europe', 'FRPA0485', 0),
(0, 'Roce', 'France', 'Europe', 'FRCE0944', 0),
(0, 'Roche', 'France', 'Europe', 'FRXX0258', 0),
(0, 'Roche-Charles-la-Mayrand', 'France', 'Europe', 'FRAU0617', 0),
(0, 'Roche-d`Agoux', 'France', 'Europe', 'FRAU0618', 0),
(0, 'Roche-en-Regnier', 'France', 'Europe', 'FRXX1926', 0),
(0, 'Roche-et-Raucourt', 'France', 'Europe', 'FRXX6743', 0),
(0, 'Roche-la-Moliere', 'France', 'Europe', 'FRRA1449', 0),
(0, 'Roche-le-Peyroux', 'France', 'Europe', 'FRXX5220', 0),
(0, 'Roche-les-Clerval', 'France', 'Europe', 'FRFC1144', 0),
(0, 'Roche-lez-Beaupre', 'France', 'Europe', 'FRXX1782', 0),
(0, 'Roche-Saint-Secret-Beconne', 'France', 'Europe', 'FRRA1448', 0),
(0, 'Roche-sur-Linotte-et-Sorans-les-Cordiers', 'France', 'Europe', 'FRFC1145', 0),
(0, 'Rochebaudin', 'France', 'Europe', 'FRRA1450', 0),
(0, 'Rochebrune', 'France', 'Europe', 'FRRA1451', 0),
(0, 'Rochebrune', 'France', 'Europe', 'FRXX4673', 0),
(0, 'Rochechinard', 'France', 'Europe', 'FRRA1452', 0),
(0, 'Rochechouart', 'France', 'Europe', 'FRXX6044', 0),
(0, 'Rochecolombe', 'France', 'Europe', 'FRRA1453', 0),
(0, 'Rochecorbon', 'France', 'Europe', 'FRCE0945', 0),
(0, 'Rochefort', 'France', 'Europe', 'FRRA1454', 0),
(0, 'Rochefort', 'France', 'Europe', 'FRRA1455', 0),
(0, 'Rochefort', 'France', 'Europe', 'FRXX0083', 0),
(0, 'Rochefort-du-Gard', 'France', 'Europe', 'FRXX6268', 0),
(0, 'Rochefort-en-Terre', 'France', 'Europe', 'FRBR0497', 0),
(0, 'Rochefort-en-Valdaine', 'France', 'Europe', 'FRRA1456', 0),
(0, 'Rochefort-en-Yvelines', 'France', 'Europe', 'FRIF0501', 0),
(0, 'Rochefort-Montagne', 'France', 'Europe', 'FRAU0619', 0),
(0, 'Rochefort-Samson', 'France', 'Europe', 'FRXX5566', 0),
(0, 'Rochefort-sur-Brevon', 'France', 'Europe', 'FRBO1040', 0),
(0, 'Rochefort-sur-la-Cote', 'France', 'Europe', 'FRCA1193', 0),
(0, 'Rochefort-sur-Loire', 'France', 'Europe', 'FRXX3135', 0),
(0, 'Rochefort-sur-Nenon', 'France', 'Europe', 'FRXX5892', 0),
(0, 'Rochefourchat', 'France', 'Europe', 'FRRA1457', 0),
(0, 'Rochegude', 'France', 'Europe', 'FRLR0681', 0),
(0, 'Rochegude', 'France', 'Europe', 'FRRA1458', 0),
(0, 'Rochejean', 'France', 'Europe', 'FRFC1146', 0),
(0, 'Rochemaure', 'France', 'Europe', 'FRRA1459', 0),
(0, 'Rochepaule', 'France', 'Europe', 'FRRA1460', 0),
(0, 'Rocher', 'France', 'Europe', 'FRRA1461', 0),
(0, 'Rocher de l` Homme', 'France', 'Europe', 'FRXX0259', 0),
(0, 'Roches', 'France', 'Europe', 'FRCE0946', 0),
(0, 'Saint-Brieuc-des-Iffs', 'France', 'Europe', 'FRBR0530', 0),
(0, 'Saint-Bris-des-Bois', 'France', 'Europe', 'FRPC0835', 0),
(0, 'Saint-Bris-le-Vineux', 'France', 'Europe', 'FRXX2287', 0),
(0, 'Saint-Brisson', 'France', 'Europe', 'FRBO1097', 0),
(0, 'Saint-Brisson-sur-Loire', 'France', 'Europe', 'FRCE0989', 0),
(0, 'Saint-Broing', 'France', 'Europe', 'FRFC1177', 0),
(0, 'Saint-Broing-les-Moines', 'France', 'Europe', 'FRBO1098', 0),
(0, 'Saint-Broingt-le-Bois', 'France', 'Europe', 'FRCA1233', 0),
(0, 'Saint-Broingt-les-Fosses', 'France', 'Europe', 'FRCA1234', 0),
(0, 'Saint-Broladre', 'France', 'Europe', 'FRBR0531', 0),
(0, 'Saint-Bueil', 'France', 'Europe', 'FRRA1556', 0),
(0, 'Saint-Calais', 'France', 'Europe', 'FRXX0347', 0),
(0, 'Saint-Calais-du-Desert', 'France', 'Europe', 'FRPL0759', 0),
(0, 'Saint-Calez-en-Saosnois', 'France', 'Europe', 'FRPL0760', 0),
(0, 'Saint-Cannat', 'France', 'Europe', 'FRXX4750', 0),
(0, 'Saint-Caprais', 'France', 'Europe', 'FRAU0657', 0),
(0, 'Saint-Caprais', 'France', 'Europe', 'FRCE0990', 0),
(0, 'Saint-Caprais', 'France', 'Europe', 'FRXX1242', 0),
(0, 'Saint-Caprais-de-Blaye', 'France', 'Europe', 'FRAQ1269', 0),
(0, 'Saint-Caprais-de-Bordeaux', 'France', 'Europe', 'FRXX2753', 0),
(0, 'Saint-Caprais-de-Lerm', 'France', 'Europe', 'FRAQ1270', 0),
(0, 'Saint-Capraise-d`Eymet', 'France', 'Europe', 'FRAQ1271', 0),
(0, 'Saint-Capraise-de-Lalinde', 'France', 'Europe', 'FRAQ1272', 0),
(0, 'Saint-Caradec', 'France', 'Europe', 'FRBR0532', 0),
(0, 'Saint-Caradec-Tregomel', 'France', 'Europe', 'FRXX2902', 0),
(0, 'Saint-Carne', 'France', 'Europe', 'FRBR0533', 0),
(0, 'Saint-Carreuc', 'France', 'Europe', 'FRBR0534', 0),
(0, 'Saint-Cassien', 'France', 'Europe', 'FRAQ1273', 0),
(0, 'Saint-Cassien', 'France', 'Europe', 'FRPC0836', 0),
(0, 'Saint-Cassien', 'France', 'Europe', 'FRXX5679', 0),
(0, 'Saint-Cassin', 'France', 'Europe', 'FRRA1557', 0),
(0, 'Saint-Cast-le-Guildo', 'France', 'Europe', 'FRXX2486', 0),
(0, 'Saint-Castin', 'France', 'Europe', 'FRAQ1274', 0),
(0, 'Saint-Celerin', 'France', 'Europe', 'FRPL0761', 0),
(0, 'Saint-Cenere', 'France', 'Europe', 'FRPL0762', 0),
(0, 'Saint-Ceneri-le-Gerei', 'France', 'Europe', 'FRBN1105', 0),
(0, 'Saint-Ceols', 'France', 'Europe', 'FRCE0991', 0),
(0, 'Saint-Cere', 'France', 'Europe', 'FRXX3115', 0),
(0, 'Saint-Cergues', 'France', 'Europe', 'FRRA1558', 0),
(0, 'Saint-Cernin', 'France', 'Europe', 'FRMP1948', 0),
(0, 'Saint-Cernin', 'France', 'Europe', 'FRXX5465', 0),
(0, 'Saint-Cernin-de-l`Herm', 'France', 'Europe', 'FRAQ1276', 0),
(0, 'Saint-Cernin-de-Labarde', 'France', 'Europe', 'FRAQ1275', 0),
(0, 'Saint-Cernin-de-Larche', 'France', 'Europe', 'FRLI0386', 0),
(0, 'Saint-Cernin-de-Reillac', 'France', 'Europe', 'FRXX1756', 0),
(0, 'Saint-Cesaire', 'France', 'Europe', 'FRPC0837', 0),
(0, 'Saint-Cesaire-de-Gauzignan', 'France', 'Europe', 'FRLR0723', 0),
(0, 'Saint-Cezaire-sur-Siagne', 'France', 'Europe', 'FRXX1515', 0),
(0, 'Saint-Cezert', 'France', 'Europe', 'FRMP1949', 0),
(0, 'Saint-Chabrais', 'France', 'Europe', 'FRLI0387', 0),
(0, 'Saint-Chaffrey', 'France', 'Europe', 'FRXX2408', 0),
(0, 'Saint-Chamant', 'France', 'Europe', 'FRAU0658', 0),
(0, 'Saint-Chamant', 'France', 'Europe', 'FRLI0388', 0),
(0, 'Saint-Chamarand', 'France', 'Europe', 'FRMP1950', 0),
(0, 'Saint-Chamas', 'France', 'Europe', 'FRXX1083', 0),
(0, 'Saint-Chamassy', 'France', 'Europe', 'FRAQ1277', 0),
(0, 'Saint-Chamond', 'France', 'Europe', 'FRXX2825', 0),
(0, 'Saint-Champ', 'France', 'Europe', 'FRRA1559', 0),
(0, 'Saint-Chaptes', 'France', 'Europe', 'FRPA0512', 0),
(0, 'Saint-Charles-de-Percy', 'France', 'Europe', 'FRBN1106', 0),
(0, 'Saint-Charles-la-Foret', 'France', 'Europe', 'FRPL0763', 0),
(0, 'Saint-Chartier', 'France', 'Europe', 'FRCE0992', 0),
(0, 'Saint-Chartres', 'France', 'Europe', 'FRPC0838', 0),
(0, 'Saint-Chef', 'France', 'Europe', 'FRXX5034', 0),
(0, 'Saint-Chels', 'France', 'Europe', 'FRMP1951', 0),
(0, 'Saint-Chely-d`Apcher', 'France', 'Europe', 'FRLR0724', 0),
(0, 'Saint-Chely-d`Aubrac', 'France', 'Europe', 'FRMP1952', 0),
(0, 'Saint-Cheron', 'France', 'Europe', 'FRCA1235', 0),
(0, 'Saint-Cheron', 'France', 'Europe', 'FRIF0523', 0),
(0, 'Saint-Cheron-des-Champs', 'France', 'Europe', 'FRCE0993', 0),
(0, 'Saint-Chinian', 'France', 'Europe', 'FRXX5131', 0),
(0, 'Saint-Christ-Briost', 'France', 'Europe', 'FRXX2203', 0),
(0, 'Saint-Christaud', 'France', 'Europe', 'FRMP1953', 0),
(0, 'Saint-Christaud', 'France', 'Europe', 'FRMP1954', 0),
(0, 'Saint-Christo-en-Jarez', 'France', 'Europe', 'FRXX4178', 0),
(0, 'Saint-Christol', 'France', 'Europe', 'FRLR0725', 0),
(0, 'Saint-Christol', 'France', 'Europe', 'FRPA0513', 0),
(0, 'Saint-Christol', 'France', 'Europe', 'FRRA1560', 0),
(0, 'Saint-Christol-de-Rodieres', 'France', 'Europe', 'FRPA0514', 0),
(0, 'Saint-Christol-les-Ales', 'France', 'Europe', 'FRXX4840', 0),
(0, 'Tivernon', 'France', 'Europe', 'FRCE1229', 0),
(0, 'Tiviers', 'France', 'Europe', 'FRAU0860', 0),
(0, 'Tivolaggio', 'France', 'Europe', 'FRCO0213', 0),
(0, 'Tizac-de-Curton', 'France', 'Europe', 'FRAQ1678', 0),
(0, 'Tizac-de-Lapouyade', 'France', 'Europe', 'FRAQ1679', 0),
(0, 'Toahotu', 'France', 'Europe', 'FRXX7870', 0),
(0, 'Tocane-Saint-Apre', 'France', 'Europe', 'FRXX6338', 0),
(0, 'Tocqueville', 'France', 'Europe', 'FRBN1402', 0),
(0, 'Tocqueville', 'France', 'Europe', 'FRHN0938', 0),
(0, 'Tocqueville-en-Caux', 'France', 'Europe', 'FRHN0939', 0),
(0, 'Tocqueville-les-Murs', 'France', 'Europe', 'FRHN0940', 0),
(0, 'Tocqueville-sur-Eu', 'France', 'Europe', 'FRHN0941', 0),
(0, 'Toeufles', 'France', 'Europe', 'FRPI1625', 0),
(0, 'Toges', 'France', 'Europe', 'FRCA1450', 0),
(0, 'Togny-aux-Boeufs', 'France', 'Europe', 'FRCA1451', 0),
(0, 'Tolla', 'France', 'Europe', 'FRCO0214', 0),
(0, 'Tollaincourt', 'France', 'Europe', 'FRLO1605', 0),
(0, 'Tollent', 'France', 'Europe', 'FRNC0915', 0),
(0, 'Tollevast', 'France', 'Europe', 'FRBN1403', 0),
(0, 'Tombeboeuf', 'France', 'Europe', 'FRAQ1680', 0),
(0, 'Tomblaine', 'France', 'Europe', 'FRXX2283', 0),
(0, 'Tomino', 'France', 'Europe', 'FRCO0215', 0),
(0, 'Tonnac', 'France', 'Europe', 'FRMP2334', 0),
(0, 'Tonnay-Boutonne', 'France', 'Europe', 'FRPC1096', 0),
(0, 'Tonnay-Charente', 'France', 'Europe', 'FRXX4771', 0),
(0, 'Tonneins', 'France', 'Europe', 'FRXX0322', 0),
(0, 'Tonnerre', 'France', 'Europe', 'FRXX0359', 0),
(0, 'Tonneville', 'France', 'Europe', 'FRBN1404', 0),
(0, 'Tonnoy', 'France', 'Europe', 'FRLO1606', 0),
(0, 'Tonquedec', 'France', 'Europe', 'FRXX1038', 0),
(0, 'Tontoua', 'France', 'Europe', 'FRXX7954', 0),
(0, 'Topla', 'France', 'Europe', 'FRXX0134', 0),
(0, 'Torce', 'France', 'Europe', 'FRBR0706', 0),
(0, 'Torce-en-Vallee', 'France', 'Europe', 'FRPL1008', 0),
(0, 'Torce-Viviers-en-Charnie', 'France', 'Europe', 'FRPL1007', 0),
(0, 'Torcenay', 'France', 'Europe', 'FRCA1452', 0),
(0, 'Torchamp', 'France', 'Europe', 'FRBN1405', 0),
(0, 'Torchefelon', 'France', 'Europe', 'FRRA1991', 0),
(0, 'Torcheville', 'France', 'Europe', 'FRLO1607', 0),
(0, 'Torcieu', 'France', 'Europe', 'FRRA1992', 0),
(0, 'Torcy', 'France', 'Europe', 'FRBO1391', 0),
(0, 'Torcy', 'France', 'Europe', 'FRNC0916', 0),
(0, 'Torcy', 'France', 'Europe', 'FRXX4112', 0),
(0, 'Torcy-en-Valois', 'France', 'Europe', 'FRPI1626', 0),
(0, 'Torcy-et-Pouligny', 'France', 'Europe', 'FRBO1392', 0),
(0, 'Torcy-le-Grand', 'France', 'Europe', 'FRCA1453', 0),
(0, 'Torcy-le-Grand', 'France', 'Europe', 'FRHN0942', 0),
(0, 'Torcy-le-Petit', 'France', 'Europe', 'FRCA1454', 0),
(0, 'Torcy-le-Petit', 'France', 'Europe', 'FRHN0943', 0),
(0, 'Torderes', 'France', 'Europe', 'FRLR0898', 0),
(0, 'Tordouet', 'France', 'Europe', 'FRBN1406', 0),
(0, 'Torfou', 'France', 'Europe', 'FRIF0602', 0),
(0, 'Torfou', 'France', 'Europe', 'FRXX2014', 0),
(0, 'Torigni-sur-Vire', 'France', 'Europe', 'FRXX2137', 0),
(0, 'Tornac', 'France', 'Europe', 'FRLR0899', 0),
(0, 'Tornay', 'France', 'Europe', 'FRCA1455', 0),
(0, 'Torpes', 'France', 'Europe', 'FRBO1393', 0),
(0, 'Torpes', 'France', 'Europe', 'FRFC1289', 0),
(0, 'Torreilles', 'France', 'Europe', 'FRXX4584', 0),
(0, 'Torrent des Encombres', 'France', 'Europe', 'FRXX0264', 0),
(0, 'Torsac', 'France', 'Europe', 'FRPC1097', 0),
(0, 'Torsiac', 'France', 'Europe', 'FRAU0861', 0),
(0, 'Tortebesse', 'France', 'Europe', 'FRAU0862', 0),
(0, 'Tortefontaine', 'France', 'Europe', 'FRNC0917', 0),
(0, 'Tortequesne', 'France', 'Europe', 'FRNC0918', 0),
(0, 'Torteron', 'France', 'Europe', 'FRCE1230', 0),
(0, 'Torteval-Quesnay', 'France', 'Europe', 'FRBN1407', 0),
(0, 'Tortezais', 'France', 'Europe', 'FRAU0863', 0),
(0, 'Tortisambert', 'France', 'Europe', 'FRBN1408', 0),
(0, 'Torvilliers', 'France', 'Europe', 'FRCA1456', 0),
(0, 'Torxe', 'France', 'Europe', 'FRPC1098', 0),
(0, 'Tosny', 'France', 'Europe', 'FRHN0944', 0),
(0, 'Tosse', 'France', 'Europe', 'FRAQ1681', 0),
(0, 'Tossiat', 'France', 'Europe', 'FRRA1993', 0),
(0, 'Tostat', 'France', 'Europe', 'FRMP2335', 0),
(0, 'Tostes', 'France', 'Europe', 'FRHN0945', 0),
(0, 'Totainville', 'France', 'Europe', 'FRLO1608', 0),
(0, 'Totes', 'France', 'Europe', 'FRBN1409', 0),
(0, 'Totes', 'France', 'Europe', 'FRHN0946', 0),
(0, 'Touchay', 'France', 'Europe', 'FRCE1231', 0),
(0, 'Vendome', 'France', 'Europe', 'FRXX0346', 0),
(0, 'Vendranges', 'France', 'Europe', 'FRRA2060', 0),
(0, 'Vendrennes', 'France', 'Europe', 'FRPL1036', 0),
(0, 'Vendres', 'France', 'Europe', 'FRLR0936', 0),
(0, 'Vendresse', 'France', 'Europe', 'FRCA1534', 0),
(0, 'Vendresse-Beaulne', 'France', 'Europe', 'FRPI1686', 0),
(0, 'Vendrest', 'France', 'Europe', 'FRIF0623', 0),
(0, 'Venejan', 'France', 'Europe', 'FRPA0681', 0),
(0, 'Venelles', 'France', 'Europe', 'FRXX5485', 0),
(0, 'Venerand', 'France', 'Europe', 'FRPC1131', 0),
(0, 'Venere', 'France', 'Europe', 'FRFC1365', 0),
(0, 'Venerieu', 'France', 'Europe', 'FRRA2061', 0),
(0, 'Venerolles', 'France', 'Europe', 'FRXX1710', 0),
(0, 'Venerque', 'France', 'Europe', 'FRXX2032', 0),
(0, 'Venes', 'France', 'Europe', 'FRMP2420', 0),
(0, 'Venesmes', 'France', 'Europe', 'FRCE1271', 0),
(0, 'Venestanville', 'France', 'Europe', 'FRHN0984', 0),
(0, 'Venette', 'France', 'Europe', 'FRXX4285', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Veneux-les-Sablons', 'France', 'Europe', 'FRXX4113', 0),
(0, 'Veney', 'France', 'Europe', 'FRLO1709', 0),
(0, 'Vengeons', 'France', 'Europe', 'FRBN1461', 0),
(0, 'Venise', 'France', 'Europe', 'FRFC1366', 0),
(0, 'Venisey', 'France', 'Europe', 'FRFC1367', 0),
(0, 'Venissieux', 'France', 'Europe', 'FRXX0105', 0),
(0, 'Venizel', 'France', 'Europe', 'FRPI1687', 0),
(0, 'Venizy', 'France', 'Europe', 'FRBO1458', 0),
(0, 'Vennans', 'France', 'Europe', 'FRFC1368', 0),
(0, 'Vennecy', 'France', 'Europe', 'FRCE1272', 0),
(0, 'Vennes', 'France', 'Europe', 'FRFC1369', 0),
(0, 'Vennezey', 'France', 'Europe', 'FRLO1710', 0),
(0, 'Venon', 'France', 'Europe', 'FRHN0985', 0),
(0, 'Venon', 'France', 'Europe', 'FRRA2062', 0),
(0, 'Venosc', 'France', 'Europe', 'FRXX2940', 0),
(0, 'Venouse', 'France', 'Europe', 'FRBO1459', 0),
(0, 'Venoy', 'France', 'Europe', 'FRXX3818', 0),
(0, 'Vensac', 'France', 'Europe', 'FRAQ1719', 0),
(0, 'Vensat', 'France', 'Europe', 'FRAU0906', 0),
(0, 'Ventabren', 'France', 'Europe', 'FRPA0682', 0),
(0, 'Ventavon', 'France', 'Europe', 'FRPA0683', 0),
(0, 'Ventelay', 'France', 'Europe', 'FRCA1535', 0),
(0, 'Ventenac', 'France', 'Europe', 'FRMP2421', 0),
(0, 'Ventenac-Cabardes', 'France', 'Europe', 'FRXX3959', 0),
(0, 'Ventenac-en-Minervois', 'France', 'Europe', 'FRLR0937', 0),
(0, 'Venterol', 'France', 'Europe', 'FRPA0684', 0),
(0, 'Venterol', 'France', 'Europe', 'FRRA2063', 0),
(0, 'Ventes-Saint-Remy', 'France', 'Europe', 'FRHN0986', 0),
(0, 'Venteuges', 'France', 'Europe', 'FRAU0907', 0),
(0, 'Venteuil', 'France', 'Europe', 'FRCA1536', 0),
(0, 'Venthon', 'France', 'Europe', 'FRRA2064', 0),
(0, 'Ventiseri', 'France', 'Europe', 'FRCO0225', 0),
(0, 'Ventouse', 'France', 'Europe', 'FRPC1132', 0),
(0, 'Ventron', 'France', 'Europe', 'FRXX1552', 0),
(0, 'Venzolasca', 'France', 'Europe', 'FRCO0226', 0),
(0, 'Ver', 'France', 'Europe', 'FRBN1462', 0),
(0, 'Ver-les-Chartres', 'France', 'Europe', 'FRCE1273', 0),
(0, 'Ver-sur-Launette', 'France', 'Europe', 'FRXX5763', 0),
(0, 'Ver-sur-Mer', 'France', 'Europe', 'FRXX1733', 0),
(0, 'Verac', 'France', 'Europe', 'FRAQ1720', 0),
(0, 'Veranne', 'France', 'Europe', 'FRRA2065', 0),
(0, 'Verargues', 'France', 'Europe', 'FRLR0938', 0),
(0, 'Veraza', 'France', 'Europe', 'FRLR0939', 0),
(0, 'Verberie', 'France', 'Europe', 'FRPI1688', 0),
(0, 'Verbiesles', 'France', 'Europe', 'FRCA1537', 0),
(0, 'Vercel-Villedieu-le-Camp', 'France', 'Europe', 'FRXX4731', 0),
(0, 'Verchain-Maugre', 'France', 'Europe', 'FRNC0935', 0),
(0, 'Verchaix', 'France', 'Europe', 'FRRA2066', 0),
(0, 'Verchamp', 'France', 'Europe', 'FRFC1370', 0),
(0, 'Vercheny', 'France', 'Europe', 'FRRA2067', 0),
(0, 'Verchin', 'France', 'Europe', 'FRNC0936', 0),
(0, 'Verchocq', 'France', 'Europe', 'FRNC0937', 0),
(0, 'Vercia', 'France', 'Europe', 'FRFC1371', 0),
(0, 'Verclause', 'France', 'Europe', 'FRRA2068', 0),
(0, 'Vercoiran', 'France', 'Europe', 'FRRA2069', 0),
(0, 'Vercourt', 'France', 'Europe', 'FRPI1689', 0),
(0, 'Verdaches', 'France', 'Europe', 'FRPA0685', 0),
(0, 'Verdalle', 'France', 'Europe', 'FRMP2422', 0),
(0, 'Verdelais', 'France', 'Europe', 'FRAQ1721', 0),
(0, 'Verdelot', 'France', 'Europe', 'FRIF0624', 0),
(0, 'Verdenal', 'France', 'Europe', 'FRLO1711', 0),
(0, 'Verderel-les-Sauqueuse', 'France', 'Europe', 'FRPI1690', 0),
(0, 'Argentre', 'France', 'Europe', 'FRPL0015', 0),
(0, 'Argers', 'France', 'Europe', 'FRCA0034', 0),
(0, 'Arget', 'France', 'Europe', 'FRAQ0049', 0),
(0, 'Argillieres', 'France', 'Europe', 'FRFC0050', 0),
(0, 'Argilliers', 'France', 'Europe', 'FRPA0015', 0),
(0, 'Argilly', 'France', 'Europe', 'FRBO0032', 0),
(0, 'Argis', 'France', 'Europe', 'FRRA0073', 0),
(0, 'Argiusta-Moriccio', 'France', 'Europe', 'FRCO0011', 0),
(0, 'Argoeuves', 'France', 'Europe', 'FRPI0046', 0),
(0, 'Argonay', 'France', 'Europe', 'FRRA0074', 0),
(0, 'Argouges', 'France', 'Europe', 'FRBN0030', 0),
(0, 'Argoules', 'France', 'Europe', 'FRNC0029', 0),
(0, 'Arguel', 'France', 'Europe', 'FRFC0051', 0),
(0, 'Arguel', 'France', 'Europe', 'FRPI0047', 0),
(0, 'Arguenos', 'France', 'Europe', 'FRMP0068', 0),
(0, 'Arifat', 'France', 'Europe', 'FRMP0069', 0),
(0, 'Arignac', 'France', 'Europe', 'FRMP0070', 0),
(0, 'Arinthod', 'France', 'Europe', 'FRFC0052', 0),
(0, 'Arith', 'France', 'Europe', 'FRRA0075', 0),
(0, 'Arjuzanx', 'France', 'Europe', 'FRAQ0050', 0),
(0, 'Arlay', 'France', 'Europe', 'FRFC0053', 0),
(0, 'Arlempdes', 'France', 'Europe', 'FRAU0017', 0),
(0, 'Arlos', 'France', 'Europe', 'FRMP0071', 0),
(0, 'Armaille', 'France', 'Europe', 'FRPL0016', 0),
(0, 'Armancourt', 'France', 'Europe', 'FRPI0048', 0),
(0, 'Armaucourt', 'France', 'Europe', 'FRLO0041', 0),
(0, 'Armbouts-Cappel', 'France', 'Europe', 'FRNC0030', 0),
(0, 'Armeau', 'France', 'Europe', 'FRBO0033', 0),
(0, 'Armenteule', 'France', 'Europe', 'FRMP0072', 0),
(0, 'Armentieux', 'France', 'Europe', 'FRMP0073', 0),
(0, 'Armillac', 'France', 'Europe', 'FRAQ0051', 0),
(0, 'Armissan', 'France', 'Europe', 'FRLR0030', 0),
(0, 'Armix', 'France', 'Europe', 'FRRA0076', 0),
(0, 'Arnac', 'France', 'Europe', 'FRAU0018', 0),
(0, 'Arnage', 'France', 'Europe', 'FRXX0005', 0),
(0, 'Arnancourt', 'France', 'Europe', 'FRCA0035', 0),
(0, 'Arnas', 'France', 'Europe', 'FRRA0077', 0),
(0, 'Arnave', 'France', 'Europe', 'FRMP0074', 0),
(0, 'Arnayon', 'France', 'Europe', 'FRRA0078', 0),
(0, 'Arne', 'France', 'Europe', 'FRMP0075', 0),
(0, 'Arneke', 'France', 'Europe', 'FRNC0031', 0),
(0, 'Arnicourt', 'France', 'Europe', 'FRCA0036', 0),
(0, 'Arnos', 'France', 'Europe', 'FRAQ0052', 0),
(0, 'Aroffe', 'France', 'Europe', 'FRLO0042', 0),
(0, 'Aromas', 'France', 'Europe', 'FRFC0054', 0),
(0, 'Aron', 'France', 'Europe', 'FRPL0017', 0),
(0, 'Arpajon', 'France', 'Europe', 'FRIF0016', 0),
(0, 'Arpavon', 'France', 'Europe', 'FRRA0079', 0),
(0, 'Arpenans', 'France', 'Europe', 'FRFC0055', 0),
(0, 'Arpheuilles', 'France', 'Europe', 'FRCE0022', 0),
(0, 'Arpheuilles', 'France', 'Europe', 'FRCE0023', 0),
(0, 'Arquenay', 'France', 'Europe', 'FRPL0018', 0),
(0, 'Arques', 'France', 'Europe', 'FRLR0031', 0),
(0, 'Arques', 'France', 'Europe', 'FRMP0076', 0),
(0, 'Arques', 'France', 'Europe', 'FRXX4972', 0),
(0, 'Arquettes-en-Val', 'France', 'Europe', 'FRLR0032', 0),
(0, 'Arqueves', 'France', 'Europe', 'FRPI0049', 0),
(0, 'Arrabloy', 'France', 'Europe', 'FRCE0024', 0),
(0, 'Arradon', 'France', 'Europe', 'FRXX2194', 0),
(0, 'Arraincourt', 'France', 'Europe', 'FRLO0043', 0),
(0, 'Arrancourt', 'France', 'Europe', 'FRIF0017', 0),
(0, 'Arrancy', 'France', 'Europe', 'FRPI0050', 0),
(0, 'Arrans', 'France', 'Europe', 'FRBO0034', 0),
(0, 'Arrayou-Lahitte', 'France', 'Europe', 'FRMP0077', 0),
(0, 'Arre', 'France', 'Europe', 'FRLR0033', 0),
(0, 'Arreau', 'France', 'Europe', 'FRXX0543', 0),
(0, 'Arrelles', 'France', 'Europe', 'FRCA0037', 0),
(0, 'Arrembecourt', 'France', 'Europe', 'FRCA0038', 0),
(0, 'Arrenes', 'France', 'Europe', 'FRLI0014', 0),
(0, 'Arrens-Marsous', 'France', 'Europe', 'FRMP0078', 0),
(0, 'Arrentieres', 'France', 'Europe', 'FRCA0039', 0),
(0, 'Arrest', 'France', 'Europe', 'FRXX1510', 0),
(0, 'Arriance', 'France', 'Europe', 'FRLO0044', 0),
(0, 'Arricau-Bordes', 'France', 'Europe', 'FRAQ0053', 0),
(0, 'Arrien', 'France', 'Europe', 'FRAQ0054', 0),
(0, 'Arrigny', 'France', 'Europe', 'FRCA0040', 0),
(0, 'Arronville', 'France', 'Europe', 'FRIF0018', 0),
(0, 'Arroses', 'France', 'Europe', 'FRAQ0055', 0),
(0, 'Arrou', 'France', 'Europe', 'FRCE0025', 0),
(0, 'Arrouede', 'France', 'Europe', 'FRMP0079', 0),
(0, 'Bergbieten', 'France', 'Europe', 'FRAL0023', 0),
(0, 'Bergerac', 'France', 'Europe', 'FRXX0140', 0),
(0, 'Bergeres', 'France', 'Europe', 'FRCA0102', 0),
(0, 'Bergesserin', 'France', 'Europe', 'FRBO0083', 0),
(0, 'Bergheim', 'France', 'Europe', 'FRXX6344', 0),
(0, 'Bergholtz', 'France', 'Europe', 'FRAL0024', 0),
(0, 'Bergicourt', 'France', 'Europe', 'FRPI0135', 0),
(0, 'Bergnicourt', 'France', 'Europe', 'FRCA0103', 0),
(0, 'Bergonne', 'France', 'Europe', 'FRAU0050', 0),
(0, 'Bergouey', 'France', 'Europe', 'FRAQ0148', 0),
(0, 'Bergueneuse', 'France', 'Europe', 'FRNC0102', 0),
(0, 'Berguette', 'France', 'Europe', 'FRNC0103', 0),
(0, 'Berigny', 'France', 'Europe', 'FRBN0081', 0),
(0, 'Berjou', 'France', 'Europe', 'FRBN0082', 0),
(0, 'Berlaimont', 'France', 'Europe', 'FRNC0104', 0),
(0, 'Berlancourt', 'France', 'Europe', 'FRPI0136', 0),
(0, 'Berlancourt', 'France', 'Europe', 'FRPI0137', 0),
(0, 'Berlats', 'France', 'Europe', 'FRMP0239', 0),
(0, 'Berling', 'France', 'Europe', 'FRLO0134', 0),
(0, 'Berlise', 'France', 'Europe', 'FRPI0138', 0),
(0, 'Berlou', 'France', 'Europe', 'FRLR0077', 0),
(0, 'Bermerain', 'France', 'Europe', 'FRNC0105', 0),
(0, 'Bermericourt', 'France', 'Europe', 'FRCA0104', 0),
(0, 'Bermeries', 'France', 'Europe', 'FRNC0106', 0),
(0, 'Bermering', 'France', 'Europe', 'FRLO0135', 0),
(0, 'Bermesnil', 'France', 'Europe', 'FRPI0139', 0),
(0, 'Bermicourt', 'France', 'Europe', 'FRNC0107', 0),
(0, 'Bermont', 'France', 'Europe', 'FRMP0240', 0),
(0, 'Bermonville', 'France', 'Europe', 'FRHN0048', 0),
(0, 'Bernac', 'France', 'Europe', 'FRMP0241', 0),
(0, 'Bernac', 'France', 'Europe', 'FRPC0089', 0),
(0, 'Bernac-Debat', 'France', 'Europe', 'FRMP0242', 0),
(0, 'Bernac-Dessus', 'France', 'Europe', 'FRMP0243', 0),
(0, 'Bernadets', 'France', 'Europe', 'FRAQ0149', 0),
(0, 'Bernardswiller', 'France', 'Europe', 'FRAL0025', 0),
(0, 'Bernardville', 'France', 'Europe', 'FRAL0026', 0),
(0, 'Bernatre', 'France', 'Europe', 'FRPI0140', 0),
(0, 'Bernaville', 'France', 'Europe', 'FRPI0141', 0),
(0, 'Bernay', 'France', 'Europe', 'FRPL0054', 0),
(0, 'Bernay', 'France', 'Europe', 'FRXX0386', 0),
(0, 'Bernay-Saint-Martin', 'France', 'Europe', 'FRPC0090', 0),
(0, 'Bernecourt', 'France', 'Europe', 'FRLO0136', 0),
(0, 'Bernede', 'France', 'Europe', 'FRMP0244', 0),
(0, 'Bernesq', 'France', 'Europe', 'FRBN0083', 0),
(0, 'Berneuil', 'France', 'Europe', 'FRLI0035', 0),
(0, 'Berneuil', 'France', 'Europe', 'FRPC0091', 0),
(0, 'Berneuil', 'France', 'Europe', 'FRPC0092', 0),
(0, 'Berneuil', 'France', 'Europe', 'FRPI0142', 0),
(0, 'Berneville', 'France', 'Europe', 'FRNC0108', 0),
(0, 'Bernex', 'France', 'Europe', 'FRRA0159', 0),
(0, 'Bernienville', 'France', 'Europe', 'FRHN0049', 0),
(0, 'Bernieres', 'France', 'Europe', 'FRHN0050', 0),
(0, 'Bernieres-sur-Mer', 'France', 'Europe', 'FRXX5463', 0),
(0, 'Bernieulles', 'France', 'Europe', 'FRNC0109', 0),
(0, 'Bernin', 'France', 'Europe', 'FRRA0160', 0),
(0, 'Bernis', 'France', 'Europe', 'FRPA0054', 0),
(0, 'Bernolsheim', 'France', 'Europe', 'FRAL0027', 0),
(0, 'Bernon', 'France', 'Europe', 'FRCA0105', 0),
(0, 'Bernos-Beaulac', 'France', 'Europe', 'FRAQ0150', 0),
(0, 'Bernot', 'France', 'Europe', 'FRPI0143', 0),
(0, 'Bernouil', 'France', 'Europe', 'FRBO0084', 0),
(0, 'Bernouville', 'France', 'Europe', 'FRXX2501', 0),
(0, 'Bernwiller', 'France', 'Europe', 'FRAL0028', 0),
(0, 'Berny-Riviere', 'France', 'Europe', 'FRPI0144', 0),
(0, 'Berrac', 'France', 'Europe', 'FRMP0245', 0),
(0, 'Berre-l`Etang', 'France', 'Europe', 'FRXX3995', 0),
(0, 'Berriac', 'France', 'Europe', 'FRLR0078', 0),
(0, 'Berrias-et-Casteljau', 'France', 'Europe', 'FRRA0161', 0),
(0, 'Berrie', 'France', 'Europe', 'FRPC0093', 0),
(0, 'Berrieux', 'France', 'Europe', 'FRPI0145', 0),
(0, 'Berru', 'France', 'Europe', 'FRCA0106', 0),
(0, 'Berrwiller', 'France', 'Europe', 'FRAL0029', 0),
(0, 'Bersaillin', 'France', 'Europe', 'FRFC0120', 0),
(0, 'Bersee', 'France', 'Europe', 'FRXX6308', 0),
(0, 'Bersillies', 'France', 'Europe', 'FRNC0110', 0),
(0, 'Berson', 'France', 'Europe', 'FRAQ0151', 0),
(0, 'Berstett', 'France', 'Europe', 'FRAL0030', 0),
(0, 'Berstheim', 'France', 'Europe', 'FRAL0031', 0),
(0, 'Bert', 'France', 'Europe', 'FRAU0051', 0),
(0, 'Bertangles', 'France', 'Europe', 'FRPI0146', 0),
(0, 'Chamberet', 'France', 'Europe', 'FRLI0064', 0),
(0, 'Chamberia', 'France', 'Europe', 'FRFC0221', 0),
(0, 'Chambery', 'France', 'Europe', 'FRXX0147', 0),
(0, 'Chambeugle', 'France', 'Europe', 'FRBO0177', 0),
(0, 'Chambezon', 'France', 'Europe', 'FRAU0110', 0),
(0, 'Chambilly', 'France', 'Europe', 'FRBO0178', 0),
(0, 'Chamblanc', 'France', 'Europe', 'FRBO0179', 0),
(0, 'Chamblay', 'France', 'Europe', 'FRFC0222', 0),
(0, 'Chambles', 'France', 'Europe', 'FRRA0276', 0),
(0, 'Chamblet', 'France', 'Europe', 'FRAU0111', 0),
(0, 'Chambly', 'France', 'Europe', 'FRXX5767', 0),
(0, 'Chamboeuf', 'France', 'Europe', 'FRBO0180', 0),
(0, 'Chamboeuf', 'France', 'Europe', 'FRRA0277', 0),
(0, 'Chambois', 'France', 'Europe', 'FRBN0199', 0),
(0, 'Chambon', 'France', 'Europe', 'FRCE0139', 0),
(0, 'Chambon', 'France', 'Europe', 'FRCE0140', 0),
(0, 'Chambon', 'France', 'Europe', 'FRCE0141', 0),
(0, 'Chambon', 'France', 'Europe', 'FRPC0171', 0),
(0, 'Chambonas', 'France', 'Europe', 'FRRA0278', 0),
(0, 'Chambonchard', 'France', 'Europe', 'FRAU0112', 0),
(0, 'Chamborand', 'France', 'Europe', 'FRLI0065', 0),
(0, 'Chambord', 'France', 'Europe', 'FRHN0125', 0),
(0, 'Chamboret', 'France', 'Europe', 'FRLI0066', 0),
(0, 'Chamborigaud', 'France', 'Europe', 'FRLR0161', 0),
(0, 'Chambors', 'France', 'Europe', 'FRPI0309', 0),
(0, 'Chamboulive', 'France', 'Europe', 'FRLI0067', 0),
(0, 'Chambourcy', 'France', 'Europe', 'FRXX1402', 0),
(0, 'Chambray-les-Tours', 'France', 'Europe', 'FRXX6757', 0),
(0, 'Chambrecy', 'France', 'Europe', 'FRCA0207', 0),
(0, 'Chambretaud', 'France', 'Europe', 'FRPL0103', 0),
(0, 'Chambrey', 'France', 'Europe', 'FRLO0249', 0),
(0, 'Chambroncourt', 'France', 'Europe', 'FRCA0208', 0),
(0, 'Chambroutet', 'France', 'Europe', 'FRPC0172', 0),
(0, 'Chambry', 'France', 'Europe', 'FRIF0098', 0),
(0, 'Chambry', 'France', 'Europe', 'FRPI0310', 0),
(0, 'Chameane', 'France', 'Europe', 'FRAU0113', 0),
(0, 'Chamelet', 'France', 'Europe', 'FRRA0279', 0),
(0, 'Chameroy', 'France', 'Europe', 'FRCA0209', 0),
(0, 'Chamery', 'France', 'Europe', 'FRCA0210', 0),
(0, 'Chamesey', 'France', 'Europe', 'FRFC0223', 0),
(0, 'Chamesol', 'France', 'Europe', 'FRFC0224', 0),
(0, 'Chamesson', 'France', 'Europe', 'FRBO0181', 0),
(0, 'Chameyrat', 'France', 'Europe', 'FRLI0068', 0),
(0, 'Chamigny', 'France', 'Europe', 'FRIF0099', 0),
(0, 'Chamilly', 'France', 'Europe', 'FRBO0182', 0),
(0, 'Chammes', 'France', 'Europe', 'FRPL0104', 0),
(0, 'Chamole', 'France', 'Europe', 'FRFC0225', 0),
(0, 'Chamonix', 'France', 'Europe', 'FRXX0212', 0),
(0, 'Chamouillac', 'France', 'Europe', 'FRPC0173', 0),
(0, 'Chamouille', 'France', 'Europe', 'FRPI0311', 0),
(0, 'Chamouilley', 'France', 'Europe', 'FRCA0211', 0),
(0, 'Chamousset', 'France', 'Europe', 'FRRA0280', 0),
(0, 'Chamoux', 'France', 'Europe', 'FRBO0183', 0),
(0, 'Chamoy', 'France', 'Europe', 'FRCA0212', 0),
(0, 'Champ-d`Oiseau', 'France', 'Europe', 'FRBO0184', 0),
(0, 'Champ-Dolent', 'France', 'Europe', 'FRHN0126', 0),
(0, 'Champ-du-Boult', 'France', 'Europe', 'FRBN0201', 0),
(0, 'Champ-Haut', 'France', 'Europe', 'FRBN0200', 0),
(0, 'Champ-Laurent', 'France', 'Europe', 'FRRA0281', 0),
(0, 'Champ-sur-Layon', 'France', 'Europe', 'FRXX3764', 0),
(0, 'Champagnac', 'France', 'Europe', 'FRPC0174', 0),
(0, 'Champagnat', 'France', 'Europe', 'FRBO0185', 0),
(0, 'Champagnat', 'France', 'Europe', 'FRLI0069', 0),
(0, 'Champagne', 'France', 'Europe', 'FRCE0142', 0),
(0, 'Champagne', 'France', 'Europe', 'FRPC0175', 0),
(0, 'Champagne', 'France', 'Europe', 'FRRA0282', 0),
(0, 'Champagne', 'France', 'Europe', 'FRXX4930', 0),
(0, 'Champagne-au-Mont-d`Or', 'France', 'Europe', 'FRXX6542', 0),
(0, 'Champagne-Mouton', 'France', 'Europe', 'FRPC0176', 0),
(0, 'Champagne-sur-Oise', 'France', 'Europe', 'FRXX3000', 0),
(0, 'Champagne-sur-Seine', 'France', 'Europe', 'FRXX4893', 0),
(0, 'Champagneux', 'France', 'Europe', 'FRRA0283', 0),
(0, 'Champagney', 'France', 'Europe', 'FRFC0226', 0),
(0, 'Champagney', 'France', 'Europe', 'FRFC0227', 0),
(0, 'Champagnier', 'France', 'Europe', 'FRRA0284', 0),
(0, 'Champagnolles', 'France', 'Europe', 'FRPC0177', 0),
(0, 'Champagny', 'France', 'Europe', 'FRBO0186', 0),
(0, 'Champagny', 'France', 'Europe', 'FRFC0228', 0),
(0, 'Champagny-en-Vanoise', 'France', 'Europe', 'FRXX0522', 0),
(0, 'Champallement', 'France', 'Europe', 'FRBO0187', 0),
(0, 'Frenelle-la-Grande', 'France', 'Europe', 'FRLO0493', 0),
(0, 'Frenelle-la-Petite', 'France', 'Europe', 'FRLO0494', 0),
(0, 'Frenes', 'France', 'Europe', 'FRBN0376', 0),
(0, 'Freneuse', 'France', 'Europe', 'FRHN0248', 0),
(0, 'Freneuse', 'France', 'Europe', 'FRIF0207', 0),
(0, 'Freniches', 'France', 'Europe', 'FRPI0612', 0),
(0, 'Frenois', 'France', 'Europe', 'FRBO0444', 0),
(0, 'Frenois', 'France', 'Europe', 'FRLO0495', 0),
(0, 'Frenouville', 'France', 'Europe', 'FRBN0377', 0),
(0, 'Frepillon', 'France', 'Europe', 'FRXX3760', 0),
(0, 'Fresnay', 'France', 'Europe', 'FRCA0470', 0),
(0, 'Fresne-les-Reims', 'France', 'Europe', 'FRCA0471', 0),
(0, 'Fresnes', 'France', 'Europe', 'FRBO0445', 0),
(0, 'Fresnes', 'France', 'Europe', 'FRBO0446', 0),
(0, 'Fresnes', 'France', 'Europe', 'FRCE0335', 0),
(0, 'Fresnes', 'France', 'Europe', 'FRXX6718', 0),
(0, 'Fresnes-Mazancourt', 'France', 'Europe', 'FRPI0613', 0),
(0, 'Fresneville', 'France', 'Europe', 'FRPI0614', 0),
(0, 'Fresney', 'France', 'Europe', 'FRHN0249', 0),
(0, 'Fresnieres', 'France', 'Europe', 'FRPI0615', 0),
(0, 'Fresnoy', 'France', 'Europe', 'FRNC0370', 0),
(0, 'Fresnoy-le-Grand', 'France', 'Europe', 'FRXX4848', 0),
(0, 'Fresnoy-les-Roye', 'France', 'Europe', 'FRXX4483', 0),
(0, 'Frespech', 'France', 'Europe', 'FRAQ0466', 0),
(0, 'Fresquiennes', 'France', 'Europe', 'FRHN0250', 0),
(0, 'Fressac', 'France', 'Europe', 'FRLR0254', 0),
(0, 'Fressain', 'France', 'Europe', 'FRNC0371', 0),
(0, 'Fressancourt', 'France', 'Europe', 'FRPI0616', 0),
(0, 'Fresse', 'France', 'Europe', 'FRFC0507', 0),
(0, 'Fresse-sur-Moselle', 'France', 'Europe', 'FRXX3741', 0),
(0, 'Fresselines', 'France', 'Europe', 'FRXX4874', 0),
(0, 'Fressenneville', 'France', 'Europe', 'FRXX2919', 0),
(0, 'Fressies', 'France', 'Europe', 'FRXX5602', 0),
(0, 'Fressin', 'France', 'Europe', 'FRNC0372', 0),
(0, 'Fressines', 'France', 'Europe', 'FRPC0341', 0),
(0, 'Fresville', 'France', 'Europe', 'FRBN0378', 0),
(0, 'Fretay', 'France', 'Europe', 'FRIF0208', 0),
(0, 'Freterive', 'France', 'Europe', 'FRRA0587', 0),
(0, 'Freteval', 'France', 'Europe', 'FRCE0336', 0),
(0, 'Frethun', 'France', 'Europe', 'FRXX1993', 0),
(0, 'Fretigney-et-Velloreille', 'France', 'Europe', 'FRXX1277', 0),
(0, 'Fretigny', 'France', 'Europe', 'FRCE0337', 0),
(0, 'Fretin', 'France', 'Europe', 'FRNC0373', 0),
(0, 'Fretoy', 'France', 'Europe', 'FRIF0209', 0),
(0, 'Fretoy-le-Chateau', 'France', 'Europe', 'FRXX3502', 0),
(0, 'Frettecuisse', 'France', 'Europe', 'FRPI0617', 0),
(0, 'Frettemeule', 'France', 'Europe', 'FRPI0618', 0),
(0, 'Frettemolle', 'France', 'Europe', 'FRPI0619', 0),
(0, 'Fretterans', 'France', 'Europe', 'FRBO0447', 0),
(0, 'Freulleville', 'France', 'Europe', 'FRHN0251', 0),
(0, 'Frevent', 'France', 'Europe', 'FRNC0374', 0),
(0, 'Freville', 'France', 'Europe', 'FRHN0252', 0),
(0, 'Freville', 'France', 'Europe', 'FRLO0496', 0),
(0, 'Freville-du-Gatinais', 'France', 'Europe', 'FRCE0338', 0),
(0, 'Frevillers', 'France', 'Europe', 'FRNC0375', 0),
(0, 'Frevin-Capelle', 'France', 'Europe', 'FRNC0376', 0),
(0, 'Freybouse', 'France', 'Europe', 'FRLO0497', 0),
(0, 'Freycenet-la-Cuche', 'France', 'Europe', 'FRAU0248', 0),
(0, 'Freycenet-la-Tour', 'France', 'Europe', 'FRAU0249', 0),
(0, 'Freychenet', 'France', 'Europe', 'FRMP0757', 0),
(0, 'Freyming-Merlebach', 'France', 'Europe', 'FRLO0498', 0),
(0, 'Freyssenet', 'France', 'Europe', 'FRRA0588', 0),
(0, 'Friaize', 'France', 'Europe', 'FRCE0339', 0),
(0, 'Friardel', 'France', 'Europe', 'FRBN0379', 0),
(0, 'Friaucourt', 'France', 'Europe', 'FRXX3731', 0),
(0, 'Friauville', 'France', 'Europe', 'FRLO0499', 0),
(0, 'Fribourg', 'France', 'Europe', 'FRLO0500', 0),
(0, 'Fricamps', 'France', 'Europe', 'FRPI0620', 0),
(0, 'Frichemesnil', 'France', 'Europe', 'FRHN0253', 0),
(0, 'Fricourt', 'France', 'Europe', 'FRPI0621', 0),
(0, 'Fridefont', 'France', 'Europe', 'FRAU0250', 0),
(0, 'Friedolsheim', 'France', 'Europe', 'FRAL0139', 0),
(0, 'Frieres-Faillouel', 'France', 'Europe', 'FRXX2399', 0),
(0, 'Friesen', 'France', 'Europe', 'FRAL0140', 0),
(0, 'Friesenheim', 'France', 'Europe', 'FRAL0141', 0),
(0, 'Frignicourt', 'France', 'Europe', 'FRCA0472', 0),
(0, 'Frise', 'France', 'Europe', 'FRPI0622', 0),
(0, 'Friville-Escarbotin', 'France', 'Europe', 'FRXX3690', 0),
(0, 'Frizon', 'France', 'Europe', 'FRXX1554', 0),
(0, 'Froberville', 'France', 'Europe', 'FRHN0254', 0),
(0, 'Goupillieres', 'France', 'Europe', 'FRBN0412', 0),
(0, 'Goupillieres', 'France', 'Europe', 'FRHN0283', 0),
(0, 'Goupillieres', 'France', 'Europe', 'FRHN0284', 0),
(0, 'Goupillieres', 'France', 'Europe', 'FRIF0228', 0),
(0, 'Gouraincourt', 'France', 'Europe', 'FRLO0558', 0),
(0, 'Gourbera', 'France', 'Europe', 'FRAQ0524', 0),
(0, 'Gourbesville', 'France', 'Europe', 'FRBN0413', 0),
(0, 'Gourbeyre', 'France', 'Europe', 'FRXX7709', 0),
(0, 'Gourbit', 'France', 'Europe', 'FRMP0857', 0),
(0, 'Gourchelles', 'France', 'Europe', 'FRPI0661', 0),
(0, 'Gourdan-Polignan', 'France', 'Europe', 'FRMP0858', 0),
(0, 'Gourdieges', 'France', 'Europe', 'FRAU0265', 0),
(0, 'Gourdon', 'France', 'Europe', 'FRBO0488', 0),
(0, 'Gourdon', 'France', 'Europe', 'FRPA0205', 0),
(0, 'Gourdon', 'France', 'Europe', 'FRRA0617', 0),
(0, 'Gourdon', 'France', 'Europe', 'FRXX0121', 0),
(0, 'Gourdon-Murat', 'France', 'Europe', 'FRLI0152', 0),
(0, 'Gourette', 'France', 'Europe', 'FRXX0517', 0),
(0, 'Gourfaleur', 'France', 'Europe', 'FRBN0414', 0),
(0, 'Gourgancon', 'France', 'Europe', 'FRCA0512', 0),
(0, 'Gourge', 'France', 'Europe', 'FRPC0365', 0),
(0, 'Gourgeon', 'France', 'Europe', 'FRFC0551', 0),
(0, 'Gourgue', 'France', 'Europe', 'FRMP0859', 0),
(0, 'Gourhel', 'France', 'Europe', 'FRBR0022', 0),
(0, 'Gourin', 'France', 'Europe', 'FRXX1473', 0),
(0, 'Gourlizon', 'France', 'Europe', 'FRBR0023', 0),
(0, 'Gournay', 'France', 'Europe', 'FRCE0370', 0),
(0, 'Gournay', 'France', 'Europe', 'FRHN0285', 0),
(0, 'Gournay-en-Bray', 'France', 'Europe', 'FRXX5820', 0),
(0, 'Gournay-le-Guerin', 'France', 'Europe', 'FRXX6799', 0),
(0, 'Gournay-Loize', 'France', 'Europe', 'FRXX1628', 0),
(0, 'Gournay-sur-Aronde', 'France', 'Europe', 'FRXX5766', 0),
(0, 'Gournay-sur-Marne', 'France', 'Europe', 'FRXX2987', 0),
(0, 'Gours', 'France', 'Europe', 'FRAQ0525', 0),
(0, 'Gourvieille', 'France', 'Europe', 'FRLR0276', 0),
(0, 'Gourville', 'France', 'Europe', 'FRPC0366', 0),
(0, 'Gourvillette', 'France', 'Europe', 'FRPC0367', 0),
(0, 'Gourzon', 'France', 'Europe', 'FRCA0513', 0),
(0, 'Goussaincourt', 'France', 'Europe', 'FRLO0559', 0),
(0, 'Goussainville', 'France', 'Europe', 'FRCE0371', 0),
(0, 'Goussainville', 'France', 'Europe', 'FRXX3868', 0),
(0, 'Goussancourt', 'France', 'Europe', 'FRPI0662', 0),
(0, 'Gousse', 'France', 'Europe', 'FRAQ0526', 0),
(0, 'Goussonville', 'France', 'Europe', 'FRIF0229', 0),
(0, 'Goustranville', 'France', 'Europe', 'FRBN0415', 0),
(0, 'Gout-Rossignol', 'France', 'Europe', 'FRAQ0527', 0),
(0, 'Goutevernisse', 'France', 'Europe', 'FRMP0860', 0),
(0, 'Goutrens', 'France', 'Europe', 'FRXX5454', 0),
(0, 'Gouts', 'France', 'Europe', 'FRAQ0528', 0),
(0, 'Gouttieres', 'France', 'Europe', 'FRAU0266', 0),
(0, 'Gouttieres', 'France', 'Europe', 'FRHN0286', 0),
(0, 'Goutz', 'France', 'Europe', 'FRMP0861', 0),
(0, 'Gouvernes', 'France', 'Europe', 'FRIF0230', 0),
(0, 'Gouves', 'France', 'Europe', 'FRNC0393', 0),
(0, 'Gouvets', 'France', 'Europe', 'FRBN0416', 0),
(0, 'Gouvieux', 'France', 'Europe', 'FRXX3497', 0),
(0, 'Gouville', 'France', 'Europe', 'FRHN0287', 0),
(0, 'Gouville-sur-Mer', 'France', 'Europe', 'FRXX3100', 0),
(0, 'Gouvix', 'France', 'Europe', 'FRXX5490', 0),
(0, 'Goux', 'France', 'Europe', 'FRFC0552', 0),
(0, 'Goux', 'France', 'Europe', 'FRMP0862', 0),
(0, 'Goux-les-Dambelin', 'France', 'Europe', 'FRFC0553', 0),
(0, 'Goux-les-Usiers', 'France', 'Europe', 'FRXX2457', 0),
(0, 'Goux-sous-Landet', 'France', 'Europe', 'FRFC0554', 0),
(0, 'Gouy', 'France', 'Europe', 'FRHN0288', 0),
(0, 'Gouy', 'France', 'Europe', 'FRPI0663', 0),
(0, 'Gouy-en-Artois', 'France', 'Europe', 'FRXX4370', 0),
(0, 'Gouy-en-Ternois', 'France', 'Europe', 'FRNC0395', 0),
(0, 'Gouy-les-Groseillers', 'France', 'Europe', 'FRPI0664', 0),
(0, 'Gouy-Saint-Andre', 'France', 'Europe', 'FRXX4907', 0),
(0, 'Gouy-Servins', 'France', 'Europe', 'FRNC0394', 0),
(0, 'Gouy-sous-Bellonne', 'France', 'Europe', 'FRXX2142', 0),
(0, 'Gouzangrez', 'France', 'Europe', 'FRIF0231', 0),
(0, 'Gouze', 'France', 'Europe', 'FRAQ0529', 0),
(0, 'Gouzeaucourt', 'France', 'Europe', 'FRXX2583', 0),
(0, 'Gouzens', 'France', 'Europe', 'FRMP0863', 0),
(0, 'Gouzon', 'France', 'Europe', 'FRLI0153', 0),
(0, 'Gouzougnat', 'France', 'Europe', 'FRLI0154', 0),
(0, 'Goven', 'France', 'Europe', 'FRBR0024', 0),
(0, 'Goviller', 'France', 'Europe', 'FRLO0560', 0),
(0, 'Hyencourt-le-Grand', 'France', 'Europe', 'FRPI0776', 0),
(0, 'Hyenville', 'France', 'Europe', 'FRBN0467', 0),
(0, 'Hyeres', 'France', 'Europe', 'FRXX0154', 0),
(0, 'Hyet', 'France', 'Europe', 'FRFC0591', 0),
(0, 'Hyevre-Magny', 'France', 'Europe', 'FRFC0592', 0),
(0, 'Hyevre-Paroisse', 'France', 'Europe', 'FRFC0593', 0),
(0, 'Hymont', 'France', 'Europe', 'FRLO0709', 0),
(0, 'La Gohanniere', 'France', 'Europe', 'FRBN0536', 0),
(0, 'La Gonfriere', 'France', 'Europe', 'FRBN0537', 0),
(0, 'La Gonterie-Boulouneix', 'France', 'Europe', 'FRAQ0624', 0),
(0, 'La Gorgue', 'France', 'Europe', 'FRXX5859', 0),
(0, 'La Gouesniere', 'France', 'Europe', 'FRBR0117', 0),
(0, 'La Goulafriere', 'France', 'Europe', 'FRHN0401', 0),
(0, 'La Goutelle', 'France', 'Europe', 'FRAU0317', 0),
(0, 'La Grand-Combe', 'France', 'Europe', 'FRLR0317', 0),
(0, 'La Grand-Croix', 'France', 'Europe', 'FRRA0768', 0),
(0, 'La Grande-Fosse', 'France', 'Europe', 'FRLO0775', 0),
(0, 'La Grande-Motte', 'France', 'Europe', 'FRXX4396', 0),
(0, 'La Grande-Paroisse', 'France', 'Europe', 'FRIF0287', 0),
(0, 'La Grande-Resie', 'France', 'Europe', 'FRFC0641', 0),
(0, 'La Grande-Verriere', 'France', 'Europe', 'FRXX5662', 0),
(0, 'La Grandville', 'France', 'Europe', 'FRXX5922', 0),
(0, 'La Grange', 'France', 'Europe', 'FRFC0642', 0),
(0, 'La Grave', 'France', 'Europe', 'FRXX0214', 0),
(0, 'La Gravelle', 'France', 'Europe', 'FRPL0357', 0),
(0, 'La Graverie', 'France', 'Europe', 'FRBN0538', 0),
(0, 'La Gree-Saint-Laurent', 'France', 'Europe', 'FRBR0118', 0),
(0, 'La Gresle', 'France', 'Europe', 'FRXX2644', 0),
(0, 'La Greve-sur-Mignon', 'France', 'Europe', 'FRPC0438', 0),
(0, 'La Grigonnais', 'France', 'Europe', 'FRPL0358', 0),
(0, 'La Grimaudiere', 'France', 'Europe', 'FRPC0439', 0),
(0, 'La Gripperie-Saint-Symphorien', 'France', 'Europe', 'FRPC0440', 0),
(0, 'La Groise', 'France', 'Europe', 'FRNC0500', 0),
(0, 'La Groutte', 'France', 'Europe', 'FRCE0470', 0),
(0, 'La Guerche', 'France', 'Europe', 'FRCE0471', 0),
(0, 'La Guerche-de-Bretagne', 'France', 'Europe', 'FRXX3331', 0),
(0, 'La Guerche-sur-l`Aubois', 'France', 'Europe', 'FRCE0472', 0),
(0, 'La Gueriniere', 'France', 'Europe', 'FRXX1636', 0),
(0, 'La Gueroulde', 'France', 'Europe', 'FRHN0402', 0),
(0, 'La Guiche', 'France', 'Europe', 'FRBO0581', 0),
(0, 'La Guierche', 'France', 'Europe', 'FRPL0359', 0),
(0, 'La Guillermie', 'France', 'Europe', 'FRAU0318', 0),
(0, 'La Gurraz', 'France', 'Europe', 'FRXX0232', 0),
(0, 'La Guyonniere', 'France', 'Europe', 'FRPL0360', 0),
(0, 'La Hague', 'France', 'Europe', 'FRXX0112', 0),
(0, 'La Haie-Fouassiere', 'France', 'Europe', 'FRXX3530', 0),
(0, 'La Haie-Traversaine', 'France', 'Europe', 'FRPL0361', 0),
(0, 'La Hallotiere', 'France', 'Europe', 'FRHN0403', 0),
(0, 'La Hardoye', 'France', 'Europe', 'FRCA0641', 0),
(0, 'La Harengere', 'France', 'Europe', 'FRHN0404', 0),
(0, 'La Harmoye', 'France', 'Europe', 'FRBR0119', 0),
(0, 'La Haute-Beaume', 'France', 'Europe', 'FRPA0243', 0),
(0, 'La Haute-Chapelle', 'France', 'Europe', 'FRBN0539', 0),
(0, 'La Haute-Maison', 'France', 'Europe', 'FRIF0288', 0),
(0, 'La Hauteville', 'France', 'Europe', 'FRIF0289', 0),
(0, 'La Haye', 'France', 'Europe', 'FRHN0405', 0),
(0, 'La Haye', 'France', 'Europe', 'FRLO0776', 0),
(0, 'La Haye-Aubree', 'France', 'Europe', 'FRHN0406', 0),
(0, 'La Haye-Bellefond', 'France', 'Europe', 'FRBN0540', 0),
(0, 'La Haye-d`Ectot', 'France', 'Europe', 'FRBN0541', 0),
(0, 'La Haye-de-Calleville', 'France', 'Europe', 'FRHN0409', 0),
(0, 'La Haye-de-Routot', 'France', 'Europe', 'FRXX5544', 0),
(0, 'La Haye-du-Puits', 'France', 'Europe', 'FRBN0542', 0),
(0, 'La Haye-du-Theil', 'France', 'Europe', 'FRHN0410', 0),
(0, 'La Haye-le-Comte', 'France', 'Europe', 'FRHN0411', 0),
(0, 'La Haye-Malherbe', 'France', 'Europe', 'FRHN0407', 0),
(0, 'La Haye-Pesnel', 'France', 'Europe', 'FRXX3616', 0),
(0, 'La Haye-Saint-Sylvestre', 'France', 'Europe', 'FRHN0408', 0),
(0, 'La Herelle', 'France', 'Europe', 'FRPI0810', 0),
(0, 'La Herie', 'France', 'Europe', 'FRPI0811', 0),
(0, 'La Herliere', 'France', 'Europe', 'FRNC0501', 0),
(0, 'La Heuniere', 'France', 'Europe', 'FRHN0412', 0),
(0, 'La Hoguette', 'France', 'Europe', 'FRBN0543', 0),
(0, 'La Horgne', 'France', 'Europe', 'FRCA0642', 0),
(0, 'La Houblonniere', 'France', 'Europe', 'FRBN0544', 0),
(0, 'La Houssaye', 'France', 'Europe', 'FRHN0413', 0),
(0, 'La Houssaye-en-Brie', 'France', 'Europe', 'FRXX4158', 0),
(0, 'La Houssiere', 'France', 'Europe', 'FRXX1644', 0),
(0, 'La Houssoye', 'France', 'Europe', 'FRXX5013', 0),
(0, 'La Hutte', 'France', 'Europe', 'FRPL0362', 0),
(0, 'La Jaille-Yvon', 'France', 'Europe', 'FRPL0363', 0),
(0, 'La Jard', 'France', 'Europe', 'FRPC0441', 0),
(0, 'La Jarne', 'France', 'Europe', 'FRPC0442', 0),
(0, 'La Jarrie', 'France', 'Europe', 'FRPC0443', 0),
(0, 'La Jarrie-Audouin', 'France', 'Europe', 'FRPC0444', 0),
(0, 'La Jaudonniere', 'France', 'Europe', 'FRPL0364', 0),
(0, 'La Javie', 'France', 'Europe', 'FRXX5921', 0),
(0, 'Marmont-Pachas', 'France', 'Europe', 'FRAQ0874', 0),
(0, 'Marmouille', 'France', 'Europe', 'FRBN0812', 0),
(0, 'Marmoutier', 'France', 'Europe', 'FRXX2870', 0),
(0, 'Marnac', 'France', 'Europe', 'FRAQ0875', 0),
(0, 'Marnand', 'France', 'Europe', 'FRRA1066', 0),
(0, 'Marnans', 'France', 'Europe', 'FRRA1067', 0),
(0, 'Marnaves', 'France', 'Europe', 'FRMP1352', 0),
(0, 'Marnay', 'France', 'Europe', 'FRBO0743', 0),
(0, 'Marnay', 'France', 'Europe', 'FRCE0648', 0),
(0, 'Marnay', 'France', 'Europe', 'FRFC0831', 0),
(0, 'Marnay', 'France', 'Europe', 'FRPC0593', 0),
(0, 'Marnay-sur-Marne', 'France', 'Europe', 'FRCA0860', 0),
(0, 'Marnay-sur-Seine', 'France', 'Europe', 'FRCA0861', 0),
(0, 'Marnaz', 'France', 'Europe', 'FRXX2058', 0),
(0, 'Marne-la-Vallee', 'France', 'Europe', 'FRXX0279', 0),
(0, 'Marnefer', 'France', 'Europe', 'FRBN0813', 0),
(0, 'Marnes', 'France', 'Europe', 'FRPC0594', 0),
(0, 'Marnes-la-Coquette', 'France', 'Europe', 'FRXX2219', 0),
(0, 'Marnezia', 'France', 'Europe', 'FRFC0832', 0),
(0, 'Marnhagues-et-Latour', 'France', 'Europe', 'FRXX3163', 0),
(0, 'Marnoz', 'France', 'Europe', 'FRFC0833', 0),
(0, 'Maroeuil', 'France', 'Europe', 'FRNC0603', 0),
(0, 'Maroeuil', 'France', 'Europe', 'FRXX6382', 0),
(0, 'Maroilles', 'France', 'Europe', 'FRXX4308', 0),
(0, 'Marolles', 'France', 'Europe', 'FRBN0814', 0),
(0, 'Marolles', 'France', 'Europe', 'FRCA0862', 0),
(0, 'Marolles', 'France', 'Europe', 'FRCE0649', 0),
(0, 'Marolles', 'France', 'Europe', 'FRPI1033', 0),
(0, 'Marolles-en-Beauce', 'France', 'Europe', 'FRIF0369', 0),
(0, 'Marolles-en-Brie', 'France', 'Europe', 'FRIF0370', 0),
(0, 'Marolles-en-Brie', 'France', 'Europe', 'FRIF0371', 0),
(0, 'Marolles-en-Hurepoix', 'France', 'Europe', 'FRXX2242', 0),
(0, 'Marolles-les-Bailly', 'France', 'Europe', 'FRCA0863', 0),
(0, 'Marolles-les-Braults', 'France', 'Europe', 'FRXX2660', 0),
(0, 'Marolles-les-Buis', 'France', 'Europe', 'FRCE0650', 0),
(0, 'Marolles-les-Saint-Calais', 'France', 'Europe', 'FRPL0545', 0),
(0, 'Marolles-sous-Lignieres', 'France', 'Europe', 'FRCA0864', 0),
(0, 'Marolles-sur-Seine', 'France', 'Europe', 'FRIF0372', 0),
(0, 'Marollette', 'France', 'Europe', 'FRPL0546', 0),
(0, 'Marols', 'France', 'Europe', 'FRRA1068', 0),
(0, 'Maron', 'France', 'Europe', 'FRCE0651', 0),
(0, 'Maron', 'France', 'Europe', 'FRLO1007', 0),
(0, 'Maroncourt', 'France', 'Europe', 'FRLO1008', 0),
(0, 'Maroue', 'France', 'Europe', 'FRBR0297', 0),
(0, 'Marpain', 'France', 'Europe', 'FRFC0834', 0),
(0, 'Marpaps', 'France', 'Europe', 'FRAQ0876', 0),
(0, 'Marpent', 'France', 'Europe', 'FRXX4501', 0),
(0, 'Marpire', 'France', 'Europe', 'FRBR0298', 0),
(0, 'Marquaix', 'France', 'Europe', 'FRPI1034', 0),
(0, 'Marquay', 'France', 'Europe', 'FRAQ0877', 0),
(0, 'Marquay', 'France', 'Europe', 'FRNC0604', 0),
(0, 'Marquefave', 'France', 'Europe', 'FRMP1353', 0),
(0, 'Marqueglise', 'France', 'Europe', 'FRPI1035', 0),
(0, 'Marquein', 'France', 'Europe', 'FRLR0447', 0),
(0, 'Marquerie', 'France', 'Europe', 'FRMP1354', 0),
(0, 'Marques', 'France', 'Europe', 'FRHN0551', 0),
(0, 'Marquette-en-Ostrevant', 'France', 'Europe', 'FRNC0605', 0),
(0, 'Marquette-lez-Lille', 'France', 'Europe', 'FRXX1349', 0),
(0, 'Marquigny', 'France', 'Europe', 'FRCA0865', 0),
(0, 'Marquillies', 'France', 'Europe', 'FRXX1441', 0),
(0, 'Marquion', 'France', 'Europe', 'FRNC0606', 0),
(0, 'Marquise', 'France', 'Europe', 'FRXX1273', 0),
(0, 'Marquivillers', 'France', 'Europe', 'FRPI1036', 0),
(0, 'Marquixanes', 'France', 'Europe', 'FRLR0448', 0),
(0, 'Marray', 'France', 'Europe', 'FRCE0652', 0),
(0, 'Marre', 'France', 'Europe', 'FRLO1009', 0),
(0, 'Mars', 'France', 'Europe', 'FRLR0449', 0),
(0, 'Mars', 'France', 'Europe', 'FRRA1069', 0),
(0, 'Mars', 'France', 'Europe', 'FRRA1070', 0),
(0, 'Mars-la-Tour', 'France', 'Europe', 'FRXX3688', 0),
(0, 'Mars-sous-Bourcq', 'France', 'Europe', 'FRCA0866', 0),
(0, 'Mars-sur-Allier', 'France', 'Europe', 'FRBO0744', 0),
(0, 'Marsa', 'France', 'Europe', 'FRLR0450', 0),
(0, 'Marsac', 'France', 'Europe', 'FRMP1355', 0),
(0, 'Marsac', 'France', 'Europe', 'FRMP1356', 0),
(0, 'Marsac', 'France', 'Europe', 'FRPC0595', 0),
(0, 'Marsac', 'France', 'Europe', 'FRXX2600', 0),
(0, 'Marsac-en-Livradois', 'France', 'Europe', 'FRXX3551', 0),
(0, 'Marsac-sur-Don', 'France', 'Europe', 'FRPL0547', 0),
(0, 'Marsac-sur-l`Isle', 'France', 'Europe', 'FRAQ0878', 0),
(0, 'Noyal-Pontivy', 'France', 'Europe', 'FRXX3682', 0),
(0, 'Noyal-sous-Bazouges', 'France', 'Europe', 'FRBR0360', 0),
(0, 'Noyal-sur-Brutz', 'France', 'Europe', 'FRPL0643', 0),
(0, 'Noyal-sur-Vilaine', 'France', 'Europe', 'FRXX2833', 0),
(0, 'Noyales', 'France', 'Europe', 'FRPI1218', 0),
(0, 'Noyalo', 'France', 'Europe', 'FRBR0361', 0),
(0, 'Noyant', 'France', 'Europe', 'FRPL0644', 0),
(0, 'Noyant-d`Allier', 'France', 'Europe', 'FRAU0542', 0),
(0, 'Noyant-de-Touraine', 'France', 'Europe', 'FRCE0810', 0),
(0, 'Noyant-et-Aconin', 'France', 'Europe', 'FRPI1219', 0),
(0, 'Noyant-la-Gravoyere', 'France', 'Europe', 'FRXX5239', 0),
(0, 'Noyant-la-Plaine', 'France', 'Europe', 'FRPL0645', 0),
(0, 'Noyarey', 'France', 'Europe', 'FRRA1263', 0),
(0, 'Noyelle-Vion', 'France', 'Europe', 'FRNC0677', 0),
(0, 'Noyelles-en-Chaussee', 'France', 'Europe', 'FRPI1220', 0),
(0, 'Noyelles-Godault', 'France', 'Europe', 'FRXX4908', 0),
(0, 'Noyelles-les-Humieres', 'France', 'Europe', 'FRNC0678', 0),
(0, 'Noyelles-les-Seclin', 'France', 'Europe', 'FRXX6492', 0),
(0, 'Noyelles-les-Vermelles', 'France', 'Europe', 'FRXX1208', 0),
(0, 'Noyelles-sous-Bellonne', 'France', 'Europe', 'FRNC0679', 0),
(0, 'Noyelles-sous-Lens', 'France', 'Europe', 'FRXX2764', 0),
(0, 'Noyelles-sur-Escaut', 'France', 'Europe', 'FRXX6668', 0),
(0, 'Noyelles-sur-Mer', 'France', 'Europe', 'FRXX4507', 0),
(0, 'Noyelles-sur-Sambre', 'France', 'Europe', 'FRNC0680', 0),
(0, 'Noyelles-sur-Selle', 'France', 'Europe', 'FRXX6576', 0),
(0, 'Noyellette', 'France', 'Europe', 'FRNC0681', 0),
(0, 'Noyen-sur-Sarthe', 'France', 'Europe', 'FRXX2669', 0),
(0, 'Noyen-sur-Seine', 'France', 'Europe', 'FRXX1483', 0),
(0, 'Noyers', 'France', 'Europe', 'FRBO0904', 0),
(0, 'Noyers', 'France', 'Europe', 'FRCA1013', 0),
(0, 'Noyers', 'France', 'Europe', 'FRCE0811', 0),
(0, 'Noyers', 'France', 'Europe', 'FRHN0636', 0),
(0, 'Noyers-Auzecourt', 'France', 'Europe', 'FRLO1185', 0),
(0, 'Noyers-Bocage', 'France', 'Europe', 'FRBN0945', 0),
(0, 'Noyers-Pont-Maugis', 'France', 'Europe', 'FRXX1871', 0),
(0, 'Noyers-Saint-Martin', 'France', 'Europe', 'FRXX4296', 0),
(0, 'Noyers-sur-Cher', 'France', 'Europe', 'FRXX1361', 0),
(0, 'Noyers-sur-Jabron', 'France', 'Europe', 'FRPA0413', 0),
(0, 'Noyon', 'France', 'Europe', 'FRXX3498', 0),
(0, 'Nozay', 'France', 'Europe', 'FRCA1014', 0),
(0, 'Nozay', 'France', 'Europe', 'FRIF0439', 0),
(0, 'Nozay', 'France', 'Europe', 'FRXX4237', 0),
(0, 'Nozeroy', 'France', 'Europe', 'FRFC0991', 0),
(0, 'Nozieres', 'France', 'Europe', 'FRCE0812', 0),
(0, 'Nozieres', 'France', 'Europe', 'FRRA1264', 0),
(0, 'Nuaille', 'France', 'Europe', 'FRPL0646', 0),
(0, 'Nuaille-d`Aunis', 'France', 'Europe', 'FRXX1066', 0),
(0, 'Nuaille-sur-Boutonne', 'France', 'Europe', 'FRPC0701', 0),
(0, 'Nuars', 'France', 'Europe', 'FRBO0905', 0),
(0, 'Nubecourt', 'France', 'Europe', 'FRLO1186', 0),
(0, 'Nucourt', 'France', 'Europe', 'FRIF0440', 0),
(0, 'Nueil-les-Aubiers', 'France', 'Europe', 'FRXX6010', 0),
(0, 'Nueil-sous-Faye', 'France', 'Europe', 'FRPC0702', 0),
(0, 'Nueil-sur-Layon', 'France', 'Europe', 'FRXX1936', 0),
(0, 'Nuelles', 'France', 'Europe', 'FRRA1265', 0),
(0, 'Nuille-sur-Ouette', 'France', 'Europe', 'FRPL0647', 0),
(0, 'Nuille-sur-Vicoin', 'France', 'Europe', 'FRPL0648', 0),
(0, 'Nuisement-sur-Coole', 'France', 'Europe', 'FRCA1015', 0),
(0, 'Nuits', 'France', 'Europe', 'FRXX2977', 0),
(0, 'Nuits-Saint-Georges', 'France', 'Europe', 'FRXX3221', 0),
(0, 'Nuku-Hiva', 'France', 'Europe', 'FRXX7885', 0),
(0, 'Nukutavake', 'France', 'Europe', 'FRXX7911', 0),
(0, 'Nullemont', 'France', 'Europe', 'FRHN0637', 0),
(0, 'Nully', 'France', 'Europe', 'FRCA1016', 0),
(0, 'Nuncq-Hautecote', 'France', 'Europe', 'FRNC0682', 0),
(0, 'Nuret-le-Ferron', 'France', 'Europe', 'FRCE0813', 0),
(0, 'Nurieux-Volognat', 'France', 'Europe', 'FRRA1266', 0),
(0, 'Nurlu', 'France', 'Europe', 'FRPI1221', 0),
(0, 'Nuzejouls', 'France', 'Europe', 'FRMP1642', 0),
(0, 'Nuzejoux', 'France', 'Europe', 'FRLI0318', 0),
(0, 'Nyer', 'France', 'Europe', 'FRLR0561', 0),
(0, 'Nyoiseau', 'France', 'Europe', 'FRPL0649', 0),
(0, 'Nyons', 'France', 'Europe', 'FRXX4067', 0),
(0, 'Pimbo', 'France', 'Europe', 'FRAQ1122', 0),
(0, 'Pimelles', 'France', 'Europe', 'FRBO0965', 0),
(0, 'Pimorin', 'France', 'Europe', 'FRFC1051', 0),
(0, 'Pimprez', 'France', 'Europe', 'FRPI1294', 0),
(0, 'Pin', 'France', 'Europe', 'FRXX3459', 0),
(0, 'Pin-Balma', 'France', 'Europe', 'FRXX1859', 0),
(0, 'Pinas', 'France', 'Europe', 'FRMP1735', 0),
(0, 'Pinay', 'France', 'Europe', 'FRRA1334', 0),
(0, 'Pince', 'France', 'Europe', 'FRPL0676', 0),
(0, 'Pinderes', 'France', 'Europe', 'FRAQ1123', 0),
(0, 'Pindray', 'France', 'Europe', 'FRPC0738', 0),
(0, 'Pinel-Hauterive', 'France', 'Europe', 'FRAQ1124', 0),
(0, 'Pinet', 'France', 'Europe', 'FRXX1881', 0),
(0, 'Pineuilh', 'France', 'Europe', 'FRAQ1125', 0),
(0, 'Piney', 'France', 'Europe', 'FRCA1084', 0),
(0, 'Pino', 'France', 'Europe', 'FRCO0158', 0),
(0, 'Pinols', 'France', 'Europe', 'FRAU0576', 0),
(0, 'Pinon', 'France', 'Europe', 'FRXX4097', 0),
(0, 'Pins-Justaret', 'France', 'Europe', 'FRMP1736', 0),
(0, 'Pinsac', 'France', 'Europe', 'FRMP1737', 0),
(0, 'Pinsaguel', 'France', 'Europe', 'FRMP1738', 0),
(0, 'Pinsot', 'France', 'Europe', 'FRRA1335', 0),
(0, 'Pintac', 'France', 'Europe', 'FRMP1739', 0),
(0, 'Pinterville', 'France', 'Europe', 'FRHN0663', 0),
(0, 'Pintheville', 'France', 'Europe', 'FRLO1256', 0),
(0, 'Piobetta', 'France', 'Europe', 'FRCO0159', 0),
(0, 'Pioggiola', 'France', 'Europe', 'FRCO0160', 0),
(0, 'Piolenc', 'France', 'Europe', 'FRXX1607', 0),
(0, 'Pionnat', 'France', 'Europe', 'FRLI0335', 0),
(0, 'Pionsat', 'France', 'Europe', 'FRAU0577', 0),
(0, 'Pioussay', 'France', 'Europe', 'FRPC0739', 0),
(0, 'Pipriac', 'France', 'Europe', 'FRXX5126', 0),
(0, 'Piquecos', 'France', 'Europe', 'FRMP1740', 0),
(0, 'Pirae', 'France', 'Europe', 'FRXX7862', 0),
(0, 'Pirajoux', 'France', 'Europe', 'FRRA1336', 0),
(0, 'Pire-sur-Seiche', 'France', 'Europe', 'FRBR0378', 0),
(0, 'Pirey', 'France', 'Europe', 'FRFC1052', 0),
(0, 'Piriac-sur-Mer', 'France', 'Europe', 'FRPL0677', 0),
(0, 'Pirmil', 'France', 'Europe', 'FRPL0678', 0),
(0, 'Pirou', 'France', 'Europe', 'FRXX6811', 0),
(0, 'Pis', 'France', 'Europe', 'FRMP1741', 0),
(0, 'Pisany', 'France', 'Europe', 'FRPC0740', 0),
(0, 'Piscop', 'France', 'Europe', 'FRIF0471', 0),
(0, 'Piseux', 'France', 'Europe', 'FRHN0664', 0),
(0, 'Pisieu', 'France', 'Europe', 'FRRA1337', 0),
(0, 'Pisseleu', 'France', 'Europe', 'FRPI1295', 0),
(0, 'Pisseleux', 'France', 'Europe', 'FRPI1296', 0),
(0, 'Pisseloup', 'France', 'Europe', 'FRCA1085', 0),
(0, 'Pissos', 'France', 'Europe', 'FRAQ1126', 0),
(0, 'Pissotte', 'France', 'Europe', 'FRPL0679', 0),
(0, 'Pissy', 'France', 'Europe', 'FRPI1297', 0),
(0, 'Pissy-Poville', 'France', 'Europe', 'FRHN0665', 0),
(0, 'Pisy', 'France', 'Europe', 'FRBO0966', 0),
(0, 'Pitgam', 'France', 'Europe', 'FRXX5861', 0),
(0, 'Pithiviers', 'France', 'Europe', 'FRXX3386', 0),
(0, 'Pithiviers-le-Vieil', 'France', 'Europe', 'FRCE0876', 0),
(0, 'Pithon', 'France', 'Europe', 'FRPI1298', 0),
(0, 'Pitres', 'France', 'Europe', 'FRXX4780', 0),
(0, 'Pittefaux', 'France', 'Europe', 'FRNC0712', 0),
(0, 'Pizay', 'France', 'Europe', 'FRRA1338', 0),
(0, 'Pizieux', 'France', 'Europe', 'FRPL0680', 0),
(0, 'Plabennec', 'France', 'Europe', 'FRXX3195', 0),
(0, 'Place', 'France', 'Europe', 'FRPL0681', 0),
(0, 'Placey', 'France', 'Europe', 'FRFC1053', 0),
(0, 'Plachy-Buyon', 'France', 'Europe', 'FRXX2201', 0),
(0, 'Placy', 'France', 'Europe', 'FRBN0988', 0),
(0, 'Placy-Montaigu', 'France', 'Europe', 'FRBN0989', 0),
(0, 'Plagnal', 'France', 'Europe', 'FRRA1339', 0),
(0, 'Plagne', 'France', 'Europe', 'FRMP1742', 0),
(0, 'Plagne', 'France', 'Europe', 'FRRA1340', 0),
(0, 'Plagnole', 'France', 'Europe', 'FRMP1743', 0),
(0, 'Plagny', 'France', 'Europe', 'FRBO0967', 0),
(0, 'Plaigne', 'France', 'Europe', 'FRLR0610', 0),
(0, 'Plailly', 'France', 'Europe', 'FRPI1299', 0),
(0, 'Plaimbois-du-Miroir', 'France', 'Europe', 'FRFC1055', 0),
(0, 'Plaimbois-Vennes', 'France', 'Europe', 'FRFC1054', 0),
(0, 'Plaimpied-Givaudins', 'France', 'Europe', 'FRXX5500', 0),
(0, 'Plaine', 'France', 'Europe', 'FRAL0440', 0),
(0, 'Plaine-de-Walsch', 'France', 'Europe', 'FRLO1257', 0),
(0, 'Plaine-Haute', 'France', 'Europe', 'FRBR0379', 0),
(0, 'Roches', 'France', 'Europe', 'FRLI0351', 0),
(0, 'Roches-Bettaincourt', 'France', 'Europe', 'FRXX5360', 0),
(0, 'Roches-les-Blamont', 'France', 'Europe', 'FRXX5459', 0),
(0, 'Roches-Premarie-Andille', 'France', 'Europe', 'FRPC0803', 0),
(0, 'Roches-sur-Marne', 'France', 'Europe', 'FRXX4638', 0),
(0, 'Rocheserviere', 'France', 'Europe', 'FRXX6038', 0),
(0, 'Rochessauve', 'France', 'Europe', 'FRRA1462', 0),
(0, 'Rochesson', 'France', 'Europe', 'FRLO1371', 0),
(0, 'Rochetaillee', 'France', 'Europe', 'FRCA1194', 0),
(0, 'Rochetaillee', 'France', 'Europe', 'FRRA1463', 0),
(0, 'Rochetaillee-sur-Saone', 'France', 'Europe', 'FRXX4363', 0),
(0, 'Rochetoirin', 'France', 'Europe', 'FRRA1464', 0),
(0, 'Rochetrejoux', 'France', 'Europe', 'FRPL0721', 0),
(0, 'Rochette', 'France', 'Europe', 'FRRA1465', 0),
(0, 'Rocheville', 'France', 'Europe', 'FRBN1052', 0),
(0, 'Rochonvillers', 'France', 'Europe', 'FRLO1372', 0),
(0, 'Rochy-Conde', 'France', 'Europe', 'FRPI1404', 0),
(0, 'Rocles', 'France', 'Europe', 'FRAU0620', 0),
(0, 'Rocles', 'France', 'Europe', 'FRLR0682', 0),
(0, 'Rocles', 'France', 'Europe', 'FRRA1466', 0),
(0, 'Roclincourt', 'France', 'Europe', 'FRNC0780', 0),
(0, 'Rocourt', 'France', 'Europe', 'FRLO1373', 0),
(0, 'Rocourt-Saint-Martin', 'France', 'Europe', 'FRPI1405', 0),
(0, 'Rocquancourt', 'France', 'Europe', 'FRBN1053', 0),
(0, 'Rocquefort', 'France', 'Europe', 'FRHN0708', 0),
(0, 'Rocquemont', 'France', 'Europe', 'FRHN0709', 0),
(0, 'Rocquemont', 'France', 'Europe', 'FRPI1406', 0),
(0, 'Rocquencourt', 'France', 'Europe', 'FRIF0502', 0),
(0, 'Rocquencourt', 'France', 'Europe', 'FRPI1407', 0),
(0, 'Rocques', 'France', 'Europe', 'FRBN1054', 0),
(0, 'Rocquigny', 'France', 'Europe', 'FRCA1195', 0),
(0, 'Rocquigny', 'France', 'Europe', 'FRNC0781', 0),
(0, 'Rocquigny', 'France', 'Europe', 'FRPI1408', 0),
(0, 'Rocroi', 'France', 'Europe', 'FRXX3251', 0),
(0, 'Rodalbe', 'France', 'Europe', 'FRLO1374', 0),
(0, 'Rodelinghem', 'France', 'Europe', 'FRNC0782', 0),
(0, 'Rodelle', 'France', 'Europe', 'FRXX1051', 0),
(0, 'Rodemack', 'France', 'Europe', 'FRLO1375', 0),
(0, 'Roderen', 'France', 'Europe', 'FRAL0477', 0),
(0, 'Rodern', 'France', 'Europe', 'FRAL0478', 0),
(0, 'Rodes', 'France', 'Europe', 'FRLR0683', 0),
(0, 'Rodez', 'France', 'Europe', 'FRXX0171', 0),
(0, 'Rodilhan', 'France', 'Europe', 'FRXX1873', 0),
(0, 'Rodome', 'France', 'Europe', 'FRLR0684', 0),
(0, 'Roellecourt', 'France', 'Europe', 'FRNC0783', 0),
(0, 'Roeschwoog', 'France', 'Europe', 'FRAL0479', 0),
(0, 'Roeulx', 'France', 'Europe', 'FRXX5947', 0),
(0, 'Roeux', 'France', 'Europe', 'FRNC0784', 0),
(0, 'Roeze-sur-Sarthe', 'France', 'Europe', 'FRPL0722', 0),
(0, 'Roffey', 'France', 'Europe', 'FRBO1041', 0),
(0, 'Roffiac', 'France', 'Europe', 'FRAU0621', 0),
(0, 'Rogalle', 'France', 'Europe', 'FRMP1868', 0),
(0, 'Rogecourt', 'France', 'Europe', 'FRPI1409', 0),
(0, 'Rogerville', 'France', 'Europe', 'FRHN0710', 0),
(0, 'Rogeville', 'France', 'Europe', 'FRLO1376', 0),
(0, 'Roggenhouse', 'France', 'Europe', 'FRAL0480', 0),
(0, 'Rogliano', 'France', 'Europe', 'FRXX4078', 0),
(0, 'Rogna', 'France', 'Europe', 'FRFC1147', 0),
(0, 'Rognac', 'France', 'Europe', 'FRXX3974', 0),
(0, 'Rognaix', 'France', 'Europe', 'FRRA1467', 0),
(0, 'Rognes', 'France', 'Europe', 'FRXX2528', 0),
(0, 'Rognon', 'France', 'Europe', 'FRFC1148', 0),
(0, 'Rognonas', 'France', 'Europe', 'FRXX6248', 0),
(0, 'Rogny', 'France', 'Europe', 'FRPI1410', 0),
(0, 'Rogny-les-Sept-Ecluses', 'France', 'Europe', 'FRXX4533', 0),
(0, 'Rogues', 'France', 'Europe', 'FRLR0685', 0),
(0, 'Rogy', 'France', 'Europe', 'FRPI1411', 0),
(0, 'Rohaire', 'France', 'Europe', 'FRCE0947', 0),
(0, 'Rohan', 'France', 'Europe', 'FRXX5198', 0),
(0, 'Rohr', 'France', 'Europe', 'FRAL0481', 0),
(0, 'Rohrbach-les-Bitche', 'France', 'Europe', 'FRXX5656', 0),
(0, 'Rohrwiller', 'France', 'Europe', 'FRXX5837', 0),
(0, 'Roiffe', 'France', 'Europe', 'FRPC0804', 0),
(0, 'Roiffieux', 'France', 'Europe', 'FRXX4689', 0),
(0, 'Roiglise', 'France', 'Europe', 'FRPI1412', 0),
(0, 'Roilly', 'France', 'Europe', 'FRBO1042', 0),
(0, 'Roinville', 'France', 'Europe', 'FRCE0948', 0),
(0, 'Roinville', 'France', 'Europe', 'FRIF0503', 0),
(0, 'Roinvilliers', 'France', 'Europe', 'FRIF0504', 0),
(0, 'Roisel', 'France', 'Europe', 'FRPI1413', 0),
(0, 'Saint-Christoly-de-Blaye', 'France', 'Europe', 'FRAQ1279', 0),
(0, 'Saint-Christoly-Medoc', 'France', 'Europe', 'FRAQ1278', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRAU0659', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRCE0994', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRLI0389', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRMP1955', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRPC0839', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRPC0840', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRPC0841', 0),
(0, 'Saint-Christophe', 'France', 'Europe', 'FRXX6545', 0),
(0, 'Saint-Christophe-a-Berry', 'France', 'Europe', 'FRPI1468', 0),
(0, 'Saint-Christophe-d`Allier', 'France', 'Europe', 'FRAU0660', 0),
(0, 'Saint-Christophe-de-Chaulieu', 'France', 'Europe', 'FRBN1107', 0),
(0, 'Saint-Christophe-de-Double', 'France', 'Europe', 'FRAQ1280', 0),
(0, 'Saint-Christophe-de-Valains', 'France', 'Europe', 'FRBR0535', 0),
(0, 'Saint-Christophe-des-Bardes', 'France', 'Europe', 'FRAQ1281', 0),
(0, 'Saint-Christophe-des-Bois', 'France', 'Europe', 'FRBR0536', 0),
(0, 'Saint-Christophe-Dodinicourt', 'France', 'Europe', 'FRCA1236', 0),
(0, 'Saint-Christophe-du-Bois', 'France', 'Europe', 'FRPL0764', 0),
(0, 'Saint-Christophe-du-Foc', 'France', 'Europe', 'FRBN1108', 0),
(0, 'Saint-Christophe-du-Jambet', 'France', 'Europe', 'FRXX3567', 0),
(0, 'Saint-Christophe-du-Ligneron', 'France', 'Europe', 'FRXX1635', 0),
(0, 'Saint-Christophe-du-Luat', 'France', 'Europe', 'FRPL0765', 0),
(0, 'Saint-Christophe-en-Bazelle', 'France', 'Europe', 'FRCE0995', 0),
(0, 'Saint-Christophe-en-Boucherie', 'France', 'Europe', 'FRCE0996', 0),
(0, 'Saint-Christophe-en-Bresse', 'France', 'Europe', 'FRBO1099', 0),
(0, 'Saint-Christophe-en-Brionnais', 'France', 'Europe', 'FRBO1100', 0),
(0, 'Saint-Christophe-en-Champagne', 'France', 'Europe', 'FRPL0766', 0),
(0, 'Saint-Christophe-en-Oisans', 'France', 'Europe', 'FRRA1561', 0),
(0, 'Saint-Christophe-et-le-Laris', 'France', 'Europe', 'FRXX4797', 0),
(0, 'Saint-Christophe-la-Couperie', 'France', 'Europe', 'FRPL0767', 0),
(0, 'Saint-Christophe-le-Chaudry', 'France', 'Europe', 'FRCE0997', 0),
(0, 'Saint-Christophe-le-Jajolet', 'France', 'Europe', 'FRBN1109', 0),
(0, 'Saint-Christophe-les-Gorges', 'France', 'Europe', 'FRXX5466', 0),
(0, 'Saint-Christophe-sur-Avre', 'France', 'Europe', 'FRXX1106', 0),
(0, 'Saint-Christophe-sur-Conde', 'France', 'Europe', 'FRHN0750', 0),
(0, 'Saint-Christophe-sur-Dolaison', 'France', 'Europe', 'FRAU0661', 0),
(0, 'Saint-Christophe-sur-Guiers', 'France', 'Europe', 'FRRA1562', 0);
INSERT INTO `#__eweather_locations` (`id`, `city`, `country`, `region`, `loc_id`, `published`) VALUES
(0, 'Saint-Christophe-sur-le-Nais', 'France', 'Europe', 'FRCE0998', 0),
(0, 'Saint-Christophe-sur-Roc', 'France', 'Europe', 'FRPC0842', 0),
(0, 'Saint-Christophe-Vallon', 'France', 'Europe', 'FRMP1956', 0),
(0, 'Saint-Cibard', 'France', 'Europe', 'FRAQ1282', 0),
(0, 'Saint-Cierge-la-Serre', 'France', 'Europe', 'FRRA1563', 0),
(0, 'Saint-Cierge-sous-le-Cheylard', 'France', 'Europe', 'FRRA1564', 0),
(0, 'Saint-Ciergues', 'France', 'Europe', 'FRCA1237', 0),
(0, 'Saint-Ciers-Champagne', 'France', 'Europe', 'FRPC0843', 0),
(0, 'Saint-Ciers-d`Abzac', 'France', 'Europe', 'FRAQ1283', 0),
(0, 'Saint-Ciers-de-Canesse', 'France', 'Europe', 'FRXX3546', 0),
(0, 'Saint-Ciers-du-Taillon', 'France', 'Europe', 'FRPC0844', 0),
(0, 'Saint-Ciers-sur-Bonnieure', 'France', 'Europe', 'FRPC0845', 0),
(0, 'Saint-Ciers-sur-Gironde', 'France', 'Europe', 'FRXX5044', 0),
(0, 'Saint-Cirgue', 'France', 'Europe', 'FRXX2932', 0),
(0, 'Saint-Cirgues', 'France', 'Europe', 'FRAU0662', 0),
(0, 'Saint-Cirgues', 'France', 'Europe', 'FRMP1957', 0),
(0, 'Saint-Cirgues-de-Jordanne', 'France', 'Europe', 'FRXX2460', 0),
(0, 'Saint-Cirgues-de-Malbert', 'France', 'Europe', 'FRAU0663', 0),
(0, 'Saint-Cirgues-de-Prades', 'France', 'Europe', 'FRRA1565', 0),
(0, 'Saint-Cirgues-en-Montagne', 'France', 'Europe', 'FRXX6229', 0),
(0, 'Saint-Cirgues-la-Loutre', 'France', 'Europe', 'FRLI0390', 0),
(0, 'Saint-Cirgues-sur-Couze', 'France', 'Europe', 'FRAU0664', 0),
(0, 'Saint-Cirice', 'France', 'Europe', 'FRMP1958', 0),
(0, 'Saint-Cirq', 'France', 'Europe', 'FRAQ1284', 0),
(0, 'Saint-Cirq', 'France', 'Europe', 'FRMP1959', 0),
(0, 'Saint-Cirq-Lapopie', 'France', 'Europe', 'FRMP1960', 0),
(0, 'Saint-Cirq-Madelon', 'France', 'Europe', 'FRAQ1285', 0),
(0, 'Saint-Cirq-Souillaguet', 'France', 'Europe', 'FRMP1961', 0),
(0, 'Saint-Civran', 'France', 'Europe', 'FRCE0999', 0),
(0, 'Saint-Clair', 'France', 'Europe', 'FRMP1962', 0),
(0, 'Saint-Clair', 'France', 'Europe', 'FRMP1963', 0),
(0, 'Saint-Clair', 'France', 'Europe', 'FRPC0846', 0),
(0, 'Saint-Clair', 'France', 'Europe', 'FRRA1566', 0),
(0, 'Saint-Clair-d`Arcey', 'France', 'Europe', 'FRHN0751', 0),
(0, 'Saint-Clair-de-Halouze', 'France', 'Europe', 'FRXX4412', 0),
(0, 'Saint-Clair-de-la-Tour', 'France', 'Europe', 'FRRA1567', 0),
(0, 'Saint-Clair-du-Rhone', 'France', 'Europe', 'FRXX1247', 0),
(0, 'Saint-Clair-sur-Epte', 'France', 'Europe', 'FRXX2368', 0),
(0, 'Saint-Clair-sur-Galaure', 'France', 'Europe', 'FRXX1321', 0),
(0, 'Saint-Clair-sur-l`Elle', 'France', 'Europe', 'FRBN1110', 0),
(0, 'Saint-Clair-sur-les-Monts', 'France', 'Europe', 'FRHN0752', 0),
(0, 'Saint-Clar', 'France', 'Europe', 'FRXX3556', 0),
(0, 'Toucy', 'France', 'Europe', 'FRBO1394', 0),
(0, 'Toudon', 'France', 'Europe', 'FRPA0640', 0),
(0, 'Touet-de-l`Escarene', 'France', 'Europe', 'FRPA0641', 0),
(0, 'Touet-sur-Var', 'France', 'Europe', 'FRPA0642', 0),
(0, 'Touffailles', 'France', 'Europe', 'FRMP2336', 0),
(0, 'Toufflers', 'France', 'Europe', 'FRNC0919', 0),
(0, 'Touffreville', 'France', 'Europe', 'FRBN1410', 0),
(0, 'Touffreville', 'France', 'Europe', 'FRHN0947', 0),
(0, 'Touffreville-la-Cable', 'France', 'Europe', 'FRHN0948', 0),
(0, 'Touffreville-la-Corbeline', 'France', 'Europe', 'FRHN0949', 0),
(0, 'Touffreville-sur-Eu', 'France', 'Europe', 'FRXX1422', 0),
(0, 'Touget', 'France', 'Europe', 'FRMP2337', 0),
(0, 'Tougnete', 'France', 'Europe', 'FRXX0265', 0),
(0, 'Touho', 'France', 'Europe', 'FRXX7951', 0),
(0, 'Touille', 'France', 'Europe', 'FRMP2338', 0),
(0, 'Touillon', 'France', 'Europe', 'FRBO1395', 0),
(0, 'Touillon-et-Loutelet', 'France', 'Europe', 'FRFC1290', 0),
(0, 'Toujouse', 'France', 'Europe', 'FRMP2339', 0),
(0, 'Toul', 'France', 'Europe', 'FRXX6081', 0),
(0, 'Toul-Rosieres', 'France', 'Europe', 'FRXX0174', 0),
(0, 'Toulaud', 'France', 'Europe', 'FRRA1994', 0),
(0, 'Toulenne', 'France', 'Europe', 'FRAQ1682', 0),
(0, 'Touligny', 'France', 'Europe', 'FRCA1457', 0),
(0, 'Toulis-et-Attencourt', 'France', 'Europe', 'FRPI1627', 0),
(0, 'Toulon', 'France', 'Europe', 'FRXX0098', 0),
(0, 'Toulon-la-Montagne', 'France', 'Europe', 'FRXX5366', 0),
(0, 'Toulon-sur-Allier', 'France', 'Europe', 'FRXX3162', 0),
(0, 'Toulon-sur-Arroux', 'France', 'Europe', 'FRXX2639', 0),
(0, 'Toulonjac', 'France', 'Europe', 'FRMP2340', 0),
(0, 'Toulouges', 'France', 'Europe', 'FRXX5790', 0),
(0, 'Toulouse', 'France', 'Europe', 'FRXX0099', 0),
(0, 'Toulouse-le-Chateau', 'France', 'Europe', 'FRFC1291', 0),
(0, 'Toulouzette', 'France', 'Europe', 'FRAQ1683', 0),
(0, 'Toulx-Sainte-Croix', 'France', 'Europe', 'FRLI0540', 0),
(0, 'Touques', 'France', 'Europe', 'FRXX1084', 0),
(0, 'Touquettes', 'France', 'Europe', 'FRBN1411', 0),
(0, 'Touquin', 'France', 'Europe', 'FRXX3670', 0),
(0, 'Tour-de-Faure', 'France', 'Europe', 'FRXX1684', 0),
(0, 'Tour-en-Bessin', 'France', 'Europe', 'FRBN1412', 0),
(0, 'Tour-en-Sologne', 'France', 'Europe', 'FRCE1232', 0),
(0, 'Tourailles', 'France', 'Europe', 'FRCE1233', 0),
(0, 'Tourailles-sous-Bois', 'France', 'Europe', 'FRLO1609', 0),
(0, 'Tourbes', 'France', 'Europe', 'FRLR0900', 0),
(0, 'Tourcelles-Chaumont', 'France', 'Europe', 'FRCA1458', 0),
(0, 'Tourch', 'France', 'Europe', 'FRBR0707', 0),
(0, 'Tourcoing', 'France', 'Europe', 'FRXX0277', 0),
(0, 'Tourdun', 'France', 'Europe', 'FRMP2341', 0),
(0, 'Tourette-du-Chateau', 'France', 'Europe', 'FRPA0643', 0),
(0, 'Tourgeville', 'France', 'Europe', 'FRBN1413', 0),
(0, 'Tourlaville', 'France', 'Europe', 'FRXX5878', 0),
(0, 'Tourliac', 'France', 'Europe', 'FRAQ1684', 0),
(0, 'Tourly', 'France', 'Europe', 'FRPI1628', 0),
(0, 'Tourmignies', 'France', 'Europe', 'FRXX2064', 0),
(0, 'Tourmont', 'France', 'Europe', 'FRFC1292', 0),
(0, 'Tournai-sur-Dive', 'France', 'Europe', 'FRXX3516', 0),
(0, 'Tournan', 'France', 'Europe', 'FRMP2342', 0),
(0, 'Tournan-en-Brie', 'France', 'Europe', 'FRXX5615', 0),
(0, 'Tournans', 'France', 'Europe', 'FRFC1293', 0),
(0, 'Tournavaux', 'France', 'Europe', 'FRCA1459', 0),
(0, 'Tournay', 'France', 'Europe', 'FRMP2343', 0),
(0, 'Tournay-sur-Odon', 'France', 'Europe', 'FRBN1414', 0),
(0, 'Tournebu', 'France', 'Europe', 'FRBN1415', 0),
(0, 'Tournecoupe', 'France', 'Europe', 'FRMP2344', 0),
(0, 'Tournedos-Bois-Hubert', 'France', 'Europe', 'FRHN0950', 0),
(0, 'Tournedos-sur-Seine', 'France', 'Europe', 'FRHN0951', 0),
(0, 'Tournedoz', 'France', 'Europe', 'FRFC1294', 0),
(0, 'Tournefeuille', 'France', 'Europe', 'FRXX4263', 0),
(0, 'Tournefort', 'France', 'Europe', 'FRPA0644', 0),
(0, 'Tournehem-sur-la-Hem', 'France', 'Europe', 'FRNC0920', 0),
(0, 'Tournemire', 'France', 'Europe', 'FRAU0864', 0),
(0, 'Tournemire', 'France', 'Europe', 'FRMP2345', 0),
(0, 'Tournes', 'France', 'Europe', 'FRXX4489', 0),
(0, 'Tourneville', 'France', 'Europe', 'FRHN0952', 0),
(0, 'Tourniac', 'France', 'Europe', 'FRAU0865', 0),
(0, 'Tournieres', 'France', 'Europe', 'FRBN1416', 0),
(0, 'Tournissan', 'France', 'Europe', 'FRLR0901', 0),
(0, 'Tournoisis', 'France', 'Europe', 'FRCE1234', 0),
(0, 'Tournon', 'France', 'Europe', 'FRRA1995', 0),
(0, 'Tournon-d`Agenais', 'France', 'Europe', 'FRAQ1685', 0),
(0, 'Tournon-Saint-Martin', 'France', 'Europe', 'FRXX2797', 0),
(0, 'Verderonne', 'France', 'Europe', 'FRPI1691', 0),
(0, 'Verdes', 'France', 'Europe', 'FRCE1274', 0),
(0, 'Verdese', 'France', 'Europe', 'FRCO0227', 0),
(0, 'Verdets', 'France', 'Europe', 'FRAQ1722', 0),
(0, 'Verdigny', 'France', 'Europe', 'FRCE1275', 0),
(0, 'Verdille', 'France', 'Europe', 'FRPC1133', 0),
(0, 'Verdilly', 'France', 'Europe', 'FRPI1692', 0),
(0, 'Verdon', 'France', 'Europe', 'FRAQ1723', 0),
(0, 'Verdon', 'France', 'Europe', 'FRCA1538', 0),
(0, 'Verdonnet', 'France', 'Europe', 'FRBO1460', 0),
(0, 'Verdun', 'France', 'Europe', 'FRMP2423', 0),
(0, 'Verdun', 'France', 'Europe', 'FRXX0431', 0),
(0, 'Verdun-en-Lauragais', 'France', 'Europe', 'FRLR0940', 0),
(0, 'Verdun-sur-Garonne', 'France', 'Europe', 'FRXX2725', 0),
(0, 'Verdun-sur-le-Doubs', 'France', 'Europe', 'FRXX4910', 0),
(0, 'Vereaux', 'France', 'Europe', 'FRCE1276', 0),
(0, 'Verel-de-Montbel', 'France', 'Europe', 'FRRA2071', 0),
(0, 'Verel-Pragondran', 'France', 'Europe', 'FRRA2070', 0),
(0, 'Veretz', 'France', 'Europe', 'FRCE1277', 0),
(0, 'Vereux', 'France', 'Europe', 'FRFC1372', 0),
(0, 'Verfeil', 'France', 'Europe', 'FRMP2424', 0),
(0, 'Verfeil', 'France', 'Europe', 'FRMP2425', 0),
(0, 'Verfeuil', 'France', 'Europe', 'FRPA0686', 0),
(0, 'Vergaville', 'France', 'Europe', 'FRLO1712', 0),
(0, 'Vergeal', 'France', 'Europe', 'FRBR0779', 0),
(0, 'Verger-sur-Dive', 'France', 'Europe', 'FRPC1134', 0),
(0, 'Vergeroux', 'France', 'Europe', 'FRPC1135', 0),
(0, 'Verges', 'France', 'Europe', 'FRFC1373', 0),
(0, 'Vergetot', 'France', 'Europe', 'FRHN0987', 0),
(0, 'Vergezac', 'France', 'Europe', 'FRAU0908', 0),
(0, 'Vergeze', 'France', 'Europe', 'FRXX2568', 0),
(0, 'Vergheas', 'France', 'Europe', 'FRAU0909', 0),
(0, 'Vergies', 'France', 'Europe', 'FRPI1693', 0),
(0, 'Vergigny', 'France', 'Europe', 'FRBO1461', 0),
(0, 'Vergisson', 'France', 'Europe', 'FRBO1462', 0),
(0, 'Vergne', 'France', 'Europe', 'FRPC1136', 0),
(0, 'Vergoignan', 'France', 'Europe', 'FRMP2426', 0),
(0, 'Vergoncey', 'France', 'Europe', 'FRBN1463', 0),
(0, 'Vergongheon', 'France', 'Europe', 'FRAU0910', 0),
(0, 'Vergonnes', 'France', 'Europe', 'FRPL1037', 0),
(0, 'Vergons', 'France', 'Europe', 'FRPA0687', 0),
(0, 'Vergranne', 'France', 'Europe', 'FRFC1374', 0),
(0, 'Vergt', 'France', 'Europe', 'FRAQ1724', 0),
(0, 'Vergt-de-Biron', 'France', 'Europe', 'FRXX1039', 0),
(0, 'Veria', 'France', 'Europe', 'FRFC1375', 0),
(0, 'Verignon', 'France', 'Europe', 'FRPA0688', 0),
(0, 'Verigny', 'France', 'Europe', 'FRCE1278', 0),
(0, 'Verin', 'France', 'Europe', 'FRRA2072', 0),
(0, 'Verines', 'France', 'Europe', 'FRPC1137', 0),
(0, 'Verissey', 'France', 'Europe', 'FRBO1463', 0),
(0, 'Verizet-Fleurville', 'France', 'Europe', 'FRBO1464', 0),
(0, 'Verjon', 'France', 'Europe', 'FRRA2073', 0),
(0, 'Verjux', 'France', 'Europe', 'FRBO1465', 0),
(0, 'Verlans', 'France', 'Europe', 'FRFC1376', 0),
(0, 'Verlhac-Tescou', 'France', 'Europe', 'FRMP2427', 0),
(0, 'Verlin', 'France', 'Europe', 'FRBO1466', 0),
(0, 'Verlincthun', 'France', 'Europe', 'FRNC0938', 0),
(0, 'Verlinghem', 'France', 'Europe', 'FRXX1169', 0),
(0, 'Verlus', 'France', 'Europe', 'FRMP2428', 0),
(0, 'Vermand', 'France', 'Europe', 'FRPI1694', 0),
(0, 'Vermandovillers', 'France', 'Europe', 'FRPI1695', 0),
(0, 'Vermelles', 'France', 'Europe', 'FRNC0939', 0),
(0, 'Vermenton', 'France', 'Europe', 'FRBO1467', 0),
(0, 'Vermondans', 'France', 'Europe', 'FRFC1377', 0),
(0, 'Vern-d`Anjou', 'France', 'Europe', 'FRPL1038', 0),
(0, 'Vern-sur-Seiche', 'France', 'Europe', 'FRXX5769', 0),
(0, 'Vernais', 'France', 'Europe', 'FRCE1279', 0),
(0, 'Vernaison', 'France', 'Europe', 'FRRA2074', 0),
(0, 'Vernajoul', 'France', 'Europe', 'FRMP2429', 0),
(0, 'Vernancourt', 'France', 'Europe', 'FRCA1539', 0),
(0, 'Vernantes', 'France', 'Europe', 'FRPL1039', 0),
(0, 'Vernantois', 'France', 'Europe', 'FRFC1378', 0),
(0, 'Vernas', 'France', 'Europe', 'FRRA2075', 0),
(0, 'Vernassal', 'France', 'Europe', 'FRAU0911', 0),
(0, 'Vernaux', 'France', 'Europe', 'FRMP2430', 0),
(0, 'Vernay', 'France', 'Europe', 'FRRA2076', 0),
(0, 'Verne', 'France', 'Europe', 'FRFC1379', 0),
(0, 'Vernegues', 'France', 'Europe', 'FRXX5428', 0),
(0, 'Verneiges', 'France', 'Europe', 'FRLI0556', 0),
(0, 'Verneil', 'France', 'Europe', 'FRRA2077', 0),
(0, 'Arrout', 'France', 'Europe', 'FRMP0080', 0),
(0, 'Arry', 'France', 'Europe', 'FRLO0045', 0),
(0, 'Arry', 'France', 'Europe', 'FRPI0051', 0),
(0, 'Ars', 'France', 'Europe', 'FRLI0015', 0),
(0, 'Ars', 'France', 'Europe', 'FRPC0040', 0),
(0, 'Arsac', 'France', 'Europe', 'FRAQ0056', 0),
(0, 'Arsans', 'France', 'Europe', 'FRFC0056', 0),
(0, 'Arsonval', 'France', 'Europe', 'FRCA0041', 0),
(0, 'Arsy', 'France', 'Europe', 'FRPI0052', 0),
(0, 'Artaix', 'France', 'Europe', 'FRBO0035', 0),
(0, 'Artas', 'France', 'Europe', 'FRRA0080', 0),
(0, 'Artassenx', 'France', 'Europe', 'FRAQ0057', 0),
(0, 'Artemps', 'France', 'Europe', 'FRPI0053', 0),
(0, 'Arthel', 'France', 'Europe', 'FRBO0036', 0),
(0, 'Arthemonay', 'France', 'Europe', 'FRRA0081', 0),
(0, 'Arthenac', 'France', 'Europe', 'FRPC0041', 0),
(0, 'Arthenas', 'France', 'Europe', 'FRFC0057', 0),
(0, 'Arthes', 'France', 'Europe', 'FRMP0081', 0),
(0, 'Artheze', 'France', 'Europe', 'FRPL0019', 0),
(0, 'Arthies', 'France', 'Europe', 'FRIF0019', 0),
(0, 'Arthonnay', 'France', 'Europe', 'FRBO0037', 0),
(0, 'Arthun', 'France', 'Europe', 'FRRA0082', 0),
(0, 'Artigat', 'France', 'Europe', 'FRMP0082', 0),
(0, 'Artigueloutan', 'France', 'Europe', 'FRAQ0058', 0),
(0, 'Artiguelouve', 'France', 'Europe', 'FRAQ0059', 0),
(0, 'Artiguemy', 'France', 'Europe', 'FRMP0083', 0),
(0, 'Artigues', 'France', 'Europe', 'FRLR0034', 0),
(0, 'Artigues', 'France', 'Europe', 'FRMP0084', 0),
(0, 'Artigues', 'France', 'Europe', 'FRMP0085', 0),
(0, 'Artigues', 'France', 'Europe', 'FRPA0016', 0),
(0, 'Artix', 'France', 'Europe', 'FRAQ0060', 0),
(0, 'Artix', 'France', 'Europe', 'FRMP0086', 0),
(0, 'Artonges', 'France', 'Europe', 'FRPI0054', 0),
(0, 'Artres', 'France', 'Europe', 'FRNC0032', 0),
(0, 'Artzenheim', 'France', 'Europe', 'FRAL0006', 0),
(0, 'Arudy', 'France', 'Europe', 'FRAQ0061', 0),
(0, 'Arue', 'France', 'Europe', 'FRAQ0062', 0),
(0, 'Arue', 'France', 'Europe', 'FRXX7847', 0),
(0, 'Arutua', 'France', 'Europe', 'FRXX7900', 0),
(0, 'Arvant', 'France', 'Europe', 'FRAU0019', 0),
(0, 'Arvert', 'France', 'Europe', 'FRXX6222', 0),
(0, 'Arveyres', 'France', 'Europe', 'FRAQ0063', 0),
(0, 'Arvieu', 'France', 'Europe', 'FRMP0087', 0),
(0, 'Arvieux', 'France', 'Europe', 'FRXX0544', 0),
(0, 'Arvigna', 'France', 'Europe', 'FRMP0088', 0),
(0, 'Arvillard', 'France', 'Europe', 'FRRA0083', 0),
(0, 'Arville', 'France', 'Europe', 'FRIF0020', 0),
(0, 'Arvillers', 'France', 'Europe', 'FRXX2925', 0),
(0, 'Arx', 'France', 'Europe', 'FRAQ0064', 0),
(0, 'Arzay', 'France', 'Europe', 'FRRA0084', 0),
(0, 'Arzens', 'France', 'Europe', 'FRLR0035', 0),
(0, 'Arzillieres-Neuville', 'France', 'Europe', 'FRCA0042', 0),
(0, 'Arzviller', 'France', 'Europe', 'FRXX2652', 0),
(0, 'Asco', 'France', 'Europe', 'FRXX4829', 0),
(0, 'Ascou', 'France', 'Europe', 'FRMP0089', 0),
(0, 'Ascoux', 'France', 'Europe', 'FRCE0026', 0),
(0, 'Ascros', 'France', 'Europe', 'FRPA0017', 0),
(0, 'Aslonnes', 'France', 'Europe', 'FRPC0042', 0),
(0, 'Asnans-Beauvoisin', 'France', 'Europe', 'FRFC0058', 0),
(0, 'Asnieres-sur-Seine', 'France', 'Europe', 'FRXX0288', 0),
(0, 'Asnois', 'France', 'Europe', 'FRBO0038', 0),
(0, 'Asnois', 'France', 'Europe', 'FRPC0043', 0),
(0, 'Aspach', 'France', 'Europe', 'FRAL0007', 0),
(0, 'Aspach', 'France', 'Europe', 'FRLO0046', 0),
(0, 'Asperes', 'France', 'Europe', 'FRPA0018', 0),
(0, 'Asperjoc', 'France', 'Europe', 'FRRA0085', 0),
(0, 'Aspet', 'France', 'Europe', 'FRMP0090', 0),
(0, 'Aspiran', 'France', 'Europe', 'FRLR0036', 0),
(0, 'Aspremont', 'France', 'Europe', 'FRXX3900', 0),
(0, 'Asprieres', 'France', 'Europe', 'FRMP0091', 0),
(0, 'Asque', 'France', 'Europe', 'FRMP0092', 0),
(0, 'Asques', 'France', 'Europe', 'FRAQ0065', 0),
(0, 'Asques', 'France', 'Europe', 'FRMP0093', 0),
(0, 'Asquins', 'France', 'Europe', 'FRBO0039', 0),
(0, 'Assac', 'France', 'Europe', 'FRMP0094', 0),
(0, 'Assainvillers', 'France', 'Europe', 'FRPI0055', 0),
(0, 'Assais-les-Jumeaux', 'France', 'Europe', 'FRPC0044', 0),
(0, 'Assas', 'France', 'Europe', 'FRLR0037', 0),
(0, 'Assat', 'France', 'Europe', 'FRAQ0066', 0),
(0, 'Assay', 'France', 'Europe', 'FRCE0027', 0),
(0, 'Berteaucourt-les-Dames', 'France', 'Europe', 'FRXX4484', 0),
(0, 'Bertheauville', 'France', 'Europe', 'FRHN0051', 0),
(0, 'Bertheauville', 'France', 'Europe', 'FRHN0052', 0),
(0, 'Berthecourt', 'France', 'Europe', 'FRPI0147', 0),
(0, 'Berthegon', 'France', 'Europe', 'FRPC0094', 0),
(0, 'Berthelange', 'France', 'Europe', 'FRFC0121', 0),
(0, 'Berthelming', 'France', 'Europe', 'FRLO0137', 0),
(0, 'Berthen', 'France', 'Europe', 'FRNC0111', 0),
(0, 'Berthenay', 'France', 'Europe', 'FRCE0057', 0),
(0, 'Berthenicourt', 'France', 'Europe', 'FRPI0148', 0),
(0, 'Berthenonville', 'France', 'Europe', 'FRHN0053', 0),
(0, 'Bertholene', 'France', 'Europe', 'FRMP0246', 0),
(0, 'Berthouville', 'France', 'Europe', 'FRHN0054', 0),
(0, 'Bertignat', 'France', 'Europe', 'FRAU0052', 0),
(0, 'Bertignolles', 'France', 'Europe', 'FRCA0107', 0),
(0, 'Bertoncourt', 'France', 'Europe', 'FRCA0108', 0),
(0, 'Bertrambois', 'France', 'Europe', 'FRLO0138', 0),
(0, 'Bertrancourt', 'France', 'Europe', 'FRPI0149', 0),
(0, 'Bertrange', 'France', 'Europe', 'FRLO0139', 0),
(0, 'Bertre', 'France', 'Europe', 'FRMP0247', 0),
(0, 'Bertren', 'France', 'Europe', 'FRMP0248', 0),
(0, 'Bertreville', 'France', 'Europe', 'FRHN0055', 0),
(0, 'Bertrichamps', 'France', 'Europe', 'FRLO0140', 0),
(0, 'Bertricourt', 'France', 'Europe', 'FRPI0150', 0),
(0, 'Bertrimont', 'France', 'Europe', 'FRHN0056', 0),
(0, 'Bertrimoutier', 'France', 'Europe', 'FRLO0141', 0),
(0, 'Bertry', 'France', 'Europe', 'FRNC0112', 0),
(0, 'Beru', 'France', 'Europe', 'FRBO0085', 0),
(0, 'Beruges', 'France', 'Europe', 'FRPC0095', 0),
(0, 'Berus', 'France', 'Europe', 'FRBN0084', 0),
(0, 'Berville', 'France', 'Europe', 'FRBN0085', 0),
(0, 'Berville', 'France', 'Europe', 'FRIF0052', 0),
(0, 'Berze-la-Ville', 'France', 'Europe', 'FRBO0086', 0),
(0, 'Berze-le-Chatel', 'France', 'Europe', 'FRBO0087', 0),
(0, 'Berzeme', 'France', 'Europe', 'FRRA0162', 0),
(0, 'Berzet', 'France', 'Europe', 'FRAU0053', 0),
(0, 'Berzieux', 'France', 'Europe', 'FRCA0109', 0),
(0, 'Besain', 'France', 'Europe', 'FRFC0122', 0),
(0, 'Besancon', 'France', 'Europe', 'FRXX0141', 0),
(0, 'Besayes', 'France', 'Europe', 'FRRA0163', 0),
(0, 'Bescat', 'France', 'Europe', 'FRAQ0152', 0),
(0, 'Besignan', 'France', 'Europe', 'FRRA0164', 0),
(0, 'Besingrand', 'France', 'Europe', 'FRAQ0153', 0),
(0, 'Beslon', 'France', 'Europe', 'FRBN0086', 0),
(0, 'Besme', 'France', 'Europe', 'FRPI0151', 0),
(0, 'Besmont', 'France', 'Europe', 'FRPI0152', 0),
(0, 'Besnans', 'France', 'Europe', 'FRFC0123', 0),
(0, 'Besneville', 'France', 'Europe', 'FRBN0087', 0),
(0, 'Besny-et-Loizy', 'France', 'Europe', 'FRPI0153', 0),
(0, 'Bessac', 'France', 'Europe', 'FRPC0096', 0),
(0, 'Bessamorel', 'France', 'Europe', 'FRAU0054', 0),
(0, 'Bessan', 'France', 'Europe', 'FRXX1146', 0),
(0, 'Bessancourt', 'France', 'Europe', 'FRXX4563', 0),
(0, 'Bessans', 'France', 'Europe', 'FRXX0477', 0),
(0, 'Bessas', 'France', 'Europe', 'FRRA0165', 0),
(0, 'Bessay', 'France', 'Europe', 'FRPL0055', 0),
(0, 'Besse', 'France', 'Europe', 