<?php
/**
 * This file contains the allLocations view definition
 *  for the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport( 'joomla.application.component.view');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('JButtonEWeather', COM_EWEATHER_ADMIN_CLASSES_PATH.DS.'jbuttonweather.php' );


class eWeatherViewAllLocations extends JView
{
	public function display($tpl = null)
	{
		// get the Data
        $form = $this->get('Form');
        $fieldset = $form->getFieldset('eWeatherLocationFilters');
        $rows = $this->get('Items');
		$pagination = $this->get('Pagination');
		$totalLocations = $this->get('totalLocations');
		$publishedLocations = $this->get('publishedLocations');
		$locationsInCurrentView = $this->get('locationsInCurrentView');
		$defaultLocation = $this->get('defaultLocation');

        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            JError::raiseError(500, implode('<br />', $errors));
            return false;
        }

        // Assign the Data
        $this->fieldset = $fieldset;
		$this->rows = $rows;
		$this->pagination = $pagination;
		$this->totalLocations = $totalLocations;
		$this->publishedLocations = $publishedLocations;
		$this->locationsInCurrentView = $locationsInCurrentView;
		$this->defaultLocation = $defaultLocation;
		
        // Set the toolbar
        $this->addToolBar();
 
        // Display the template
        parent::display($tpl);
 
        // Set the document
        $this->setDocument();
	}
	
	/**
     * Setting the toolbar
     */
    protected function addToolBar() 
    {
        JRequest::setVar('hidemainmenu', true);
        
		// Set toolbar items for the page
        JToolBarHelper::title( JText::_('COM_EWEATHER_ADMIN_TITLE') . ' ' . JText::_('COM_EWEATHER_ADMIN_LOCATION_TITLE'), 'eweather_locations' );
        $bar = JToolBar::getInstance('toolbar');
		$bar->appendButton( 'eWeather', 'default', JText::_( 'JTOOLBAR_DEFAULT' ), 'location_makeDefault', false);
		$bar->appendButton( 'eWeather', 'publish', JText::_( 'JTOOLBAR_PUBLISH' ), 'location_publish', false);
		$bar->appendButton( 'eWeather', 'unpublish', JText::_( 'JTOOLBAR_UNPUBLISH' ), 'location_unpublish', false);
		$bar->appendButton( 'eWeather', 'publish', JText::_( 'COM_EWEATHER_ADMIN_LOCATION_PUBLISH_ALL_VIEW_BUTTON' ), 'location_publishAll', false);
		$bar->appendButton( 'eWeather', 'unpublish', JText::_( 'COM_EWEATHER_ADMIN_LOCATION_UNPUBLISH_ALL_VIEW_BUTTON' ), 'location_unpublishAll', false);
		$bar->appendButton( 'eWeather', 'cancel', JTEXT::_('JTOOLBAR_CLOSE'), 'location_close', false );
    }

    /**
     * Method to set up the document properties
     *
     * @return void
     */
    protected function setDocument() 
    {
    	// set the page title
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_EWEATHER_ADMIN_TITLE') . ' :: ' .JText::_('COM_EWEATHER_ADMIN_LOCATION_TITLE'));
		
		// add our stylesheet
        JHTML::stylesheet( 'eweather.admin.css', COM_EWEATHER_ADMIN_CSS_URL );
    }
    
}
