<?php
/**
 * This file contains the Configuration Manager view definition
 *  for the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

jimport( 'joomla.application.component.view');

// setup paths
require_once( JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('JButtonEWeather', COM_EWEATHER_ADMIN_CLASSES_PATH.DS.'jbuttonweather.php' );


class eWeatherViewConfig extends JView
{
    /**
     * display method of Hello view
     * @return void
     */
    public function display($tpl = null) 
    {
        // get the Data
        $form = $this->get('Form');
		$script = $this->get('Script');
        
        // Check for errors.
        if (count($errors = $this->get('Errors'))) 
        {
            JError::raiseError(500, implode('<br />', $errors));
            return false;
        }

        // Assign the Data
        $this->form = $form;
		$this->script = $script;
        
        // Set the toolbar
        $this->addToolBar();
 
        // Display the template
        parent::display($tpl);
 
        // Set the document
        $this->setDocument();
    }
 
    /**
     * Setting the toolbar
     */
    protected function addToolBar() 
    {
        JRequest::setVar('hidemainmenu', true);
        
		// Set toolbar items for the page
        JToolBarHelper::title( JText::_('COM_EWEATHER_ADMIN_TITLE') . ' ' . JText::_('COM_EWEATHER_ADMIN_CONFIG_TITLE'), 'eweather_config' );
		$bar = JToolBar::getInstance('toolbar');
		$bar->appendButton( 'eWeather', 'save', JTEXT::_('JTOOLBAR_SAVE'), 'config_save', false );
		$bar->appendButton( 'eWeather', 'apply', JTEXT::_('JTOOLBAR_APPLY'), 'config_apply', false );
		$bar->appendButton( 'eWeather', 'restore', JText::_('COM_EWEATHER_ADMIN_CONFIG_RESET_BUTTON'), 'config_reset', false );
		$bar->appendButton( 'eWeather', 'cancel', JTEXT::_('JTOOLBAR_CLOSE'), 'config_cancel', false );
    }

    /**
     * Method to set up the document properties
     *
     * @return void
     */
    protected function setDocument() 
    {
    	// set the page title
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_EWEATHER_ADMIN_TITLE') . ' :: ' .JText::_('COM_EWEATHER_ADMIN_CONFIG_TITLE'));

		// add our stylesheet
		JHTML::stylesheet( COM_EWEATHER_ADMIN_CSS_URL.'eweather.admin.css' );

		// add the verification scripts
        $document->addScript(JURI::root() . $this->script);
        $document->addScript(JURI::root() . COM_EWEATHER_ADMIN_VIEWS_URL.'config/submit.js');
        JText::script('COM_EWEATHER_ADMIN_CONFIG_ERROR_PARAMETER');
    }
	
}
