<?php
/**
 * This file contains the Info view definition
 *  for the backend of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>

<form action="index.php" method="post" name="adminForm" id="adminForm">
	<table border="0" class="adminform">
		<tr>
			<td>
				<div style="text-align:left;" >
					<h3>eWeather Component</h3>
					<h4><?php echo $this->version; ?></h4>

					A component that displays XML weather feed information from www.weather.com.
					<br /><br />
					Demo:
					<a href="http://robertjlavey.com/index.php?option=com_eweather" target="_blank">
						http://robertjlavey.com/index.php?option=com_eweather
					</a>
					<br/><br/>
					
					Features include:
					<ul>
						<li>eWeather displays weather information from a XML Feed provided by weather.com</li>
						<li>Users can set their own preferred city (User Profiles)</li>
						<li>Selectable icon styles</li>
						<li>Language Support</li>
						<li>Proxy Support with Proxy Authentication</li>
					</ul>
					<br/>
						
					eWeather Component has been released under
					<a href="http://www.gnu.org/licenses/gpl.txt">GNU/GPL</a>.<br/><br/>
					<strong>Note:</strong>&nbsp;This package has only been tested under Joomla! 1.5.x

					<br/><br />
					<h4>History - Known bugs and limitations (most important ones)</h4>
					Version 1.5.0.0:<br />
					<ul>
						<li>Migrated to Joomla! 1.6.x/1.7.x</li>
					</ul>
					Version 1.4.0:<br />
					<ul>
						<li>Converted to Model View Controller (MVC) architecture.</li>
						<li>Refactored region/country/city selection functionality:
							<ul>
								<li>easier to add/remove entire regions or countries</li>
								<li>search function and filtering on region/country</li> 
							</ul>
						</li>
						<li>Added translations for current conditions text and forecast text.</li>
						<li>Added translations for moon phase text.</li>
					</ul>
					Version 1.3.0:<br />
					<ul>
						<li>Migrated to Joomla! 1.5.x</li>
					</ul>
					Version 1.2.0:<br />
					<ul>
						<li>Some reported issues fix</li>
						<li>Dutch language supported</li>
					</ul>
					<br />
					Version 1.1.0:<br />
					<ul>
						<li>Layout of actual weather data changed, now it can be displayed in smaller templates</li>
						<li>Sorting of region names in location dialog implemented</li>
						<li>Sorting of country names in location dialog implemented</li>
						<li>Sorting of city names in location dialog implemented</li>
					</ul>
					<br />
					Version 1.0.6:<br />
					<ul>
						<li>Default configuration  of version 1.0.5 fixed</li>
						<li>some location data files fixed</li>
					</ul>
					<br />
					Version 1.0.5:<br />
					<ul>
						<li>Bugfixing of version 1.0.4 Beta</li>
						<li>Proxy functionality implemented</li>
						<li>Proxy authentication functionality implemented</li>
					</ul>
					<br />
					Version 1.0.4 Beta:<br />
					<ul>
						<li>Bugfixing of version 1.0.3 Beta</li>
						<li>Language file for hebrew added from Benny Davidovich</li>
					</ul>
					<br />
					Version 1.0.3 Beta:<br />
					<ul>
						<li>Bugfixing of version 1.0.2 Beta</li>
						<li>Location files and component XML definition fixed.</li>
					</ul>
					<br />
					Version 1.0.2 Beta:<br />
					<ul>
						<li>Bugfixing of version 1.0.1 Beta</li>
						<li>New location files provided</li>
					</ul>
					<br />
					Version 1.0.1 Beta:<br />
					<ul>
						<li>Initial Public Release</li>
						<li>Redirection after saving user profile to eWeather component fixed</li>
						<li>Display default location when user hasn't profile yet fixed</li>
					</ul>
					<br />

					<hr size="1" />
					<div align="center">
						<a href="http://www.robertjlavey.com/" target="_blank">
							http://www.robertjlavey.com/
						</a>
					</div>
				</div>
			</td>
		</tr>
	</table>
	<input type="hidden" name="option" value="com_eweather" />
	<input type="hidden" name="task" value="info_show" />
</form>
