<?php
/**
 * This file defines a class to abstract eWeather's
 *  menu parameters for the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );

JLoader::register('eWeatherReadOnlyPropertyContainer', COM_EWEATHER_CLASSES_PATH.DS.'eweatherreadonlypropertycontainer.php' );


class eWeatherMenuParams extends eWeatherReadOnlyPropertyContainer
{
	public function __construct($cfg)
	{
		// get the eWeather menu
		if (isset($cfg->menuType))
		{
			$db = JFactory::getDBO();
			$query = $db->getQuery(true);
			$query->select('id,params');
			$query->from('#__menu');
			$query->where("menutype='".$cfg->menuType."'");
			$query->where("link LIKE '%option=com_eweather%'");
			$db->setQuery($query);
			$menu = $db->loadObject();
		}
		
		// save the menu id and params
		if (isset($menu))
		{
			// convert the JSON string to an array
        	$params = new JRegistry();
        	$params->loadJSON($menu->params);
			$this->data = $params->toArray();

			$this->menuId = $menu->id;
		}
	}
}
