<?php
/**
 * This file defines a class to abstract The Weather Channel's
 *  daily forecasts for the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial version by Bob Lavey
 *
 * @package eWeather
 * @subpackage classes
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */
/* ensure this file is being called by Joomla! */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

// setup paths
require_once( JPATH_SITE.DS.'components'.DS.'com_eweather'.DS.'helpers'.DS.'defines.php' );
require_once( COM_EWEATHER_HELPERS_PATH.DS.'translation.helpers.php' );

JLoader::register('eWeatherConfiguration', COM_EWEATHER_CLASSES_PATH.DS.'eweatherconfiguration.php' );


class TWCDailyForecast extends JObject
{
    public $day_num = null;
    public $day_weekday = null;
    public $day_date = null;
    public $day_temp_max = null;
    public $day_temp_min = null;
    public $day_sunrise = null;
    public $day_sunset = null;
	// Day Part
    public $day_d_icon = null;
    public $day_d_text = null;
    public $day_d_windspeed = null;
    public $day_d_windgust = null;
    public $day_d_winddirection = null;
    public $day_d_windtext = null;
    public $day_d_precipitation = null;
    public $day_d_windtextd = null;
    public $day_d_humidity = null;
	// Night Part
    public $day_n_icon = null;
    public $day_n_text = null;
    public $day_n_windspeed = null;
    public $day_n_windgust = null;
    public $day_n_winddirection = null;
    public $day_n_windtext = null;
    public $day_n_precipitation = null;
    public $day_n_windtextd = null;
    public $day_n_humidity = null;

	public function loadXMLNode($node)
	{
		$cfg = new eWeatherConfiguration();
		
		$this->day_num = $node->getAttribute('d');
		$this->day_weekday = $node->getAttribute('t');
		$this->day_date = $node->getAttribute('dt');

    	foreach ($node->childNodes as $childNode)
		{
			if ($childNode->nodeName == "hi") $this->day_temp_max = $childNode->firstChild->nodeValue;
			elseif ($childNode->nodeName == "low") $this->day_temp_min = $childNode->firstChild->nodeValue;
			elseif ($childNode->nodeName == "sunr")
			{
				$this->day_sunrise = JHTML::_('date', $childNode->firstChild->nodeValue, $cfg->timeFormat, null);
			}
			elseif ($childNode->nodeName == "suns")
			{
				$this->day_sunset = JHTML::_('date', $childNode->firstChild->nodeValue, $cfg->timeFormat, null);
			}
			elseif ($childNode->nodeName == "part")
			{
				$flag = $childNode->getAttribute('p');
				foreach ($childNode->childNodes as $grandchildNode)
				{
					if ($flag == "d")
					{
						if ($grandchildNode->nodeName == "icon") $this->day_d_icon = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "t") $this->day_d_text = translatePhrase($grandchildNode->firstChild->nodeValue);
						elseif ($grandchildNode->nodeName == "bt") $this->day_d_windtextd = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "ppcp") $this->day_d_precipitation = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "hmid") $this->day_d_humidity = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "wind")
						{
    						foreach ($grandchildNode->childNodes as $greatGrandchildNode)
							{
								if ($greatGrandchildNode->nodeName == "s") $this->day_d_windspeed = $greatGrandchildNode->firstChild->nodeValue;
								elseif ($greatGrandchildNode->nodeName == "gust") $this->day_d_windgust = $greatGrandchildNode->firstChild->nodeValue;
								elseif ($greatGrandchildNode->nodeName == "d") $this->day_d_winddirection = $greatGrandchildNode->firstChild->nodeValue;
								elseif ($greatGrandchildNode->nodeName == "t") $this->day_d_windtext = $greatGrandchildNode->firstChild->nodeValue;
							}
						}
					}
					else
					{
						if ($grandchildNode->nodeName == "icon") $this->day_n_icon = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "t") $this->day_n_text = translatePhrase($grandchildNode->firstChild->nodeValue);
						elseif ($grandchildNode->nodeName == "bt") $this->day_n_windtextd = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "ppcp") $this->day_n_precipitation = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "hmid") $this->day_n_humidity = $grandchildNode->firstChild->nodeValue;
						elseif ($grandchildNode->nodeName == "wind")
						{
    						foreach ($grandchildNode->childNodes as $greatGrandchildNode)
							{
								if ($greatGrandchildNode->nodeName == "s") $this->day_n_windspeed = $greatGrandchildNode->firstChild->nodeValue;
								elseif ($greatGrandchildNode->nodeName == "gust") $this->day_n_windgust = $greatGrandchildNode->firstChild->nodeValue;
								elseif ($greatGrandchildNode->nodeName == "d") $this->day_n_winddirection = $greatGrandchildNode->firstChild->nodeValue;
								elseif ($greatGrandchildNode->nodeName == "t") $this->day_n_windtext = $greatGrandchildNode->firstChild->nodeValue;
							}
						}
					}
				}
			}
		}
  	}
	
	public function loadStdClassObject($obj)
	{
        $this->day_num = $obj->day_num;
        $this->day_weekday = $obj->day_weekday;
        $this->day_date = $obj->day_date;
        $this->day_temp_max =$obj->day_temp_max;
        $this->day_temp_min =$obj->day_temp_min;
        $this->day_sunrise =$obj->day_sunrise;
        $this->day_sunset =$obj->day_sunset;
        $this->day_d_icon =$obj->day_d_icon;
        $this->day_d_text =$obj->day_d_text;
        $this->day_d_windspeed =$obj->day_d_windspeed;
        $this->day_d_windgust =$obj->day_d_windgust;
        $this->day_d_winddirection =$obj->day_d_winddirection;
        $this->day_d_windtext =$obj->day_d_windtext;
        $this->day_d_precipitation =$obj->day_d_precipitation;
        $this->day_d_windtextd =$obj->day_d_windtextd;
        $this->day_d_humidity =$obj->day_d_humidity;
        $this->day_n_icon =$obj->day_n_icon;
        $this->day_n_text =$obj->day_n_text;
        $this->day_n_windspeed =$obj->day_n_windspeed;
        $this->day_n_windgust =$obj->day_n_windgust;
        $this->day_n_winddirection =$obj->day_n_winddirection;
        $this->day_n_windtext =$obj->day_n_windtext;
        $this->day_n_precipitation =$obj->day_n_precipitation;
        $this->day_n_windtextd =$obj->day_n_windtextd;
        $this->day_n_humidity =$obj->day_n_humidity;
	}
}
