<?php
/**
 * This file contains tranlations helpers for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage Admin eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

function translatePhrase( $phrase, $separator=' ' )
{
	$phraseArray = explode($separator, $phrase);
	$translatedArray = array(count($phraseArray));
	
	for ($i = 0; $i < count($phraseArray); ++$i)
	{
		switch(strtoupper($phraseArray[$i]))
		{
			// moon phase translations
			case 'CRESCENT':
				$translatedPhrase = JText::_('COM_EWEATHER_CRESCENT');
				break;
				
			case 'FIRST':
				$translatedPhrase = JText::_('COM_EWEATHER_FIRST');
				break;
				
			case 'FULL':
				$translatedPhrase = JText::_('COM_EWEATHER_FULL');
				break;
				
			case 'GIBBOUS':
				$translatedPhrase = JText::_('COM_EWEATHER_GIBBOUS');
				break;
				
			case 'LAST':
				$translatedPhrase = JText::_('COM_EWEATHER_LAST');
				break;
				
			case 'NEW':
				$translatedPhrase = JText::_('COM_EWEATHER_NEW');
				break;
				
			case 'QUARTER':
				$translatedPhrase = JText::_('COM_EWEATHER_QUARTER');
				break;
				
			case 'WANING':
				$translatedPhrase = JText::_('COM_EWEATHER_WANING');
				break;
				
			case 'WAXING':
				$translatedPhrase = JText::_('COM_EWEATHER_WAXING');
				break;
			
			// weather description translations
			case 'AM':
				$translatedPhrase = JText::_('COM_EWEATHER_AM');
				break;
				
			case 'BLOWING':
				$translatedPhrase = JText::_('COM_EWEATHER_BLOWING');
				break;
				
			case 'CLEAR':
				$translatedPhrase = JText::_('COM_EWEATHER_CLEAR');
				break;
				
			case 'CLEARING':
				$translatedPhrase = JText::_('COM_EWEATHER_CLEARING');
				break;
				
			case 'CLOUDS':
				$translatedPhrase = JText::_('COM_EWEATHER_CLOUDS');
				break;
				
			case 'CLOUDY':
				$translatedPhrase = JText::_('COM_EWEATHER_CLOUDY');
				break;
				
			case 'DRIZZLE':
				$translatedPhrase = JText::_('COM_EWEATHER_DRIZZLE');
				break;
				
			case 'DUST':
				$translatedPhrase = JText::_('COM_EWEATHER_DUST');
				break;
				
			case 'EARLY':
				$translatedPhrase = JText::_('COM_EWEATHER_EARLY');
				break;
				
			case 'FAIR':
				$translatedPhrase = JText::_('COM_EWEATHER_FAIR');
				break;
				
			case 'FEW':
				$translatedPhrase = JText::_('COM_EWEATHER_FEW');
				break;
				
			case 'FLURRIES':
				$translatedPhrase = JText::_('COM_EWEATHER_FLURRIES');
				break;
				
			case 'FOG':
				$translatedPhrase = JText::_('COM_EWEATHER_FOG');
				break;
				
			case 'FOGGY':
				$translatedPhrase = JText::_('COM_EWEATHER_FOGGY');
				break;
				
			case 'FREEZING':
				$translatedPhrase = JText::_('COM_EWEATHER_FREEZING');
				break;
				
			case 'ISOLATED':
				$translatedPhrase = JText::_('COM_EWEATHER_ISOLATED');
				break;
				
			case 'LATE':
				$translatedPhrase = JText::_('COM_EWEATHER_LATE');
				break;
				
			case 'LIGHT':
				$translatedPhrase = JText::_('COM_EWEATHER_LIGHT');
				break;
				
			case 'MIX':
				$translatedPhrase = JText::_('COM_EWEATHER_MIX');
				break;
				
			case 'MOSTLY':
				$translatedPhrase = JText::_('COM_EWEATHER_MOSTLY');
				break;
				
			case 'PARTLY':
				$translatedPhrase = JText::_('COM_EWEATHER_PARTLY');
				break;
				
			case 'PM':
				$translatedPhrase = JText::_('COM_EWEATHER_PM');
				break;
				
			case 'RAIN':
				$translatedPhrase = JText::_('COM_EWEATHER_RAIN');
				break;
				
			case 'SAND':
				$translatedPhrase = JText::_('COM_EWEATHER_SAND');
				break;
				
			case 'SCATTERED':
				$translatedPhrase = JText::_('COM_EWEATHER_SCATTERED');
				break;
				
			case 'SHOWER':
				$translatedPhrase = JText::_('COM_EWEATHER_SHOWER');
				break;
				
			case 'SHOWERS':
				$translatedPhrase = JText::_('COM_EWEATHER_SHOWERS');
				break;
				
			case 'SLEET':
				$translatedPhrase = JText::_('COM_EWEATHER_SLEET');
				break;
				
			case 'SNOW':
				$translatedPhrase = JText::_('COM_EWEATHER_SNOW');
				break;
				
			case 'SUN':
				$translatedPhrase = JText::_('COM_EWEATHER_SUN');
				break;
				
			case 'SUNNY':
				$translatedPhrase = JText::_('COM_EWEATHER_SUNNY');
				break;
				
			case 'T-STORM':
				$translatedPhrase = JText::_('COM_EWEATHER_TSTORM');
				break;
				
			case 'T-STORMS':
				$translatedPhrase = JText::_('COM_EWEATHER_TSTORMS');
				break;
				
			case 'T-SHOWER':
				$translatedPhrase = JText::_('COM_EWEATHER_TSHOWER');
				break;
				
			case 'T-SHOWERS':
				$translatedPhrase = JText::_('COM_EWEATHER_TSHOWERS');
				break;
				
			case 'THUNDER':
				$translatedPhrase = JText::_('COM_EWEATHER_THUNDER');
				break;
				
			case 'TO':
				$translatedPhrase = JText::_('COM_EWEATHER_TO');
				break;
				
			case 'WIND':
				$translatedPhrase = JText::_('COM_EWEATHER_WIND');
				break;
				
			case 'WINDY':
				$translatedPhrase = JText::_('COM_EWEATHER_WINDY');
				break;
				
			case 'WINTRY':
				$translatedPhrase = JText::_('COM_EWEATHER_WINTRY');
				break;
			
			default:
				$translatedPhrase = $phraseArray[$i];
				break;
		}
		
		$translatedArray[$i] = $translatedPhrase;
	}
	
	return implode($separator, $translatedArray);
}
