<?php
/**
 * This file contains the routines that handle SEF
 * routing for the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * aangepast door Mart Dirks<br/>
 * converted to Joomla! 1.5.x by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright Copyright (c) 2000 - 2006 MamboBaer.de (Harald Baer),
 *            2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

/**
 * Builds route for eWeather
 * 
 * Possible URLs:
 * /component/eweather/weather_show
 * /component/eweather/profile_show
 * /component/eweather/weather_show/locid
 * /component/eweather/weather_show/detail/locid
 * 
 * @access public
 * @param array Query associative array
 * @return array SEF URI segments
 */
function eWeatherBuildRoute(&$query)
{
	$segments = array();

	if (isset($query['task']))
	{
		$segments[] = $query['task'];
		unset($query['task']);
	}	
	
	if (isset($query['detail']))
	{
		$segments[] = $query['detail'];
		unset($query['detail']);
	}
	
	if (isset($query['locid']))
	{
		$segments[] = $query['locid'];
		unset($query['locid']);
	}

	return $segments;
}

/**
 * Decodes SEF URI segments for eWeather
 * 
 * Possible URLs:
 * /component/eweather/weather_show
 * /component/eweather/profile_show
 * /component/eweather/weather_show/locid
 * /component/eweather/weather_show/detail/locid
 *
 * @access public
 * @param array SEF URI segments array
 * @return array Query associative array
 */
function eWeatherParseRoute($segments)
{
	$query = array();
	$count = count($segments);
	
	if (isset($segments[0]))
	{
		$query['task'] = $segments[0];
	}
	
	if (2 == $count)
	{
		$query['locid'] = $segments[1];
	}
	else if (3 == $count)
	{
		$query['detail'] = $segments[1];
		$query['locid'] = $segments[2];
	}

	return $query;
}
?>