<?php
/**
 * This file contains the template for the 'select city' tab
 *  of the profiles view in the front-end of the eWeather component.
 *
 * This file is part of eWeather.
 *
 *   eWeather is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   eWeather is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with eWeather.  If not, see <a href="http://www.gnu.org/licenses/">
 *   http://www.gnu.org/licenses/</a>.
 *
 * <b>Modifications:</b><br/>
 * Initial revision by Bob Lavey
 *
 * @package eWeather
 * @subpackage eWeather
 * @copyright 2009 - 2011 Bob Lavey<br/>
 * @license http://www.gnu.org/licenses/gpl.txt GNU/GPL
 */

/* ensure this file is being called by Joomla! */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');
?>

<table id="WeatherUserLocationFilters" >
	<tr>
		<td valign="top">
			<?php echo JText::_('JSEARCH_FILTER'); ?>: 
		</td>
		<td nowrap="nowrap">
			<?php $userDefaultLocationFieldSet = $this->form->getFieldset('UserDefaultLocation'); echo $userDefaultLocationFieldSet['jform_search']->input; ?>
			<button id="goButton" onclick="document.adminForm.submit();">
				<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>
			</button>
			<button id="resetButton" onclick="document.getElementById('jform_search').value='';
					document.getElementById('jform_region').value='';
					document.getElementById('jform_country').value='';
					document.adminForm.submit();">
				<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>
			</button>
			<div>
				<?php echo $userDefaultLocationFieldSet['jform_region']->input; ?>
			</div>
			<div>
				<?php echo $userDefaultLocationFieldSet['jform_country']->input; ?>
				<?php echo $userDefaultLocationFieldSet['jform_city']->input; ?>
				<?php echo $userDefaultLocationFieldSet['jform_locationId']->input; ?>
			</div>
		</td>
		<td width=100%" align="center">
			<span style="font-weight: bold;" >
				<?php echo JText::_('COM_EWEATHER_CURRENT_SELECTION'); ?>
			</span>
			<br/>
			<?php echo JText::_($this->locData['region']); ?>
			<br/>
			<?php echo JText::_($this->locData['country']); ?>
			<br/>
			<?php echo JText::_($this->locData['city']); ?>
		</td>
	</tr>
</table>

<table id="WeatherUserLocationList" >
	<thead>
		<tr>
			<th width="20"></th>
			<th width="10%"><?php echo JText::_('COM_EWEATHER_SELECTED'); ?></th>
			<th width="25%"><?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_REGION_HEADING'); ?></th>
			<th width="25%"><?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_COUNTRY_HEADING'); ?></th>
			<th width="30%"><?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_CITY_HEADING'); ?></th>
			<th width="10%"><?php echo JText::_('COM_EWEATHER_ADMIN_LOCATION_LOCATION_ID_HEADING'); ?></th>
		</tr>
	</thead>
<?php
	$k = 0;
	for ($i=0, $n=count( $this->locRows ); $i < $n; $i++)
	{
		$row = $this->locRows[$i];
		$checked = JHTMLRadioGrid::id($i, $row->id );
?>
	<tr class="<?php echo "row$k"; ?>">
		<td><?php echo $checked; ?></td>
		<td align="center">
<?php
		if ($this->locData['locId'] == $row->loc_id)
		{
?>
			<img src="media/com_eweather/images/menu/icon-16-default.png" alt="*" />
<?php
		} 
?>
		</td>
		<td><?php echo JText::_($row->region); ?></td>
		<td><?php echo JText::_($row->country); ?></td>
		<td><?php echo JText::_($row->city); ?></td>
		<td><?php echo $row->loc_id; ?></td>
	</tr>
<?php
	$k = 1 - $k;
	}
?>

	<tfoot>
		<tr>
			<td colspan="6">
<?php
				echo $this->pagination->getListFooter();
?>
			</td>
		</tr>
	</tfoot>

</table>
